ON:
VBL_INTERRUP: equ $70
HBL_INTERRUP: equ $120
TimerAVectOr: Equ $134

PaletteRegStart:equ $ff8240
	
	Move.w	sr,D1
	Cmp.w	#$fff,D1
	Bhi.s	AreInSupervisorMode
 	Bsr		SetSupervisorMode
AreInSupervisorMode:

;-------------------------------------------------
;	Get	Old Dta Addr
;-------------------------------------------------
	Move.w	#$2f,-(sp)
	Trap	#1
	Addq.l	#2,sp
	Move.l	D0,OldDta

;-------------------------------------------------
;	Set Dta
;-------------------------------------------------
	Pea		Dta			; Init Dta
	Move.w	#$1a,-(sp)
	Trap	#1
	Addq.l	#6,sp

	Move.b	$484,OldKeyClickStatus	;Gemmer Key Click StaTstus
	Move.b	#14,$484	;Key Click Off

;***********************************************
;***	Call Set Screen resolutions
;***********************************************
	Bsr		Save_all_colOrs
	Bsr		SetScreenResolutions

	Move.l	VBL_INTERRUP,Old_raster_interup_VBL  ;Saver VBL interup
;	Move.l	HBL_INTERRUP,Old_raster_interup_HBL ;Saver HBL Interup
	Move.l	TimerAVectOr,OldTimerAAddr

	Move.l	#VBL_Raster,VBL_INTERRUP ;internalize VBL interrupt
;	Move.l	#HBL_Raster,HBL_INTERRUP ;internalize HBL interrupt
	Move.l	#TimerA_YmPlayingRoutine,TimerAVectOr;

	Move.b	$fffA07,Old2
	Move.b	$fffA09,Old3

	Move.b	#0,$fffA07
	Move.b	#0,$fffA09


; Mfp 2457600

	Move.b	#%0101,$FFFA19
	Move.b	#153,$FFFA1F

	Move.w	#13,-(sp)
	Move.w	#27,-(sp)			;Enable Interrup 13
	Trap	#14
	Addq.l	#4,sp
	Move.b 	#$12,$fffffc02.w	;disable mouse

;***********************************************
;***   Main Loop
;***********************************************
	Bsr		LoadYmtFile	
	Bsr		StartPlaying
		
MainLoop:
	Cmp.b	#3,$fffc02
	Bne.s	DonTstartPlaying
	Bsr		StartPlaying
DonTstartPlaying:
	Cmp.b	#4,$fffc02
	Bne.s	DonTstopPlaying
	Move.b	#0,PlayMode
	Bsr		SilenceSounDchip
DonTstopPlaying:

	Cmp.b	#2,$fffc02
	Bne.s	MainLoop

;***********************************************
;***   Main Loop Ends
;***********************************************
ExitProgram:
	Bsr		SilenceSounDchip

	Move.w	#13,-(sp)
	Move.w	#26,-(sp) 	;Disable Interrup 13
	Trap	#14
	Addq.l	#4,sp

	Move.b	Old2,$fffA07
	Move.b	Old3,$fffA09


	Move.l	Old_raster_interup_VBL,VBL_INTERRUP
;	Move.l	Old_raster_interup_HBL,HBL_INTERRUP
	Move.l	OldTimerAAddr,TimerAVectOr

	Bsr		RestorePalette
	Bsr		RestoreOldScreenResolutions

	Move.b	OldKeyClickStatus(PC),$484 	;RestOre Gemmer Key Click StaTstus
	Move.b 	#8,$fffffc02.w  ;enable mouse

;-------------------------------------------------
;	RestOre Old Dta
;-------------------------------------------------
	Move.l	OldDta,-(sp) ; Init Dta
	Move.w	#$1a,-(sp)
	Trap	#1
	Addq.l	#6,sp
;-------------------------------------------------
	Move.w	sr,D1
	Cmp.w	#$1000,D1
	Bmi.s	IsNotSupervisOrMode
 	Bsr		TakeOutOfSupervisOrMode
IsNotSupervisOrMode:

;***********************************************_
;***   Terminate Program
;***********************************************
	Clr.w	-(sp)
	Trap	#1
	Rts
;***********************************************_
;***   Main Code Ends : Subs Rutines StaRts
;***********************************************
StartPlaying:
	Move.l	ScoreStartAddr(Pc),D0
	Move.l	D0,ScorePointer 
	Clr.l	ScoreCounter 
	Move.b	#1,PlayMode
	Rts

SilenceSounDchip:
	Move.b	#7,$ffff8800.W
	Move.b	#%11111111,$ffff8802.W
	Move.b	#8,$ffff8800.W
	Move.b	#0,$ffff8802.W
	Move.b	#9,$ffff8800.W
	Move.b	#0,$ffff8802.W
	Move.b	#10,$ffff8800.W
	Move.b	#0,$ffff8802.W
	Rts

;***********************************************
;	Loader Data
;***********************************************
LoAddata:
	Move.l	D7,-(sp)

	Move.w	#0,-(sp)
	Move.l	D7,-(sp)
	Move.w	#$4e,-(sp)
	Trap	#1
	Addq.l	#8,sp
	Move.l	(sp)+,D7
		

	Move.w	#2,-(sp)
	Move.l	D7,-(sp)	 ; Pointer to Filename
	Move.w	#$3d,-(sp) 
	Trap	#1
	Addq.l	#8,sp
	Move.w	D0,fhAndle

 ;   Tst.l	D0
	bpl.s	er_ok
	Move.w	#1,Load_erRor
	Bra.s	er_ok_1
er_ok:
	

	Move.l	D6,-(sp)                 ;Pointer to wram

	Move.l	Dta+26(pc),D1
	Move.l	D1,-(sp)
	Move.w	D0,-(sp)
	Move.w	#$3f,-(sp)
	Trap	#1
	Add.l	#12,sp
	Tst.l	D0
	bpl.s	er_ok_1
	Move.w	#1,Load_erRor

er_ok_1:

	Move.w	fhAndle,-(sp)
	Move.w	#$3e,-(sp)
	Trap	#1
	Addq.l	#4,sp

	Rts


;***********************************************_
;***   Saves Palette
;***********************************************
Save_all_colOrs:
	Lea 	Palette_stOre(Pc),A0
	Lea 	PaletteRegStart,A1

	Moveq	#15,D1
PaletteSaveLoop:
	Move.w	(A1)+,(A0)+
	Dbra	D1,PaletteSaveLoop
	Rts

;***********************************************_
;***   RestOre Palette
;***********************************************
RestorePalette:
	Lea 	Palette_stOre(PC),A0
	Lea 	PaletteRegStart,A1

	Moveq	#15,D1
PaletteRestOreLoop:
	Move.w	(A0)+,(A1)+
	Dbra	D1,PaletteRestOreLoop
	Rts

;***********************************************_
;***   Set the Screen resolutions
;***********************************************
SetScreenResolutions:

	Move.w	#2,-(sp)
	Trap	#14
	Move.l	D0,Old_physadr
	Addq.l	#2,sp
	
	Move.w	#3,-(sp)
	Trap	#14
	Move.l	D0,Old_logbase
	Addq.l	#2,sp

	Move.w	#4,-(sp)
	Trap	#14
	Move.w	D0,Old_screen_res
	Addq.l	#2,sp


	Move.w	program_Res,-(sp)
	Move.l	Physadr,-(sp)
	Move.l	Logbase,-(sp)
	Move	#5,-(sp)
	Trap	#14
	Add.l	#12,sp
	Bra		WaitForVsync

;***********************************************_
;***   Restore Screen resolutions
;***********************************************
RestoreOldScreenResolutions:
	Move.w	Old_screen_res,-(sp)
	Move.l	Old_physadr,-(sp)
	Move.l	Old_logbase,-(sp)
	Move	#5,-(sp)
	Trap	#14
	Add.l	#12,sp
	Bra		WaitForVsync

;***********************************************_
;***   VBL Raster Routine
;***********************************************
VBL_Raster:
	Move.w	 ErRorColOr,$FFFF8240.W
	Rte
;***********************************************
;	Load Ymt
;***********************************************
LoadYmtFile:
	Move.l	#Score,D6 	 

	Move.l	#filename1,D7    ; loader filename Addr 	
	Bsr		LoAddata
	Tst.w	Load_erRor
	Bne		ExitProgram
	Moveq	#0,D0
	Move.l	D0,ScoreStartAddr 

	Lea		Score(Pc),A0
	Move.b	4(A0),D0	
	Move.b	D0,ComputerType
	Lsr.b	#4,D0
	Move.b	D0,SoundSpeed 
	Move.b	5(A0),D0	
	Move.b	D0,PlayHz 

	Clr.b	 NewFOrmat 
	Cmp.b	#'F',(A0)
	Bne.s	NotNewFOrmat
	Cmp.b	#'E',1(A0)
	Bne.s	NotNewFOrmat
	Move.b	#1,NewFOrmat 
NotNewFOrmat:
	Cmp.b	#'A',(A0)
	Bne.s	NotOldFOrmat
	Cmp.b	#'B',1(A0)
	Bne.s	NotOldFOrmat
	Bra.s	IniVariablesOldWay
NotOldFOrmat:
	Bra.s	IniVariablesNewWay
ExitIni:
;	Tst.l	ScoreStartAddr 
;	Bne.s	DontNeedToIniName
	Bsr		IniNames
;DontNeedToIniName:

	Bsr 	SetTimer
	Tst.b	NewFOrmat 
	Bne.s	DontCLearScore
	Bsr		CLearScore
DontCLearScore:
	Bsr		IniLoopPoints
	Rts

IniVariablesOldWay:
	Move.l	6(A0),D0
	Ror.w	#8,D0
	Swap	D0
	Ror.w	#8,D0
	Move.l	D0,TrackLen 

	Move.l	14(A0),D0
	Ror.w	#8,D0
	Swap	D0
	Ror.w	#8,D0
	Move.l	D0,LoopPointer 

	Bra.s	ExitIni
IniVariablesNewWay:
	Move.l	6(A0),D0
	Move.l	D0,TrackLen 

	Move.l	14(A0),D0
	Move.l	D0,LoopPointer 
	Bra.s	ExitIni
;***********************************************
;***   Ini Loop Point
;***********************************************
IniLoopPoints:
	Move.l	LoopPointer(PC),D7
	Bne.s	ThereIsALoopPoint
	Move.l	#0,LoopPointerAddr 
	Rts
ThereIsALoopPoint:
	Subq.l	#1,D7

	Moveq	#15,D0
	Moveq	#0,D1
	Lea		OldchipData(Pc),A1
OldDataCLearLoop:
	Move.b	D1,(A1)+
	Dbra	D0,OldDataCLearLoop

	Lea		OldchipData(Pc),A1
	Move.l 	 ScoreStartAddr(PC),A0
FindDataLoop:
	Move.b	(A0)+,D1
	Move.b	(A0)+,D2	
	Tst.b	D1
	Beq 	FNoDataChangeInthefirst8Reg

FNoData:
	Btst	#0,D1
	Beq.s	FNoDatA0
	Move.b	(A0)+,D0
	Move.b	D0,(A1)
FNoDatA0:	
	Btst	#1,D1
	Beq.s	FNoDatA1
	Move.b	(A0)+,D0
	Move.b	D0,1(A1)
FNoDatA1:	
	Btst	#2,D1
	Beq.s	FNoDatA2
	Move.b	(A0)+,D0
	Move.b	D0,2(A1)
FNoDatA2:	
	Btst	#3,D1
	Beq.s	FNoDatA3
	Move.b	(A0)+,D0
	Move.b	D0,3(A1)
FNoDatA3:	
	Btst	#4,D1
	Beq.s	FNoDatA4
	Move.b	(A0)+,D0
	Move.b	D0,4(A1)
FNoDatA4:	
	Btst	#5,D1
	Beq.s	FNoDatA5
	Move.b	(A0)+,D0
	Move.b	D0,5(A1)
FNoDatA5:	
	Btst	#6,D1
	Beq.s	FNoDatA6
	Move.b	(A0)+,D0
	Move.b	D0,6(A1)
FNoDatA6:	
	Btst	#7,D1
	Beq.s	FNoDatA7
	Move.b	(A0)+,D0
	Move.b	D0,7(A1)
FNoDatA7:
FNoDataChangeInthefirst8Reg:

	Tst.b	D2
	Beq 	FNoDataChangeIntheHigh8Reg

FHNoData:
	Btst	#0,D2
	Beq.s	FHNoDatA0
	Move.b	(A0)+,D0
	Move.b	D0,8(A1)
FHNoDatA0:	
	Btst	#1,D2
	Beq.s	FHNoDatA1
	Move.b	(A0)+,D0
	Move.b	D0,9(A1)
FHNoDatA1:	
	Btst	#2,D2
	Beq.s	FHNoDatA2
	Move.b	(A0)+,D0
	Move.b	D0,10(A1)
FHNoDatA2:	
	Btst	#3,D2
	Beq.s	FHNoDatA3
	Move.b	(A0)+,D0
	Move.b	D0,11(A1)
FHNoDatA3:	
	Btst	#4,D2
	Beq.s	FHNoDatA4
	Move.b	(A0)+,D0
	Move.b	D0,12(A1)
FHNoDatA4:	
	Btst	#5,D2
	Beq.s	FHNoDatA5
	Move.b	(A0)+,D0
	Move.b	D0,13(A1)
FHNoDatA5:	
	Btst	#6,D2
	Beq.s	FHNoDatA6
	Move.b	(A0)+,D0
	Move.b	D0,14(A1)
FHNoDatA6:	
	Btst	#7,D2
	Beq.s	FHNoDatA7
	Move.b	(A0)+,D0
	Move.b	D0,15(A1)
FHNoDatA7:
FNoDataChangeIntheHigh8Reg:

	Dbra	D7,FindDataLoop
	Move.l	A0,LoopPointerAddr 

	Rts

;***********************************************
;***   CLear Register pOrt 14-15 datas Old FOrmat
;*********************************************** tis
CLearScore:
	Move.l	ScoreStartAddr(PC),A0
	Move.l	A0,A1
	Move.l	TrackLen(PC),D7

CLearReg1415Loop:
	Move.l	A0,A2
	Move.b	(A1)+,D1
	Move.b	(A1)+,D2
	Addq.l	#2,A0

	Tst.b	D1
	Beq.s	Test2Datas

	Btst	#0,D1
	Beq.s	PNoCLearReg0
	Move.b	(A1)+,(A0)+
PNoCLearReg0:	
	Btst	#1,D1
	Beq.s	PNoCLearReg1
	Move.b	(A1)+,(A0)+
PNoCLearReg1:	
	Btst	#2,D1
	Beq.s	PNoCLearReg2
	Move.b	(A1)+,(A0)+
PNoCLearReg2:	
	Btst	#3,D1
	Beq.s	PNoCLearReg3
	Move.b	(A1)+,(A0)+
PNoCLearReg3:	
	Btst	#4,D1
	Beq.s	PNoCLearReg4
	Move.b	(A1)+,(A0)+
PNoCLearReg4:	
	Btst	#5,D1
	Beq.s	PNoCLearReg5
	Move.b	(A1)+,(A0)+
PNoCLearReg5:	
	Btst	#6,D1
	Beq.s	PNoCLearReg6
	Move.b	(A1)+,(A0)+
PNoCLearReg6:	
	Btst	#7,D1
	Beq.s	PNoCLearReg7
	Move.b	(A1)+,(A0)+
PNoCLearReg7:	

		
Test2Datas:
	Tst.b	D2
	Beq.s	EndDataTest

	Btst	#0,D2
	Beq.s	PNoCLearReg8
	Move.b	(A1)+,(A0)+
PNoCLearReg8:	
	Btst	#1,D2
	Beq.s	PNoCLearReg9
	Move.b	(A1)+,(A0)+
PNoCLearReg9:	
	Btst	#2,D2
	Beq.s	PNoCLearReg10
	Move.b	(A1)+,(A0)+
PNoCLearReg10:	
	Btst	#3,D2
	Beq.s	PNoCLearReg11
	Move.b	(A1)+,(A0)+
PNoCLearReg11:	
	Btst	#4,D2
	Beq.s	PNoCLearReg12
	Move.b	(A1)+,(A0)+
PNoCLearReg12:	
	Btst	#5,D2
	Beq.s	PNoCLearReg13
	Move.b	(A1)+,(A0)+
PNoCLearReg13:	
	
POrtAB_EndDataTest:
	Btst	#6,D2
	Beq.s	POrtA_NoCLear
	Addq.l	#1,A1
	BClr	#6,D2
POrtA_NoCLear:
	Btst	#7,D2
	Beq.s	POrtB_NoCLear
	Addq.l	#1,A1
	BClr	#7,D2
POrtB_NoCLear:


EndDataTest:
	Move.b	D1,(A2)+
	Move.b	D2,(A2)

	Dbra	D7,CLearReg1415Loop
	Rts



;***********************************************
;***   Caculate And Set Timer
;***********************************************
SetTimer:
	Moveq	#0,D0
	Moveq	#0,D1
	Lea		TimerList(Pc),A0

	Move.b	SoundSpeed(PC),D0
	Bne.s	SoundSpeedAreGreaterThenZerro
	Addq.b	#1,D0
SoundSpeedAreGreaterThenZerro:
	Move.b	PlayHz(PC),D1
	Bne.s	PlayHZAreGreaterThenZerro
	Moveq	#50,D0
PlayHZAreGreaterThenZerro:
	Mulu	D0,D1

	Add.b	D0,D0
	Add.w	D0,A0
	Move.b	(A0)+,D2

	Move.l	#2457600,D0 	; Mfp 2457600
	Divu	D1,D0
	And.l	#$ffff,D0

	Move.b	(A0),D1
	And.w	#$ff,D1	
	Divu	D1,D0
	Move.b	D2,$FFFFFA19.W
	Move.b	D0,$FFFFFA1F.W
	Rts

TimerList:
	Dc.b 	%0111,200	;0	
	Dc.b 	%0111,200	;1	
	Dc.b 	%0110,100	;2	
	Dc.b 	%0110,100	;3	
	Dc.b 	%0100,50 	;4	
	Dc.b 	%0100,50 	;5	
	Dc.b 	%0100,50 	;6	
	Dc.b 	%0100,50 	;6	
;***********************************************
;***   Ini Score,Composer And ConveRter Name
;***********************************************

IniNames:
	Lea		NameList(pc),A1
	Move.l	(A1)+,A2

	Moveq	#3,D0	
	Lea		Score(Pc),A0
	Add.l	#50,A0
NameLoop:
	Tst.b	(A0)
	Bne.s	NoNewName
	Addq.w	#1,A0
	Subq.b	#1,D0
	Ble.s	FoundAllNames
	Move.l	(A1)+,A2
	Bra.s	NameLoop
NoNewName:
	Move.b	(A0)+,(A2)+	
	Bra.s	NameLoop

FoundAllNames:
	Move.l	A0,ScoreStartAddr 
	Rts

;***********************************************
;***   Take Out Of Supervisor Mode
;***********************************************
TakeOutOfSupervisOrMode:
	Move.l	save_stack,-(sp)	;Restore Old Supervisor Mode
	Move.w	#$20,-(sp)			;
	Trap	#1				;
	Addq.l	#6,sp				;
	Rts
;***********************************************
;***   Set Supervisor Mode
;***********************************************
SetSupervisorMode:
	Clr.l	-(sp)
	Move.w	#$20,-(sp)
	Trap	#1
	Add.l	#6,sp
	Move.l	D0,save_stack			
	Rts

;***********************************************
;***   wait fOr vertical blanking
;***********************************************
WaitForVsync:
	Move.w	#37,-(sp)
	Trap	#14
	Addq.l	#2,sp
	Rts

;***********************************************
;***   Timer A Ym-File Playing Routine
;***********************************************
TimerA_YmPlayingRoutine:
	Move.w	#$007,$ffff8240.w
	MoveM.l	D0-D2/A0,-(sp)

	Tst.b	PlayMode 
	Beq		NoPlaying

	Move.l	ScorePointer(PC),A0
	Move.b	(A0)+,D1
	Move.b	(A0)+,D2	
	Tst.b	D1
	Beq 	NoDataChangeInthefirst8Reg

NoData:
	Btst	#0,D1
	Beq.s	NoDatA0
	Move.b	(A0)+,D0
	Move.b	#0,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDatA0:
	Btst	#1,D1
	Beq.s	NoDatA1
	Move.b	(A0)+,D0
	Move.b	#1,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDatA1:
	Btst	#2,D1
	Beq.s	NoDatA2
	Move.b	(A0)+,D0
	Move.b	#2,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDatA2:
	Btst	#3,D1
	Beq.s	NoDatA3
	Move.b	(A0)+,D0
	Move.b	#3,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDatA3:
	Btst	#4,D1
	Beq.s	NoDatA4
	Move.b	(A0)+,D0
	Move.b	#4,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDatA4:
	Btst	#5,D1
	Beq.s	NoDatA5
	Move.b	(A0)+,D0
	Move.b	#5,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDatA5:
	Btst	#6,D1
	Beq.s	NoDatA6
	Move.b	(A0)+,D0
	Move.b	#6,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDatA6:
	Btst	#7,D1
	Beq.s	NoDatA7
	Move.b	(A0)+,D0
	Move.b	#7,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDataChangeInthefirst8Reg:	
NoDatA7:
	Tst.b	D2
	Beq 	NoDataChangeIntheLast5Reg

	Btst	#0,D2
	Beq.s	NoData8
	Move.b	(A0)+,D0
	Move.b	#8,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoData8:
	Btst	#1,D2
	Beq.s	NoData9
	Move.b	(A0)+,D0
	Move.b	#9,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoData9:
	Btst	#2,D2
	Beq.s	NoDatA10
	Move.b	(A0)+,D0
	Move.b	#10,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDatA10:
	Btst	#3,D2
	Beq.s	NoDatA11
	Move.b	(A0)+,D0
	Move.b	#11,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDatA11:
	Btst	#4,D2
	Beq.s	NoDatA12
	Move.b	(A0)+,D0
	Move.b	#12,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDatA12:
	Btst	#5,D2	
	Beq.s	NoDatA13
	Move.b	(A0)+,D0
	Move.b	#13,$ffff8800.w
	Move.b	D0,$ffff8802.w
NoDatA13:
	Btst	#6,D2	
	Beq.s	NoDatA14
	Addq.l	#1,A0
NoDatA14:
	Btst	#7,D2	
	Beq.s	NoDatA15
	Addq.l	#1,A0
NoDatA15:



NoDataChangeIntheLast5Reg:
	Move.l	ScoreCounter(PC),D0
	Addq.l	#1,D0
	Cmp.l	TrackLen(PC),D0
	Blo.s	NotAtTheEnd
	Tst.l	LoopPointer 
	Beq.s	NoLoopPoint
	Move.l	#TimerASetAll16datas,TimerAVectOr;
	Bra.s	NoPlaying;
NoLoopPoint:
	Move.l	ScoreStartAddr(PC),A0
	Moveq	#0,D0
NotAtTheEnd:
	Move.l	D0,ScoreCounter 
	Move.l	A0,ScorePointer 

NoPlaying:

	MoveM.l	(sp)+,D0-D2/A0
	Move.w	ErRorColOr(PC),$FFFF8240.W
	BClr	#5,$FFFFFA0F.w 
	Rte

TimerASetAll16datas:	
	Move.w	#$077,$FFFF8240.W
	MoveM.l	D0-D1/D7/A0,-(sp)

	Move.l	#TimerASetAll16datas,TimerAVectOr;

	Move.l	LoopPointerAddr(PC),A0
	Move.l	A0,ScorePointer 

	Move.l	LoopPointer(PC),D0
	Move.l	D0,ScoreCounter 
	
	Moveq	#15,D7
	Moveq	#0,D1
	Lea		OldchipData(Pc),A0
SetDatas:
	Move.b	(A0)+,D0
	Move.b	D1,$ffff8800.w
	Move.b	D0,$ffff8802.w
	Addq.b	#1,D1
	Dbra	D7,SetDatas

	Move.l	#TimerA_YmPlayingRoutine,TimerAVectOr;
	MoveM.l	(sp)+,D0-D1/D7/A0
	Move.w	ErRorColOr(PC),$FFFF8240.W
	BClr	#5,$FFFFFA0F.w 
	Rte




;***********************************************
;***   Data Variables
;***********************************************
filename1:	Dc.b		'KLATMIX.YMT',0
;filename1:	Dc.b		'QUITES.YMT',0
;filename1:	Dc.b		'RIGHTH.YMT',0

;filename1:	Dc.b		'JIMPOWR2.YMT',0
;filename1:	Dc.b		'3DGALAXY.YMT',0
;filename1:	Dc.b		'DJSERG.YMT',0
;filename1:	Dc.b		'GOldRNR2.YMT',0
;filename1:	Dc.b		'COSMICP1.YMT',0
;filename1:	Dc.b		'LOF.YMT',0
;filename1:	Dc.b		'LOF1.YMT',0
;filename1:	Dc.b		'ISS.YMT',0
;filename1:	Dc.b		'TRANTOr1.YMT',0

OldKeyClickStatus:		Dc.b	0
Old2:			Dc.b	0
Old3:			Dc.b	0

ComputerType:	Dc.b	0
SoundSpeed:		Dc.b	0
PlayHz:			Dc.b	0
PlayMode:		Dc.B	0
NewFOrmat:		Dc.b	0
even
DownCounter:	Dc.w	0

ErRorColOr:		Dc.W	0
Dta:			Dcb.b	64
fhAndle:		Dc.l	0
save_stack:		Dc.l	0
OldDta:		Dc.l	0
Load_erRor:		Dc.w	0
gog:			Dc.w	0

TrackLen:		Dc.l	0
LoopPointerAddr:Dc.l	0
LoopPointer:	Dc.l	0

ScoreStartAddr: Dc.l	0
ScorePointer:	Dc.l	0

ScoreCounter:	Dc.l	0
ScoreLength:	Dc.l	0	
Bibi:			Dc.l	0
bibi1:			Dc.l	0

Old_screen_res:	Dc.w	0
Old_logbase:	Dc.l	0
Old_physadr:	Dc.l	0
	

program_Res:	Dc.w	0
Logbase:		Dc.l	$78000
Physadr:		Dc.l	$78000




NameList:
				Dc.l	ScoreName
				Dc.l	ComposerName
				Dc.l	ConveRterName


Old_raster_interup_VBL:	Dc.l	0
Old_raster_interup_HBL:	Dc.l	0
OldTimerAAddr:	Dc.l	0


Palette_store:
				Dc.w 0,0,0,0,0,0,0,0
				Dc.w 0,0,0,0,0,0,0,0

ScoreName:		Dcb.b	128,0
ComposerName:	Dcb.b	128,0
ConveRterName:	Dcb.b	128,0

OldchipData:	Dcb.b	16,0

Score:
 	

