#include <stdio.h>
#include <stdint.h>

/* Mapping table. This table specifies the target index in the
   output file. */
int map_idx [120] = {
	0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b,
	0x2c, 0x2d, 0x2e, 0x2f, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b,
	0x4c, 0x4d, 0x4e, 0x4f, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b,
	0x6c, 0x6d, 0x6e, 0x6f, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf
};


/* remap colors in a 256 color bitmap */
int main(int argc, char **argv) {
	if(argc<3) {
		fprintf(stderr, "Usage: %s <infile> <outfile>\n", argv[0]);
		return 1;
	}
	FILE *in, *out;
	if((in=fopen(argv[1], "rb"))==NULL) {
		perror("Could not open input file");
		return 1;
	}
	if((out=fopen(argv[2], "wb"))==NULL) {
		perror("Could not open output file");
		return 1;
	}
	while(1) {
		uint8_t c=fgetc(in);
		if(feof(in))break;
/* new palette mapping:
   0-31: fonts, tile stuff
   32-35: 4bit palette 2
   36-47: logo
   48-51: 4bit palette 3
   52-63: logo
   64-67: 4bit palette 4
   68-79: logo
   80-83: 4bit palette 5
   84-95: logo
   96-99: 4bit palette 6
   100-111: logo
   112-115: 4bit palette 7
   116-175: logo
   176-191: sprites (misc overlays, cursor, etc.)
   192-255: sprites (logo gfx overlays)
*/
		if(c < 120) {
			c = map_idx[c];
		} else {
			c = 0;
                }
		fputc(c, out);
	}
	fclose(out);
	fclose(in);
	return 0;
}
