/**
  * ;TRONSCII
  *
 */
.var screenRam = $0400
.var colourRam = $d800

.pc = $0801 "Basic Upstart"
:BasicUpstart($080d)

//; macros and functions only
.import source "lib/Macros.asm"
.import source "lib/Functions.asm"
.import source "lib/VicTools.asm"

//; imports for code/gfx here 
.pc =$0900 "Game"
.import source "lib/PrintDecimal.asm"
.import source "lib/Screen.asm"
.import source "lib/PrintASCII.asm"

.import source "common/Constants.asm"
.import source "common/Tiles.asm"
.import source "common/EventHandler.asm"
.import source "common/Timers.asm"

.import source "game/Game.asm"
.import source "game/Raster.asm"

//.import source "highscore/HighScore.asm"
//.import source "highscore/HighScoreBackground.asm"
//.import source "highscore/Raster.asm"

//.import source "intro/Intro.asm"
//.import source "intro/Events.asm"
//.import source "intro/Raster.asm"
//.import source "intro/Timer.asm"

//.import source "player/PlayerData.asm"
//.import source "player/PlayerIO.asm"

//.import source "title/Title.asm"
//.import source "title/Raster.asm"
//.import source "title/Timer.asm"

.var STATE = GAME// HIGH_SCORE_VIEW
//.eval registerIntroEvents()

.pc =$080d "TRONSCII"

	sei
	cld
	lda #$00 sta $d020 sta $d021
	:turnOffCIA()	
	:setVicBank(BANK_0)	
	:disableROMS(ALL_ROMS)	
	:kill_restore()
	:start()

main: jmp main
state:
.byte STATE

setState: {

}

/** 
 *; Mostly for development purposes.  Set state above to start game at the specificied STATE.
 */
.macro start() {

	.if (STATE == INTRO) {
		//jsr initIntro 
	} 
	.if (STATE == TITLE) {
		//jsr initTitle 
	} 
	.if (STATE == DEMO) {
		//jsr initDemo 
	} 
	.if (STATE == PRE_GAME) {
		//jsr initPreGame 
	} 
	.if (STATE == GAME) {
		jsr initGame
	} 
	.if (STATE == LEVEL_CHANGE) {
		//jsr initLevelChange 
	} 
	.if (STATE == POST_GAME) {
		//jsr initPostGame
	} 
	.if (STATE == HIGH_SCORE_VIEW) {
		jsr initHighScoreView
	} 
	.if (STATE == HIGH_SCORE_ENTER) {
		//jsr initHighScoreEnter
	} 

}
