.var events = Hashtable()
.var eventId = 0

//; addresses to the various parts and concurrent timer events
//; address (2) x concurrent events 8
.var timeAddressLength = 16
timerDataAddresses:
introTimerAddresses: .fill timeAddressLength,0
titleTimerAddresses: .fill timeAddressLength,0
demoTimerAddresses: .fill timeAddressLength,0
hiscoreTimerAddresses: .fill timeAddressLength,0


/**
 *@id unique identifier.  Auto generated 
 *@time time in 50 millionths of second since beginning of timer initialisation 
 *@actionAddress memory address of code subroutine to execute 
 *@callAddress memory address where subroutine is called from.  May be raster or main loop.  Address of calling code must contain :eventCallerHolder() macro
 */
.struct Event {
	id,
	time,
	actionAddress//,
	//callAddress
}


.macro runEvents(state) {
	lda #state
	jsr processEvents
}

processEvents: {
	rts
}


.macro generateEventData(state) {

	.var eventList = events.get(state)
	.eval eventList = sortTimerEvents(eventList)
	
	.var event = null
	.for (var i = 0 ; i < eventList.size();i++) {
		.eval event = eventList.get(i)
		.byte >event.time,<event.time
	}

	.for (var i = 0 ; i < eventList.size();i++) {
		.eval event = eventList.get(i)
		.byte >event.actionAddress,<event.actionAddress
	}
	
}

.function addEvent(state,event) {
	.var eventList = events.get(state)
	.if (isNull(eventList)) {
		.eval eventList = List()
		.eval events.put(state,eventList)
	}
	
	.eval eventId = eventId + 1
	.eval event.id = eventId
	.eval eventList.add(event)
}

.function sortTimerEvents(eventList) {

 	.var sorted = false
   	.var temp
	
	.for (var top = eventList.size() - 1; top > 0 && !sorted; top--) {
	      
	 	.eval sorted = true	
	    .for (var i = 0; i < top; i++) {
	    	.if (eventList.get(i).time > eventList.get(i+1).time) {
	        	.eval sorted = false
	          	.eval temp = eventList.get(i)
	          	.eval eventList.set(i,eventList.get(i+1))
	          	.eval eventList.set(i+1,temp)
	        }
	    }
	}

	.return eventList
}

.function printTimers(eventList) {
	.var event = "Null"
	.for (var i = 0 ; i < eventList.size();i++) {
		.eval event = eventList.get(i)
		.print "" + event.id + ":" + event.time + ":" + event.actionAddress
	}
}