.macro printDecimal(source,location) {
	lda source sta decimalValue
	lda source + 1 sta decimalValue + 1
	lda source + 2 sta decimalValue + 2
	lda source + 3 sta decimalValue + 3

	lda #<location sta $02
	lda #>location sta $03
	
	jsr printDecimalNumber
}

//; prints a 32 bit value to the screen
printDecimalNumber: {
        jsr hex2dec
		ldy #$00
        ldx #9
l1:     lda result,x
        bne l2
        dex             //; skip leading zeros
        bne l1

l2:     lda result,x
        ora #$30
        sta ($02),y
        iny
        dex
        bpl l2
        rts
//; converts 10 digits (32 bit values have max. 10 decimal digits)
hex2dec:
		clc
        ldx #0
l3:     jsr div10
        sta result,x
        inx
        cpx #10
        bne l3
        rts

//; divides a 32 bit value by 10
//; remainder is returned in akku
div10:
        ldy #32         //; 32 bits
        lda #0
        clc
l4:     rol
        cmp #10
        bcc skip
        sbc #10
skip:   rol decimalValue
        rol decimalValue+1
        rol decimalValue+2
        rol decimalValue+3
        dey
        bpl l4
        rts
result:  
.byte 0,0,0,0,0,0,0,0,0,0
}
decimalValue: 
.byte $ff,$ff,$ff,$ff