.var MULTI_COLOUR = 0
.var HIRES = 1
/**
 * Clear the raster interupt, set the next interupt line and memory location to jump to on next interupt.
 * @param line
 * @param location
 */
.macro setRaster(line,location) {

	.var bit8 = %00000000	
	.if (line > $ff) {
		.eval line = line - $ff
		.eval bit8 = %10000000 
	} 
	
	asl $d019

	lda $d011 and #%01111111 ora #bit8 sta $d011
	lda #line sta $d012

	lda #<location sta $fffe
	lda #>location sta $ffff
}

/**
 *; This is how to tell the VICII to generate a raster interrupt
 */
.macro generateRasterInterupts() {
	lda #$01  sta $d01a
	lda #$1b  sta $d011	
}

.macro resetRaster() {
	lda #$ff  
	sta $d019 
}

.macro checkRaster(line) {
	lda #line
	cmp $d012
	bne *-3
}

.macro setBorderColour(colour) {
	lda #colour sta $d020
}

.macro setMultiColour1(colour) {
	lda #colour sta $d022
}
.macro setMultiColour2(colour) {
	lda #colour sta $d023
}
.macro setMultiColour3(colour) {
	lda #colour sta $d024
}

.macro setBackgroundColour(colour) {
	lda #colour sta $d021
}


.var BANK_0 = 0
.var BANK_1 = 1
.var BANK_2 = 2
.var BANK_3 = 3

/**
 * ;Set the memory bank for the vic chip to use
 * ;@param bank number
 * ;bank 0: $0000-$3fff
 * ;bank 1: $4000-$7fff
 * ;bank 2: $8000-$bfff
 * ;bank 3: $c000-$ffff
 */
.macro setVicBank(bank) {

	lda $dd00 and #%11111100
	
	.if (bank == BANK_0) {
		ora #00000011
	}
	.if (bank == BANK_1) {
		ora #00000010
	}
	.if (bank == BANK_2) {
		ora #00000001
	} 
	.if (bank == BANK_3) {
		ora #00000000
	}	
	
	sta $dd00		
}

/**
 *; disable all ROMs
 *; $01=$37 -> Basic Rom visible A000-C000, IO visible at D000-E000, Kernal Rom Visible at E000-FFFF
 *; $01=$36 -> RAM       visible A000-C000, IO visible at D000-E000, Kernal Rom Visible at E000-FFFF
 *; $01=$35 -> RAM       visible A000-C000, IO visible at D000-E000, RAM        Visible at E000-FFFF
 *; $01=$34 -> RAM       visible A000-C000, RAM visible at D000-E000, RAM        Visible at E000-FFFF
 *; $01=$33 -> RAM       visible A000-C000, CHAR ROM   at D000-E000, RAM        Visible at E000-FFFF
 */ 
 .var ALL_ROMS = $35
.macro disableROMS(value) {
	lda #value 
	sta $01 
}


/**
 * ;Turn cia interupts off
 */ 
.macro turnOffCIA() {
	lda #$7f
	sta $dc0d  
	sta $dd0d 
	lda #$00
	sta $dc0e
	sta $dc0f
	sta $dd0e
	sta $dd0f
}

.macro dummyNMI(nmi) {
	lda #<nmi
	sta $fffa
	lda #>nmi
	sta $fffb    //  ; dummy NMI to avoid crashing due to RESTORE
}

.macro kill_restore()	// used to disable RESTORE, use after you stop all nmis
{
	tsx
	lda #<exit
	sta $fffa
	lda #>exit
	sta $fffb
	lda #$00
	sta $dd05
	lda #55
	sta $dd04
	lda #$81
	sta $dd0d
	lda #$19
	sta $dd0e	// oneshot setting, starts timer

inf:	jmp inf
exit:	txs
}

