initGame: {
	ldx #0
	stx $d020
	stx $d021
loop:	lda #$0d
	sta $2800,x
	sta $2900,x
	sta $2a00,x
	sta $2b00,x
	sta $d800,x
	sta $d900,x
	sta $da00,x
	sta $db00,x
	lda #$20
	sta $2400,x
	sta $2500,x
	sta $2600,x
	sta $2700,x
	sta $0400,x
	sta $0500,x
	sta $0600,x
	sta $0700,x
	inx
	bne loop	
	jsr drawviewport
	jsr initGameRaster	
	rts	
}
directionP1: 
.byte 1
lastjoy:
.byte 0
directionP2: 
.byte 1
lastjoy1:
.byte 0
grid:
.byte $5b,$43,$43
.byte $42,$20,$20
.byte $42,$20,$20
gridlo:
.byte <grid, <grid+3, <grid+6
gridhi:
.byte >grid, >grid+3, >grid+6
rastercount:
.byte 0


plotscii: {
	inc rastercount
	lda rastercount
	cmp #1
	beq doit
	cmp #3
	beq dotrail
	cmp #4
	beq lastframe
	rts
dotrail: 	
	jsr arena1
	jsr trail1
	jsr plotplayer
	rts   
lastframe:	lda #0
	sta rastercount
	jsr arena2
	jsr trail2
	jsr plotplayer2
	jsr colrbuffer
	lda doublebuffer
	bne nxframe
	inc doublebuffer
	rts
nxframe: dec doublebuffer
rts

doit:

// JOYSTICK
	lda P1death
	bne !+
	jsr readjoy
!:	lda dx
	bne !+				// has player pressed left or right?
	lda #8				// lastjoy will always have the last joy movement, preventing keybounce, and resets when there is no joy movement
	sta lastjoy
!:	
	cmp #$ff			// pressed left?
	bne next			// no -- I CHANGED THIS FROM BNE TO BEQ TO TRY TO FIX REVERSED CONTROLS
	cmp lastjoy
	bne !+				// if joy not equal to last joy store joy to last joy, else skip
	jmp next1


!:	
	sta lastjoy			
	inc coordpos1		// add a coordinate

	ldx directionP1
	dex
	bpl !+
	ldx #3
!: stx directionP1
	jmp next1
			// 0-3 - 0 is left, 1 is down, 2 is right, 3 is up
next:	
	cmp #1				// Pressed right?
	bne next1			// No - CHANGED TO FIX REVERSED CONTROLS
	cmp lastjoy			// debounce (not sure this is necessary)
	 bne !+
	jmp next1			

!:	
	sta lastjoy 
	inc coordpos1		// add a coordinate
	ldx directionP1
	inx
	cpx #4
	bne !+
	ldx #0
!: stx directionP1
next1:	
ldx coordpos1
		lda directionP1
	sta directiontableP1,x
		lda P2death
	bne !+
	jsr readjoy1
!:	lda dx1
	bne !+				// has player pressed left or right?
	lda #8				// lastjoy will always have the last joy movement, preventing keybounce, and resets when there is no joy movement
	sta lastjoy1
!:	
	cmp #$ff			// pressed left?
	bne next2			// no -- I CHANGED THIS FROM BNE TO BEQ TO TRY TO FIX REVERSED CONTROLS
	cmp lastjoy1
	bne !+				// if joy not equal to last joy store joy to last joy, else skip
	jmp next3


!:	
	sta lastjoy1		
	inc coordpos2		// add a coordinate
 
	ldx directionP2
	dex
	bpl !+
	ldx #3
!: stx directionP2
	jmp next3
			// 0-3 - 0 is left, 1 is down, 2 is right, 3 is up
next2:	
	cmp #1				// Pressed right?
	bne next3		// No - CHANGED TO FIX REVERSED CONTROLS
	cmp lastjoy1			// debounce (not sure this is necessary)
	 bne !+
	jmp next3			

!:	
	sta lastjoy1 
	inc coordpos2		// add a coordinate
	ldx directionP2
	inx
	cpx #4
	bne !+
	ldx #0
!: stx directionP2
next3:
ldx coordpos2
		lda directionP2
	sta directiontableP2,x

	jsr clearcolram	
	lda P1death
	bne !+
	jsr dodir
!:	lda P2death
	bne !+
	jsr dodir1
!:	jsr rendergrid
jsr rendergrid1
	jsr dotrailcol
	jsr dotrailcol1

	rts
} //END OF plotscii


rendergrid:
xgrid:	
	ldx #0
	ldy #0
	lda doublebuffer
	bne gloop1
gloop:	
	lda grid,x
	sta $0479,y
	sta $04f1,y
	sta $0569,y
	sta $05e1,y
	sta $0659,y
g1:	
	lda grid+3,x
	sta $0429,y
	sta $04a1,y
	sta $0519,y
	sta $0591,y
	sta $0609,y
	sta $0681,y
g2:	
	lda grid+6,x
	sta $0451,y
	sta $04c9,y
	sta $0541,y
	sta $05b9,y
	sta $0631,y
	sta $06a9,y
	inx
	cpx #3
	bne incy
	ldx #0
incy:	
	iny
	cpy #17
	bne gloop
	rts
gloop1:	
	lda grid,x
	sta $2479,y
	sta $24f1,y
	sta $2569,y
	sta $25e1,y
	sta $2659,y
g12:	
	lda grid+3,x
	sta $2429,y
	sta $24a1,y
	sta $2519,y
	sta $2591,y
	sta $2609,y
	sta $2681,y
g22:	
	lda grid+6,x
	sta $2451,y
	sta $24c9,y
	sta $2541,y
	sta $25b9,y
	sta $2631,y
	sta $26a9,y
	inx
	cpx #3
	bne incy1
	ldx #0
incy1:	
	iny
	cpy #17
	bne gloop1
 	rts

rendergrid1:
xgrid1:	
	ldx #0
	ldy #0
	lda doublebuffer
	bne grloop1
grloop:	
	lda grid,x
	sta $0479+21,y
	sta $04f1+21,y
	sta $0569+21,y
	sta $05e1+21,y
	sta $0659+21,y
gr1:	
	lda grid+3,x
	sta $0429+21,y
	sta $04a1+21,y
	sta $0519+21,y
	sta $0591+21,y
	sta $0609+21,y
	sta $0681+21,y
gr2:	
	lda grid+6,x
	sta $0451+21,y
	sta $04c9+21,y
	sta $0541+21,y
	sta $05b9+21,y
	sta $0631+21,y
	sta $06a9+21,y
	inx
	cpx #3
	bne !+
	ldx #0
!:	
	iny
	cpy #17
	bne grloop
	rts
grloop1:	
	lda grid,x
	sta $2479+21,y
	sta $24f1+21,y
	sta $2569+21,y
	sta $25e1+21,y
	sta $2659+21,y
gr12:	
	lda grid+3,x
	sta $2429+21,y
	sta $24a1+21,y
	sta $2519+21,y
	sta $2591+21,y
	sta $2609+21,y
	sta $2681+21,y
gr22:	
	lda grid+6,x
	sta $2451+21,y
	sta $24c9+21,y
	sta $2541+21,y
	sta $25b9+21,y
	sta $2631+21,y
	sta $26a9+21,y
	inx
	cpx #3
	bne !+
	ldx #0
!:	
	iny
	cpy #17
	bne grloop1
 	rts



dodir:{ 	
	lda directionP1			// 0-3 - 0 is left, 1 is down, 2 is right, 3 is up
	bne nxchk		
	inc viewportleft1		
	inc viewportright1
	jsr storecoord
	ldx xgrid+1
	inx
	cpx #3
	bne stxgrd1
	ldx #0
stxgrd1:	
	stx xgrid+1
	rts
nxchk:	
	cmp #3
	bne nxchk1
	dec viewportbottom1
	dec viewporttop1
	jsr storecoord
	ldy ygrid+1
	dey
	bpl stygrd
	ldy #2
stygrd:	
	sty ygrid+1
	jsr ygrid
	rts
nxchk1:	
	cmp #2
	bne nxchk3
	dec viewportleft1
	dec viewportright1
	jsr storecoord
	ldx xgrid+1
	dex
	bpl stxgrd
	ldx #2
stxgrd:	
	stx xgrid+1
	rts
nxchk3:	
	cmp #1
	bne return
	inc viewportbottom1
	inc viewporttop1
	jsr storecoord
	ldy ygrid+1
	iny
	cpy #3
	bne stygrd1
	ldy #0
stygrd1: 
	sty ygrid+1
	jsr ygrid
return:	
	rts

//store current player co-ords to x an y co-ord tables
storecoord:  
	ldx coordpos1
	inc distancetableP1,x
	rts
}
dodir1:{ 	
	lda directionP2			// 0-3 - 0 is left, 1 is down, 2 is right, 3 is up
	bne nxchk		
	inc viewportleft2		
	inc viewportright2
	jsr storecoord
	ldx xgrid1+1
	inx
	cpx #3
	bne !+
	ldx #0
!:	
	stx xgrid1+1
	rts
nxchk:	
	cmp #3
	bne nxchk1
	dec viewportbottom2
	dec viewporttop2
	jsr storecoord
	ldy ygrid1+1
	dey
	bpl !+
	ldy #2
!:	
	sty ygrid1+1
	jsr ygrid1
	rts
nxchk1:	
	cmp #2
	bne nxchk3
	dec viewportleft2
	dec viewportright2
	jsr storecoord
	ldx xgrid1+1
	dex
	bpl !+
	ldx #2
!:	
	stx xgrid1+1
	rts
nxchk3:	
	cmp #1
	bne return
	inc viewportbottom2
	inc viewporttop2
	jsr storecoord
	ldy ygrid1+1
	iny
	cpy #3
	bne !+
	ldy #0
!: 
	sty ygrid1+1
	jsr ygrid1
return:	
	rts

//store current player co-ords to x an y co-ord tables
storecoord:  
	ldx coordpos2
	inc distancetableP2,x
	rts
}
ygrid: { 	
	ldx #0
	lda gridlo,x
	sta gloop+1
	sta gloop1+1
	lda gridhi,x
	sta gloop+2
	sta gloop1+2
	inx
	cpx #3
	bne !+
	ldx #0
!:	lda gridlo,x
	sta g1+1
	sta g12+1
	lda gridhi,x
	sta g1+2
	sta g12+2
	inx
	cpx #3
	bne !+
	ldx #0
!:	
	lda gridlo,x
	sta g2+1
	sta g22+1
	lda gridhi,x
	sta g2+2
	sta g22+2
	rts

	
}
ygrid1: { 	
	ldx #0
	lda gridlo,x
	sta grloop+1
	sta grloop1+1
	lda gridhi,x
	sta grloop+2
	sta grloop1+2
	inx
	cpx #3
	bne !+
	ldx #0
!:	lda gridlo,x
	sta gr1+1
	sta gr12+1
	lda gridhi,x
	sta gr1+2
	sta gr12+2
	inx
	cpx #3
	bne !+
	ldx #0
!:	
	lda gridlo,x
	sta gr2+1
	sta gr22+1
	lda gridhi,x
	sta gr2+2
	sta gr22+2
	rts

	
}
// END OF rendergrid


trail1: 
	lda coordpos2
	sta coordpos
	lda trailcol2
	sta trailcol
	lda viewportleft1
	sta viewportleft
	lda viewportright1
	sta viewportright
	lda viewporttop1
	sta viewporttop
	lda viewportbottom1
	sta viewportbottom
	ldx #<directiontableP2
	ldy #>directiontableP2
	stx $40
	sty $41
	ldx #<distancetableP2
	ldy #>distancetableP2
	stx $42
	sty $43
	ldx #<directiontableP2-1
	ldy #>directiontableP2-1
	stx $44
	sty $45
	ldx #<scrnlo
	ldy #>scrnlo
	stx $46
	sty $47
	ldx #<scrnhi
	ldy #>scrnhi
	stx $48
	sty $49
	ldx #<scrn2hi
	ldy #>scrn2hi
	stx $4a
	sty $4b
	ldx #<colorhi
	ldy #>colorhi
	stx $4c
	sty $4d
	lda #0
	sta plotplayers
	ldx #130
	ldy #128
	jsr trailplot
	lda coordpos1
	sta coordpos
	lda trailcol1
	sta trailcol
	ldx #<directiontableP1
	ldy #>directiontableP1
	stx $40
	sty $41
	ldx #<distancetableP1
	ldy #>distancetableP1
	stx $42
	sty $43
	ldx #<directiontableP1-1
	ldy #>directiontableP1-1
	stx $44
	sty $45
	lda viewportleft1
	sta viewportleft
	lda viewportright1
	sta viewportright
	lda viewporttop1
	sta viewporttop
	lda viewportbottom1
	sta viewportbottom
	lda P1death
	sta death
	ldx #$71
	ldy #$29
	stx collision+1
	sty collision+2
	ldx #<scrnlo
	ldy #>scrnlo
	stx $46
	sty $47
	ldx #<scrnhi
	ldy #>scrnhi
	stx $48
	sty $49
	ldx #<scrn2hi
	ldy #>scrn2hi
	stx $4a
	sty $4b
	ldx #<colorhi
	ldy #>colorhi
	stx $4c
	sty $4d
	lda #1
	sta plotplayers
	ldx #128
	ldy #128
	jsr trailplot
	lda death
	sta P1death
	rts
trail2: 
	lda coordpos1
	sta coordpos
	lda viewportleft2
	sta viewportleft
	lda viewportright2
	sta viewportright
	lda viewporttop2
	sta viewporttop
	lda viewportbottom2
	sta viewportbottom
	lda trailcol1
	sta trailcol
	ldx #<directiontableP1
	ldy #>directiontableP1
	stx $40
	sty $41
	ldx #<distancetableP1
	ldy #>distancetableP1
	stx $42
	sty $43
	ldx #<directiontableP1-1
	ldy #>directiontableP1-1
	stx $44
	sty $45
	ldx #<scrnloP2
	ldy #>scrnloP2
	stx $46
	sty $47
	ldx #<scrnhiP2
	ldy #>scrnhiP2
	stx $48
	sty $49
	ldx #<scrn2hiP2
	ldy #>scrn2hiP2
	stx $4a
	sty $4b
	ldx #<colorhi2
	ldy #>colorhi2
	stx $4c
	sty $4d
	lda #0
	sta plotplayers
	ldx #128
	ldy #128
	jsr trailplot


	lda coordpos2
	sta coordpos
	lda trailcol2
	sta trailcol
	ldx #<directiontableP2
	ldy #>directiontableP2
	stx $40
	sty $41
	ldx #<distancetableP2
	ldy #>distancetableP2
	stx $42
	sty $43
	ldx #<directiontableP2-1
	ldy #>directiontableP2-1
	stx $44
	sty $45
	lda viewportleft2
	sta viewportleft
	lda viewportright2
	sta viewportright
	lda viewporttop2
	sta viewporttop
	lda viewportbottom2
	sta viewportbottom
	lda P2death
	sta death
	ldx #$86
	ldy #$29
	stx collision+1
	sty collision+2
	ldx #<scrnloP2
	ldy #>scrnloP2
	stx $46
	sty $47
	ldx #<scrnhiP2
	ldy #>scrnhiP2
	stx $48
	sty $49
	ldx #<scrn2hiP2
	ldy #>scrn2hiP2
	stx $4a
	sty $4b
	ldx #<colorhi2
	ldy #>colorhi2
	stx $4c
	sty $4d
	lda #1
	sta plotplayers
	ldx #130
	ldy #128
	jsr trailplot
	lda death
	sta P2death
	rts	
trailplot: 	
	stx P1xcoord1
	stx P1xcoord2
	sty P1ycoord1
	sty P1ycoord2
	lda #0
	sta xregpos
	ldy #0
loopy:	
	lda plotplayers
	beq !+
	cpy coordpos
	bne !+
collision:	lda $2971
	cmp #$0d
	beq	!+
	lda #1
	sta death
!:
{	lda ($40),y
	bne !+
	jmp right
!:	cmp #1
	bne !+
	jmp down
!:	cmp #2
	bne up
	jmp left
	
incrx1: jmp incrx
up:	
	lda P1ycoord2  // load latest P1ycoord
	sta P1ycoord1	// store as last co-ord
	sec
	sbc ($42),y	// subtract distance
	sta P1ycoord2	// store to latest P1ycoord
	lda P1ycoord1	// put co-ords in lowest to highest order, for the line plot routine
	sta ycoord2
	lda P1ycoord2
	sta ycoord1
	lda P1xcoord2
	sta xcoord1
	sta xcoord2
	lda xcoord1				
	cmp viewportright			// Is left hand point to the right of the viewport? If its horizontal or vertical, its invisible
	bcs incrx1				
//L1X < V2X
	lda xcoord2
	cmp viewportleft			// Is the right hand point to the left of the viewport? If its horizontal or vertical, its invisible
	bcc incrx1

	lda ycoord1					// Is the top point below the viewport? if it is horizontal or vertical, its invisible
	cmp viewporttop
	bcs incrx1				

	lda ycoord2					// Is the bottom point above the viewport? if it is horizontal or vertical, its invisible
	cmp viewportbottom
	bcc incrx1	
	jsr viewportcoords
	jsr reducecoords	// reduce co-ords to screen co-ords for plot routine
	lda ycoord1
	cmp ycoord2
	beq incrx1
	ldy ycoord2
	ldx xcoord1
dloop:
	lda ($46),y
	sta scrn1+1
	sta colr1+1
	lda doublebuffer	// check doublebuffer and render to appropriate screen
	bne nxscrn1
	lda ($48),y    
	sta scrn1+2
	jmp colrhi1
nxscrn1:
	lda ($4a),y    
	sta scrn1+2
colrhi1:	lda ($4c),y
	sta colr1+2
	lda #$42
scrn1:	
	sta $0400,x
	lda trailcol
colr1: sta $d800,x
	cpy ycoord1
//loop until top yco-ord, drawing a line up
	beq !+
	dey
	jmp dloop	
!:	lda P1ycoord1
	cmp viewporttop
	bcs incx
	ldy xregpos
	lda ($44),y
	bne !+
	lda #$4b
	sta cornrb+1
	jmp docornrb
!: lda #$4a 
	sta cornrb+1
docornrb: ldx xcoord1
	ldy ycoord2
	lda doublebuffer
	bne nxtscrnt
	lda ($48),y
	sta charb+2
	jmp doeets
nxtscrnt:	lda ($4a),y
	sta charb+2
doeets:	lda ($46),y
	sta charb+1
	ldx xcoord1
cornrb: lda #$4b
charb: sta $0400,x	
	
incx: 	jmp incrx
 	
 	
down:	
	lda P1ycoord2
	sta P1ycoord1
	clc
	adc ($42),y
	sta P1ycoord2
	lda P1xcoord2
	sta xcoord1
	sta xcoord2
	lda P1ycoord1
	sta ycoord1
	lda P1ycoord2
	sta ycoord2
	lda xcoord1				
	cmp viewportright			// Is left hand point to the right of the viewport? If its horizontal or vertical, its invisible
	bcs incx				
//L1X < V2X
	lda xcoord2
	cmp viewportleft			// Is the right hand point to the left of the viewport? If its horizontal or vertical, its invisible
	bcc incx

	lda ycoord1					// Is the top point below the viewport? if it is horizontal or vertical, its invisible
	cmp viewporttop
	bcs incx				

	lda ycoord2					// Is the bottom point above the viewport? if it is horizontal or vertical, its invisible
	cmp viewportbottom
	bcc incx
	jsr viewportcoords
	jsr reducecoords
	lda ycoord1
	cmp ycoord2
	beq incx
	ldy ycoord1
	ldx xcoord1
dloop1:
	lda ($46),y
	sta scrn2+1
	sta colr2+1
	lda doublebuffer
	bne nxscrn2
	lda ($48),y    
	sta scrn2+2
	jmp colrhi2
nxscrn2:
	lda ($4a),y    
	sta scrn2+2
colrhi2:	lda ($4c),y
	sta colr2+2
	lda #$42
scrn2:	
	sta $0400,x
	lda trailcol
colr2: sta $d800,x
	cpy ycoord2
//loop until top yco-ord
	beq !+
	iny
	jmp dloop1
!:	lda P1ycoord1
	cmp viewportbottom
	bcc incx1
	lda xregpos
	beq incx1
		ldy xregpos
	lda ($44),y
	bne blah2
	lda #$49
	sta cornr2+1
	jmp docornr2
blah2: lda #$55 
	sta cornr2+1
docornr2: ldx xcoord1
	ldy ycoord1
	lda doublebuffer
	bne nxtscrn
	lda ($48),y
	sta char2+2
	jmp doeet
nxtscrn:	lda ($4a),y
	sta char2+2
doeet:	lda ($46),y
	sta char2+1
	ldx xcoord1
cornr2: lda #$4b
char2: sta $0400,x	

incx1: 	jmp incrx	
 	
 	
left:	
	lda P1xcoord2
	sta P1xcoord1
	sec
	sbc ($42),y
	sta P1xcoord2
	lda P1xcoord1
	sta xcoord2
	lda P1xcoord2
	sta xcoord1
	lda P1ycoord2
	sta ycoord1
	sta ycoord2

	lda xcoord1				
	cmp viewportright			// Is left hand point to the right of the viewport? If its horizontal or vertical, its invisible
	bcs incx1				
//L1X < V2X
	lda xcoord2
	cmp viewportleft			// Is the right hand point to the left of the viewport? If its horizontal or vertical, its invisible
	bcc incx1

	lda ycoord1					// Is the top point below the viewport? if it is horizontal or vertical, its invisible
	cmp viewporttop
	bcs incx1					

	lda ycoord2					// Is the bottom point above the viewport? if it is horizontal or vertical, its invisible
	cmp viewportbottom
	bcc incx1
	jsr viewportcoords
	jsr reducecoords
	lda xcoord1
	cmp xcoord2
	beq incx1
	ldx xcoord2
	ldy ycoord1
	lda ($46),y
	sta scrn3+1
	sta colr3+1
	lda doublebuffer
	bne nxscrn3
	lda ($48),y    
	sta scrn3+2
	jmp colrhi3
nxscrn3:
	lda ($4a),y    
	sta scrn3+2
colrhi3:	
lda ($4c),y
	sta colr3+2	
dloop2:

	lda #$43
scrn3:	
	sta $0400,x
	lda trailcol
colr3: sta $d800,x
	cpx xcoord1
//loop until top yco-ord
	beq !+
	dex
	jmp dloop2
!:	lda P1xcoord1
	cmp viewportright
	bcs incx2
	ldy xregpos
	lda ($44),y
	cmp #1
	bne blah
	lda #$4b
	sta cornr+1
	jmp docornr
blah: lda #$49
	sta cornr+1
docornr: ldx xcoord2
	lda scrn3+1
	sta char+1
	lda scrn3+2
	sta char+2
cornr: lda #$4b
char: sta $0400,x	
nup: 	
incx2: jmp incrx	


right:	
	lda P1xcoord2
	sta P1xcoord1
	clc
	adc ($42),y
	sta P1xcoord2
	lda P1xcoord1
	sta xcoord1
	lda P1xcoord2
	sta xcoord2
	lda P1ycoord2
	sta ycoord1
	sta ycoord2
	lda xcoord1				
	cmp viewportright			// Is left hand point to the right of the viewport? If its horizontal or vertical, its invisible
	bcs incx2				
//L1X < V2X
	lda xcoord2
	cmp viewportleft			// Is the right hand point to the left of the viewport? If its horizontal or vertical, its invisible
	bcc incx2

	lda ycoord1					// Is the top point below the viewport? if it is horizontal or vertical, its invisible
	cmp viewporttop
	bcs incx2				

	lda ycoord2					// Is the bottom point above the viewport? if it is horizontal or vertical, its invisible
	cmp viewportbottom
	bcc incx2	
	jsr viewportcoords
	jsr reducecoords
	lda xcoord1
	cmp xcoord2
	beq incx2
	ldy ycoord1
	lda ($46),y
	sta scrn4+1
	sta colr4+1
	lda doublebuffer
	bne nxscrn4
	lda ($48),y    
	sta scrn4+2
	jmp colrhi4
nxscrn4:
	lda ($4a),y    
	sta scrn4+2
colrhi4:	lda ($4c),y
	sta colr4+2	
	ldx xcoord1
dloop3:

	lda #$43
scrn4:	
	sta $0400,x
	lda trailcol
colr4: sta $d800,x
	cpx xcoord2
//loop until top yco-ord
	beq !+
	inx
	jmp dloop3
	!:
	lda P1xcoord1
	cmp viewportleft
	bcc incrx
	ldy xregpos
	lda ($44),y
	cmp #1
	bne blah1
	lda #$4a
	sta cornr1+1
	jmp docornr1
blah1: lda #$55 
	sta cornr1+1
docornr1: ldx xcoord1
	lda scrn4+1
	sta char1+1
	lda scrn4+2
	sta char1+2
cornr1: lda #$4b
char1: sta $0400,x	
incrx: ldy xregpos
	cpy coordpos
	beq ret
	iny
	sty xregpos
	jmp loopy
ret:	rts
}
arena1: 
	ldx #<scrnlo
	ldy #>scrnlo
	stx $46
	sty $47
	ldx #<scrnhi
	ldy #>scrnhi
	stx $48
	sty $49
	ldx #<scrn2hi
	ldy #>scrn2hi
	stx $4a
	sty $4b
	ldx #<colorhi
	ldy #>colorhi
	stx $4c
	sty $4d
	lda viewportleft1
	sta viewportleft
	lda viewportright1
	sta viewportright
	lda viewporttop1
	sta viewporttop
	lda viewportbottom1
	sta viewportbottom
	jsr arenaplot
	rts
arena2: 
	ldx #<scrnloP2
	ldy #>scrnloP2
	stx $46
	sty $47
	ldx #<scrnhiP2
	ldy #>scrnhiP2
	stx $48
	sty $49
	ldx #<scrn2hiP2
	ldy #>scrn2hiP2
	stx $4a
	sty $4b
	ldx #<colorhi2
	ldy #>colorhi2
	stx $4c
	sty $4d
	lda viewportleft2
	sta viewportleft
	lda viewportright2
	sta viewportright
	lda viewporttop2
	sta viewporttop
	lda viewportbottom2
	sta viewportbottom
	jsr arenaplot
	rts
arenaplot: 	{
	ldx #9
	ldy #9
	stx P1xcoord1
	stx P1xcoord2
	sty P1ycoord1
	sty P1ycoord2
	lda #0
	sta xregpos
	ldx #0
loop:	
	lda arenadir,x
	bne nah
	jmp right
nah:	cmp #1
	bne nah1
	jmp down
nah1:	cmp #2
	bne up
	jmp left
	
incrx1: jmp incrx
up:	
	lda P1ycoord2  // load latest P1ycoord
	sta P1ycoord1	// store as last co-ord
	sec
	sbc distancetablearena,x	// subtract distance
	sta P1ycoord2	// store to latest P1ycoord
	lda P1ycoord1	// put co-ords in lowest to highest order, for the line plot routine
	sta ycoord2
	lda P1ycoord2
	sta ycoord1
	lda P1xcoord2
	sta xcoord1
	sta xcoord2
	lda xcoord1				
	cmp viewportright			// Is left hand point to the right of the viewport? If its horizontal or vertical, its invisible
	bcs incrx1				
//L1X < V2X
	lda xcoord2
	cmp viewportleft			// Is the right hand point to the left of the viewport? If its horizontal or vertical, its invisible
	bcc incrx1

	lda ycoord1					// Is the top point below the viewport? if it is horizontal or vertical, its invisible
	cmp viewporttop
	bcs incrx1				

	lda ycoord2					// Is the bottom point above the viewport? if it is horizontal or vertical, its invisible
	cmp viewportbottom
	bcc incrx1	
	jsr viewportcoords
	jsr reducecoords	// reduce co-ords to screen co-ords for plot routine
	lda ycoord1
	cmp ycoord2
	beq incrx1
	ldy ycoord2
	ldx xcoord1
dloop:
	lda ($46),y
	sta scrn1+1
	sta colr1+1
	lda doublebuffer	// check doublebuffer and render to appropriate screen
	bne nxscrn1
	lda ($48),y    
	sta scrn1+2
	jmp colrhi1
nxscrn1:
	lda ($4a),y    
	sta scrn1+2
colrhi1:	lda ($4c),y
	sta colr1+2
	lda #$56
scrn1:	
	sta $0400,x
	lda #$02
colr1: sta $d800,x
	cpy ycoord1
//loop until top yco-ord, drawing a line up
	beq !+
	dey
	jmp dloop	
!:	
incx: 	jmp incrx
 	
 	
down:	
	lda P1ycoord2
	sta P1ycoord1
	clc
	adc distancetablearena,x
	sta P1ycoord2
	lda P1xcoord2
	sta xcoord1
	sta xcoord2
	lda P1ycoord1
	sta ycoord1
	lda P1ycoord2
	sta ycoord2
	lda xcoord1				
	cmp viewportright			// Is left hand point to the right of the viewport? If its horizontal or vertical, its invisible
	bcs incx				
//L1X < V2X
	lda xcoord2
	cmp viewportleft			// Is the right hand point to the left of the viewport? If its horizontal or vertical, its invisible
	bcc incx

	lda ycoord1					// Is the top point below the viewport? if it is horizontal or vertical, its invisible
	cmp viewporttop
	bcs incx				

	lda ycoord2					// Is the bottom point above the viewport? if it is horizontal or vertical, its invisible
	cmp viewportbottom
	bcc incx
	jsr viewportcoords
	jsr reducecoords
	lda ycoord1
	cmp ycoord2
	beq incx
	ldy ycoord1
	ldx xcoord1
dloop1:
	lda ($46),y
	sta scrn2+1
	sta colr2+1
	lda doublebuffer
	bne nxscrn2
	lda ($48),y    
	sta scrn2+2
	jmp colrhi2
nxscrn2:
	lda ($4a),y    
	sta scrn2+2
colrhi2:	lda ($4c),y
	sta colr2+2
	lda #$56
scrn2:	
	sta $0400,x
	lda #$02
colr2: sta $d800,x
	cpy ycoord2
//loop until top yco-ord
	beq !+
	iny
	jmp dloop1
!:	
incx1: 	jmp incrx	
 	
 	
left:	
	lda P1xcoord2
	sta P1xcoord1
	sec
	sbc distancetablearena,x
	sta P1xcoord2
	lda P1xcoord1
	sta xcoord2
	lda P1xcoord2
	sta xcoord1
	lda P1ycoord2
	sta ycoord1
	sta ycoord2

	lda xcoord1				
	cmp viewportright			// Is left hand point to the right of the viewport? If its horizontal or vertical, its invisible
	bcs incx1				
//L1X < V2X
	lda xcoord2
	cmp viewportleft			// Is the right hand point to the left of the viewport? If its horizontal or vertical, its invisible
	bcc incx1

	lda ycoord1					// Is the top point below the viewport? if it is horizontal or vertical, its invisible
	cmp viewporttop
	bcs incx1					

	lda ycoord2					// Is the bottom point above the viewport? if it is horizontal or vertical, its invisible
	cmp viewportbottom
	bcc incx1
	jsr viewportcoords
	jsr reducecoords
	lda xcoord1
	cmp xcoord2
	beq incx1
	ldx xcoord2
	ldy ycoord1
	lda ($46),y
	sta scrn3+1
	sta colr3+1
	lda doublebuffer
	bne nxscrn3
	lda ($48),y    
	sta scrn3+2
	jmp colrhi3
nxscrn3:
	lda ($4a),y    
	sta scrn3+2
colrhi3:	
lda ($4c),y
	sta colr3+2	
dloop2:

	lda #$56
scrn3:	
	sta $0400,x
	lda #$02
colr3: sta $d800,x
	cpx xcoord1
//loop until top yco-ord
	beq !+
	dex
	jmp dloop2
!:	
incx2: jmp incrx	


right:	
	lda P1xcoord2
	sta P1xcoord1
	clc
	adc distancetablearena,x
	sta P1xcoord2
	lda P1xcoord1
	sta xcoord1
	lda P1xcoord2
	sta xcoord2
	lda P1ycoord2
	sta ycoord1
	sta ycoord2
	lda xcoord1				
	cmp viewportright			// Is left hand point to the right of the viewport? If its horizontal or vertical, its invisible
	bcs incx2				
//L1X < V2X
	lda xcoord2
	cmp viewportleft			// Is the right hand point to the left of the viewport? If its horizontal or vertical, its invisible
	bcc incx2

	lda ycoord1					// Is the top point below the viewport? if it is horizontal or vertical, its invisible
	cmp viewporttop
	bcs incx2				

	lda ycoord2					// Is the bottom point above the viewport? if it is horizontal or vertical, its invisible
	cmp viewportbottom
	bcc incx2	
	jsr viewportcoords
	jsr reducecoords
	lda xcoord1
	cmp xcoord2
	beq incx2
	ldy ycoord1
	lda ($46),y
	sta scrn4+1
	sta colr4+1
	lda doublebuffer
	bne nxscrn4
	lda ($48),y    
	sta scrn4+2
	jmp colrhi4
nxscrn4:
	lda ($4a),y    
	sta scrn4+2
colrhi4:	lda ($4c),y
	sta colr4+2	
	ldx xcoord1
dloop3:

	lda #$56
scrn4:	
	sta $0400,x
	lda #$02
colr4: sta $d800,x
	cpx xcoord2
//loop until top yco-ord
	beq !+
	inx
	jmp dloop3
	!:
	
incrx: ldx xregpos
	cpx #3
	beq ret
	inx
	stx xregpos
	jmp loop
ret:	rts
}
viewportcoords:	
lda xcoord1
	cmp viewportleft		// is the left point to the left of the viewport?
	bcs !+
	lda viewportleft			// set it to the left hand side of the viewport
	sta xcoord1

!:
	lda xcoord2					// is the right point to the right of the viewport?
	cmp viewportright
	bcc !+
	lda viewportright			// set it to the right hand side of the viewport
	sta xcoord2

!:	
	lda ycoord1					// is top point above the viewport?
	cmp viewportbottom
	bcs !+
	lda viewportbottom
	sta ycoord1

!:
	lda ycoord2
	cmp viewporttop
	bcc !+
	lda viewporttop
	sta ycoord2
!:	rts
reducecoords: lda xcoord1
	sec
	sbc viewportleft
	sta xcoord1
	lda xcoord2
	sec
	sbc viewportleft
	sta xcoord2
	lda ycoord1
	sec
	sbc viewportbottom
	sta ycoord1
	lda ycoord2
	sec
	sbc viewportbottom
	sta ycoord2
	rts



dotrailcol: {
	ldx trailcol1pos
	lda trailcol1table,x
	sta trailcol1
	inx
	cpx #9
	bne nxt
	ldx #0
nxt: 
	stx trailcol1pos
	rts
}
dotrailcol1: {
	ldx trailcol2pos
	lda trailcol2table,x
	sta trailcol2
	inx
	cpx #9
	bne !+
	ldx #0
!: 
	stx trailcol2pos
	rts
}

	
plotplayer: {
	lda directionP1
	bne up
	lda doublebuffer
	bne nx1
	lda #$51
	sta $056f
	sta $0571
	lda #$a0
	sta $0570
	jmp colr1
nx1: lda #$51
	sta $256f
	sta $2571
	lda #$a0
	sta $2570
colr1:	lda P1death
	beq !+
	lda #$06
	sta $296f
	sta $2970
	sta $2971
	rts
!:	ldx playercolrpos
	lda playercycletable,x
	sta $296f
	jsr incx
	lda playercycletable,x
	sta $2970
	jsr incx
	lda playercycletable,x
	sta $2971
	jsr incx
	stx playercolrpos
	rts
up:	
	cmp #1
	bne right
	lda doublebuffer
	bne nx2
	lda #$51
	sta $0521
	sta $0571
	lda #$a0
	sta $0549
	jmp colr2
nx2:	lda #$51
	sta $2521
	sta $2571
	lda #$a0
	sta $2549
colr2:	lda P1death
	beq !+
	lda #$06
	sta $2921
	sta $2949
	sta $2971
	rts
!:	ldx playercolrpos
	lda playercycletable,x
	sta $2921
	jsr incx
	lda playercycletable,x
	sta $2949
	jsr incx
	lda playercycletable,x
	sta $2971
	jsr incx
	stx playercolrpos	
	rts
right:	
	cmp #2
	bne down
	lda doublebuffer
	bne nx3
	lda #$51
	sta $0573
	sta $0571
	lda #$a0
	sta $0572
	jmp colr3
nx3:	lda #$51
	sta $2573
	sta $2571
	lda #$a0
	sta $2572
colr3:	lda P1death
	beq !+
	lda #$06
	sta $2971
	sta $2972
	sta $2973
	rts
!:	ldx playercolrpos
	lda playercycletable,x
	sta $2973
	jsr incx
	lda playercycletable,x
	sta $2972
	jsr incx
	lda playercycletable,x
	sta $2971
	jsr incx
	stx playercolrpos
	rts
down:	lda doublebuffer
	bne nx4
	lda #$51
	sta $05c1
	sta $0571
	lda #$a0
	sta $0599
	jmp colr4
nx4:	 lda #$51
	sta $25c1
	sta $2571
	lda #$a0
	sta $2599
colr4:	lda P1death
	beq !+
	lda #$06
	sta $2971
	sta $2999
	sta $29c1
	rts
!:	ldx playercolrpos
	lda playercycletable,x
	sta $29c1
	jsr incx
	lda playercycletable,x
	sta $2999
	jsr incx
	lda playercycletable,x
	sta $2971
	jsr incx
	stx playercolrpos
	rts
incx: 
	inx
	cpx #16
	bne exit
	ldx #0
exit: 
	rts
}
plotplayer2: {
	lda directionP2
	bne up
	lda doublebuffer
	bne nx1
	lda #$51
	sta $0584
	sta $0586
	lda #$a0
	sta $0585
	jmp colr1
nx1: lda #$51
	sta $2584
	sta $2586
	lda #$a0
	sta $2585
colr1:	lda P2death
	beq !+
	lda #$02
	sta $2984
	sta $2985
	sta $2986
	rts
!:	ldx player2colrpos
	lda player2cycletable,x
	sta $2984
	jsr incx
	lda player2cycletable,x
	sta $2985
	jsr incx
	lda player2cycletable,x
	sta $2986
	jsr incx
	stx player2colrpos
	rts
up:	
	cmp #1
	bne right
	lda doublebuffer
	bne nx2
	lda #$51
	sta $0586
	sta $0536
	lda #$a0
	sta $055e
	jmp colr2
nx2:	lda #$51
	sta $2536
	sta $2586
	lda #$a0
	sta $255e
colr2:	lda P2death
	beq !+
	lda #$02
	sta $2936
	sta $295e
	sta $2986
	rts
!:	ldx player2colrpos
	lda player2cycletable,x
	sta $2936
	jsr incx
	lda player2cycletable,x
	sta $295e
	jsr incx
	lda player2cycletable,x
	sta $2986
	jsr incx
	stx player2colrpos	
	rts
right:	
	cmp #2
	bne down
	lda doublebuffer
	bne nx3
	lda #$51
	sta $0586
	sta $0588
	lda #$a0
	sta $0587
	jmp colr3
nx3:	lda #$51
	sta $2586
	sta $2588
	lda #$a0
	sta $2587
colr3:	lda P2death
	beq !+
	lda #$02
	sta $2986
	sta $2987
	sta $2988
	rts
!:	ldx player2colrpos
	lda player2cycletable,x
	sta $2988
	jsr incx
	lda player2cycletable,x
	sta $2987
	jsr incx
	lda player2cycletable,x
	sta $2986
	jsr incx
	stx player2colrpos
	rts
down:	lda doublebuffer
	bne nx4
	lda #$51
	sta $0586
	sta $05d6
	lda #$a0
	sta $05ae
	jmp colr4
nx4:	 lda #$51
	sta $2586
	sta $25d6
	lda #$a0
	sta $25ae
colr4:	lda P2death
	beq !+
	lda #$02
	sta $2986
	sta $29ae
	sta $29d6
	rts
!:	ldx player2colrpos
	lda player2cycletable,x
	sta $29d6
	jsr incx
	lda player2cycletable,x
	sta $29ae
	jsr incx
	lda player2cycletable,x
	sta $2986
	jsr incx
	stx player2colrpos
	rts
incx: 
	inx
	cpx #16
	bne exit
	ldx #0
exit: 
	rts
}
plotplayers: .byte 0
death: .byte 0
P1death: .byte 0
P2death: .byte 0
doublebuffer: .byte 0
coordpos: .byte 0
coordpos1: .byte 0
coordpos2: .byte 0
xregpos: .byte 0
viewportleft: .byte 120
viewportright: .byte 136
viewporttop: .byte 136
viewportbottom: .byte 120
viewportleft1: .byte 120
viewportright1: .byte 136
viewporttop1: .byte 136
viewportbottom1: .byte 120
xregpos1: .byte 0
viewportleft2: .byte 122
viewportright2: .byte 138
viewporttop2: .byte 136
viewportbottom2: .byte 120
xcoord1: .byte 0
xcoord2: .byte 0
ycoord1: .byte 0
ycoord2: .byte 0
P1xcoord1: .byte 0
P1xcoord2: .byte 0
P1ycoord1: .byte 0
P1ycoord2: .byte 0
trailcol: .byte 0
trailcol1: .byte 0
trailcol1pos: .byte 0
trailcol1table: .byte $06,$06,$0e,$03,$01,$03,$0e,$06,$06
trailcol2: .byte 0
trailcol2pos: .byte 0
trailcol2table: .byte $02,$02,$09,$0a,$01,$0a,$09,$02,$02
playercycletable: .byte $06,$06,$0e,$03,$01,$01,$03,$0e,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06
playercolrpos: .byte 0
player2cycletable: .byte $02,$02,$09,$0a,$01,$01,$0a,$09,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
player2colrpos: .byte 0
.align 256

scrnlo:
.byte $29,$51,$79,$a1,$c9,$f1,$19
.byte $41,$69,$91,$b9,$e1,$09,$31,$59
.byte $81,$a9,$d1,$f9,$21,$49,$71,$99
scrnloP2:
.byte $3e,$66,$8e,$b6,$de,$06,$2e
.byte $56,$7e,$a6,$ce,$f6,$1e,$46,$6e
.byte $96,$be

scrnhi:
.byte $04,$04,$04,$04,$04,$04,$05
.byte $05,$05,$05,$05,$05,$06,$06,$06
.byte $06,$06,$06,$06,$07,$07,$07,$07
scrnhiP2:
.byte $04,$04,$04,$04,$04,$05,$05
.byte $05,$05,$05,$05,$05,$06,$06,$06
.byte $06,$06,$06,$07,$07,$07,$07,$07
scrn2hiP2:
.byte $24,$24,$24,$24,$24,$25,$25
.byte $25,$25,$25,$25,$25,$26,$26,$26
.byte $26,$26,$26,$27,$27,$27,$27,$27

scrn2hi:
.byte $24,$24,$24,$24,$24,$24,$25
.byte $25,$25,$25,$25,$25,$26,$26,$26
.byte $26,$26,$26,$26,$27,$27,$27,$27

colorhi:
.byte $28,$28,$28,$28,$28,$28,$29
.byte $29,$29,$29,$29,$29,$2a,$2a,$2a
.byte $2a,$2a,$2a,$2a,$2b,$2b,$2b,$2b
colorhi2:
.byte $28,$28,$28,$28,$28,$29,$29
.byte $29,$29,$29,$29,$29,$2a,$2a,$2a
.byte $2a,$2a,$2a,$2b,$2b,$2b,$2b,$2b
arenadir: .byte 0,1,2,3
distancetablearena: .byte 238,238,238,238
dx: .byte 0
dy: .byte 0
dx1: .byte 0
dy1: .byte 0
readjoy: {    
		lda $dc00     
		ldy #0        
        ldx #0        
        lsr           
        bcs !+      		// UP
        dey           
!:   
		lsr           
        bcs !+      
        iny           		// DOWN
!:    
		lsr           
        bcs !+      
        dex           		// LEFT
!:    
		lsr           
        bcs !+      
        inx           		// RIGHT
!:    
        stx dx        		// 255 = left, 1 = right
        sty dy        		// 255 = up, 1 = down
        rts           
	 
}
readjoy1: {    
		lda $dc01     
		ldy #0        
        ldx #0        
        lsr           
        bcs !+      		// UP
        dey           
!:   
		lsr           
        bcs !+      
        iny           		// DOWN
!:    
		lsr           
        bcs !+      
        dex           		// LEFT
!:    
		lsr           
        bcs !+      
        inx           		// RIGHT
!:    
        stx dx1        		// 255 = left, 1 = right
        sty dy1        		// 255 = up, 1 = down
        rts           
	 
}
.pc = $2c00
colrbuffer: {
	ldx #0
!:	
	lda $2829,x
	sta $d829,x
	lda $2851,x
	sta $d851,x
	lda $2879,x
	sta $d879,x
	lda $28a1,x
	sta $d8a1,x
	lda $28c9,x
	sta $d8c9,x
	lda $28f1,x
	sta $d8f1,x
	lda $2919,x
	sta $d919,x
	lda $2941,x
	sta $d941,x
	lda $2969,x
	sta $d969,x
	lda $2991,x
	sta $d991,x
	lda $29b9,x
	sta $d9b9,x
	lda $29e1,x
	sta $d9e1,x
	lda $2a09,x
	sta $da09,x
	lda $2a31,x
	sta $da31,x
	lda $2a59,x
	sta $da59,x
	lda $2a81,x
	sta $da81,x
	lda $2aa9,x
	sta $daa9,x
	lda $283e,x
	sta $d83e,x
	lda $2866,x
	sta $d866,x
	lda $288e,x
	sta $d88e,x
	lda $28b6,x
	sta $d8b6,x
	lda $28de,x
	sta $d8de,x
	lda $2906,x
	sta $d906,x
	lda $292e,x
	sta $d92e,x
	lda $2956,x
	sta $d956,x
	lda $297e,x
	sta $d97e,x
	lda $29a6,x
	sta $d9a6,x
	lda $29ce,x
	sta $d9ce,x
	lda $29f6,x
	sta $d9f6,x
	lda $2a1e,x
	sta $da1e,x
	lda $2a46,x
	sta $da46,x
	lda $2a6e,x
	sta $da6e,x
	lda $2a96,x
	sta $da96,x
	lda $2abe,x
	sta $dabe,x
	inx
	cpx #17
	beq !+
	jmp !-
!:	rts

}

clearcolram:{
	ldx #0
	lda #$0d
!: 
	sta $2829,x
	sta $2851,x
	sta $2879,x
	sta $28a1,x
	sta $28c9,x
	sta $28f1,x
	sta $2919,x
	sta $2941,x
	sta $2969,x
	sta $2991,x
	sta $29b9,x
	sta $29e1,x
	sta $2a09,x
	sta $2a31,x
	sta $2a59,x
	sta $2a81,x
	sta $2aa9,x
	sta $2829+21,x
	sta $2851+21,x
	sta $2879+21,x
	sta $28a1+21,x
	sta $28c9+21,x
	sta $28f1+21,x
	sta $2919+21,x
	sta $2941+21,x
	sta $2969+21,x
	sta $2991+21,x
	sta $29b9+21,x
	sta $29e1+21,x
	sta $2a09+21,x
	sta $2a31+21,x
	sta $2a59+21,x
	sta $2a81+21,x
	sta $2aa9+21,x
	inx
	cpx #17
	bne !-
	rts
}
drawviewport: {
	lda #$55
	sta $0400
	sta $2400
	lda #$43
	sta $0401
	sta $0402
	sta $0410
	sta $0411
	lda #$46
	sta $0403
	sta $0404
	sta $0405
	sta $0406
	sta $040c
	sta $040d
	sta $040e
	sta $040f
	lda #$52
	sta $0407
	sta $0408
	sta $0409
	sta $040a
	sta $040b
	lda #$49
	sta $0412
	lda #$42
	sta $0428
	sta $0450
	sta $043a
	sta $0462
	sta $0680
	sta $06a8
	sta $0692
	sta $06ba
	lda #$48
	sta $0478
	sta $04a0
	sta $04c8
	sta $04f0
	sta $05e0
	sta $0608
	sta $0630
	sta $0658
	lda #$47
	sta $048a
	sta $04b2
	sta $04da
	sta $0502
	sta $05f2
	sta $061a
	sta $0642
	sta $066a
	lda #$59
	sta $0518
	sta $0540
	sta $0568
	sta $0590
	sta $05b8
	lda #$4a
	sta $06d0
	lda #$43
	sta $06d1
	sta $06d2
	sta $06e0
	sta $06e1
	lda #$44
	sta $06d3
	sta $06d4
	sta $06d5
	sta $06d6
	sta $06dc
	sta $06dd
	sta $06de
	sta $06df
	lda #$45
	sta $06d7
	sta $06d8
	sta $06d9
	sta $06da
	sta $06db
	lda #$54
	sta $052a
	sta $0552
	sta $057a
	sta $05a2
	sta $05ca
	lda #$4b
	sta $06e2
	ldx #0
!:	lda $0400,x
	sta $2400,x
	sta $0400+21,x
	sta $2400+21,x
	lda $0428,x
	sta $2428,x
	sta $0428+21,x
	sta $2428+21,x
	lda $0450,x
	sta $2450,x
	sta $0450+21,x
	sta $2450+21,x
	lda $0478,x
	sta $2478,x
	sta $0478+21,x
	sta $2478+21,x
	lda $04a0,x
	sta $24a0,x
	sta $04a0+21,x
	sta $24a0+21,x
	lda $04c8,x
	sta $24c8,x
	sta $04c8+21,x
	sta $24c8+21,x
	lda $04f0,x
	sta $24f0,x
	sta $04f0+21,x
	sta $24f0+21,x
	lda $0518,x
	sta $2518,x
	sta $0518+21,x
	sta $2518+21,x
	lda $0540,x
	sta $2540,x
	sta $0540+21,x
	sta $2540+21,x
	lda $0568,x
	sta $2568,x
	sta $0568+21,x
	sta $2568+21,x
	lda $0590,x
	sta $2590,x
	sta $0590+21,x
	sta $2590+21,x
	lda $05b8,x
	sta $25b8,x
	sta $05b8+21,x
	sta $25b8+21,x
	lda $05e0,x
	sta $25e0,x
	sta $05e0+21,x
	sta $25e0+21,x
	lda $0608,x
	sta $2608,x
	sta $0608+21,x
	sta $2608+21,x
	lda $0630,x
	sta $2630,x
	sta $0630+21,x
	sta $2630+21,x
	lda $0658,x
	sta $2658,x
	sta $0658+21,x
	sta $2658+21,x
	lda $0680,x
	sta $2680,x
	sta $0680+21,x
	sta $2680+21,x
	lda $06a8,x
	sta $26a8,x
	sta $06a8+21,x
	sta $26a8+21,x
	lda $06d0,x
	sta $26d0,x
	sta $06d0+21,x
	sta $26d0+21,x
	inx
	cpx #19
	beq !+
	jmp !-
!:	rts
	}

.align 256

directiontableP1:
	.byte 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
distancetableP1:
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
directiontableP2:
	.byte 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
distancetableP2:
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
