drawGridTile: {
	lda #91 sta screenRam
	lda #67 sta screenRam + 1 sta screenRam + 2
	lda #93 sta screenRam + 40 sta screenRam + 80 
	rts
}
tileBuffer: 
.fill $100,0

.macro makeTile(source,sourceWidth,tileBuffer,tileWidth,tileHeight) {
	lda #<source sta $02 
	lda #>source sta $03
	lda #<tileBuffer sta $04 
	lda #>tileBuffer sta $05
	lda #sourceWidth 
	ldy #tileWidth
	ldx #tileHeight
	jsr _makeTile
}

_makeTile: {
	sta sourceWidth 
	sty tileWidth
	stx tileHeight	//; not needed
lp1:
	ldy #$00
lp2:	
	lda ($02),y
	sta ($04),y
	iny
	cpy tileWidth
	bne lp2
	clc lda $02 adc sourceWidth sta $02 bcc noCarry1 inc $03 noCarry1:
	clc lda $04 adc tileWidth sta $04 bcc noCarry2 inc $05 noCarry2:
	dex
	bne lp1
	rts
tileWidth: .byte 0
tileHeight: .byte 0
sourceWidth: .byte 0	
}


.macro drawTiles(destination,destinationWidth,columns,rows,tileBuffer,tileWidth,tileHeight) {
	
	lda #destinationWidth sta _drawTiles_destinationWidth 
	lda #tileWidth sta _drawTiles_tileWidth
	lda #tileHeight sta _drawTiles_tileHeight

	.var tileDestination = 0
	.for (var y = 0 ; y < rows; y++) {
		.for (var x = 0 ; x < columns; x++) {
	 
	 		.eval tileDestination = destination + [x * tileWidth] + [y * destinationWidth * tileHeight] 
	 
			lda #<tileBuffer sta $02
			lda #>tileBuffer sta $03
			lda #<tileDestination sta $04
			lda #>tileDestination sta $05
			jsr _drawTiles
		}
	}	
}

_drawTiles: {
	ldx _drawTiles_tileHeight
lp1:
	ldy #$00
lp2:	
	lda ($02),y
	sta ($04),y
	iny
	cpy _drawTiles_tileWidth
	bne lp2
	clc lda $02 adc _drawTiles_tileWidth sta $02 bcc noCarry1 inc $03 noCarry1:
	clc lda $04 adc _drawTiles_destinationWidth sta $04 bcc noCarry2 inc $05 noCarry2:
	dex
	bne lp1

	rts
}
_drawTiles_tileWidth: .byte 0
_drawTiles_tileHeight: .byte 0
_drawTiles_destinationWidth: .byte 0
