; ------------------------------------------------------------------------------------------------------------- ;
; BASIC interpreter ROM ($a000 - $bfff)
; ------------------------------------------------------------------------------------------------------------- ;
BASIC_ROM     = $a000 ; start address
; ------------------------------------------------------------------------------------------------------------- ;
RESTART	      = $a000 ; BASIC Cold Start Vector   [INIT]      WORD
BASIC_NMI     = $a002 ; BASIC Warm Start Vector   [BASSFT]    WORD
BASIC_TEXT    = $a004 ; "cbmbasic"
STMDSP        = $a00c ; BASIC Command  Vectors                WORD
BAS_END         = $a00c ; perform END     $80 -> _END_      - $01
BAS_FOR         = $a00e ; perform FOR     $81 -> _FOR_      - $01
BAS_NEXT        = $a010 ; perform NEXT    $82 -> _NEXT_     - $01
BAS_DATA        = $a012 ; perform DATA    $83 -> _DATA_     - $01
BAS_INPUT#      = $a014 ; perform INPUT#  $84 -> _INPUTN_   - $01
BAS_INPUT       = $a016 ; perform INPUT   $85 -> _INPUT_    - $01
BAS_DIM         = $a018 ; perform DIM     $86 -> _DIM_      - $01
BAS_READ        = $a01a ; perform READ    $87 -> _READ_     - $01
BAS_LET         = $a01c ; perform LET     $88 -> _LET_      - $01
BAS_GOTO        = $a01e ; perform GOTO    $89 -> _GOTO_     - $01
BAS_RUN         = $a020 ; perform RUN     $8a -> _RUN_      - $01
BAS_IF          = $a022 ; perform IF      $8b -> _IF_       - $01
BAS_RESTORE     = $a024 ; perform RESTORE $8c -> _RESTORE_  - $01
BAS_GOSUB       = $a026 ; perform GOSUB   $8d -> _GOSUB_    - $01
BAS_RETURN      = $a028 ; perform RETURN  $8e -> _RETURN_   - $01
BAS_REM         = $a02a ; perform REM     $8f -> _REM_      - $01
BAS_STOP        = $a02c ; perform STOP    $90 -> _BSTOP_    - $01
BAS_ON          = $a02e ; perform ON      $91 -> _ONGOTO_   - $01
BAS_WAIT        = $a030 ; perform WAIT    $92 -> _WAIT_     - $01
BAS_LOAD        = $a032 ; perform LOAD    $93 -> _LOADT_    - $01
BAS_SAVE        = $a034 ; perform SAVE    $94 -> _SAVET_    - $01
BAS_VERIFY      = $a036 ; perform VERIFY  $95 -> _VERFYT_   - $01
BAS_DEF         = $a038 ; perform DEF     $96 -> _DEF_      - $01
BAS_POKE        = $a03a ; perform POKE    $97 -> _POKE_     - $01
BAS_PRINT#      = $a03c ; perform PRINT#  $98 -> _PRINTN_   - $01
BAS_PRINT       = $a03e ; perform PRINT   $99 -> _PRINT_    - $01
BAS_CONT        = $a040 ; perform CONT    $9a -> _CONT_     - $01
BAS_LIST        = $a042 ; perform LIST    $9b -> _LIST_     - $01
BAS_CLR         = $a044 ; perform CLR     $9c -> _CLEAR_    - $01
BAS_CMD         = $a046 ; perform CMD     $9d -> _PRINTN_   - $01
BAS_SYS         = $a048 ; perform SYS     $9e -> _SYS_      - $01
BAS_OPEN        = $a04a ; perform OPEN    $9f -> _OPENT_    - $01
BAS_CLOSE       = $a04c ; perform CLOSE   $a0 -> _CLOSET_   - $01
BAS_GET         = $a04e ; perform GET     $a1 -> _GET_      - $01
BAS_NEW         = $a050 ; perform NEW     $a2 -> _SCRTCH_   - $01
FUNDSP        = $a052 ; BASIC Function Vectors                WORD
BAS_SGN         = $a052 ; perform SGN     $b4 -> _SGN_
BAS_INT         = $a054 ; perform INT     $b5 -> _INT_
BAS_ABS         = $a056 ; perform ABS     $b6 -> _ABS_
BAS_USR         = $a058 ; perform USR     $b7 -> $0310
BAS_FRE         = $a05a ; perform FRE     $b8 -> _FRE_
BAS_POS         = $a05c ; perform POS     $b9 -> _POS_
BAS_SQR         = $a05e ; perform SQR     $ba -> _SQR_
BAS_RND         = $a060 ; perform RND     $bb -> _RND_
BAS_LOG         = $a062 ; perform LOG     $bc -> _LOG_
BAS_EXP         = $a064 ; perform EXP     $bd -> _EXP_
BAS_COS         = $a066 ; perform COS     $be -> _COS_
BAS_SIN         = $a068 ; perform SIN     $bf -> _SIN_
BAS_TAN         = $a06a ; perform TAN     $c0 -> _TAN_
BAS_ATN         = $a06c ; perform ATN     $c1 -> _ATN_
BAS_PEEK        = $a06e ; perform PEEK    $c2 -> _PEEK_
BAS_LEN         = $a070 ; perform LEN     $c3 -> _LEN_
BAS_STR$        = $a072 ; perform STR$    $c4 -> _STRD_
BAS_VAL         = $a074 ; perform VAL     $c5 -> _VAL_
BAS_ASC         = $a076 ; perform ASC     $c6 -> _ASC_
BAS_CHR$        = $a078 ; perform CHR$    $c7 -> _CHRD_
BAS_LEFT$       = $a07a ; perform LEFT$   $c8 -> _LEFTD_
BAS_RIGHT$      = $a07c ; perform RIGHT$  $c9 -> _RIGHTD_
BAS_MID$        = $a07e ; perform MID$    $ca -> _MIDD_
OPTAB         = $a080 ; BASIC Operator Vectors                WORD
RESLST        = $a09e ; BASIC Command  Keyword Table          DATA
MSCLST        = $a129 ; BASIC Misc     Keyword Table          DATA
OPLIST        = $a140 ; BASIC Operator Keyword Table          DATA
FUNLST        = $a14d ; BASIC Function Keyword Table          DATA
ERRTAB        = $a19e ; Error Message  Table                  DATA
ERRPTR        = $a328 ; Error Message  Pointers               WORD
OKK           = $a364 ; Misc  Messages                        TEXT
FNDFOR        = $a38a ; Find FOR/GOSUB Entry on Stack
BLTU          = $a3b8 ; Open Space in Memory
GETSTK        = $a3fb ; Check Stack Depth
REASON        = $a408 ; Check Memory Overlap
OMERR         = $a435 ; Output ?OUT OF MEMORY Error
ERROR         = $a437 ; Error Routine
ERRFIN        = $a469 ; Break Entry
READY         = $a474 ; Restart BASIC
MAIN          = $a483 ; Input & Identify BASIC Line
MAIN1         = $a49c ; Get Line Number & Tokenise Text
INSLIN        = $a4a2 ; Insert BASIC Text
LINKPRG       = $a533 ; Rechain Lines
INLIN         = $a560 ; Input Line Into Buffer
CRUNCH        = $a579 ; Tokenise Input Buffer
FNDLIN        = $a613 ; Search for Line Number
_SCRTCH_      = $a642 ; Perform [new]
_CLEAR_       = $a65e ; Perform [clr]
STXPT         = $a68e ; Reset TXTPTR
_LIST_        = $a69c ; Perform [list]
QPLOP         = $a717 ; Handle LIST Character
_FOR_         = $a742 ; Perform [for]
NEWSTT        = $a7ae ; BASIC Warm Start
CKEOL         = $a7c4 ; Check End of Program
GONE          = $a7e1 ; Prepare to execute statement
GONE3         = $a7ed ; Perform BASIC Keyword
_RESTORE_     = $a81d ; Perform [restore]
SCAN_STOP     = $a82c ; Scan Stop Key
_BSTOP_       = $a82f ; Perform [stop], break
_END_         = $a831 ; Perform [end]
_CONT_        = $a857 ; Perform [cont]
_RUN_         = $a871 ; Perform [run]
_GOSUB_       = $a883 ; Perform [gosub]
_GOTO_        = $a8a0 ; Perform [goto]
_RETURN_      = $a8d2 ; Perform [return]
_DATA_        = $a8f8 ; Perform [data]
DATAN         = $a906 ; Search for Next Statement / Line
_IF_          = $a928 ; Perform [if]
_REM_         = $a93b ; Perform [rem]
_ONGOTO_      = $a94b ; Perform [on]
LINGET        = $a96b ; Fetch linnum From BASIC
_LET_         = $a9a5 ; Perform [let]
PUTINT        = $a9c4 ; Assign Integer
PTFLPT        = $a9d6 ; Assign Floating Point
PUTSTR        = $a9d9 ; Assign String
PUTTIM        = $a9e3 ; Assign TI$
GETSPT        = $aa2c ; Add Digit to FAC#1
_PRINTN_      = $aa80 ; Perform [print]#
_CMD_         = $aa86 ; Perform [cmd]
STRDON        = $aa9a ; Print String From Memory
_PRINT_       = $aaa0 ; Perform [print]
VAROP         = $aab8 ; Output Variable
CRDO          = $aad7 ; Output CR/LF
COMPRT        = $aae8 ; Handle comma, TAB(, SPC(
STROUT        = $ab1e ; Output String
OUTSPC        = $ab3b ; Output Format Character
DOAGIN        = $ab4d ; Handle Bad Data
_GET_         = $ab7b ; Perform [get]
_INPUTN_      = $aba5 ; Perform [input#]
_INPUT_       = $abbf ; Perform [input]
BUFFUL        = $abea ; Read Input Buffer
QINLIN        = $abf9 ; Do Input Prompt
_READ_        = $ac06 ; Perform [read]
RDGET         = $ac35 ; General Purpose Read Routine
EXINT         = $acfc ; Input Error Messages                  TEXT
_NEXT_        = $ad1e ; Perform [next]
DONEXT        = $ad61 ; Check Valid Loop
FRMNUM        = $ad8a ; Confirm Result
FRMEVL        = $ad9e ; Evaluate Expression in Text
EVAL          = $ae83 ; Evaluate Single Term
PIVAL         = $aea8 ; Constant - pi                         DATA
QDOT          = $aead ; Continue Expression
PARCHK        = $aef1 ; Expression in Brackets
CHKCLS        = $aef7 ; Confirm Character
;             = $aef7 ; -test ')'-
;             = $aefa ; -test '('-
;             = $aefd ; -test comma-
SYNERR        = $af08 ; Output ?SYNTAX Error
DOMIN         = $af0d ; Set up NOT Function
RSVVAR        = $af14 ; Identify Reserved Variable
ISVAR         = $af28 ; Search for Variable
TISASC        = $af48 ; Convert TI to ASCII String
ISFUN         = $afa7 ; Identify Function Type
STRFUN        = $afb1 ; Evaluate String Function
NUMFUN        = $afd1 ; Evaluate Numeric Function
_OROP_        = $afe6 ; Perform [or], [and]
_DOREL_       = $b016 ; Perform <, =, >
NUMREL        = $b01b ; Numeric Comparison
STRREL        = $b02e ; String Comparison
_DIM_         = $b081 ; Perform [dim]
PTRGET        = $b08b ; Identify Variable
ORDVAR        = $b0e7 ; Locate Ordinary Variable
NOTFNS        = $b11d ; Create New Variable
NOTEVL        = $b128 ; Create Variable
ARYGET        = $b194 ; Allocate Array Pointer Space
N32768        = $b1a5 ; Constant 32768 in Flpt        DATA
FACINX        = $b1aa ; FAC#1 to Integer in (AC/YR)
INTIDX        = $b1b2 ; Evaluate Text for Integer
AYINT         = $b1bf ; FAC#1 to Positive Integer
ISARY         = $b1d1 ; Get Array Parameters
FNDARY        = $b218 ; Find Array
BSERR         = $b245 ; ?BAD SUBSCRIPT/?ILLEGAL QUANTITY
NOTFDD        = $b261 ; Create Array
INLPN2        = $b30e ; Locate Element in Array
UMULT         = $b34c ; Number of Bytes in Subscript
_FRE_         = $b37d ; Perform [fre]
GIVAYF        = $b391 ; Convert Integer in (AC/YR) to Flpt
_POS_         = $b39e ; Perform [pos]
ERRDIR        = $b3a6 ; Confirm Program Mode
_DEF_         = $b3b3 ; Perform [def]
GETFNM        = $b3e1 ; Check Syntax of FN
_FNDOER_      = $b3f4 ; Perform [fn]
_STRD_        = $b465 ; Perform [str$]
STRLIT        = $b487 ; Set Up String
PUTNW1        = $b4d5 ; Save String Descriptor
GETSPA        = $b4f4 ; Allocate Space for String
GARBAG        = $b526 ; Garbage Collection
DVARS         = $b5bd ; Search for Next String
GRBPAS        = $b606 ; Collect a String
CAT           = $b63d ; Concatenate Two Strings
MOVINS        = $b67a ; Store String in High RAM
_FRESTR_      = $b6a3 ; Perform String Housekeeping
FREFAC        = $b6db ; Clean Descriptor Stack
_CHRD_        = $b6ec ; Perform [chr$]
_LEFTD_       = $b700 ; Perform [left$]
_RIGHTD_      = $b72c ; Perform [right$]
_MIDD_        = $b737 ; Perform [mid$]
PREAM         = $b761 ; Pull sTring Parameters
_LEN_         = $b77c ; Perform [len]
LEN1          = $b782 ; Exit String Mode
_ASC_         = $b78b ; Perform [asc]
GTBYTC        = $b79b ; Evaluate Text to 1 Byte in XR
_VAL_         = $b7ad ; Perform [val]
STRVAL        = $b7b5 ; Convert ASCII String to Flpt
GETNUM        = $b7eb ; Get parameters for POKE/WAIT
GETADR        = $b7f7 ; Convert FAC#1 to Integer in LINNUM
_PEEK_        = $b80d ; Perform [peek]
_POKE_        = $b824 ; Perform [poke]
_WAIT_        = $b82d ; Perform [wait]
FADDH         = $b849 ; Add 0.5 to FAC#1
_FSUB_        = $b850 ; Perform Subtraction
FADD5         = $b862 ; Normalise Addition
_FADD_        = $b867 ; Perform Addition
NEGFAC        = $b947 ; 2s Complement FAC#1
OVERR         = $b97e ; Output ?OVERFLOW Error
MULSHF        = $b983 ; Multiply by Zero Byte
FONE          = $b9bc ; Table of Flpt Constants               DATA
_LOG_         = $b9ea ; Perform [log]
_FMULT_       = $ba28 ; Perform Multiply
MULPLY        = $ba59 ; Multiply by a Byte
CONUPK        = $ba8c ; Load FAC#2 From Memory
MULDIV        = $bab7 ; Test Both Accumulators
MLDVEX        = $bad4 ; Overflow / Underflow
MUL10         = $bae2 ; Multiply FAC#1 by 10
TENC          = $baf9 ; Constant 10 in Flpt                   DATA
DIV10         = $bafe ; Divide FAC#1 by 10
FDIV          = $bb07 ; Divide FAC#2 by Flpt at (AC/YR)
FDIVT         = $bb0f ; Divide FAC#2 by FAC#1
MOVFM         = $bba2 ; Load FAC#1 From Memory
MOV2F         = $bbc7 ; Store FAC#1 in Memory
MOVFA         = $bbfc ; Copy FAC#2 into FAC#1
MOVAF         = $bc0c ; Copy FAC#1 into FAC#2
ROUND         = $bc1b ; Round FAC#1
SIGN          = $bc2b ; Check Sign of FAC#1
_SGN_         = $bc39 ; Perform [sgn]
_ABS_         = $bc58 ; Perform [abs]
FCOMP         = $bc5b ; Compare FAC#1 With Memory
QINT          = $bc9b ; Convert FAC#1 to Integer
_INT_         = $bccc ; Perform [int]
FIN           = $bcf3 ; Convert ASCII String to a Number in FAC#1
N0999         = $bdb3 ; String Conversion Constants           DATA
INPRT         = $bdc2 ; Output 'IN' and Line Number
FOUT          = $bddd ; Convert FAC#1 to ASCII String
FOUTIM        = $be68 ; Convert TI to String
FHALF         = $bf11 ; Table of Constants                    DATA
_SQR_         = $bf71 ; Perform [sqr]
_FPWRT_       = $bf7b ; Perform power ($)
NEGOP         = $bfb4 ; Negate FAC#1
LOGEB2        = $bfbf ; Table of Constants                    DATA
_EXP_         = $bfed ; Perform [exp]
; ------------------------------------------------------------------------------------------------------------- ;
