; ------------------------------------------------------------------------------------------------------------- ;
; Complex Interface Adapter (CIA) #1 Registers - $DC00-$DC0F
; ------------------------------------------------------------------------------------------------------------- ;
CIA1              = $DC00        ; Base address
; ------------------------------------------------------------------------------------------------------------- ;
; Common Joystick Definitions
; ------------------------------------------------------------------------------------------------------------- ;
CIA_Joy_Mask_Move   = %00001111  ; Joystick Moves
CIA_JoyWas_Up       = %00001110  ; Joystick 1/2 - Up     0=pressed
CIA_JoyWas_Do       = %00001101  ; Joystick 1/2 - Down   0=pressed
CIA_JoyWas_Le       = %00001011  ; Joystick 1/2 - Left   0=pressed
CIA_JoyWas_Ri       = %00000111  ; Joystick 1/2 - Right  0=pressed
                    
CIA_Joy_Mask_All    = %00011111  ; Joystick Moves + Fire
CIA_JoyWas_Fi       = %00001111  ; Joystick 1/2 - Fire   0=pressed
                    
CIA_Joy_Up          = %00000001  ; Joystick 1/2 - Up     0=pressed
CIA_Joy_Do          = %00000010  ; Joystick 1/2 - Down   0=pressed
CIA_Joy_Le          = %00000100  ; Joystick 1/2 - Left   0=pressed
CIA_Joy_Ri          = %00001000  ; Joystick 1/2 - Right  0=pressed
CIA_Joy_Fi          = %00010000  ; Joystick 1/2 - Fire   0=pressed
; ------------------------------------------------------------------------------------------------------------- ;
CIAPRA            = [CIA1 + $00] ; Data Port Register A  Joystick #2
CIA_Joy_Pa          = %11000000  ; Paddle Set Selection Port A or B (only one bit may be active)
                                 ; 
CIA_KeySelRow_00    = %00000001  ; Keyboard Check Row Selection  Joystick #2_Up
CIA_KeySelRow_01    = %00000010  ; 0=read   this column          Joystick #2_Down
CIA_KeySelRow_02    = %00000100  ; 1=ignore this column          Joystick #2_Left
CIA_KeySelRow_03    = %00001000  ;                               Joystick #2_Right
CIA_KeySelRow_04    = %00010000  ;                               Joystick #2_Fire
CIA_KeySelRow_05    = %00100000  ; 
CIA_KeySelRow_06    = %01000000  ; 
CIA_KeySelRow_07    = %10000000  ; 
                  
__PRA             = CIAPRA             ; 
__PA0               = CIA_KeySelRow_00 ; 
__PA1               = CIA_KeySelRow_01 ; 
__PA2               = CIA_KeySelRow_02 ; 
__PA3               = CIA_KeySelRow_03 ; 
__PA4               = CIA_KeySelRow_04 ; 
__PA5               = CIA_KeySelRow_05 ; 
__PA6               = CIA_KeySelRow_06 ; 
__PA7               = CIA_KeySelRow_07 ; 

__KCOL            = CIAPRA             ; Keyboard Matrix Column Select

__JOY2            = CIAPRA             ; Joystick #2
; ------------------------------------------------------------------------------------------------------------- ;
CIAPRB            = [CIA1 + $01] ; Data Port Register B  Joystick #1
CIA_KeyResCol_00    = %00000001  ; Keyboard Check Column Result  Joystick #1_Up
CIA_KeyResCol_01    = %00000010  ; 0=pressed                     Joystick #1_Down
CIA_KeyResCol_02    = %00000100  ; 1=not pressed                 Joystick #1_Left
CIA_KeyResCol_03    = %00001000  ;                               Joystick #1_Right
CIA_KeyResCol_04    = %00010000  ;                               Joystick #1_Fire
CIA_KeyResCol_05    = %00100000  ; 
CIA_KeyResCol_06    = %01000000  ; 
CIA_KeyResCol_07    = %10000000  ; 
                                 ; 
CIA_Key_None        = %11111111  ; no key pressed
                    
CIA_OutTypeTiA      = %01000000  ; Toggle or pulse data output for Timer A - see CIACRA bit1/bit2
CIA_OutTypeTiB      = %10000000  ; Toggle or pulse data output for Timer B - see CIACRB bit1/bit2
                  
__PRB             = CIAPRA             ; 
__PB0               = CIA_KeyResCol_00 ; 
__PB1               = CIA_KeyResCol_01 ; 
__PB2               = CIA_KeyResCol_02 ; 
__PB3               = CIA_KeyResCol_03 ; 
__PB4               = CIA_KeyResCol_04 ; 
__PB5               = CIA_KeyResCol_05 ; 
__PB6               = CIA_KeyResCol_06 ; 
__PB7               = CIA_KeyResCol_07 ; 

__KROW            = CIAPRA             ; Keyboard Matrix Row Read

__JOY1            = CIAPRB             ; Joystick #1
; -------------------------------+-------------------------------------------------------------------------------- ;
                                 ;  CIDDRA/CIDDRB must be set 1st
                                 ;  Write to   Data Port A - set row bit to check=0 / row bit to ignore=1
                                 ;  Read  from Data Port B - for the checked row: the col bit of key pressed=0 
; -------------------------------+--------+--------+--------+--------+--------+--------+--------+--------+--------+
                                 ;        !  bit7  !  bit6  !  bit5  !  bit4  !  bit3  !  bit2  !  bit1  !  bit0  !
                                 ;  ------+--------+--------+--------+--------+--------+--------+--------+--------+
                                 ;  bit7  !  Stop  !   Q    !   C=   !  Space !   2    !  Ctrl  !   <-   !   1    !
                                 ;  ------+--------+--------+--------+--------+--------+--------+--------+--------+
                                 ;  bit6  !   /    !   ^    !   =    ! Shft_R !  Home  !   ;    !   *    !  LIRA  !
                                 ;  ------+--------+--------+--------+--------+--------+--------+--------+--------+
                                 ;  bit5  !   ,    !   @    !   :    !   .    !   -    !   L    !   P    !   +    !
                                 ;  ------+--------+--------+--------+--------+--------+--------+--------+--------+
                                 ;  bit4  !   N    !   O    !   K    !   M    !   0    !   J    !   I    !   9    !
                                 ;  ------+--------+--------+--------+--------+--------+--------+--------+--------+
                                 ;  bit3  !   V    !   U    !   H    !   B    !   8    !   G    !   Y    !   7    !
                                 ;  ------+--------+--------+--------+--------+--------+--------+--------+--------+
                                 ;  bit2  !   X    !   T    !   F    !   C    !   6    !   D    !   R    !   5    !
                                 ;  ------+--------+--------+--------+--------+--------+--------+--------+--------+
                                 ;  bit1  ! Shft_L !   E    !   S    !   Z    !   4    !   A    !   W    !   3    !
                                 ;  ------+--------+--------+--------+--------+--------+--------+--------+--------+
                                 ;  bit0  ! Crsr_D !   F5   !   F3   !   F1   !   F7   ! Crsr_R ! Return ! Delete !
; -------------------------------+--------+--------+--------+--------+--------+--------+--------+--------+--------+
;                                !  count !  $38   !   $30  !   $28  !   $20  !   $18  !   $10  !   $08  !   $00  !
; -------------------------------+--------+--------+--------+--------+--------+--------+--------+--------+--------+
CIA_KeyWas_Stop     = %01111111 ; row 7
CIA_KeyWas_Q        = %10111111 ; 
CIA_KeyWas_Cmdre    = %11011111 ; 
CIA_KeyWas_Space    = %11101111 ; 
CIA_KeyWas_2        = %11110111 ; 
CIA_KeyWas_Ctrl     = %11111011 ; 
CIA_KeyWas_Arrow    = %11111101 ; 
CIA_KeyWas_1        = %11111110 ; 

CIA_KeyWas_Slash    = %01111111 ; row 6
CIA_KeyWas_Carret   = %10111111 ; 
CIA_KeyWas_Equal    = %11011111 ; 
CIA_KeyWas_Shft_R   = %11101111 ; 
CIA_KeyWas_Home     = %11110111 ; 
CIA_KeyWas_SemiK    = %11111011 ; 
CIA_KeyWas_Mult     = %11111101 ; 
CIA_KeyWas_Lira     = %11111110 ; 

CIA_KeyWas_Comma    = %01111111 ; row 5
CIA_KeyWas_At       = %10111111 ; 
CIA_KeyWas_Colon    = %11011111 ; 
CIA_KeyWas_Period   = %11101111 ; 
CIA_KeyWas_Minus    = %11110111 ; 
CIA_KeyWas_L        = %11111011 ; 
CIA_KeyWas_P        = %11111101 ; 
CIA_KeyWas_Plus     = %11111110 ; 

CIA_KeyWas_N        = %01111111 ; row 4
CIA_KeyWas_O        = %10111111 ; 
CIA_KeyWas_K        = %11011111 ; 
CIA_KeyWas_M        = %11101111 ; 
CIA_KeyWas_0        = %11110111 ; 
CIA_KeyWas_J        = %11111011 ; 
CIA_KeyWas_I        = %11111101 ; 
CIA_KeyWas_9        = %11111110 ; 

CIA_KeyWas_V        = %01111111 ; row 3
CIA_KeyWas_U        = %10111111 ; 
CIA_KeyWas_H        = %11011111 ; 
CIA_KeyWas_B        = %11101111 ; 
CIA_KeyWas_8        = %11110111 ; 
CIA_KeyWas_G        = %11111011 ; 
CIA_KeyWas_Y        = %11111101 ; 
CIA_KeyWas_7        = %11111110 ; 

CIA_KeyWas_X        = %01111111 ; row 2
CIA_KeyWas_T        = %10111111 ; 
CIA_KeyWas_F        = %11011111 ; 
CIA_KeyWas_C        = %11101111 ; 
CIA_KeyWas_6        = %11110111 ; 
CIA_KeyWas_D        = %11111011 ; 
CIA_KeyWas_R        = %11111101 ; 
CIA_KeyWas_5        = %11111110 ; 

CIA_KeyWas_Shft_L   = %01111111 ; row 1
CIA_KeyWas_E        = %10111111 ; 
CIA_KeyWas_S        = %11011111 ; 
CIA_KeyWas_Z        = %11101111 ; 
CIA_KeyWas_4        = %11110111 ; 
CIA_KeyWas_A        = %11111011 ; 
CIA_KeyWas_W        = %11111101 ; 
CIA_KeyWas_3        = %11111110 ; 

CIA_KeyWas_Crsr_D   = %01111111 ; row 0
CIA_KeyWas_F5       = %10111111 ; 
CIA_KeyWas_F3       = %11011111 ; 
CIA_KeyWas_F1       = %11101111 ; 
CIA_KeyWas_F7       = %11110111 ; 
CIA_KeyWas_Crsr_R   = %11111011 ; 
CIA_KeyWas_Return   = %11111101 ; 
CIA_KeyWas_Delete   = %11111110 ; 
; ------------------------------------------------------------------------------------------------------------- ;
CIDDRA            = [CIA1 + $02] ; Data Direction Register A
                                 ;   for keybord scan set all for output ($ff=default)
                                 ;     Bit 0: Select Bit 0 of Data Port A for input or output (0=input, 1=output)
                                 ;     Bit 1: Select Bit 1 of Data Port A for input or output (0=input, 1=output)
                                 ;     Bit 2: Select Bit 2 of Data Port A for input or output (0=input, 1=output)
                                 ;     Bit 3: Select Bit 3 of Data Port A for input or output (0=input, 1=output)
                                 ;     Bit 4: Select Bit 4 of Data Port A for input or output (0=input, 1=output)
                                 ;     Bit 5: Select Bit 5 of Data Port A for input or output (0=input, 1=output)
                                 ;     Bit 6: Select Bit 6 of Data Port A for input or output (0=input, 1=output)
                                 ;     Bit 7: Select Bit 7 of Data Port A for input or output (0=input, 1=output)
CIA_PortA_Out_0     = %00000001  ; 
CIA_PortA_Out_1     = %00000010  ; 
CIA_PortA_Out_2     = %00000100  ; 
CIA_PortA_Out_3     = %00001000  ; 
CIA_PortA_Out_4     = %00010000  ; 
CIA_PortA_Out_5     = %00100000  ; 
CIA_PortA_Out_6     = %01000000  ; 
CIA_PortA_Out_7     = %10000000  ; 
                                 ; 
CIA_PortA_In_0      = %11111110  ; 
CIA_PortA_In_1      = %11111101  ; 
CIA_PortA_In_2      = %11111011  ; 
CIA_PortA_In_3      = %11110111  ; 
CIA_PortA_In_4      = %11101111  ; 
CIA_PortA_In_5      = %11011111  ; 
CIA_PortA_In_6      = %10111111  ; 
CIA_PortA_In_7      = %01111111  ; 
                  
__DDRA            = CIDDRA            ; 
__DPA0              = CIA_PortA_Out_0 ; 
__DPA1              = CIA_PortA_Out_1 ; 
__DPA2              = CIA_PortA_Out_2 ; 
__DPA3              = CIA_PortA_Out_3 ; 
__DPA4              = CIA_PortA_Out_4 ; 
__DPA5              = CIA_PortA_Out_5 ; 
__DPA6              = CIA_PortA_Out_6 ; 
__DPA7              = CIA_PortA_Out_7 ; 
; ------------------------------------------------------------------------------------------------------------- ;
CIDDRB            = [CIA1 + $03] ; Data Direction Register B
                                 ;   for keybord scan set all for input ($00=default)
                                 ;     Bit 0: Select Bit 0 of Data Port B for input or output (0=input, 1=output)
                                 ;     Bit 1: Select Bit 1 of Data Port B for input or output (0=input, 1=output)
                                 ;     Bit 2: Select Bit 2 of Data Port B for input or output (0=input, 1=output)
                                 ;     Bit 3: Select Bit 3 of Data Port B for input or output (0=input, 1=output)
                                 ;     Bit 4: Select Bit 4 of Data Port B for input or output (0=input, 1=output)
                                 ;     Bit 5: Select Bit 5 of Data Port B for input or output (0=input, 1=output)
                                 ;     Bit 6: Select Bit 6 of Data Port B for input or output (0=input, 1=output)
                                 ;     Bit 7: Select Bit 7 of Data Port B for input or output (0=input, 1=output)
CIA_PortB_Out_0     = %00000001  ; 
CIA_PortB_Out_1     = %00000010  ; 
CIA_PortB_Out_2     = %00000100  ; 
CIA_PortB_Out_3     = %00001000  ; 
CIA_PortB_Out_4     = %00010000  ; 
CIA_PortB_Out_5     = %00100000  ; 
CIA_PortB_Out_6     = %01000000  ; 
CIA_PortB_Out_7     = %10000000  ; 
                                 ; 
CIA_PortB_In_0      = %11111110  ; 
CIA_PortB_In_1      = %11111101  ; 
CIA_PortB_In_2      = %11111011  ; 
CIA_PortB_In_3      = %11110111  ; 
CIA_PortB_In_4      = %11101111  ; 
CIA_PortB_In_5      = %11011111  ; 
CIA_PortB_In_6      = %10111111  ; 
CIA_PortB_In_7      = %01111111  ; 
                  
__DDRB            = CIDDRA            ; 
__DPB0              = CIA_PortB_Out_0 ; 
__DPB1              = CIA_PortB_Out_1 ; 
__DPB2              = CIA_PortB_Out_2 ; 
__DPB3              = CIA_PortB_Out_3 ; 
__DPB4              = CIA_PortB_Out_4 ; 
__DPB5              = CIA_PortB_Out_5 ; 
__DPB6              = CIA_PortB_Out_6 ; 
__DPB7              = CIA_PortB_Out_7 ; 
; ------------------------------------------------------------------------------------------------------------- ;
TIMALO            = [CIA1 + $04] ; Timer A (low byte)  : TIME = LATCH VALUE / CLOCK SPEED
                                 ;   Read : Current State of Timer A
                                 ;   Write: Value to be loaded (latch) at next start of Timer A
                                 ;
                                 ;   LATCH VALUE = TIMER LOW + 256 * TIMER HIGH
                                 ;   CLOCK SPEED = 1,022,370 cycles per second for NTSC monitors
                                 ;               =   985,250 cycles per second for PAL  monitors
                  
__TAL             = TIMALO       ; 
; ------------------------------------------------------------------------------------------------------------- ;
TIMAHI            = [CIA1 + $05] ; Timer A (high byte) : TIME = LATCH VALUE / CLOCK SPEED
                                 ;   Read : Current State of Timer A
                                 ;   Write: Value to be loaded (latch) at next start of Timer A
                  
__TAH             = TIMAHI       ; 
; ------------------------------------------------------------------------------------------------------------- ;
TIMBLO            = [CIA1 + $06] ; Timer B (low byte)  : TIME = LATCH VALUE / CLOCK SPEED
                                 ;   Read : Current State of Timer B
                                 ;   Write: Value to be loaded (latch) at next start of Timer B
                  
__TBL             = TIMBLO       ; 
; ------------------------------------------------------------------------------------------------------------- ;
TIMBHI            = [CIA1 + $07] ; Timer B (high byte) : TIME = LATCH VALUE / CLOCK SPEED
                                 ;   Read : Current State of Timer B
                                 ;   Write: Value to be loaded (latch) at next start of Timer B
                  
__TBH             = TIMBHI       ; 
; ------------------------------------------------------------------------------------------------------------- ;
; The ToD clock registers stop update the registers (latch) as soon as the HOURS register is read/written
; The ToD clock continues to keep time internally
; The ToD clock starts updating the registers again when the TENTHS of seconds register is read
; 
; If MINUTES or SECONDS or TENTHS are read/written no latching will occur
; 
; ==> Anytime HOURS are read/written a read/write of TENTHS must follow 
;     or else the registers will not continue to update
; ------------------------------------------------------------------------------------------------------------- ;
TODTEN            = [CIA1 + $08] ; Time of Day Clock Tenths of Seconds
                              ;   Bits 0-3: Time of Day tenths of second digit (BCD)
                              ;   Bits 4-7: Unused
                  
__10THS           = TODTEN       ; 
; ------------------------------------------------------------------------------------------------------------- ;
TODSEC            = [CIA1 + $09] ; Time of Day Clock Seconds
                                 ;   Bits 0-3: Second digit of Time of Day seconds (BCD)
                                 ;   Bits 4-6: First digit of Time of Day seconds  (BCD)
                                 ;   Bit    7: Unused
                  
__SEC             = TODSEC       ; 
; ------------------------------------------------------------------------------------------------------------- ;
TODMIN            = [CIA1 + $0a] ; Time of Day Clock Minutes
                                 ;   Bits 0-3: Second digit of Time of Day minutes (BCD)
                                 ;   Bits 4-6: First digit of Time of Day minutes (BCD)
                                 ;   Bit    7: Unused
                  
__MIN             = TODMIN       ; 
; ------------------------------------------------------------------------------------------------------------- ;
TODHRS            = [CIA1 + $0b] ; Time of Day Clock Hours
                                 ;   Bits 0-3: Second digit of Time of Day hours (BCD)
                                 ;   Bit    4: First digit of Time of Day hours (BCD)
                                 ;   Bits 5-6: Unused
                                 ;   Bit    7: AM/PM Flag (1=PM, 0=AM)
                  
__HR              = TODHRS       ; 
; ------------------------------------------------------------------------------------------------------------- ;
CIASDR            = [CIA1 + $0c] ; Serial Data Port
                  
__SDR             = CIASDR       ; 
; ------------------------------------------------------------------------------------------------------------- ;
CIAICR            = [CIA1 + $0d] ; Interrupt Control Register
CIA_IntData          = %00011111 ;        Read : Origin of the Interrupt
CIA_IntDataTiA       = %00000001 ;   Bit0 Read : Underflow Timer A
CIA_IntDataTiB       = %00000010 ;   Bit1 Read : Underflow Timer B
CIA_IntDataAlarm     = %00000100 ;   Bit2 Read : ToD equal Alarm Time
CIA_IntDataSDR       = %00001000 ;   Bit3 Read : SDR full or empty (full byte transferred depending of serial busoperating mode)
CIA_IntDataFlag      = %00010000 ;   Bit4 Read : IRQ Signal occured at FLAG-pin (Cassette port Data input / Serial bus SRQ IN)
                                 ;   Bit5 Read : always 0
                                 ;   Bit6 Read : always 0
CIA_IntDataIRQ       = %10000000 ;   Bit7 Read : An interrupt occured (At least one bit of INT MASK / INT DATA is set)
                                 ; 
CIA_IntMask          = %00011111 ;        Write: Interrupt mask
CIA_IntMaskTiA       = %00000001 ;   Bit0 Write: Interrupt release through timer A underflow
CIA_IntMaskTiB       = %00000010 ;   Bit1 Write: Interrupt release through timer B underflow
CIA_IntMaskAlarm     = %00000100 ;   Bit2 Write: Interrupt release if Tod equal Alarm Time
CIA_IntMaskSDR       = %00001000 ;   Bit3 Write: Interrupt release if a complete byte has been received/sent
CIA_IntMaskFlag      = %00010000 ;   Bit4 Write: Interrupt release if a positive slope occurs at the FLAG-Pin
                                 ;   Bit5 Write: always 0
                                 ;   Bit6 Write: always 0
CIA_IntMaskSRC       = %10000000 ;   Bit7 Write: Interrupt source
                                 ;             : 0 = Set a Bit0..4 -> CLEAR the according mask bit
                                 ;             : 1 = Set a Bit0..4 -> SET   the according mask bit
                                 ; 
                                 ;   Bit 0:  Read : did Timer A count down to 0? ...................... (1=yes)
                                 ;           Write: enable or disable Timer A interrupt ............... (1=enable, 0=disable)
                                 ;   Bit 1:  Read : did Timer B count down to 0? ...................... (1=yes)
                                 ;           Write: enable or disable Timer B interrupt ............... (1=enable, 0=disable)
                                 ;   Bit 2:  Read : did Time of Day Clock reach the alarm time? ....... (1=yes)
                                 ;           Write: enable or disable TOD clock alarm interrupt ....... (1=enable, 0=disable)
                                 ;   Bit 3:  Read : did the serial shift register finish a byte? ...... (1=yes)
                                 ;           Write: enable or disable serial shift register interrupt . (1=enable, 0=disable)
                                 ;   Bit 4:  Read : was a signal sent on the FLAG line? ............... (1=yes)
                                 ;                : FLAG-pin: Cassette port Data input / Serial bus SRQ IN
                                 ;           Write: enable or disable FLAG line interrupt ............. (1=enable, 0=disable)
                                 ;   Bit 5:  Unused
                                 ;   Bit 6:  Unused
                                 ;   Bit 7:  Read  - did any CIA #1 source cause an interrupt? ........ (1=yes)
                                 ;           Write - set or clear bits of this register         
                                 ;             (1=bits written with 1 will be set, 0=bits written with 1 will be cleared)
                  
__ICR             = CIAICR             ; 
__TA                = CIA_IntDataTiA   ; 
__TB                = CIA_IntDataTiB   ; 
__ALARM             = CIA_IntDataAlarm ; 
__SP                = CIA_IntDataSDR   ; 
__FLAG              = CIA_IntDataFlag  ; 
__IR                = CIA_IntDataIRQ   ; 
__SC                = CIA_IntMaskSRC   ; 
; ------------------------------------------------------------------------------------------------------------- ;
CIACRA            = [CIA1 + $0e] ; Control Register A
CIA_TiA_Start       = %00000001  ;   Bit 0:  Start Timer A ........................ (1=start, 0=stop)
CIA_TiA_PB6_On      = %00000010  ;   Bit 1:  Select Timer A output on Port B ...... (1=Timer A output appears on Bit 6 of Port B)
CIA_TiA_OutMode     = %00000100  ;   Bit 2:  Port B output mode ................... (1=toggle Bit 6, 0=pulse Bit 6 for one cycle)
CIA_TiA_RunMode     = %00001000  ;   Bit 3:  Timer A run mode ..................... (1=one-shot, 0=continuous)
CIA_TiA_Load        = %00010000  ;   Bit 4:  Load latched value into Timer A once . (1=force load strobe)
CIA_TiA_InMode      = %00100000  ;   Bit 5:  Timer A input mode ................... (1=count microprocessor cycles)
                                 ;                                                  (0=count signals on CNT line at pin 4 of User Port)  
CIA_SerSerMode      = %01000000  ;   Bit 6:  Serial Port (56332, $DC0C) mode ...... (1=output, 0=input)
CIA_ToD_In          = %10000000  ;   Bit 7:  Time of Day Clock frequency .......... (1=50 Hz required on TOD pin)
                  
__CRA             = CIACRA            ; 
__CASTART           = CIA_TiA_Start   ; 
__CAPB6ON           = CIA_TiA_PB6_On  ; 
__CAOUTMODE         = CIA_TiA_OutMode ; 
__CARUNMODE         = CIA_TiA_RunMode ; 
__CALOAD            = CIA_TiA_Load    ; 
__CAINMODE          = CIA_TiA_InMode  ; 
__CASPMODE          = CIA_SerSerMode  ; 
__CATODIN           = CIA_ToD_In      ; 
; ------------------CIA_TOD_Freq    ------------------------------------------------------------------------------------------- ;
CIACRB            = [CIA1 + $0f] ; Control Register B
CIA_TiB_Start       = %00000001  ;   Bit    0: Start Timer B ........................ (1=start, 0=stop)
CIA_TiB_PB7_On      = %00000010  ;   Bit    1: Select Timer B output on Port B ...... (1=Timer B output appears on Bit 7 of Port B)
CIA_TiB_OutMode     = %00000100  ;   Bit    2: Port B output mode ................... (1=toggle Bit 7, 0=pulse Bit 7 for one cycle)
CIA_TiB_RunMode     = %00001000  ;   Bit    3: Timer B run mode ..................... (1=one-shot, 0=continuous)
CIA_TiB_Load        = %00010000  ;   Bit    4: Load latched value into Timer A once . (1=force load strobe)
CIA_TiB_InMode      = %01100000  ;   Bits 5-6: Timer B input mode
                                 ;               00 = Timer B counts microprocessor cycles
                                 ;               01 = Count signals on CNT line at pin 4 of User Port
                                 ;               10 = Count underflows Timer A (count down to zero)
                                 ;               11 = Count underflows Timer A if CNT-pin is high
CIA_TiB_Alarm       = %10000000  ;   Bit    7: Select Time of Day write
                                 ;               0=writing into the TOD register sets the clock time
                                 ;               1=writing into the TOD register sets the alarm time
                  
__CRB             = CIACRB            ; 
__CBSTART           = CIA_TiB_Start   ; 
__CBPB7ON           = CIA_TiB_PB7_On  ; 
__CBOUTMODE         = CIA_TiB_OutMode ; 
__CBRUNMODE         = CIA_TiB_RunMode ; 
__CBLOAD            = CIA_TiB_Load    ; 
__CBINMODE          = CIA_TiB_InMode  ; 
__CBALARM           = CIA_TiB_Alarm   ; 
; ------------------------------------------------------------------------------------------------------------- ;
; $DC10-$DCFF   ; CIA #1 Register Images - Mirror of $DC00-$DC0F
; ------------------------------------------------------------------------------------------------------------- ;
