; ------------------------------------------------------------------------------------------------------------- ;
; C64 Colour RAM - Only the low nybble of each Color RAM location is connected
;                  Writing to the high nybble has no effect
;                  Read    of the high nybble usually returns random values
;                          should be masked out with AND #$0f
; ------------------------------------------------------------------------------------------------------------- ;
COLORAM           = $D800                         ; $D800-$DBFF
COLORAM_MCM_On      = %00001000                   ; set bit3 for MCM colors - colors reduced to $00-$07
COLORAM_MCM_Off     = $11110111                   ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Simple colors
; ------------------------------------------------------------------------------------------------------------- ;
BLACK               = $00
WHITE               = $01
RED                 = $02
CYAN                = $03
PURPLE              = $04
GREEN               = $05
BLUE                = $06
YELLOW              = $07
ORANGE              = $08
BROWN               = $09
LT_RED              = $0a
DK_GREY             = $0b
GREY                = $0c
LT_GREEN            = $0d
LT_BLUE             = $0e
LT_GREY             = $0f
; ------------------------------------------------------------------------------------------------------------- ;
; HiRes color combinations
; ------------------------------------------------------------------------------------------------------------- ;
HR_BlackBlack       = $00
HR_BlackWhite       = $01
HR_BlackRed         = $02
HR_BlackCyan        = $03
HR_BlackPurple      = $04
HR_BlackGreen       = $05
HR_BlackBlue        = $06
HR_BlackYellow      = $07
HR_BlackOrange      = $08
HR_BlackBrown       = $09
HR_BlackLtRed       = $0a
HR_BlackDkGrey      = $0b
HR_BlackGrey        = $0c
HR_BlackLtGreen     = $0d
HR_BlackLtBlue      = $0e
HR_BlackLtGrey      = $0f
; ------------------------------------------------------------------------------------------------------------- ;
HR_WhiteBlack       = $10
HR_WhiteWhite       = $11
HR_WhiteRed         = $12
HR_WhiteCyan        = $13
HR_WhitePurple      = $14
HR_WhiteGreen       = $15
HR_WhiteBlue        = $16
HR_WhiteYellow      = $17
HR_WhiteOrange      = $18
HR_WhiteBrown       = $19
HR_WhiteLtRed       = $1a
HR_WhiteDkGrey      = $1b
HR_WhiteGrey        = $1c
HR_WhiteLtGreen     = $1d
HR_WhiteLtBlue      = $1e
HR_WhiteLtGrey      = $1f
; ------------------------------------------------------------------------------------------------------------- ;
HR_RedBlack         = $20
HR_RedWhite         = $21
HR_RedRed           = $22
HR_RedCyan          = $23
HR_RedPurple        = $24
HR_RedGreen         = $25
HR_RedBlue          = $26
HR_RedYellow        = $27
HR_RedOrange        = $28
HR_RedBrown         = $29
HR_RedLtRed         = $2a
HR_RedDkGrey        = $2b
HR_RedGrey          = $2c
HR_RedLtGreen       = $2d
HR_RedLtBlue        = $2e
HR_RedLtGrey        = $2f
; ------------------------------------------------------------------------------------------------------------- ;
HR_CyanBlack        = $30
HR_CyanWhite        = $31
HR_CyanRed          = $32
HR_CyanCyan         = $33
HR_CyanPurple       = $34
HR_CyanGreen        = $35
HR_CyanBlue         = $36
HR_CyanYellow       = $37
HR_CyanOrange       = $38
HR_CyanBrown        = $39
HR_CyanLtRed        = $3a
HR_CyanDkGrey       = $3b
HR_CyanGrey         = $3c
HR_CyanLtGreen      = $3d
HR_CyanLtBlue       = $3e
HR_CyanLtGrey       = $3f
; ------------------------------------------------------------------------------------------------------------- ;
HR_PurpleBlack      = $40
HR_PurpleWhite      = $41
HR_PurpleRed        = $42
HR_PurpleCyan       = $43
HR_PurplePurple     = $44
HR_PurpleGreen      = $45
HR_PurpleBlue       = $46
HR_PurpleYellow     = $47
HR_PurpleOrange     = $48
HR_PurpleBrown      = $49
HR_PurpleLtRed      = $4a
HR_PurpleDkGrey     = $4b
HR_PurpleGrey       = $4c
HR_PurpleLtGreen    = $4d
HR_PurpleLtBlue     = $4e
HR_PurpleLtGrey     = $4f
; ------------------------------------------------------------------------------------------------------------- ;
HR_GreenBlack       = $50
HR_GreenWhite       = $51
HR_GreenRed         = $52
HR_GreenCyan        = $53
HR_GreenPurple      = $54
HR_GreenGreen       = $55
HR_GreenBlue        = $56
HR_GreenYellow      = $57
HR_GreenOrange      = $58
HR_GreenBrown       = $59
HR_GreenLtRed       = $5a
HR_GreenDkGrey      = $5b
HR_GreenGrey        = $5c
HR_GreenLtGreen     = $5d
HR_GreenLtBlue      = $5e
HR_GreenLtGrey      = $5f
; ------------------------------------------------------------------------------------------------------------- ;
HR_BlueBlack        = $60
HR_BlueWhite        = $61
HR_BlueRed          = $62
HR_BlueCyan         = $63
HR_BluePurple       = $64
HR_BlueGreen        = $65
HR_BlueBlue         = $66
HR_BlueYellow       = $67
HR_BlueOrange       = $68
HR_BlueBrown        = $69
HR_BlueLtRed        = $6a
HR_BlueDkGrey       = $6b
HR_BlueGrey         = $6c
HR_BlueLtGreen      = $6d
HR_BlueLtBlue       = $6e
HR_BlueLtGrey       = $6f
; ------------------------------------------------------------------------------------------------------------- ;
HR_YellowBlack      = $70
HR_YellowWhite      = $71
HR_YellowRed        = $72
HR_YellowCyan       = $73
HR_YellowPurple     = $74
HR_YellowGreen      = $75
HR_YellowBlue       = $76
HR_YellowYellow     = $77
HR_YellowOrange     = $78
HR_YellowBrown      = $79
HR_YellowLtRed      = $7a
HR_YellowDkGrey     = $7b
HR_YellowGrey       = $7c
HR_YellowLtGreen    = $7d
HR_YellowLtBlue     = $7e
HR_YellowLtGrey     = $7f
; ------------------------------------------------------------------------------------------------------------- ;
HR_OrangeBlack      = $80
HR_OrangeWhite      = $81
HR_OrangeRed        = $82
HR_OrangeCyan       = $83
HR_OrangePurple     = $84
HR_OrangeGreen      = $85
HR_OrangeBlue       = $86
HR_OrangeYellow     = $87
HR_OrangeOrange     = $88
HR_OrangeBrown      = $89
HR_OrangeLtRed      = $8a
HR_OrangeDkGrey     = $8b
HR_OrangeGrey       = $8c
HR_OrangeLtGreen    = $8d
HR_OrangeLtBlue     = $8e
HR_OrangeLtGrey     = $8f
; ------------------------------------------------------------------------------------------------------------- ;
HR_BrownBlack       = $90
HR_BrownWhite       = $91
HR_BrownRed         = $92
HR_BrownCyan        = $93
HR_BrownPurple      = $94
HR_BrownGreen       = $95
HR_BrownBlue        = $96
HR_BrownYellow      = $97
HR_BrownOrange      = $98
HR_BrownBrown       = $99
HR_BrownLtRed       = $9a
HR_BrownDkGrey      = $9b
HR_BrownGrey        = $9c
HR_BrownLtGreen     = $9d
HR_BrownLtBlue      = $9e
HR_BrownLtGrey      = $9f
; ------------------------------------------------------------------------------------------------------------- ;
HR_LtRedBlack       = $a0
HR_LtRedWhite       = $a1
HR_LtRedRed         = $a2
HR_LtRedCyan        = $a3
HR_LtRedPurple      = $a4
HR_LtRedGreen       = $a5
HR_LtRedBlue        = $a6
HR_LtRedYellow      = $a7
HR_LtRedOrange      = $a8
HR_LtRedBrown       = $a9
HR_LtRedLtRed       = $aa
HR_LtRedDkGrey      = $ab
HR_LtRedGrey        = $ac
HR_LtRedLtGreen     = $ad
HR_LtRedLtBlue      = $ae
HR_LtRedLtGrey      = $af
; ------------------------------------------------------------------------------------------------------------- ;
HR_DkGreyBlack      = $b0
HR_DkGreyWhite      = $b1
HR_DkGreyRed        = $b2
HR_DkGreyCyan       = $b3
HR_DkGreyPurple     = $b4
HR_DkGreyGreen      = $b5
HR_DkGreyBlue       = $b6
HR_DkGreyYellow     = $b7
HR_DkGreyOrange     = $b8
HR_DkGreyBrown      = $b9
HR_DkGreyLtRed      = $ba
HR_DkGreyDkGrey     = $bb
HR_DkGreyGrey       = $bc
HR_DkGreyLtGreen    = $bd
HR_DkGreyLtBlue     = $be
HR_DkGreyLtGrey     = $bf
; ------------------------------------------------------------------------------------------------------------- ;
HR_GreyBlack        = $c0
HR_GreyWhite        = $c1
HR_GreyRed          = $c2
HR_GreyCyan         = $c3
HR_GreyPurple       = $c4
HR_GreyGreen        = $c5
HR_GreyBlue         = $c6
HR_GreyYellow       = $c7
HR_GreyOrange       = $c8
HR_GreyBrown        = $c9
HR_GreyLtRed        = $ca
HR_GreyDkGrey       = $cb
HR_GreyGrey         = $cc
HR_GreyLtGreen      = $cd
HR_GreyLtBlue       = $ce
HR_GreyLtGrey       = $cf
; ------------------------------------------------------------------------------------------------------------- ;
HR_LtGreenBlack     = $d0
HR_LtGreenWhite     = $d1
HR_LtGreenRed       = $d2
HR_LtGreenCyan      = $d3
HR_LtGreenPurple    = $d4
HR_LtGreenGreen     = $d5
HR_LtGreenBlue      = $d6
HR_LtGreenYellow    = $d7
HR_LtGreenOrange    = $d8
HR_LtGreenBrown     = $d9
HR_LtGreenLtRed     = $da
HR_LtGreenDkGrey    = $db
HR_LtGreenGrey      = $dc
HR_LtGreenLtGreen   = $dd
HR_LtGreenLtBlue    = $de
HR_LtGreenLtGrey    = $df
; ------------------------------------------------------------------------------------------------------------- ;
HR_LtBlueBlack      = $e0
HR_LtBlueWhite      = $e1
HR_LtBlueRed        = $e2
HR_LtBlueCyan       = $e3
HR_LtBluePurple     = $e4
HR_LtBlueGreen      = $e5
HR_LtBlueBlue       = $e6
HR_LtBlueYellow     = $e7
HR_LtBlueOrange     = $e8
HR_LtBlueBrown      = $e9
HR_LtBlueLtRed      = $ea
HR_LtBlueDkGrey     = $eb
HR_LtBlueGrey       = $ec
HR_LtBlueLtGreen    = $ed
HR_LtBlueLtBlue     = $ee
HR_LtBlueLtGrey     = $ef
; ------------------------------------------------------------------------------------------------------------- ;
HR_LtGreyBlack      = $f0
HR_LtGreyWhite      = $f1
HR_LtGreyRed        = $f2
HR_LtGreyCyan       = $f3
HR_LtGreyPurple     = $f4
HR_LtGreyGreen      = $f5
HR_LtGreyBlue       = $f6
HR_LtGreyYellow     = $f7
HR_LtGreyOrange     = $f8
HR_LtGreyBrown      = $f9
HR_LtGreyLtRed      = $fa
HR_LtGreyDkGrey     = $fb
HR_LtGreyGrey       = $fc
HR_LtGreyLtGreen    = $fd
HR_LtGreyLtBlue     = $fe
HR_LtGreyLtGrey     = $ff
; ------------------------------------------------------------------------------------------------------------- ;
