; ------------------------------------------------------------------------------------------------------------- ;
; Kernal ROM ($e000 - $fFFF)
; ------------------------------------------------------------------------------------------------------------- ;
KERNAL_ROM    = $e000 ; start address
; ------------------------------------------------------------------------------------------------------------- ;
STOLD         = $e000 ; Perform [exp] - continued from BASIC ROM
POLYX         = $e043 ; Function Series Evaluation Subroutines
POLY          = $e059 ; Function Series Evaluation Subroutine 2
RMULC         = $e08d ; Multiplicative Constant for RND
RADDC         = $e092 ; Additive Constant for RND
RND           = $e097 ; Basic: Perform RND
BIOERR        = $e0f9 ; Handle I/O Error in BASIC
QSETNR        = $e0be ; Random number - argument positive
RND1          = $e0d3 ; Random number - argument negative
BCHOUT        = $e10c ; Output Character
EBSOUT        = $e10c ; Output Character
BCHIN         = $e112 ; Input Character
EBASIN        = $e112 ; Input Character
BCKOUT        = $e118 ; Set Up For Output
ECKOUT        = $e118 ; Set Up For Output
BCKIN         = $e11e ; Set Up For Input
ECHKIN        = $e11e ; Set Up For Input
BGETIN        = $e124 ; Get One Character
CSYS          = $e12a ; Perform [sys]
CSAVE         = $e156 ; Perform [save]
CVERFY        = $e165 ; Perform [verify]
CLOAD         = $e168 ; Perform [load]
COPEN         = $e1be ; Perform [open]
CCLOSE        = $e1c7 ; Perform [close]
PLSV          = $e1d4 ; Set Parameters for LOAD, VERIFY, and SAVE
COMBYT        = $e200 ; Skip Comma and Get Integer in .X
DEFLT         = $e206 ; Fetch Current Character and Check for End of Line
CMMERR        = $e20e ; Check for Comma - last char in .A - otherwise print error text
OCPARA        = $e219 ; Set Parameters for OPEN and CLOSE
COS           = $e264 ; Perform COS
SIN           = $e268 ; Perform SIN
TAN           = $e2b4 ; Perform TAN
PI2           = $e2e0 ; 1.570796327   Five-Byte Floating Point Representation of the Constant PI/2
TWOPI         = $e2e5 ; 6.28318531    Five-Byte Floating Point Representation of the Constant 2*PI
FR4           = $e2ea ; 0.25          Five-Byte Floating Point Representation of the Constant 1/4
SINCON        = $e2ef ; #05 (counter) Table of Constants for Evaluation of SIN, COS, and TAN
SINCO1        = $e2f0 ; -14.3813907
SINCO2        = $e2f5 ; 42.0077971
SINCO3        = $e2fa ; -76.7041703
SINCO4        = $e2ff ; 81.6052237
SINCO5        = $e304 ; -41.3417021
SINCO6        = $e309 ; 6.28318531
ATN           = $e30e ; Perform ATN
ATNCON        = $e33e ; #0b (counter) Table of Constants for ATN Evaluation
ATNCO1        = $e3ef ; -0.000684793912
ATNCO2        = $e344 ;  0.00485094216
ATNCO3        = $e349 ; -0.161117018
ATNCO4        = $e34e ;  0.034209638
ATNCO5        = $e353 ; -0.0542791328
ATNCO6        = $e358 ;  0.0724571965
ATNCO7        = $e35d ; -0.0898023954
ATNCO8        = $e362 ;  0.110932413
ATNCO9        = $e367 ; -0.142839808
ATNCOA        = $e36c ;  0.19999912
ATNCOB        = $e371 ; -0.333333316
ATNCOC        = $e376 ;  1.00
BASSFT        = $e37b ; BASIC Warm Start [RUNSTOP-RESTORE]
MSGRDY        = $e386 ; Output: 'ready' - Ready-Status
NERROR        = $e38b ; Error Message Handler
INIT          = $e394 ; BASIC Cold Start
INITAT        = $e3a2 ; CHRGET For Zero-page
RNDSED        = $e3ba ; RND Seed For zero-page                DATA
INITAT        = $e3a2 ; Text of the CHRGET Routine Which Runs at 115 ($73)
RSEED         = $e3ba ; Initial RND Seed Value
INITCZ        = $e3bf ; Initialize BASIC
INITMS        = $e422 ; Print BASIC Start-Up Messages
BVTRS         = $e447 ; Table of BASIC Vectors (for 0300)
_NERROR       = $e447 ; $938b - Error-Routine
_NMAIN        = $e449 ; $a483 - Main Routine BASIC-Interpreter
_NCRNCH       = $e44b ; $a57c - Convert Text to BASIC-Token
_NQPLOP       = $e44d ; $a71a - List Line - Converrt BASIC-Tokens
_NGONE        = $e44f ; $a794 - Evaluate Token - Call BASIC-Routine
_NEVAL        = $e451 ; $ae86 - Evauate Next Expression
INITV	        = $e453 ; Copy BASIC Vectors to RAM
WORDS         = $e460 ; Power-Up Messages
SIGNON        = $e473 ; Message Texts after Power On/Reset - '   **** commodore 64 basic v2 ****' ...
PATCH6        = $e4ad ; Patch for BASIC Call of CHKOUT
;             = $e4b7 ; 35 ($23) Unused Bytes (all have the value of 170 ($AA)
CPATCH        = $e4da ; Clear Color RAM to the Color in Background Color Register 0
FPATCH        = $e4e0 ; Wait 8.5sec for C= key after finding a file on cassette
BAUDOP        = $e4ec ; Baud Rate Timer Constants Table for RS-232
; ------------------------------------------------------------------------------------------------------------- ;
; kernal routines
; ------------------------------------------------------------------------------------------------------------- ;
_IOBASE       = $e500 ; Get I/O Address
_SCREEN       = $e505 ; Get Screen Size
_PLOT         = $e50a ; Carry=1: Get Row (.Y) and Column (.X) / Carry=0: Put Row (.Y) and Column (.X)
_CINT1        = $e518 ; Initialize Screen and Keyboard
CLRSCR        = $e544 ; Clear Screen
HOME          = $e566 ; Home Cursor
STUPT         = $e56c ; Set Screen Pointers (address actual cursor line to pnt)
XINICT        = $e59a ; Set I/O Defaults (Unused Entry)
PANIC         = $e5a0 ; NMI-Vector: Set I/O Defaults/Init VIC
_LP2          = $e5b4 ; Get Character From Keyboard Buffer
CKINKB        = $e5ca ; Input From Keyboard
CKINSCR       = $e632 ; Input From Screen or Keyboard
QTSWC         = $e684 ; Quotes Test
CKOUTSCR      = $e691 ; Set Up Screen Print
CURFORW       = $e6b6 ; Advance Cursor
CURBACK       = $e6ed ; Retreat Cursor
BACKPREV      = $e701 ; Back on to Previous Line
PRTSCN        = $e716 ; Output in .A to Screen
CKCCNS        = $e72a ; Handle Unshifted Control Characters
CKCCSH        = $e7d4 ; Handle Shifted Control Characters
NXTLN         = $e87c ; Go to Next Line
OUTCHR        = $e891 ; Output <CR>
CHKBAK        = $e8a1 ; Check Line Decrement
CHKDWN        = $e8b3 ; Check Line Increment
CHKCOL        = $e8cb ; Set Colour Code
COLTAB        = $e8da ; Colour Code Table
SCROL         = $e8ea ; Scroll Screen
NEWLIN        = $e965 ; Open A Space On The Screen - Insert a Continued Line
SCRLIN        = $e9c8 ; Move A Screen Line
TOFROM        = $e9e0 ; Syncronise Colour Transfer
SETLIN        = $e9f0 ; Set Start of Line
CLRLN         = $e9ff ; Clear Screen Line
DSPP          = $ea13 ; Print To Screen
SCOLOR        = $ea24 ; Syncronise Colour Pointer
_IRQ_MAIN     = $ea31 ; Main IRQ Entry Point
_SCNKEY       = $ea87 ; Scan Keyboard
JKEYLOG       = $eadd ; Process Key Image - JMP (KEYLOG) Vector: Routine to determine Keyboard table to use based on Shift Key Pattern ($EB48)
SHFLOG        = $eb48 ; Evaluate 'SHIFT' 'CTRL' 'CBM' keys / Init keyboard decode table
KEYCOD        = $eb79 ; Pointers to Keyboard decoding tables  WORD
MODE1         = $eb81 ; Keyboard 1 -- unshifted               DATA
MODE2         = $ebc2 ; Keyboard 2 -- Shifted                 DATA
MODE3         = $ec03 ; Keyboard 3 -- Commodore               DATA
LOWER         = $ec44 ; Graphics/Text Control - Lower Case    DATA
UPPER         = $ec4f ; Graphics/Text Control - Upper Case    DATA
MODE4         = $ec78 ; Keyboard 4 -- Control                 DATA
TVIC          = $ecb9 ; Video Chip Setup Table                DATA
RUNTB         = $ece7 ; Shift-Run Equivalent                  DATA
LDTB2         = $ecf0 ; Low Byte Screen Line Addresses        DATA
_TALK         = $ed09 ; Send TALK Command on Serial Bus
_LISTEN       = $ed0c ; Send LISTEN Command on Serial Bus
ISOUR         = $ed40 ; Send Data On Serial Bus
NODEV         = $edad ; Flag Errors: Status #80 - device not present
FRMERR        = $edb0 ; Flag Errors: Status #03 - write timeout
_SECOND       = $edb9 ; Send LISTEN Secondary Address
SCATN         = $edbe ; Clear ATN
_TKSA         = $edc7 ; Send TALK Secondary Address
TKATN         = $edcc ; Wait For Clock
_CIOUT        = $eddd ; Send Serial Deferred
_UNTLK        = $edef ; Send UNTALK
_UNLSN        = $edfe ; Send UNLISTEN
_ACPTR        = $ee13 ; Receive From Serial Bus
SCLKHI        = $ee85 ; Serial Clock On
SCLKLO        = $ee8e ; Serial Clock Off
SDATHI        = $ee97 ; Serial Output 1
SDATLO        = $eea0 ; Serial Output 0
DEBPIA        = $eea9 ; Get Serial Data And Clock In
W1MS          = $eeb3 ; Delay 1 ms
RSTRAB        = $eebb ; RS-232 Send
RSTBGN        = $ef06 ; Send New RS-232 Byte
DSRERR        = $ef2e ; 'No DSR' (Data Set Ready) Error
CTSERR        = $ef31 ; 'No CTS' (Clear To Send)  Error
RSODNE        = $ef39 ; Disable Timer
BITCNT        = $ef4a ; Compute Bit Count
RSRCVR        = $ef59 ; RS-232 Receive
RSRABL        = $ef7e ; Set Up To Receive
RSRTRT        = $ef90 ; Process RS-232 Byte
XRSR1         = $efc7 ; Parity error on Receive
RECERR        = $efca ; Receive Buffer Full Error
BREAKE        = $efcd ; Flag Errors: Status #80 - break at receive
FRAMEE        = $edb0 ; Flag Errors: Status #02 - receive error
CKO232        = $efe1 ; Submit to RS-232
CKDSRX        = $f00d ; Flag Errors: Status #40 - No DSR (Data Set Ready) Error
BSO232        = $f017 ; Send to RS-232 Buffer
CKI232        = $f04d ; Input From RS-232
BSI232        = $f086 ; Get From RS-232
RSP232        = $f0a4 ; Serial Bus Idle
MS1           = $f0bd ; Table of Kernal I/O Messages          DATA
SPMSG         = $f12b ; Test Error Flag (pgm=$00 / direct=$80) - Print System Message if Direct
MSG           = $f12f ; Print Message
_GETIN        = $f13e ; Get a byte
_CHRIN        = $f157 ; Input a byte
JTGET         = $f199 ; Get From Tape / Serial / RS-232
_CHROUT       = $f1ca ; Output One Character
_CHKIN        = $f20e ; Set Input Device
_CHKOUT       = $f250 ; Set Output Device
_CLOSE        = $f291 ; Close File
FLOOKUP       = $f30f ; Find File
SETFVAL       = $f31f ; Set File values (LA, FA, SA via x-indirect from File Table to Zeropage)
_CLALL        = $f32f ; Abort All Files
_CLRCH        = $f333 ; Restore Default I/O
_OPEN         = $f34a ; Open File
opensa        = $f3d5 ; Send Secondary Address / Send Name
opn232        = $f409 ; Open RS-232
memtcf        = $f47d ; Set new MEMTOP
cln232        = $f483 ; Reset CIAs to RS-232
_LOAD         = $f49e ; Load RAM
_LOAD_SERIAL  = $f4b8 ; Load File From Serial Bus
_LOAD_TAPE    = $f533 ; Load File From Tape
_LOAD_MSG_SF  = $f5af ; Print "SEARCHING FOR"
_LOAD_MSG_FN  = $f5c1 ; Print Filename
_LOAD_MSG_LV  = $f5d2 ; Print "LOADING" / "VERIFYING"
_SAVE         = $f5dd ; Save RAM
_SAVE_SERIAL  = $f5fa ; Save to Serial Bus
_SAVE_TAPE    = $f659 ; Save to Tape
_SAVE_MSG_SA  = $f68f ; Print "SAVING"
_UDTIM        = $f69b ; Bump Clock
_RDTIM        = $f6dd ; Get Time
_SETTIM       = $f6e4 ; Set Time
_STOP         = $f6ed ; Check STOP Key
_IOERROR      = $f6fb ; Output I/O Error Messages
IOERROR1      = $f6fb ; $01 - 'too many files'
IOERROR2      = $f6fe ; $02 - 'file open'
IOERROR3      = $f701 ; $03 - 'file not open'
IOERROR4      = $f704 ; $04 - 'file not found'
IOERROR5      = $f707 ; $05 - 'device not present'
IOERROR6      = $f70a ; $06 - 'not input file'
IOERROR7      = $f70d ; $07 - 'not output file'
IOERROR8      = $f710 ; $08 - 'missing filename'
IOERROR9      = $f713 ; $09 - 'illegal device number'
TAPFAH        = $f72c ; Find Any Tape Header
TAPEH         = $f76a ; Write Tape Header / Tape End
TAPGETBUF     = $f7d0 ; Get Buffer Address
TAPSETPT      = $f7d7 ; Set Buffer Start / End Pointers
TAPFAF        = $f7ea ; Find Specific Tape Header (Find Any File)
TAPCKBUF      = $f80d ; Check Tape Buffer Full
TAPMSGPLAY    = $f817 ; Print "PRESS PLAY ON TAPE"
TAPCKSTAT     = $f82e ; Check Tape Status
TAPMSGREC     = $f838 ; Print "PRESS RECORD..."
TAPRDINI      = $f841 ; Initiate Tape Read
TAPRD         = $f864 ; Initiate Tape Write
TAPCIA        = $f875 ; Common Tape Code
TAPSTOP       = $f8d0 ; Check Tape Stop
TAPTIM        = $f8e2 ; Set Read Timing
TAPREAD       = $f92c ; Read Tape Bits
TAPSTOR       = $fa60 ; Store Tape Characters
TAPRPTR       = $fb8e ; Reset Tape Pointer (stah' vektor to 'sah' vektor)
TAPNEWCH      = $fb97 ; Init Register for Serial Read/Write
TAPWRITE      = $fba6 ; Send Tone (Bit) to Tape
TAPXWRT       = $fbc8 ; Write Data to Tape
TAPWRTN       = $fbcd ; IRQ Entry Point
TAPWRNC       = $fc57 ; Write Tape Leader
TAPTNIF       = $fc93 ; Tape Motor Off / Restore Normal IRQ
TAPSTKY       = $fcb8 ; Set IRQ Vector
TAPTNOF       = $fcca ; Kill Tape Motor
EMPSTE        = $fcd1 ; Check Read / Write Pointer
INCSAL        = $fcdb ; Bump Read / Write Pointer
_RESET        = $fce2 ; Power-Up RESET Entry
CHKMODROM     = $fd02 ; Check For 8-ROM Module
TABMODMASK    = $fd12 ; 8-ROM Mask '80CBM'                    DATA
_RESTOR       = $fd15 ; Restore Kernal Vectors (at 0314)
_VECTOR       = $fd1a ; Change Vectors For User
; ------------------------------------------------------------------------------------------------------------- ;
; kernal vectors
; ------------------------------------------------------------------------------------------------------------- ;
VECTSS        = $fd30 ; Kernal Reset Vectors                  WORD
VIRQ          = $fd30 ; $ea31 <- $0314 - CINV   IRQ vector
VIRQ_LO       = $fd30 ; 
VIRQ_HI       = $fd31 ; 
VBRK          = $fd32 ; $fe66 <- $0316 - CNBINV BRK vector
VBRK_LO       = $fd32 ; 
VBRK_HI       = $fd33 ; 
VNMI          = $fd34 ; $fe47 <- $0318 - NMINV  NMI vector
VNMI_LO       = $fd34 ; 
VNMI_HI       = $fd35 ; 
VOPEN         = $fd36 ; $f34a <- $031a - IOPEN  open a logical file
VOPEN_LO      = $fd36 ; 
VOPEN_HI      = $fd37 ; 
VCLOSE        = $fd38 ; $f291 <- $031c - ICLOSE close a specified logical file
VCLOSE_LO     = $fd38 ; 
VCLOSE_HI     = $fd39 ; 
VCHKIN        = $fd3a ; $f20e <- $031e - ICHKIN open channel for input
VCHKIN_LO     = $fd3a ; 
VCHKIN_HI     = $fd3b ; 
VCHKOUT       = $fd3c ; $f250 <- $0320 - ICKOUT open channel for output
VCHKOUT_LO    = $fd3c ; 
VCHKOUT_HI    = $fd3d ; 
VCLRCHN       = $fd3e ; $f333 <- $0322 - ICLRCH close input and output channels
VCLRCHN_LO    = $fd3e ; 
VCLRCHN_HI    = $fd3f ; 
VCHRIN        = $fd40 ; $f157 <- $0324 - IBASIN input character from channel
VCHRIN_LO     = $fd40 ; 
VCHRIN_HI     = $fd41 ; 
VCHROUT       = $fd42 ; $f1ca <- $0326 - IBSOUT output character to channel
VCHROUT_LO    = $fd42 ; 
VCHROUT_HI    = $fd43 ; 
VSTOP         = $fd44 ; $f6ed <- $0328 - ISTOP  scan stop key
VSTOP_LO      = $fd44 ; 
VSTOP_HI      = $fd45 ; 
VGETIN        = $fd46 ; $f13e <- $032a - IGETIN get character from the input device
VGETIN_LO     = $fd46 ; 
VGETIN_HI     = $fd47 ; 
VCLALL        = $fd48 ; $f32f <- $032c - ICLALL close all channels and files
VCLALL_LO     = $fd48 ; 
VCLALL_HI     = $fd49 ; 
VUSR          = $fd4a ; $fe66 <- $032e - USRCMD user defined command Vector (currently points to BRK - does not have any function)
VUSR_LO       = $fd4a ; 
VUSR_HI       = $fd4b ; 
VLOAD         = $fd4c ; $f4a5 <- $0330 - ILOAD  load
VLOAD_LO      = $fd4c ; 
VLOAD_HI      = $fd4d ; 
VSAVE         = $fd4e ; $f5ed <- $0332 - ISAVE  save
VSAVE_LO      = $fd4e ; 
VSAVE_HI      = $fd4f ; 
VECTSS_LEN    = [VSAVE_HI - VECTSS] ; 
; ------------------------------------------------------------------------------------------------------------- ;
_RAMTAS       = $fd50 ; Initialise System Constants
VECTTAP       = $fd9b ; IRQ Vectors For Tape I/O              WORD
VTAPE_WRITEA  = $fd9b ; $fc6a $08 write tape leader IRQ routine
VTAPE_WRITEB  = $fd9d ; $fbcd $0A tape write IRQ routine
VTAPE_IRQ     = $fd9f ; $ea31 $0C normal IRQ vector
VTAPE_READ    = $fda1 ; $f92c $0E read tape bits IRQ routine
_IOINIT       = $fda3 ; Initialise I/O
IOKEYS        = $fddd ; Enable Timer - flag 'pal=1' 'ntsc=0'
_SETNAM       = $fdf9 ; Set Filename
_SETLFS       = $fe00 ; Set Logical File Parameters
_READST       = $fe07 ; Get I/O Status Word
_SETMSG       = $fe18 ; Control OS Messages
_SETTMO       = $fe21 ; Set IEEE Timeout
_MEMTOP       = $fe25 ; Read / Set Top of Memory
_MEMBOT       = $fe34 ; Read / Set Bottom of Memory
_NMI          = $fe43 ; NMI Transfer Entry
TIMB          = $fe66 ; Warm Start Basic [BRK]
_NMI_RS_232   = $fe72 ; NMI Routine for RS 232
PREND         = $febc ; Exit Interrupt
BAUDO         = $fec2 ; RS-232 Timing Table - NTSC            DATA
T2NMI         = $fed6 ; NMI RS-232 In
FLNMI         = $ff07 ; NMI RS-232 Out
simirq        = $ff43 ; Fake IRQ Entry - Entered via cassette routine
_IRQ          = $ff48 ; IRQ Entry
_CINT         = $ff5b ; Initialize screen editor
XCKSM         = $ff80 ; Kernal Version Number [03]            DATA
; ------------------------------------------------------------------------------------------------------------- ;
         ifnconst KERNAL_JUMP_TABLE
; ------------------------------------------------------------------------------------------------------------- ;
; C64 Kernal Jump Table Definitions
; ------------------------------------------------------------------------------------------------------------- ;
CINT          = $ff81 ; jmp $ff5b           Init Editor & Video Chips
IOINIT        = $ff84 ; jmp $fd23           Init I/O Devices, Ports & Timers
RAMTAS        = $ff87 ; jmp $fd50           Init Ram & Buffers
RESTOR        = $ff8a ; jmp $fd15           Restore Vectors
VECTOR        = $ff8d ; jmp $fd1a           Change Vectors For User
SETMSG        = $ff90 ; jmp $fe18           Control OS Messages
SECOND        = $ff93 ; jmp $edb9           Send SA After Listen
TKSA          = $ff96 ; jmp $edc7           Send SA After Talk
MEMTOP        = $ff99 ; jmp $fe25           Set/Read System RAM Top
MEMBOT        = $ff9c ; jmp $fe34           Set/Read System RAM Bottom
SCNKEY        = $ff9f ; jmp $ea87           Scan Keyboard
SETTMO        = $ffa2 ; jmp $fe21           Set Timeout In IEEE
ACPTR         = $ffa5 ; jmp $ee13           Handshake Serial Byte In
CIOUT         = $ffa8 ; jmp $eddd           Handshake Serial Byte Out
UNTLK         = $ffab ; jmp $edef           Command Serial Bus UNTALK
UNLSN         = $ffae ; jmp $edfe           Command Serial Bus UNLISTEN
LISTEN        = $ffb1 ; jmp $ed0c           Command Serial Bus LISTEN
TALK          = $ffb4 ; jmp $ed09           Command Serial Bus TALK
READST        = $ffb7 ; jmp $fe07           Read I/O Status Word
SETLFS        = $ffba ; jmp $fe00           Set Logical File Parameters
SETNAM        = $ffbd ; jmp $fdf9           Set Filename
OPEN          = $ffc0 ; jmp ($031a) IOPEN   Open Vector                   [_OPEN]
CLOSE         = $ffc3 ; jmp ($031c) ICLOSE  Close Vector                  [_CLOSE]
CHKIN         = $ffc6 ; jmp ($031e) ICHKIN  Set Input                     [_CHKIN]
CHKOUT        = $ffc9 ; jmp ($0320) ICKOUT  Set Output                    [_CHKOUT]
CLRCHN        = $ffcc ; jmp ($0322) ICLRCH  Restore I/O Vector            [_CLRCHN]
CHRIN         = $ffcf ; jmp ($0324) IBASIN  Input Vector, chrin           [_CHRIN]
CHROUT        = $ffd2 ; jmp ($0326) IBSOUT  Output Vector, chrout         [_CHROUT]
LOAD          = $ffd5 ; jmp $f49e           Load RAM From Device
SAVE          = $ffd8 ; jmp $f5dd           Save RAM To Device
SETTIM        = $ffdb ; jmp $f6e4           Set Real-Time Clock
RDTIM         = $ffde ; jmp $f6dd           Read Real-Time Clock
STOP          = $ffe1 ; jmp ($0328) ISTOP   Test-Stop Vector              [_STOP]
GETIN         = $ffe4 ; jmp ($032a) IGETIN  Get From Keyboad              [_GETIN]
CLALL         = $ffe7 ; jmp ($032c) ICLALL  Close All Channels And Files  [_CLALL]
UDTIM         = $ffea ; jmp $f69b           Increment Real-Time Clock
SCREEN        = $ffed ; jmp $e505           Return Screen Organization
PLOT          = $fff0 ; jmp $e50a           Read / Set Cursor X/Y Position
IOBASE        = $fff3 ; jmp $e500           Return I/O Base Address
         endif              ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Misc Vectors
; ------------------------------------------------------------------------------------------------------------- ;
;             = $fff6 ; -> [$5252]
SYSTEM        = $fff8 ; -> [$5942]
; ------------------------------------------------------------------------------------------------------------- ;
; Hardware Vectors
; ------------------------------------------------------------------------------------------------------------- ;
HNMI          = $fffa ; Non-Maskable Interrupt Hardware Vector                [_NMI]
HNMI_LO       = $fffa ; 
HNMI_HI       = $fffb ; 
HRESET        = $fffc ; System Reset (RES) Hardware Vector                    [_RESET]
HRESET_LO     = $fffc ; 
HRESET_HI     = $fffd ; 
HBRK          = $fffe ; Maskable Interrupt Request and Break Hardware Vectors [_IRQ]
HBRK_LO       = $fffe ; 
HBRK_HI       = $ffff ; 
; ------------------------------------------------------------------------------------------------------------- ;
