; ------------------------------------------------------------------------------------------------------------- ;
; Sound Interface Device (SID) Registers - $D400-$D41C
; ------------------------------------------------------------------------------------------------------------- ;
SID               = $D400       ; Base Address
SID_Len             = $20       ; SID possible address space (32) - $1d (29) used / remaining $03 (03) unused
; ------------------------------------------------------------------------------------------------------------- ;
FRELO1            = [SID + $00] ; Oscillator 1 Frequency Control (low byte)       : 16bit FREQUENCY
                                ; Fout = (Fn * Fclk/16777216) Hz  -->  Freq = Register Value * 0.060959458 Hz
                                ;   Fn   = the 16-bit number in the Frequency registers
                                ;   Fclk = the system clock applied to the 2 input (pin 6)
FreLo0              = %00000001 ;   Bit 00: same for Oscillators 1-3
FreLo1              = %00000010 ;   Bit 01: same for Oscillators 1-3
FreLo2              = %00000100 ;   Bit 02: same for Oscillators 1-3
FreLo3              = %00001000 ;   Bit 03: same for Oscillators 1-3
FreLo4              = %00010000 ;   Bit 04: same for Oscillators 1-3
FreLo5              = %00100000 ;   Bit 05: same for Oscillators 1-3
FreLo6              = %01000000 ;   Bit 06: same for Oscillators 1-3
FreLo7              = %10000000 ;   Bit 07: same for Oscillators 1-3
                  
__FREQLO1         = FRELO1      ; 
__F0                = FreLo0    ;   Bit 00: same for Oscillators 1-3
__F1                = FreLo1    ;   Bit 01: same for Oscillators 1-3
__F2                = FreLo2    ;   Bit 02: same for Oscillators 1-3
__F3                = FreLo3    ;   Bit 03: same for Oscillators 1-3
__F4                = FreLo4    ;   Bit 04: same for Oscillators 1-3
__F5                = FreLo5    ;   Bit 05: same for Oscillators 1-3
__F6                = FreLo6    ;   Bit 06: same for Oscillators 1-3
__F7                = FreLo7    ;   Bit 07: same for Oscillators 1-3
; ------------------------------------------------------------------------------------------------------------- ;
FREHI1            = [SID + $01] ; Oscillator 1 Frequency Control (high byte)      : 16bit FREQUENCY   = FRELO1_FREHI1_VALUE * 0.060959458 Hz
FreHi0              = %00000001 ;   Bit 08: same for Oscillators 1-3
FreHi1              = %00000010 ;   Bit 09: same for Oscillators 1-3
FreHi2              = %00000100 ;   Bit 10: same for Oscillators 1-3
FreHi3              = %00001000 ;   Bit 11: same for Oscillators 1-3
FreHi4              = %00010000 ;   Bit 12: same for Oscillators 1-3
FreHi5              = %00100000 ;   Bit 13: same for Oscillators 1-3
FreHi6              = %01000000 ;   Bit 14: same for Oscillators 1-3
FreHi7              = %10000000 ;   Bit 15: same for Oscillators 1-3
                  
__FREQHI1         = FREHI1      ; 
__F8                = FreHi0    ;   Bit 08: same for Oscillators 1-3
__F9                = FreHi1    ;   Bit 09: same for Oscillators 1-3
__F10               = FreHi2    ;   Bit 10: same for Oscillators 1-3
__F11               = FreHi3    ;   Bit 11: same for Oscillators 1-3
__F12               = FreHi4    ;   Bit 12: same for Oscillators 1-3
__F13               = FreHi5    ;   Bit 13: same for Oscillators 1-3
__F14               = FreHi6    ;   Bit 14: same for Oscillators 1-3
__F15               = FreHi7    ;   Bit 15: same for Oscillators 1-3
; ------------------------------------------------------------------------------------------------------------- ;
PWLO1             = [SID + $02] ; Oscillator 1 Pulse Waveform Width (low byte)    : 12bit PULSE WIDTH
                                ; PWout = (PWn/40.95) %
                                ;   PWn = the 12-bit number in the Pulse Width registers
PwLo0               = %00000001 ;   Bit 00: same for Oscillators 1-3
PwLo1               = %00000010 ;   Bit 01: same for Oscillators 1-3
PwLo2               = %00000100 ;   Bit 02: same for Oscillators 1-3
PwLo3               = %00001000 ;   Bit 03: same for Oscillators 1-3
PwLo4               = %00010000 ;   Bit 04: same for Oscillators 1-3
PwLo5               = %00100000 ;   Bit 05: same for Oscillators 1-3
PwLo6               = %01000000 ;   Bit 06: same for Oscillators 1-3
PwLo7               = %10000000 ;   Bit 07: same for Oscillators 1-3
                  
__PWLO1           = PWLO1       ; 
__PW0               = PwLo0     ;   Bit 00: same for Oscillators 1-3
__PW1               = PwLo1     ;   Bit 01: same for Oscillators 1-3
__PW2               = PwLo2     ;   Bit 02: same for Oscillators 1-3
__PW3               = PwLo3     ;   Bit 03: same for Oscillators 1-3
__PW4               = PwLo4     ;   Bit 04: same for Oscillators 1-3
__PW5               = PwLo5     ;   Bit 05: same for Oscillators 1-3
__PW6               = PwLo6     ;   Bit 06: same for Oscillators 1-3
__PW7               = PwLo7     ;   Bit 07: same for Oscillators 1-3
; ------------------------------------------------------------------------------------------------------------- ;
PWHI1             = [SID + $03] ; Oscillator 1 Pulse Waveform Width (high nybble) : 12bit PULSE WIDTH = PWLO1_PWHI1_VALUE / 40.95) %
PwHi0               = %00000001 ;   Bit 08: same for Oscillators 1-3
PwHi1               = %00000010 ;   Bit 09: same for Oscillators 1-3
PwHi2               = %00000100 ;   Bit 10: same for Oscillators 1-3
PwHi3               = %00001000 ;   Bit 11: same for Oscillators 1-3
                    ; %00010000 ;   Bit 12: <unused>
                    ; %00100000 ;   Bit 13: <unused>
                    ; %01000000 ;   Bit 14: <unused>
                    ; %10000000 ;   Bit 15: <unused>
                  
__PWHI1           = PWHI1       ; 
__PW8               = PwHi0     ;   Bit 08: same for Oscillators 1-3
__PW9               = PwHi1     ;   Bit 09: same for Oscillators 1-3
__PW10              = PwHi2     ;   Bit 10: same for Oscillators 1-3
__PW11              = PwHi3     ;   Bit 11: same for Oscillators 1-3
; ------------------------------------------------------------------------------------------------------------- ;
VCREG1            = [SID + $04] ; Oscillator 1 Control
VcRegGATE           = %00000001 ;   Bit 0: Gate Bit:        1=Start attack/decay/sustain, 0=Start release
VcRegSYNC           = %00000010 ;   Bit 1: Sync Bit:        1=Synchronize Oscillator with Oscillator 3 frequency
VcRegRING           = %00000100 ;   Bit 2: Ring Modulation: 1=Ring modulate Oscillators 1 and 3
VcRegTEST           = %00001000 ;   Bit 3: Test Bit:        1=Lock Oscillator 1
VcRegTRI            = %00010000 ;   Bit 4: Select triangle     waveform - only one possible at any time - no mixing
VcRegSAW            = %00100000 ;   Bit 5: Select sawtooth     waveform
VcRegPULSE          = %01000000 ;   Bit 6: Select pulse        waveform
VcRegNOISE          = %10000000 ;   Bit 7: Select random noise waveform
                  
__VCR1            = VCREG1       ; 
__GATE              = VcRegGATE  ; 
__SYNC              = VcRegSYNC  ; 
__RING              = VcRegRING  ; 
__TEST              = VcRegTEST  ; 
__TRI               = VcRegTRI   ; 
__SAW               = VcRegSAW   ; 
__PULSE             = VcRegPULSE ; 
__NOISE             = VcRegNOISE ; 
; ------------------------------------------------------------------------------------------------------------- ;
ATDCY1            = [SID + $05] ; Oscillator 1 Attack/Decay Register : REGISTER VALUE= (ATTACK * 16) + DECAY
Atk_Mask            = %00001111 ; Bits 0-3: Select decay cycle duration (0-15)
                                ;   0 = 6   milliseconds   8 = 300 milliseconds
                                ;   1 = 24  milliseconds   9 = 750 milliseconds
                                ;   2 = 48  milliseconds  10 = 1.5 seconds
                                ;   3 = 72  milliseconds  11 = 2.4 seconds
                                ;   4 = 114 milliseconds  12 = 3 seconds
                                ;   5 = 168 milliseconds  13 = 9 seconds
                                ;   6 = 204 milliseconds  14 = 15 seconds
                                ;   7 = 240 milliseconds  15 = 24 seconds
AtkDcy0             = %00000001 ; 
AtkDcy1             = %00000010 ; 
AtkDcy2             = %00000100 ; 
AtkDcy3             = %00001000 ; 
                                ; 
Dcy_Mask            = %11110000 ; Bits 4-7: Select attack cycle duration (0-15)
                                ;   0 = 2  milliseconds    8 = 100 milliseconds
                                ;   1 = 8  milliseconds    9 = 250 milliseconds
                                ;   2 = 16 milliseconds   10 = 500 milliseconds
                                ;   3 = 24 milliseconds   11 = 800 milliseconds
                                ;   4 = 38 milliseconds   12 = 1 second
                                ;   5 = 56 milliseconds   13 = 3 seconds
                                ;   6 = 68 milliseconds   14 = 5 seconds
                                ;   7 = 80 milliseconds   15 = 8 seconds
AtkDcy4           = %00010000   ; 
AtkDcy5           = %00100000   ; 
AtkDcy6           = %01000000   ; 
AtkDcy7           = %10000000   ; 
                                
__AD1             = ATDCY1      ; 
__DCY0              = AtkDcy0   ;   Bit 00: same for Oscillators 1-3
__DCY1              = AtkDcy1   ;   Bit 01: same for Oscillators 1-3
__DCY2              = AtkDcy2   ;   Bit 02: same for Oscillators 1-3
__DCY3              = AtkDcy3   ;   Bit 03: same for Oscillators 1-3
__ATK0              = AtkDcy4   ;   Bit 04: same for Oscillators 1-3
__ATK1              = AtkDcy5   ;   Bit 05: same for Oscillators 1-3
__ATK2              = AtkDcy6   ;   Bit 06: same for Oscillators 1-3
__ATK3              = AtkDcy7   ;   Bit 07: same for Oscillators 1-3
; ------------------------------------------------------------------------------------------------------------- ;
SUREL1            = [SID + $06] ; Oscillator 1 Sustain/Release Control Register
Stn_Mask            = %11110000 ; Bits 0-3: Select release cycle duration (0-15)
                                ;   0 = 6   milliseconds   8 = 300 milliseconds
                                ;   1 = 24  milliseconds   9 = 750 milliseconds
                                ;   2 = 48  milliseconds  10 = 1.5 seconds
                                ;   3 = 72  milliseconds  11 = 2.4 seconds
                                ;   4 = 114 milliseconds  12 = 3 seconds
                                ;   5 = 168 milliseconds  13 = 9 seconds
                                ;   6 = 204 milliseconds  14 = 15 seconds
                                ;   7 = 240 milliseconds  15 = 24 seconds
StnRis0             = %00000001 ;   Bit 00: same for Oscillators 1-3
StnRis1             = %00000010 ;   Bit 01: same for Oscillators 1-3
StnRis2             = %00000100 ;   Bit 02: same for Oscillators 1-3
StnRis3             = %00001000 ;   Bit 03: same for Oscillators 1-3
                                ; 
Ris_Mask            = %11110000 ; Bits 4-7: Select sustain volume level   (0-15)
StnRis4             = %00010000 ;   Bit 04: same for Oscillators 1-3
StnRis5             = %00100000 ;   Bit 05: same for Oscillators 1-3
StnRis6             = %01000000 ;   Bit 06: same for Oscillators 1-3
StnRis7             = %10000000 ;   Bit 07: same for Oscillators 1-3
                                
__SR1               = SUREL1    ; 
__STN0              = StnRis0   ;   Bit 00: same for Oscillators 1-3
__STN1              = StnRis1   ;   Bit 01: same for Oscillators 1-3
__STN2              = StnRis2   ;   Bit 02: same for Oscillators 1-3
__STN3              = StnRis3   ;   Bit 03: same for Oscillators 1-3
__RIS0              = StnRis4   ;   Bit 04: same for Oscillators 1-3
__RIS1              = StnRis5   ;   Bit 05: same for Oscillators 1-3
__RIS2              = StnRis6   ;   Bit 06: same for Oscillators 1-3
__RIS3              = StnRis7   ;   Bit 07: same for Oscillators 1-3
; ------------------------------------------------------------------------------------------------------------- ;
FRELO2            = [SID + $07] ; Oscillator 2 Frequency Control (low byte)
                  
__FREQLO2         = FRELO2      ; 
; ------------------------------------------------------------------------------------------------------------- ;
FREHI2            = [SID + $08] ; Oscillator 2 Frequency Control (high byte)
                  
__FREQHI2         = FREHI2      ; 
; ------------------------------------------------------------------------------------------------------------- ;
PWLO2             = [SID + $09] ; Oscillator 2 Pulse Waveform Width (low byte)
                  
__PWLO2           = PWLO2       ; 
; ------------------------------------------------------------------------------------------------------------- ;
PWHI2             = [SID + $0a] ; Oscillator 2 Pulse Waveform Width (high nybble)
                  
__PWHI2           = PWHI2       ; 
; ------------------------------------------------------------------------------------------------------------- ;
VCREG2            = [SID + $0b] ; Oscillator 2 Control
                                ;   Bit 0: Gate Bit:          1=Start attack/decay/sustain, 0=Start release
                                ;   Bit 1: Sync Bit:          1=Synchronize oscillator with Oscillator 1 frequency
                                ;   Bit 2: Ring Modulation:   1=Ring modulate Oscillators 2 and 1
                                ;   Bit 3: Test Bit:          1=Disable Oscillator 2
                                ;   Bit 4: Select triangle     waveform - only one possible at any time - no mixing
                                ;   Bit 5: Select sawtooth     waveform
                                ;   Bit 6: Select pulse        waveform
                                ;   Bit 7: Select random noise waveform
                                
__VCR2            = VCREG2      ; 
; ------------------------------------------------------------------------------------------------------------- ;
ATDCY2            = [SID + $0c] ; Oscillator 2 Attack/Decay Register
                                ;   Bits 0-3: Select decay cycle duration   (0-15)
                                ;   Bits 4-7: Select attack cycle duration  (0-15)
                                
__AD2             = ATDCY2      ; 
; ------------------------------------------------------------------------------------------------------------- ;
SUREL2            = [SID + $0d] ; Oscillator 2 Sustain/Release Control Register
                                ;   Bits 0-3:  Select release cycle duration (0-15)
                                ;   Bits 4-7:  Select sustain volume level (0-15)
                                
__SR2             = SUREL2      ; 
; ------------------------------------------------------------------------------------------------------------- ;
FRELO3            = [SID + $0e] ; Oscillator 3 Frequency Control (low byte)
                  
__FREQLO3         = FRELO3      ; 
; ------------------------------------------------------------------------------------------------------------- ;
FREHI3            = [SID + $0f] ; Oscillator 3 Frequency Control (high byte)
                  
__FREQHI3         = FREHI3      ; 
; ------------------------------------------------------------------------------------------------------------- ;
PWLO3             = [SID + $10] ; Oscillator 3 Pulse Waveform Width (low byte)
                  
__PWLO3           = PWLO3       ; 
; ------------------------------------------------------------------------------------------------------------- ;
PWHI3             = [SID + $11] ; Oscillator 3 Pulse Waveform Width (high nybble)
                  
__PWHI3           = PWHI3       ; 
; ------------------------------------------------------------------------------------------------------------- ;
VCREG3            = [SID + $12] ; Oscillator 3 Control
                                ;   Bit 0: Gate Bit:        1=Start attack/decay/sustain, 0=Start release
                                ;   Bit 1: Sync Bit:        1=Synchronize oscillator with Oscillator 2 frequency
                                ;   Bit 2: Ring Modulation: 1=Ring modulate Oscillators 3 and 2
                                ;   Bit 3: Test Bit:        1=Disable Oscillator 3
                                ;   Bit 4: Select triangle     waveform - only one possible at any time - no mixing
                                ;   Bit 5: Select sawtooth     waveform
                                ;   Bit 6: Select pulse        waveform
                                ;   Bit 7: Select random noise waveform
                                
__VCR3            = VCREG3      ; 
; ------------------------------------------------------------------------------------------------------------- ;
ATDCY3            = [SID + $13]   ; Oscillator 3 Attack/Decay Register
                                ;   Bits 0-3:  Select decay cycle duration (0-15)
                                ;   Bits 4-7:  Select attack cycle duration (0-15)
                                
__AD3             = ATDCY3      ; 
; ------------------------------------------------------------------------------------------------------------- ;
SUREL3            = [SID + $14] ; Oscillator 3 Sustain/Release Control Register
                                ;   Bits 0-3:  Select release cycle duration (0-15)
                                ;   Bits 4-7:  Select sustain volume level (0-15)
                                
__SR3             = SUREL3      ; 
; ------------------------------------------------------------------------------------------------------------- ;
CUTLO             = [SID + $15] ; Filter Cutoff Frequency (lowh byte)   : FREQUENCY = (REGISTER VALUE * 5.8) + 30Hz
                                ;   Bits 0-2:  Low portion of filter cutoff frequency
                                ;   Bits 5-7:  Unused
; ------------------------------------------------------------------------------------------------------------- ;
CUTHI             = [SID + $16] ; Filter Cutoff Frequency (high byte)   : FREQUENCY = (REGISTER VALUE * 5.8) + 30Hz
; ------------------------------------------------------------------------------------------------------------- ;
RESON             = [SID + $17] ; Filter Resonance Control Register
ResOn1              = %00000001 ;   Bit 0:    Filter the output of voice 1?  1=yes
ResOn2              = %00000010 ;   Bit 1:    Filter the output of voice 2?  1=yes
ResOn3              = %00000100 ;   Bit 2:    Filter the output of voice 3?  1=yes
ResExt              = %00001000 ;   Bit 3:    Filter the output from the external input?  1=yes
                                ; 
Res_Mask            = %11110000 ;   Bits 4-7: Select filter resonance 0-15
                                
__FILT1             = ResOn1    ; 
__FILT2             = ResOn2    ; 
__FILT3             = ResOn3    ; 
__FILTEXT           = ResExt    ; 
__FILTRES           = Res_Mask  ; 
; ------------------------------------------------------------------------------------------------------------- ;
SIGVOL            = [SID + $18] ; Volume and Filter Select Register
SigVol_Mask         = %00001111 ;   Bits 0-3: Select output volume (0-15)
                                ; 
SigVolLowPass       = %00010000 ;   Bit 4:    Select low-pass filter,  1=low-pass on
SigVolBandPass      = %00100000 ;   Bit 5:    Select band-pass filter, 1=band-pass on
SigVolHighPass      = %01000000 ;   Bit 6:    Select high-pass filter, 1=high-pass on
SigVolMuteOsc3      = %10000000 ;   Bit 7:    Mute Oscillator 3 - 1=off
                                
__VOLUME            = SigVol_Mask    ; 
__LOWPASS           = SigVolLowPass  ; 
__BANDPASS          = SigVolBandPass ; 
__HIGHPASS          = SigVolHighPass ; 
__CHAN3OFF          = SigVolMuteOsc3 ; 
; ------------------------------------------------------------------------------------------------------------- ;
POTX              = [SID + $19] ; Read Game Paddle 1 (or 3) Position
                  
__POTX            = POTX
; ------------------------------------------------------------------------------------------------------------- ;
POTY              = [SID + $1a] ; Read Game Paddle 2 (or 4) Position
                  
__POTY            = POTY
; ------------------------------------------------------------------------------------------------------------- ;
RANDOM            = [SID + $1b] ; Current State of Oscillator 3's Wave / Random Number Generator
                  
__OSC3            = RANDOM
; ------------------------------------------------------------------------------------------------------------- ;
ENV3              = [SID + $1c] ; Current State of Oscillator 3's Envelope
                  
__ENV3            = ENV3
; ------------------------------------------------------------------------------------------------------------- ;
; $D41D-$D41F   ; Not Connected - always $ff when read even after writes
; ------------------------------------------------------------------------------------------------------------- ;
; $D420-$D7FF   ; SID Register Images - Mirror of $D400-$D41F
; ------------------------------------------------------------------------------------------------------------- ;
