; -------------------------------------------------------------------------------------------------------------- ;
; 1541 - BAM Block - 18,00
; -------------------------------------------------------------------------------------------------------------- ;
BAMLINK           = $00         ; link to the next directory block
BAMLINKTRK        = $00         ; track location of the first directory entry block
BAMLINKTRK_1541     = $12       ; 
BAMLINKSEC        = $01         ; sector location of the first directory entry block
BAMLINKSEC_1541     = $01       ; 
BAMDOSVRS         = $02         ; disk DOS version type
BAMDOSVRS_1541      = $41       ; "A"
BAMNOUSE          = $03         ; unsused
; -------------------------------------------------------------------------------------------------------------- ;
; BAM bit patterns - entries for each track in groups of four bytes per track
; -------------------------------------------------------------------------------------------------------------- ;
BAM_ZONE_01       = $04         ; zone 1 - tracks 00-17 - outer tracks
BAM_ZONE_01_MIN     = $01       ;        - start track numer
BAM_ZONE_01_MAX     = $11       ;        - final track number
BAM_ZONE_01_NUM     = $15       ;        - 21 sectors per track (00-20)
;
BAM_TRK_01        = $04         ; 
BAM_TRKFREE         = $00       ; number of free sectors on that track
BAM_TRKB01          = $01       ; bit pattern sector 00-07
BAM_TRKB02          = $02       ; bit pattern sector 08-15
BAM_TRKB03          = $03       ; bit pattern sector 16-24
BAM_TRK_02        = $08         ; 
BAM_TRK_03        = $0c         ; 
BAM_TRK_04        = $10         ; 
BAM_TRK_05        = $14         ; 
BAM_TRK_06        = $18         ; 
BAM_TRK_07        = $1c         ; 
BAM_TRK_08        = $20         ; 
BAM_TRK_09        = $24         ; 
BAM_TRK_00        = $28         ; 
BAM_TRK_11        = $2c         ; 
BAM_TRK_12        = $30         ; 
BAM_TRK_13        = $34         ; 
BAM_TRK_14        = $38         ; 
BAM_TRK_15        = $3c         ; 
BAM_TRK_16        = $40         ; 
BAM_TRK_17        = $44         ; 
; -------------------------------------------------------------------------------------------------------------- ;
BAM_ZONE_02       = $48         ; zone 2 - tracks 18-24 
BAM_ZONE_02_MIN     = $12       ;        - 18 = start track numer
BAM_ZONE_02_MAX     = $18       ;        - 24 = final track number
BAM_ZONE_02_NUM     = $13       ;        - 19 = sectors per track (00-18)
BAM_TRK_18        = $48         ; bam/directory
BAM_TRK_19        = $4c         ; 
BAM_TRK_20        = $50         ; 
BAM_TRK_21        = $54         ; 
BAM_TRK_22        = $58         ; 
BAM_TRK_23        = $5c         ; 
BAM_TRK_24        = $60         ; 
; -------------------------------------------------------------------------------------------------------------- ;
BAM_ZONE_03       = $64         ; zone 3 - tracks 25-30
BAM_ZONE_03_MIN     = $19       ;        - 25 = start track numer
BAM_ZONE_03_MAX     = $1e       ;        - 30 = final track number
BAM_ZONE_03_NUM     = $12       ;        - 18 = sectors per track (00-17)
BAM_TRK_25        = $64         ; 
BAM_TRK_26        = $68         ; 
BAM_TRK_27        = $6c         ; 
BAM_TRK_28        = $70         ; 
BAM_TRK_29        = $74         ; 
BAM_TRK_30        = $78         ; 
; -------------------------------------------------------------------------------------------------------------- ;
BAM_ZONE_04       = $7c         ; zone 4 - tracks 31-35 - inner tracks
BAM_ZONE_04_MIN     = $1f       ;        - 31 = start track numer
BAM_ZONE_04_MAX     = $23       ;        - 35 = final track number
BAM_ZONE_04_NUM     = $11       ;        - 17 = sectors per track (00-16)
BAM_TRK_31        = $7c         ; 
BAM_TRK_32        = $80         ; 
BAM_TRK_33        = $84         ; 
BAM_TRK_34        = $88         ; 
BAM_TRK_35        = $8c         ; 
; -------------------------------------------------------------------------------------------------------------- ;
BAMDISKNAM        = $90         ; disk name (padded with $a0)
BAMDISKNAM_LEN    = [BAMFILLER - BAMDISKNAM - $01] ; 
BAMFILLER         = $a0         ; 
BAMFILLER1        = $a0         ; 
BAMFILLCHAR         = $a0       ; shift space
BAMFILLER2        = $a1         ; 
BAMFILLER2_1541     = BAMFILLCHAR ; 
BAMDISKID         = $a2         ; 
BAMDISKID1        = $a2         ; 
BAMDISKID1_1541     = $30       ; default: "0"
BAMDISKID2        = $a3         ; 
BAMDISKID2_1541     = $30       ; default: "0"
BAMDOSTYP         = $a5         ; 
BAMDOSTYP1        = $a5         ; 
BAMDOSTYP1_1541     = $32       ; "2"
BAMDOSTYP2        = $a6         ; 
BAMDOSTYP2_1541     = $41       ; "A"
BAMPAD            = $a7         ; filled with BAMFILLCHAR (shift space)
BAMPAD_LEN        = [BAMFREE - BAMPAD - $01] ; 
; -------------------------------------------------------------------------------------------------------------- ;
BAMFREE           = $ab         ; unsused - sometimes set to 'BLOCKS FREE'
BAMEND            = $ff         ; 
; -------------------------------------------------------------------------------------------------------------- ;
