; -------------------------------------------------------------------------------------------------------------- ;
; VC1541 - Data Block
; -------------------------------------------------------------------------------------------------------------- ;
; The entire data_block (including the SYNC) is rewritten each time data is recorded an a discette
; -------------------------------------------------------------------------------------------------------------- ;
DATA_SYNC          = $0000      ; 1-bits - indicates DOS that a HEADER or DATA block follows
DATA_SYNC_VAL        = $ff      ; 
DATA_SYNC_LEN        = $05      ; 
; -------------------------------------------------------------------------------------------------------------- ;
DATA_BLOCK         = $0005      ; 
DATA_BLOCK_ID      = $0005      ; indicates a data block
DATA_BLOCK_ID_VAL    = BID_DFLT ; $07
; -------------------------------------------------------------------------------------------------------------- ;
DATA_BLOCK_BYTES   = $0006      ; 256 data bytes
DATA_BLOCK_BYTES_LEN = $ff      ; 
; -------------------------------------------------------------------------------------------------------------- ;
DATA_BLOCK_CRC     = $0106      ; checksum - ensures that a data block was read correctly
                                ; calulated by EORing DATA_BLOCK_BYTES_LEN  DATA_BLOCK_BYTES
; -------------------------------------------------------------------------------------------------------------- ;
; $02 OFF Bytes are used to complete $08 bytes
; as a multiple of $04 bytes is needed to create a multiple of $05 GCR-bytes
; -------------------------------------------------------------------------------------------------------------- ;
DATA_BLOCK_OFF     = $0107      ; DOS padding bytes during initial format - never referenced again
DATA_BLOCK_OFF_VAL   = $00      ; 
DATA_BLOCK_OFF1    = $0107      ; 
DATA_BLOCK_OFF2    = $0108      ; 
; -------------------------------------------------------------------------------------------------------------- ;
DATA_BLOCK_LEN       = [DATA_BLOCK_OFF2 - DATA_BLOCK] ; $103 = 260 bytes
; -------------------------------------------------------------------------------------------------------------- ;
; the tail_gap length varies from zone to zone and from one drive to another
; between consectutive sectors the tail_gap is normally 4 to 12 bytes long
; between the last sector and sector zero on a track the tail_gap is often longer (up to 100 bytes)
; the tail_gap is designed to be long enough that the write of a data block does not overwrite 
; the start of the next sector if the drive is not turning exactly at 300 rpm
; (due to power fluctuations, mechanical wear, belt slippage, changes in temperature, etc.)
; -------------------------------------------------------------------------------------------------------------- ;
DATA_TAIL_GAP      = $0000      ; give DOS enough time to set-up between end of data block and start of next sector
DATA_TAIL_GAP_VAL    = $ff      ; DOS never reads these bytes
; -------------------------------------------------------------------------------------------------------------- ;
