; -------------------------------------------------------------------------------------------------------------- ;
; 1541 - Directory Block
; -------------------------------------------------------------------------------------------------------------- ;
; zone 2 - tracks 18-24 - 19 sectors per track (00-18)
; -------------------------------------------------------------------------------------------------------------- ;
; BAM occupies one block so 18 blocks are left for file entries
; max 144 files per diskette - 18 blocks with 8 entries each
; -------------------------------------------------------------------------------------------------------------- ;
DIR1ST            = $00         ; First dir entry - $00-$1f 
DIR1ST_LEN        = [DIR2ND - DIR1ST] ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Directory Link Address
; -------------------------------------------------------------------------------------------------------------- ;
DIRLINK           = $00         ; link to the next directory block
DIRLINKTRK        = $00         ; track location of next directory block
DIRLINKSEC        = $01         ; sector location of next directory block
DIRLINKLASTID       = $00       ; last directory block
DIRLINKLASTCOUNT    = $ff       ; last directory block used byte count
; -------------------------------------------------------------------------------------------------------------- ;
; Directory 1st Data Byte
; -------------------------------------------------------------------------------------------------------------- ;
DIRDATA           = $02         ; directory data start
; -------------------------------------------------------------------------------------------------------------- ;
DIRFTYP           = $02         ; actual file type
DIRFTYP_SCR         = $00       ; Scratched - deleted file entry
; -------------------------------------------------------------------------------------------------------------- ;
; Bit0-3: the actual filetype
;     : 000 (0) - DEL
;     : 001 (1) - SEQ
;     : 010 (2) - PRG
;     : 011 (3) - USR
;     : 100 (4) - REL
;                 values 5-15 are illegal - if used will produce very strange results 
;                 the 1541 is inconsistent in how it treats these bits
;                   - some routines use all 4 bits
;                   - others ignore bit 3 resulting in values from 0-7
; Bit4: not used
; Bit5: only present during a 'save-@' or "@0:" file replacement
; Bit6: locked flag (set    : produces ">" locked files)
; Bit7: closed flag (not set: produces  "*" or "splat" files)
; -------------------------------------------------------------------------------------------------------------- ;
; $80-$84 - normal filetype (bit 7 = 1)
; -------------------------------------------------------------------------------------------------------------- ;
DIRFTYP_MASK_NORMAL = %10000111 ; $80 - $84 - normal filetype (bit 7 = 1)
DIRFTYP_DEL         = %10000000 ; $80 - DEL
DIRFTYP_SEQ         = %10000001 ; $81 - SEQ
DIRFTYP_PRG         = %10000010 ; $82 - PRG
DIRFTYP_USR         = %10000011 ; $83 - USR
DIRFTYP_REL         = %10000100 ; $84 - REL
; -------------------------------------------------------------------------------------------------------------- ;
; $85-$8F - not used - if used results in *WEIRD* filetypes
; -------------------------------------------------------------------------------------------------------------- ;
; $00-$04 - "unclosed" - '*PRG'
; -------------------------------------------------------------------------------------------------------------- ;
DIRFTYP_MASK_OPEN   = %00000111 ; $00 - $04 - "unclosed" - '*PRG'
DIRFTYP_SEQ_O       = %00000001 ; $01 - *SEQ
DIRFTYP_PRG_O       = %00000010 ; $02 - *PRG
DIRFTYP_USR_O       = %00000011 ; $03 - *USR
DIRFTYP_REL_O       = %00000100 ; $04 - *REL
; -------------------------------------------------------------------------------------------------------------- ;
; $c0-$c4 - "locked" - 'PRG<'
; -------------------------------------------------------------------------------------------------------------- ;
DIRFTYP_MASK_LOCK   = %11000111 ; $c0 - $c4 - "locked" - 'PRG<'
DIRFTYP_DEL_L       = %11000000 ; $c0 - DEL<
DIRFTYP_SEQ_L       = %11000001 ; $c1 - SEQ<
DIRFTYP_PRG_L       = %11000010 ; $c2 - PRG<
DIRFTYP_USR_L       = %11000011 ; $c3 - USR<
DIRFTYP_REL_L       = %11000100 ; $c4 - REL<
; -------------------------------------------------------------------------------------------------------------- ;
; $a0-$a4 - only present during a 'save-@' or "@0:" file replacement
; -------------------------------------------------------------------------------------------------------------- ;
DIRFTYP_MASK_SAVE   = %10100111 ; $a0 - $a4 - only present during a 'save-@' or "@0:" file replacement
DIRFTYP_DEL_S       = %10100000 ; $a0 - DEL
DIRFTYP_SEQ_S       = %10100001 ; $a1 - SEQ
DIRFTYP_PRG_S       = %10100010 ; $a2 - PRG
DIRFTYP_USR_S       = %10100011 ; $a3 - USR
DIRFTYP_REL_S       = %10100100 ; $a4 - REL
; -------------------------------------------------------------------------------------------------------------- ;
DIRFILE           = $03         ; location of first block of file
DIRFILETRK        = $03         ; 1st track
DIRFILESEC        = $04         ; 1st sector
DIRFILENAM        = $05         ; 16 character filename in PETSCII padded with shift_space ($a0)
DIRFILENAM_LEN    = [DIRFILETRKSS - DIRFILENAM - $01] ; 
; -------------------------------------------------------------------------------------------------------------- ;
; REL file side sector blocks start / record lengths (REL file only)
; -------------------------------------------------------------------------------------------------------------- ;
DIRFILETRKSS      = $15         ; REL file starting track  location of side-sector blocks ($00)
DIRFILESECSS      = $16         ; REL file starting sector location of side-sector blocks ($00)
DIRFILERLEN       = $17         ; REL file record length                                  ($00)
; -------------------------------------------------------------------------------------------------------------- ;
DIRUNUSED1        = $18         ; $00
DIRUNUSED2        = $19         ; $00
DIRUNUSED3        = $1a         ; $00
DIRUNUSED4        = $1b         ; $00
DIRUNUSED5        = $1c         ; $00
DIRUNUSED6        = $1d         ; $00
; -------------------------------------------------------------------------------------------------------------- ;
DIRFILESIZE       = $1e         ; file size in blocks - filesize in bytes is <= #blocks * 254
DIRFILESIZE_LO      = $1e       ; 
DIRFILESIZE_HI      = $1f       ; 
; -------------------------------------------------------------------------------------------------------------- ;
DIRENTRYLEN       = [DIRFILESIZE_HI + $01]  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; from now on the DIRLINK bytes of each entry in this block should be $00/$00 as they are unused
; -------------------------------------------------------------------------------------------------------------- ;
DIR2ND            = [DIRENTRYLEN * $01]     ; Second  dir entry - $20-$3f 
DIR2ND_LEN        = DIRENTRYLEN             ; 
DIR3RD            = [DIRENTRYLEN * $02]     ; Third   dir entry - $40-$5f
DIR3RD_LEN        = DIRENTRYLEN             ; 
DIR4TH            = [DIRENTRYLEN * $03]     ; Fourth  dir entry - $60-$7f
DIR4TH_LEN        = DIRENTRYLEN             ; 
DIR5TH            = [DIRENTRYLEN * $04]     ; Fifth   dir entry - $80-$9f
DIR5TH_LEN        = DIRENTRYLEN             ; 
DIR6TH            = [DIRENTRYLEN * $05]     ; Sixth   dir entry - $a0-$bf
DIR6TH_LEN        = DIRENTRYLEN             ; 
DIR7TH            = [DIRENTRYLEN * $06]     ; Seventh dir entry - $c0-$df
DIR7TH_LEN        = DIRENTRYLEN             ; 
DIR8TH            = [DIRENTRYLEN * $07]     ; Eighth  dir entry - $e0-$ff
DIR8TH_LEN        = DIRENTRYLEN             ; 
; -------------------------------------------------------------------------------------------------------------- ;
DIRLEN            = [DIRENTRYLEN * $08 - $01] ; 
; -------------------------------------------------------------------------------------------------------------- ;
