; -------------------------------------------------------------------------------------------------------------- ;
; VC1541 - DOS ROM ($c000) $c100 - $ffff
; -------------------------------------------------------------------------------------------------------------- ;
; Communications / File Management
; -------------------------------------------------------------------------------------------------------------- ;
DRVTYPE           = $c000       ; used with std drive typ checks
DRVTYPE_1541        = $97       ; VIC1541/VIC1541-II
DRVTYPE_1571        = $38       ; VIC1571
DRVTYPE_1581        = $c0       ; VIC1581
DRVTYPE_MSD         = $32       ; MSD Super Disk
; -------------------------------------------------------------------------------------------------------------- ;
; $c001 - $cfff   - unused      ; filled with $aa
; -------------------------------------------------------------------------------------------------------------- ;
SETLDA            = $c100       ; turn on drive-active LED for drive 0 / Turn off drive-active LED for drive 1
                                ; set bit 3 of DSKCNT ($1C00) to turn on LED for the current drive in DRVNUM ($7f)
LEDSON            = $c118       ; set bit 3 of DSKCNT ($1C00) to turn on drive active LED for drive 0
ERROFF            = $c123       ; turn off error LED: Store $00 in ERWORD ($026C) and in ERLED ($026D)
                                ; to clear any error status and turn off drive-active/error LED
ERRON             = $c12c       ; turn on error LED: Store $80 in ERWORD ($026C) to ensure LED will continue to flash 
                                ; and set bit 3 of DSKCNT to turn the LED on using the LED mask from LEDMSK ($FECA)
PARSXQ            = $c146       ; parse string in command buffer:
                                ; clear the "don't write BAM" flag WBAM ($02F9) and move the drive number of the
                                ; last successful job from LSTDRV ($028E) to DRVNUM ($7F) - makes the last used drive the default drive
ENDCMD            = $c194       ; terminate a command
                                ; clear the "don't write BAM" flag WBAM ($02F9) - load .A with the error status from ERWORD ($026C)
                                ; if non-zero an error has occurred so exit with a JMP to CMDERR ($ClC8)
CLRCB             = $c1bd       ; clear the command buffer ($0200-$0228)
                                ; erase any old command information by overwriting the old command with $00
CMDERR            = $c1c8       ; command level error handling: .A must contain the error number
                                ; set TRACK ($80) and SECTOR ($81) to $00 and JMP to CMDER2 ($E645)
SIMPRS            = $c1d1       ; init .X and the file table pointer FILTBL ($027A) to $00
                                ; load .A with a $3A (:) and JSR to PARSE ($C268) to scan the command string for a colon
                                ; if found: the pos ist stored in .Y / pos minus $02 is stored in FILTBL ($027A) / LED is switched on
PRSCLN            = $c1e5       ; find colon (:) in command string:
                                ; load .X and .Y with $00 and .A with $3A (:) and JMP to PARSE ($C268).
                                ; 
                                ; cmds RENAME, SCRATCH, NEW, LOAD are analyzed by this routine to determine their structure.
                                ; bits in IMAGE ($028B) are set/cleared to indicate the presence/absence of various cmd parts
                                ; the cmd structure image is then checked against its correct structure in STRUCT ($FEA5)
                                ;                                                             
PRSCLN_N2          = %00000001  ;  filename2 given
PRSCLN_D2          = %00000010  ;  drive # specified (not default)
PRSCLN_G2          = %00000100  ;  more than one file implied (Y=1)
PRSCLN_P2          = %00001000  ;  wild cards present (Y=1)

PRSCLN_N1          = %00010000  ;  filenamel given
PRSCLN_D1          = %00100000  ;  drive # specified (not default)
PRSCLN_G1          = %01000000  ;  more than one file implied (Y=1)
PRSCLN_P1          = %10000000  ;  wild cards present (Y=1)
                                ;
                                ; NOTE: Bits 7-4 refer to file #1
                                ;       Bits 3-0 refer to file #2
TAGCMD             = $c1ee      ; find a ':' '=' or ',' in cmd string - multi part cmd string (R0:NEWNAME=OLDNAME)
PARSE              = $c268      ; search the cmd string for the char in .A
                                ; .Y = start pos / .X = file table pointer FILTBL ($027A)
                                ; special chars like '*', '?' ',' are taken into account
                                ; the z-flag is set if the char in .A isn' found
                                ; store the desired character in CHAR ($0275)
CMDSET             = $c2b3      ; init all cmd tables / init all variables / return an error msg if cmd sting is too long
                                ; .Y = BUFTAB+CBPTR ($A3) - cmd string length
CMDRST             = $c2dc      ; zero all important variables & pointers
                                ;   BUFTAB+CBPTR ($A3) 
                                ;   ENTSEC       ($d8-dc)
                                ;   ENTIND       ($dd-e1)
                                ;   FILDRV       ($e2-e6)
                                ;   PATTYP       ($e7-eb)
                                ;   REC          ($0258)
                                ;   TYPE         ($024a)
                                ;   TYPFLG       ($0296)
                                ;   FlPTR        ($00d3)
                                ;   F2PTR        ($0279)
                                ;   PATFLG       ($028a)
                                ;   ERWORD       ($026c)
                                ;   FILTBL       ($027a-$027f)
                                ;   FILTRK       ($0280-$0284)
                                ;   FILSEC       ($0285-$0289)
ONEDRV             = $c312      ; set first drive & table pointers
SETDRV             = $c33c      ; get drive number from cmd string or set default 0
SETANY             = $c368      ; set drive number from any configuration
TOGDRV             = $c38f      ; toggle drive number in DRVNUM ($7F)
FSlSET             = $c398      ; set pointer to file name and check type
TST0V1             = $c3bd      ; test drive number in .A is ASCII 0 or 1 - set bit7=1 if no match found
OPTSCH             = $c3ca      ; determine optimal search for LOOKUP and FINFIL
SCHTBL             = $c440      ; search table
LOOKUP             = $c44f      ; look up all files in command string in the directory and fill tables with info
FFRE               = $c48b      ; find next matching file name in the directory
COMPAR             = $c4d8      ; compare all file names in command list with each valid entry in the directory
CMPCHK             = $c589      ; check table for unfound files - set all-files-found flag FOUND ($028F)
SRCHST             = $c5ac      ; Initiate search of directory - init all default values
SEARCH             = $c617      ; find next valid entry with number of entries left in the buffer from FILCNT ($0295)
AUTOI              = $c63d      ; check drive for active diskette - init if disk was changed
TRNAME             = $c66e      ; transfer filename from CMD buffer to DIR buffer
TRCMBF             = $c688      ; transfer CMD buffer to another buffer
FNDLMT             = $c6a6      ; find the limit(end) of the string in the command buffer that is pointed to by .X
GETNAM             = $c6ce      ; get file entry from directory - save secondary address SA ($83) on the stack
GNSUB              = $c6de      ; get file entry subroutine - set current secondary address SA ($83)
BLKNB              = $c7ac      ; blank the buffer for the name in the directory
NEWDIR             = $c7b7      ; create new directory header for listing in the dir buffer $02B0-02D4
MSGFRE             = $c806      ; create message line "BLOCKS FREE" in the dir buffer $02B0-02D4
FREMSG             = $c817      ; Tab: Message "BLOCKS FREE"
SCRTCH             = $c823      ; Command: SCRATCH - scratch one or more files
DELFIL             = $c87d      ; delete file by links - free blocks in BAM - write BAM
DELDIR             = $c8b6      ; delete file entry in the directory
BACKUP             = $c8c1      ; Command: BACKUP - duplicate disk - not available on the 1541
FORMAT             = $c8c6      ; store a JMP FORMT ($fac7) in BUF0 (DC formatting routine)
DSKCPY             = $c8f0      ; Command: COPY - copy disk files
PUPS1              = $c932      ; set up parameters for copying an entire disk (not used on 1541)
COPY               = $c952      ; copy file(s) to one file
CY                 = $c9a7      ; copy the files
OPIRFL             = $c9fa      ; open internal read channel to read file
GIBYTE             = $ca35      ; get a byte from internal read channel
                                ; set secondary address SA ($83) to $11 for the internal read channel
GCBYTE             = $ca39      ; get a byte from any channel
CYEXT              = $ca53      ; copy relative records
RENAME             = $ca88      ; Command: RENAME - rename a file in the directory
CHKINF             = $cacc      ; check the existance of the input file
CHKIO              = $cae7      ; check if two files have the same name
MEM                = $caf8      ; Commands: memory access commands (M-R, M-W, M-E)
MEMEX              = $cb1d      ; do indirect jump using the pointer set up in TEMP ($006F)
MEMRD              = $cb20      ; Command: M-R
MRMULT             = $cb2b      ; get the number of bytes to read
MEMERR             = $cb4b      ; error msg: print '3l, SYNTAX ERROR'
MEMWRT             = $cb50      ; Command: M-W
USER               = $cb5c      ; Command: USER
OPNBLK             = $cb84      ; open direct access buffer in response to an OPEN "#" command
BLOCK              = $cc1b      ; Commands: Block commands (B-A, B-F, B-R, B-W, B-E, B-P)
BLKCMD             = $cc5d      ; table: names of the BLOCK commands ("AFRWEP")
BLKJMP             = $cc63      ; block jump table
                                ;   $cc63-cc64 - BLOCK-ALLOCATE  $cd03
                                ;   $cc65-cc66 - BLOCK-FREE      $ccf5
                                ;   $cc67-cc68 - BLOCK-READ      $cd56
                                ;   $cc69-cc6a - BLOCK-WRITE     $cd73
                                ;   $cc6b-cc6c - BLOCK-EXECUTE   $cda3
                                ;   $cc6d-cc6e - BLOCK-POINTER   $cdbd
BLKPAR             = $cc6f      ; get and parse the block command parameters
ASCHEX             = $cca1      ; convert ASCII to HEX and store the converted values in the FILTRK ($0280) and FILSEC ($0285) tables
DECTAB             = $ccf2      ; Table: decimal conversion
DECTAB_01          = $ccf2      ;   byte $01 =   1
DECTAB_0a          = $ccf3      ;   byte $0A =  10
DECTAB_64          = $ccf4      ;   byte $64 = 100
BLKFRE             = $ccf5      ; Command B-F: free (de-allocate) block in the BAM
unused_ccfe        = $ccfe      ; unused code: LDA #$01 / STA WBAM($02F9)
BLKALC             = $cd03      ; Command: B-A - allocate a sector (block) in the BAM
BLKRD2             = $cd36      ; B-R sub routine to test parameters and to read a block from disk
GETSIM             = $cd3c      ; B-R sub routine to get byte w/o increment from buffer into .A
BLKRD3             = $cd42      ; B-R Sub to do read a block from disk
BLKRD              = $cd56      ; Command: B-R - block read a sector
UBLKRD             = $cd5f      ; Command: U1  - block read of a sector (B-R alternative)
BLKWT              = $cd73      ; Command: B-W - block-write of a sector
UBLKWT             = $cd97      ; Command: U2  - block write of a sector (B-W alternative)
BLKEXC             = $cda3      ; Command: B-E - block execute a sector
BLKEXCJ            = $cdba      ; JMP (TEMP)   - execute the pgm with B-E
BLKPTR             = $cdbd      ; Command: B-P - set the buffer pointer
BUFTST             = $cdd2      ; test whether a buffer has been allocated for the secondary address given in SA
                                ; open the channel / allocate buffer - eventually print 'NO CHANNEL'
BKOTST             = $cdf2      ; test all block parameters - buffer allocated and legal block
                                ; if OK: set up drive, track, sector values
FNDREL             = $ce0e      ; find a data block in a REL file
                                ; 
                                ;   INPUTS     (ALL 1 BYTE)            OUTPUTS
                                ;   ------------------------------------------
                                ;    RECL    - record # (lo byte)      SSNUM
                                ;    RECH    - record # (hi byte)      SSIND
                                ;    RS      - record size             RELPTR
                                ;    RECPTR  - pointer into record
DIV254             = $ce6e      ; divide routine: divide by 254 entry point
DIV120             = $ce71      ;                 divide by 120 entry point:
                                ;                 result: quotient in $8B, $8C, $8D / remainder in in $90
ZERRES             = $ced9      ; zero the RESULT area $8B, $8C, $8D
ACCX4              = $cee2      ; multiply ACCUM by 4
ACCX2              = $cee5      ; multiply ACCUM by 2
ADDRES             = $ceed      ; add ACCUM to RESULT
LRUINT             = $cefa      ; init LRU (least recently used) table
LRUUPD             = $cf09      ; update LRU (least recently used) table:
DBLBUF             = $cf1e      ; double buffer: switch the active and inactive buffers.
DBL30              = $cf76      ; no buffers to steal  - print error 'NO CHANNEL'
DBSET              = $cf7b      ; set up double buffering - look for a free buffer
TGLBUF             = $cf8c      ; toggle the inactive & active buffers
PIBYTE             = $cf9b      ; write byte via the internal write channel into a buffer
PUTBYT             = $cff1      ; put byte in .A into the active buffer
INTDRV             = $d005      ; Command: INITIALIZE - initialize drive(s) (Disk command)
ITRIAL             = $d00e      ; initialize drive given in DRVNUM:
INITDR             = $d042      ; read BAM / initialize drive
NFCALC             = $d075      ; calculate the number of free blocks in BAM
STRRD              = $d09b      ; start reading ahead a block
STRDBL             = $d0af      ; start double buffering: (reading ahead)
                                ;   read a block and the following block into a 2nd buffer
RDBUF              = $d0c3      ; start a read  job of TRACK and SECTOR
WRTBUF             = $d0c7      ; start a write job of TRACK and SECTOR
STRTIT             = $d0c9      ; store command desired (in .A) as the current command in CMD ($024D)
FNDRCH             = $d0eb      ; find and open the assigned read  channel
FNDWCH             = $d107      ; find and open the assigned write channel
TYPFIL             = $d125      ; get current file type / check for REL file
GETPRE             = $d12f      ; get and set buffer and channel pointers
GETBYT             = $d137      ; read one byte from the active buffer
RDBYT              = $d156      ; read byte from file - next block of the file read if necessary - EOI if last byte was read
WRTBYT             = $d19d      ; write char to the active channels buffer - if this fills the buffer write it out to disk
INCPTR             = $d1c6      ; increment the pointer of the active buffer by .A
SETDRN             = $d1d3      ; get and set drive number
GETWCH             = $d1df      ; search/open a new WRITE channel and the alloc a corresponding buffer
GETRCH             = $d1e2      ; search/open a new READ  channel and the alloc a corresponding buffer
FRECHN             = $d227      ; free all channels associated with SA
RELBUF             = $d25a      ; release buffers associated with channel - .X=channel #
GETBUF             = $d28e      ; get a free buffer number - .Y=channel #
FNDBUF             = $d23a      ; find a free buffer and set BUFUSE:
                                ; on entry: .Y = index into BUFUSE
                                ;   .Y = $00 - buffers $00-$07
                                ;   .Y = $01 - buffers $08-$0f
                                ; if successful    : .X = buffer number
                                ; if not successful: .X = $ff - N flag set
FREIAC             = $d2da      ; free the inactive buffer:
FREBUF             = $d2f3      ; free buffer in BUFUSE
CLRCHN_1541        = $d307      ; clear all channels except the CMD channel
                                ; ($83) to $0e (#14)
CLDCHN             = $d313      ; close all channels except the CMD one:
STL3UF             = $d339      ; steal an inactive buffer selected in .A
FNDLDX             = $d37f      ; find free LINDX and allocate in LINUSE
GBYTE              = $d39b      ; get next byte from a channel:
GET                = $d3aa      ; get next byte from any type of file
GETERC             = $d414      ; get byte from the error channel
NXTBUF             = $d44d      ; read in the next block of a file by following the track and sector link
                                ; set an EOF (end of file) indicator if the track link (first byte) is $00
DRTRD              = $d460      ; direct block read : load .A with the job code for read  ($83)
DRTWRT             = $d464      ; direct block write: load .A with the job code for write ($90)
OPNIRD             = $d475      ; open internal read channel: (SA=17)
                                ; entry point for PRG files - load .A with $01 (program file type)
OPNTYP             = $d477      ; open internal read channel (.A = any type) - read first block
OPNIWR             = $d486      ; open internal write channel (SA=18)
NXDRBK             = $d48d      ; alloc and write the next directory block
SETPNT             = $d4c8      ; set up pointer into active data buffer - on entry: .A contains new pointer value
FREICH             = $d4da      ; free both internal channels: (SA=17 SA=18 - READ WRITE)
GETPNT             = $d4e8      ; get the active buffer pointer:
DRDBYT             = $d4f6      ; direct read of a byte from the active buffer
                                ;   on entry: .A = position of byte in buffer
                                ;   on exit : .A = requested data byte
SETLJB             = $d506      ; check trak/sector number for job loop - CMD = job code / .X = buffer number
SETJOB             = $d50e      ; save new job code on stack / the buffer number to use (.X) in JOBNUM ($f9)
HED2TS             = $d552      ; set desired track and sector values for the active job
TSCHK              = $d55f      ; check for legal track / sector values
VNERR              = $d572      ; get track / sector number for the DOS-Mismatch message
SJB1               = $d57a      ; conclude job set up - load .X with the number of the buffer to use for the job from JOBNUM ($F9)
DOREAD             = $d586      ; do a read  job - load .A with the read  job code ($80) - return OK when done
DOWRIT             = $d58a      ; do a write job - load .A with the write job ccde ($90) - return OK when done
WATJOB             = $d599      ; wait until job is completed
TSTJOB             = $d5a6      ; test if job has ended without errors
                                ; on any disk error (except WRITE PROTECT or ID MISMATCH) a reread is tried with HEAD adjustment
HEDOFF             = $d676      ; adjust head offset position in relation to the actual position
                                ; on entry: .A = OFFSET (number of the necessary steps)
                                ;           .A < $80 - move head outward
                                ;           .A > $7f - move head inward
MCVHED             = $d693      ; step head $01 track inward or outward
DOREC              = $d6a6      ; load .A with the retry counter REVCNT ($6A) in case of any errors
SETHDR             = $d6d0      ; supply parms for the next job to DC - uses values in TRACK, SECTOR, DSKID
ADDFIL             = $d6e4      ; add new filename to the directory
OPSER              = $d7b4      ; open a channel got from serial bus
                                ; the open, load, or save command is parsed - SA range is $00 - $0e
                                ; a channel is allocated and the directory is searched for the filename specified in the command.
OPREPL             = $d8f5      ; open a file to REPLACE 
OPREAD             = $d9a0      ; open a file to READ
OPWRIT             = $d9e3      ; open a file to WRITE
CKTM               = $da09      ; check file mode or file type
APPEND             = $da2a      ; prepare file for APPEND
                                ; append information to the end of a file - read through old file to end
LOADIR             = $da55      ; load the directory ($)
CLSSEC             = $dac0      ; close the file related to the specified secondary address
CLSALL             = $daec      ; close all files if CMD channel is closed
CLSCHN             = $db02      ; close file with specified secondary address
CLSWRT             = $db62      ; close a sequential file write channel - write last block of a file
CLSDIR             = $dba5      ; close/update directory after writing a file
OPNRCH             = $dc46      ; open read channel with two buffers
                                ; set secondary adr in LINTAB / init all pointers (including the ones for a REL file)
INITP              = $dcb6      ; Init parms for open channel
OPNWCH             = $dcda      ; open write channel with two buffers
PUTSS              = $dd8d      ; write byte into the side sector:
SCFLG              = $dd95      ; set/clear af all most important flags
TSTFLG             = $dda6      ; test file type flags
TSTWRT             = $ddab      ; test if this is a write job
TSTCHN             = $ddb7      ; test for active files in LINDX tables:
                                ;   .C=0 - file active   .X=ENTFND / .Y=LINDX
                                ;   .C=1 - file inactive .X=18
SCRUB              = $ddf1      ; write out buffer if it is dirty
                                ; Note: a buffer is 'dirty' if the copy in RAM has been modified so it does not match the copy on disk
SETLNK             = $ddfd      ; put TRACK and SECTOR into header (file linker)
GETLNK             = $de0c      ; set TRACK and SECTOR from link in buffer
NULLNK             = $de19      ; set track link to $00 and sector link to the last non-zero character in buffer
                                ; (last block of a file)
BUFPTR             = $de2b      ; set up pointer to active buffer
CURBLK             = $de3b      ; set TRACK and SECTOR from header
WRTAB              = $de50      ; exec the READ and WRITE jobs
RDLNK              = $de95      ; set next TRACK and SECTOR from link in buffer
BOTOBO             = $dea5      ; move bytes from one buffer to another
                                ; on entry: 
                                ;   .A = number of bytes to move
                                ;   .Y = from buffer number
                                ;   .X = to buffer numbe
CLRBUF             = $dec1      ; clear buffer - .A = buffer number
SSSET              = $ded2      ; get side-sector number
SSDIR              = $dedc      ; set DIRBUF to side sector - On entry: .A = lo byte
SETSSP             = $dee9      ; set DIRBUF and BUFTAB from side sector SS pointer
SSPOS              = $def8      ; use SSNUM and SSIND to set side sector and BUFTAB
                                ; on return: V = 0: all OK
                                ;            V = 1: out of range - no side sector
IBRD               = $df1b      ; indirect block read
                                ; on entry: .A = buffer number for R/W
                                ;           .X = active buffer (LINDX)
                                ;           .Y = Y points to T&S to be R/W (DIRBUF)
IBWT               = $df21      ; indirect block write
                                ; on entry: .A = buffer number for R/W
                                ;           .X = active buffer (LINDX)
                                ;           .Y = Y points to T&S to be R/W (DIRBUF)
GSSPNT             = $df45      ; get side sector pointers
SCAL1              = $df4c      ; calculate total block number of a REL file
SSTEST             = $df66      ; test SSNUM and SSIND for range and residence for a side sector block in buffer
                                ; Flag meanings on exit:
                                ; +---------+-------------+
                                ; ! N Range ! V Residence !
                                ; +---------+-------------+
                                ; ! 0 OK    !  0 YES ER0  !
                                ; ! 0 MAYBE !  1 NO  ER1  !
                                ; ! 1 BAD   !  0 YES ER2  !
                                ; ! 1 BAD   !  1 NO  ER3  !
                                ; +----------+------------+
GETACT             = $df93      ; get active buffer number
                                ; on exit: 
                                ;   .A = active buffer number
                                ;   .X = LINDX
                                ;   Flag N = 1 if no active buffer
GAFLGS             = $df9e      ; get active buffer & set LBUSED:
                                ; On exit: 
                                ;   .A = active buffer number
                                ;   .X = LINDX
                                ;   Flag N = 1 if no active buffer
                                ;   Flag V = 1 if buffer is dirty
GETINA             = $dfb7      ; get a channel's inactive buffer number
                                ;   On entry: LINDX = channel number
                                ;   On exit : .A = buffer number or $ff if none
PUTINA             = $dfc2      ; free buffer or set the inactive buffer's buffer number given in .A
NXTREC             = $dfd0      ; set up next record of a REL file
NRBUF              = $e03c      ; generate next record in buffer - write previous block
RELPUT             = $e07c      ; write relative record - write a byte into record buffer
WRTREL             = $e0ab      ; write out relative records
CLREC              = $e0f3      ; fill the rest of a relative record with zeroes
SDIRTY             = $e105      ; set buffer dirty flag - buffer was modified
CDIRTY             = $e115      ; clear buffer dirty flag
RDREL              = $e120      ; read relative record - get a byte from record buffer
SETLST             = $e16e      ; set pointer to last character in record
FNDLST             = $e1b2      ; find last non-zero character in record
SSEND              = $e1cb      ; set side sector and BUFTAB to end of last record
RECORD             = $e207      ; Command: RECORD - Position pointer to given record
POSITN             = $e275      ; position to record - moves relative record into active buffer and the next block into inactive buffer
POSBUF             = $e29c      ; write proper data blocks into buffers
BHERE              = $e2d0      ; check if desired block is in buffer - compare buffer track/sector numbers with TRACK/SECTOR
NULBUF             = $e2e2      ; set null ($00) records in active buffer
ADDNR              = $e304      ; check if next record still fits into buffer - on exit: C = 1 if crossed buffer boundary
ADDREL             = $e31c      ; add blocks to a relative file - update side sectors
NEWSS              = $e44e      ; create a new side sector and change the old side sectors to reflect it
------------------------------------------------------------------------------
E4FC               = $e4fc      ; Table: DOS Error Messages
                                ;
                                ; Each entry consists of:
                                ;   - a  list of the applicable error numbers
                                ;   - a  token (with bit7=1) of the entry in Table of Tokenized Words
                                ;   - an error message text - last char has bit7=1
                                ;
E4FC               = $e4fc      ; 00, oK
E500               = $e500      ; 20/21/22/23/24/27, Read ErroR
E50B               = $e50b      ; 52, FilE too largE
E517               = $e517      ; 50, RecorD NoT presenT
E522               = $e522      ; 51, Overflow in RecorD
E52F               = $e52f      ; 25/28, WritE ErroR
E533               = $e533      ; 26, WritE protect oN
E540               = $e540      ; 29, DisK id MismatcH
E546               = $e546      ; 30/31/32/33/34, Syntax ErroR
E552               = $e552      ; 60, WritE FilE OpeN
E556               = $e556      ; 63, FilE existS
E55F               = $e55f      ; 64, FilE type MismatcH
E567               = $e567      ; 65, No blocK
E570               = $e570      ; 66/67, Illegal track or sectoR
E589               = $e589      ; 61, FilE NoT OpeN
E58D               = $e58d      ; 39/62, FilE NoT FounD
E592               = $e592      ; 01, FilE 's scratcheD
E59F               = $e59f      ; 70, No channeL
E5AA               = $e5aa      ; 71, Dir ErroR
E5AF               = $e5af      ; 72, DisK fulL
E5B6               = $e5b6      ; 73, Cbm dos v2.6 1541
E5C8               = $e5c8      ; 74, Drive NoT readY
------------------------------------------------------------------------------
                                ; Table: Tokenized Words
E5D5               = $e5d5      ; $09 ErroR
E5DB               = $e5db      ; $0a WritE
E5E1               = $e5e1      ; $03 FilE
E5E6               = $e5e6      ; $04 OpeN
E5EB               = $e5eb      ; $05 MismatcH
E5F4               = $e5f4      ; $06 NoT
E5F8               = $e5f8      ; $07 FounD
E5FE               = $e5fe      ; $08 DisK
E603               = $e603      ; $0b RecorD
------------------------------------------------------------------------------
ERROR_1541         = $e60a      ; save the error code onto the stack after job execution - .A = error number .X=buffer number
TLKERR             = $e680      ; TALK error recovery - release all bus lines and go idle
LSNERR             = $e688      ; LISTEN error recovery - release all bus lines and go idle
HEXDEC             = $e69b      ; convert a hex number to BCD
                                ;   on entry: .A contains hex number
                                ;   on exit : .A contains BCD number
OKERR              = $e6bc      ; transfer error message to error buffer
ERMOVE             = $e706      ; move the error message from the error table to the error buffer - tokens are converted into text
EADV1              = $e767      ; advance error pointer - get byte from table - transfer bit7 into carry
EADV2              = $e775      ; advance error pointer
BOOT               = $e780      ; AUTOBOOT - used to load and execute user programs or system utilities from disk
                                ;          - only available with 'old' ROMs (end number -03)
                                ;          - removed in 'new' ROMs (end number -05)
                                ; 
                                ; may be used in two ways:
                                ; a) AUTOBBOOT on power-up
                                ;    routine is entered if the data and clock lines are grounded at power up
                                ;     - it waits until the ground clip is removed
                                ;     - it then loads the first file found in the directory into disk RAM 
                                ;       using the first two bytes of the file as the load address 
                                ;     - start execution at the first byte
                                ; b) normal entry
                                ;    the disk command "&:filename" will load and execute the file with the specified filename
                                ;    for example: PRINT#15,"&0:DISK TASK"
                                ;
                                ; the utility or program must be of the following form:
                                ;   File type: USR
                                ;   Bytes 1/2: Load address in disk RAM (lo/hi).
                                ;   Byte 3   : Lo byte of the length of the routine
                                ;   Bytes 4/N: Disk routine machine code.
                                ;   Byte N+1 : Checksum
                                ;            : Note: the checksum includes all bytes including the load address
                                ;            :       formula: CHECKSUM = CHECKSUM + BYTE + CARRY                                
                                ;     ($1800). T r a n s f e r data from .A to .
UTLODR             = $e7a3      ; Command: &
ADDSUM             = $e84b      ; compute the running checksum in R1 - on entry: .A = new byte to add
ATNIRQ             = $e853      ; entry point for IRQ routine to service attention (ATN) signals from the C64
ATNSRV             = $e85b      ; service the attention request from the C64
                   = $e909      ; send a data byte to the serial bus in response to a TALK from the C64
DATHI              = $e99c      ; set DATA OUT line high
DATLOW             = $e9a5      ; Set DATA OUT line low
CLKLOW             = $e9ae      ; set CLOCK    line low
CLKHI              = $e9b7      ; set CLOCK    line high
DEBNC              = $e9c0      ; wait for response on bus
ACPTR_1541         = $e9c9      ; get a data byte from the serial bus in response to a LISTEN from the C64
LISTEN_1541        = $ea2e      ; main LISTEN routine - get data from bus - write data into the active buffer
TSTATN             = $ea59      ; test if in ATN mode
PEZRO              = $ea6e      ; SELFTEST - no error
PERR               = $ea71      ; HARDWARE ERROR - flash LED slowly - lock the drive
DSKINT             = $eaa0      ; complete RESET of the VC1541 disk drive
DIAGOK             = $eb22      ; short    RESET of the VC1541 disk drive - buffers are not cleared
IDLE               = $ebe7      ; STANDBY idle loop - wait for job
STDIR              = $ec9e      ; start loading/preparation of the directory
DIR3               = $ed23      ; end preparation of the directory
MOVBUF             = $ed59      ; transfer directory line to listing buffer
GETDIR             = $ed67      ; get char from directory - eventually load next block
VERDIR             = $ed84      ; Command: VALIDATE
VD15               = $edb3      ; process blocks of a directory entry - allocate blocks in BAM
VMKBAM             = $ede5      ; track file by its links and mark BAM - allocate blocks in BAM
NEW                = $ee0d      ; Command: NEW
                                ;   - full or long NEW 
                                ;       - marks off the tracks/sectors on a disk
                                ;       - writes $00 data blocks to all sectors
                                ;   - short NEW
                                ;       - merely creates a new BAM and directory on track 18
NEWMAP             = $eeb7      ; create a new BAM map
MAPOUT             = $eef4      ; write out 'dirty' BAM from buffer to the drive specified in LSTJOB
SETBPT             = $ef3a      ; read BAM if not already in RAM - set the pointers to the BAM
NUMFRE             = $ef4d      ; get the number of blocks free from NDBL/NDBK ($02fa/$02fc) on the drive specified in DRVNUM
WFREE              = $ef5c      ; mark the block specified in TRACK and SECTOR as free in the BAM
DTYBAM             = $ef88      ; set dirty-BAM flag
                                ;   indicates that the copy of the BAM in disk RAM does not match the disk copy
WUSED              = $ef90      ; mark the block specified in TRACK and SECTOR as USED in the BAM
FREUSE             = $efcf      ; calculate index into the BAM for FRETS and USEDTS
                                ;   on exit: Z flag = 1 - block used in BAM
                                ;            Z flag = 0 - block free in BAM
BMASK              = $efe9      ; table: bit masks
BMASK_01             = $efe9    ;   $01 - 1
BMASK_02             = $efea    ;   $02 - 2
BMASK_04             = $efeb    ;   $04 - 4
BMASK_08             = $efec    ;   $08 - 8
BMASK_10             = $efed    ;   $10 - 16
BMASK_20             = $efee    ;   $20 - 32
BMASK_40             = $efef    ;   $40 - 64
BMASK_80             = $eff0    ;   $80 - 128
FIXBAM             = $eff1      ; write out BAM to disk if value in WBAM indicates that it is necessary
CLRBAM             = $f005      ; clear the BAM buffer
SETBAM             = $f011      ; create BAM images in buffer
SWAP               = $f05b      ; swap   BAM images in buffer
PUTBAM             = $f0a5      ; transfer memory image of BAM into the correct position in disk RAM
CLNBAM             = $f0d1      ; set the track number for BAM images to zero
REDBAM             = $f0df      ; read BAM from disk if not already in RAM
BAAM2X             = $f119      ; load .X with the channel number for the BAM
NXTTS              = $f11e      ; given the current track and sector the next available track and sector is searched
FNDNXT             = $f173      ; find the optimum next sector on this track - Next sector = Current + change (#10)
INTTS              = $f1a9      ; find and alloc the optimum initial track and sector
GETSEC             = $f1fa      ; set the BAM and find the first available sector starting at SECTOR
AVCK               = $f220      ; check the validity of the BAM bit map
MAXSEC             = $f24b      ; returns the max number of sectors allowed on this track - track number in .A
; -------------------------------------------------------------------------------------------------------------- ;
; Disk Controller Routines
; -------------------------------------------------------------------------------------------------------------- ;
CNTINT             = $f259      ; init the DC (disk controller) registers
LCC                = $f2b0      ; main IRQ controller loop:
                                ;   - scans the job queue for job requests
                                ;   - finds job on current track if it exists
TOP                = $f2be      ; top of loop to scan job queue - load .Y with #$05 as pointer to top of queue
BMP                = $f37c      ; exec a BUMP to track #1
SETJB              = $f393      ; set BUFPNT ($30/31) and HDRPNT ($32) for this position in job queue
SEAK               = $f3b1      ; search for a valid header block on this track
                                ;   Up to 90 header and data blocks are scanned while looking for a valid header block
                                ;   before giving up - a header block is considered valid if it has:
                                ;     1 - a SYNC mark
                                ;     2 - a header block ID ($08)
                                ;     3 - a valid checksum  (EOR of sector/track, ID1, ID2)
                                ;     4 - the sector number
                                ;     5 - the track number
                                ;     6 - ID2 (2nd ID chr given when formatted)
                                ;     7 - ID1 (1st ID chr given when formatted)
                                ;   NOTE: The actual order of these bytes is as given above - not as listed in the 1541 manual
WSECTD             = $f423      ; determine best sector on this track to service (optimum is current sector + $02)
CNVRIN             = $f497      ; convert GCR image of header in STAB into a normal 8 bit binary
                                ; store the values into HEADER ($16-$1A)
                                ; 
                                ;   HEADER      - Header block ID code  (usually $08)
                                ;   HEADER_CHR2 - ID2 (2nd ID chr given when formatted)
                                ;   HEADER_CHR1 - ID1 (1st ID chr given when formatted)
                                ;   HEADERTRK   - Sector number
                                ;   HEADERSEC   - Track number
                                ;   HEADERCHK   - Header block checksum (EOR of sector/track, ID1, ID2)
                                ; 
                                ; the remaining characters are junk!
REED               = $f4ca      ; check jobcode READ - read in/decode the track and sector that is specified in the header table
DSTRT              = $f50a      ; call SRCH ($f510) to find the desired header block
                                ; call SYNC ($f556) to wait for the data block sync char
SRCH               = $f510      ; find a specific header - the track and sector desired must be stored in the header table
SYNC               = $f556      ; wait for SYNC mark (10 or more consecutive 1's bits) on disk
                                ; it is used to identify the start of a block of information recorded on disk
                                ; the first character following a SYNC mark is used to determine whether this is
                                ;   - a header block ($08)
                                ;   - a data block   ($07)
WPIGHT             = $f56e      ; check for jobcode WRITE - write contents of data buffer to disk
CHKBLK             = $f5e9      ; calculate data block checksum EOR the $ff data bytes - return with the checksum in .A
WTOBIN             = $f5f2      ; convert the 10 bit GCR image of the data to normal 8 bit binary
                                ; Since 5 encoded bytes (40 bits) are converted into 4 normal bytes (32 bits)
                                ; the encoded form of 256 data bytes takes up 320 bytes
                                ; at start
                                ;   - the first 64 encoded bytes that were read are stored in the overflow buffer ($01ba-$01ff)
                                ;     the remaining 256 bytes are stored in the normal data buffer
                                ; at end:
                                ;   -  the decoded bytes are stored in the normal data buffer
VRFY               = $f691      ; check for jobcode VERIFY - then:
                                ;   - convert the data in the data buffer into its 10 bit encoded form (GCR)
                                ;   - compare the GCR image with what is recorded on the disk
                                ;   - convert the encoded data back into normal 8 bit binary form
SECTSK             = $f6ca      ; SRCH - do a sector search for a block header
PUT4GB             = $f6d0      ; convert 4 byte binary to 5 byte GCR
                                ; convert 4 normal 8 bit bytes into the 10 bit encoded form used for recording onto disk
                                ; 
                                ;   - break up each 8 bit normal byte into two 4-bit nybbles
                                ;   - find the 5-bit equivalent for each nybble by a BGTAB table lookup
                                ; 
                                ; patterns:
                                ;   - 4 normal 8 bit bytes stored in BTAB ($52-$55) as: AAAABBBB CCCCDDDD EEEEFFFF GGGGHHHH
                                ;   - 4 10 bit encoded bytes stored in buffer as      : aaaaabbb bbcccccd ddddeeee efffffgg ggghhhhh
------------------------------------------------------------------------------
BGTAB              = $f77f      ; Table: 5 bit GCR equivalents
                                ;
                                ; 4 bit nybble - 5 bit GCR code
                                ;
                                ; $00 - 0000    $0A - 01010
                                ; $01 - 0001    $0B - 01011
                                ; $02 - 0010    $12 - 10010
                                ; $03 - 0011    $13 - 10011
                                ; $04 - 0100    $0E - 01110
                                ; $05 - 0101    $0F - 01111
                                ; $06 - 0110    $16 - 10110
                                ; $07 - 0111    $17 - 10111
                                ; $08 - 1000    $09 - 01001
                                ; $09 - 1001    $19 - 11001
                                ; $0A - 1010    $lA - 11010
                                ; $0B - 1011    $lB - 11011
                                ; $0C - 1100    $0D - 01101
                                ; $0D - 1101    $lD - 11101
                                ; $0E - 1110    $lE - 11110
                                ; $0F - 1111    $15 - 10101
                                ;
                                ; Note: 5 bits are used to ensure that not more than 2 consecutive 0's are recorded on disk
------------------------------------------------------------------------------
BINGCR             = $f78f      ; create write image of data from the whole active buffer - a total of 325 GCR bytes is produced
                                ; convert 260 normal 8-bit bytes into their 10-bit equivalents to produce an image for writing to disk
                                ; 
                                ; The original 8-bit bytes are:
                                ;     1 data block ID character ($07)
                                ;   256 data bytes (stored in buffer X)
                                ;     1 data checksum
                                ;     2 off bytes ($00)
                                ; = 260 8-bit binary bytes
                                ; 
                                ; the first 69 GCR bytes are stored in the overflow buffer ($10bb-$10ff)
                                ; the rest of the GCR bytes are stored in buffer X and replace the original data bytes
GET4GB             = $f7e6      ; convert GCR to binary
                                ; decode 5 GCR bytes (used for recording on disk) from buffer (pointer in GCRPNT)
                                ; into 4 normal 8-bit binary bytes
                                ; 
                                ; decoding
                                ;   - extract 5 bits from one or two GCR bytes
                                ;   - get 4-bit equivalaent via table lookup
                                ; 
                                ; patterns:
                                ;   - 4 10 bit encoded bytes stored in buffer as      : aaaaabbb bbcccccd ddddeeee efffffgg ggghhhhh
                                ;   - 4 normal 8 bit bytes stored in GTAB ($56-$59) as: AAAABBBB CCCCDDDD EEEEFFFF GGGGHHHH
------------------------------------------------------------------------------
GCRHI              = $f8a0      ; table: of 5 bit GCR to binary - High
GCRLO              = $f8c0      ; table: of 5 bit GCR to binary - Low
                                ;
                                ;  +-----------------+---------------------+--------------------+
                                ;  ! 5 bit GCR code  ! High nybble ($f8a0) ! Low nybble ($f8c0) !
                                ;  +-----------------+---------------------+--------------------+
                                ;  !    $00 00000    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $01 00001    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $02 00010    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $03 00011    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $04 00100    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $05 00101    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $06 00110    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $07 00111    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $08 01000    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $09 01001    ! $80 1000----        ! $08 ----1000       !
                                ;  !    $0A 01010    ! $00 --------        ! $00 ----0000       !
                                ;  !    $0B 01011    ! $10 0001----        ! $01 ----0001       !
                                ;  !    $0C 01100    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $0D 01101    ! $C0 1100----        ! $0C ----1100       !
                                ;  !    $0E 01110    ! $40 0100----        ! $04 ----0100       !
                                ;  !    $0F 01111    ! $50 0101----        ! $05 ----0101       !
                                ;  !    $10 10000    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $11 10001    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $12 10010    ! $20 0010----        ! $02 ----0010       !
                                ;  !    $13 10011    ! $30 0011----        ! $03 ----0011       !
                                ;  !    $14 10100    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $15 10101    ! $F0 1111----        ! $0F ----1111       !
                                ;  !    $16 10110    ! $60 0110----        ! $06 ----0110       !
                                ;  !    $17 10111    ! $70 0111----        ! $07 ----0111       !
                                ;  !    $18 11000    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $19 11001    ! $90 1001----        ! $09 ----1001       !
                                ;  !    $lA 11010    ! $A0 1010----        ! $0A ----1010       !
                                ;  !    $lB 11011    ! $B0 1011----        ! $0B ----1011       !
                                ;  !    $lC 11100    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  !    $lD 11101    ! $D0 1101----        ! $0D ----1101       !
                                ;  !    $lE 11110    ! $E0 1110----        ! $0E ----1110       !
                                ;  !    $1F 11111    ! $FF 11111111 ERROR  ! $FF 11111111 ERROR !
                                ;  +-----------------+---------------------+--------------------+
GCRBIN             = $f8e0      ; decode GCR data image
                                ; decode the 69 GCR bytes stored in the overflow buffer ($10bb-$10ff) into normal 8-bit bytes
                                ; the decoded bytes are stored in a data buffer
CONHDR             = $f934      ; create a GCR image of an header block
                                ;  the header block ID code from HBID ($39) is used and the HEADER information is stored in:
                                ;   HEADER_CHR1 ($16)
                                ;   HEADER_CHR2 ($17)
                                ;   HEADERTRK   ($18)
                                ;   HEADERSEC   ($19)
                                ;   HEADERCHK   ($la)
ERRR               = $f969      ; disk controller error handling
                                ; terminate all of the major disk controller routines
                                ; 
                                ; inputs: 
                                ; the error code (see table) in .A, 
                                ; the job buffer number in JOBN ($3F)
                                ; the GCRFLG ($50) (indicates data in the buffer has been left in write image (1) or binary (0) form)
                                ; 
                                ; work:
                                ; stuff the error code into the job queue
                                ; convert the data back to binary (if necessary)
                                ; start time-out to turn off the drive motor
                                ; reset the stack pointer
                                ; exit to TOP ($f2be) to begin scanning the job queue again
TURNON             = $f97e      ; turn ON disk drive motor
                                ;   - store $a0 into drive status DRVST ($20) to indicate that the drive is ON but still accelerating
                                ;   - set bit 2 (00000100) of DSKCNT ($1c00) to turn ON the drive motor
                                ;   - store $3C into acceleration timer ACLTIM ($48) to cause drive status to be set 
                                ;     to up-to-speed after 1.5 seconds (60 interrupts at .025 seconds each)
TRNOFF             = $f98f      ; turn OFF disk drive motor
                                ;   - load .X with current drive # (0)
                                ;   - set bit 4 (00010000) of the drive status DRVST ($20) to indicate DRIVE IS OFF!
                                ;   - store $ff into acceleration timer to cause the drive to be turned OFF
                                ;     after 6.4 seconds (255 interrupts at .025 seconds each)
END                = $f99c      ; drive motor and head stepper control
                                ;   - last part of the main IRQ routine
                                ;   - executed every 10 milliseconds
                                ; control is transferred to the routine by JMP instructions at the end of the main DC routines
                                ; the RTS at the end of the routine transfers control to master IRQ routine at $fe7c
                                ; 
                                ; AND .A (contains drive status) with $40 to test if head must be moved
                                ; not $00 - stepping required - indirect JMP via NXTST ($0062) to the proper head stepping routine
                                ;     SHORT - $fa3b - short step mode
                                ;     SETLE - $fa4e - settle head mode
                                ;     SSACL - $fa7b - accelerate mode
                                ;     SSRUN - $fa97 - fast stepping mode
                                ;     SSDEC - $faa5 - decelerate mode
INACT              = $fa05      ; set up to step the head
SHORT              = $fa3b      ; short distance head stepping
                                ; check the number of steps left from STEPS ($4a) - if any left branch to DOSTEP ($fa2e)
                                ; if not - set NXTST pointer($62/$63) to point to the settle head routine SETLE ($fa4e)
                                ;        - store $05 in ACLSTP ($60) to set the settle time
SETLE              = $fa4e      ; settle head routine
                                ; decrement ACLSTP ($60) - if zero clear bit6 of drive status DRVST ($20) - indicate drive is available
                                ; set NXTST pointer($62/$63) to point to the head inactive routine ($fa05)
STPIN              = $fa63      ; service routine for stepper motor
                                ; decrement STEPS ($4a) to reduce number left to do by 1
                                ; cycling DSKCNT_STEPPER bits 0 & 1 of DSKCNT ($1c00) to move the head
                                ;   $00/$01/$10/$11/$00 - move the head inward
                                ;   $00/$11/$10/$01/$00 - move the head outward
SSACL              = $fa7b      ; accelerate head routine
SSRUN              = $fa97      ; fast stepping mode routine
                                ; decrement number of steps left to do in RSTEPS ($61)
                                ; if none left set the NXTST pointer ($62/$63) to point to the decelerate routine SSDEC ($faa5)
SSDEC              = $faa5      ; decelerate head routine
FORMT              = $fac7      ; format (NEW) a diskette - the FORMAT routine ($c8c6)
                                ;   - sets up a JMP FORMT ($fac7) at the start of buffer #0
                                ;   - puts an EXECUTE ($e0) job into the job queue at $03
                                ;   - waits for the job to be completed
SYNCLR             = $fda3      ; wipe out track by writing 40*256 SYNC marks
WRTNUM             = $fdc3      ; write out NUM ($0621/$0622) bytes
FMTERR             = $fdd3      ; format error handler
MOVUP              = $fde5      ; move .Y bytes in buffer #0 up 69 bytes to free space at buffer start
MOVOVR             = $fdf5      ; move 69 bytes from overflow buffer into the bottom of the data buffer pointed to by BUFPNT ($30/$31)
KILL               = $fe00      ; switch PCR2_HD_CTRL in PCR2 of DSKCNT from write to read mode
CLEAR              = $fe0e      ; wipe out track with 40*256 non-sync non-sync chars ($55)
FBTOG              = $fe30      ; convert header images in buffer #0 into GCR form without the header ID code
                                ; write result into the overflow buffer ($01bb-$01ff)
SYSIRQ             = $fe67      ; main system IRQ routine (IRQ vector points here)
                                ; IRQs are generated in two ways:
                                ;   1 - by an ATN signal from the VIC-20 or the C-64 on the serial bus
                                ;   2 - by a time out of the VIA timers every 10 milliseconds
                                ; this routine tests for the source of the IRQ signal and brnches to the correct ROM routine
------------------------------------------------------------------------------
                                ; Table: Directory / BAM Values
FE85               = $fe85      ; $12 - Directory track number (18)
FE86               = $fe86      ; $04 - Number of bytes/track in BAM
FE87               = $fe87      ; $04 - Offset of BAM in the sector
fe88               = $fe88      ; $90 - Offset of disk name in BAM sector
------------------------------------------------------------------------------
                                ; table: Command Search Table
FE89               = $fe89      ; $56 - V = Validate or collect disk
FE8A               = $fe8a      ; $49 - I = Initialize BAM & directory
FE8B               = $fe8b      ; $44 - D = Duplicate or backup disk (N.A.)
FE8C               = $fe8c      ; $4d - M = Memory operation (M-R, M-W, M-E)
FE8D               = $fe8d      ; $42 - B = Block operation (B-R, B-A, B-W, etc)
FE8E               = $fe8e      ; $55 - U = User jump commands (except U+ & U-)
FE8F               = $fe8f      ; $50 - P = Position (for REL files)
FE90               = $fe90      ; $26 - & = Utility loader
FE91               = $fe91      ; $43 - C = Copy file (copy disk N.A. on 1541)
FE92               = $fe92      ; $52 - R = Rename file
FE93               = $fe93      ; $53 - S = Scratch file
FE94               = $fe94      ; $4e - N = New or format a diskette
------------------------------------------------------------------------------
                                ; table: Command Jump Table - Lo byte
FE95               = $fe95      ; $84 - V = Validate
FE96               = $fe96      ; $05 - I = Initialize BAM
FE97               = $fe97      ; $c1 - D = Duplicate (N.A.)
FE98               = $fe98      ; $f8 - M = Memory operation
FE99               = $fe99      ; $lb - B = Block operation
FE9A               = $fe9a      ; $5c - U = User jump commands
FE9B               = $fe9b      ; $07 - P = Position (for REL)
FE9C               = $fe9c      ; $a3 - & = Utility loader
FE9D               = $fe9d      ; $f0 - C = Copy file
FE9E               = $fe9e      ; $88 - R = Rename file
FE9F               = $fe9f      ; $23 - S = Scratch file
FEA0               = $fea0      ; $0d - N = New a diskette
------------------------------------------------------------------------------
                                ; table: Command Jump Table - Hi byte
FEA1               = $fea1      ; $ed - V = Validate
FEA2               = $fea2      ; $d0 - I = Initialize BAM
FEA3               = $fea3      ; $c8 - D = Duplicate (N.A.)
FEA4               = $fea4      ; $ca - M = Memory operation
FEA5               = $fea5      ; $cc - B = Block operation
FEA6               = $fea6      ; $cb - U = User jump commands
FEA7               = $fea7      ; $e2 - P = Position (for REL)
FEA8               = $fea8      ; $e7 - & = Utility loader
FEA9               = $fea9      ; $c8 - C = Copy file
FEAA               = $feaa      ; $ca - R = Rename file
FEAB               = $feab      ; $c8 - S = Scratch file
FEAC               = $feac      ; $ee - N = New a diskette
------------------------------------------------------------------------------
                                ; table: Structure Images for Comands
FEAD               = $fead      ; $51 - %01010001 = disk copy                   
FEAE               = $feae      ; $dd - %11011101 = rename  a file (not parsed)  
FEAF               = $feaf      ; $lc - %00011100 = scratch a file (not parsed) 
FEB0               = $feb0      ; $9e - %10011110 = new a diskette (not parsed) 
FEB1               = $feb1      ; $lc - %00011100 = load a file                 
------------------------------------------------------------------------------
                                ; Table: Mode
FEB2               = $feb2      ; R = READ  mode
FEB3               = $feb3      ; W = WRITE mode
FEB4               = $feb4      ; A = APPEND
FEB5               = $feb5      ; M = MODIFY (read improperly closed file)
------------------------------------------------------------------------------
                                ; Table: File Type Shortcut
FEB6               = $feb6      ; D = DELETED    file
FEB7               = $feb7      ; S = SEQUENTIAL file
FEB8               = $feb8      ; P = PROGRAM    file
FEB9               = $feb9      ; U = USER       file
FEBA               = $feba      ; L = RELATIVE   file
------------------------------------------------------------------------------
                                ; Table: File Type Directory Name
FEBB               = $febb      ; D - DEL
FEBC               = $febc      ; S - SEQ
FEBD               = $febd      ; P - PRG
FEBE               = $febe      ; U - USR
FEBF               = $febf      ; R - REL
                   
FEC0               = $fec0      ; E - DEL
FEC1               = $fec1      ; E - SEQ
FEC2               = $fec2      ; R - PRG
FEC3               = $fec3      ; S - USR
FEC4               = $fec4      ; E - REL
                   
FEC5               = $fec5      ; L - DEL
FEC6               = $fec6      ; Q - SEQ
FEC7               = $fec7      ; G - PRG
FEC8               = $fec8      ; R - USR
FEC9               = $fec9      ; L - REL
------------------------------------------------------------------------------
LEDMSK             = $feca      ; Table: LED Mask for Drive 0
LEDMSK_1           = $fecb      ; Table: LED Mask for Drive 1 (N.A. on 1541)
------------------------------------------------------------------------------
                                ; Table: Error Flag Variables for use by BIT
FECC               = $fecc      ; $00 ER00
FECD               = $fecd      ; $3f ER0
FECE               = $fece      ; $7f ER1
FECF               = $fecf      ; $bf ER2
FED0               = $fed0      ; $ff ER3
------------------------------------------------------------------------------
                                ; Table: Number of sectors per track in each zone
FED1               = $fed1      ; $11 - 17 sectors/track in zone 4 (31-35)
FED2               = $fed2      ; $12 - 18 sectors/track in zone 3 (25-30) 
FED3               = $fed3      ; $13 - 19 sectors/track in zone 2 (18-24) 
FED4               = $fed4      ; $15 - 21 sectors/track in zone 1 (01-17) 
------------------------------------------------------------------------------
FED5               = $fed5      ; Table: DOS version number (65)
FED6               = $fed6      ; Table: Number of different zones on disk
------------------------------------------------------------------------------
                                ; Table: Zone Boundaries (highest track # + 1)
FED7               = $fed7      ; $24 - Track #36 - end of zone 4 (31-35) (4)
FED8               = $fed8      ; $lf - Track #31 - end of zone 3 (25-30) <3)
FED9               = $fed9      ; $19 - Track #25 - end of zone 2 (18-24) (2)
FEDA               = $feda      ; $12 - Track #18 - end of zone 1 (01-17) (1)
------------------------------------------------------------------------------
                                ; Table: Control Bytes for Head movement for error recovery
FEDB               = $fedb      ; $01  +1 move a half step inwards
FEDC               = $fedc      ; $ff  -1 move a half step outwards
FEDD               = $fedd      ; $ff  -1 move a half step outwards
FEDE               = $fede      ; $01  +1 move a half step inwards
FEDF               = $fedf      ; $00   0 end mark
------------------------------------------------------------------------------
                                ; Table: Hi Bytes of Pointers to Data Buffers
FEE0               = $fee0      ; $03 - Buffer 0 ($0300-03ff)
FEE1               = $fee1      ; $04 - Buffer 1 ($0400-04ff}
FEE2               = $fee2      ; $05 - Buffer 2 ($0500-05ff)
FEE3               = $fee3      ; $06 - Buffer 3 ($0600-06ff)
FEE4               = $fee4      ; $07 - Buffer 4 ($0700-07ff)
FEE5               = $fee5      ; $07 - Buffer 5 ($0700-07ff)
------------------------------------------------------------------------------
FEE6               = $fee6      ; Table: Checksum for $E and $F ROMs
------------------------------------------------------------------------------
NMI                = $fee7      ; NMI vector points here
                                ; do an indirect jump to the address stored in VNMI ($65)
PEA7A              = $feea      ; switch on LED
SLOWD              = $fef3      ; produce a 40 microseconds serial bus delay with a loop that counts .X down from 5 to 1
unused_fefb        = $fefb      ; 
NNMI               = $ff01      ; patch to NMI routine to check for u+ and u- commands
unused_ff10        = $ff10      ; - $ffe5
------------------------------------------------------------------------------
                                ; Table: Jump vectors to routines (lo byte/hi byte)
FFE6               = $ffe6      ; $c6 $c8 - FORMAT ROM routine                  $c8c6
FFE8               = $ffe8      ; $8f $f9 - TRNOFF ROM routine                  $f98f
FFEA               = $ffea      ; $5f $cd - U1 UA Vektor = UBLKRD ROM routine   $cd5f
FFEC               = $ffec      ; $97 $cd - U2 UB Vektor = UBLKWT ROM routine   $cd97
FFEE               = $ffee      ; $00 $05 - U3 UC Vektor = Link to buffer #2    $0500 
FFF0               = $fff0      ; $03 $05 - U4 UD Vektor = Link to buffer #2    $0503 
FFF2               = $fff2      ; $06 $05 - U5 UE Vektor = Link to buffer #2    $0506 
FFF4               = $fff4      ; $09 $05 - U6 UF Vektor = Link to buffer #2    $0509 
FFF6               = $fff6      ; $0c $05 - U7 UG Vektor = Link to buffer #2    $050c 
FFF8               = $fff8      ; $0f $05 - U8 UH Vektor = Link to buffer #2    $050f 
FFFA               = $fffa      ; $01 $ff - U9 UI Vektor = NNMI ROM routine     $ff01  
FFFC               = $fffc      ; $a0 $ea - U: UJ Vektor = DSKINT ROM routine   $eaa0
FFFE               = $fffe      ; $67 $fe - SYSIRQ ROM routine                  $fe67
------------------------------------------------------------------------------
