; -------------------------------------------------------------------------------------------------------------- ;
; 1541 - File Data Block
; -------------------------------------------------------------------------------------------------------------- ;
PRGLINK           = $00         ; link to the next PGM file data block
PRGLINKTRK        = $00         ; track  location of the next PGM file data block
PRGLINKLAST         = $00       ; id last PGM file data block
PRGLINKSEC        = $01         ; sector location of the next PGM file data block
PRGLINKCOUNT      = $01         ; used byte count of the last PGM file data block
; -------------------------------------------------------------------------------------------------------------- ;
PRGLOAD           = $02         ; program load address
PRGLOADLO         = $02         ; 
PRGLOADHI         = $03         ; 
; -------------------------------------------------------------------------------------------------------------- ;
PRGDATAFIRST      = $04         ; start of data 1st PGM file block (max $fc)
PRGDATAFIRST_MAX    = $fc       ; amount data bytes
PRGDATANEXT       = $02         ; start of data 2nd PGM file block (max $fe)
PRGDATANEXT_MAX     = $fe       ; amount data bytes
; -------------------------------------------------------------------------------------------------------------- ;
; 1541 - SEQ File Data Block
; -------------------------------------------------------------------------------------------------------------- ;
SEQLINK           = $00         ; link to the next SEQ file data block
SEQLINKTRK        = $00         ; track  location of the next SEQ file data block
SEQLINKLAST         = $00       ; id last SEQ file data block
SEQLINKSEC        = $01         ; sector location of the next SEQ file data block
PRGLINKCOUNT      = $01         ; used byte count of the last SEQ file data block
; -------------------------------------------------------------------------------------------------------------- ;
SEQDATANEXT       = $02         ; start of data 2nd block (max $fe)
; -------------------------------------------------------------------------------------------------------------- ;
; 1541 - REL File Data Block - Contains Records of a fixed length
; -------------------------------------------------------------------------------------------------------------- ;
RELLINK           = $00         ; link to the next REL file data block
RELLINKTRK        = $00         ; track  location of the next REL file data block
RELLINKLAST         = $00       ; id last REL file data block
RELLINKSEC        = $01         ; sector location of the next REL file data block
RRLLINKCOUNT      = $01         ; used byte count of the last REL file data block
; -------------------------------------------------------------------------------------------------------------- ;
RELDATANEXT       = $02         ; start of data 2nd block (max $fe)
; -------------------------------------------------------------------------------------------------------------- ;
; 1541 - REL File Side Sector Block - Contains TRACK/SECTOR pointers
; -------------------------------------------------------------------------------------------------------------- ;
RELSSLINK         = $00         ; link to the next REL file data block
RELSSLINKTRK      = $00         ; track  location of the next REL file data block
RELSSLINKLAST       = $00       ; id last REL file data block
RELSSLINKSEC      = $01         ; sector location of the next REL file SIDE SECTOR block
RELSSNUMBER       = $02         ; sector location of the next REL file SIDE SECTOR block
RELSSRECSIZE      = $03         ; record length
; -------------------------------------------------------------------------------------------------------------- ;
RELSS             = $04         ; TRACK/SECTOR list of the side sector file
RELSSTRK00        = $04         ; TRACK  side sector #00
RELSSSEC00        = $05         ; SECTOR side sector #00
RELSSTRK01        = $06         ; TRACK  side sector #01
RELSSSEC01        = $07         ; SECTOR side sector #01
RELSSTRK02        = $08         ; TRACK  side sector #02
RELSSSEC02        = $09         ; SECTOR side sector #02
RELSSTRK03        = $0a         ; TRACK  side sector #03
RELSSSEC03        = $0b         ; SECTOR side sector #03
RELSSTRK04        = $0c         ; TRACK  side sector #04
RELSSSEC04        = $0d         ; SECTOR side sector #04
RELSSTRK05        = $0e         ; TRACK  side sector #05
RELSSSEC05        = $0f         ; SECTOR side sector #05
; -------------------------------------------------------------------------------------------------------------- ;
RELDATA           = $10         ; TRACK/SECTOR list of 120 data blocks
RELDATAMAX          = $78       ; max 120 TRACK/SECTOR entries in list
RELDATATRK00      = $10         ; TRACK  of data block #00
RELDATASEC00      = $11         ; SECTOR of data block #00
; -------------------------------------------------------------------------------------------------------------- ;
