; -------------------------------------------------------------------------------------------------------------- ;
; VC1541 - Header Block
; -------------------------------------------------------------------------------------------------------------- ;
; The header block is written ONLY during the formatting process
; -------------------------------------------------------------------------------------------------------------- ;
; the hdr_sync length varies from zone to zone and from one drive to another
; between consectutive sectors the hdr_sync is normally 4 to 12 bytes long
; between the last sector and sector zero on a track the hdr_sync is often longer (up to 100 bytes)
; the hdr_sync is designed to be long enough that the write of a data block does not overwrite 
; the start of the next sector if the drive is not turning exactly at 300 rpm
; (due to power fluctuations, mechanical wear, belt slippage, changes in temperature, etc.)
; -------------------------------------------------------------------------------------------------------------- ;
HDR_SYNC          = $00         ; give DOS enough time to set-up between end of data block and start of next sector
HDR_SYNC_VAL        = $ff       ; DOS never reads these bytes
; -------------------------------------------------------------------------------------------------------------- ;
HDR_BLOCK         = $00         ; 
HDR_BLOCK_ID      = $00         ; indicates a header block
HDR_BLOCK_ID_VAL    = HBID_DFLT ; $08
HDR_BLOCK_CRC     = $01         ; checksum - ensures that a header block was read correctly
                                ; calulated by EORing HDR_TRACK_NUM / HDR_SECTOR_NUM / HDR_ID
; -------------------------------------------------------------------------------------------------------------- ;
; the 1541 has no track_00_detector (exception: 1541C)
; so the first thing it does after powering up and getting a disk command
; is reading a sector header to find out where the head is positioned
; -------------------------------------------------------------------------------------------------------------- ;
HDR_SECTOR_NUM    = $02         ; number of this particular sector        - checked for correct head sector pos
HDR_TRACK_NUM     = $03         ; number of this particular track         - checked for correct head track  pos
; -------------------------------------------------------------------------------------------------------------- ;
HDR_ID            = $04         ; from the format command (N0:GAMES,V1)   - checked against Master Dik ID
HDR_ID_CHR2       = $04         ; -----------------------------------^    - checked to ensure that Disks
HDR_ID_CHR1       = $05         ; ----------------------------------^       are not swapped
; -------------------------------------------------------------------------------------------------------------- ;
; $02 OFF Bytes are used to complete $08 bytes
; as a multiple of $04 bytes is needed to create a multiple of $05 GCR-bytes
; -------------------------------------------------------------------------------------------------------------- ;
HDR_OFF           = $06         ; DOS padding bytes during initial format - never referenced again
HDR_OFF_VAL         = $0f       ; 
HDR_OFF1          = $06         ; 
HDR_OFF2          = $07         ; 
; -------------------------------------------------------------------------------------------------------------- ;
HDR_GAP           = $08         ; give DOS enough time to set-up for reading the data block that folows
HDR_GAP_VAL         = $55       ; DOS never reads these bytes
HDR_GAP_LEN         = $05       ; 
; -------------------------------------------------------------------------------------------------------------- ;
