; -------------------------------------------------------------------------------------------------------------- ;
;  VC1541 - Standard Zeropage / Extended Zeropage / Stack / Vectors / Buffers
; -------------------------------------------------------------------------------------------------------------- ;
; Zeropage - JOB queue / Constants / Pointers / Work Area
; -------------------------------------------------------------------------------------------------------------- ;
; JOBSTCC0 - JOBSTCC5 ; Interface Main Program - Disc Controller
                      ;   main program writes 
                      ;     - job command codes
                      ;     - track/sector numbers of the block to be processed (if necessary)
                      ;   into the appropriate job cmd memory area
                      ;     - bit7 set   - job will be executed with the next interrupt
                      ;     - bit7 clear - bit0-bit6 contain the jobs status code
                      ; 
                      ;     Addresses and the assigned buffers
                      ;   +-----+-------+--------+-------------+
                      ;   ! JOB ! TRACK ! SECTOR !   BUFFER    !
                      ;   +-----+-------+--------+-------------+
                      ;   ! $00 !  $06  !  $07   ! $0300-$03ff !
                      ;   ! $01 !  $08  !  $09   ! $0400-$04ff !
                      ;   ! $02 !  $0a  !  $0b   ! $0500-$05ff !
                      ;   ! $03 !  $0c  !  $0d   ! $0600-$06ff !
                      ;   ! $04 !  $0e  !  $0f   ! $0700-$07ff !
                      ;   ! $05 !  $10  !  $11   ! -no ram-    !
; ------------------------+-----+-------+--------+-------------+------------------------------------------------ ;
JOBS              = $00         ; command code
JOBCC_ID            = %10000000 ; bit7=1  : is job   code
                                ; bit7=0  : is error code
JOBCC_MASK          = %11110000 ; bits 4-7: command  code
JOBCC_READ          = %10000000 ; $80 - Read   a sector
JOBCC_WRITE         = %10010000 ; $90 - Write  a sector
JOBCC_VERIFY        = %10100000 ; $a0 - Verify a sector
JOBCC_SEEK          = %10110000 ; $b0 - Seek   a sector
JOBCC_BUMP          = %11000000 ; $c0 - Bump head - find track 01
JOBCC_JUMP          = %11010000 ; $d0 - Exec program in buffer
JOBCC_EXECUTE       = %11100000 ; $e0 - Exec program in buffer / switch drive on and position head
; -------------------------------------------------------------------------------------------------------------- ;
JOBST_MASK          = %00001111 ; bits 0-3: error code
JOBST_OK            = %00000001 ; $01 - Everything OK                   00, OK
JOBST_ERR_NOHDR     = %00000010 ; $02 - Header block not found          20, READ ERROR
JOBST_ERR_NOSYNC    = %00000011 ; $03 - SYNC not found                  21, READ ERROR
JOBST_ERR_NODATA    = %00000100 ; $04 - Data block not found            22, READ ERROR
JOBST_ERR_CRCDATA   = %00000101 ; $05 - Checksum error in data block    23, READ ERROR
JOBST_ERR_FORMAT    = %00000110 ; $06 - Format error                    24, READ ERROR        - not used on the 1541
JOBST_ERR_VERIFY    = %00000111 ; $07 - Verify error                    25, WRITE ERROR
JOBST_ERR_WRTPROT   = %00001000 ; $08 - Disk write protected            26, WRITE PROTECT ON
JOBST_ERR_CRCHDR    = %00001001 ; $09 - Checksum error in header block  27, READ ERROR
JOBST_ERR_LONGDATA  = %00001100 ; $0a - Data block too long             28, READ ERROR
JOBST_ERR_DSKCHG    = %00001011 ; $0b - Id mismatch                     29, DISK ID MISMATCH
JOBST_ERR_NODISC    = %00001111 ; $0f - Disk not inserted               74, DRIVE NOT READY
; -------------------------------------------------------------------------------------------------------------- ;
; Job Queue
; -------------------------------------------------------------------------------------------------------------- ;
JOBS0             = $00         ; use BUF0 - command and status registers - JOB0TRA/JOB0SEC
JOBS1             = $01         ; use BUF1 - command and status registers - JOB1TRA/JOB1SEC
JOBS2             = $02         ; use BUF2 - command and status registers - JOB2TRA/JOB2SEC
JOBS3             = $03         ; use BUF3 - command and status registers - JOB3TRA/JOB3SEC
JOBS4             = $04         ; use BUF4 - command and status registers - JOB4TRA/JOB4SEC
JOBS5             = $05         ; use BUF5 - command and status registers - JOB5TRA/JOB5SEC - unused: not existing
; -------------------------------------------------------------------------------------------------------------- ;
; Header Table
; -------------------------------------------------------------------------------------------------------------- ;
HDRS              = $06         ; track/sector area for jobs
JOB0TRA           = $06         ; BUF0 track
JOB0SEC           = $07         ; BUF0 sector
JOB1TRA           = $08         ; BUF1 track
JOB1SEC           = $09         ; BUF1 sector
JOB2TRA           = $0a         ; BUF2 track
JOB2SEC           = $0b         ; BUF2 sector
JOB3TRA           = $0c         ; BUF3 track
JOB3SEC           = $0d         ; BUF3 sector
JOB4TRA           = $0e         ; BUF4 track
JOB4SEC           = $0f         ; BUF4 sector
JOB5TRA           = $10         ; BUF5 track  - unused: not existing
JOB5SEC           = $11         ; BUF5 sector - unused: not existing
; -------------------------------------------------------------------------------------------------------------- ;
; Master copy of dik ID (specified when disk was formatted) - updated with any JOBCC_SEEK
; -------------------------------------------------------------------------------------------------------------- ;
DISKID            = $12         ; drive #0 - expected sector header ID
DISKID_CHR1         = $12       ; 
DISKID_CHR2         = $13       ; 
DISKID1           = $14         ; drive #1 - expected sector header ID                          ---> unused <---
DISKID1_CHR1        = $14       ; 
DISKID1_CHR2        = $15       ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Image of the most recent HEADER read - stored on disk in the opposite sequence
; -------------------------------------------------------------------------------------------------------------- ;
HEADER            = $16         ; header block ID     - from header of sector last read from disk
HEADER_CHR1       = $16         ;                       1st ID char
HEADER_CHR2       = $17         ;                       2nd ID char
HEADER_TRK        = $18         ; header block track  - track  number from header of sector last read from disk
HEADER_SEC        = $19         ; header block sector - sector number from header of sector last read from disk
HEADER_CRC        = $1a         ; header block parity - checksum from header of sector last read from disk
; -------------------------------------------------------------------------------------------------------------- ;
ACTJOB            = $1b         ; free                                                          ---> unused <---
WPSW              = $1c         ; flag: drive #0 - disk change indicator
WPSW_FLAG           = %00000001 ; 
WPSW_SAME           = $00       ; disk has not changed
WPSW_DIFF           = $01       ; disk has changed
WPSW1             = $1d         ; flag: drive #1 - disk change indicator                        ---> unused <---
LWPT              = $1e         ; flag: drive #0 - previous status of write protect photocell (write protect sense)
LWPT_ON             = %00010000 ; 
LWPT_OFF            = %11101111 ; 
LWPT_NO             = %00000000 ; 
LWPT_YES            = %00010000 ; 
LWPT1             = $1f         ; flag: drive #1 - previous status of write protect photocell   ---> unused <---
DRVST             = $20         ; drive #0 - disk drive status (disk and step motor)
DRVST_MASK          = %11110000 ; 
DRVST_MSTOP         = %00010000 ; shut down drive motor  (1 = no , 0 = yes)
DRVST_MSTOP_NO      = %00010000 ; 
DRVST_MSTOP_YES     = %11101111 ;                                          
DRVST_MON           = %00100000 ; motor is on            (1 = yes, 0 = no )
DRVST_MON_YES       = %00100000 ; 
DRVST_MON_NO        = %11011111 ; 
DRVST_BUSY          = %01000000 ; read/write head moving (1 = yes, 0 = no )
DRVST_BUSY_YES      = %01000000 ; 
DRVST_BUSY_NO       = %10111111 ; 
DRVST_READY         = %10000000 ; disk drive ready       (1 = yes, 0 = no )
DRVST_READY_YES     = %10000000 ; 
DRVST_READY_NO      = %01111111 ; 
DRVST1            = $21         ; drive #1 - disk drive status                                  ---> unused <---
DRVTRK            = $22         ; drive #0 - current track under head
SBUSMODE          = $23         ; serial bus communication speed switch (0=1541 /<>0=1540)
SBUS_C64            = $00       ; C64    mode - lower speed (extra waits are needed as compensation for the delays caused by sprite DMA in the host)
SBUS_VC20           = $01       ; VIC-20 mode - higher speed ($01-$ff)
; -------------------------------------------------------------------------------------------------------------- ;
; Scratch Pad Area of GCR conversion / storage for BIN -> GCR conversions
; -------------------------------------------------------------------------------------------------------------- ;
STAB              = $24         ; 
STABX             = $2d         ; 
STAB_LEN          = [STABX - STAB] ;  
; -------------------------------------------------------------------------------------------------------------- ;
SAVPNT            = $2e         ; pointer: current byte in buffer during GCR-encoding/decoding
SAVPNT_LO           = $2e       ; 
SAVPNT_HI           = $2f       ; 
BUFPNT            = $30         ; pointer: begin of currently active buffer
BUFPNT_LO         = $30         ; 
BUFPNT_HI         = $31         ; 
HDRPNT            = $32         ; pointer: track and sector registers of current buffer
HDRPNT_TRK          = $32       ; pointer: active track
HDRPNT_SEC          = $33       ; pointer: active sector
GCRPNT            = $34         ; pointer: last converted byte during GCR-encoding/decoding
GCRERR            = $35         ; free - not used
BYTCOUNT          = $36         ; byte counter during GCR-encoding/decoding
BITCOUNT          = $37         ; free                                                          ---> unused <---
BID               = $38         ; constant: ID mark for start of data block
BID_DFLT            = $07       ; 
HBID              = $39         ; constant: ID mark for start of block header
HBID_DFLT           = $08       ; 
CHKSUM            = $3a         ; computed data or header checksum

HINIB             = $3b         ; free - not used
BYT               = $3c         ; free - not used

DRIVE             = $3d         ; disk controller current unit number
DRIVE_0             = $00       ; 
DRIVE_1             = $01       ; unused: will not work
CDRIVE            = $3e         ; disk controller previous unit number
CDRIVE_0            = $00       ; 
CDRIVE_1            = $01       ; unused: will not work
CDRIVE_OFF          = $ff       ; motor is off - must spin up before seeking
JOBN              = $3f         ; disk controller current buffer number
JOBN_0              = $00       ; 
JOBN_1              = $01       ; 
JOBN_2              = $02       ; 
JOBN_3              = $03       ; 
JOBN_4              = $04       ; 
JOBN_5              = $05       ; unused: buffer #5 does not exist
TRACC             = $40         ; byte counter for GCR-encoding/decoding
NXTJOB            = $41         ; position of next job in queue
NXTJOB_0            = $00       ; 
NXTJOB_1            = $01       ; 
NXTJOB_2            = $02       ; 
NXTJOB_3            = $03       ; 
NXTJOB_4            = $04       ; 
NXTJOB_5            = $05       ; unused: buffer #5 does not exist
NXTTRK            = $42         ; destination (next) track to move head to
SECTR             = $43         ; number of sectors per track for formatting
WORK              = $44         ; temporary workspace
JOB               = $45         ; temporary storage of job code
CTRACK            = $46         ; free - not used
DBID              = $47         ; data block ID code - init to DBID_DFLT ($07) on reset drive
                                ;   - may be changed - write/read data blocks with different data block ID codes
                                ;   - 1st nibble of the data block ID code should always be a zero ($0-)
                                ;     otherwise the controller will have difficulty detecting the 
                                ;     end of the sync mark and the start of the DBID
                                ; if a sector is read whose DBID is different from the value stored here
                                ; the disk controller puts JOBST_NODATA_ER ($04) in the job queue and
                                ; the drive will report a #22 error (DATA BLOCK NOT FOUND)
DBID_DFLT           = $07       ; default
DBID_MIN            = $00       ; allowed values: $00-$0f
DBID_MAX            = $0f       ; allowed values: $00-$0f
ACLTIM            = $48         ; timer for acceleration of head movement
SAVSP             = $49         ; temporary save of stackpointer
STEPS             = $4a         ; number of steps to move head to desired track
                                ;   $00-$7f - move head out (from disk centre)
                                ;   $80-$ff - move head in  (to disk centre)
TMP               = $4b         ; retry counter for reading sector header / temporary storage during seeking
CSECT             = $4c         ; last sector read
NEXTS             = $4d         ; next sector to read
NXTBF             = $4e         ; pointer: next buffer of GCR-bytes to be changed to binary
NXTBF_HI            = $4e       ;   --> byte swapped !!
NXTBF_LO            = $4f       ;   --> byte swapped !!
GCRFLG            = $50         ; flag: buffer data currently being in GCR-encoded form
GCRFLG_BIN          = $00       ; $00    : Data in normal form
GCRFLG_GCR          = $01       ; $01-$FF: Data in GCR-encoded form - must be decoded
FTNUM             = $51         ; current track number for formatting
; -------------------------------------------------------------------------------------------------------------- ;
; Staging area for the 4 binary bytes being converted to GCR (PUT4BG) or from GCR (GET4BG)
; -------------------------------------------------------------------------------------------------------------- ;
BTAB              = $52         ; temp area for 4 data bytes during GCR-encoding/decoding
BTAB0             = $52         ; 
BTAB1             = $53         ; 
BTAB2             = $54         ; 
BTAB3             = $55         ; 
BTABX             = BTAB3       ; 
BTAB_LEN          = [BTABX - BTAB] ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Staging area for the 5 GCR bytes being converted from binary (PUT4BG) or to binary (GET4BG)
; -------------------------------------------------------------------------------------------------------------- ;
GTAB              = $56         ; temp area for data nybbles/5 GCR bytes during GCR-encoding/decoding
GTAB0             = $56         ; 
GTAB1             = $57         ; 
GTAB2             = $58         ; 
GTAB3             = $59         ; 
GTAB4             = $5a         ; 
GTAB5             = $5b         ; 
GTAB6             = $5c         ; 
GTAB7             = $5d         ; 
GTABX             = GTAB7       ; 
GTAB_LEN          = [GTABX - GTAB] ; 
; -------------------------------------------------------------------------------------------------------------- ;
AS                = $5e         ; number of halftracks (steps) to accelerate/decelerate
AS_DFLT             = $04       ; twice this value must be less than value of MINSTP
AF                = $5f         ; acceleration/deceleration factor
AF_DFLT             = $04       ; value of DSKCNT(T1LH2) plus/minus value of AS times this value must not be
                                ;   too low   below about 12-20 (depends on drive mechanics) or
                                ;   too high  above 255
ACLSTP            = $60         ; number of steps left to ac/decelerate when stepping the head
RSTEPS            = $61         ; number of steps left to step the head when in fast stepping (run) mode
NXTST             = $62         ; pointer: head stepping routine INACT($fa05)
NXTST_LO            = $62       ;
NXTST_HI            = $63       ;
MINSTP            = $64         ; minimum of steps to go when in fast stepping (run) mode
UIPNT             = $65         ; pointer: warm start ("UI" command) routine [$EB22]
UIPNT_LO            = $65       ; 
UIPNT_HI            = $66       ; 
NMIFLG            = $67         ; flag: NMI in progress
AUTOFG            = $68         ; flag: enable/disable automatic disk initialisation if ID MISMATCH occurred 
AUTOFG_YES          = $00       ; 
AUTOFG_NO           = $01       ; 
SECINC            = $69         ; soft interleave - distance (in sectors) for allocating the next sector for files
SECINC_DFLT         = $0a       ; 
REVCNT            = $6a         ; number of retries on dos commands in case of an error
REVCNT_MASK         = %00111111 ; number of retries
REVCNT_AHT          = %01000000 ; retry on adjacent halftracks
REVCNT_BUMP         = %10000000 ; bump head
REVCNT_AHT_NO       = %10111111 ; do not retry on adjacent halftracks
REVCNT_BUMP_NO      = %01111111 ; do not bump head
REVCNT_DFLT         = %00000101 ; 
USRJMP            = $6b         ; pointer: start of user jump table for "Ux" commands [$fff6]
USRJMP_LO           = $6b       ; 
USRJMP_HI           = $6c       ; 
BMPNT             = $6d         ; pointer: start of bitmap [$0400] - set when a disk is initialized
BMPNT_LO            = $6d       ; 
BMPNT_HI            = $6e       ; 
MBJUMP            = $6f         ; pointer: address for M & B commands
MBJUMP_LO           = $6f       ; 
MBJUMP_HI           = $70       ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Temporary Work Area
; -------------------------------------------------------------------------------------------------------------- ;
TOTEMP            = $71         ; 
TOTEMP1             = $71       ; 
TOTEMP2             = $72       ; 
TOTEMP3             = $73       ; 
TOTEMP4             = $74       ; 
TOTEMPX             = TOTEMP4   ; 
TOTEMP_LEN          = [TOTEMPX - TOTEMP] ; 
; -------------------------------------------------------------------------------------------------------------- ;
IP                = $75         ; pointer: current byte during memory test upon startup OR
                                ;          exec address current "Ux" user command
IP_LO               = $75       ; 
IP_HI               = $76       ; 
LSNADR            = $77         ; listener address (device number + $20) - $28 on reset
LSNADR_DFLT         = $28       ; 
TLKADR            = $78         ; talker   address (device number + $40) - $48 on reset
TLKADR_DFLT         = $48       ; 
LSNACT            = $79         ; flag: active listener
LSNACT_YES          = $01       ;       $01-$ff: LISTEN command currently active
LSNACT_NO           = $00       ;       $00    : no LISTEN command active
TLKACT            = $7a         ; flag: active talker
TLKACT_YES          = $01       ;       $01-$ff: TALK command currently active
TLKACT_NO           = $00       ;       $00    : no TALK command active
ADRSED            = $7b         ; flag: addressing mode
ATNPND            = $7c         ; flag: ATN from serial bus receiving
ATNPND_YES          = $01       ;       $01-$ff: ATN signal arrived
ATNPND_NO           = $00       ;       $00    : ATN inactive
ATNMOD            = $7d         ; flag: end of command (6502 in attention mode)
ATNMOD_YES          = $00       ;       $00    : Command fully arrived, ATN became inactive
ATNMOD_NO           = $01       ;       $01-$ff: Command still transferring
PRGTRK            = $7e         ; track number ($01-$ff) of previously opened file (used when opening "*")
PRGTRK_NONE         = $00       ; no file has been opened yet
DRVNUM            = $7f         ; current drive number (always 0 in 1541)
TRACK             = $80         ; current track number  ($00 after use)
SECTOR            = $81         ; current sector number ($00 after use)
LINDX             = $82         ; logical index (current channel number)
LINDX0              = $00       ; buffer #00
LINDX1              = $01       ; buffer #01
LINDX2              = $02       ; buffer #02
LINDX3              = $03       ; buffer #03
LINDX4              = $04       ; buffer #04
LINDX5              = $05       ; buffer #05 - error message
CURSA             = $83         ; current secondary address (bit0 - bit3 only)
CURSA_MASK          = %00001111 ; 
ORGSA             = $84         ; original secondary address
ORGSA_DFLT          = $6f       ; 
DATA              = $85         ; current data byte read from serial bus
R0                = $86         ; temporary result
R1                = $87         ; temporary result
R2                = $88         ; temporary result
R3                = $89         ; temporary result
R4                = $8a         ; temporary result
; -------------------------------------------------------------------------------------------------------------- ;
; Result Area
; -------------------------------------------------------------------------------------------------------------- ;
RESULT            = $8b         ; 
RESULT0             = $8b       ; 
RESULT1             = $8c       ; 
RESULT2             = $8d       ; 
RESULT3             = $8e       ; 
RESULTX             = RESULT3   ; 
RESULT_LEN          = [RESULTX - RESULT] ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Accumulator
; -------------------------------------------------------------------------------------------------------------- ;
ACCUM             = $8f         ; 
ACCUM0              = $8f       ;                
ACCUM1              = $90       ; 
ACCUM2              = $91       ; 
ACCUM3              = $92       ; 
ACCUM4              = $93       ; 
ACCUMX              = ACCUM4    ; 
ACCUM_LEN           = [ACCUMX - ACCUM] ; 
; -------------------------------------------------------------------------------------------------------------- ;
DIRBUF            = $94         ; pointer: current directory entry - directory buffer ($0205)
                                ; note   : DIRBUF does NOT point to the start of the data buffer ($0300, $0400, ...)
                                ;          but points to the first data byte ($0302, $0402, ...)
                                ;          as the entries are examined it is updated to point to the start of
                                ;          the entry ($02, $22, $42, ...)
DIRBUF_LO           = $94       ; 
DIRBUF_HI           = $95       ; 
ICMD              = $96         ; IEEE command in (not used on 1541)
MYPA              = $97         ; MY PA flag $00
CONT              = $98         ; bit counter during serial bus input/output
; -------------------------------------------------------------------------------------------------------------- ;
; Buffer Byte Pointers - Point to the next byte to be used of each buffer - set by the B-P command
; -------------------------------------------------------------------------------------------------------------- ;
BUFTAB            = $99         ; pointer table to buffer #0..#4  - normally: $0300..$0700
BUFTAB0           = $99         ; pointer: next byte in buffer #0 - default : $0300
BUFTAB0_LO          = $99       ; 
BUFTAB0_HI          = $9a       ; 
BUFTAB1           = $9b         ; pointer: next byte in buffer #1 - default : $0400
BUFTAB1_LO          = $9b       ; 
BUFTAB1_HI          = $9c       ; 
BUFTAB2           = $9d         ; pointer: next byte in buffer #2 - default : $0500
BUFTAB2_LO          = $9d       ; 
BUFTAB2_HI          = $9e       ; 
BUFTAB3           = $9f         ; pointer: next byte in buffer #3 - default : $0600
BUFTAB3_LO          = $9f       ; 
BUFTAB3_HI          = $a0       ; 
BUFTAB4           = $a1         ; pointer: next byte in buffer #4 - default : $0700
BUFTAB4_LO          = $a1       ; 
BUFTAB4_HI          = $a2       ; 
BUFTABCMD         = $a3         ; pointer: next byte in command buffer - default: $0200
BUFTABCMD_LO        = $a3       ; 
BUFTABCMD_HI        = $a4       ; 
BUFTABERR         = $a5         ; pointer: next byte in error message buffer - default: $02D5
BUFTABERR_LO        = $a5       ; 
BUFTABERR_HI        = $a6       ; 
; -------------------------------------------------------------------------------------------------------------- ;
BUF0CH            = $a7         ; table: primary buffer number assigned to channels
BUF0CH_NUM_MASK     = %01111111 ;        bit0-bit6: buffer number
BUF0CH_ACT_MASK     = %10000000 ;        bit7     : 1 = no buffer assigned to channel
BUF0CH_INACT        = %11111111 ; 
BUF0CH1           = $a7         ; 
BUF0CH2           = $a8         ; 
BUF0CH3           = $a9         ; 
BUF0CH4           = $aa         ; 
BUF0CH5           = $ab         ; 
BUF0CH6           = $ac         ; 
BUF0CH7           = $ad         ; 
; -------------------------------------------------------------------------------------------------------------- ;
BUF1CH            = $ae         ; table: secondary buffer number assigned to channels
BUF1CH_NUM_MASK     = %01111111 ;        bit0-bit6: buffer number
BUF1CH_ACT_MASK     = %10000000 ;        bit7     : 1 = no buffer assigned to channel
BUF1CH_INACT        = %11111111 ; 
BUF1CH1           = $ae         ; 
BUF1CH2           = $ae         ; 
BUF1CH3           = $ae         ; 
BUF1CH4           = $ae         ; 
BUF1CH5           = $ae         ; 
BUF1CH6           = $ae         ; 
BUF1CH7           = $b4         ; 
; -------------------------------------------------------------------------------------------------------------- ;
RECL              = $b5         ; table: low byte - length of file assigned to channels / rel files: number of records
RECL1             = $b5         ; 
RECL2             = $b6         ; 
RECL3             = $b7         ; 
RECL4             = $b8         ; 
RECL5             = $b9         ; 
RECL6             = $ba         ; 
; -------------------------------------------------------------------------------------------------------------- ;
RECH              = $bb         ; table: high byte - length of file assigned to channels / rel files: number of records
RECH1             = $bb         ; 
RECH2             = $bc         ; 
RECH3             = $bd         ; 
RECH4             = $be         ; 
RECH5             = $bf         ; 
RECH6             = $c0         ; 
; -------------------------------------------------------------------------------------------------------------- ;
NR                = $c1         ; table: offset of current byte in buffer assigned to channels
NR1               = $c1         ; 
NR2               = $c2         ; 
NR3               = $c3         ; 
NR4               = $c4         ; 
NR5               = $c5         ; 
NR6               = $c6         ; 
; -------------------------------------------------------------------------------------------------------------- ;
RS                = $c7         ; table: record length of relative file assigned to channels
RS1               = $c7         ; 
RS2               = $c8         ; 
RS3               = $c9         ; 
RS4               = $ca         ; 
RS5               = $cb         ; 
RS6               = $cc         ; 
; -------------------------------------------------------------------------------------------------------------- ;
SS                = $cd         ; buffer number holding side sector of relative file assigned to channels
SS_Num_Mask         = %01111111 ;        bit0-bit6: buffer number
SS_Act_Mask         = %10000000 ;        bit7     : 1 = no buffer assigned to channel
SS1               = $cd         ; 
SS2               = $ce         ; 
SS3               = $cf         ; 
SS4               = $d0         ; 
SS5               = $d1         ; 
SS6               = $d2         ; 
; -------------------------------------------------------------------------------------------------------------- ;
FLPTR             = $d3         ; comma counter during fetch unit numbers from command
RECPTR            = $d4         ; offset: current byte in relative file record
SSNUM             = $d5         ; side sector number belonging to current relative file record
SSIND             = $d6         ; offset of track and sector number of current relative file record in side sector
RELPTR            = $d7         ; offset: record in relative file data sector
; -------------------------------------------------------------------------------------------------------------- ;
ENTSEC            = $d8         ; table: sector number of directory entry of files pointer directory sectors
ENTSEC1           = $d8         ; 
ENTSEC2           = $d9         ; 
ENTSEC3           = $da         ; 
ENTSEC4           = $db         ; 
ENTSEC5           = $dc         ; 
; -------------------------------------------------------------------------------------------------------------- ;
ENTIND            = $dd         ; table: offset of directory entry of files
ENTIND1           = $dd         ; 
ENTIND2           = $de         ; 
ENTIND3           = $df         ; 
ENTIND4           = $e0         ; 
ENTIND5           = $e1         ; 
; -------------------------------------------------------------------------------------------------------------- ;
FILDRV            = $e2         ; table: unit number of files
FILDRV_NUM_MASK     = %00000001 ;        bit0: unit number
FILDRV_ACT_MASK     = %10000000 ;        bit7: 1 = no valid unit number has been specified in command - must try both units
FILDRV1           = $e2         ; 
FILDRV2           = $e3         ; 
FILDRV3           = $e4         ; 
FILDRV4           = $e5         ; 
FILDRV5           = $e6         ; 
; -------------------------------------------------------------------------------------------------------------- ;
PATTYP            = $e7         ; table: file type / flags of files
PATTYP_TPYE_MASK    = %00000111 ; 
PATTYP_TYPE_DEL     = %00000000 ; $00
PATTYP_TYPE_SEQ     = %00000001 ; $01
PATTYP_TYPE_PRG     = %00000010 ; $02
PATTYP_TYPE_USR     = %00000011 ; $03
PATTYP_TYPE_REL     = %00000100 ; $04

PATTYP_CLOSED       = %11011111 ; 0 = file has been closed
PATTYP_OPEN         = %00100000 ; 
PATTYP_PROT_YES     = %01000000 ; 1 = file is write protected
PATTYP_PROT_NO      = %10111111 ; 
PATTYP_WICA_YES     = %10000000 ; 1 = wildcards present in file name
PATTYP_WICA_NO      = %01111111 ; 
PATTYP1           = $e7         ; 
PATTYP2           = $e8         ; 
PATTYP3           = $e9         ; 
PATTYP4           = $ea         ; 
PATTYP5           = $eb         ; 
; -------------------------------------------------------------------------------------------------------------- ;
FILTYP            = $ec         ; table: unit number / file type / flags of files assigned to channels
FILTYP_UNIT         = %00000001 ; unit number

FILTYP_TYPE_Mask    = %00001110 ; file type
FILTYP_TYPE_DEL     = %00000000 ; $00
FILTYP_TYPE_SEQ     = %00000010 ; $01
FILTYP_TYPE_PRG     = %00000100 ; $02
FILTYP_TYPE_USR     = %00000110 ; $03
FILTYP_TYPE_REL     = %00001000 ; $04
FILTYP_TYPE_DDA     = %00001110 ; "#" - direct disk access

FILTYP_EOR          = %00100000 ; end of record
FILTYP_EOF          = %01000000 ; end of file
FILTYP_DIR          = %10000000 ; directory entry of file must be updated
FILTYP1           = $ec         ; 
FILTYP2           = $ed         ; 
FILTYP3           = $ee         ; 
FILTYP4           = $ef         ; 
FILTYP5           = $f0         ; 
FILTYP6           = $f1         ; 
; -------------------------------------------------------------------------------------------------------------- ;
CHNRDY            = $f2         ; table: input/output flags of channels
CHNRDY_WRITE      =   %00000001 ; bit0 - 1 = write allowed
CHNRDY_EOF        =   %11110111 ; bit3 - 0 = end of file
CHNRDY_READ       =   %10000000 ; bit7 - 1 = read allowed
CHNRDY1           = $f2         ; 
CHNRDY2           = $f3         ; 
CHNRDY3           = $f4         ; 
CHNRDY4           = $f5         ; 
CHNRDY5           = $f6         ; 
CHNRDY6           = $f7         ; 
; -------------------------------------------------------------------------------------------------------------- ;
EOIFLG            = $f8         ; flag: end of file indicator current channel
EOIFLG_YES          = $00       ;       $00    : end of file
EOIFLG_NO           = $01       ;       $01-$FF: file has not ended yet
JOBNUM            = $f9         ; current work (buffer number)
LRUTBL            = $fa         ; table: last used
LRUTBL1           = $fa         ; 
LRUTBL2           = $fb         ; 
LRUTBL3           = $fc         ; 
LRUTBL4           = $fd         ; 
LRUTBL5           = $fe         ; 
NODRV             = $ff         ; flag: drive #0 status
NODRV_YES           = $00       ;       drive #0 ready
NODRV_NO            = $ff       ;       drive #0 not ready (no disk)
; -------------------------------------------------------------------------------------------------------------- ;
; Extended Zero Page - Stacks / Work Areas / Overflow Buffer
; -------------------------------------------------------------------------------------------------------------- ;
ZPDRVEXT          = $0100       ; 
NODRV1              = $0100     ; flag: drive #1 status                                         ---> unused <---
DSKVER              = $0101     ; drive #0 DOS version - taken from track 18 sector 00 BAMDOSVRS ($02)
DSKVER1             = $0102     ; drive #1 DOS version                                          ---> unused <---
; -------------------------------------------------------------------------------------------------------------- ;
ZPDRVEND          = $0103       ; end of zero page                                              ---> unused <---
; -------------------------------------------------------------------------------------------------------------- ;
; Stack Area
; -------------------------------------------------------------------------------------------------------------- ;
STACK_DRV         = $0104       ; 
STACK_DRV_PTR_INI   = $45       ; offset top of stack
STACK_DRVX        = [ZPDRVEXT + STACK_DRV_PTR_INI] ; 
STACK_DRV_LEN     = [STACK_DRVX - STACK_DRV]    ; 

STACK_DRV_FREE    = [STACK_DRVX + $01] ; free - not used ($0146)
STACK_DRV_FREEX   = $01b9       ; 

BUFGCR            = $01ba       ; buffer for GCR de/encoding
; -------------------------------------------------------------------------------------------------------------- ;
; Command Buffer / Work
; -------------------------------------------------------------------------------------------------------------- ;
CMDBUF            = $0200       ; input buffer for command string from computer

CMDSTR_ME_LEN       = $05       ; M-E AdrLo AdrHi                     - Memory-Execute
CMDSTR_MR_LEN       = $06       ; M-R AdrLo AdrHi Num                 - Memory-Read
CMDSTR_MW_LEN       = $06       ; M-W AdrLo AdrHi Num(max $23)        - Memory-Write
CMDSTR_MW_MAX       = [CMDBUF_LEN - CMDSTR_MW_LEN] ; 

CMDSTR_BR_LEN       = $07       ; B-R Channel# Drive# Track# Sector#  - Block-Read (do not use)
CMDSTR_U1_LEN       = $06       ;  U1 Channel# Drive# Track# Sector#  - Block-Read

CMDSTR_BW_LEN       = $07       ; B-R Channel# Drive# Track# Sector#  - Block-Write (do not use)
CMDSTR_U2_LEN       = $06       ;  U2 Channel# Drive# Track# Sector#  - Block-Write

CMDSTR_BA_LEN       = $06       ; B-A Drive# Track# Sector#           - Block-Allocate in BAM
CMDSTR_BE_LEN       = $06       ; B-E Drive# Track# Sector#           - Block-Execute
CMDSTR_BF_LEN       = $06       ; B-F Drive# Track# Sector#           - Block-Free in BAM
CMDSTR_BP_LEN       = $03       ; B-P Channel# Position#              - Buffer-Pointer

CMDBUFX           = $0229       ; 
CMDBUF_LEN          = [CMDBUFX - CMDBUF] ; input buffer size
; -------------------------------------------------------------------------------------------------------------- ;
CMDNUM            = $022a       ; command code number
CMDNUM_DOS0         = $00       ;   open
CMDNUM_DOS1         = $01       ;   dos
CMDNUM_DOS2         = $02       ;   dos
CMDNUM_DOS3         = $03       ;   dos
CMDNUM_DOS4         = $04       ;   dos
CMDNUM_DOS5         = $05       ;   dos
CMDNUM_DOS6         = $06       ;   dos
CMDNUM_DOS7         = $07       ;   dos
CMDNUM_DOS8         = $08       ;   dos
CMDNUM_DOS9         = $09       ;   dos
CMDNUM_DOSa         = $0a       ;   dos
CMDNUM_DOSb         = $0b       ;   dos
CMDNUM_DOS$         = $0c       ;   open "$"
CMDNUM_DOSB         = $80       ; - $fe: "B-x" commands
CMDNUM_DOSE         = $ff       ; error: command too long
; -------------------------------------------------------------------------------------------------------------- ;
LINTAB            = $022b       ; array: logical index - current status of each data channel (secondary address)
LINTAB_NA           = $ff       ;        no channel assigned (inactive)
LINTAB_R            = $01       ;        open for read
LINTAB_RW           = $41       ;        open for read/write
LINTAB_W            = $81       ;        open for write
LINTAB0           = $022b       ;        logical index channel 0
LINTAB1           = $022c       ;        logical index channel 1
LINTAB2           = $022d       ;        logical index channel 2
; -------------------------------------------------------------------------------------------------------------- ;
CHNDAT            = $022e       ; channel data byte
                                ; offset next data byte to be read or written from buffers #0-#4 for each channel
CHNDATX           = $0243       ; 
CHNDAT_LEN        = [CHNDATX - CHNDAT] ; 
; -------------------------------------------------------------------------------------------------------------- ;
LSTCHR            = $0244       ; channel last character pointer
                                ; offset last data byte read or written in buffers #0-#4 for each channel
LSTCHR0           = $0244       ; 
LSTCHR1           = $0245       ; 
LSTCHR2           = $0246       ; 
LSTCHR3           = $0247       ; 
LSTCHR4           = $0248       ; 
LSTCHR5           = $0249       ; 
LSTCHRX           = LSTCHR5     ; 
LSTCHR_LEN        = [LSTCHRX - LSTCHR] ; 
; -------------------------------------------------------------------------------------------------------------- ;
TYPE              = $024a       ; active file type
STRSIZ            = $024b       ; active file name length
TEMPSA            = $024c       ; temp area for secondary address
TEMPCMD           = $024d       ; temp area for disk controller command
LSTSEC            = $024e       ; work area to find the best sector
BUFUSE            = $024f       ; Buffer allocation register low
BUFUSE0             = %00000001 ;    buffer #0 is being used
BUFUSE1             = %00000010 ;    buffer #1 is being used
BUFUSE2             = %00000100 ;    buffer #2 is being used
BUFUSE3             = %00001000 ;    buffer #3 is being used
BUFUSE4             = %00010000 ;    buffer #4 is being used
BUFUSEE             = %00100000 ;    error message buffer is being used
BUFUSEH           = $0250       ; Buffer allocation register high
MDIRTY            = $0251       ; flag: BAM changed drive #0
MDIRTY_NO           = $00       ;       BAM unchanged
MDIRTY_YES          = $01       ; - $ff BAM has been changed - must be written onto disk
MDIRTY1           = $0252       ; flag: BAM changed drive #1                                    ---> unused <---
ENTFND            = $0253       ; flag: directory entry found
                                ;   bit7=1   : a file matching the name has NOT been found in the directory
                                ;   bit7=0   : a file matching the name has     been found in the directory
                                ;   bit0-bit2: current entry number
DIRLST            = $0254       ; directory listing flag
DIRLST_YES          = $00       ;         data file is being LOADed
DIRLST_NO           = $01       ;   -$ff: directory is being LOADed
CMDWAT            = $0255       ; command waiting flag
CMDWAT_YES          = $00       ;   command still arriving
CMDWAT_NO           = $01       ;   command fully arrived
LINUSE            = $0256       ; channel allocation register
LINUSE0             = %00000001 ;    channel #0 is being used
LINUSE1             = %00000010 ;    channel #1 is being used
LINUSE2             = %00000100 ;    channel #2 is being used
LINUSE3             = %00001000 ;    channel #3 is being used
LINUSE4             = %00010000 ;    channel #4 is being used
LINUSE5             = %00100000 ;    channel #5 is being used
LINUSE6             = %01000000 ;    channel #6 is being used
LBUSED            = $0257       ; last used buffer - temp area for channel number
                                ;   $00-$06: assigned buffer number in primary   table BUF0CH ($a7-$ad)
                                ;   $07-$0D: assigned buffer number in secondary table BUF1CH ($ae-$b4)
REC               = $0258       ; record length of current relative file
TRKSS             = $0259       ; side sector track
SECSS             = $025a       ; side sector sector
; -------------------------------------------------------------------------------------------------------------- ;
LSTJOB            = $025b       ; original disk controller commands of buffers #0-#4
LSTJOB0             = $025b     ; 
LSTJOB1             = $025c     ; 
LSTJOB2             = $025d     ; 
LSTJOB3             = $025e     ; 
LSTJOB4             = $025f     ; 
LSTJOBX             = LSTJOB4   ; 
LSTJOB_LEN          = [LSTJOBX - LSTJOB] ; 
; -------------------------------------------------------------------------------------------------------------- ;
DSEC              = $0260       ; sector number of directory entry of files specified in command
DSEC0               = $0260     ; 
DSEC1               = $0261     ; 
DSEC2               = $0262     ; 
DSEC3               = $0263     ; 
DSEC4               = $0264     ; 
DSEC5               = $0265     ; 
DSECX               = DSEC5     ; 
DSEC_LEN            = [DSECX - DSEC] ; 
; -------------------------------------------------------------------------------------------------------------- ;
DIND              = $0266       ; offset of directory entry of files specified in command
DIND0               = $0266     ; 
DIND1               = $0267     ; 
DIND2               = $0268     ; 
DIND3               = $0269     ; 
DIND4               = $026a     ; 
DIND5               = $026b     ; 
DINDX               = DIND5     ; 
DIND_LEN            = [DINDX - DIND] ; 
; -------------------------------------------------------------------------------------------------------------- ;
ERWORD            = $026c       ; flag: display warning messages of relative files
ERWORD_YES          = $01       ; -$ff: display warning messages
ERWORD_NO           = $00       ;       always display "00,OK" instead of warnings
ERLED             = $026d       ; drive #0 LED must blink during error
ERLED_OFF           = $00       ; switch LED off
ERLED_ON            = $80       ; switch LED on
PRGDRV            = $026e       ; drive  number of previously opened file (used when opening "*")
PRGSEC            = $026f       ; sector number of previously opened file (Used when opening "*")
WLINDX            = $0270       ; temp area for channel number (write LINDX)
RLINDX            = $0271       ; temp area for channel number (read  LINDX)
NBTEMP            = $0272       ; BASIC line number for entries sent to host during LOAD "$"
                                ;   for header: drive number
                                ;   for files : length of file in blocks
                                ;   for footer: number of free blocks
NBTEMP0           = $0272       ; 
NBTEMP1           = $0273       ; 
CMDSIZ            = $0274       ; length of command string
CHAR              = $0275       ; actual character to search for in input buffer
LIMIT             = $0276       ; index: End of filename in command buffer (1st char after file name in command)
F1CNT             = $0277       ; number of commas in command
F2CNT             = $0278       ; number of commas or unit numbers in command
F2PTR             = $0279       ; number of commas before equation mark in command
                                ; number of current file in command during search for files specified in command
; -------------------------------------------------------------------------------------------------------------- ;
; Parser Table Area ($027a - $0289)
; -------------------------------------------------------------------------------------------------------------- ;
FILTBL            = $027a       ; index: file names in command (last offset specifies end of command)
FILTBL0           = $027a       ; 
FILTBL1           = $027b       ; 
FILTBL2           = $027c       ; 
FILTBL3           = $027d       ; 
FILTBL4           = $027e       ; 
FILTBL5           = $027f       ; 
FILTBLX           = FILTBL5     ; 
FILTBL_LEN          = [FILTBLX - FILTBL] ; 
; -------------------------------------------------------------------------------------------------------------- ;
FILTRK            = $0280       ; track number of files specified in command
                                ; $00    : file not yet found in directory
                                ; $01-$ff: track number of first sector of file
                                ; for "B-x" cmds: high byte of parameters
FILTRK0           = $0280       ;
FILTRK1           = $0281       ;
FILTRK2           = $0282       ;
FILTRK3           = $0283       ;
FILTRK4           = $0284       ;
FILTRKX           = FILTRK4     ;
FILTRK_LEN          = [FILTRKX - FILTRK] ; 
; -------------------------------------------------------------------------------------------------------------- ;
FILSEC            = $0285       ; sector number of files specified in command
                                ; $00    : file not yet found in directory
                                ; $01-$ff: sector number of first sector of file
                                ; for "B-x" cmds: low byte of parameters
FILSEC0           = $0285       ; 
FILSEC1           = $0286       ; 
FILSEC2           = $0287       ; 
FILSEC3           = $0288       ; 
FILSEC4           = $0289       ; 
FILSECX           = FILSEC4     ; 
FILSEC_LEN          = [FILSECX - FILSEC] ; 
; -------------------------------------------------------------------------------------------------------------- ;
PATFLG            = $028a       ; flag: wild card present (number of wildcards found in current file name)
IMAGE             = $028b       ; flag: command syntax check
IMAGE_EQA           = %00000001 ; equation marks are present in the command
IMAGE_EQB           = %00000010 ; equation marks are present in the command
IMAGE_COA           = %00000100 ; commas    after  equation marks are present in the command
IMAGE_WCA           = %00001000 ; wildcards after  equation marks are present in the command
IMAGE_COB           = %01000000 ; commas    before equation marks are present in the command
IMAGE_WCB           = %10000000 ; wildcards before equation marks are present in the command
DRVCNT            = $028c       ; number of drives to process during reading the directory
DRVCNT1             = $00       ;   only one drive
DRVCNT2             = $01       ;   both drives
DRVFLG            = $028d       ; current unit number during reading the directory
DRVFLG1             = $00       ;   drive previously used
DRVFLG2             = $01       ;   switch to inactive drive
LSTDRV            = $028e       ; previous drive number during reading the directory (used as default drive)
FOUND             = $028f       ; flag: found in directory searches (indicator to keep searching in the directory)
FOUND_NO            = $00       ;       still more files to be searched for
FOUND_YES           = $01       ; -$ff: all files have been found - no need to continue search
DIRSEC            = $0290       ; current directory sector number
DELSEC            = $0291       ; directory sector number to read (sector number for 1st available file)
DELSEC_1ST          = $00       ;        1st directory sector is to be read
DELSEC_NEXT         = $01       ; - $ff: sector number of next directory to read
DELIND            = $0292       ; offset of current directory entry in directory sector (index of 1st available file)
LSTBUF            = $0293       ; flag: end of directory
LSTBUF_YES          = $00       ;      : current directory sector is the last one
LSTBUF_NO           = $01       ; - $ff: more directory sectors are present
BUFIDX            = $0294       ; offset: current directory entry in buffer
FILCNT            = $0295       ; number of remaining directory entries in directory sector minus 1
                                ;   $00 - $07: number of remaining directory entries
                                ;   $ff      : no more entries left
TYPFLG            = $0296       ; flag: file type of file being searched in directory
TYPFLG_NO           = $00       ;       file type was NOT specified in command - any file type will match
TYPFLG_YES          = $01       ;       file type was     specified in command
FMODE             = $0297       ; file open mode
FMODE_R             = $00       ;   "R" - read   or LOAD
FMODE_W             = $01       ;   "W" - write  or SAVE
FMODE_A             = $02       ;   "A" - append
FMODE_M             = $03       ;   "M" - modify or salvage improperly closed file
JOBRTN            = $0298       ; flag: message display for disk errors
JOBRTN_NO           = %00000000 ;       bit7=0: silently ignore the following errors when executing disk commands
                                ;               "26,WRITE PROTECT ON"
                                ;               "29,DISK ID MISMATCH"
                                ;               "74,DRIVE NOT READY" 
JOBRTN_YES          = %10000000 ;       bit7=1: display the error messages
EPTR              = $0299       ; offset: current byte in halftrack seek table during retrying disk operations on adjacent halftracks
TOFF              = $029a       ; offset: direction of seeking back to original halftrack during retry disk operations on adjacent halftracks
UBAM              = $029b       ; track number current BAM entry of drive #0
UBAM1             = $029c       ; track number current BAM entry of drive #1                    ---> unused <---
TBAM              = $029d       ; track numbers of two cached BAM entries of drive #0
TBAM00              = $029d     ; 1st track number of two cached BAM entries of drive #0
TBAM01              = $029e     ; 2nd track number of two cached BAM entries of drive #0
TBAM1             = $029f       ; track numbers of two cached BAM entries of drive #1           ---> unused <---
TBAM10              = $029f     ; 1st track number of two cached BAM entries of drive #1        ---> unused <---
TBAM11              = $02a0     ; 2nd track number of two cached BAM entries of drive #1        ---> unused <---
; -------------------------------------------------------------------------------------------------------------- ;
; BAM Images Buffer
; -------------------------------------------------------------------------------------------------------------- ;
BAM               = $02a1       ; buffer: BAM image
BAMX              = $02b0       ; 
BAM_LEN           = [BAMX - BAM]; 
; -------------------------------------------------------------------------------------------------------------- ;
; Directory Buffer
; -------------------------------------------------------------------------------------------------------------- ;
NAMBUF            = $02b1       ; buffer: directory output
NAMBUFX           = $02d4       ; 
NAMBUF_LEN        = [NAMBUFX - NAMBUF] ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Error Message Buffer
; -------------------------------------------------------------------------------------------------------------- ;
ERRBUF            = $02d5       ; - $02f8: buffer error message output
ERRBUFX           = $02f8       ; 
ERRBUF_LEN        = [ERRBUFX - ERRBUF] ; 
; -------------------------------------------------------------------------------------------------------------- ;
WBAM              = $02f9       ; flag: 'don't write BAM' - reset to $00 before and after each command
                                ;       disk update upon BAM change switch
                                ;       different BAM-related operations expect different values here
NDBLO             = $02fa       ; number of disk blocks free for drive #0 (lo byte)
NDBLO1            = $02fb       ; number of disk blocks free for drive #1 (lo byte)             ---> unused <---
NDBHI             = $02fc       ; number of disk blocks free for drive #0 (hi byte)
NDBHI1            = $02fd       ; number of disk blocks free for drive #1 (hi byte)             ---> unused <---
PHASE             = $02fe       ; direction of seeking adjacent halftrack drive #0 (current phase of head stepper motor)
PHASE_NO            = $00       ;   no seeking
PHASE_UP            = $01       ;   seek a halftrack upwards
PHASE_OK            = $02       ;   halftrack seeking complete
PHASE_DO            = $ff       ;   seek a halftrack downwards
PHASE1            = $02ff       ; direction of seeking adjacent halftrack drive #1              ---> unused <---
; -------------------------------------------------------------------------------------------------------------- ;
; Data Buffers
; -------------------------------------------------------------------------------------------------------------- ;
BUF0              = $0300       ; main working buffer
BUF1              = $0400       ; contains the actual part of the directory
BUF2              = $0500       ; USER buffer - normally free
BUF3              = $0600       ; contains the last directory block
BUF4              = $0700       ; contains block 18,0 (BAM) after init
; -------------------------------------------------------------------------------------------------------------- ;
END_OF_RAM        = $7fff       ; no ram from $0800 - $bfff
; -------------------------------------------------------------------------------------------------------------- ;
