; -------------------------------------------------------------------------------------------------------------- ;
; VC1541 - 6522 VIA1 chip register definitions
; -------------------------------------------------------------------------------------------------------------- ;
; VIA #1 Registers - $1800-$180F - port for serial bus
; -------------------------------------------------------------------------------------------------------------- ;
VIA1              = $1800        ; Base address
; -------------------------------------------------------------------------------------------------------------- ;
SERCNT            = [VIA1 + $00] ; Serial Bus Controller - Data Port B (ATN, CLOCK, Ser Data I/O, Device #)
SERCNT_DATIN        = %00000001  ; DATA  In  line
SERCNT_DATOUT       = %00000010  ; DATA  Out line
SERCNT_CLKIN        = %00000100  ; CLOCK In  line
SERCNT_CLKOUT       = %00001000  ; CLOCK Out line
SERCNT_ATNOUT       = %00010000  ; ATTENTION Acknowledge Out (Attention acknowledge line)
SERCNT_ATNOUT_ENAB  = %00010000  ;   1=Enable device presence detection by automatically
                                 ;      acknowledging ATN IN signals on DATA OUT
SERCNT_ATNOUT_DISAB = %11101111  ; 
SERCNT_DEVICE       = %01100000  ; Device Address Preset Switches (hardware device number)
SERCNT_DEVICE_08    = %00000000  ;   00 = #8
SERCNT_DEVICE_09    = %00100000  ;   01 = #9
SERCNT_DEVICE_10    = %01000000  ;   10 = #10
SERCNT_DEVICE_11    = %01100000  ;   11 = #11
SERCNT_ATN          = %10000000  ; ATTENTION IN from serial bus
; -------------------------------------------------------------------------------------------------------------- ;
DATA1             = [VIA1 + $01] ; Data Port A - read to acknowledge interrupt generated by ATN IN going high (unused)
; -------------------------------------------------------------------------------------------------------------- ;
DDRB1             = [VIA1 + $02] ; Data Direction Register Port B
                                 ; bit0-bit7=0 - corresponding bit0-bit7 in PA1 can be read only
                                 ; bit0-bit7=1 - corresponding bit0-bit7 in PA1 can be read and written 
DDRB1_INI           = %00011010  ; $1a
; -------------------------------------------------------------------------------------------------------------- ;
DDRA1             = [VIA1 + $03] ; Data Direction Register Port A (unused)
                                 ;   bit0-bit7=0 - corresponding bit0-bit7 in PB can be read only 
                                 ;   bit0-bit7=1 - corresponding bit0-bit7 in PB can be read and written 
DDRA_INI            = %11111111  ; $ff
; -------------------------------------------------------------------------------------------------------------- ;
T1CL1             = [VIA1 + $04] ; Timer 1 Low-Byte  (Timeout Errors)
                                 ;   read  low  byte to start timer or restart timer upon underflow
; -------------------------------------------------------------------------------------------------------------- ;
T1CH1             = [VIA1 + $05] ; Timer 1 High-Byte (Timeout Errors)
                                 ;   write high byte to start timer or restart timer upon underflow
; -------------------------------------------------------------------------------------------------------------- ;
T1LL1             = [VIA1 + $06] ; Timer 1-Latch Low-Byte  (Timeout Errors)
                                 ;   read/write starting value of timer from/to here
; -------------------------------------------------------------------------------------------------------------- ;
T1LH1             = [VIA1 + $07] ; Timer 1-Latch High-Byte (Timeout Errors)
                                 ;   read/write starting value of timer from/to here
; -------------------------------------------------------------------------------------------------------------- ;
T2CL1             = [VIA1 + $08] ; Timer 2 Low-Byte  (unused)
; -------------------------------------------------------------------------------------------------------------- ;
T2CH1             = [VIA1 + $09] ; Timer 2 High-Byte (unused)
; -------------------------------------------------------------------------------------------------------------- ;
SR1               = [VIA1 + $0a] ; Shift Register
; -------------------------------------------------------------------------------------------------------------- ;
ACR1              = [VIA1 + $0b] ; Auxiliary Control Register
ACR1_PA_LATCH       = %00000001  ; Control latching PB
ACR1_PA_LATCH_ENA   = %00000001  ;   1 = enable  latching PB
ACR1_PA_LATCH_DISA  = %11111110  ;   0 = disable latching PB
ACR1_PB_LATCH       = %00000010  ; Control latching PB
ACR1_PB_LATCH_ENA   = %00000010  ;   1 = enable  latching PB
ACR1_PB_LATCH_DISA  = %11111101  ;   0 = disable latching PB
ACR1_SHIFT_I_CTRL   = %00011100  ; Shift Register Control
ACR1_SHIFT_I_OFF    = %00000000  ;   Disabled
ACR1_SHIFT_I_TI2    = %00000100  ;   Shift in  under control of Timer 2     
ACR1_SHIFT_I_PHI2   = %00001000  ;   Shift in  under control of Phi2        
ACR1_SHIFT_I_EXT    = %00001100  ;   Shift in  under control of ext Clock   
ACR1_SHIFT_O_FREE2  = %00010000  ;   Shift out free-running at Timer 2 rate
ACR1_SHIFT_O_TI2    = %00010100  ;   Shift out under control of Timer 2    
ACR1_SHIFT_O_PHI2   = %00011000  ;   Shift out under control of Phi2       
ACR1_SHIFT_O_EXT    = %00011100  ;   Shift out under control of ext Clock  
ACR1_TI2_CTRL       = %00100000  ; Timer 2 Control
ACR1_TI2_CTRL_IPULS = %00100000  ;   Count Pulses on PB6
ACR1_TI2_CTRL_ITIME = %11011111  ;   Timed Interrupt
ACR1_TI1_CTRL       = %11000000  ; Timer 1 Control
ACR1_TI1_CTRL_ILOAD = %00000000  ;   Timed Interrupt when Timer 1 is loaded - no PB7
ACR1_TI1_CTRL_ICONT = %01000000  ;   Continuous Interrupts                  - no PB7
ACR1_TI1_CTRL_IONES = %10000000  ;   Timed Interrupt when Timer 1 is loaded - one-shot    on PB7
ACR1_TI1_CTRL_ISQRE = %11000000  ;   Continuous Interrupts                  - square-wave on PB7

;ACR1_TI_Start       = %01000000  ; bit6=1 - start timer
;ACR1_TI_Stop        = %10111111  ; bit6=0 - stop  timer
; -------------------------------------------------------------------------------------------------------------- ;
PCR1              = [VIA1 + $0c] ; Peripheral Control Register
PCR1_CTRL_INT_CA1   = %00000001  ; CA1 Interrupt Control
PCR1_CTRL_INT_CA1_P = %00000001  ;   Positive active edge
PCR1_CTRL_INT_CA1_N = %11111110  ;   Negative active edge

PCR1_CTRL_CA2       = %00001110  ; CA2 Control
PCR1_CTRL_CA2_INEG  = %00000000  ;   Input  - Negative active edge
PCR1_CTRL_CA2_INEGI = %00000010  ;   Input  - Negative edge Independent Interrupt
PCR1_CTRL_CA2_IPOS  = %00000100  ;   Input  - Positive active edge
PCR1_CTRL_CA2_IPOSI = %00000110  ;   Input  - Positive edge Independent Interrupt
PCR1_CTRL_CA2_OHDS  = %00001000  ;   Output - Handshake
PCR1_CTRL_CA2_OPULS = %00001010  ;   Output - Pulse
PCR1_CTRL_CA2_OLO   = %00001100  ;   Output - Low
PCR1_CTRL_CA2_OHI   = %00001110  ;   Output - High
                    
PCR1_CTRL_INT_CB1   = %00010000  ; CB1 Interrupt Control
PCR1_CTRL_INT_CB1_P = %00010000  ;   Positive active edge
PCR1_CTRL_INT_CB1_N = %11101110  ;   Negative active edge
                    
PCR1_CTRL_CB2       = %11100000  ; CB2 Control
PCR1_CTRL_CB2_INEG  = %00000000  ;   Input  - Negative active edge
PCR1_CTRL_CB2_INEGI = %00100000  ;   Input  - Negative edge Independent Interrupt
PCR1_CTRL_CB2_IPOS  = %01000000  ;   Input  - Positive active edge
PCR1_CTRL_CB2_IPOSI = %01100000  ;   Input  - Positive edge Independent Interrupt
PCR1_CTRL_CB2_OHDS  = %10000000  ;   Output - Handshake
PCR1_CTRL_CB2_OPULS = %10100000  ;   Output - Pulse
PCR1_CTRL_CB2_OLO   = %11000000  ;   Output - Low
PCR1_CTRL_CB2_OHI   = %11100000  ;   Output - High

                                 ; CA1 (Input) : ATN IN (make Interrupt if ATN occurs)
                                 
                                 ; bit1=1 - enable interrupts generated by ATN IN going high
                                 ; bit7=1 - fill bit
                                 ;          bit0-bit6 that are set to 1 get their values from this bit
                                 ;          bit0-bit6 that are set to 0 are left unchanged
; -------------------------------------------------------------------------------------------------------------- ;
IFR1              = [VIA1 + $0d] ; Interrupt Flag Register
                                 ;   bit1=1 - ATN IN went high
                                 ;   bit6=1 - timer underflow occurred
IFR1_INT_CA2        = %00000001  ; CA2
IFR1_INT_CA1        = %00000010  ; CA1
IFR1_INT_SHIFT      = %00000100  ; Shift Register
IFR1_INT_CB2        = %00001000  ; CB2
IFR1_INT_CB1        = %00010000  ; CB1
IFR1_INT_TI2        = %00100000  ; Timer 2
IFR1_INT_TI1        = %01000000  ; Timer 1
IFR1_INT            = %10000000  ; Interrupt occurred
; -------------------------------------------------------------------------------------------------------------- ;
IER1              = [VIA1 + $0e] ; Interrupt Enable Register
IER1_ENA_CA2        = %00000001  ; CA2
IER1_ENA_CA1        = %00000010  ; CA1
IER1_ENA_SHIFT      = %00000100  ; Shift Register
IER1_ENA_CB2        = %00001000  ; CB2
IER1_ENA_CB1        = %00010000  ; CB1
IER1_ENA_TI2        = %00100000  ; Timer 2
IER1_ENA_TI1        = %01000000  ; Timer 1
IER1_ENA            = %10000000  ; read : always=1
                                 ; write: 1=Set Interrupt Flags / 0=Clear Interrupt Flags
; -------------------------------------------------------------------------------------------------------------- ;
IRA1              = [VIA1 + $0f] ; Data Port A - same as PA1 except no handshake will be initiated
; -------------------------------------------------------------------------------------------------------------- ;
                          