; -------------------------------------------------------------------------------------------------------------- ;
; VC1541 - 6522 VIA2 chip register definitions
; -------------------------------------------------------------------------------------------------------------- ;
; VIA #2 Registers - $1C00-$1C0F - port for motor and read/write head control
; -------------------------------------------------------------------------------------------------------------- ;
VIA2              = $1C00        ; Base address
; -------------------------------------------------------------------------------------------------------------- ;
DSKCNT            = [VIA2 + $00] ; Disk Controller I/O - Data Port B (SYNC, Motors, Bit Rates, LED)
DSKCNT_STEPPER      = [DSKCNT_STEPPER0  | DSKCNT_STEPPER1] ; 
                                 ;   bit0-bit1: decrease value (%00-%11-%10-%01-%00...) - move head downwards
                                 ;   bit0-bit1: increase value (%00-%01-%10-%11-%00...) - move head upwards
DSKCNT_STEPPER_SET  = %00000011  ; stepper motor head step direction
DSKCNT_STEPPER_CLR  = %11111100  ; stepper motor head step direction
DSKCNT_STEPPER0     = %00000001  ; stepper motor bit 0 - head step direction
DSKCNT_STEPPER1     = %00000010  ; stepper motor bit 1 - head step direction
                                 ;   Sequence 00/01/10/11/00... move inwards
                                 ;   Sequence 00/11/10/01/00... move outwards
DSKCNT_MOTOR        = %00000100  ; drive #0 motor control
DSKCNT_MOTOR_ON     = %00000100  ;   1=on
DSKCNT_MOTOR_OFF    = %11111011  ;   0=off
DSKCNT_LED          = %00001000  ; drive #0 LED control
DSKCNT_LED_ON       = %00001000  ;   1=on
DSKCNT_LED_OFF      = %11110111  ;   0=off
DSKCNT_PROT         = %00010000  ; write protect photo cell status
DSKCNT_PROT_ON      = %11101111  ;   0=write protect tab covered   = disk protected
DSKCNT_PROT_OFF     = %00010000  ;   1=write protect tab uncovered = disk not protected
DSKCNT_BITRATE      = [DSKCNT_BITRATE0  | DSKCNT_BITRATE1]   ; 
                                 ;   bit5-bit6: Data density - %00=lowest / %11=highest
DSKCNT_BITRATE      = %01100000  ; 
DSKCNT_BITRATE_CLR  = %10011111  ; 
DSKCNT_BITRATE0     = %00100000  ; drive transfer rate bit 0 - data density
DSKCNT_BITRATE1     = %01000000  ; drive transfer rate bit 1 - data density
                                 ;  00 = 250000 Bit/s - Tracks 31-35
                                 ;  01 = 266667 Bit/s - Tracks 25-30
                                 ;  10 = 285714 Bit/s - Tracks 18-24
                                 ;  11 = 307692 Bit/s - Tracks  1-17
DSKCNT_SYNC         = %10000000  ; SYNC detected
                                 ;   bit7=0 - data bytes are being currently read from disk
                                 ;   bit7=1 - SYNC marks are being read
; ------------------------------------------------------------------------------------------------------------- ;
DATA2             = [VIA2 + $01] ; Data Port A (Data to/from head)
; ------------------------------------------------------------------------------------------------------------- ;
DDRB2             = [VIA2 + $02] ; Data Direction Register Port B
                                 ;   bit0-bit7=0 - corresponding bit0-bit7 in DSKCNT can be read only 
                                 ;   bit0-bit7=1 - corresponding bit0-bit7 in DSKCNT can be read and written 
DDRB2_INI           = %01101111  ; $6f
; ------------------------------------------------------------------------------------------------------------- ;
DDRA2             = [VIA2 + $03] ; Data Direction Register Port A
                                 ;   bit0-bit7=0 - corresponding bit0-bit7 in DATA2 set to input
                                 ;   bit0-bit7=1 - corresponding bit0-bit7 in DATA2 set to output
DDRA2_READ          = %00000000  ;   $00 - read  from disk
DDRA2_WRITE         = %11111111  ;   $ff - write to   disk
; ------------------------------------------------------------------------------------------------------------- ;
T1CL2             = [VIA2 + $04] ; Timer 1 Low-Byte  (IRQ Timer)
                                 ;   read  low  byte to start timer or restart timer upon underflow
; ------------------------------------------------------------------------------------------------------------- ;
T1CH2             = [VIA2 + $05] ; Timer 1 High-Byte (IRQ Timer)
                                 ;   write high byte to start timer or restart timer upon underflow
; ------------------------------------------------------------------------------------------------------------- ;
T1LL2             = [VIA2 + $06] ; Timer 1-Latch Low-Byte  (IRQ Timer)
                                 ;   read/write starting value of timer from/to here
; ------------------------------------------------------------------------------------------------------------- ;
T1LH2             = [VIA2 + $07] ; Timer 1-Latch High-Byte (IRQ Timer)
                                 ;   read/write starting value of timer from/to here
; ------------------------------------------------------------------------------------------------------------- ;
T2CL2             = [VIA2 + $08] ; Timer 2 Low-Byte  (unused)
; ------------------------------------------------------------------------------------------------------------- ;
T2CH2             = [VIA2 + $09] ; Timer 2 High-Byte (unused)
; ------------------------------------------------------------------------------------------------------------- ;
SR2               = [VIA2 + $0a] ; Shift Register
; ------------------------------------------------------------------------------------------------------------- ;
ACR2              = [VIA2 + $0b] ; Auxiliary Control Register
ACR2_PA_LATCH       = %00000001  ; Control latching PB
ACR2_PA_LATCH_ENA   = %00000001  ;   1 = enable  latching PB
ACR2_PA_LATCH_DISA  = %11111110  ;   0 = disable latching PB
ACR2_PB_LATCH       = %00000010  ; Control latching PB
ACR2_PB_LATCH_ENA   = %00000010  ;   1 = enable  latching PB
ACR2_PB_LATCH_DISA  = %11111101  ;   0 = disable latching PB
ACR2_SHIFT_I_CTRL   = %00011100  ; Shift Register Control
ACR2_SHIFT_I_OFF    = %00000000  ;   Disabled
ACR2_SHIFT_I_TI2    = %00000100  ;   Shift in  under control of Timer 2     
ACR2_SHIFT_I_PHI2   = %00001000  ;   Shift in  under control of Phi2        
ACR2_SHIFT_I_EXT    = %00001100  ;   Shift in  under control of ext Clock   
ACR2_SHIFT_O_FREE2  = %00010000  ;   Shift out free-running at Timer 2 rate
ACR2_SHIFT_O_TI2    = %00010100  ;   Shift out under control of Timer 2    
ACR2_SHIFT_O_PHI2   = %00011000  ;   Shift out under control of Phi2       
ACR2_SHIFT_O_EXT    = %00011100  ;   Shift out under control of ext Clock  
ACR2_TI2_CTRL       = %00100000  ; Timer 2 Control
ACR2_TI2_CTRL_IPULS = %00100000  ;   Count Pulses on PB6
ACR2_TI2_CTRL_ITIME = %11011111  ;   Timed Interrupt
ACR2_TI1_CTRL       = %11000000  ; Timer 1 Control
ACR2_TI1_CTRL_ILOAD = %00000000  ;   Timed Interrupt when Timer 1 is loaded - no PB7
ACR2_TI1_CTRL_ICONT = %01000000  ;   Continuous Interrupts                  - no PB7
ACR2_TI1_CTRL_IONES = %10000000  ;   Timed Interrupt when Timer 1 is loaded - one-shot    on PB7
ACR2_TI1_CTRL_ISQRE = %11000000  ;   Continuous Interrupts                  - square-wave on PB7

;ACR2_TI_Start       = %01000000  ; bit6=1 - start timer
;ACR2_TI_Stop        = %10111111  ; bit6=0 - stop  timer
; ------------------------------------------------------------------------------------------------------------- ;
PCR2              = [VIA2 + $0c] ; Peripheral Control Register
PCR2_CTRL_INT_CA1   = %00000001  ; CA1 Interrupt Control
PCR2_CTRL_INT_CA1_P = %00000001  ;   Positive active edge
PCR2_CTRL_INT_CA1_N = %11111110  ;   Negative active edge

PCR2_CTRL_CA2       = %00001110  ; CA2 Control
PCR2_CTRL_CA2_INEG  = %00000000  ;   Input  - Negative active edge
PCR2_CTRL_CA2_INEGI = %00000010  ;   Input  - Negative edge Independent Interrupt
PCR2_CTRL_CA2_IPOS  = %00000100  ;   Input  - Positive active edge
PCR2_CTRL_CA2_IPOSI = %00000110  ;   Input  - Positive edge Independent Interrupt
PCR2_CTRL_CA2_OHDS  = %00001000  ;   Output - Handshake
PCR2_CTRL_CA2_OPULS = %00001010  ;   Output - Pulse
PCR2_CTRL_CA2_OLO   = %00001100  ;   Output - Low
PCR2_CTRL_CA2_OHI   = %00001110  ;   Output - High
                    
PCR2_CTRL_INT_CB1   = %00010000  ; CB1 Interrupt Control
PCR2_CTRL_INT_CB1_P = %00010000  ;   Positive active edge
PCR2_CTRL_INT_CB1_N = %11101110  ;   Negative active edge
                    
PCR2_CTRL_CB2       = %11100000  ; CB2 Control
PCR2_CTRL_CB2_INEG  = %00000000  ;   Input  - Negative active edge
PCR2_CTRL_CB2_INEGI = %00100000  ;   Input  - Negative edge Independent Interrupt
PCR2_CTRL_CB2_IPOS  = %01000000  ;   Input  - Positive active edge
PCR2_CTRL_CB2_IPOSI = %01100000  ;   Input  - Positive edge Independent Interrupt
PCR2_CTRL_CB2_OHDS  = %10000000  ;   Output - Handshake
PCR2_CTRL_CB2_OPULS = %10100000  ;   Output - Pulse
PCR2_CTRL_CB2_OLO   = %11000000  ;   Output - Low
PCR2_CTRL_CB2_OHI   = %11100000  ;   Output - High

                                 ;    CA1 (Input) : BYTE-READY                          
                                 ;    CA2 (Output): SOE (High = activate BYTE-READY)    
                                 ;    CB2 (Output): Head Mode (Low = Write / High = Read)

PCR2_ATT_V          = %00000001  ; 
PCR2_ATT_V_YES      = %00000001  ;   bit1=1 - attach BYTE-READY line to Overflow (V) Processor Flag
                                 ;            the V-flag is set to 1 if a byte 
                                 ;              - has been successfully read from disk
                                 ;              - has been successfully written to disk
PCR2_ATT_V_NO       = %11111110  ; 

PCR2_HD_CTRL        = %00100000  ;   bit5: head control  
PCR2_HD_CTRL_WRITE  = %00100000  ;    1=Write
PCR2_HD_CTRL_READ   = %11011111  ;    0=Read
; ------------------------------------------------------------------------------------------------------------- ;
IFR2              = [VIA2 + $0d] ; Interrupt Flag Register
IFR2_INT_CA2        = %00000001  ; CA2
IFR2_INT_CA1        = %00000010  ; CA1
IFR2_INT_SHIFT      = %00000100  ; Shift Register
IFR2_INT_CB2        = %00001000  ; CB2
IFR2_INT_CB1        = %00010000  ; CB1
IFR2_INT_TI2        = %00100000  ; Timer 2
IFR2_INT_TI1        = %01000000  ; Timer 1
IFR2_INT            = %10000000  ; Interrupt occurred
; ------------------------------------------------------------------------------------------------------------- ;
IER2              = [VIA2 + $0e] ; Interrupt Enable Register
IER2_ENA_CA2        = %00000001  ; CA2
IER2_ENA_CA1        = %00000010  ; CA1
IER2_ENA_SHIFT      = %00000100  ; Shift Register
IER2_ENA_CB2        = %00001000  ; CB2
IER2_ENA_CB1        = %00010000  ; CB1
IER2_ENA_TI2        = %00100000  ; Timer 2
IER2_ENA_TI1        = %01000000  ; Timer 1
IER2_ENA            = %10000000  ; read : always=1
                                 ; write: 1=Set Interrupt Flags / 0=Clear Interrupt Flags
; ------------------------------------------------------------------------------------------------------------- ;
IRA2              = [VIA2 + $0f] ; Data Port A - same as DATA2 except no handshake will be initiated
; -------------------------------------------------------------------------------------------------------------- ;
                          