
; Gunfright Plus4 TED & SID - V1.10

; Tedzakker_1_0 used for ted sound version.
; Goat Tracker 2.73 used for sid sound version.

; Improvements over original Spectrum version:
;---------------------------------------------
; Turn & walk plus directional control available for both keyboard & joystick control

; Notes:
; ------
; old_clear_part_2 (part of old screen clear, seems to clear down vars)
; game_on if 0 then in bonus screen, if 4 then in game
; LB68F - no townsfolk

; Keys in Keyboard mode:
; Q 		- up
; A 		- down
; O 		- left
; P 		- right 
; Space 	- fire
; Z 		- change view
; L Shift 	- pause (fire un-pause)

; Use Space in Joystick mode to change view


; Complie Ted or Sid version...
; 0 = SID, 1 = TED
TED_SOUND = 0

FRAME_MIN = 2
FRAME_SYNC_GAME = 3
FRAME_SYNC_MINI_GAME = 2

spectrum_screen			equ $c000 ; 8k
ScreenBuffer			equ $f000 ; 3k  size: $0a80	; note: game writes past buffer, probably to ease clipping?
RotationTable			equ $e000 ; 4k  size: $1000
MirrorTable				equ RotationTable+$0900
ROM_PAGE_ZERO			equ $fc00 ; 0.25k
screen_mem				equ $b800 ; 1k
luma_mem				equ $bc00 ; 1k

bullet_sprite			equ $dfb0 ;$df80
expl_sprite				equ $dfd0 ;$dfa0


		.if TED_SOUND == 1

; ted sound
ted_music_play			equ $aa00
ted_player				equ $aa03
		
		.else

; sid sound
music_play				equ $ab00
sid_player				equ $ab03
sfx_play				equ $ab06
sound_volume			equ $ab09

sound_player_e			equ $a703
sfx_play_e				equ $a706

sfxwalk1				equ $aa00+$70 ;C1 (and expl in game)
sfxbounce				equ $aa09+$70 ;C2

sfxtelegram				equ $aa16+$70 ;C2
sfxhorse				equ $aa1e+$70 ;C2 (horse & money bag in game)

;sfxpause				equ $aa33+$70 ;C3
sfxshoot     			equ $aa2f+$70 ;C3
sfxexpl					equ $aa45+$70 ;C3 (bonus game only)
sfxreload				equ $aa74+$70 ;C3

		.endif


border 					= $ff19
background 				= $ff15

random					= $ff1d

; zer0page vars
frame_counter			= $1f

dest_col_lo				= $c0
dest_col_hi				= $c1
destb_lo				= $c2
destb_hi				= $c3
d2_lo					= $c4
d2_hi					= $c5
joyvalue				= $c6
keyvalue				= $c7
source_lo				= $c8
source_hi				= $c9
dest_lo					= $ca
dest_hi					= $cb

;in use					= $cc
;in use					= $cd

sfx_count_001			= $ce ;*
sfx_count_002			= $cf ;*
generate_man			= $d0 ;*

play_bonus_music 		= $d2 ;*
zer0page_software_inc	= $d3 ;*
on_horse 				= $d4 ;*

key_l					= $d5
key_r					= $d6
key_bu					= $d7
key_bd					= $d8

sound_off				= $d9
sound_e					= $da

button_2				= $db
temp_ddra				= $dc
;sound_on				= $dd
key_bf					= $de

; In use for sound ...
;soundfx1				= $ea
;soundfx2				= $eb
;sound1					= $ec
;sound2					= $ed


; $f8 - $ff in use


; Vars comming from front end
UNLIMITED_LIVES			= $03f5 ;$c8
DISABLE_COLISIONS 		= $03f6 ;$c9
UNLIMITED_MONEY 		= $03f7 ;$ca
BANDIT_STUCK			= $03f8 ;$cb
QUICK_RELOAD			= $03f9 ;$cc
MAN_SPEED				= $03fa ;$cd
START_LEVEL			    = $03fb ;$ce
SID						= $03fc ;$cf

			
		;org $0600
		;lda #$ff
		;sta $d301
		;rts
		;ini $0600
		
		; code
		;org $0800
		;icl 'spectrum_atari.asm'

	; basic start
	org 	$0401
    dta 	$0C,$08,$0A,$00,$9E,$20
	dta 	$31,$30,$34,$30,$00			;1040
	dta 	$00,$00,$00,$00

	.if TED_SOUND == 0
	lda		#00
	sta 	sound_e
	sta 	sound_off
	.endif
	
	;org $0801
    ;dta $0C,$08,$0A,$00,$9E,$20
	;dta $32,$30,$36,$34,$00		;2064
	;dta $00,$00,$00,$00	
	
	
; LA265 - number of lives
;CHEAT_DISABLE_COLISIONS	= 0
	
	; cheats for testing
	;lda #01
	;sta UNLIMITED_LIVES
	;sta UNLIMITED_MONEY	
	;sta BANDIT_STUCK
	;sta QUICK_RELOAD
	;sta DISABLE_COLISIONS
	
	
	; start level 00 to 07 only - 03=bonus
	;lda #00
	;sta START_LEVEL
		
	; man speed - Use $0A to $12 ($0A is normal speed)
	;lda #$12
	;sta MAN_SPEED

	; c128 mode deteted - 01 for on
	;lda #00
	;sta C128_MODE_ON
	
; Initial machine set-up
	
	; set VIC to bank $C000
;	lda 	$DD00
;	and 	#%11111100
;	ora 	#%00000000 
;	sta 	$DD00

	; set up vic memory config, bitmap at $c000 colour at $f000 
;	lda 	#%11000000 ;$f000 $c000
;	sta 	$d018

	; hi-res bitmap in 24 row mode
;	lda 	#%00110111  
;	sta 	$d011
;	lda 	#$08
;	sta 	$d016

	
		; open up the memory
	jsr 	raster_irq

	
	; turn music off	
	.if TED_SOUND == 1
		lda #05
		jsr ted_music_play
	.else	
		lda #06
		jsr music_play	
	.endif		

	lda 	#$e8
	sta		d2_lo
	lda		#$d5
	sta		d2_hi
	
	; clear some vars down
	lda 	#$00
	tay
@	
	sta 	$ce,y
	iny
	cpy 	#07
	bne 	@-	
	sta		border
	sta 	background
	sta 	sound_e
	sta 	sound_off

	; remove when front end suppling
;	sta 	UNLIMITED_LIVES
;	sta 	DISABLE_COLISIONS 		
;	sta 	UNLIMITED_MONEY 		
;;	sta 	BANDIT_STUCK			
;	sta 	QUICK_RELOAD			
;;	sta 	MAN_SPEED				
;	sta 	START_LEVEL		      	
;;	sta 	SID							
;;	lda 	#00
;;	sta     START_LEVEL
;	lda 	#$12
;;	sta		DISABLE_COLISIONS
;	sta		BANDIT_STUCK
;	sta 	MAN_SPEED


;	lda		#$0e
;	sta		MAN_SPEED
;	sta		UNLIMITED_MONEY

;	lda 	#15
;	sta		START_LEVEL

lets_go


	; copy un-packed data into place 

	; poster_bottom2
	ldy #00
@
	lda $c300,y
	sta $0100,y
	iny
	cpy #$c0
	bne @-
	
	; poster_top
	ldy #00
@	
	lda $c000,y
	sta $0200,y
	iny
	bne @-

	; gun
	ldy #00
@
	lda $c100,y
	sta $0300,y
	iny
	cpy #$d8
	bne @-

	; poster_sides
	ldy #00
@
	lda $c200,y
	sta $ff40,y
	iny
	cpy #$90
	bne @-

	
	; colour set in A
	lda		#$00
	jsr 	c64clearcols
	
	jsr 	z80_init
			
			
	jmp 	PlayGame	
	
		;sei
		;cld
		;ldx #$ff
		;txs
		
		;jsr z80_init
		;jsr spectrum_init
		;jsr HostInit
		;jmp PlayGame
		
		;icl 'z80.asm'
		;icl 'gunfright_atari.asm'
		;org $1c00
		;icl 'gunfright_6502.asm'
		
		;run		main		

		
		;icl 'atari.hea'

		;org $0800

;c128_check
;        lda $d030
;        cmp #$ff
;        beq c64
;        bne done_c128
;c128:
;        lda #$ff
;        sta $d030
;done_c128:
;        lda #$01
;		sta C128_MODE_ON
;        rts
;
;c64:
;        lda #$fc
;        sta $d030
;        eor $d030
;        beq c128
;done_c64:
;        lda #$00
;		sta C128_MODE_ON
;        rts 		



raster_irq

		; set-up stuff
		STA $FF3F	; enable all RAM

		;lda #$ff
		;sta $ff00
		;sta $ff01
	
		;turn on bitmap screen in 24 row mode
		lda #% 00100111
		ora $ff06
		sta $ff06
	
		;get gfx from ram (zero in bit 2) & set bitmap to $c000
		;lda #% 11110011 
		;and $ff12
		;sta $ff12 	
		lda #% 00110000 
		sta $ff12 	
	
		;256 char mode (one in bit 7)
		;lda #% 10000000
		;ora $ff07
		;sta $ff07
	
		;char mem poss ($C000)
		;lda #% 11000000
		;sta $ff13	
	
		;bit col & luma poss  ($b800, $bc00)
		lda #% 10111000
		;ora $ff14
		sta $ff14	

		lda #$00     		
		sta frame_counter	
	
		; irq set-up
		sei

		lda #02
		;lda #10
		sta $ff0a
	
		LDA #204
		STA $FF0B	; --- raster line	
	
		lda #<irq_01  	;this is how we set up
		sta $fffe  		;the address of our interrupt code
		lda #>irq_01
		sta $ffff
	
		;inc $FF09	; clear interrupt bit
	
		cli

		rts		

irq_01

        sta atemp1+1
        stx xtemp1+1
        sty ytemp1+1

		inc $FF09	; clear interrupt bit
		
		;do stuff...
  					
		inc frame_counter

	.if TED_SOUND == 1
		
		jsr ted_player
	
	.else
		
		lda sound_e
		beq @+

		;lda #02
		;sta border
		jsr sound_player_e
		;lda #00
		;sta border		
		
		jmp skip_music_player
				
@		
			
		lda sound_off
		bne skip_music_player
		
		;lda #03
		;sta border		
		jsr sid_player
		;lda #00
		;sta border
		
skip_music_player

	.endif
			
		
		; branch to next irq
		lda #<irq_01
		sta $fffe  		
		lda #>irq_01
		sta $ffff
		
		LDA #204
		STA $FF0B	; --- raster line	
		

atemp1 	lda #$00
xtemp1 	ldx #$00
ytemp1 	ldy #$00
	
		rti

	
;raster_irq
;
;		sei       		 	;disable maskable IRQs
;
;		lda #$7f
;		sta $dc0d  			;disable timer interrupts 
;		sta $dd0d  	
;		
;		lda $dc0d  			;by reading this two registers we negate any pending CIA irqs.
;		lda $dd0d  	
;					
;		lda #$01   			;tell the VICII to generate a raster interrupt
;		sta $d01a
;			
;		lda #$00     
;		sta frame_counter
;		
;		lda #$35   			;turn off the BASIC and KERNAL rom here
;		sta $01    	
;
;		lda C128_MODE_ON
;		bne c128_raster
;		
;		lda #$f6 			;this is how to tell at which rasterline we want the irq to be triggered
;		sta $d012		
;
;		lda #<irq_01  		;this is how we set up
;		sta $fffe  			;the address of our interrupt code
;		lda #>irq_01
;		sta $ffff
;		
;		jmp c128_skip_raster
;
;c128_raster
;
;		lda #$36 			;this is how to tell at which rasterline we want the irq to be triggered
;		sta $d012		
;
;		lda #<irq_01_128  	;this is how we set up
;		sta $fffe  			;the address of our interrupt code
;		lda #>irq_01_128
;		sta $ffff
;
;c128_skip_raster
;		
;		lda #<irq_brk_01
;        sta $fffa   
;        lda #>irq_brk_01
;        sta $fffb  
;		
;		lda #$ff			; ack irq
;		sta $d019
;		
;		cli        			;enable maskable interrupts again
;		
;		rts
;
;irq_01
;
;        sta atemp1+1
;        stx xtemp1+1
;        sty ytemp1+1
;
;		;do stuff...
;
;		lda $01
;		sta c64_mem_buf
;		lda #$35
;		sta $01		
;  					
;		inc frame_counter
;
;		
;		; branch to next irq
;		lda #<irq_01
;		sta $fffe  		
;		lda #>irq_01
;		sta $ffff
;
;		;lda soundfx
;		;cmp #02
;		;beq irqsoundoff
;		
;		jsr sound_player
;
;;irqsoundoff
;		
;		lda #$f6 ; trig next raster irq
;		sta $d012
;					
;		lda #$ff	; ack irq
;		sta $d019
;			
;		lda c64_mem_buf
;		sta $01 
;			       	
;		
;atemp1 	lda #$00
;xtemp1 	ldx #$00
;ytemp1 	ldy #$00
;			
;irq_brk_01
;
;        rti		
;
;irq_01_128
;
;        sta atemp_128_1+1
;        stx xtemp_128_1+1
;        sty ytemp_128_1+1
;		
;		;do stuff...
;
;		lda $01
;		sta c64_mem_buf
;		lda #$35
;		sta $01 
;			
;
;		; switch on 1mhz mode for c128 for screen size only - 192 Y lines 
;		lda #00
;		sta $D030
;		
;		; branch to next irq
;		lda #<irq_02_128
;		sta $fffe  		
;		lda #>irq_02_128
;		sta $ffff
;		
;		lda #$f6
;		sta $d012
;			
;		lda #$ff	; ack irq
;		sta $d019
;
;		lda c64_mem_buf
;		sta $01	
;		
;		
;atemp_128_1 	lda #$00
;xtemp_128_1 	ldx #$00
;ytemp_128_1 	ldy #$00
;		
;		rti			
;
;irq_02_128		
;
;        sta atemp_128_2+1
;        stx xtemp_128_2+1
;        sty ytemp_128_2+1		
;				
;		lda $01
;		sta c64_mem_buf
;		lda #$35
;		sta $01 
;		
;		; switch on 2mhz mode for c128 in border area for extra 25% (PAL) speed per full frame.
;		; Smaller border area for NTSC machines means slightly less speedup for them.
;		lda #01
;		sta $D030		
;
;		inc frame_counter
;
;		
;		; branch back to first irq
;		lda #<irq_01_128
;		sta $fffe  		
;		lda #>irq_01_128
;		sta $ffff
;
;		;lda soundfx
;		;cmp #02
;		;beq irqsoundoff
;		
;		jsr sound_player
;
;;irqsoundoff		
;		
;		lda #$36 ;trig next raster bottom of screen
;		sta $d012
;		
;		lda #$ff	; ack irq
;		sta $d019		
;
;		lda c64_mem_buf
;		sta $01			
;		
;atemp_128_2 	lda #$00
;xtemp_128_2 	ldx #$00
;ytemp_128_2 	ldy #$00
;
;		rti

		
;.enum	@dmactl
;	blank	= %00
;	narrow	= %01
;	standard= %10
;	wide	= %11
;	missiles= %100
;	players	= %1000
;	lineX1	= %10000
;	lineX2	= %00000
;	dma	= %100000
;.ende

;scr48	= @dmactl(wide|dma|players|missiles|lineX1)		;screen 48b
;scr40	= @dmactl(standard|dma|players|missiles|lineX1)		;screen 40b
;scr32	= @dmactl(narrow|dma|players|missiles|lineX1)		;screen 32b

;.enum	@pmcntl
;	missiles= %1
;	players	= %10
;	trigs	= %100
;.ende

;.enum	@gtictl
;	prior0	= %0
;	prior1	= %1
;	prior2	= %10
;	prior4	= %100
;	prior8	= %1000
;	ply5	= %10000	; Fifth Player Enable
;	mlc	= %100000	; Multiple Color Player Enable
;	mode9	= %01000000
;	mode10	= %10000000
;	mode11	= %11000000
;.ende


;* ---------------------------------------------------------------------------------------------
;* ---	OS
;* ---------------------------------------------------------------------------------------------

;rtclok	= $12		; (3) zegar czasu rzeczywistego

;lmargin	= $52
;rmargin	= $53
;rowcrs	= $54		; wiersz  kursora
;colcrs	= $55		; (2) Kolumna kursora

;keydef	= $79		; (2) tablica konwersji kodów klawiatury na ATASCII

;setvbv	= $e45c
;xitvbv	= $e462
;ciov	= $e456		; Wektor do cio

;iocb	= $340		; IOCB
;iocom	= iocb+2	; Komenda dla IOCB
;ioadr	= iocb+4	; (2) Adres bufora   dla IOCB
;ioaux1	= iocb+10	; Bajt pomocniczy 1 IOCB
;ioaux2	= iocb+11	; Bajt pomocniczy 2 IOCB

;icchid	= $0340
;icdno	= $0341
;iccmd	= $0342
;icstat	= $0343
;icbufa	= $0344
;icputb	= $0346
;icbufl	= $0348
;icax1	= $034a
;icax2	= $034b
;icax3	= $034c
;icax4	= $034d
;icax5	= $034e
;icax6	= $034f

;colpf0s	= $02C4		; rejestr-cieñ COLPF0
;colpf1s	= $02C5		; rejestr-cieñ COLPF1
;colpf2s	= $02C6		; rejestr-cieñ COLPF2
;colpf3s	= $02C7		; rejestr-cieñ COLPF3
;colbaks	= $02C8		; rejestr-cieñ COLBAK

;crsinh	= $02f0		; znacznik widocznoœci kursora
;atachr	= $02fb		; numer koloru dla PLOT, DRAW
;kbcodes	= $02fc		; kod ostatnio naciœniêtego klawisza, $ff jeœli ¿aden nie zosta³ naciœniêty (KBCODE)
;fildat	= $02fd		; numer koloru dla FILL
;chart	= $02f3		; cieñ rejestru kontroli wyœwietlania znaków (CHRCTL)

;* ---------------------------------------------------------------------------------------------
;* ---	KEY ($d209)
;* ---------------------------------------------------------------------------------------------
;key_esc		= 28
;key_space	= 33
;key_v		= 16
;key_b		= 21
;key_n		= 35
;key_m		= 37

;* ---------------------------------------------------------------------------------------------
;* ---	GTIA
;* ---------------------------------------------------------------------------------------------

;hposp0	=	$D000		; pozioma pozycja gracza 0 (Z)
;hposp1	=	$D001		; pozioma pozycja gracza 1 (Z)
;hposp2	=	$D002		; pozioma pozycja gracza 2 (Z)
;hposp3	=	$D003		; pozioma pozycja gracza 3 (Z)
;hposm0	=	$D004		; pozioma pozycja pocisku 0 (Z)
;hposm1	=	$D005		; pozioma pozycja pocisku 1 (Z)
;hposm2	=	$D006		; pozioma pozycja pocisku 2 (Z)
;hposm3	=	$D007		; pozioma pozycja pocisku 3 (Z)
;sizep0	=	$D008		; poziomy rozmiar gracza 0 (Z)
;sizep1	=	$D009		; poziomy rozmiar gracza 1 (Z)
;sizep2	=	$D00A		; poziomy rozmiar gracza 2 (Z)
;sizep3	=	$D00B		; poziomy rozmiar gracza 3 (Z)
;sizem	=	$D00C		; poziomy rozmiar pocisków (Z)
;grafp0	=	$D00D		; rejestr grafiki gracza 0 (Z)
;grafp1	=	$D00E		; rejestr grafiki gracza 1 (Z)
;grafp2	=	$D00F		; rejestr grafiki gracza 2 (Z)
;grafp3	=	$D010		; rejestr grafiki gracza 3 (Z)
;grafm	=	$D011		; rejestr grafiki pocisków (Z)
;colpm0	=	$D012		; rejestr koloru gracza i pocisku 0 (Z)
;colpm1	=	$D013		; rejestr koloru gracza i pocisku 1 (Z)
;colpm2	=	$D014		; rejestr koloru gracza i pocisku 2 (Z)
;colpm3	=	$D015		; rejestr koloru gracza i pocisku 3 (Z)
;colpf0	=	$D016		; rejestr koloru pola gry 0 (Z)
;colpf1	=	$D017		; rejestr koloru pola gry 1 (Z)
;colpf2	=	$D018		; rejestr koloru pola gry 2 (Z)
;colpf3	=	$D019		; rejestr koloru pola gry 3 (Z)
;colbak	=	$D01A		; rejestr koloru t³a (Z)

;color0	=	colpf0
;color1	=	colpf1
;color2	=	colpf2
;color3	=	colpf3

;kolm0pf	=	$D000		; kolizja pocisku 0 z polem gry (O)
;kolm1pf	=	$D001		; kolizja pocisku 1 z polem gry (O)
;kolm2pf	=	$D002		; kolizja pocisku 2 z polem gry (O)
;kolm3pf	=	$D003		; kolizja pocisku 3 z polem gry (O)
;kolp0pf	=	$D004		; kolizja gracza 0 z polem gry (O)
;kolp1pf	=	$D005		; kolizja gracza 1 z polem gry (O)
;kolp2pf	=	$D006		; kolizja gracza 2 z polem gry (O)
;kolp3pf	=	$D007		; kolizja gracza 3 z polem gry (O)
;kolm0p	=	$D008		; kolizja pocisku 0 z graczem (O)
;kolm1p	=	$D009		; kolizja pocisku 1 z graczem (O)
;kolm2p	=	$D00A		; kolizja pocisku 2 z graczem (O)
;kolm3p	=	$D00B		; kolizja pocisku 3 z graczem (O)
;kolp0p	=	$D00C		; kolizja gracza 0 z innym graczem (O)
;kolp1p	=	$D00D		; kolizja gracza 1 z innym graczem (O)
;kolp2p	=	$D00E		; kolizja gracza 2 z innym graczem (O)
;kolp3p	=	$D00F		; kolizja gracza 3 z innym graczem (O)
;trig0	=	$D010		; stan przycisku joysticka 0 (O)
;trig1	=	$D011		; stan przycisku joysticka 1 (O)
;trig3	=	$D013		; znacznik do³¹czenia cartridge-a (O)
;pal	=	$D014		; znacznik systemu TV (O)

;gtictl	=	$D01B		; rejestr kontroli uk³adu GTIA
;gtiactl	=	gtictl

;vdelay	=	$D01C		; licznik opóŸnienia pionowego P/MG
;pmcntl	=	$D01D		; rejestr kontroli graczy i pocisków
;hitclr	=	$D01E		; rejestr kasowania rejestrów kolizji
;consol	=	$D01F		; rejestr stanu klawiszy konsoli

;* ---------------------------------------------------------------------------------------------
;* ---	POKEY
;* ---------------------------------------------------------------------------------------------

;irqens	=	$0010		; rejestr-cieñ IRQEN
;irqstat	=	$0011		; rejestr-cieñ IRQST

;audf1	=	$d200		; czêstotliwoœæ pracy generatora 1 (Z)
;audc1	=	$d201		; rejestr kontroli dŸwiêku generatora 1 (Z)
;audf2	=	$d202		; czêstotliwoœæ pracy generatora 2 (Z)
;audc2	=	$d203		; rejestr kontroli dŸwiêku generatora 2 (Z)
;audf3	=	$d204		; czêstotliwoœæ pracy generatora 3 (Z)
;audc3	=	$d205		; rejestr kontroli dŸwiêku generatora 3 (Z)
;audf4	=	$d206		; czêstotliwoœæ pracy generatora 4 (Z)
;audc4	=	$d207		; rejestr kontroli dŸwiêku generatora 4 (Z)

;audctl	=	$D208		; rejestr kontroli generatorów dŸwiêku (Z)
;stimer	=	$D209		; rejestr zerowania liczników (Z)
;kbcode	=	$D209		; kod ostatnio naciœniêtego klawisza (O)
;skstres	=	$D20A		; rejestr statusu z³¹cza szeregowego (Z)
;random	=	$D20A		; rejestr liczby losowej (O)
;serout	=	$D20D		; szeregowy rejestr wyjœciowy (Z)
;serin	=	$D20D		; szeregowy rejestr wejœciowy (O)
;irqen	=	$D20E		; zezwolenie przerwañ IRQ (Z)
;irqst	=	$D20E		; status przerwañ IRQ (O)
;skctl	=	$D20F		; rejestr kontroli z³¹cza szeregowego (Z)
;skstat	=	$D20F		; rejestr statusu z³¹cza szeregowego (O)

;* ---------------------------------------------------------------------------------------------
;* ---	PIA
;* ---------------------------------------------------------------------------------------------

;porta	=	$D300		; port A uk³adu PIA
;portb	=	$D301		; port B uk³adu PIA
;pactl	=	$D302		; rejestr kontroli portu A
;pbctl	=	$D303		; rejestr kontroli portu B

;* ---------------------------------------------------------------------------------------------
;* ---	ANTIC
;* ---------------------------------------------------------------------------------------------

;dmactl	=	$D400		; rejestr kontroli dostêpu do pamiêci
;chrctl	=	$D401		; rejestr kontroli wyœwietlania znaków
;dlptr	=	$D402		; adres programu ANTIC-a
;hscrol	=	$D404		; znacznik poziomego przesuwu obrazu
;vscrol	=	$D405		; znacznik pionowego przesuwu obrazu
;pmbase	=	$D407		; adres pamiêci graczy i pocisków
;chbase	=	$D409		; adres zestawu znaków
;wsync	=	$D40A		; znacznik oczekiwania na synchronizacjê poziom¹
;vcount	=	$D40B		; licznik linii obrazu
;lpenh	=	$D40C		; poziome po³o¿enie pióra œwietlengo
;lpenv	=	$D40D		; pionowe po³o¿enie pióra œwietlnego
;nmien	=	$D40E		; rejestr zezwoleñ na przerwania NMI
;nmist	=	$D40F		; rejestr statusu przerwañ NMI

;* ---------------------------------------------------------------------------------------------
;* ---	HARDWARE
;* ---------------------------------------------------------------------------------------------

;nmivec	=	$FFFA		; wektor przerwania NMI
;resetvec=	$FFFC		; wektor przerwania RESET
;irqvec	=	$FFFE		; wektor przerwania IRQ

		;icl 'spectrum_atari.asm'

;frame_counter	equ $1f


		
;out_fe	
;		lsr @
;		;sta consol ; Buzzer
;		rts
		
;out_fd
;		sta readkb+1
;		rts
;in_a_fe
;		;lda #$ff
;readkb	lda $d100
;		rts


;out_fd	eor #$ff
;		;sta keys_rows
;		rts
		
;in_a_fe	
		;lda #$ff
		;sta key_result
		;lda skstat
		;and #$04
		;bne nokey
		;stx rk_save_x+1
		;sty rk_save_y+1
		;lda kbcode
		;bmi key_exit
		;tay
		;and #$3f
		;tax
		;lda atari_spectrum_keys,x
		;and #$07
		;tax
		;lda _bitmem0,x
		;and keys_rows
		;beq key_exit
		;tya
		;and #$3f
		;tax
		;lda atari_spectrum_keys,x
		;lsr @
		;lsr @
		;lsr @
		;lsr @
		;tax
		;lda _bitmem0,x
		;eor #$ff
		;sta key_result
;key_exit
;rk_save_x
;		;ldx #$00
;rk_save_y
;		;ldy #$00
;nokey	
;		;lda key_result
;		rts

		
;keys_rows 	dta $00
;key_result	dta $00
		
;atari_spectrum_keys
; spectrum keyboard matrix
;  Bit    Col0  Col1  Col2  Col3  Col4  
;  Row0   CS    "Z"   "X"   "C"   "V"   ; 0xFEFE
;  Row1   "A"   "S"   "D"   "F"   "G"   ; 0xFDFE
;  Row2   "Q"   "W"   "E"   "R"   "T"   ; 0xFBFE
;  Row3   "1"   "2"   "3"   "4"   "5"	; 0xF7FE   
;  Row4   "0"   "9"   "8"   "7"   "6"   ; 0xEFFE
;  Row5   "P"   "O"   "I"   "U"   "Y"	; 0xDFFE   
;  Row6   ENTER "L"   "K"   "J"   "H"   ; 0xBFFE
;  Row7   SPACE SS    "M"   "N"   "B"   ; 0x7FFE
;		dta $16	; L $00
;		dta $36	; J $01
;		dta $ff	; ;: $02
;		dta $ff	; F1 $03
;		dta $ff	; F2 $04
;		dta $26	; K $05
;		dta $ff	; +\ $06
;		dta $ff	; *^ $07
;		dta $15	; O $08
;		dta $ff	;   $09
;		dta $05	; P $0A
;		dta $35	; U $0B
;		dta $06	; RETURN $0C
;		dta $25	; I $0D
;		dta $ff	; -_ $0E
;		dta $ff	; =| $0F
;		dta $40	; $10 V
;		dta $ff	; $11 HELP
;		dta $30	; $12 C
;		dta $ff	; $13 F3
;		dta $ff	; $14 F4
;		dta $47	; $15 B
;		dta $20 ; $16 X
;		dta $10 ; $17 Z
;		dta $33	; $18 4$
;		dta $ff ; $19
;		dta $23	; $1a 3#
;		dta $44	; $1b 6&
;		dta $ff ; $1c ESC
;		dta $43	; $1d 5%
;		dta $13 ; $1e 2"
;		dta $03 ; $1f 1!
;		dta $ff ; $20 ,[
;		dta $07 ; $21 SPACE
;		dta $ff	; $22 .]
;		dta $37	; $23 N
;		dta $ff	; $24
;		dta $27	; $25 M
;		dta $ff	; $26 /?
;		dta $ff ; $27 LOGO (RSHIFT)
;		dta $32	; $28 R
;		dta $ff	; $29
;		dta $22	; $2a E
;		dta $45 ; $2b Y
;		dta $ff	; $2c TAB
;		dta $42	; $2d T
;		dta $12	; $2e W
;		dta $02	; $2f Q
;		dta $14	; $30 9(
;		dta $ff ; $31
;		dta $04 ; $32 0)
;		dta $34 ; $33 7'
;		dta $ff	; $34 BACKSPACE/DEL
;		dta $24 ; $35 8@
;		dta $ff ; $36 <CLEAR
;		dta $ff ; $37 >INS
;		dta $31 ; $38 F
;		dta $46 ; $39 H
;		dta $21 ; $3a D
;		dta $ff ; $3b
;		dta $ff ; $3c CAPS
;		dta $41	; $3d G
;		dta $11	; $3e S
;		dta $01 ; $3f A
		
;in_a_1f
;		lda #$00	; kempston is active high FUDLR
;		rts
;in_a_1f
;		lda trig0
;		lsr @
;		lda porta	; RLDU active low
;		and #$0f
;		tax
;		lda joystick_table,x
;		scs:ora #$10
;		rts
		
;joystick_table
;		dta %1111; 0000
;		dta %0111; 0001
;		dta %1011; 0010
;		dta %0011; 0011
;		dta %1101; 0100
;		dta %0101; 0101
;		dta %1001; 0110
;		dta %0001; 0111
;		dta %1110; 1000
;		dta %0110; 1001
;		dta %1010; 1010
;		dta %0010; 1011
;		dta %1100; 1100
;		dta %0100; 1101
;		dta %1000; 1110
;		dta %0000; 1111

		
ld_a_r	.macro
		;lda $d20a ; POKEY random number - emulate R register
		;lda $d012
		lda $ff1d
		.endm
	
; colors
;Spectrum color 0: (00,00,00) = Atari color 00 (00,00,00), distance = 0.000000
;Spectrum color 1: (00,00,bf) = Atari color 82 (05,1d,8e), distance = 57.157677
;Spectrum color 2: (bf,00,00) = Atari color 34 (82,2a,0f), distance = 75.564545
;Spectrum color 3: (bf,00,bf) = Atari color 56 (98,3f,92), distance = 86.689102
;Spectrum color 4: (00,bf,00) = Atari color c5 (26,7c,22), distance = 84.196198
;Spectrum color 5: (00,bf,bf) = Atari color a7 (38,93,a6), distance = 75.478477
;Spectrum color 6: (bf,bf,00) = Atari color 19 (b3,a0,2b), distance = 54.350712
;Spectrum color 7: (bf,bf,bf) = Atari color 0b (bb,bb,bb), distance = 6.928203
;Spectrum color 8: (00,00,00) = Atari color 00 (00,00,00), distance = 0.000000
;Spectrum color 9: (00,00,ff) = Atari color 84 (27,3f,b0), distance = 108.309738
;Spectrum color 10: (ff,00,00) = Atari color 35 (93,3b,20), distance = 127.157379
;Spectrum color 11: (ff,00,ff) = Atari color 59 (cb,72,c5), distance = 138.072449
;Spectrum color 12: (00,ff,00) = Atari color c6 (37,8d,33), distance = 136.462448
;Spectrum color 13: (00,ff,ff) = Atari color aa (6b,c6,d9), distance = 127.051170
;Spectrum color 14: (ff,ff,00) = Atari color 1c (e6,d3,5e), distance = 106.756729
;Spectrum color 15: (ff,ff,ff) = Atari color 0f (ff,ff,ff), distance = 0.000000

;spectrum_color
		; 0 - black
		; 1 - blue
		; 2 - red
		; 3 - violet
		; 4 - green
		; 5 -
		; 6 - yellow
		; 7 - white
;		.he 00,84,36,46,c4,a4,e4,0a
;		.he 00,88,3a,4e,ca,aa,ee,0e
		;.he 00,8a,3a,4a,ca,aa,ea,0a
		;.he 00,8a,3a,4a,ca,aa,ee,0a
		
;spectrum_init

		; init ANTIC + interrupts
;		sei
;		lda #0
;		sta nmien	; disable interrupts
;		sta irqen
;		sta dmactl	; disable screen
;		sta frame_counter
;		lda #%11111110
;		sta portb

;		lda #<nmi
;		sta $fffa
;		lda #>nmi
;		sta $fffb
;		lda #<irq
;		sta $fffe
;		lda #>irq
;		sta $ffff
		
		; set screen
;		lda #<dlist
;		sta dlptr
;		lda #>dlist
;		sta dlptr+1
;		lda #%00100001
;		sta dmactl

;		lda #$40
;		sta nmien

		; init POKEY
;		ldx #$08
;		lda #$00
;		sta skctl
;clear	sta $d200,x
;		dex
;		bpl clear
;		lda #$03
;		sta skctl
		; init GTIA
;		ldx #$0f
;		lda #$00
;cleargtia	sta $d000,x
;		dex
;		bpl cleargtia
		; colors
;		lda #$00
;		sta colbak
;		sta colpf2
;		lda #$0e
;		sta colpf1
		
;		rts

;nmi		bit nmist
;		bmi dli
;		inc frame_counter
;		jsr HostVBI
;irq
;		rti
		
;dli		jmp HostDLI


		;icl 'z80.asm'

; spectrum stuff
; adresses
z80_regs equ $00

z80_f	equ $cc		;moved from $00 for C64
z80_a	equ $cd		;moved from $01 for C64

z80_af	equ z80_f
z80_c	equ $02
z80_b	equ $03
z80_bc	equ z80_c
z80_e	equ $04
z80_d	equ $05
z80_de	equ z80_e
z80_l	equ $06
z80_h	equ $07
z80_hl	equ z80_l
z80_ix	equ $08
z80_iy	equ $0a
z80_fp	equ $0c
z80_ap	equ $0d
z80_cp	equ $0e
z80_bp	equ $0f
z80_bcp	equ z80_cp
z80_ep	equ $10
z80_dp	equ $11
z80_dep	equ z80_ep
z80_lp	equ $12
z80_hp	equ $13
z80_hlp	equ z80_lp
z80_sp  equ $14
z80_reg0 equ $16
z80_reg1 equ $17
z80_reg2 equ $18
z80_reg3 equ $19
z80_reg4 equ $1a
z80_reg5 equ $1b
z80_reg6 equ $1c
z80_reg7 equ $1d

z80_free_zp	equ $20
	
_bitmem0	equ $f8
_bitmem1	equ $f9
_bitmem2	equ $fa
_bitmem3	equ $fb
_bitmem4	equ $fc
_bitmem5	equ $fd
_bitmem6	equ $fe
_bitmem7	equ $ff
	
; constants	
_bitvalue0	equ $01	
_bitvalue1	equ $02	
_bitvalue2	equ $04	
_bitvalue3	equ $08	
_bitvalue4	equ $10	
_bitvalue5	equ $20	
_bitvalue6	equ $40	
_bitvalue7	equ $80	

_notbitvalue0	equ $fe	
_notbitvalue1	equ $fd	
_notbitvalue2	equ $fb	
_notbitvalue3	equ $f7	
_notbitvalue4	equ $ef	
_notbitvalue5	equ $df	
_notbitvalue6	equ $bf	
_notbitvalue7	equ $7f	


add_hl_bc
		lda z80_l
		clc
		adc z80_c
		sta z80_l
		lda z80_h
		adc z80_b
		sta z80_h
		rts

add_hl_sp
		lda z80_l
		clc
		adc z80_sp
		sta z80_l
		lda z80_h
		adc z80_sp+1
		sta z80_h
		rts
		
add_ix_de
		lda z80_ix
		clc
		adc z80_e
		sta z80_ix
		lda z80_ix+1
		adc z80_d
		sta z80_ix+1
		rts
		
add_ix_bc
		lda z80_ix
		clc
		adc z80_c
		sta z80_ix
		lda z80_ix+1
		adc z80_b
		sta z80_ix+1
		rts
				
add_iy_de
		lda z80_iy
		clc
		adc z80_e
		sta z80_iy
		lda z80_iy+1
		adc z80_d
		sta z80_iy+1
		rts
		
add_hl_de
		lda z80_l
		clc
		adc z80_e
		sta z80_l
		lda z80_h
		adc z80_d
		sta z80_h
		rts

add_iy_bc
		lda z80_iy
		clc
		adc z80_c
		sta z80_iy
		lda z80_iy+1
		adc z80_b
		sta z80_iy+1
		rts
		
sbc_hl_de
		lda z80_l
		sbc z80_e
		sta z80_l
		lda z80_h
		sbc z80_d
		sta z80_h
		rts

sbc_hl_bc
		lda z80_l
		sbc z80_c
		sta z80_l
		lda z80_h
		sbc z80_b
		sta z80_h
		rts

cmp_hl_bc
		lda z80_l
		cmp z80_c
		bne cmp_hl_bc_end
		lda z80_h
		cmp z80_b
cmp_hl_bc_end
		rts
		
cmp_iy_ix
		lda z80_iy
		cmp z80_ix
		bne cmp_iy_ix_end
		lda z80_iy+1
		cmp z80_ix+1
cmp_iy_ix_end
		rts
		
dec_hl
		lda z80_l
		bne dec_hl_no_dec_h
		dec z80_h
dec_hl_no_dec_h
		dec z80_l
		rts
	
dec_ix
		lda z80_ix
		bne dec_ix_no_dec_h
		dec z80_ix+1
dec_ix_no_dec_h
		dec z80_ix
		rts
		
dec_bc	
		lda z80_c
		bne dec_bc_no_dec_b
		dec z80_b
dec_bc_no_dec_b
		dec z80_c
		rts
	
dec_de
		lda z80_e
		bne dec_de_no_dec_d
		dec z80_d
dec_de_no_dec_d
		dec z80_e
		rts
		
dec_sp
		lda z80_sp
		bne dec_sp_no_dec_sp_1
		dec z80_sp+1
dec_sp_no_dec_sp_1
		dec z80_sp
		rts

ex_de_hl
		lda z80_e
		ldx z80_l
		stx z80_e
		sta z80_l
		lda z80_d
		ldx z80_h
		stx z80_d
		sta z80_h
		rts

ld_hl_de
		lda z80_e
		sta z80_l
		lda z80_d
		sta z80_h
		rts
		
;exx
;		ldx #$00
;exx_loop		
;		lda z80_c,x
;		ldy z80_cp,x
;		sty z80_c,x
;		sta z80_cp,x
;		inx
;		cpx #$06
;		bne exx_loop
;		rts

exx		lda z80_c
		ldx z80_cp
		stx z80_c
		sta z80_cp
		lda z80_b
		ldx z80_bp
		stx z80_b
		sta z80_bp
		lda z80_e
		ldx z80_ep
		stx z80_e
		sta z80_ep
		lda z80_d
		ldx z80_dp
		stx z80_d
		sta z80_dp		
		lda z80_l
		ldx z80_lp
		stx z80_l
		sta z80_lp
		lda z80_h
		ldx z80_hp
		stx z80_h
		sta z80_hp
		rts
		
ex_sp_hl
		tsx
		lda $0103,x
		ldy z80_h
		sta z80_h
		tya
		sta $0103,x
		lda $0104,x
		ldy z80_l
		sta z80_l
		tya
		sta $104,x
		rts
		
ldir
		ldy #$00
		ldx z80_b
		beq ldir_last_page
ldir_loop		
		lda (z80_hl),y
		sta (z80_de),y
		iny
		bne ldir_loop
		inc z80_h
		inc z80_d
		dex
		bne ldir_loop
ldir_last_page
		lda z80_c
		beq ldir_end
ldir_last_page_loop		
		lda (z80_hl),y
		sta (z80_de),y
		iny
		cpy z80_c
		bne ldir_last_page_loop
ldir_end		
		stx z80_c
		stx z80_b
		tya
		clc
		adc z80_l
		sta z80_l
		bcc *+4
		inc z80_h
		tya
		clc
		adc z80_e
		sta z80_e
		bcc *+4
		inc z80_d
		rts
		
lddr	ldy #$00
lddr_loop
		lda (z80_hl),y
		sta (z80_de),y
		jsr dec_hl
		jsr dec_de
		jsr dec_bc
		lda z80_b
		ora z80_c
		bne lddr_loop
		rts
ei
		rts
di
		rts
		
ccf		bcc ccf_setc
		clc
		rts
ccf_setc
		sec
		rts
		
ld_de_hl
		lda z80_l
		sta z80_e
		lda z80_h
		sta z80_d
		rts
		
z80_init
		ldx #$00
		lda #$01
z80_init_loop		
		sta _bitmem0,x
		inx
		asl @
		bne z80_init_loop
		rts		
		
		;icl 'gunfright_atari.asm'	

; Atari specific Gunfright routines

;HostVBI	rts
;HostDLI 	rti

		;icl 'gunfright_6502.asm'

L0000 equ $0000
L0003 equ $0003
L0004 equ $0004
L0005 equ $0005
L0008 equ $0008
L0010 equ $0010
L0012 equ $0012
L0014 equ $0014
L0015 equ $0015
L0016 equ $0016
L0017 equ $0017
L001E equ $001E
L0020 equ $0020
L002D equ $002D
L0030 equ $0030
L0040 equ $0040
L0050 equ $0050
L00CF equ $00CF
L00F0 equ $00F0
L0100 equ $0100
L0114 equ $0114
L012F equ $012F
L0164 equ $0164
L01B0 equ $01B0
L0200 equ $0200
L0201 equ $0201
L0202 equ $0202
L0203 equ $0203
L0280 equ $0280
L0300 equ $0300
L040A equ $040A
L0705 equ $0705
L0800 equ $0800
L0801 equ $0801
L0808 equ $0808
L1800 equ $1800
L1909 equ $1909
L190D equ $190D
L1A0F equ $1A0F
L4000 equ spectrum_screen+$0020
L4004 equ spectrum_screen+$0004
;L4006 equ spectrum_screen+$0006
L4006 equ spectrum_screen+$0038
L401B equ spectrum_screen+$001b
L4024 equ spectrum_screen+$0024
L403B equ spectrum_screen+$003b

;L4062 equ spectrum_screen+$0062
L4062 equ $c3f0

BDRHO equ $c048+$20
BDRLO equ $d308+$20
BDRLE equ $c180+$20
BDRRI equ $c238+$20
BDRC1 equ $c040+$20
BDRC2 equ $c0f8+$20
BDRC3 equ $d300+$20
BDRC4 equ $d3b8+$20

BDRHOB equ $c048
BDRLOB equ $d308
BDRLEB equ $c180
BDRRIB equ $c238
BDRC1B equ $c040
BDRC2B equ $c0f8
BDRC3B equ $d300
BDRC4B equ $d3b8

SDRHO equ $D488+$20
SDRLO equ $DD48+$20
SDRLE equ $D5C0+$20
SDRRI equ $D638+$20
SDRC1 equ $D480+$20
SDRC2 equ $D4F8+$20
SDRC3 equ $DD40+$20
SDRC4 equ $DDB8+$20

SDRHOB equ $D488
SDRLOB equ $DD48
SDRLEB equ $D5C0
SDRRIB equ $D638
SDRC1B equ $D480
SDRC2B equ $D4F8
SDRC3B equ $DD40
SDRC4B equ $DDB8

GUNR  equ $D280
GUNL  equ $D1B8

BARR1 equ $d440+$20
BARR2 equ $d478+$20
BARR3 equ $d440
BARR4 equ $d478

TELET equ $DD60+$20
TELETB equ $DD60

DOLL  equ $dba0
DOLLB  equ $D860


L4083 equ spectrum_screen+$0083
L4087 equ spectrum_screen+$0087
L40A3 equ spectrum_screen+$00a3
;L40C7 equ spectrum_screen+$00c7
L40C7 equ $c7d8

L40E8 equ spectrum_screen+$00e8
L40EB equ spectrum_screen+$00EB
;L430B equ $430B
L4826 equ spectrum_screen+$0826

;L4842 equ spectrum_screen+$0842
L4842 equ $ccb0

L4846 equ spectrum_screen+$0846
L4868 equ spectrum_screen+$0868
L4882 equ spectrum_screen+$0882
;L48A7 equ spectrum_screen+$08A7
L48A7 equ $d098

L48A8 equ spectrum_screen+$08A8
L48C3 equ spectrum_screen+$08C3
L48DC equ spectrum_screen+$08DC
L48E4 equ spectrum_screen+$08E4
L48FB equ spectrum_screen+$08FB
L4F42 equ spectrum_screen+$0F42
L4FDB equ spectrum_screen+$0FDB
L5004 equ spectrum_screen+$1004
L500C equ spectrum_screen+$100C

;L5022 equ spectrum_screen+$1022
L5022 equ $d570

L502C equ spectrum_screen+$102C
L502D equ spectrum_screen+$102D
L502E equ spectrum_screen+$102E
L503B equ spectrum_screen+$103B
L5040 equ spectrum_screen+$1040
L5048 equ spectrum_screen+$1048
L504D equ spectrum_screen+$104D
L506D equ spectrum_screen+$106D
L5070 equ spectrum_screen+$1070
L5072 equ spectrum_screen+$1072
;L5087 equ spectrum_screen+$1087
L5087 equ $d958

L50A0 equ spectrum_screen+$10A0
L50AD equ spectrum_screen+$10AD
L50C0 equ spectrum_screen+$10C0
L50C2 equ spectrum_screen+$10C2

;L50CD equ spectrum_screen+$10CD
L50CD equ $dc28
;L50EA equ spectrum_screen+$10EA
L50EA equ $dd30

L50EC equ spectrum_screen+$10EC
L50F0 equ spectrum_screen+$10F0
L50F8 equ spectrum_screen+$10F8

;L5800 equ spectrum_attr
;L5809 equ spectrum_attr+$0009
;L580A equ spectrum_attr+$000A
;L581F equ spectrum_attr+$001F

; barrel and bullet colours
L5A27 equ screen_mem+$02b7-4
L5A45 equ screen_mem+$02dd-4
L5A49 equ screen_mem+$02e1-4
L5A85 equ screen_mem+$032d-4
L5A89 equ screen_mem+$0331-4
L5AA7 equ screen_mem+$0357-4

;L5A27 equ spectrum_attr+$0227
;L5A45 equ spectrum_attr+$0245
;L5A49 equ spectrum_attr+$0249
;L5A85 equ spectrum_attr+$0285
;L5A89 equ spectrum_attr+$0289
;L5AA7 equ spectrum_attr+$02A7


;L5C79 equ $5C79
;LBE7C equ $BE7C
LBFCD equ $BFCD
;LC171 equ $C171 ; return address dropped on stack
;LC5AB equ $C5AB
;LC5AF equ $C5AF
;LC63F equ $C63F
;LC64D equ $C64D
;LC666 equ $C666
;LC675 equ $C675
LD022 equ ScreenBuffer-$6c2 ; $D022 ; seems to be base address used to calculate off-screen buffer address?
LD6FB equ ScreenBuffer+$0018-1 ; last byte of first row of off-screen buffer
LE001 equ $E001 ; unknown, counter?
LE164 equ ScreenBuffer+$0a80-1 ; last byte of off-screen buffer of size $a80
LF900 equ MirrorTable
LFEFD equ $FEFD
LFF16 equ $FF16
LFF88 equ $FF88
LFFF0 equ $FFF0
LFFF8 equ $FFF8

sprite_mask_ptr	= z80_reg6 ; 2 bytes
SPRITE_PARAMS_SIZE = 3

;Rom_page_zero
;		ins 'rom_page_0.bin'

;L5CB0   JP (HL)

L5CB0
   
		jmp (z80_hl) ; JP (HL)

;5CB1    DB 00,57,FF,FF,FF,F4,09,A8
;5CB9    DB 10,4B,F4,09,C4,15,53,81 ; .K....S.
;5CC1    DB 0F,C4,15,52,F4,09,C4,15
;5CC9    DB 50,80,00,0A,F4,00,E7,30 ; P......0
;5CD1    DB 0E,00,00,00,00,00,3A,DA
;5CD9    DB 30,0E,00,00,00,00,00,3A ; 0......:
;5CE1    DB D9,30,0E,00,00,00,00,00
;5CE9    DB 3A,FB,3A,F5,AC,31,38,0E ; :.:..18.
;5CF1    DB 00,00,12,00,00,2C,30,0E ; .....,0.
;5CF9    DB 00,00,00,00,00,3A,EF,22 ; .....:."
;5D01    DB 22,AF,3A,F5,AC,31,38,0E ; ".:..18.
;5D09    DB 00,00,12,00,00,2C,30,0E ; .....,0.
;5D11    DB 00,00,00,00,00,3A,EF,22 ; .....:."
;5D19    DB 22,AF,3A,F2,34,30,0E,00 ; ".:.40..
;5D21    DB 00,28,00,00,3A,F5,AC,31 ; .(..:..1
;5D29    DB 38,0E,00,00,12,00,00,2C ; 8......,
;5D31    DB 30,0E,00,00,00,00,00,3A ; 0......:
;5D39    DB EF,22,22,AF,3A,F5,C0,32 ; ."".:..2
;5D41    DB 34,30,36,34,0E,00,00,00 ; 4064....
;5D49    DB 5E,00,3A,F5,AC,31,38,0E ; ^.:..18.
;5D51    DB 00,00,12,00,00,2C,30,0E ; .....,0.
;5D59    DB 00,00,00,00,00,3A,EF,22 ; .....:."
;5D61    DB 22,AF,3A,F5,AC,31,38,0E ; ".:..18.
;5D69    DB 00,00,12,00,00,2C,30,0E ; .....,0.
;5D71    DB 00,00,00,00,00,3A,EF,22 ; .....:."
;5D79    DB 22,AF,3A,F5,AC,31,38,0E ; ".:..18.
;5D81    DB 00,00,12,00,00,2C,30,0E ; .....,0.
;5D89    DB 00,00,00,00,00,3A,EF,22 ; .....:."
;5D91    DB 22,AF,3A,F5,AC,31,38,0E ; ".:..18.
;5D99    DB 00,00,12,00,00,2C,30,0E ; .....,0.
;5DA1    DB 00,00,00,00,00,3A,EF,22 ; .....:."
;5DA9    DB 22,AF,3A,F2,30,0E,00,00 ; ".:.0...
;5DB1    DB 00,00,00,3A,F5,C0,32,33 ; ...:..23
;5DB9    DB 34,32,34,0E,00,00,80,5B ; 424....[
;5DC1    DB 00,0D,80,EF,22,22,0D,80 ; ....""..
;5DC9    DB 00,00,80,5B,00,20,20,20 ; ...[.   
;5DD1    DB 20,20,20,00,00,00,00,00 ;    .....
;5DD9    DB 00,03,33,20,20,20,20,20 ; ..3     
;5DE1    DB 20,20,20,20,02,00,78,5C ;     ...\
;5DE9    DB 00,80,00,00,00,00,00,00
;5DF1    DB 00,00,00,00,00,00,00,00
;5DF9    DB 00,00,00,00,00,00,00

;        .he 00,57,FF,FF,FF,F4,09,A8 ; DB 00,57,FF,FF,FF,F4,09,A8
;        .he 10,4B,F4,09,C4,15,53,81 ; DB 10,4B,F4,09,C4,15,53,81
;        .he 0F,C4,15,52,F4,09,C4,15 ; DB 0F,C4,15,52,F4,09,C4,15
;        .he 50,80,00,0A,F4,00,E7,30 ; DB 50,80,00,0A,F4,00,E7,30
;        .he 0E,00,00,00,00,00,3A,DA ; DB 0E,00,00,00,00,00,3A,DA
;        .he 30,0E,00,00,00,00,00,3A ; DB 30,0E,00,00,00,00,00,3A
;        .he D9,30,0E,00,00,00,00,00 ; DB D9,30,0E,00,00,00,00,00
;        .he 3A,FB,3A,F5,AC,31,38,0E ; DB 3A,FB,3A,F5,AC,31,38,0E
;        .he 00,00,12,00,00,2C,30,0E ; DB 00,00,12,00,00,2C,30,0E
;        .he 00,00,00,00,00,3A,EF,22 ; DB 00,00,00,00,00,3A,EF,22
;        .he 22,AF,3A,F5,AC,31,38,0E ; DB 22,AF,3A,F5,AC,31,38,0E
;        .he 00,00,12,00,00,2C,30,0E ; DB 00,00,12,00,00,2C,30,0E
;        .he 00,00,00,00,00,3A,EF,22 ; DB 00,00,00,00,00,3A,EF,22
;        .he 22,AF,3A,F2,34,30,0E,00 ; DB 22,AF,3A,F2,34,30,0E,00
;        .he 00,28,00,00,3A,F5,AC,31 ; DB 00,28,00,00,3A,F5,AC,31
;        .he 38,0E,00,00,12,00,00,2C ; DB 38,0E,00,00,12,00,00,2C
;        .he 30,0E,00,00,00,00,00,3A ; DB 30,0E,00,00,00,00,00,3A
;        .he EF,22,22,AF,3A,F5,C0,32 ; DB EF,22,22,AF,3A,F5,C0,32
;        .he 34,30,36,34,0E,00,00,00 ; DB 34,30,36,34,0E,00,00,00
;        .he 5E,00,3A,F5,AC,31,38,0E ; DB 5E,00,3A,F5,AC,31,38,0E
;        .he 00,00,12,00,00,2C,30,0E ; DB 00,00,12,00,00,2C,30,0E
;        .he 00,00,00,00,00,3A,EF,22 ; DB 00,00,00,00,00,3A,EF,22
;        .he 22,AF,3A,F5,AC,31,38,0E ; DB 22,AF,3A,F5,AC,31,38,0E
;        .he 00,00,12,00,00,2C,30,0E ; DB 00,00,12,00,00,2C,30,0E
;        .he 00,00,00,00,00,3A,EF,22 ; DB 00,00,00,00,00,3A,EF,22
;        .he 22,AF,3A,F5,AC,31,38,0E ; DB 22,AF,3A,F5,AC,31,38,0E
;        .he 00,00,12,00,00,2C,30,0E ; DB 00,00,12,00,00,2C,30,0E
;        .he 00,00,00,00,00,3A,EF,22 ; DB 00,00,00,00,00,3A,EF,22
;        .he 22,AF,3A,F5,AC,31,38,0E ; DB 22,AF,3A,F5,AC,31,38,0E
;        .he 00,00,12,00,00,2C,30,0E ; DB 00,00,12,00,00,2C,30,0E
;        .he 00,00,00,00,00,3A,EF,22 ; DB 00,00,00,00,00,3A,EF,22
;        .he 22,AF,3A,F2,30,0E,00,00 ; DB 22,AF,3A,F2,30,0E,00,00
;        .he 00,00,00,3A,F5,C0,32,33 ; DB 00,00,00,3A,F5,C0,32,33
;        .he 34,32,34,0E,00,00,80,5B ; DB 34,32,34,0E,00,00,80,5B
;        .he 00,0D,80,EF,22,22,0D,80 ; DB 00,0D,80,EF,22,22,0D,80
;        .he 00,00,80,5B,00,20,20,20 ; DB 00,00,80,5B,00,20,20,20
;        .he 20,20,20,00,00,00,00,00 ; DB 20,20,20,00,00,00,00,00
;        .he 00,03,33,20,20,20,20,20 ; DB 00,03,33,20,20,20,20,20
;        .he 20,20,20,20,02,00,78,5C ; DB 20,20,20,20,02,00,78,5C
;        .he 00,80,00,00,00,00,00,00 ; DB 00,80,00,00,00,00,00,00
;        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
;        .he 00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00

;5E00    DI
;5E01    JP LA36B

PlayGame
        jsr di ; DI
        jmp LA36B ; JP LA36B

;L5E04   DB 1F,00,00,00,20,21,00,00 ; .... !..
;5E0C    DB 22,23,00,00,00,24,25,00 ; "#...$
;5E14    DB 00,26,27,28,00,29,2A,2B ; .&'(.)*+
;5E1C    DB 00,2C,2D,2E,2F,30,31,00 ; .,-./01.
;5E24    DB 32,33,34,00,35,36,00,00 ; 234.56..

L5E04   .he 1F,00,00,00,20,21,00,00 ; DB 1F,00,00,00,20,21,00,00
        .he 22,23,00,00,00,24,25,00 ; DB 22,23,00,00,00,24,25,00
        .he 00,26,27,28,00,29,2A,2B ; DB 00,26,27,28,00,29,2A,2B
        .he 00,2C,2D,2E,2F,30,31,00 ; DB 00,2C,2D,2E,2F,30,31,00
        .he 32,33,34,00,35,36,00,00 ; DB 32,33,34,00,35,36,00,00

;L5E2C   DB 00,02,03,00,00,00,00,00
;5E34    DB 00,00,00,00,00,00,00,00
;5E3C    DB 00,00,00,00,00,02,03,00
;5E44    DB 00,00,00,00,00,00,00,00
;5E4C    DB 00,00,02,03,04

L5E2C   .he 00,02,03,00,00,00,00,00 ; DB 00,02,03,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,02,03,00 ; DB 00,00,00,00,00,02,03,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,02,03,04 ; DB 00,00,02,03,04

;L5E51   DB 00,00,04,05,45,44,00,00 ; ....ED..
;5E59    DB 06,07,08,09,49,48,47,46 ; ....IHGF
;5E61    DB 0A,0B,0C,0D,4D,4C,4B,4A ; ....MLKJ
;5E69    DB 0E,0F,10,11,51,50,4F,4E ; ....QPON
;5E71    DB 8E,8F,90,91,D1,D0,CF,CE
;5E79    DB 8A,8B,8C,8D,CD,CC,CB,CA
;5E81    DB 86,87,88,89,C9,C8,C7,C6
;5E89    DB 00,00,84,85,C5,C4,00,00

;barel gfx data
;L5E51   .he 00,00,04,05,45,44,00,00 ; DB 00,00,04,05,45,44,00,00
;        .he 06,07,08,09,49,48,47,46 ; DB 06,07,08,09,49,48,47,46
;        .he 0A,0B,0C,0D,4D,4C,4B,4A ; DB 0A,0B,0C,0D,4D,4C,4B,4A
;        .he 0E,0F,10,11,51,50,4F,4E ; DB 0E,0F,10,11,51,50,4F,4E
;        .he 8E,8F,90,91,D1,D0,CF,CE ; DB 8E,8F,90,91,D1,D0,CF,CE
;        .he 8A,8B,8C,8D,CD,CC,CB,CA ; DB 8A,8B,8C,8D,CD,CC,CB,CA
;        .he 86,87,88,89,C9,C8,C7,C6 ; DB 86,87,88,89,C9,C8,C7,C6
;        .he 00,00,84,85,C5,C4,00,00 ; DB 00,00,84,85,C5,C4,00,00

;L5E91   DB 07,34,07,81,07,83,07,82
;5E99    DB 07,83,07,81,07,82,07,2A
;5EA1    DB 07,2D,17,31,17,32,17,33 ; .-.1.2.3
;5EA9    DB 17,2C,17,A8,17,B0,07,6D
;5EB1    DB 07,64,17,0C,17,14,17,19
;5EB9    DB 17,25,17,28,17,30,07,24 ; .(.0.$
;5EC1    DB 07,2E,07,2F,07,2F,07,2F ; .../././
;5EC9    DB 07,2F,07,2F,07,2F,07,6E ; ./././..
;5ED1    DB 38,15,38,35,38,35,38,35 ; 8.858585
;5ED9    DB 38,35,38,35,38,35,38,5D ; 8585858]
;5EE1    DB 38,15,38,35,38,35,38,35 ; 8.858585
;5EE9    DB 38,35,38,35,38,35,38,1C ; 8585858.
;5EF1    DB 38,1D,46,35,46,35,46,35 ; 8.F5F5F5
;5EF9    DB 46,35,46,35,46,35,38,1C ; F5F5F58.
;5F01    DB 38,5C,46,35,46,35,46,35 ; 8\F5F5F5
;5F09    DB 46,35,46,35,46,35,38,5D ; F5F5F58]
;5F11    DB 38,5C,46,35,46,35,46,35 ; 8\F5F5F5
;5F19    DB 46,35,46,35,46,35,38,55 ; F5F5F58U
;5F21    DB 38,1D,47,35,47,35,47,35 ; 8.G5G5G5
;5F29    DB 47,35,47,35,47,35,38,1C ; G5G5G58.
;5F31    DB 38,1D,45,35,45,35,47,35 ; 8.E5E5G5
;5F39    DB 47,35,45,35,45,35,38,5D ; G5E5E58]
;5F41    DB 07,64,45,35,45,35,47,35 ; ..E5E5G5
;5F49    DB 47,35,45,35,45,35,07,24 ; G5E5E5.$
;5F51    DB 07,64,0F,26,38,35,38,35 ; ...&8585
;5F59    DB 38,35,38,35,38,35,38,5D ; 8585858]
;5F61    DB 38,1D,1F,1E,1F,1F,1F,20 ; 8...... 
;5F69    DB 1F,21,1F,22,1F,23,07,24 ; .!.".#.$
;5F71    DB 38,15,17,16,17,17,17,18
;5F79    DB 17,16,17,1A,17,1B,38,1C
;5F81    DB 07,0D,27,0E,27,0F,27,10 ; ..'.'.'.
;5F89    DB 27,11,27,12,27,13,07,4D ; '.'.'..M
;5F91    DB 07,05,27,06,27,07,27,08 ; ..'.'.'.
;5F99    DB 27,09,27,0A,27,0B,07,45 ; '.'.'..E
;5FA1    DB 07,00,07,01,07,01,07,02
;5FA9    DB 07,03,07,01,07,01,07,04

;L5E91   .he 07,34,07,81,07,83,07,82 ; DB 07,34,07,81,07,83,07,82
;        .he 07,83,07,81,07,82,07,2A ; DB 07,83,07,81,07,82,07,2A
;        .he 07,2D,17,31,17,32,17,33 ; DB 07,2D,17,31,17,32,17,33
;        .he 17,2C,17,A8,17,B0,07,6D ; DB 17,2C,17,A8,17,B0,07,6D
;        .he 07,64,17,0C,17,14,17,19 ; DB 07,64,17,0C,17,14,17,19
;        .he 17,25,17,28,17,30,07,24 ; DB 17,25,17,28,17,30,07,24
;        .he 07,2E,07,2F,07,2F,07,2F ; DB 07,2E,07,2F,07,2F,07,2F
;        .he 07,2F,07,2F,07,2F,07,6E ; DB 07,2F,07,2F,07,2F,07,6E
;        .he 38,15,38,35,38,35,38,35 ; DB 38,15,38,35,38,35,38,35
;        .he 38,35,38,35,38,35,38,5D ; DB 38,35,38,35,38,35,38,5D
;        .he 38,15,38,35,38,35,38,35 ; DB 38,15,38,35,38,35,38,35
;        .he 38,35,38,35,38,35,38,1C ; DB 38,35,38,35,38,35,38,1C
;        .he 38,1D,46,35,46,35,46,35 ; DB 38,1D,46,35,46,35,46,35
;        .he 46,35,46,35,46,35,38,1C ; DB 46,35,46,35,46,35,38,1C
;        .he 38,5C,46,35,46,35,46,35 ; DB 38,5C,46,35,46,35,46,35
;        .he 46,35,46,35,46,35,38,5D ; DB 46,35,46,35,46,35,38,5D
;        .he 38,5C,46,35,46,35,46,35 ; DB 38,5C,46,35,46,35,46,35
;        .he 46,35,46,35,46,35,38,55 ; DB 46,35,46,35,46,35,38,55
;        .he 38,1D,47,35,47,35,47,35 ; DB 38,1D,47,35,47,35,47,35
;        .he 47,35,47,35,47,35,38,1C ; DB 47,35,47,35,47,35,38,1C
;        .he 38,1D,45,35,45,35,47,35 ; DB 38,1D,45,35,45,35,47,35
;        .he 47,35,45,35,45,35,38,5D ; DB 47,35,45,35,45,35,38,5D
;        .he 07,64,45,35,45,35,47,35 ; DB 07,64,45,35,45,35,47,35
;        .he 47,35,45,35,45,35,07,24 ; DB 47,35,45,35,45,35,07,24
;        .he 07,64,0F,26,38,35,38,35 ; DB 07,64,0F,26,38,35,38,35
;        .he 38,35,38,35,38,35,38,5D ; DB 38,35,38,35,38,35,38,5D
;        .he 38,1D,1F,1E,1F,1F,1F,20 ; DB 38,1D,1F,1E,1F,1F,1F,20
;        .he 1F,21,1F,22,1F,23,07,24 ; DB 1F,21,1F,22,1F,23,07,24
;        .he 38,15,17,16,17,17,17,18 ; DB 38,15,17,16,17,17,17,18
;        .he 17,16,17,1A,17,1B,38,1C ; DB 17,16,17,1A,17,1B,38,1C
;        .he 07,0D,27,0E,27,0F,27,10 ; DB 07,0D,27,0E,27,0F,27,10
;        .he 27,11,27,12,27,13,07,4D ; DB 27,11,27,12,27,13,07,4D
;        .he 07,05,27,06,27,07,27,08 ; DB 07,05,27,06,27,07,27,08
;        .he 27,09,27,0A,27,0B,07,45 ; DB 27,09,27,0A,27,0B,07,45
;        .he 07,00,07,01,07,01,07,02 ; DB 07,00,07,01,07,01,07,02
;        .he 07,03,07,01,07,01,07,04 ; DB 07,03,07,01,07,01,07,04

;L5FB1   DB 01,01,01,01,01,01,01,01
;5FB9    DB 01,01,01,01,01,01,01,01
;5FC1    DB 01,00,00,00,00,00,09,00
;5FC9    DB 00,0E,00,09,00,00,00,01
;5FD1    DB 01,00,08,00,00,00,03,09
;5FD9    DB 00,0D,00,02,00,00,00,01
;5FE1    DB 01,00,00,00,00,10,00,00
;5FE9    DB 00,12,00,03,00,00,00,01
;5FF1    DB 01,00,00,00,00,03,00,04
;5FF9    DB 05,04,00,07,00,00,00,01
;6001    DB 01,00,00

L5FB1   .he 01,01,01,01,01,01,01,01 ; DB 01,01,01,01,01,01,01,01
        .he 01,01,01,01,01,01,01,01 ; DB 01,01,01,01,01,01,01,01
        .he 01,00,00,00,00,00,09,00 ; DB 01,00,00,00,00,00,09,00
        .he 00,0E,00,09,00,00,00,01 ; DB 00,0E,00,09,00,00,00,01
        .he 01,00,08,00,00,00,03,09 ; DB 01,00,08,00,00,00,03,09
        .he 00,0D,00,02,00,00,00,01 ; DB 00,0D,00,02,00,00,00,01
        .he 01,00,00,00,00,10,00,00 ; DB 01,00,00,00,00,10,00,00
        .he 00,12,00,03,00,00,00,01 ; DB 00,12,00,03,00,00,00,01
        .he 01,00,00,00,00,03,00,04 ; DB 01,00,00,00,00,03,00,04
        .he 05,04,00,07,00,00,00,01 ; DB 05,04,00,07,00,00,00,01
        .he 01,00,00 ; DB 01,00,00

;L6004   DB 0C,19,00,00,00,00,00,00
;600C    DB 09,00,00,00,01,01,00,00
;6014    DB 0B,00,00,17,14,14,18,00
;601C    DB 0E,00,08,0E,01,01,00,00
;6024    DB 0E,00,00,13,00,00,13,00
;602C    DB 00,00,00,00,01,01,00,00
;6034    DB 05,00,00,13,00,00,13,00
;603C    DB 04,05,00,10,01,01,00,00
;6044    DB 00,00,00,0F,15,15,11,00
;604C    DB 06,00,00,00,01,01,00,00
;6054    DB 06,0E,00,00,00,00,00,00
;605C    DB 0A,00,05,00,01,01,00,00
;6064    DB 00,0D,00,00,00,00,04,00
;606C    DB 00,00,00,00,01,01,00,0E
;6074    DB 00,06,00,00,00,00,00,00
;607C    DB 02,00,00,06,01,01,00,00
;6084    DB 00,0D,00,00,00,00,02,00
;608C    DB 03,00,05,00,01,01,0C,00
;6094    DB 00,00,00,0C,00,00,07,00
;609C    DB 09,00,00,0A,01,01,01,01
;60A4    DB 01,01,01,01,01,01,01,01
;60AC    DB 01,01,01,01,01

; L6004 is not a pointer
        .he 0C,19,00,00,00,00,00,00 ; DB 0C,19,00,00,00,00,00,00
        .he 09,00,00,00,01,01,00,00 ; DB 09,00,00,00,01,01,00,00
        .he 0B,00,00,17,14,14,18,00 ; DB 0B,00,00,17,14,14,18,00
        .he 0E,00,08,0E,01,01,00,00 ; DB 0E,00,08,0E,01,01,00,00
        .he 0E,00,00,13,00,00,13,00 ; DB 0E,00,00,13,00,00,13,00
        .he 00,00,00,00,01,01,00,00 ; DB 00,00,00,00,01,01,00,00
        .he 05,00,00,13,00,00,13,00 ; DB 05,00,00,13,00,00,13,00
        .he 04,05,00,10,01,01,00,00 ; DB 04,05,00,10,01,01,00,00
        .he 00,00,00,0F,15,15,11,00 ; DB 00,00,00,0F,15,15,11,00
        .he 06,00,00,00,01,01,00,00 ; DB 06,00,00,00,01,01,00,00
        .he 06,0E,00,00,00,00,00,00 ; DB 06,0E,00,00,00,00,00,00
        .he 0A,00,05,00,01,01,00,00 ; DB 0A,00,05,00,01,01,00,00
        .he 00,0D,00,00,00,00,04,00 ; DB 00,0D,00,00,00,00,04,00
        .he 00,00,00,00,01,01,00,0E ; DB 00,00,00,00,01,01,00,0E
        .he 00,06,00,00,00,00,00,00 ; DB 00,06,00,00,00,00,00,00
        .he 02,00,00,06,01,01,00,00 ; DB 02,00,00,06,01,01,00,00
        .he 00,0D,00,00,00,00,02,00 ; DB 00,0D,00,00,00,00,02,00
        .he 03,00,05,00,01,01,0C,00 ; DB 03,00,05,00,01,01,0C,00
        .he 00,00,00,0C,00,00,07,00 ; DB 00,00,00,0C,00,00,07,00
        .he 09,00,00,0A,01,01,01,01 ; DB 09,00,00,0A,01,01,01,01
        .he 01,01,01,01,01,01,01,01 ; DB 01,01,01,01,01,01,01,01
        .he 01,01,01,01,01 ; DB 01,01,01,01,01

;L60B1   DB 40,80,60,00,50,41,80,60 ; @...PA..
;60B9    DB 00,50,40,81,60,00,50,81 ; .P@...P.
;60C1    DB 41,60,00,50,40,80,61,00 ; A..P@...
;60C9    DB 50,61,41,80,00,50,40,81 ; P.A..P@.
;60D1    DB 61,00,50,81,61,41,00,50 ; ..P..A.P
;60D9    DB 40,80,60,01,50,41,80,60 ; @...PA..
;60E1    DB 01,50,40,01,81,60,50,01 ; .P@...P.
;60E9    DB 81,41,60,50,40,80,61,01 ; .A.P@...
;60F1    DB 50,61,41,80,01,50,40,01 ; P.A..P@.
;60F9    DB 81,61,50,01,81,61,41,50 ; ..P...AP
;6101    DB 40,80,60,00,51,41,80,60 ; @...QA..
;6109    DB 00,51,40,81,60,00,51,81 ; .Q@...Q.
;6111    DB 41,60,00,51,40,80,51,61 ; A..Q@.Q.
;6119    DB 00,51,61,41,80,00,40,51 ; .Q.A..@Q
;6121    DB 61,81,00,51,61,81,41,00 ; ...Q..A.
;6129    DB 40,80,60,01,51,41,80,60 ; @...QA..
;6131    DB 01,51,40,01,81,60,51,01 ; .Q@...Q.
;6139    DB 81,41,60,51,40,51,61,80 ; .A.Q@Q..
;6141    DB 01,51,61,41,80,01,40,01 ; .Q.A..@.
;6149    DB 81,51,61,01,81,51,61,41 ; .Q...Q.A

L60B1   .he 40,80,60,00,50,41,80,60 ; DB 40,80,60,00,50,41,80,60
        .he 00,50,40,81,60,00,50,81 ; DB 00,50,40,81,60,00,50,81
        .he 41,60,00,50,40,80,61,00 ; DB 41,60,00,50,40,80,61,00
        .he 50,61,41,80,00,50,40,81 ; DB 50,61,41,80,00,50,40,81
        .he 61,00,50,81,61,41,00,50 ; DB 61,00,50,81,61,41,00,50
        .he 40,80,60,01,50,41,80,60 ; DB 40,80,60,01,50,41,80,60
        .he 01,50,40,01,81,60,50,01 ; DB 01,50,40,01,81,60,50,01
        .he 81,41,60,50,40,80,61,01 ; DB 81,41,60,50,40,80,61,01
        .he 50,61,41,80,01,50,40,01 ; DB 50,61,41,80,01,50,40,01
        .he 81,61,50,01,81,61,41,50 ; DB 81,61,50,01,81,61,41,50
        .he 40,80,60,00,51,41,80,60 ; DB 40,80,60,00,51,41,80,60
        .he 00,51,40,81,60,00,51,81 ; DB 00,51,40,81,60,00,51,81
        .he 41,60,00,51,40,80,51,61 ; DB 41,60,00,51,40,80,51,61
        .he 00,51,61,41,80,00,40,51 ; DB 00,51,61,41,80,00,40,51
        .he 61,81,00,51,61,81,41,00 ; DB 61,81,00,51,61,81,41,00
        .he 40,80,60,01,51,41,80,60 ; DB 40,80,60,01,51,41,80,60
        .he 01,51,40,01,81,60,51,01 ; DB 01,51,40,01,81,60,51,01
        .he 81,41,60,51,40,51,61,80 ; DB 81,41,60,51,40,51,61,80
        .he 01,51,61,41,80,01,40,01 ; DB 01,51,61,41,80,01,40,01
        .he 81,51,61,01,81,51,61,41 ; DB 81,51,61,01,81,51,61,41

;L6151   DW L6185,L6186,L6197,L6197
;6159    DW L61B0,L61B0,L61D1,L61EA
;6161    DW L61FF,L6214,L6229,L6253
;6169    DW L623E,L61D1,L61FF,L61EA
;6171    DW L6229,L6214,L61D1,L6197
;6179    DW L61B0,L61B0,L61B0,L61EA
;6181    DW L6214,L6229

L6151   .wo L6185,L6186,L6197,L6197 ; DW L6185,L6186,L6197,L6197
        .wo L61B0,L61B0,L61D1,L61EA ; DW L61B0,L61B0,L61D1,L61EA
        .wo L61FF,L6214,L6229,L6253 ; DW L61FF,L6214,L6229,L6253
        .wo L623E,L61D1,L61FF,L61EA ; DW L623E,L61D1,L61FF,L61EA
        .wo L6229,L6214,L61D1,L6197 ; DW L6229,L6214,L61D1,L6197
        .wo L61B0,L61B0,L61B0,L61EA ; DW L61B0,L61B0,L61B0,L61EA
        .wo L6214,L6229 ; DW L6214,L6229

;L6185   DB 00

L6185   .he 00 ; DB 00

;L6186   DB 80,42,40,02,BE,80,02,40 ; .B@....@
;618E    DB 80,BE,40,02,42,80,02,40 ; ..@.B..@
;6196    DB 00

L6186   .he 80,42,40,02,BE,80,02,40 ; DB 80,42,40,02,BE,80,02,40
        .he 80,BE,40,02,42,80,02,40 ; DB 80,BE,40,02,42,80,02,40
        .he 00 ; DB 00

;L6197   DB 80,42,40,02,BE,58,02,18 ; .B@..X..
;619F    DB BE,A8,02,18,80,BE,40,02
;61A7    DB 42,A8,02,18,42,58,02,18 ; B...BX..
;61AF    DB 00

L6197   .he 80,42,40,02,BE,58,02,18 ; DB 80,42,40,02,BE,58,02,18
        .he BE,A8,02,18,80,BE,40,02 ; DB BE,A8,02,18,80,BE,40,02
        .he 42,A8,02,18,42,58,02,18 ; DB 42,A8,02,18,42,58,02,18
        .he 00 ; DB 00

;L61B0   DB 58,42,18,02,A8,42,18,02 ; XB...B..
;61B8    DB BE,58,02,18,BE,A8,02,18
;61C0    DB A8,BE,18,02,58,BE,18,02
;61C8    DB 42,A8,02,18,42,58,02,18 ; B...BX..
;61D0    DB 00

L61B0   .he 58,42,18,02,A8,42,18,02 ; DB 58,42,18,02,A8,42,18,02
        .he BE,58,02,18,BE,A8,02,18 ; DB BE,58,02,18,BE,A8,02,18
        .he A8,BE,18,02,58,BE,18,02 ; DB A8,BE,18,02,58,BE,18,02
        .he 42,A8,02,18,42,58,02,18 ; DB 42,A8,02,18,42,58,02,18
        .he 00 ; DB 00

;L61D1   DB 58,42,18,02,A8,42,18,02 ; XB...B..
;61D9    DB BE,80,02,40,A8,BE,18,02
;61E1    DB 58,BE,18,02,42,80,02,40 ; X...B..@
;61E9    DB 00

L61D1   .he 58,42,18,02,A8,42,18,02 ; DB 58,42,18,02,A8,42,18,02
        .he BE,80,02,40,A8,BE,18,02 ; DB BE,80,02,40,A8,BE,18,02
        .he 58,BE,18,02,42,80,02,40 ; DB 58,BE,18,02,42,80,02,40
        .he 00 ; DB 00

;L61EA   DB 80,42,40,02,BE,58,02,18 ; .B@..X..
;61F2    DB BE,A8,02,18,80,BE,40,02
;61FA    DB 42,80,02,40,00 ; B..@.

L61EA   .he 80,42,40,02,BE,58,02,18 ; DB 80,42,40,02,BE,58,02,18
        .he BE,A8,02,18,80,BE,40,02 ; DB BE,A8,02,18,80,BE,40,02
        .he 42,80,02,40,00 ; DB 42,80,02,40,00

;L61FF   DB 80,42,40,02,BE,80,02,40 ; .B@....@
;6207    DB A8,BE,18,02,58,BE,18,02
;620F    DB 42,80,02,40,00 ; B..@.

L61FF   .he 80,42,40,02,BE,80,02,40 ; DB 80,42,40,02,BE,80,02,40
        .he A8,BE,18,02,58,BE,18,02 ; DB A8,BE,18,02,58,BE,18,02
        .he 42,80,02,40,00 ; DB 42,80,02,40,00

;L6214   DB 80,42,40,02,BE,80,02,40 ; .B@....@
;621C    DB 80,BE,40,02,42,A8,02,18 ; ..@.B...
;6224    DB 42,58,02,18,00 ; BX...

L6214   .he 80,42,40,02,BE,80,02,40 ; DB 80,42,40,02,BE,80,02,40
        .he 80,BE,40,02,42,A8,02,18 ; DB 80,BE,40,02,42,A8,02,18
        .he 42,58,02,18,00 ; DB 42,58,02,18,00

;L6229   DB 58,42,18,02,A8,42,18,02 ; XB...B..
;6231    DB BE,80,02,40,80,BE,40,02 ; ...@..@.
;6239    DB 42,80,02,40,00 ; B..@.

L6229   .he 58,42,18,02,A8,42,18,02 ; DB 58,42,18,02,A8,42,18,02
        .he BE,80,02,40,80,BE,40,02 ; DB BE,80,02,40,80,BE,40,02
        .he 42,80,02,40,00 ; DB 42,80,02,40,00

;L623E   DB 68,42,28,02,B8,42,04,02 ; .B(..B..
;6246    DB BE,80,02,40,80,BE,40,02 ; ...@..@.
;624E    DB 42,80,02,40,00 ; B..@.

L623E   .he 68,42,28,02,B8,42,04,02 ; DB 68,42,28,02,B8,42,04,02
        .he BE,80,02,40,80,BE,40,02 ; DB BE,80,02,40,80,BE,40,02
        .he 42,80,02,40,00 ; DB 42,80,02,40,00

;L6253   DB 80,42,40,02,BE,60,02,20 ; .B@.... 
;625B    DB BE,B0,02,10,80,BE,40,02
;6263    DB 42,B0,02,10,42,60,02,20 ; B...B.. 
;626B    DB 00

L6253   .he 80,42,40,02,BE,60,02,20 ; DB 80,42,40,02,BE,60,02,20
        .he BE,B0,02,10,80,BE,40,02 ; DB BE,B0,02,10,80,BE,40,02
        .he 42,B0,02,10,42,60,02,20 ; DB 42,B0,02,10,42,60,02,20
        .he 00 ; DB 00

;L626C   DW L0000,L0000,L62D4,L62D4
;6274    DW L62F4,L62F4,L6314,L6314
;627C    DW L6334,L6334,L6354,L6354
;6284    DW L6374,L6374,L6394,L63B4
;628C    DW L63D4,L63F4,L6414,L6434
;6294    DW L6454,L6474,L6494,L64B4
;629C    DW L64D4,L64F4,L6514,L6534
;62A4    DW L6554,L6574,L6594,L65B4
;62AC    DW L65D4,L65F4,L6614,L6634
;62B4    DW L6654,L6654,L6674,L6674
;62BC    DW L6694,L66B4,L66D4,L66F4
;62C4    DW L6714,L6714,L6734,L6754
;62CC    DW L6774,L6794,L67B4,L67D4

L626C   .wo L0000,L0000,L62D4,L62D4 ; DW L0000,L0000,L62D4,L62D4
        .wo L62F4,L62F4,L6314,L6314 ; DW L62F4,L62F4,L6314,L6314
        .wo L6334,L6334,L6354,L6354 ; DW L6334,L6334,L6354,L6354
        .wo L6374,L6374,L6394,L63B4 ; DW L6374,L6374,L6394,L63B4
        .wo L63D4,L63F4,L6414,L6434 ; DW L63D4,L63F4,L6414,L6434
        .wo L6454,L6474,L6494,L64B4 ; DW L6454,L6474,L6494,L64B4
        .wo L64D4,L64F4,L6514,L6534 ; DW L64D4,L64F4,L6514,L6534
        .wo L6554,L6574,L6594,L65B4 ; DW L6554,L6574,L6594,L65B4
        .wo L65D4,L65F4,L6614,L6634 ; DW L65D4,L65F4,L6614,L6634
        .wo L6654,L6654,L6674,L6674 ; DW L6654,L6654,L6674,L6674
        .wo L6694,L66B4,L66D4,L66F4 ; DW L6694,L66B4,L66D4,L66F4
        .wo L6714,L6714,L6734,L6754 ; DW L6714,L6714,L6734,L6754
        .wo L6774,L6794,L67B4,L67D4 ; DW L6774,L6794,L67B4,L67D4

;L62D4   DB 11,12,11,12,11,12,11,12
;62DC    DB 11,12,11,12,11,12,11,12
;62E4    DB 11,12,11,12,11,12,11,12
;62EC    DB 11,12,11,12,11,12,11,12

L62D4   .he 11,12,11,12,11,12,11,12 ; DB 11,12,11,12,11,12,11,12
        .he 11,12,11,12,11,12,11,12 ; DB 11,12,11,12,11,12,11,12
        .he 11,12,11,12,11,12,11,12 ; DB 11,12,11,12,11,12,11,12
        .he 11,12,11,12,11,12,11,12 ; DB 11,12,11,12,11,12,11,12

;L62F4   DB 21,0D,05,0A,07,0B,06,0C
;62FC    DB 07,0B,06,0C,07,0D,21,0D
;6304    DB 00,0D,0E,0C,00,0B,02,0D
;630C    DB 01,0D,00,0C,0E,0B,00,0D

L62F4   .he 21,0D,05,0A,07,0B,06,0C ; DB 21,0D,05,0A,07,0B,06,0C
        .he 07,0B,06,0C,07,0D,21,0D ; DB 07,0B,06,0C,07,0D,21,0D
        .he 00,0D,0E,0C,00,0B,02,0D ; DB 00,0D,0E,0C,00,0B,02,0D
        .he 01,0D,00,0C,0E,0B,00,0D ; DB 01,0D,00,0C,0E,0B,00,0D

;L6314   DB 08,09,05,0A,07,0B,06,0C
;631C    DB 07,0B,06,0C,07,0B,08,09
;6324    DB 00,0D,00,0D,00,0D,02,0C
;632C    DB 01,0B,00,0D,00,0D,00,0D

L6314   .he 08,09,05,0A,07,0B,06,0C ; DB 08,09,05,0A,07,0B,06,0C
        .he 07,0B,06,0C,07,0B,08,09 ; DB 07,0B,06,0C,07,0B,08,09
        .he 00,0D,00,0D,00,0D,02,0C ; DB 00,0D,00,0D,00,0D,02,0C
        .he 01,0B,00,0D,00,0D,00,0D ; DB 01,0B,00,0D,00,0D,00,0D

;L6334   DB 00,0D,00,0D,00,0D,01,0B
;633C    DB 02,0C,00,0D,00,0D,00,0D
;6344    DB 00,0D,00,0D,00,0D,02,0C
;634C    DB 01,0B,00,0D,00,0D,00,0D

L6334   .he 00,0D,00,0D,00,0D,01,0B ; DB 00,0D,00,0D,00,0D,01,0B
        .he 02,0C,00,0D,00,0D,00,0D ; DB 02,0C,00,0D,00,0D,00,0D
        .he 00,0D,00,0D,00,0D,02,0C ; DB 00,0D,00,0D,00,0D,02,0C
        .he 01,0B,00,0D,00,0D,00,0D ; DB 01,0B,00,0D,00,0D,00,0D

;L6354   DB 00,0D,0E,0D,0E,0B,01,0C
;635C    DB 02,0D,03,0D,04,0D,00,0D
;6364    DB 00,0D,04,0C,03,0B,02,0D
;636C    DB 01,0D,04,0C,03,0B,00,0D

L6354   .he 00,0D,0E,0D,0E,0B,01,0C ; DB 00,0D,0E,0D,0E,0B,01,0C
        .he 02,0D,03,0D,04,0D,00,0D ; DB 02,0D,03,0D,04,0D,00,0D
        .he 00,0D,04,0C,03,0B,02,0D ; DB 00,0D,04,0C,03,0B,02,0D
        .he 01,0D,04,0C,03,0B,00,0D ; DB 01,0D,04,0C,03,0B,00,0D

;L6374   DB 00,0D,03,1F,04,20,01,1F
;637C    DB 02,20,03,1F,04,20,00,0D ; . ... ..
;6384    DB 00,0D,10,0C,0F,0B,10,0C
;638C    DB 0F,0B,10,0C,0F,0B,00,0D

L6374   .he 00,0D,03,1F,04,20,01,1F ; DB 00,0D,03,1F,04,20,01,1F
        .he 02,20,03,1F,04,20,00,0D ; DB 02,20,03,1F,04,20,00,0D
        .he 00,0D,10,0C,0F,0B,10,0C ; DB 00,0D,10,0C,0F,0B,10,0C
        .he 0F,0B,10,0C,0F,0B,00,0D ; DB 0F,0B,10,0C,0F,0B,00,0D

;L6394   DB 00,0D,0E,0B,00,0C,00,0B
;639C    DB 00,0C,00,0B,0E,0C,00,0D
;63A4    DB 0E,0D,04,0D,03,0C,02,0B
;63AC    DB 01,0C,04,0B,03,0D,0E,0D

L6394   .he 00,0D,0E,0B,00,0C,00,0B ; DB 00,0D,0E,0B,00,0C,00,0B
        .he 00,0C,00,0B,0E,0C,00,0D ; DB 00,0C,00,0B,0E,0C,00,0D
        .he 0E,0D,04,0D,03,0C,02,0B ; DB 0E,0D,04,0D,03,0C,02,0B
        .he 01,0C,04,0B,03,0D,0E,0D ; DB 01,0C,04,0B,03,0D,0E,0D

;L63B4   DB 0E,0D,0E,0D,0E,0D,03,0D
;63BC    DB 04,0D,0E,0D,0E,0D,0E,0D
;63C4    DB 00,0D,0E,0C,00,0B,00,0D
;63CC    DB 0E,0D,0E,0C,00,0B,00,0D

L63B4   .he 0E,0D,0E,0D,0E,0D,03,0D ; DB 0E,0D,0E,0D,0E,0D,03,0D
        .he 04,0D,0E,0D,0E,0D,0E,0D ; DB 04,0D,0E,0D,0E,0D,0E,0D
        .he 00,0D,0E,0C,00,0B,00,0D ; DB 00,0D,0E,0C,00,0B,00,0D
        .he 0E,0D,0E,0C,00,0B,00,0D ; DB 0E,0D,0E,0C,00,0B,00,0D

;L63D4   DB 00,0B,00,0C,0E,0B,03,0C
;63DC    DB 04,0B,0E,0C,0E,0B,00,0C
;63E4    DB 00,0D,0E,0C,00,0B,00,20
;63EC    DB 10,1F,0F,0C,00,0B,00,0D

L63D4   .he 00,0B,00,0C,0E,0B,03,0C ; DB 00,0B,00,0C,0E,0B,03,0C
        .he 04,0B,0E,0C,0E,0B,00,0C ; DB 04,0B,0E,0C,0E,0B,00,0C
        .he 00,0D,0E,0C,00,0B,00,20 ; DB 00,0D,0E,0C,00,0B,00,20
        .he 10,1F,0F,0C,00,0B,00,0D ; DB 10,1F,0F,0C,00,0B,00,0D

;L63F4   DB 00,0D,0F,1F,10,20,01,1F
;63FC    DB 02,20,0F,0B,10,0C,0E,0D
;6404    DB 00,0D,10,0D,0F,0D,0E,0D
;640C    DB 0E,0D,10,0D,0F,0D,00,0D

L63F4   .he 00,0D,0F,1F,10,20,01,1F ; DB 00,0D,0F,1F,10,20,01,1F
        .he 02,20,0F,0B,10,0C,0E,0D ; DB 02,20,0F,0B,10,0C,0E,0D
        .he 00,0D,10,0D,0F,0D,0E,0D ; DB 00,0D,10,0D,0F,0D,0E,0D
        .he 0E,0D,10,0D,0F,0D,00,0D ; DB 0E,0D,10,0D,0F,0D,00,0D

;L6414   DB 00,0B,00,0C,0E,0B,03,0C
;641C    DB 04,0B,00,0C,00,0B,0E,0C
;6424    DB 00,0D,0E,0C,00,0B,00,20
;642C    DB 10,1F,0F,0C,00,0B,00,0D

L6414   .he 00,0B,00,0C,0E,0B,03,0C ; DB 00,0B,00,0C,0E,0B,03,0C
        .he 04,0B,00,0C,00,0B,0E,0C ; DB 04,0B,00,0C,00,0B,0E,0C
        .he 00,0D,0E,0C,00,0B,00,20 ; DB 00,0D,0E,0C,00,0B,00,20
        .he 10,1F,0F,0C,00,0B,00,0D ; DB 10,1F,0F,0C,00,0B,00,0D

;L6434   DB 00,0B,0E,0C,00,0B,0E,0C
;643C    DB 0E,0B,00,0C,0E,0B,00,0C
;6444    DB 0E,0D,10,0C,0F,0B,02,20
;644C    DB 01,1F,0E,0C,0E,0B,0E,0D

L6434   .he 00,0B,0E,0C,00,0B,0E,0C ; DB 00,0B,0E,0C,00,0B,0E,0C
        .he 0E,0B,00,0C,0E,0B,00,0C ; DB 0E,0B,00,0C,0E,0B,00,0C
        .he 0E,0D,10,0C,0F,0B,02,20 ; DB 0E,0D,10,0C,0F,0B,02,20
        .he 01,1F,0E,0C,0E,0B,0E,0D ; DB 01,1F,0E,0C,0E,0B,0E,0D

;L6454   DB 03,0D,04,0D,0E,0B,01,0C
;645C    DB 02,0B,0E,0C,03,0D,04,0D
;6464    DB 00,0D,0E,0C,00,0B,00,0D
;646C    DB 00,0D,00,0C,0E,0B,00,0D

L6454   .he 03,0D,04,0D,0E,0B,01,0C ; DB 03,0D,04,0D,0E,0B,01,0C
        .he 02,0B,0E,0C,03,0D,04,0D ; DB 02,0B,0E,0C,03,0D,04,0D
        .he 00,0D,0E,0C,00,0B,00,0D ; DB 00,0D,0E,0C,00,0B,00,0D
        .he 00,0D,00,0C,0E,0B,00,0D ; DB 00,0D,00,0C,0E,0B,00,0D

;L6474   DB 00,0D,00,0D,00,0D,00,0C
;647C    DB 00,0B,00,0D,00,0D,00,0D
;6484    DB 0E,0D,00,0D,0E,0C,00,0B
;648C    DB 0E,0C,00,0B,0E,0D,00,0D

L6474   .he 00,0D,00,0D,00,0D,00,0C ; DB 00,0D,00,0D,00,0D,00,0C
        .he 00,0B,00,0D,00,0D,00,0D ; DB 00,0B,00,0D,00,0D,00,0D
        .he 0E,0D,00,0D,0E,0C,00,0B ; DB 0E,0D,00,0D,0E,0C,00,0B
        .he 0E,0C,00,0B,0E,0D,00,0D ; DB 0E,0C,00,0B,0E,0D,00,0D

;L6494   DB 1D,1F,1E,20,1D,1F,1E,20 ; ... ... 
;649C    DB 1D,1F,1E,20,1D,1F,1E,20 ; ... ... 
;64A4    DB 1E,20,1D,1F,1E,20,1D,1F ; . ... ..
;64AC    DB 02,20,01,1F,1E,20,1D,1F ; . ... ..

L6494   .he 1D,1F,1E,20,1D,1F,1E,20 ; DB 1D,1F,1E,20,1D,1F,1E,20
        .he 1D,1F,1E,20,1D,1F,1E,20 ; DB 1D,1F,1E,20,1D,1F,1E,20
        .he 1E,20,1D,1F,1E,20,1D,1F ; DB 1E,20,1D,1F,1E,20,1D,1F
        .he 02,20,01,1F,1E,20,1D,1F ; DB 02,20,01,1F,1E,20,1D,1F

;L64B4   DB 1D,1F,1E,20,1D,1F,1E,20 ; ... ... 
;64BC    DB 0F,1F,10,20,1D,1F,1E,20 ; ... ... 
;64C4    DB 1E,20,1D,1F,02,20,01,1F ; . ... ..
;64CC    DB 1E,20,1D,1F,1E,20,1D,1F ; . ... ..

L64B4   .he 1D,1F,1E,20,1D,1F,1E,20 ; DB 1D,1F,1E,20,1D,1F,1E,20
        .he 0F,1F,10,20,1D,1F,1E,20 ; DB 0F,1F,10,20,1D,1F,1E,20
        .he 1E,20,1D,1F,02,20,01,1F ; DB 1E,20,1D,1F,02,20,01,1F
        .he 1E,20,1D,1F,1E,20,1D,1F ; DB 1E,20,1D,1F,1E,20,1D,1F

;L64D4   DB 00,0D,0F,1F,10,20,0F,1F
;64DC    DB 10,20,01,1F,02,20,00,0D ; . ... ..
;64E4    DB 00,0D,10,20,0F,1F,10,20 ; ... ... 
;64EC    DB 0F,1F,10,20,0F,1F,00,0D

L64D4   .he 00,0D,0F,1F,10,20,0F,1F ; DB 00,0D,0F,1F,10,20,0F,1F
        .he 10,20,01,1F,02,20,00,0D ; DB 10,20,01,1F,02,20,00,0D
        .he 00,0D,10,20,0F,1F,10,20 ; DB 00,0D,10,20,0F,1F,10,20
        .he 0F,1F,10,20,0F,1F,00,0D ; DB 0F,1F,10,20,0F,1F,00,0D

;L64F4   DB 00,0D,0F,1F,10,20,0F,1F
;64FC    DB 10,20,0F,1F,10,20,00,0D ; . ... ..
;6504    DB 00,0D,10,20,0F,1F,10,20 ; ... ... 
;650C    DB 0F,1F,10,20,0F,1F,00,0D

L64F4   .he 00,0D,0F,1F,10,20,0F,1F ; DB 00,0D,0F,1F,10,20,0F,1F
        .he 10,20,0F,1F,10,20,00,0D ; DB 10,20,0F,1F,10,20,00,0D
        .he 00,0D,10,20,0F,1F,10,20 ; DB 00,0D,10,20,0F,1F,10,20
        .he 0F,1F,10,20,0F,1F,00,0D ; DB 0F,1F,10,20,0F,1F,00,0D

;L6514   DB 08,09,1D,1F,1E,20,01,1F
;651C    DB 02,20,1D,1F,1E,20,08,09 ; . ... ..
;6524    DB 00,0D,1E,20,1D,1F,10,20 ; ... ... 
;652C    DB 0F,1F,1E,20,1D,1F,00,0D

L6514   .he 08,09,1D,1F,1E,20,01,1F ; DB 08,09,1D,1F,1E,20,01,1F
        .he 02,20,1D,1F,1E,20,08,09 ; DB 02,20,1D,1F,1E,20,08,09
        .he 00,0D,1E,20,1D,1F,10,20 ; DB 00,0D,1E,20,1D,1F,10,20
        .he 0F,1F,1E,20,1D,1F,00,0D ; DB 0F,1F,1E,20,1D,1F,00,0D

;L6534   DB 08,09,1D,1F,1E,20,01,1F
;653C    DB 02,20,1D,1F,1E,20,08,06 ; . ... ..
;6544    DB 00,0D,1E,20,1D,1F,10,20 ; ... ... 
;654C    DB 0F,1F,1E,20,1D,1F,00,0D

L6534   .he 08,09,1D,1F,1E,20,01,1F ; DB 08,09,1D,1F,1E,20,01,1F
        .he 02,20,1D,1F,1E,20,08,06 ; DB 02,20,1D,1F,1E,20,08,06
        .he 00,0D,1E,20,1D,1F,10,20 ; DB 00,0D,1E,20,1D,1F,10,20
        .he 0F,1F,1E,20,1D,1F,00,0D ; DB 0F,1F,1E,20,1D,1F,00,0D

;L6554   DB 18,0D,18,1F,17,20,18,1F
;655C    DB 18,20,17,1F,17,20,18,0D ; . ... ..
;6564    DB 18,0D,17,20,17,1F,18,20 ; ... ... 
;656C    DB 18,1F,17,20,17,1F,18,0D

L6554   .he 18,0D,18,1F,17,20,18,1F ; DB 18,0D,18,1F,17,20,18,1F
        .he 18,20,17,1F,17,20,18,0D ; DB 18,20,17,1F,17,20,18,0D
        .he 18,0D,17,20,17,1F,18,20 ; DB 18,0D,17,20,17,1F,18,20
        .he 18,1F,17,20,17,1F,18,0D ; DB 18,1F,17,20,17,1F,18,0D

;L6574   DB 18,0D,17,1F,18,20,15,1F
;657C    DB 16,20,18,1F,17,20,18,0D ; . ... ..
;6584    DB 18,0D,18,20,18,1F,17,20 ; ... ... 
;658C    DB 17,1F,18,20,18,1F,18,0D

L6574   .he 18,0D,17,1F,18,20,15,1F ; DB 18,0D,17,1F,18,20,15,1F
        .he 16,20,18,1F,17,20,18,0D ; DB 16,20,18,1F,17,20,18,0D
        .he 18,0D,18,20,18,1F,17,20 ; DB 18,0D,18,20,18,1F,17,20
        .he 17,1F,18,20,18,1F,18,0D ; DB 17,1F,18,20,18,1F,18,0D

;L6594   DB 18,14,18,14,18,14,18,14
;659C    DB 18,14,18,14,18,14,18,14
;65A4    DB 18,14,18,14,18,14,16,14
;65AC    DB 15,14,18,14,18,14,18,14

L6594   .he 18,14,18,14,18,14,18,14 ; DB 18,14,18,14,18,14,18,14
        .he 18,14,18,14,18,14,18,14 ; DB 18,14,18,14,18,14,18,14
        .he 18,14,18,14,18,14,16,14 ; DB 18,14,18,14,18,14,16,14
        .he 15,14,18,14,18,14,18,14 ; DB 15,14,18,14,18,14,18,14

;L65B4   DB 18,14,17,19,17,1A,18,14
;65BC    DB 18,14,17,19,17,1A,18,14
;65C4    DB 18,14,17,14,17,14,18,1C
;65CC    DB 18,1B,17,14,17,14,18,14

L65B4   .he 18,14,17,19,17,1A,18,14 ; DB 18,14,17,19,17,1A,18,14
        .he 18,14,17,19,17,1A,18,14 ; DB 18,14,17,19,17,1A,18,14
        .he 18,14,17,14,17,14,18,1C ; DB 18,14,17,14,17,14,18,1C
        .he 18,1B,17,14,17,14,18,14 ; DB 18,1B,17,14,17,14,18,14

;L65D4   DB 17,0D,18,0B,17,0C,15,0B
;65DC    DB 16,0C,17,0B,18,0C,17,0D
;65E4    DB 18,0D,17,20,17,1F,18,20 ; ... ... 
;65EC    DB 18,1F,17,20,17,1F,18,0D

L65D4   .he 17,0D,18,0B,17,0C,15,0B ; DB 17,0D,18,0B,17,0C,15,0B
        .he 16,0C,17,0B,18,0C,17,0D ; DB 16,0C,17,0B,18,0C,17,0D
        .he 18,0D,17,20,17,1F,18,20 ; DB 18,0D,17,20,17,1F,18,20
        .he 18,1F,17,20,17,1F,18,0D ; DB 18,1F,17,20,17,1F,18,0D

;L65F4   DB 18,0D,17,0B,18,0C,18,1F
;65FC    DB 18,20,18,0B,17,0C,18,0D
;6604    DB 18,0D,17,0C,18,0B,18,20
;660C    DB 17,1F,17,0C,18,0B,18,0D

L65F4   .he 18,0D,17,0B,18,0C,18,1F ; DB 18,0D,17,0B,18,0C,18,1F
        .he 18,20,18,0B,17,0C,18,0D ; DB 18,20,18,0B,17,0C,18,0D
        .he 18,0D,17,0C,18,0B,18,20 ; DB 18,0D,17,0C,18,0B,18,20
        .he 17,1F,17,0C,18,0B,18,0D ; DB 17,1F,17,0C,18,0B,18,0D

;L6614   DB 18,14,18,14,18,14,18,14
;661C    DB 18,14,18,14,18,14,18,14
;6624    DB 18,14,18,14,18,14,17,1C
;662C    DB 17,1B,18,14,18,14,18,14

L6614   .he 18,14,18,14,18,14,18,14 ; DB 18,14,18,14,18,14,18,14
        .he 18,14,18,14,18,14,18,14 ; DB 18,14,18,14,18,14,18,14
        .he 18,14,18,14,18,14,17,1C ; DB 18,14,18,14,18,14,17,1C
        .he 17,1B,18,14,18,14,18,14 ; DB 17,1B,18,14,18,14,18,14

;L6634   DB 18,14,18,14,17,14,18,19
;663C    DB 18,1A,17,14,18,14,18,14
;6644    DB 18,14,18,14,18,14,16,14
;664C    DB 15,14,18,14,18,14,18,14

L6634   .he 18,14,18,14,17,14,18,19 ; DB 18,14,18,14,17,14,18,19
        .he 18,1A,17,14,18,14,18,14 ; DB 18,1A,17,14,18,14,18,14
        .he 18,14,18,14,18,14,16,14 ; DB 18,14,18,14,18,14,16,14
        .he 15,14,18,14,18,14,18,14 ; DB 15,14,18,14,18,14,18,14

;L6654   DB 18,1F,17,20,18,1F,15,20 ; ... ... 
;665C    DB 16,1F,17,20,18,1F,18,20 ; ... ... 
;6664    DB 18,20,18,1F,17,20,17,1F ; . ... ..
;666C    DB 17,20,17,1F,18,20,18,1F ; . ... ..

L6654   .he 18,1F,17,20,18,1F,15,20 ; DB 18,1F,17,20,18,1F,15,20
        .he 16,1F,17,20,18,1F,18,20 ; DB 16,1F,17,20,18,1F,18,20
        .he 18,20,18,1F,17,20,17,1F ; DB 18,20,18,1F,17,20,17,1F
        .he 17,20,17,1F,18,20,18,1F ; DB 17,20,17,1F,18,20,18,1F

;L6674   DB 18,14,18,14,18,14,18,14
;667C    DB 18,14,18,14,18,14,18,14
;6684    DB 18,14,17,1C,17,1B,16,14
;668C    DB 15,14,17,1C,17,1B,18,14

L6674   .he 18,14,18,14,18,14,18,14 ; DB 18,14,18,14,18,14,18,14
        .he 18,14,18,14,18,14,18,14 ; DB 18,14,18,14,18,14,18,14
        .he 18,14,17,1C,17,1B,16,14 ; DB 18,14,17,1C,17,1B,16,14
        .he 15,14,17,1C,17,1B,18,14 ; DB 15,14,17,1C,17,1B,18,14

;L6694   DB 18,14,17,13,18,14,15,19
;669C    DB 16,1A,18,14,17,13,18,14
;66A4    DB 18,14,18,14,18,14,16,14
;66AC    DB 15,14,18,14,18,14,18,14

L6694   .he 18,14,17,13,18,14,15,19 ; DB 18,14,17,13,18,14,15,19
        .he 16,1A,18,14,17,13,18,14 ; DB 16,1A,18,14,17,13,18,14
        .he 18,14,18,14,18,14,16,14 ; DB 18,14,18,14,18,14,16,14
        .he 15,14,18,14,18,14,18,14 ; DB 15,14,18,14,18,14,18,14

;L66B4   DB 18,14,18,13,18,13,15,14
;66BC    DB 16,14,18,13,18,13,18,14
;66C4    DB 18,14,18,14,18,14,16,14
;66CC    DB 15,14,18,14,18,14,18,14

L66B4   .he 18,14,18,13,18,13,15,14 ; DB 18,14,18,13,18,13,15,14
        .he 16,14,18,13,18,13,18,14 ; DB 16,14,18,13,18,13,18,14
        .he 18,14,18,14,18,14,16,14 ; DB 18,14,18,14,18,14,16,14
        .he 15,14,18,14,18,14,18,14 ; DB 15,14,18,14,18,14,18,14

;L66D4   DB 17,14,17,14,17,14,15,14
;66DC    DB 16,14,17,14,17,14,17,14
;66E4    DB 18,14,18,14,18,14,16,14
;66EC    DB 15,14,18,14,18,14,18,14

L66D4   .he 17,14,17,14,17,14,15,14 ; DB 17,14,17,14,17,14,15,14
        .he 16,14,17,14,17,14,17,14 ; DB 16,14,17,14,17,14,17,14
        .he 18,14,18,14,18,14,16,14 ; DB 18,14,18,14,18,14,16,14
        .he 15,14,18,14,18,14,18,14 ; DB 15,14,18,14,18,14,18,14

;L66F4   DB 18,14,18,14,18,19,15,1A
;66FC    DB 16,19,18,1A,18,14,18,14
;6704    DB 18,14,18,14,18,14,16,14
;670C    DB 15,14,18,14,18,14,18,14

L66F4   .he 18,14,18,14,18,19,15,1A ; DB 18,14,18,14,18,19,15,1A
        .he 16,19,18,1A,18,14,18,14 ; DB 16,19,18,1A,18,14,18,14
        .he 18,14,18,14,18,14,16,14 ; DB 18,14,18,14,18,14,16,14
        .he 15,14,18,14,18,14,18,14 ; DB 15,14,18,14,18,14,18,14

;L6714   DB 18,0D,17,0B,18,0C,15,0D
;671C    DB 16,0D,18,0B,17,0C,18,0D
;6724    DB 18,0D,17,0C,18,0B,16,0D
;672C    DB 15,0D,17,0C,17,0B,18,0D

L6714   .he 18,0D,17,0B,18,0C,15,0D ; DB 18,0D,17,0B,18,0C,15,0D
        .he 16,0D,18,0B,17,0C,18,0D ; DB 16,0D,18,0B,17,0C,18,0D
        .he 18,0D,17,0C,18,0B,16,0D ; DB 18,0D,17,0C,18,0B,16,0D
        .he 15,0D,17,0C,17,0B,18,0D ; DB 15,0D,17,0C,17,0B,18,0D

;L6734   DB 18,14,18,13,18,19,18,1A
;673C    DB 18,19,18,1A,18,13,18,14
;6744    DB 18,14,18,14,18,14,16,14
;674C    DB 15,14,18,14,18,14,18,14

L6734   .he 18,14,18,13,18,19,18,1A ; DB 18,14,18,13,18,19,18,1A
        .he 18,19,18,1A,18,13,18,14 ; DB 18,19,18,1A,18,13,18,14
        .he 18,14,18,14,18,14,16,14 ; DB 18,14,18,14,18,14,16,14
        .he 15,14,18,14,18,14,18,14 ; DB 15,14,18,14,18,14,18,14

;L6754   DB 18,14,18,14,18,14,18,14
;675C    DB 18,14,18,14,18,14,18,14
;6764    DB 18,14,18,1C,18,1B,18,14
;676C    DB 18,14,18,14,18,14,18,14

L6754   .he 18,14,18,14,18,14,18,14 ; DB 18,14,18,14,18,14,18,14
        .he 18,14,18,14,18,14,18,14 ; DB 18,14,18,14,18,14,18,14
        .he 18,14,18,1C,18,1B,18,14 ; DB 18,14,18,1C,18,1B,18,14
        .he 18,14,18,14,18,14,18,14 ; DB 18,14,18,14,18,14,18,14

;L6774   DB 18,14,17,14,18,19,18,1A
;677C    DB 18,19,18,1A,17,14,18,14
;6784    DB 18,14,18,14,18,1C,18,1B
;678C    DB 18,1C,18,1B,18,14,18,14

L6774   .he 18,14,17,14,18,19,18,1A ; DB 18,14,17,14,18,19,18,1A
        .he 18,19,18,1A,17,14,18,14 ; DB 18,19,18,1A,17,14,18,14
        .he 18,14,18,14,18,1C,18,1B ; DB 18,14,18,14,18,1C,18,1B
        .he 18,1C,18,1B,18,14,18,14 ; DB 18,1C,18,1B,18,14,18,14

;L6794   DB 18,14,18,14,18,14,18,14
;679C    DB 18,14,18,14,18,14,18,14
;67A4    DB 18,14,18,14,18,14,16,14
;67AC    DB 15,14,18,14,18,14,18,14

L6794   .he 18,14,18,14,18,14,18,14 ; DB 18,14,18,14,18,14,18,14
        .he 18,14,18,14,18,14,18,14 ; DB 18,14,18,14,18,14,18,14
        .he 18,14,18,14,18,14,16,14 ; DB 18,14,18,14,18,14,16,14
        .he 15,14,18,14,18,14,18,14 ; DB 15,14,18,14,18,14,18,14

;L67B4   DB 03,0D,04,0D,0E,0B,22,0C
;67BC    DB 23,0B,0E,0C,03,0D,04,0D
;67C4    DB 00,0D,0E,0C,00,0B,00,0D
;67CC    DB 00,0D,00,0C,0E,0B,00,0D

L67B4   .he 03,0D,04,0D,0E,0B,22,0C ; DB 03,0D,04,0D,0E,0B,22,0C
        .he 23,0B,0E,0C,03,0D,04,0D ; DB 23,0B,0E,0C,03,0D,04,0D
        .he 00,0D,0E,0C,00,0B,00,0D ; DB 00,0D,0E,0C,00,0B,00,0D
        .he 00,0D,00,0C,0E,0B,00,0D ; DB 00,0D,00,0C,0E,0B,00,0D

;L67D4   DB 00,0D,00,0D,00,0D,00,0C
;67DC    DB 00,0B,00,0D,00,0D,00,0D
;67E4    DB 0E,0D,00,0D,0E,0C,00,0B
;67EC    DB 0E,0C,00,0B,0E,0D,00,0D

L67D4   .he 00,0D,00,0D,00,0D,00,0C ; DB 00,0D,00,0D,00,0D,00,0C
        .he 00,0B,00,0D,00,0D,00,0D ; DB 00,0B,00,0D,00,0D,00,0D
        .he 0E,0D,00,0D,0E,0C,00,0B ; DB 0E,0D,00,0D,0E,0C,00,0B
        .he 0E,0C,00,0B,0E,0D,00,0D ; DB 0E,0C,00,0B,0E,0D,00,0D


L67F4
SprGfxTable
        .wo sprite_68ea,sprite_79b8,sprite_7a6e,sprite_7b24
        .wo sprite_7bda,sprite_7c90,sprite_7d52,sprite_7e08
        .wo sprite_7e4a,sprite_7e8c,sprite_7ece,sprite_69c4
        .wo sprite_68ea,sprite_68ea,sprite_7f10,sprite_7f72
        .wo sprite_8042,sprite_7fda,sprite_8118,sprite_80a4
        .wo sprite_81fa,sprite_817a,sprite_8268,sprite_82e2
        .wo sprite_834a,sprite_83b2,sprite_841a,sprite_8482
        .wo sprite_84ea,sprite_8546,sprite_85a2,sprite_85fe
        .wo sprite_865a,sprite_86c8,sprite_8736,sprite_87a4
        .wo sprite_8806,sprite_88bc,sprite_8972,sprite_7180
        .wo sprite_7836,sprite_723c,sprite_72d4,sprite_73a8
        .wo sprite_7844,sprite_74f6,sprite_743a,sprite_76ea
        .wo sprite_7038,sprite_70d6,sprite_68ea,sprite_68ea
        .wo sprite_75b2,sprite_78d0,sprite_693e,sprite_68ec
; 56 sprites found

sprite_68ea
        .he 00,00,00 ; total 0 bytes

; mask equals to data

sprite_68ea_data
sprite_68ea_mask

sprite_68ec
        .he 02,14,28 ; total 40 bytes
sprite_68ec_data
        .he 00,00
        .he 68,00
        .he 6c,00
        .he f4,03
        .he fe,0f
        .he fe,1f
        .he cf,3f
        .he d7,ff
        .he b7,ff
        .he cf,7f
        .he 7e,ff
        .he 3e,ff
        .he 3b,7e
        .he 3b,7e
        .he 1d,3e
        .he 19,1e
        .he 10,0f
        .he 10,07
        .he 00,01
        .he 00,00
sprite_68ec_mask
        .he 68,00
        .he fc,00
        .he fe,03
        .he fe,0f
        .he ff,1f
        .he ff,3f
        .he ff,ff
        .he ff,ff
        .he ff,ff
        .he ff,ff
        .he ff,ff
        .he 7f,ff
        .he 7f,ff
        .he 7f,ff
        .he 3f,ff
        .he 3f,bf
        .he 39,1f
        .he 38,0f
        .he 10,07
        .he 00,01

sprite_693e
        .he 03,16,42 ; total 66 bytes
sprite_693e_data
        .he 00,00,00
        .he 06,00,00
        .he c7,80,00
        .he f3,e0,00
        .he f9,c0,00
        .he fc,00,00
        .he fd,d0,00
        .he fd,d8,00
        .he fb,d8,00
        .he 83,de,00
        .he 01,ee,18
        .he 00,ef,2a
        .he 00,6f,2a
        .he 00,6f,b2
        .he 00,3f,b6
        .he 00,3f,b4
        .he 80,3f,a8
        .he e0,7f,78
        .he 79,ff,70
        .he 1f,fc,e0
        .he 03,e1,80
        .he 00,00,00
sprite_693e_mask
        .he 06,00,00
        .he cf,80,00
        .he ff,e0,00
        .he ff,f0,00
        .he ff,f0,00
        .he ff,f0,00
        .he ff,f8,00
        .he ff,fc,00
        .he ff,fe,00
        .he ff,ff,18
        .he ff,ff,3e
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,fe
        .he ff,ff,fe
        .he ff,ff,fc
        .he ff,ff,f8
        .he 7f,ff,f0
        .he 1f,ff,e0
        .he 03,e1,80

sprite_69c4
        .he 04,20,80 ; total 128 bytes
sprite_69c4_data
        .he 00,00,00,00
        .he 00,01,01,00
        .he 05,e2,01,00
        .he 1f,06,07,10
        .he 03,06,04,08
        .he 02,03,04,10
        .he 03,05,38,20
        .he 01,fa,ce,e0
        .he 21,7b,2f,e0
        .he 22,87,e6,e0
        .he 11,78,19,40
        .he 11,70,0e,fe
        .he 1f,a0,06,f0
        .he 01,40,02,e0
        .he 03,40,02,e0
        .he 04,40,02,f0
        .he 0b,c0,02,7e
        .he 3c,40,03,a0
        .he 3f,40,02,40
        .he 21,60,06,e0
        .he 21,b0,0d,f0
        .he 41,b8,1b,98
        .he 03,6f,ed,80
        .he 03,53,15,80
        .he 06,ba,fb,80
        .he 04,7a,ff,d0
        .he 7c,2d,b0,e0
        .he 00,2f,bc,30
        .he 00,e1,b4,18
        .he 03,83,24,00
        .he 06,00,24,00
        .he 00,00,00,00
sprite_69c4_mask
        .he 00,01,01,00
        .he 05,e3,83,80
        .he 1d,f7,07,90
        .he 3f,ef,0f,b8
        .he 1f,8f,0f,1c
        .he 07,07,be,38
        .he 07,ff,fe,f0
        .he 23,ff,ff,f0
        .he 73,ff,ff,f0
        .he 77,ff,ff,f0
        .he 3b,ff,ff,fe
        .he 3f,ff,ff,ff
        .he 3f,ff,ff,fe
        .he 1f,ff,ff,f0
        .he 07,ff,ff,f0
        .he 0f,ff,ff,fe
        .he 3f,ff,ff,ff
        .he 7f,ff,ff,fe
        .he 7f,ff,ff,e0
        .he 7f,ff,ff,f0
        .he 73,ff,ff,f8
        .he e3,ff,ff,fc
        .he 47,ff,ff,d8
        .he 07,ff,ff,c0
        .he 0f,ff,ff,d0
        .he 7f,ff,ff,f8
        .he fe,7f,ff,f0
        .he 7c,ff,fe,f8
        .he 03,ff,fe,3c
        .he 07,e7,fe,18
        .he 0f,83,7e,00
        .he 06,00,24,00

sprite_7038
        .he 03,1a,4e ; total 78 bytes
sprite_7038_data
        .he 00,00,00
        .he 00,38,00
        .he 00,1e,00
        .he 01,a7,00
        .he 03,3b,00
        .he 02,b8,00
        .he 01,b8,00
        .he 01,fc,00
        .he 01,c4,00
        .he 03,38,00
        .he 02,fc,00
        .he 01,fe,00
        .he 03,fe,00
        .he 03,fa,00
        .he 03,fc,00
        .he 1c,ff,00
        .he 3f,7f,80
        .he 3f,83,c0
        .he 3c,e9,d0
        .he 1b,30,50
        .he 0b,dc,38
        .he 07,ee,0c
        .he 07,ef,00
        .he 07,de,00
        .he 03,80,00
        .he 00,00,00
sprite_7038_mask
        .he 00,38,00
        .he 00,7e,00
        .he 01,ff,00
        .he 03,ff,80
        .he 07,ff,80
        .he 07,ff,00
        .he 03,fc,00
        .he 03,fe,00
        .he 03,fe,00
        .he 07,fc,00
        .he 07,fe,00
        .he 03,ff,00
        .he 07,ff,00
        .he 07,ff,00
        .he 1f,ff,00
        .he 3f,ff,80
        .he 7f,ff,c0
        .he 7f,ff,f0
        .he 7f,ff,f8
        .he 3f,fd,f8
        .he 1f,fe,7c
        .he 0f,ff,3e
        .he 0f,ff,8c
        .he 0f,ff,00
        .he 07,de,00
        .he 03,80,00

sprite_70d6
        .he 03,1c,54 ; total 84 bytes
sprite_70d6_data
        .he 00,00,00
        .he 00,0c,00
        .he 00,0f,00
        .he 00,04,80
        .he 01,83,00
        .he 01,e3,80
        .he 00,db,80
        .he 00,3f,80
        .he 00,7f,00
        .he 00,41,00
        .he 00,3e,00
        .he 03,1f,80
        .he 0d,a7,00
        .he 07,39,00
        .he 00,fe,80
        .he 01,3f,40
        .he 01,0f,40
        .he 00,c2,80
        .he 00,a0,00
        .he 00,ff,e0
        .he 03,f3,f0
        .he 07,cd,f0
        .he 07,be,f0
        .he 03,be,e0
        .he 01,dc,00
        .he 00,1c,00
        .he 00,08,00
        .he 00,00,00
sprite_70d6_mask
        .he 00,0c,00
        .he 00,1f,00
        .he 00,1f,80
        .he 01,8f,c0
        .he 03,e7,80
        .he 03,ff,c0
        .he 01,ff,c0
        .he 00,ff,c0
        .he 00,ff,80
        .he 00,ff,80
        .he 03,ff,80
        .he 0f,ff,c0
        .he 1f,ff,80
        .he 0f,ff,80
        .he 07,ff,c0
        .he 03,ff,e0
        .he 03,ff,e0
        .he 01,ff,c0
        .he 01,ff,e0
        .he 03,ff,f0
        .he 07,ff,f8
        .he 0f,ff,f8
        .he 0f,ff,f8
        .he 07,ff,f0
        .he 03,fe,e0
        .he 01,fe,00
        .he 00,3c,00
        .he 00,08,00

sprite_7180
        .he 03,1f,5d ; total 93 bytes
sprite_7180_data
        .he 00,00,00
        .he 00,38,00
        .he 00,7e,00
        .he 00,2f,00
        .he 00,17,80
        .he 00,39,80
        .he 00,b8,00
        .he 00,dd,00
        .he 01,bd,00
        .he 01,7e,80
        .he 03,8e,00
        .he 00,72,00
        .he 03,fc,00
        .he 07,fe,00
        .he 0f,f7,00
        .he 0f,cb,00
        .he 0f,bc,00
        .he 0f,7f,00
        .he 0f,7f,c0
        .he 00,3c,f0
        .he 1f,c0,30
        .he 3f,f3,00
        .he 3f,fb,c0
        .he 3d,fc,c0
        .he 1c,7e,00
        .he 1b,be,00
        .he 0b,df,00
        .he 07,df,00
        .he 03,3e,00
        .he 00,78,00
        .he 00,00,00
sprite_7180_mask
        .he 00,38,00
        .he 00,7e,00
        .he 00,ff,00
        .he 00,7f,80
        .he 00,3f,c0
        .he 00,ff,c0
        .he 01,ff,80
        .he 01,ff,80
        .he 03,ff,80
        .he 03,ff,c0
        .he 07,ff,80
        .he 03,ff,00
        .he 07,fe,00
        .he 0f,ff,00
        .he 1f,ff,80
        .he 1f,ff,80
        .he 1f,ff,00
        .he 1f,ff,c0
        .he 1f,ff,f0
        .he 1f,ff,f8
        .he 3f,ff,f8
        .he 7f,ff,f0
        .he 7f,ff,e0
        .he 7f,ff,e0
        .he 3f,ff,c0
        .he 3f,ff,00
        .he 1f,ff,80
        .he 0f,ff,80
        .he 07,ff,00
        .he 03,fe,00
        .he 00,78,00

sprite_723c
        .he 03,19,4b ; total 75 bytes
sprite_723c_data
        .he 00,00,00
        .he 00,fe,00
        .he 03,ff,80
        .he 07,f7,c0
        .he 0f,c6,e0
        .he 1f,38,70
        .he 1f,fb,30
        .he 1f,fb,30
        .he 1f,fb,50
        .he 1f,f7,50
        .he 0f,c2,d0
        .he 0f,b4,30
        .he 07,ae,e0
        .he 07,dd,e0
        .he 03,ab,c0
        .he 01,f0,c0
        .he 01,1f,80
        .he 00,ee,00
        .he 01,f4,c0
        .he 01,fb,00
        .he 03,39,e0
        .he 02,cc,00
        .he 01,f4,00
        .he 00,f8,00
        .he 00,00,00
sprite_723c_mask
        .he 00,fe,00
        .he 03,ff,80
        .he 07,ff,c0
        .he 0f,ff,e0
        .he 1f,ff,f0
        .he 3f,ff,f8
        .he 3f,ff,f8
        .he 3f,ff,f8
        .he 3f,ff,f8
        .he 3f,ff,f8
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 0f,ff,f0
        .he 0f,ff,f0
        .he 07,ff,e0
        .he 03,ff,e0
        .he 03,ff,c0
        .he 01,ff,c0
        .he 03,ff,e0
        .he 03,ff,e0
        .he 07,ff,f0
        .he 07,ff,e0
        .he 03,fe,00
        .he 01,fc,00
        .he 00,f8,00

sprite_72d4
        .he 03,23,69 ; total 105 bytes
sprite_72d4_data
        .he 00,00,00
        .he 00,1e,00
        .he 00,1f,00
        .he 00,9d,00
        .he 00,bf,00
        .he 00,9f,00
        .he 01,b7,00
        .he 00,9f,00
        .he 01,9f,00
        .he 00,97,00
        .he 00,9e,00
        .he 00,9d,c8
        .he 00,9b,f0
        .he 01,d4,78
        .he 00,97,28
        .he 00,bb,dc
        .he 0a,9c,6e
        .he 06,97,2c
        .he 0e,9f,2c
        .he 5e,9d,ac
        .he 36,cf,2a
        .he 2d,9f,6c
        .he 6e,9b,2e
        .he 46,9f,ac
        .he 5c,9d,2c
        .he 5c,bf,58
        .he 5c,97,08
        .he 5c,df,00
        .he 5d,9b,80
        .he 54,9f,00
        .he 5c,ce,00
        .he 6d,6e,00
        .he 38,2c,00
        .he 24,42,00
        .he 00,00,00
sprite_72d4_mask
        .he 00,1e,00
        .he 00,7f,00
        .he 00,ff,80
        .he 01,ff,80
        .he 01,ff,80
        .he 01,ff,80
        .he 03,ff,80
        .he 01,ff,80
        .he 03,ff,80
        .he 01,ff,80
        .he 01,ff,c8
        .he 01,ff,fc
        .he 01,ff,f8
        .he 03,ff,fc
        .he 01,ff,fc
        .he 0b,ff,fe
        .he 1f,ff,ff
        .he 1f,ff,fe
        .he 5f,ff,fe
        .he ff,ff,fe
        .he 7f,ff,ff
        .he 7f,ff,fe
        .he ff,ff,ff
        .he ff,ff,fe
        .he ff,ff,fe
        .he ff,ff,fc
        .he ff,ff,dc
        .he ff,ff,88
        .he ff,ff,c0
        .he ff,ff,80
        .he ff,ff,00
        .he ff,ff,00
        .he 7d,fe,00
        .he 7e,ff,00
        .he 24,42,00

sprite_73a8
        .he 03,18,48 ; total 72 bytes
sprite_73a8_data
        .he 00,00,00
        .he 00,f0,00
        .he 07,0e,00
        .he 0c,98,00
        .he 19,30,20
        .he 31,60,60
        .he 32,21,c4
        .he 26,7f,88
        .he 6c,ce,18
        .he 7d,80,30
        .he 5b,3c,60
        .he 5a,01,c0
        .he 5f,ff,82
        .he 6c,7e,02
        .he 3b,a3,9c
        .he 39,de,70
        .he 16,d0,02
        .he 6f,50,c2
        .he 0f,3f,04
        .he 36,ec,0c
        .he 21,80,38
        .he 08,ff,f0
        .he 02,3f,80
        .he 00,00,00
sprite_73a8_mask
        .he 00,f0,00
        .he 07,fe,00
        .he 0f,ff,00
        .he 1f,fe,20
        .he 3f,f8,70
        .he 7f,f1,f4
        .he 7f,ff,ee
        .he 7f,ff,dc
        .he ff,ff,bc
        .he ff,fe,78
        .he ff,ff,f0
        .he ff,ff,e2
        .he ff,ff,c7
        .he ff,ff,9f
        .he 7f,ff,fe
        .he 7f,ff,fe
        .he 7f,ff,f7
        .he ff,ff,e7
        .he 7f,ff,ce
        .he 7f,ff,3e
        .he 7f,ff,fc
        .he 3f,ff,f8
        .he 0f,ff,f0
        .he 02,3f,80

sprite_743a
        .he 03,1f,5d ; total 93 bytes
sprite_743a_data
        .he 00,00,00
        .he 00,03,00
        .he 01,cf,80
        .he 03,bf,60
        .he 0f,8f,30
        .he 19,ce,30
        .he 1d,ce,70
        .he 1c,ce,e0
        .he 0e,ec,e0
        .he 0f,6d,e0
        .he 07,6d,c0
        .he 03,ff,c0
        .he 01,ff,80
        .he 00,e1,b0
        .he 01,5e,70
        .he 01,3f,60
        .he 01,a2,80
        .he 00,1c,e0
        .he 01,be,e0
        .he 03,ff,e0
        .he 01,c3,c0
        .he 00,bd,80
        .he 00,7e,00
        .he 00,e3,00
        .he 00,dd,80
        .he 00,a5,c0
        .he 00,35,c0
        .he 00,3b,c0
        .he 00,37,80
        .he 00,0f,00
        .he 00,00,00
sprite_743a_mask
        .he 00,03,00
        .he 01,cf,80
        .he 03,ff,e0
        .he 0f,ff,f0
        .he 1f,ff,f8
        .he 3f,ff,f8
        .he 3f,ff,f8
        .he 3f,ff,f0
        .he 1f,ff,f0
        .he 1f,ff,f0
        .he 0f,ff,e0
        .he 07,ff,e0
        .he 03,ff,f0
        .he 01,ff,f8
        .he 03,ff,f8
        .he 03,ff,f0
        .he 03,ff,e0
        .he 01,ff,f0
        .he 03,ff,f0
        .he 07,ff,f0
        .he 03,ff,e0
        .he 01,ff,c0
        .he 00,ff,80
        .he 01,ff,80
        .he 01,ff,c0
        .he 01,ff,e0
        .he 00,ff,e0
        .he 00,7f,e0
        .he 00,7f,c0
        .he 00,3f,80
        .he 00,0f,00

sprite_74f6
        .he 03,1f,5d ; total 93 bytes
sprite_74f6_data
        .he 00,00,00
        .he 00,03,00
        .he 01,cf,80
        .he 03,bf,60
        .he 0f,8f,30
        .he 19,ce,30
        .he 1d,ce,70
        .he 1c,ce,e0
        .he 0e,ec,e0
        .he 0f,6d,e0
        .he 07,6d,40
        .he 03,fe,80
        .he 01,fe,c0
        .he 00,e1,60
        .he 0c,4c,60
        .he 0f,3f,00
        .he 06,7e,e0
        .he 01,be,e0
        .he 03,bf,f0
        .he 03,ff,e0
        .he 01,e3,c0
        .he 00,c1,80
        .he 00,00,20
        .he 00,42,20
        .he 00,96,20
        .he 00,98,40
        .he 00,81,80
        .he 00,7e,60
        .he 00,01,e0
        .he 00,03,c0
        .he 00,00,00
sprite_74f6_mask
        .he 00,03,00
        .he 01,cf,80
        .he 03,ff,e0
        .he 0f,ff,f0
        .he 1f,ff,f8
        .he 3f,ff,f8
        .he 3f,ff,f8
        .he 3f,ff,f0
        .he 1f,ff,f0
        .he 1f,ff,f0
        .he 0f,ff,e0
        .he 07,ff,c0
        .he 03,ff,e0
        .he 0d,ff,f0
        .he 1f,ff,f0
        .he 1f,ff,e0
        .he 0f,ff,f0
        .he 07,ff,f8
        .he 07,ff,f8
        .he 07,ff,f0
        .he 03,ff,e0
        .he 01,ff,e0
        .he 00,ff,f0
        .he 00,ff,f0
        .he 01,ff,f0
        .he 01,ff,e0
        .he 01,ff,e0
        .he 00,ff,f0
        .he 00,7f,f0
        .he 00,07,e0
        .he 00,03,c0

sprite_75b2
        .he 05,1f,9b ; total 155 bytes
sprite_75b2_data
        .he 00,00,00,00,00
        .he 01,40,00,00,00
        .he 05,40,0c,00,00
        .he 05,40,1f,00,00
        .he 05,c0,1f,80,00
        .he 06,cf,8f,c0,00
        .he 03,5f,ef,80,00
        .he 01,ef,ee,00,00
        .he 00,77,de,80,00
        .he 01,f7,be,60,00
        .he 01,d7,7e,f0,00
        .he 00,ec,fd,f4,00
        .he 00,7b,fd,34,00
        .he 00,37,fb,d6,00
        .he 00,57,f7,d7,08
        .he 00,0f,ff,db,5c
        .he 00,4f,ff,db,fe
        .he 00,70,ff,aa,fe
        .he 00,6c,0f,77,fe
        .he 00,03,84,3b,9c
        .he 00,00,78,5d,5c
        .he 00,00,07,ed,68
        .he 00,00,00,75,98
        .he 00,00,00,3f,f0
        .he 00,00,00,1b,e0
        .he 00,00,00,0d,c0
        .he 00,00,00,0d,c0
        .he 00,00,00,19,c0
        .he 00,00,00,18,80
        .he 00,00,00,10,80
        .he 00,00,00,10,00
sprite_75b2_mask
        .he 01,40,00,00,00
        .he 07,e0,0c,00,00
        .he 0f,e0,1f,00,00
        .he 0f,e0,3f,80,00
        .he 0f,ef,bf,c0,00
        .he 0f,ff,ff,e0,00
        .he 07,ff,ff,c0,00
        .he 03,ff,ff,80,00
        .he 01,ff,ff,e0,00
        .he 03,ff,ff,f0,00
        .he 03,ff,ff,fc,00
        .he 01,ff,ff,fe,00
        .he 00,ff,ff,fe,00
        .he 00,7f,ff,ff,08
        .he 00,ff,ff,ff,dc
        .he 00,7f,ff,ff,fe
        .he 00,ff,ff,ff,ff
        .he 00,ff,ff,ff,ff
        .he 00,ff,ff,ff,ff
        .he 00,6f,ff,ff,fe
        .he 00,03,ff,ff,fe
        .he 00,00,7f,ff,fc
        .he 00,00,07,ff,fc
        .he 00,00,00,7f,f8
        .he 00,00,00,3f,f0
        .he 00,00,00,1f,e0
        .he 00,00,00,1f,e0
        .he 00,00,00,3f,e0
        .he 00,00,00,3d,c0
        .he 00,00,00,39,c0
        .he 00,00,00,38,80

sprite_76ea
        .he 05,21,a5 ; total 165 bytes
sprite_76ea_data
        .he 00,00,00,00,00
        .he 00,00,38,00,00
        .he 00,00,7c,04,00
        .he 00,00,7e,0e,00
        .he 00,00,3e,07,38
        .he 00,00,1f,03,fc
        .he 00,00,1f,07,fe
        .he 00,00,0f,cf,fe
        .he 00,00,0f,ef,fe
        .he 00,00,0f,ff,fe
        .he 00,00,1f,ff,f8
        .he 00,00,7f,ff,fc
        .he 30,01,ff,fe,6e
        .he 78,07,ff,fe,04
        .he 7e,7f,ff,ff,00
        .he 3f,ff,ff,ff,c0
        .he 1f,ff,ff,ff,f0
        .he 0f,ff,ff,f9,fc
        .he 07,e0,3f,e0,7e
        .he 00,00,1f,80,1e
        .he 00,00,1f,00,04
        .he 00,00,1f,00,00
        .he 00,00,3e,00,00
        .he 00,00,3e,00,00
        .he 00,00,7e,00,00
        .he 00,00,7c,00,00
        .he 00,00,fc,00,00
        .he 00,00,f8,00,00
        .he 00,01,f8,00,00
        .he 00,01,ff,00,00
        .he 00,00,ff,80,00
        .he 00,00,1f,80,00
        .he 00,00,00,00,00
sprite_76ea_mask
        .he 00,00,38,00,00
        .he 00,00,7c,04,00
        .he 00,00,fe,0e,00
        .he 00,00,ff,1f,38
        .he 00,00,7f,0f,fc
        .he 00,00,3f,87,fe
        .he 00,00,3f,cf,ff
        .he 00,00,1f,ff,ff
        .he 00,00,1f,ff,ff
        .he 00,00,1f,ff,ff
        .he 00,00,7f,ff,fe
        .he 30,01,ff,ff,fe
        .he 78,07,ff,ff,ff
        .he fe,7f,ff,ff,6e
        .he ff,ff,ff,ff,c4
        .he 7f,ff,ff,ff,f0
        .he 3f,ff,ff,ff,fc
        .he 1f,ff,ff,ff,fe
        .he 0f,ff,ff,f9,ff
        .he 07,e0,3f,e0,7f
        .he 00,00,3f,80,1e
        .he 00,00,3f,80,04
        .he 00,00,7f,00,00
        .he 00,00,7f,00,00
        .he 00,00,ff,00,00
        .he 00,00,fe,00,00
        .he 00,01,fe,00,00
        .he 00,01,fc,00,00
        .he 00,03,ff,00,00
        .he 00,03,ff,80,00
        .he 00,01,ff,c0,00
        .he 00,00,ff,c0,00
        .he 00,00,1f,80,00

sprite_7836
        .he 01,06,06 ; total 6 bytes
sprite_7836_data
        .he 00
        .he 60
        .he 78
        .he 1e
        .he 06
        .he 00
sprite_7836_mask
        .he 60
        .he f8
        .he fe
        .he 7f
        .he 1f
        .he 06

sprite_7844
        .he 03,17,45 ; total 69 bytes
sprite_7844_data
        .he 00,00,00
        .he 00,10,00
        .he 00,10,00
        .he 00,10,00
        .he 00,7c,00
        .he 01,93,00
        .he 02,10,80
        .he 04,10,40
        .he 04,00,40
        .he 08,00,20
        .he 08,00,20
        .he 7f,01,fc
        .he 08,00,20
        .he 08,00,20
        .he 04,00,40
        .he 04,10,40
        .he 02,10,80
        .he 01,93,00
        .he 00,7c,00
        .he 00,10,00
        .he 00,10,00
        .he 00,10,00
        .he 00,00,00
sprite_7844_mask
        .he 00,10,00
        .he 00,38,00
        .he 00,38,00
        .he 00,7c,00
        .he 01,ff,00
        .he 03,ff,80
        .he 07,bb,c0
        .he 0e,38,e0
        .he 0e,10,e0
        .he 1c,00,70
        .he 7f,01,fc
        .he ff,83,fe
        .he 7f,01,fc
        .he 1c,00,70
        .he 0e,10,e0
        .he 0e,38,e0
        .he 07,bb,c0
        .he 03,ff,80
        .he 01,ff,00
        .he 00,7c,00
        .he 00,38,00
        .he 00,38,00
        .he 00,10,00

sprite_78d0
        .he 05,17,73 ; total 115 bytes
sprite_78d0_data
        .he 00,00,00,00,00
        .he 34,00,00,00,00
        .he 36,00,06,00,00
        .he 7a,03,87,80,00
        .he 7f,0f,e3,e0,00
        .he 7f,1f,f1,e0,00
        .he 67,bf,7d,c0,00
        .he 6b,fe,bd,98,00
        .he 5b,9d,dd,98,00
        .he 66,62,c0,58,00
        .he 3e,79,8f,58,00
        .he 3f,9f,ff,9c,18
        .he 3d,a7,3f,9c,2a
        .he 1d,b1,7f,a6,aa
        .he 0e,b6,ff,79,ba
        .he 0c,af,7e,fd,b6
        .he 08,0f,ff,fd,b4
        .he 08,0f,0f,fb,a6
        .he 00,07,cf,f7,78
        .he 00,03,83,ef,70
        .he 00,01,00,de,e0
        .he 00,00,00,3d,80
        .he 00,00,00,0c,00
sprite_78d0_mask
        .he 34,00,00,00,00
        .he 7e,00,06,00,00
        .he 7f,03,8f,80,00
        .he ff,0f,ef,e0,00
        .he ff,9f,ff,f0,00
        .he ff,bf,ff,f0,00
        .he ff,ff,ff,f8,00
        .he ff,ff,ff,fc,00
        .he ff,ff,ff,fc,00
        .he ff,ff,ff,fc,00
        .he 7f,ff,ff,fc,18
        .he 7f,ff,ff,fe,3e
        .he 7f,ff,ff,fe,ff
        .he 3f,ff,ff,ff,ff
        .he 1f,ff,ff,ff,ff
        .he 1f,ff,ff,ff,ff
        .he 1c,bf,ff,ff,fe
        .he 1c,1f,ff,ff,fe
        .he 08,0f,ff,ff,fc
        .he 00,07,cf,ff,f8
        .he 00,03,83,ff,f0
        .he 00,01,00,ff,e0
        .he 00,00,00,3f,80

sprite_79b8
        .he 03,1e,5a ; total 90 bytes
sprite_79b8_data
        .he 00,00,00
        .he 00,03,00
        .he 00,03,00
        .he 00,03,00
        .he 00,03,80
        .he 00,01,80
        .he 02,01,80
        .he 02,01,c0
        .he 0a,23,c0
        .he 0a,23,e0
        .he 0b,67,e0
        .he 27,c1,c0
        .he 1f,c6,40
        .he 0f,cf,80
        .he 03,cf,40
        .he 01,8c,00
        .he 00,60,00
        .he 01,e0,00
        .he 07,90,00
        .he 03,78,00
        .he 01,ff,00
        .he 01,ff,00
        .he 00,ff,00
        .he 00,ff,00
        .he 00,7f,00
        .he 00,3f,00
        .he 00,0f,00
        .he 00,03,00
        .he 00,00,00
        .he 00,00,00
sprite_79b8_mask
        .he 00,03,00
        .he 00,07,80
        .he 00,07,80
        .he 00,07,80
        .he 00,07,c0
        .he 02,03,c0
        .he 07,03,c0
        .he 0f,23,e0
        .he 1f,77,e0
        .he 1f,77,f0
        .he 3f,ff,f0
        .he 7f,e7,e0
        .he 3f,ff,e0
        .he 1f,ff,c0
        .he 0f,ff,e0
        .he 03,ff,40
        .he 01,fc,00
        .he 07,f0,00
        .he 0f,f8,00
        .he 07,ff,00
        .he 03,ff,00
        .he 03,ff,00
        .he 01,ff,00
        .he 01,ff,00
        .he 00,ff,00
        .he 00,7f,00
        .he 00,3f,00
        .he 00,0f,00
        .he 00,03,00
        .he 00,00,00

sprite_7a6e
        .he 03,1e,5a ; total 90 bytes
sprite_7a6e_data
        .he 00,00,00
        .he 00,03,00
        .he 00,03,00
        .he 00,03,00
        .he 00,03,80
        .he 00,01,80
        .he 00,01,80
        .he 00,01,c0
        .he 00,03,c0
        .he 00,03,e0
        .he 00,03,e0
        .he 00,05,c0
        .he 00,1a,40
        .he 00,2a,80
        .he 00,3e,40
        .he 00,3f,c0
        .he 00,7f,80
        .he 01,7e,00
        .he 01,b8,00
        .he 01,c4,00
        .he 02,f9,00
        .he 03,31,00
        .he 07,cb,00
        .he 07,ff,00
        .he 07,ff,00
        .he 07,ff,00
        .he 03,ff,00
        .he 01,ff,00
        .he 00,fe,00
        .he 00,00,00
sprite_7a6e_mask
        .he 00,03,00
        .he 00,07,80
        .he 00,07,80
        .he 00,07,80
        .he 00,07,c0
        .he 00,03,0c
        .he 00,03,c0
        .he 00,03,e0
        .he 00,07,e0
        .he 00,07,e0
        .he 00,07,f0
        .he 00,1f,e0
        .he 00,3f,e0
        .he 00,7f,c0
        .he 00,7f,e0
        .he 00,7f,e0
        .he 01,ff,c0
        .he 03,ff,80
        .he 03,ff,00
        .he 03,ff,00
        .he 07,ff,00
        .he 07,ff,00
        .he 0f,ff,00
        .he 0f,ff,00
        .he 0f,ff,00
        .he 0f,ff,00
        .he 07,ff,00
        .he 03,ff,00
        .he 01,ff,00
        .he 00,fe,00

sprite_7b24
        .he 03,1e,5a ; total 90 bytes
sprite_7b24_data
        .he 00,00,00
        .he 00,03,00
        .he 00,03,00
        .he 00,03,00
        .he 00,03,80
        .he 00,01,80
        .he 00,01,80
        .he 00,01,c0
        .he 00,03,c0
        .he 00,03,e0
        .he 00,03,e0
        .he 00,01,c0
        .he 00,0a,40
        .he 00,2b,20
        .he 00,2b,e0
        .he 00,5c,a0
        .he 00,7f,b0
        .he 00,3f,00
        .he 00,fc,00
        .he 03,7c,00
        .he 03,81,00
        .he 05,f9,00
        .he 06,ef,00
        .he 07,0f,00
        .he 0f,ef,00
        .he 0f,df,00
        .he 0f,ff,00
        .he 07,ff,00
        .he 03,f0,00
        .he 00,00,00
sprite_7b24_mask
        .he 00,03,00
        .he 00,07,80
        .he 00,07,80
        .he 00,07,80
        .he 00,07,c0
        .he 00,03,c0
        .he 00,03,c0
        .he 00,03,e0
        .he 00,07,e0
        .he 00,07,f0
        .he 00,07,f0
        .he 00,0f,e0
        .he 00,3f,e0
        .he 00,7f,f0
        .he 00,7f,f0
        .he 00,ff,f0
        .he 00,ff,f8
        .he 00,ff,b0
        .he 03,ff,00
        .he 07,ff,00
        .he 07,ff,00
        .he 0f,ff,00
        .he 0f,ff,00
        .he 0f,ff,00
        .he 1f,ff,00
        .he 1f,ff,00
        .he 1f,ff,00
        .he 0f,ff,00
        .he 07,ff,00
        .he 03,f0,00

sprite_7bda
        .he 03,1e,5a ; total 90 bytes
sprite_7bda_data
        .he 00,00,00
        .he 00,03,00
        .he 00,03,00
        .he 00,03,00
        .he 00,03,80
        .he 00,01,80
        .he 00,01,80
        .he 00,01,c0
        .he 00,03,c0
        .he 00,03,e0
        .he 00,03,e0
        .he 00,01,c0
        .he 00,02,40
        .he 00,03,00
        .he 00,27,00
        .he 00,a6,00
        .he 01,6e,00
        .he 05,ac,00
        .he 05,ac,00
        .he 0e,fe,00
        .he 07,01,00
        .he 1b,ef,00
        .he 1c,df,00
        .he 1f,5f,00
        .he 3f,bf,00
        .he 3f,ff,00
        .he 3f,ff,00
        .he 1f,ff,00
        .he 0f,fe,00
        .he 00,00,00
sprite_7bda_mask
        .he 00,03,00
        .he 00,07,80
        .he 00,07,80
        .he 00,07,80
        .he 00,07,c0
        .he 00,03,c0
        .he 00,03,c0
        .he 00,03,e0
        .he 00,07,e0
        .he 00,07,f0
        .he 00,07,f0
        .he 00,03,e0
        .he 00,07,e0
        .he 00,27,c0
        .he 00,ff,80
        .he 01,ff,00
        .he 07,ff,00
        .he 0f,fe,00
        .he 0f,fe,00
        .he 1f,ff,00
        .he 1f,ff,00
        .he 3f,ff,00
        .he 3f,ff,00
        .he 3f,ff,00
        .he 7f,ff,00
        .he 7f,ff,00
        .he 7f,ff,00
        .he 3f,ff,00
        .he 1f,ff,00
        .he 0f,fe,00

sprite_7c90
        .he 03,20,60 ; total 96 bytes
sprite_7c90_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,03,00
        .he 00,03,00
        .he 00,03,00
        .he 00,03,80
        .he 00,01,80
        .he 00,01,80
        .he 00,01,c0
        .he 00,03,c0
        .he 00,03,e0
        .he 00,03,e0
        .he 00,01,c0
        .he 02,00,30
        .he 07,41,b0
        .he 1d,27,c0
        .he 2e,ff,00
        .he 2f,fc,00
        .he 67,f0,00
        .he 70,60,00
        .he 7f,80,00
        .he 7e,f1,00
        .he 7d,ff,00
        .he 7f,ff,00
        .he 3f,ff,00
        .he 0f,ff,00
        .he 03,ff,00
        .he 00,ff,00
        .he 00,3f,00
        .he 00,0e,00
        .he 00,00,00
sprite_7c90_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,03,00
        .he 00,07,80
        .he 00,07,80
        .he 00,07,80
        .he 00,07,c0
        .he 00,03,c0
        .he 00,03,c0
        .he 00,03,e0
        .he 00,07,e0
        .he 00,07,f0
        .he 00,07,f0
        .he 02,03,f0
        .he 07,c1,f8
        .he 1f,e7,f8
        .he 3f,ff,f0
        .he 7f,ff,c0
        .he 7f,ff,00
        .he ff,fc,00
        .he ff,f0,00
        .he ff,f1,00
        .he ff,ff,00
        .he ff,ff,00
        .he ff,ff,00
        .he 7f,ff,00
        .he 3f,ff,00
        .he 0f,ff,00
        .he 03,ff,00
        .he 00,ff,00
        .he 00,3f,00
        .he 00,0e,00

sprite_7d52
        .he 03,1e,5a ; total 90 bytes
sprite_7d52_data
        .he 00,00,00
        .he 00,03,00
        .he 00,03,00
        .he 00,03,00
        .he 00,02,00
        .he 00,00,00
        .he 00,01,80
        .he 00,00,00
        .he 00,03,c0
        .he 00,02,00
        .he 00,03,c0
        .he 00,1a,00
        .he 00,39,80
        .he 00,1a,40
        .he 00,5a,40
        .he 00,ed,80
        .he 00,ee,00
        .he 01,f3,80
        .he 01,fc,00
        .he 00,fe,00
        .he 00,ff,00
        .he 00,7f,00
        .he 00,7f,00
        .he 00,3f,00
        .he 00,1f,00
        .he 00,0f,00
        .he 00,07,00
        .he 00,03,00
        .he 00,00,00
        .he 00,00,00
sprite_7d52_mask
        .he 00,03,00
        .he 00,07,80
        .he 00,07,80
        .he 00,07,80
        .he 00,07,80
        .he 00,03,80
        .he 00,03,c0
        .he 00,03,c0
        .he 00,07,e0
        .he 00,07,c0
        .he 00,1f,e0
        .he 00,3f,c0
        .he 00,7f,c0
        .he 00,7f,e0
        .he 00,ff,e0
        .he 01,ff,c0
        .he 01,ff,c0
        .he 03,ff,c0
        .he 03,ff,80
        .he 01,ff,00
        .he 01,ff,00
        .he 00,ff,00
        .he 00,ff,00
        .he 00,7f,00
        .he 00,3f,00
        .he 00,1f,00
        .he 00,0f,00
        .he 00,07,00
        .he 00,03,00
        .he 00,00,00

sprite_7e08
        .he 02,10,20 ; total 32 bytes
sprite_7e08_data
        .he 00,00
        .he 00,00
        .he 04,00
        .he 02,80
        .he 00,80
        .he 19,c0
        .he 06,64
        .he 05,b8
        .he 0d,a0
        .he 12,40
        .he 07,e0
        .he 05,30
        .he 00,00
        .he 00,00
        .he 00,00
        .he 00,00
sprite_7e08_mask
        .he 00,00
        .he 04,00
        .he 0e,80
        .he 07,c0
        .he 1b,c0
        .he 3f,e4
        .he 1f,fe
        .he 0f,fc
        .he 1f,f8
        .he 3f,e0
        .he 1f,f0
        .he 0f,f8
        .he 05,30
        .he 00,00
        .he 00,00
        .he 00,00

sprite_7e4a
        .he 02,10,20 ; total 32 bytes
sprite_7e4a_data
        .he 00,00
        .he 04,80
        .he 02,80
        .he 02,44
        .he 04,c8
        .he 1b,d8
        .he 3a,60
        .he 05,b8
        .he 0d,a6
        .he 32,71
        .he 03,38
        .he 02,44
        .he 04,c0
        .he 00,80
        .he 00,40
        .he 00,00
sprite_7e4a_mask
        .he 04,80
        .he 0f,c0
        .he 07,c4
        .he 07,ee
        .he 1f,fc
        .he 3f,fc
        .he 7f,f8
        .he 3f,fe
        .he 3f,ff
        .he 7f,ff
        .he 37,fd
        .he 07,fe
        .he 0f,e4
        .he 05,c0
        .he 00,e0
        .he 00,40

sprite_7e8c
        .he 02,10,20 ; total 32 bytes
sprite_7e8c_data
        .he 00,00
        .he 00,00
        .he 00,00
        .he 00,00
        .he 04,80
        .he 00,20
        .he 01,80
        .he 0b,c0
        .he 02,d0
        .he 01,80
        .he 00,20
        .he 04,80
        .he 00,00
        .he 00,00
        .he 00,00
        .he 00,00
sprite_7e8c_mask
        .he 00,00
        .he 00,00
        .he 00,00
        .he 04,80
        .he 0f,e0
        .he 05,f0
        .he 0f,e0
        .he 1f,f0
        .he 0f,f8
        .he 03,f0
        .he 07,f0
        .he 0f,e0
        .he 04,80
        .he 00,00
        .he 00,00
        .he 00,00

sprite_7ece
        .he 02,10,20 ; total 32 bytes
sprite_7ece_data
        .he 00,00
        .he 00,00
        .he 01,08
        .he 11,10
        .he 08,00
        .he 00,00
        .he 01,80
        .he 33,cc
        .he 02,c0
        .he 01,80
        .he 00,00
        .he 08,10
        .he 10,08
        .he 00,80
        .he 00,80
        .he 00,00
sprite_7ece_mask
        .he 00,00
        .he 01,08
        .he 13,9c
        .he 3b,b8
        .he 1d,10
        .he 08,80
        .he 33,cc
        .he 38,fe
        .he 37,ec
        .he 03,c0
        .he 09,90
        .he 1c,38
        .he 38,9c
        .he 11,c8
        .he 01,c0
        .he 00,80

sprite_7f10
        .he 03,10,30 ; total 48 bytes
sprite_7f10_data
        .he 00,00,00
        .he 00,00,00
        .he 0f,00,00
        .he 1f,c0,00
        .he 3f,f1,80
        .he 7f,fc,80
        .he 7e,1f,00
        .he 7d,ef,80
        .he 7b,f7,c0
        .he 3b,fb,e0
        .he 0b,fb,e0
        .he 03,fb,c0
        .he 03,fb,80
        .he 01,b8,00
        .he 00,30,00
        .he 00,00,00
sprite_7f10_mask
        .he 00,00,00
        .he 0f,00,00
        .he 1f,f0,00
        .he 3f,fb,80
        .he 7f,ff,c0
        .he ff,ff,c0
        .he ff,ff,80
        .he ff,ff,c0
        .he ff,ff,e0
        .he 7f,ff,f0
        .he 3f,ff,f0
        .he 0f,ff,e0
        .he 07,ff,c0
        .he 03,ff,80
        .he 01,f8,00
        .he 00,30,00

sprite_7f72
        .he 03,11,33 ; total 51 bytes
sprite_7f72_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,08
        .he 00,00,04
        .he 00,00,02
        .he 00,30,02
        .he 04,34,02
        .he 08,4c,04
        .he 10,60,08
        .he 10,00,30
        .he 08,00,c0
        .he 06,07,30
        .he 01,f8,f0
        .he 00,0f,f0
        .he 00,07,c0
        .he 00,03,80
        .he 00,00,00
sprite_7f72_mask
        .he 00,00,00
        .he 00,00,08
        .he 00,30,1c
        .he 00,7c,1e
        .he 00,ff,3f
        .he 07,ff,ff
        .he 0f,ff,ff
        .he 1f,ff,fe
        .he 3f,ff,fc
        .he 3f,ff,f8
        .he 1f,ff,f8
        .he 0f,ff,f8
        .he 07,ff,f8
        .he 01,ff,f8
        .he 00,0f,f0
        .he 00,07,e0
        .he 00,03,80

sprite_7fda
        .he 03,11,33 ; total 51 bytes
sprite_7fda_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,0c
        .he 00,0e,02
        .he 00,19,02
        .he 04,22,22
        .he 08,0b,42
        .he 10,18,42
        .he 10,41,84
        .he 10,3e,18
        .he 08,00,60
        .he 04,03,90
        .he 03,fc,60
        .he 00,03,e0
        .he 00,01,c0
        .he 00,00,00
sprite_7fda_mask
        .he 00,20,00
        .he 00,30,00
        .he 00,7c,0c
        .he 00,ff,3e
        .he 00,ff,ff
        .he 07,ff,ff
        .he 0f,ff,ff
        .he 1f,ff,ff
        .he 3f,ff,ff
        .he 3f,ff,fe
        .he 3f,ff,fc
        .he 1f,ff,f8
        .he 0f,ff,f8
        .he 07,ff,f0
        .he 03,ff,f0
        .he 00,03,e0
        .he 00,01,c0

sprite_8042
        .he 03,10,30 ; total 48 bytes
sprite_8042_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 1f,c0,00
        .he 3f,f0,00
        .he 7c,7c,00
        .he 7b,9f,00
        .he 77,e7,c0
        .he 74,7b,e0
        .he 37,9d,e0
        .he 17,eb,f0
        .he 07,f3,f0
        .he 03,f7,f0
        .he 01,cf,e0
        .he 00,1f,80
        .he 00,00,00
sprite_8042_mask
        .he 00,00,00
        .he 00,00,00
        .he 1f,c0,00
        .he 3f,f0,00
        .he 7f,fc,00
        .he ff,ff,00
        .he ff,ff,c0
        .he ff,ff,e0
        .he ff,ff,f0
        .he 7f,ff,f0
        .he 3f,ff,f8
        .he 1f,ff,f8
        .he 07,ff,f8
        .he 03,ff,f0
        .he 01,ff,e0
        .he 00,1f,80

sprite_80a4
        .he 03,13,39 ; total 57 bytes
sprite_80a4_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,1e,10
        .he 00,3d,8c
        .he 00,7c,8a
        .he 00,60,4a
        .he 02,00,0a
        .he 04,3a,12
        .he 04,06,64
        .he 04,11,88
        .he 06,06,10
        .he 03,f8,60
        .he 02,01,90
        .he 01,fe,70
        .he 00,01,f0
        .he 00,00,f0
        .he 00,00,60
        .he 00,00,00
sprite_80a4_mask
        .he 00,40,00
        .he 00,30,00
        .he 00,7c,10
        .he 00,ff,3c
        .he 00,ff,fe
        .he 00,ff,ff
        .he 03,ff,ff
        .he 07,ff,ff
        .he 0f,ff,ff
        .he 0f,ff,fe
        .he 0f,ff,fc
        .he 0f,ff,f8
        .he 07,ff,f8
        .he 07,ff,f8
        .he 03,ff,f8
        .he 01,ff,f8
        .he 00,01,f8
        .he 00,00,f0
        .he 00,00,60

sprite_8118
        .he 03,10,30 ; total 48 bytes
sprite_8118_data
        .he 00,00,00
        .he 00,00,00
        .he 0f,c0,00
        .he 10,f0,00
        .he 2f,1c,00
        .he 7f,e7,00
        .he 5e,3b,80
        .he 6d,cd,c0
        .he 75,f6,e0
        .he 3b,f7,60
        .he 1b,f7,b0
        .he 07,ee,b0
        .he 03,e1,a0
        .he 03,ff,e0
        .he 01,9f,c0
        .he 00,00,00
sprite_8118_mask
        .he 00,00,00
        .he 0f,c0,00
        .he 1f,f0,00
        .he 3f,fc,00
        .he 7f,ff,00
        .he ff,ff,80
        .he ff,ff,c0
        .he ff,ff,e0
        .he ff,ff,f0
        .he 7f,ff,f0
        .he 3f,ff,f8
        .he 1f,ff,f8
        .he 07,ff,f0
        .he 07,ff,f0
        .he 03,ff,e0
        .he 01,9f,c0

sprite_817a
        .he 03,15,3f ; total 63 bytes
sprite_817a_data
        .he 00,00,00
        .he 00,18,00
        .he 00,1c,00
        .he 00,3e,18
        .he 00,3f,04
        .he 00,7f,84
        .he 00,79,e4
        .he 02,c0,04
        .he 04,06,08
        .he 08,33,10
        .he 08,60,28
        .he 08,00,58
        .he 06,07,bc
        .he 01,f8,7c
        .he 00,01,fe
        .he 00,1c,fe
        .he 00,0c,fc
        .he 00,0e,78
        .he 00,07,30
        .he 00,03,20
        .he 00,00,00
sprite_817a_mask
        .he 00,3c,00
        .he 00,3c,00
        .he 00,3e,18
        .he 00,7f,3c
        .he 00,ff,fe
        .he 01,ff,fe
        .he 03,ff,fe
        .he 07,ff,fe
        .he 0f,ff,fc
        .he 1f,ff,f8
        .he 1f,ff,fc
        .he 1f,ff,fc
        .he 0f,ff,fe
        .he 07,ff,fe
        .he 01,ff,ff
        .he 00,3f,ff
        .he 00,1f,fe
        .he 00,1f,fc
        .he 00,0f,f8
        .he 00,07,f0
        .he 00,03,e0

sprite_81fa
        .he 03,12,36 ; total 54 bytes
sprite_81fa_data
        .he 00,00,00
        .he 00,00,00
        .he 0f,00,80
        .he 1f,c1,80
        .he 7f,f1,80
        .he 79,fc,c0
        .he 76,7f,40
        .he 2f,1f,80
        .he 1e,2f,c0
        .he 3c,77,c0
        .he 00,fb,e0
        .he 39,fd,e0
        .he 7e,fd,e0
        .he 3f,7b,e0
        .he 1f,b7,c0
        .he 0f,d7,00
        .he 03,c0,00
        .he 00,00,00
sprite_81fa_mask
        .he 00,00,00
        .he 0f,00,80
        .he 1f,c1,c0
        .he 7f,f3,c0
        .he ff,ff,c0
        .he ff,ff,e0
        .he ff,ff,e0
        .he 7f,ff,c0
        .he 3f,ff,e0
        .he 7f,ff,e0
        .he 7f,ff,f0
        .he 7f,ff,f0
        .he ff,ff,f0
        .he 7f,ff,f0
        .he 3f,ff,e0
        .he 1f,ff,c0
        .he 0f,f7,00
        .he 03,c0,00

sprite_8268
        .he 03,14,3c ; total 60 bytes
sprite_8268_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,60
        .he 00,fe,f0
        .he 0f,fe,f0
        .he 37,fd,30
        .he 37,fb,d0
        .he 67,f7,d0
        .he 0f,ff,d8
        .he 4f,ff,d8
        .he 70,ff,a8
        .he 60,0f,70
        .he 00,04,38
        .he 00,00,1c
        .he 00,00,0e
        .he 00,00,06
        .he 00,00,00
sprite_8268_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,60
        .he 00,fe,f0
        .he 0f,ff,f8
        .he 3f,ff,f8
        .he 7f,ff,f8
        .he 7f,ff,f8
        .he ff,ff,f8
        .he 7f,ff,fc
        .he ff,ff,fc
        .he ff,ff,fc
        .he f0,ff,f8
        .he 60,1f,fc
        .he 00,04,3e
        .he 00,00,1f
        .he 00,00,0f
        .he 00,00,06

sprite_82e2
        .he 03,11,33 ; total 51 bytes
sprite_82e2_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,12
        .he 00,00,1c
        .he 00,fe,38
        .he 0f,fe,78
        .he 37,fd,90
        .he 77,fb,e0
        .he 67,f7,f0
        .he 0f,ff,e0
        .he 6f,ff,c0
        .he 70,ff,80
        .he 60,0f,00
        .he 00,04,00
        .he 00,00,00
sprite_82e2_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,12
        .he 00,00,1f
        .he 00,fc,3e
        .he 0f,ff,7c
        .he 3f,ff,fc
        .he 7f,ff,f8
        .he ff,ff,f0
        .he ff,ff,f8
        .he 7f,ff,f0
        .he ff,ff,e0
        .he ff,ff,c0
        .he f0,ff,80
        .he 60,3f,00
        .he 00,0c,00

sprite_834a
        .he 03,11,33 ; total 51 bytes
sprite_834a_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,48
        .he 00,00,70
        .he 00,00,e0
        .he 00,fd,e0
        .he 0f,fc,c0
        .he 17,fb,00
        .he 37,fb,c0
        .he 27,f7,c0
        .he 0f,ff,c0
        .he 2f,ff,80
        .he 30,ff,00
        .he 20,0e,00
        .he 00,04,00
        .he 00,00,00
sprite_834a_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,00,48
        .he 00,00,fc
        .he 00,00,f8
        .he 00,fd,f0
        .he 0f,ff,f0
        .he 1f,ff,e0
        .he 3f,ff,c0
        .he 7f,ff,e0
        .he 7f,ff,e0
        .he 3f,ff,e0
        .he 7f,ff,c0
        .he 7f,ff,80
        .he 70,ff,00
        .he 20,3e,00
        .he 00,0e,00

sprite_83b2
        .he 03,11,33 ; total 51 bytes
sprite_83b2_data
        .he 00,00,00
        .he 00,01,80
        .he 00,01,e0
        .he 00,00,f0
        .he 08,0c,78
        .he 0c,3f,38
        .he 04,ff,88
        .he 05,ff,b0
        .he 01,fb,78
        .he 0d,f1,78
        .he 0d,fb,f8
        .he 0f,df,f0
        .he 0f,c7,f0
        .he 07,81,f0
        .he 07,80,20
        .he 03,00,00
        .he 00,00,00
sprite_83b2_mask
        .he 00,01,80
        .he 00,03,e0
        .he 00,03,f0
        .he 08,0d,f8
        .he 1c,3f,fc
        .he 1c,ff,fc
        .he 0f,ff,fc
        .he 0f,ff,f8
        .he 0f,ff,fc
        .he 1f,ff,fc
        .he 1f,ff,fc
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 0f,cf,f8
        .he 0f,c3,f0
        .he 07,80,e0
        .he 03,00,00

sprite_841a
        .he 03,11,33 ; total 51 bytes
sprite_841a_data
        .he 00,00,00
        .he 00,00,30
        .he 00,00,38
        .he 20,00,1c
        .he 30,0e,1e
        .he 14,3f,8e
        .he 18,ff,ee
        .he 19,ff,d2
        .he 01,fb,bc
        .he 1d,f1,7c
        .he 1d,fb,fc
        .he 1f,df,f8
        .he 0f,c7,f8
        .he 07,81,f0
        .he 07,80,20
        .he 03,00,00
        .he 00,00,00
sprite_841a_mask
        .he 00,00,30
        .he 00,00,78
        .he 20,00,7c
        .he 70,0e,3e
        .he 7c,3f,bf
        .he 3e,ff,ff
        .he 3f,ff,ff
        .he 3f,ff,ff
        .he 1f,ff,fe
        .he 3f,ff,fe
        .he 3f,ff,fe
        .he 3f,ff,fc
        .he 1f,ff,fc
        .he 0f,cf,f8
        .he 0f,c3,f0
        .he 07,80,e0
        .he 03,00,00

sprite_8482
        .he 03,11,33 ; total 51 bytes
sprite_8482_data
        .he 00,00,00
        .he 00,00,00
        .he 00,07,00
        .he 00,07,c0
        .he 61,8b,f0
        .he 79,bc,f8
        .he 1f,6f,08
        .he 07,bf,70
        .he 01,7b,78
        .he 07,71,78
        .he 0f,7b,f8
        .he 0f,df,f0
        .he 07,c7,f0
        .he 07,81,e0
        .he 03,80,20
        .he 03,00,00
        .he 00,00,00
sprite_8482_mask
        .he 00,00,00
        .he 00,07,00
        .he 00,0f,c0
        .he 61,8f,f0
        .he fb,ff,f8
        .he ff,ff,fc
        .he 7f,ff,fc
        .he 1f,ff,f8
        .he 1f,ff,fc
        .he 0f,ff,fc
        .he 1f,ff,fc
        .he 1f,ff,fc
        .he 0f,ff,fc
        .he 0f,cf,f8
        .he 07,c3,f0
        .he 07,80,e0
        .he 03,00,00

sprite_84ea
        .he 03,0f,2d ; total 45 bytes
sprite_84ea_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,06,00
        .he 00,1f,80
        .he 0e,17,c0
        .he 1f,99,c0
        .he 19,de,c0
        .he 06,d8,00
        .he 0f,16,00
        .he 0f,16,00
        .he 0f,b6,00
        .he 0f,b7,00
        .he 07,ef,00
        .he 07,03,00
sprite_84ea_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,06,00
        .he 00,1f,80
        .he 0e,3f,c0
        .he 1f,bf,e0
        .he 3f,ff,e0
        .he 3f,ff,e0
        .he 1f,ff,c0
        .he 1f,ff,00
        .he 1f,ff,00
        .he 1f,ff,00
        .he 1f,ff,80
        .he 0f,ff,80
        .he 0f,03,80

sprite_8546
        .he 03,0f,2d ; total 45 bytes
sprite_8546_data
        .he 00,00,00
        .he 00,00,00
        .he 00,03,00
        .he 00,0f,80
        .he 00,0b,c0
        .he 00,0d,e0
        .he 1e,0e,e0
        .he 33,0e,60
        .he 3d,88,00
        .he 0e,8b,00
        .he 1e,1b,00
        .he 1f,37,00
        .he 0f,b7,00
        .he 07,ef,00
        .he 07,03,00
sprite_8546_mask
        .he 00,00,00
        .he 00,03,00
        .he 00,0f,80
        .he 00,1f,c0
        .he 00,1f,e0
        .he 1e,1f,f0
        .he 3f,1f,f0
        .he 7f,9f,f0
        .he 7f,fe,60
        .he 3f,ff,80
        .he 3f,bf,80
        .he 3f,ff,80
        .he 1f,ff,80
        .he 0f,ff,80
        .he 0f,03,80

sprite_85a2
        .he 03,0f,2d ; total 45 bytes
sprite_85a2_data
        .he 00,00,00
        .he 00,00,00
        .he 00,70,00
        .he 00,fc,00
        .he 00,ce,00
        .he 00,77,00
        .he 03,ba,00
        .he 01,dc,00
        .he 02,52,00
        .he 03,8d,00
        .he 01,ce,00
        .he 01,d6,00
        .he 03,b7,00
        .he 07,f7,80
        .he 07,02,00
sprite_85a2_mask
        .he 00,00,00
        .he 00,70,00
        .he 00,fc,00
        .he 01,fe,00
        .he 01,ff,00
        .he 03,ff,80
        .he 07,ff,00
        .he 03,fe,00
        .he 07,ff,00
        .he 07,ff,80
        .he 03,ff,00
        .he 03,ff,00
        .he 07,ff,80
        .he 0f,ff,c0
        .he 0f,03,80

sprite_85fe
        .he 03,0f,2d ; total 45 bytes
sprite_85fe_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 70,00,00
        .he 7e,01,80
        .he 3f,03,c0
        .he 21,03,e0
        .he 0e,00,f0
        .he 1f,07,38
        .he 0f,06,98
        .he 07,89,c0
        .he 07,77,80
        .he 0f,ef,00
        .he 0f,03,00
sprite_85fe_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 70,00,00
        .he fe,01,80
        .he ff,03,c0
        .he 7f,87,e0
        .he 7f,87,f0
        .he 3f,07,f8
        .he 3f,8f,fc
        .he 1f,8f,fc
        .he 0f,ff,f8
        .he 0f,ff,c0
        .he 1f,ff,80
        .he 1f,03,80

sprite_865a
        .he 03,12,36 ; total 54 bytes
sprite_865a_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,38,00
        .he 00,3e,00
        .he 06,1f,00
        .he 0f,83,00
        .he 07,c5,00
        .he 02,66,00
        .he 01,8f,00
        .he 01,cf,00
        .he 01,ef,00
        .he 0d,df,00
        .he 05,de,00
        .he 06,f1,00
        .he 02,c0,00
        .he 03,00,00
        .he 00,00,00
sprite_865a_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,38,00
        .he 00,7e,00
        .he 06,7f,00
        .he 0f,bf,80
        .he 1f,df,80
        .he 0f,ef,80
        .he 07,ff,00
        .he 03,ff,80
        .he 03,ff,80
        .he 0f,ff,80
        .he 1f,ff,80
        .he 0f,ff,00
        .he 0f,ff,80
        .he 07,f1,00
        .he 07,c0,00
        .he 03,00,00

sprite_86c8
        .he 03,12,36 ; total 54 bytes
sprite_86c8_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 38,0c,00
        .he 3c,0e,00
        .he 0f,0f,00
        .he 07,85,80
        .he 02,02,c0
        .he 01,87,40
        .he 03,8f,80
        .he 07,cf,00
        .he 17,ef,00
        .he 0b,de,00
        .he 05,f1,00
        .he 06,c0,00
        .he 03,00,00
        .he 00,00,00
sprite_86c8_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 38,0c,00
        .he 7c,1e,00
        .he 7f,1f,00
        .he 3f,9f,80
        .he 0f,cf,c0
        .he 07,87,e0
        .he 03,cf,e0
        .he 07,df,c0
        .he 1f,ff,80
        .he 3f,ff,80
        .he 1f,ff,00
        .he 0f,ff,80
        .he 0f,f1,00
        .he 07,c0,00
        .he 03,00,00

sprite_8736
        .he 03,12,36 ; total 54 bytes
sprite_8736_data
        .he 00,00,00
        .he 00,40,00
        .he 00,e0,00
        .he 00,f8,00
        .he 00,7e,00
        .he 00,26,00
        .he 00,1a,00
        .he 01,bc,00
        .he 03,bc,00
        .he 01,bc,00
        .he 00,3e,00
        .he 00,de,00
        .he 06,df,00
        .he 05,de,00
        .he 06,f0,00
        .he 02,c0,00
        .he 03,00,00
        .he 00,00,00
sprite_8736_mask
        .he 00,40,00
        .he 00,e0,00
        .he 01,f8,00
        .he 01,fe,00
        .he 00,ff,00
        .he 00,7f,00
        .he 01,ff,00
        .he 03,fe,00
        .he 07,fe,00
        .he 03,fe,00
        .he 01,ff,00
        .he 07,ff,00
        .he 0f,ff,80
        .he 0f,ff,00
        .he 0f,fe,00
        .he 07,f0,00
        .he 07,c0,00
        .he 03,00,00

sprite_87a4
        .he 03,10,30 ; total 48 bytes
sprite_87a4_data
        .he 00,08,00
        .he 00,1e,00
        .he 00,1f,00
        .he 00,07,80
        .he 1c,01,c0
        .he 1f,82,80
        .he 06,47,00
        .he 01,87,80
        .he 03,8f,00
        .he 03,cf,00
        .he 09,ef,00
        .he 0d,de,00
        .he 06,f0,00
        .he 06,c0,00
        .he 03,00,00
        .he 00,00,00
sprite_87a4_mask
        .he 00,1e,00
        .he 00,3f,00
        .he 00,3f,80
        .he 1c,1f,c0
        .he 3f,87,e0
        .he 3f,c7,c0
        .he 1f,ef,80
        .he 07,cf,c0
        .he 07,df,80
        .he 0f,ff,80
        .he 1f,ff,80
        .he 1f,ff,00
        .he 0f,ff,80
        .he 0f,f1,00
        .he 07,c0,00
        .he 03,00,00

sprite_8806
        .he 03,1e,5a ; total 90 bytes
sprite_8806_data
        .he 00,00,00
        .he 00,c0,00
        .he 00,f1,80
        .he 00,79,e0
        .he 00,00,f0
        .he 00,3b,20
        .he 00,7b,c0
        .he 00,7b,80
        .he 00,37,80
        .he 00,3f,c0
        .he 00,00,c0
        .he 00,3b,40
        .he 00,c1,80
        .he 00,f1,c0
        .he 01,3e,60
        .he 19,cd,a0
        .he 1d,f3,c0
        .he 06,f9,c0
        .he 00,fd,d8
        .he 00,31,88
        .he 00,0c,08
        .he 00,1c,08
        .he 00,01,08
        .he 00,4b,10
        .he 00,40,60
        .he 00,41,90
        .he 00,3e,78
        .he 00,01,f8
        .he 00,00,30
        .he 00,00,00
sprite_8806_mask
        .he 00,c0,00
        .he 01,f1,80
        .he 01,fb,e0
        .he 00,ff,f0
        .he 00,7f,f8
        .he 00,7f,f0
        .he 00,ff,e0
        .he 00,ff,c0
        .he 00,7f,c0
        .he 00,7f,e0
        .he 00,3f,e0
        .he 00,ff,e0
        .he 01,ff,c0
        .he 01,ff,e0
        .he 1b,ff,f0
        .he 3f,ff,f0
        .he 3f,ff,e0
        .he 1f,ff,f8
        .he 07,ff,fc
        .he 00,ff,fc
        .he 00,3f,fc
        .he 00,3f,fc
        .he 00,7f,fc
        .he 00,ff,f8
        .he 00,ff,f0
        .he 00,ff,f8
        .he 00,7f,fc
        .he 00,3f,fc
        .he 00,01,f8
        .he 00,00,f0

sprite_88bc
        .he 03,1e,5a ; total 90 bytes
sprite_88bc_data
        .he 00,00,00
        .he 00,18,00
        .he 00,0e,00
        .he 00,07,80
        .he 00,00,40
        .he 00,17,40
        .he 00,17,80
        .he 00,37,80
        .he 00,37,c0
        .he 00,3f,c0
        .he 00,00,c0
        .he 00,3b,40
        .he 00,c1,80
        .he 00,f1,c0
        .he 01,3e,60
        .he 19,cd,a0
        .he 1d,f3,c0
        .he 06,f9,c0
        .he 00,fd,d8
        .he 00,31,88
        .he 00,0c,08
        .he 00,1c,08
        .he 00,01,08
        .he 00,4b,10
        .he 00,40,60
        .he 00,41,90
        .he 00,3e,78
        .he 00,01,f8
        .he 00,00,30
        .he 00,00,00
sprite_88bc_mask
        .he 00,18,00
        .he 00,3e,00
        .he 00,1f,80
        .he 00,0f,c0
        .he 00,1f,e0
        .he 00,3f,e0
        .he 00,3f,c0
        .he 00,7f,c0
        .he 00,7f,e0
        .he 00,7f,e0
        .he 00,3f,e0
        .he 00,ff,e0
        .he 01,ff,c0
        .he 01,ff,e0
        .he 1b,ff,f0
        .he 3f,ff,f0
        .he 3f,ff,e0
        .he 1f,ff,f8
        .he 07,ff,fc
        .he 00,ff,fc
        .he 00,3f,fc
        .he 00,3f,fc
        .he 00,7f,fc
        .he 00,ff,f8
        .he 00,ff,f0
        .he 00,ff,f8
        .he 00,7f,fc
        .he 00,3f,fc
        .he 00,01,f8
        .he 00,00,30

sprite_8972
        .he 03,1f,5d ; total 93 bytes
sprite_8972_data
        .he 00,00,00
        .he 00,00,00
        .he 00,06,00
        .he 03,8f,00
        .he 07,c7,80
        .he 06,e9,c0
        .he 01,6e,40
        .he 03,9e,00
        .he 01,7e,00
        .he 01,fe,00
        .he 03,8e,00
        .he 00,72,00
        .he 03,fc,00
        .he 07,fe,00
        .he 0f,f7,00
        .he 0f,cb,00
        .he 0f,bc,00
        .he 0f,7f,00
        .he 0f,7f,c0
        .he 00,03,f0
        .he 1f,c0,30
        .he 3f,f3,00
        .he 3f,fb,c0
        .he 3d,fc,c0
        .he 1c,7e,00
        .he 1b,be,00
        .he 0b,df,00
        .he 07,df,00
        .he 03,3e,00
        .he 00,78,00
        .he 00,00,00
sprite_8972_mask
        .he 00,00,00
        .he 00,06,00
        .he 03,8f,00
        .he 07,df,80
        .he 0f,ff,c0
        .he 0f,ff,e0
        .he 07,ff,e0
        .he 07,ff,40
        .he 03,ff,00
        .he 03,ff,00
        .he 07,ff,00
        .he 03,ff,00
        .he 07,fe,00
        .he 0f,ff,00
        .he 1f,ff,80
        .he 1f,ff,80
        .he 1f,ff,00
        .he 1f,ff,c0
        .he 1f,ff,f0
        .he 1f,ff,f8
        .he 3f,ff,f8
        .he 7f,ff,f0
        .he 7f,ff,e0
        .he 7f,ff,e0
        .he 3f,ff,c0
        .he 3f,ff,00
        .he 1f,ff,80
        .he 0f,ff,80
        .he 07,ff,00
        .he 03,fe,00
        .he 00,78,00



;L6864   DW L68EA,L68EA,L688D,L68AE
;686C    DW L68C9

L6864   .wo L68EA,L68EA,L688D,L68AE ; DW L68EA,L68EA,L688D,L68AE
        .wo L68C9 ; DW L68C9

;L686E   DW L68EA,L6872

L686E   .wo L68EA,L6872 ; DW L68EA,L6872

;L6872   DB 0D,1E,00,2F,00,26,00,1E ; .../.&..
;687A    DB 00,00,F0,01,9E,0E,DC,3F
;6882    DB 38,67,C4,27,F8,13,F0,0D ; 8..'....
;688A    DB E0,03,80

L6872   .he 0D,1E,00,2F,00,26,00,1E ; DB 0D,1E,00,2F,00,26,00,1E
        .he 00,00,F0,01,9E,0E,DC,3F ; DB 00,00,F0,01,9E,0E,DC,3F
        .he 38,67,C4,27,F8,13,F0,0D ; DB 38,67,C4,27,F8,13,F0,0D
        .he E0,03,80 ; DB E0,03,80

;L688D   DB 10,40,00,40,18,63,30,76 ; .@.@..0.
;6895    DB 60,76,EC,3F,F8,1D,90,29 ; ...?...)
;689D    DB 3E,00,3C,05,B8,77,F8,7D ; >.<.....
;68A5    DB DC,6C,C6,46,62,02,20,01 ; ...F.. .
;68AD    DB 10

L688D   .he 10,40,00,40,18,63,30,76 ; DB 10,40,00,40,18,63,30,76
        .he 60,76,EC,3F,F8,1D,90,29 ; DB 60,76,EC,3F,F8,1D,90,29
        .he 3E,00,3C,05,B8,77,F8,7D ; DB 3E,00,3C,05,B8,77,F8,7D
        .he DC,6C,C6,46,62,02,20,01 ; DB DC,6C,C6,46,62,02,20,01
        .he 10 ; DB 10

;L68AE   DB 0D,00,00,00,00,00,20,00
;68B6    DB 40,50,00,52,00,76,60,3F ; @P.R...?
;68BE    DB 80,3E,0C,7F,C0,36,00,12 ; .>...6..
;68C6    DB 60,08,18

L68AE   .he 0D,00,00,00,00,00,20,00 ; DB 0D,00,00,00,00,00,20,00
        .he 40,50,00,52,00,76,60,3F ; DB 40,50,00,52,00,76,60,3F
        .he 80,3E,0C,7F,C0,36,00,12 ; DB 80,3E,0C,7F,C0,36,00,12
        .he 60,08,18 ; DB 60,08,18

;L68C9   DB 10,00,00,00,00,00,00,00
;68D1    DB 00,1D,F0,1D,FC,1D,FE,1D
;68D9    DB FF,1D,F1,12,06,12,3C,1D
;68E1    DB F0,00,00,00,00,00,00,00
;68E9    DB 00

L68C9   .he 10,00,00,00,00,00,00,00 ; DB 10,00,00,00,00,00,00,00
        .he 00,1D,F0,1D,FC,1D,FE,1D ; DB 00,1D,F0,1D,FC,1D,FE,1D
        .he FF,1D,F1,12,06,12,3C,1D ; DB FF,1D,F1,12,06,12,3C,1D
        .he F0,00,00,00,00,00,00,00 ; DB F0,00,00,00,00,00,00,00
        .he 00 ; DB 00

;L68EA   DB 00,00

L68EA   .he 00,00 ; DB 00,00





;L6AC6   DW L6B18,L6B38,L6B58,L6B78
;6ACE    DW L6B98,L6BB8,L6BD8,L6BF8
;6AD6    DW L6C18,L6C38,L6C58,L6C78
;6ADE    DW L6C98,L6CB8,L6CD8,L6CF8
;6AE6    DW L6D18,L6D38,L6D58,L6D78
;6AEE    DW L6D98,L6DB8,L6DD8,L6DF8
;6AF6    DW L6E18,L6E38,L6E58,L6E78
;6AFE    DW L6E98,L6EB8,L6ED8,L6EF8
;6B06    DW L6F18,L6F38,L6F58,L6F78
;6B0E    DW L6F98,L6FB8,L6FD8,L6FF8
;6B16    DW L7018


L6AC6   .wo L6B18,L6B38,L6B58,L6B78 ; DW L6B18,L6B38,L6B58,L6B78
        .wo L6B98,L6BB8,L6BD8,L6BF8 ; DW L6B98,L6BB8,L6BD8,L6BF8
        .wo L6C18,L6C38,L6C58,L6C78 ; DW L6C18,L6C38,L6C58,L6C78
        .wo L6C98,L6CB8,L6CD8,L6CF8 ; DW L6C98,L6CB8,L6CD8,L6CF8
        .wo L6D18,L6D38,L6D58,L6D78 ; DW L6D18,L6D38,L6D58,L6D78
        .wo L6D98,L6DB8,L6DD8,L6DF8 ; DW L6D98,L6DB8,L6DD8,L6DF8
        .wo L6E18,L6E38,L6E58,L6E78 ; DW L6E18,L6E38,L6E58,L6E78
        .wo L6E98,L6EB8,L6ED8,L6EF8 ; DW L6E98,L6EB8,L6ED8,L6EF8
        .wo L6F18,L6F38,L6F58,L6F78 ; DW L6F18,L6F38,L6F58,L6F78
        .wo L6F98,L6FB8,L6FD8,L6FF8 ; DW L6F98,L6FB8,L6FD8,L6FF8
        .wo L7018 ; DW L7018

;L6B18   DB 00,7F,F0,00,00,3F,F0,00
;6B20    DB 00,1B,E0,00,00,01,E0,00
;6B28    DB 00,00,C0,00,00,00,00,00
;6B30    DB 00,00,00,00,00,00,00,00

L6B18   .he 00,7F,F0,00,00,3F,F0,00 ; DB 00,7F,F0,00,00,3F,F0,00
        .he 00,1B,E0,00,00,01,E0,00 ; DB 00,1B,E0,00,00,01,E0,00
        .he 00,00,C0,00,00,00,00,00 ; DB 00,00,C0,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00

;L6B38   DB 1F,E0,07,00,3F,FF,FF,C0
;6B40    DB 3E,8F,FF,E0,1E,70,FF,E0
;6B48    DB 05,FF,1F,C0,00,FF,E3,00
;6B50    DB 00,FF,F8,00,00,FF,F8,00

L6B38   .he 1F,E0,07,00,3F,FF,FF,C0 ; DB 1F,E0,07,00,3F,FF,FF,C0
        .he 3E,8F,FF,E0,1E,70,FF,E0 ; DB 3E,8F,FF,E0,1E,70,FF,E0
        .he 05,FF,1F,C0,00,FF,E3,00 ; DB 05,FF,1F,C0,00,FF,E3,00
        .he 00,FF,F8,00,00,FF,F8,00 ; DB 00,FF,F8,00,00,FF,F8,00

;L6B58   DB 01,DC,77,70,01,EF,EF,60
;6B60    DB 00,F7,CE,00,00,E9,96,00
;6B68    DB 01,D4,29,00,01,D6,6B,00
;6B70    DB 01,D1,0B,00,00,0E,F0,00

L6B58   .he 01,DC,77,70,01,EF,EF,60 ; DB 01,DC,77,70,01,EF,EF,60
        .he 00,F7,CE,00,00,E9,96,00 ; DB 00,F7,CE,00,00,E9,96,00
        .he 01,D4,29,00,01,D6,6B,00 ; DB 01,D4,29,00,01,D6,6B,00
        .he 01,D1,0B,00,00,0E,F0,00 ; DB 01,D1,0B,00,00,0E,F0,00

;L6B78   DB 7D,EB,AF,66,7D,EA,D7,78
;6B80    DB 3F,E8,D6,FE,3F,DB,D7,FC ; ?...?...
;6B88    DB 1F,DB,B7,FC,0F,D9,B5,FE
;6B90    DB 07,5A,32,FE,02,99,B5,78 ; .Z2.....

L6B78   .he 7D,EB,AF,66,7D,EA,D7,78 ; DB 7D,EB,AF,66,7D,EA,D7,78
        .he 3F,E8,D6,FE,3F,DB,D7,FC ; DB 3F,E8,D6,FE,3F,DB,D7,FC
        .he 1F,DB,B7,FC,0F,D9,B5,FE ; DB 1F,DB,B7,FC,0F,D9,B5,FE
        .he 07,5A,32,FE,02,99,B5,78 ; DB 07,5A,32,FE,02,99,B5,78

;L6B98   DB 00,7F,FE,1E,00,FE,FE,03
;6BA0    DB 00,FC,FE,07,00,FF,FE,0E
;6BA8    DB 01,FF,FF,32,01,FE,FF,3C ; ...2...<
;6BB0    DB 01,F4,DF,7F,01,EB,AF,1F

L6B98   .he 00,7F,FE,1E,00,FE,FE,03 ; DB 00,7F,FE,1E,00,FE,FE,03
        .he 00,FC,FE,07,00,FF,FE,0E ; DB 00,FC,FE,07,00,FF,FE,0E
        .he 01,FF,FF,32,01,FE,FF,3C ; DB 01,FF,FF,32,01,FE,FF,3C
        .he 01,F4,DF,7F,01,EB,AF,1F ; DB 01,F4,DF,7F,01,EB,AF,1F

;L6BB8   DB 01,FF,F8,00,01,03,F8,00
;6BC0    DB 00,FC,70,00,01,FF,B0,00
;6BC8    DB 01,FF,D0,00,00,FF,E0,00
;6BD0    DB 00,3F,F0,00,00,03,E0,00

L6BB8   .he 01,FF,F8,00,01,03,F8,00 ; DB 01,FF,F8,00,01,03,F8,00
        .he 00,FC,70,00,01,FF,B0,00 ; DB 00,FC,70,00,01,FF,B0,00
        .he 01,FF,D0,00,00,FF,E0,00 ; DB 01,FF,D0,00,00,FF,E0,00
        .he 00,3F,F0,00,00,03,E0,00 ; DB 00,3F,F0,00,00,03,E0,00

;L6BD8   DB 1F,F0,00,00,7F,FF,FF,80
;6BE0    DB FF,8F,FF,F0,FF,70,FF,FC
;6BE8    DB 7E,FF,1F,FE,3E,FF,E7,FE
;6BF0    DB 0E,FF,FB,FE,00,FF,FB,FC

L6BD8   .he 1F,F0,00,00,7F,FF,FF,80 ; DB 1F,F0,00,00,7F,FF,FF,80
        .he FF,8F,FF,F0,FF,70,FF,FC ; DB FF,8F,FF,F0,FF,70,FF,FC
        .he 7E,FF,1F,FE,3E,FF,E7,FE ; DB 7E,FF,1F,FE,3E,FF,E7,FE
        .he 0E,FF,FB,FE,00,FF,FB,FC ; DB 0E,FF,FB,FE,00,FF,FB,FC

;L6BF8   DB 03,AC,2F,70,01,6F,EF,60
;6C00    DB 00,FE,7F,00,01,FF,FF,80
;6C08    DB 01,F9,7F,80,01,E6,9F,80
;6C10    DB 01,D9,6F,80,00,07,9F,80

L6BF8   .he 03,AC,2F,70,01,6F,EF,60 ; DB 03,AC,2F,70,01,6F,EF,60
        .he 00,FE,7F,00,01,FF,FF,80 ; DB 00,FE,7F,00,01,FF,FF,80
        .he 01,F9,7F,80,01,E6,9F,80 ; DB 01,F9,7F,80,01,E6,9F,80
        .he 01,D9,6F,80,00,07,9F,80 ; DB 01,D9,6F,80,00,07,9F,80

;L6C18   DB 7B,FD,7F,66,7F,F2,BF,78
;6C20    DB 3F,EA,CE,FE,3F,EA,D7,FC ; ?...?...
;6C28    DB 1F,DB,DB,FC,0F,DF,DB,FE
;6C30    DB 07,DF,F9,FE,03,BF,F6,F8

L6C18   .he 7B,FD,7F,66,7F,F2,BF,78 ; DB 7B,FD,7F,66,7F,F2,BF,78
        .he 3F,EA,CE,FE,3F,EA,D7,FC ; DB 3F,EA,CE,FE,3F,EA,D7,FC
        .he 1F,DB,DB,FC,0F,DF,DB,FE ; DB 1F,DB,DB,FC,0F,DF,DB,FE
        .he 07,DF,F9,FE,03,BF,F6,F8 ; DB 07,DF,F9,FE,03,BF,F6,F8

;L6C38   DB 01,FC,1F,1E,03,FE,3F,83
;6C40    DB 07,FF,FF,C7,07,FF,FF,CE
;6C48    DB 0F,FF,FF,B2,0F,FF,FF,BC
;6C50    DB 0F,FF,FF,7F,07,FF,FF,9F

L6C38   .he 01,FC,1F,1E,03,FE,3F,83 ; DB 01,FC,1F,1E,03,FE,3F,83
        .he 07,FF,FF,C7,07,FF,FF,CE ; DB 07,FF,FF,C7,07,FF,FF,CE
        .he 0F,FF,FF,B2,0F,FF,FF,BC ; DB 0F,FF,FF,B2,0F,FF,FF,BC
        .he 0F,FF,FF,7F,07,FF,FF,9F ; DB 0F,FF,FF,7F,07,FF,FF,9F

;L6C58   DB 00,0F,E0,00,00,0F,E0,00
;6C60    DB 00,0F,C0,00,00,07,C0,00
;6C68    DB 00,03,80,00,00,00,00,00
;6C70    DB 00,00,00,00,00,00,00,00

L6C58   .he 00,0F,E0,00,00,0F,E0,00 ; DB 00,0F,E0,00,00,0F,E0,00
        .he 00,0F,C0,00,00,07,C0,00 ; DB 00,0F,C0,00,00,07,C0,00
        .he 00,03,80,00,00,00,00,00 ; DB 00,03,80,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00

;L6C78   DB 0F,C0,00,00,7F,FF,FF,00
;6C80    DB FF,F8,3F,F0,FF,E7,CF,EC
;6C88    DB 7F,EF,F7,FE,0F,E8,37,FE
;6C90    DB 00,E7,D7,FC,00,0F,EF,F0

L6C78   .he 0F,C0,00,00,7F,FF,FF,00 ; DB 0F,C0,00,00,7F,FF,FF,00
        .he FF,F8,3F,F0,FF,E7,CF,EC ; DB FF,F8,3F,F0,FF,E7,CF,EC
        .he 7F,EF,F7,FE,0F,E8,37,FE ; DB 7F,EF,F7,FE,0F,E8,37,FE
        .he 00,E7,D7,FC,00,0F,EF,F0 ; DB 00,E7,D7,FC,00,0F,EF,F0

;L6C98   DB 01,08,F7,70,01,CE,7B,60
;6CA0    DB 00,F7,BA,00,00,FE,FC,00
;6CA8    DB 00,79,7E,00,00,BB,7E,00
;6CB0    DB 00,DC,FE,00,00,AF,FF,00

L6C98   .he 01,08,F7,70,01,CE,7B,60 ; DB 01,08,F7,70,01,CE,7B,60
        .he 00,F7,BA,00,00,FE,FC,00 ; DB 00,F7,BA,00,00,FE,FC,00
        .he 00,79,7E,00,00,BB,7E,00 ; DB 00,79,7E,00,00,BB,7E,00
        .he 00,DC,FE,00,00,AF,FF,00 ; DB 00,DC,FE,00,00,AF,FF,00

;L6CB8   DB 7D,FF,FF,66,7D,87,FF,78
;6CC0    DB 3F,79,FE,FE,3E,FE,7F,FC ; ?...>...
;6CC8    DB 1E,FF,BF,FC,0E,E7,DD,FE
;6CD0    DB 06,41,EE,FE,02,40,EF,78 ; .A...@..

L6CB8   .he 7D,FF,FF,66,7D,87,FF,78 ; DB 7D,FF,FF,66,7D,87,FF,78
        .he 3F,79,FE,FE,3E,FE,7F,FC ; DB 3F,79,FE,FE,3E,FE,7F,FC
        .he 1E,FF,BF,FC,0E,E7,DD,FE ; DB 1E,FF,BF,FC,0E,E7,DD,FE
        .he 06,41,EE,FE,02,40,EF,78 ; DB 06,41,EE,FE,02,40,EF,78

;L6CD8   DB 00,3F,FE,1E,00,15,54,03 ; .?....T.
;6CE0    DB 00,1F,FC,07,00,00,00,0E
;6CE8    DB 00,7F,FE,32,00,7E,FE,3C ; ...2...<
;6CF0    DB 00,FC,FE,7F,00,FF,FF,1F

L6CD8   .he 00,3F,FE,1E,00,15,54,03 ; DB 00,3F,FE,1E,00,15,54,03
        .he 00,1F,FC,07,00,00,00,0E ; DB 00,1F,FC,07,00,00,00,0E
        .he 00,7F,FE,32,00,7E,FE,3C ; DB 00,7F,FE,32,00,7E,FE,3C
        .he 00,FC,FE,7F,00,FF,FF,1F ; DB 00,FC,FE,7F,00,FF,FF,1F

;L6CF8   DB 00,07,E0,00,00,07,E0,00
;6D00    DB 00,07,C0,00,00,03,80,00
;6D08    DB 00,00,00,00,00,00,00,00
;6D10    DB 00,00,00,00,00,00,00,00

L6CF8   .he 00,07,E0,00,00,07,E0,00 ; DB 00,07,E0,00,00,07,E0,00
        .he 00,07,C0,00,00,03,80,00 ; DB 00,07,C0,00,00,03,80,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00

;L6D18   DB 0F,E0,07,F0,18,3F,FF,10
;6D20    DB 17,CF,FC,E0,0F,D3,F3,F0
;6D28    DB 07,9C,CB,C0,00,0F,38,00
;6D30    DB 00,0F,F0,00,00,0F,F0,00

L6D18   .he 0F,E0,07,F0,18,3F,FF,10 ; DB 0F,E0,07,F0,18,3F,FF,10
        .he 17,CF,FC,E0,0F,D3,F3,F0 ; DB 17,CF,FC,E0,0F,D3,F3,F0
        .he 07,9C,CB,C0,00,0F,38,00 ; DB 07,9C,CB,C0,00,0F,38,00
        .he 00,0F,F0,00,00,0F,F0,00 ; DB 00,0F,F0,00,00,0F,F0,00

;L6D38   DB 00,EE,0D,E0,00,FD,F1,C0
;6D40    DB 00,77,C0,00,01,BE,DE,00
;6D48    DB 03,DD,6E,00,03,DD,A0,00
;6D50    DB 03,DC,2B,00,01,DF,F7,00

L6D38   .he 00,EE,0D,E0,00,FD,F1,C0 ; DB 00,EE,0D,E0,00,FD,F1,C0
        .he 00,77,C0,00,01,BE,DE,00 ; DB 00,77,C0,00,01,BE,DE,00
        .he 03,DD,6E,00,03,DD,A0,00 ; DB 03,DD,6E,00,03,DD,A0,00
        .he 03,DC,2B,00,01,DF,F7,00 ; DB 03,DC,2B,00,01,DF,F7,00

;L6D58   DB 7D,FF,FF,66,7D,FF,FF,78
;6D60    DB 3F,FF,FE,FC,3F,F8,07,F8 ; ?...?...
;6D68    DB 1F,C7,FB,F0,0F,BF,FD,F0
;6D70    DB 07,7F,FD,F0,02,FF,F5,E0

L6D58   .he 7D,FF,FF,66,7D,FF,FF,78 ; DB 7D,FF,FF,66,7D,FF,FF,78
        .he 3F,FF,FE,FC,3F,F8,07,F8 ; DB 3F,FF,FE,FC,3F,F8,07,F8
        .he 1F,C7,FB,F0,0F,BF,FD,F0 ; DB 1F,C7,FB,F0,0F,BF,FD,F0
        .he 07,7F,FD,F0,02,FF,F5,E0 ; DB 07,7F,FD,F0,02,FF,F5,E0

;L6D78   DB 00,7F,FE,1E,00,7F,7E,3F
;6D80    DB 00,7F,7E,1F,00,7F,7E,0E
;6D88    DB 00,FF,7E,32,00,FF,7E,3C ; ...2...<
;6D90    DB 01,FF,7F,7F,01,FF,7F,1F

L6D78   .he 00,7F,FE,1E,00,7F,7E,3F ; DB 00,7F,FE,1E,00,7F,7E,3F
        .he 00,7F,7E,1F,00,7F,7E,0E ; DB 00,7F,7E,1F,00,7F,7E,0E
        .he 00,FF,7E,32,00,FF,7E,3C ; DB 00,FF,7E,32,00,FF,7E,3C
        .he 01,FF,7F,7F,01,FF,7F,1F ; DB 01,FF,7F,7F,01,FF,7F,1F

;L6D98   DB 0E,A5,2F,80,05,5B,D3,80 ; ../..[..
;6DA0    DB 03,FE,F5,00,07,EF,7E,00
;6DA8    DB 01,DD,FE,00,02,7F,FF,00
;6DB0    DB 00,BB,FC,00,00,02,48,00

L6D98   .he 0E,A5,2F,80,05,5B,D3,80 ; DB 0E,A5,2F,80,05,5B,D3,80
        .he 03,FE,F5,00,07,EF,7E,00 ; DB 03,FE,F5,00,07,EF,7E,00
        .he 01,DD,FE,00,02,7F,FF,00 ; DB 01,DD,FE,00,02,7F,FF,00
        .he 00,BB,FC,00,00,02,48,00 ; DB 00,BB,FC,00,00,02,48,00

;L6DB8   DB 00,A1,C7,00,00,DF,FE,00
;6DC0    DB 00,DB,DE,00,00,5B,D6,00
;6DC8    DB 00,2D,D4,00,00,1D,A9,00
;6DD0    DB 00,2F,FE,00,00,05,20,00 ; ./.... .

L6DB8   .he 00,A1,C7,00,00,DF,FE,00 ; DB 00,A1,C7,00,00,DF,FE,00
        .he 00,DB,DE,00,00,5B,D6,00 ; DB 00,DB,DE,00,00,5B,D6,00
        .he 00,2D,D4,00,00,1D,A9,00 ; DB 00,2D,D4,00,00,1D,A9,00
        .he 00,2F,FE,00,00,05,20,00 ; DB 00,2F,FE,00,00,05,20,00

;L6DD8   DB 03,6E,7F,78,01,F9,CF,A0
;6DE0    DB 02,F6,B7,40,05,E6,B3,A0
;6DE8    DB 0A,E1,C3,50,09,F3,E7,90
;6DF0    DB 06,FF,FF,60,00,FF,FF,00

L6DD8   .he 03,6E,7F,78,01,F9,CF,A0 ; DB 03,6E,7F,78,01,F9,CF,A0
        .he 02,F6,B7,40,05,E6,B3,A0 ; DB 02,F6,B7,40,05,E6,B3,A0
        .he 0A,E1,C3,50,09,F3,E7,90 ; DB 0A,E1,C3,50,09,F3,E7,90
        .he 06,FF,FF,60,00,FF,FF,00 ; DB 06,FF,FF,60,00,FF,FF,00

;L6DF8   DB 00,19,80,00,00,1C,C0,00
;6E00    DB 00,1C,F8,00,00,24,44,00 ; .....$D.
;6E08    DB 00,24,22,00,00,24,17,00 ; .$"..$..
;6E10    DB 00,3C,0F,80,00,18,03,80

L6DF8   .he 00,19,80,00,00,1C,C0,00 ; DB 00,19,80,00,00,1C,C0,00
        .he 00,1C,F8,00,00,24,44,00 ; DB 00,1C,F8,00,00,24,44,00
        .he 00,24,22,00,00,24,17,00 ; DB 00,24,22,00,00,24,17,00
        .he 00,3C,0F,80,00,18,03,80 ; DB 00,3C,0F,80,00,18,03,80

;L6E18   DB 01,00,0F,06,00,FF,F1,0F
;6E20    DB 03,BF,FE,0F,07,FF,FF,71
;6E28    DB 06,FF,FF,E2,0F,BF,FF,A2
;6E30    DB 07,DF,F7,9C,07,FE,FF,80

L6E18   .he 01,00,0F,06,00,FF,F1,0F ; DB 01,00,0F,06,00,FF,F1,0F
        .he 03,BF,FE,0F,07,FF,FF,71 ; DB 03,BF,FE,0F,07,FF,FF,71
        .he 06,FF,FF,E2,0F,BF,FF,A2 ; DB 06,FF,FF,E2,0F,BF,FF,A2
        .he 07,DF,F7,9C,07,FE,FF,80 ; DB 07,DF,F7,9C,07,FE,FF,80

;L6E38   DB 00,4E,7E,F0,00,DF,BE,E0
;6E40    DB 00,DB,DF,40,01,E4,FF,80
;6E48    DB 02,DD,7F,40,02,9B,7F,40 ; ...@...@
;6E50    DB 03,44,FE,C0,00,BF,FE,00

L6E38   .he 00,4E,7E,F0,00,DF,BE,E0 ; DB 00,4E,7E,F0,00,DF,BE,E0
        .he 00,DB,DF,40,01,E4,FF,80 ; DB 00,DB,DF,40,01,E4,FF,80
        .he 02,DD,7F,40,02,9B,7F,40 ; DB 02,DD,7F,40,02,9B,7F,40
        .he 03,44,FE,C0,00,BF,FE,00 ; DB 03,44,FE,C0,00,BF,FE,00

;L6E58   DB 00,00,00,00,00,00,00,00
;6E60    DB 1E,00,00,00,1F,80,00,00
;6E68    DB 07,80,38,F8,08,40,3F,78 ; ..8..@?.
;6E70    DB 0F,C0,3F,90,0B,C0,1F,C0

L6E58   .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 1E,00,00,00,1F,80,00,00 ; DB 1E,00,00,00,1F,80,00,00
        .he 07,80,38,F8,08,40,3F,78 ; DB 07,80,38,F8,08,40,3F,78
        .he 0F,C0,3F,90,0B,C0,1F,C0 ; DB 0F,C0,3F,90,0B,C0,1F,C0

;L6E78   DB 04,20,0E,00,07,80,01,80
;6E80    DB 07,C0,07,C0,07,E0,0F,40
;6E88    DB 06,F0,1F,C0,03,F8,1F,C0
;6E90    DB 03,FC,3F,C0,01,FF,FF,40 ; ..?....@

L6E78   .he 04,20,0E,00,07,80,01,80 ; DB 04,20,0E,00,07,80,01,80
        .he 07,C0,07,C0,07,E0,0F,40 ; DB 07,C0,07,C0,07,E0,0F,40
        .he 06,F0,1F,C0,03,F8,1F,C0 ; DB 06,F0,1F,C0,03,F8,1F,C0
        .he 03,FC,3F,C0,01,FF,FF,40 ; DB 03,FC,3F,C0,01,FF,FF,40

;L6E98   DB 01,BF,FF,C0,00,FF,FF,C0
;6EA0    DB 00,FF,FF,80,00,FF,FE,80
;6EA8    DB 00,5F,FF,80,00,7F,FF,00
;6EB0    DB 00,7F,FF,00,00,00,00,00

L6E98   .he 01,BF,FF,C0,00,FF,FF,C0 ; DB 01,BF,FF,C0,00,FF,FF,C0
        .he 00,FF,FF,80,00,FF,FE,80 ; DB 00,FF,FF,80,00,FF,FE,80
        .he 00,5F,FF,80,00,7F,FF,00 ; DB 00,5F,FF,80,00,7F,FF,00
        .he 00,7F,FF,00,00,00,00,00 ; DB 00,7F,FF,00,00,00,00,00

;L6EB8   DB 00,00,00,00,00,00,00,00
;6EC0    DB 03,C0,00,00,03,F0,00,00
;6EC8    DB 00,F0,E3,E0,01,08,FD,E0
;6ED0    DB 01,F8,FE,C0,01,78,7F,00

L6EB8   .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 03,C0,00,00,03,F0,00,00 ; DB 03,C0,00,00,03,F0,00,00
        .he 00,F0,E3,E0,01,08,FD,E0 ; DB 00,F0,E3,E0,01,08,FD,E0
        .he 01,F8,FE,C0,01,78,7F,00 ; DB 01,F8,FE,C0,01,78,7F,00

;L6ED8   DB 00,84,B8,00,00,F0,06,00
;6EE0    DB 01,F0,1F,00,01,F8,3D,00
;6EE8    DB 01,B8,3F,00,00,FC,7F,80
;6EF0    DB 00,FC,7F,80,00,FF,FE,80

L6ED8   .he 00,84,B8,00,00,F0,06,00 ; DB 00,84,B8,00,00,F0,06,00
        .he 01,F0,1F,00,01,F8,3D,00 ; DB 01,F0,1F,00,01,F8,3D,00
        .he 01,B8,3F,00,00,FC,7F,80 ; DB 01,B8,3F,00,00,FC,7F,80
        .he 00,FC,7F,80,00,FF,FE,80 ; DB 00,FC,7F,80,00,FF,FE,80

;L6EF8   DB 00,BF,FF,80,00,FF,FF,80
;6F00    DB 00,FF,FF,80,00,FF,FE,80
;6F08    DB 00,5F,FF,80,00,7F,FF,00
;6F10    DB 00,7F,FF,00,00,00,00,00

L6EF8   .he 00,BF,FF,80,00,FF,FF,80 ; DB 00,BF,FF,80,00,FF,FF,80
        .he 00,FF,FF,80,00,FF,FE,80 ; DB 00,FF,FF,80,00,FF,FE,80
        .he 00,5F,FF,80,00,7F,FF,00 ; DB 00,5F,FF,80,00,7F,FF,00
        .he 00,7F,FF,00,00,00,00,00 ; DB 00,7F,FF,00,00,00,00,00

;L6F18   DB 00,7E,7E,00,01,FF,FF,80
;6F20    DB 03,FF,FF,C0,03,FF,FF,C0
;6F28    DB 03,FF,FF,C0,03,FF,FF,C0
;6F30    DB 03,FF,FF,C0,03,FF,FF,C0

L6F18   .he 00,7E,7E,00,01,FF,FF,80 ; DB 00,7E,7E,00,01,FF,FF,80
        .he 03,FF,FF,C0,03,FF,FF,C0 ; DB 03,FF,FF,C0,03,FF,FF,C0
        .he 03,FF,FF,C0,03,FF,FF,C0 ; DB 03,FF,FF,C0,03,FF,FF,C0
        .he 03,FF,FF,C0,03,FF,FF,C0 ; DB 03,FF,FF,C0,03,FF,FF,C0

;L6F38   DB 03,FF,FF,C0,01,3F,FC,80
;6F40    DB 01,3E,7C,80,01,FE,7F,80
;6F48    DB 01,FE,7F,00,00,FE,7F,00
;6F50    DB 00,FE,7F,00,00,9E,79,00

L6F38   .he 03,FF,FF,C0,01,3F,FC,80 ; DB 03,FF,FF,C0,01,3F,FC,80
        .he 01,3E,7C,80,01,FE,7F,80 ; DB 01,3E,7C,80,01,FE,7F,80
        .he 01,FE,7F,00,00,FE,7F,00 ; DB 01,FE,7F,00,00,FE,7F,00
        .he 00,FE,7F,00,00,9E,79,00 ; DB 00,FE,7F,00,00,9E,79,00

;L6F58   DB 00,9E,79,00,00,7E,7E,00
;6F60    DB 00,7E,7E,00,00,3E,7C,00
;6F68    DB 00,3E,7C,00,00,2E,74,00 ; .>......
;6F70    DB 00,3E,7C,00,00,00,00,00

L6F58   .he 00,9E,79,00,00,7E,7E,00 ; DB 00,9E,79,00,00,7E,7E,00
        .he 00,7E,7E,00,00,3E,7C,00 ; DB 00,7E,7E,00,00,3E,7C,00
        .he 00,3E,7C,00,00,2E,74,00 ; DB 00,3E,7C,00,00,2E,74,00
        .he 00,3E,7C,00,00,00,00,00 ; DB 00,3E,7C,00,00,00,00,00

;L6F78   DB 00,7E,5C,00,00,BE,5D,00 ; ..\...].
;6F80    DB 17,BE,5D,F8,2F,BE,5D,FC ; ..]./.].
;6F88    DB 2F,80,01,FC,00,3E,5C,00 ; /....>\.
;6F90    DB 3F,9E,59,FC,00,00,00,00 ; ?.Y.....

L6F78   .he 00,7E,5C,00,00,BE,5D,00 ; DB 00,7E,5C,00,00,BE,5D,00
        .he 17,BE,5D,F8,2F,BE,5D,FC ; DB 17,BE,5D,F8,2F,BE,5D,FC
        .he 2F,80,01,FC,00,3E,5C,00 ; DB 2F,80,01,FC,00,3E,5C,00
        .he 3F,9E,59,FC,00,00,00,00 ; DB 3F,9E,59,FC,00,00,00,00

;L6F98   DB 00,7E,7E,00,01,FF,FF,80
;6FA0    DB 03,FF,FF,C0,03,FF,FF,C0
;6FA8    DB 03,FF,FF,C0,03,FF,FF,C0
;6FB0    DB 03,FF,FF,C0,03,FF,FF,C0

L6F98   .he 00,7E,7E,00,01,FF,FF,80 ; DB 00,7E,7E,00,01,FF,FF,80
        .he 03,FF,FF,C0,03,FF,FF,C0 ; DB 03,FF,FF,C0,03,FF,FF,C0
        .he 03,FF,FF,C0,03,FF,FF,C0 ; DB 03,FF,FF,C0,03,FF,FF,C0
        .he 03,FF,FF,C0,03,FF,FF,C0 ; DB 03,FF,FF,C0,03,FF,FF,C0

;L6FB8   DB 01,3F,FC,80,01,FF,FF,80
;6FC0    DB 01,FF,FF,80,00,FE,7F,00
;6FC8    DB 00,F2,4F,00,00,CC,33,00 ; ..O...3.
;6FD0    DB 00,BE,7D,00,00,7E,7E,00

L6FB8   .he 01,3F,FC,80,01,FF,FF,80 ; DB 01,3F,FC,80,01,FF,FF,80
        .he 01,FF,FF,80,00,FE,7F,00 ; DB 01,FF,FF,80,00,FE,7F,00
        .he 00,F2,4F,00,00,CC,33,00 ; DB 00,F2,4F,00,00,CC,33,00
        .he 00,BE,7D,00,00,7E,7E,00 ; DB 00,BE,7D,00,00,7E,7E,00

;L6FD8   DB 03,3E,7C,C0,0F,9E,7C,C0
;6FE0    DB 17,EC,37,D8,3F,E0,07,F4 ; ..7.?...
;6FE8    DB 2F,C0,02,FC,3E,C0,03,F4 ; /...>...
;6FF0    DB 2B,80,01,AC,1E,00,00,78

L6FD8   .he 03,3E,7C,C0,0F,9E,7C,C0 ; DB 03,3E,7C,C0,0F,9E,7C,C0
        .he 17,EC,37,D8,3F,E0,07,F4 ; DB 17,EC,37,D8,3F,E0,07,F4
        .he 2F,C0,02,FC,3E,C0,03,F4 ; DB 2F,C0,02,FC,3E,C0,03,F4
        .he 2B,80,01,AC,1E,00,00,78 ; DB 2B,80,01,AC,1E,00,00,78

;L6FF8   DB 00,CC,33,00,01,BE,7D,80
;7000    DB 00,7E,7E,00,03,3E,7C,C0
;7008    DB 0F,9E,79,F0,17,ED,B7,D8
;7010    DB 3F,E3,C7,F4,2F,DF,FA,FC ; ?.../...

L6FF8   .he 00,CC,33,00,01,BE,7D,80 ; DB 00,CC,33,00,01,BE,7D,80
        .he 00,7E,7E,00,03,3E,7C,C0 ; DB 00,7E,7E,00,03,3E,7C,C0
        .he 0F,9E,79,F0,17,ED,B7,D8 ; DB 0F,9E,79,F0,17,ED,B7,D8
        .he 3F,E3,C7,F4,2F,DF,FA,FC ; DB 3F,E3,C7,F4,2F,DF,FA,FC

;L7018   DB 3E,DE,7B,F4,2B,BE,7D,AC ; >...+...
;7020    DB 1E,7F,FE,78,00,3E,7C,00
;7028    DB 00,07,E0,00,00,00,00,00
;7030    DB 00,00,00,00,00,00,00,00

L7018   .he 3E,DE,7B,F4,2B,BE,7D,AC ; DB 3E,DE,7B,F4,2B,BE,7D,AC
        .he 1E,7F,FE,78,00,3E,7C,00 ; DB 1E,7F,FE,78,00,3E,7C,00
        .he 00,07,E0,00,00,00,00,00 ; DB 00,07,E0,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00




;L8A2E   DW L8A3A,L8A3A,L8A4F,L8A64
;8A36    DW L8A6D,L8A6D

L8A2E   .wo L8A3A,L8A3A,L8A4F,L8A64 ; DW L8A3A,L8A3A,L8A4F,L8A64
        .wo L8A6D,L8A6D ; DW L8A6D,L8A6D

;L8A3A   DB 0A,00,03,00,0F,00,3F,00
;8A42    DB FC,03,F0,0F,C0,3F,00,FC
;8A4A    DB 00,F0,00,C0,00

L8A3A   .he 0A,00,03,00,0F,00,3F,00 ; DB 0A,00,03,00,0F,00,3F,00
        .he FC,03,F0,0F,C0,3F,00,FC ; DB FC,03,F0,0F,C0,3F,00,FC
        .he 00,F0,00,C0,00 ; DB 00,F0,00,C0,00

;L8A4F   DB 0A,00,00,00,00,00,00,00
;8A57    DB 00,00,00,00,00,30,00,F0
;8A5F    DB 00,F0,00,C0,00

L8A4F   .he 0A,00,00,00,00,00,00,00 ; DB 0A,00,00,00,00,00,00,00
        .he 00,00,00,00,00,30,00,F0 ; DB 00,00,00,00,00,30,00,F0
        .he 00,F0,00,C0,00 ; DB 00,F0,00,C0,00

;L8A64   DB 04,00,03,00,0F,00,0F,00
;8A6C    DB 0C

L8A64   .he 04,00,03,00,0F,00,0F,00 ; DB 04,00,03,00,0F,00,0F,00
        .he 0C ; DB 0C

;L8A6D   DB 01,00,00

L8A6D   .he 01,00,00 ; DB 01,00,00

;L8A70   DB 00,00,00,00,00,00,00,00
;8A78    DB 00,00,1F,3F,07,03,01,01
;8A80    DB 00,00,0B,D7,F6,ED,DB,BA
;8A88    DB 00,7F,FF,FF,00,7F,78,77
;8A90    DB 00,C0,F0,FF,00,FE,00,FE
;8A98    DB 00,00,00,FF,FF,D5,CA,D5
;8AA0    DB 00,00,00,FF,FF,55,AA,55 ; .....U.U
;8AA8    DB 06,0F,00,FF,FF,55,AA,55 ; .....U.U
;8AB0    DB 03,02,01,03,03,01,01,00
;8AB8    DB 74,F0,F3,37,37,F7,FB,CB ; ...77...
;8AC0    DB 70,78,7F,7F,78,77,70,78
;8AC8    DB 00,00,FE,FE,00,FE,00,00
;8AD0    DB DF,DF,DF,FF,FF,E0,FF,FF
;8AD8    DB FF,FF,FF,FF,FF,00,FF,FF
;8AE0    DB FF,FF,FF,FF,FF,00,80,00
;8AE8    DB 00,00,01,01,03,07,0E,0D
;8AF0    DB CD,FE,FF,FF,AF,57,AA,55 ; .....W.U
;8AF8    DB 7F,00,FF,FF,FF,E0,E8,CC
;8B00    DB FE,01,FF,FF,FE,18,18,08
;8B08    DB C0,80,00,00,00,00,00,00
;8B10    DB 1E,1D,3A,34,7B,71,66,73 ; ..:4....
;8B18    DB AA,55,AB,57,AF,D7,4F,9E ; .U.W..O.
;8B20    DB C6,C6,82,80,FF,00,00,00
;8B28    DB 08,18,30,E0,80,00,00,00
;8B30    DB E9,F5,FA,7D,3E,0F,03,00
;8B38    DB CE,5E,AE,56,AE,D7,FF,FF ; .^.V....
;8B40    DB 00,00,00,00,00,00,00,80



;L8B48   DB 3F,33,2D,29,33,3E,18,00 ; ?3-)3>..
;8B50    DB FF,FF,80,FF,FF,7F,3F,00
;8B58    DB FF,FF,06,FD,FD,F8,F8,00
;8B60    DB FF,7F,C0,FF,FF,FF,7F,FF
;8B68    DB 6F,4E,9E,F8,F0,C0,80,00
;8B70    DB 38,38,78,3F,38,38,3F,3F ; 88.?88??
;8B78    DB CE,FE,FE,FE,FC,FC,FC,FC
;8B80    DB 0E,0E,4E,4E,44,44,44,44 ; ..NNDDDD
;8B88    DB 7E,7E,76,76,04,04,04,04
;8B90    DB 72,7A,7A,7A,30,30,30,30 ; ....0000
;8B98    DB 70,F0,F2,F3,60,60,60,60
;8BA0    DB F3,FF,BF,BF,3F,3F,3F,3F ; ....????
;8BA8    DB 94,94,D5,C1,C9,C9,C9,C9
;8BB0    DB 77,7F,78,F8,FF,D8,B8,78
;8BB8    DB FE,FE,FE,FE,FF,FF,FF,CF
;8BC0    DB 0C,0C,0C,0C,5E,5E,5E,5E ; ....^^^^
;8BC8    DB 3C,3C,3C,3C,7E,7E,7E,7E ; <<<<....
;8BD0    DB 22,22,22,22,72,72,72,72 ; """"....
;8BD8    DB 20,20,20,20,73,72,72,70 ;     ....
;8BE0    DB 3F,3F,3F,3F,BF,BF,FF,F3 ; ????....
;8BE8    DB C9,C1,C1,C9,88,88,88,88
;8BF0    DB C0,80,8C,8C,80,C0,E0,A0
;8BF8    DB 03,01,99,99,99,01,03,FF
;8C00    DB 01,01,9F,87,9D,01,01,FF
;8C08    DB 83,93,93,83,93,11,11,FF
;8C10    DB C0,C0,C8,C8,88,8C,8C,8C
;8C18    DB F8,F2,F2,F2,F2,F2,F8,FF
;8C20    DB C3,49,49,41,4B,49,CD,FF ; .IIAKI..
;8C28    DB 01,01,33,33,03,03,01,01 ; ..33....
;8C30    DB 80,80,80,C4,C8,C0,F0,E0
;8C38    DB FF,E0,E6,E0,E4,E6,FF,FF
;8C40    DB FF,C0,4F,43,CF,40,FF,FF ; ..OC.@..
;8C48    DB FF,9C,9C,94,94,80,FF,FF
;8C50    DB FF,C3,99,81,99,99,FF,FF
;8C58    DB FF,06,32,02,26,32,FF,FF ; ..2.&2..
;8C60    DB FF,0F,67,67,67,0F,FF,FF
;8C68    DB FF,FF,FF,FF,FE,FE,FE,FE
;8C70    DB F3,F3,F3,F3,61,61,61,61
;8C78    DB FF,F7,01,37,81,D5,01,D7
;8C80    DB F8,F8,FC,FC,FC,FE,FE,FE
;8C88    DB C3,CB,CE,CE,80,80,80,80
;8C90    DB E2,FE,FC,FC,FC,F8,F8,F8
;8C98    DB 00,C0,A0,B8,BA,46,7C,CC
;8CA0    DB F8,FC,FC,FC,FC,FE,FE,FE
;8CA8    DB 40,40,40,40,D2,D2,F3,F3 ; @@@@....
;8CB0    DB F3,E7,CF,99,99,CF,FF,FF
;8CB8    DB FF,7B,FB,F8,7F,7F,7F,7F
;8CC0    DB FF,00,FF,00,FF,FF,FF,FF
;8CC8    DB CC,CC,CC,CC,80,80,80,81
;8CD0    DB 08,08,08,08,9C,94,94,94
;8CD8    DB 41,41,41,41,E3,E3,C9,C9 ; AAAA....
;8CE0    DB 8C,8C,8C,84,84,C4,C0,C0
;8CE8    DB 1F,71,60,44,46,46,62,73 ; ...DFF..

		; wanted poster graphics

poster_bottom1
	.he 80,80,80,C4,C8,C0,F0,E0
	.he 00,1F,19,1F,1B,19,00,00
	.he 00,3F,B0,BC,30,BF,00,00
	.he 00,63,63,6B,6B,7F,00,00
	.he 00,3C,66,7E,66,66,00,00
	.he 00,F9,CD,FD,D9,CD,00,00
	.he 00,F0,98,98,98,F0,00,00
	.he 00,00,00,00,01,01,01,01
	
	.he C0,80,8C,8C,80,C0,E0,A0
	.he 03,01,99,99,99,01,03,FF
	.he 01,01,9F,87,9D,01,01,FF
	.he 83,93,93,83,93,11,11,FF
	.he 03,01,99,99,99,01,03,FF
	.he F8,F2,F2,F2,F2,F2,F8,FF
	.he C3,49,49,41,4B,49,CD,FF
	.he 01,01,33,33,03,03,01,01

;poster_bottom2	
;	.he 88,80,87,07,00,27,47,87
;	.he FE,FE,FE,FE,FF,FF,FF,CF
;	.he 0C,0C,0C,0C,5E,5E,5E,5E
;	.he 3C,3C,3C,3C,7E,7E,7E,7E
;	.he 22,22,22,22,72,72,72,72
;	.he 20,20,20,20,73,72,72,70
;	.he 3F,3F,3F,3F,BF,BF,FF,F3
;	.he 11,01,E1,E0,00,E4,E2,E1
;	
;	.he C7,C7,87,C0,C7,C7,C0,C0
;	.he CE,FE,FE,FE,FC,FC,FC,FC
;	.he 0E,0E,4E,4E,44,44,44,44
;	.he 7E,7E,76,76,04,04,04,04
;	.he 72,7A,7A,7A,30,30,30,30
;	.he 70,F0,F2,F3,60,60,60,60
;	.he F3,FF,BF,BF,3F,3F,3F,3F
;	.he E3,E3,E1,03,E3,E3,03,03
;	
;	.he C0,CC,D2,D6,CC,C1,E7,FF
;	.he 00,00,7F,00,00,80,C0,FF
;	.he 00,00,7F,00,00,80,C0,FF
;	.he 00,00,F9,02,02,07,07,FF
;	.he 00,80,3F,00,00,00,80,00
;	.he 00,00,7F,00,00,80,C0,FF
;	.he 00,00,7F,00,00,80,C0,FF
;	.he 90,B1,61,07,0F,3F,7F,FF

		
;L8B48   .he 3F,33,2D,29,33,3E,18,00 ; DB 3F,33,2D,29,33,3E,18,00
;        .he FF,FF,80,FF,FF,7F,3F,00 ; DB FF,FF,80,FF,FF,7F,3F,00
;        .he FF,FF,06,FD,FD,F8,F8,00 ; DB FF,FF,06,FD,FD,F8,F8,00
;        .he FF,7F,C0,FF,FF,FF,7F,FF ; DB FF,7F,C0,FF,FF,FF,7F,FF
;        .he 6F,4E,9E,F8,F0,C0,80,00 ; DB 6F,4E,9E,F8,F0,C0,80,00
;        .he 38,38,78,3F,38,38,3F,3F ; DB 38,38,78,3F,38,38,3F,3F
;        .he CE,FE,FE,FE,FC,FC,FC,FC ; DB CE,FE,FE,FE,FC,FC,FC,FC
;        .he 0E,0E,4E,4E,44,44,44,44 ; DB 0E,0E,4E,4E,44,44,44,44
;        .he 7E,7E,76,76,04,04,04,04 ; DB 7E,7E,76,76,04,04,04,04
;        .he 72,7A,7A,7A,30,30,30,30 ; DB 72,7A,7A,7A,30,30,30,30
;        .he 70,F0,F2,F3,60,60,60,60 ; DB 70,F0,F2,F3,60,60,60,60
;        .he F3,FF,BF,BF,3F,3F,3F,3F ; DB F3,FF,BF,BF,3F,3F,3F,3F
;        .he 94,94,D5,C1,C9,C9,C9,C9 ; DB 94,94,D5,C1,C9,C9,C9,C9
;        .he 77,7F,78,F8,FF,D8,B8,78 ; DB 77,7F,78,F8,FF,D8,B8,78
;        .he FE,FE,FE,FE,FF,FF,FF,CF ; DB FE,FE,FE,FE,FF,FF,FF,CF
;        .he 0C,0C,0C,0C,5E,5E,5E,5E ; DB 0C,0C,0C,0C,5E,5E,5E,5E
;        .he 3C,3C,3C,3C,7E,7E,7E,7E ; DB 3C,3C,3C,3C,7E,7E,7E,7E
;        .he 22,22,22,22,72,72,72,72 ; DB 22,22,22,22,72,72,72,72
;        .he 20,20,20,20,73,72,72,70 ; DB 20,20,20,20,73,72,72,70
;        .he 3F,3F,3F,3F,BF,BF,FF,F3 ; DB 3F,3F,3F,3F,BF,BF,FF,F3
;        .he C9,C1,C1,C9,88,88,88,88 ; DB C9,C1,C1,C9,88,88,88,88
;        .he C0,80,8C,8C,80,C0,E0,A0 ; DB C0,80,8C,8C,80,C0,E0,A0
;        .he 03,01,99,99,99,01,03,FF ; DB 03,01,99,99,99,01,03,FF
;        .he 01,01,9F,87,9D,01,01,FF ; DB 01,01,9F,87,9D,01,01,FF
;        .he 83,93,93,83,93,11,11,FF ; DB 83,93,93,83,93,11,11,FF
;        .he C0,C0,C8,C8,88,8C,8C,8C ; DB C0,C0,C8,C8,88,8C,8C,8C
;        .he F8,F2,F2,F2,F2,F2,F8,FF ; DB F8,F2,F2,F2,F2,F2,F8,FF
;        .he C3,49,49,41,4B,49,CD,FF ; DB C3,49,49,41,4B,49,CD,FF
;        .he 01,01,33,33,03,03,01,01 ; DB 01,01,33,33,03,03,01,01
;        .he 80,80,80,C4,C8,C0,F0,E0 ; DB 80,80,80,C4,C8,C0,F0,E0
;        .he FF,E0,E6,E0,E4,E6,FF,FF ; DB FF,E0,E6,E0,E4,E6,FF,FF
;        .he FF,C0,4F,43,CF,40,FF,FF ; DB FF,C0,4F,43,CF,40,FF,FF
;        .he FF,9C,9C,94,94,80,FF,FF ; DB FF,9C,9C,94,94,80,FF,FF
;        .he FF,C3,99,81,99,99,FF,FF ; DB FF,C3,99,81,99,99,FF,FF
;        .he FF,06,32,02,26,32,FF,FF ; DB FF,06,32,02,26,32,FF,FF
;        .he FF,0F,67,67,67,0F,FF,FF ; DB FF,0F,67,67,67,0F,FF,FF
;        .he FF,FF,FF,FF,FE,FE,FE,FE ; DB FF,FF,FF,FF,FE,FE,FE,FE
;        .he F3,F3,F3,F3,61,61,61,61 ; DB F3,F3,F3,F3,61,61,61,61
;        .he FF,F7,01,37,81,D5,01,D7 ; DB FF,F7,01,37,81,D5,01,D7
;        .he F8,F8,FC,FC,FC,FE,FE,FE ; DB F8,F8,FC,FC,FC,FE,FE,FE
;        .he C3,CB,CE,CE,80,80,80,80 ; DB C3,CB,CE,CE,80,80,80,80
;        .he E2,FE,FC,FC,FC,F8,F8,F8 ; DB E2,FE,FC,FC,FC,F8,F8,F8
;        .he 00,C0,A0,B8,BA,46,7C,CC ; DB 00,C0,A0,B8,BA,46,7C,CC
;        .he F8,FC,FC,FC,FC,FE,FE,FE ; DB F8,FC,FC,FC,FC,FE,FE,FE
;        .he 40,40,40,40,D2,D2,F3,F3 ; DB 40,40,40,40,D2,D2,F3,F3
;        .he F3,E7,CF,99,99,CF,FF,FF ; DB F3,E7,CF,99,99,CF,FF,FF
;        .he FF,7B,FB,F8,7F,7F,7F,7F ; DB FF,7B,FB,F8,7F,7F,7F,7F
;        .he FF,00,FF,00,FF,FF,FF,FF ; DB FF,00,FF,00,FF,FF,FF,FF
;        .he CC,CC,CC,CC,80,80,80,81 ; DB CC,CC,CC,CC,80,80,80,81
;        .he 08,08,08,08,9C,94,94,94 ; DB 08,08,08,08,9C,94,94,94
;        .he 41,41,41,41,E3,E3,C9,C9 ; DB 41,41,41,41,E3,E3,C9,C9
;        .he 8C,8C,8C,84,84,C4,C0,C0 ; DB 8C,8C,8C,84,84,C4,C0,C0
;        .he 1F,71,60,44,46,46,62,73 ; DB 1F,71,60,44,46,46,62,73

;L8CF0   DB 00,00,00,00,00,00,00,00
;8CF8    DB FF,FF,C0,C6,C0,D7,D7,C6
;8D00    DB FF,FF,00,66,00,FF,FF,00
;8D08    DB C6,D6,D6,C6,C6,D6,D6,C6
;8D10    DB 00,00,00,01,01,01,01,01
;8D18    DB 00,00,3F,FF,FF,FF,FF,FF
;8D20    DB 00,00,00,00,00,00,01,01
;8D28    DB 00,00,18,3C,7E,FF,FF,FF
;8D30    DB 03,03,07,0F,3F,FF,FF,FF
;8D38    DB FC,F0,E0,E0,C0,C1,C1,C0
;8D40    DB 03,07,07,0F,0F,0F,1F,1F
;8D48    DB FF,FC,F0,E0,E0,C0,C1,C1
;8D50    DB FF,3F,0F,07,07,03,83,83
;8D58    DB E0,E0,F0,FC,FF,FF,FF,FF
;8D60    DB 3F,3F,07,03,01,00,00,00 ; ??......
;8D68    DB C0,E0,E0,F0,FC,FF,FF,FF
;8D70    DB 03,07,07,0F,3F,FF,FF,FF
;8D78    DB F8,E0,C3,8F,9F,1C,39,3B ; ......9;
;8D80    DB 00,7F,40,46,46,58,5B,42 ; ..@FFX[B
;8D88    DB 00,FF,00,66,66,00,FF,00
;8D90    DB 42,5A,5A,42,42,5A,5A,42 ; BZZBBZZB
;8D98    DB 00,02,1F,3E,3A,3A,3E,0F ; ...>::>.
;8DA0    DB 00,40,F0,58,40,40,40,F0 ; .@.X@@@.
;8DA8    DB 03,02,32,72,3E,1F,02,00 ; ..2.>...
;8DB0    DB F8,7C,5C,5C,78,E0,40,00 ; ..\\..@.
;8DB8    DB 00,00,06,0F,0F,0F,27,63
;8DC0    DB 00,40,E0,E0,EE,CF,CF,2F ; .@...../
;8DC8    DB EC,F7,F8,FF,7F,3F,0E,00
;8DD0    DB DF,3E,FC,E2,82,04,04,08
;8DD8    DB 04,02,01,00,00,00,00,00
;8DE0    DB 08,10,20,C0,00,00,00,00
;8DE8    DB 00,00,05,1D,76,7A,3B,3D ; ......;=
;8DF0    DB 1D,1B,2E,2F,17,17,0B,0B ; .../....
;8DF8    DB 80,80,C0,40,60,A0,B0,D0
;8E00    DB 05,05,02,02,01,01,00,00
;8E08    DB D8,E8,EC,F4,76,7A,BB,BB
;8E10    DB 5D,5E,2E,2F,17,14,0B,07 ; ]^./....
;8E18    DB 80,80,C0,40,20,F0,F0,D8 ; ...@ ...
;8E20    DB 07,0C,11,63,D3,69,69,34
;8E28    DB 28,2C,94,96,CA,CB,E5,E5 ; (,......
;8E30    DB 00,00,00,00,00,00,00,80
;8E38    DB 34,1A,1B,2D,2D,36,76,C3 ; 4..--6..
;8E40    DB FE,7E,FF,FF,FC,F3,CF,3F
;8E48    DB 80,C0,40,30,D8,D8,BC,BF ; ..@0....
;8E50    DB 83,A5,DD,42,60,30,18,0E ; ...B.0..
;8E58    DB FF,FF,FE,EE,D7,3B,FA,FC
;8E60    DB 60,40,00,00,00,00,00,00
;8E68    DB 00,00,00,00,00,00,00,1F
;8E70    DB 05,05,03,07,0F,1B,70,E0
;8E78    DB FC,FE,FE,FE,FE,FE,FE,04
;8E80    DB 2F,2F,17,17,0B,0B,05,05 ; //......
;8E88    DB F1,F4,F6,F0,F9,F7,F3,F6
;8E90    DB AC,B8,30,60,C0,80,00,00
;8E98    DB 02,02,01,01,00,00,00,00
;8EA0    DB F6,FC,78,70,D0,D0,00,00

		; background graphics for duck shoot screen
L8CF0   .he 00,00,00,00,00,00,00,00 ; blank 			; DB 00,00,00,00,00,00,00,00

BORDERC .he FF,FF,C0,C6,C0,D7,D7,C6 ; border top left 	; DB FF,FF,C0,C6,C0,D7,D7,C6
BORDERH .he FF,FF,00,66,00,FF,FF,00 ; border top 		; DB FF,FF,00,66,00,FF,FF,00
BORDERS .he C6,D6,D6,C6,C6,D6,D6,C6 ; border sides 		; DB C6,D6,D6,C6,C6,D6,D6,C6

BARELBE .he 00,00,00,00,00,00,00,00
		.he 00,00,00,00,00,00,00,00
		.he 00,00,00,01,01,01,01,01 
        .he 00,00,3F,FF,FF,FF,FF,FF 
        
		.he 00,00,00,00,00,00,01,01 
        .he 00,00,18,3C,7E,FF,FF,FF
   		.he 03,03,07,0F,3F,FF,FF,FF 
        .he FC,F0,E0,E0,C0,C1,C1,C0 
		
		.he 03,07,07,0F,0F,0F,1F,1F 
        .he FF,FC,F0,E0,E0,C0,C1,C1 
        .he FF,3F,0F,07,07,03,83,83 
        .he E0,E0,F0,FC,FF,FF,FF,FF 
        
		.he 3F,3F,07,03,01,00,00,00 
        .he C0,E0,E0,F0,FC,FF,FF,FF 
        .he 03,07,07,0F,3F,FF,FF,FF 
        .he F8,E0,C3,8F,9F,1C,39,3B 


		.he 00,00,00,01,03,07,3f,3f
		.he ff,ff,ff,fc,f0,e0,e0,c0
		.he ff,ff,ff,3f,0f,07,07,03
		.he 3b,39,1c,9f,8f,c3,e0,f8

		.he 1f,1f,0f,0f,0f,07,07,03
		.he c1,c1,c0,e0,e0,f0,fc,ff
		.he 83,83,03,07,07,0f,3f,ff
		.he ff,ff,ff,ff,fc,f0,e0,e0
		
		.he 01,01,00,00,00,00,00,00
		.he ff,ff,ff,7e,3c,18,00,00
		.he ff,ff,ff,3f,0f,07,03,03
		.he c0,c1,c1,c0,e0,e0,f0,fc

		.he 00,00,00,00,00,00,00,00
		.he 00,00,00,00,00,00,00,00
		.he 01,01,01,01,01,00,00,00
		.he ff,ff,ff,ff,ff,3f,00,00
	
SBORDEC .he 00,7F,40,46,46,58,5B,42 ; DB 00,7F,40,46,46,58,5B,42
SBORDEH .he 00,FF,00,66,66,00,FF,00 ; DB 00,FF,00,66,66,00,FF,00
SBORDES .he 42,5A,5A,42,42,5A,5A,42 ; DB 42,5A,5A,42,42,5A,5A,42

DOLLORB .he 00,02,1F,3E,3A,3A,3E,0F ; DB 00,02,1F,3E,3A,3A,3E,0F
        .he 00,40,F0,58,40,40,40,F0 ; DB 00,40,F0,58,40,40,40,F0
        .he 03,02,32,72,3E,1F,02,00 ; DB 03,02,32,72,3E,1F,02,00
        .he F8,7C,5C,5C,78,E0,40,00 ; DB F8,7C,5C,5C,78,E0,40,00
        
LIVESHA	.he 00,00,06,0F,0F,0F,27,63 ; DB 00,00,06,0F,0F,0F,27,63
        .he 00,40,E0,E0,EE,CF,CF,2F ; DB 00,40,E0,E0,EE,CF,CF,2F
        .he EC,F7,F8,FF,7F,3F,0E,00 ; DB EC,F7,F8,FF,7F,3F,0E,00
        .he DF,3E,FC,E2,82,04,04,08 ; DB DF,3E,FC,E2,82,04,04,08
        .he 04,02,01,00,00,00,00,00 ; DB 04,02,01,00,00,00,00,00
        .he 08,10,20,C0,00,00,00,00 ; DB 08,10,20,C0,00,00,00,00

RGUNBEG .he 00,00,05,1D,76,7A,3B,3D ; DB 00,00,05,1D,76,7A,3B,3D
        .he 00,00,00,00,00,00,00,00 ; 1
		.he 00,00,00,00,00,00,00,00
		.he 00,00,00,00,00,00,00,00
	
		.he 1D,1B,2E,2F,17,17,0B,0B ; DB 1D,1B,2E,2F,17,17,0B,0B
        .he 80,80,C0,40,60,A0,B0,D0 ; DB 80,80,C0,40,60,A0,B0,D0
        .he 00,00,00,00,00,00,00,00 ; 2
		.he 00,00,00,00,00,00,00,00
		
		.he 05,05,02,02,01,01,00,00 ; DB 05,05,02,02,01,01,00,00
        .he D8,E8,EC,F4,76,7A,BB,BB ; DB D8,E8,EC,F4,76,7A,BB,BB
        .he 00,00,00,00,00,00,00,00 ; 3
		.he 00,00,00,00,00,00,00,00
		
		.he 00,00,00,00,00,00,00,00 ; 4
		.he 5D,5E,2E,2F,17,14,0B,07 ; DB 5D,5E,2E,2F,17,14,0B,07
        .he 80,80,C0,40,20,F0,F0,D8 ; DB 80,80,C0,40,20,F0,F0,D8
        .he 00,00,00,00,00,00,00,00
		
		.he 00,00,00,00,00,00,00,00 ; 5
		.he 07,0C,11,63,D3,69,69,34 ; DB 07,0C,11,63,D3,69,69,34
        .he 28,2C,94,96,CA,CB,E5,E5 ; DB 28,2C,94,96,CA,CB,E5,E5
        .he 00,00,00,00,00,00,00,80 ; DB 00,00,00,00,00,00,00,80
        
		.he 00,00,00,00,00,00,00,00 ; 6
		.he 34,1A,1B,2D,2D,36,76,C3 ; DB 34,1A,1B,2D,2D,36,76,C3
        .he FE,7E,FF,FF,FC,F3,CF,3F ; DB FE,7E,FF,FF,FC,F3,CF,3F
        .he 80,C0,40,30,D8,D8,BC,BF ; DB 80,C0,40,30,D8,D8,BC,BF
        
		.he 00,00,00,00,00,00,00,00 ; 7 
		.he 83,A5,DD,42,60,30,18,0E ; DB 83,A5,DD,42,60,30,18,0E
        .he FF,FF,FE,EE,D7,3B,FA,FC ; DB FF,FF,FE,EE,D7,3B,FA,FC
        .he 60,40,00,00,00,00,00,00 ; DB 60,40,00,00,00,00,00,00
        
		.he 00,00,00,00,00,00,00,1F ; DB 00,00,00,00,00,00,00,1F
        .he 05,05,03,07,0F,1B,70,E0 ; DB 05,05,03,07,0F,1B,70,E0
        .he FC,FE,FE,FE,FE,FE,FE,04 ; DB FC,FE,FE,FE,FE,FE,FE,04
        .he 00,00,00,00,00,00,00,00 ; 8
		
		.he 2F,2F,17,17,0B,0B,05,05 ; DB 2F,2F,17,17,0B,0B,05,05
        .he F1,F4,F6,F0,F9,F7,F3,F6 ; DB F1,F4,F6,F0,F9,F7,F3,F6
        .he AC,B8,30,60,C0,80,00,00 ; DB AC,B8,30,60,C0,80,00,00
        .he 00,00,00,00,00,00,00,00 ; 9
		
		.he 02,02,01,01,00,00,00,00 ; DB 02,02,01,01,00,00,00,00
        .he F6,FC,78,70,D0,D0,00,00 ; DB F6,FC,78,70,D0,D0,00,00
		.he 00,00,00,00,00,00,00,00 ; 10
		.he 00,00,00,00,00,00,00,00 ;
		
;L8EA8   DB 00,00,00,00,00,00,00

L8EA8   .he 00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00

;L8EAF   DB 00

L8EAF   .he 00 ; DB 00

;L8EB0   DB 3E,63,63,63,63,63,3E,00 ; >.....>.
;8EB8    DB 0C,1C,0C,0C,0C,0C,1E,00
;8EC0    DB 1E,23,03,03,1E,30,7F,00 ; .#...0..
;8EC8    DB 1E,23,0E,03,03,43,3E,00 ; .#...C>.
;8ED0    DB 10,10,20,2C,4C,7E,0C,00 ; .. ,L...
;8ED8    DB 7F,60,7E,03,03,43,3E,00 ; .....C>.
;8EE0    DB 08,10,20,7E,63,63,3E,00 ; .. ...>.
;8EE8    DB 7F,03,06,06,0C,0C,18,00
;8EF0    DB 3E,63,63,3E,63,63,3E,00 ; >..>..>.
;8EF8    DB 3E,63,63,3F,02,04,08,00 ; >..?....
;8F00    DB 3E,7F,63,63,7F,63,63,00
;8F08    DB 3E,33,33,3E,33,33,3E,00 ; >33>33>.
;8F10    DB 3E,71,60,60,60,71,3E,00 ; >.....>.
;8F18    DB 7E,63,61,61,61,63,7E,00
;8F20    DB 7F,60,60,78,78,60,7F,00
;8F28    DB 7F,60,60,78,78,60,60,00
;8F30    DB 3E,71,60,6F,63,73,3F,00 ; >.....?.
;8F38    DB 63,63,63,7F,63,63,63,00
;8F40    DB 3E,0C,0C,0C,0C,0C,3E,00 ; >.....>.
;8F48    DB 3E,0C,0C,0C,0C,4C,38,00 ; >....L8.
;8F50    DB 66,6C,78,7C,6E,67,63,00
;8F58    DB 60,60,60,60,60,60,7F,00
;8F60    DB 36,7F,6B,6B,6B,63,63,00
;8F68    DB 73,73,7B,6B,6F,67,67,00
;8F70    DB 3E,63,63,63,63,63,3E,00 ; >.....>.
;8F78    DB 7E,33,33,3E,30,30,30,00 ; .33>000.
;8F80    DB 3C,66,66,66,6C,6E,3A,00 ; <.....:.
;8F88    DB 7E,63,63,7E,6C,66,63,00
;8F90    DB 3E,71,60,7E,07,43,3E,00 ; >....C>.
;8F98    DB 3F,4D,0C,0C,0C,0C,0C,00 ; ?M......
;8FA0    DB 63,63,63,63,63,63,3E,00
;8FA8    DB 63,36,36,14,1C,08,1C,00 ; .66.....
;8FB0    DB 63,63,6B,6B,6B,7F,77,00
;8FB8    DB 63,36,3E,1C,3E,36,63,00 ; .6>.>6..
;8FC0    DB 67,36,1E,0C,0C,58,30,00 ; .6...X0.
;8FC8    DB 7F,46,0C,18,30,61,7F,00 ; .F..0...
;8FD0    DB 3C,42,99,A1,A1,99,42,3C ; <B....B<
;8FD8    DB 00,00,00,00,00,18,18,00
;8FE0    DB 06,06,0C,0C,18,18,00,30
;8FE8    DB 08,3E,28,3E,0A,3E,08,00 ; .>(>.>..
;8FF0    DB 00,14,08,3E,08,14,00,00

		; font data graphics
tfont_n	.he 00,00,00,00,00,00,00,00 ; spc 40
L8EB0   .he 3E,63,63,63,63,63,3E,00 ; 0 00   DB 3E,63,63,63,63,63,3E,00
sfont   .he 0C,1C,0C,0C,0C,0C,1E,00 ; 1 08   DB 0C,1C,0C,0C,0C,0C,1E,00
        .he 1E,23,03,03,1E,30,7F,00 ; 2 16   DB 1E,23,03,03,1E,30,7F,00
        .he 1E,23,0E,03,03,43,3E,00 ; 3 24   DB 1E,23,0E,03,03,43,3E,00
        .he 10,10,20,2C,4C,7E,0C,00 ; 4 32   DB 10,10,20,2C,4C,7E,0C,00
        .he 7F,60,7E,03,03,43,3E,00 ; 5 40   DB 7F,60,7E,03,03,43,3E,00
        .he 08,10,20,7E,63,63,3E,00 ; 6 48   DB 08,10,20,7E,63,63,3E,00
        .he 7F,03,06,06,0C,0C,18,00 ; 7 56   DB 7F,03,06,06,0C,0C,18,00
        .he 3E,63,63,3E,63,63,3E,00 ; 8 64   DB 3E,63,63,3E,63,63,3E,00
        .he 3E,63,63,3F,02,04,08,00 ; 9 72   DB 3E,63,63,3F,02,04,08,00
		.he 08,FE,C8,7E,2A,FE,28,00 ; $ 80
		.he 3C,42,99,A1,A1,99,42,3C ; (c) 88
		

fontdta .he 00,00,00,00,00,00,00,00 ; spc 00
        .he 3E,7F,63,63,7F,63,63,00 ; A 08  DB 3E,7F,63,63,7F,63,63,00
        .he 3E,33,33,3E,33,33,3E,00 ; B 16  DB 3E,33,33,3E,33,33,3E,00
        .he 3E,71,60,60,60,71,3E,00 ; C 24  DB 3E,71,60,60,60,71,3E,00
        .he 7E,63,61,61,61,63,7E,00 ; D 32  DB 7E,63,61,61,61,63,7E,00
        .he 7F,60,60,78,78,60,7F,00 ; E 40  DB 7F,60,60,78,78,60,7F,00
        .he 7F,60,60,78,78,60,60,00 ; F 48  DB 7F,60,60,78,78,60,60,00
        .he 3E,71,60,6F,63,73,3F,00 ; G 56  DB 3E,71,60,6F,63,73,3F,00
        .he 63,63,63,7F,63,63,63,00 ; H 64  DB 63,63,63,7F,63,63,63,00
        .he 3E,0C,0C,0C,0C,0C,3E,00 ; I 72  DB 3E,0C,0C,0C,0C,0C,3E,00
        .he 3E,0C,0C,0C,0C,4C,38,00 ; J 80  DB 3E,0C,0C,0C,0C,4C,38,00
        .he 66,6C,78,7C,6E,67,63,00 ; K 88  DB 66,6C,78,7C,6E,67,63,00
        .he 60,60,60,60,60,60,7F,00 ; L 96  DB 60,60,60,60,60,60,7F,00
        .he 36,7F,6B,6B,6B,63,63,00 ; M 104 DB 36,7F,6B,6B,6B,63,63,00
        .he 73,73,7B,6B,6F,67,67,00 ; N 112 DB 73,73,7B,6B,6F,67,67,00
        .he 3E,63,63,63,63,63,3E,00 ; O 120 DB 3E,63,63,63,63,63,3E,00
        .he 7E,33,33,3E,30,30,30,00 ; P 128 DB 7E,33,33,3E,30,30,30,00
        .he 3C,66,66,66,6C,6E,3A,00 ; Q 136 DB 3C,66,66,66,6C,6E,3A,00
        .he 7E,63,63,7E,6C,66,63,00 ; R 144 DB 7E,63,63,7E,6C,66,63,00
        .he 3E,71,60,7E,07,43,3E,00 ; S 152 DB 3E,71,60,7E,07,43,3E,00
        .he 3F,4D,0C,0C,0C,0C,0C,00 ; T 160 DB 3F,4D,0C,0C,0C,0C,0C,00
        .he 63,63,63,63,63,63,3E,00 ; U 168 DB 63,63,63,63,63,63,3E,00
        .he 63,36,36,14,1C,08,1C,00 ; V 176 DB 63,36,36,14,1C,08,1C,00
        .he 63,63,6B,6B,6B,7F,77,00 ; W 184 DB 63,63,6B,6B,6B,7F,77,00
        .he 63,36,3E,1C,3E,36,63,00 ; X 192 DB 63,36,3E,1C,3E,36,63,00
        .he 67,36,1E,0C,0C,58,30,00 ; Y 200 DB 67,36,1E,0C,0C,58,30,00
        .he 7F,46,0C,18,30,61,7F,00 ; Z 208 DB 7F,46,0C,18,30,61,7F,00

        .he 3C,42,99,A1,A1,99,42,3C ; (c) 216	DB 3C,42,99,A1,A1,99,42,3C
        .he 00,00,00,00,00,18,18,00 ; . 224 DB 00,00,00,00,00,18,18,00
        .he 06,06,0C,0C,18,18,00,30 ; ! 232 DB 06,06,0C,0C,18,18,00,30
        .he 08,3E,28,3E,0A,3E,08,00 ; $ 240 DB 08,3E,28,3E,0A,3E,08,00
        .he 00,14,08,3E,08,14,00,00 ; * 248 DB 00,14,08,3E,08,14,00,00

;L8FF8   DW L9042,L90C3,L9144,L91C5
;9000    DW L9246,L92C7,L9348,L93C9
;9008    DW L944A,L94CB,L953C,L95AD
;9010    DW L961E,L968F,L9700,L9781
;9018    DW L9802,L9883,L9904,L9975
;9020    DW L99E6,L9A57,L9AD8,L9B59
;9028    DW L9BDA,L9C5B,L9CCC,L9D3D
;9030    DW L9DAE,L9E1F,L9EA0,L9F21
;9038    DW L9F92,LA003,LA084,LA105
;9040    DW LA186

L8FF8   .wo L9042,L90C3,L9144,L91C5 ; DW L9042,L90C3,L9144,L91C5
        .wo L9246,L92C7,L9348,L93C9 ; DW L9246,L92C7,L9348,L93C9
        .wo L944A,L94CB,L953C,L95AD ; DW L944A,L94CB,L953C,L95AD
        .wo L961E,L968F,L9700,L9781 ; DW L961E,L968F,L9700,L9781
        .wo L9802,L9883,L9904,L9975 ; DW L9802,L9883,L9904,L9975
        .wo L99E6,L9A57,L9AD8,L9B59 ; DW L99E6,L9A57,L9AD8,L9B59
        .wo L9BDA,L9C5B,L9CCC,L9D3D ; DW L9BDA,L9C5B,L9CCC,L9D3D
        .wo L9DAE,L9E1F,L9EA0,L9F21 ; DW L9DAE,L9E1F,L9EA0,L9F21
        .wo L9F92,LA003,LA084,LA105 ; DW L9F92,LA003,LA084,LA105
        .wo LA186 ; DW LA186

;L9042   DB 40,00,03,00,03,00,23,00 ; @.....#.
;904A    DB 73,03,77,0B,77,1B,77,5B
;9052    DB 77,5B,77,5B,77,7B,77,7B ; .[.[....
;905A    DB 7F,77,7F,77,77,77,77,77
;9062    DB 77,77,7F,77,7F,77,7F,77
;906A    DB 7F,77,7F,77,7F,7B,7B,7B
;9072    DB 7B,7B,7B,7B,7B,75,7B,75
;907A    DB 7B,75,75,5B,75,5B,75,5F ; ...[.[._
;9082    DB 75,6F,73,6F,7B,6F,7B,6F
;908A    DB 7A,77,7E,77,7E,77,7D,7B
;9092    DB 7D,7B,7D,6D,7B,5D,7B,5D ; .....].]
;909A    DB 7B,5D,7B,5D,5F,5D,5B,6B ; .].]_][.
;90A2    DB 5B,6B,5B,6B,5B,6B,4D,6B ; [.[.[.M.
;90AA    DB 6D,6F,6F,6F,6F,6F,6F,6F
;90B2    DB 6F,6F,6F,7F,7C,7F,73,7F
;90BA    DB 4F,7F,3F,7E,FF,73,FF,4F ; O.?....O
;90C2    DB FC

L9042   .he 40,00,03,00,03,00,23,00 ; DB 40,00,03,00,03,00,23,00
        .he 73,03,77,0B,77,1B,77,5B ; DB 73,03,77,0B,77,1B,77,5B
        .he 77,5B,77,5B,77,7B,77,7B ; DB 77,5B,77,5B,77,7B,77,7B
        .he 7F,77,7F,77,77,77,77,77 ; DB 7F,77,7F,77,77,77,77,77
        .he 77,77,7F,77,7F,77,7F,77 ; DB 77,77,7F,77,7F,77,7F,77
        .he 7F,77,7F,77,7F,7B,7B,7B ; DB 7F,77,7F,77,7F,7B,7B,7B
        .he 7B,7B,7B,7B,7B,75,7B,75 ; DB 7B,7B,7B,7B,7B,75,7B,75
        .he 7B,75,75,5B,75,5B,75,5F ; DB 7B,75,75,5B,75,5B,75,5F
        .he 75,6F,73,6F,7B,6F,7B,6F ; DB 75,6F,73,6F,7B,6F,7B,6F
        .he 7A,77,7E,77,7E,77,7D,7B ; DB 7A,77,7E,77,7E,77,7D,7B
        .he 7D,7B,7D,6D,7B,5D,7B,5D ; DB 7D,7B,7D,6D,7B,5D,7B,5D
        .he 7B,5D,7B,5D,5F,5D,5B,6B ; DB 7B,5D,7B,5D,5F,5D,5B,6B
        .he 5B,6B,5B,6B,5B,6B,4D,6B ; DB 5B,6B,5B,6B,5B,6B,4D,6B
        .he 6D,6F,6F,6F,6F,6F,6F,6F ; DB 6D,6F,6F,6F,6F,6F,6F,6F
        .he 6F,6F,6F,7F,7C,7F,73,7F ; DB 6F,6F,6F,7F,7C,7F,73,7F
        .he 4F,7F,3F,7E,FF,73,FF,4F ; DB 4F,7F,3F,7E,FF,73,FF,4F
        .he FC ; DB FC

;L90C3   DB 40,00,00,00,00,00,00,00
;90CB    DB 00,00,00,00,00,34,00,F2
;90D3    DB 00,F5,40,F2,80,F5,40,F2 ; ..@...@.
;90DB    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;90E3    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;90EB    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;90F3    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;90FB    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;9103    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;910B    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;9113    DB 80,F5,40,F2,80,F5,43,F0 ; ..@...C.
;911B    DB 97,F2,37,F9,B7,F5,B7,F5
;9123    DB B7,F5,B7,F5,B7,F6,B7,FE
;912B    DB B7,FF,B7,FF,B7,FF,B7,FF
;9133    DB B7,FF,BB,FF,B8,FF,B3,FF
;913B    DB 8F,FF,3F,FC,FF,F3,FF,CF
;9143    DB FC

L90C3   .he 40,00,00,00,00,00,00,00 ; DB 40,00,00,00,00,00,00,00
        .he 00,00,00,00,00,34,00,F2 ; DB 00,00,00,00,00,34,00,F2
        .he 00,F5,40,F2,80,F5,40,F2 ; DB 00,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,43,F0 ; DB 80,F5,40,F2,80,F5,43,F0
        .he 97,F2,37,F9,B7,F5,B7,F5 ; DB 97,F2,37,F9,B7,F5,B7,F5
        .he B7,F5,B7,F5,B7,F6,B7,FE ; DB B7,F5,B7,F5,B7,F6,B7,FE
        .he B7,FF,B7,FF,B7,FF,B7,FF ; DB B7,FF,B7,FF,B7,FF,B7,FF
        .he B7,FF,BB,FF,B8,FF,B3,FF ; DB B7,FF,BB,FF,B8,FF,B3,FF
        .he 8F,FF,3F,FC,FF,F3,FF,CF ; DB 8F,FF,3F,FC,FF,F3,FF,CF
        .he FC ; DB FC

;L9144   DB 40,00,03,00,07,00,07,00
;914C    DB 07,00,07,00,07,00,07,00
;9154    DB 07,00,07,00,07,00,07,00
;915C    DB 07,00,07,00,07,00,07,00
;9164    DB 07,00,07,00,07,00,07,00
;916C    DB 07,00,07,00,07,00,07,00
;9174    DB 07,00,07,00,07,00,07,00
;917C    DB 07,00,07,00,07,00,07,00
;9184    DB 07,00,07,00,07,00,07,00
;918C    DB 07,00,07,00,07,00,07,00
;9194    DB 0F,00,2F,00,2F,00,2F,00 ; ../././.
;919C    DB 6F,01,6F,03,EF,03,EF,0B
;91A4    DB EF,5B,F7,DB,F7,9B,F7,9A
;91AC    DB F7,B6,77,B6,77,B7,77,F7
;91B4    DB 77,F7,F7,F7,F4,F7,F3,F7
;91BC    DB CF,F7,3F,F4,FF,F3,FF,CF
;91C4    DB FC

L9144   .he 40,00,03,00,07,00,07,00 ; DB 40,00,03,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 0F,00,2F,00,2F,00,2F,00 ; DB 0F,00,2F,00,2F,00,2F,00
        .he 6F,01,6F,03,EF,03,EF,0B ; DB 6F,01,6F,03,EF,03,EF,0B
        .he EF,5B,F7,DB,F7,9B,F7,9A ; DB EF,5B,F7,DB,F7,9B,F7,9A
        .he F7,B6,77,B6,77,B7,77,F7 ; DB F7,B6,77,B6,77,B7,77,F7
        .he 77,F7,F7,F7,F4,F7,F3,F7 ; DB 77,F7,F7,F7,F4,F7,F3,F7
        .he CF,F7,3F,F4,FF,F3,FF,CF ; DB CF,F7,3F,F4,FF,F3,FF,CF
        .he FC ; DB FC

;L91C5   DB 40,00,02,00,06,00,36,00 ; @.....6.
;91CD    DB B6,02,B6,0A,FA,3A,FA,FE
;91D5    DB FA,FE,FA,F6,FA,F6,BA,EA
;91DD    DB BE,EA,BE,EA,DE,EA,DE,F6
;91E5    DB DE,F6,EE,D6,EE,D6,FC,DE
;91ED    DB F3,BE,CE,BE,39,BC,E7,F3
;91F5    DB 9E,CE,78,B9,E0,A7,80,92
;91FD    DB 00,CB,00,E4,80,ED,00,EC
;9205    DB 80,ED,01,EC,87,ED,1E,EC
;920D    DB F8,ED,60,EC,80,ED,00,EC
;9215    DB 80,6D,00,6C,80,6D,00,6C
;921D    DB 80,6D,03,AC,8F,AD,3C,AC
;9225    DB F2,AF,CE,AF,3E,AC,FE,A2
;922D    DB FA,DE,FA,EE,FA,F6,F6,F6
;9235    DB F6,F6,F6,F6,F4,FE,F3,FE
;923D    DB CF,FE,3F,FC,FF,F3,FF,CF
;9245    DB FC

L91C5   .he 40,00,02,00,06,00,36,00 ; DB 40,00,02,00,06,00,36,00
        .he B6,02,B6,0A,FA,3A,FA,FE ; DB B6,02,B6,0A,FA,3A,FA,FE
        .he FA,FE,FA,F6,FA,F6,BA,EA ; DB FA,FE,FA,F6,FA,F6,BA,EA
        .he BE,EA,BE,EA,DE,EA,DE,F6 ; DB BE,EA,BE,EA,DE,EA,DE,F6
        .he DE,F6,EE,D6,EE,D6,FC,DE ; DB DE,F6,EE,D6,EE,D6,FC,DE
        .he F3,BE,CE,BE,39,BC,E7,F3 ; DB F3,BE,CE,BE,39,BC,E7,F3
        .he 9E,CE,78,B9,E0,A7,80,92 ; DB 9E,CE,78,B9,E0,A7,80,92
        .he 00,CB,00,E4,80,ED,00,EC ; DB 00,CB,00,E4,80,ED,00,EC
        .he 80,ED,01,EC,87,ED,1E,EC ; DB 80,ED,01,EC,87,ED,1E,EC
        .he F8,ED,60,EC,80,ED,00,EC ; DB F8,ED,60,EC,80,ED,00,EC
        .he 80,6D,00,6C,80,6D,00,6C ; DB 80,6D,00,6C,80,6D,00,6C
        .he 80,6D,03,AC,8F,AD,3C,AC ; DB 80,6D,03,AC,8F,AD,3C,AC
        .he F2,AF,CE,AF,3E,AC,FE,A2 ; DB F2,AF,CE,AF,3E,AC,FE,A2
        .he FA,DE,FA,EE,FA,F6,F6,F6 ; DB FA,DE,FA,EE,FA,F6,F6,F6
        .he F6,F6,F6,F6,F4,FE,F3,FE ; DB F6,F6,F6,F6,F4,FE,F3,FE
        .he CF,FE,3F,FC,FF,F3,FF,CF ; DB CF,FE,3F,FC,FF,F3,FF,CF
        .he FC ; DB FC

;L9246   DB 40,00,02,00,0E,00,3E,00 ; @.....>.
;924E    DB FE,02,F6,0E,F6,0E,F6,CE
;9256    DB EE,CE,EE,CE,EE,DE,DE,DE
;925E    DB DE,FE,DE,FE,9E,FE,9E,FE
;9266    DB 9E,DE,DE,FE,DE,DE,FE,DE
;926E    DB FE,AE,CE,AE,36,DC,D6,F3
;9276    DB A6,CE,56,39,B6,E7,B6,9E ; ..V9....
;927E    DB 36,78,36,E0,36,80,36,40 ; 6.6.6.6@
;9286    DB 36,C0,34,C0,34,C0,34,C0 ; 6.4.4.4.
;928E    DB 34,C1,B4,C7,B6,DE,36,78 ; 4.....6.
;9296    DB 36,E0,36,80,36,C0,36,C0 ; 6.6.6.6.
;929E    DB 36,C0,36,C0,36,C0,36,C0 ; 6.6.6.6.
;92A6    DB F6,C3,CE,CF,3A,3C,FA,F2 ; ....:<..
;92AE    DB F6,CE,F6,3E,EE,FE,EE,FE
;92B6    DB FE,DE,FE,DE,FC,CE,F3,E6
;92BE    DB CF,A2,3F,B0,FF,D3,FF,CF
;92C6    DB FC

L9246   .he 40,00,02,00,0E,00,3E,00 ; DB 40,00,02,00,0E,00,3E,00
        .he FE,02,F6,0E,F6,0E,F6,CE ; DB FE,02,F6,0E,F6,0E,F6,CE
        .he EE,CE,EE,CE,EE,DE,DE,DE ; DB EE,CE,EE,CE,EE,DE,DE,DE
        .he DE,FE,DE,FE,9E,FE,9E,FE ; DB DE,FE,DE,FE,9E,FE,9E,FE
        .he 9E,DE,DE,FE,DE,DE,FE,DE ; DB 9E,DE,DE,FE,DE,DE,FE,DE
        .he FE,AE,CE,AE,36,DC,D6,F3 ; DB FE,AE,CE,AE,36,DC,D6,F3
        .he A6,CE,56,39,B6,E7,B6,9E ; DB A6,CE,56,39,B6,E7,B6,9E
        .he 36,78,36,E0,36,80,36,40 ; DB 36,78,36,E0,36,80,36,40
        .he 36,C0,34,C0,34,C0,34,C0 ; DB 36,C0,34,C0,34,C0,34,C0
        .he 34,C1,B4,C7,B6,DE,36,78 ; DB 34,C1,B4,C7,B6,DE,36,78
        .he 36,E0,36,80,36,C0,36,C0 ; DB 36,E0,36,80,36,C0,36,C0
        .he 36,C0,36,C0,36,C0,36,C0 ; DB 36,C0,36,C0,36,C0,36,C0
        .he F6,C3,CE,CF,3A,3C,FA,F2 ; DB F6,C3,CE,CF,3A,3C,FA,F2
        .he F6,CE,F6,3E,EE,FE,EE,FE ; DB F6,CE,F6,3E,EE,FE,EE,FE
        .he FE,DE,FE,DE,FC,CE,F3,E6 ; DB FE,DE,FE,DE,FC,CE,F3,E6
        .he CF,A2,3F,B0,FF,D3,FF,CF ; DB CF,A2,3F,B0,FF,D3,FF,CF
        .he FC ; DB FC

;L92C7   DB 40,00,02,00,0E,00,2E,00 ; @.......
;92CF    DB EC,02,E3,0E,CF,2E,3F,EC ; ......?.
;92D7    DB FC,E3,F3,CF,CF,39,FF,E4
;92DF    DB 7E,DD,38,3C,A5,5D,2A,1C ; ..8<.]*.
;92E7    DB 95,5D,28,1C,B2,5D,0D,1C ; .](..]..
;92EF    DB 83,3D,00,3A,80,39,00,3A ; .=.:.9.:
;92F7    DB 00,39,00,3A,00,39,00,3A ; .9.:.9.:
;92FF    DB 00,39,00,3A,80,3D,00,3C ; .9.:.=.<
;9307    DB 80,5D,20,1D,F0,5D,FF,1D ; .] ..]..
;930F    DB FF,5D,FC,1D,F2,5D,CF,1D ; .]...]..
;9317    DB 27,5C,FB,12,7C,4F,BF,27 ; '\...O.'
;931F    DB CF,FB,F7,FC,F9,7F,7E,3F
;9327    DB 9F,4F,EF,27,F3,55,FD,2A ; .O.'.U.*
;932F    DB FE,55,3F,2A,9F,55,57,2A ; .U?*.UW*
;9337    DB AB,55,54,2A,AA,55,55,2A ; .UT*.UU*
;933F    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;9347    DB AA

L92C7   .he 40,00,02,00,0E,00,2E,00 ; DB 40,00,02,00,0E,00,2E,00
        .he EC,02,E3,0E,CF,2E,3F,EC ; DB EC,02,E3,0E,CF,2E,3F,EC
        .he FC,E3,F3,CF,CF,39,FF,E4 ; DB FC,E3,F3,CF,CF,39,FF,E4
        .he 7E,DD,38,3C,A5,5D,2A,1C ; DB 7E,DD,38,3C,A5,5D,2A,1C
        .he 95,5D,28,1C,B2,5D,0D,1C ; DB 95,5D,28,1C,B2,5D,0D,1C
        .he 83,3D,00,3A,80,39,00,3A ; DB 83,3D,00,3A,80,39,00,3A
        .he 00,39,00,3A,00,39,00,3A ; DB 00,39,00,3A,00,39,00,3A
        .he 00,39,00,3A,80,3D,00,3C ; DB 00,39,00,3A,80,3D,00,3C
        .he 80,5D,20,1D,F0,5D,FF,1D ; DB 80,5D,20,1D,F0,5D,FF,1D
        .he FF,5D,FC,1D,F2,5D,CF,1D ; DB FF,5D,FC,1D,F2,5D,CF,1D
        .he 27,5C,FB,12,7C,4F,BF,27 ; DB 27,5C,FB,12,7C,4F,BF,27
        .he CF,FB,F7,FC,F9,7F,7E,3F ; DB CF,FB,F7,FC,F9,7F,7E,3F
        .he 9F,4F,EF,27,F3,55,FD,2A ; DB 9F,4F,EF,27,F3,55,FD,2A
        .he FE,55,3F,2A,9F,55,57,2A ; DB FE,55,3F,2A,9F,55,57,2A
        .he AB,55,54,2A,AA,55,55,2A ; DB AB,55,54,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA ; DB AA

;L9348   DB 40,00,02,00,0E,00,2E,00 ; @.......
;9350    DB EC,02,E3,0E,CF,2E,3F,EC ; ......?.
;9358    DB FC,E3,F3,CF,CF,3F,3F,FC ; .....??.
;9360    DB FE,3B,F8,C7,E5,D3,8A,CA
;9368    DB 55,90,A8,A5,52,92,AD,A5 ; U...R...
;9370    DB 6A,90,55,A2,A8,95,53,A2 ; ..U...S.
;9378    DB 8C,95,30,C8,D0,D3,10,C8
;9380    DB 10,D0,00,C8,10,D0,00,C8
;9388    DB 10,D0,00,C8,00,D0,00,D8
;9390    DB 00,DE,1C,BF,F3,BF,CF,BF
;9398    DB 27,BC,FB,B0,7C,8F,BF,07
;93A0    DB CF,FB,F7,7C,F9,BF,7E,CF
;93A8    DB 9F,F7,EF,F9,F3,7E,FD,9F
;93B0    DB 3E,EF,DF,F3,E7,FD,FB,3E ; >......>
;93B8    DB 7C,DF,BF,E7,CC,FB,F3,7C
;93C0    DB CF,BF,3F,CC,FF,F3,FF,CF
;93C8    DB FC

L9348   .he 40,00,02,00,0E,00,2E,00 ; DB 40,00,02,00,0E,00,2E,00
        .he EC,02,E3,0E,CF,2E,3F,EC ; DB EC,02,E3,0E,CF,2E,3F,EC
        .he FC,E3,F3,CF,CF,3F,3F,FC ; DB FC,E3,F3,CF,CF,3F,3F,FC
        .he FE,3B,F8,C7,E5,D3,8A,CA ; DB FE,3B,F8,C7,E5,D3,8A,CA
        .he 55,90,A8,A5,52,92,AD,A5 ; DB 55,90,A8,A5,52,92,AD,A5
        .he 6A,90,55,A2,A8,95,53,A2 ; DB 6A,90,55,A2,A8,95,53,A2
        .he 8C,95,30,C8,D0,D3,10,C8 ; DB 8C,95,30,C8,D0,D3,10,C8
        .he 10,D0,00,C8,10,D0,00,C8 ; DB 10,D0,00,C8,10,D0,00,C8
        .he 10,D0,00,C8,00,D0,00,D8 ; DB 10,D0,00,C8,00,D0,00,D8
        .he 00,DE,1C,BF,F3,BF,CF,BF ; DB 00,DE,1C,BF,F3,BF,CF,BF
        .he 27,BC,FB,B0,7C,8F,BF,07 ; DB 27,BC,FB,B0,7C,8F,BF,07
        .he CF,FB,F7,7C,F9,BF,7E,CF ; DB CF,FB,F7,7C,F9,BF,7E,CF
        .he 9F,F7,EF,F9,F3,7E,FD,9F ; DB 9F,F7,EF,F9,F3,7E,FD,9F
        .he 3E,EF,DF,F3,E7,FD,FB,3E ; DB 3E,EF,DF,F3,E7,FD,FB,3E
        .he 7C,DF,BF,E7,CC,FB,F3,7C ; DB 7C,DF,BF,E7,CC,FB,F3,7C
        .he CF,BF,3F,CC,FF,F3,FF,CF ; DB CF,BF,3F,CC,FF,F3,FF,CF
        .he FC ; DB FC

;L93C9   DB 40,00,02,00,07,00,2E,00 ; @.......
;93D1    DB EC,02,E3,0E,CF,2E,3C,EC ; ......<.
;93D9    DB FB,E3,F3,CF,CB,3F,3B,FC ; .....?;.
;93E1    DB FB,F3,F8,CF,E3,3F,8B,FE
;93E9    DB 53,F8,AB,F5,53,8A,83,55 ; S...S..U
;93F1    DB 2B,A8,53,52,AB,85,53,2A ; +.SR..S*
;93F9    DB 8D,55,31,A8,E1,43,21,8C ; .U1..C!.
;9401    DB 00,B4,21,C4,05,84,25,84 ; ..!...
;9409    DB 0D,80,0D,84,1B,80,1B,04
;9411    DB 3B,80,78,00,F3,81,CF,03
;9419    DB 27,00,FB,02,7C,CF,BF,27 ; '......'
;9421    DB CF,FB,F7,7C,F9,BF,7E,CF
;9429    DB 9F,F7,EF,F9,F3,7E,FD,9F
;9431    DB 3E,EF,DF,F3,E7,FD,FB,3E ; >......>
;9439    DB 7C,DF,BF,E7,CC,FB,F3,7C
;9441    DB CF,BF,3F,CC,FF,F3,FF,CF
;9449    DB FC

L93C9   .he 40,00,02,00,07,00,2E,00 ; DB 40,00,02,00,07,00,2E,00
        .he EC,02,E3,0E,CF,2E,3C,EC ; DB EC,02,E3,0E,CF,2E,3C,EC
        .he FB,E3,F3,CF,CB,3F,3B,FC ; DB FB,E3,F3,CF,CB,3F,3B,FC
        .he FB,F3,F8,CF,E3,3F,8B,FE ; DB FB,F3,F8,CF,E3,3F,8B,FE
        .he 53,F8,AB,F5,53,8A,83,55 ; DB 53,F8,AB,F5,53,8A,83,55
        .he 2B,A8,53,52,AB,85,53,2A ; DB 2B,A8,53,52,AB,85,53,2A
        .he 8D,55,31,A8,E1,43,21,8C ; DB 8D,55,31,A8,E1,43,21,8C
        .he 00,B4,21,C4,05,84,25,84 ; DB 00,B4,21,C4,05,84,25,84
        .he 0D,80,0D,84,1B,80,1B,04 ; DB 0D,80,0D,84,1B,80,1B,04
        .he 3B,80,78,00,F3,81,CF,03 ; DB 3B,80,78,00,F3,81,CF,03
        .he 27,00,FB,02,7C,CF,BF,27 ; DB 27,00,FB,02,7C,CF,BF,27
        .he CF,FB,F7,7C,F9,BF,7E,CF ; DB CF,FB,F7,7C,F9,BF,7E,CF
        .he 9F,F7,EF,F9,F3,7E,FD,9F ; DB 9F,F7,EF,F9,F3,7E,FD,9F
        .he 3E,EF,DF,F3,E7,FD,FB,3E ; DB 3E,EF,DF,F3,E7,FD,FB,3E
        .he 7C,DF,BF,E7,CC,FB,F3,7C ; DB 7C,DF,BF,E7,CC,FB,F3,7C
        .he CF,BF,3F,CC,FF,F3,FF,CF ; DB CF,BF,3F,CC,FF,F3,FF,CF
        .he FC ; DB FC

;L944A   DB 40,00,02,00,0E,00,2E,00 ; @.......
;9452    DB EC,02,E3,0E,CE,2E,39,EC ; ......9.
;945A    DB E3,E3,9B,CE,7B,39,FB,E7
;9462    DB FB,9F,FB,5F,E3,DF,83,DE
;946A    DB 03,D8,1B,D0,7B,D1,FB,D7
;9472    DB E3,D7,83,D7,03,D7,03,D7
;947A    DB 33,D7,F3,D7,F3,D7,83,D7
;9482    DB 03,D7,1B,D7,7B,D7,FB,D7
;948A    DB E3,D7,83,D6,03,D0,1B,D0
;9492    DB 3B,D3,3B,D7,3B,D7,73,D7 ; ;.;.;...
;949A    DB 73,D7,73,D7,FB,D7,FB,D7
;94A2    DB FB,D7,3B,D7,3B,D7,3B,D7 ; ..;.;.;.
;94AA    DB 7B,D7,FB,D7,E3,D7,83,D6
;94B2    DB 03,D0,13,D0,7B,D1,FB,D3
;94BA    DB FB,D7,BB,D7,3B,D7,3B,D7 ; ....;.;.
;94C2    DB 3B,D7,3B,D7,3B,D7,3B,D7 ; ;.;.;.;.
;94CA    DB 3B

L944A   .he 40,00,02,00,0E,00,2E,00 ; DB 40,00,02,00,0E,00,2E,00
        .he EC,02,E3,0E,CE,2E,39,EC ; DB EC,02,E3,0E,CE,2E,39,EC
        .he E3,E3,9B,CE,7B,39,FB,E7 ; DB E3,E3,9B,CE,7B,39,FB,E7
        .he FB,9F,FB,5F,E3,DF,83,DE ; DB FB,9F,FB,5F,E3,DF,83,DE
        .he 03,D8,1B,D0,7B,D1,FB,D7 ; DB 03,D8,1B,D0,7B,D1,FB,D7
        .he E3,D7,83,D7,03,D7,03,D7 ; DB E3,D7,83,D7,03,D7,03,D7
        .he 33,D7,F3,D7,F3,D7,83,D7 ; DB 33,D7,F3,D7,F3,D7,83,D7
        .he 03,D7,1B,D7,7B,D7,FB,D7 ; DB 03,D7,1B,D7,7B,D7,FB,D7
        .he E3,D7,83,D6,03,D0,1B,D0 ; DB E3,D7,83,D6,03,D0,1B,D0
        .he 3B,D3,3B,D7,3B,D7,73,D7 ; DB 3B,D3,3B,D7,3B,D7,73,D7
        .he 73,D7,73,D7,FB,D7,FB,D7 ; DB 73,D7,73,D7,FB,D7,FB,D7
        .he FB,D7,3B,D7,3B,D7,3B,D7 ; DB FB,D7,3B,D7,3B,D7,3B,D7
        .he 7B,D7,FB,D7,E3,D7,83,D6 ; DB 7B,D7,FB,D7,E3,D7,83,D6
        .he 03,D0,13,D0,7B,D1,FB,D3 ; DB 03,D0,13,D0,7B,D1,FB,D3
        .he FB,D7,BB,D7,3B,D7,3B,D7 ; DB FB,D7,BB,D7,3B,D7,3B,D7
        .he 3B,D7,3B,D7,3B,D7,3B,D7 ; DB 3B,D7,3B,D7,3B,D7,3B,D7
        .he 3B ; DB 3B

;L94CB   DB 38,D6,3B,D6,7B,D7,F3,D7 ; 8.;.....
;94D3    DB E3,D7,83,D2,03,D0,03,D0
;94DB    DB 03,D0,C3,D1,C3,D1,C3,D1
;94E3    DB C3,D1,C3,D1,C3,D1,C3,D1
;94EB    DB C3,D1,C3,D1,C3,D1,C3,D1
;94F3    DB DB,D1,FB,D1,FB,D7,E3,D7
;94FB    DB 83,D6,03,D0,03,D0,33,D0
;9503    DB FB,D3,FB,D7,BB,D7,3B,D4
;950B    DB 3B,D0,3B,D0,FB,D3,FB,D7 ; ;.;.....
;9513    DB E3,D7,83,D7,03,D7,3B,D7
;951B    DB FB,D7,FB,D7,E3,D7,87,D2
;9523    DB 06,D0,06,D0,0E,D0,0C,D0
;952B    DB 1C,E8,39,E8,70,75,E0,3F ; ..9....?
;9533    DB C0,1F,00,00,00,00,00,00
;953B    DB 00

L94CB   .he 38,D6,3B,D6,7B,D7,F3,D7 ; DB 38,D6,3B,D6,7B,D7,F3,D7
        .he E3,D7,83,D2,03,D0,03,D0 ; DB E3,D7,83,D2,03,D0,03,D0
        .he 03,D0,C3,D1,C3,D1,C3,D1 ; DB 03,D0,C3,D1,C3,D1,C3,D1
        .he C3,D1,C3,D1,C3,D1,C3,D1 ; DB C3,D1,C3,D1,C3,D1,C3,D1
        .he C3,D1,C3,D1,C3,D1,C3,D1 ; DB C3,D1,C3,D1,C3,D1,C3,D1
        .he DB,D1,FB,D1,FB,D7,E3,D7 ; DB DB,D1,FB,D1,FB,D7,E3,D7
        .he 83,D6,03,D0,03,D0,33,D0 ; DB 83,D6,03,D0,03,D0,33,D0
        .he FB,D3,FB,D7,BB,D7,3B,D4 ; DB FB,D3,FB,D7,BB,D7,3B,D4
        .he 3B,D0,3B,D0,FB,D3,FB,D7 ; DB 3B,D0,3B,D0,FB,D3,FB,D7
        .he E3,D7,83,D7,03,D7,3B,D7 ; DB E3,D7,83,D7,03,D7,3B,D7
        .he FB,D7,FB,D7,E3,D7,87,D2 ; DB FB,D7,FB,D7,E3,D7,87,D2
        .he 06,D0,06,D0,0E,D0,0C,D0 ; DB 06,D0,06,D0,0E,D0,0C,D0
        .he 1C,E8,39,E8,70,75,E0,3F ; DB 1C,E8,39,E8,70,75,E0,3F
        .he C0,1F,00,00,00,00,00,00 ; DB C0,1F,00,00,00,00,00,00
        .he 00 ; DB 00

;L953C   DB 38,55,51,2A,AA,55,55,2A ; 8UQ*.UU*
;9544    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;954C    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;9554    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;955C    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;9564    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;956C    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;9574    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;957C    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;9584    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;958C    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;9594    DB AA,55,55,2A,AA,55,55,2A ; .UU*.UU*
;959C    DB AA,55,55,2A,A8,55,50,AA ; .UU*.UP.
;95A4    DB 80,55,00,A8,00,50,00,50 ; .U...P.P
;95AC    DB 00

L953C   .he 38,55,51,2A,AA,55,55,2A ; DB 38,55,51,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA,55,55,2A,AA,55,55,2A ; DB AA,55,55,2A,AA,55,55,2A
        .he AA,55,55,2A,A8,55,50,AA ; DB AA,55,55,2A,A8,55,50,AA
        .he 80,55,00,A8,00,50,00,50 ; DB 80,55,00,A8,00,50,00,50
        .he 00 ; DB 00

;L95AD   DB 38,3F,F2,FF,CE,FF,2E,FC ; 8?......
;95B5    DB EE,F2,EE,CE,EE,2E,EE,EE
;95BD    DB EE,EE,EE,EE,EE,EE,EE,EE
;95C5    DB EE,EE,EE,EE,EE,EE,EE,EE
;95CD    DB EE,EE,EC,EE,E3,EE,CF,EE
;95D5    DB 3F,EE,FC,EE,F3,EE,CC,EE
;95DD    DB D0,EE,D0,EE,D0,EE,D0,EE
;95E5    DB D3,EE,DF,EE,DC,EE,D0,EE
;95ED    DB D0,EE,D0,EE,D0,EE,D0,EE
;95F5    DB D0,EE,D0,EE,D3,EE,CF,EE
;95FD    DB FC,EE,F2,EE,CE,EE,2E,EE
;9605    DB EE,EE,EE,EE,EE,EE,EE,EE
;960D    DB EE,EE,EE,EE,EC,EE,E0,EE
;9615    DB C0,EE,00,EC,00,E0,00,C0
;961D    DB 00

L95AD   .he 38,3F,F2,FF,CE,FF,2E,FC ; DB 38,3F,F2,FF,CE,FF,2E,FC
        .he EE,F2,EE,CE,EE,2E,EE,EE ; DB EE,F2,EE,CE,EE,2E,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EC,EE,E3,EE,CF,EE ; DB EE,EE,EC,EE,E3,EE,CF,EE
        .he 3F,EE,FC,EE,F3,EE,CC,EE ; DB 3F,EE,FC,EE,F3,EE,CC,EE
        .he D0,EE,D0,EE,D0,EE,D0,EE ; DB D0,EE,D0,EE,D0,EE,D0,EE
        .he D3,EE,DF,EE,DC,EE,D0,EE ; DB D3,EE,DF,EE,DC,EE,D0,EE
        .he D0,EE,D0,EE,D0,EE,D0,EE ; DB D0,EE,D0,EE,D0,EE,D0,EE
        .he D0,EE,D0,EE,D3,EE,CF,EE ; DB D0,EE,D0,EE,D3,EE,CF,EE
        .he FC,EE,F2,EE,CE,EE,2E,EE ; DB FC,EE,F2,EE,CE,EE,2E,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EC,EE,E0,EE ; DB EE,EE,EE,EE,EC,EE,E0,EE
        .he C0,EE,00,EC,00,E0,00,C0 ; DB C0,EE,00,EC,00,E0,00,C0
        .he 00 ; DB 00

;L961E   DB 38,3F,F2,FF,CE,FF,2E,FC ; 8?......
;9626    DB EE,F2,EE,CE,EE,2E,EE,EE
;962E    DB EE,EE,EE,EE,EE,EE,EE,EE
;9636    DB EE,EE,EE,EE,EE,EE,EE,EE
;963E    DB EE,EE,EE,EE,EE,EE,EE,EE
;9646    DB 6E,EC,6E,E3,6E,CF,6E,3F
;964E    DB 6E,FF,6E,F3,6E,CB,6E,33
;9656    DB 6E,C3,6E,C3,6E,C3,6E,C3
;965E    DB 6E,CF,6E,FF,6E,F3,6E,C3
;9666    DB 6E,C3,6E,C3,6E,C3,6E,C3
;966E    DB 6E,C3,6E,C3,6E,CF,6E,3C
;9676    DB 6E,F2,EE,CE,EE,2E,EE,EE
;967E    DB EE,EE,EE,EE,EC,EE,E0,EE
;9686    DB C0,EE,00,EC,00,E0,00,C0
;968E    DB 00

L961E   .he 38,3F,F2,FF,CE,FF,2E,FC ; DB 38,3F,F2,FF,CE,FF,2E,FC
        .he EE,F2,EE,CE,EE,2E,EE,EE ; DB EE,F2,EE,CE,EE,2E,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he 6E,EC,6E,E3,6E,CF,6E,3F ; DB 6E,EC,6E,E3,6E,CF,6E,3F
        .he 6E,FF,6E,F3,6E,CB,6E,33 ; DB 6E,FF,6E,F3,6E,CB,6E,33
        .he 6E,C3,6E,C3,6E,C3,6E,C3 ; DB 6E,C3,6E,C3,6E,C3,6E,C3
        .he 6E,CF,6E,FF,6E,F3,6E,C3 ; DB 6E,CF,6E,FF,6E,F3,6E,C3
        .he 6E,C3,6E,C3,6E,C3,6E,C3 ; DB 6E,C3,6E,C3,6E,C3,6E,C3
        .he 6E,C3,6E,C3,6E,CF,6E,3C ; DB 6E,C3,6E,C3,6E,CF,6E,3C
        .he 6E,F2,EE,CE,EE,2E,EE,EE ; DB 6E,F2,EE,CE,EE,2E,EE,EE
        .he EE,EE,EE,EE,EC,EE,E0,EE ; DB EE,EE,EE,EE,EC,EE,E0,EE
        .he C0,EE,00,EC,00,E0,00,C0 ; DB C0,EE,00,EC,00,E0,00,C0
        .he 00 ; DB 00

;L968F   DB 38,3F,F2,FF,CE,FF,2E,FC ; 8?......
;9697    DB EE,F2,EE,CE,EE,2E,EE,EE
;969F    DB EE,EE,EE,EE,EE,EE,EE,EE
;96A7    DB EE,EE,EE,EE,EE,EE,EE,EE
;96AF    DB EE,EE,EE,EE,EE,EE,EE,EE
;96B7    DB EE,EE,EE,EE,EE,EE,EE,EE
;96BF    DB EE,EE,EE,EE,EE,EE,EE,EE
;96C7    DB EE,EE,EE,EE,EE,EE,EE,EE
;96CF    DB EE,EE,EE,EE,EE,EE,EE,EE
;96D7    DB EE,EE,EE,EE,EE,EE,EE,EE
;96DF    DB EE,EE,EE,EE,EE,EE,EE,EE
;96E7    DB EE,EE,EE,EE,EE,EE,EE,EE
;96EF    DB EE,EE,EE,EE,EC,EE,E0,EE
;96F7    DB C0,EE,00,EC,00,E0,00,C0
;96FF    DB 00

L968F   .he 38,3F,F2,FF,CE,FF,2E,FC ; DB 38,3F,F2,FF,CE,FF,2E,FC
        .he EE,F2,EE,CE,EE,2E,EE,EE ; DB EE,F2,EE,CE,EE,2E,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EE,EE,EE,EE ; DB EE,EE,EE,EE,EE,EE,EE,EE
        .he EE,EE,EE,EE,EC,EE,E0,EE ; DB EE,EE,EE,EE,EC,EE,E0,EE
        .he C0,EE,00,EC,00,E0,00,C0 ; DB C0,EE,00,EC,00,E0,00,C0
        .he 00 ; DB 00

;L9700   DB 40,00,02,00,0A,00,36,00 ; @.....6.
;9708    DB B6,02,D6,06,D6,26,C6,E6
;9710    DB EE,E6,EE,F6,EE,F6,EE,FA
;9718    DB EE,DA,FE,DE,FE,CE,FE,AE
;9720    DB FF,AE,FD,DE,F2,DE,CE,FF
;9728    DB 3E,FC,F2,F3,CE,CF,52,BC ; >.....R.
;9730    DB 4A,65,72,5D,4E,44,7E,55 ; J..]ND.U
;9738    DB FE,67,C6,5E,06,78,0E,72
;9740    DB 76,71,F6,60,CA,40,3A,41 ; .....@:A
;9748    DB 36,41,A6,60,16,61,E6,66 ; 6A......
;9750    DB 12,69,EA,73,F2,67,FE,6F
;9758    DB FE,7F,EA,7F,D6,7E,AE,7D
;9760    DB F8,6A,E6,55,9E,6E,7E,58 ; ...U...X
;9768    DB FE,66,FE,1E,FE,7E,FE,FE
;9770    DB FE,FE,FE,FE,FC,FE,F3,FE
;9778    DB CF,FE,3F,FC,FF,F3,FF,CF
;9780    DB FC

L9700   .he 40,00,02,00,0A,00,36,00 ; DB 40,00,02,00,0A,00,36,00
        .he B6,02,D6,06,D6,26,C6,E6 ; DB B6,02,D6,06,D6,26,C6,E6
        .he EE,E6,EE,F6,EE,F6,EE,FA ; DB EE,E6,EE,F6,EE,F6,EE,FA
        .he EE,DA,FE,DE,FE,CE,FE,AE ; DB EE,DA,FE,DE,FE,CE,FE,AE
        .he FF,AE,FD,DE,F2,DE,CE,FF ; DB FF,AE,FD,DE,F2,DE,CE,FF
        .he 3E,FC,F2,F3,CE,CF,52,BC ; DB 3E,FC,F2,F3,CE,CF,52,BC
        .he 4A,65,72,5D,4E,44,7E,55 ; DB 4A,65,72,5D,4E,44,7E,55
        .he FE,67,C6,5E,06,78,0E,72 ; DB FE,67,C6,5E,06,78,0E,72
        .he 76,71,F6,60,CA,40,3A,41 ; DB 76,71,F6,60,CA,40,3A,41
        .he 36,41,A6,60,16,61,E6,66 ; DB 36,41,A6,60,16,61,E6,66
        .he 12,69,EA,73,F2,67,FE,6F ; DB 12,69,EA,73,F2,67,FE,6F
        .he FE,7F,EA,7F,D6,7E,AE,7D ; DB FE,7F,EA,7F,D6,7E,AE,7D
        .he F8,6A,E6,55,9E,6E,7E,58 ; DB F8,6A,E6,55,9E,6E,7E,58
        .he FE,66,FE,1E,FE,7E,FE,FE ; DB FE,66,FE,1E,FE,7E,FE,FE
        .he FE,FE,FE,FE,FC,FE,F3,FE ; DB FE,FE,FE,FE,FC,FE,F3,FE
        .he CF,FE,3F,FC,FF,F3,FF,CF ; DB CF,FE,3F,FC,FF,F3,FF,CF
        .he FC ; DB FC

;L9781   DB 40,00,00,00,00,00,00,00
;9789    DB 00,00,00,00,00,20,00,E8
;9791    DB 00,E5,03,EA,86,E5,4E,EA
;9799    DB BE,E4,F6,EB,D6,EF,56,ED
;97A1    DB 56,ED,56,ED,56,ED,56,ED ; V.V.V.V.
;97A9    DB 56,ED,56,ED,56,ED,56,ED ; V.V.V.V.
;97B1    DB 56,ED,56,ED,56,ED,56,ED ; V.V.V.V.
;97B9    DB 56,ED,56,ED,56,ED,56,ED ; V.V.V.V.
;97C1    DB 56,ED,56,ED,56,ED,56,ED ; V.V.V.V.
;97C9    DB 5E,ED,5E,ED,3E,ED,77,ED ; ^.^.>...
;97D1    DB EC,ED,D3,ED,A0,EF,A0,EF
;97D9    DB 50,EF,40,EE,90,E9,20,E9 ; P.@... .
;97E1    DB 50,ED,20,ED,50,EA,A0,E4 ; P. .P...
;97E9    DB 50,F1,A8,FE,01,FF,FF,FF
;97F1    DB FF,FF,FF,FF,FC,FF,F3,FF
;97F9    DB CF,FF,3F,FC,FF,F3,FF,CF
;9801    DB FC

L9781   .he 40,00,00,00,00,00,00,00 ; DB 40,00,00,00,00,00,00,00
        .he 00,00,00,00,00,20,00,E8 ; DB 00,00,00,00,00,20,00,E8
        .he 00,E5,03,EA,86,E5,4E,EA ; DB 00,E5,03,EA,86,E5,4E,EA
        .he BE,E4,F6,EB,D6,EF,56,ED ; DB BE,E4,F6,EB,D6,EF,56,ED
        .he 56,ED,56,ED,56,ED,56,ED ; DB 56,ED,56,ED,56,ED,56,ED
        .he 56,ED,56,ED,56,ED,56,ED ; DB 56,ED,56,ED,56,ED,56,ED
        .he 56,ED,56,ED,56,ED,56,ED ; DB 56,ED,56,ED,56,ED,56,ED
        .he 56,ED,56,ED,56,ED,56,ED ; DB 56,ED,56,ED,56,ED,56,ED
        .he 56,ED,56,ED,56,ED,56,ED ; DB 56,ED,56,ED,56,ED,56,ED
        .he 5E,ED,5E,ED,3E,ED,77,ED ; DB 5E,ED,5E,ED,3E,ED,77,ED
        .he EC,ED,D3,ED,A0,EF,A0,EF ; DB EC,ED,D3,ED,A0,EF,A0,EF
        .he 50,EF,40,EE,90,E9,20,E9 ; DB 50,EF,40,EE,90,E9,20,E9
        .he 50,ED,20,ED,50,EA,A0,E4 ; DB 50,ED,20,ED,50,EA,A0,E4
        .he 50,F1,A8,FE,01,FF,FF,FF ; DB 50,F1,A8,FE,01,FF,FF,FF
        .he FF,FF,FF,FF,FC,FF,F3,FF ; DB FF,FF,FF,FF,FC,FF,F3,FF
        .he CF,FF,3F,FC,FF,F3,FF,CF ; DB CF,FF,3F,FC,FF,F3,FF,CF
        .he FC ; DB FC

;L9802   DB 40,00,03,00,07,00,07,00
;980A    DB 07,00,07,00,07,00,07,00
;9812    DB 07,00,07,00,07,00,07,00
;981A    DB 37,00,F7,03,F7,2F,B7,7E ; 7..../..
;9822    DB B7,7A,B7,EA,B7,EA,B7,6A
;982A    DB B7,EA,B7,6A,B7,EA,B7,6A
;9832    DB B7,EA,B7,6A,B7,EA,B7,6A
;983A    DB B7,EA,B7,6A,B7,EA,B7,6A
;9842    DB B7,EA,B7,6A,B7,EA,B7,6A
;984A    DB B7,EA,B7,6A,B7,EA,B7,6A
;9852    DB B7,EA,B7,6A,B7,FE,B7,7F
;985A    DB B7,FF,B7,63,F7,1C,F7,F3
;9862    DB 77,00,17,00,17,00,37,00
;986A    DB 37,00,17,00,07,00,1F,00
;9872    DB 3F,00,7F,00,FC,01,F3,0F
;987A    DB CF,3F,3F,FC,FF,F3,FF,CF ; .??.....
;9882    DB FC

L9802   .he 40,00,03,00,07,00,07,00 ; DB 40,00,03,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 37,00,F7,03,F7,2F,B7,7E ; DB 37,00,F7,03,F7,2F,B7,7E
        .he B7,7A,B7,EA,B7,EA,B7,6A ; DB B7,7A,B7,EA,B7,EA,B7,6A
        .he B7,EA,B7,6A,B7,EA,B7,6A ; DB B7,EA,B7,6A,B7,EA,B7,6A
        .he B7,EA,B7,6A,B7,EA,B7,6A ; DB B7,EA,B7,6A,B7,EA,B7,6A
        .he B7,EA,B7,6A,B7,EA,B7,6A ; DB B7,EA,B7,6A,B7,EA,B7,6A
        .he B7,EA,B7,6A,B7,EA,B7,6A ; DB B7,EA,B7,6A,B7,EA,B7,6A
        .he B7,EA,B7,6A,B7,EA,B7,6A ; DB B7,EA,B7,6A,B7,EA,B7,6A
        .he B7,EA,B7,6A,B7,FE,B7,7F ; DB B7,EA,B7,6A,B7,FE,B7,7F
        .he B7,FF,B7,63,F7,1C,F7,F3 ; DB B7,FF,B7,63,F7,1C,F7,F3
        .he 77,00,17,00,17,00,37,00 ; DB 77,00,17,00,17,00,37,00
        .he 37,00,17,00,07,00,1F,00 ; DB 37,00,17,00,07,00,1F,00
        .he 3F,00,7F,00,FC,01,F3,0F ; DB 3F,00,7F,00,FC,01,F3,0F
        .he CF,3F,3F,FC,FF,F3,FF,CF ; DB CF,3F,3F,FC,FF,F3,FF,CF
        .he FC ; DB FC

;L9883   DB 40,00,02,00,03,00,3B,00 ; @.....;.
;988B    DB 7B,03,7B,07,7B,37,7B,F7
;9893    DB 7B,F7,7B,F7,7B,F7,7B,F7
;989B    DB 7B,F7,7B,F7,7B,F7,7B,F7
;98A3    DB 7B,F7,7B,F7,7B,F7,7B,F7
;98AB    DB 7B,F7,7B,F7,7B,F7,7B,F7
;98B3    DB 7B,F7,7B,F7,7B,F7,7B,F7
;98BB    DB 7B,F7,7B,F7,7B,F7,7B,F7
;98C3    DB 7B,F7,7B,F7,7B,F7,7B,F7
;98CB    DB 7B,F7,7B,F7,7B,F7,7B,F7
;98D3    DB 7B,F7,7B,F7,7B,F7,7B,F7
;98DB    DB 7B,F7,7B,F7,7B,F7,7B,F7
;98E3    DB 7B,F7,7B,F7,7B,F7,7B,F7
;98EB    DB 7B,F7,7B,F7,7B,F7,7B,F7
;98F3    DB 7B,F7,7B,F7,78,F7,73,F7
;98FB    DB 4F,F7,3F,F4,FB,F3,FF,CF ; O.?.....
;9903    DB FF

L9883   .he 40,00,02,00,03,00,3B,00 ; DB 40,00,02,00,03,00,3B,00
        .he 7B,03,7B,07,7B,37,7B,F7 ; DB 7B,03,7B,07,7B,37,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,7B,F7,7B,F7 ; DB 7B,F7,7B,F7,7B,F7,7B,F7
        .he 7B,F7,7B,F7,78,F7,73,F7 ; DB 7B,F7,7B,F7,78,F7,73,F7
        .he 4F,F7,3F,F4,FB,F3,FF,CF ; DB 4F,F7,3F,F4,FB,F3,FF,CF
        .he FF ; DB FF

;L9904   DB 38,FC,FC,FF,F3,FF,CC,FF
;990C    DB 31,FC,CA,F3,11,CC,2A,30 ; 1.....*0
;9914    DB 51,C2,2A,15,51,A2,2A,55 ; Q.*.Q.*U
;991C    DB 51,A2,2A,55,51,A2,2A,55 ; Q.*UQ.*U
;9924    DB 51,A2,2A,55,51,A2,2A,55 ; Q.*UQ.*U
;992C    DB 51,A2,2A,55,51,A2,2A,55 ; Q.*UQ.*U
;9934    DB 51,A2,2A,55,51,A2,2A,55 ; Q.*UQ.*U
;993C    DB 51,A2,2A,55,51,A2,2A,55 ; Q.*UQ.*U
;9944    DB 51,A2,2A,55,51,A2,2A,55 ; Q.*UQ.*U
;994C    DB 51,A2,2A,55,51,A2,29,55 ; Q.*UQ.)U
;9954    DB 53,A2,0F,55,3F,A2,4C,55 ; S..U?.LU
;995C    DB 70,A2,70,55,70,A2,70,54 ; ...U...T
;9964    DB 70,A2,30,4F,C0,3F,F0,FF ; ..0O.?..
;996C    DB C0,3F,00,0C,00,00,00,00
;9974    DB 00

L9904   .he 38,FC,FC,FF,F3,FF,CC,FF ; DB 38,FC,FC,FF,F3,FF,CC,FF
        .he 31,FC,CA,F3,11,CC,2A,30 ; DB 31,FC,CA,F3,11,CC,2A,30
        .he 51,C2,2A,15,51,A2,2A,55 ; DB 51,C2,2A,15,51,A2,2A,55
        .he 51,A2,2A,55,51,A2,2A,55 ; DB 51,A2,2A,55,51,A2,2A,55
        .he 51,A2,2A,55,51,A2,2A,55 ; DB 51,A2,2A,55,51,A2,2A,55
        .he 51,A2,2A,55,51,A2,2A,55 ; DB 51,A2,2A,55,51,A2,2A,55
        .he 51,A2,2A,55,51,A2,2A,55 ; DB 51,A2,2A,55,51,A2,2A,55
        .he 51,A2,2A,55,51,A2,2A,55 ; DB 51,A2,2A,55,51,A2,2A,55
        .he 51,A2,2A,55,51,A2,2A,55 ; DB 51,A2,2A,55,51,A2,2A,55
        .he 51,A2,2A,55,51,A2,29,55 ; DB 51,A2,2A,55,51,A2,29,55
        .he 53,A2,0F,55,3F,A2,4C,55 ; DB 53,A2,0F,55,3F,A2,4C,55
        .he 70,A2,70,55,70,A2,70,54 ; DB 70,A2,70,55,70,A2,70,54
        .he 70,A2,30,4F,C0,3F,F0,FF ; DB 70,A2,30,4F,C0,3F,F0,FF
        .he C0,3F,00,0C,00,00,00,00 ; DB C0,3F,00,0C,00,00,00,00
        .he 00 ; DB 00

;L9975   DB 38,FB,F3,3F,4F,BF,3B,F8 ; 8..?O.;.
;997D    DB FB,F3,7D,C7,BF,3B,FF,FF
;9985    DB F5,FF,FF,DF,FF,FF,9D,FF
;998D    DB FF,FB,FF,FD,FF,FF,FB,DE
;9995    DB FF,FE,7F,7F,FF,9F,FF,FF
;999D    DB EE,FB,E7,F7,FF,FB,BF,FF
;99A5    DB FF,FF,FF,DF,E6,EF,9A,FE
;99AD    DB 7B,F9,FB,E7,9B,DE,7B,99
;99B5    DB 9B,DA,3B,DA,DB,5B,1B,DA ; ..;..[..
;99BD    DB 3B,DA,DB,9B,1A,DA,1B,5A ; ;......Z
;99C5    DB 79,D9,E7,DF,9F,DE,7F,D9
;99CD    DB F6,E7,FF,F7,FF,F6,FB,7F
;99D5    DB 3F,9F,FB,FF,FC,FD,F0,BE
;99DD    DB C0,BD,00,DC,00,F0,00,C0
;99E5    DB 00

L9975   .he 38,FB,F3,3F,4F,BF,3B,F8 ; DB 38,FB,F3,3F,4F,BF,3B,F8
        .he FB,F3,7D,C7,BF,3B,FF,FF ; DB FB,F3,7D,C7,BF,3B,FF,FF
        .he F5,FF,FF,DF,FF,FF,9D,FF ; DB F5,FF,FF,DF,FF,FF,9D,FF
        .he FF,FB,FF,FD,FF,FF,FB,DE ; DB FF,FB,FF,FD,FF,FF,FB,DE
        .he FF,FE,7F,7F,FF,9F,FF,FF ; DB FF,FE,7F,7F,FF,9F,FF,FF
        .he EE,FB,E7,F7,FF,FB,BF,FF ; DB EE,FB,E7,F7,FF,FB,BF,FF
        .he FF,FF,FF,DF,E6,EF,9A,FE ; DB FF,FF,FF,DF,E6,EF,9A,FE
        .he 7B,F9,FB,E7,9B,DE,7B,99 ; DB 7B,F9,FB,E7,9B,DE,7B,99
        .he 9B,DA,3B,DA,DB,5B,1B,DA ; DB 9B,DA,3B,DA,DB,5B,1B,DA
        .he 3B,DA,DB,9B,1A,DA,1B,5A ; DB 3B,DA,DB,9B,1A,DA,1B,5A
        .he 79,D9,E7,DF,9F,DE,7F,D9 ; DB 79,D9,E7,DF,9F,DE,7F,D9
        .he F6,E7,FF,F7,FF,F6,FB,7F ; DB F6,E7,FF,F7,FF,F6,FB,7F
        .he 3F,9F,FB,FF,FC,FD,F0,BE ; DB 3F,9F,FB,FF,FC,FD,F0,BE
        .he C0,BD,00,DC,00,F0,00,C0 ; DB C0,BD,00,DC,00,F0,00,C0
        .he 00 ; DB 00

;L99E6   DB 38,FF,C3,FF,CF,D7,3F,FC ; 8.....?.
;99EE    DB FF,B3,F7,8D,FF,3F,BF,FF
;99F6    DB FF,F7,FF,FF,FF,FF,BF,FF
;99FE    DB FF,FF,CD,FF,FF,DF,ED,FF
;9A06    DB FF,FF,FF,FE,EF,FF,FF,DF
;9A0E    DB FF,FF,FB,FB,FF,BD,9F,7F
;9A16    DB DF,FF,FF,DF,FF,FA,FF,FF
;9A1E    DB F7,FF,D3,BF,F7,7F,FF,BF
;9A26    DB 7F,FE,7F,FF,FF,FF,F7,E7
;9A2E    DB FF,FF,FF,FF,F7,FF,EF,EF
;9A36    DB F7,F7,FF,FE,FF,FF,7F,FF
;9A3E    DB FB,FF,FB,EF,FF,CF,DF,ED
;9A46    DB FD,BE,FF,FF,FC,FF,F0,AF
;9A4E    DB C0,FF,00,FC,00,F0,00,C0
;9A56    DB 00

L99E6   .he 38,FF,C3,FF,CF,D7,3F,FC ; DB 38,FF,C3,FF,CF,D7,3F,FC
        .he FF,B3,F7,8D,FF,3F,BF,FF ; DB FF,B3,F7,8D,FF,3F,BF,FF
        .he FF,F7,FF,FF,FF,FF,BF,FF ; DB FF,F7,FF,FF,FF,FF,BF,FF
        .he FF,FF,CD,FF,FF,DF,ED,FF ; DB FF,FF,CD,FF,FF,DF,ED,FF
        .he FF,FF,FF,FE,EF,FF,FF,DF ; DB FF,FF,FF,FE,EF,FF,FF,DF
        .he FF,FF,FB,FB,FF,BD,9F,7F ; DB FF,FF,FB,FB,FF,BD,9F,7F
        .he DF,FF,FF,DF,FF,FA,FF,FF ; DB DF,FF,FF,DF,FF,FA,FF,FF
        .he F7,FF,D3,BF,F7,7F,FF,BF ; DB F7,FF,D3,BF,F7,7F,FF,BF
        .he 7F,FE,7F,FF,FF,FF,F7,E7 ; DB 7F,FE,7F,FF,FF,FF,F7,E7
        .he FF,FF,FF,FF,F7,FF,EF,EF ; DB FF,FF,FF,FF,F7,FF,EF,EF
        .he F7,F7,FF,FE,FF,FF,7F,FF ; DB F7,F7,FF,FE,FF,FF,7F,FF
        .he FB,FF,FB,EF,FF,CF,DF,ED ; DB FB,FF,FB,EF,FF,CF,DF,ED
        .he FD,BE,FF,FF,FC,FF,F0,AF ; DB FD,BE,FF,FF,FC,FF,F0,AF
        .he C0,FF,00,FC,00,F0,00,C0 ; DB C0,FF,00,FC,00,F0,00,C0
        .he 00 ; DB 00

;L9A57   DB 40,00,00,00,00,00,00,00
;9A5F    DB 00,00,00,00,00,00,00,E0
;9A67    DB 00,D8,00,CA,00,D5,80,CA
;9A6F    DB 80,D5,00,CA,80,D5,00,4A
;9A77    DB 80,D5,00,CA,80,95,00,CA
;9A7F    DB 80,D5,00,CA,80,D5,00,CA
;9A87    DB 80,95,00,CA,80,95,00,CA
;9A8F    DB 80,D5,00,8A,80,D5,00,CA
;9A97    DB 80,D5,00,4A,80,D5,00,CA
;9A9F    DB 80,D5,00,CA,80,D5,00,4A
;9AA7    DB 80,D5,00,CA,80,D5,40,EA
;9AAF    DB A0,E5,50,F2,A8,F9,55,FC ; ..P...U.
;9AB7    DB AA,DF,01,BF,FF,FD,FF,FF
;9ABF    DB FD,FD,FF,FF,FF,FF,F7,FF
;9AC7    DB FF,EF,FF,B7,FC,FF,F3,FF
;9ACF    DB CB,FF,3B,FC,EF,F2,FF,CF
;9AD7    DB FF

L9A57   .he 40,00,00,00,00,00,00,00 ; DB 40,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,E0 ; DB 00,00,00,00,00,00,00,E0
        .he 00,D8,00,CA,00,D5,80,CA ; DB 00,D8,00,CA,00,D5,80,CA
        .he 80,D5,00,CA,80,D5,00,4A ; DB 80,D5,00,CA,80,D5,00,4A
        .he 80,D5,00,CA,80,95,00,CA ; DB 80,D5,00,CA,80,95,00,CA
        .he 80,D5,00,CA,80,D5,00,CA ; DB 80,D5,00,CA,80,D5,00,CA
        .he 80,95,00,CA,80,95,00,CA ; DB 80,95,00,CA,80,95,00,CA
        .he 80,D5,00,8A,80,D5,00,CA ; DB 80,D5,00,8A,80,D5,00,CA
        .he 80,D5,00,4A,80,D5,00,CA ; DB 80,D5,00,4A,80,D5,00,CA
        .he 80,D5,00,CA,80,D5,00,4A ; DB 80,D5,00,CA,80,D5,00,4A
        .he 80,D5,00,CA,80,D5,40,EA ; DB 80,D5,00,CA,80,D5,40,EA
        .he A0,E5,50,F2,A8,F9,55,FC ; DB A0,E5,50,F2,A8,F9,55,FC
        .he AA,DF,01,BF,FF,FD,FF,FF ; DB AA,DF,01,BF,FF,FD,FF,FF
        .he FD,FD,FF,FF,FF,FF,F7,FF ; DB FD,FD,FF,FF,FF,FF,F7,FF
        .he FF,EF,FF,B7,FC,FF,F3,FF ; DB FF,EF,FF,B7,FC,FF,F3,FF
        .he CB,FF,3B,FC,EF,F2,FF,CF ; DB CB,FF,3B,FC,EF,F2,FF,CF
        .he FF ; DB FF

;L9AD8   DB 40,00,03,00,0F,00,0F,00
;9AE0    DB 0F,00,0F,00,0B,00,0F,00
;9AE8    DB 0F,00,0F,00,0B,00,0D,00
;9AF0    DB 0F,00,0B,00,0B,00,0F,00
;9AF8    DB 0F,00,0F,00,0F,00,0E,00
;9B00    DB 09,00,0D,00,0F,00,0F,00
;9B08    DB 0F,00,0F,00,0F,00,0F,00
;9B10    DB 0F,00,0F,00,0D,00,0F,00
;9B18    DB 0F,00,0D,00,0F,00,0D,00
;9B20    DB 0B,00,0B,00,0F,00,1E,00
;9B28    DB 1F,00,1F,00,1D,00,3F,00
;9B30    DB 3F,00,3F,00,7F,00,7F,00 ; ?.?.....
;9B38    DB E7,00,FF,01,FF,01,FF,03
;9B40    DB FD,03,FF,27,F7,4F,EF,3F ; ...'.O.?
;9B48    DB FF,FE,FF,FC,FC,EF,F3,B7
;9B50    DB CF,77,33,BC,7B,F3,BF,CF
;9B58    DB FF

L9AD8   .he 40,00,03,00,0F,00,0F,00 ; DB 40,00,03,00,0F,00,0F,00
        .he 0F,00,0F,00,0B,00,0F,00 ; DB 0F,00,0F,00,0B,00,0F,00
        .he 0F,00,0F,00,0B,00,0D,00 ; DB 0F,00,0F,00,0B,00,0D,00
        .he 0F,00,0B,00,0B,00,0F,00 ; DB 0F,00,0B,00,0B,00,0F,00
        .he 0F,00,0F,00,0F,00,0E,00 ; DB 0F,00,0F,00,0F,00,0E,00
        .he 09,00,0D,00,0F,00,0F,00 ; DB 09,00,0D,00,0F,00,0F,00
        .he 0F,00,0F,00,0F,00,0F,00 ; DB 0F,00,0F,00,0F,00,0F,00
        .he 0F,00,0F,00,0D,00,0F,00 ; DB 0F,00,0F,00,0D,00,0F,00
        .he 0F,00,0D,00,0F,00,0D,00 ; DB 0F,00,0D,00,0F,00,0D,00
        .he 0B,00,0B,00,0F,00,1E,00 ; DB 0B,00,0B,00,0F,00,1E,00
        .he 1F,00,1F,00,1D,00,3F,00 ; DB 1F,00,1F,00,1D,00,3F,00
        .he 3F,00,3F,00,7F,00,7F,00 ; DB 3F,00,3F,00,7F,00,7F,00
        .he E7,00,FF,01,FF,01,FF,03 ; DB E7,00,FF,01,FF,01,FF,03
        .he FD,03,FF,27,F7,4F,EF,3F ; DB FD,03,FF,27,F7,4F,EF,3F
        .he FF,FE,FF,FC,FC,EF,F3,B7 ; DB FF,FE,FF,FC,FC,EF,F3,B7
        .he CF,77,33,BC,7B,F3,BF,CF ; DB CF,77,33,BC,7B,F3,BF,CF
        .he FF ; DB FF

;L9B59   DB 40,00,03,00,0F,00,2F,00 ; @...../.
;9B61    DB 79,03,FB,07,FD,3F,7F,FF
;9B69    DB 3F,FF,FF,BF,FF,F7,F7,FF
;9B71    DB EF,7F,FE,7F,FF,EF,FF,F7
;9B79    DB FF,FF,BF,FF,F3,FD,FF,FD
;9B81    DB FF,FF,FC,EF,F2,DF,CE,EF
;9B89    DB 3E,FC,FC,F3,F4,CF,E4,3F ; >......?
;9B91    DB 24,3D,24,01,24,51,24,21 ; $=$.$Q$!
;9B99    DB 24,51,24,21,24,51,24,21 ; $Q$!$Q$!
;9BA1    DB 24,51,24,21,25,51,25,21 ; $Q$!Q!
;9BA9    DB 25,51,25,21,27,51,23,A9 ; Q!'Q#.
;9BB1    DB 23,95,27,CB,27,E5,4D,F8 ; #.'.'.M.
;9BB9    DB 3F,FF,FF,FF,FF,EF,FF,FF
;9BC1    DB F7,FF,FF,EE,BF,F7,7F,FF
;9BC9    DB FF,FF,F7,FD,FC,DF,F3,DF
;9BD1    DB C7,EF,33,FC,BF,F3,3F,CF ; ..3...?.
;9BD9    DB FC

L9B59   .he 40,00,03,00,0F,00,2F,00 ; DB 40,00,03,00,0F,00,2F,00
        .he 79,03,FB,07,FD,3F,7F,FF ; DB 79,03,FB,07,FD,3F,7F,FF
        .he 3F,FF,FF,BF,FF,F7,F7,FF ; DB 3F,FF,FF,BF,FF,F7,F7,FF
        .he EF,7F,FE,7F,FF,EF,FF,F7 ; DB EF,7F,FE,7F,FF,EF,FF,F7
        .he FF,FF,BF,FF,F3,FD,FF,FD ; DB FF,FF,BF,FF,F3,FD,FF,FD
        .he FF,FF,FC,EF,F2,DF,CE,EF ; DB FF,FF,FC,EF,F2,DF,CE,EF
        .he 3E,FC,FC,F3,F4,CF,E4,3F ; DB 3E,FC,FC,F3,F4,CF,E4,3F
        .he 24,3D,24,01,24,51,24,21 ; DB 24,3D,24,01,24,51,24,21
        .he 24,51,24,21,24,51,24,21 ; DB 24,51,24,21,24,51,24,21
        .he 24,51,24,21,25,51,25,21 ; DB 24,51,24,21,25,51,25,21
        .he 25,51,25,21,27,51,23,A9 ; DB 25,51,25,21,27,51,23,A9
        .he 23,95,27,CB,27,E5,4D,F8 ; DB 23,95,27,CB,27,E5,4D,F8
        .he 3F,FF,FF,FF,FF,EF,FF,FF ; DB 3F,FF,FF,FF,FF,EF,FF,FF
        .he F7,FF,FF,EE,BF,F7,7F,FF ; DB F7,FF,FF,EE,BF,F7,7F,FF
        .he FF,FF,F7,FD,FC,DF,F3,DF ; DB FF,FF,F7,FD,FC,DF,F3,DF
        .he C7,EF,33,FC,BF,F3,3F,CF ; DB C7,EF,33,FC,BF,F3,3F,CF
        .he FC ; DB FC

;L9BDA   DB 40,00,03,00,0F,00,3F,00 ; @.....?.
;9BE2    DB BB,03,73,07,FF,3F,FF,9F
;9BEA    DB FF,BF,FF,DB,DF,FF,EF,FF
;9BF2    DB FF,DF,FF,CF,FF,FF,BB,FF
;9BFA    DB FF,FB,FF,F9,FF,FF,FF,FF
;9C02    DB FF,FF,FF,FF,BF,F7,DF,FB
;9C0A    DB FF,FF,FF,7F,FF,BF,FB,FF
;9C12    DB FF,FF,7F,EE,FF,F6,FB,FF
;9C1A    DB 7F,FF,FF,EF,FF,FF,FB,FF
;9C22    DB F7,FE,FF,CF,FF,DF,FF,FF
;9C2A    DB FF,FE,FF,FF,FB,FF,FD,FF
;9C32    DB EF,DF,DF,FF,EF,FF,DD,FF
;9C3A    DB FF,FF,BF,FF,FE,F9,F7,FB
;9C42    DB FB,FF,DF,FF,FF,FF,FF,FF
;9C4A    DB DF,FF,FF,FF,BC,EF,F1,F6
;9C52    DB CF,FD,3F,FC,F3,F2,FF,CF
;9C5A    DB FC

L9BDA   .he 40,00,03,00,0F,00,3F,00 ; DB 40,00,03,00,0F,00,3F,00
        .he BB,03,73,07,FF,3F,FF,9F ; DB BB,03,73,07,FF,3F,FF,9F
        .he FF,BF,FF,DB,DF,FF,EF,FF ; DB FF,BF,FF,DB,DF,FF,EF,FF
        .he FF,DF,FF,CF,FF,FF,BB,FF ; DB FF,DF,FF,CF,FF,FF,BB,FF
        .he FF,FB,FF,F9,FF,FF,FF,FF ; DB FF,FB,FF,F9,FF,FF,FF,FF
        .he FF,FF,FF,FF,BF,F7,DF,FB ; DB FF,FF,FF,FF,BF,F7,DF,FB
        .he FF,FF,FF,7F,FF,BF,FB,FF ; DB FF,FF,FF,7F,FF,BF,FB,FF
        .he FF,FF,7F,EE,FF,F6,FB,FF ; DB FF,FF,7F,EE,FF,F6,FB,FF
        .he 7F,FF,FF,EF,FF,FF,FB,FF ; DB 7F,FF,FF,EF,FF,FF,FB,FF
        .he F7,FE,FF,CF,FF,DF,FF,FF ; DB F7,FE,FF,CF,FF,DF,FF,FF
        .he FF,FE,FF,FF,FB,FF,FD,FF ; DB FF,FE,FF,FF,FB,FF,FD,FF
        .he EF,DF,DF,FF,EF,FF,DD,FF ; DB EF,DF,DF,FF,EF,FF,DD,FF
        .he FF,FF,BF,FF,FE,F9,F7,FB ; DB FF,FF,BF,FF,FE,F9,F7,FB
        .he FB,FF,DF,FF,FF,FF,FF,FF ; DB FB,FF,DF,FF,FF,FF,FF,FF
        .he DF,FF,FF,FF,BC,EF,F1,F6 ; DB DF,FF,FF,FF,BC,EF,F1,F6
        .he CF,FD,3F,FC,F3,F2,FF,CF ; DB CF,FD,3F,FC,F3,F2,FF,CF
        .he FC ; DB FC

;L9C5B   DB 38,FF,F3,F9,4F,FB,3F,7C ; 8...O.?.
;9C63    DB FF,F3,FB,CF,FF,3F,FB,FE
;9C6B    DB FF,FD,FD,FE,FB,FF,FF,EF
;9C73    DB F7,FF,EF,DD,F7,EF,FF,FF
;9C7B    DB FE,FF,F0,9F,80,80,06,80
;9C83    DB 66,BE,66,BF,7E,B3,7E,B3
;9C8B    DB 66,BE,66,B3,3C,B3,18,BE
;9C93    DB 00,80,02,E0,23,FE,22,FE ; ....#.".
;9C9B    DB 3A,FE,60,FF,07,7F,FF,BF
;9CA3    DB FF,77,FB,7B,F7,FF,FF,FF
;9CAB    DB F7,FE,EF,FD,FD,FE,FB,FF
;9CB3    DB FF,FF,9F,FF,BF,FF,9F,F7
;9CBB    DB FF,FF,FF,FF,FC,FF,F0,FF
;9CC3    DB C0,FF,00,FC,00,F0,00,C0
;9CCB    DB 00

L9C5B   .he 38,FF,F3,F9,4F,FB,3F,7C ; DB 38,FF,F3,F9,4F,FB,3F,7C
        .he FF,F3,FB,CF,FF,3F,FB,FE ; DB FF,F3,FB,CF,FF,3F,FB,FE
        .he FF,FD,FD,FE,FB,FF,FF,EF ; DB FF,FD,FD,FE,FB,FF,FF,EF
        .he F7,FF,EF,DD,F7,EF,FF,FF ; DB F7,FF,EF,DD,F7,EF,FF,FF
        .he FE,FF,F0,9F,80,80,06,80 ; DB FE,FF,F0,9F,80,80,06,80
        .he 66,BE,66,BF,7E,B3,7E,B3 ; DB 66,BE,66,BF,7E,B3,7E,B3
        .he 66,BE,66,B3,3C,B3,18,BE ; DB 66,BE,66,B3,3C,B3,18,BE
        .he 00,80,02,E0,23,FE,22,FE ; DB 00,80,02,E0,23,FE,22,FE
        .he 3A,FE,60,FF,07,7F,FF,BF ; DB 3A,FE,60,FF,07,7F,FF,BF
        .he FF,77,FB,7B,F7,FF,FF,FF ; DB FF,77,FB,7B,F7,FF,FF,FF
        .he F7,FE,EF,FD,FD,FE,FB,FF ; DB F7,FE,EF,FD,FD,FE,FB,FF
        .he FF,FF,9F,FF,BF,FF,9F,F7 ; DB FF,FF,9F,FF,BF,FF,9F,F7
        .he FF,FF,FF,FF,FC,FF,F0,FF ; DB FF,FF,FF,FF,FC,FF,F0,FF
        .he C0,FF,00,FC,00,F0,00,C0 ; DB C0,FF,00,FC,00,F0,00,C0
        .he 00 ; DB 00

;L9CCC   DB 38,FF,F3,FE,CF,EF,3F,CC ; 8.....?.
;9CD4    DB FF,F3,FF,CF,FF,3F,FB,FE
;9CDC    DB FF,FF,7F,FF,ED,FF,FD,BF
;9CE4    DB D9,FF,F1,F9,E1,FF,C1,FF
;9CEC    DB 81,DF,0D,DE,5D,FC,DD,F8
;9CF4    DB F9,F0,F1,E0,E1,86,F9,06
;9CFC    DB FD,66,D9,6E,D3,6E,C7,7E
;9D04    DB 0F,76,1F,76,3F,66,7D,60
;9D0C    DB 7C,60,7F,0E,6F,18,FF,54
;9D14    DB FF,59,FF,C3,FF,47,EF,1F ; .Y...G..
;9D1C    DB E7,FF,FF,FF,FF,FE,FB,FF
;9D24    DB FF,FF,FF,7F,BF,EF,FF,F7
;9D2C    DB FF,FF,FF,DF,FC,DF,F0,EF
;9D34    DB C0,FF,00,FC,00,F0,00,C0
;9D3C    DB 00

L9CCC   .he 38,FF,F3,FE,CF,EF,3F,CC ; DB 38,FF,F3,FE,CF,EF,3F,CC
        .he FF,F3,FF,CF,FF,3F,FB,FE ; DB FF,F3,FF,CF,FF,3F,FB,FE
        .he FF,FF,7F,FF,ED,FF,FD,BF ; DB FF,FF,7F,FF,ED,FF,FD,BF
        .he D9,FF,F1,F9,E1,FF,C1,FF ; DB D9,FF,F1,F9,E1,FF,C1,FF
        .he 81,DF,0D,DE,5D,FC,DD,F8 ; DB 81,DF,0D,DE,5D,FC,DD,F8
        .he F9,F0,F1,E0,E1,86,F9,06 ; DB F9,F0,F1,E0,E1,86,F9,06
        .he FD,66,D9,6E,D3,6E,C7,7E ; DB FD,66,D9,6E,D3,6E,C7,7E
        .he 0F,76,1F,76,3F,66,7D,60 ; DB 0F,76,1F,76,3F,66,7D,60
        .he 7C,60,7F,0E,6F,18,FF,54 ; DB 7C,60,7F,0E,6F,18,FF,54
        .he FF,59,FF,C3,FF,47,EF,1F ; DB FF,59,FF,C3,FF,47,EF,1F
        .he E7,FF,FF,FF,FF,FE,FB,FF ; DB E7,FF,FF,FF,FF,FE,FB,FF
        .he FF,FF,FF,7F,BF,EF,FF,F7 ; DB FF,FF,FF,7F,BF,EF,FF,F7
        .he FF,FF,FF,DF,FC,DF,F0,EF ; DB FF,FF,FF,DF,FC,DF,F0,EF
        .he C0,FF,00,FC,00,F0,00,C0 ; DB C0,FF,00,FC,00,F0,00,C0
        .he 00 ; DB 00

;L9D3D   DB 38,FF,F3,DF,CF,CF,3F,FC ; 8.....?.
;9D45    DB FB,F3,BB,CF,9F,37,FF,FF
;9D4D    DB FF,FF,FF,F7,FF,BF,EF,3C
;9D55    DB F7,FF,EF,FF,FF,F7,FF,FF
;9D5D    DB FE,F9,F0,9F,80,80,02,B0
;9D65    DB 66,BB,66,9B,76,9B,7E,8F
;9D6D    DB 7E,9F,6E,9B,66,BB,64,93
;9D75    DB 40,C0,04,F0,F7,FE,34,FE ; @.....4.
;9D7D    DB 54,BA,30,FF,07,EF,FF,DF ; T.0.....
;9D85    DB FF,FF,FC,FF,EF,F9,CF,FB
;9D8D    DB FF,FF,FF,DF,FF,FF,F7,FF
;9D95    DB 7B,BB,3F,DF,7F,FF,FF,FF
;9D9D    DB FF,FF,9F,F7,FC,E7,F0,FF
;9DA5    DB C0,BF,00,FC,00,F0,00,C0
;9DAD    DB 00

L9D3D   .he 38,FF,F3,DF,CF,CF,3F,FC ; DB 38,FF,F3,DF,CF,CF,3F,FC
        .he FB,F3,BB,CF,9F,37,FF,FF ; DB FB,F3,BB,CF,9F,37,FF,FF
        .he FF,FF,FF,F7,FF,BF,EF,3C ; DB FF,FF,FF,F7,FF,BF,EF,3C
        .he F7,FF,EF,FF,FF,F7,FF,FF ; DB F7,FF,EF,FF,FF,F7,FF,FF
        .he FE,F9,F0,9F,80,80,02,B0 ; DB FE,F9,F0,9F,80,80,02,B0
        .he 66,BB,66,9B,76,9B,7E,8F ; DB 66,BB,66,9B,76,9B,7E,8F
        .he 7E,9F,6E,9B,66,BB,64,93 ; DB 7E,9F,6E,9B,66,BB,64,93
        .he 40,C0,04,F0,F7,FE,34,FE ; DB 40,C0,04,F0,F7,FE,34,FE
        .he 54,BA,30,FF,07,EF,FF,DF ; DB 54,BA,30,FF,07,EF,FF,DF
        .he FF,FF,FC,FF,EF,F9,CF,FB ; DB FF,FF,FC,FF,EF,F9,CF,FB
        .he FF,FF,FF,DF,FF,FF,F7,FF ; DB FF,FF,FF,DF,FF,FF,F7,FF
        .he 7B,BB,3F,DF,7F,FF,FF,FF ; DB 7B,BB,3F,DF,7F,FF,FF,FF
        .he FF,FF,9F,F7,FC,E7,F0,FF ; DB FF,FF,9F,F7,FC,E7,F0,FF
        .he C0,BF,00,FC,00,F0,00,C0 ; DB C0,BF,00,FC,00,F0,00,C0
        .he 00 ; DB 00

;L9DAE   DB 38,FF,73,77,CF,BF,3D,BC ; 8.....=.
;9DB6    DB FB,73,FF,CE,EF,2F,CD,FF
;9DBE    DB FF,FF,BF,BF,3D,DF,FD,BD
;9DC6    DB F9,FB,B1,FF,E1,FF,C1,EF
;9DCE    DB 8D,FF,1D,FE,3D,3C,6D,B8 ; ....=<..
;9DD6    DB CD,70,DD,E2,FD,86,6D,26
;9DDE    DB 4D,66,D9,6E,F3,7E,E5,76
;9DE6    DB 4C,66,1F,6E,3B,7C,79,78 ; L...;...
;9DEE    DB 7F,60,7F,08,7F,08,FF,8C
;9DF6    DB FF,B9,FB,83,BF,87,DF,1F
;9DFE    DB DF,FF,FF,FF,FB,FB,FF,7F
;9E06    DB FF,FF,7E,FF,39,FF,7F,FF
;9E0E    DB FF,EF,FF,DF,FC,FB,F0,FD
;9E16    DB C0,FF,00,FC,00,F0,00,C0
;9E1E    DB 00

L9DAE   .he 38,FF,73,77,CF,BF,3D,BC ; DB 38,FF,73,77,CF,BF,3D,BC
        .he FB,73,FF,CE,EF,2F,CD,FF ; DB FB,73,FF,CE,EF,2F,CD,FF
        .he FF,FF,BF,BF,3D,DF,FD,BD ; DB FF,FF,BF,BF,3D,DF,FD,BD
        .he F9,FB,B1,FF,E1,FF,C1,EF ; DB F9,FB,B1,FF,E1,FF,C1,EF
        .he 8D,FF,1D,FE,3D,3C,6D,B8 ; DB 8D,FF,1D,FE,3D,3C,6D,B8
        .he CD,70,DD,E2,FD,86,6D,26 ; DB CD,70,DD,E2,FD,86,6D,26
        .he 4D,66,D9,6E,F3,7E,E5,76 ; DB 4D,66,D9,6E,F3,7E,E5,76
        .he 4C,66,1F,6E,3B,7C,79,78 ; DB 4C,66,1F,6E,3B,7C,79,78
        .he 7F,60,7F,08,7F,08,FF,8C ; DB 7F,60,7F,08,7F,08,FF,8C
        .he FF,B9,FB,83,BF,87,DF,1F ; DB FF,B9,FB,83,BF,87,DF,1F
        .he DF,FF,FF,FF,FB,FB,FF,7F ; DB DF,FF,FF,FF,FB,FB,FF,7F
        .he FF,FF,7E,FF,39,FF,7F,FF ; DB FF,FF,7E,FF,39,FF,7F,FF
        .he FF,EF,FF,DF,FC,FB,F0,FD ; DB FF,EF,FF,DF,FC,FB,F0,FD
        .he C0,FF,00,FC,00,F0,00,C0 ; DB C0,FF,00,FC,00,F0,00,C0
        .he 00 ; DB 00

;L9E1F   DB 40,00,02,00,0E,00,2E,00 ; @.......
;9E27    DB EC,02,E3,0E,CC,2E,31,EC ; ......1.
;9E2F    DB C1,E3,01,CC,C1,31,A1,C1
;9E37    DB A1,D1,A1,C9,A1,D5,A1,C9
;9E3F    DB A1,D5,A1,C9,A1,D5,A1,C9
;9E47    DB A1,D5,A1,C9,A1,D5,A0,C9
;9E4F    DB A3,D5,AF,C9,3F,D4,FC,CB
;9E57    DB F3,CF,CF,DF,3C,DC,F0,D3
;9E5F    DB C0,CF,00,D4,00,C8,00,D4
;9E67    DB 00,C8,00,D4,00,C8,00,D4
;9E6F    DB 00,C8,00,D4,00,C8,00,D4
;9E77    DB 00,C8,00,D4,00,C8,00,D4
;9E7F    DB 00,C8,00,D4,00,C8,00,D4
;9E87    DB 00,C0,00,D0,00,D8,00,DF
;9E8F    DB 07,DF,FF,D7,FC,DF,F3,DF
;9E97    DB CF,D7,3F,DC,FF,D3,FF,CF
;9E9F    DB FC

L9E1F   .he 40,00,02,00,0E,00,2E,00 ; DB 40,00,02,00,0E,00,2E,00
        .he EC,02,E3,0E,CC,2E,31,EC ; DB EC,02,E3,0E,CC,2E,31,EC
        .he C1,E3,01,CC,C1,31,A1,C1 ; DB C1,E3,01,CC,C1,31,A1,C1
        .he A1,D1,A1,C9,A1,D5,A1,C9 ; DB A1,D1,A1,C9,A1,D5,A1,C9
        .he A1,D5,A1,C9,A1,D5,A1,C9 ; DB A1,D5,A1,C9,A1,D5,A1,C9
        .he A1,D5,A1,C9,A1,D5,A0,C9 ; DB A1,D5,A1,C9,A1,D5,A0,C9
        .he A3,D5,AF,C9,3F,D4,FC,CB ; DB A3,D5,AF,C9,3F,D4,FC,CB
        .he F3,CF,CF,DF,3C,DC,F0,D3 ; DB F3,CF,CF,DF,3C,DC,F0,D3
        .he C0,CF,00,D4,00,C8,00,D4 ; DB C0,CF,00,D4,00,C8,00,D4
        .he 00,C8,00,D4,00,C8,00,D4 ; DB 00,C8,00,D4,00,C8,00,D4
        .he 00,C8,00,D4,00,C8,00,D4 ; DB 00,C8,00,D4,00,C8,00,D4
        .he 00,C8,00,D4,00,C8,00,D4 ; DB 00,C8,00,D4,00,C8,00,D4
        .he 00,C8,00,D4,00,C8,00,D4 ; DB 00,C8,00,D4,00,C8,00,D4
        .he 00,C0,00,D0,00,D8,00,DF ; DB 00,C0,00,D0,00,D8,00,DF
        .he 07,DF,FF,D7,FC,DF,F3,DF ; DB 07,DF,FF,D7,FC,DF,F3,DF
        .he CF,D7,3F,DC,FF,D3,FF,CF ; DB CF,D7,3F,DC,FF,D3,FF,CF
        .he FC ; DB FC

;L9EA0   DB 40,00,02,00,0E,00,2E,00 ; @.......
;9EA8    DB EC,02,E3,0E,CF,2E,33,EC ; ......3.
;9EB0    DB C3,E3,03,CC,C3,31,A3,C1
;9EB8    DB A3,01,A3,C1,A3,A1,A3,A1
;9EC0    DB A3,A1,A3,A1,A3,A1,A3,A1
;9EC8    DB A3,A1,A3,A1,A3,A1,A3,A1
;9ED0    DB A3,A1,AB,A1,3B,A0,FB,A3
;9ED8    DB F3,AF,CF,3F,3F,FC,F3,F3 ; ...??...
;9EE0    DB C3,CF,03,3C,03,F0,03,C0
;9EE8    DB 03,00,03,00,03,00,03,00
;9EF0    DB 03,00,03,00,03,00,03,00
;9EF8    DB 03,00,03,00,03,00,03,00
;9F00    DB 03,00,0B,00,0B,00,1B,00
;9F08    DB 1B,00,3B,00,2B,00,7B,00 ; ..;.+...
;9F10    DB 7B,00,EB,01,F8,03,F3,07
;9F18    DB CF,0F,3F,3C,FF,F3,FF,CF ; ..?<....
;9F20    DB FC

L9EA0   .he 40,00,02,00,0E,00,2E,00 ; DB 40,00,02,00,0E,00,2E,00
        .he EC,02,E3,0E,CF,2E,33,EC ; DB EC,02,E3,0E,CF,2E,33,EC
        .he C3,E3,03,CC,C3,31,A3,C1 ; DB C3,E3,03,CC,C3,31,A3,C1
        .he A3,01,A3,C1,A3,A1,A3,A1 ; DB A3,01,A3,C1,A3,A1,A3,A1
        .he A3,A1,A3,A1,A3,A1,A3,A1 ; DB A3,A1,A3,A1,A3,A1,A3,A1
        .he A3,A1,A3,A1,A3,A1,A3,A1 ; DB A3,A1,A3,A1,A3,A1,A3,A1
        .he A3,A1,AB,A1,3B,A0,FB,A3 ; DB A3,A1,AB,A1,3B,A0,FB,A3
        .he F3,AF,CF,3F,3F,FC,F3,F3 ; DB F3,AF,CF,3F,3F,FC,F3,F3
        .he C3,CF,03,3C,03,F0,03,C0 ; DB C3,CF,03,3C,03,F0,03,C0
        .he 03,00,03,00,03,00,03,00 ; DB 03,00,03,00,03,00,03,00
        .he 03,00,03,00,03,00,03,00 ; DB 03,00,03,00,03,00,03,00
        .he 03,00,03,00,03,00,03,00 ; DB 03,00,03,00,03,00,03,00
        .he 03,00,0B,00,0B,00,1B,00 ; DB 03,00,0B,00,0B,00,1B,00
        .he 1B,00,3B,00,2B,00,7B,00 ; DB 1B,00,3B,00,2B,00,7B,00
        .he 7B,00,EB,01,F8,03,F3,07 ; DB 7B,00,EB,01,F8,03,F3,07
        .he CF,0F,3F,3C,FF,F3,FF,CF ; DB CF,0F,3F,3C,FF,F3,FF,CF
        .he FC ; DB FC

;L9F21   DB 38,3F,F0,FF,C0,FF,00,FC ; 8?......
;9F29    DB 01,F0,07,C0,1F,00,FE,C1
;9F31    DB F9,CF,E6,DF,98,DE,61,D9
;9F39    DB 87,C6,1F,DC,7E,C1,F9,C7
;9F41    DB E6,DF,98,DE,60,D9,83,C6
;9F49    DB 0F,D8,3F,C0,FC,C3,F3,CF
;9F51    DB CF,DF,3C,DC,F0,D3,C0,CF
;9F59    DB 00,D4,00,C0,00,C8,00,D4
;9F61    DB 00,C8,00,D4,00,C8,00,D4
;9F69    DB 00,C8,00,D4,00,C8,00,D4
;9F71    DB 00,C8,00,D4,00,C8,00,D4
;9F79    DB 00,C8,00,D4,00,D8,00,DF
;9F81    DB 07,DF,FF,D7,FC,DF,F0,DF
;9F89    DB C0,D7,00,DC,00,D0,00,C0
;9F91    DB 00

L9F21   .he 38,3F,F0,FF,C0,FF,00,FC ; DB 38,3F,F0,FF,C0,FF,00,FC
        .he 01,F0,07,C0,1F,00,FE,C1 ; DB 01,F0,07,C0,1F,00,FE,C1
        .he F9,CF,E6,DF,98,DE,61,D9 ; DB F9,CF,E6,DF,98,DE,61,D9
        .he 87,C6,1F,DC,7E,C1,F9,C7 ; DB 87,C6,1F,DC,7E,C1,F9,C7
        .he E6,DF,98,DE,60,D9,83,C6 ; DB E6,DF,98,DE,60,D9,83,C6
        .he 0F,D8,3F,C0,FC,C3,F3,CF ; DB 0F,D8,3F,C0,FC,C3,F3,CF
        .he CF,DF,3C,DC,F0,D3,C0,CF ; DB CF,DF,3C,DC,F0,D3,C0,CF
        .he 00,D4,00,C0,00,C8,00,D4 ; DB 00,D4,00,C0,00,C8,00,D4
        .he 00,C8,00,D4,00,C8,00,D4 ; DB 00,C8,00,D4,00,C8,00,D4
        .he 00,C8,00,D4,00,C8,00,D4 ; DB 00,C8,00,D4,00,C8,00,D4
        .he 00,C8,00,D4,00,C8,00,D4 ; DB 00,C8,00,D4,00,C8,00,D4
        .he 00,C8,00,D4,00,D8,00,DF ; DB 00,C8,00,D4,00,D8,00,DF
        .he 07,DF,FF,D7,FC,DF,F0,DF ; DB 07,DF,FF,D7,FC,DF,F0,DF
        .he C0,D7,00,DC,00,D0,00,C0 ; DB C0,D7,00,DC,00,D0,00,C0
        .he 00 ; DB 00

;L9F92   DB 38,3F,F3,FF,C3,FF,03,FC ; 8?......
;9F9A    DB 03,F0,03,C0,1B,00,7B,01
;9FA2    DB FB,07,E3,1F,9B,7E,63,F9
;9FAA    DB 83,E6,1B,98,7B,61,FB,87
;9FB2    DB EB,1F,9B,7E,63,F9,83,E6
;9FBA    DB 0B,98,3B,60,FB,83,F3,0F
;9FC2    DB CF,3F,3F,FC,F3,F3,C3,CF ; .??.....
;9FCA    DB 03,3C,03,F0,03,C0,03,00
;9FD2    DB 03,00,03,00,03,00,03,00
;9FDA    DB 03,00,03,00,03,00,03,00
;9FE2    DB 03,00,0B,00,0B,00,1B,00
;9FEA    DB 1B,00,3B,00,2B,00,7B,00 ; ..;.+...
;9FF2    DB 7B,00,EB,01,F8,03,F0,07
;9FFA    DB C0,0F,00,3C,00,F0,00,C0
;A002    DB 00

L9F92   .he 38,3F,F3,FF,C3,FF,03,FC ; DB 38,3F,F3,FF,C3,FF,03,FC
        .he 03,F0,03,C0,1B,00,7B,01 ; DB 03,F0,03,C0,1B,00,7B,01
        .he FB,07,E3,1F,9B,7E,63,F9 ; DB FB,07,E3,1F,9B,7E,63,F9
        .he 83,E6,1B,98,7B,61,FB,87 ; DB 83,E6,1B,98,7B,61,FB,87
        .he EB,1F,9B,7E,63,F9,83,E6 ; DB EB,1F,9B,7E,63,F9,83,E6
        .he 0B,98,3B,60,FB,83,F3,0F ; DB 0B,98,3B,60,FB,83,F3,0F
        .he CF,3F,3F,FC,F3,F3,C3,CF ; DB CF,3F,3F,FC,F3,F3,C3,CF
        .he 03,3C,03,F0,03,C0,03,00 ; DB 03,3C,03,F0,03,C0,03,00
        .he 03,00,03,00,03,00,03,00 ; DB 03,00,03,00,03,00,03,00
        .he 03,00,03,00,03,00,03,00 ; DB 03,00,03,00,03,00,03,00
        .he 03,00,0B,00,0B,00,1B,00 ; DB 03,00,0B,00,0B,00,1B,00
        .he 1B,00,3B,00,2B,00,7B,00 ; DB 1B,00,3B,00,2B,00,7B,00
        .he 7B,00,EB,01,F8,03,F0,07 ; DB 7B,00,EB,01,F8,03,F0,07
        .he C0,0F,00,3C,00,F0,00,C0 ; DB C0,0F,00,3C,00,F0,00,C0
        .he 00 ; DB 00

;LA003   DB 40,00,02,00,0E,00,3E,00 ; @.....>.
;A00B    DB 0E,00,66,00,66,36,E6,E6
;A013    DB E6,E7,E6,E7,66,E7,66,E6
;A01B    DB 06,E6,06,E0,66,E1,E6,E7
;A023    DB E6,E7,66,E6,66,E6,E6,E7
;A02B    DB E6,E7,86,E6,06,E0,66,E1
;A033    DB E6,E7,E6,E7,66,E6,66,E6
;A03B    DB E6,E7,E6,E7,86,E6,06,E0
;A043    DB 66,E1,E6,E7,86,E6,06,E6
;A04B    DB 06,E6,06,E6,06,E6,06,E6
;A053    DB 66,E0,66,E6,66,E6,E6,E7
;A05B    DB E6,E7,66,E6,66,E6,E6,E7
;A063    DB 86,E6,06,E0,66,E1,E6,E7
;A06B    DB E6,E6,66,E1,E6,E3,C6,E7
;A073    DB 06,E6,E6,E7,EC,E7,83,E6
;A07B    DB 0F,F0,3F,F8,FF,F3,FF,CF
;A083    DB FC

LA003   .he 40,00,02,00,0E,00,3E,00 ; DB 40,00,02,00,0E,00,3E,00
        .he 0E,00,66,00,66,36,E6,E6 ; DB 0E,00,66,00,66,36,E6,E6
        .he E6,E7,E6,E7,66,E7,66,E6 ; DB E6,E7,E6,E7,66,E7,66,E6
        .he 06,E6,06,E0,66,E1,E6,E7 ; DB 06,E6,06,E0,66,E1,E6,E7
        .he E6,E7,66,E6,66,E6,E6,E7 ; DB E6,E7,66,E6,66,E6,E6,E7
        .he E6,E7,86,E6,06,E0,66,E1 ; DB E6,E7,86,E6,06,E0,66,E1
        .he E6,E7,E6,E7,66,E6,66,E6 ; DB E6,E7,E6,E7,66,E6,66,E6
        .he E6,E7,E6,E7,86,E6,06,E0 ; DB E6,E7,E6,E7,86,E6,06,E0
        .he 66,E1,E6,E7,86,E6,06,E6 ; DB 66,E1,E6,E7,86,E6,06,E6
        .he 06,E6,06,E6,06,E6,06,E6 ; DB 06,E6,06,E6,06,E6,06,E6
        .he 66,E0,66,E6,66,E6,E6,E7 ; DB 66,E0,66,E6,66,E6,E6,E7
        .he E6,E7,66,E6,66,E6,E6,E7 ; DB E6,E7,66,E6,66,E6,E6,E7
        .he 86,E6,06,E0,66,E1,E6,E7 ; DB 86,E6,06,E0,66,E1,E6,E7
        .he E6,E6,66,E1,E6,E3,C6,E7 ; DB E6,E6,66,E1,E6,E3,C6,E7
        .he 06,E6,E6,E7,EC,E7,83,E6 ; DB 06,E6,E6,E7,EC,E7,83,E6
        .he 0F,F0,3F,F8,FF,F3,FF,CF ; DB 0F,F0,3F,F8,FF,F3,FF,CF
        .he FC ; DB FC

;LA084   DB 40,00,00,00,00,00,00,00
;A08C    DB 00,00,00,00,00,34,00,F2
;A094    DB 00,F5,40,F2,80,F5,40,F2 ; ..@...@.
;A09C    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;A0A4    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;A0AC    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;A0B4    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;A0BC    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;A0C4    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;A0CC    DB 80,F5,40,F2,80,F5,40,F2 ; ..@...@.
;A0D4    DB 80,F5,40,F2,81,F5,47,F0 ; ..@...G.
;A0DC    DB 9F,F2,79,F9,E9,E7,C9,DF
;A0E4    DB C1,B9,C1,B1,C9,A1,C1,A9
;A0EC    DB C3,B9,4E,B8,79,B0,E7,A3
;A0F4    DB 9C,AE,73,B9,CC,A7,33,9C
;A0FC    DB CF,D3,3F,EC,FF,F3,FF,CF
;A104    DB FC

LA084   .he 40,00,00,00,00,00,00,00 ; DB 40,00,00,00,00,00,00,00
        .he 00,00,00,00,00,34,00,F2 ; DB 00,00,00,00,00,34,00,F2
        .he 00,F5,40,F2,80,F5,40,F2 ; DB 00,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,80,F5,40,F2 ; DB 80,F5,40,F2,80,F5,40,F2
        .he 80,F5,40,F2,81,F5,47,F0 ; DB 80,F5,40,F2,81,F5,47,F0
        .he 9F,F2,79,F9,E9,E7,C9,DF ; DB 9F,F2,79,F9,E9,E7,C9,DF
        .he C1,B9,C1,B1,C9,A1,C1,A9 ; DB C1,B9,C1,B1,C9,A1,C1,A9
        .he C3,B9,4E,B8,79,B0,E7,A3 ; DB C3,B9,4E,B8,79,B0,E7,A3
        .he 9C,AE,73,B9,CC,A7,33,9C ; DB 9C,AE,73,B9,CC,A7,33,9C
        .he CF,D3,3F,EC,FF,F3,FF,CF ; DB CF,D3,3F,EC,FF,F3,FF,CF
        .he FC ; DB FC

;LA105   DB 40,00,03,00,07,00,07,00
;A10D    DB 07,00,07,00,07,00,07,00
;A115    DB 07,00,07,00,07,00,07,00
;A11D    DB 07,00,07,00,07,00,07,00
;A125    DB 07,00,07,00,07,00,07,00
;A12D    DB 07,00,07,00,07,00,07,00
;A135    DB 07,00,07,00,07,00,07,00
;A13D    DB 07,00,07,00,07,00,07,00
;A145    DB 07,00,07,00,07,00,07,00
;A14D    DB 07,00,07,00,07,00,07,00
;A155    DB 0F,00,0F,00,0F,00,0F,00
;A15D    DB 0F,00,6F,01,D7,07,D7,1E
;A165    DB 57,78,57,E8,D7,99,D7,19 ; W.W.....
;A16D    DB D7,99,D7,99,D7,99,D7,9B
;A175    DB 97,1E,77,39,CC,E7,33,9C ; ...9..3.
;A17D    DB CF,73,3F,CC,FF,33,FF,CF ; ..?..3..
;A185    DB FC

LA105   .he 40,00,03,00,07,00,07,00 ; DB 40,00,03,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 07,00,07,00,07,00,07,00 ; DB 07,00,07,00,07,00,07,00
        .he 0F,00,0F,00,0F,00,0F,00 ; DB 0F,00,0F,00,0F,00,0F,00
        .he 0F,00,6F,01,D7,07,D7,1E ; DB 0F,00,6F,01,D7,07,D7,1E
        .he 57,78,57,E8,D7,99,D7,19 ; DB 57,78,57,E8,D7,99,D7,19
        .he D7,99,D7,99,D7,99,D7,9B ; DB D7,99,D7,99,D7,99,D7,9B
        .he 97,1E,77,39,CC,E7,33,9C ; DB 97,1E,77,39,CC,E7,33,9C
        .he CF,73,3F,CC,FF,33,FF,CF ; DB CF,73,3F,CC,FF,33,FF,CF
        .he FC ; DB FC

;LA186   DB 40,00,00,00,00,00,00,00
;A18E    DB 00,00,00,00,00,00,00,00
;A196    DB 00,00,00,00,00,00,00,00
;A19E    DB 00,00,00,00,00,00,00,00
;A1A6    DB 00,00,00,00,00,00,00,00
;A1AE    DB 00,00,00,00,00,00,00,00
;A1B6    DB 00,00,00,00,00,00,00,00
;A1BE    DB 00,00,00,00,00,00,00,00
;A1C6    DB 00,00,00,00,00,00,00,00
;A1CE    DB 00,00,00,00,00,00,00,00
;A1D6    DB 00,00,00,00,00,00,01,00
;A1DE    DB 01,00,05,00,0D,02,2D,02
;A1E6    DB AD,0B,AD,3B,AF,7B,B7,7B
;A1EE    DB B7,7B,BF,7B,BF,7B,BF,7B
;A1F6    DB BF,7B,BC,7B,B3,7B,8F,7B
;A1FE    DB 3F,78,FF,73,FF,4F,FF,3F ; ?....O.?
;A206    DB FC

LA186   .he 40,00,00,00,00,00,00,00 ; DB 40,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,01,00 ; DB 00,00,00,00,00,00,01,00
        .he 01,00,05,00,0D,02,2D,02 ; DB 01,00,05,00,0D,02,2D,02
        .he AD,0B,AD,3B,AF,7B,B7,7B ; DB AD,0B,AD,3B,AF,7B,B7,7B
        .he B7,7B,BF,7B,BF,7B,BF,7B ; DB B7,7B,BF,7B,BF,7B,BF,7B
        .he BF,7B,BC,7B,B3,7B,8F,7B ; DB BF,7B,BC,7B,B3,7B,8F,7B
        .he 3F,78,FF,73,FF,4F,FF,3F ; DB 3F,78,FF,73,FF,4F,FF,3F
        .he FC ; DB FC

;LA207   DB 7F

;LA207   .he 7F ; DB 7F
LA207	equ z80_free_zp

;LA208   DB 40

;LA208   .he 40 ; DB 40
LA208	equ LA207+1

;LA209   DB 02

;LA209   .he 02 ; DB 02
LA209	equ LA208+1

;LA20A   DB 9B
;LA20A   .he 9B ; DB 9B
LA20A	equ LA209+1



;LA20B   DB 7F,40,03

;LA20B   .he 7F,40,03 ; DB 7F,40,03
LA20B	equ LA20A+1

;LA20E   DB 44

;LA20E   .he 44 ; DB 44
LA20E	equ LA20B+3

;LA20F   DB FE,C0
;LA20F   .he FE,C0 ; DB FE,C0
LA20F	equ LA20E+1



;LA211   DB 00
;LA211   .he 00 ; DB 00
LA211	equ LA20F+2



;LA212   DB BF

;LA212   .he BF ; DB BF
LA212	equ LA211+1

;LA213   DB FE
;LA213   .he FE ; DB FE
LA213	equ LA212+1



;LA214   DB 00

;LA214   .he 00 ; DB 00
LA214	equ LA213+1

;LA215   DB 00
;LA215   .he 00 ; DB 00
LA215	equ LA214+1



;LA216   DB 00,00

;LA216   .he 00,00 ; DB 00,00
LA216	equ LA215+1

;LA218   DB 00

;LA218   .he 00 ; DB 00
LA218	equ LA216+2

;LA219   DB 00

;LA219   .he 00 ; DB 00
LA219	equ LA218+1

;LA21A   DB 00

;LA21A   .he 00 ; DB 00
LA21A	equ LA219+1

;LA21B   DB 00
;LA21B   .he 00 ; DB 00
LA21B	equ LA21A+1

;LA21C   DB 00
;LA21C   .he 00 ; DB 00
game_select_type	equ LA21B+1


;LA21D   DB 1E,00
;LA21D   .he 1E,00 ; DB 1E,00
LA21D	equ game_select_type+1




;LA21F   DB 00

;LA21F   .he 00 ; DB 00
LA21F	equ LA21D+2

;LA220   DB 00

;LA220   .he 00 ; DB 00
LA220	equ LA21F+1

;LA221   DB 1F

;LA221   .he 1F ; DB 1F
LA221	equ LA220+1

;LA222   DB 80
;LA222   .he 80 ; DB 80
LA222	equ LA221+1



;LA223   DB 00
;LA223   .he 00 ; DB 00
LA223	equ LA222+1



;LA224   DB 00
;LA224   .he 00 ; DB 00
LA224	equ LA223+1



;LA225   DB 07,80

;LA225   .he 07,80 ; DB 07,80
LA225	equ LA224+1

;LA227   DB 38
;LA227   .he 38 ; DB 38
LA227	equ LA225+2



;LA228   DB F8,08,40,3F,78 ; ..@?.
;LA228   .he F8,08,40,3F,78 ; DB F8,08,40,3F,78
LA228	equ LA227+1



;LA22D   DB 0F,C0,3F,90,0B

;LA22D   .he 0F,C0,3F,90,0B ; DB 0F,C0,3F,90,0B
LA22D	equ LA228+5

;LA232   DB C0,1F,C0,04,20,0E,00,07
;A23A    DB 80,01
;LA232   .he C0,1F,C0,04,20,0E,00,07 ; DB C0,1F,C0,04,20,0E,00,07
;        .he 80,01 ; DB 80,01
LA232	equ LA22D+5




;LA23C   DB 80
;LA23C   .he 80 ; DB 80
LA23C	equ LA232+10



;LA23D   DB 07,C0
;LA23D   .he 07,C0 ; DB 07,C0
LA23D	equ LA23C+1



;LA23F   DB 07

;LA23F   .he 07 ; DB 07
player_number	equ LA23D+2



;LA240   .he C0 ; DB C0
LA240	equ player_number+1



;LA241   DB 07

;LA241   .he 07 ; DB 07
LA241	equ LA240+1

;LA242   DB E0
;LA242   .he E0 ; DB E0
LA242	equ LA241+1



;LA243   DB 0F
;LA243   .he 0F ; DB 0F
LA243	equ LA242+1



;LA244   DB 40
;LA244   .he 40 ; DB 40
LA244	equ LA243+1



;LA245   DB 06

;LA245   .he 06 ; DB 06
LA245	equ LA244+1

;LA246   DB F0

;LA246   .he F0 ; DB F0
LA246	equ LA245+1

;LA247   DB 1F
;LA247   .he 1F ; DB 1F
LA247	equ LA246+1



;LA248   DB C0

;LA248   .he C0 ; DB C0
LA248	equ LA247+1

;LA249   DB 03,F8
;LA249   .he 03,F8 ; DB 03,F8
LA249	equ LA248+1



;LA24B   DB 1F,C0

;LA24B   .he 1F,C0 ; DB 1F,C0
LA24B	equ LA249+2

;LA24D   DB 03,FC
;LA24D   .he 03,FC ; DB 03,FC
LA24D	equ LA24B+2



;LA24F   DB 3F

;LA24F   .he 3F ; DB 3F
LA24F	equ LA24D+2

;LA250   DB C0,01

;LA250   .he C0,01 ; DB C0,01
LA250	equ LA24F+1

;LA252   DB FF,FF
;LA252   .he FF,FF ; DB FF,FF
LA252	equ LA250+2



;LA254   DB 40

;LA254   .he 40 ; DB 40
LA254	equ LA252+2

;LA255   DB 01
;LA255   .he 01 ; DB 01
LA255	equ LA254+1



;LA256   DB BF

;LA256   .he BF ; DB BF
LA256	equ LA255+1

;LA257   DB FF
;LA257   .he FF ; DB FF
LA257	equ LA256+1



;LA258   DB C0

;LA258   .he C0 ; DB C0
LA258	equ LA257+1

;LA259   DB 00,FF

;LA259   .he 00,FF ; DB 00,FF
LA259	equ LA258+1

;LA25B   DB FF

;LA25B   .he FF ; DB FF
LA25B	equ LA259+2

;LA25C   DB C0

;LA25C   .he C0 ; DB C0
LA25C	equ LA25B+1

;LA25D   DB 00
;LA25D   .he 00 ; DB 00
LA25D	equ LA25C+1



;LA25E   DB FF
;LA25E   .he FF ; DB FF
LA25E	equ LA25D+1



;LA25F   DB FF
;LA25F   .he FF ; DB FF
LA25F	equ LA25E+1



;LA260   DB 80

;LA260   .he 80 ; DB 80
LA260	equ LA25F+1

;LA261   DB 00

;LA261   .he 00 ; DB 00
LA261	equ LA260+1

;LA262   DB FF

;BanditId   .he FF ; DB FF
BanditId	equ LA261+1

;LA263   DB FE
;LA263   .he FE ; DB FE
LA263	equ BanditId+1


;LA264   DB 80
;LA264   .he 80 ; DB 80
LA264	equ LA263+1



;LA265   DB 00
;LA265   .he 00 ; DB 00
no_of_lives	equ LA264+1


;LA266   DB 5F

;LA266   .he 5F ; DB 5F
LA266	equ no_of_lives+1


;LA267   DB FF

;LA267   .he FF ; DB FF
LA267	equ LA266+1

;LA268   DB 80
;LA268   .he 80 ; DB 80
LA268	equ LA267+1



;LA269   DB 00

;LA269   .he 00 ; DB 00
game_on	 equ LA268+1


;LA26A   DB 7F,FF,00,00,7F,FF,00,00
;A272    DB 00,00,00,00

;LA26A   .he 7F,FF,00,00,7F,FF,00,00 ; DB 7F,FF,00,00,7F,FF,00,00
;        .he 00,00,00,00 ; DB 00,00,00,00
LA26A	equ game_on+1


;LA276   DB 00,00,00,00,00
;LA276   .he 00,00,00,00,00 ; DB 00,00,00,00,00
LA276	equ LA26A+12

	ert (LA276+5) != (LA207+$A27B-$A207)
gf_free_zp	equ LA276+5


;LA27B   DB 00

LA27B   .he 00 ; DB 00

;LA27C   DB 00

LA27C   .he 00 ; DB 00

;LA27D   DB 03

LA27D   .he 03 ; DB 03

;LA27E   DB C0

LA27E   .he C0 ; DB C0

;LA27F   DB 00,00,03,F0,00,00,00,F0
;A287    DB E3,E0,01,08

LA27F   .he 00,00,03,F0,00,00,00,F0 ; DB 00,00,03,F0,00,00,00,F0
        .he E3,E0;,01,08 ; DB E3,E0,01,08

LA289	.he 01,08 ; pointer stored here
		
;LA28B   DB FD,E0,01,F8,FE,C0,01,78
;A293    DB 7F,00,00,84,B8,00,00,F0
;A29B    DB 06,00,01,F0,1F,00,01,F8
;A2A3    DB 3D,00,01,B8,3F,00,00,FC ; =...?...
;A2AB    DB 7F,80,00,FC,7F,80,00,FF
;A2B3    DB FE,80,00,BF,FF,80,00,FF

LA28B   .he FD,E0,01,F8,FE,C0,01,78 ; DB FD,E0,01,F8,FE,C0,01,78
        .he 7F,00,00,84,B8,00;,00,F0 ; DB 7F,00,00,84,B8,00,00,F0
LA299	.he 00,F0 ; pointer stored here		
        .he 06,00,01,F0,1F,00,01,F8 ; DB 06,00,01,F0,1F,00,01,F8
        .he 3D,00,01,B8,3F,00;,00,FC ; DB 3D,00,01,B8,3F,00,00,FC
LA2A9	.he 00,FC ; pointer stored here
        .he 7F,80,00,FC,7F,80,00,FF ; DB 7F,80,00,FC,7F,80,00,FF
        .he FE,80,00,BF,FF,80,00,FF ; DB FE,80,00,BF,FF,80,00,FF

;LA2BB   DB FF,80,00,FF,FF,80,00,FF
;A2C3    DB FE,80,00,5F,FF,80,00,7F

LA2BB   .he FF,80,00,FF,FF,80,00,FF ; DB FF,80,00,FF,FF,80,00,FF
        .he FE,80,00,5F,FF,80;,00,7F ; DB FE,80,00,5F,FF,80,00,7F

LA2C9	.he 00,7F ; pointer stored here
		
;LA2CB   DB FF,00,00,7F,FF,00,00,00
;A2D3    DB 00,00,00,7E,7E,00,01,FF

LA2CB   .he FF,00,00,7F,FF,00,00,00 ; DB FF,00,00,7F,FF,00,00,00
        .he 00,00,00,7E,7E,00;,01,FF ; DB 00,00,00,7E,7E,00,01,FF

LA2D9	.he 01,FF ; pointer stored here

;LA2DB   DB FF,80,03,FF,FF,C0,03,FF
;A2E3    DB FF,C0,03,FF,FF,C0,03,FF

LA2DB   .he FF,80,03,FF,FF,C0,03,FF ; DB FF,80,03,FF,FF,C0,03,FF
        .he FF,C0,03,FF,FF,C0;,03,FF ; DB FF,C0,03,FF,FF,C0,03,FF
LA2E9	.he 03,FF ; pointer stored here

;LA2EB   DB FF,C0,03,FF,FF,C0,03,FF
;A2F3    DB FF,C0,03,FF,FF,C0,01,3F

LA2EB   .he FF,C0,03,FF,FF,C0,03,FF ; DB FF,C0,03,FF,FF,C0,03,FF
        .he FF,C0,03,FF,FF,C0;,01,3F ; DB FF,C0,03,FF,FF,C0,01,3F

LA2F9	.he 01,3F ; pointer stored here
;LA2FB   DB FC,80,01,3E,7C,80,01,FE
;A303    DB 7F,80,01,FE,7F,00,00,FE

LA2FB   .he FC,80,01,3E,7C,80,01,FE ; DB FC,80,01,3E,7C,80,01,FE
        .he 7F,80,01,FE,7F,00;,00,FE ; DB 7F,80,01,FE,7F,00,00,FE
LA309	.he 00,FE

;LA30B   DB 7F,00,00,FE,7F,00,00,9E
;A313    DB 79,00,00,9E,79,00,00,7E
;A31B    DB 7E,00,00,7E,7E,00,00,3E
;A323    DB 7C,00,00,3E,7C,00,00,2E ; ...>....
;A32B    DB 74,00,00,3E,7C,00,00,00
;A333    DB 00,00,00,7E,5C,00,00,BE

LA30B   .he 7F,00,00,FE,7F,00,00,9E ; DB 7F,00,00,FE,7F,00,00,9E
        .he 79,00,00,9E,79,00;,00,7E ; DB 79,00,00,9E,79,00,00,7E
LA319	.he 00,7E ; pointer stored here
LA31B   .he 7E,00,00,7E,7E,00,00,3E ; DB 7E,00,00,7E,7E,00,00,3E
        .he 7C,00,00,3E,7C,00;,00,2E ; DB 7C,00,00,3E,7C,00,00,2E
LA329	.he 00,2E ; pointer stored here
LA32B   .he 74,00,00,3E,7C,00,00,00 ; DB 74,00,00,3E,7C,00,00,00
        .he 00,00,00,7E,5C,00;,00,BE ; DB 00,00,00,7E,5C,00,00,BE
LA339	.he 00,BE ; pointer stored here
;LA33B   DB 5D,00,17,BE,5D,F8,2F,BE ; ]...]./.
;A343    DB 5D,FC,2F,80,01,FC,00,3E ; ]./....>

LA33B   .he 5D,00,17,BE,5D,F8,2F,BE ; DB 5D,00,17,BE,5D,F8,2F,BE
        .he 5D,FC,2F,80,01,FC;,00,3E ; DB 5D,FC,2F,80,01,FC,00,3E
LA349	.he 00,3E

;LA34B   DB 5C,00,3F,9E,59,FC,00,00 ; \.?.Y...
;A353    DB 00,00,00,7E,7E,00,01,FF

LA34B   .he 5C,00,3F,9E,59,FC,00,00 ; DB 5C,00,3F,9E,59,FC,00,00
        .he 00,00,00,7E,7E,00;,01,FF ; DB 00,00,00,7E,7E,00,01,FF
LA359	.he 01,FF
;LA35B   DB FF,80,03,FF,FF,C0,03,FF
;A363    DB FF,C0,03,FF,FF,C0,03,FF

LA35B   .he FF,80,03,FF,FF,C0,03,FF ; DB FF,80,03,FF,FF,C0,03,FF
        .he FF,C0,03,FF,FF,C0;,03,FF ; DB FF,C0,03,FF,FF,C0,03,FF
		
LA369	.he 03,FF ; pointer copied here

;LA36B   LD SP,L5E00
;A36E    LD A,(L5C79)
;A371    CP 56
;A373    RET NZ
;A374    LD HL,LA207
;A377    LD BC,L0164
;A37A    JR @@1


; start
LA36B 

		; LD SP,L5E00
        ldx #$ff
        txs
        ;lda L5C79 ; LD A,(L5C79) ; 5C79 is Spectrum timer. Copy protection?
        ;cmp #$56 ; CP 56
        ;beq *+3 ; RET NZ
        ;rts
        ;lda #<LA207 ; LD HL,LA207
        ;sta z80_l
        ;lda #>LA207
        ;sta z80_h
        ;lda #<L0164 ; LD BC,L0164
        ;sta z80_c
        ;lda #>L0164
        ;sta z80_b
		lda #$00
		ldx #$02
@		
		sta LA207,x
		inx
		cpx #$36
		bne @-

;LA37C   LD HL,LA23C
;A37F    LD BC,L012F
;@@1     CALL LD6DA
;A385    CALL LD4F6
;A388    LD A,C3
;A38A    LD (LA224),A 
;A38D    XOR A
;A38E    OUT A,(FE)
;A390    CALL LAB75
;A393    LD A,(LA21C)
;A396    OR 08
;A398    LD (LA21C),A
;A39B    CALL LA4EA
;A39E    CALL LA6B3
;A3A1    CALL LD0B0
;A3A4    LD A,01
;A3A6    LD (LA240),A
;A3A9    LD A,(LA21C)
;A3AC    BIT 0,A
;A3AE    CALL NZ,LA6C7
;LA3B1   LD A,(LA268)
;A3B4    LD E,A
;A3B5    CALL LD2F4
;@@2     XOR A
;A3B9    LD (LA244),A
;A3BC    LD SP,L5E00 
;A3BF    CALL LC03E
;A3C2    LD IX,LA27B
;@@3     LD A,(IX+00)
;A3C9    LD BC,LA410
;A3CC    CALL LC755
;A3CF    CALL LC0C2
;A3D2    LD BC,L0010
;A3D5    ADD IX,BC
;A3D7    PUSH IX
;A3D9    POP HL
;A3DA    LD BC,LA36B 
;A3DD    AND A
;A3DE    SBC HL,BC
;A3E0    JR C,@@3
;A3E2    CALL LC0BB
;A3E5    CALL LB859
;A3E8    CALL LAB16
;A3EB    CALL LC0E7
;A3EE    CALL LCAFC
;A3F1    CALL LD0AD
;A3F4    CALL LAEA7
;A3F7    CALL LA7D8
;A3FA    CALL LB2E7
;A3FD    CALL LB3BB
;A400    CALL LD1FF
;A403    LD A,(LA266)
;A406    LD C,A
;A407    LD A,(LA244)
;A40A    OR C
;A40B    JP Z,LC7C0
;A40E    JR @@2

; game start
LA37C   ;lda #<LA23C ; LD HL,LA23C
        ;sta z80_l
        ;lda #>LA23C
        ;sta z80_h
        ;lda #<L012F ; LD BC,L012F
        ;sta z80_c
        ;lda #>L012F
        ;sta z80_b
		ldx #$35
@@1     ;jsr LD6DA ; CALL LD6DA
		lda #$00
@@1_loop
		sta LA207,x
		inx
		cpx #$74
		bne @@1_loop
		tax
@@1_loop_2		
		sta LA27B,x
		inx
		cpx #$f0
		bne @@1_loop_2

		;jsr old_clear_part_2 ; CALL LD6DA
		
		; rot table generation
		;jsr LD4F6 ; CALL LD4F6
        
		;lda #$C3 ; LD A,C3
		lda #$4c ; $4c is jmp opcode
        sta LA224 ; LD (LA224),A
        lda #$00 ; XOR A
        ;jsr out_fe ; OUT A,(FE)
        		
		;display menu
		jsr draw_main_menu ; CALL LAB75
				
		;game type select
        lda game_select_type ; LD A,(LA21C)
        ora #$08 ; OR 08
        sta game_select_type ; LD (LA21C),A
		
		
		; hi-score
        jsr LA4EA ; CALL LA4EA
		
		; start game
        jsr LA6B3 ; CALL LA6B3
		
        jsr LD0B0 ; CALL LD0B0
		
        lda #$01 ; LD A,01
        sta LA240 ; LD (LA240),A
        lda game_select_type ; LD A,(LA21C)
        bit _bitmem0 ; BIT 0,A
        beq *+5 ; CALL NZ,LA6C7
        
		; player number text
		jsr player_no_start_txt
		
LA3B1   
	
		lda LA268 ; LD A,(LA268)
        sta z80_e ; LD E,A
				
		; draw static graphics
        jsr draw_background_gfx ; CALL LD2F4
		
		; main game loop - sort of
@@2     
		lda #$00 ; XOR A
        sta LA244 ; LD (LA244),A
        ; LD SP,L5E00
        ldx #$ff ; reset stack
        txs
        jsr LC03E ; CALL LC03E
        lda #<LA27B ; LD IX,LA27B
        sta z80_ix
        lda #>LA27B
        sta z80_ix+1
@@3     ldy #$00 ; LD A,(IX+00)
        lda (z80_ix),y
        ;ldx #<LA410 ; LD BC,LA410
        ;stx z80_c
        ;ldx #>LA410
        ;stx z80_b
        ;jsr LC755 ; CALL LC755 ; uses A as parameter
		asl @
		tax
		lda LA410,x
		sta MainLoopJump+1
		lda LA410+1,x
		sta MainLoopJump+2
MainLoopJump
		jsr $ffff
	jsr LC0C2 ; CALL LC0C2
        
	;lda #<L0010 ; LD BC,L0010
        ;sta z80_c
        ;lda #>L0010
        ;sta z80_b
        ;jsr add_ix_bc ; ADD IX,BC
        ;lda z80_ix ; PUSH IX
        ;pha
        ;lda z80_ix+1
        ;pha
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;lda #<LA36B ; LD BC,LA36B
        ;sta z80_c
        ;lda #>LA36B
        ;sta z80_b        
        ;sec ; AND  A
        ;jsr sbc_hl_bc ; SBC HL,BC
		lda #$10
		clc
		adc z80_ix
		sta z80_ix
		scc:inc z80_ix+1
		cmp #<LA36B
		lda z80_ix+1
		sbc #>LA36B
        jcc @@3 ; JR C,@@3
		
		; set-up telegram messages
        jsr telegram_messages ; CALL LC0BB
        
		jsr LB859 ; CALL LB859
        
		jsr LAB16 ; CALL LAB16
        
		jsr LC0E7 ; CALL LC0E7
        
		jsr LCAFC ; CALL LCAFC
				
		jsr BlitBufferToScreenAndClearBuffer ; CALL LD0AD
		
        jsr LAEA7 ; CALL LAEA7
        
		; print telegram messages to screen
		jsr print_telegram_messages ; CALL LA7D8
        
		jsr LB2E7 ; CALL LB2E7
		
        jsr LB3BB ; CALL LB3BB
        
		jsr pause_key ; CALL LD1FF
        lda LA266 ; LD A,(LA266)
        ;sta z80_c ; LD C,A
        ;lda LA244 ; LD A,(LA244)
        ;ora z80_c ; OR C
		ora LA244
        jeq LC7C0 ; JP Z,LC7C0
        jmp @@2 ; JR @@2

;LA410   DW LA446,LC929,LCABF,LBCBF
;A418    DW LC862,LC7AF,LB717,LC784
;A420    DW LC7A6,LC75B,LB3D8,LB345
;A428    DW LB9EB,LBACA,LB8DB,LB966
;A430    DW LB9CA,LBACD,LBAFB,LAA7D
;A438    DW LA9BD,LC909,LB3D8,LA8D3
;A440    DW LA4C7,LA447,LA450

LA410   .wo LA446,LC929,LCABF,LBCBF ; DW LA446,LC929,LCABF,LBCBF
        .wo LC862,LC7AF,LB717,LC784 ; DW LC862,LC7AF,LB717,LC784
        .wo LC7A6,LC75B,LB3D8,LB345 ; DW LC7A6,LC75B,LB3D8,LB345
        .wo LB9EB,LBACA,LB8DB,LB966 ; DW LB9EB,LBACA,LB8DB,LB966
        .wo LB9CA,LBACD,LBAFB,LAA7D ; DW LB9CA,LBACD,LBAFB,LAA7D
        .wo LA9BD,LC909,LB3D8,LA8D3 ; DW LA9BD,LC909,LB3D8,LA8D3
        .wo LA4C7,LA447,LA450 ; DW LA4C7,LA447,LA450

;A446    RET

LA446    rts ; RET

;A447    DEC (IX+0C)
;A44A    RET NZ
;A44B    LD (IX+00),1A
;A44F    RET

LA447   ldy #$0C ; DEC (IX+0C)
        lda (z80_ix),y
        sec
        sbc #$01
        sta (z80_ix),y
        beq *+3 ; RET NZ
        rts
        ldy #$00 ; LD (IX+00),1A
        lda #$1A
        sta (z80_ix),y
        rts ; RET

;A450    LD A,(IX+0D)
;A453    ADD A,04
;A455    LD (IX+0D),A
;A458    CALL LAF4D
;A45B    LD A,(IX+0D)
;A45E    CP 1C
;A460    RET C
;A461    LD (IX+00),01
;A465    LD (IX+0D),00
;A469    LD A,10
;A46B    LD (LA208),A
;A46E    LD HL,LA228
;A471    LD (IX+0E),L
;A474    LD (IX+0F),H
;A477    LD C,00
;A479    JP LC945


LA450
		inc generate_man

		ldy #$0D ; LD A,(IX+0D)
        lda (z80_ix),y
        clc ; ADD A,04
        adc #$04
        ;ldy #$0D ; LD (IX+0D),A
        sta (z80_ix),y
		
		; generate man
        	
		jsr LAF4D ; CALL LAF4D
        
		ldy #$0D ; LD A,(IX+0D)
        lda (z80_ix),y
        cmp #$1C ; CP 1C
        bcs *+3 ; RET C
        rts
        ldy #$00 ; LD (IX+00),01
        lda #$01
        sta (z80_ix),y
        ldy #$0D ; LD (IX+0D),00
        lda #$00
        sta (z80_ix),y
        lda #$10 ; LD A,10
        sta LA208 ; LD (LA208),A
        
        ;lda #<LA228 ; LD HL,LA228
        ;sta z80_l
        ;lda #>LA228

        ;sta z80_h
        ldy #$0E ; LD (IX+0E),L
        ;lda z80_l
		lda #<LA228
        sta (z80_ix),y
        ;ldy #$0F ; LD (IX+0F),H
		iny
        ;lda z80_h
		lda #>LA228
        sta (z80_ix),y
        lda #$00 ; LD C,00
        sta z80_c
        jmp LC945 ; JP LC945

;LA47C   LD HL,LA259
;A47F    LD A,(HL)
;A480    INC HL
;A481    OR (HL)
;A482    RET NZ
;A483    LD DE,LA2DB
;A486    LD A,(DE)
;A487    AND A
;A488    RET NZ
;A489    PUSH DE
;A48A    POP IY
;A48C    LD HL,LA4B3
;A48F    LD BC,L0010
;A492    LDIR
;A494    LD B,01
;A496    CALL LB6CB
;A499    RET NZ
;A49A    LD A,(LA218)
;A49D    AND 30
;A49F    ADD A,80
;A4A1    LD (IY+01),A
;A4A4    LD A,(LA219)
;A4A7    AND 30
;A4A9    ADD A,80
;A4AB    LD (IY+03),A
;A4AE    LD (IY+00),18
;A4B2    RET

LA47C   ;lda #<LA259 ; LD HL,LA259
        ;sta z80_l
        ;lda #>LA259
        ;sta z80_h
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
		lda LA259
		ora LA259+1
        beq *+3 ; RET NZ
        rts
        lda #<LA2DB ; LD DE,LA2DB
        sta z80_e
        lda #>LA2DB
        sta z80_d
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        ; AND  A
        beq *+3 ; RET NZ
        rts
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		lda z80_e
		sta z80_iy

		lda z80_d


		sta z80_iy+1


        lda #<LA4B3 ; LD HL,LA4B3
        sta z80_l
        lda #>LA4B3
        sta z80_h
        lda #<L0010 ; LD BC,L0010
        sta z80_c
        lda #>L0010
        sta z80_b
        jsr ldir ; LDIR
        lda #$01 ; LD B,01
        sta z80_b
        jsr LB6CB ; CALL LB6CB
        beq *+3 ; RET NZ
        rts
        lda LA218 ; LD A,(LA218)
        and #$30 ; AND 30
        clc ; ADD A,80
        adc #$80
        ldy #$01 ; LD (IY+01),A
        sta (z80_iy),y
        lda LA219 ; LD A,(LA219)
        and #$30 ; AND 30
        clc ; ADD A,80
        adc #$80
        ldy #$03 ; LD (IY+03),A
        sta (z80_iy),y
        ldy #$00 ; LD (IY+00),18
        lda #$18
        sta (z80_iy),y
        rts ; RET

;LA4B3   DB 00,00,00,00,00,00,00,00
;A4BB    DB 10,10,00,00,00,00

LA4B3   .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 10,10,00,00,00,00 ; DB 10,10,00,00,00,00

;LA4C1   DW LA4C3

LA4C1   .wo LA4C3 ; DW LA4C3

;LA4C3   DB F8,04,29,80

LA4C3   .he F8,04,29,80 ; DB F8,04,29,80

;A4C7    LD C,02
;A4C9    CALL LB80E
;A4CC    JP NC,LC7AA
;A4CF    CALL LB62F
;A4D2    RET NC
;A4D3    LD BC,L0100
;A4D6    CALL LD34D
;A4D9    CALL LD389
;A4DC    LD A,08
;A4DE    LD (LA23C),A
;A4E1    LD HL,LAEC5
;A4E4    LD (LA23D),HL
;A4E7    JP LC7AA

LA4C7   lda #$02 ; LD C,02
        sta z80_c
        jsr LB80E ; CALL LB80E
        jcs LC7AA ; JP NC,LC7AA; 
        jsr LB62F ; CALL LB62F
        bcc *+3 ; RET NC
        rts; 
        lda #<L0100 ; LD BC,L0100
        sta z80_c
        lda #>L0100
        sta z80_b
        jsr LD34D ; CALL LD34D
        jsr LD389 ; CALL LD389
		
		; pick up money bag
        lda #$08 ; LD A,08
        sta LA23C ; LD (LA23C),A
       
		
		;lda #<LAEC5 ; LD HL,LAEC5
        ;sta z80_l
        ;lda #>LAEC5
        ;sta z80_h
        ;lda z80_l ; LD (LA23D),HL
        ;sta LA23D
        ;lda z80_h
        ;sta LA23D+1
		lda #<LAEC5
		sta LA23D

		lda #>LAEC5




		sta LA23D+1
        jmp LC7AA ; JP LC7AA

;LA4EA   LD DE,LA5D0
;A4ED    LD HL,LA870
;LA4F0   LD B,03
;@@4     LD A,(DE)
;A4F3    RRCA
;A4F4    RRCA
;A4F5    RRCA
;A4F6    RRCA
;A4F7    AND 0F
;A4F9    ADD A,30
;A4FB    LD (HL),A
;A4FC    INC HL
;A4FD    LD A,(DE)
;A4FE    AND 0F
;A500    ADD A,30
;A502    LD (HL),A
;A503    INC DE
;A504    INC HL
;A505    DJNZ @@4
;A507    RET

LA4EA
		;hi-score
		lda #<LA5D0 ; LD DE,LA5D0
        sta z80_e
        lda #>LA5D0
        sta z80_d
        
		lda #<LA870 ; LD HL,LA870
        sta z80_l
        lda #>LA870
        sta z80_h
		
LA4F0   lda #$03 ; LD B,03
        sta z80_b
@@4     ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$0F ; AND 0F
        clc ; ADD A,30
        adc #$30
        ldy #$00 ; LD (HL),A
        sta (z80_hl),y
				
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        and #$0F ; AND 0F
        clc ; ADD A,30
        adc #$30
        ldy #$00 ; LD (HL),A
        sta (z80_hl),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        dec z80_b ; DJNZ @@4
        jne @@4
        rts ; RET

;LA508   CALL LA6E8
;LA50B   LD B,03
;A50D    LD DE,LA259
;A510    LD HL,LA26A
;@@5     LD A,(DE)
;A514    CP (HL)
;A515    INC DE
;A516    INC HL
;A517    JR C,@@6
;A519    JR NZ,@@10
;A51B    DJNZ @@5
;@@6     LD C,01
;A51F    LD DE,LA26A
;@@7     PUSH DE
;A523    LD HL,LA5D0
;A526    LD B,03
;@@8     LD A,(DE)
;A529    CP (HL)
;A52A    INC DE
;A52B    INC HL
;A52C    JR C,@@9
;A52E    JR NZ,@@11
;A530    DJNZ @@8
;@@9     POP DE
;A533    JP LA37C

LA508   jsr LA6E8 ; CALL LA6E8
LA50B   lda #$03 ; LD B,03
        sta z80_b
        lda #<LA259 ; LD DE,LA259
        sta z80_e
        lda #>LA259
        sta z80_d
        lda #<LA26A ; LD HL,LA26A
        sta z80_l
        lda #>LA26A
        sta z80_h
@@5     ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        ldy #$00 ; CP (HL)
        cmp (z80_hl),y
        php
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        plp
        jcc @@6 ; JR C,@@6
        jne @@10 ; JR NZ,@@10
        dec z80_b ; DJNZ @@5
        jne @@5
@@6     lda #$01 ; LD C,01
        sta z80_c
        lda #<LA26A ; LD DE,LA26A
        sta z80_e
        lda #>LA26A
        sta z80_d
@@7     lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
		
		;hi-score
        lda #<LA5D0 ; LD HL,LA5D0
        sta z80_l
        lda #>LA5D0
        sta z80_h
        
		lda #$03 ; LD B,03
        sta z80_b
@@8     ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        ldy #$00 ; CP (HL)
        cmp (z80_hl),y
        php
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        plp
        jcc @@9 
        jne @@11
        dec z80_b ; DJNZ @@8
        jne @@8
@@9     pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        jmp LA37C ; JP LA37C

;@@10    LD C,00
;A538    LD DE,LA259
;A53B    JR @@7

@@10    lda #$00 ; LD C,00
        sta z80_c
        lda #<LA259 ; LD DE,LA259
        sta z80_e
        lda #>LA259
        sta z80_d
        jmp @@7 ; JR @@7

;@@11    LD A,C
;A53E    ADD A,31
;A540    LD (LA5AE),A
;A543    LD E,00
;A545    CALL LD6CC
;A548    CALL LD6D4
;A54B    POP DE
;A54C    LD HL,LA5D0
;A54F    LD B,03
;A551    CALL LA6F0
;A554    LD DE,LA5D0
;A557    LD HL,LA5C9
;A55A    CALL LA4F0
;A55D    LD HL,L4087
;A560    LD DE,LA59B
;A563    CALL LAA98
;A566    LD HL,L40E8
;A569    LD DE,LA5A6
;A56C    CALL LAA98
;A56F    LD HL,L4846
;A572    LD DE,LA5B0
;A575    CALL LAA98
;A578    LD HL,L48A8
;A57B    LD DE,LA5BC
;A57E    CALL LAA98
;A581    LD HL,L5048
;A584    LD DE,LA5C6
;A587    CALL LAA98
;A58A    LD DE,LB1DE
;A58D    CALL LAF8D
;A590    LD B,04
;A592    LD HL,L0000
;A595    CALL LAE80
;A598    JP LA37C

; print hi-score text screen
@@11    lda z80_c ; LD A,C
        clc ; ADD A,31
        adc #$31
        sta LA5AE ; LD (LA5AE),A
        lda #$00 ; LD E,00
        sta z80_e
				
        ;jsr old_clear_colours ; CALL LD6CC
        ;jsr old_screen_clear ; CALL LD6D4
        ;lda #00
		jsr c64clearcols
		jsr c64clearbitmap
		
		pla ; POP DE
        sta z80_d
        pla
        sta z80_e
		
		; hi-score
        lda #<LA5D0 ; LD HL,LA5D0
        sta z80_l
        lda #>LA5D0
        sta z80_h
		
        lda #$03 ; LD B,03
        sta z80_b
        jsr LA6F0 ; CALL LA6F0
		
		; hi-score
        lda #<LA5D0 ; LD DE,LA5D0
        sta z80_e
        lda #>LA5D0
        sta z80_d
        
		lda #<LA5C9 ; LD HL,LA5C9
        sta z80_l
        lda #>LA5C9
        sta z80_h
        jsr LA4F0 ; CALL LA4F0
        
;		; screen poss
;		lda #<L4087 ; LD HL,L4087
;        sta z80_l
;        lda #>L4087
;        sta z80_h
;        
;		; well done text
;		lda #<LA59B ; LD DE,LA59B
;        sta z80_e
;        lda #>LA59B
;        sta z80_d
;        
;		; print text to screen
;		jsr LAA98 ; CALL LAA98
;        
;		; screen poss
;		lda #<L40E8 ; LD HL,L40E8
;        sta z80_l
;        lda #>L40E8
;        sta z80_h
;		
;		; player 1/2
;        lda #<LA5A6 ; LD DE,LA5A6
;        sta z80_e
;        lda #>LA5A6
;        sta z80_d
;		
;        ; print text to screen
;		jsr LAA98 ; CALL LAA98
;        
;		; screen poss
;		lda #<L4846 ; LD HL,L4846
;        sta z80_l
;        lda #>L4846
;        sta z80_h
;		
;		; todays
;        lda #<LA5B0 ; LD DE,LA5B0
;        sta z80_e
;        lda #>LA5B0
;        sta z80_d
;		
;        ; print text to screen
;		jsr LAA98 ; CALL LAA98
;        
;		; screen poss
;		lda #<L48A8 ; LD HL,L48A8
;        sta z80_l
;        lda #>L48A8
;        sta z80_h
;		
;		; score
;        lda #<LA5BC ; LD DE,LA5BC
;        sta z80_e
;        lda #>LA5BC
;        sta z80_d
;		
;        ; print text to screen
;		jsr LAA98 ; CALL LAA98
;        
;		; screen poss
;		lda #<L5048 ; LD HL,L5048
;        sta z80_l
;        lda #>L5048
;        sta z80_h
;		
;		; $
;        lda #<LA5C6 ; LD DE,LA5C6
;        sta z80_e
;        lda #>LA5C6
;        sta z80_d
;		
;        ; print text to screen
;		jsr LAA98 ; CALL LAA98
        
		; well done text
		lda #01
		sta alpha		
		
        lda #<$c558
        sta dest_lo
        lda #>$c558
        sta dest_hi

        lda #<$c560
        sta source_lo
        lda #>$c560
		sta source_hi

		ldx #00
@
		ldy welldonealpha,x
		jsr font_expand
		
		ldx count_temp_03
		stx count_temp_03
		
		inx
		cpx #09
		bne @-

		; player no text

        lda #<$c920
        sta dest_lo
        lda #>$c920
        sta dest_hi

        lda #<$c928
        sta source_lo
        lda #>$c928
		sta source_hi		
		
		ldx #04
@
		ldy playeralpha,x
		jsr font_expand
		
		ldx count_temp_03
		stx count_temp_03
		
		inx
		cpx #11
		bne @-

		; set to 1 or 2 char based on player number (0 or 1)		
		
		lda #00
		sta alpha		
		
		; get player no ($31 or $32) then reduce it to 0 or 1
		lda LA5AE
		sec
		sbc #49		
		
		; * by 8 to get font poss then stick it in Y
		asl
		asl
		asl
		tay
		jsr font_expand			

		; todays top text
		lda #01
		sta alpha		
		
        lda #<$ccd0
        sta dest_lo
        lda #>$ccd0
        sta dest_hi

        lda #<$ccd8
        sta source_lo
        lda #>$ccd8
		sta source_hi

		ldx #00
@
		ldy todaystopalpha,x
		jsr font_expand
		
		ldx count_temp_03
		stx count_temp_03
		
		inx
		cpx #10
		bne @-		

		; score is text
		lda #<$d0a0
        sta dest_lo
        lda #>$d0a0
        sta dest_hi

        lda #<$d0a8
        sta source_lo
        lda #>$d0a8
		sta source_hi

		ldx #00
@
		ldy scoreisalpha,x
		jsr font_expand
		
		ldx count_temp_03
		stx count_temp_03
		
		inx
		cpx #08
		bne @-

		; $
		lda #02
		sta alpha
		
		lda #<$d6e0
        sta dest_lo
        lda #>$d6e0
        sta dest_hi

        lda #<$d6e8
        sta source_lo
        lda #>$d6e8
		sta source_hi
		
		ldy #80
		jsr font_expand
		ldy #96
		jsr font_expand

		; convert score numbers then print
		ldy #00
@		
		lda LA5C9,y
		sec
		sbc #48
		asl
		asl
		asl
		sta hiscorecon,y
		
		iny
		cpy #06
		bne @-

		ldx #00
@
		ldy hiscorecon,x
		jsr font_expand
		
		ldx count_temp_03
		stx count_temp_03
		
		inx
		cpx #06
		bne @-
		
		; colour
		lda #$a0
		sta dest_lo
		lda #$b8
		sta dest_hi
		lda #$04
		sta colourcode
		lda #80
		sta blitsize
		jsr colourblit			

		lda #$18
		sta dest_lo
		lda #$b9
		sta dest_hi
		lda #$05
		sta colourcode
		jsr colourblit	

		lda #$90
		sta dest_lo
		lda #$b9
		sta dest_hi
		lda #$07
		sta colourcode
		jsr colourblit
		
		lda #$08
		sta dest_lo
		lda #$ba
		sta dest_hi
		lda #$03
		sta colourcode
		jsr colourblit

		lda #$d0
		sta dest_lo
		lda #$ba
		sta dest_hi
		lda #$0f
		sta colourcode
		jsr colourblit		
		
		;lda #<LB1DE ; LD DE,LB1DE
        ;sta z80_e
        ;lda #>LB1DE
        ;sta z80_d
        ;jsr PlayAudio ; CALL LAF8D
 
 		; play hi-score music
		;lda #04
		;jsr music_play

	.if TED_SOUND == 1
		lda #04
		jsr ted_music_play
		lda #00 ; LD B,04
		sta z80_b
	.else
		lda #00
		sta sound_e
		sta z80_b
		lda #04
		jsr music_play
		
	.endif			
 		
        lda #<L0000 ; LD HL,L0000
        sta z80_l
        lda #>L0000
        sta z80_h
				
		;pause
        ;jsr LAE80 ; CALL LAE80

	; turn music off	
	.if TED_SOUND == 1
		;jsr LAE80
		
		lda #54
		sta mpwait
		jsr music_pause
		
		lda #05
		jsr ted_music_play
	.else
		lda #86
		sta mpwait
		jsr music_pause
		
		; turn music off
		lda #06
		jsr music_play
		
		lda #02
		sta mpwait
		jsr music_pause_no
		
	.endif	
		
        
		jmp LA37C ; JP LA37C

;LA59B   DB 43,57,45,4C,4C,20,44,4F ; CWELL DO
;A5A3    DB 4E,45,00

;LA59B   .he 43,57,45,4C,4C,20,44,4F ; DB 43,57,45,4C,4C,20,44,4F
;        .he 4E,45,00 ; DB 4E,45,00

;LA5A6   DB 44,50,4C,41,59,45,52,20 ; DPLAYER 

;LA5A6   .he 44,50,4C,41,59,45,52,20 ; DB 44,50,4C,41,59,45,52,20

;LA5AE   DB 20,00

LA5AE   .he 20,00 ; DB 20,00

;LA5B0   DB 46,54,4F,44,41,59,53,20 ; FTODAYS 
;A5B8    DB 54,4F,50,00 ; TOP.

;LA5B0   .he 46,54,4F,44,41,59,53,20 ; DB 46,54,4F,44,41,59,53,20
;        .he 54,4F,50,00 ; DB 54,4F,50,00

;LA5BC   DB 45,53,43,4F,52,45,20,49 ; ESCORE I
;A5C4    DB 53,00

;LA5BC   .he 45,53,43,4F,52,45,20,49 ; DB 45,53,43,4F,52,45,20,49
;        .he 53,00 ; DB 53,00

;LA5C6   DB 47,5E,20

;LA5C6   .he 47,5E,20 ; DB 47,5E,20

;LA5C9   DB 20,20,20,20,20,20,00 ;       .

LA5C9   .he 20,20,20,20,20,20,00 ; DB 20,20,20,20,20,20,00

;LA5D0   DB 01,00,00

; hi-score
LA5D0   .he 00,10,00 ; DB 01,00,00

;LA5D3   LD HL,(LA216)
;A5D6    LD A,L
;A5D7    ADD A,43
;A5D9    RET NZ
;A5DA    LD A,(LA218)
;A5DD    AND 03
;A5DF    JR Z,@@20
;A5E1    DEC A
;A5E2    JR Z,@@21
;A5E4    CALL LA64D
;A5E7    RET NZ
;A5E8    XOR A
;A5E9    LD (LA82E),A
;A5EC    LD HL,LA261
;A5EF    LD DE,LA83B
;A5F2    EXX
;A5F3    LD HL,LA65D
;@@12    LD A,(LA262)
;A5F9    CP 06
;A5FB    JR NC,@@14
;A5FD    LD A,02
;A5FF    JR @@17

LA5D3   lda LA216 ; LD HL,(LA216)
        sta z80_l
        lda LA216+1
        sta z80_h
        lda z80_l ; LD A,L
        clc ; ADD A,43
        adc #$43
        beq *+3 ; RET NZ
        rts
        lda LA218 ; LD A,(LA218)
        and #$03 ; AND 03
        jeq @@20 ; JR Z,@@20
        sec ; DEC A
        sbc #$01; 
        jeq @@21 ; JR Z,@@21
        jsr LA64D ; CALL LA64D
        beq *+3 ; RET NZ
        rts
        lda #$00 ; XOR A
        sta LA82E ; LD (LA82E),A
        lda #<LA261 ; LD HL,LA261
        sta z80_l
        lda #>LA261
        sta z80_h
        lda #<LA83B ; LD DE,LA83B
        sta z80_e
        lda #>LA83B
        sta z80_d
        jsr exx ; EXX
        lda #<LA65D ; LD HL,LA65D
        sta z80_l
        lda #>LA65D
        sta z80_h
@@12    lda BanditId ; LD A,(LA262)
        cmp #$06 ; CP 06
        jcs @@14 ; JR NC,@@14
        lda #$02 ; LD A,02
        jmp @@17 ; JR @@17

;@@14    CP 0D
;A603    JR NC,@@15
;A605    LD A,04
;A607    JR @@17

@@14    cmp #$0D ; CP 0D; 
        jcs @@15 ; JR NC,@@15
        lda #$04 ; LD A,04
        jmp @@17 ; JR @@17

;@@15    LD A,08
;@@17    LD C,A
;A60C    LD A,(LA219)
;A60F    AND 0F
;@@18    CP C
;A612    JR C,@@19
;A614    SUB C
;A615    JR @@18

@@15    lda #$08 ; LD A,08
@@17    sta z80_c ; LD C,A
        lda LA219 ; LD A,(LA219)
        and #$0F ; AND 0F
@@18    cmp z80_c ; CP C
        jcc @@19 ; JR C,@@19
        sec ; SUB C
        sbc z80_c; 
        jmp @@18 ; JR @@18

;@@19    ADD A,A
;A618    LD E,A
;A619    LD D,00
;A61B    ADD HL,DE
;A61C    LD C,(HL)
;A61D    INC HL
;A61E    LD B,(HL)
;A61F    PUSH BC
;A620    EXX
;A621    POP BC
;A622    JP LA77B

@@19    asl @ ; ADD A,A; 
        sta z80_e ; LD E,A
        lda #$00 ; LD D,00
        sta z80_d
        jsr add_hl_de ; ADD HL,DE
        ldy #$00 ; LD C,(HL)
        lda (z80_hl),y
        sta z80_c
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD B,(HL)
        lda (z80_hl),y
        sta z80_b
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        jsr exx ; EXX
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
        jmp LA77B ; JP LA77B

;@@20    CALL LA64D
;A628    RET NZ
;A629    XOR A
;A62A    LD (LA852),A
;A62D    LD HL,LA25D
;A630    LD DE,LA85F
;A633    EXX
;A634    LD HL,LA67D
;A637    JR @@12

@@20    jsr LA64D ; CALL LA64D
        beq *+3 ; RET NZ
        rts
        lda #$00 ; XOR A
        sta LA852 ; LD (LA852),A
        lda #<LA25D ; LD HL,LA25D
        sta z80_l
        lda #>LA25D
        sta z80_h
        lda #<LA85F ; LD DE,LA85F
        sta z80_e
        lda #>LA85F
        sta z80_d
        jsr exx ; EXX
        lda #<LA67D ; LD HL,LA67D
        sta z80_l
        lda #>LA67D
        sta z80_h
        jmp @@12 ; JR @@12

;@@21    CALL LA64D
;A63C    RET NZ
;A63D    XOR A
;A63E    LD (LA840),A
;A641    LD HL,LA25F
;A644    LD DE,LA84D
;A647    EXX
;A648    LD HL,LA66D
;A64B    JR @@12

@@21    jsr LA64D ; CALL LA64D
        beq *+3 ; RET NZ
        rts
        lda #$00 ; XOR A
        sta LA840 ; LD (LA840),A
        lda #<LA25F ; LD HL,LA25F
        sta z80_l
        lda #>LA25F
        sta z80_h
        lda #<LA84D ; LD DE,LA84D
        sta z80_e
        lda #>LA84D
        sta z80_d
        jsr exx ; EXX
        lda #<LA66D ; LD HL,LA66D
        sta z80_l
        lda #>LA66D
        sta z80_h
        jmp @@12 ; JR @@12

;LA64D   LD HL,LA82E
;A650    LD DE,L0012
;A653    LD B,06
;@@22    LD A,(HL)
;A656    CP 0E
;A658    RET NZ
;A659    ADD HL,DE
;A65A    DJNZ @@22
;A65C    RET

LA64D   lda #<LA82E ; LD HL,LA82E
        sta z80_l
        lda #>LA82E
        sta z80_h
        lda #<L0012 ; LD DE,L0012
        sta z80_e
        lda #>L0012
        sta z80_d
        lda #$06 ; LD B,06
        sta z80_b
@@22    ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        cmp #$0E ; CP 0E
        beq *+3 ; RET NZ
        rts
        jsr add_hl_de ; ADD HL,DE
        dec z80_b ; DJNZ @@22
        jne @@22
        ; here zero flag should be set
        rts ; RET

;LA65D   DB 05,00,10,00,15,00,20,00
;A665    DB 25,00,50,00,75,00,00,01 ; P.....

LA65D   .he 05,00,10,00,15,00,20,00 ; DB 05,00,10,00,15,00,20,00
        .he 25,00,50,00,75,00,00,01 ; DB 25,00,50,00,75,00,00,01

;LA66D   DB 50,00,75,00,00,01,50,01 ; P.....P.
;A675    DB 50,02,50,03,00,05,00,10 ; P.P.....

LA66D   .he 50,00,75,00,00,01,50,01 ; DB 50,00,75,00,00,01,50,01
        .he 50,02,50,03,00,05,00,10 ; DB 50,02,50,03,00,05,00,10

;LA67D   DB 00,01,50,01,50,02,00,04 ; ..P.P...
;A685    DB 00,10,00,15,00,30,00,50 ; .....0.P

LA67D   .he 00,01,50,01,50,02,00,04 ; DB 00,01,50,01,50,02,00,04
        .he 00,10,00,15,00,30,00,50 ; DB 00,10,00,15,00,30,00,50

;LA68D   LD A,04
;A68F    LD (LA265),A
;A692    XOR A
;A693    LD (LA262),A
;A696    LD (LA263),A
;A699    LD BC,L0280
;A69C    CALL LD34D
;A69F    LD HL,L0114
;A6A2    LD (LA266),HL
;A6A5    LD A,46
;A6A7    LD (LA268),A
;A6AA    CALL LA76E
;A6AD    CALL LA7B6
;A6B0    JP LA7C9

; set-up
LA68D
 
		lda #$04 ; LD A,04
		sta no_of_lives ; LD (LA265),A
		
        lda START_LEVEL ; XOR A
        sta BanditId ; LD (LA262),A
        sta LA263 ; LD (LA263),A
        lda #<L0280 ; LD BC,L0280
        sta z80_c
        lda #>L0280
        sta z80_b
        jsr LD34D ; CALL LD34D

        ;lda #<L0114 ; LD HL,L0114
        ;sta z80_l
        ;lda #>L0114
        ;sta z80_h
        ;lda z80_l ; LD (LA266),HL
        ;sta LA266
        ;lda z80_h
        ;sta LA266+1
		lda #<L0114
		sta LA266

		lda #>L0114

		sta LA266+1
		
		; background colour yellow
        lda #$46 ; LD A,46
        sta LA268 ; LD (LA268),A
		
        jsr LA76E ; CALL LA76E
        jsr LA7B6 ; CALL LA7B6
        jmp LA7C9 ; JP LA7C9

;LA6B3   CALL LA68D
;A6B6    CALL LA6E8
;A6B9    CALL LA68D
;A6BC    LD A,(LA21C)
;A6BF    BIT 0,A
;A6C1    RET NZ
;A6C2    XOR A
;A6C3    LD (LA276),A
;A6C6    RET

LA6B3   jsr LA68D ; CALL LA68D
        jsr LA6E8 ; CALL LA6E8
        jsr LA68D ; CALL LA68D
        lda game_select_type ; LD A,(LA21C)
        bit _bitmem0 ; BIT 0,A
        beq *+3 ; RET NZ
        rts
        lda #$00 ; XOR A
        sta LA276 ; LD (LA276),A
        rts ; RET

;LA6C7   LD E,00
;A6C9    CALL LD6CC
;A6CC    CALL LD6D4
;A6CF    LD A,(LA23F)
;A6D2    ADD A,31
;A6D4    LD (LB7EC),A
;A6D7    LD DE,LB7E4
;A6DA    LD HL,L4868
;A6DD    CALL LAA98
;A6E0    LD B,02
;A6E2    LD HL,L0000
;A6E5    JP LAE80

;LA6C7 
player_no_start_txt  

		;lda game_on
		;beq @+
		
;		lda #$8c
;		sta source_lo
;		lda #$f2
;		sta source_hi		
		
;		jsr barrel_colour_copy_temp

;@
			
		lda #$00 ; LD E,00
        sta z80_e
		
        ;jsr old_clear_colours ; CALL LD6CC
		;jsr old_screen_clear ; CALL LD6D4
        
		;lda #00
		jsr c64clearcols        
		jsr c64clearbitmap
				
		;player 1/2
		
		;lda #142
		;sta spr_y
		;lda #120
		;sta spr_x0
		;lda #168
		;sta spr_x1
		;lda #232
		;sta spr_x2
		;lda #03
		;sta spr_col
		
		;jsr spritesastextdotcom
		
		;lda #$c0
		;sta dest_lo
		;lda #$de
		;sta dest_hi

		;lda #00
		;sta count_temp_02

        lda #<$ce20
        sta dest_lo
        lda #>$ce20
        sta dest_hi

        lda #<$ce28
        sta source_lo
        lda #>$ce28
		sta source_hi		
		
		jsr print_player_no
		
		
        ;clc ; ADD A,31
        ;adc #$31
			
        ;sta LB7EC ; LD (LB7EC),A
        ;lda #<LB7E4 ; LD DE,LB7E4
        ;sta z80_e
        ;lda #>LB7E4
        ;sta z80_d
		
		;screen poss
        ;lda #<L4868 ; LD HL,L4868
        ;sta z80_l
        ;lda #>L4868
        ;sta z80_h
		
        ;jsr LAA98 ; CALL LAA98
        
		lda #$02 ; LD B,02
        sta z80_b
        lda #<L0000 ; LD HL,L0000
        sta z80_l
        lda #>L0000
        sta z80_h

		;lda game_on
		;beq @+
		
;		lda #$8c
;		sta dest_lo
;		lda #$f2
;		sta dest_hi	
		
;		jsr barrel_colour_copy_screen
		
;		lda #03
;		sta border
		
;@
		
		;pause
        jmp LAE80 ; JP LAE80
		

;LA6E8   LD HL,LA259
;A6EB    LD DE,LA26A
;A6EE    LD B,11
;LA6F0   LD C,(HL)
;A6F1    LD A,(DE)
;A6F2    LD (HL),A
;A6F3    LD A,C
;A6F4    LD (DE),A
;A6F5    INC DE
;A6F6    INC HL
;A6F7    DJNZ LA6F0
;A6F9    RET

LA6E8   lda #<LA259 ; LD HL,LA259
        sta z80_l
        lda #>LA259
        sta z80_h
        lda #<LA26A ; LD DE,LA26A
        sta z80_e
        lda #>LA26A
        sta z80_d
        lda #$11 ; LD B,11
        sta z80_b
LA6F0   ldy #$00 ; LD C,(HL)
        lda (z80_hl),y
        sta z80_c
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        ldy #$00 ; LD (HL),A
        sta (z80_hl),y
        lda z80_c ; LD A,C
        ldy #$00 ; LD (DE),A
        sta (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        dec z80_b ; DJNZ LA6F0
        jne LA6F0
        rts ; RET

;LA6FA   LD A,(LA269)
;A6FD    AND A
;A6FE    RET Z
;A6FF    LD HL,LA83B
;A702    LD DE,LA260
;A705    CALL LA77F
;A708    LD HL,LA84D
;A70B    LD DE,LA25E
;A70E    CALL LA77F
;A711    LD HL,LA85F
;A714    LD DE,LA25C
;A717    CALL LA77F
;A71A    LD DE,LA82E
;A71D    LD B,04
;A71F    CALL LA742
;A722    LD A,(LA21C)
;A725    BIT 0,A
;A727    RET Z
;A728    LD A,(LA23F)
;A72B    AND 01
;A72D    JR NZ,@@27
;A72F    LD DE,LA888
;@@24    PUSH DE
;A733    LD HL,LA26A
;A736    EX DE,HL
;A737    LD A,0C
;A739    CALL LD26E
;A73C    CALL LA4F0
;A73F    POP DE
;A740    LD B,01
;LA742   LD C,0E
;A744    INC DE
;A745    LD A,(DE)
;A746    INC DE
;A747    ADD A,04
;A749    LD L,A
;A74A    LD A,(DE)
;A74B    INC DE
;A74C    LD H,A
;A74D    LD A,(DE)
;A74E    INC DE
;A74F    EX AF,AF'
;@@26    LD A,(DE)
;A751    INC DE
;A752    PUSH BC
;A753    CALL LD4E3
;A756    LD BC,L8EA8
;A759    CALL LD632
;A75C    INC L
;A75D    POP BC
;A75E    DEC C
;A75F    JR NZ,@@26
;A761    DJNZ LA742
;A763    RET

; telegram text set-up - only comes in here once at the start of each game
; LA6FA
telegram_text_startup   

		lda game_on ; LD A,(LA269)
        ; AND  A
        bne *+3 ; RET Z
        rts
  
		; 5 x $20 to be filled
		lda #<LA83B ; LD HL,LA83B
        sta z80_l
        lda #>LA83B
        sta z80_h
		
		; $80
        lda #<LA260 ; LD DE,LA260
        sta z80_e
        lda #>LA260
        sta z80_d
        
		jsr LA77F ; CALL LA77F
        
		; 5 x $20 to be filled
		lda #<LA84D ; LD HL,LA84D
        sta z80_l
        lda #>LA84D
        sta z80_h
        
		; $ff
		lda #<LA25E ; LD DE,LA25E
        sta z80_e
        lda #>LA25E
        sta z80_d
        
		jsr LA77F ; CALL LA77F
        
		; hi score text with 5 x $20 in front
		lda #<LA85F ; LD HL,LA85F
        sta z80_l
        lda #>LA85F
        sta z80_h
        
		; $c0
		lda #<LA25C ; LD DE,LA25C
        sta z80_e
        lda #>LA25C
        sta z80_d
        
		jsr LA77F ; CALL LA77F

    
		; draw first 4 lines of text - bullets text data
		lda #<LA82E ; LD DE,LA82E
        sta z80_e
        lda #>LA82E
        sta z80_d
		
        lda #$04 ; LD B,04
        sta z80_b
		
		; jump down this proc into drawing part
        jsr LA742 ; CALL LA742
		
		; jump out if single player game
        lda game_select_type ; LD A,(LA21C)
		bit _bitmem0 ; BIT 0,A
        bne *+3 ; RET Z
        rts
		
		 ; jump to @@27 if player 2 is up - to print P1 SCR - if player 1 up then do stuff below instead
        lda player_number ; LD A,(LA23F)
        and #$01 ; AND 01
        jne @@27 ; JR NZ,@@27
		
		; player txt and screen poss
        lda #<LA888 ; LD DE,LA888
        sta z80_e
        lda #>LA888
        sta z80_d

		lda #01
		sta twoplayersup
		
@@24    lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
		
        lda #<LA26A ; LD HL,LA26A
        sta z80_l
        lda #>LA26A
        sta z80_h
		
        jsr ex_de_hl ; EX DE,HL
        lda #$0C ; LD A,0C
		
        jsr LD26E ; CALL LD26E
        jsr LA4F0 ; CALL LA4F0
        
		pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        lda #$01 ; LD B,01
        sta z80_b

		
; draw all lines of text		
LA742
		
		lda #03
		sta count_temp
		
		; 5 for 2 player game
		;lda #04
		;sta count_temp_02

		lda #<$d5e8
		sta dest_lo
		lda #>$d5e8
		sta dest_hi

		lda twoplayersup
		beq LA742_b
		
		lda #<$dc28
		sta dest_lo
		lda #>$dc28
		sta dest_hi

		lda #00
		sta twoplayersup

LA742_b
		
		lda #$0E ; LD C,0E
        sta z80_c
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        clc ; ADD A,04
        adc #$04; 
        sta z80_l ; LD L,A
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        sta z80_h ; LD H,A; 
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        ;ldx z80_ap ; EX AF,AF'
        sta z80_ap
        ;txa 

; draw one line of text		
@@26    ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        tax
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        txa
		
		; set-up draw data
        jsr LD4E3 ; CALL LD4E3 ; uses A as parameter
        
		; 6 x $00
		ldx #<L8EA8 ; LD BC,L8EA8
        stx z80_c
        ldx #>L8EA8
        stx z80_b

		; update draw
        ;jsr LD632 ; CALL LD632 ; uses A as parameter

		jsr setup_char
		jsr fontblit		
        
		inc z80_l ; INC L
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
		
		; length of text string (max 14)
        dec z80_c ; DEC C
		;cmp #04
        jne @@26 ; JR NZ,@@26

		lda #208
		jsr addadest
		
		dec count_temp
		bne @+
		jsr addline
		
@	
		
        dec z80_b ; DJNZ LA742
        jne LA742_b
		
		;dec count_temp_02
		;jne LA742_b
		
		;jmp *
		
        rts ; RET

;@@27    LD DE,LA876
;A767    JR @@24

@@27
		; player txt and screen poss
		lda #<LA876 ; LD DE,LA876
        sta z80_e
        lda #>LA876
        sta z80_d
		
		lda #01
		sta twoplayersup
		
        jmp @@24 ; JR @@24

;A769    DB C9,AF,32,2E,A8 ; ..2..

        ;.he C9,AF,32,2E,A8 ; DB C9,AF,32,2E,A8

;LA76E   LD HL,LA260
;A771    LD A,(HL)
;A772    INC HL
;A773    OR (HL)
;A774    RET NZ
;A775    LD DE,LA83B
;A778    LD BC,L0005
;LA77B   LD (HL),B
;A77C    DEC HL
;A77D    LD (HL),C
;A77E    EX DE,HL
;LA77F   LD BC,L0200
;A782    INC DE
;@@30    LD A,(DE)
;A784    AND F0
;A786    JR NZ,@@31
;A788    INC C
;A789    LD A,(DE)
;A78A    AND 0F
;A78C    JR NZ,@@33
;A78E    INC C
;A78F    DEC DE
;A790    DJNZ @@30
;A792    RET

LA76E   lda #<LA260 ; LD HL,LA260
        sta z80_l
        lda #>LA260
        sta z80_h
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ldy #$00 ; OR (HL)
        ora (z80_hl),y; 
        beq *+3 ; RET NZ
        rts
        lda #<LA83B ; LD DE,LA83B
        sta z80_e
        lda #>LA83B
        sta z80_d
        lda #<L0005 ; LD BC,L0005
        sta z80_c
        lda #>L0005
        sta z80_b
LA77B   lda z80_b ; LD (HL),B
        ldy #$00
        sta (z80_hl),y
        jsr dec_hl ; DEC HL
        lda z80_c ; LD (HL),C
        ldy #$00
        sta (z80_hl),y
        jsr ex_de_hl ; EX DE,HL
LA77F   lda #<L0200 ; LD BC,L0200
        sta z80_c
        lda #>L0200
        sta z80_b
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
@@30    ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        and #$F0 ; AND F0
        jne @@31 ; JR NZ,@@31
        inc z80_c ; INC C
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        and #$0F ; AND 0F
        jne @@33 ; JR NZ,@@33
        inc z80_c ; INC C
        jsr dec_de ; DEC DE
        dec z80_b ; DJNZ @@30
        jne @@30
        rts ; RET

;@@31    LD A,(DE)
;A794    RRCA
;A795    RRCA
;A796    RRCA
;A797    RRCA
;A798    AND 0F
;A79A    ADD A,30
;A79C    LD (HL),A
;A79D    INC HL
;@@33    LD A,(DE)
;A79F    AND 0F
;A7A1    ADD A,30
;A7A3    LD (HL),A
;A7A4    INC HL
;A7A5    DEC DE
;A7A6    DJNZ @@31
;@@34    LD A,C
;A7A9    AND A
;A7AA    RET Z
;A7AB    LD (HL),20
;A7AD    INC HL
;A7AE    DEC C
;A7AF    JR @@34

@@31    ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$0F ; AND 0F
        clc ; ADD A,30
        adc #$30
        ldy #$00 ; LD (HL),A
        sta (z80_hl),y
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
@@33    ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        and #$0F ; AND 0F
        clc ; ADD A,30
        adc #$30
        ldy #$00 ; LD (HL),A
        sta (z80_hl),y
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        jsr dec_de ; DEC DE
        dec z80_b ; DJNZ @@31
        jne @@31
@@34    lda z80_c ; LD A,C
        ; AND  A
        bne *+3 ; RET Z
        rts
        lda #$20 ; LD (HL),20
        ldy #$00
        sta (z80_hl),y
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        dec z80_c ; DEC C
        jmp @@34 ; JR @@34

;A7B1    DB C9,AF,32,40,A8 ; ..2@.

        .he C9,AF,32,40,A8 ; DB C9,AF,32,40,A8

;LA7B6   LD HL,LA25E
;A7B9    LD A,(HL)
;A7BA    INC HL
;A7BB    OR (HL)
;A7BC    RET NZ
;A7BD    LD DE,LA84D
;A7C0    LD BC,L0050
;A7C3    JR LA77B

LA7B6   lda #<LA25E ; LD HL,LA25E
        sta z80_l
        lda #>LA25E
        sta z80_h
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ldy #$00 ; OR (HL)
        ora (z80_hl),y
        beq *+3 ; RET NZ
        rts
        lda #<LA84D ; LD DE,LA84D
        sta z80_e
        lda #>LA84D
        sta z80_d
        lda #<L0050 ; LD BC,L0050
        sta z80_c
        lda #>L0050
        sta z80_b
        jmp LA77B ; JR LA77B

;A7C5    DB AF,32,40,A8 ; .2@.

        ;.he AF,32,40,A8 ; DB AF,32,40,A8

;LA7C9   LD HL,LA25C
;A7CC    LD A,(HL)
;A7CD    INC HL
;A7CE    OR (HL)
;A7CF    RET NZ
;A7D0    LD DE,LA85F
;A7D3    LD BC,L0100
;A7D6    JR LA77B

LA7C9   lda #<LA25C ; LD HL,LA25C
        sta z80_l
        lda #>LA25C
        sta z80_h
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ldy #$00 ; OR (HL)
        ora (z80_hl),y
        beq *+3 ; RET NZ
        rts
        lda #<LA85F ; LD DE,LA85F
        sta z80_e
        lda #>LA85F
        sta z80_d
        lda #<L0100 ; LD BC,L0100
        sta z80_c
        lda #>L0100
        sta z80_b
        jmp LA77B ; JR LA77B

;LA7D8   LD A,(LA269)
;A7DB    AND A
;A7DC    RET Z
;A7DD    LD B,06
;A7DF    LD HL,LA82E
;A7E2    LD DE,L0012
;A7E5    LD A,(LA269)
;A7E8    LD C,A
;@@35    LD A,(HL)
;A7EA    CP 0E
;A7EC    JR NZ,@@36
;A7EE    ADD HL,DE
;A7EF    DJNZ @@35
;A7F1    RET

;LA7D8   
print_telegram_messages
		
		lda game_on ; LD A,(LA269)
        ; AND  A
        bne *+3 ; RET Z
        rts
		
		lda #$06 ; LD B,06
        sta z80_b
        lda #<LA82E ; LD HL,LA82E
        sta z80_l
        lda #>LA82E
        sta z80_h
        lda #<L0012 ; LD DE,L0012
        sta z80_e
        lda #>L0012
        sta z80_d
        lda game_on ; LD A,(LA269)
			
        sta z80_c ; LD C,A
		
@@35    ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        cmp #$0E ; CP 0E
        jne @@36 ; JR NZ,@@36
			
		
        jsr add_hl_de ; ADD HL,DE
        dec z80_b ; DJNZ @@35
        jne @@35
	
		;lda #<$d708
		;sta dest_lo
		;lda #>$d708
		;sta dest_hi 
		
        rts ; RET

;@@36    PUSH HL
;A7F3    PUSH AF
;A7F4    INC HL
;A7F5    LD E,(HL)
;A7F6    INC HL
;A7F7    LD D,(HL)
;A7F8    INC HL
;A7F9    EX DE,HL
;A7FA    ADD A,C
;A7FB    CALL LD26E
;A7FE    LD A,(DE)
;A7FF    INC DE
;A800    EX AF,AF'
;A801    LD A,(LA216)
;A804    AND 01
;A806    JR Z,@@37
;A808    ADD A,5E
;A80A    CALL LD4E3
;A80D    LD BC,L8EA8
;A810    CALL LD632
;A813    POP AF
;A814    POP HL
;A815    RET

@@36   
		sta z80_a
		
		lda #01
		sta drawposs
		
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda z80_a
        pha ; PUSH AF
        php;
	
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD E,(HL)
        lda (z80_hl),y
        sta z80_e
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD D,(HL)
        lda (z80_hl),y
        sta z80_d
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        jsr ex_de_hl ; EX DE,HL
        lda z80_a
        clc ; ADD A,C
        adc z80_c; 
        jsr LD26E ; CALL LD26E ; uses A as parameter
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        ;ldx z80_ap ; EX AF,AF'
        sta z80_ap
        ;txa ;

		
        lda LA216 ; LD A,(LA216)
        and #$01 ; AND 01
        jeq @@37 ; JR Z,@@37
		
        clc ; ADD A,5E
        adc #$5E; 
        jsr LD4E3 ; CALL LD4E3 ; uses A as parameter
        ldx #<L8EA8 ; LD BC,L8EA8
        stx z80_c
        ldx #>L8EA8
        stx z80_b
		
		
		; print stars across message screen
        ;jsr LD632 ; CALL LD632 ; uses A as parameter
       
	   	ldx #01
		stx block_add
	    jsr setup_char_tele

	   
	    ; go back one
		;lda dest_lo
		;sec
		;sbc #08
		;sta dest_lo
		;scs:dec dest_hi
			
		;lda #01
		;sta alpha
		;ldx #248
		;jsr fontblit
		
		plp ; POP AF
        pla
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
		
        rts ; RET

;@@37    POP AF
;A817    EX DE,HL
;A818    CALL LD26E
;A81B    EX DE,HL
;A81C    LD A,(DE)
;A81D    CALL LD4E3
;A820    PUSH AF
;A821    CALL LAF41
;A824    POP AF
;A825    LD BC,L8EA8
;A828    CALL LD632
;A82B    POP HL
;A82C    INC (HL)
;A82D    RET

@@37    plp ; POP AF
        pla
        ;sta z80_a
        ;jsr ex_de_hl ; EX DE,HL
        ;lda z80_a
        ;jsr AddAToHL ; CALL LD26E ; uses A as parameter
        ;jsr ex_de_hl ; EX DE,HL
		clc
		adc z80_e
		sta z80_e
		scc:inc z80_d

        		
	ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        jsr LD4E3 ; CALL LD4E3 ; uses A as parameter
        pha ; PUSH AF
        php; 
        jsr LAF41 ; CALL LAF41
        plp ; POP AF
        pla
        ldx #<L8EA8 ; LD BC,L8EA8
        stx z80_c
        ldx #>L8EA8
        stx z80_b
	
		; print numbers to screen
        ;jsr LD632 ; CALL LD632 ; uses A as parameter

		jsr setup_char_tele
		
		pla ; POP HL
        sta z80_h
        pla
        sta z80_l
       
		
		ldy #$00 ; INC (HL)
        lda (z80_hl),y
        
		clc
		
        adc #$01
        sta (z80_hl),y	
		
        rts ; RET

;LA82E   DB 0E,2D,50,47,42,55,4C,4C ; .-PGBULL
;A836    DB 45,54,53,20,5E ; ETS ^

LA82E   .he 0E ; DB 0E,2D,50,47,42,55,4C,4C
LA82F   .wo L502D
LA831   .he 47,42,55,4C,4C
        .he 45,54,53,20,5E ; DB 45,54,53,20,5E

;LA83B   DB 20,20,20,20,20 ;      

LA83B   .he 20,20,20,20,20 ; DB 20,20,20,20,20

;LA840   DB 0E,4D,50,47,48,4F,52,53 ; .MPGHORS
;A848    DB 45,20,20,20,5E ; E   ^

LA840   .he 0E ; DB 0E,4D,50,47,48,4F,52,53
LA841   .wo L504D
LA843   .he 47,48,4F,52,53
        .he 45,20,20,20,5E ; DB 45,20,20,20,5E

;LA84D   DB 20,20,20,20,20 ;      

LA84D   .he 20,20,20,20,20 ; DB 20,20,20,20,20

;LA852   DB 0E,6D,50,47,46,49,4E,45 ; ..PGFINE
;A85A    DB 20,20,20,20,5E ;     ^

LA852   .he 0E ; DB 0E,6D,50,47,46,49,4E,45
LA853   .wo L506D
LA855   .he 47,46,49,4E,45
        .he 20,20,20,20,5E ; DB 20,20,20,20,5E

;LA85F   DB 20,20,20,20,20,0E,AD,50 ;      ..P
;A867    DB 46,48,49,5C,53,43,52,20 ; FHI\SCR 
;A86F    DB 5E

LA85F   .he 20,20,20,20,20,0E ; DB 20,20,20,20,20,0E,AD,50
LA865   .wo L50AD
LA867   .he 46,48,49,5C,53,43,52,20 ; DB 46,48,49,5C,53,43,52,20
        .he 5E ; DB 5E

;LA870   DB 20,20,20,20,20,20 ;       

LA870   .he 20,20,20,20,20,20 ; DB 20,20,20,20,20,20

;LA876   DB 0E,CD,50,46,50,31,20,53 ; ..PFP1 S
;A87E    DB 43,52,20,5E,20,20,20,20 ; CR ^    
;A886    DB 20,20

LA876   .he 0E ; DB 0E,CD,50,46,50,31,20,53
        .wo L50CD
        .he 46,50,31,20,53
        .he 43,52,20,5E,20,20,20,20 ; DB 43,52,20,5E,20,20,20,20
        .he 20,20 ; DB 20,20

;LA888   DB 0E,CD,50,46,50,32,20,53 ; ..PFP2 S
;A890    DB 43,52,20,5E,20,20,20,20 ; CR ^    
;A898    DB 20,20

LA888   .he 0E ; DB 0E,CD,50,46,50,32,20,53
        .wo L50CD
        .he 46,50,32,20,53
        .he 43,52,20,5E,20,20,20,20 ; DB 43,52,20,5E,20,20,20,20
        .he 20,20 ; DB 20,20

;LA89A   LD A,(LA262)
;A89D    CP 08
;A89F    RET C
;A8A0    LD DE,LA2FB
;A8A3    LD A,(DE)
;A8A4    AND A
;A8A5    RET NZ
;A8A6    PUSH DE
;A8A7    POP IY
;A8A9    LD HL,LA8BF
;A8AC    LD BC,L0010
;A8AF    LDIR
;A8B1    LD B,01
;A8B3    CALL LB6CB
;A8B6    RET NZ
;A8B7    CALL LB6F6
;A8BA    LD (IY+00),17
;A8BE    RET

LA89A   lda BanditId ; LD A,(LA262)
        cmp #$08 ; CP 08
        bcs *+3 ; RET C
        rts
        lda #<LA2FB ; LD DE,LA2FB
        sta z80_e
        lda #>LA2FB
        sta z80_d
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        ; AND  A
        beq *+3 ; RET NZ
        rts
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        pla ; POP IY
        sta z80_iy+1
        pla
        sta z80_iy
        lda #<LA8BF ; LD HL,LA8BF
        sta z80_l
        lda #>LA8BF
        sta z80_h
        lda #<L0010 ; LD BC,L0010
        sta z80_c
        lda #>L0010
        sta z80_b
        jsr ldir ; LDIR
        lda #$01 ; LD B,01
        sta z80_b
        jsr LB6CB ; CALL LB6CB
        beq *+3 ; RET NZ
        rts
        jsr LB6F6 ; CALL LB6F6
        ldy #$00 ; LD (IY+00),17
        lda #$17
        sta (z80_iy),y
        rts ; RET

;LA8BF   DB 00,00,00,00,00,00,00,00
;A8C7    DB 10,10,00,00,00,00

LA8BF   .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 10,10,00,00,00,00 ; DB 10,10,00,00,00,00

;LA8CD   DW LA8CF

LA8CD   .wo LA8CF ; DW LA8CF

;LA8CF   DB F4,00,2B,80

LA8CF   .he F4,00,2B,80 ; DB F4,00,2B,80

;@@38    LD C,02
;A8D5    CALL LB80E
;A8D8    JP NC,LC7AA
;A8DB    LD A,(IX+0A)
;A8DE    LD BC,LA949
;A8E1    CALL LC74B
;A8E4    LD A,(IX+0B)
;A8E7    INC (IX+0B)
;A8EA    CALL LD26E
;A8ED    LD A,(HL)
;A8EE    CP 80
;A8F0    JR Z,@@42
;A8F2    SRA A
;A8F4    SRA A
;A8F6    SRA A
;A8F8    SRA A
;A8FA    BIT 6,(IX+05)
;A8FE    JR Z,@@39
;A900    NEG
;@@39    SLA A
;A904    LD (LA215),A
;A907    LD A,(HL)
;A908    LD C,A
;A909    AND 0F
;A90B    BIT 3,C
;A90D    JR Z,@@40
;A90F    OR F0
;@@40    BIT 7,(IX+05)
;A915    JR Z,@@41
;A917    NEG
;@@41    SLA A
;A91B    LD (LA214),A
;A91E    CALL LCD39
;A921    CALL LCCDE
;A924    LD A,(IX+07)
;A927    XOR 40
;A929    LD (IX+07),A
;A92C    CALL LB62F
;A92F    JP C,LB752
;A932    RET

LA8D3
@@38    lda #$02 ; LD C,02
        sta z80_c
        jsr LB80E ; CALL LB80E
        jcs LC7AA ; JP NC,LC7AA
        ldy #$0A ; LD A,(IX+0A)
        lda (z80_ix),y
        ;ldx #<LA949 ; LD BC,LA949
        ;stx z80_c
        ;ldx #>LA949
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		asl @
		tax
		lda LA949,x
		sta z80_l
		lda LA949+1,x
		sta z80_h
        ldy #$0B ; LD A,(IX+0B)
        lda (z80_ix),y
        tax
        ;ldy #$0B ; INC (IX+0B)
        ;lda (z80_ix),y

        clc
        adc #$01
        sta (z80_ix),y
        txa
        jsr LD26E ; CALL LD26E ; uses A as parameter
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        cmp #$80 ; CP 80
        jeq @@42 ; JR Z,@@42
        cmp #$80 ; SRA A
        ror @; 
        cmp #$80 ; SRA A
        ror @
        cmp #$80 ; SRA A
        ror @
        cmp #$80 ; SRA A
        ror @

		sta z80_a
        ldy #$05 ; BIT 6,(IX+05)
        lda (z80_ix),y
        bit _bitmem6
        jeq @@39 ; JR Z,@@39
		lda z80_a
        eor #$ff ; NEG
        clc
        adc #$01
		sta z80_a
@@39    sta z80_a
		asl @ ; SLA A

        sta LA215 ; LD (LA215),A
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        sta z80_c ; LD C,A
        and #$0F ; AND 0F
		sta z80_a
        lda z80_c ; BIT 3,C
        bit _bitmem3
        jeq @@40 ; JR Z,@@40
		lda z80_a
        ora #$F0 ; OR F0
        sta z80_a
@@40    ldy #$05 ; BIT 7,(IX+05)
        lda (z80_ix),y
        bit _bitmem7
        jeq @@41 ; JR Z,@@41
        lda z80_a
        eor #$ff ; NEG
        clc
        adc #$01
        sta z80_a
@@41    lda z80_a
        asl @ ; SLA A
        sta LA214 ; LD (LA214),A
        jsr LCD39 ; CALL LCD39
        jsr LCCDE ; CALL LCCDE
        ldy #$07 ; LD A,(IX+07)
        lda (z80_ix),y
        eor #$40 ; XOR 40
        ;ldy #$07 ; LD (IX+07),A
        sta (z80_ix),y
        jsr LB62F ; CALL LB62F
        jcc LB752 ; JP C,LB752
        rts ; RET

;@@42    LD A,(LA218)
;A936    AND 01
;A938    LD (IX+0A),A
;A93B    LD (IX+0B),00
;A93F    LD A,(IX+05)
;A942    ADD A,40
;A944    LD (IX+05),A
;A947    JR @@38

@@42    lda LA218 ; LD A,(LA218)
        and #$01 ; AND 01
        ldy #$0A ; LD (IX+0A),A
        sta (z80_ix),y
        ;ldy #$0B ; LD (IX+0B),00
		iny
        lda #$00
        sta (z80_ix),y
        ldy #$05 ; LD A,(IX+05)
        lda (z80_ix),y
        clc ; ADD A,40
        adc #$40
        ;ldy #$05 ; LD (IX+05),A
        sta (z80_ix),y
        jmp @@38 ; JR @@38

;LA949   DW LA94D,LA966

LA949   .wo LA94D,LA966 ; DW LA94D,LA966

;LA94D   DB 0C,2C,0C,2C,2C,4E,2C,4E ; .,.,,N,N
;A955    DB 4E,40,4E,40,40,42,40,42 ; N@N@@B@B
;A95D    DB 42,24,42,24,24,24,24,20 ; B$B$$$$ 
;A965    DB 80

LA94D   .he 0C,2C,0C,2C,2C,4E,2C,4E ; DB 0C,2C,0C,2C,2C,4E,2C,4E
        .he 4E,40,4E,40,40,42,40,42 ; DB 4E,40,4E,40,40,42,40,42
        .he 42,24,42,24,24,24,24,20 ; DB 42,24,42,24,24,24,24,20
        .he 80 ; DB 80

;LA966   DB C0,C2,C0,C2,C2,E4,C2,E4
;A96E    DB E4,04,E4,04,04,24,04,24 ; .....$.$
;A976    DB 24,42,24,42,42,42,42,02 ; $B$BBBB.
;A97E    DB 80

LA966   .he C0,C2,C0,C2,C2,E4,C2,E4 ; DB C0,C2,C0,C2,C2,E4,C2,E4
        .he E4,04,E4,04,04,24,04,24 ; DB E4,04,E4,04,04,24,04,24
        .he 24,42,24,42,42,42,42,02 ; DB 24,42,24,42,42,42,42,02
        .he 80 ; DB 80

;LA97F   LD A,(LA27B)
;A982    CP 01
;A984    RET NZ
;A985    LD DE,LA2EB
;A988    LD A,(DE)
;A989    AND A
;A98A    RET NZ
;A98B    PUSH DE
;A98C    POP IY
;A98E    LD HL,LA9A6
;A991    LD BC,L0010
;A994    LDIR
;A996    LD B,02
;A998    CALL LB6CB
;A99B    RET NZ
;A99C    LD (IY+00),14
;A9A0    LD A,40
;A9A2    LD (LA209),A
;A9A5    RET

LA97F   lda LA27B ; LD A,(LA27B)
        cmp #$01 ; CP 01
        beq *+3 ; RET NZ
        rts
        ;lda #<LA2EB ; LD DE,LA2EB
        ;sta z80_e
        ;lda #>LA2EB

        ;sta z80_d
        ;ldy #$00 ; LD A,(DE)
        ;lda (z80_de),y
		lda LA2EB
        ; AND  A
        beq *+3 ; RET NZ
        rts
        ;lda z80_e ; PUSH DE
        ;pha

        ;lda z80_d
        ;pha

        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		lda #<LA2EB
		sta z80_iy
		lda #>LA2EB
		sta z80_iy+1


        ;lda #<LA9A6 ; LD HL,LA9A6
        ;sta z80_l
        ;lda #>LA9A6
        ;sta z80_h
        ;lda #<L0010 ; LD BC,L0010
        ;sta z80_c
        ;lda #>L0010
        ;sta z80_b
        ;jsr ldir ; LDIR
		ldy #$0f
LA97F_Loop		
		lda LA9A6,y
		sta (z80_iy),y
		dey
		bpl LA97F_Loop
        lda #$02 ; LD B,02
        sta z80_b
        jsr LB6CB ; CALL LB6CB
        beq *+3 ; RET NZ
        rts
        ldy #$00 ; LD (IY+00),14
        lda #$14
        sta (z80_iy),y
        lda #$40 ; LD A,40
        sta LA209 ; LD (LA209),A
        rts ; RET


;LA9A6   DB 00,80,00,80,00,00,00,00
;A9AE    DB 10,10,00,00,00,00

LA9A6   .he 00,80,00,80,00,00,00,00 ; DB 00,80,00,80,00,00,00,00
        .he 10,10,00,00,00,00 ; DB 10,10,00,00,00,00

;LA9B4   DW LA9B6

LA9B4   .wo LA9B6 ; DW LA9B6

;LA9B6   DB EC,00,37,FC,01,36,80 ; ..7..6.

LA9B6   .he EC,00,37,FC,01,36,80 ; DB EC,00,37,FC,01,36,80

;A9BD    LD C,03
;A9BF    CALL LB80E
;A9C2    JP NC,LC7AA
;A9C5    CALL LB62F
;A9C8    RET NC
;A9C9    LD A,08
;A9CB    LD (LA23C),A
;A9CE    LD HL,LAEBD
;A9D1    LD (LA23D),HL
;A9D4    LD (IX+00),00
;A9D8    LD A,12
;A9DA    LD (LA21F),A
;A9DD    LD (IY+00),15
;A9E1    LD BC,(LA25E)
;A9E5    CALL LD340
;A9E8    JP LD389
LA9BD   lda #$03 ; LD C,03
        sta z80_c
        jsr LB80E ; CALL LB80E
        jcs LC7AA ; JP NC,LC7AA
        jsr LB62F ; CALL LB62F
        bcc *+3 ; RET NC
        rts
        
		; on horse
		lda #$08 ; LD A,08
        sta LA23C ; LD (LA23C),A
		sta on_horse
		
        ;lda #<LAEBD ; LD HL,LAEBD
        ;sta z80_l
        ;lda #>LAEBD
        ;sta z80_h
        ;lda z80_l ; LD (LA23D),HL
        ;sta LA23D
        ;lda z80_h
        ;sta LA23D+1
		lda #<LAEBD
		sta LA23D

		lda #>LAEBD




		sta LA23D+1
        ldy #$00 ; LD (IX+00),00
        ;lda #$00
		tya
        sta (z80_ix),y
		; horse speed - default $12
        lda #$12 ; LD A,12
        sta LA21F ; LD (LA21F),A
        ;ldy #$00 ; LD (IY+00),15
        lda #$15
        sta (z80_iy),y
        lda LA25E ; LD BC,(LA25E)
        sta z80_c
        lda LA25E+1
        sta z80_b
        jsr LD340 ; CALL LD340
        jmp LD389 ; JP LD389



;LA9EB   LD A,(LA2DB)
;A9EE    AND A
;A9EF    RET NZ
;A9F0    LD A,(LA27D)
;A9F3    LD E,A
;A9F4    LD A,(LA27F)
;A9F7    RLCA
;A9F8    RLCA
;A9F9    RLCA
;A9FA    RLCA
;A9FB    AND F0
;A9FD    LD D,A
;A9FE    LD HL,LAA74
;AA01    LD B,(HL)
;AA02    INC HL
;@@43    LD A,(HL)
;AA04    AND 0F
;AA06    SUB E
;AA07    JR NC,@@44
;AA09    NEG
;@@44    CP 02
;AA0D    JR NC,@@47
;AA0F    LD A,(HL)
;AA10    AND F0
;AA12    SUB D
;AA13    JR NC,@@45
;AA15    NEG
;@@45    CP 20
;AA19    JR NC,@@47
;AA1B    LD A,(HL)
;AA1C    PUSH AF
;AA1D    LD DE,LA2DB
;AA20    PUSH DE
;AA21    POP IY
;AA23    LD HL,LAA60
;AA26    LD BC,L0010
;AA29    LDIR
;AA2B    POP AF
;AA2C    LD C,A
;AA2D    AND 0F
;AA2F    LD (IY+02),A
;AA32    LD A,C
;AA33    RRCA
;AA34    RRCA
;AA35    RRCA
;AA36    RRCA
;AA37    AND 0F
;AA39    LD (IY+04),A
;AA3C    LD A,C
;AA3D    RLCA
;AA3E    RLCA
;AA3F    RLCA
;AA40    RLCA
;AA41    AND 70
;AA43    ADD A,40
;AA45    LD (IY+01),A
;AA48    LD A,C
;AA49    CPL
;AA4A    AND 70
;AA4C    ADD A,40
;AA4E    LD (IY+03),A
;AA51    XOR (IY+01)
;AA54    RLCA
;AA55    RLCA
;AA56    AND 40
;AA58    LD (IY+07),A
;AA5B    RET

LA9EB   lda LA2DB ; LD A,(LA2DB)
        ; AND  A
        beq *+3 ; RET NZ
        rts
        lda LA27D ; LD A,(LA27D)
        sta z80_e ; LD E,A
        lda LA27F ; LD A,(LA27F)
        asl @ ; RLCA
        asl @ ; RLCA
        asl @ ; RLCA
        asl @ ; RLCA
        and #$F0 ; AND F0
        sta z80_d ; LD D,A
        lda #<LAA74 ; LD HL,LAA74
        sta z80_l
        lda #>LAA74
        sta z80_h
        ldy #$00 ; LD B,(HL)
        lda (z80_hl),y
        sta z80_b
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
@@43    ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        and #$0F ; AND 0F
        sec ; SUB E
        sbc z80_e
        jcs @@44 ; JR NC,@@44
        eor #$ff ; NEG
        clc
        adc #$01; 
@@44    cmp #$02 ; CP 02
        jcs @@47 ; JR NC,@@47
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        and #$F0 ; AND F0
        sec ; SUB D
        sbc z80_d
        jcs @@45 ; JR NC,@@45
        eor #$ff ; NEG
        clc
        adc #$01;

@@45    cmp #$20 ; CP 20
        jcs @@47 ; JR NC,@@47
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        pha ; PUSH AF
        ;php

        lda #<LA2DB ; LD DE,LA2DB
        ;sta z80_e
		sta z80_iy
        lda #>LA2DB
        ;sta z80_d
		sta z80_iy+1
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
        ;lda #<LAA60 ; LD HL,LAA60
        ;sta z80_l
        ;lda #>LAA60
        ;sta z80_h
        ;lda #<L0010 ; LD BC,L0010
        ;sta z80_c
        ;lda #>L0010
        ;sta z80_b
        ;jsr ldir ; LDIR
		ldy #$0f
@@45_Loop		
		lda LAA60,y
		sta (z80_iy),y
		dey
		bpl @@45_Loop
        ;plp ; POP AF
        pla
        sta z80_c ; LD C,A
        and #$0F ; AND 0F
        ldy #$02 ; LD (IY+02),A
        sta (z80_iy),y
        lda z80_c ; LD A,C
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$0F ; AND 0F
        ldy #$04 ; LD (IY+04),A
        sta (z80_iy),y
        lda z80_c ; LD A,C
        asl @ ; RLCA
        asl @ ; RLCA
        asl @ ; RLCA
        asl @ ; RLCA
        and #$70 ; AND 70
        clc ; ADD A,40
        adc #$40
        ldy #$01 ; LD (IY+01),A
        sta (z80_iy),y
        lda z80_c ; LD A,C
        eor #$ff ; CPL
        and #$70 ; AND 70
        clc ; ADD A,40
        adc #$40
        ldy #$03 ; LD (IY+03),A
        sta (z80_iy),y
        ldy #$01 ; XOR (IY+01)
        eor (z80_iy),y
        asl @ ; RLCA
        asl @ ; RLCA
        and #$40 ; AND 40
        ldy #$07 ; LD (IY+07),A
        sta (z80_iy),y
        rts ; RET


;@@47    INC HL
;AA5D    DJNZ @@43
;AA5F    RET

@@47    inc z80_l ; INC HL
        bne *+4
        inc z80_h
        dec z80_b ; DJNZ @@43
        jne @@43
        rts ; RET

;LAA60   DB 13,00,00,00,00,00,00,00
;AA68    DB 10,10,00,00,00,00

LAA60   .he 13,00,00,00,00,00,00,00 ; DB 13,00,00,00,00,00,00,00
        .he 10,10,00,00,00,00 ; DB 10,10,00,00,00,00

;LAA6E   DW LAA70

LAA6E   .wo LAA70 ; DW LAA70

;LAA70   DB F4,00,2A,80

LAA70   .he F4,00,2A,80 ; DB F4,00,2A,80

;LAA74   DB 08,33,2D,5E,92,B7,BC,D2 ; .3-^....
;AA7C    DB DE

LAA74   .he 08,33,2D,5E,92,B7,BC,D2 ; DB 08,33,2D,5E,92,B7,BC,D2
        .he DE ; DB DE

;AA7D    LD C,02
;AA7F    CALL LB80E
;AA82    JP NC,LC7AA
;AA85    CALL LB62F
;AA88    JP C,LB752
;AA8B    CALL LB612
;AA8E    RET NC
;AA8F    LD (IY+00),07
;AA93    LD (IY+0C),02
;AA97    RET

LAA7D   lda #$02 ; LD C,02
        sta z80_c
        jsr LB80E ; CALL LB80E
        jcs LC7AA ; JP NC,LC7AA
        jsr LB62F ; CALL LB62F
        jcc LB752 ; JP C,LB752
        jsr LB612 ; CALL LB612
        bcc *+3 ; RET NC
        rts
        ldy #$00 ; LD (IY+00),07
        lda #$07
        sta (z80_iy),y
        ldy #$0C ; LD (IY+0C),02
        lda #$02
        sta (z80_iy),y
        rts ; RET

;LAA98   LD A,(DE)
;AA99    INC DE
;AA9A    EX AF,AF'
;@@48    LD A,(DE)
;AA9C    AND A
;AA9D    RET Z
;AA9E    INC DE
;AA9F    CALL LD4E3
;AAA2    PUSH DE
;AAA3    PUSH HL
;AAA4    EX DE,HL
;AAA5    LD L,A
;AAA6    LD H,00
;AAA8    ADD HL,HL
;AAA9    ADD HL,HL
;AAAA    ADD HL,HL
;AAAB    LD BC,L8EA8
;AAAE    ADD HL,BC
;AAAF    EX DE,HL
;AAB0    CALL LAAC2
;AAB3    CALL LAAE5
;AAB6    CALL LAAC2
;AAB9    CALL LAAE5
;AABC    POP HL
;AABD    POP DE
;AABE    INC L
;AABF    INC L
;AAC0    JR @@48

;LAA98
;		ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa 
;@@48    ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        ; AND  A
;        bne *+3 ; RET Z
;        rts
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        jsr LD4E3 ; CALL LD4E3 ; uses A as parameter
;        sta z80_a
;        lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;        jsr ex_de_hl ; EX DE,HL
;        lda z80_a
;        sta z80_l ; LD L,A
;        lda #$00 ; LD H,00
;        sta z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        lda #<L8EA8 ; LD BC,L8EA8
;        sta z80_c
;        lda #>L8EA8
;        sta z80_b
;        jsr add_hl_bc ; ADD HL,BC
;        jsr ex_de_hl ; EX DE,HL
;        
;  		jsr LAAC2 ; CALL LAAC2
;        jsr LAAE5 ; CALL LAAE5
;        jsr LAAC2 ; CALL LAAC2
;        jsr LAAE5 ; CALL LAAE5
;        
;	   	pla ; POP HL
;        sta z80_h
;        pla
;        sta z80_l
;        pla ; POP DE
;        sta z80_d
;        pla
;        sta z80_e
;        inc z80_l ; INC L
;        inc z80_l ; INC L
;        jmp @@48 ; JR @@48

;LAAC2   PUSH DE
;AAC3    PUSH HL
;AAC4    EX DE,HL
;AAC5    LD B,04
;@@49    LD A,(HL)
;AAC8    INC HL
;AAC9    RRCA
;AACA    RRCA
;AACB    RRCA
;AACC    RRCA
;AACD    AND 0F
;AACF    PUSH HL
;AAD0    LD HL,LAB06
;AAD3    CALL LD26E
;AAD6    LD A,(HL)
;AAD7    LD (DE),A
;AAD8    INC D
;AAD9    LD (DE),A
;AADA    INC D
;AADB    POP HL
;AADC    DJNZ @@49
;AADE    POP HL
;AADF    POP DE
;AAE0    CALL LD635
;AAE3    INC L
;AAE4    RET

;LAAC2   lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;        jsr ex_de_hl ; EX DE,HL
;        lda #$04 ; LD B,04
;        sta z80_b
;@@49    ldy #$00 ; LD A,(HL)
;        lda (z80_hl),y
;        inc z80_l ; INC HL
;        bne *+4
;        inc z80_h
;        lsr @ ; RRCA
;        lsr @ ; RRCA
;        lsr @ ; RRCA
;        lsr @ ; RRCA
;        and #$0F ; AND 0F
;        tax
;       lda z80_l ; PUSH HL
;       pha
;       lda z80_h
;       pha
;       lda #<LAB06 ; LD HL,LAB06
;       sta z80_l
;       lda #>LAB06
;       sta z80_h
;       txa
;       jsr LD26E ; CALL LD26E ; uses A as parameter
;       ldy #$00 ; LD A,(HL)
;       lda (z80_hl),y
;       ldy #$00 ; LD (DE),A
;       sta (z80_de),y
;       inc z80_d ; INC D
;       ldy #$00 ; LD (DE),A
;       sta (z80_de),y
;       inc z80_d ; INC D
;       pla ; POP HL
;       sta z80_h
;       pla
;       sta z80_l
;       dec z80_b ; DJNZ @@49
;       jne @@49
;       pla ; POP HL
;       sta z80_h
;       pla
;       sta z80_l
;       pla ; POP DE
;       sta z80_d
;       pla
;       sta z80_e
;       jsr LD635 ; CALL LD635
;       inc z80_l ; INC L
;       rts ; RET

;LAAE5   PUSH HL
;AAE6    EX DE,HL
;AAE7    LD B,04
;@@50    LD A,(HL)
;AAEA    INC HL
;AAEB    AND 0F
;AAED    PUSH HL
;AAEE    LD HL,LAB06
;AAF1    CALL LD26E
;AAF4    LD A,(HL)
;AAF5    LD (DE),A
;AAF6    INC D
;AAF7    LD (DE),A
;AAF8    INC D
;AAF9    POP HL
;AAFA    DJNZ @@50
;AAFC    EX DE,HL
;AAFD    POP HL
;AAFE    CALL LD635
;AB01    CALL LD648
;AB04    DEC L
;AB05    RET

;LAAE5   
;	     lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;        jsr ex_de_hl ; EX DE,HL
;        lda #$04 ; LD B,04
;        sta z80_b
;@@50    ldy #$00 ; LD A,(HL)
;        lda (z80_hl),y
;        inc z80_l ; INC HL
;        bne *+4
;        inc z80_h
;        and #$0F ; AND 0F
;        tax
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;        lda #<LAB06 ; LD HL,LAB06
;        sta z80_l
;        lda #>LAB06
;        sta z80_h
;        txa
;        jsr LD26E ; CALL LD26E ; uses A as parameter
;        ldy #$00 ; LD A,(HL)
;        lda (z80_hl),y
;        ldy #$00 ; LD (DE),A
;        sta (z80_de),y
;        inc z80_d ; INC D
;        ldy #$00 ; LD (DE),A
;        sta (z80_de),y
;        inc z80_d ; INC D
;        pla ; POP HL
;        sta z80_h
;        pla
;        sta z80_l
;        dec z80_b ; DJNZ @@50
;        jne @@50
;        jsr ex_de_hl ; EX DE,HL
;        pla ; POP HL
;        sta z80_h
;        pla
;        sta z80_l
;        jsr LD635 ; CALL LD635
;        jsr LD648 ; CALL LD648
;        dec z80_l ; DEC L
;        rts ; RET

;LAB06   DB 00,03,0C,0F,30,33,3C,3F ; ....03<?
;AB0E    DB C0,C3,CC,CF,F0,F3,FC,FF

;LAB06   .he 00,03,0C,0F,30,33,3C,3F ; DB 00,03,0C,0F,30,33,3C,3F
;        .he C0,C3,CC,CF,F0,F3,FC,FF ; DB C0,C3,CC,CF,F0,F3,FC,FF

;LAB16   LD A,(LA269)
;AB19    AND A
;AB1A    RET Z
;AB1B    LD A,(LA27D)
;AB1E    AND FE
;AB20    LD L,A
;AB21    LD A,(LA27F)
;AB24    AND FE
;AB26    LD H,A
;AB27    LD (LA256),HL
;AB2A    CALL LC6CB
;AB2D    LD HL,LAB68
;@@52    LD A,(HL)
;AB31    AND A
;AB32    RET Z
;AB33    AND 40
;AB35    LD (LA254),A
;AB38    LD A,(HL)
;AB39    AND 3F
;AB3B    INC HL
;AB3C    EX AF,AF'
;AB3D    LD E,(HL)
;AB3E    INC HL
;AB3F    LD A,(LA250)
;AB42    ADD A,E
;AB43    CP D0
;AB45    JR NC,@@54
;AB47    CP 10
;AB49    JR C,@@54
;AB4B    LD E,A
;AB4C    LD D,(HL)
;AB4D    INC HL
;AB4E    LD A,(LA252)
;AB51    ADD A,D
;AB52    AND 7F
;AB54    ADD A,40
;AB56    LD D,A
;AB57    EX AF,AF'
;AB58    PUSH HL
;AB59    LD BC,L686E
;AB5C    CALL LC74B
;AB5F    CALL LC496
;AB62    POP HL
;AB63    JR @@52


; *** Not Needed ??? ******
LAB16   lda game_on ; LD A,(LA269)
        ; AND  A
        bne *+3 ; RET Z
        rts
        lda LA27D ; LD A,(LA27D)
        and #$FE ; AND FE
        ;sta z80_l ; LD L,A
		sta LA256
        lda LA27F ; LD A,(LA27F)
        and #$FE ; AND FE
        ;sta z80_h ; LD H,A



		sta LA256+1
        ;lda z80_l ; LD (LA256),HL
        ;sta LA256
        ;lda z80_h
        ;sta LA256+1
        jsr LC6CB ; CALL LC6CB
        lda #<LAB68 ; LD HL,LAB68
        sta z80_l
        lda #>LAB68
        sta z80_h
@@52    ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        ; AND  A
        bne *+3 ; RET Z
        rts
        and #$40 ; AND 40
        sta LA254 ; LD (LA254),A
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        and #$3F ; AND 3F
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ;ldx z80_ap ; EX AF,AF'
        sta z80_ap
        ;txa 
        ldy #$00 ; LD E,(HL)
        lda (z80_hl),y
        sta z80_e
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        lda LA250 ; LD A,(LA250)
        clc ; ADD A,E
        adc z80_e
        cmp #$D0 ; CP D0
        jcs @@54 ; JR NC,@@54
        cmp #$10 ; CP 10
        jcc @@54 ; JR C,@@54
        sta z80_e ; LD E,A
        ldy #$00 ; LD D,(HL)
        lda (z80_hl),y
        sta z80_d
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        lda LA252 ; LD A,(LA252)
        clc ; ADD A,D
        adc z80_d
        and #$7F ; AND 7F
        clc ; ADD A,40
        adc #$40
        sta z80_d ; LD D,A
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa 
        ;tax
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        ;lda #<L686E ; LD BC,L686E
        ;sta z80_c
        ;lda #>L686E
        ;sta z80_b
        ;txa

        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		lda z80_ap
		asl @
		tax
		lda L686E,x
		sta z80_l
		lda L686E+1,x
		sta z80_h
        jsr PrintSmallBackgroundObjects
	;jsr LC496 ; CALL LC496
        
	pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        jmp @@52 ; JR @@52

;@@54    INC HL
;AB66    JR @@52

@@54    inc z80_l ; INC HL
        bne *+4
        inc z80_h
        jmp @@52 ; JR @@52

;LAB68   DB 01,20,20,41,90,60,01,60 ; .  A....
;AB70    DB 20,41,C0,30,00 ;  A.0.

LAB68   .he 01,20,20,41,90,60,01,60 ; DB 01,20,20,41,90,60,01,60
        .he 20,41,C0,30,00 ; DB 20,41,C0,30,00

;LAB75   XOR A
;AB76    LD (LA242),A
;AB79    CALL LD6D4
;AB7C    LD E,45
;AB7E    CALL LD6CC
;AB81    LD HL,L8A70
;AB84    LD (LA20F),HL
;AB87    LD HL,L4062
;AB8A    LD A,47
;AB8C    CALL LADE1
;AB8F    LD BC,L8EB0
;AB92    LD HL,L40C7
;AB95    LD A,01
;AB97    CALL LD2C2
;AB9A    LD HL,L4842
;AB9D    LD A,46
;AB9F    CALL LADE1
;ABA2    LD BC,L8EB0
;ABA5    LD HL,L48A7
;ABA8    LD A,02
;ABAA    CALL LD2C2
;ABAD    LD HL,L5022
;ABB0    LD A,44
;ABB2    CALL LADE1
;ABB5    LD BC,L8EB0
;ABB8    LD HL,L5087
;ABBB    LD A,03
;ABBD    CALL LD2C2
;ABC0    LD C,00
;ABC2    LD HL,L5800
;ABC5    CALL LAE8C
;ABC8    LD HL,L581F
;ABCB    CALL LAE8C
;ABCE    LD C,42
;ABD0    LD HL,L5809
;ABD3    CALL LAE8C
;ABD6    LD HL,L580A
;ABD9    CALL LAE8C
;ABDC    LD HL,L4006
;ABDF    LD DE,LAC30
;ABE2    CALL LAA98
;ABE5    LD HL,L50EA
;ABE8    LD DE,LAC21
;ABEB    CALL LD4D0
;ABEE    LD HL,LAC3C
;ABF1    LD DE,LAC4C
;ABF4    LD BC,L0010
;ABF7    LDIR
;LABF9   LD IX,LAC4C
;ABFD    XOR A
;ABFE    LD (LA20E),A
;@@55    LD A,(IX+00)
;AC04    LD BC,LAC5C
;AC07    CALL LC755
;AC0A    LD HL,LA20E
;AC0D    INC (HL)
;AC0E    LD BC,L0004
;AC11    ADD IX,BC
;AC13    PUSH IX
;AC15    POP HL
;AC16    LD BC,LAC5C
;AC19    AND A
;AC1A    SBC HL,BC
;AC1C    JR C,@@55
;AC1E    JP LABF9

; menu
; LAB75
draw_main_menu

		;jsr clear_vars

		;lda #$30 ; Open up all RAM
		;sta $01 	

		; clear bitmap & sprite data
		jsr c64clearbitmap

		;jsr font_expand
		
		;lda #$00 ; XOR A
        ;sta LA242 ; LD (LA242),A
        
		; clear bitmap screen
		;jsr old_screen_clear ; CALL LD6D4
        
		;lda #$45 ; LD E,45
        ;sta z80_e
		
		; clear colours
        ;jsr LD6CC ; CALL LD6CC
        
		;lda #<L8A70 ; LD HL,L8A70
        ;sta z80_l
        ;lda #>L8A70
        ;sta z80_h
        ;lda z80_l ; LD (LA20F),HL
        ;sta LA20F
        ;lda z80_h
        ;sta LA20F+1
		
		;gun gfx
		;lda #<L8A70
		;sta LA20F
		;lda #>L8A70
		;sta LA20F+1
        
		;gun1
		;lda #<L4062 ; LD HL,L4062 ; start drawing screen address
        ;sta z80_l
        ;lda #>L4062
        ;sta z80_h
        ;lda #$47 ; LD A,47
        ;jsr LADE1 ; CALL LADE1
        
		;draw gun 1
		lda #<L4062
		sta dest_lo
		lda #>L4062
		sta dest_hi
		lda #<L8A70
		sta source_lo
		lda #>L8A70
		sta source_hi

		jsr drawgun
		
		; draw gun 2
		lda #<L4842
		sta dest_lo
		lda #>L4842
		sta dest_hi
		lda #<L8A70
		sta source_lo
		lda #>L8A70
		sta source_hi

		jsr drawgun		

		; draw gun 3
		lda #<L5022
		sta dest_lo
		lda #>L5022
		sta dest_hi
		lda #<L8A70
		sta source_lo
		lda #>L8A70
		sta source_hi

		jsr drawgun
		
		; font gfx
		;lda #<L8EB0 ; LD BC,L8EB0
        ;sta z80_c
        ;lda #>L8EB0
        ;sta z80_b
		
		;no 1
        ;lda #<L40C7 ; LD HL,L40C7
        ;sta z80_l
        ;lda #>L40C7
        ;sta z80_h
        ;lda #$01 ; LD A,01
        ;jsr LD2C2 ; CALL LD2C2

		;no 1
		lda #00
		sta alpha
		
        lda #<L40C7 ; LD HL,L40C7
        sta dest_lo
        lda #>L40C7
        sta dest_hi
		ldx #08
		jsr fontblit_yx2
		
		
		;gun 2
		;lda #<L4842 ; LD HL,L4842
        ;sta z80_l
        ;lda #>L4842
        ;sta z80_h
        ;lda #$46 ; LD A,46
        ;jsr LADE1 ; CALL LADE1
		
        ;lda #<L8EB0 ; LD BC,L8EB0
        ;sta z80_c
        ;lda #>L8EB0
        ;sta z80_b
		
		;no 2
        ;lda #<L48A7 ; LD HL,L48A7
        ;sta z80_l
        ;lda #>L48A7
        ;sta z80_h
        ;lda #$02 ; LD A,02
        ;jsr LD2C2 ; CALL LD2C2

		;no 2
        lda #<L48A7 ; LD HL,L40C7
        sta dest_lo
        lda #>L48A7
        sta dest_hi
		ldx #16
		jsr fontblit_yx2
        
		;gun 3
		;lda #<L5022 ; LD HL,L5022
        ;sta z80_l
        ;lda #>L5022
        ;sta z80_h
        ;lda #$44 ; LD A,44
        ;jsr LADE1 ; CALL LADE1
		
        ;lda #<L8EB0 ; LD BC,L8EB0
        ;sta z80_c
        ;lda #>L8EB0
        ;sta z80_b
		
		;no 3
        ;lda #<L5087 ; LD HL,L5087
        ;sta z80_l
        ;lda #>L5087
        ;sta z80_h
        ;lda #$03 ; LD A,03
        ;jsr LD2C2 ; CALL LD2C2

		;no 3
        lda #<L5087 ; LD HL,L40C7
        sta dest_lo
        lda #>L5087
        sta dest_hi
		ldx #24
		jsr fontblit_yx2
		
		; colour
        ;lda #$00 ; LD C,00
        ;sta z80_c
        ;lda #<L5800 ; LD HL,L5800
        ;sta z80_l
        ;lda #>L5800
        ;sta z80_h
        ;jsr LAE8C ; CALL LAE8C
		
		; colour
        ;lda #<L581F ; LD HL,L581F
        ;sta z80_l
        ;lda #>L581F
        ;sta z80_h
        ;jsr LAE8C ; CALL LAE8C
		
		; colour
        ;lda #$42 ; LD C,42
        ;sta z80_c
        ;lda #<L5809 ; LD HL,L5809
        ;sta z80_l
        ;lda #>L5809
        ;sta z80_h
        ;jsr LAE8C ; CALL LAE8C
		
		; colour
        ;lda #<L580A ; LD HL,L580A
        ;sta z80_l
        ;lda #>L580A
        ;sta z80_h
        ;jsr LAE8C ; CALL LAE8C
		
        ;gun fright
		lda #01
		sta alpha		
		
        lda #<$c050
        sta dest_lo
        lda #>$c050
        sta dest_hi

        lda #<$c058
        sta source_lo
        lda #>$c058
		sta source_hi

		ldx #00
@
		ldy gunfrightalpha,x
		jsr font_expand
		
		ldx count_temp_03
		stx count_temp_03
		
		inx
		cpx #10
		bne @-
		
		;lda #<L4006 ; LD HL,L4006
        ;sta z80_l
        ;lda #>L4006
        ;sta z80_h
        ;lda #<LAC30 ; LD DE,LAC30
        ;sta z80_e
        ;lda #>LAC30
        ;sta z80_d
        ;jsr LAA98 ; CALL LAA98

		;gun fright sprite text

;		lda #54
;		sta spr_y
;		lda #104
;		sta spr_x0
;		lda #168
;		sta spr_x1
;		lda #216
;		sta spr_x2
;		lda #03
;		sta spr_col
;		
;		jsr spritesastextdotcom
;
;		lda #$c0
;		sta dest_lo
;		lda #$de
;		sta dest_hi
;		
;		ldx #00
;		stx count_temp_02
;gunf01	
;		lda gunfrightalpha,x
;		stx count_temp
;		tax
;		jsr fontalphablitsprite
;		ldx count_temp
;		inx
;		
;		cpx #09
;		bne gunf01  
		
		;acg
		;lda #<L50EA ; LD HL,L50EA
        ;sta z80_l
        ;lda #>L50EA
        ;sta z80_h
        ;lda #<LAC21 ; LD DE,LAC21
        ;sta z80_e
        ;lda #>LAC21
        ;sta z80_d
        ;jsr LD4D0 ; CALL LD4D0
		
		; c 1985 a.c.g.
		
		lda #00
		sta alpha
		
		lda #<L50EA
		sta dest_lo
		lda #>L50EA
		sta dest_hi
		
		ldx #00
acg01	
		lda acgnum,x
		stx count_temp
		tax
		jsr fontblit
		ldx count_temp
		inx
		
		cpx #07
		bne acg01		

		lda #01
		sta alpha		
		
		ldx #00
acg02	
		lda acgalpha,x
		stx count_temp
		tax
		jsr fontblit
		ldx count_temp
		inx
		
		cpx #06
		bne acg02		

		
		; title screen colours
		
		lda #$00
		sta dest_lo
		lda #$b8
		sta dest_hi
		lda #$03
		sta colourcode
		lda #80
		sta blitsize
		jsr colourblit		
		
		lda #$78
		sta dest_lo
		lda #$b8
		sta dest_hi
		lda #$0f
		sta colourcode
		lda #200
		sta blitsize
		jsr colourblit

		lda #$90
		sta dest_lo
		lda #$b9
		sta dest_hi
		lda #$07
		sta colourcode
		lda #200
		sta blitsize
		jsr colourblit

		lda #$a8
		sta dest_lo
		lda #$ba
		sta dest_hi
		lda #$05
		sta colourcode
		lda #200
		sta blitsize
		jsr colourblit		

		lda #$98
		sta dest_lo
		lda #$bb
		sta dest_hi
		lda #$0f
		sta colourcode
		lda #40
		sta blitsize
		jsr colourblit
		
		;lda #$98
		;sta dest_lo
		;lda #$bb
		;sta dest_hi
		;lda #$0f
		;sta colourcode
		;lda #40
		;sta blitsize
		;jsr colourblit

		; menu options text colours

		; red for expl gfx
		lda #$5d
		sta dest_lo
		lda #$b8
		sta dest_hi		

		lda #$02 
		sta colourcode

		lda #02
		sta blitsize

		ldx #00
@	
		jsr colourblit

		lda #40
		jsr addadest		

		inx
		cpx #18
		bne @-
	
		
		lda #23
		sta blitsize
		
		; players txt cols
		lda #$87
		sta dest_lo
		lda #$b8
		sta dest_hi
				
		jsr colourblit

		lda #40
		jsr addadest	
		jsr colourblit

		; keyboard txt cols
		lda #$04 
		sta colourcode
		
		lda #$9f
		sta dest_lo
		lda #$b9
		sta dest_hi

		jsr colourblit

		lda #40
		jsr addadest	
		jsr colourblit

		; start game txt cols
		lda #$0f 
		sta colourcode
		
		lda #$b7
		sta dest_lo
		lda #$ba
		sta dest_hi

		jsr colourblit

		lda #40
		jsr addadest	
		jsr colourblit
		
		;lda #<LAC3C ; LD HL,LAC3C
        ;sta z80_l
        ;lda #>LAC3C
        ;sta z80_h
        ;lda #<LAC4C ; LD DE,LAC4C
        ;sta z80_e
        ;lda #>LAC4C
        ;sta z80_d
        ;lda #<L0010 ; LD BC,L0010
        ;sta z80_c
        ;lda #>L0010
        ;sta z80_b
        ;jsr ldir ; LDIR

		
		;lda #$35 ; IO back in
		;sta $01

		
; loop for drawing and updating menu text menu selection	
LABF9

		;lda #00
		;sta game_select_type 		
		
		jsr player_no_text
		jsr keyboard_text
		jsr gamestart_text

	.if TED_SOUND == 1
		lda #00
		jsr ted_music_play
	.else
		lda #00
		jsr music_play	
	.endif
		
		;start main menu music
		;lda #00
		;jsr music_play
		
						
menuloop
		
		jsr c64waitframe
				
		jsr c64menukeys
		
		lda gameselect
		cmp #01
		beq menu01
		cmp #02
		beq menu02
		cmp #03
		beq menu03

		
		jmp menuloop

menu01

		lda #01
		bit game_select_type
		bne menu01b

		lda #%00000001 
        ora game_select_type
        sta game_select_type
					
		jsr player_no_text
		
		lda #00
		sta gameselect
		jmp menuloop

menu01b		

		lda #%11111110
        and game_select_type
        sta game_select_type
		
		jsr player_no_text
		
		lda #00
		sta gameselect
		jmp menuloop
		
menu02

		lda #02
		bit game_select_type
		bne menu02b

		lda #%00000010 
		
        ora game_select_type
        sta game_select_type
					
		jsr keyboard_text
		
		lda #00
		sta gameselect
		jmp menuloop

menu02b		

		lda #%11111101
	
		and game_select_type
        sta game_select_type
		
		jsr keyboard_text
		
		lda #00
		sta gameselect
		jmp menuloop

menu03		
	
		;start main menu music off
		;lda #09
		;jsr music_play

	; turn music off	
	.if TED_SOUND == 1
		lda #05
		jsr ted_music_play
	.else
		lda #06
		jsr music_play
		lda #02
		sta mpwait
		jsr music_pause_no		
	.endif	
		
		jsr gamestart_text
		
		lda #00
		sta gameselect
		; turn all sprites off
		;sta sprite_on
		
		; play game start music
		;lda #01
		;jsr music_play

		
	.if TED_SOUND == 1
		lda #01
		jsr ted_music_play
		lda #26
		sta mpwait
		jsr music_pause
		
	.else
		lda #01
		jsr music_play
		lda #86
		sta mpwait
		jsr music_pause		
	.endif	
		

	; turn music off	
	.if TED_SOUND == 1
		lda #05
		jsr ted_music_play
	.else
		lda #06
		jsr music_play
		lda #02
		sta mpwait
		jsr music_pause_no		
	.endif		
	
		; turn game start music off
		;lda #00
		;jsr music_play
		
		rts
		
		
;		lda #<LAC4C ; LD IX,LAC4C
;        sta z80_ix
;        lda #>LAC4C
;        sta z80_ix+1
;        lda #$00 ; XOR A
;        sta LA20E ; LD (LA20E),A
;@@55    ldy #$00 ; LD A,(IX+00)
;        lda (z80_ix),y
;        ldx #<LAC5C ; LD BC,LAC5C
;        stx z80_c
;        ldx #>LAC5C
;        stx z80_b
		
		; jump to text draw on menu
        ;jsr LC755 ; CALL LC755 ; uses A as parameter
        		
		;lda #<LA20E ; LD HL,LA20E
        ;sta z80_l
        ;lda #>LA20E
        ;sta z80_h
        ;ldy #$00 ; INC (HL)
        ;lda (z80_hl),y
        ;clc
        ;adc #$01
        ;sta (z80_hl),y
;		inc LA20E
        ;lda #<L0004 ; LD BC,L0004
        ;sta z80_c
        ;lda #>L0004
        ;sta z80_b
        ;jsr add_ix_bc ; ADD IX,BC
;		lda #$04
;		clc
;		adc z80_ix
;		sta z80_ix
;		scc:inc z80_ix+1
        ;lda z80_ix ; PUSH IX
        ;pha
        ;lda z80_ix+1
        ;pha
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;lda #<LAC5C ; LD BC,LAC5C
        ;sta z80_c
        ;lda #>LAC5C
        ;sta z80_b
        ; AND  A
        ;sec
        ;jsr sbc_hl_bc ; SBC HL,BC
				
;		cmp #<LAC5C
;		lda z80_ix+1
;		sbc #>LAC5C
;       jcc @@55 ; JR C,@@55
		
;        jmp LABF9 ; JP LABF9

;LAC21   DB 47,5B,20,31,39,38,35,20 ; G[ 1985 
;AC29    DB 41,5C,43,5C,47,5C,00 ; A\C\G\.

;LAC21   .he 47,5B,20,31,39,38,35,20 ; DB 47,5B,20,31,39,38,35,20
;        .he 41,5C,43,5C,47,5C,00 ; DB 41,5C,43,5C,47,5C,00

;LAC30   DB 45,47,55,4E,20,46,52,49 ; EGUN FRI
;AC38    DB 47,48,54,00 ; GHT.

;LAC30   .he 45,47,55,4E,20,46,52,49 ; DB 45,47,55,4E,20,46,52,49
;        .he 47,48,54,00 ; DB 47,48,54,00

;LAC3C   DB 05,00,00,00,00,00,98,00
;AC44    DB 00,00,60,00,00,00,28,00

;LAC3C   .he 05,00,00,00,00,00,98,00 ; DB 05,00,00,00,00,00,98,00
;        .he 00,00,60,00,00,00,28,00 ; DB 00,00,60,00,00,00,28,00

;LAC4C   DB 08,01,00,FC

;LAC4C   .he 08,01,00,FC ; DB 08,01,00,FC

;LAC50   DB 20,1C,08,00

LAC50   .he 20,1C,08,00 ; DB 20,1C,08,00

;LAC54   DB 00,70,20,0E

LAC54   .he 00,70,20,0E ; DB 00,70,20,0E

;LAC58   DB 04,10,00,E0

LAC58   .he 04,10,00,E0 ; DB 04,10,00,E0

;LAC5C   DW LA446,LA446,LACE0,LACE0
;AC64    DW LACF4,LAC68

LAC5C   .wo LA446,LA446,LACE0,LACE0 ; DW LA446,LA446,LACE0,LACE0
        .wo LACF4,LAC68 ; DW LACF4,LAC68

;AC68    LD IY,LAC50
;AC6C    LD DE,L0004
;AC6F    LD B,03
;@@56    LD A,(IY+00)
;AC74    AND A
;AC75    JR Z,@@63
;AC77    SUB 02
;AC79    CP 03
;AC7B    RET C
;AC7C    ADD IY,DE
;AC7E    DJNZ @@56
;AC80    LD DE,LB0D1
;AC83    CALL LAF74
;AC86    LD DE,LA21C
;AC89    LD A,F7
;AC8B    CALL ReadKey
;AC8E    LD C,A
;AC8F    LD HL,LA20B
;AC92    BIT 0,C
;AC94    JR NZ,@@59
;AC96    LD (HL),00
;@@57    INC HL
;AC99    BIT 1,C
;AC9B    JR NZ,@@60
;AC9D    LD (HL),00
;@@58    INC HL
;ACA0    BIT 2,C
;ACA2    RET Z
;ACA3    LD HL,LA241
;ACA6    INC (HL)
;ACA7    LD DE,LB0C7
;ACAA    CALL LAF8D
;ACAD    LD IY,LAC58
;ACB1    JR @@63

LAC68

		;inc border

		rts
		
;		lda #<LAC50 ; LD IY,LAC50
;        sta z80_iy
;        lda #>LAC50
;        sta z80_iy+1
;        lda #<L0004 ; LD DE,L0004
;        sta z80_e
;        lda #>L0004
;        sta z80_d
;        lda #$03 ; LD B,03
;        sta z80_b
;@@56    ldy #$00 ; LD A,(IY+00)
;        lda (z80_iy),y
;        ; AND  A
;        jeq @@63 ; JR Z,@@63
;        sec ; SUB 02
;        sbc #$02
;        cmp #$03 ; CP 03
;        bcs *+3 ; RET C
;        rts
;        jsr add_iy_de ; ADD IY,DE
;        dec z80_b ; DJNZ @@56
;        jne @@56
;        lda #<LB0D1 ; LD DE,LB0D1
;        sta z80_e
;        lda #>LB0D1
;        sta z80_d
;				
;        jsr LAF74 ; CALL LAF74
;        lda #<game_select_type ; LD DE,LA21C
;        sta z80_e
;        lda #>game_select_type
;        sta z80_d
;        lda #$F7 ; LD A,F7
;        jsr ReadKey ; CALL ReadKey
;        sta z80_c ; LD C,A
;        lda #<LA20B ; LD HL,LA20B
;        sta z80_l
;        lda #>LA20B
;        sta z80_h
;        lda z80_c ; BIT 0,C
;        bit _bitmem0
;        jne @@59 ; JR NZ,@@59
;        lda #$00 ; LD (HL),00
;        ldy #$00
;        sta (z80_hl),y
;@@57    inc z80_l ; INC HL
;        bne *+4
;        inc z80_h
;        lda z80_c ; BIT 1,C
;        bit _bitmem1
;        jne @@60 ; JR NZ,@@60
;        lda #$00 ; LD (HL),00
;        ldy #$00
;        sta (z80_hl),y
;@@58    inc z80_l ; INC HL
;        bne *+4
;        inc z80_h
;        lda z80_c ; BIT 2,C
;        bit _bitmem2
;        bne *+3 ; RET Z
;        rts
        ;lda #<LA241 ; LD HL,LA241
        ;sta z80_l
        ;lda #>LA241
        ;sta z80_h
        ;ldy #$00 ; INC (HL)
        ;lda (z80_hl),y
        ;clc
        ;adc #$01
        ;sta (z80_hl),y
;		inc LA241
;        lda #<LB0C7 ; LD DE,LB0C7
;        sta z80_e
;        lda #>LB0C7
;        sta z80_d
;        jsr LAF8D ; CALL LAF8D
;        lda #<LAC58 ; LD IY,LAC58
;        sta z80_iy
;        lda #>LAC58
;        sta z80_iy+1
;        jmp @@63 ; JR @@63

;@@59    LD A,(HL)
;ACB4    AND A
;ACB5    JR NZ,@@57
;ACB7    LD (HL),01
;ACB9    LD IY,LAC50
;ACBD    LD A,(DE)
;ACBE    XOR 01
;ACC0    LD (DE),A
;ACC1    JR @@63

;@@59    ldy #$00 ; LD A,(HL)
;        lda (z80_hl),y
;        ; AND  A
;        jne @@57 ; JR NZ,@@57
;        lda #$01 ; LD (HL),01
;        ldy #$00
;        sta (z80_hl),y
;        lda #<LAC50 ; LD IY,LAC50
;        sta z80_iy
;        lda #>LAC50
;        sta z80_iy+1
;        ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        eor #$01 ; XOR 01
;        ldy #$00 ; LD (DE),A
;        sta (z80_de),y
;        jmp @@63 ; JR @@63

;@@60    LD A,(HL)
;ACC4    AND A
;ACC5    JR NZ,@@58
;ACC7    LD (HL),01
;ACC9    LD IY,LAC54
;ACCD    LD A,(DE)
;ACCE    ADD A,02
;ACD0    AND 07
;ACD2    LD (DE),A
;@@63    LD (IY+00),02
;ACD7    LD (IY+01),48
;ACDB    LD (IY+03),00
;ACDF    RET

;@@60    ldy #$00 ; LD A,(HL)
;        lda (z80_hl),y
;        ; AND  A
;        jne @@58 ; JR NZ,@@58
;        lda #$01 ; LD (HL),01
;        ldy #$00
;        sta (z80_hl),y
;        lda #<LAC54 ; LD IY,LAC54
;        sta z80_iy
;        lda #>LAC54
;        sta z80_iy+1
;        ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        clc ; ADD A,02
;        adc #$02
;        and #$07 ; AND 07
;        ldy #$00 ; LD (DE),A
;        sta (z80_de),y
;@@63    ldy #$00 ; LD (IY+00),02
;        lda #$02
;        sta (z80_iy),y
;        ldy #$01 ; LD (IY+01),48
;        lda #$48
;        sta (z80_iy),y
;        ldy #$03 ; LD (IY+03),00
;        lda #$00
;        sta (z80_iy),y
;        rts ; RET

;ACE0    CALL LAE0E
;ACE3    INC (IX+03)
;ACE6    LD A,(IX+03)
;ACE9    CP 0C
;ACEB    RET NZ
;ACEC    INC (IX+00)
;ACEF    LD (IX+03),00
;ACF3    RET

LACE0

		;inc border

		rts
		
;		jsr LAE0E ; CALL LAE0E
;        ldy #$03 ; INC (IX+03)
;        lda (z80_ix),y
;        clc
;        adc #$01
;        sta (z80_ix),y
;        ldy #$03 ; LD A,(IX+03)
;        lda (z80_ix),y
;        cmp #$0C ; CP 0C
;        beq *+3 ; RET NZ
;        rts
;        ldy #$00 ; INC (IX+00)
;        lda (z80_ix),y
;        clc
;        adc #$01
;        sta (z80_ix),y
;        ldy #$03 ; LD (IX+03),00
;        lda #$00
;        sta (z80_ix),y
;        rts ; RET

;ACF4    LD A,(IX+01)
;ACF7    ADD A,02
;ACF9    LD (IX+01),A
;ACFC    CP F8
;ACFE    JP NC,LAD6D
;AD01    CALL LAE0E
;AD04    CALL LAF55
;AD07    LD A,(LA20E)
;AD0A    DEC A
;AD0B    JR Z,@@64
;AD0D    DEC A
;AD0E    JR Z,@@68
;AD10    LD A,47
;AD12    EX AF,AF'
;AD13    LD HL,LADD7
;AD16    JR @@66

; draw menu options graphics
LACF4

		rts

;		ldy #$01 ; LD A,(IX+01)
;        lda (z80_ix),y
;        clc ; ADD A,02
;        adc #$02
;        ldy #$01 ; LD (IX+01),A
;        sta (z80_ix),y
;        cmp #$F8 ; CP F8
;        jcs LAD6D ; JP NC,LAD6D
;		
;		; bullet across screen
;		jsr LAE0E ; CALL LAE0E
;		
;        jsr LAF55 ; CALL LAF55
;        lda LA20E ; LD A,(LA20E)
;        sec ; DEC A
;        sbc #$01
;        jeq @@64 ; JR Z,@@64
;        sec ; DEC A
;        sbc #$01
;        jeq @@68 ; JR Z,@@68
;        lda #$47 ; LD A,47
;        ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa ;
;
;		;start game txt
;        lda #<LADD7 ; LD HL,LADD7
;        sta z80_l
;        lda #>LADD7
;        sta z80_h
;        jmp @@66 ; JR @@66
;
;;@@64    LD A,42
;;AD1A    EX AF,AF'
;;AD1B    LD A,(LA21C)
;;AD1E    AND 01
;;AD20    LD BC,LAD79
;;@@65    CALL LC74B
;@@66    LD A,(IX+01)
;AD29    SUB 08
;AD2B    LD E,A
;AD2C    LD A,(IX+02)
;AD2F    ADD A,0F
;AD31    LD D,A
;AD32    BIT 7,(IX+03)
;AD36    RET NZ
;AD37    LD A,E
;AD38    AND 06
;AD3A    RET NZ
;AD3B    LD A,E
;AD3C    SUB 58
;AD3E    RET C
;AD3F    RRCA
;AD40    RRCA
;AD41    RRCA
;AD42    AND 1F
;AD44    CALL LD26E
;AD47    EX DE,HL
;AD48    CALL LD248
;AD4B    LD A,(DE)
;AD4C    BIT 7,A
;AD4E    JR Z,@@67
;AD50    AND 7F
;AD52    SET 7,(IX+03)
;@@67    CALL LD4E3
;AD59    LD BC,L8EA8
;AD5C    JP LD2C2

;@@64    lda #$42 ; LD A,42
;        ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa 
;        lda game_select_type ; LD A,(LA21C)
;        and #$01 ; AND 01
;        ldx #<LAD79 ; LD BC,LAD79
;        stx z80_c
;        ldx #>LAD79
;        stx z80_b
;@@65    jsr LC74B ; CALL LC74B ; uses A as parameter
;@@66    ldy #$01 ; LD A,(IX+01)
;        lda (z80_ix),y
;        sec ; SUB 08
;        sbc #$08
;        sta z80_e ; LD E,A
;        ldy #$02 ; LD A,(IX+02)
;        lda (z80_ix),y
;        clc ; ADD A,0F
;        adc #$0F
;        sta z80_d ; LD D,A
;        ldy #$03 ; BIT 7,(IX+03)
;        lda (z80_ix),y
;        bit _bitmem7
;        beq *+3 ; RET NZ
;        rts
;        lda z80_e ; LD A,E
;        and #$06 ; AND 06
;        beq *+3 ; RET NZ
;        rts
;        lda z80_e ; LD A,E
;        sec ; SUB 58
;        sbc #$58
;        bcs *+3 ; RET C
;        rts
;        lsr @ ; RRCA
;        lsr @ ; RRCA
;        lsr @ ; RRCA
;        and #$1F ; AND 1F
;        jsr LD26E ; CALL LD26E
;        jsr ex_de_hl ; EX DE,HL
;        jsr LD248 ; CALL LD248
;        ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        bit _bitmem7 ; BIT 7,A
;        jeq @@67 ; JR Z,@@67
;        and #$7F ; AND 7F
;        tax
;        ldy #$03 ; SET 7,(IX+03)
;        lda (z80_ix),y
;        ora #_bitvalue7
;        sta (z80_ix),y
;        txa
;@@67    jsr LD4E3 ; CALL LD4E3 ; uses A as parameter
;        ldx #<L8EA8 ; LD BC,L8EA8
;        stx z80_c
;        ldx #>L8EA8
;        stx z80_b
;        jmp LD2C2 ; JP LD2C2 ; uses A as parameter

;@@68    LD A,43
;AD61    EX AF,AF'
;AD62    LD A,(LA21C)
;AD65    RRCA
;AD66    AND 03
;AD68    LD BC,LAD9B
;AD6B    JR @@65

; menu text
;@@68    lda #$43 ; LD A,43
;        ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa 
;        lda game_select_type ; LD A,(LA21C)
;        lsr @ ; RRCA
;        and #$03 ; AND 03
;        ldx #<LAD9B ; LD BC,LAD9B
;        stx z80_c
;        ldx #>LAD9B
;        stx z80_b
;        jmp @@65 ; JR @@65 ; A must be preserved

;LAD6D   LD (IX+00),01
;AD71    LD A,(LA241)
;AD74    AND A
;AD75    RET Z
;AD76    INC SP
;AD77    INC SP
;AD78    RET

;LAD6D   
;
;		rts
		
;		ldy #$00 ; LD (IX+00),01
;        lda #$01
;        sta (z80_ix),y
;        lda LA241 ; LD A,(LA241)
;        ; AND  A
;        bne *+3 ; RET Z
;        rts
;        pla ; INC SP
;        pla ; INC SP
;        rts ; RET

;LAD79   DW LAD7D,LAD8C

;LAD79   .wo LAD7D,LAD8C ; DW LAD7D,LAD8C

;LAD7D   DB 4F,4E,45,20,50,4C,41,59 ; ONE PLAY
;AD85    DB 45,52,20,47,41,4D,C5 ; ER GAM.

;LAD7D   .he 4F,4E,45,20,50,4C,41,59 ; DB 4F,4E,45,20,50,4C,41,59
;        .he 45,52,20,47,41,4D,C5 ; DB 45,52,20,47,41,4D,C5

;LAD8C   DB 54,57,4F,20,50,4C,41,59 ; TWO PLAY
;AD94    DB 45,52,20,47,41,4D,C5 ; ER GAM.

;LAD8C   .he 54,57,4F,20,50,4C,41,59 ; DB 54,57,4F,20,50,4C,41,59
;        .he 45,52,20,47,41,4D,C5 ; DB 45,52,20,47,41,4D,C5

;LAD9B   DW LADA3,LADAB,LADBC,LADCB

;LAD9B   .wo LADA3,LADAB,LADBC,LADCB ; DW LADA3,LADAB,LADBC,LADCB

;LADA3   DB 4B,45,59,42,4F,41,52,C4 ; KEYBOAR.

;LADA3   .he 4B,45,59,42,4F,41,52,C4 ; DB 4B,45,59,42,4F,41,52,C4

;LADAB   DB 4B,45,4D,50,53,54,4F,4E ; KEMPSTON
;ADB3    DB 20,4A,4F,59,53,54,49,43 ;  JOYSTIC
;ADBB    DB CB

;LADAB   .he 4B,45,4D,50,53,54,4F,4E ; DB 4B,45,4D,50,53,54,4F,4E
;        .he 20,4A,4F,59,53,54,49,43 ; DB 20,4A,4F,59,53,54,49,43
;        .he CB ; DB CB

;LADBC   DB 43,55,52,53,4F,52,20,4A ; CURSOR J
;ADC4    DB 4F,59,53,54,49,43,CB ; OYSTIC.

;LADBC   .he 43,55,52,53,4F,52,20,4A ; DB 43,55,52,53,4F,52,20,4A
;        .he 4F,59,53,54,49,43,CB ; DB 4F,59,53,54,49,43,CB

;LADCB   DB 49,4E,54,45,52,46,41,43 ; INTERFAC
;ADD3    DB 45,20,49,C9 ; E I.

;LADCB   .he 49,4E,54,45,52,46,41,43 ; DB 49,4E,54,45,52,46,41,43
;        .he 45,20,49,C9 ; DB 45,20,49,C9

;LADD7   DB 53,54,41,52,54,20,47,41 ; START GA
;ADDF    DB 4D,C5

;LADD7   .he 53,54,41,52,54,20,47,41 ; DB 53,54,41,52,54,20,47,41
;        .he 4D,C5 ; DB 4D,C5

;LADE1   EX AF,AF'
;ADE2    LD DE,LADEB
;ADE5    LD BC,L0705
;ADE8    JP LD58E

;LADE1   ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
        ;txa 
;        lda #<LADEB ; LD DE,LADEB
;        sta z80_e
;        lda #>LADEB
;        sta z80_d
;        lda #<L0705 ; LD BC,L0705
;        sta z80_c
;        lda #>L0705
;        sta z80_b
;        jmp LD58E ; JP LD58E

;LADEB   DB 01,02,03,04,05,06,07,08
;ADF3    DB 09,0A,0B,0C,0D,0E,0F,10
;ADFB    DB 11,12,13,00,00,14,15,16
;AE03    DB 17,00,00,00,18,19,1A,00
;AE0B    DB 00,00,00

;LADEB   .he 01,02,03,04,05,06,07,08 ; DB 01,02,03,04,05,06,07,08
;        .he 09,0A,0B,0C,0D,0E,0F,10 ; DB 09,0A,0B,0C,0D,0E,0F,10
;        .he 11,12,13,00,00,14,15,16 ; DB 11,12,13,00,00,14,15,16
;        .he 17,00,00,00,18,19,1A,00 ; DB 17,00,00,00,18,19,1A,00
;        .he 00,00,00 ; DB 00,00,00

;LAE0E   LD A,(IX+00)
;AE11    LD BC,L6864
;AE14    CALL LC74B
;AE17    LD A,(HL)
;AE18    INC HL
;AE19    EX AF,AF'
;AE1A    EX DE,HL
;AE1B    LD A,(IX+01)
;AE1E    LD L,A
;AE1F    LD H,(IX+02)
;AE22    CALL LD248
;AE25    LD (LA21D),SP
;AE29    EX DE,HL
;AE2A    LD SP,HL
;AE2B    LD A,(IX+01)
;AE2E    AND 06
;AE30    JR Z,@@73
;AE32    OR F8
;AE34    LD H,A
;AE35    EX AF,AF'
;@@69    EX AF,AF'
;AE37    POP BC
;AE38    LD L,C
;AE39    LD A,(HL)
;AE3A    LD (DE),A
;AE3B    INC E
;AE3C    INC H
;AE3D    LD A,(HL)
;AE3E    DEC H
;AE3F    LD L,B
;AE40    OR (HL)
;AE41    LD (DE),A
;AE42    INC E
;AE43    INC H
;AE44    LD A,(HL)
;AE45    DEC H
;AE46    LD (DE),A
;AE47    DEC E
;AE48    DEC E
;AE49    DEC D
;AE4A    LD A,D
;AE4B    INC A
;AE4C    AND 07
;AE4E    JR NZ,@@70
;AE50    LD A,E
;AE51    SUB 20
;AE53    LD E,A
;AE54    JR C,@@70
;AE56    LD A,D
;AE57    ADD A,08
;AE59    LD D,A
;@@70    EX AF,AF'
;AE5B    DEC A
;AE5C    JR NZ,@@69
;@@72    LD SP,(LA21D)
;AE62    RET

		
;		ldy #$00 ; LD A,(IX+00)
;        lda (z80_ix),y
;        ldx #<L6864 ; LD BC,L6864
;        stx z80_c
;        ldx #>L6864
;        stx z80_b
;        jsr LC74B ; CALL LC74B ; uses A as parameter
;        ldy #$00 ; LD A,(HL)
;        lda (z80_hl),y
;        inc z80_l ; INC HL
;        bne *+4
;        inc z80_h
;        ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa ; 
;        jsr ex_de_hl ; EX DE,HL
;        ldy #$01 ; LD A,(IX+01)
;        lda (z80_ix),y
;        sta z80_l ; LD L,A
;        ldy #$02 ; LD H,(IX+02)
;        lda (z80_ix),y
;        sta z80_h
;        jsr LD248 ; CALL LD248
;        ; LD (LA21D),SP ; LD (LA21D),SP
;        jsr ex_de_hl ; EX DE,HL
;        ; LD SP,HL ; LD SP,HL
;		lda z80_l
;		sta z80_sp
;		lda z80_h
;		sta z80_sp+1
;        ldy #$01 ; LD A,(IX+01)
;        lda (z80_ix),y
;        and #$06 ; AND 06
;        jeq @@73 ; JR Z,@@73
;        ;ora #$F8 ; OR F8; address of lookup table
;        ora #>[RotationTable+$800]
;        sta z80_h ; LD H,A
;        ;ldx z80_ap ; EX AF,AF'
;        ;sta z80_ap
;        ;txa ; 
;		lda z80_ap
;@@69    ;ldx z80_ap ; EX AF,AF'
;        ;sta z80_ap
;        ;txa ; TODO: EX   AF,AF'
;		sta z80_ap
;		
;        ;pla ; POP BC
;        ;sta z80_b
;        ;pla
;        ;sta z80_c
;		ldy #$00
;		lda (z80_sp),y
;		sta z80_c
;		iny
;		lda (z80_sp),y
;		sta z80_b
;		lda #$02
;		clc
;		adc z80_sp
;		sta z80_sp
;		scc:inc z80_sp+1		
;        lda z80_c ; LD L,C
;        sta z80_l
;        ldy #$00 ; LD A,(HL)
;        lda (z80_hl),y
;        ldy #$00 ; LD (DE),A
;        sta (z80_de),y
;        inc z80_e ; INC E
;        inc z80_h ; INC H
;        ldy #$00 ; LD A,(HL)
;        lda (z80_hl),y
;        dec z80_h ; DEC H
;        ldx z80_b ; LD L,B
;        stx z80_l
;        ldy #$00 ; OR (HL)
;        ora (z80_hl),y; 
;        ldy #$00 ; LD (DE),A
;        sta (z80_de),y
;        inc z80_e ; INC E
;        inc z80_h ; INC H
;        ldy #$00 ; LD A,(HL)
;        lda (z80_hl),y
;        dec z80_h ; DEC H
;        ldy #$00 ; LD (DE),A
;        sta (z80_de),y; 
;        dec z80_e ; DEC E
;        dec z80_e ; DEC E
;        dec z80_d ; DEC D
;        lda z80_d ; LD A,D
;        clc ; INC A
;        adc #$01
;        and #$07 ; AND 07
;        jne @@70 ; JR NZ,@@70
;        lda z80_e ; LD A,E
;        sec ; SUB 20
;        sbc #$20
;        sta z80_e ; LD E,A
;        jcc @@70 ; JR C,@@70; 
;        lda z80_d ; LD A,D
;        clc ; ADD A,08
;        adc #$08
;        sta z80_d ; LD D,A
;@@70    ;ldx z80_ap ; EX AF,AF'
;        ;sta z80_ap
;        ;txa ; 
;		lda z80_ap
;        sec ; DEC A
;        sbc #$01
;        jne @@69 ; JR NZ,@@69
;@@72    ; LD SP,(LA21D): TODO  ; LD SP,(LA21D)
;        rts ; RET

;@@73    EX AF,AF'
;AE64    LD B,A
;AE65    EX DE,HL
;@@74    POP DE
;AE67    LD (HL),E
;AE68    INC L
;AE69    LD (HL),D
;AE6A    DEC L
;AE6B    DEC H
;AE6C    LD A,H
;AE6D    INC A
;AE6E    AND 07
;AE70    JR NZ,@@75
;AE72    LD A,L
;AE73    SUB 20
;AE75    LD L,A
;AE76    JR C,@@75
;AE78    LD A,H
;AE79    ADD A,08
;AE7B    LD H,A
;@@75    DJNZ @@74
;AE7E    JR @@72

;@@73    ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        txa ; 
;        sta z80_b ; LD B,A
;        jsr ex_de_hl ; EX DE,HL
;@@74    ;pla ; POP DE
;        ;sta z80_d
;        ;pla
;        ;sta z80_e
;		ldy #$00
;		lda (z80_sp),y
;		sta z80_e
;		iny
;		lda (z80_sp),y
;		sta z80_d
;		lda #$02
;		clc
;		adc z80_sp
;		sta z80_sp
;		scc:inc z80_sp+1		
;		
;        lda z80_e ; LD (HL),E
;        ldy #$00
;        sta (z80_hl),y
;        inc z80_l ; INC L
;        lda z80_d ; LD (HL),D
;        ldy #$00
;        sta (z80_hl),y
;        dec z80_l ; DEC L
;        dec z80_h ; DEC H
;        lda z80_h ; LD A,H
;        clc ; INC A
;        adc #$01
;        and #$07 ; AND 07
;        jne @@75 ; JR NZ,@@75
;        lda z80_l ; LD A,L
;        sec ; SUB 20
;        sbc #$20
;        sta z80_l ; LD L,A
;        jcc @@75 ; JR C,@@75
;        lda z80_h ; LD A,H
;        clc ; ADD A,08
;        adc #$08
;        sta z80_h ; LD H,A
;@@75    dec z80_b ; DJNZ @@74
;        jne @@74
;        jmp @@72 ; JR @@72

;LAE80   CALL LAE86
;AE83    DJNZ LAE80
;AE85    RET

; goes here after 2 player game after player number displayed, bonus display, hi-score (not game over)
LAE80
		
		ldx #30
		
LAE80_b		
		;jsr LAE86 ; CALL LAE86
        ;dec z80_b ; DJNZ LAE80
        ;jne LAE80_b
		
		jsr c64waitframe
		dex
		bne LAE80_b
		
		dec z80_b
		jne LAE80
		
        rts ; RET

;LAE86   DEC HL
;AE87    LD A,H
;AE88    OR L
;AE89    JR NZ,LAE86
;AE8B    RET

; old pause
;LAE86   jsr dec_hl ; DEC HL
;        lda z80_h ; LD A,H
;        ora z80_l ; OR L
;        jne LAE86 ; JR NZ,LAE86
;        rts ; RET


;LAE8C   LD B,18
;AE8E    LD DE,L0020
;@@79    LD (HL),C
;AE92    ADD HL,DE
;AE93    DJNZ @@79
;AE95    RET

;LAE8C   lda #$18 ; LD B,18
;        sta z80_b
;        lda #<L0020 ; LD DE,L0020
;        sta z80_e
;        lda #>L0020
;        sta z80_d
;@@79    lda z80_c ; LD (HL),C
;        ldy #$00
;        sta (z80_hl),y
;        jsr add_hl_de ; ADD HL,DE
;        dec z80_b ; DJNZ @@79
;        jne @@79
;        rts ; RET

;LAE96   LD HL,L0000
;AE99    LD C,80
;@@80    LD A,(HL)
;AE9C    INC HL
;AE9D    AND 3F
;AE9F    LD B,A
;AEA0    CALL LAF64
;AEA3    DEC C
;AEA4    JR NZ,@@80
;AEA6    RET

LAE96   lda #<Rom_page_zero ; LD HL,L0000
        sta z80_l
        lda #>Rom_page_zero
        sta z80_h
        lda #$80 ; LD C,80
        sta z80_c
@@80    ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        and #$3F ; AND 3F
        sta z80_b ; LD B,A
		
		; bandit hits you in draw! screen sfx
		
	.if TED_SOUND == 1
		lda #08
		jsr ted_music_play
	.else
		lda #<sfxshoot     ;Start address of sound effect data
        ldy #>sfxshoot 
        ldx #00             ;0, 7 or 14 for channels 1-3
        jsr sfx_play 	
	.endif		
				
		;lda #<sfxshoot      ;Start address of sound effect data
        ;ldy #>sfxshoot 
        ;ldx #00            ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 
		
        ;jsr LAF64 ; CALL LAF64
        ;dec z80_c ; DEC C
        ;jne @@80 ; JR NZ,@@80
        rts ; RET

;LAEA7   LD HL,LA23C
;AEAA    LD A,(HL)
;AEAB    AND A
;AEAC    RET Z
;AEAD    DEC (HL)
;AEAE    INC HL
;AEAF    LD E,(HL)
;AEB0    INC HL
;AEB1    LD D,(HL)
;AEB2    EX DE,HL
;AEB3    CALL LD26E
;AEB6    LD A,(HL)
;AEB7    LD B,A
;AEB8    LD C,0C
;AEBA    JP LAF5D

LAEA7   ;lda #<LA23C ; LD HL,LA23C
        ;sta z80_l
        ;lda #>LA23C
        ;sta z80_h
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		lda LA23C
        sta z80_a
		
        ; AND  A
        bne *+3 ; RET Z
        rts
        ;ldy #$00 ; DEC (HL)
        ;lda (z80_hl),y
        ;sec

        ;sbc #$01
        ;sta (z80_hl),y
		dec LA23C
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ;ldy #$00 ; LD E,(HL)
        ;lda (z80_hl),y
        ;sta z80_e
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ;ldy #$00 ; LD D,(HL)
        ;lda (z80_hl),y
        ;sta z80_d
        ;jsr ex_de_hl ; EX DE,HL
		
;		lda LA23D
;		sta z80_l
;		lda LA23D+1
;		sta z80_h
        
		;lda z80_a
        ;jsr AddAToHL ; CALL LD26E ; uses A as parameter
        ;ldy #$00 ; LD A,(HL)
		
		ldy z80_a
;        lda (z80_hl),y

		lda game_on
		beq play_bonus

		cpy #08
		bcc playonce
		
		;money bag hit 04 & mount horse 08 & pick up money bag 08 sfx

	.if TED_SOUND == 1
		lda #07
		jsr ted_music_play
		lda on_horse
		beq playonce
		lda #00
		sta on_horse
	.else
			
		lda #<sfxhorse       ;Start address of sound effect data
        ldy #>sfxhorse 
        ldx #07           ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e 		

		lda on_horse
		beq playonce
		
		;lda #06
		;jsr music_play
			
		lda #00
		sta on_horse
				
		
	.endif		
		
		jmp playonce
		
play_bonus
		
		cpy #04
		bcc playonce
		
		;money bag hit 04 & mount horse 08 & pick up money bag 08 sfx

	.if TED_SOUND == 1
		lda #10
		jsr ted_music_play
	.else
		lda #<sfxexpl     ;Start address of sound effect data
        ldy #>sfxexpl 
        ldx #14             ;0, 7 or 14 for channels 1-3
        jsr sfx_play 	
	.endif			
		
		;lda #<sfxexpl      ;Start address of sound effect data
        ;ldy #>sfxexpl  
        ;ldx #14             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 		

playonce		
		; *** RTS ADDED ***
		rts
		
        ;sta z80_b ; LD B,A
        ;lda #$0C ; LD C,0C
        ;sta z80_c
        ;jmp LAF5D ; JP LAF5D

;LAEBD   DB 20,30,40,50,60,50,40,80 ;  0@P.P@.

LAEBD   .he 20,30,40,50,60,50,40,80 ; DB 20,30,40,50,60,50,40,80

;LAEC5   DB 20,A0,30,90,40,80,50,60 ;  .0.@.P.

LAEC5   .he 20,A0,30,90,40,80,50,60 ; DB 20,A0,30,90,40,80,50,60

;LAECD   DB 2C,28,24,20 ; ,($ 

LAECD   .he 2C,28,24,20 ; DB 2C,28,24,20

;LAED1   BIT 0,A
;AED3    RET NZ
;AED4    BIT 0,(IX+07)
;AED8    RET Z
;AED9    BIT 1,(IX+07)
;AEDD    RET Z
;AEDE    LD C,10
;@@81    LD A,C
;AEE1    XOR 76
;AEE3    LD B,A
;AEE4    CALL LAF64
;AEE7    DEC C
;AEE8    JR NZ,@@81
;AEEA    RET

LAED1   bit _bitmem0 ; BIT 0,A
        beq *+3 ; RET NZ
        rts
        ldy #$07 ; BIT 0,(IX+07)
        lda (z80_ix),y
        bit _bitmem0
        bne *+3 ; RET Z
        rts
        ;ldy #$07 ; BIT 1,(IX+07)
        ;lda (z80_ix),y
        bit _bitmem1
        bne *+3 ; RET Z
        rts
        
;	     lda #$10 ; LD C,10
;        sta z80_c
;@@81    lda z80_c ; LD A,C
;        eor #$76 ; XOR 76
;        sta z80_b ; LD B,A
		
		; people turn and bump into wall sfx

	.if TED_SOUND == 1
		lda #09
		jsr ted_music_play
	.else
		lda #<sfxbounce     ;Start address of sound effect data
        ldy #>sfxbounce 
        ldx #07             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e 	
	.endif
		
		;lda #<sfxbounce     ;Start address of sound effect data
        ;ldy #>sfxbounce 
        ;ldx #00             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 		
		
		
        ;jsr LAF64 ; CALL LAF64
        ;dec z80_c ; DEC C
        ;jne @@81 ; JR NZ,@@81
        
		rts ; RET

;LAEEB   LD HL,LA207
;AEEE    INC (HL)
;AEEF    LD A,(IX+05)
;AEF2    CP 0C
;AEF4    JR NC,@@83
;AEF6    LD A,(HL)
;AEF7    BIT 2,A
;AEF9    JR Z,@@82
;AEFB    AND 03
;AEFD    RET NZ
;AEFE    LD BC,L4004
;AF01    JR LAF5D

; Warning: footstep?
LAEEB   ;rts
		;lda #<LA207 ; LD HL,LA207
        ;sta z80_l
        ;lda #>LA207
        ;sta z80_h
        ;ldy #$00 ; INC (HL)
        ;lda (z80_hl),y
        ;clc

        ;adc #$01
        ;sta (z80_hl),y
		inc LA207
        ldy #$05 ; LD A,(IX+05)
        lda (z80_ix),y
        cmp #$0C ; CP 0C
        jcs @@83 ; JR NC,@@83
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		lda LA207
        bit _bitmem2 ; BIT 2,A
        jeq @@82 ; JR Z,@@82
        and #$03 ; AND 03
        beq *+3 ; RET NZ
        rts
        ;lda #<$4004 ; LD BC,4004 ; sound parameter
        ;sta z80_c
        ;lda #>$4004
        ;sta z80_b
		
		; walk 1 sfx

	.if TED_SOUND == 1
		lda #06
		jsr ted_music_play
	.else
		lda #<sfxwalk1     ;Start address of sound effect data
        ldy #>sfxwalk1 
        ldx #00             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e 	
	.endif
		
		;lda #<sfxwalk1     ;Start address of sound effect data
        ;ldy #>sfxwalk1 
        ;ldx #00             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 		
		
		; *** rts added ***
		rts
		
        ;jmp LAF5D ; JR LAF5D ; PlaySound

;@@82    AND 03
;AF05    RET NZ
;AF06    LD BC,L6004
;AF09    JR LAF5D

		; walk 2 sfx
@@82    and #$03 ; AND 03
        beq *+3 ; RET NZ
        rts
        ;lda #<$6004 ; LD BC,L6004 ; sound parameter
        ;sta z80_c
        ;lda #>$6004
        ;sta z80_b
	
		; walk sfx

	.if TED_SOUND == 1
		lda #06
		jsr ted_music_play
	.else
		lda #<sfxwalk1     ;Start address of sound effect data
        ldy #>sfxwalk1 
        ldx #00             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e	
	.endif		
		
		;lda #<sfxwalk1     ;Start address of sound effect data
        ;ldy #>sfxwalk1 
        ;ldx #00             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 
		
		; *** rts added ***
		rts
		
        ;jmp LAF5D ; JR LAF5D ; PlaySound

;@@83    LD A,(HL)
;AF0C    BIT 1,A
;AF0E    JR Z,@@84
;AF10    AND 01
;AF12    RET NZ
;AF13    LD BC,L4004
;AF16    JR LAF5D


@@83    ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		lda LA207
        bit _bitmem1 ; BIT 1,A
        jeq @@84 ; JR Z,@@84
        and #$01 ; AND 01
        beq *+3 ; RET NZ
        rts
        ;lda #<$4004 ; LD BC,4004 ; sound parameter
        ;sta z80_c
        ;lda #>$4004
        ;sta z80_b
		
		; horse1 walk sfx

	.if TED_SOUND == 1
		lda #06
		jsr ted_music_play
	.else
		lda #<sfxwalk1     ;Start address of sound effect data
        ldy #>sfxwalk1 
        ldx #00             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e 	
	.endif		
		
		;lda #<sfxwalk1     ;Start address of sound effect data
        ;ldy #>sfxwalk1 
        ;ldx #00             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 	
		
		; *** rts added ***
		rts
		
        ;jmp LAF5D ; JR LAF5D ; PlaySound

;@@84    AND 01
;AF1A    RET NZ
;AF1B    LD BC,L6004
;AF1E    JR LAF5D

@@84    and #$01 ; AND 01
        beq *+3 ; RET NZ
        rts
        ;lda #<$6004 ; LD BC,L6004 ; sound parameter
        ;sta z80_c
        ;lda #>$6004
        ;sta z80_b
		
		; horse2 walk sfx

	.if TED_SOUND == 1
		lda #06
		jsr ted_music_play
	.else
		lda #<sfxwalk1     ;Start address of sound effect data
        ldy #>sfxwalk1 
        ldx #00             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e 	
	.endif		
		
		;lda #<sfxwalk1     ;Start address of sound effect data
        ;ldy #>sfxwalk1 
        ;ldx #00             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 			
		
		; *** ADDED RTS ***
		rts
		
        ;jmp LAF5D ; JR LAF5D; PlaySound

;LAF20   LD C,0C
;@@85    LD A,C
;AF23    XOR A5
;AF25    ADD A,C
;AF26    LD B,A
;AF27    CALL LAF64
;AF2A    DEC C
;AF2B    JR NZ,@@85
;AF2D    RET

LAF20   ;lda #$0C ; LD C,0C
        ;sta z80_c
@@85    ;lda z80_c ; LD A,C
        ;eor #$A5 ; XOR A5
        ;clc ; ADD A,C
        ;adc z80_c
        ;sta z80_b ; LD B,A
		
		;re-load bullets sfx

	.if TED_SOUND == 1
		lda #13
		jsr ted_music_play
	.else
		;re-load bullets sfx

		lda #<sfxreload    ;Start address of sound effect data
        ldy #>sfxreload
        ;ldx #14             ;0, 7 or 14 for channels 1-3

		ldx game_on
		bne @+
		ldx #14
		jsr sfx_play
		jmp move_on_expl
@
		ldx #14
		jsr sfx_play_e         

move_on_expl 	
	.endif			
		
		;lda #<sfxreload    ;Start address of sound effect data
        ;ldy #>sfxreload
        ;ldx #14             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 	
		
        ;jsr LAF64 ; CALL LAF64
        ;dec z80_c ; DEC C
        ;jne @@85 ; JR NZ,@@85
		
	.if TED_SOUND == 1
		inc sfx_count_002
		lda sfx_count_002
		cmp #06
		bcs @+
		
		; *** rts added ***
		rts
@
		; turn sound off
		
		lda game_on
		beq @+
		
		lda #08
		jsr ted_music_play
@
		lda #00
		sta sfx_count_002
		
	.endif
		
        rts ; RET

;LAF2E   LD HL,L0000
;AF31    LD E,10
;@@86    LD A,(HL)
;AF34    INC HL
;AF35    AND 7F
;AF37    LD B,A
;AF38    LD C,02
;AF3A    CALL LAF5D
;AF3D    DEC E
;AF3E    JR NZ,@@86
;AF40    RET

LAF2E   lda #<Rom_page_zero ; LD HL,L0000
        sta z80_l
        lda #>Rom_page_zero
        sta z80_h
        lda #$10 ; LD E,10
        sta z80_e
@@86    ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        and #$7F ; AND 7F
        sta z80_b ; LD B,A
        lda #$02 ; LD C,02
        sta z80_c
		
		; fire sfx

	.if TED_SOUND == 1
		lda #08
		jsr ted_music_play
	.else
		
		lda #<sfxshoot      ;Start address of sound effect data
        ldy #>sfxshoot 
        ;ldx #14             ;0, 7 or 14 for channels 1-3
        
		ldx game_on
		bne @+
		ldx #14
		jsr sfx_play
		jmp move_on_fire
@		
		ldx #14
		jsr sfx_play_e 

move_on_fire	
	.endif
		
		;lda #<sfxshoot      ;Start address of sound effect data
        ;ldy #>sfxshoot 
        ;ldx #14             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 
		
        ;jsr LAF5D ; CALL LAF5D
        ;dec z80_e ; DEC E
        ;jne @@86 ; JR NZ,@@86
        rts ; RET

;LAF41   LD C,08
;AF43    LD B,60
;AF45    JR LAF5D

LAF41   ;lda #$08 ; LD C,08
        ;sta z80_c
        ;lda #$60 ; LD B,60
        ;sta z80_b
		
		;telegram sfx

	.if TED_SOUND == 1
		lda #06 ;#12
		jsr ted_music_play
	.else
		lda #<sfxtelegram     ;Start address of sound effect data
        ldy #>sfxtelegram 
        ldx #07             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e 	
	.endif
		
		;lda #<sfxtelegram     ;Start address of sound effect data
        ;ldy #>sfxtelegram
        ;ldx #07             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 
				
		rts
		
        ;jmp LAF5D ; JR LAF5D

;LAF47   LD C,10
;AF49    LD B,80
;AF4B    JR LAF5D


; not used
;LAF47   lda #$10 ; LD C,10
;        sta z80_c
;        lda #$80 ; LD B,80
;        sta z80_b
		
		;??? sfx
;		jmp LAF5D ; JR LAF5D

;LAF4D   ADD A,A
;AF4E    ADD A,A
;AF4F    CPL
;AF50    LD B,A
;AF51    LD C,04
;AF53    JR LAF5D

LAF4D   ;asl @ ; ADD A,A
        ;asl @ ; ADD A,A
        ;eor #$ff ; CPL
        ;sta z80_b ; LD B,A
        ;lda #$04 ; LD C,04
        ;sta z80_c
		
		; dont play man gen music at all
		lda generate_man
		beq not_generate_man_sfx
		
		; only play man gen music once (flag cleared when man dies)
		cmp #01
		bne not_generate_man_sfx
		
	.if TED_SOUND == 0
		lda #06
		jsr music_play
		lda #02
		sta mpwait
		jsr music_pause_no
	.endif
	
not_generate_man_sfx
		
		; die, people die, generate sfx

	.if TED_SOUND == 1
		lda #06
		jsr ted_music_play
	.else
		lda #<sfxwalk1     ;Start address of sound effect data
        ldy #>sfxwalk1 
        ldx #07             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e 	
	.endif
		
		;lda #<sfxwalk1      ;Start address of sound effect data
        ;ldy #>sfxwalk1  
        ;ldx #07             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 
		
        ;jmp LAF5D ; JR LAF5D

	.if TED_SOUND == 1
		inc sfx_count_001
		lda sfx_count_001
		cmp #07
		bcs @+
		
		; *** rts added ***
		rts
@
		; turn sound off
		lda #08
		jsr ted_music_play
		lda #00
		sta sfx_count_001
		
	.endif	
		
		rts
	
	
;LAF55   LD A,(IX+01)
;AF58    SUB 40
;AF5A    LD B,A
;AF5B    LD C,04
;LAF5D   CALL LAF64
;AF60    DEC C
;AF61    JR NZ,LAF5D
;AF63    RET

;LAF55   ldy #$01 ; LD A,(IX+01)
;        lda (z80_ix),y
;        sec ; SUB 40
;        sbc #$40
;        sta z80_b ; LD B,A
;        lda #$04 ; LD C,04
;        sta z80_c
;sound
;LAF5D   jsr LAF64 ; CALL LAF64
;        dec z80_c ; DEC C
;        jne LAF5D ; JR NZ,LAF5D
;        rts ; RET

;LAF64   LD A,10
;AF66    OUT A,(FE)
;AF68    LD A,B
;@@95    DJNZ @@95
;AF6B    LD B,A
;AF6C    XOR A
;AF6D    OUT A,(FE)
;AF6F    LD A,B
;@@96    DJNZ @@96
;AF72    LD B,A
;AF73    RET

;LAF64   ; Warning: Sound Effect
;		
;		lda #$10 ; LD A,10
;       ;jsr out_fe ; OUT A,(FE)
;  
;  lda z80_b ; LD A,B
;		tax
;@@95    ;dec z80_b ; DJNZ @@95
;		dex
;        jne @@95
;        ;sta z80_b ; LD B,A
;        lda #$00 ; XOR A
;        ;jsr out_fe ; OUT A,(FE)
;        lda z80_b ; LD A,B
;		tax
;@@96    ;dec z80_b ; DJNZ @@96
;		dex
;        jne @@96
;        ;sta z80_b ; LD B,A
;        rts ; RET

;LAF74   LD HL,LA242
;AF77    LD A,(HL)
;AF78    AND A
;AF79    RET NZ
;AF7A    SET 0,(HL)
;@@97    XOR A
;AF7D    CALL ReadKey
;AF80    JR Z,@@98
;AF82    RET

; menu key wait

;LAF74   
;PlayAudioWaitKey
;		lda #<LA242 ; LD HL,LA242
;        sta z80_l
;        lda #>LA242
;        sta z80_h
;        ldy #$00 ; LD A,(HL)
;        lda (z80_hl),y
;        ; AND  A
;        beq *+3 ; RET NZ
;        rts
;        ldy #$00 ; SET 0,(HL)
;        lda (z80_hl),y
;        ora #_bitvalue0
;        sta (z80_hl),y
;				
;@@97    lda #$00 ; XOR A
;
;        jsr ReadKey ; CALL ReadKey
;        jeq @@98 ; JR Z,@@98
;        		
;		rts ; RET

;@@98    LD A,(DE)
;AF84    CP FF
;AF86    JR Z,@@101
;AF88    CALL LAF98
;AF8B    JR @@97

;@@98    ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        cmp #$FF ; CP FF
;        jeq @@101 ; JR Z,@@101
;        jsr LAF98 ; CALL LAF98
;        jmp @@97 ; JR @@97

;LAF8D   LD A,(DE)
;AF8E    CP FF
;AF90    JR Z,@@101
;AF92    CALL LAF98
;AF95    JR LAF8D

;LAF8D
;PlayAudio
;		ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        cmp #$FF ; CP FF
;        jeq @@101 ; JR Z,@@101
;        jsr LAF98 ; CALL LAF98
;        jmp PlayAudio ; JR LAF8D

;@@101   RET

;@@101   
;
;		lda #00
;		sta sprite_on
;		
;		; clear down game over sprite data from buffer
;		ldx #00
;@		
;		sta $f500,x
;		inx
;		bne @-
;		
;		rts ; RET

;LAF98   AND 3F
;AF9A    JR Z,@@109
;AF9C    LD L,A
;AF9D    LD H,00
;AF9F    ADD HL,HL
;AFA0    CALL LD26E
;AFA3    LD BC,LAFF0
;AFA6    ADD HL,BC
;AFA7    LD B,(HL)
;AFA8    INC HL
;AFA9    LD C,(HL)
;AFAA    INC HL
;AFAB    LD L,(HL)
;AFAC    LD H,00
;AFAE    LD A,(DE)
;AFAF    RLCA
;AFB0    RLCA
;AFB1    AND 03
;AFB3    INC A
;AFB4    PUSH DE
;AFB5    LD E,L
;AFB6    LD D,H
;@@102   DEC A
;AFB8    JR Z,@@103
;AFBA    ADD HL,DE
;AFBB    JR @@102

; menu wait - MUSIC PLAYBACK
;LAF98   
;
;		and #$3F ; AND 3F
;        jeq @@109 ; JR Z,@@109
;        sta z80_l ; LD L,A
;        ldx #$00 ; LD H,00
;        stx z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        jsr LD26E ; CALL LD26E ; uses A as parameter
;        
;		; freq table
;		lda #<LAFF0 ; LD BC,LAFF0
;        sta z80_c
;        lda #>LAFF0
;        sta z80_b
;        
;		jsr add_hl_bc ; ADD HL,BC
;        ldy #$00 ; LD B,(HL)
;        lda (z80_hl),y
;        sta z80_b
;        inc z80_l ; INC HL
;        bne *+4
;        inc z80_h
;        ldy #$00 ; LD C,(HL)
;        lda (z80_hl),y
;        sta z80_c
;        inc z80_l ; INC HL
;        bne *+4
;        inc z80_h
;        ldy #$00 ; LD L,(HL)
;        lda (z80_hl),y
;        sta z80_l
;        lda #$00 ; LD H,00
;        sta z80_h
;        ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        asl @ ; RLCA: this copies bit 7 to bit 0
;        rol @
;        rol @
;        and #$03 ; AND 03
;        clc ; INC A
;        adc #$01
;        sta z80_a
;        lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        lda z80_l ; LD E,L
;        sta z80_e
;        lda z80_h ; LD D,H
;        sta z80_d
;@@102   ;sec ; DEC A
;        ;sbc #$01; A read but not set by previous instruction
;        dec z80_a
;        jeq @@103 ; JR Z,@@103
;        jsr add_hl_de ; ADD HL,DE
;		
;        jmp @@102 ; JR @@102

;@@103   POP DE
;@@104   PUSH BC
;AFBF    XOR A
;AFC0    OUT A,(FE)
;@@105   DJNZ @@105
;AFC4    DEC C
;AFC5    JR NZ,@@105
;AFC7    POP BC
;AFC8    PUSH BC
;AFC9    LD A,10
;AFCB    OUT A,(FE)
;@@107   DJNZ @@107
;AFCF    DEC C
;AFD0    JR NZ,@@107
;AFD2    POP BC
;AFD3    DEC HL
;AFD4    LD A,H
;AFD5    OR L
;AFD6    JR NZ,@@104
;AFD8    INC DE
;AFD9    RET

;@@103   pla ; POP DE
;        sta z80_d
;        pla
;        sta z80_e
;@@104   lda z80_c ; PUSH BC
;        pha
;		tay
;        lda z80_b
;        pha
;		tax
;        lda #$00 ; XOR A
;        jsr out_fe ; OUT A,(FE)
;		;lda #$00
;		;sta consol
;@@105   ;dec z80_b ; DJNZ @@105
;		dex
;        jne @@105
;        ;dec z80_c ; DEC C
;		dey
;        jne @@105 ; JR NZ,@@105
;        pla ; POP BC
;        sta z80_b
;        pla
;        sta z80_c
;        lda z80_c ; PUSH BC
;        pha
;		tay
;        lda z80_b
;        pha
;		tax
;        lda #$10 ; LD A,10
;        jsr out_fe ; OUT A,(FE)
;		;lda #$08
;		;sta consol
;@@107   ;dec z80_b ; DJNZ @@107
;		dex
;        jne @@107
;        ;dec z80_c ; DEC C
;		dey
;        jne @@107 ; JR NZ,@@107
;        pla ; POP BC
;        sta z80_b
;        pla
;        sta z80_c
;        jsr dec_hl ; DEC HL
;		
;        lda z80_h ; LD A,H
;        ora z80_l ; OR L
;        jne @@104 ; JR NZ,@@104
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        rts ; RET

;@@109   LD A,(DE)
;AFDB    INC DE
;AFDC    RLCA
;AFDD    RLCA
;AFDE    AND 03
;AFE0    INC A
;AFE1    LD L,A
;AFE2    LD BC,L430B
;@@110   PUSH BC
;@@111   DEC BC
;AFE7    LD A,B
;AFE8    OR C
;AFE9    JR NZ,@@111
;AFEB    POP BC
;AFEC    DEC L
;AFED    JR NZ,@@110
;AFEF    RET

;@@109   ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        asl @ ; RLCA this copies bit 7 to bit 0
;        rol @
;        rol @
;        and #$03 ; AND 03
;        clc ; INC A
;        adc #$01
;        sta z80_l ; LD L,A
;        lda #<$430B ; LD BC,L430B ; delay loop parameter?
;        sta z80_c
;        lda #>$430B
;        sta z80_b
;@@110   lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;@@111   jsr dec_bc ; DEC BC
;        lda z80_b ; LD A,B
;        ora z80_c ; OR C
;        jne @@111 ; JR NZ,@@111
;        pla ; POP BC
;        sta z80_b
;        pla
;        sta z80_c
;        dec z80_l ; DEC L
;        jne @@110 ; JR NZ,@@110
;        rts ; RET

;LAFF0   DB 00,00,00,F4,0A,08,65,0A
;AFF8    DB 09,DE,09,09,5E,09,0A,E7
;B000    DB 08,0A,75,08,0B,0A,08,0C
;B008    DB A5,07,0C,45,07,0D,EB,06
;B010    DB 0E,96,06,0F,46,06,0F,FA
;B018    DB 05,10,B3,05,11,6F,05,12
;B020    DB 2F,05,13,F3,04,15,F3,04
;B028    DB 16,85,04,17,52,04,19,23 ; ....R..#
;B030    DB 04,1A,F6,03,1C,CB,03,1D
;B038    DB A3,03,1F,7D,03,21,59,03 ; .....!Y.
;B040    DB 23,38,03,25,18,03,27,FA ; #8..'.
;B048    DB 02,29,DD,02,2C,C2,02,2E ; .)..,...
;B050    DB A9,02,31,91,02,34,7B,02 ; ..1..4..
;B058    DB 37,66,02,3A,51,02,3E,3F ; 7..:Q.>?
;B060    DB 02,41,2D,02,45,1C,02,49 ; .A-.E..I
;B068    DB 0C,02,4E,FD,01,52,EF,01 ; ..N..R..
;B070    DB 57,E2,01,5D,D5,01,62,C9 ; W..]....
;B078    DB 01,68,BD,01,6E,B3,01,75
;B080    DB A9,01,7B,9F,01,83,96,01
;B088    DB 8B,8E,01,93,86,01,9C,7E
;B090    DB 01,A5,77,01,AF,71,01,B9
;B098    DB 6A,01,C4,64,01,D0,5F,01
;B0A0    DB DC,59,01,E9,54,01,F7 ; .Y..T..

; freq table
;LAFF0   .he 00,00,00,F4,0A,08,65,0A ; DB 00,00,00,F4,0A,08,65,0A
;        .he 09,DE,09,09,5E,09,0A,E7 ; DB 09,DE,09,09,5E,09,0A,E7
;        .he 08,0A,75,08,0B,0A,08,0C ; DB 08,0A,75,08,0B,0A,08,0C
;        .he A5,07,0C,45,07,0D,EB,06 ; DB A5,07,0C,45,07,0D,EB,06
;        .he 0E,96,06,0F,46,06,0F,FA ; DB 0E,96,06,0F,46,06,0F,FA
;        .he 05,10,B3,05,11,6F,05,12 ; DB 05,10,B3,05,11,6F,05,12
;        .he 2F,05,13,F3,04,15,F3,04 ; DB 2F,05,13,F3,04,15,F3,04
;        .he 16,85,04,17,52,04,19,23 ; DB 16,85,04,17,52,04,19,23
;        .he 04,1A,F6,03,1C,CB,03,1D ; DB 04,1A,F6,03,1C,CB,03,1D
;        .he A3,03,1F,7D,03,21,59,03 ; DB A3,03,1F,7D,03,21,59,03
;        .he 23,38,03,25,18,03,27,FA ; DB 23,38,03,25,18,03,27,FA
;        .he 02,29,DD,02,2C,C2,02,2E ; DB 02,29,DD,02,2C,C2,02,2E
;        .he A9,02,31,91,02,34,7B,02 ; DB A9,02,31,91,02,34,7B,02
;        .he 37,66,02,3A,51,02,3E,3F ; DB 37,66,02,3A,51,02,3E,3F
;        .he 02,41,2D,02,45,1C,02,49 ; DB 02,41,2D,02,45,1C,02,49
;        .he 0C,02,4E,FD,01,52,EF,01 ; DB 0C,02,4E,FD,01,52,EF,01
;        .he 57,E2,01,5D,D5,01,62,C9 ; DB 57,E2,01,5D,D5,01,62,C9
;        .he 01,68,BD,01,6E,B3,01,75 ; DB 01,68,BD,01,6E,B3,01,75
;        .he A9,01,7B,9F,01,83,96,01 ; DB A9,01,7B,9F,01,83,96,01
;        .he 8B,8E,01,93,86,01,9C,7E ; DB 8B,8E,01,93,86,01,9C,7E
;        .he 01,A5,77,01,AF,71,01,B9 ; DB 01,A5,77,01,AF,71,01,B9
;        .he 6A,01,C4,64,01,D0,5F,01 ; DB 6A,01,C4,64,01,D0,5F,01
;        .he DC,59,01,E9,54,01,F7 ; DB DC,59,01,E9,54,01,F7

;LB0A7   DB 23,25,27,23,22,23,25,22 ; #'#"#"
;B0AF    DB 20,22,23,20,1F,20,22,1B ;  "# . ".
;B0B7    DB 1F,22,27,25,23,25,23,22 ; ."'%#"
;B0BF    DB 23,22,20,22,20,1F,E0,FF ; #" " ...

; audio
;LB0A7   .he 23,25,27,23,22,23,25,22 ; DB 23,25,27,23,22,23,25,22
;        .he 20,22,23,20,1F,20,22,1B ; DB 20,22,23,20,1F,20,22,1B
;        .he 1F,22,27,25,23,25,23,22 ; DB 1F,22,27,25,23,25,23,22
;        .he 23,22,20,22,20,1F,E0,FF ; DB 23,22,20,22,20,1F,E0,FF

;LB0C7   DB 27,2A,27,2A,27,2A,22,25 ; '*'*'*"
;B0CF    DB E7,FF

; audio
;LB0C7   .he 27,2A,27,2A,27,2A,22,25 ; DB 27,2A,27,2A,27,2A,22,25
;        .he E7,FF ; DB E7,FF

;LB0D1   DB 00,2A,22,21,22,29,22,21 ; .*"!")"!
;B0D9    DB 22,27,22,21,22,26,22,21 ; "'"!"&"!
;B0E1    DB 22,2A,22,21,22,29,22,21 ; "*"!")"!
;B0E9    DB 22,27,22,21,22,26,22,21 ; "'"!"&"!
;B0F1    DB 22,2C,20,1D,20,2A,1E,1B ; ", . *..
;B0F9    DB 1E,29,1D,14,1D,16,1D,14
;B101    DB 1D,2C,20,1D,20,2A,1E,1B ; ., . *..
;B109    DB 1E,29,1D,14,1D,16,1D,14
;B111    DB 1D,2E,1B,2A,27,2A,1B,27 ; ...*'*.'
;B119    DB 22,1B,22,27,2A,2E,1B,2C ; "."'*..,
;B121    DB 2A,2C,19,29,25,29,19,25 ; *,.)).
;B129    DB 20,19,20,25,29,2C,19,2A ;  . ),.*
;B131    DB 29,2A,17,27,22,27,17,22 ; )*.'"'."
;B139    DB 1E,17,1E,22,27,2A,17,29 ; ..."'*.)
;B141    DB 27,29,16,26,22,26,16,22 ; ').&"&."
;B149    DB 1D,20,16,1E,1D,1B,16,1B
;B151    DB 80,2C,20,1D,20,2A,1E,1B ; ., . *..
;B159    DB 1E,29,1D,14,1D,16,1D,14
;B161    DB 1D,2C,20,1D,20,2A,1E,1B ; ., . *..
;B169    DB 1E,29,1D,14,1D,16,1D,14
;B171    DB 1D,2E,1B,2A,27,2A,1B,27 ; ...*'*.'
;B179    DB 22,1B,22,27,2A,2E,1B,2C ; "."'*..,
;B181    DB 2A,2C,19,29,25,29,19,25 ; *,.)).
;B189    DB 20,19,20,25,29,2C,19,2A ;  . ),.*
;B191    DB 29,2A,17,27,22,27,17,22 ; )*.'"'."
;B199    DB 1E,17,1E,22,27,2A,17,29 ; ..."'*.)
;B1A1    DB 27,29,16,26,22,26,16,22 ; ').&"&."
;B1A9    DB 1D,20,16,1E,1D,1B,16,1B
;B1B1    DB 80,FF

; audio
;LB0D1   .he 00,2A,22,21,22,29,22,21 ; DB 00,2A,22,21,22,29,22,21
;        .he 22,27,22,21,22,26,22,21 ; DB 22,27,22,21,22,26,22,21
;        .he 22,2A,22,21,22,29,22,21 ; DB 22,2A,22,21,22,29,22,21
;        .he 22,27,22,21,22,26,22,21 ; DB 22,27,22,21,22,26,22,21
;        .he 22,2C,20,1D,20,2A,1E,1B ; DB 22,2C,20,1D,20,2A,1E,1B
;        .he 1E,29,1D,14,1D,16,1D,14 ; DB 1E,29,1D,14,1D,16,1D,14
;        .he 1D,2C,20,1D,20,2A,1E,1B ; DB 1D,2C,20,1D,20,2A,1E,1B
;        .he 1E,29,1D,14,1D,16,1D,14 ; DB 1E,29,1D,14,1D,16,1D,14
;        .he 1D,2E,1B,2A,27,2A,1B,27 ; DB 1D,2E,1B,2A,27,2A,1B,27
;        .he 22,1B,22,27,2A,2E,1B,2C ; DB 22,1B,22,27,2A,2E,1B,2C
;        .he 2A,2C,19,29,25,29,19,25 ; DB 2A,2C,19,29,25,29,19,25
;        .he 20,19,20,25,29,2C,19,2A ; DB 20,19,20,25,29,2C,19,2A
;        .he 29,2A,17,27,22,27,17,22 ; DB 29,2A,17,27,22,27,17,22
;        .he 1E,17,1E,22,27,2A,17,29 ; DB 1E,17,1E,22,27,2A,17,29
;        .he 27,29,16,26,22,26,16,22 ; DB 27,29,16,26,22,26,16,22
;        .he 1D,20,16,1E,1D,1B,16,1B ; DB 1D,20,16,1E,1D,1B,16,1B
;        .he 80,2C,20,1D,20,2A,1E,1B ; DB 80,2C,20,1D,20,2A,1E,1B
;        .he 1E,29,1D,14,1D,16,1D,14 ; DB 1E,29,1D,14,1D,16,1D,14
;        .he 1D,2C,20,1D,20,2A,1E,1B ; DB 1D,2C,20,1D,20,2A,1E,1B
;        .he 1E,29,1D,14,1D,16,1D,14 ; DB 1E,29,1D,14,1D,16,1D,14
;        .he 1D,2E,1B,2A,27,2A,1B,27 ; DB 1D,2E,1B,2A,27,2A,1B,27
;        .he 22,1B,22,27,2A,2E,1B,2C ; DB 22,1B,22,27,2A,2E,1B,2C
;        .he 2A,2C,19,29,25,29,19,25 ; DB 2A,2C,19,29,25,29,19,25
;        .he 20,19,20,25,29,2C,19,2A ; DB 20,19,20,25,29,2C,19,2A
;        .he 29,2A,17,27,22,27,17,22 ; DB 29,2A,17,27,22,27,17,22
;        .he 1E,17,1E,22,27,2A,17,29 ; DB 1E,17,1E,22,27,2A,17,29
;        .he 27,29,16,26,22,26,16,22 ; DB 27,29,16,26,22,26,16,22
;        .he 1D,20,16,1E,1D,1B,16,1B ; DB 1D,20,16,1E,1D,1B,16,1B
;        .he 80,FF ; DB 80,FF

;LB1B3   DB 2E,2F,2E,2C,2A,2C,2A,27 ; ./.,*,*'
;B1BB    DB 27,2E,2C,2A,29,2A,27,22 ; '.,*)*'"
;B1C3    DB 2A,2C,2A,27,29,2A,29,26 ; *,*')*)&
;B1CB    DB E7,FF

; audio
;LB1B3   .he 2E,2F,2E,2C,2A,2C,2A,27 ; DB 2E,2F,2E,2C,2A,2C,2A,27
;        .he 27,2E,2C,2A,29,2A,27,22 ; DB 27,2E,2C,2A,29,2A,27,22
;        .he 2A,2C,2A,27,29,2A,29,26 ; DB 2A,2C,2A,27,29,2A,29,26
;        .he E7,FF ; DB E7,FF


;LB1CD   DB 29,16,26,22,26,16,22,1D ; ).&"&.".
;B1D5    DB 20,16,1E,1D,1B,16,1B,80
;B1DD    DB FF

; audio
;LB1CD   .he 29,16,26,22,26,16,22,1D ; DB 29,16,26,22,26,16,22,1D
;        .he 20,16,1E,1D,1B,16,1B,80 ; DB 20,16,1E,1D,1B,16,1B,80
;        .he FF ; DB FF

;LB1DE   DB 22,27,2B,6E,6B,24,29,2C ; "'+..$),
;B1E6    DB 70,6C,26,29,2E,72,6E,27 ; ..&)...'
;B1EE    DB 2B,2E,F3,FF ; +...

; audio
;LB1DE   .he 22,27,2B,6E,6B,24,29,2C ; DB 22,27,2B,6E,6B,24,29,2C
;        .he 70,6C,26,29,2E,72,6E,27 ; DB 70,6C,26,29,2E,72,6E,27
;        .he 2B,2E,F3,FF ; DB 2B,2E,F3,FF

;LB1F2   LD HL,LB4A6
;B1F5    LD A,(LA262)
;B1F8    ADD A,A
;B1F9    LD B,A
;B1FA    JR Z,@@114
;@@113   BIT 7,(HL)
;B1FE    INC HL
;B1FF    JR Z,@@113
;B201    DJNZ @@113
;@@114   PUSH HL
;B204    POP IY
;B206    LD DE,L4083
;B209    CALL LB20F
;B20C    LD DE,L40A3
;LB20F   PUSH IY
;B211    POP HL
;B212    XOR A
;@@115   BIT 7,(HL)
;B215    JR NZ,@@116
;B217    INC HL
;B218    INC A
;B219    JR @@115


; quite a complex routine as we have to blit and ORA and in some cases centre (shift) the text, fun!
;LB1F2
enemy_name_txt   

		; top half of name text (ORA)
		lda #04
		sta alpha
		
		lda #00
		sta count_temp_02
		
		lda #<$c520
		sta dest_lo
		lda #>$c520
		sta dest_hi

		ldy BanditId
		lda enemy_top_centre,y
		sta enemy_ctr
		
		tya
		
		
		; multiply by 8 leaving number in A & X for loop
		asl
		asl
		asl
		tax

		; add another 8 to A value for loop end point (count_temp_02)
		clc
		adc #08
		sta count_temp_02
		
		
@	
		stx count_temp
		lda enemy_txt_t,x
		
		sec
		sub #40
		tax
		
		lda enemy_ctr
		bne crt_txt_01
		jsr fontblit
		jmp crt_txt_02

crt_txt_01	

		jsr centre_text

crt_txt_02		

		ldx count_temp
		inx
		
		cpx count_temp_02 ; X plus 8
		bne @-	

		; bottom half of name text
		lda #00
		sta count_temp_02
		
		lda #<$c660
		sta dest_lo
		lda #>$c660
		sta dest_hi

		ldy BanditId
		lda enemy_bot_centre,y
		sta enemy_ctr
		
		tya
		
		; multiply enemy number by 8
		asl
		asl
		asl
		tax

		clc
		adc #08
		sta count_temp_02
		
		
@	
		stx count_temp
		lda enemy_txt_b,x

		sec
		sub #40
		tax

		lda enemy_ctr
		bne crt_txt_03		
		jsr fontblit
		jmp crt_txt_04
		
crt_txt_03		
		
		jsr centre_text
	
crt_txt_04
	
		ldx count_temp
		inx
		
		cpx count_temp_02
		bne @-	
		
		rts

enemy_txt_t
		dta 056,208,088,088,048,136,160,040		;1
		dta 040,056,112,136,136,240,040,040		;1	
		dta 192,208,152,072,048,152,064,080		;0
		dta 040,120,080,192,192,240,040,040		;1
		dta 040,056,208,200,064,104,040,040		;1
		dta 040,040,040,144,048,040,040,040		;0
		dta 040,040,224,112,136,072,040,040		;0
		dta 040,184,208,144,168,160,040,040		;1
		dta 040,064,136,080,216,080,184,040		;0
		dta 040,144,112,136,128,112,080,040		;0
		dta 128,136,160,152,072,112,128,080		;0
		dta 040,056,184,160,152,064,160,040		;0
		dta 040,224,048,240,128,160,040,040		;1
		dta 040,040,136,160,152,080,040,040		;0
		dta 040,200,160,152,200,160,040,040		;1
		dta 040,040,040,176,072,040,040,040		;0
		dta 144,080,232,112,064,048,152,192		;0
		dta 040,040,096,208,152,040,040,040		;1
		dta 056,048,152,072,112,200,192,040		;1
		dta 040,040,104,112,136,136,040,040		;0

enemy_top_centre
		dta 1,1,0,1,1,0,0,1,0,0,0,0,1,0,1,0,0,1,1,0
		
enemy_txt_b		
		dta 040,040,056,112,136,136,040,040		;0
		dta 200,104,080,040,128,112,072,040		;1
		dta 040,040,128,112,072,040,040,040		;1
		dta 040,120,048,144,080,192,040,040		;1
		dta 064,048,192,192,112,072,240,040		;1
		dta 040,056,048,128,080,184,040,040		;1
		dta 040,040,056,112,136,136,040,040		;0
		dta 040,040,128,112,072,040,040,040		;1
		dta 040,040,120,048,128,080,040,040		;0
		dta 056,048,184,040,128,112,072,040		;1
		dta 040,040,168,080,200,080,040,040		;0
		dta 064,160,136,048,184,048,072,160		;0
		dta 040,040,128,112,072,040,040,040		;1
		dta 040,184,048,152,096,080,184,040		;0
		dta 040,040,040,040,040,040,040,040		;0
		dta 040,144,064,096,184,048,224,040		;0
		dta 040,040,040,040,040,040,040,040		;0
		dta 192,136,112,152,096,080,184,192		;0
		dta 040,040,040,040,040,040,040,040		;0
		dta 040,056,112,136,136,240,192,040		;0

enemy_bot_centre
		dta 0,1,1,1,1,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0
		
;enemy_temp
;		dta 00,00,00,00,00,00,00,00
;		dta 00,00,00,00,00,00,00,00
;		dta 00,00,00,00,00,00,00,00
;		dta 00,00,00,00,00,00,00,00
;		dta 00,00,00,00,00,00,00,00
;		dta 00,00,00,00,00,00,00,00
;		dta 00,00,00,00,00,00,00,00
;		dta 00,00,00,00,00,00,00,00
		
;		; enemy name text
;		 lda #<LB4A6 ; LD HL,LB4A6
;        sta z80_l
;        lda #>LB4A6
;        sta z80_h
;				
;        lda BanditId ; LD A,(LA262)
;				
;        asl @ ; ADD A,A
;        sta z80_b ; LD B,A
;        jeq @@114 ; JR Z,@@114; 
;@@113   ldy #$00 ; BIT 7,(HL)
;        lda (z80_hl),y
;        bit _bitmem7
;        php
;        inc z80_l ; INC HL
;        bne *+4
;        inc z80_h
;        plp
;        jeq @@113 ; JR Z,@@113; ZERO flag read but not set by previous instruction
;        dec z80_b ; DJNZ @@113
;        jne @@113
;@@114   lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;        pla ; POP IY
;        sta z80_iy+1
;        pla
;        sta z80_iy
;        lda #<L4083 ; LD DE,L4083
;        sta z80_e
;        lda #>L4083
;        sta z80_d
;        jsr LB20F ; CALL LB20F
;        lda #<L40A3 ; LD DE,L40A3
;        sta z80_e
;        lda #>L40A3
;        sta z80_d
;LB20F   lda z80_iy ; PUSH IY
;        pha
;        lda z80_iy+1
;        pha
;        pla ; POP HL
;        sta z80_h
;        pla
;        sta z80_l
;        lda #$00 ; XOR A
;        sta z80_a
;@@115   ldy #$00 ; BIT 7,(HL)
;        lda (z80_hl),y
;        bit _bitmem7
;        jne @@116 ; JR NZ,@@116
;        inc z80_l ; INC HL
;        bne *+4
;        inc z80_h
;        ;clc ; INC A
;        ;adc #$01; A read but not set by previous instruction
;        inc z80_a
;        jmp @@115 ; JR @@115
;
;@@116   PUSH AF
;B21C    CPL
;B21D    AND 01
;B21F    LD (LA213),A
;B222    POP AF
;B223    SRL A
;B225    NEG
;B227    ADD A,E
;B228    LD E,A
;@@117   LD A,(IY+00)
;B22C    AND 7F
;B22E    CALL LD4E3
;B231    LD L,A
;B232    LD H,00
;B234    ADD HL,HL
;B235    ADD HL,HL
;B236    ADD HL,HL
;B237    LD BC,L8EA8
;B23A    ADD HL,BC
;B23B    EX DE,HL
;B23C    LD A,(LA213)
;B23F    AND A
;B240    JR Z,@@120
;B242    LD B,FC
;B244    LD A,08
;@@118   EX AF,AF'
;B247    LD A,(DE)
;B248    INC DE
;B249    LD C,A
;B24A    LD A,(BC)
;B24B    OR (HL)
;B24C    LD (HL),A
;B24D    INC L
;B24E    INC B
;B24F    LD A,(BC)
;B250    DEC B
;B251    OR (HL)
;B252    LD (HL),A
;B253    DEC L
;B254    INC H
;B255    EX AF,AF'
;B256    DEC A
;B257    JR NZ,@@118
;@@119   LD A,H
;B25A    SUB 08
;B25C    LD H,A
;B25D    INC L
;B25E    INC IY
;B260    EX DE,HL
;B261    BIT 7,(IY-01)
;B265    RET NZ
;B266    JR @@117

;@@116   lda z80_a
;        pha ; PUSH AF
;        php; A read at the beginning of the block
;        eor #$ff ; CPL
;        and #$01 ; AND 01
;        sta LA213 ; LD (LA213),A
;        plp ; POP AF
;        pla
;        lsr @ ; SRL A
;        eor #$ff ; NEG
;        clc
;        adc #$01
;        clc ; ADD A,E
;        adc z80_e
;        sta z80_e ; LD E,A
;@@117   ldy #$00 ; LD A,(IY+00)
;        lda (z80_iy),y
;        and #$7F ; AND 7F
;        jsr LD4E3 ; CALL LD4E3 ; uses A as parameter
;        sta z80_l ; LD L,A
;        lda #$00 ; LD H,00
;        sta z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        lda #<L8EA8 ; LD BC,L8EA8
;        sta z80_c
;        lda #>L8EA8
;        sta z80_b
;        jsr add_hl_bc ; ADD HL,BC
;        jsr ex_de_hl ; EX DE,HL
;        lda LA213 ; LD A,(LA213)
;        ; AND  A
;        jeq @@120 ; JR Z,@@120
;        ;lda #$FC ; LD B,FC ; table address
;        lda #>[RotationTable+$0c00]
;        sta z80_b
;        lda #$08 ; LD A,08
;@@118   ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa ; 
;        ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        sta z80_c ; LD C,A
;        ldy #$00 ; LD A,(BC)
;        lda (z80_bc),y
;        ldy #$00 ; OR (HL)
;        ora (z80_hl),y
;        ldy #$00 ; LD (HL),A
;        sta (z80_hl),y
;        inc z80_l ; INC L
;        inc z80_b ; INC B
;        ldy #$00 ; LD A,(BC)
;        lda (z80_bc),y
;        dec z80_b ; DEC B
;        ldy #$00 ; OR (HL)
;        ora (z80_hl),y; 
;        ldy #$00 ; LD (HL),A
;        sta (z80_hl),y
;        dec z80_l ; DEC L
;        inc z80_h ; INC H
;        ;ldx z80_ap ; EX AF,AF'
;        ;sta z80_ap
;        ;txa ; 
;		lda z80_ap
;        sec ; DEC A
;        sbc #$01
;        jne @@118 ; JR NZ,@@118
;@@119   lda z80_h ; LD A,H
;        sec ; SUB 08
;        sbc #$08
;        sta z80_h ; LD H,A
;        inc z80_l ; INC L
;        ldy #$00	; LD A,(IY+0) ; added instruction to emulate BIT 7,(IY-01)
;        lda (z80_iy),y
;        pha
;        inc z80_iy ; INC IY
;        bne *+4
;        inc z80_iy+1
;        jsr ex_de_hl ; EX DE,HL
;        ;unemulated instruction ; BIT 7,(IY-01)
;        pla
;        ;beq *+3 ; RET NZ
;        bpl *+3
;        rts
;        jmp @@117 ; JR @@117

;@@120   LD B,08
;@@121   LD A,(DE)
;B26B    INC DE
;B26C    OR (HL)
;B26D    LD (HL),A
;B26E    INC H
;B26F    DJNZ @@121
;B271    JR @@119

;@@120   lda #$08 ; LD B,08
;        sta z80_b
;@@121   ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        ldy #$00 ; OR (HL)
;        ora (z80_hl),y;
;        ldy #$00 ; LD (HL),A
;        sta (z80_hl),y
;        inc z80_h ; INC H
;        dec z80_b ; DJNZ @@121
;        jne @@121
;        jmp @@119 ; JR @@119

;LB273   DEC (IX+0D)
;B276    DEC (IX+0D)
;B279    RET P
;B27A    LD (IX+0D),A
;B27D    RET

LB273   sta z80_a
        ldy #$0D ; DEC (IX+0D)
        lda (z80_ix),y
        sec
        sbc #$02

        sta (z80_ix),y
        ;ldy #$0D ; DEC (IX+0D)
        ;lda (z80_ix),y
        ;sec

        ;sbc #$01
        ;sta (z80_ix),y
        bmi *+3 ; RET P
        rts
        lda z80_a
        ;ldy #$0D ; LD (IX+0D),A
        sta (z80_ix),y
        rts ; RET

;LB27E   LD A,(DE)
;B27F    INC DE
;B280    PUSH BC
;B281    PUSH DE
;B282    CALL LB28A
;B285    POP DE
;B286    POP BC
;B287    DJNZ LB27E
;B289    RET

LB27E   
				
		ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        tax
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        txa
        jsr LB28A ; CALL LB28A ; uses A as parameter
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
        dec z80_b ; DJNZ LB27E
        jne LB27E
		
        rts ; RET

;LB28A   EX DE,HL
;B28B    LD BC,L6AC6
;B28E    CALL LC74B
;B291    LD (LA21D),SP
;B295    LD SP,HL
;B296    EX DE,HL
;B297    LD A,(LA220)
;B29A    AND 06
;B29C    JR Z,@@125
;B29E    OR F8
;B2A0    LD D,A
;B2A1    LD A,08
;@@123   EX AF,AF'
;B2A4    POP BC
;B2A5    LD E,C
;B2A6    LD A,(DE)
;B2A7    OR (HL)
;B2A8    LD (HL),A
;B2A9    INC HL
;B2AA    INC D
;B2AB    LD A,(DE)
;B2AC    DEC D
;B2AD    LD E,B
;B2AE    EX DE,HL
;B2AF    OR (HL)
;B2B0    LD (DE),A
;B2B1    INC DE
;B2B2    INC H
;B2B3    LD A,(HL)
;B2B4    DEC H
;B2B5    POP BC
;B2B6    LD L,C
;B2B7    OR (HL)
;B2B8    LD (DE),A
;B2B9    INC DE
;B2BA    INC H
;B2BB    LD A,(HL)
;B2BC    DEC H
;B2BD    LD L,B
;B2BE    OR (HL)
;B2BF    LD (DE),A
;B2C0    INC DE
;B2C1    INC H
;B2C2    EX DE,HL
;B2C3    LD A,(DE)
;B2C4    OR (HL)
;B2C5    LD (HL),A
;B2C6    DEC D
;B2C7    LD BC,L0014
;B2CA    ADD HL,BC
;B2CB    EX AF,AF'
;B2CC    DEC A
;B2CD    JR NZ,@@123
;@@124   LD SP,(LA21D)
;B2D3    RET

; boss drawing
LB28A   ;sta z80_a
        ;jsr ex_de_hl ; EX DE,HL; A read at the beginning of the block
		;jsr ld_de_hl
        ;lda #<L6AC6 ; LD BC,L6AC6
        ;sta z80_c
        ;lda #>L6AC6
        ;sta z80_b
        ;lda z80_a
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
        ; LD (LA21D),SP ; LD (LA21D),SP
        ; LD SP,HL ; LD SP,HL
		;lda z80_l
		;sta z80_sp
		;lda z80_h
		;sta z80_sp+1
        ;jsr ex_de_hl ; EX DE,HL
		asl @
		tax
		lda L6AC6,x
		sta z80_sp
		lda L6AC6+1,x

		sta z80_sp+1

        lda LA220 ; LD A,(LA220)
        and #$06 ; AND 06
        jeq @@125 ; JR Z,@@125
        ;ora #$F8 ; OR F8; lookup table
        ora #>[RotationTable+$0800]
        sta z80_d ; LD D,A
		sta @@123_d_1+2
		sta @@123_d_2+2
		sta @@123_d_3+2
		sta @@123_d_4+2
		ora #$01
		sta @@123_d1_1+2
		sta @@123_d1_2+2
		sta @@123_d1_3+2
		sta @@123_d1_4+2
        lda #$08 ; LD A,08
		sta z80_ap
		ldy #$00
@@123   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;pla ; POP BC
        ;sta z80_b
        ;pla
        ;sta z80_c
		
		;ldy #$00
		;lda (z80_sp),y
		;sta z80_c
		;iny
		;lda (z80_sp),y
		;sta z80_b
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		lda (z80_sp),y ; => C
        ;lda z80_c ; LD E,C
        ;sta z80_e
		tax
        ;ldy #$00 ; LD A,(DE)
        ;lda (z80_de),y
@@123_d_1		
		lda $ff00,x
        ;ldy #$00 ; OR (HL)
        ora (z80_hl),y
        ;ldy #$00 ; LD (HL),A
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		iny
        ;inc z80_d ; INC D
        ;ldy #$00 ; LD A,(DE)
        ;lda (z80_de),y
		;sta z80_a
@@123_d1_1
		lda $ff00,x
		sta z80_a
        ;dec z80_d ; DEC D
        ;lda z80_b ; LD E,B
        ;sta z80_e
		lda (z80_sp),y
		tax
        ;jsr ex_de_hl ; EX DE,HL
		lda z80_a
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y;
@@123_d_2		
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A

        ;sta (z80_de),y
		sta (z80_hl),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		iny
        ;inc z80_h ; INC H
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
@@123_d1_2
		lda $ff00,x
		sta z80_a
        ;dec z80_h ; DEC H
        ;pla ; POP BC
        ;sta z80_b
        ;pla
        ;sta z80_c
		;ldy #$00
		;lda (z80_sp),y
		;sta z80_c
		;iny
		;lda (z80_sp),y
		;sta z80_b
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		lda (z80_sp),y
		tax
        ;lda z80_c ; LD L,C
        ;sta z80_l
		lda z80_a
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y;
@@123_d_3		
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A
        ;sta (z80_de),y
		sta (z80_hl),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		iny
        ;inc z80_h ; INC H
@@123_d1_3		
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		lda $ff00,x
		sta z80_a
        ;dec z80_h ; DEC H
        ;ldx z80_b ; LD L,B
        ;stx z80_l
		lda (z80_sp),y
		tax








		lda z80_a
@@123_d_4
		ora $ff00,x
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y; 
        ;ldy #$00 ; LD (DE),A

        ;sta (z80_de),y





		sta (z80_hl),y
        ;inc z80_e ; INC DE








        ;bne *+4
        ;inc z80_d
		iny
        ;inc z80_h ; INC H
        ;jsr ex_de_hl ; EX DE,HL
        ;ldy #$00 ; LD A,(DE)
        ;lda (z80_de),y
@@123_d1_4
		lda $ff00,x
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
		ora (z80_hl),y
        ;ldy #$00 ; LD (HL),A
        ;sta (z80_hl),y
		sta (z80_hl),y
        ;dec z80_d ; DEC D
        ;lda #<L0014 ; LD BC,L0014
        ;sta z80_c
        ;lda #>L0014
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
		lda #$14
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
        ;ldx z80_ap ; EX AF,AF'
		;lda z80_ap
        ;sta z80_ap
        ;txa ; 
        ;sec ; DEC A
        ;sbc #$01
		dec z80_ap
        jne @@123 ; JR NZ,@@123
@@124   ; LD SP,(LA21D): TODO  ; LD SP,(LA21D)
		tya
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
        rts ; RET

;@@125   LD B,08
;@@126   POP DE
;B2D7    LD (HL),E
;B2D8    INC HL
;B2D9    LD (HL),D
;B2DA    INC HL
;B2DB    POP DE
;B2DC    LD (HL),E
;B2DD    INC HL
;B2DE    LD (HL),D
;B2DF    LD DE,L0015
;B2E2    ADD HL,DE
;B2E3    DJNZ @@126
;B2E5    JR @@124

@@125   ;lda #$08 ; LD B,08
        ;sta z80_b
		ldx #$08
		ldy #$00
@@126   ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #$00
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		lda (z80_sp),y
		sta (z80_hl),y
		iny
        ;lda z80_e ; LD (HL),E
        ;ldy #$00
        ;sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ;lda z80_d ; LD (HL),D
        ;ldy #$00
        ;sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		lda (z80_sp),y








		sta (z80_hl),y
		iny









        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #$00
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1					
        ;lda z80_e ; LD (HL),E
        ;ldy #$00
        ;sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		lda (z80_sp),y
		sta (z80_hl),y
		iny
        ;lda z80_d ; LD (HL),D
        ;ldy #$00
        ;sta (z80_hl),y
		lda (z80_sp),y
		sta (z80_hl),y
		iny
        ;lda #<L0015 ; LD DE,L0015
        ;sta z80_e
        ;lda #>L0015
        ;sta z80_d
        ;jsr add_hl_de ; ADD HL,DE

		lda #$15-1
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
        ;dec z80_b ; DJNZ @@126
		dex















        jne @@126
        jmp @@124 ; JR @@124

;LB2E7   LD HL,LA20A
;B2EA    LD A,(HL)
;B2EB    CP 01
;B2ED    RET NZ
;B2EE    INC (HL)
;B2EF    LD DE,LB1B3
;B2F2    CALL LAF8D
;B2F5    CALL LC7B7
;B2F8    XOR A
;B2F9    LD (LA269),A
;B2FC    LD (LA212),A
;B2FF    LD HL,L0201
;B302    LD (LA266),HL
;B305    LD HL,LA265
;B308    INC (HL)
;B309    LD A,45
;B30B    LD (LA268),A
;B30E    LD A,01
;B310    LD (LA240),A
;B313    JP LA3B1

LB2E7
		
	;lda #<LA20A ; LD HL,LA20A
        ;sta z80_l
        ;lda #>LA20A
        ;sta z80_h
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
        

		lda LA20A
        cmp #$01 ; CP 01
        beq *+3 ; RET NZ
        rts

        ;ldy #$00 ; INC (HL)
        ;lda (z80_hl),y
        ;clc
        ;adc #$01
        ;sta (z80_hl),y

		inc LA20A
        
		;lda #<LB1B3 ; LD DE,LB1B3
        ;sta z80_e
        ;lda #>LB1B3
        ;sta z80_d
        ;jsr PlayAudio ; CALL LAF8D
		
		; bandit found music play
		;lda #02
		;jsr music_play

	.if TED_SOUND == 1
		lda #02
		jsr ted_music_play
		lda #50
		sta mpwait
		jsr music_pause_no		
	.else
	
		lda #00
		sta sound_e
		
		lda #06
		jsr music_play

		lda #02
		sta mpwait
		jsr music_pause_no
		
		; bandit found music play
		lda #02
		jsr music_play
			
		lda #03
		sta mpwait
		jsr music_pause_no

		lda #80
		sta mpwait
		jsr music_pause		
		
		lda #06
		jsr music_play

		lda #03
		sta mpwait
		jsr music_pause_no
		
		; draw music effects
		lda #03
		jsr music_play			
	.endif	


	
	; turn music off	
;	.if TED_SOUND == 1
;		lda #05
;		jsr ted_music_play
;	.else
;		lda #09
;		jsr music_play	
;	.endif			
		
		; turn music off
		;lda #09
		;jsr music_play			
		
        
		jsr LC7B7 ; CALL LC7B7
        lda #$00 ; XOR A
        sta game_on ; LD (LA269),A
        sta LA212 ; LD (LA212),A
        
		;lda #<L0201 ; LD HL,L0201
        ;sta z80_l
        ;lda #>L0201
        ;sta z80_h
        ;lda z80_l ; LD (LA266),HL
        ;sta LA266
        ;lda z80_h
        ;sta LA266+1

		lda #<L0201
		sta LA266
		lda #>L0201
		sta LA266+1
        
		;lda #<no_of_lives ; LD HL,LA265
        ;sta z80_l
        ;lda #>no_of_lives
        ;sta z80_h
        ;ldy #$00 ; INC (HL)
        ;lda (z80_hl),y
        ;clc

        ;adc #$01
        ;sta (z80_hl),y
		
		inc no_of_lives

		; background colour cyan
        lda #$45 ; LD A,45
        sta LA268 ; LD (LA268),A
		
        lda #$01 ; LD A,01
        sta LA240 ; LD (LA240),A
        jmp LA3B1 ; JP LA3B1

;LB316   LD DE,LA2CB
;B319    LD A,(DE)
;B31A    AND A
;B31B    RET NZ
;B31C    PUSH DE
;B31D    POP IY
;B31F    LD HL,LB335
;B322    LD BC,L0010
;B325    LDIR
;B327    LD B,01
;B329    CALL LB6CB
;B32C    RET NZ
;B32D    CALL LB6F6
;B330    LD (IY+00),0B
;B334    RET

LB316   ;lda #<LA2CB ; LD DE,LA2CB
        ;sta z80_e
        ;lda #>LA2CB

        ;sta z80_d
        ;ldy #$00 ; LD A,(DE)
        ;lda (z80_de),y
		lda LA2CB
        ; AND  A
        beq *+3 ; RET NZ
        rts
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		;lda z80_e
		lda #<LA2CB
		sta z80_iy
		;lda z80_d
		lda #>LA2CB
		sta z80_iy+1
        ;lda #<LB335 ; LD HL,LB335
        ;sta z80_l
        ;lda #>LB335
        ;sta z80_h
        ;lda #<L0010 ; LD BC,L0010
        ;sta z80_c
        ;lda #>L0010
        ;sta z80_b
        ;jsr ldir ; LDIR
		ldy #$0f
LB316_Loop		
		lda LB335,y
		sta (z80_iy),y
		dey
		bpl LB316_Loop
        lda #$01 ; LD B,01
        sta z80_b
        jsr LB6CB ; CALL LB6CB
        beq *+3 ; RET NZ
        rts
        jsr LB6F6 ; CALL LB6F6
        ldy #$00 ; LD (IY+00),0B
        lda #$0B
        sta (z80_iy),y
        rts ; RET


;LB335   DB 00,00,00,00,00,00,00,00
;B33D    DB 10,10,00,00,00,00

LB335   .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 10,10,00,00,00,00 ; DB 10,10,00,00,00,00

;LB343   DW LB3A9

LB343   .wo LB3A9 ; DW LB3A9

;B345    LD A,04
;B347    CALL LB273
;B34A    LD C,02
;B34C    CALL LB80E
;B34F    JP NC,LC7AA
;B352    LD IY,LA2BB
;B356    CALL LB3AD
;B359    EX DE,HL
;B35A    LD IY,LA27B
;B35E    CALL LB3AD
;B361    LD A,(LA24F)
;B364    LD B,A
;B365    LD C,00
;B367    AND A
;B368    SBC HL,DE
;B36A    JR NC,@@127
;B36C    CALL LD014
;B36F    INC C
;@@127   PUSH HL
;B371    LD IY,LA2BB
;B375    CALL LB3B4
;B378    EX DE,HL
;B379    LD IY,LA27B
;B37D    CALL LB3B4
;B380    AND A
;B381    SBC HL,DE
;B383    JR NC,@@128
;B385    CALL LD014
;B388    INC C
;B389    INC C
;@@128   POP DE
;B38B    AND A
;B38C    SBC HL,DE
;B38E    JR C,@@130
;B390    RES 6,(IX+07)
;B394    LD A,C
;B395    CPL
;B396    RRCA
;@@129   AND 01
;B399    XOR B
;B39A    ADD A,30
;B39C    LD (LB3AB),A
;B39F    JP LB73F

LB345   lda #$04 ; LD A,04
        jsr LB273 ; CALL LB273
        lda #$02 ; LD C,02
        sta z80_c
        jsr LB80E ; CALL LB80E
        jcs LC7AA ; JP NC,LC7AA
        lda #<LA2BB ; LD IY,LA2BB
        sta z80_iy
        lda #>LA2BB
        sta z80_iy+1
        jsr LB3AD ; CALL LB3AD
        jsr ex_de_hl ; EX DE,HL
        lda #<LA27B ; LD IY,LA27B
        sta z80_iy
        lda #>LA27B
        sta z80_iy+1
        jsr LB3AD ; CALL LB3AD
        lda LA24F ; LD A,(LA24F)
        sta z80_b ; LD B,A
        lda #$00 ; LD C,00
        sta z80_c
        ; AND  A
        sec
        jsr sbc_hl_de ; SBC HL,DE
        jcs @@127 ; JR NC,@@127
        jsr LD014 ; CALL LD014
        inc z80_c ; INC C
@@127   lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda #<LA2BB ; LD IY,LA2BB
        sta z80_iy
        lda #>LA2BB
        sta z80_iy+1
        jsr LB3B4 ; CALL LB3B4
        jsr ex_de_hl ; EX DE,HL
        lda #<LA27B ; LD IY,LA27B
        sta z80_iy
        lda #>LA27B
        sta z80_iy+1
        jsr LB3B4 ; CALL LB3B4
        ; AND  A
        sec
        jsr sbc_hl_de ; SBC HL,DE
        jcs @@128 ; JR NC,@@128
        jsr LD014 ; CALL LD014
        inc z80_c ; INC C
        inc z80_c ; INC C
@@128   pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        ; AND  A
        sec
        jsr sbc_hl_de ; SBC HL,DE
        jcc @@130 ; JR C,@@130
        ldy #$07 ; RES 6,(IX+07)
        lda (z80_ix),y
        and #_notbitvalue6
        sta (z80_ix),y
        lda z80_c ; LD A,C
        eor #$ff ; CPL
        lsr @ ; RRCA
@@129   and #$01 ; AND 01
        eor z80_b ; XOR B
        clc ; ADD A,30
        adc #$30
        sta LB3AB ; LD (LB3AB),A
        jmp LB73F ; JP LB73F

;@@130   SET 6,(IX+07)
;B3A6    LD A,C
;B3A7    JR @@129

@@130   ldy #$07 ; SET 6,(IX+07)
        lda (z80_ix),y
        ora #_bitvalue6
        sta (z80_ix),y
        lda z80_c ; LD A,C
        jmp @@129 ; JR @@129

;LB3A9   DB F4,04

LB3A9   .he F4,04 ; DB F4,04

;LB3AB   DB 00,80

LB3AB   .he 00,80 ; DB 00,80

;LB3AD   LD L,(IY+01)
;B3B0    LD H,(IY+02)
;B3B3    RET

LB3AD   ldy #$01 ; LD L,(IY+01)
        lda (z80_iy),y
        sta z80_l
        ;ldy #$02 ; LD H,(IY+02)
		iny
        lda (z80_iy),y
        sta z80_h
        rts ; RET

;LB3B4   LD L,(IY+03)
;B3B7    LD H,(IY+04)
;B3BA    RET

LB3B4   ldy #$03 ; LD L,(IY+03)
        lda (z80_iy),y
        sta z80_l
        ;ldy #$04 ; LD H,(IY+04)
		iny
        lda (z80_iy),y
        sta z80_h
        rts ; RET


;LB3BB   LD A,(LA269)
;B3BE    AND A
;B3BF    RET Z
;B3C0    CALL LA5D3
;B3C3    CALL LB68F
;B3C6    CALL LB41E
;B3C9    CALL LB316
;B3CC    CALL LA47C
;B3CF    CALL LA9EB
;B3D2    CALL LA97F
;B3D5    JP LA89A

LB3BB   lda game_on ; LD A,(LA269)
        ; AND  A
        bne *+3 ; RET Z
        rts
        jsr LA5D3 ; CALL LA5D3
        jsr LB68F ; CALL LB68F
        jsr LB41E ; CALL LB41E
        jsr LB316 ; CALL LB316
        jsr LA47C ; CALL LA47C
        jsr LA9EB ; CALL LA9EB
        jsr LA97F ; CALL LA97F
        jmp LA89A ; JP LA89A

;B3D8    CALL LB612
;B3DB    JR NC,@@131
;B3DD    LD A,01
;B3DF    LD (LA20A),A
;B3E2    JR @@132

LB3D8   jsr LB612 ; CALL LB612
        jcs @@131 ; JR NC,@@131
        lda #$01 ; LD A,01
        sta LA20A ; LD (LA20A),A
        jmp @@132 ; JR @@132

;@@131   CALL LB62F
;B3E7    JP C,LB752
;B3EA    LD A,(IX+05)
;B3ED    CALL LCCBB
;B3F0    LD A,(IX+07)
;B3F3    PUSH AF
;B3F4    CALL LCD85
;B3F7    POP AF
;B3F8    CALL LAED1
;B3FB    CALL LCCDE
;B3FE    CALL LB828
;B401    CALL LCC0C
;B404    CALL LCCA7
;@@132   CALL LCB22
;B40A    EX AF,AF'
;B40B    LD L,A
;B40C    LD A,(LA262)
;B40F    ADD A,A
;B410    AND 06
;B412    JR NZ,@@133
;B414    LD A,02
;@@133   ADD A,L
;B417    EX AF,AF'
;B418    LD HL,LA232
;B41B    JP LCB59

@@131   jsr LB62F ; CALL LB62F
        jcc LB752 ; JP C,LB752
        ldy #$05 ; LD A,(IX+05)
        lda (z80_ix),y
        jsr LCCBB ; CALL LCCBB
        ldy #$07 ; LD A,(IX+07)
        lda (z80_ix),y
        pha ; PUSH AF
        php
        jsr LCD85 ; CALL LCD85
        plp ; POP AF
        pla
        jsr LAED1 ; CALL LAED1
        jsr LCCDE ; CALL LCCDE
        jsr LB828 ; CALL LB828
        jsr LCC0C ; CALL LCC0C
        jsr LCCA7 ; CALL LCCA7
@@132   jsr LCB22 ; CALL LCB22
        ldx z80_ap ; EX AF,AF'
        sta z80_ap
        txa ; 
        sta z80_l ; LD L,A
        lda BanditId ; LD A,(LA262)
        asl @ ; ADD A,A
        and #$06 ; AND 06
        jne @@133 ; JR NZ,@@133
        lda #$02 ; LD A,02
@@133   clc ; ADD A,L
        adc z80_l
        ldx z80_ap ; EX AF,AF'
        sta z80_ap
        txa ; TODO: EX   AF,AF'
        lda #<LA232 ; LD HL,LA232
        sta z80_l
        lda #>LA232
        sta z80_h
        jmp LCB59 ; JP LCB59

;LB41E   LD DE,LA2BB
;B421    LD A,(DE)
;B422    AND A
;B423    RET NZ
;B424    PUSH DE
;B425    POP IY
;B427    LD HL,LB482
;B42A    LD BC,L0010
;B42D    LDIR
;B42F    LD A,(LA218)
;B432    AND 0F
;B434    LD L,A
;B435    LD A,(LA219)
;B438    AND 0F
;B43A    LD H,A
;B43B    LD (IY+02),L
;B43E    LD (IY+04),H
;B441    CALL LC727
;B444    CP 01
;B446    RET Z
;B447    LD A,(LA262)
;B44A    LD HL,LB492
;B44D    CALL LD26E
;B450    LD A,(HL)
;B451    LD (IY+0A),A
;B454    LD (IY+00),0A
;B458    LD A,(LA21A)
;B45B    AND 06
;B45D    ADD A,02
;B45F    LD (IY+05),A
;B462    LD A,(LA262)
;B465    CP 10
;B467    JR C,@@134
;B469    SUB 04
;@@134   RLCA
;B46C    RLCA
;B46D    RLCA
;B46E    RLCA
;B46F    LD C,A
;B470    LD A,(LA21B)
;B473    CP C
;B474    RET NC
;B475    LD A,(IY+05)
;B478    ADD A,08
;B47A    LD (IY+05),A
;B47D    LD (IY+00),16
;B481    RET

LB41E   ;lda #<LA2BB ; LD DE,LA2BB
        ;sta z80_e
        ;lda #>LA2BB

        ;sta z80_d
        ;ldy #$00 ; LD A,(DE)
        ;lda (z80_de),y
		lda LA2BB
        ; AND  A
        beq *+3 ; RET NZ
        rts
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		;lda z80_e
		lda #<LA2BB
		sta z80_iy
		;lda z80_d
		lda #>LA2BB
		sta z80_iy+1
        ;lda #<LB482 ; LD HL,LB482
        ;sta z80_l
        ;lda #>LB482
        ;sta z80_h
        ;lda #<L0010 ; LD BC,L0010
        ;sta z80_c
        ;lda #>L0010
        ;sta z80_b
        ;jsr ldir ; LDIR
		ldy #$0f
LB41E_Loop		
		lda LB482,y
		sta (z80_iy),y
		dey
		bpl LB41E_Loop
        lda LA218 ; LD A,(LA218)
        and #$0F ; AND 0F
        sta z80_l ; LD L,A
		ldy #$02
		sta (z80_iy),y
        lda LA219 ; LD A,(LA219)
        and #$0F ; AND 0F
        sta z80_h ; LD H,A
		ldy #$04

		sta (z80_iy),y
        ;ldy #$02 ; LD (IY+02),L
        ;lda z80_l
        ;sta (z80_iy),y
        ;ldy #$04 ; LD (IY+04),H
        ;lda z80_h
        ;sta (z80_iy),y
        jsr LC727 ; CALL LC727
        cmp #$01 ; CP 01
        bne *+3 ; RET Z
        rts
        ;lda BanditId ; LD A,(LA262)
		lda BanditId
        ;ldx #<LB492 ; LD HL,LB492
        ;stx z80_l
        ;ldx #>LB492
        ;stx z80_h
        ;jsr AddAToHL ; CALL LD26E ; uses A as parameter
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		;lda LB492,x

        ldy #$0A ; LD (IY+0A),A
        sta (z80_iy),y
		tya
        ldy #$00 ; LD (IY+00),0A
        ;lda #$0A
        sta (z80_iy),y
        lda LA21A ; LD A,(LA21A)
        and #$06 ; AND 06
        clc ; ADD A,02
        adc #$02
        ldy #$05 ; LD (IY+05),A
        sta (z80_iy),y
        lda BanditId ; LD A,(LA262)
        cmp #$10 ; CP 10
        jcc @@134 ; JR C,@@134
        ;sec ; SUB 04 ; C=1

        sbc #$04; 
		
@@134   asl @ ; RLCA
        adc #$00
        asl @ ; RLCA
        adc #$00
        asl @ ; RLCA
        adc #$00
        asl @ ; RLCA
        adc #$00
        sta z80_c ; LD C,A
        lda LA21B ; LD A,(LA21B)
        cmp z80_c ; CP C
        bcc *+3 ; RET NC
        rts
        ldy #$05 ; LD A,(IY+05)
        lda (z80_iy),y
        clc ; ADD A,08
        adc #$08
        ;ldy #$05 ; LD (IY+05),A
        sta (z80_iy),y
        ldy #$00 ; LD (IY+00),16
        lda #$16
        sta (z80_iy),y
        rts ; RET

;LB482   DB 00,80,00,80,00,00,00,00
;B48A    DB 10,10,00,00,00,00

LB482   .he 00,80,00,80,00,00,00,00 ; DB 00,80,00,80,00,00,00,00
        .he 10,10,00,00,00,00 ; DB 10,10,00,00,00,00

;LB490   DW LA232

LB490   .wo LA232 ; DW LA232

;LB492   DB 00,01,02,03,04,05,06,07
;B49A    DB 08,09,0A,0B,0C,0D,0E,0F
;B4A2    DB 10,11,12,13

LB492   .he 00,01,02,03,04,05,06,07 ; DB 00,01,02,03,04,05,06,07
        .he 08,09,0A,0B,0C,0D,0E,0F ; DB 08,09,0A,0B,0C,0D,0E,0F
        .he 10,11,12,13 ; DB 10,11,12,13

;LB4A6   DB 42,55,46,46,41,4C,CF,42 ; BUFFAL.B
;B4AE    DB 49,4C,CC,42,49,4C,4C,D9 ; IL.BILL.
;B4B6    DB 54,48,45,20,4B,49,C4,53 ; THE KI.S
;B4BE    DB 55,4E,44,41,4E,43,C5,4B ; UNDANC.K
;B4C6    DB 49,C4,4A,45,53,53,C5,4A ; I.JESS.J
;B4CE    DB 41,4D,45,D3,42,55,54,43 ; AME.BUTC
;B4D6    DB C8,43,41,53,53,49,44,D9 ; .CASSID.
;B4DE    DB 4D,C1,42,41,4B,45,D2,57 ; M.BAKE.W
;B4E6    DB 49,4C,C4,42,49,4C,CC,52 ; IL.BIL.R
;B4EE    DB 55,4D,50,CF,4B,49,C4,43 ; UMP.KI.C
;B4F6    DB 4C,45,56,45,D2,4A,41,4B ; LEVE.JAK
;B4FE    DB C5,4D,49,4C,4B,49,C5,42 ; .MILKI.B
;B506    DB 41,52,20,4B,49,C4,4B,4C ; AR KI.KL
;B50E    DB 4F,4E,44,49,4B,C5,50,45 ; ONDIK.PE
;B516    DB 54,C5,42,52,4F,4E,43,CF ; T.BRONC.
;B51E    DB 43,4F,4C,41,52,41,44,CF ; COLARAD.
;B526    DB 57,41,59,4B,CF,4B,49,C4 ; WAYK.KI.
;B52E    DB 4C,4F,4E,C5,52,41,4E,47 ; LON.RANG
;B536    DB 45,D2,54,4F,4E,54,CF,A0 ; E.TONT..
;B53E    DB 51,C4,4D,43,47,52,41,D7 ; Q.MCGRA.
;B546    DB 4D,45,58,49,43,41,4E,D3 ; MEXICAN.
;B54E    DB A0,47,55,CE,53,4C,49,4E ; .GU.SLIN
;B556    DB 47,45,52,D3,42,41,4E,44 ; GER.BAND
;B55E    DB 49,54,D3,A0,48,49,4C,CC ; IT..HIL.
;B566    DB 42,49,4C,4C,59,D3 ; BILLY.

;LB4A6   .he 42,55,46,46,41,4C,CF,42 ; DB 42,55,46,46,41,4C,CF,42
;        .he 49,4C,CC,42,49,4C,4C,D9 ; DB 49,4C,CC,42,49,4C,4C,D9
;        .he 54,48,45,20,4B,49,C4,53 ; DB 54,48,45,20,4B,49,C4,53
;        .he 55,4E,44,41,4E,43,C5,4B ; DB 55,4E,44,41,4E,43,C5,4B
;        .he 49,C4,4A,45,53,53,C5,4A ; DB 49,C4,4A,45,53,53,C5,4A
;        .he 41,4D,45,D3,42,55,54,43 ; DB 41,4D,45,D3,42,55,54,43
;        .he C8,43,41,53,53,49,44,D9 ; DB C8,43,41,53,53,49,44,D9
;        .he 4D,C1,42,41,4B,45,D2,57 ; DB 4D,C1,42,41,4B,45,D2,57
;        .he 49,4C,C4,42,49,4C,CC,52 ; DB 49,4C,C4,42,49,4C,CC,52
;        .he 55,4D,50,CF,4B,49,C4,43 ; DB 55,4D,50,CF,4B,49,C4,43
;        .he 4C,45,56,45,D2,4A,41,4B ; DB 4C,45,56,45,D2,4A,41,4B
;        .he C5,4D,49,4C,4B,49,C5,42 ; DB C5,4D,49,4C,4B,49,C5,42
;        .he 41,52,20,4B,49,C4,4B,4C ; DB 41,52,20,4B,49,C4,4B,4C
;        .he 4F,4E,44,49,4B,C5,50,45 ; DB 4F,4E,44,49,4B,C5,50,45
;        .he 54,C5,42,52,4F,4E,43,CF ; DB 54,C5,42,52,4F,4E,43,CF
;        .he 43,4F,4C,41,52,41,44,CF ; DB 43,4F,4C,41,52,41,44,CF
;        .he 57,41,59,4B,CF,4B,49,C4 ; DB 57,41,59,4B,CF,4B,49,C4
;        .he 4C,4F,4E,C5,52,41,4E,47 ; DB 4C,4F,4E,C5,52,41,4E,47
;        .he 45,D2,54,4F,4E,54,CF,A0 ; DB 45,D2,54,4F,4E,54,CF,A0
;        .he 51,C4,4D,43,47,52,41,D7 ; DB 51,C4,4D,43,47,52,41,D7
;        .he 4D,45,58,49,43,41,4E,D3 ; DB 4D,45,58,49,43,41,4E,D3
;        .he A0,47,55,CE,53,4C,49,4E ; DB A0,47,55,CE,53,4C,49,4E
;        .he 47,45,52,D3,42,41,4E,44 ; DB 47,45,52,D3,42,41,4E,44
;        .he 49,54,D3,A0,48,49,4C,CC ; DB 49,54,D3,A0,48,49,4C,CC
;        .he 42,49,4C,4C,59,D3 ; DB 42,49,4C,4C,59,D3

;LB56C   DB 00,03,50,00,07,00,00,15
;B574    DB 00,00,20,00,00,25,00,00 ; .. ...
;B57C    DB 30,00,00,36,00,00,40,00 ; 0..6..@.
;B584    DB 00,56,00,00,61,00,00,70
;B58C    DB 00,00,75,00,00,80,00,00
;B594    DB 85,00,00,95,00,01,00,00
;B59C    DB 02,50,00,02,70,00,03,10
;B5A4    DB 00,03,40,00

LB56C   .he 00,03,50,00,07,00,00,15 ; DB 00,03,50,00,07,00,00,15
        .he 00,00,20,00,00,25,00,00 ; DB 00,00,20,00,00,25,00,00
        .he 30,00,00,36,00,00,40,00 ; DB 30,00,00,36,00,00,40,00
        .he 00,56,00,00,61,00,00,70 ; DB 00,56,00,00,61,00,00,70
        .he 00,00,75,00,00,80,00,00 ; DB 00,00,75,00,00,80,00,00
        .he 85,00,00,95,00,01,00,00 ; DB 85,00,00,95,00,01,00,00
        .he 02,50,00,02,70,00,03,10 ; DB 02,50,00,02,70,00,03,10
        .he 00,03,40,00 ; DB 00,03,40,00

;LB5A8   DB 1A,1B,1C

LB5A8   .he 1A,1B,1C ; DB 1A,1B,1C

;LB5AB   DB 1D,1E,1F

LB5AB   .he 1D,1E,1F ; DB 1D,1E,1F

;LB5AE   DB 0E,12,02,18,14,0E,0D,19
;B5B6    DB 10,0A,09,08,11,01,0F,04
;B5BE    DB 0D,0C,06,00,13,12,07,01
;B5C6    DB 00,09,12,16,0B,0A,04,03
;B5CE    DB 07,01,00,13,08,11,10,0A
;B5D6    DB 09,0D,0C,06,01,13,0D,19
;B5DE    DB 0B,0A,13,08,11,01,05,09
;B5E6    DB 12,16,01,05,13,03,07,0B
;B5EE    DB 0A,09,08,11,06,0F,0E,12
;B5F6    DB 11,15,17,04,08,02,06,05
;B5FE    DB 04,03,02,01,00,0E,03,07
;B606    DB 0B,0A,09,03,02,10,0F,09
;B60E    DB 08,16,06,00

; fix wrong graphic from spectrum version below...
LB5AE   .he 0E,12,02,18,14,0E,0D,19 ; DB 0E,12,02,18,14,0E,0D,19
        .he 10,0A,09,08,11,01,0F,04 ; DB 10,0A,09,08,11,01,0F,04
        .he 0D,0C,06,00,13,12,07,01 ; DB 0D,0C,06,00,13,12,07,01
        .he 00,09,12,16,0B,0A,04,03 ; DB 00,09,12,16,0B,0A,04,03
        .he 07,01,00,13,08,11,10,0A ; DB 07,01,00,13,08,11,10,0A
        .he 09,0D,0C,06,0A,13,0D,19 ; DB 09,0D,0C,06,01,13,0D,19 ; <--- fix here (change 01 to 0A)
        .he 0B,0A,13,08,11,01,05,09 ; DB 0B,0A,13,08,11,01,05,09
        .he 12,16,01,05,13,03,07,0B ; DB 12,16,01,05,13,03,07,0B
        .he 0A,09,08,11,06,0F,0E,12 ; DB 0A,09,08,11,06,0F,0E,12
        .he 11,15,17,04,08,02,06,05 ; DB 11,15,17,04,08,02,06,05
        .he 04,03,02,01,00,0E,03,07 ; DB 04,03,02,01,00,0E,03,07
        .he 0B,0A,09,03,02,10,0F,09 ; DB 0B,0A,09,03,02,10,0F,09
        .he 08,16,06,00 ; DB 08,16,06,00

;LB612   LD IY,LA28B
;B616    LD DE,L0010
;B619    LD B,03
;@@135   LD A,(IY+00)
;B61E    CP 02
;B620    JR NZ,@@136
;B622    PUSH BC
;B623    PUSH DE
;B624    CALL LB645
;B627    POP DE
;B628    POP BC
;B629    RET C
;@@136   ADD IY,DE
;B62C    DJNZ @@135
;B62E    RET

LB612   lda #<LA28B ; LD IY,LA28B
        sta z80_iy
        lda #>LA28B
        sta z80_iy+1
        ;lda #<L0010 ; LD DE,L0010
        ;sta z80_e
        ;lda #>L0010
        ;sta z80_d
        lda #$03 ; LD B,03
        sta z80_b
@@135   ldy #$00 ; LD A,(IY+00)
        lda (z80_iy),y
        cmp #$02 ; CP 02
        jne @@136 ; JR NZ,@@136
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        ;lda z80_e ; PUSH DE
        ;pha

        ;lda z80_d
        ;pha

        jsr LB645 ; CALL LB645
        ;pla ; POP DE
        ;sta z80_d
        ;pla

        ;sta z80_e
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
        bcs *+3 ; RET C
        rts; 
@@136   ;jsr add_iy_de ; ADD IY,DE
		clc
		lda #$10
		adc z80_iy
		scc:inc z80_iy+1
        dec z80_b ; DJNZ @@135
        jne @@135
        sec
        rts ; RET


;LB62F   LD A,(LA208)
;B632    AND A
;B633    RET NZ
;B634    LD IY,LA27B
;B638    LD A,(IY+00)
;B63B    CP 01
;B63D    JR Z,LB645
;B63F    CP 15
;B641    JR Z,LB645
;B643    AND A
;B644    RET

LB62F   

		lda DISABLE_COLISIONS
		beq LB62F_b
		
		sec
		rts
		
;.if CHEAT_DISABLE_COLISIONS == 1
;		sec
;		rts
;.endif
	
LB62F_b	
		lda LA208 ; LD A,(LA208)
        ; AND  A
        sec
        beq *+3 ; RET NZ
        rts
        lda #<LA27B ; LD IY,LA27B
        sta z80_iy
        lda #>LA27B
        sta z80_iy+1
        ldy #$00 ; LD A,(IY+00)
        lda (z80_iy),y
        cmp #$01 ; CP 01
        jeq LB645 ; JR Z,LB645
        cmp #$15 ; CP 15
        jeq LB645 ; JR Z,LB645
        ; AND  A
        sec
        rts ; RET

;LB645   LD A,(IY+08)
;B648    ADD A,(IX+08)
;B64B    SRL A
;B64D    LD C,A
;B64E    SRL A
;B650    ADD A,C
;B651    LD C,A
;B652    LD B,00
;B654    LD L,(IX+01)
;B657    LD H,(IX+02)
;B65A    LD E,(IY+01)
;B65D    LD D,(IY+02)
;B660    AND A
;B661    SBC HL,DE
;B663    CALL C,LD014
;B666    AND A
;B667    SBC HL,BC
;B669    RET NC
;B66A    LD A,(IY+09)
;B66D    ADD A,(IX+09)
;B670    SRL A
;B672    LD C,A
;B673    SRL A
;B675    ADD A,C
;B676    LD C,A
;B677    LD B,00
;B679    LD L,(IX+03)
;B67C    LD H,(IX+04)
;B67F    LD E,(IY+03)
;B682    LD D,(IY+04)
;B685    AND A
;B686    SBC HL,DE
;B688    CALL C,LD014
;B68B    AND A
;B68C    SBC HL,BC
;B68E    RET

LB645   ldy #$08 ; LD A,(IY+08)
        lda (z80_iy),y
        ;ldy #$08 ; ADD A,(IX+08)
        clc
        adc (z80_ix),y
        lsr @ ; SRL A
        sta z80_c ; LD C,A
        lsr @ ; SRL A
        clc ; ADD A,C
        adc z80_c
        sta z80_c ; LD C,A
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;ldy #$01 ; LD L,(IX+01)
        ;lda (z80_ix),y
        ;sta z80_l
        ;ldy #$02 ; LD H,(IX+02)
        ;lda (z80_ix),y
        ;sta z80_h
        ;ldy #$01 ; LD E,(IY+01)
        ;lda (z80_iy),y
        ;sta z80_e
        ;ldy #$02 ; LD D,(IY+02)
        ;lda (z80_iy),y
        ;sta z80_d
        ; AND  A
        ;sec
        ;jsr sbc_hl_de ; SBC HL,DE
		sec
		ldy #$01
		lda (z80_ix),y
		sbc (z80_iy),y
		sta z80_l
		iny

		lda (z80_ix),y
		sbc (z80_iy),y
		sta z80_h









        bcs *+5 ; CALL C,LD014
        jsr LD014 ; CALL C
        ; AND  A
        ;sec

        ;jsr sbc_hl_bc ; SBC HL,BC
		lda z80_l
		sbc z80_c
		sta z80_l
		lda z80_h
		sbc #$00
		sta z80_h
        bcc *+3 ; RET NC
        rts
        ldy #$09 ; LD A,(IY+09)
        lda (z80_iy),y
        ;ldy #$09 ; ADD A,(IX+09)
        clc
        adc (z80_ix),y
        lsr @ ; SRL A
        sta z80_c ; LD C,A
        lsr @ ; SRL A
        clc ; ADD A,C
        adc z80_c
        sta z80_c ; LD C,A
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;ldy #$03 ; LD L,(IX+03)
        ;lda (z80_ix),y
        ;sta z80_l
        ;ldy #$04 ; LD H,(IX+04)
        ;lda (z80_ix),y
        ;sta z80_h
        ;ldy #$03 ; LD E,(IY+03)
        ;lda (z80_iy),y
        ;sta z80_e
        ;ldy #$04 ; LD D,(IY+04)
        ;lda (z80_iy),y
        ;sta z80_d
        ; AND  A
        ;sec
        ;jsr sbc_hl_de ; SBC HL,DE
		sec
		ldy #$03
		lda (z80_ix),y
		sbc (z80_iy),y
		sta z80_l
		iny

		lda (z80_ix),y
		sbc (z80_iy),y
		sta z80_h









        bcs *+5 ; CALL C,LD014
        jsr LD014
        ; AND  A
        ;sec

        ;jsr sbc_hl_bc ; SBC HL,BC
		lda z80_l
		sbc z80_c
		sta z80_l
		lda z80_h
		sbc #$00
		sta z80_h
        rts ; RET


;LB68F   LD IY,LA30B
;B693    LD DE,L0010
;B696    LD B,04
;@@139   LD A,(IY+00)
;B69B    AND A
;B69C    JR Z,@@140
;B69E    ADD IY,DE
;B6A0    DJNZ @@139
;B6A2    RET

LB68F   
		; no townsfolk
		lda #<LA30B ; LD IY,LA30B
        sta z80_iy
        lda #>LA30B
        sta z80_iy+1
        
		lda #<L0010 ; LD DE,L0010
        sta z80_e
        lda #>L0010
        sta z80_d
        lda #$04 ; LD B,04
        sta z80_b
@@139   ldy #$00 ; LD A,(IY+00)
        lda (z80_iy),y
        ; AND  A
        jeq @@140 ; JR Z,@@140
        jsr add_iy_de ; ADD IY,DE
        dec z80_b ; DJNZ @@139
        jne @@139
        rts ; RET

;@@140   LD B,01
;B6A5    CALL LB6CB
;B6A8    RET NZ
;B6A9    CALL LB6F6
;B6AC    LD A,(LA21A)
;B6AF    AND 06
;B6B1    ADD A,04
;B6B3    LD (IY+05),A
;B6B6    LD (IY+00),06
;B6BA    LD (IY+06),01
;B6BE    LD (IY+08),10
;B6C2    LD (IY+09),10
;B6C6    LD (IY+0D),00
;B6CA    RET

@@140   lda #$01 ; LD B,01
        sta z80_b
        jsr LB6CB ; CALL LB6CB
        beq *+3 ; RET NZ
        rts
        jsr LB6F6 ; CALL LB6F6
        lda LA21A ; LD A,(LA21A)
        and #$06 ; AND 06
        clc ; ADD A,04
        adc #$04
        ldy #$05 ; LD (IY+05),A
        sta (z80_iy),y
        ldy #$00 ; LD (IY+00),06
        lda #$06
        sta (z80_iy),y
        ldy #$06 ; LD (IY+06),01
        lda #$01
        sta (z80_iy),y
        ldy #$08 ; LD (IY+08),10
        lda #$10
        sta (z80_iy),y
        ldy #$09 ; LD (IY+09),10
        lda #$10
        sta (z80_iy),y
        ldy #$0D ; LD (IY+0D),00
        lda #$00
        sta (z80_iy),y
        rts ; RET

;LB6CB   LD A,(LA27D)
;B6CE    LD L,A
;B6CF    LD A,(LA27F)
;B6D2    LD H,A
;B6D3    LD A,(LA216)
;B6D6    LD C,A
;B6D7    LD A,B
;B6D8    BIT 0,C
;B6DA    JR Z,@@141
;B6DC    NEG
;@@141   ADD A,L
;B6DF    AND 0F
;B6E1    LD L,A
;B6E2    LD A,B
;B6E3    BIT 1,C
;B6E5    JR Z,@@142
;B6E7    NEG
;@@142   ADD A,H
;B6EA    AND 0F
;B6EC    LD H,A
;B6ED    LD (IY+02),L
;B6F0    LD (IY+04),H
;B6F3    JP LC727

LB6CB   lda LA27D ; LD A,(LA27D)
        sta z80_l ; LD L,A
        lda LA27F ; LD A,(LA27F)
        sta z80_h ; LD H,A
        lda LA216 ; LD A,(LA216)
        sta z80_c ; LD C,A
        lda z80_b ; LD A,B
        ;lda z80_c ; BIT 0,C
        ;bit _bitmem0
        lsr z80_c
        ;jeq @@141 ; JR Z,@@141
        jcc @@141
        eor #$ff ; NEG
        clc
        adc #$01; A read but not set by previous instruction
@@141   clc ; ADD A,L
        adc z80_l
        and #$0F ; AND 0F
        sta z80_l ; LD L,A
        lda z80_b ; LD A,B
        ;lda z80_c ; BIT 1,C
        ;bit _bitmem1
        lsr z80_c
        ;jeq @@142 ; JR Z,@@142
        jcc @@142
        eor #$ff ; NEG
        clc
        adc #$01; A read but not set by previous instruction
@@142   clc ; ADD A,H
        adc z80_h
        and #$0F ; AND 0F
        sta z80_h ; LD H,A
        ldy #$02 ; LD (IY+02),L
        lda z80_l
        sta (z80_iy),y
        ldy #$04 ; LD (IY+04),H
        lda z80_h
        sta (z80_iy),y
        jmp LC727 ; JP LC727

;LB6F6   LD A,(LA27C)
;B6F9    AND C0
;B6FB    OR 40
;B6FD    BIT 0,C
;B6FF    JR Z,@@143
;B701    NEG
;@@143   LD (IY+01),A
;B706    LD A,(LA27E)
;B709    AND C0
;B70B    OR 40
;B70D    BIT 1,C
;B70F    JR Z,@@144
;B711    NEG
;@@144   LD (IY+03),A
;B716    RET

LB6F6   lda LA27C ; LD A,(LA27C)
        and #$C0 ; AND C0
        ora #$40 ; OR 40
        ;tax
		; workaround for error in LB6F6 routine. BC is always 5FB1 or 60b1 here
		; routine B6CB (always called before LB6F6) sets C to value of memory at A216 and calls C727 which overwrites BC with 5FB1 or 60b1
		; probably C727 was supposed to preserve BC?

        ;lda z80_c ; BIT 0,C
        ;bit _bitmem0
        ;jeq @@143 ; JR Z,@@143
        ;txa
        eor #$ff ; NEG
        clc
        adc #$01; A read but not set by previous instruction
        tax
@@143   txa
        ldy #$01 ; LD (IY+01),A
        sta (z80_iy),y
        lda LA27E ; LD A,(LA27E)
        and #$C0 ; AND C0
        ora #$40 ; OR 40
        ;tax
        ;lda z80_c ; BIT 1,C
        ;bit _bitmem1
        ;jeq @@144 ; JR Z,@@144
        ;txa
        ;eor #$ff ; NEG
        ;clc
        ;adc #$01; A read but not set by previous instruction
        ;tax
@@144   ;txa
        ldy #$03 ; LD (IY+03),A
        sta (z80_iy),y
        rts ; RET

;B717    LD A,(IX+05)
;B71A    CALL LCCBB
;B71D    LD A,(IX+07)
;B720    PUSH AF
;B721    CALL LCD85
;B724    POP AF
;B725    CALL LAED1
;B728    CALL LCCDE
;B72B    CALL LB828
;B72E    CALL LB7EE
;B731    LD C,02
;B733    CALL LB80E
;B736    JP NC,LC7AA
;B739    LD BC,LB796
;B73C    CALL LC78D
;LB73F   CALL LB612
;B742    JR C,@@145
;B744    CALL LB62F
;B747    RET NC
;B748    LD A,(IY+00)
;B74B    CP 15
;B74D    JR Z,LB776
;B74F    CALL LB776
;LB752   PUSH IX
;B754    PUSH IY
;B756    POP IX
;B758    CALL LB780
;B75B    LD A,(IX+0C)
;B75E    SUB 04
;B760    LD (IX+0C),A
;B763    POP IX
;B765    LD HL,LA28B
;B768    LD BC,L0030
;B76B    JP LD6DA

LB717   ldy #$05 ; LD A,(IX+05)
        lda (z80_ix),y
        jsr LCCBB ; CALL LCCBB
        ldy #$07 ; LD A,(IX+07)
        lda (z80_ix),y
        pha ; PUSH AF
        php; 
        jsr LCD85 ; CALL LCD85
        plp ; POP AF
        pla
        jsr LAED1 ; CALL LAED1
        jsr LCCDE ; CALL LCCDE
        jsr LB828 ; CALL LB828
        jsr LB7EE ; CALL LB7EE
        lda #$02 ; LD C,02
        sta z80_c
        jsr LB80E ; CALL LB80E
        jcs LC7AA ; JP NC,LC7AA
        lda #<LB796 ; LD BC,LB796
        sta z80_c
        lda #>LB796
        sta z80_b
        jsr LC78D ; CALL LC78D
LB73F   jsr LB612 ; CALL LB612
        jcc @@145 ; JR C,@@145
        jsr LB62F ; CALL LB62F
        bcc *+3 ; RET NC
        rts
        ldy #$00 ; LD A,(IY+00)
        lda (z80_iy),y
        cmp #$15 ; CP 15
        jeq LB776 ; JR Z,LB776
        jsr LB776 ; CALL LB776

LB752   lda z80_ix ; PUSH IX
        pha
        lda z80_ix+1
        pha
        ;lda z80_iy ; PUSH IY
        ;pha
        ;lda z80_iy+1
        ;pha
        ;pla ; POP IX
        ;sta z80_ix+1
        ;pla
        ;sta z80_ix
		lda z80_iy
		sta z80_ix

		lda z80_iy+1


		sta z80_ix+1


        jsr LB780 ; CALL LB780
        ldy #$0C ; LD A,(IX+0C)
        lda (z80_ix),y
        sec ; SUB 04
        sbc #$04
        ;ldy #$0C ; LD (IX+0C),A
        sta (z80_ix),y
        pla ; POP IX
        sta z80_ix+1
        pla
        sta z80_ix
        lda #<LA28B ; LD HL,LA28B
        sta z80_l
        lda #>LA28B
        sta z80_h
        lda #<L0030 ; LD BC,L0030
        sta z80_c
        lda #>L0030
        sta z80_b
				
        jmp old_clear_part_2 ; JP LD6DA

;@@145   LD (IY+00),07
;B772    LD (IY+0C),02
;LB776   LD BC,(LA25C)
;B77A    CALL LD340
;B77D    CALL LD389
;LB780   LD (IX+00),09
;B784    LD (IX+0C),FA
;B788    LD (IX+0D),18
;B78C    LD HL,LB7A2
;B78F    LD (IX+0E),L
;B792    LD (IX+0F),H
;B795    RET

@@145   ldy #$00 ; LD (IY+00),07
        lda #$07
        sta (z80_iy),y
        ldy #$0C ; LD (IY+0C),02
        lda #$02
        sta (z80_iy),y
LB776   lda LA25C ; LD BC,(LA25C)
        sta z80_c
        lda LA25C+1
        sta z80_b
        jsr LD340 ; CALL LD340
        jsr LD389 ; CALL LD389

LB780   ldy #$00 ; LD (IX+00),09
        lda #$09
        sta (z80_ix),y
        ldy #$0C ; LD (IX+0C),FA
        lda #$FA
        sta (z80_ix),y
        ldy #$0D ; LD (IX+0D),18
        lda #$18
        sta (z80_ix),y
        ;lda #<LB7A2 ; LD HL,LB7A2
        ;sta z80_l
        ;lda #>LB7A2

        ;sta z80_h
        ldy #$0E ; LD (IX+0E),L
        ;lda z80_l
		lda #<LB7A2
        sta (z80_ix),y
        ldy #$0F ; LD (IX+0F),H
        ;lda z80_h
		lda #>LB7A2
        sta (z80_ix),y
        rts ; RET

;LB796   DW LB79A,LB79E

LB796   .wo LB79A,LB79E ; DW LB79A,LB79E

;LB79A   DB F4,04,2D,80

LB79A   .he F4,04,2D,80 ; DB F4,04,2D,80

;LB79E   DB F4,04,2E,80

LB79E   .he F4,04,2E,80 ; DB F4,04,2E,80

;LB7A2   DB F4,00,10,80

LB7A2   .he F4,00,10,80 ; DB F4,00,10,80

;LB7A6   LD E,00
;B7A8    CALL LD6CC
;B7AB    CALL LD6D4
;B7AE    LD A,(LA23F)
;B7B1    ADD A,31
;B7B3    LD (LB7EC),A
;B7B6    LD HL,L4826
;B7B9    LD DE,LB7D8
;B7BC    CALL LAA98
;B7BF    LD HL,L48A8
;B7C2    LD DE,LB7E4
;B7C5    CALL LAA98
;B7C8    LD HL,L0000
;B7CB    CALL LAE86
;B7CE    XOR A
;B7CF    LD (LA242),A
;B7D2    LD DE,LB1CD
;B7D5    JP LAF74

;game over
;LB7A6   
game_over

		lda #$00 ; LD E,00
        sta z80_e
		
        ;jsr old_clear_colours ; CALL LD6CC
		;jsr old_screen_clear ; CALL LD6D4
        
        ;lda #00
		jsr c64clearcols		
		jsr c64clearbitmap
		
		;lda player_number ; LD A,(LA23F)
        ;clc ; ADD A,31
        ;adc #$31
        ;sta LB7EC ; LD (LB7EC),A
        
		;screen poss
		;lda #<L4826 ; LD HL,L4826
        ;sta z80_l
        ;lda #>L4826
        ;sta z80_h
		
		; game over text data
        ;lda #<LB7D8 ; LD DE,LB7D8
        ;sta z80_e
        ;lda #>LB7D8
        ;sta z80_d
        
		; print game over
		;jsr LAA98 ; CALL LAA98
		
		; screen poss
        ;lda #<L48A8 ; LD HL,L48A8
        ;sta z80_l
        ;lda #>L48A8
        ;sta z80_h
		
		; player no text
        ;lda #<LB7E4 ; LD DE,LB7E4
        ;sta z80_e
        ;lda #>LB7E4
        ;sta z80_d
		
		; print player no
        ;jsr LAA98 ; CALL LAA98

		; player 1/2 text
		;lda #158
		;sta spr_y
		;lda #120
		;sta spr_x0
		;lda #168
		;sta spr_x1
		;lda #232
		;sta spr_x2
		;lda #03
		;sta spr_col
		
		;jsr spritesastextdotcom

		;lda #$c0
		;sta dest_lo
		;lda #$de
		;sta dest_hi

		;lda #00
		;sta count_temp_02

        lda #<$d0a0
        sta dest_lo
        lda #>$d0a0
        sta dest_hi

        lda #<$d0a8
        sta source_lo
        lda #>$d0a8
		sta source_hi		
		
		jsr print_player_no

        ;game over
		lda #01
		sta alpha		
		
        lda #<$cb90
        sta dest_lo
        lda #>$cb90
        sta dest_hi

        lda #<$cb98
        sta source_lo
        lda #>$cb98
		sta source_hi

		ldx #00
@
		ldy gameoveralpha,x
		jsr font_expand
		
		ldx count_temp_03
		stx count_temp_03
		
		inx
		cpx #10
		bne @-

		; colour
		lda #$68
		sta dest_lo
		lda #$b9
		sta dest_hi
		lda #$03
		sta colourcode
		lda #240
		sta blitsize
		jsr colourblit	
		
		; game over text
;		lda #126
;		sta spr_y
;		lda #104
;		sta spr_x0
;		lda #152
;		sta spr_x1
;		lda #200
;		sta spr_x2
;		lda #248
;		sta spr_x3
;		
;		jsr spritesastextgameover
;		
;		lda #$00
;		sta dest_lo
;		lda #$f5
;		sta dest_hi
;		
;		ldx #00
;		stx count_temp_02
;@	
;		lda gameoveralpha,x
;		stx count_temp
;		tax
;		jsr fontalphablitsprite
;		ldx count_temp
;		inx
;		
;		cpx #10
;		bne @-		
	
	
	
        lda #<L0000 ; LD HL,L0000
        sta z80_l
        ;lda #>L0000
        sta z80_h
        
		; old pause
		;jsr LAE86 ; CALL LAE86
		
        lda #$00 ; XOR A
        sta LA242 ; LD (LA242),A

		; game over music play
		;lda #05
		;jsr music_play

	.if TED_SOUND == 1
		lda #11
		jsr ted_music_play
		lda #40
		sta mpwait
		jsr music_pause
		; turn music off	
		lda #05
		jsr ted_music_play		
	.else
		lda #00
		sta sound_e
		
		; game over music play
		lda #05
		jsr music_play
		
		lda #84
		sta mpwait
		jsr music_pause

		; turn music off
		lda #06
		jsr music_play		

		lda #02
		sta mpwait
		jsr music_pause_no	
		
	.endif	
		

	; turn music off	
;	.if TED_SOUND == 1
;		lda #05
;		jsr ted_music_play
;	.else
;		lda #09
;		jsr music_play	
;	.endif			
		
		; turn music off
		;lda #09
		;jsr music_play		
		
		; put pause and music in here

;		lda #00
;		sta sprite_on
;		; clear down game over sprite data from buffer
;		ldx #00
;@		
;		sta $f500,x
;		inx
;		bne @-
		
        ;lda #<LB1CD ; LD DE,LB1CD
        ;sta z80_e
        ;lda #>LB1CD
        ;sta z80_d
        ;jmp PlayAudioWaitKey ; JP LAF74

;LB7D8   DB 45,47,41,4D,45,20,20,4F ; EGAME  O
;B7E0    DB 56,45,52,00 ; VER.

;LB7D8   .he 45,47,41,4D,45,20,20,4F ; DB 45,47,41,4D,45,20,20,4F
;        .he 56,45,52,00 ; DB 56,45,52,00

;LB7E4   DB 45,50,4C,41,59,45,52,20 ; EPLAYER 

;LB7E4   .he 45,50,4C,41,59,45,52,20 ; DB 45,50,4C,41,59,45,52,20

;LB7EC   DB 3F,00

;LB7EC   .he 3F,00 ; DB 3F,00

;LB7EE   LD A,(LA24F)
;B7F1    LD B,A
;B7F2    LD A,(IX+06)
;B7F5    SUB 40
;B7F7    RLCA
;B7F8    AND 01
;B7FA    XOR B
;B7FB    LD (IX+0C),A
;B7FE    LD A,(IX+06)
;B801    AND 40
;B803    LD C,A
;B804    LD A,(IX+07)
;B807    AND BF
;B809    OR C
;B80A    LD (IX+07),A
;B80D    RET

LB7EE   lda LA24F ; LD A,(LA24F)
        sta z80_b ; LD B,A
        ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        sec ; SUB 40
        sbc #$40
        asl @ ; RLCA
        rol @
        and #$01 ; AND 01
        eor z80_b ; XOR B
        ldy #$0C ; LD (IX+0C),A
        sta (z80_ix),y
        ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        and #$40 ; AND 40
        sta z80_c ; LD C,A
        ldy #$07 ; LD A,(IX+07)
        lda (z80_ix),y
        and #$BF ; AND BF
        ora z80_c ; OR C
        ;ldy #$07 ; LD (IX+07),A
        sta (z80_ix),y
        rts ; RET

;LB80E   LD A,(LA27D)
;B811    SUB (IX+02)
;B814    JP P,LB819
;B817    NEG
;LB819   CP C
;B81A    RET NC
;B81B    LD A,(LA27F)
;B81E    SUB (IX+04)
;B821    JP P,LB826
;B824    NEG
;LB826   CP C
;B827    RET

LB80E   lda LA27D ; LD A,(LA27D)
        ldy #$02 ; SUB (IX+02)
        sec
        sbc (z80_ix),y
        jpl LB819 ; JP P,LB819
        eor #$ff ; NEG
        clc
        adc #$01
LB819   cmp z80_c ; CP C
        bcc *+3 ; RET NC
        rts
        lda LA27F ; LD A,(LA27F)
        ldy #$04 ; SUB (IX+04)
        sec
        sbc (z80_ix),y
        jpl LB826 ; JP P,LB826
        eor #$ff ; NEG
        clc
        adc #$01
LB826   cmp z80_c ; CP C
        rts ; RET

;LB828   BIT 0,(IX+07)
;B82C    JR NZ,@@147
;B82E    DEC (IX+06)
;B831    LD A,(IX+06)
;B834    AND 1F
;B836    RET NZ
;B837    BIT 5,(IX+07)
;B83B    JR NZ,@@150
;@@147   LD A,(LA218)
;B840    CP 80
;B842    LD A,(IX+06)
;B845    JR NC,@@149
;B847    ADD A,40
;@@148   LD C,A
;B84A    LD A,(LA219)
;B84D    AND 3F
;B84F    OR C
;B850    LD (IX+06),A
;B853    RET

LB828   ldy #$07 ; BIT 0,(IX+07)
        lda (z80_ix),y
        bit _bitmem0
        jne @@147 ; JR NZ,@@147
        ldy #$06 ; DEC (IX+06)
        lda (z80_ix),y
        sec
        sbc #$01
        sta (z80_ix),y
        ;ldy #$06 ; LD A,(IX+06)
        ;lda (z80_ix),y
        and #$1F ; AND 1F
        beq *+3 ; RET NZ
        rts
        ldy #$07 ; BIT 5,(IX+07)
        lda (z80_ix),y
        bit _bitmem5

        jne @@150 ; JR NZ,@@150
@@147   lda LA218 ; LD A,(LA218)
        cmp #$80 ; CP 80
        ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        jcs @@149 ; JR NC,@@149
        clc ; ADD A,40
        adc #$40
@@148   sta z80_c ; LD C,A
        lda LA219 ; LD A,(LA219)
        and #$3F ; AND 3F
        ora z80_c ; OR C
        ldy #$06 ; LD (IX+06),A
        sta (z80_ix),y
        rts ; RET

;@@149   SUB 40
;B856    JR @@148

@@149   sec ; SUB 40
        sbc #$40
        jmp @@148 ; JR @@148

;@@150   RET

@@150   rts ; RET

;LB859   LD A,(LA269)
;B85C    AND A
;B85D    RET NZ
;B85E    LD A,(LA267)
;B861    LD BC,LB867
;B864    JP LC755

LB859   lda game_on ; LD A,(LA269)
        ; AND  A
        beq *+3 ; RET NZ
        rts

		; only go in here once for each bonus game
		lda play_bonus_music
		bne notbonusgame
		
        lda LA267 ; LD A,(LA267)

; Use LA267 to check for bonus game to play bonus music - 00=in game, 01=bonus game, 02=bandit screen
; ----------------------------------		
		; skip bonus music if in bandit screen (02)
		cmp #02
		beq notbonusgame
		
	.if TED_SOUND == 0
		lda #00
		sta sound_e
		
		; play bonus music
		lda #08
		jsr music_play
	.endif
		
		; only go in here once for each bonus game
		lda #01
		sta play_bonus_music
				
notbonusgame
; ----------------------------------
	
		lda LA267
	
        ldx #<LB867 ; LD BC,LB867
        stx z80_c
        ldx #>LB867
        stx z80_b
        jmp LC755 ; JP LC755; uses A as parameter

;LB867   DW LA446,LC7DC,LB86D

LB867   .wo LA446,LC7DC,LB86D ; DW LA446,LC7DC,LB86D

;B86D    LD DE,LA27B
;B870    LD A,(DE)
;B871    AND A
;B872    RET NZ
;B873    PUSH DE
;B874    POP IY
;B876    LD HL,LB897
;B879    LD BC,L0020
;B87C    LDIR
;B87E    LD A,(LA218)
;B881    AND 07
;B883    ADD A,02
;B885    LD (IY+0A),A
;B888    LD A,(LA219)
;B88B    AND 7F
;B88D    ADD A,40
;B88F    LD (IY+02),A
;B892    XOR A
;B893    LD (LA211),A
;B896    RET

LB86D   ;lda #<LA27B ; LD DE,LA27B
        ;sta z80_e
        ;lda #>LA27B
        ;sta z80_d
        ;ldy #$00 ; LD A,(DE)
        ;lda (z80_de),y
		lda LA27B
        ; AND  A
        beq *+3 ; RET NZ
        rts
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		;lda z80_e
		lda #<LA27B
		sta z80_iy
		;lda z80_d
		lda #>LA27B
		sta z80_iy+1
        ;lda #<LB897 ; LD HL,LB897
        ;sta z80_l
        ;lda #>LB897
        ;sta z80_h
        ;lda #<L0020 ; LD BC,L0020
        ;sta z80_c
        ;lda #>L0020
        ;sta z80_b
        ;jsr ldir ; LDIR
		ldy #$1f
LB86D_Loop		
		lda LB897,y
		sta (z80_iy),y
		dey
		bpl LB86D_Loop
        lda LA218 ; LD A,(LA218)
        and #$07 ; AND 07
        clc ; ADD A,02
        adc #$02
        ldy #$0A ; LD (IY+0A),A
        sta (z80_iy),y
        lda LA219 ; LD A,(LA219)
        and #$7F ; AND 7F
        clc ; ADD A,40
        adc #$40
        ldy #$02 ; LD (IY+02),A
        sta (z80_iy),y
        lda #$00 ; XOR A
        sta LA211 ; LD (LA211),A
        rts ; RET

;LB897   DB 0C,00,70,00,60,00,00,00
;B89F    DB 20,40,00,01,00,00,00,00 ;  @......
;B8A7    DB 0E,00,00,00,00,00,00,00
;B8AF    DB 00,00,00,00,00,00

LB897   .he 0C,00,70,00,60,00,00,00 ; DB 0C,00,70,00,60,00,00,00
        .he 20,40,00,01,00,00,00,00 ; DB 20,40,00,01,00,00,00,00
        .he 0E,00,00,00,00,00,00,00 ; DB 0E,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00 ; DB 00,00,00,00,00,00

;LB8B5   DW LB8C3

LB8B5   .wo LB8C3 ; DW LB8C3

;LB8B7   DW LB8C3,LB8C7,LB8CB,LB8CF
;B8BF    DW LB8D3,LB8D7

LB8B7   .wo LB8C3,LB8C7,LB8CB,LB8CF ; DW LB8C3,LB8C7,LB8CB,LB8CF
        .wo LB8D3,LB8D7 ; DW LB8D3,LB8D7

;LB8C3   DB 00,00,01,80

LB8C3   .he 00,00,01,80 ; DB 00,00,01,80

;LB8C7   DB 00,00,02,80

LB8C7   .he 00,00,02,80 ; DB 00,00,02,80

;LB8CB   DB 00,00,03,80

LB8CB   .he 00,00,03,80 ; DB 00,00,03,80

;LB8CF   DB 00,00,04,80

LB8CF   .he 00,00,04,80 ; DB 00,00,04,80

;LB8D3   DB 00,00,05,80

LB8D3   .he 00,00,05,80 ; DB 00,00,05,80

;LB8D7   DB 00,00,06,80

LB8D7   .he 00,00,06,80 ; DB 00,00,06,80

;B8DB    LD A,(IX+F0)
;B8DE    CP 12
;B8E0    JP Z,LC7AA
;B8E3    CP 11
;B8E5    JR Z,@@151
;B8E7    CP 0C
;B8E9    JR Z,@@151
;B8EB    LD A,(IX+0C)
;B8EE    CP 05
;B8F0    JR Z,@@156
;B8F2    CALL LB9CD
;B8F5    LD A,(IX+0C)
;B8F8    LD BC,LB8B7
;B8FB    CALL LC74B
;B8FE    LD (IX+0E),L
;B901    LD (IX+0F),H
;@@151   LD A,(IX+F2)
;B907    SUB 08
;B909    LD (IX+02),A
;B90C    LD A,(IX+F0)
;B90F    CP 11
;B911    LD A,(IX+F4)
;B914    JR Z,@@155
;B916    ADD A,0C
;@@155   LD (IX+04),A
;B91B    JP LBD47

LB8DB   ldy #$F0 ; LD A,(IX+F0)
		dec z80_ix+1
        lda (z80_ix),y
		inc z80_ix+1
        cmp #$12 ; CP 12
        jeq LC7AA ; JP Z,LC7AA
        cmp #$11 ; CP 11
        jeq @@151 ; JR Z,@@151
        cmp #$0C ; CP 0C
        jeq @@151 ; JR Z,@@151
        ldy #$0C ; LD A,(IX+0C)
        lda (z80_ix),y
        cmp #$05 ; CP 05
        jeq @@156 ; JR Z,@@156
        jsr LB9CD ; CALL LB9CD
        ldy #$0C ; LD A,(IX+0C)
        lda (z80_ix),y
        ;ldx #<LB8B7 ; LD BC,LB8B7
        ;stx z80_c
        ;ldx #>LB8B7
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		asl @
		tax
		lda LB8B7,x
		sta z80_l
        ldy #$0E ; LD (IX+0E),L
        ;lda z80_l
        sta (z80_ix),y
        ;ldy #$0F ; LD (IX+0F),H
		iny
		lda LB8B7+1,x
		sta z80_h
        ;lda z80_h

        sta (z80_ix),y
@@151   ldy #$F2 ; LD A,(IX+F2)
		dec z80_ix+1
        lda (z80_ix),y
		inc z80_ix+1
        sec ; SUB 08
        sbc #$08
        ldy #$02 ; LD (IX+02),A
        sta (z80_ix),y
        ldy #$F0 ; LD A,(IX+F0)
		dec z80_ix+1
        lda (z80_ix),y
        cmp #$11 ; CP 11
        php
        ldy #$F4 ; LD A,(IX+F4)
        lda (z80_ix),y
		inc z80_ix+1
        plp
        jeq @@155 ; JR Z,@@155
        clc ; ADD A,0C
        adc #$0C
@@155   ldy #$04 ; LD (IX+04),A
        sta (z80_ix),y
        jmp LBD47 ; JP LBD47


;@@156   LD A,(IX+10)
;B921    AND A
;B922    JR NZ,@@151
;B924    LD HL,LA212
;B927    LD A,(HL)
;B928    AND A
;B929    RET M
;B92A    INC A
;B92B    CP 07
;B92D    JR Z,LB979
;B92F    LD (HL),A
;B930    PUSH IX
;B932    POP HL
;B933    LD BC,L0010
;B936    ADD HL,BC
;B937    PUSH HL
;B938    POP IY
;B93A    EX DE,HL
;B93B    LD HL,LB952
;B93E    LDIR
;B940    LD A,(IX+02)
;B943    ADD A,08
;B945    LD (IY+02),A
;B948    LD A,(IX+04)
;B94B    ADD A,06
;B94D    LD (IY+04),A
;B950    JR @@151

@@156   ldy #$10 ; LD A,(IX+10)
        lda (z80_ix),y
        ; AND  A
        jne @@151 ; JR NZ,@@151
        ;lda #<LA212 ; LD HL,LA212
        ;sta z80_l
        ;lda #>LA212
        ;sta z80_h
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		lda LA212
        ; AND  A
        bpl *+3 ; RET M
        rts
        clc ; INC A
        adc #$01
        cmp #$07 ; CP 07
        jeq LB979 ; JR Z,LB979
        ;ldy #$00 ; LD (HL),A
        ;sta (z80_hl),y
		sta LA212
        ;lda z80_ix ; PUSH IX
        ;pha
        ;lda z80_ix+1
        ;pha
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
		lda z80_ix
		sta z80_l
		lda z80_ix+1
		sta z80_h
        lda #<L0010 ; LD BC,L0010
        sta z80_c
        lda #>L0010
        sta z80_b
        jsr add_hl_bc ; ADD HL,BC
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		lda z80_l
		sta z80_iy
		sta z80_e
		lda z80_h
		sta z80_iy+1
		sta z80_d
        ;jsr ex_de_hl ; EX DE,HL
        lda #<LB952 ; LD HL,LB952
        sta z80_l
        lda #>LB952
        sta z80_h
        jsr ldir ; LDIR
        ldy #$02 ; LD A,(IX+02)
        lda (z80_ix),y
        clc ; ADD A,08
        adc #$08
        ;ldy #$02 ; LD (IY+02),A
        sta (z80_iy),y
        ldy #$04 ; LD A,(IX+04)
        lda (z80_ix),y
        clc ; ADD A,06
        adc #$06
        ;ldy #$04 ; LD (IY+04),A
        sta (z80_iy),y
        jmp @@151 ; JR @@151


;LB952   DB 0F,00,00,00,00,00,00,00
;B95A    DB 00,00,00,00,00,00

LB952   .he 0F,00,00,00,00,00,00,00 ; DB 0F,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00 ; DB 00,00,00,00,00,00

;LB960   DW LB962

LB960   .wo LB962 ; DW LB962

;LB962   DB 00,00

LB962   .he 00,00 ; DB 00,00

;LB964   DB 00,80

LB964   .he 00,80 ; DB 00,80

;B966    LD A,(IX+0C)
;B969    CP 04
;B96B    JR Z,@@158
;B96D    INC A
;B96E    LD (IX+0C),A
;B971    ADD A,06
;B973    LD (LB964),A
;B976    JP LBD47

LB966   ldy #$0C ; LD A,(IX+0C)
        lda (z80_ix),y
        cmp #$04 ; CP 04
        jeq @@158 ; JR Z,@@158
        clc ; INC A
        adc #$01
        ;ldy #$0C ; LD (IX+0C),A
        sta (z80_ix),y
        clc ; ADD A,06
        adc #$06
        sta LB964 ; LD (LB964),A
        jmp LBD47 ; JP LBD47

;LB979   XOR A
;B97A    LD (LA266),A
;B97D    JP LC7B7

LB979   lda #$00 ; XOR A
        sta LA266 ; LD (LA266),A
        jmp LC7B7 ; JP LC7B7

;@@158   LD HL,LA33B
;B983    LD DE,LFFF0
;B986    LD B,0D
;@@159   LD A,(HL)
;B989    AND A
;B98A    JR Z,@@160
;B98C    ADD HL,DE
;B98D    DJNZ @@159
;B98F    RET

@@158   lda #<LA33B ; LD HL,LA33B
        sta z80_l
        lda #>LA33B
        sta z80_h
        lda #<LFFF0 ; LD DE,LFFF0
        sta z80_e
        lda #>LFFF0
        sta z80_d
        lda #$0D ; LD B,0D
        sta z80_b
@@159   ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        ; AND  A
        jeq @@160 ; JR Z,@@160
        jsr add_hl_de ; ADD HL,DE
        dec z80_b ; DJNZ @@159
        jne @@159
        rts ; RET

;@@160   EX DE,HL
;B991    PUSH DE
;B992    POP IY
;B994    LD HL,LB9B6
;B997    LD BC,L0010
;B99A    LDIR
;B99C    LD A,(LA218)
;B99F    AND 7F
;B9A1    ADD A,38
;B9A3    LD (IY+02),A
;B9A6    LD A,(LA219)
;B9A9    AND 3F
;B9AB    ADD A,60
;B9AD    LD (IY+04),A
;B9B0    CALL LAE96
;B9B3    JP LC7AA

@@160   ;jsr ex_de_hl ; EX DE,HL
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		lda z80_l
		sta z80_e
		sta z80_iy
		lda z80_h
		sta z80_d
		sta z80_iy+1
        lda #<LB9B6 ; LD HL,LB9B6
        sta z80_l
        lda #>LB9B6
        sta z80_h
        lda #<L0010 ; LD BC,L0010
        sta z80_c
        lda #>L0010
        sta z80_b
        jsr ldir ; LDIR
        lda LA218 ; LD A,(LA218)
        and #$7F ; AND 7F
        clc ; ADD A,38
        adc #$38
        ldy #$02 ; LD (IY+02),A
        sta (z80_iy),y
        lda LA219 ; LD A,(LA219)
        and #$3F ; AND 3F
        clc ; ADD A,60
        adc #$60
        ldy #$04 ; LD (IY+04),A
        sta (z80_iy),y
        jsr LAE96 ; CALL LAE96
        jmp LC7AA ; JP LC7AA

;LB9B6   DB 10,00,00,00,00,00,00,00
;B9BE    DB 00,00,00,00,00,00

LB9B6   .he 10,00,00,00,00,00,00,00 ; DB 10,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00 ; DB 00,00,00,00,00,00

;LB9C4   DW LB9C6

LB9C4   .wo LB9C6 ; DW LB9C6

;LB9C6   DB F0,F0,0B,80

LB9C6   .he F0,F0,0B,80 ; DB F0,F0,0B,80

;B9CA    JP LBD47

LB9CA    jmp LBD47 ; JP LBD47

;LB9CD   LD A,(LA211)
;B9D0    CP 01
;B9D2    JR Z,@@162
;B9D4    LD A,(IX+05)
;B9D7    AND A
;B9D8    JR Z,@@161
;B9DA    DEC (IX+05)
;B9DD    RET

; bandit gun pause
LB9CD
				
        ldy #$05 ; LD A,(IX+05)
        lda (z80_ix),y
		
		; *** 00
		
        ; AND  A
        jeq @@161 ; JR Z,@@161
        ;ldy #$05 ; DEC (IX+05)
        ;lda (z80_ix),y
        sec
        sbc #$01
        sta (z80_ix),y

		; *** 06
		
        rts ; RET

;@@161   LD A,(LA263)
;B9E1    CPL
;B9E2    AND 07
;B9E4    LD (IX+05),A
;@@162   INC (IX+0C)
;B9EA    RET

@@161   

		lda LA211 ; LD A,(LA211)
        cmp #$01 ; CP 01
        jeq @@162_1 ; JR Z,@@162

		lda LA263 ; LD A,(LA263)
        eor #$ff ; CPL
        and #$07 ; AND 07 ; *******************
		jmp @@162_2	
		
		;*** 07

@@162_1

		lda LA263 ; LD A,(LA263)
        eor #$ff ; CPL
        and #$01 ; AND 07 ; *******************
		
@@162_2		
		
		ldy #$05 ; LD (IX+05),A
        sta (z80_ix),y
		
		; jump here direct if yellow draw
@@162

		;*** 01

		ldy #$0C ; INC (IX+0C)
        lda (z80_ix),y
        clc
        adc #$01
        sta (z80_ix),y

		;*** 01
		
		rts ; RET

;B9EB    CALL LBA7B
;B9EE    DEC (IX+0B)
;B9F1    LD A,(IX+0B)
;B9F4    JR NZ,@@163
;B9F6    OR (IX+0A)
;B9F9    JP Z,LBAA1
;B9FC    CALL LBC27
;@@163   CALL LBBCD
;BA02    LD A,(IX+05)
;BA05    AND 0F
;BA07    JR Z,@@164
;BA09    LD (IX+0B),01
;@@164   CALL LBBBA
;LBA10   CALL LBA53
;BA13    JR NC,@@165
;BA15    LD A,80
;BA17    LD (LA212),A
;BA1A    LD (IX+00),11
;BA1E    LD (IX+0C),00
;@@165   LD A,(IX+02)
;BA25    LD L,A
;BA26    LD (LA220),A
;BA29    LD H,(IX+04)
;BA2C    CALL LD22C
;BA2F    CALL LBC5C
;BA32    LD B,03
;BA34    CALL LB27E
;LBA37   LD A,(LA262)
;BA3A    EX DE,HL
;BA3B    LD HL,LB492
;BA3E    CALL LD26E
;BA41    LD L,(HL)
;BA42    LD H,00
;BA44    LD C,L
;BA45    LD B,H
;BA46    ADD HL,HL
;BA47    ADD HL,HL
;BA48    ADD HL,BC
;BA49    LD BC,LB5AE
;BA4C    ADD HL,BC
;BA4D    EX DE,HL
;BA4E    LD B,05
;BA50    JP LB27E

; bandit
LB9EB		

		
		ldx BANDIT_STUCK
		bne @@163

		jsr fight_bandit_draw ; CALL LBA7B
        ldy #$0B ; DEC (IX+0B)
        lda (z80_ix),y
        sec
        sbc #$01
        sta (z80_ix),y
        ;ldy #$0B ; LD A,(IX+0B)
        ;lda (z80_ix),y
        jne @@163 ; JR NZ,@@163

		ldy #$0A ; OR (IX+0A)
        ora (z80_ix),y
        
		jeq LBAA1 ; JP Z,LBAA1  *******      
		
		jsr LBC27 ; CALL LBC27
		
@@163   jsr LBBCD ; CALL LBBCD
        ldy #$05 ; LD A,(IX+05)
        lda (z80_ix),y
        and #$0F ; AND 0F
        jeq @@164 ; JR Z,@@164
        ldy #$0B ; LD (IX+0B),01
        lda #$01
        sta (z80_ix),y
@@164   jsr LBBBA ; CALL LBBBA

LBA10
				
		jsr LBA53 ; CALL LBA53
        jcs @@165 ; JR NC,@@165
        lda #$80 ; LD A,80
        sta LA212 ; LD (LA212),A
        ldy #$00 ; LD (IX+00),11
        lda #$11
        sta (z80_ix),y
        ldy #$0C ; LD (IX+0C),00
        lda #$00
        sta (z80_ix),y
@@165   ldy #$02 ; LD A,(IX+02)
        lda (z80_ix),y
        sta z80_l ; LD L,A
        sta LA220 ; LD (LA220),A
        ldy #$04 ; LD H,(IX+04)
        lda (z80_ix),y
        sta z80_h
        jsr GetPointerInBackgroundBuffer ; CALL LD22C

        jsr LBC5C ; CALL LBC5C
        lda #$03 ; LD B,03
        sta z80_b
        jsr LB27E ; CALL LB27E
		
LBA37   ;ldx BanditId ; LD A,(LA262)
        ;sta z80_a
        ;jsr ex_de_hl ; EX DE,HL
		jsr ld_de_hl

		; LD HL,LB492
        ;jsr AddAToHL ; CALL LD26E ; uses A as parameter

		;lda LB492,x ; LD L,(HL) ; LB492 is identity table
		lda BanditId ; LD A,(LA262)
        sta z80_c
        ldy #$00 ; LD H,00
        sty z80_h
        ;lda z80_l ; LD C,L
        ;sta z80_c
        ;lda z80_h ; LD B,H
        ;sta z80_b
        ;asl z80_l ; ADD HL,HL
        ;rol z80_h
        ;asl z80_l ; ADD HL,HL
        ;rol z80_h
		asl @
		rol z80_h

		asl @
		rol z80_h
		adc z80_c
		scc:inc z80_h
        ;jsr add_hl_bc ; ADD HL,BC
        ;lda #<LB5AE ; LD BC,LB5AE
        ;sta z80_c
        ;lda #>LB5AE
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
		clc
		adc #<LB5AE
		sta z80_l
		lda z80_h
		adc #>LB5AE
		sta z80_h
        jsr ex_de_hl ; EX DE,HL
        lda #$05 ; LD B,05
        sta z80_b
        jmp LB27E ; JP LB27E

;LBA53   LD A,(LA212)
;BA56    AND A
;BA57    RET NZ
;BA58    LD IY,LA34B
;BA5C    LD A,(IY+00)
;BA5F    AND A
;BA60    RET Z
;BA61    LD A,(IX+02)
;BA64    ADD A,04
;BA66    SUB (IY+02)
;BA69    NEG
;BA6B    CP 18
;BA6D    RET NC
;BA6E    LD A,(IX+04)
;BA71    ADD A,0C
;BA73    SUB (IY+04)
;BA76    NEG
;BA78    CP 30
;BA7A    RET

LBA53   
		
		lda LA212 ; LD A,(LA212)
        ; AND  A
        		
		beq *+4 ; RET NZ
        
		sec
        rts
				
        lda #<LA34B ; LD IY,LA34B
        sta z80_iy
        lda #>LA34B
        sta z80_iy+1
        ldy #$00 ; LD A,(IY+00)
        lda (z80_iy),y
        ; AND  A
        bne *+4 ; RET Z
        sec
		rts
		
		
        ldy #$02 ; LD A,(IX+02)
        lda (z80_ix),y
        clc ; ADD A,04
        adc #$04
        ;ldy #$02 ; SUB (IY+02)
        		
		sec
        sbc (z80_iy),y
        eor #$ff ; NEG
        clc
        adc #$01
        cmp #$18 ; CP 18
        bcc *+3 ; RET NC
        rts
        
		ldy #$04 ; LD A,(IX+04)
        lda (z80_ix),y
        clc ; ADD A,0C
        adc #$0C
        ;ldy #$04 ; SUB (IY+04)
        sec
        sbc (z80_iy),y
        eor #$ff ; NEG
        clc
        adc #$01
        cmp #$30 ; CP 30
        rts ; RET

;LBA7B   LD A,(IX+06)
;BA7E    AND A
;BA7F    RET NZ
;BA80    CALL LD0DC
;BA83    AND A
;BA84    RET Z
;BA85    LD A,01
;BA87    LD (IX+06),A
;BA8A    LD (IX+0A),A
;BA8D    LD (IX+0B),A
;BA90    LD HL,LA211
;BA93    LD A,(HL)
;BA94    AND A
;BA95    RET NZ
;BA96    LD (HL),01
;BA98    LD HL,L502E
;BA9B    LD DE,LBAC2
;BA9E    JP LAA98

; draw start
;LBA7B

fight_bandit_draw   
		
		ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        ; AND  A
        beq *+3 ; RET NZ
        rts
		
        jsr CheckUserInput ; CALL LD0DC
        		
		; AND  A
        bne *+3 ; RET Z
        rts
				
        lda #$01 ; LD A,01
        ldy #$06 ; LD (IX+06),A
        sta (z80_ix),y
        ldy #$0A ; LD (IX+0A),A
        sta (z80_ix),y
        ldy #$0B ; LD (IX+0B),A
        sta (z80_ix),y

        ;lda #<LA211 ; LD HL,LA211
        ;sta z80_l
        ;lda #>LA211
        ;sta z80_h
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		lda LA211
        ; AND  A
        beq *+3 ; RET NZ
        rts
        lda #$01 ; LD (HL),01
        ;ldy #$00
        ;sta (z80_hl),y
		sta LA211
		
		; screen poss
        ;lda #<L502E ; LD HL,L502E
        ;sta z80_l
        ;lda #>L502E
        ;sta z80_h
        
		; text
		;lda #<LBAC2 ; LD DE,LBAC2
        ;sta z80_e
        ;lda #>LBAC2
        ;sta z80_d
		
		; print font
        ;jmp LAA98 ; JP LAA98
		
		;lda #02
		;sta border
		
		;yellow
		;lda #07
		;sta spr_col
		;jsr spritebanditdrawtxt

		lda #$07
		sta colourcode		
		jsr drawtexttoscreen
				
		
;LBAA1   LD (IX+00),0D
;BAA5    LD HL,LA211
;BAA8    LD A,(HL)
;BAA9    AND A
;BAAA    JR NZ,@@166
;BAAC    LD (HL),02
;BAAE    LD HL,L502E
;BAB1    LD DE,LBABA
;BAB4    CALL LAA98
;@@166   JP LBA10

; draw 2
LBAA1   
		ldy #$00 ; LD (IX+00),0D
        lda #$0D
        sta (z80_ix),y
        ;lda #<LA211 ; LD HL,LA211
        ;sta z80_l
        ;lda #>LA211
        ;sta z80_h
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		lda LA211
        ; AND  A
        jne @@166 ; JR NZ,@@166
        lda #$02 ; LD (HL),02
        ;ldy #$00
        ;sta (z80_hl),y
		sta LA211
		
		; screen poss
        ;lda #<L502E ; LD HL,L502E
        ;sta z80_l
        ;lda #>L502E
        ;sta z80_h
        
		; text 
		;lda #<LBABA ; LD DE,LBABA
        ;sta z80_e
        ;lda #>LBABA
        ;sta z80_d
		
		; print font
        ;jsr LAA98 ; CALL LAA98

		;lda #07
		;sta border
		
		;red
		;lda #02
		;sta spr_col
		;jsr spritebanditdrawtxt

		lda #$02
		sta colourcode		
		jsr drawtexttoscreen
		
		
@@166   jmp LBA10 ; JP LBA10

;LBABA   DB 42,44,52,41,57,5D,5D,00 ; BDRAW]]. RED

;LBABA   .he 42,44,52,41,57,5D,5D,00 ; DB 42,44,52,41,57,5D,5D,00

;LBAC2   DB 46,44,52,41,57,5D,5D,00 ; FDRAW]]. YELLOW

;LBAC2   .he 46,44,52,41,57,5D,5D,00 ; DB 46,44,52,41,57,5D,5D,00

;BACA    JP LBA10

LBACA    jmp LBA10 ; JP LBA10

;BACD    INC (IX+0C)
;BAD0    LD A,(IX+0C)
;BAD3    CP 06
;BAD5    JR Z,@@167
;BAD7    LD A,(IX+02)
;BADA    LD L,A
;BADB    LD (LA220),A
;BADE    LD H,(IX+04)
;BAE1    CALL LD22C
;BAE4    LD DE,LBBB8
;BAE7    LD B,02
;BAE9    CALL LB27E
;BAEC    LD BC,LFF88
;BAEF    ADD HL,BC
;BAF0    JP LBA37

LBACD
				
		ldy #$0C ; INC (IX+0C)
        lda (z80_ix),y
        clc
        adc #$01
        sta (z80_ix),y
        ;ldy #$0C ; LD A,(IX+0C)
        ;lda (z80_ix),y
        cmp #$06 ; CP 06
        jeq @@167 ; JR Z,@@167
        ldy #$02 ; LD A,(IX+02)
        lda (z80_ix),y
        sta z80_l ; LD L,A
        sta LA220 ; LD (LA220),A
        ldy #$04 ; LD H,(IX+04)
        lda (z80_ix),y
        sta z80_h
        
	jsr GetPointerInBackgroundBuffer ; CALL LD22C
	;jsr LD22C ; CALL LD22C
        
	lda #<LBBB8 ; LD DE,LBBB8
        sta z80_e
        lda #>LBBB8
        sta z80_d
        lda #$02 ; LD B,02
        sta z80_b
        jsr LB27E ; CALL LB27E
        lda #<LFF88 ; LD BC,LFF88
        sta z80_c
        lda #>LFF88
        sta z80_b
        jsr add_hl_bc ; ADD HL,BC
        jmp LBA37 ; JP LBA37

;@@167   LD (IX+00),12
;BAF7    LD (IX+0C),00
;BAFB    LD A,(IX+0C)
;BAFE    CP 03
;BB00    JR Z,@@168
;BB02    LD E,A
;BB03    LD BC,LBBAB
;BB06    CALL LC74B
;BB09    EX DE,HL
;BB0A    LD A,L
;BB0B    NEG
;BB0D    ADD A,04
;BB0F    LD B,A
;BB10    LD A,(IX+02)
;BB13    LD L,A
;BB14    LD (LA220),A
;BB17    LD H,(IX+04)
;BB1A    CALL LD22C
;BB1D    CALL LB27E
;BB20    LD A,(LA216)
;BB23    AND 03
;BB25    RET NZ
;BB26    INC (IX+0C)
;BB29    RET

; bandit die
@@167   ldy #$00 ; LD (IX+00),12
        lda #$12
		sta (z80_ix),y
        ldy #$0C ; LD (IX+0C),00
        lda #$00
        sta (z80_ix),y
LBAFB   ldy #$0C ; LD A,(IX+0C)
        lda (z80_ix),y
        cmp #$03 ; CP 03
        jeq @@168 ; JR Z,@@168
        ;sta z80_e ; LD E,A
		sta z80_l
        ;ldx #<LBBAB ; LD BC,LBBAB
        ;stx z80_c
        ;ldx #>LBBAB
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		asl @
		tax
		lda LBBAB,x
		sta z80_e
		lda LBBAB+1,x
		sta z80_d
        ;jsr ex_de_hl ; EX DE,HL
        lda z80_l ; LD A,L
        eor #$ff ; NEG
        clc
        adc #$01
        clc ; ADD A,04
        adc #$04
        sta z80_b ; LD B,A
        ldy #$02 ; LD A,(IX+02)
        lda (z80_ix),y
        sta z80_l ; LD L,A
        sta LA220 ; LD (LA220),A
        ldy #$04 ; LD H,(IX+04)
        lda (z80_ix),y
        sta z80_h
        jsr GetPointerInBackgroundBuffer ; CALL LD22C

        jsr LB27E ; CALL LB27E
        lda LA216 ; LD A,(LA216)
        and #$03 ; AND 03
        beq *+3 ; RET NZ
        rts
        ldy #$0C ; INC (IX+0C)
        lda (z80_ix),y
        clc
        adc #$01
        sta (z80_ix),y
        rts ; RET


;@@168   LD DE,LB0A7
;BB2D    CALL LAF8D
;BB30    LD A,(LA262)
;BB33    LD C,A
;BB34    ADD A,A
;BB35    ADD A,C
;BB36    LD HL,LB56C
;BB39    CALL LD26E
;BB3C    INC HL
;BB3D    INC HL
;BB3E    LD C,(HL)
;BB3F    DEC HL
;BB40    LD B,(HL)
;BB41    DEC HL
;BB42    EX DE,HL
;BB43    CALL LD34D
;BB46    LD A,(DE)
;BB47    ADD A,(HL)
;BB48    DAA
;BB49    LD (HL),A
;BB4A    CALL LD389
;BB4D    LD HL,LA265
;BB50    INC (HL)
;BB51    LD HL,LA262
;BB54    INC (HL)
;BB55    LD A,(HL)
;BB56    CP 14
;BB58    JR C,@@169
;BB5A    LD A,10
;BB5C    LD (HL),A
;@@169   AND 01
;BB5F    JR NZ,@@170
;BB61    LD HL,LA263
;BB64    LD A,(HL)
;BB65    CP 07
;BB67    JR Z,@@170
;BB69    INC (HL)
;@@170   LD A,(LA262)
;BB6D    AND 03
;BB6F    JP NZ,LB979
;BB72    CALL LD0B0
;BB75    CALL LD0AD
;BB78    LD HL,L40EB
;BB7B    LD DE,LBBA4
;BB7E    CALL LAA98
;BB81    LD DE,LB1DE
;BB84    CALL LAF8D
;BB87    LD B,02
;BB89    LD HL,L0000
;BB8C    CALL LAE80
;BB8F    LD HL,L0114
;BB92    LD (LA266),HL
;BB95    CALL LC7B7
;BB98    LD A,46
;BB9A    LD (LA268),A
;BB9D    LD HL,LA265
;BBA0    INC (HL)
;BBA1    JP LA3B1

@@168   
		;lda #<LB0A7 ; LD DE,LB0A7
        ;sta z80_e
        ;lda #>LB0A7
        ;sta z80_d
        ;jsr PlayAudio ; CALL LAF8D
		
		; bandit draw music play
		;lda #03
		;jsr music_play
	
	.if TED_SOUND == 1
		lda #03
		jsr ted_music_play
		lda #60
		sta mpwait
		jsr music_pause_no
	.else
		lda #00
		sta sound_e
		
		; turn music off first
		lda #06
		jsr music_play
		
		lda #02
		sta mpwait
		jsr music_pause_no
	
		; bandit killed music play
		lda #07
		jsr music_play
		
		lda #10
		sta mpwait
		jsr music_pause_no
		
		lda #48
		sta mpwait
		jsr music_pause

		; turn music off
		lda #06
		jsr music_play	
        
		lda #02
		sta mpwait
		jsr music_pause_no
		
	.endif	
		

	; turn music off	
;	.if TED_SOUND == 1
;		lda #05
;		jsr ted_music_play
;	.else
;		lda #09
;		jsr music_play	
;	.endif			
		
		; turn music off
		;lda #09
		;jsr music_play	
        
		lda BanditId ; LD A,(LA262)
        sta z80_c ; LD C,A
        asl @ ; ADD A,A
        clc ; ADD A,C
        adc z80_c
        ldx #<LB56C ; LD HL,LB56C
        stx z80_l
        ldx #>LB56C
        stx z80_h

        jsr LD26E ; CALL LD26E ; uses A as parameter
        
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ;ldy #$00 ; LD C,(HL)
		ldy #$02
        lda (z80_hl),y
        sta z80_c
        ;jsr dec_hl ; DEC HL
        ;ldy #$00 ; LD B,(HL)
		ldy #$01
        lda (z80_hl),y
        sta z80_b
        ;jsr dec_hl ; DEC HL
        jsr ex_de_hl ; EX DE,HL
		
		jsr LD34D ; CALL LD34D
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        sed
        clc
        adc LA25B-2
        cld
		sta LA25B-2
        jsr LD389 ; CALL LD389
		
				
        ;lda #<no_of_lives ; LD HL,LA265
        ;sta z80_l
        ;lda #>no_of_lives
        ;sta z80_h
        ;ldy #$00 ; INC (HL)
        ;lda (z80_hl),y
        ;clc

        ;adc #$01
        ;sta (z80_hl),y
				
		inc no_of_lives
		
        ;lda #<BanditId ; LD HL,LA262
        ;sta z80_l
        ;lda #>BanditId
        ;sta z80_h
        ;ldy #$00 ; INC (HL)
        ;lda (z80_hl),y
        ;clc
        ;adc #$01
        ;sta (z80_hl),y
		
		; move onto next bandit
		inc BanditId

		
			
	;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y

	lda BanditId        
	cmp #$14 ; CP 14
        jcc @@169 ; JR C,@@169
        lda #$10 ; LD A,10
        ;ldy #$00 ; LD (HL),A
        ;sta (z80_hl),y
	sta BanditId

@@169   and #$01 ; AND 01
        jne @@170 ; JR NZ,@@170
        
	;lda #<LA263 ; LD HL,LA263
        ;sta z80_l
        ;lda #>LA263
        ;sta z80_h
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y

	lda LA263
        cmp #$07 ; CP 07
        jeq @@170 ; JR Z,@@170

        ;ldy #$00 ; INC (HL)
        ;lda (z80_hl),y
        ;clc

        ;adc #$01
        ;sta (z80_hl),y

	inc LA263

@@170   lda BanditId ; LD A,(LA262)
        and #$03 ; AND 03
        jne LB979 ; JP NZ,LB979
        jsr LD0B0 ; CALL LD0B0
		
        jsr BlitBufferToScreenAndClearBuffer ; CALL LD0AD
		
		
		; bonus text poss
		;lda #<L40EB ; LD HL,L40EB
        ;sta z80_l
        ;lda #>L40EB
        ;sta z80_h
		
		; bonus text data
        ;lda #<LBBA4 ; LD DE,LBBA4
        ;sta z80_e
        ;lda #>LBBA4
        ;sta z80_d
		
		; blit bonus text to screen
        ;jsr LAA98 ; CALL LAA98
        
		
		lda #01
		sta alpha		
		
        lda #<$c938
        sta dest_lo
        lda #>$c938
        sta dest_hi

        lda #<$c940
        sta source_lo
        lda #>$c940
		sta source_hi

		ldx #00
@
		ldy bonusalpha,x
		jsr font_expand
		
		ldx count_temp_03
		stx count_temp_03
		
		inx
		cpx #05
		bne @-		

		lda #$27
		sta dest_lo
		lda #$b9
		sta dest_hi

		lda #$07
		sta colourcode	
		
		lda #10
		sta blitsize
		jsr colourblit

		lda #40
		jsr addadest
		
		jsr colourblit
		
		;lda #02
		;sta bandit_screen		
		
		;lda #<LB1DE ; LD DE,LB1DE
        ;sta z80_e
        ;lda #>LB1DE
        ;sta z80_d
        ;jsr PlayAudio ; CALL LAF8D
        
 		; play extra bonus music
		;lda #04
		;jsr music_play
	
	.if TED_SOUND == 1
		lda #04
		jsr ted_music_play
		; pause length
		lda #08 ; LD B,02
        sta z80_b
	.else
		lda #00
		sta sound_e
		
 		; play extra bonus music
		lda #04
		jsr music_play

		lda #10
		sta mpwait
		jsr music_pause_no
		
		lda #76
		sta mpwait
		jsr music_pause
		
		; pause length
		lda #00 ; LD B,02
        sta z80_b		
	.endif	
		
        lda #<L0000 ; LD HL,L0000
        sta z80_l
        ;lda #>L0000
        sta z80_h

	.if TED_SOUND == 1
	
		; pause
        jsr LAE80 ; CALL LAE80	
	
	.else
	
 		; music off
		lda #06
		jsr music_play

		lda #02
		sta mpwait
		jsr music_pause_no		
		
	.endif	

	; turn music off	
;	.if TED_SOUND == 1
;		lda #05
;		jsr ted_music_play
;	.else
;		lda #09
;		jsr music_play	
;	.endif	
	
 		; music off
		;lda #09
		;jsr music_play		
        
	;lda #<L0114 ; LD HL,L0114
        ;sta z80_l
        ;lda #>L0114
        ;sta z80_h
        ;lda z80_l ; LD (LA266),HL
        ;sta LA266
        ;lda z80_h
        ;sta LA266+1

	lda #<L0114
	sta LA266
	lda #>L0114
	sta LA266+1

        jsr LC7B7 ; CALL LC7B7
		
		; backgournd colour yellow
        lda #$46 ; LD A,46
        sta LA268 ; LD (LA268),A

        ;lda #<no_of_lives ; LD HL,LA265
        ;sta z80_l
        ;lda #>no_of_lives
        ;sta z80_h
			
        ;ldy #$00 ; INC (HL)
        ;lda (z80_hl),y
        ;clc
        ;adc #$01
        ;sta (z80_hl),y

	inc no_of_lives

        jmp LA3B1 ; JP LA3B1

;LBBA4   DB 46,42,4F,4E,55,53,00 ; FBONUS.

;LBBA4   .he 46,42,4F,4E,55,53,00 ; DB 46,42,4F,4E,55,53,00

;LBBAB   DW LBBB1,LBBB5,LBBB8

LBBAB   .wo LBBB1,LBBB5,LBBB8 ; DW LBBB1,LBBB5,LBBB8

;LBBB1   DB 20,21,22,23 ;  !"#

LBBB1   .he 20,21,22,23 ; DB 20,21,22,23

;LBBB5   DB 24,25,26

LBBB5   .he 24,25,26 ; DB 24,25,26

;LBBB8   DB 27,28

LBBB8   .he 27,28 ; DB 27,28

;LBBBA   LD A,(IX+02)
;BBBD    ADD A,(IX+01)
;BBC0    LD (IX+02),A
;BBC3    LD A,(IX+04)
;BBC6    ADD A,(IX+03)
;BBC9    LD (IX+04),A
;BBCC    RET

LBBBA   ldy #$02 ; LD A,(IX+02)
        lda (z80_ix),y
        ;ldy #$01 ; ADD A,(IX+01)
		dey
        clc
        adc (z80_ix),y
        ;ldy #$02 ; LD (IX+02),A
		iny
        sta (z80_ix),y
        ldy #$04 ; LD A,(IX+04)
        lda (z80_ix),y
        ;ldy #$03 ; ADD A,(IX+03)
		dey
        clc
        adc (z80_ix),y
        ;ldy #$04 ; LD (IX+04),A
		iny
        sta (z80_ix),y
        rts ; RET

;LBBCD   LD (IX+05),00
;BBD1    LD A,(IX+02)
;BBD4    ADD A,(IX+01)
;BBD7    SUB 28
;BBD9    JR NC,@@172
;BBDB    NEG
;BBDD    LD (IX+01),A
;BBE0    SET 0,(IX+05)
;@@172   LD A,(IX+02)
;BBE7    ADD A,(IX+08)
;BBEA    ADD A,(IX+01)
;BBED    SUB D1
;BBEF    JR C,@@173
;BBF1    NEG
;BBF3    ADD A,(IX+01)
;BBF6    LD (IX+01),A
;BBF9    SET 1,(IX+05)
;@@173   LD A,(IX+04)
;BC00    ADD A,(IX+03)
;BC03    SUB 48
;BC05    JR NC,@@174
;BC07    NEG
;BC09    LD (IX+03),A
;BC0C    SET 2,(IX+05)
;@@174   LD A,(IX+04)
;BC13    ADD A,(IX+09)
;BC16    ADD A,(IX+03)
;BC19    SUB B9
;BC1B    JR C,@@175
;BC1D    NEG
;BC1F    LD (IX+03),A
;BC22    SET 3,(IX+05)
;@@175   RET

LBBCD   ldy #$05 ; LD (IX+05),00
        lda #$00
        sta (z80_ix),y
        ldy #$02 ; LD A,(IX+02)
        lda (z80_ix),y
        ldy #$01 ; ADD A,(IX+01)
        clc
        adc (z80_ix),y
        sec ; SUB 28
        sbc #$28
        jcs @@172 ; JR NC,@@172
        eor #$ff ; NEG
        clc
        adc #$01
        ldy #$01 ; LD (IX+01),A
        sta (z80_ix),y
        ldy #$05 ; SET 0,(IX+05)
        lda (z80_ix),y
        ora #_bitvalue0
        sta (z80_ix),y
@@172   ldy #$02 ; LD A,(IX+02)
        lda (z80_ix),y
        ldy #$08 ; ADD A,(IX+08)
        clc
        adc (z80_ix),y
        ldy #$01 ; ADD A,(IX+01)
        clc
        adc (z80_ix),y
        sec ; SUB D1
        sbc #$D1
        jcc @@173 ; JR C,@@173
        eor #$ff ; NEG
        clc
        adc #$01
        ldy #$01 ; ADD A,(IX+01)
        clc
        adc (z80_ix),y
        ldy #$01 ; LD (IX+01),A
        sta (z80_ix),y
        ldy #$05 ; SET 1,(IX+05)
        lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
@@173   ldy #$04 ; LD A,(IX+04)
        lda (z80_ix),y
        ldy #$03 ; ADD A,(IX+03)
        clc
        adc (z80_ix),y
        sec ; SUB 48
        sbc #$48
        jcs @@174 ; JR NC,@@174
        eor #$ff ; NEG
        clc
        adc #$01
        ldy #$03 ; LD (IX+03),A
        sta (z80_ix),y
        ldy #$05 ; SET 2,(IX+05)
        lda (z80_ix),y
        ora #_bitvalue2
        sta (z80_ix),y
@@174   ldy #$04 ; LD A,(IX+04)
        lda (z80_ix),y
        ldy #$09 ; ADD A,(IX+09)
        clc
        adc (z80_ix),y
        ldy #$03 ; ADD A,(IX+03)
        clc
        adc (z80_ix),y
        sec ; SUB B9
        sbc #$B9
        jcc @@175 ; JR C,@@175
        eor #$ff ; NEG
        clc
        adc #$01
        ldy #$03 ; LD (IX+03),A
        sta (z80_ix),y
        ldy #$05 ; SET 3,(IX+05)
        lda (z80_ix),y
        ora #_bitvalue3
        sta (z80_ix),y
@@175   rts ; RET

;LBC27   LD A,(LA218)
;BC2A    LD C,A
;BC2B    AND 03
;BC2D    BIT 7,C
;BC2F    JR Z,@@176
;BC31    NEG
;@@176   LD (IX+01),A
;BC36    LD A,(LA219)
;BC39    LD C,A
;BC3A    AND 03
;BC3C    BIT 7,C
;BC3E    JR Z,@@177
;BC40    NEG
;@@177   LD (IX+03),A
;BC45    LD A,(LA216)
;BC48    AND 1F
;BC4A    ADD A,08
;BC4C    LD (IX+0B),A
;BC4F    DEC (IX+0A)
;BC52    RET NZ
;BC53    SLA (IX+01)
;BC57    SLA (IX+03)
;BC5B    RET

; bandit change direction
LBC27

		lda LA218 ; LD A,(LA218)
        sta z80_c ; LD C,A
        and #$03 ; AND 03
        ;lda z80_c ; BIT 7,C
        ;bit _bitmem7
        bit z80_c
        ;jeq @@176 ; JR Z,@@176
        jpl @@176
        eor #$ff ; NEG
        clc
        adc #$01; A read but not set by previous instruction
@@176   ldy #$01 ; LD (IX+01),A
        sta (z80_ix),y
        lda LA219 ; LD A,(LA219)
        sta z80_c ; LD C,A
        and #$03 ; AND 03
        ;lda z80_c ; BIT 7,C
        ;bit _bitmem7
        bit z80_c
        ;jeq @@177 ; JR Z,@@177
        jpl @@177
        eor #$ff ; NEG
        clc
        adc #$01; A read but not set by previous instruction
@@177   ldy #$03 ; LD (IX+03),A
        sta (z80_ix),y
        lda LA216 ; LD A,(LA216)
        and #$1F ; AND 1F
        clc ; ADD A,08
        adc #$08
        ldy #$0B ; LD (IX+0B),A
        sta (z80_ix),y
        ldy #$0A ; DEC (IX+0A)
        lda (z80_ix),y
        sec
        sbc #$01
        sta (z80_ix),y
        beq *+3 ; RET NZ
        rts
        ldy #$01 ; SLA (IX+01)
        lda (z80_ix),y
        asl @
        sta (z80_ix),y
        ldy #$03 ; SLA (IX+03)
        lda (z80_ix),y
        asl @
        sta (z80_ix),y
        rts ; RET

;LBC5C   LD A,(IX+01)
;BC5F    OR (IX+03)
;BC62    JR Z,@@180
;BC64    LD A,(IX+0A)
;BC67    OR (IX+0B)
;BC6A    JR Z,@@180
;BC6C    LD A,(LA216)
;BC6F    AND 03
;BC71    JR NZ,@@180
;BC73    INC (IX+0E)
;@@180   LD A,(IX+0E)
;BC79    AND 01
;BC7B    LD DE,LB5A8
;BC7E    RET Z
;BC7F    LD DE,LB5AB
;BC82    RET

LBC5C   ldy #$01 ; LD A,(IX+01)
        lda (z80_ix),y
        ldy #$03 ; OR (IX+03)
        ora (z80_ix),y
        jeq @@180 ; JR Z,@@180
        ldy #$0A ; LD A,(IX+0A)
        lda (z80_ix),y
        
	;ldy #$0B ; OR (IX+0B)
	iny        

	ora (z80_ix),y
        jeq @@180 ; JR Z,@@180
        lda LA216 ; LD A,(LA216)
        and #$03 ; AND 03
        jne @@180 ; JR NZ,@@180
        ldy #$0E ; INC (IX+0E)
        lda (z80_ix),y
        clc
        adc #$01
        sta (z80_ix),y
@@180   ldy #$0E ; LD A,(IX+0E)
        lda (z80_ix),y
        and #$01 ; AND 01
        php
        lda #<LB5A8 ; LD DE,LB5A8
        sta z80_e
        lda #>LB5A8
        sta z80_d
        plp
        bne *+3 ; RET Z
        rts; ZERO flag read but not set by previous instruction
        lda #<LB5AB ; LD DE,LB5AB
        sta z80_e
        lda #>LB5AB
        sta z80_d
        rts ; RET

;LBC83   LD DE,LA35B
;BC86    LD A,(DE)
;BC87    AND A
;BC88    RET NZ
;BC89    LD A,01
;BC8B    LD (LA240),A
;BC8E    LD HL,LBC97
;BC91    LD BC,L0010
;BC94    LDIR
;BC96    RET

LBC83   ;lda #<LA35B ; LD DE,LA35B
        ;sta z80_e
        ;lda #>LA35B
        ;sta z80_d
        ;ldy #$00 ; LD A,(DE)
        ;lda (z80_de),y
		lda LA35B
        ; AND  A
        beq *+3 ; RET NZ
        rts
        lda #$01 ; LD A,01
        sta LA240 ; LD (LA240),A
        ;lda #<LBC97 ; LD HL,LBC97
        ;sta z80_l
        ;lda #>LBC97
        ;sta z80_h
        ;lda #<L0010 ; LD BC,L0010
        ;sta z80_c
        ;lda #>L0010
        ;sta z80_b
        ;jsr ldir ; LDIR
		ldx #$0f
LBC83_Loop		
		lda LBC97,x
		sta LA35B,x
		dex
		bpl LBC83_Loop
        rts ; RET


;LBC97   DB 03,00,78,00,54,08,00,00
;BC9F    DB 08,08,00,00,00,00

LBC97   .he 03,00,78,00,54,08,00,00 ; DB 03,00,78,00,54,08,00,00
        .he 08,08,00,00,00,00 ; DB 08,08,00,00,00,00

;LBCA5   DW LBCA7

LBCA5   .wo LBCA7 ; DW LBCA7

;LBCA7   DB F4,F4,2C,80

LBCA7   .he F4,F4,2C,80 ; DB F4,F4,2C,80

;@@181   LD A,L
;BCAC    SUB E
;BCAD    CP 2C
;BCAF    JR NC,@@184
;BCB1    LD A,2C
;BCB3    JR @@184

@@181   
		
		lda z80_l ; LD A,L
        sec ; SUB E
        sbc z80_e
        cmp #$2C ; CP 2C
        jcs @@184 ; JR NC,@@184
        lda #$2C ; LD A,2C
        jmp @@184 ; JR @@184

;@@182   LD A,H
;BCB6    SUB E
;BCB7    CP 54
;BCB9    JR NC,@@191
;BCBB    LD A,54
;BCBD    JR @@191

@@182   lda z80_h ; LD A,H
        sec ; SUB E
        sbc z80_e
        cmp #$54 ; CP 54
        jcs @@191 ; JR NC,@@191
        lda #$54 ; LD A,54
        jmp @@191 ; JR @@191

;BCBF    CALL LC970
;BCC2    LD L,(IX+02)
;BCC5    LD H,(IX+04)
;BCC8    LD E,(IX+05)
;BCCB    CALL LD0DC
;BCCE    LD A,B
;BCCF    AND 03
;BCD1    JR Z,@@187
;BCD3    CP 03
;BCD5    JR Z,@@187
;BCD7    CP 01
;BCD9    JR Z,@@181
;BCDB    LD A,L
;BCDC    ADD A,E
;BCDD    CP C5
;BCDF    JR C,@@184
;BCE1    LD A,C4
;@@184   LD L,A
;@@187   LD A,(LA21C)
;BCE7    RRCA
;BCE8    AND 03
;BCEA    JP Z,LBD2F
;BCED    LD A,B
;BCEE    LD B,00
;BCF0    BIT 2,A
;BCF2    JR Z,@@188
;BCF4    SET 1,B
;@@188   BIT 4,A
;BCF8    JR Z,@@189
;BCFA    SET 0,B
;@@189   BIT 3,A
;BCFE    JR Z,LBD02
;BD00    SET 3,B
;LBD02   LD A,B
;BD03    AND 03
;BD05    JR Z,@@194
;BD07    CP 03
;BD09    JR Z,@@194
;BD0B    CP 01
;BD0D    JR Z,@@182
;BD0F    LD A,H
;BD10    ADD A,E
;BD11    CP AD
;BD13    JR C,@@191
;BD15    LD A,AC
;@@191   LD H,A
;@@194   LD (IX+02),L
;BD1B    LD (IX+04),H
;BD1E    LD A,H
;BD1F    LD H,00
;BD21    LD (LA250),HL
;BD24    LD L,A
;BD25    LD (LA252),HL
;BD28    LD E,B
;BD29    CALL LC9E5
;BD2C    JP LBD5E

; move on keyboard/joystick

LBCBF   jsr LC970 ; CALL LC970
        ldy #$02 ; LD L,(IX+02)
        lda (z80_ix),y
        sta z80_l
        ldy #$04 ; LD H,(IX+04)
        lda (z80_ix),y
        sta z80_h
        ldy #$05 ; LD E,(IX+05)
        lda (z80_ix),y
        sta z80_e
		
        jsr CheckUserInput ; CALL LD0DC
		lda z80_b ; LD A,B
        		
		and #$03 ; AND 03
        jeq @@187 ; JR Z,@@187
        cmp #$03 ; CP 03
        jeq @@187 ; JR Z,@@187
        cmp #$01 ; CP 01
        jeq @@181 ; JR Z,@@181
        lda z80_l ; LD A,L
        clc ; ADD A,E
        adc z80_e
        cmp #$C5 ; CP C5
        jcc @@184 ; JR C,@@184
        lda #$C4 ; LD A,C4
@@184   sta z80_l ; LD L,A

@@187   lda game_select_type ; LD A,(LA21C)
        		
		lsr @ ; RRCA
        and #$03 ; AND 03
        
		jeq LBD2F ; JP Z,LBD2F
        
		lda z80_b ; LD A,B
        ldx #$00 ; LD B,00
        stx z80_b
        bit _bitmem2 ; BIT 2,A; A read but not set by previous instruction
        jeq @@188 ; JR Z,@@188
		sta z80_a
        lda z80_b ; SET 1,B
        ora #_bitvalue1
        sta z80_b
		lda z80_a
@@188   bit _bitmem4 ; BIT 4,A; A read but not set by previous instruction
        jeq @@189 ; JR Z,@@189
		sta z80_a
        lda z80_b ; SET 0,B
        ora #_bitvalue0
        sta z80_b
		lda z80_a
@@189   bit _bitmem3 ; BIT 3,A; A read but not set by previous instruction
        jeq LBD02 ; JR Z,LBD02
        lda z80_b ; SET 3,B
        ora #_bitvalue3
        sta z80_b
LBD02   lda z80_b ; LD A,B
        and #$03 ; AND 03
        jeq @@194 ; JR Z,@@194
        cmp #$03 ; CP 03; 
        jeq @@194 ; JR Z,@@194
        cmp #$01 ; CP 01; 
        jeq @@182 ; JR Z,@@182
        lda z80_h ; LD A,H
        clc ; ADD A,E
        adc z80_e
        cmp #$AD ; CP AD
        jcc @@191 ; JR C,@@191
        lda #$AC ; LD A,AC
@@191   sta z80_h ; LD H,A
@@194   ldy #$02 ; LD (IX+02),L
        lda z80_l
        sta (z80_ix),y
		sta LA250
        ldy #$04 ; LD (IX+04),H
        lda z80_h
        sta (z80_ix),y
		sta LA252
        ;ldx z80_h ; LD A,H
        lda #$00 ; LD H,00




		sta LA250+1




		sta LA252+1
        ;sta z80_h
        ;lda z80_l ; LD (LA250),HL
        ;sta LA250
        ;lda z80_h
        ;sta LA250+1
        ;stx z80_l ; LD L,A; A read but not set by previous instruction
        ;lda z80_l ; LD (LA252),HL
        ;sta LA252
        ;lda z80_h
        ;sta LA252+1
        lda z80_b ; LD E,B
        sta z80_e
        jsr LC9E5 ; CALL LC9E5
        jmp LBD5E ; JP LBD5E

;LBD2F   LD A,B
;BD30    LD B,00
;BD32    BIT 2,A
;BD34    JR Z,@@196
;BD36    SET 0,B
;@@196   BIT 3,A
;BD3A    JR Z,@@197
;BD3C    SET 1,B
;@@197   BIT 4,A
;BD40    JR Z,@@198
;BD42    SET 3,B
;@@198   JP LBD02

LBD2F   lda z80_b ; LD A,B
        ldx #$00 ; LD B,00
        stx z80_b
        bit _bitmem2 ; BIT 2,A; A read but not set by previous instruction
        jeq @@196 ; JR Z,@@196
        tax
        lda z80_b ; SET 0,B
        ora #_bitvalue0
        sta z80_b
        txa
@@196   bit _bitmem3 ; BIT 3,A; A read but not set by previous instruction
        jeq @@197 ; JR Z,@@197
        tax
        lda z80_b ; SET 1,B
        ora #_bitvalue1
        sta z80_b
        txa
@@197   bit _bitmem4 ; BIT 4,A; A read but not set by previous instruction
        jeq @@198 ; JR Z,@@198
        tax
        lda z80_b ; SET 3,B
        ora #_bitvalue3
        sta z80_b
        txa
@@198   jmp LBD02 ; JP LBD02

;LBD47   LD H,00
;BD49    LD L,(IX+02)
;BD4C    LD (LA250),HL
;BD4F    LD L,(IX+04)
;BD52    LD (LA252),HL
;BD55    JR LBD5A

LBD47   lda #$00 ; LD H,00
        sta LA250+1
        sta LA252+1
        ;sta z80_h

        ldy #$02 ; LD L,(IX+02)
        lda (z80_ix),y


        sta LA250
        ;sta z80_l
        ;lda z80_l ; LD (LA250),HL
        ;sta LA250
        ;lda z80_h

        ;sta LA250+1
        ldy #$04 ; LD L,(IX+04)
        lda (z80_ix),y


        sta LA252
        ;sta z80_l
        ;lda z80_l ; LD (LA252),HL
        ;sta LA252
        ;lda z80_h

        ;sta LA252+1
        jmp LBD5A ; JR LBD5A


;LBD57   CALL LC6B6
;LBD5A   LD HL,LA244
;BD5D    INC (HL)
;LBD5E   LD E,(IX+0E)
;BD61    LD D,(IX+0F)
;@@201   LD A,(DE)
;BD65    INC DE
;BD66    CP 80
;BD68    RET Z
;BD69    LD HL,(LA250)
;BD6C    CALL LD025
;BD6F    LD A,H
;BD70    AND A
;BD71    JR NZ,@@203
;BD73    LD A,L
;BD74    CP CB
;BD76    JR NC,@@203
;BD78    CP 10
;BD7A    JR C,@@203
;BD7C    LD (LA220),A
;BD7F    LD HL,(LA252)
;BD82    LD A,(DE)
;BD83    INC DE
;BD84    ADD A,(IX+0D)
;BD87    CALL LD025
;BD8A    LD A,H
;BD8B    AND A
;BD8C    JR NZ,@@205
;BD8E    LD A,L
;BD8F    CP B8
;BD91    JR NC,@@205
;BD93    LD (LA221),A
;BD96    LD A,(DE)
;BD97    INC DE
;BD98    PUSH DE
;BD99    CALL LBDA3
;BD9C    POP DE
;BD9D    JR @@201


LBD57_e	equ gf_free_zp
LBD57_d	equ gf_free_zp+1
LBD57_de_index equ gf_free_zp+2


LBD57   jsr LC6B6 ; CALL LC6B6
LBD5A   ;lda #<LA244 ; LD HL,LA244
        ;sta z80_l
        ;lda #>LA244
        ;sta z80_h
        ;ldy #$00 ; INC (HL)
        ;lda (z80_hl),y
        ;clc
        ;adc #$01
        ;sta (z80_hl),y
		inc LA244
LBD5E   ldy #$0E ; LD E,(IX+0E)
        lda (z80_ix),y
        ;sta z80_e
		sta LBD57_e
        ;ldy #$0F ; LD D,(IX+0F)
		iny
        lda (z80_ix),y
        ;sta z80_d
		sta LBD57_d
		ldy #$00
		sty LBD57_de_index

@@201   ;ldy #$00 ; LD A,(DE)
		ldy LBD57_de_index
        ;lda (z80_de),y
		lda (LBD57_e),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		inc LBD57_de_index
        cmp #$80 ; CP 80
        bne *+3 ; RET Z
        rts
        ;tax

        ;lda LA250 ; LD HL,(LA250)
        ;sta z80_l
        ;lda LA250+1
        ;sta z80_h
        ;txa
		ldx LA250
		ldy LA250+1

        jsr LD025 ; CALL LD025 ; uses A as parameter
        ;lda z80_h ; LD A,H
		cpy #$00
        ; AND  A
        jne @@203 ; JR NZ,@@203
        ;lda z80_l ; LD A,L
        ;cmp #$CB ; CP CB
		cpx #$CB
        jcs @@203 ; JR NC,@@203
        ;cmp #$10 ; CP 10
		cpx #$10
        jcc @@203 ; JR C,@@203
        ;sta LA220 ; LD (LA220),A
		stx LA220
        ;lda LA252 ; LD HL,(LA252)
        ;sta z80_l
        ;lda LA252+1
        ;sta z80_h
        ;ldy #$00 ; LD A,(DE)
		ldy LBD57_de_index
        ;lda (z80_de),y
		lda (LBD57_e),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		inc LBD57_de_index
        ldy #$0D ; ADD A,(IX+0D)
        clc
        adc (z80_ix),y
		ldx LA252
		ldy LA252+1
        jsr LD025 ; CALL LD025
        ;lda z80_h ; LD A,H
		cpy #$00
        ; AND  A
        jne @@205 ; JR NZ,@@205
        ;lda z80_l ; LD A,L
        ;cmp #$B8 ; CP B8
		cpx #$B8
        jcs @@205 ; JR NC,@@205
        ;sta LA221 ; LD (LA221),A
		stx LA221
        ;ldy #$00 ; LD A,(DE)
		ldy LBD57_de_index
        ;lda (z80_de),y
		lda (LBD57_e),y
        ;tax

        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		inc LBD57_de_index
        ;lda z80_e ; PUSH DE
        ;pha

        ;lda z80_d
        ;pha
        ;txa


        jsr PrintSpriteMasked ; CALL LBDA3
        ;pla ; POP DE
        ;sta z80_d
        ;pla

        ;sta z80_e
        jmp @@201 ; JR @@201

;@@203   INC DE
;@@205   INC DE
;BDA1    JR @@201

@@203   ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		inc LBD57_de_index
@@205   ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		inc LBD57_de_index
        jmp @@201 ; JR @@201


;LBDA3   LD BC,L67F4
;BDA6    CALL LC74B
;BDA9    EX DE,HL
;BDAA    BIT 6,(IX+07)
;BDAE    JP NZ,LBEED
;BDB1    LD A,(LA220)
;BDB4    AND 06
;BDB6    JP Z,LBE3E
;BDB9    OR F8
;BDBB    LD H,A
;BDBC    LD A,(DE)
;BDBD    INC DE
;BDBE    AND 07
;BDC0    INC A
;BDC1    LD B,A
;BDC2    LD (LA222),A
;BDC5    DEC A
;BDC6    AND 07
;BDC8    ADD A,A
;BDC9    LD C,A
;BDCA    ADD A,A
;BDCB    ADD A,A
;BDCC    ADD A,A
;BDCD    ADD A,C
;BDCE    NEG
;BDD0    ADD A,5D
;LBDD2   PUSH BC
;BDD3    PUSH HL
;BDD4    LD H,00
;BDD6    AND A
;BDD7    JP P,LBDDB
;BDDA    DEC H
;LBDDB   LD L,A
;BDDC    LD BC,LBE7C ; Warning: potentially self modifying code (access to memory where code is located)
;BDDF    ADD HL,BC
;BDE0    LD (LA225),HL
;BDE3    POP HL
;BDE4    POP BC
;BDE5    LD A,B
;BDE6    CPL
;BDE7    ADD A,1A
;BDE9    LD (LA227),A
;BDEC    EX DE,HL
;BDED    LD C,70
;BDEF    LD A,(LA221)
;BDF2    SUB 48
;BDF4    JR C,@@209
;BDF6    SUB C
;BDF7    RET NC
;BDF8    NEG
;BDFA    CP (HL)
;BDFB    JR C,@@207
;BDFD    LD A,(HL)
;@@207   INC HL
;BDFF    LD (LA223),A
;@@208   EX DE,HL
;BE03    PUSH HL
;BE04    LD HL,(LA220)
;BE07    CALL LD22C
;BE0A    LD C,L
;BE0B    LD B,H
;BE0C    POP HL
;BE0D    LD (LA21D),SP
;BE11    EX DE,HL
;BE12    LD SP,HL
;BE13    EX DE,HL
;BE14    SET 1,(IX+07)
;BE18    LD A,(LA223)
;BE1B    JR LBE7A

PrintSpriteMasked   ;ldx #<L67F4 ; LD BC,L67F4 ; A read at the beginning of the block
        ;stx z80_c
        ;ldx #>L67F4
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		asl @
		tax
		lda L67F4,x
		sta z80_e
		lda L67F4+1,x
		sta z80_d
		ldy #SPRITE_PARAMS_SIZE-1
		lda (z80_de),y
		clc

		; fix for incorrect masking
		adc #SPRITE_PARAMS_SIZE
		; end of fix for incorrect masking		
		
		adc z80_e
		sta sprite_mask_ptr
		lda z80_d
		adc #$00
		sta sprite_mask_ptr+1
        ;jsr ex_de_hl ; EX DE,HL
        ldy #$07 ; BIT 6,(IX+07)
        lda (z80_ix),y
        bit _bitmem6
        jne LBEED ; JP NZ,LBEED
        lda LA220 ; LD A,(LA220)
        and #$06 ; AND 06
        jeq LBE3E ; JP Z,LBE3E
; PrintSpriteRotated		
        ora #>[RotationTable+$800] ; OR F8
        sta z80_h ; LD H,A
		sta z80_h2
		inc z80_h2
		
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        and #$07 ; AND 07;
        clc ; INC A
        adc #$01
        sta z80_b ; LD B,A
        sta LA222 ; LD (LA222),A
        sec ; DEC A
        sbc #$01
        and #$07 ; AND 07
        ;asl @ ; ADD A,A
        ;sta z80_c ; LD C,A
        ;asl @ ; ADD A,A
        ;asl @ ; ADD A,A
        ;asl @ ; ADD A,A
        ;clc ; ADD A,C
        ;adc z80_c
        ;eor #$ff ; NEG
        ;clc
        ;adc #$01
        ;clc ; ADD A,5D
        ;adc #$5D
		tax 
		lda #$00
		sta z80_sp_idx
		sta z80_bc_idx
		sta z80_l
		sta z80_l2
		lda PrintSpriteMasked_LoByte-1,x
		ldy PrintSpriteMasked_HiByte-1,x

LBDD2   ;tax
        ;lda z80_c ; PUSH BC
        ;pha
        ;lda z80_b
        ;pha
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;lda #$00 ; LD H,00
        ;sta z80_h
        ;txa
        ; AND  A; A read but not set by previous instruction
        ;jpl LBDDB ; JP P,LBDDB
        ;dec z80_h ; DEC H
;LBDDB   sta z80_l ; LD L,A
        ;lda #<LBE7C ; LD BC,LBE7C
        ;sta z80_c
        ;lda #>LBE7C
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
        ;lda z80_l ; LD (LA225),HL
        ;sta LA225
        ;lda z80_h
        ;sta LA225+1
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;pla ; POP BC
        ;sta z80_b
        ;pla
        ;sta z80_c
		sta LA225
		sty LA225+1
        lda z80_b ; LD A,B
        eor #$ff ; CPL
        clc ; ADD A,1A
        adc #$1A
        sta LA227 ; LD (LA227),A
        jsr ex_de_hl ; EX DE,HL
        lda #$70 ; LD C,70
        sta z80_c
        lda LA221 ; LD A,(LA221)
        sec ; SUB 48
        sbc #$48
        jcc @@209 ; JR C,@@209
        sec ; SUB C
        sbc z80_c
        bcc *+3 ; RET NC
        rts
        eor #$ff ; NEG
        clc
        adc #$01
        ldy #$00 ; CP (HL)
        cmp (z80_hl),y
        jcc @@207 ; JR C,@@207
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
@@207   inc z80_l ; INC HL
        bne *+4
        inc z80_h
        sta LA223 ; LD (LA223),A
@@208   jsr ex_de_hl ; EX DE,HL
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda LA220 ; LD HL,(LA220)
        sta z80_l
        lda LA220+1
        sta z80_h
        jsr GetPointerInBackgroundBuffer ; CALL LD22C
        lda z80_l ; LD C,L
        sta z80_c
        lda z80_h ; LD B,H
        sta z80_b
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        ; LD (LA21D),SP ; LD (LA21D),SP
        ;jsr ex_de_hl ; EX DE,HL
        ; LD SP,HL ; LD SP,HL
		;lda z80_l
		;sta z80_sp
		;lda z80_h
		;sta z80_sp+1
        ;jsr ex_de_hl ; EX DE,HL
		ldy #$00
		lda (z80_de),y
		tay
		inc z80_e			; increase for size byte
		sne:inc z80_d
		lda z80_e		
		sta z80_sp
		lda z80_d
		sta z80_sp+1
	
        lda LA220 
        and #$06 
        jeq SkipPreparePrintSpriteMaskedShifted 
		lda z80_h
		sta shift_low_5_1+2
		sta shift_low_5_2+2
		sta shift_low_4_1+2
		sta shift_low_4_2+2
		sta shift_low_3_1+2
		sta shift_low_3_2+2
		sta shift_low_2_1+2
		sta shift_low_2_2+2
		sta shift_low_1_1+2
		sta shift_low_1_2+2
		ora #$01
		sta shift_hi_5_1+2
		sta shift_hi_5_2+2
		sta shift_hi_4_1+2
		sta shift_hi_4_2+2
		sta shift_hi_3_1+2
		sta shift_hi_3_2+2
		sta shift_hi_2_1+2
		sta shift_hi_2_2+2
		sta shift_hi_1_1+2
		sta shift_hi_1_2+2
		; DE points to sprite data
		; set data pointers
		lda z80_sp
		sta data_5_rot+1
		sta data_4_rot+1
		sta data_3_rot+1
		sta data_2_rot+1
		sta data_1_rot+1
		sec
		sbc #$01
		sta data1_5_rot+1
		sta data1_4_rot+1
		sta data1_3_rot+1
		sta data1_2_rot+1
		sta data1_1_rot+1
		lda z80_sp+1
		sta data_5_rot+2
		sta data_4_rot+2
		sta data_3_rot+2
		sta data_2_rot+2
		sta data_1_rot+2
		sbc #$00
		sta data1_5_rot+2
		sta data1_4_rot+2
		sta data1_3_rot+2
		sta data1_2_rot+2
		sta data1_1_rot+2
		lda sprite_mask_ptr
		sta mask_5_rot+1
		sta mask_4_rot+1
		sta mask_3_rot+1
		sta mask_2_rot+1
		sta mask_1_rot+1
		sec
		sbc #$01
		sta mask1_5_rot+1
		sta mask1_4_rot+1
		sta mask1_3_rot+1
		sta mask1_2_rot+1
		sta mask1_1_rot+1
		lda sprite_mask_ptr+1
		sta mask_5_rot+2
		sta mask_4_rot+2
		sta mask_3_rot+2
		sta mask_2_rot+2
		sta mask_1_rot+2
		sbc #$00
		sta mask1_5_rot+2
		sta mask1_4_rot+2
		sta mask1_3_rot+2
		sta mask1_2_rot+2
		sta mask1_1_rot+2
SkipPreparePrintSpriteMaskedShifted
		
        ldy #$07 ; SET 1,(IX+07)
        lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
        lda LA223 ; LD A,(LA223)
		sta z80_ap
		ldy #$00
        jmp LBE7A ; JR LBE7A


;@@209   NEG
;BE1F    LD C,A
;BE20    LD A,(HL)
;BE21    SUB C
;BE22    RET M
;BE23    RET Z
;BE24    LD (LA223),A
;BE27    LD B,00
;BE29    DEC HL
;BE2A    LD A,(HL)
;BE2B    AND 3F
;BE2D    INC HL
;BE2E    INC HL
;BE2F    SLA C
;BE31    RL B
;@@210   ADD HL,BC
;BE34    DEC A
;BE35    JR NZ,@@210
;BE37    LD A,48
;BE39    LD (LA221),A
;BE3C    JR @@208


@@209   eor #$ff ; NEG
        clc
        adc #$01
        sta z80_c ; LD C,A
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        sec ; SUB C
        sbc z80_c
        bpl *+3 ; RET M
        rts
        bne *+3 ; RET Z
        rts
        sta LA223 ; LD (LA223),A
        ;lda #$00 ; LD B,00
        ;sta z80_b
        jsr dec_hl ; DEC HL
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        and #$3F ; AND 3F
        tax
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ;asl z80_c ; SLA C
        ;rol z80_b ; RL B
@@210   ;jsr add_hl_bc ; ADD HL,BC
		lda z80_l
		clc
		adc z80_c
		sta z80_l
		scc:inc z80_h
		lda sprite_mask_ptr
		clc
		adc z80_c
		sta sprite_mask_ptr
		scc:inc sprite_mask_ptr+1
        ;sec ; DEC A
        ;sbc #$01; A read but not set by previous instruction
        dex
        jne @@210 ; JR NZ,@@210
        lda #$48 ; LD A,48
        sta LA221 ; LD (LA221),A
        jmp @@208 ; JR @@208

;LBE3E   LD A,(DE)
;BE3F    INC DE
;BE40    AND 0F
;BE42    LD (LA222),A
;BE45    LD B,A
;BE46    ADD A,A
;BE47    ADD A,A
;BE48    ADD A,A
;BE49    NEG
;BE4B    SUB 04
;BE4D    JP LBDD2

z80_sp_idx = z80_reg0
z80_bc_idx = z80_reg1

LBE3E   lda #$00
		sta z80_sp_idx
		sta z80_bc_idx
		ldy #$00 ; LD A,(DE)

        lda (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        and #$0F ; AND 0F
        sta LA222 ; LD (LA222),A
        sta z80_b ; LD B,A
		inc z80_b
        ;asl @ ; ADD A,A
        ;asl @ ; ADD A,A
        ;asl @ ; ADD A,A
        ;eor #$ff ; NEG
        ;clc
        ;adc #$01
        ;sec ; SUB 04
        ;sbc #$04
		tax
		lda PrintSpriteMaskedNoShift_LoByte-1,x
		ldy PrintSpriteMaskedNoShift_HiByte-1,x
        jmp LBDD2 ; JP LBDD2

;BE50    POP DE
;BE51    LD A,(BC)
;BE52    CPL
;BE53    OR E
;BE54    CPL
;BE55    OR D
;BE56    LD (BC),A
;BE57    INC BC
;BE58    POP DE
;BE59    LD A,(BC)
;BE5A    CPL
;BE5B    OR E
;BE5C    CPL
;BE5D    OR D
;BE5E    LD (BC),A
;BE5F    INC BC
;BE60    POP DE
;BE61    LD A,(BC)
;BE62    CPL
;BE63    OR E
;BE64    CPL
;BE65    OR D
;BE66    LD (BC),A
;BE67    INC BC
;BE68    POP DE
;BE69    LD A,(BC)
;BE6A    CPL
;BE6B    OR E
;BE6C    CPL
;BE6D    OR D
;BE6E    LD (BC),A
;BE6F    INC BC
;BE70    POP DE
;BE71    LD A,(BC)
;BE72    CPL
;BE73    OR E
;BE74    CPL
;BE75    OR D
;BE76    LD (BC),A
;BE77    JP LBEDA

PrintSpriteMaskedNoShift_LoByte
		dta <PrintSpriteMaskedNoShift_1,<PrintSpriteMaskedNoShift_2,<PrintSpriteMaskedNoShift_3,<PrintSpriteMaskedNoShift_4,<PrintSpriteMaskedNoShift_5		
PrintSpriteMaskedNoShift_HiByte
		dta >PrintSpriteMaskedNoShift_1,>PrintSpriteMaskedNoShift_2,>PrintSpriteMaskedNoShift_3,>PrintSpriteMaskedNoShift_4,>PrintSpriteMaskedNoShift_5	







PrintSpriteMaskedNoShift_5


















		eor #$ff
		ora (sprite_mask_ptr),y


		eor #$ff

		ora (z80_sp),y



		sta (z80_bc),y
		iny








		lda (z80_bc),y



		
PrintSpriteMaskedNoShift_4


















		eor #$ff
		ora (sprite_mask_ptr),y


		eor #$ff

		ora (z80_sp),y



		sta (z80_bc),y
		iny









		lda (z80_bc),y




PrintSpriteMaskedNoShift_3

















		eor #$ff
		ora (sprite_mask_ptr),y


		eor #$ff

		ora (z80_sp),y



		sta (z80_bc),y
		iny
		lda (z80_bc),y
        












PrintSpriteMaskedNoShift_2

















		eor #$ff
		ora (sprite_mask_ptr),y


		eor #$ff

		ora (z80_sp),y



		sta (z80_bc),y
		iny









		lda (z80_bc),y




PrintSpriteMaskedNoShift_1

















		eor #$ff
		ora (sprite_mask_ptr),y


		eor #$ff

		ora (z80_sp),y



		sta (z80_bc),y
		iny



		;sty z80_bc_idx






        jmp LBEDA ; JP LBEDA
		

;LBE7A   EX AF,AF'
;BE7B    LD A,(BC)
;BE7C    JP LA224

LBE7A   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;ldy #$00 ; LD A,(BC)
		;ldy z80_bc_idx
        lda (z80_bc),y
        jmp LA224 ; JP LA224

;BE7F    CPL
;BE80    POP DE
;BE81    LD L,E
;BE82    OR (HL)
;BE83    CPL
;BE84    LD L,D
;BE85    OR (HL)
;BE86    LD (BC),A
;BE87    INC BC
;BE88    INC H
;BE89    LD L,E
;BE8A    LD A,(BC)
;BE8B    CPL
;BE8C    OR (HL)
;BE8D    CPL
;BE8E    LD L,D
;BE8F    OR (HL)
;BE90    DEC H
;BE91    CPL
;BE92    POP DE
;BE93    LD L,E
;BE94    OR (HL)
;BE95    CPL
;BE96    LD L,D
;BE97    OR (HL)
;BE98    LD (BC),A
;BE99    INC BC
;BE9A    INC H
;BE9B    LD L,E
;BE9C    LD A,(BC)
;BE9D    CPL
;BE9E    OR (HL)
;BE9F    CPL
;BEA0    LD L,D
;BEA1    OR (HL)
;BEA2    DEC H
;BEA3    CPL
;BEA4    POP DE
;BEA5    LD L,E
;BEA6    OR (HL)
;BEA7    CPL
;BEA8    LD L,D
;BEA9    OR (HL)
;BEAA    LD (BC),A
;BEAB    INC BC
;BEAC    INC H
;BEAD    LD L,E
;BEAE    LD A,(BC)
;BEAF    CPL
;BEB0    OR (HL)
;BEB1    CPL
;BEB2    LD L,D
;BEB3    OR (HL)
;BEB4    DEC H
;BEB5    CPL
;BEB6    POP DE
;BEB7    LD L,E
;BEB8    OR (HL)
;BEB9    CPL
;BEBA    LD L,D
;BEBB    OR (HL)
;BEBC    LD (BC),A
;BEBD    INC BC
;BEBE    INC H
;BEBF    LD L,E
;BEC0    LD A,(BC)
;BEC1    CPL
;BEC2    OR (HL)
;BEC3    CPL
;BEC4    LD L,D
;BEC5    OR (HL)
;BEC6    DEC H
;BEC7    CPL
;BEC8    POP DE
;BEC9    LD L,E
;BECA    OR (HL)
;BECB    CPL
;BECC    LD L,D
;BECD    OR (HL)
;BECE    LD (BC),A
;BECF    INC BC
;BED0    INC H
;BED1    LD L,E
;BED2    LD A,(BC)
;BED3    CPL
;BED4    OR (HL)
;BED5    CPL
;BED6    LD L,D
;BED7    OR (HL)
;BED8    DEC H
;BED9    LD (BC),A
;LBEDA   LD A,(LA227)
;BEDD    ADD A,C
;BEDE    LD C,A
;BEDF    LD A,B
;BEE0    ADC A,00
;BEE2    LD B,A
;BEE3    EX AF,AF'
;BEE4    DEC A
;BEE5    JP NZ,LBE7A
;BEE8    LD SP,(LA21D)
;BEEC    RET





z80_l2 = z80_reg2
z80_h2 = z80_reg3
z80_hl2 = z80_reg2

PrintSpriteMasked_LoByte
		dta <PrintSpriteMasked_1,<PrintSpriteMasked_2,<PrintSpriteMasked_3,<PrintSpriteMasked_4,<PrintSpriteMasked_5
PrintSpriteMasked_HiByte
		dta >PrintSpriteMasked_1,>PrintSpriteMasked_2,>PrintSpriteMasked_3,>PrintSpriteMasked_4,>PrintSpriteMasked_5
		
PrintSpriteMasked_5
		eor #$ff
mask_5_rot
		ldx $ffff,y ; read mask
shift_low_5_1
		ora $ff00,x


























		eor #$ff
data_5_rot
		ldx $ffff,y ; read data
shift_low_5_2		
		ora $ff00,x







		sta (z80_bc),y







		iny
mask1_5_rot		
		ldx $ffff,y ; read mask (-1)

		lda (z80_bc),y
		eor #$ff
shift_hi_5_1		
		ora $ff00,x ; (rot table + 1)



		eor #$ff
data1_5_rot
		ldx $ffff,y ; read data (-1)
shift_hi_5_2
		ora $ff00,x ; (rot table + 1)







		
PrintSpriteMasked_4
		eor #$ff
mask_4_rot
		ldx $ffff,y ; read mask
shift_low_4_1
		ora $ff00,x


























		eor #$ff
data_4_rot
		ldx $ffff,y ; read data
shift_low_4_2		
		ora $ff00,x







		sta (z80_bc),y







		iny
mask1_4_rot		
		ldx $ffff,y ; read mask (-1)

		lda (z80_bc),y
		eor #$ff
shift_hi_4_1		
		ora $ff00,x ; (rot table + 1)



		eor #$ff
data1_4_rot
		ldx $ffff,y ; read data (-1)
shift_hi_4_2
		ora $ff00,x ; (rot table + 1)






		
PrintSpriteMasked_3
		eor #$ff
mask_3_rot
		ldx $ffff,y ; read mask
shift_low_3_1
		ora $ff00,x


























		eor #$ff
data_3_rot
		ldx $ffff,y ; read data
shift_low_3_2		
		ora $ff00,x







		sta (z80_bc),y







		iny
mask1_3_rot		
		ldx $ffff,y ; read mask (-1)

		lda (z80_bc),y
		eor #$ff
shift_hi_3_1		
		ora $ff00,x ; (rot table + 1)



		eor #$ff
data1_3_rot
		ldx $ffff,y ; read data (-1)
shift_hi_3_2
		ora $ff00,x ; (rot table + 1)






		
PrintSpriteMasked_2
		eor #$ff
mask_2_rot
		ldx $ffff,y ; read mask
shift_low_2_1
		ora $ff00,x


























		eor #$ff
data_2_rot
		ldx $ffff,y ; read data
shift_low_2_2		
		ora $ff00,x







		sta (z80_bc),y







		iny
mask1_2_rot		
		ldx $ffff,y ; read mask (-1)

		lda (z80_bc),y
		eor #$ff
shift_hi_2_1		
		ora $ff00,x ; (rot table + 1)



		eor #$ff
data1_2_rot
		ldx $ffff,y ; read data (-1)
shift_hi_2_2
		ora $ff00,x ; (rot table + 1)






		
PrintSpriteMasked_1
		eor #$ff
mask_1_rot
		ldx $ffff,y ; read mask
shift_low_1_1
		ora $ff00,x


























		eor #$ff
data_1_rot
		ldx $ffff,y ; read data
shift_low_1_2		
		ora $ff00,x







		sta (z80_bc),y







		iny
mask1_1_rot		
		ldx $ffff,y ; read mask (-1)

		lda (z80_bc),y
		eor #$ff
shift_hi_1_1		
		ora $ff00,x ; (rot table + 1)



		eor #$ff
data1_1_rot
		ldx $ffff,y ; read data (-1)
shift_hi_1_2
		ora $ff00,x ; (rot table + 1)






		
        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
        sta (z80_bc),y; 
		
LBEDA   lda LA227 ; LD A,(LA227)
        clc ; ADD A,C
        adc z80_c
        sta z80_c ; LD C,A
        ;lda z80_b ; LD A,B
        ;adc #$00 ; ADC A,00
        ;sta z80_b ; LD B,A
		scc:inc z80_b
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;sec ; DEC A
        ;sbc #$01
		dec z80_ap
        jne LBE7A ; JP NZ,LBE7A
        ; LD SP,(LA21D): TODO  ; LD SP,(LA21D)
        rts ; RET

;LBEED   LD A,(LA220)
;BEF0    AND 06
;BEF2    JP Z,LBF82
;BEF5    OR F1
;BEF7    LD H,A
;BEF8    LD A,(DE)
;BEF9    INC DE
;BEFA    AND 07
;BEFC    INC A
;BEFD    LD B,A
;BEFE    LD (LA222),A
;BF01    DEC A
;BF02    AND 07
;BF04    ADD A,A
;BF05    LD C,A
;BF06    ADD A,A
;BF07    ADD A,A
;BF08    ADD A,A
;BF09    ADD A,C
;BF0A    NEG
;BF0C    ADD A,5D
;LBF0E   PUSH BC
;BF0F    PUSH HL
;BF10    LD H,00
;BF12    AND A
;BF13    JP P,LBF17
;BF16    DEC H
;LBF17   LD L,A
;BF18    LD BC,LBFCD ; Warning: potentially self modifying code (access to memory where code is located)
;BF1B    ADD HL,BC
;BF1C    LD (LA225),HL
;BF1F    POP HL
;BF20    POP BC
;BF21    LD A,B
;BF22    ADD A,17
;BF24    LD (LA227),A
;BF27    EX DE,HL
;BF28    LD C,70
;BF2A    LD A,(LA221)
;BF2D    SUB 48
;BF2F    JR C,@@214
;BF31    SUB C
;BF32    RET NC
;BF33    NEG
;BF35    CP (HL)
;BF36    JR C,@@212
;BF38    LD A,(HL)
;@@212   INC HL
;BF3A    LD (LA223),A
;@@213   EX DE,HL
;BF3E    PUSH HL
;BF3F    LD HL,(LA220)
;BF42    LD A,(LA222)
;BF45    DEC A
;BF46    ADD A,A
;BF47    ADD A,A
;BF48    ADD A,A
;BF49    ADD A,L
;BF4A    LD L,A
;BF4B    CALL LD22C
;BF4E    LD C,L
;BF4F    LD B,H
;BF50    POP HL
;BF51    LD (LA21D),SP
;BF55    EX DE,HL
;BF56    LD SP,HL
;BF57    EX DE,HL
;BF58    SET 1,(IX+07)
;BF5C    LD A,(LA223)
;BF5F    JR LBFCB

z80_bc_start_idx equ gf_free_zp+4

LBEED   lda #$00
		sta z80_bc_idx
		sta z80_sp_idx
		sta z80_l
		sta z80_l2
		lda LA220 ; LD A,(LA220)
        and #$06 ; AND 06
        jeq LBF82 ; JP Z,LBF82
        ;ora #$F1 ; OR F1
		ora #>[RotationTable+$100]
        sta z80_h ; LD H,A
		sec
		sbc #$01
		sta z80_h2
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        and #$07 ; AND 07
        clc ; INC A
        adc #$01
        sta z80_b ; LD B,A
        sta LA222 ; LD (LA222),A
        sec ; DEC A
        sbc #$01
        and #$07 ; AND 07
		tax
		lda PrintSpriteFlippedMaskedShift_LoByte-1,x
		ldy PrintSpriteFlippedMaskedShift_HiByte-1,x
		
        ;asl @ ; ADD A,A
        ;sta z80_c ; LD C,A
        ;asl @ ; ADD A,A
        ;asl @ ; ADD A,A
        ;asl @ ; ADD A,A
        ;clc ; ADD A,C
        ;adc z80_c
        ;eor #$ff ; NEG
        ;clc
        ;adc #$01
        ;clc ; ADD A,5D
        ;adc #$5D
LBF0E   ;tax
        ;lda z80_c ; PUSH BC
        ;pha
        ;lda z80_b
        ;pha
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;lda #$00 ; LD H,00
        ;sta z80_h
        ;txa
        ; AND  A: A read but not set by previous instruction
        ;jpl LBF17 ; JP P,LBF17
        ;dec z80_h ; DEC H
;LBF17   sta z80_l ; LD L,A; 
        ;lda #<LBFCD ; LD BC,LBFCD
        ;sta z80_c
        ;lda #>LBFCD
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
        ;lda z80_l ; LD (LA225),HL
        ;sta LA225
        ;lda z80_h
        ;sta LA225+1
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;pla ; POP BC
        ;sta z80_b
        ;pla
        ;sta z80_c
		sta LA225
		sty LA225+1
		;dex
		stx z80_bc_start_idx
        ;lda z80_b ; LD A,B
        ;clc ; ADD A,17
        ;adc #$17
		;sec
		;sbc z80_bc_start_idx
		lda #$18
        sta LA227 ; LD (LA227),A
        jsr ex_de_hl ; EX DE,HL
        lda #$70 ; LD C,70
        sta z80_c
        lda LA221 ; LD A,(LA221)
        sec ; SUB 48
        sbc #$48
        jcc @@214 ; JR C,@@214
        ;sec ; SUB C ; C=1 here

        sbc z80_c
        bcc *+3 ; RET NC
        rts
        eor #$ff ; NEG
        ;clc ; C=0 here

        adc #$01
        ldy #$00 ; CP (HL)
        cmp (z80_hl),y
        jcc @@212 ; JR C,@@212
        ;ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
@@212   inc z80_l ; INC HL
        bne *+4
        inc z80_h
        sta LA223 ; LD (LA223),A
@@213   jsr ex_de_hl ; EX DE,HL
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda LA220 ; LD HL,(LA220)
        sta z80_l
        lda LA220+1
        sta z80_h
        lda LA222 ; LD A,(LA222)
        sec ; DEC A
        sbc #$01
        asl @ ; ADD A,A
        asl @ ; ADD A,A
        asl @ ; ADD A,A
        clc ; ADD A,L
        adc z80_l
        sta z80_l ; LD L,A
        jsr GetPointerInBackgroundBuffer ; CALL LD22C
        lda z80_l ; LD C,L
		sec
		sbc z80_bc_start_idx
        sta z80_c
        lda z80_h ; LD B,H
		sbc #$00
        sta z80_b
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        ; LD (LA21D),SP ; LD (LA21D),SP
        ;jsr ex_de_hl ; EX DE,HL
        ; LD SP,HL ; LD SP,HL
		;lda z80_l
		;sta z80_sp
		;lda z80_h
		;sta z80_sp+1
        ;jsr ex_de_hl ; EX DE,HL
		inc z80_e
		sne:inc z80_d
		lda z80_e
		sta z80_sp
		lda z80_d
		sta z80_sp+1
        ldy #$07 ; SET 1,(IX+07)
        lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
        lda LA223 ; LD A,(LA223)
        jmp LBFCB ; JR LBFCB


;@@214   NEG
;BF63    LD C,A
;BF64    LD A,(HL)
;BF65    SUB C
;BF66    RET M
;BF67    RET Z
;BF68    LD (LA223),A
;BF6B    LD B,00
;BF6D    DEC HL
;BF6E    LD A,(HL)
;BF6F    AND 3F
;BF71    INC HL
;BF72    INC HL
;BF73    SLA C
;BF75    RL B
;@@215   ADD HL,BC
;BF78    DEC A
;BF79    JR NZ,@@215
;BF7B    LD A,48
;BF7D    LD (LA221),A
;BF80    JR @@213

@@214   eor #$ff ; NEG
        ;clc ; C=0 here (jumped by jcc)

        adc #$01
        sta z80_c ; LD C,A
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        sec ; SUB C
        sbc z80_c
        bpl *+3 ; RET M
        rts
        bne *+3 ; RET Z
        rts
        sta LA223 ; LD (LA223),A
        ;lda #$00 ; LD B,00
        ;sta z80_b
        jsr dec_hl ; DEC HL
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        and #$3F ; AND 3F
        tax
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ;asl z80_c ; SLA C
        ;rol z80_b ; RL B
@@215   ;jsr add_hl_bc ; ADD HL,BC
		lda z80_l
		clc
		adc z80_c
		sta z80_l
		scc:inc z80_h
		lda sprite_mask_ptr
		clc
		adc z80_c
		sta sprite_mask_ptr
		scc:inc sprite_mask_ptr+1
        ;sec ; DEC A
        ;sbc #$01; A read but not set by previous instruction
        dex
        jne @@215 ; JR NZ,@@215
        lda #$48 ; LD A,48
        sta LA221 ; LD (LA221),A
        jmp @@213 ; JR @@213

;LBF82   LD H,F9
;BF84    LD A,(DE)
;BF85    INC DE
;BF86    AND 0F
;BF88    LD (LA222),A
;BF8B    LD B,A
;BF8C    ADD A,A
;BF8D    ADD A,A
;BF8E    ADD A,A
;BF8F    ADD A,B
;BF90    ADD A,B
;BF91    NEG
;BF93    SUB 03
;BF95    JP LBF0E

LBF82   ;lda #$F9 ; LD H,F9
		lda #>MirrorTable
        sta z80_h
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        and #$0F ; AND 0F; 
        sta LA222 ; LD (LA222),A
        sta z80_b ; LD B,A
        ;asl @ ; ADD A,A
        ;asl @ ; ADD A,A
        ;asl @ ; ADD A,A
        ;clc ; ADD A,B
        ;adc z80_b
        ;clc ; ADD A,B
        ;adc z80_b
        ;eor #$ff ; NEG
        ;clc
        ;adc #$01
        ;sec ; SUB 03
        ;sbc #$03
		tax
		lda PrintSpriteFlippedMaskedNoShift_LoByte-1,x
		ldy PrintSpriteFlippedMaskedNoShift_HiByte-1,x
        jmp LBF0E ; JP LBF0E

;BF98    POP DE
;BF99    LD L,E
;BF9A    CPL
;BF9B    OR (HL)
;BF9C    CPL
;BF9D    LD L,D
;BF9E    OR (HL)
;BF9F    LD (BC),A
;BFA0    DEC BC
;BFA1    LD A,(BC)
;BFA2    POP DE
;BFA3    LD L,E
;BFA4    CPL
;BFA5    OR (HL)
;BFA6    CPL
;BFA7    LD L,D
;BFA8    OR (HL)
;BFA9    LD (BC),A
;BFAA    DEC BC
;BFAB    LD A,(BC)
;BFAC    POP DE
;BFAD    LD L,E
;BFAE    CPL
;BFAF    OR (HL)
;BFB0    CPL
;BFB1    LD L,D
;BFB2    OR (HL)
;BFB3    LD (BC),A
;BFB4    DEC BC
;BFB5    LD A,(BC)
;BFB6    POP DE
;BFB7    LD L,E
;BFB8    CPL
;BFB9    OR (HL)
;BFBA    CPL
;BFBB    LD L,D
;BFBC    OR (HL)
;BFBD    LD (BC),A
;BFBE    DEC BC
;BFBF    LD A,(BC)
;BFC0    POP DE
;BFC1    LD L,E
;BFC2    CPL
;BFC3    OR (HL)
;BFC4    CPL
;BFC5    LD L,D
;BFC6    OR (HL)
;BFC7    LD (BC),A
;BFC8    JP LBEDA

PrintSpriteFlippedMaskedNoShift_LoByte
		dta <PrintSpriteFlippedMaskedNoShift_1
		dta <PrintSpriteFlippedMaskedNoShift_2
		dta <PrintSpriteFlippedMaskedNoShift_3
		dta <PrintSpriteFlippedMaskedNoShift_4
		dta <PrintSpriteFlippedMaskedNoShift_5

PrintSpriteFlippedMaskedNoShift_HiByte
		dta >PrintSpriteFlippedMaskedNoShift_1
		dta >PrintSpriteFlippedMaskedNoShift_2
		dta >PrintSpriteFlippedMaskedNoShift_3
		dta >PrintSpriteFlippedMaskedNoShift_4
		dta >PrintSpriteFlippedMaskedNoShift_5


PrintSpriteFlippedMaskedNoShift_5
		sta z80_a
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1	
		;ldy #$00
		ldy z80_sp_idx
		lda (sprite_mask_ptr),y
		;sta z80_e
		tax

		lda (z80_sp),y



		sta z80_d
		;inc sprite_mask_ptr
		;sne:inc sprite_mask_ptr+1



		;inc z80_sp
		;sne:inc z80_sp+1
		inc z80_sp_idx
        ;lda z80_e ; LD L,E
        ;sta z80_l
		lda z80_a
        eor #$ff ; CPL; 
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
		ora MirrorTable,x
        eor #$ff ; CPL
        ldx z80_d ; LD L,D
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y; 
		ora MirrorTable,x
        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
		ldy #$05
        sta (z80_bc),y
        ;jsr dec_bc ; DEC BC
		;lda z80_c
		;sne:dec z80_b
		;dec z80_c
		dey
		;sty z80_bc_idx
        ;ldy #$00 ; LD A,(BC)
        lda (z80_bc),y
		
PrintSpriteFlippedMaskedNoShift_4
		sta z80_a
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1	
		;ldy #$00
		ldy z80_sp_idx
		lda (sprite_mask_ptr),y
		;sta z80_e
		tax
		lda (z80_sp),y
		sta z80_d
		;inc sprite_mask_ptr
		;sne:inc sprite_mask_ptr+1



		;inc z80_sp
		;sne:inc z80_sp+1
		inc z80_sp_idx
        ;lda z80_e ; LD L,E
        ;sta z80_l
		lda z80_a
        eor #$ff ; CPL; 
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
		ora MirrorTable,x
        eor #$ff ; CPL
        ldx z80_d ; LD L,D
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y; 
		ora MirrorTable,x
        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
		ldy #$04
        sta (z80_bc),y
        ;jsr dec_bc ; DEC BC
		;lda z80_c
		;sne:dec z80_b
		;dec z80_c
		dey
		;sty z80_bc_idx
        ;ldy #$00 ; LD A,(BC)
        lda (z80_bc),y
		
PrintSpriteFlippedMaskedNoShift_3
		sta z80_a
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1	
		;ldy #$00
		ldy z80_sp_idx
		lda (sprite_mask_ptr),y
		;sta z80_e
		tax

		lda (z80_sp),y



		sta z80_d
		;inc sprite_mask_ptr
		;sne:inc sprite_mask_ptr+1



		;inc z80_sp
		;sne:inc z80_sp+1
		inc z80_sp_idx
        ;lda z80_e ; LD L,E
        ;sta z80_l
		lda z80_a
        eor #$ff ; CPL; 
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
		ora MirrorTable,x
        eor #$ff ; CPL
        ldx z80_d ; LD L,D
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y; 
		ora MirrorTable,x
        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
		ldy #$03
        sta (z80_bc),y
        ;jsr dec_bc ; DEC BC
		;lda z80_c
		;sne:dec z80_b
		;dec z80_c
		dey
		;sty z80_bc_idx
        ;ldy #$00 ; LD A,(BC)
        lda (z80_bc),y
		
PrintSpriteFlippedMaskedNoShift_2
		sta z80_a
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1	
		;ldy #$00
		ldy z80_sp_idx
		lda (sprite_mask_ptr),y
		;sta z80_e
		tax

		lda (z80_sp),y



		sta z80_d
		;inc sprite_mask_ptr
		;sne:inc sprite_mask_ptr+1



		;inc z80_sp
		;sne:inc z80_sp+1
		inc z80_sp_idx

        ;lda z80_e ; LD L,E
        ;sta z80_l
		lda z80_a
        eor #$ff ; CPL; 
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
		ora MirrorTable,x
        eor #$ff ; CPL
        ldx z80_d ; LD L,D
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y; 
		ora MirrorTable,x
        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
		ldy #$02
        sta (z80_bc),y
        ;jsr dec_bc ; DEC BC
		;lda z80_c
		;sne:dec z80_b
		;dec z80_c
		dey
		;sty z80_bc_idx
        ;ldy #$00 ; LD A,(BC)
        lda (z80_bc),y

PrintSpriteFlippedMaskedNoShift_1
		sta z80_a
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1	
		;ldy #$00
		ldy z80_sp_idx
		lda (sprite_mask_ptr),y
		;sta z80_e
		tax

		lda (z80_sp),y



		sta z80_d
		;inc sprite_mask_ptr
		;sne:inc sprite_mask_ptr+1



		;inc z80_sp
		;sne:inc z80_sp+1
		inc z80_sp_idx
        ;lda z80_e ; LD L,E
        ;sta z80_l
		lda z80_a
        eor #$ff ; CPL; 
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
		ora MirrorTable,x
        eor #$ff ; CPL
        ldx z80_d ; LD L,D
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y; 
		ora MirrorTable,x
        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
		ldy #$01
        sta (z80_bc),y

        ;jmp LBEDA ; JP LBEDA
		jmp PrintSpriteFlippedNextRow

;LBFCB   EX AF,AF'
;BFCC    LD A,(BC)
;BFCD    JP LA224

LBFCB   ;ldx z80_ap ; EX AF,AF'
        sta z80_ap
        ;txa ; 
LBCFB_Next_iteration		

        ;ldy #$00 ; LD A,(BC)
		ldy z80_bc_start_idx
		sty z80_bc_idx
        lda (z80_bc),y
        jmp LA224 ; JP LA224

;BFD0    CPL
;BFD1    POP DE
;BFD2    LD L,E
;BFD3    OR (HL)
;BFD4    CPL
;BFD5    LD L,D
;BFD6    OR (HL)
;BFD7    LD (BC),A
;BFD8    DEC BC
;BFD9    DEC H
;BFDA    LD L,E
;BFDB    LD A,(BC)
;BFDC    CPL
;BFDD    OR (HL)
;BFDE    CPL
;BFDF    LD L,D
;BFE0    OR (HL)
;BFE1    INC H
;BFE2    CPL
;BFE3    POP DE
;BFE4    LD L,E
;BFE5    OR (HL)
;BFE6    CPL
;BFE7    LD L,D
;BFE8    OR (HL)
;BFE9    LD (BC),A
;BFEA    DEC BC
;BFEB    DEC H
;BFEC    LD L,E
;BFED    LD A,(BC)
;BFEE    CPL
;BFEF    OR (HL)
;BFF0    CPL
;BFF1    LD L,D
;BFF2    OR (HL)
;BFF3    INC H
;BFF4    CPL
;BFF5    POP DE
;BFF6    LD L,E
;BFF7    OR (HL)
;BFF8    CPL
;BFF9    LD L,D
;BFFA    OR (HL)
;BFFB    LD (BC),A
;BFFC    DEC BC
;BFFD    DEC H
;BFFE    LD L,E
;BFFF    LD A,(BC)
;C000    CPL
;C001    OR (HL)
;C002    CPL
;C003    LD L,D
;C004    OR (HL)
;C005    INC H
;C006    CPL
;C007    POP DE
;C008    LD L,E
;C009    OR (HL)
;C00A    CPL
;C00B    LD L,D
;C00C    OR (HL)
;C00D    LD (BC),A
;C00E    DEC BC
;C00F    DEC H
;C010    LD L,E
;C011    LD A,(BC)
;C012    CPL
;C013    OR (HL)
;C014    CPL
;C015    LD L,D
;C016    OR (HL)
;C017    INC H
;C018    CPL
;C019    POP DE
;C01A    LD L,E
;C01B    OR (HL)
;C01C    CPL
;C01D    LD L,D
;C01E    OR (HL)
;C01F    LD (BC),A
;C020    DEC BC
;C021    DEC H
;C022    LD L,E
;C023    LD A,(BC)
;C024    CPL
;C025    OR (HL)
;C026    CPL
;C027    LD L,D
;C028    OR (HL)
;C029    INC H
;C02A    LD (BC),A
;C02B    LD A,(LA227)
;C02E    ADD A,C
;C02F    LD C,A
;C030    LD A,B
;C031    ADC A,00
;C033    LD B,A
;C034    EX AF,AF'
;C035    DEC A
;C036    JP NZ,LBFCB
;C039    LD SP,(LA21D)
;C03D    RET

PrintSpriteFlippedMaskedShift_LoByte
		dta <PrintSpriteFlippedMaskedShift_1
		dta <PrintSpriteFlippedMaskedShift_2
		dta <PrintSpriteFlippedMaskedShift_3
		dta <PrintSpriteFlippedMaskedShift_4
		dta <PrintSpriteFlippedMaskedShift_5
PrintSpriteFlippedMaskedShift_HiByte
		dta >PrintSpriteFlippedMaskedShift_1
		dta >PrintSpriteFlippedMaskedShift_2
		dta >PrintSpriteFlippedMaskedShift_3
		dta >PrintSpriteFlippedMaskedShift_4
		dta >PrintSpriteFlippedMaskedShift_5
		
PrintSpriteFlippedMaskedShift_5
        eor #$ff ; CPL; 
		sta z80_a
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1	
		;ldy #$00
		ldy z80_sp_idx
		lda (sprite_mask_ptr),y
		sta z80_e

		lda (z80_sp),y
		sta z80_d
		;inc sprite_mask_ptr
		;sne:inc sprite_mask_ptr+1



		;inc z80_sp
		;sne:inc z80_sp+1
		inc z80_sp_idx

        ;ldx z80_e ; LD L,E
        ;stx z80_l
		ldy z80_e
		lda z80_a
        ;ldy #$00 ; OR (HL)
        ora (z80_hl),y; 
        eor #$ff ; CPL
        ;ldx z80_d ; LD L,D
        ;stx z80_l
		ldy z80_d
        ;ldy #$00 ; OR (HL)
        ora (z80_hl),y; 
        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
		ldy #$05
        sta (z80_bc),y
        ;jsr dec_bc ; DEC BC
		;lda z80_c
		;sne:dec z80_b
		;dec z80_c
		dey
		;sty z80_bc_idx
        ;dec z80_h ; DEC H
        ;lda z80_e ; LD L,E
        ;sta z80_l
        ;ldy #$00 ; LD A,(BC)
        lda (z80_bc),y		
        eor #$ff ; CPL
		ldy z80_e
        ;ldy #$00 ; OR (HL)
        ora (z80_hl2),y
        eor #$ff ; CPL
        ;ldx z80_d ; LD L,D
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
		ldy z80_d
        ora (z80_hl2),y; 
        ;inc z80_h ; INC H

		
PrintSpriteFlippedMaskedShift_4
        eor #$ff ; CPL; 
		sta z80_a
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		;lda (z80_sp),y
		;sta z80_e
		;iny

		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1	
		;ldy #$00
		ldy z80_sp_idx
		lda (sprite_mask_ptr),y
		sta z80_e

		lda (z80_sp),y
		sta z80_d
		;inc sprite_mask_ptr
		;sne:inc sprite_mask_ptr+1



		;inc z80_sp
		;sne:inc z80_sp+1
		inc z80_sp_idx

        ;ldx z80_e ; LD L,E
        ;stx z80_l
		ldy z80_e

		lda z80_a
        ;ldy #$00 ; OR (HL)
        ora (z80_hl),y; 
        eor #$ff ; CPL
        ;ldx z80_d ; LD L,D
        ;stx z80_l
		ldy z80_d
        ;ldy #$00 ; OR (HL)
        ora (z80_hl),y; 
        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
		ldy #$04
        sta (z80_bc),y
        ;jsr dec_bc ; DEC BC
		;lda z80_c
		;sne:dec z80_b
		;dec z80_c
		dey
		;sty z80_bc_idx
        ;dec z80_h ; DEC H
        ;lda z80_e ; LD L,E
        ;sta z80_l
        ;ldy #$00 ; LD A,(BC)
        lda (z80_bc),y		
        eor #$ff ; CPL
		ldy z80_e
        ;ldy #$00 ; OR (HL)
        ora (z80_hl2),y
        eor #$ff ; CPL
        ;ldx z80_d ; LD L,D
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
		ldy z80_d
        ora (z80_hl2),y; 
        ;inc z80_h ; INC H

		
PrintSpriteFlippedMaskedShift_3
        eor #$ff ; CPL; 
		sta z80_a
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		;lda (z80_sp),y
		;sta z80_e
		;iny

		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1	
		;ldy #$00
		ldy z80_sp_idx
		lda (sprite_mask_ptr),y
		sta z80_e

		lda (z80_sp),y
		sta z80_d
		;inc sprite_mask_ptr
		;sne:inc sprite_mask_ptr+1



		;inc z80_sp
		;sne:inc z80_sp+1
		inc z80_sp_idx

        ;ldx z80_e ; LD L,E
        ;stx z80_l
		ldy z80_e

		lda z80_a
        ;ldy #$00 ; OR (HL)
        ora (z80_hl),y; 
        eor #$ff ; CPL
        ;ldx z80_d ; LD L,D
        ;stx z80_l
		ldy z80_d
        ;ldy #$00 ; OR (HL)
        ora (z80_hl),y; 
        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
		ldy #$03
        sta (z80_bc),y
        ;jsr dec_bc ; DEC BC
		;lda z80_c
		;sne:dec z80_b
		;dec z80_c
		dey
		;sty z80_bc_idx
        ;dec z80_h ; DEC H
        ;lda z80_e ; LD L,E
        ;sta z80_l
        ;ldy #$00 ; LD A,(BC)
        lda (z80_bc),y		
        eor #$ff ; CPL
		ldy z80_e
        ;ldy #$00 ; OR (HL)
        ora (z80_hl2),y
        eor #$ff ; CPL
        ;ldx z80_d ; LD L,D
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
		ldy z80_d
        ora (z80_hl2),y; 
        ;inc z80_h ; INC H

		
PrintSpriteFlippedMaskedShift_2
        eor #$ff ; CPL; 
		sta z80_a
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1	
		;ldy #$00
		ldy z80_sp_idx
		lda (sprite_mask_ptr),y
		sta z80_e

		lda (z80_sp),y
		sta z80_d
		;inc sprite_mask_ptr
		;sne:inc sprite_mask_ptr+1



		;inc z80_sp
		;sne:inc z80_sp+1
		inc z80_sp_idx

        ;ldx z80_e ; LD L,E
        ;stx z80_l
		ldy z80_e

		lda z80_a
        ;ldy #$00 ; OR (HL)
        ora (z80_hl),y; 
        eor #$ff ; CPL
        ;ldx z80_d ; LD L,D
        ;stx z80_l
		ldy z80_d
        ;ldy #$00 ; OR (HL)
        ora (z80_hl),y; 
        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
		ldy #$02
        sta (z80_bc),y
        ;jsr dec_bc ; DEC BC
		;lda z80_c
		;sne:dec z80_b
		;dec z80_c
		dey
		;sty z80_bc_idx
        ;dec z80_h ; DEC H
        ;lda z80_e ; LD L,E
        ;sta z80_l
        ;ldy #$00 ; LD A,(BC)
        lda (z80_bc),y		
        eor #$ff ; CPL
		ldy z80_e
        ;ldy #$00 ; OR (HL)
        ora (z80_hl2),y
        eor #$ff ; CPL
        ;ldx z80_d ; LD L,D
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
		ldy z80_d
        ora (z80_hl2),y; 
        ;inc z80_h ; INC H

		
PrintSpriteFlippedMaskedShift_1
        eor #$ff ; CPL; 
		sta z80_a
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1	
		;ldy #$00
		ldy z80_sp_idx
		lda (sprite_mask_ptr),y
		sta z80_e

		lda (z80_sp),y
		sta z80_d
		;inc sprite_mask_ptr
		;sne:inc sprite_mask_ptr+1



		;inc z80_sp
		;sne:inc z80_sp+1
		inc z80_sp_idx

        ;ldx z80_e ; LD L,E
        ;stx z80_l
		ldy z80_e

		lda z80_a
        ;ldy #$00 ; OR (HL)
        ora (z80_hl),y; 
        eor #$ff ; CPL
        ;ldx z80_d ; LD L,D
        ;stx z80_l
		ldy z80_d
        ;ldy #$00 ; OR (HL)
        ora (z80_hl),y; 
        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
		ldy #$01
        sta (z80_bc),y
        ;jsr dec_bc ; DEC BC
		;lda z80_c
		;sne:dec z80_b
		;dec z80_c
		dey
		;sty z80_bc_idx
        ;dec z80_h ; DEC H
        ;lda z80_e ; LD L,E
        ;sta z80_l
        ;ldy #$00 ; LD A,(BC)
        lda (z80_bc),y		
        eor #$ff ; CPL
		ldy z80_e
        ;ldy #$00 ; OR (HL)
        ora (z80_hl2),y
        eor #$ff ; CPL
        ;ldx z80_d ; LD L,D
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
		ldy z80_d
        ora (z80_hl2),y; 
        ;inc z80_h ; INC H

        ;ldy #$00 ; LD (BC),A
		;ldy z80_bc_idx
		ldy #$00
        sta (z80_bc),y; 
PrintSpriteFlippedNextRow		
        lda LA227 ; LD A,(LA227)
        clc ; ADD A,C
        adc z80_c
        sta z80_c ; LD C,A
        ;lda z80_b ; LD A,B
        ;adc #$00 ; ADC A,00
        ;sta z80_b ; LD B,A
		scc:inc z80_b
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 

        ;sec ; DEC A
        ;sbc #$01
		dec z80_ap
        ;jne LBFCB ; JP NZ,LBFCB
		jne LBCFB_Next_iteration
        ; LD SP,(LA21D): TODO  ; LD SP,(LA21D)
        rts ; RET



;LC03E   LD A,(LA27B)
;C041    LD C,A
;C042    LD A,(LA35B)
;C045    OR C
;C046    RET NZ
;C047    LD A,(LA21C)
;C04A    BIT 0,A
;C04C    JR NZ,@@219
;@@217   LD HL,LA265
;C051    DEC (HL)
;C052    JP M,LC0A5
;C055    XOR A
;C056    LD (LA240),A
;C059    LD A,(LA267)
;C05C    AND A
;C05D    JP NZ,LBC83
;C060    LD HL,LC0AB
;C063    LD DE,LA27B
;C066    LD BC,L0010
;C069    LDIR
;C06B    LD A,0A
;C06D    LD (LA21F),A
;C070    JP LD275

; man die
LC03E	

		;lda LA27B ; LD A,(LA27B)
        ;sta z80_c ; LD C,A
        ;lda LA35B ; LD A,(LA35B)
        ;ora z80_c ; OR C
        ;beq *+3 ; RET NZ
        ;rts
 
		lda LA27B
		ora LA35B
        beq *+3 ; RET NZ
        rts
 
		; clear down man start music flag
		lda #00
		sta generate_man
 
		lda game_select_type ; LD A,(LA21C)
        bit _bitmem0 ; BIT 0,A
        jne @@219 ; JR NZ,@@219
@@217   
;					
;	lda #<no_of_lives ; LD HL,LA265
;        sta z80_l
;        lda #>no_of_lives
;        sta z80_h
;
;	; unlimited lives cheat, if on (1) then branch to @
	ldx UNLIMITED_LIVES
	bne @+
;		
;        ldy #$00 ; DEC (HL)
;        lda (z80_hl),y
;        sec
;        sbc #$01
;        sta (z80_hl),y

	dec no_of_lives
	; game over
	jmi LC0A5 ; JP M,LC0A5
@
		
		; set to 0 for two player game		
		lda #$00 ; XOR A
        sta LA240 ; LD (LA240),A
        
		
		lda LA267 ; LD A,(LA267)
        ; AND  A
        
		; jump to bandit screen
		jne LBC83 ; JP NZ,LBC83



		
	;lda #<LC0AB ; LD HL,LC0AB
        ;sta z80_l
        ;lda #>LC0AB
        ;sta z80_h
        ;lda #<LA27B ; LD DE,LA27B
        ;sta z80_e
        ;lda #>LA27B
        ;sta z80_d
        ;lda #<L0010 ; LD BC,L0010
        ;sta z80_c
        ;lda #>L0010
        ;sta z80_b
        ;jsr ldir ; LDIR

		ldx #$0f
@@217_Loop		
		lda LC0AB,x
		sta LA27B,x
		dex
		bpl @@217_Loop
		
		; man speed - default $0A
        lda MAN_SPEED ; LD A,0A
        sta LA21F ; LD (LA21F),A
        
		jmp draw_lives ; JP LD275

;@@219   LD A,(LA240)
;C076    AND A
;C077    JR NZ,@@217
;C079    LD A,(LA265)
;C07C    AND A
;C07D    JR NZ,@@221
;C07F    CALL LB7A6
;C082    LD A,(LA23F)
;C085    AND A
;C086    JP NZ,LA508
;@@220   XOR 01
;C08B    LD (LA23F),A
;C08E    CALL LC7B7
;C091    CALL LA6E8
;C094    CALL LA6C7
;C097    LD A,(LA268)
;C09A    LD E,A
;C09B    CALL LD2F4
;C09E    JR @@217

@@219
     	 
		lda LA240 ; LD A,(LA240)
        ; AND  A
		
        jne @@217 ; JR NZ,@@217
		
		
		lda no_of_lives ; LD A,(LA265)
        ; AND  A
        jne @@221 ; JR NZ,@@221
        jsr game_over ; CALL LB7A6
        lda player_number ; LD A,(LA23F)
        ; AND  A
        jne LA508 ; JP NZ,LA508
		
@@220   

		;not here

		eor #$01 ; XOR 01
        sta player_number ; LD (LA23F),A
		
		
        jsr LC7B7 ; CALL LC7B7
        jsr LA6E8 ; CALL LA6E8
		
        jsr player_no_start_txt ; CALL LA6C7
        lda LA268 ; LD A,(LA268)
        sta z80_e ; LD E,A
	
        jsr draw_background_gfx ; CALL LD2F4

        jmp @@217 ; JR @@217

;@@221   LD A,(LA23F)
;C0A3    JR @@220

@@221   
	
		lda player_number ; LD A,(LA23F)
        jmp @@220 ; JR @@220

;LC0A5   CALL LB7A6
;C0A8    JP LA50B

LC0A5   jsr game_over ; CALL LB7A6
        jmp LA50B ; JP LA50B

;LC0AB   DB 19,88,04,F0,04,00,80,00
;C0B3    DB 10,10,00,00,10,00

LC0AB   .he 19,88,04,F0,04,00,80,00 ; DB 19,88,04,F0,04,00,80,00
        .he 10,10,00,00,10,00 ; DB 10,10,00,00,10,00

;LC0B9   DW LB7A2

LC0B9   .wo LB7A2 ; DW LB7A2

;LC0BB   LD HL,(LA216)
;C0BE    INC HL
;C0BF    LD (LA216),HL
;LC0C2   LD DE,(LA216)
;C0C6    LD HL,(LA218)
;C0C9    LD A,R
;C0CB    ADD A,E
;C0CC    ADD A,L
;C0CD    LD L,A
;C0CE    LD A,R
;C0D0    ADD A,D
;C0D1    ADD A,H
;C0D2    LD H,A
;C0D3    LD (LA218),HL
;C0D6    POP BC
;C0D7    PUSH BC
;C0D8    LD HL,(LA21A)
;C0DB    LD A,C
;C0DC    SUB E
;C0DD    ADD A,L
;C0DE    LD L,A
;C0DF    LD A,B
;C0E0    SUB D
;C0E1    ADD A,H
;C0E2    LD H,A
;C0E3    LD (LA21A),HL
;C0E6    RET

;LC0BB

; in game messages

telegram_messages

	;lda LA216 ; LD HL,(LA216)
        ;sta z80_l
        ;lda LA216+1
        ;sta z80_h
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ;lda z80_l ; LD (LA216),HL
        ;sta LA216
        ;lda z80_h
        ;sta LA216+1

	inc LA216
	sne:inc LA216+1

LC0C2   ;lda LA216 ; LD DE,(LA216)
        ;sta z80_e
        ;lda LA216+1
        ;sta z80_d
        ;lda LA218 ; LD HL,(LA218)
        ;sta z80_l
        ;lda LA218+1
        ;sta z80_h
        ld_a_r ; LD A,R
        clc ; ADD A,E
        ;adc z80_e
	adc LA216
        clc ; ADD A,L
        ;adc z80_l
	adc LA218
        ;sta z80_l ; LD L,A
	sta LA218
        ld_a_r ; LD A,R
        clc ; ADD A,D
        ;adc z80_d
	adc LA216+1
        clc ; ADD A,H
        ;adc z80_h
	adc LA218+1
        ;sta z80_h ; LD H,A



	sta LA218+1
        ;lda z80_l ; LD (LA218),HL
        ;sta LA218
        ;lda z80_h
        ;sta LA218+1
        ;pla ; POP BC
        ;sta z80_b
        ;pla

        ;sta z80_c
        ;lda z80_c ; PUSH BC
        ;pha

        ;lda z80_b
        ;pha
	tsx

        ;lda LA21A ; LD HL,(LA21A)
        ;sta z80_l
        ;lda LA21A+1
        ;sta z80_h
		
        ;lda z80_c ; LD A,C
	lda $0102,x
		
        sec ; SUB E
        ;sbc z80_e
	sbc LA216
        clc ; ADD A,L
        ;adc z80_l
	adc LA21A
        ;sta z80_l ; LD L,A
	sta LA21A
		
        ;lda z80_b ; LD A,B
	lda $0101,x
		
        sec ; SUB D
        ;sbc z80_d
	sbc LA216+1

        clc ; ADD A,H
        ;adc z80_h
	adc LA21A+1
        ;sta z80_h ; LD H,A



	sta LA21A+1
        ;lda z80_l ; LD (LA21A),HL
        ;sta LA21A
        ;lda z80_h
        ;sta LA21A+1
        rts ; RET


;LC0E7   LD A,(LA269)
;C0EA    AND A
;C0EB    RET Z
;C0EC    LD HL,LE001
;C0EF    LD (LA249),HL
;C0F2    LD A,(LA27D)
;C0F5    LD L,A
;C0F6    LD A,(LA27F)
;C0F9    LD H,A
;C0FA    CALL LC361
;C0FD    PUSH HL
;C0FE    LD E,00
;C100    DEC L
;C101    INC H
;C102    CALL LC727
;C105    JR Z,@@222
;C107    SET 0,E
;@@222   POP HL
;C10A    PUSH HL
;C10B    DEC L
;C10C    CALL LC727
;C10F    JR Z,@@223
;C111    SET 1,E
;@@223   POP HL
;C114    PUSH HL
;C115    INC H
;C116    CALL LC727
;C119    JR Z,@@224
;C11B    SET 2,E
;@@224   POP HL
;C11E    PUSH HL
;C11F    DEC L
;C120    DEC H
;C121    CALL LC727
;C124    JR Z,@@225
;C126    SET 3,E
;@@225   POP HL
;C129    PUSH HL
;C12A    INC L
;C12B    INC H
;C12C    CALL LC727
;C12F    JR Z,@@226
;C131    SET 4,E
;@@226   LD D,00
;C135    LD A,E
;C136    EX DE,HL
;C137    LD E,L
;C138    LD D,H
;C139    ADD HL,HL
;C13A    ADD HL,HL
;C13B    ADD HL,DE
;C13C    LD DE,L60B1
;C13F    ADD HL,DE
;C140    EX DE,HL
;C141    LD B,05
;@@227   POP HL
;C144    PUSH HL
;C145    LD A,(DE)
;C146    INC DE
;C147    BIT 5,A
;C149    JR NZ,@@229
;C14B    BIT 4,A
;C14D    JR Z,@@228
;C14F    INC L
;C150    INC L
;@@228   DEC L
;@@229   BIT 7,A
;C154    JR NZ,@@231
;C156    BIT 6,A
;C158    JR Z,@@230
;C15A    INC H
;C15B    INC H
;@@230   DEC H
;@@231   AND 03
;C15F    PUSH BC
;C160    PUSH DE
;C161    LD DE,LC171 
;C164    PUSH DE
;C165    JP Z,LC18E
;C168    DEC A
;C169    JP Z,LC53A
;C16C    DEC A
;C16D    JP Z,LC381
;C170    POP DE
;C171    POP DE
;C172    POP BC
;C173    DJNZ @@227
;C175    POP HL
;C176    PUSH HL
;C177    CALL LC189
;C17A    POP HL
;C17B    PUSH HL
;C17C    DEC H
;C17D    CALL LC189
;C180    POP HL
;C181    PUSH HL
;C182    INC L
;C183    CALL LC189
;C186    POP HL
;C187    INC L
;C188    DEC H
;LC189   PUSH HL
;C18A    CALL LC381
;C18D    POP HL
;LC18E   CALL LC193
;C191    JR LC1D6

LC0E7_l	= z80_reg4
LC0E7_h = z80_reg5


LC0E7   lda game_on ; LD A,(LA269)
        ; AND  A
        bne *+3 ; RET Z
        rts

        ;lda #<LE001 ; LD HL,LE001
        ;sta z80_l
        ;lda #>LE001
        ;sta z80_h
        ;lda z80_l ; LD (LA249),HL
        ;sta LA249
        ;lda z80_h
        ;sta LA249+1
		lda #<LE001
		sta LA249
		lda #>LE001
		sta LA249+1
        lda LA27D ; LD A,(LA27D)
        sta z80_l ; LD L,A
        lda LA27F ; LD A,(LA27F)
        sta z80_h ; LD H,A
        jsr LC361 ; CALL LC361
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
		lda z80_l
		sta LC0E7_l

		lda z80_h
		sta LC0E7_h

        lda #$00 ; LD E,00
        sta z80_e
        dec z80_l ; DEC L
        inc z80_h ; INC H
        jsr LC727 ; CALL LC727
        jeq @@222 ; JR Z,@@222
        lda z80_e ; SET 0,E
        ora #_bitvalue0
        sta z80_e
@@222   ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
		ldx LC0E7_l
		dex
		stx z80_l
		lda LC0E7_h
		sta z80_h
        ;dec z80_l ; DEC L







        jsr LC727 ; CALL LC727
        jeq @@223 ; JR Z,@@223
        lda z80_e ; SET 1,E
        ora #_bitvalue1
        sta z80_e
@@223   ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
		lda LC0E7_l

		sta z80_l
		ldx LC0E7_h
		inx


		stx z80_h

        ;inc z80_h ; INC H
        jsr LC727 ; CALL LC727
        jeq @@224 ; JR Z,@@224
        lda z80_e ; SET 2,E
        ora #_bitvalue2
        sta z80_e
@@224   ;pla ; POP HL
        ;sta z80_h
        ;pla

        ;sta z80_l
        ;lda z80_l ; PUSH HL
        ;pha

        ;lda z80_h
        ;pha
		ldx LC0E7_l
		dex
		stx z80_l
		ldx LC0E7_h
		dex
		stx z80_h

        ;dec z80_l ; DEC L
        ;dec z80_h ; DEC H
        jsr LC727 ; CALL LC727
        jeq @@225 ; JR Z,@@225
        lda z80_e ; SET 3,E
        ora #_bitvalue3
        sta z80_e
@@225   ;pla ; POP HL
        ;sta z80_h
        ;pla

        ;sta z80_l
        ;lda z80_l ; PUSH HL
        ;pha

        ;lda z80_h
        ;pha
		ldx LC0E7_l
		inx
		stx z80_l
		ldx LC0E7_h
		inx
		stx z80_h

        ;inc z80_l ; INC L
        ;inc z80_h ; INC H
        jsr LC727 ; CALL LC727
        jeq @@226 ; JR Z,@@226
        lda z80_e ; SET 4,E
        ora #_bitvalue4
        sta z80_e
@@226   lda #$00 ; LD D,00
        sta z80_d
		sta z80_h
        lda z80_e ; LD A,E
		;sta z80_l
        ;jsr ex_de_hl ; EX DE,HL
        ;lda z80_l ; LD E,L
        ;sta z80_e
        ;lda z80_h ; LD D,H
        ;sta z80_d
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
		clc
		adc z80_e
		scc:inc z80_h
        ;jsr add_hl_de ; ADD HL,DE
        ;lda #<L60B1 ; LD DE,L60B1
        ;sta z80_e
        ;lda #>L60B1
        ;sta z80_d
        ;jsr add_hl_de ; ADD HL,DE
        ;jsr ex_de_hl ; EX DE,HL
		;jsr ld_de_hl
		clc
		adc #<L60B1
		sta z80_e
		lda z80_h
		adc #>L60B1
		sta z80_d


        lda #$05 ; LD B,05
        sta z80_b
@@227   ;pla ; POP HL
        ;sta z80_h
        ;pla

        ;sta z80_l
        ;lda z80_l ; PUSH HL
        ;pha

        ;lda z80_h
        ;pha
		;lda LC0E7_l
		;sta z80_l
		;lda LC0E7_h
		;sta z80_h

        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
		ldx LC0E7_l
		ldy LC0E7_h
        bit _bitmem5 ; BIT 5,A
        jne @@229 ; JR NZ,@@229
        bit _bitmem4 ; BIT 4,A
        jeq @@228 ; JR Z,@@228
        ;inc z80_l ; INC L
        ;inc z80_l ; INC L
		inx
		inx
@@228   ;dec z80_l ; DEC L
		dex
@@229   bit _bitmem7 ; BIT 7,A
        jne @@231 ; JR NZ,@@231
        bit _bitmem6 ; BIT 6,A
        jeq @@230 ; JR Z,@@230
        ;inc z80_h ; INC H
        ;inc z80_h ; INC H
		iny
		iny
@@230   ;dec z80_h ; DEC H
		dey
@@231   stx z80_l
		sty z80_h
		and #$03 ; AND 03

        sta z80_a
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        ;lda #<(LC171-1) ; LD DE,LC171 ; Dropping return address on stack directly
        ;sta z80_e
        ;lda #>(LC171-1)
        ;sta z80_d
        ;lda z80_d ; PUSH DE
        ;pha
        ;lda z80_e
        ;pha
		lda #>(LC171-1) ; LD DE,LC171 ; Dropping return address on stack directly
		pha
		lda #<(LC171-1)

		pha
        lda z80_a
        jeq LC18E ; JP Z,LC18E; ZERO flag read but not set by previous instruction
        sec ; DEC A
        sbc #$01; A read but not set by previous instruction
        jeq LC53A ; JP Z,LC53A
        sec ; DEC A
        sbc #$01; A read but not set by previous instruction
        jeq LC381 ; JP Z,LC381
        pla ; POP DE
        ;sta z80_d
        pla
        ;sta z80_e
LC171   pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
        dec z80_b ; DJNZ @@227
        jne @@227
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
		lda LC0E7_l
		sta z80_l
		lda LC0E7_h

		sta z80_h






        jsr LC189 ; CALL LC189
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
		lda LC0E7_l

		sta z80_l
		ldx LC0E7_h
		dex


		stx z80_h		

        ;dec z80_h ; DEC H
        jsr LC189 ; CALL LC189
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
		ldx LC0E7_l
		inx
		stx z80_l
		lda LC0E7_h

		sta z80_h		
        ;inc z80_l ; INC L







        jsr LC189 ; CALL LC189
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
		ldx LC0E7_l
		inx

		stx z80_l
		ldx LC0E7_h
		dex
		stx z80_h		
        ;inc z80_l ; INC L
        ;dec z80_h ; DEC H
LC189   lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr LC381 ; CALL LC381
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
LC18E   jsr PrepareObjectsToSort ; CALL LC193
        jmp LC1D6 ; JR LC1D6

;LC193   LD IY,LC341
;C197    LD IX,LA27B
;C19B    CALL LC361
;C19E    EX DE,HL
;@@232   LD A,(IX+00)
;C1A2    AND A
;C1A3    JR Z,@@234
;C1A5    LD A,E
;C1A6    CP (IX+02)
;C1A9    JR NZ,@@234
;C1AB    LD A,D
;C1AC    CP (IX+04)
;C1AF    JR NZ,@@234
;C1B1    PUSH IX
;C1B3    POP HL
;C1B4    LD (IY+00),L
;C1B7    LD (IY+01),H
;C1BA    INC IY
;C1BC    INC IY
;@@234   LD BC,L0010
;C1C1    ADD IX,BC
;C1C3    PUSH IX
;C1C5    POP HL
;C1C6    LD BC,LA36B 
;C1C9    AND A
;C1CA    SBC HL,BC
;C1CC    JR C,@@232
;C1CE    XOR A
;C1CF    LD (IY+00),A
;C1D2    LD (IY+01),A
;C1D5    RET

PrepareObjectsToSort
		;lda #<LC341 ; LD IY,LC341
        ;sta z80_iy
        ;lda #>LC341
        ;sta z80_iy+1
        ;lda #<LA27B ; LD IX,LA27B
        ;sta z80_ix
        ;lda #>LA27B

        ;sta z80_ix+1
        jsr LC361 ; CALL LC361
        ;jsr ex_de_hl ; EX DE,HL
		jsr ld_de_hl
		ldx #$00
		ldy #$00
@@232   ;ldy #$00 ; LD A,(IX+00)
        ;lda (z80_ix),y
		lda LA27B,y
        ; AND  A
        jeq @@234 ; JR Z,@@234
        lda z80_e ; LD A,E
        ;ldy #$02 ; CP (IX+02)
		;iny
		;iny
        ;cmp (z80_ix),y
		cmp LA27B+2,y
        jne @@234 ; JR NZ,@@234
        lda z80_d ; LD A,D
        ;ldy #$04 ; CP (IX+04)
		;iny
		;iny
        ;cmp (z80_ix),y
		cmp LA27B+4,y
        jne @@234 ; JR NZ,@@234
        ;lda z80_ix ; PUSH IX
        ;pha
        ;lda z80_ix+1
        ;pha
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;ldy #$00 ; LD (IY+00),L
        ;lda z80_l
		;lda z80_ix
		tya
		clc
		adc #<LA27B
        ;sta (z80_iy),y
		sta ObjectsToSort,x
        ;ldy #$01 ; LD (IY+01),H
		;iny
		inx
        ;lda z80_h
		;lda z80_ix+1
		lda #>LA27B
		adc #$00
        ;sta (z80_iy),y
		sta ObjectsToSort,x
		inx
        ;inc z80_iy ; INC IY
        ;bne *+4
        ;inc z80_iy+1
        ;inc z80_iy ; INC IY
        ;bne *+4
        ;inc z80_iy+1
@@234   ;lda #<L0010 ; LD BC,L0010
        ;sta z80_c
        ;lda #>L0010
        ;sta z80_b
        ;jsr add_ix_bc ; ADD IX,BC
        ;lda z80_ix ; PUSH IX
        ;pha
        ;lda z80_ix+1
        ;pha
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;lda #<LA36B ; LD BC,LA36B
        ;sta z80_c
        ;lda #>LA36B
        ;sta z80_b
        ; AND  A
        ;sec
        ;jsr sbc_hl_bc ; SBC HL,BC
		;lda #$10
		;clc
		;adc z80_ix
		;sta z80_ix
		;scc:inc z80_ix+1
		;cmp #<LA36B
		;lda z80_ix+1
		;sbc #>LA36B
		tya

		clc
		adc #$10
		tay
		cmp #$f0
		jne @@232






        ;jcc @@232 ; JR C,@@232
        lda #$00 ; XOR A
        ;ldy #$00 ; LD (IY+00),A
        ;sta (z80_iy),y
		sta ObjectsToSort,x
		sta ObjectsToSort+1,x
        ;ldy #$01 ; LD (IY+01),A
		;iny
        ;sta (z80_iy),y
        rts ; RET


;LC1D6   LD HL,LC341
;@@237   LD E,(HL)
;C1DA    INC HL
;C1DB    LD D,(HL)
;C1DC    INC HL
;C1DD    LD A,D
;C1DE    OR E
;C1DF    RET Z
;C1E0    BIT 7,D
;C1E2    JR Z,@@237
;C1E4    LD (LA24B),HL
;C1E7    PUSH DE
;C1E8    POP IX
;LC1EA   LD E,(HL)
;C1EB    INC HL
;C1EC    LD D,(HL)
;C1ED    INC HL
;C1EE    LD A,D
;C1EF    OR E
;C1F0    JP Z,LC278
;C1F3    BIT 7,D
;C1F5    JR Z,LC1EA
;C1F7    LD (LA24D),HL
;C1FA    PUSH DE
;C1FB    POP IY
;C1FD    LD C,00
;C1FF    LD A,(IY+01)
;C202    ADD A,(IY+08)
;C205    RRA
;C206    ADD A,40
;C208    LD B,A
;C209    LD A,(IX+01)
;C20C    SUB (IX+08)
;C20F    RRA
;C210    ADD A,40
;C212    SUB B
;C213    JR NC,@@240
;C215    LD A,(IX+01)
;C218    ADD A,(IX+08)
;C21B    RRA
;C21C    ADD A,40
;C21E    LD B,A
;C21F    LD A,(IY+01)
;C222    SUB (IY+08)
;C225    RRA
;C226    ADD A,40
;C228    SUB B
;C229    JR C,@@239
;C22B    INC C
;@@239   INC C
;@@240   LD A,(IY+03)
;C230    ADD A,(IY+09)
;C233    RRA
;C234    ADD A,40
;C236    LD B,A
;C237    LD A,(IX+03)
;C23A    SUB (IX+09)
;C23D    RRA
;C23E    ADD A,40
;C240    SUB B
;C241    LD A,C
;C242    JR NC,@@242
;C244    LD A,(IX+03)
;C247    ADD A,(IX+09)
;C24A    RRA
;C24B    ADD A,40
;C24D    LD B,A
;C24E    LD A,(IY+03)
;C251    SUB (IY+09)
;C254    RRA
;C255    ADD A,40
;C257    SUB B
;C258    LD A,C
;C259    JR C,@@241
;C25B    ADD A,03
;@@241   ADD A,03
;@@242   LD C,A
;C260    LD A,(LA24F)
;C263    AND 01
;C265    JR Z,@@243
;C267    LD A,C
;C268    ADD A,09
;C26A    LD C,A
;@@243   LD A,C
;C26C    LD BC,LC284
;C26F    CALL LC755
;C272    LD HL,(LA24D)
;C275    JP LC1EA

LC1D6   lda #<ObjectsToSort ; LD HL,LC341
        sta z80_l
        lda #>ObjectsToSort

        sta z80_h
@@237   ldy #$00 ; LD E,(HL)
        lda (z80_hl),y
        sta z80_e
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD D,(HL)
        lda (z80_hl),y
        sta z80_d
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        lda z80_d ; LD A,D
        ora z80_e ; OR E
        bne *+3 ; RET Z
        rts
        lda z80_d ; BIT 7,D	; this tests if DE is valid pointer?
        ;bit _bitmem7
		and #$c0 ; DE >= $4000
        jeq @@237 ; JR Z,@@237
        lda z80_l ; LD (LA24B),HL
        sta LA24B
        lda z80_h
        sta LA24B+1
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha
        ;pla ; POP IX
        ;sta z80_ix+1
        ;pla
        ;sta z80_ix
		lda z80_e
		sta z80_ix

		lda z80_d


		sta z80_ix+1


LC1EA   ldy #$00 ; LD E,(HL)
        lda (z80_hl),y
        sta z80_e
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD D,(HL)
        lda (z80_hl),y
        sta z80_d
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        lda z80_d ; LD A,D
        ora z80_e ; OR E
        jeq LC278 ; JP Z,LC278
        lda z80_d ; BIT 7,D ; this tests if DE is valid pointer
        ;bit _bitmem7
		and #$c0 ; DE >= $4000
        jeq LC1EA ; JR Z,LC1EA
        lda z80_l ; LD (LA24D),HL
        sta LA24D
        lda z80_h
        sta LA24D+1
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		lda z80_e
		sta z80_iy

		lda z80_d


		sta z80_iy+1


        lda #$00 ; LD C,00
        sta z80_c
        ldy #$01 ; LD A,(IY+01)
        lda (z80_iy),y
        ldy #$08 ; ADD A,(IY+08)
        clc
        adc (z80_iy),y
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sta z80_b ; LD B,A
        ldy #$01 ; LD A,(IX+01)
        lda (z80_ix),y
        ldy #$08 ; SUB (IX+08)
        sec
        sbc (z80_ix),y
		; need to invert C flag here, as it comes from subtraction and is consumed by shift
		jsr ccf
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sec ; SUB B
        sbc z80_b
        jcs @@240 ; JR NC,@@240
        ldy #$01 ; LD A,(IX+01)
        lda (z80_ix),y
        ldy #$08 ; ADD A,(IX+08)
        clc
        adc (z80_ix),y
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sta z80_b ; LD B,A
        ldy #$01 ; LD A,(IY+01)
        lda (z80_iy),y
        ldy #$08 ; SUB (IY+08)
        sec
        sbc (z80_iy),y
		; need to invert C flag here, as it comes from subtraction and is consumed by shift
		jsr ccf		
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sec ; SUB B
        sbc z80_b
        jcc @@239 ; JR C,@@239
        inc z80_c ; INC C
@@239   inc z80_c ; INC C
@@240   ldy #$03 ; LD A,(IY+03)
        lda (z80_iy),y
        ldy #$09 ; ADD A,(IY+09)
        clc
        adc (z80_iy),y
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sta z80_b ; LD B,A
        ldy #$03 ; LD A,(IX+03)
        lda (z80_ix),y
        ldy #$09 ; SUB (IX+09)
        sec
        sbc (z80_ix),y
		; need to invert C flag here, as it comes from subtraction and is consumed by shift
		jsr ccf		
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sec ; SUB B
        sbc z80_b
        lda z80_c ; LD A,C
        jcs @@242 ; JR NC,@@242
        ldy #$03 ; LD A,(IX+03)
        lda (z80_ix),y
        ldy #$09 ; ADD A,(IX+09)
        clc
        adc (z80_ix),y
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sta z80_b ; LD B,A
        ldy #$03 ; LD A,(IY+03)
        lda (z80_iy),y
        ldy #$09 ; SUB (IY+09)
        sec
        sbc (z80_iy),y
		; need to invert C flag here, as it comes from subtraction and is consumed by shift
		jsr ccf		
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sec ; SUB B
        sbc z80_b
        lda z80_c ; LD A,C
        jcc @@241 ; JR C,@@241
        clc ; ADD A,03
        adc #$03
@@241   clc ; ADD A,03
        adc #$03
@@242   sta z80_c ; LD C,A
        lda LA24F ; LD A,(LA24F)
        and #$01 ; AND 01
        jeq @@243 ; JR Z,@@243
        lda z80_c ; LD A,C
        clc ; ADD A,09
        adc #$09
        sta z80_c ; LD C,A
@@243   lda z80_c ; LD A,C
        ldx #<LC284 ; LD BC,LC284
        stx z80_c
        ldx #>LC284
        stx z80_b
        jsr LC755 ; CALL LC755; uses A as parameter
        lda LA24D ; LD HL,(LA24D)
        sta z80_l
        lda LA24D+1
        sta z80_h
        jmp LC1EA ; JP LC1EA


;LC278   LD HL,(LA24B)
;C27B    DEC HL
;C27C    RES 7,(HL)
;C27E    CALL LBD57
;C281    JP LC1D6

LC278   lda LA24B ; LD HL,(LA24B)
        sta z80_l
        lda LA24B+1
        sta z80_h
        jsr dec_hl ; DEC HL
        ldy #$00 ; RES 7,(HL)
        lda (z80_hl),y
        ;and #_notbitvalue7	; this marks entry at c341 table as processed
		and #$3f
        sta (z80_hl),y
        jsr LBD57 ; CALL LBD57
        jmp LC1D6 ; JP LC1D6

;LC284   DW LC2A8,LC2A8,LC2A8,LC2A9
;C28C    DW LC2B4,LC2A8,LC2A9,LC2A9
;C294    DW LC2A8,LC2A8,LC2A9,LC2A9
;C29C    DW LC2A8,LC2B4,LC2A9,LC2A8
;C2A4    DW LC2A8,LC2A8

LC284   .wo LC2A8,LC2A8,LC2A8,LC2A9 ; DW LC2A8,LC2A8,LC2A8,LC2A9
        .wo LC2B4,LC2A8,LC2A9,LC2A9 ; DW LC2B4,LC2A8,LC2A9,LC2A9
        .wo LC2A8,LC2A8,LC2A9,LC2A9 ; DW LC2A8,LC2A8,LC2A9,LC2A9
        .wo LC2A8,LC2B4,LC2A9,LC2A8 ; DW LC2A8,LC2B4,LC2A9,LC2A8
        .wo LC2A8,LC2A8 ; DW LC2A8,LC2A8

;C2A8    RET

LC2A8    rts ; RET

;LC2A9   LD HL,(LA24D)
;C2AC    LD (LA24B),HL
;C2AF    PUSH IY
;C2B1    POP IX
;C2B3    RET

LC2A9   ;lda LA24D ; LD HL,(LA24D)
        ;sta z80_l
        ;lda LA24D+1
        ;sta z80_h
        ;lda z80_l ; LD (LA24B),HL
        ;sta LA24B
        ;lda z80_h
        ;sta LA24B+1
		lda LA24D
		sta LA24B

		lda LA24D+1




		sta LA24B+1
        ;lda z80_iy ; PUSH IY
        ;pha
        ;lda z80_iy+1
        ;pha
        ;pla ; POP IX
        ;sta z80_ix+1
        ;pla
        ;sta z80_ix
		lda z80_iy
		sta z80_ix

		lda z80_iy+1


		sta z80_ix+1


        rts ; RET

;C2B4    LD A,(LA24F)
;C2B7    AND 01
;C2B9    JR NZ,@@245
;C2BB    LD A,(IY+01)
;C2BE    ADD A,(IY+08)
;C2C1    RRA
;C2C2    ADD A,40
;C2C4    LD C,A
;C2C5    LD B,00
;C2C7    LD A,(IY+03)
;C2CA    SUB (IY+09)
;C2CD    RRA
;C2CE    ADD A,40
;C2D0    LD L,A
;C2D1    LD H,00
;C2D3    AND A
;C2D4    SBC HL,BC
;C2D6    LD BC,L0100
;C2D9    ADD HL,BC
;C2DA    SRL H
;C2DC    RR L
;C2DE    EX DE,HL
;C2DF    LD A,(IX+01)
;C2E2    ADD A,(IX+08)
;C2E5    RRA
;C2E6    ADD A,40
;C2E8    LD C,A
;C2E9    LD B,00
;C2EB    LD A,(IX+03)
;C2EE    SUB (IX+09)
;@@244   RRA
;C2F2    ADD A,40
;C2F4    LD L,A
;C2F5    LD H,00
;C2F7    AND A
;C2F8    SBC HL,BC
;C2FA    LD BC,L0100
;C2FD    ADD HL,BC
;C2FE    SRL H
;C300    RR L
;C302    AND A
;C303    SBC HL,DE
;C305    RET NC
;C306    JP LC2A9

LC2B4   lda LA24F ; LD A,(LA24F)
        and #$01 ; AND 01
        jne @@245 ; JR NZ,@@245
        ldy #$01 ; LD A,(IY+01)
        lda (z80_iy),y
        ldy #$08 ; ADD A,(IY+08)
        clc
        adc (z80_iy),y
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sta z80_c ; LD C,A
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ldy #$03 ; LD A,(IY+03)
        lda (z80_iy),y
        ldy #$09 ; SUB (IY+09)
        sec
        sbc (z80_iy),y
		jsr ccf
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        ;sta z80_l ; LD L,A
        ;lda #$00 ; LD H,00
        ;sta z80_h
        ; AND  A
        sec
        ;jsr sbc_hl_bc ; SBC HL,BC
		sbc z80_c
		sta z80_e
		lda #$01
		sbc #$00
		;sta z80_h
		lsr @
		sta z80_d
		ror z80_e
        ;lda #<L0100 ; LD BC,L0100
        ;sta z80_c
        ;lda #>L0100
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
        ;lsr z80_h ; SRL H
        ;ror z80_l ; RR L
        ;jsr ex_de_hl ; EX DE,HL
		;jsr ld_de_hl
        ldy #$01 ; LD A,(IX+01)
        lda (z80_ix),y
        ldy #$08 ; ADD A,(IX+08)
        clc
        adc (z80_ix),y
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sta z80_c ; LD C,A
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ldy #$03 ; LD A,(IX+03)
        lda (z80_ix),y
        ldy #$09 ; SUB (IX+09)
        sec
        sbc (z80_ix),y
		jsr ccf
@@244   ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        ;sta z80_l ; LD L,A
        ;lda #$00 ; LD H,00
        ;sta z80_h
        ; AND  A
        sec
        ;jsr sbc_hl_bc ; SBC HL,BC
		sbc z80_c
		sta z80_l
		lda #$01
		sbc #$00
		lsr @
		sta z80_h
        ;lda #<L0100 ; LD BC,L0100
        ;sta z80_c
        ;lda #>L0100
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
        ;lsr z80_h ; SRL H
        ror z80_l ; RR L
        ; AND  A
        sec
        jsr sbc_hl_de ; SBC HL,DE
        bcc *+3 ; RET NC
        rts
        jmp LC2A9 ; JP LC2A9


;@@245   LD A,(IX+01)
;C30C    SUB (IX+08)
;C30F    RRA
;C310    ADD A,40
;C312    LD C,A
;C313    LD B,00
;C315    LD A,(IX+03)
;C318    ADD A,(IX+09)
;C31B    RRA
;C31C    ADD A,40
;C31E    LD L,A
;C31F    LD H,00
;C321    AND A
;C322    SBC HL,BC
;C324    LD BC,L0100
;C327    ADD HL,BC
;C328    SRL H
;C32A    RR L
;C32C    EX DE,HL
;C32D    LD A,(IY+01)
;C330    SUB (IY+08)
;C333    RRA
;C334    ADD A,40
;C336    LD C,A
;C337    LD B,00
;C339    LD A,(IY+03)
;C33C    ADD A,(IY+09)
;C33F    JR @@244

@@245   ldy #$01 ; LD A,(IX+01)
        lda (z80_ix),y
        ldy #$08 ; SUB (IX+08)
        sec
        sbc (z80_ix),y
		jsr ccf
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sta z80_c ; LD C,A
        lda #$00 ; LD B,00
        sta z80_b
        ldy #$03 ; LD A,(IX+03)
        lda (z80_ix),y
        ldy #$09 ; ADD A,(IX+09)
        clc
        adc (z80_ix),y
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sta z80_l ; LD L,A
        lda #$00 ; LD H,00
        sta z80_h
        ; AND  A
        sec
        jsr sbc_hl_bc ; SBC HL,BC
        lda #<L0100 ; LD BC,L0100
        sta z80_c
        lda #>L0100
        sta z80_b
        jsr add_hl_bc ; ADD HL,BC
        lsr z80_h ; SRL H
        ror z80_l ; RR L
        jsr ex_de_hl ; EX DE,HL
        ldy #$01 ; LD A,(IY+01)
        lda (z80_iy),y
        ldy #$08 ; SUB (IY+08)
        sec
        sbc (z80_iy),y
		jsr ccf
        ror @ ; RRA
        clc ; ADD A,40
        adc #$40
        sta z80_c ; LD C,A
        lda #$00 ; LD B,00
        sta z80_b
        ldy #$03 ; LD A,(IY+03)
        lda (z80_iy),y
        ldy #$09 ; ADD A,(IY+09)
        clc
        adc (z80_iy),y
        jmp @@244 ; JR @@244

;LC341   DB 00,00,00,00,00,00,00,00
;C349    DB 00,00,00,00,00,00,00,00
;C351    DB 00,00,00,00,00,00,00,00
;C359    DB 00,00,00,00,00,00,00,00

ObjectsToSort   .he 00,00;,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
LC343	.he 00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00

;LC361   LD A,(LA24F)
;C364    AND 01
;C366    RET Z
;C367    LD A,L
;C368    CPL
;C369    AND 0F
;C36B    LD L,A
;C36C    LD A,H
;C36D    CPL
;C36E    AND 0F
;C370    LD H,A
;C371    RET

LC361   lda LA24F ; LD A,(LA24F)
        and #$01 ; AND 01
        bne *+3 ; RET Z
        rts
        lda z80_l ; LD A,L
        eor #$ff ; CPL
        and #$0F ; AND 0F
        sta z80_l ; LD L,A
        lda z80_h ; LD A,H
        eor #$ff ; CPL
        and #$0F ; AND 0F
        sta z80_h ; LD H,A
        rts ; RET

;LC372   LD A,(LA24F)
;C375    AND 01
;C377    RET Z
;C378    LD A,L
;C379    CPL
;C37A    LD L,A
;C37B    LD A,H
;C37C    CPL
;C37D    AND 0F
;C37F    LD H,A
;C380    RET

LC372   lda LA24F ; LD A,(LA24F)
        and #$01 ; AND 01
        bne *+3 ; RET Z
        rts
        lda z80_l ; LD A,L
        eor #$ff ; CPL
        sta z80_l ; LD L,A
        lda z80_h ; LD A,H
        eor #$ff ; CPL
        and #$0F ; AND 0F
        sta z80_h ; LD H,A
        rts ; RET

;LC381   CALL LC727
;C384    RET Z
;C385    ADD A,A
;C386    PUSH AF
;C387    CALL LC6CB
;C38A    POP AF
;C38B    PUSH AF
;C38C    LD HL,LA24F
;C38F    BIT 0,(HL)
;C391    JR NZ,@@249
;C393    CALL LC3DE
;C396    POP AF
;C397    OR 01
;@@246   LD HL,(LA250)
;C39C    LD DE,LFFF0
;C39F    ADD HL,DE
;C3A0    LD (LA250),HL
;C3A3    LD BC,L626C
;C3A6    CALL LC74B
;C3A9    PUSH HL
;C3AA    POP IY
;C3AC    XOR A
;C3AD    LD (LA254),A
;C3B0    LD BC,L0801
;@@247   CALL LC457
;C3B6    CALL LC439
;C3B9    DJNZ @@247
;C3BB    LD HL,(LA252)
;C3BE    LD DE,LFFF8
;C3C1    ADD HL,DE
;C3C2    LD (LA252),HL
;C3C5    LD A,01
;C3C7    LD (LA254),A
;C3CA    LD BC,L0801
;@@248   CALL LC457
;C3D0    CALL LC452
;C3D3    DJNZ @@248
;C3D5    RET

LC381   jsr LC727 ; CALL LC727
        bne *+3 ; RET Z
        rts
        asl @ ; ADD A,A
        pha ; PUSH AF
        php
        jsr LC6CB ; CALL LC6CB
        plp ; POP AF
        pla
        pha ; PUSH AF
        php
        tax
        ;lda #<LA24F ; LD HL,LA24F
        ;sta z80_l
        ;lda #>LA24F
        ;sta z80_h
        ;ldy #$00 ; BIT 0,(HL)
        ;lda (z80_hl),y
		lda LA24F
        bit _bitmem0
        jne @@249 ; JR NZ,@@249
        txa
        jsr LC3DE ; CALL LC3DE
        plp ; POP AF
        pla
        ora #$01 ; OR 01
@@246   asl @
		tax
        ;lda LA250 ; LD HL,(LA250)
        ;sta z80_l
        ;lda LA250+1
        ;sta z80_h
        ;lda #<LFFF0 ; LD DE,LFFF0
        ;sta z80_e
        ;lda #>LFFF0
        ;sta z80_d
        ;jsr add_hl_de ; ADD HL,DE
        ;lda z80_l ; LD (LA250),HL
        ;sta LA250
        ;lda z80_h
        ;sta LA250+1
		lda LA250
		sec
		sbc #$10
		sta LA250
		scs:dec LA250+1
        ;lda #<L626C ; LD BC,L626C
        ;sta z80_c
        ;lda #>L626C
        ;sta z80_b
        lda L626C,x
		sta z80_iy
		lda L626C+1,x
		sta z80_iy+1

        ;jsr LC74B ; CALL LC74B ; uses A as parameter
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		;lda z80_l
		;sta z80_iy


		;lda z80_h
		;sta z80_iy+1
        lda #$00 ; XOR A
        sta LA254 ; LD (LA254),A
        lda #<L0801 ; LD BC,L0801
        sta z80_c
        lda #>L0801
        sta z80_b
@@247   jsr PrintBuildingLines ; CALL LC457
        jsr LC439 ; CALL LC439
        dec z80_b ; DJNZ @@247
        jne @@247
        ;lda LA252 ; LD HL,(LA252)
        ;sta z80_l
        ;lda LA252+1
        ;sta z80_h
        ;lda #<LFFF8 ; LD DE,LFFF8
        ;sta z80_e
        ;lda #>LFFF8
        ;sta z80_d
        ;jsr add_hl_de ; ADD HL,DE
        ;lda z80_l ; LD (LA252),HL
        ;sta LA252
        ;lda z80_h
        ;sta LA252+1
		lda LA252
		sec
		sbc #$08
		sta LA252
		scs:dec LA252+1
        lda #$01 ; LD A,01
        sta LA254 ; LD (LA254),A
        lda #<L0801 ; LD BC,L0801
        sta z80_c
        lda #>L0801
        sta z80_b
@@248   jsr PrintBuildingLines ; CALL LC457
        jsr LC452 ; CALL LC452
        dec z80_b ; DJNZ @@248
        jne @@248
        rts ; RET


;@@249   OR 01
;C3D8    CALL LC3DE
;C3DB    POP AF
;C3DC    JR @@246

@@249   txa
        ora #$01 ; OR 01; A read at the beginning of the block
        jsr LC3DE ; CALL LC3DE
        plp ; POP AF
        pla
        jmp @@246 ; JR @@246

;LC3DE   LD BC,L626C
;C3E1    CALL LC74B
;C3E4    PUSH HL
;C3E5    POP IY
;C3E7    XOR A
;C3E8    LD (LA254),A
;C3EB    LD BC,L0800
;@@250   CALL LC457
;C3F1    CALL LC42F
;C3F4    DJNZ @@250
;C3F6    LD HL,(LA252)
;C3F9    LD DE,L0008
;C3FC    ADD HL,DE
;C3FD    LD (LA252),HL
;C400    LD A,01
;C402    LD (LA254),A
;C405    LD BC,L0800
;@@251   CALL LC457
;C40B    CALL LC416
;C40E    DJNZ @@251
;C410    RET

LC3DE   ;ldx #<L626C ; LD BC,L626C
        ;stx z80_c
        ;ldx #>L626C
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		asl @
		tax
		lda L626C,x
		sta z80_iy
		lda L626C+1,x
		sta z80_iy+1
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		;lda z80_l
		;sta z80_iy


		;lda z80_h
		;sta z80_iy+1
        lda #$00 ; XOR A
        sta LA254 ; LD (LA254),A
        lda #<L0800 ; LD BC,L0800
        sta z80_c
        lda #>L0800
        sta z80_b
@@250   jsr PrintBuildingLines ; CALL LC457
        jsr LC42F ; CALL LC42F
        dec z80_b ; DJNZ @@250
        jne @@250
        ;lda LA252 ; LD HL,(LA252)
        ;sta z80_l
        ;lda LA252+1
        ;sta z80_h
        ;lda #<L0008 ; LD DE,L0008
        ;sta z80_e
        ;lda #>L0008
        ;sta z80_d
        ;jsr add_hl_de ; ADD HL,DE
        ;lda z80_l ; LD (LA252),HL
        ;sta LA252
        ;lda z80_h
        ;sta LA252+1
		lda LA252
		clc
		adc #$08
		sta LA252
		scc:inc LA252+1
        lda #$01 ; LD A,01
        sta LA254 ; LD (LA254),A
        lda #<L0800 ; LD BC,L0800
        sta z80_c
        lda #>L0800
        sta z80_b
@@251   jsr PrintBuildingLines ; CALL LC457
        jsr LC416 ; CALL LC416
        dec z80_b ; DJNZ @@251
        jne @@251
        rts ; RET

;LC411   LD DE,L0008
;C414    JR @@253

LC411   ;lda #<L0008 ; LD DE,L0008
        ;sta z80_e
        ;lda #>L0008
        ;sta z80_d
		ldx #<L0008
		ldy #>L0008
        jmp @@253 ; JR @@253

;LC416   LD DE,L0008
;@@252   INC IY
;C41B    INC IY
;@@253   LD HL,(LA252)
;C420    ADD HL,DE
;C421    LD (LA252),HL
;C424    LD HL,(LA250)
;C427    LD DE,L0010
;C42A    ADD HL,DE
;C42B    LD (LA250),HL
;C42E    RET

LC416   ;lda #<L0008 ; LD DE,L0008
        ;sta z80_e
        ;lda #>L0008
        ;sta z80_d
		ldx #<L0008
		ldy #>L0008
@@252   inc z80_iy ; INC IY
        bne *+4
        inc z80_iy+1
        inc z80_iy ; INC IY
        bne *+4
        inc z80_iy+1
@@253   ;lda LA252 ; LD HL,(LA252)
        ;sta z80_l
        ;lda LA252+1
        ;sta z80_h
        ;jsr add_hl_de ; ADD HL,DE
        ;lda z80_l ; LD (LA252),HL
        ;sta LA252
        ;lda z80_h
        ;sta LA252+1

		clc
		txa
		adc LA252
		;clc
		;adc z80_e
		sta LA252
		tya
		;lda LA252+1
		;adc z80_d
		adc LA252+1
		sta LA252+1
        ;lda LA250 ; LD HL,(LA250)
        ;sta z80_l
        ;lda LA250+1
        ;sta z80_h
        ;lda #<L0010 ; LD DE,L0010
        ;sta z80_e
        ;lda #>L0010
        ;sta z80_d
        ;jsr add_hl_de ; ADD HL,DE
        ;lda z80_l ; LD (LA250),HL
        ;sta LA250
        ;lda z80_h
        ;sta LA250+1
		lda LA250
		clc
		adc #$10
		sta LA250
		scc:inc LA250+1
        rts ; RET

;LC42F   LD DE,LFFF8
;C432    JR @@252

LC42F   ;lda #<LFFF8 ; LD DE,LFFF8
        ;sta z80_e
        ;lda #>LFFF8
        ;sta z80_d
		ldx #<LFFF8
		ldy #>LFFF8
        jmp @@252 ; JR @@252

;LC434   LD DE,LFFF8
;C437    JR @@253

LC434   ;lda #<LFFF8 ; LD DE,LFFF8
        ;sta z80_e
        ;lda #>LFFF8
        ;sta z80_d
		ldx #<LFFF8
		ldy #>LFFF8
        jmp @@253 ; JR @@253

;LC439   LD DE,L0008
;@@255   INC IY
;C43E    INC IY
;C440    LD HL,(LA252)
;C443    ADD HL,DE
;C444    LD (LA252),HL
;C447    LD HL,(LA250)
;C44A    LD DE,LFFF0
;C44D    ADD HL,DE
;C44E    LD (LA250),HL
;C451    RET

LC439   ;lda #<L0008 ; LD DE,L0008
        ;sta z80_e
        ;lda #>L0008
        ;sta z80_d
		ldx #<L0008
		ldy #>L0008
@@255   inc z80_iy ; INC IY
        bne *+4
        inc z80_iy+1
        inc z80_iy ; INC IY
        bne *+4
        inc z80_iy+1
        ;lda LA252 ; LD HL,(LA252)
        ;sta z80_l
        ;lda LA252+1
        ;sta z80_h
        ;jsr add_hl_de ; ADD HL,DE
        ;lda z80_l ; LD (LA252),HL
        ;sta LA252
        ;lda z80_h
        ;sta LA252+1
		;lda LA252
		;clc
		;adc z80_e
		clc
		txa
		adc LA252

		sta LA252
		;lda LA252+1
		;adc z80_d
		tya
		adc LA252+1
		sta LA252+1
        ;lda LA250 ; LD HL,(LA250)
        ;sta z80_l
        ;lda LA250+1
        ;sta z80_h
        ;lda #<LFFF0 ; LD DE,LFFF0
        ;sta z80_e
        ;lda #>LFFF0
        ;sta z80_d
        ;jsr add_hl_de ; ADD HL,DE
        ;lda z80_l ; LD (LA250),HL
        ;sta LA250
        ;lda z80_h
        ;sta LA250+1
		lda LA250
		sec
		sbc #$10
		sta LA250
		scs:dec LA250+1
        rts ; RET

;LC452   LD DE,LFFF8
;C455    JR @@255

LC452   ;lda #<LFFF8 ; LD DE,LFFF8
        ;sta z80_e
        ;lda #>LFFF8
        ;sta z80_d
		ldx #<LFFF8
		ldy #>LFFF8
        jmp @@255 ; JR @@255

;LC457   LD DE,(LA250)
;C45B    LD HL,L00CF
;C45E    AND A
;C45F    SBC HL,DE
;C461    RET C
;C462    LD HL,L0010
;C465    SBC HL,DE
;C467    RET NC
;C468    LD HL,(LA252)
;C46B    LD A,H
;C46C    AND A
;C46D    RET NZ
;C46E    LD D,L
;C46F    LD A,C
;C470    PUSH BC
;C471    LD C,(IY+00)
;C474    LD B,00
;C476    LD HL,L5E2C
;C479    ADD HL,BC
;C47A    XOR (HL)
;C47B    LD BC,L8A2E
;C47E    CALL LC74B
;C481    CALL LC496
;C484    POP BC
;C485    RET

PrintBuildingLines
;LC457   ;lda LA250 ; LD DE,(LA250)
        ;sta z80_e
        ;lda LA250+1
        ;sta z80_d
        ;lda #<L00CF ; LD HL,L00CF
        ;sta z80_l
        ;lda #>L00CF
        ;sta z80_h
        ; AND  A
        ;sec
        ;jsr sbc_hl_de ; SBC HL,DE
		lda #<L00CF
		cmp LA250
		lda #>L00CF
		sbc LA250+1




        bcs *+3 ; RET C
        rts
        ;lda #<L0010 ; LD HL,L0010
        ;sta z80_l
        ;lda #>L0010
        ;sta z80_h
        ;jsr sbc_hl_de ; SBC HL,DE
		lda #<L0010
		sbc LA250
		lda #>L0010
		sbc LA250+1


        bcc *+3 ; RET NC
        rts
        ldx LA252 ; LD HL,(LA252)
        stx z80_l

        lda LA252+1
        ;sta z80_h
        ;lda z80_h ; LD A,H
        ; AND  A
        beq *+3 ; RET NZ
        rts
		lda LA250
		sta z80_e
        ;lda z80_l ; LD D,L
        ;sta z80_d
		stx z80_d
        lda z80_c ; LD A,C
        tax
        ;lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        ldy #$00 ; LD C,(IY+00)
        lda (z80_iy),y
        ;sta z80_c
		tay
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;lda #<L5E2C ; LD HL,L5E2C
        ;sta z80_l
        ;lda #>L5E2C
        ;sta z80_h
        ;jsr add_hl_bc ; ADD HL,BC
        ;ldy #$00 ; XOR (HL)
        txa
        ;eor (z80_hl),y; A read but not set by previous instruction
		eor L5E2C,y
        ;ldx #<L8A2E ; LD BC,L8A2E
        ;stx z80_c
        ;ldx #>L8A2E
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		asl @
		tax
		lda L8A2E,x
		sta z80_l
		lda L8A2E+1,x
		sta z80_h
        jsr PrintSmallBackgroundObjects ; CALL LC496

        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
        rts ; RET


;@@256   NEG
;C488    LD C,A
;C489    LD A,(HL)
;C48A    INC HL
;C48B    SUB C
;C48C    RET M
;C48D    RET Z
;C48E    LD B,00
;C490    ADD HL,BC
;C491    ADD HL,BC
;C492    LD D,48
;C494    JR @@258

@@256   eor #$ff ; NEG
        clc
        adc #$01
        sta z80_c ; LD C,A
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        sec ; SUB C
        sbc z80_c
		sta z80_a
        bpl *+3 ; RET M
        rts
        bne *+3 ; RET Z
        rts
        lda #$00 ; LD B,00
        sta z80_b
        jsr add_hl_bc ; ADD HL,BC
        jsr add_hl_bc ; ADD HL,BC
        lda #$48 ; LD D,48
        sta z80_d
		lda z80_a
        jmp @@258 ; JR @@258

;LC496   LD A,D
;C497    SUB 48
;C499    JR C,@@256
;C49B    SUB 70
;C49D    RET NC
;C49E    NEG
;C4A0    CP (HL)
;C4A1    JR C,@@257
;C4A3    LD A,(HL)
;@@257   INC HL
;@@258   EX AF,AF'
;C4A6    EX DE,HL
;C4A7    CALL LD22C
;C4AA    EX DE,HL
;C4AB    LD (LA21D),SP
;C4AF    LD SP,HL
;C4B0    LD A,(LA250)
;C4B3    AND 06
;C4B5    JR Z,@@265
;C4B7    OR F0
;C4B9    LD H,A
;C4BA    LD A,(LA254)
;C4BD    AND A
;C4BE    JR NZ,@@263
;C4C0    SET 3,H
;C4C2    EX AF,AF'
;@@259   EX AF,AF'
;C4C4    POP BC
;C4C5    LD L,C
;C4C6    LD A,(DE)
;C4C7    OR (HL)
;C4C8    LD (DE),A
;C4C9    INC DE
;C4CA    INC H
;C4CB    LD A,(DE)
;C4CC    OR (HL)
;C4CD    DEC H
;C4CE    LD L,B
;C4CF    OR (HL)
;C4D0    LD (DE),A
;C4D1    INC DE
;C4D2    INC H
;C4D3    LD A,(DE)
;C4D4    OR (HL)
;C4D5    LD (DE),A
;C4D6    DEC H
;C4D7    EX DE,HL
;C4D8    LD BC,L0016
;C4DB    ADD HL,BC
;C4DC    EX DE,HL
;C4DD    EX AF,AF'
;C4DE    DEC A
;C4DF    JR NZ,@@259
;@@262   LD SP,(LA21D)
;C4E5    RET

PrintSmallBackgroundObjects
;LC496   
		lda z80_d ; LD A,D
        sec ; SUB 48
        sbc #$48
        jcc @@256 ; JR C,@@256
        sec ; SUB 70
        sbc #$70; 
        bcc *+3 ; RET NC
        rts
        eor #$ff ; NEG
        ;clc	; C=0 here (after bcc)

        adc #$01; 
        ldy #$00 ; CP (HL)
        cmp (z80_hl),y
        jcc @@257 ; JR C,@@257
        ;ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
@@257   inc z80_l ; INC HL
        bne *+4
        inc z80_h

@@258   ;ldx z80_ap ; EX AF,AF'
        sta z80_ap
        ;txa ; 
        ;jsr ex_de_hl ; EX DE,HL
        ;jsr GetPointerInBackgroundBuffer ; CALL LD22C
        jsr GetPointerInBackgroundBufferDE ; CALL LD22C
        ;jsr ex_de_hl ; EX DE,HL
        ; LD (LA21D),SP ; LD (LA21D),SP
        ; LD SP,HL ; LD SP,HL

		lda z80_l
		sta z80_sp
		lda z80_h
		sta z80_sp+1
        lda LA250 ; LD A,(LA250)
        and #$06 ; AND 06
        jeq @@265 ; JR Z,@@265
        ;ora #$F0 ; OR F0; Lookup table
        ora #>RotationTable
        sta z80_h ; LD H,A
        lda LA254 ; LD A,(LA254)
        ; AND  A
        jne @@263 ; JR NZ,@@263
		;sta z80_a
        lda z80_h ; SET 3,H
        ora #_bitvalue3
        sta z80_h
		sta @@259_or_hl_1+2
		sta @@259_or_hl_2+2
		ora #$01
		sta @@259_or_hl1_1+2
		sta @@259_or_hl1_2+2
		;lda z80_a
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ;
		

		lda z80_sp
		sta @@259_ld_sp_1+1
		sta @@259_ld_sp_2+1
		lda z80_sp+1
		sta @@259_ld_sp_1+2
		sta @@259_ld_sp_2+2
		lda z80_ap
		asl @
		sta @@259_cmp+1
		ldy #$00
		clc
@@259   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
		
        ;pla ; POP BC
        ;sta z80_b
        ;pla
        ;sta z80_c
		;lda (z80_sp),y
		;sta z80_c
		;tax
		;iny
		;lda (z80_sp),y
		;sta z80_b
		;iny
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1	
        ;lda z80_c ; LD L,C
        ;sta z80_l
		;dey
        ;ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
@@259_ld_sp_1
		ldx $ffff,y
@@259_or_hl_1
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
        ;inc z80_h ; INC H
        ;ldy #$00 ; LD A,(DE)
		iny
        lda (z80_de),y
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
@@259_or_hl1_1
		ora $ff00,x
        ;dec z80_h ; DEC H
        ;ldx z80_b ; LD L,B
        ;stx z80_l
@@259_ld_sp_2
		ldx $ffff,y
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y; 
@@259_or_hl_2
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
        ;inc z80_h ; INC H
        ;ldy #$00 ; LD A,(DE)
		iny
        lda (z80_de),y
@@259_or_hl1_2
		ora $ff00,x
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;dec z80_h ; DEC H
        ;jsr ex_de_hl ; EX DE,HL
        ;lda #<L0016 ; LD BC,L0016
        ;sta z80_c
        ;lda #>L0016
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
        ;jsr ex_de_hl ; EX DE,HL
		lda z80_e
		;clc
		adc #$16
		sta z80_e
		scc:inc z80_d
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;sec ; DEC A
        ;sbc #$01
		;dec z80_ap
@@259_cmp
		cpy #$00	; C=0 after this instruction
        jne @@259 ; JR NZ,@@259
@@262   ; LD SP,(LA21D): TODO  ; LD SP,(LA21D)
        rts ; RET



;@@263   EX AF,AF'
;@@264   EX AF,AF'
;C4E8    POP BC
;C4E9    LD L,B
;C4EA    LD A,(DE)
;C4EB    OR (HL)
;C4EC    LD (DE),A
;C4ED    INC DE
;C4EE    INC H
;C4EF    LD A,(DE)
;C4F0    OR (HL)
;C4F1    DEC H
;C4F2    LD L,C
;C4F3    OR (HL)
;C4F4    LD (DE),A
;C4F5    INC DE
;C4F6    INC H
;C4F7    LD A,(DE)
;C4F8    OR (HL)
;C4F9    LD (DE),A
;C4FA    DEC H
;C4FB    EX DE,HL
;C4FC    LD BC,L0016
;C4FF    ADD HL,BC
;C500    EX DE,HL
;C501    EX AF,AF'
;C502    DEC A
;C503    JR NZ,@@264
;C505    JR @@262

@@263   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ;
		lda z80_h
		sta @@264_or_hl_1+2
		sta @@264_or_hl_2+2
		ora #$01
		sta @@264_or_hl1_1+2
		sta @@264_or_hl1_2+2
		lda z80_sp
		clc
		adc #$01
		sta @@264_ld_spp1+1
		lda z80_sp+1
		adc #$00
		sta @@264_ld_spp1+2
		lda z80_sp
		sec
		sbc #$01
		sta @@264_ld_spm1+1
		lda z80_sp+1
		sbc #$00
		sta @@264_ld_spm1+2
		lda z80_ap
		asl @
		sta @@264_cmp+1
		ldy #$00
@@264   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;pla ; POP BC
        ;sta z80_b
        ;pla
        ;sta z80_c
 		;ldy #0
		;lda (z80_sp),y
		;sta z80_c
		;iny
		;lda (z80_sp),y
		;sta z80_b
		;tax
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;lda z80_b ; LD L,B
        ;sta z80_l
        ;ldy #$00 ; LD A,(DE)
		;dey
        lda (z80_de),y
@@264_ld_spp1
		ldx $ffff,y
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
@@264_or_hl_1
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
        ;inc z80_h ; INC H
        ;ldy #$00 ; LD A,(DE)
		iny
        lda (z80_de),y
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
@@264_or_hl1_1
		ora $ff00,x
        ;dec z80_h ; DEC H
        ;ldx z80_c ; LD L,C
@@264_ld_spm1
		ldx $ffff,y
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y; 
@@264_or_hl_2		
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
        ;inc z80_h ; INC H
        ;ldy #$00 ; LD A,(DE)
		iny
        lda (z80_de),y
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
@@264_or_hl1_2		
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;dec z80_h ; DEC H
        ;jsr ex_de_hl ; EX DE,HL
        ;lda #<L0016 ; LD BC,L0016
        ;sta z80_c
        ;lda #>L0016
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
        ;jsr ex_de_hl ; EX DE,HL
		lda z80_e
		;clc
		adc #$16
		sta z80_e
		scc:inc z80_d
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;sec ; DEC A
        ;sbc #$01
@@264_cmp
		cpy #$00
        jne @@264 ; JR NZ,@@264
        jmp @@262 ; JR @@262


;@@265   EX DE,HL
;C508    LD A,(LA254)
;C50B    AND A
;C50C    JR NZ,@@267
;C50E    LD BC,L0017
;C511    EX AF,AF'
;@@266   EX AF,AF'
;C513    POP DE
;C514    LD A,(HL)
;C515    OR E
;C516    LD (HL),A
;C517    INC HL
;C518    LD A,(HL)
;C519    OR D
;C51A    LD (HL),A
;C51B    ADD HL,BC
;C51C    EX AF,AF'
;C51D    DEC A
;C51E    JR NZ,@@266
;C520    JR @@262

@@265   jsr ex_de_hl ; EX DE,HL
        lda LA254 ; LD A,(LA254)
        ; AND  A
        jne @@267 ; JR NZ,@@267
        ;lda #<L0017 ; LD BC,L0017
        ;sta z80_c
        ;lda #>L0017
        ;sta z80_b
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ;
		lda z80_ap
		asl @
		sta @@266_cmp+1
		ldy #$00
		clc

@@266   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 

        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
        ;ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        ;ora z80_e ; OR E
		ora (z80_sp),y
        ;ldy #$00 ; LD (HL),A
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ;ldy #$00 ; LD A,(HL)
		iny
        lda (z80_hl),y
        ;ora z80_d ; OR D
		ora (z80_sp),y
        ;ldy #$00 ; LD (HL),A
        sta (z80_hl),y
		iny
		lda z80_l
		adc #$16
		sta z80_l
		scc:inc z80_h
        ;jsr add_hl_bc ; ADD HL,BC
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 

        ;sec ; DEC A
        ;sbc #$01
@@266_cmp
		cpy #$00	; C=0
        jne @@266 ; JR NZ,@@266
        jmp @@262 ; JR @@262

;@@267   LD B,F9
;C524    EX AF,AF'
;@@268   EX AF,AF'
;C526    POP DE
;C527    LD C,D
;C528    LD A,(BC)
;C529    OR (HL)
;C52A    LD (HL),A
;C52B    INC HL
;C52C    LD C,E
;C52D    LD A,(BC)
;C52E    OR (HL)
;C52F    LD (HL),A
;C530    LD DE,L0017
;C533    ADD HL,DE
;C534    EX AF,AF'
;C535    DEC A
;C536    JR NZ,@@268
;C538    JR @@262

@@267   ;lda #$F9 ; LD B,F9
		;ldx #>MirrorTable
        ;stx z80_b
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ;
		lda z80_ap
		asl @
		sta @@268_cmp+1
		ldy #$00

@@268   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 

        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #0
		lda (z80_sp),y
		sta z80_e
		iny
		lda (z80_sp),y
		;sta z80_d
		tax
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1		
        ;lda z80_d ; LD C,D
        ;sta z80_c
        ;ldy #$00 ; LD A,(BC)
        ;lda (z80_bc),y
		lda MirrorTable,x
        ;ldy #$00 ; OR (HL)
		dey
        ora (z80_hl),y
        ;ldy #$00 ; LD (HL),A
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ;lda z80_e ; LD C,E
        ;sta z80_c
		ldx z80_e
        ;ldy #$00 ; LD A,(BC)
        ;lda (z80_bc),y
		lda MirrorTable,x
        ;ldy #$00 ; OR (HL)
		iny
        ora (z80_hl),y
        ;ldy #$00 ; LD (HL),A
        sta (z80_hl),y
        ;lda #<L0017 ; LD DE,L0017
        ;sta z80_e
        ;lda #>L0017
        ;sta z80_d
        ;jsr add_hl_de ; ADD HL,DE
		iny
		lda #$16
		;clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 

        ;sec ; DEC A
        ;sbc #$01
@@268_cmp
		cpy #$00 ; C=0 after this instruction
        jne @@268 ; JR NZ,@@268
        jmp @@262 ; JR @@262

;LC53A   CALL LC727
;C53D    RET Z
;C53E    LD (LA255),A
;C541    ADD A,A
;C542    LD HL,LA24F
;C545    OR (HL)
;C546    LD BC,L626C
;C549    CALL LC74B
;C54C    PUSH HL
;C54D    POP IY
;C54F    CALL LC6CB
;C552    XOR A
;C553    LD (LA254),A
;C556    LD B,08
;@@269   CALL LC58A
;C55B    LD HL,(LA249)
;C55E    LD A,L
;C55F    AND H
;C560    CPL
;C561    AND A
;C562    RET Z
;C563    CALL LC434
;C566    DJNZ @@269
;C568    LD HL,(LA252)
;C56B    LD DE,L0008
;C56E    ADD HL,DE
;C56F    LD (LA252),HL
;C572    LD A,01
;C574    LD (LA254),A
;C577    LD B,08
;@@270   CALL LC58A
;C57C    LD HL,(LA249)
;C57F    LD A,L
;C580    AND H
;C581    CPL
;C582    AND A
;C583    RET Z
;C584    CALL LC411
;C587    DJNZ @@270
;C589    RET


LC53A   jsr LC727 ; CALL LC727
        bne *+3 ; RET Z
        rts
        sta LA255 ; LD (LA255),A
        asl @ ; ADD A,A
        ;ldx #<LA24F ; LD HL,LA24F
        ;stx z80_l
        ;ldx #>LA24F
        ;stx z80_h
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y; A read but not set by previous instruction
		ora LA24F
        ;ldx #<L626C ; LD BC,L626C
        ;stx z80_c
        ;ldx #>L626C
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B
		asl @
		tax
		lda L626C,x
		sta z80_iy
		lda L626C+1,x
		sta z80_iy+1
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		;lda z80_l
		;sta z80_iy
		;lda z80_h
		;sta z80_iy+1
        jsr LC6CB ; CALL LC6CB
        lda #$00 ; XOR A
        sta LA254 ; LD (LA254),A
        lda #$08 ; LD B,08
        sta z80_b

@@269   jsr LC58A ; CALL LC58A
        ;lda LA249 ; LD HL,(LA249)
        ;sta z80_l
        ;lda LA249+1
        ;sta z80_h
        ;lda z80_l ; LD A,L
        ;and z80_h ; AND H
		lda LA249
		and LA249+1
        eor #$ff ; CPL
        ; AND  A
        bne *+3 ; RET Z
        rts
        jsr LC434 ; CALL LC434
        dec z80_b ; DJNZ @@269
        jne @@269
        ;lda LA252 ; LD HL,(LA252)
        ;sta z80_l
        ;lda LA252+1
        ;sta z80_h
        ;lda #<L0008 ; LD DE,L0008
        ;sta z80_e
        ;lda #>L0008
        ;sta z80_d
        ;jsr add_hl_de ; ADD HL,DE
        ;lda z80_l ; LD (LA252),HL
        ;sta LA252
        ;lda z80_h
        ;sta LA252+1
		lda LA252
		clc
		adc #$08
		sta LA252
		scc:inc LA252+1
        lda #$01 ; LD A,01
        sta LA254 ; LD (LA254),A
        lda #$08 ; LD B,08
        sta z80_b
@@270   jsr LC58A ; CALL LC58A
        ;lda LA249 ; LD HL,(LA249)
        ;sta z80_l
        ;lda LA249+1
        ;sta z80_h
        ;lda z80_l ; LD A,L
        ;and z80_h ; AND H
		lda LA249
		and LA249+1
        eor #$ff ; CPL
        ; AND  A
        bne *+3 ; RET Z
        rts
        jsr LC411 ; CALL LC411
        dec z80_b ; DJNZ @@270
        jne @@270
        rts ; RET


;LC58A   LD HL,(LA250)
;C58D    LD A,H
;C58E    AND A
;C58F    JR NZ,@@274
;C591    LD A,L
;C592    LD E,A
;C593    RRCA
;C594    AND 38
;C596    OR 46
;C598    LD (LC5AB),A ; Self modifying code (access to memory where code is located)
;C59B    OR 80
;C59D    LD (LC5AF),A ; Self modifying code (access to memory where code is located)
;C5A0    LD A,L
;C5A1    RLCA
;C5A2    AND 01
;C5A4    LD HL,LA249
;C5A7    JR Z,@@271
;C5A9    INC HL
;@@271   BIT 0,(HL)
;C5AC    JR NZ,@@274
;C5AE    SET 0,(HL)
;C5B0    LD HL,(LA252)
;C5B3    LD A,H
;C5B4    AND A
;C5B5    JR NZ,@@274
;C5B7    LD D,L
;C5B8    PUSH BC
;C5B9    PUSH DE
;C5BA    CALL LC5E8
;C5BD    POP DE
;C5BE    INC IY
;C5C0    LD HL,(LA252)
;C5C3    LD BC,L0040
;C5C6    ADD HL,BC
;C5C7    LD A,H
;C5C8    AND A
;C5C9    JR NZ,@@272
;C5CB    LD D,L
;C5CC    CALL LC5E8
;@@272   POP BC
;C5D0    INC IY
;C5D2    RET

LC58A   lda LA250 ; LD HL,(LA250)
        sta z80_l
        lda LA250+1
        sta z80_h
        ;lda z80_h ; LD A,H
        ; AND  A
        jne @@274 ; JR NZ,@@274
        lda z80_l ; LD A,L
        sta z80_e ; LD E,A
        lsr @ ; RRCA: 
		lsr @ ; extra shifts to move bits to bit 0
		lsr @
		lsr @
		ora #_bitmem0
        ;and #$38 ; AND 38
        ;ora #$46 ; OR 46
        sta LC5AA+1 ; LD (LC5AB),A
        ;ora #$80 ; OR 80
        sta LC5AE+1 ; LD (LC5AF),A
		ldx #$0
        lda z80_l ; LD A,L
        asl @ ; RLCA: this copies bit 7 to bit 0 
        rol @
        and #$01 ; AND 01
        ;php

        ;lda #<LA249 ; LD HL,LA249
        ;sta z80_l
        ;lda #>LA249
        ;sta z80_h
        ;plp

        ;jeq @@271 ; JR Z,@@271; ZERO flag read but not set by previous instruction
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		seq:inx
@@271   ;ldy #$00 ; BIT 0,(HL)
        ;lda (z80_hl),y
		lda LA249,x
LC5AA   bit _bitmem0
LC5AB	equ *-1
        jne @@274 ; JR NZ,@@274
        ;ldy #$00 ; SET 0,(HL)
        ;lda (z80_hl),y
        ;ora #_bitvalue0
LC5AE	ora _bitmem0
LC5AF	equ *-1
        ;sta (z80_hl),y
		sta LA249,x
        lda LA252 ; LD HL,(LA252)
        sta z80_l
        lda LA252+1
        sta z80_h
        ;lda z80_h ; LD A,H
        ; AND  A
        jne @@274 ; JR NZ,@@274
        lda z80_l ; LD D,L
        sta z80_d
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        jsr PrintBackgroundBuilding ; CALL LC5E8

        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        inc z80_iy ; INC IY
        bne *+4
        inc z80_iy+1
        lda LA252 ; LD HL,(LA252)
        ;sta z80_l
		clc
		adc #$40
		sta z80_l
        lda LA252+1
		adc #$00
        sta z80_h
        ;lda #<L0040 ; LD BC,L0040
        ;sta z80_c
        ;lda #>L0040
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
        ;lda z80_h ; LD A,H
        ; AND  A
        jne @@272 ; JR NZ,@@272
        lda z80_l ; LD D,L
        sta z80_d
        jsr PrintBackgroundBuilding ; CALL LC5E8

@@272   pla ; POP BC
        sta z80_b
        pla
        sta z80_c
        inc z80_iy ; INC IY
        bne *+4
        inc z80_iy+1
        rts ; RET

;@@274   INC IY
;C5D5    INC IY
;C5D7    RET

@@274   inc z80_iy ; INC IY
        bne *+4
        inc z80_iy+1
        inc z80_iy ; INC IY
        bne *+4
        inc z80_iy+1
        rts ; RET

;@@276   NEG
;C5DA    LD C,A
;C5DB    LD A,(HL)
;C5DC    INC HL
;C5DD    SUB C
;C5DE    RET M
;C5DF    RET Z
;C5E0    LD B,00
;C5E2    ADD HL,BC
;C5E3    ADD HL,BC
;C5E4    LD D,48
;C5E6    JR @@278

@@276   eor #$ff ; NEG
        clc
        adc #$01
        sta z80_c ; LD C,A
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        sec ; SUB C
        sbc z80_c
        bpl *+3 ; RET M
        rts
        bne *+3 ; RET Z
        rts
        tax
        lda #$00 ; LD B,00
        sta z80_b
        jsr add_hl_bc ; ADD HL,BC
        jsr add_hl_bc ; ADD HL,BC
        lda #$48 ; LD D,48
        sta z80_d
        txa
        jmp @@278 ; JR @@278

;LC5E8   LD A,(IY+00)
;C5EB    LD BC,L8FF8
;C5EE    CALL LC74B
;C5F1    LD A,D
;C5F2    SUB 48
;C5F4    JR C,@@276
;C5F6    SUB 70
;C5F8    RET NC
;C5F9    NEG
;C5FB    CP (HL)
;C5FC    JR C,@@277
;C5FE    LD A,(HL)
;@@277   INC HL
;@@278   EX AF,AF'
;C601    EX DE,HL
;C602    CALL LD22C
;C605    EX DE,HL
;C606    PUSH HL
;C607    LD A,(LA250)
;C60A    RRCA
;C60B    AND 03
;C60D    LD HL,LC6B2
;C610    CALL LD26E
;C613    LD A,(HL)
;C614    LD (LC63F),A ; Self modifying code (access to memory where code is located)
;C617    LD (LC666),A ; Self modifying code (access to memory where code is located)
;C61A    CPL
;C61B    LD (LC64D),A ; Self modifying code (access to memory where code is located)
;C61E    LD (LC675),A ; Self modifying code (access to memory where code is located)
;C621    POP HL
;C622    LD (LA21D),SP
;C626    LD SP,HL
;C627    LD A,(LA250)
;C62A    AND 06
;C62C    JR Z,@@285
;C62E    OR F0
;C630    LD H,A
;C631    LD A,(LA254)
;C634    AND A
;C635    JR NZ,@@283
;C637    SET 3,H
;C639    EX AF,AF'
;@@279   EX AF,AF'
;C63B    POP BC
;C63C    LD L,C
;C63D    LD A,(DE)
;C63E    AND 00
;C640    OR (HL)
;C641    LD (DE),A
;C642    INC DE
;C643    INC H
;C644    LD A,(HL)
;C645    DEC H
;C646    LD L,B
;C647    OR (HL)
;C648    LD (DE),A
;C649    INC DE
;C64A    INC H
;C64B    LD A,(DE)
;C64C    AND 00
;C64E    OR (HL)
;C64F    LD (DE),A
;C650    DEC H
;C651    EX DE,HL
;C652    LD BC,L0016
;C655    ADD HL,BC
;C656    EX DE,HL
;C657    EX AF,AF'
;C658    DEC A
;C659    JR NZ,@@279
;@@281   LD SP,(LA21D)
;C65F    RET

PrintBackgroundBuilding
;LC5E8   ldy #$00 ; LD A,(IY+00)
		ldy #$00
        lda (z80_iy),y
        ;ldx #<L8FF8 ; LD BC,L8FF8
        ;stx z80_c
        ;ldx #>L8FF8
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		asl @
		tay
		lda L8FF8,y
		sta z80_l
		lda L8FF8+1,y
		sta z80_h
        lda z80_d ; LD A,D
        sec ; SUB 48
        sbc #$48
        jcc @@276 ; JR C,@@276
        sec ; SUB 70
        sbc #$70; 
        bcc *+3 ; RET NC
        rts
        eor #$ff ; NEG
        clc
        adc #$01; 
        ldy #$00 ; CP (HL)
        cmp (z80_hl),y
        jcc @@277 ; JR C,@@277
        ;ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
@@277   inc z80_l ; INC HL
        bne *+4
        inc z80_h

@@278   ;ldx z80_ap ; EX AF,AF'
        sta z80_ap
        ;txa ; 
        ;jsr ex_de_hl ; EX DE,HL
        ;jsr GetPointerInBackgroundBuffer ; CALL LD22C
        jsr GetPointerInBackgroundBufferDE ; CALL LD22C
        ;jsr ex_de_hl ; EX DE,HL
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha



        lda LA250 ; LD A,(LA250)
        lsr @ ; RRCA
        and #$03 ; AND 03
        ;ldx #<LC6B2 ; LD HL,LC6B2
        ;stx z80_l
        ;ldx #>LC6B2
        ;stx z80_h
        ;jsr LD26E ; CALL LD26E ; uses A as parameter
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		tay
		lda LC6B2,y
        sta LC63F ; LD (LC63E+1),A
        sta LC666 ; LD (LC665+1),A
        eor #$ff ; CPL
        sta LC64D ; LD (LC64C+1),A
        sta LC675 ; LD (LC674+1),A
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ; TODO: LD (LA21D),SP ; LD (LA21D),SP
        ; LD SP,HL ; LD SP,HL
		lda z80_l
		sta z80_sp
		lda z80_h
		sta z80_sp+1
        lda LA250 ; LD A,(LA250)
        and #$06 ; AND 06
        jeq @@285 ; JR Z,@@285
        ;ora #$F0 ; OR F0; Lookup table
        ora #>RotationTable
        sta z80_h ; LD H,A
        lda LA254 ; LD A,(LA254)
        ; AND  A: 
        jne @@283 ; JR NZ,@@283
		;sta z80_a
        lda z80_h ; SET 3,H
        ora #_bitvalue3
        ;sta z80_h
		sta @@279_or_hl_1+2
		sta @@279_or_hl_2+2
		ora #$01
		sta @@279_ld_hl1_1+2
		sta @@279_or_hl1_2+2
		lda z80_sp
		sta @@279_ld_sp1+1
		sta @@279_ld_sp2+1
		lda z80_sp+1
		sta @@279_ld_sp1+2
		sta @@279_ld_sp2+2
		;lda #$00
		;sta z80_reg0
		;lda z80_a
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
		lda z80_ap
		asl @
		sta @@279_cmp+1
		ldy #$00
		clc
@@279   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;pla ; POP BC
        ;sta z80_b
        ;pla
        ;sta z80_c
		;ldy #$00
		;ldy z80_reg0
;@@279_cmp
		;cpy #$00		; always C=0 after this instruction
		;beq @@279_end
@@279_ld_sp1
		ldx $ffff,y
		;lda (z80_sp),y
		;sta z80_c
		;tax
		;iny
		;lda (z80_sp),y
		;sta z80_b
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;iny
		;sty z80_reg0
        ;lda z80_c ; LD L,C
        ;sta z80_l
        ;ldy #$00 ; LD A,(DE)
        lda (z80_de),y
LC63E   and #$00 ; AND 00
LC63F	equ *-1
        ;ldy #$00 ; OR (HL)
@@279_or_hl_1		
        ;ora (z80_hl),y
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		iny
        ;inc z80_h ; INC H
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
        ;dec z80_h ; DEC H
@@279_ld_hl1_1
		lda $ff00,x
		;sta z80_a
		;lda (z80_sp),y
		;tax
		;lda z80_a
@@279_ld_sp2
		ldx $ffff,y
        ;ldx z80_b ; LD L,B
        ;stx z80_l
        ;ldy #$00 ; OR (HL)
@@279_or_hl_2		
        ;ora (z80_hl),y; 
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		iny
        ;inc z80_h ; INC H
        ;ldy #$00 ; LD A,(DE)
        lda (z80_de),y
LC64C   and #$00 ; AND 00
LC64D	equ *-1
        ;ldy #$00 ; OR (HL)
@@279_or_hl1_2		
        ;ora (z80_hl),y
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;dec z80_h ; DEC H
        ;jsr ex_de_hl ; EX DE,HL
        ;lda #<L0016 ; LD BC,L0016
        ;sta z80_c
        ;lda #>L0016
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
        ;jsr ex_de_hl ; EX DE,HL
		lda z80_e
		;clc
		adc #$16+2-2
		sta z80_e
		scc:inc z80_d
		;bcc @@279
		;inc z80_d
@@279_cmp
		cpy #$00
		bne @@279
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;sec ; DEC A
        ;sbc #$01
		;dec z80_ap
        ;jne @@279 ; JR NZ,@@279
@@281   ; LD SP,(LA21D): TODO  ; LD SP,(LA21D)
@@279_end
        rts ; RET


;@@283   EX AF,AF'
;@@284   EX AF,AF'
;C662    POP BC
;C663    LD L,B
;C664    LD A,(DE)
;C665    AND 00
;C667    OR (HL)
;C668    LD (DE),A
;C669    INC DE
;C66A    INC H
;C66B    LD B,(HL)
;C66C    DEC H
;C66D    LD L,C
;C66E    LD A,(HL)
;C66F    OR B
;C670    LD (DE),A
;C671    INC DE
;C672    INC H
;C673    LD A,(DE)
;C674    AND 00
;C676    OR (HL)
;C677    LD (DE),A
;C678    DEC H
;C679    EX DE,HL
;C67A    LD BC,L0016
;C67D    ADD HL,BC
;C67E    EX DE,HL
;C67F    EX AF,AF'
;C680    DEC A
;C681    JR NZ,@@284
;C683    JR @@281

@@283   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
		lda z80_h
		sta @@284_or_hl_1+2
		sta @@284_or_hl_2+2
		ora #$01
		sta @@284_ld_hl1_1+2
		sta @@284_or_hl1_2+2
		;lda #$00
		;sta z80_reg0
		lda z80_sp
		sta @@284_ld_sp_2+1
		clc
		adc #$01
		sta @@284_ld_sp_1+1
		lda z80_sp+1
		sta @@284_ld_sp_2+2		
		adc #$00
		sta @@284_ld_sp_1+2
		lda z80_ap
		asl @
		sta @@284_cmp+1
		ldy #$00
		clc
@@284   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;pla ; POP BC
        ;sta z80_b
        ;pla
        ;sta z80_c
		;ldy z80_reg0
		;lda (z80_sp),y
		;sta z80_c
		;iny
		;lda (z80_sp),y
		;sta z80_b
		;tax
		;iny
		;sty z80_reg0
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1		
        ;lda z80_b ; LD L,B
        ;sta z80_l
        ;ldy #$00 ; LD A,(DE)
		;dey
        lda (z80_de),y
LC665   and #$00 ; AND 00
LC666	equ *-1
@@284_ld_sp_1
		ldx $ffff,y
        ;ldy #$00 ; OR (HL)
@@284_or_hl_1		
        ;ora (z80_hl),y
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		;iny
@@284_ld_hl1_1
		lda $ff00,x
        ;inc z80_h ; INC H
        ;ldy #$00 ; LD B,(HL)
        ;lda (z80_hl),y
        ;sta z80_b
        ;dec z80_h ; DEC H
        ;lda z80_c ; LD L,C
        ;sta z80_l
		;ldx z80_c
@@284_ld_sp_2
		ldx $ffff,y
		iny
@@284_or_hl_2		
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		ora $ff00,x
        ;ora z80_b ; OR B
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		iny
        ;inc z80_h ; INC H
        ;ldy #$00 ; LD A,(DE)
        lda (z80_de),y
LC674   and #$00 ; AND 00
LC675	equ *-1
@@284_or_hl1_2
        ;ldy #$00 ; OR (HL)
        ;ora (z80_hl),y
		ora $ff00,x
        ;ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;dec z80_h ; DEC H
        ;jsr ex_de_hl ; EX DE,HL
        ;lda #<L0016 ; LD BC,L0016
        ;sta z80_c
        ;lda #>L0016
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
        ;jsr ex_de_hl ; EX DE,HL
		lda z80_e
		;clc
		adc #$16 ;+2
		sta z80_e
		scc:inc z80_d
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;sec ; DEC A
        ;sbc #$01
		;dec z80_ap
@@284_cmp
		cpy #$00	; C=0 after this instruction
        jne @@284 ; JR NZ,@@284
        jmp @@281 ; JR @@281

;@@285   EX DE,HL
;C686    LD A,(LA254)
;C689    AND A
;C68A    JR NZ,@@287
;C68C    LD BC,L0017
;C68F    EX AF,AF'
;@@286   EX AF,AF'
;C691    POP DE
;C692    LD (HL),E
;C693    INC HL
;C694    LD (HL),D
;C695    ADD HL,BC
;C696    EX AF,AF'
;C697    DEC A
;C698    JR NZ,@@286
;C69A    JR @@281

@@285   jsr ex_de_hl ; EX DE,HL
        lda LA254 ; LD A,(LA254)
        ; AND  A
        jne @@287 ; JR NZ,@@287
        ;lda #<L0017 ; LD BC,L0017
        ;sta z80_c
        ;lda #>L0017
        ;sta z80_b
		ldx z80_ap
		ldy #$00
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ;
	clc 
@@286   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #$00
		lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1			
        ;lda z80_e ; LD (HL),E
        ;ldy #$00
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		iny
        ;lda z80_d ; LD (HL),D
		lda (z80_sp),y
        ;ldy #$00
        sta (z80_hl),y
		iny
        ;jsr add_hl_bc ; ADD HL,BC
		lda #24-2
		;clc
		adc z80_l
		sta z80_l
		;scc:inc z80_h
		bcc @@286_no_inc_h
		clc
		inc z80_h
@@286_no_inc_h		
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;sec ; DEC A
        ;sbc #$01
		dex
        jne @@286 ; JR NZ,@@286
        jmp @@281 ; JR @@281


;@@287   LD B,F9
;C69E    EX AF,AF'
;@@288   EX AF,AF'
;C6A0    POP DE
;C6A1    LD C,D
;C6A2    LD A,(BC)
;C6A3    LD (HL),A
;C6A4    INC HL
;C6A5    LD C,E
;C6A6    LD A,(BC)
;C6A7    LD (HL),A
;C6A8    LD DE,L0017
;C6AB    ADD HL,DE
;C6AC    EX AF,AF'
;C6AD    DEC A
;C6AE    JR NZ,@@288
;C6B0    JR @@281

@@287   ;lda #$F9 ; LD B,F9 ; Lookuptable
        ;ldx #>MirrorTable
        ;stx z80_b
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
		lda z80_sp
		sta @@288_ld_sp_2+1
		clc
		adc #$01
		sta @@288_ld_sp+1
		lda z80_sp+1
		sta @@288_ld_sp_2+2
		adc #$00
		sta @@288_ld_sp+2
		lda z80_ap
		asl @
		sta @@288_cmp+1
		clc
		ldy #$00
@@288   ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; TODO: EX   AF,AF'
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		;ldy #$00
		;iny
		;lda (z80_sp),y
		;dey
@@288_ld_sp
		ldx $ffff,y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1		
        ;lda z80_d ; LD C,D
        ;sta z80_c
		;tax
		lda MirrorTable,x
        ;ldy #$00 ; LD A,(BC)
        ;lda (z80_bc),y
        ;ldy #$00 ; LD (HL),A
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		;iny
        ;lda z80_e ; LD C,E
        ;sta z80_c
		;lda (z80_sp),y
        ;ldy #$00 ; LD A,(BC)
        ;lda (z80_bc),y
		;tax
@@288_ld_sp_2
		ldx $ffff,y
		lda MirrorTable,x
        ;ldy #$00 ; LD (HL),A
		iny
        sta (z80_hl),y
        ;lda #<L0017 ; LD DE,L0017
        ;sta z80_e
        ;lda #>L0017
        ;sta z80_d
        ;jsr add_hl_de ; ADD HL,DE
		iny
		lda #24-2
		;clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
        ;ldx z80_ap ; EX AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;sec ; DEC A
        ;sbc #$01
		;dec z80_ap
@@288_cmp
		cpy #$00	; C=0 after this instruction
        jne @@288 ; JR NZ,@@288
        jmp @@281 ; JR @@281


;LC6B2   DB 00,C0,F0,FC

LC6B2   .he 00,C0,F0,FC ; DB 00,C0,F0,FC

;LC6B6   LD L,(IX+03)
;C6B9    LD H,(IX+04)
;C6BC    CALL LC372
;C6BF    PUSH HL
;C6C0    LD L,(IX+01)
;C6C3    LD H,(IX+02)
;C6C6    CALL LC372
;C6C9    JR @@289

LC6B6   ldy #$03 ; LD L,(IX+03)
        lda (z80_ix),y
        sta z80_l
        ;ldy #$04 ; LD H,(IX+04)
		iny
        lda (z80_ix),y
        sta z80_h
        jsr LC372 ; CALL LC372
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        ldy #$01 ; LD L,(IX+01)
        lda (z80_ix),y
        sta z80_l
        ;ldy #$02 ; LD H,(IX+02)
		iny
        lda (z80_ix),y
        sta z80_h
        jsr LC372 ; CALL LC372
        jmp @@289 ; JR @@289


;LC6CB   LD A,(LA257)
;C6CE    LD L,00
;C6D0    LD H,A
;C6D1    PUSH HL
;C6D2    LD A,(LA256)
;C6D5    LD L,00
;C6D7    LD H,A
;@@289   LD DE,(LA27C)
;C6DC    LD A,(LA24F)
;C6DF    AND 01
;C6E1    JR Z,@@290
;C6E3    LD A,E
;C6E4    CPL
;C6E5    LD E,A
;C6E6    LD A,D
;C6E7    CPL
;C6E8    AND 0F
;C6EA    LD D,A
;@@290   AND A
;C6EC    SBC HL,DE
;C6EE    EX DE,HL
;C6EF    POP HL
;C6F0    LD BC,(LA27E)
;C6F4    LD A,(LA24F)
;C6F7    AND 01
;C6F9    JR Z,@@291
;C6FB    LD A,C
;C6FC    CPL
;C6FD    LD C,A
;C6FE    LD A,B
;C6FF    CPL
;C700    AND 0F
;C702    LD B,A
;@@291   AND A
;C704    SBC HL,BC
;C706    PUSH HL
;C707    LD BC,L00F0
;C70A    ADD HL,DE
;C70B    ADD HL,BC
;C70C    SRA H
;C70E    RR L
;C710    LD (LA250),HL
;C713    POP HL
;C714    AND A
;C715    SBC HL,DE
;C717    LD BC,L01B0
;C71A    ADD HL,BC
;C71B    SRA H
;C71D    RR L
;C71F    SRA H
;C721    RR L
;C723    LD (LA252),HL
;C726    RET

LC6CB   ;lda LA257 ; LD A,(LA257)
        ;ldx #$00 ; LD L,00
        ;stx z80_l
        ;sta z80_h ; LD H,A; A read but not set by previous instruction
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
		lda #$00
		sta z80_l
		pha
		lda LA257

		pha
        lda LA256 ; LD A,(LA256)
        ;ldx #$00 ; LD L,00
        ;stx z80_l
        sta z80_h ; LD H,A; A read but not set by previous instruction
@@289   lda LA27C ; LD DE,(LA27C)
        sta z80_e
        lda LA27C+1
        sta z80_d
        lda LA24F ; LD A,(LA24F)
        and #$01 ; AND 01
        jeq @@290 ; JR Z,@@290
        lda z80_e ; LD A,E
        eor #$ff ; CPL
        sta z80_e ; LD E,A
        lda z80_d ; LD A,D
        eor #$ff ; CPL
        and #$0F ; AND 0F
        sta z80_d ; LD D,A

@@290   ; AND  A
        sec
        ;jsr sbc_hl_de ; SBC HL,DE
        ;jsr ex_de_hl ; EX DE,HL
		;jsr ld_de_hl
		lda z80_l
		sbc z80_e
		sta z80_e
		lda z80_h
		sbc z80_d
		sta z80_d
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        lda LA27E ; LD BC,(LA27E)
        sta z80_c
        lda LA27E+1
        sta z80_b
        lda LA24F ; LD A,(LA24F)
        and #$01 ; AND 01
        jeq @@291 ; JR Z,@@291
        lda z80_c ; LD A,C
        eor #$ff ; CPL
        sta z80_c ; LD C,A
        lda z80_b ; LD A,B
        eor #$ff ; CPL
        and #$0F ; AND 0F
        sta z80_b ; LD B,A
@@291   ; AND  A
        sec
        ;jsr sbc_hl_bc ; SBC HL,BC
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
		lda z80_l
		sbc z80_c
		sta z80_l
		pha
		lda z80_h
		sbc z80_b
		sta z80_h
		pha
        ;lda #<L00F0 ; LD BC,L00F0
        ;sta z80_c
        ;lda #>L00F0
        ;sta z80_b
        ;jsr add_hl_de ; ADD HL,DE
		clc
		lda z80_l
		adc z80_e
		sta z80_l
		lda z80_h
		adc z80_d
		sta z80_h
        ;jsr add_hl_bc ; ADD HL,BC
		lda #$f0
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
        lda z80_h ; SRA H
        cmp #$80
        ror @
        ;sta z80_h
		sta LA250+1
        ;ror z80_l ; RR L
		lda z80_l
		ror @
		sta LA250
        ;lda z80_l ; LD (LA250),HL
        ;sta LA250
        ;lda z80_h
        ;sta LA250+1
        pla ; POP HL
        ;sta z80_h
		tax
        pla
        ;sta z80_l
        ; AND  A
        sec
        ;jsr sbc_hl_de ; SBC HL,DE
		sbc z80_e
		sta z80_l
		txa
		sbc z80_d
		sta z80_h
        ;lda #<L01B0 ; LD BC,L01B0
        ;sta z80_c
        ;lda #>L01B0
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
		lda #$b0
		clc
		adc z80_l
		sta z80_l
		lda z80_h
		adc #$01
		sta z80_h
        lda z80_h ; SRA H
        cmp #$80
        ror @
        ;sta z80_h
        ror z80_l ; RR L
        ;lda z80_h ; SRA H
        cmp #$80
        ror @
        ;sta z80_h
		sta LA252+1
		lda z80_l
		ror @
        ;ror z80_l ; RR L
		sta LA252
        ;lda z80_l ; LD (LA252),HL
        ;sta LA252
        ;lda z80_h
        ;sta LA252+1
        rts ; RET



;LC727   LD (LA256),HL
;C72A    LD A,L
;C72B    LD L,H
;C72C    LD H,00
;C72E    ADD HL,HL
;C72F    ADD HL,HL
;C730    ADD HL,HL
;C731    ADD HL,HL
;C732    OR L
;C733    LD L,A
;C734    LD BC,L5FB1
;C737    LD A,(LA24F)
;C73A    AND 01
;C73C    JR Z,@@292
;C73E    LD A,L
;C73F    CPL
;C740    LD L,A
;C741    LD A,H
;C742    CPL
;C743    LD H,A
;C744    LD BC,L60B1
;@@292   ADD HL,BC
;C748    LD A,(HL)
;C749    AND A
;C74A    RET

LC727   lda z80_l ; LD (LA256),HL
        sta LA256
        lda z80_h
        sta LA256+1
        ;lda z80_l ; LD A,L
        ;ldx z80_h ; LD L,H
        ;stx z80_l
        ldx #$00 ; LD H,00
        stx z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;ora z80_l ; OR L; A read but not set by previous instruction
		ora LA256
        sta z80_l ; LD L,A
        ;lda #<L5FB1 ; LD BC,L5FB1
        ;sta z80_c
        ;lda #>L5FB1
        ;sta z80_b
		ldx #<L5FB1
		ldy #>L5FB1
        lda LA24F ; LD A,(LA24F)
        and #$01 ; AND 01
        jeq @@292 ; JR Z,@@292
        lda z80_l ; LD A,L
        eor #$ff ; CPL
        sta z80_l ; LD L,A
        lda z80_h ; LD A,H
        eor #$ff ; CPL
        sta z80_h ; LD H,A
        ;lda #<L60B1 ; LD BC,L60B1
        ;sta z80_c
        ;lda #>L60B1
        ;sta z80_b
		iny
@@292   ;jsr add_hl_bc ; ADD HL,BC
		txa
		clc
		adc z80_l
		sta z80_l
		tya
		adc z80_h
		sta z80_h
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        ; AND  A
        rts ; RET

;LC74B   LD L,A
;C74C    LD H,00
;C74E    ADD HL,HL
;C74F    ADD HL,BC
;C750    LD A,(HL)
;C751    INC HL
;C752    LD H,(HL)
;C753    LD L,A
;C754    RET

LC74B   ;sta z80_l ; LD L,A; A read at the beginning of the block
        ;lda #$00 ; LD H,00
        ;sta z80_h
        ;asl z80_l ; ADD HL,HL
        ;rol z80_h
        ;jsr add_hl_bc ; ADD HL,BC
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
        ;tax

        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ;ldy #$00 ; LD H,(HL)
		;iny
        ;lda (z80_hl),y
        ;sta z80_h
        ;stx z80_l ; LD L,A; A read but not set by previous instruction
		asl @
		tay
		scc:inc z80_b
		lda (z80_bc),y
		sta z80_l
		iny
		lda (z80_bc),y
		sta z80_h

        rts ; RET

;LC755   CALL LC74B
;C758    JP L5CB0

; game menu text
LC755
		
		jsr LC74B ; CALL LC74B ; A read at the beginning of the block
		
		; jump to start of prog with H/L loaded
        jmp L5CB0 ; JP L5CB0

;C75B    LD A,(IX+0D)
;C75E    AND A
;C75F    JR NZ,@@293
;C761    LD (IX+00),08
;C765    LD (IX+0C),20
;C769    RET

LC75B   ldy #$0D ; LD A,(IX+0D)
        lda (z80_ix),y
        ; AND  A
        jne @@293 ; JR NZ,@@293
        ldy #$00 ; LD (IX+00),08
        lda #$08
        sta (z80_ix),y
        ldy #$0C ; LD (IX+0C),20
        lda #$20
        sta (z80_ix),y
        rts ; RET

;@@293   SUB (IX+0C)
;C76D    JP M,LC77F
;C770    LD (IX+0D),A
;C773    CALL LAF4D
;C776    LD A,(IX+0C)
;C779    ADD A,02
;C77B    LD (IX+0C),A
;C77E    RET

@@293   ldy #$0C ; SUB (IX+0C)
        sec
        sbc (z80_ix),y; A read at the beginning of the block
        jmi LC77F ; JP M,LC77F
        ldy #$0D ; LD (IX+0D),A
        sta (z80_ix),y; 
        jsr LAF4D ; CALL LAF4D
        ldy #$0C ; LD A,(IX+0C)
        lda (z80_ix),y
        clc ; ADD A,02
        adc #$02
        ;ldy #$0C ; LD (IX+0C),A
        sta (z80_ix),y
        rts ; RET

;LC77F   LD (IX+0D),00
;C783    RET

LC77F   ldy #$0D ; LD (IX+0D),00
        lda #$00
        sta (z80_ix),y
        rts ; RET

;C784    DEC (IX+0C)
;C787    JP M,LC7AA
;C78A    LD BC,LC79A
;LC78D   LD A,(IX+0C)
;C790    CALL LC74B
;C793    LD (IX+0E),L
;C796    LD (IX+0F),H
;C799    RET

LC784   ldy #$0C ; DEC (IX+0C)
        lda (z80_ix),y
        sec
        sbc #$01
        sta (z80_ix),y
        jmi LC7AA ; JP M,LC7AA
        lda #<LC79A ; LD BC,LC79A
        sta z80_c
        lda #>LC79A
        sta z80_b
LC78D   ldy #$0C ; LD A,(IX+0C)
        lda (z80_ix),y
        jsr LC74B ; CALL LC74B ; uses A as parameter
        ldy #$0E ; LD (IX+0E),L
        lda z80_l
        sta (z80_ix),y
        ldy #$0F ; LD (IX+0F),H
        lda z80_h
        sta (z80_ix),y
        rts ; RET

;LC79A   DW LC79E,LC7A2

LC79A   .wo LC79E,LC7A2 ; DW LC79E,LC7A2

;LC79E   DB F8,0F,07,80

LC79E   .he F8,0F,07,80 ; DB F8,0F,07,80

;LC7A2   DB F8,0F,09,80

LC7A2   .he F8,0F,09,80 ; DB F8,0F,09,80

;C7A6    DEC (IX+0C)
;C7A9    RET NZ
;LC7AA   LD (IX+00),00
;C7AE    RET

LC7A6   ldy #$0C ; DEC (IX+0C)
        lda (z80_ix),y
        sec
        sbc #$01
        sta (z80_ix),y
        beq *+3 ; RET NZ
        rts
LC7AA   ldy #$00 ; LD (IX+00),00
        tya

        sta (z80_ix),y
        rts ; RET

;C7AF    CALL LBD47
;C7B2    LD (IX+00),00
;C7B6    RET

LC7AF   jsr LBD47 ; CALL LBD47
        ldy #$00 ; LD (IX+00),00
        tya

        sta (z80_ix),y
        rts ; RET


;LC7B7   LD HL,LA27B
;C7BA    LD BC,L00F0
;C7BD    JP LD6DA

LC7B7   lda #<LA27B ; LD HL,LA27B
        sta z80_l
        lda #>LA27B
        sta z80_h
        lda #<L00F0 ; LD BC,L00F0
        sta z80_c
        lda #>L00F0
        sta z80_b
				
        jmp old_clear_part_2 ; JP LD6DA

;LC7C0   LD A,01
;C7C2    LD (LA240),A
;C7C5    CALL LD0B0
;C7C8    CALL LC7B7
;C7CB    LD A,04
;C7CD    LD (LA269),A
;C7D0    XOR A
;C7D1    LD (LA267),A
;C7D4    LD A,47
;C7D6    LD (LA268),A
;C7D9    JP LA3B1

LC7C0   lda #$01 ; LD A,01
        sta LA240 ; LD (LA240),A
        jsr LD0B0 ; CALL LD0B0
        jsr LC7B7 ; CALL LC7B7
        lda #$04 ; LD A,04
        sta game_on ; LD (LA269),A
        lda #$00 ; XOR A
        sta LA267 ; LD (LA267),A
		
        lda #$47 ; LD A,47
        sta LA268 ; LD (LA268),A
        jmp LA3B1 ; JP LA3B1

;C7DC    LD A,(LA266)
;C7DF    AND A
;C7E0    RET Z
;C7E1    LD A,(LA216)
;C7E4    AND 03
;C7E6    RET NZ
;C7E7    LD HL,LA27B
;C7EA    LD DE,L0010
;C7ED    LD B,03
;@@294   LD A,(HL)
;C7F0    AND A
;C7F1    JR Z,@@295
;C7F3    ADD HL,DE
;C7F4    DJNZ @@294
;C7F6    RET

LC7DC   lda LA266 ; LD A,(LA266)
        ; AND  A
        bne *+3 ; RET Z
        rts
        lda LA216 ; LD A,(LA216)
        and #$03 ; AND 03
        beq *+3 ; RET NZ
        rts
        lda #<LA27B ; LD HL,LA27B
        sta z80_l
        lda #>LA27B
        sta z80_h
        lda #<L0010 ; LD DE,L0010
        sta z80_e
        lda #>L0010
        sta z80_d
        lda #$03 ; LD B,03
        sta z80_b
@@294   ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        ; AND  A
        jeq @@295 ; JR Z,@@295
        jsr add_hl_de ; ADD HL,DE
        dec z80_b ; DJNZ @@294
        jne @@294
        rts ; RET

;@@295   PUSH HL
;C7F8    POP IY
;C7FA    EX DE,HL
;C7FB    LD C,L
;C7FC    LD B,H
;C7FD    LD HL,LC840
;C800    LDIR
;C802    LD A,(LA263)
;C805    LD C,A
;C806    LD B,00
;C808    LD HL,LC854
;C80B    ADD HL,BC
;C80C    LD C,(HL)
;C80D    LD A,(LA218)
;C810    LD B,A
;C811    AND 7F
;C813    ADD A,08
;C815    CALL LC85C
;C818    BIT 7,B
;C81A    JR Z,@@296
;C81C    NEG
;@@296   LD (IY+0A),A
;C821    LD A,(LA219)
;C824    AND 0F
;C826    SLA C
;C828    ADD A,C
;C829    NEG
;C82B    LD (IY+0B),A
;C82E    LD A,(LA21A)
;C831    AND 7F
;C833    ADD A,40
;C835    LD (IY+02),A
;C838    LD A,(LA266)
;C83B    DEC A
;C83C    LD (LA266),A
;C83F    RET

@@295   ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		lda z80_l
		sta z80_iy
		lda z80_h
		sta z80_iy+1
        ;jsr ex_de_hl ; EX DE,HL
        ;lda z80_l ; LD C,L
        ;sta z80_c
        ;lda z80_h ; LD B,H
        ;sta z80_b
        ;lda #<LC840 ; LD HL,LC840
        ;sta z80_l
        ;lda #>LC840
        ;sta z80_h
        ;jsr ldir ; LDIR
		ldy #$0f
@@295_Loop		
		lda LC840,y
		sta (z80_iy),y
		dey
		bpl @@295_Loop
        ;lda LA263 ; LD A,(LA263)
        ;sta z80_c ; LD C,A
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;lda #<LC854 ; LD HL,LC854
        ;sta z80_l
        ;lda #>LC854
        ;sta z80_h
        ;jsr add_hl_bc ; ADD HL,BC
        ;ldy #$00 ; LD C,(HL)
        ;lda (z80_hl),y
		ldy LA263
		lda LC854,y
        sta z80_c
        lda LA218 ; LD A,(LA218)
        sta z80_b ; LD B,A
        and #$7F ; AND 7F
        clc ; ADD A,08
        adc #$08
        jsr LC85C ; CALL LC85C
        ;lda z80_b ; BIT 7,B
        ;bit _bitmem7
        bit z80_b
        ;jeq @@296 ; JR Z,@@296
        jpl @@296
        eor #$ff ; NEG
        clc
        adc #$01; A read but not set by previous instruction
@@296   ldy #$0A ; LD (IY+0A),A
        sta (z80_iy),y
        lda LA219 ; LD A,(LA219)
        and #$0F ; AND 0F
        asl z80_c ; SLA C
        clc ; ADD A,C
        adc z80_c; 
        eor #$ff ; NEG
        clc
        adc #$01
        ldy #$0B ; LD (IY+0B),A
        sta (z80_iy),y
        lda LA21A ; LD A,(LA21A)
        and #$7F ; AND 7F
        clc ; ADD A,40
        adc #$40
        ldy #$02 ; LD (IY+02),A
        sta (z80_iy),y
        ;lda LA266 ; LD A,(LA266)
        ;sec ; DEC A
        ;sbc #$01
        ;sta LA266 ; LD (LA266),A
		dec LA266
        rts ; RET


;LC840   DB 04,00,00,00,C0,00,00,00
;C848    DB 08,08,00,00,00,00

LC840   .he 04,00,00,00,C0,00,00,00 ; DB 04,00,00,00,C0,00,00,00
        .he 08,08,00,00,00,00 ; DB 08,08,00,00,00,00

;LC84E   DW LC850

LC84E   .wo LC850 ; DW LC850

;LC850   DB F4,F4,29,80

LC850   .he F4,F4,29,80 ; DB F4,F4,29,80

;LC854   DB 0F,13,17,1B,1F,23,27,2B ; .....#'+

LC854   .he 0F,13,17,1B,1F,23,27,2B ; DB 0F,13,17,1B,1F,23,27,2B

;LC85C   CP C
;C85D    RET C
;C85E    SUB 08
;C860    JR LC85C

LC85C   cmp z80_c ; CP C; A read at the beginning of the block
        bcs *+3 ; RET C
        rts
        sec ; SUB 08
        sbc #$08; A read but not set by previous instruction
        ;jmp LC85C ; JR LC85C
		bpl LC85C
		rts

;C862    CALL LC8C1
;C865    JR C,@@298
;C867    LD L,(IX+01)
;C86A    LD H,(IX+02)
;C86D    LD E,(IX+0A)
;C870    CALL LC8F0
;C873    LD A,H
;C874    CP 10
;C876    JR C,@@300
;C878    CP D8
;C87A    JR NC,@@300
;C87C    LD (IX+01),L
;C87F    LD (IX+02),H
;C882    LD L,H
;C883    LD H,00
;C885    LD (LA250),HL
;C888    LD L,(IX+03)
;C88B    LD H,(IX+04)
;C88E    LD E,(IX+0B)
;C891    CALL LC8F0
;C894    LD A,H
;C895    CP 30
;C897    JR C,@@300
;C899    LD (IX+03),L
;C89C    LD (IX+04),H
;C89F    LD L,H
;C8A0    LD H,00
;C8A2    LD (LA252),HL
;C8A5    JP LBD5A

LC862   jsr LC8C1 ; CALL LC8C1
        jcc @@298 ; JR C,@@298
        ldy #$01 ; LD L,(IX+01)
        lda (z80_ix),y
        sta z80_l
        ;ldy #$02 ; LD H,(IX+02)
		iny
        lda (z80_ix),y
        sta z80_h
        ldy #$0A ; LD E,(IX+0A)
        lda (z80_ix),y
        sta z80_e
        jsr LC8F0 ; CALL LC8F0
        lda z80_h ; LD A,H
        cmp #$10 ; CP 10
        jcc @@300 ; JR C,@@300
        cmp #$D8 ; CP D8
        jcs @@300 ; JR NC,@@300
        ldy #$01 ; LD (IX+01),L
        lda z80_l
        sta (z80_ix),y
        ;ldy #$02 ; LD (IX+02),H
		iny
        lda z80_h
        sta (z80_ix),y
		sta LA250
        ;lda z80_h ; LD L,H
        ;sta z80_l
        lda #$00 ; LD H,00




        sta LA250+1
        ;sta z80_h
        ;lda z80_l ; LD (LA250),HL
        ;sta LA250
        ;lda z80_h
        ;sta LA250+1
        ldy #$03 ; LD L,(IX+03)
        lda (z80_ix),y
        sta z80_l
        ;ldy #$04 ; LD H,(IX+04)
		iny
        lda (z80_ix),y
        sta z80_h
        ldy #$0B ; LD E,(IX+0B)
        lda (z80_ix),y
        sta z80_e
        jsr LC8F0 ; CALL LC8F0
        lda z80_h ; LD A,H
        cmp #$30 ; CP 30
        jcc @@300 ; JR C,@@300
        ldy #$03 ; LD (IX+03),L
        lda z80_l
        sta (z80_ix),y
        ;ldy #$04 ; LD (IX+04),H
		iny
        lda z80_h
        sta (z80_ix),y
        sta LA252
        ;lda z80_h ; LD L,H
        ;sta z80_l
        lda #$00 ; LD H,00
        ;sta z80_h




        sta LA252+1
        ;lda z80_l ; LD (LA252),HL
        ;sta LA252
        ;lda z80_h
        ;sta LA252+1
        jmp LBD5A ; JP LBD5A

;@@298   LD BC,L0100
;C8AB    CALL LD34D
;C8AE    CALL LD389
;C8B1    LD A,04
;C8B3    LD (LA23C),A
;C8B6    LD HL,LAECD
;C8B9    LD (LA23D),HL
;@@300   LD (IX+00),00
;C8C0    RET

@@298   lda #<L0100 ; LD BC,L0100
        sta z80_c
        lda #>L0100
        sta z80_b
        jsr LD34D ; CALL LD34D
        jsr LD389 ; CALL LD389
        lda #$04 ; LD A,04
        sta LA23C ; LD (LA23C),A
        ;lda #<LAECD ; LD HL,LAECD
        ;sta z80_l
        ;lda #>LAECD
        ;sta z80_h
        ;lda z80_l ; LD (LA23D),HL
        ;sta LA23D
        ;lda z80_h
        ;sta LA23D+1
		lda #<LAECD
		sta LA23D

		lda #>LAECD




		sta LA23D+1
@@300   ldy #$00 ; LD (IX+00),00
        ;lda #$00
		tya
        sta (z80_ix),y
        rts ; RET


;LC8C1   LD IY,LA34B
;C8C5    LD A,(IY+00)
;C8C8    AND A
;C8C9    RET Z
;C8CA    LD A,(IX+08)
;C8CD    ADD A,(IY+08)
;C8D0    LD C,A
;C8D1    LD A,(IX+02)
;C8D4    SUB (IY+02)
;C8D7    JR NC,@@302
;C8D9    NEG
;@@302   CP C
;C8DC    RET NC
;C8DD    LD A,(IX+09)
;C8E0    ADD A,(IY+09)
;C8E3    LD C,A
;C8E4    LD A,(IX+04)
;C8E7    SUB (IY+04)
;C8EA    JR NC,@@303
;C8EC    NEG
;@@303   CP C
;C8EF    RET

LC8C1   lda #<LA34B ; LD IY,LA34B ; sets C flag at return
        sta z80_iy
        lda #>LA34B
        sta z80_iy+1
        ldy #$00 ; LD A,(IY+00)
        lda (z80_iy),y
        ; AND  A
        bne *+4 ; RET Z
        sec
        rts
        ldy #$08 ; LD A,(IX+08)
        lda (z80_ix),y
        ;ldy #$08 ; ADD A,(IY+08)
        clc
        adc (z80_iy),y
        sta z80_c ; LD C,A
        ldy #$02 ; LD A,(IX+02)
        lda (z80_ix),y
        ;ldy #$02 ; SUB (IY+02)
        sec
        sbc (z80_iy),y
        jcs @@302 ; JR NC,@@302
        eor #$ff ; NEG
        clc
        adc #$01; 
@@302   cmp z80_c ; CP C
        bcc *+3 ; RET NC
        rts
        ldy #$09 ; LD A,(IX+09)
        lda (z80_ix),y
        ;ldy #$09 ; ADD A,(IY+09)
        clc
        adc (z80_iy),y
        sta z80_c ; LD C,A
        ldy #$04 ; LD A,(IX+04)
        lda (z80_ix),y
        ;ldy #$04 ; SUB (IY+04)
        sec
        sbc (z80_iy),y
        jcs @@303 ; JR NC,@@303
        eor #$ff ; NEG
        clc
        adc #$01; 
@@303   cmp z80_c ; CP C
        rts ; RET


;LC8F0   XOR A
;C8F1    BIT 7,E
;C8F3    JR Z,@@304
;C8F5    CPL
;@@304   LD D,A
;C8F7    SLA E
;C8F9    RL D
;C8FB    SLA E
;C8FD    RL D
;C8FF    SLA E
;C901    RL D
;C903    SLA E
;C905    RL D
;C907    ADD HL,DE
;C908    RET

LC8F0   lda #$00 ; XOR A
        ;lda z80_e ; BIT 7,E
        ;bit _bitmem7
        bit z80_e
        ;jeq @@304 ; JR Z,@@304
        jpl @@304
        eor #$ff ; CPL
@@304   ;sta z80_d ; LD D,A
        asl z80_e ; SLA E
        ;rol z80_d ; RL D
		rol @
        asl z80_e ; SLA E
        ;rol z80_d ; RL D
		rol @
        asl z80_e ; SLA E
        ;rol z80_d ; RL D
		rol @
        asl z80_e ; SLA E
        ;rol z80_d ; RL D
		rol @
		sta z80_d
        jsr add_hl_de ; ADD HL,DE
        rts ; RET


;C909    LD A,(LA216)
;C90C    ADD A,02
;C90E    AND 03
;C910    JR NZ,@@307
;C912    LD HL,LA209
;C915    LD A,(HL)
;C916    AND A
;C917    JR Z,@@307
;C919    DEC (HL)
;C91A    JR NZ,@@307
;C91C    LD A,0A
;C91E    LD (LA21F),A
;C921    LD (IX+05),08
;C925    LD (IX+00),01
;@@307   LD HL,LA208
;C92C    LD A,(HL)
;C92D    AND A
;C92E    JR Z,@@308
;C930    DEC (HL)
;@@308   CALL LC970
;C934    CALL LD0DC
;C937    LD A,(LA21C)
;C93A    RRCA
;C93B    AND 03
;C93D    JR NZ,LC945
;C93F    LD A,C
;C940    RRCA
;C941    AND 08
;C943    OR C
;C944    LD C,A
;LC945   LD E,C
;C946    CALL LCD05
;C949    CALL LCB7F
;C94C    PUSH DE
;C94D    CALL LCC3B
;C950    POP DE
;C951    CALL LC9E5
;C954    CALL LCB22
;C957    LD HL,LA228
;C95A    CALL LCB59
;C95D    JP LCAE3

LC909   lda LA216 ; LD A,(LA216)
        clc ; ADD A,02
        adc #$02
        and #$03 ; AND 03
        jne @@307 ; JR NZ,@@307
        ;lda #<LA209 ; LD HL,LA209
        ;sta z80_l
        ;lda #>LA209
        ;sta z80_h
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		lda LA209
        ; AND  A
        jeq @@307 ; JR Z,@@307
        ;ldy #$00 ; DEC (HL)
        ;lda (z80_hl),y
        ;sec

        ;sbc #$01
        ;sta (z80_hl),y
		dec LA209


        jne @@307 ; JR NZ,@@307
        
		; man speed 2 - default $0A
		lda MAN_SPEED ; LD A,0A
        sta LA21F ; LD (LA21F),A
        
		ldy #$05 ; LD (IX+05),08
        lda #$08
        sta (z80_ix),y
        ldy #$00 ; LD (IX+00),01
        lda #$01
        sta (z80_ix),y
LC929
@@307   ;lda #<LA208 ; LD HL,LA208
        ;sta z80_l
        ;lda #>LA208
        ;sta z80_h
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		lda LA208
        ; AND  A
        jeq @@308 ; JR Z,@@308
        ;ldy #$00 ; DEC (HL)
        ;lda (z80_hl),y
        ;sec

        ;sbc #$01
        ;sta (z80_hl),y
	dec LA208

@@308   jsr LC970 ; CALL LC970

        jsr CheckUserInput ; CALL LD0DC
		
		; ---- removed below --------------
        ;lda game_select_type ; LD A,(LA21C)
        ;lsr @ ; RRCA
        ;and #$03 ; AND 03
        
		;jne LC945 - jeq works for kb but not joy (jne for joy)
        
		;lda z80_c ; LD A,C
        ;lsr @ ; RRCA
        ;and #$08 ; AND 08
        ;ora z80_c ; OR C
        ;sta z80_c ; LD C,A

		; --------------------------------
		
LC945   lda z80_c ; LD E,C
        sta z80_e
        jsr LCD05 ; CALL LCD05
        jsr LCB7F ; CALL LCB7F
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        jsr LCC3B ; CALL LCC3B
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        jsr LC9E5 ; CALL LC9E5
        jsr LCB22 ; CALL LCB22
        lda #<LA228 ; LD HL,LA228
        sta z80_l
        lda #>LA228
        sta z80_h
        jsr LCB59 ; CALL LCB59
        jmp LCAE3 ; JP LCAE3

;LC960   DB 1E,17,1C,17,1F,18,1C,18
;C968    DB 21,19,20,19,22,1A,20,1A ; !. .". .

LC960   .he 1E,17,1C,17,1F,18,1C,18 ; DB 1E,17,1C,17,1F,18,1C,18
        .he 21,19,20,19,22,1A,20,1A ; DB 21,19,20,19,22,1A,20,1A

;LC970   LD A,(LA243)
;C973    AND A
;C974    RET NZ
;C975    LD A,(LA216)
;C978    AND 01
;C97A    RET NZ
;C97B    LD A,(LA246)
;C97E    AND A
;C97F    RET NZ
;C980    LD HL,LA247
;C983    LD A,(HL)
;C984    AND A
;C985    LD A,(LA264)
;C988    JR NZ,@@310
;C98A    AND A
;C98B    RET NZ
;C98C    LD (HL),01
;@@310   LD BC,(LA260)
;C992    CALL LD364
;C995    JR C,@@312
;C997    LD A,(LA264)
;C99A    INC A
;C99B    LD (LA264),A
;C99E    CP 06
;C9A0    JR NZ,@@311
;C9A2    LD HL,LA247
;C9A5    LD (HL),00
;@@311   DEC A
;C9A8    LD BC,LC9D9
;C9AB    CALL LC74B
;C9AE    CALL LD26B
;C9B1    LD A,71
;C9B3    CALL LC9C8
;C9B6    CALL LAF20
;C9B9    JP LD389

LC970   

		lda LA243 ; LD A,(LA243)
        ; AND  A
        beq *+3 ; RET NZ
        rts
        lda LA216 ; LD A,(LA216)
        and #$01 ; AND 01
        beq *+3 ; RET NZ
        rts
        lda LA246 ; LD A,(LA246)
        ; AND  A
        beq *+3 ; RET NZ
        rts
        lda #<LA247 ; LD HL,LA247
        sta z80_l
        lda #>LA247
        sta z80_h
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        ; AND  A
        php
        lda LA264 ; LD A,(LA264)
        sta z80_a
        plp
        jne @@310 ; JR NZ,@@310; ZERO flag read but not set by previous instruction
        ; AND  A ; A read but not set by previous instruction
        lda z80_a
        beq *+3 ; RET NZ
        rts
        lda #$01 ; LD (HL),01
        ldy #$00
        sta (z80_hl),y
@@310   lda LA260 ; LD BC,(LA260)
        sta z80_c
        lda LA260+1
        sta z80_b
        jsr LD364 ; CALL LD364
        jcc @@312 ; JR C,@@312
        lda LA264 ; LD A,(LA264)
        clc ; INC A
        adc #$01
        sta LA264 ; LD (LA264),A

		ldx QUICK_RELOAD
		bne @+
				
		; remove for quick reload
		cmp #$06 ; CP 06
        jne @@311 ; JR NZ,@@311
@        
	tax
        ;lda #<LA247 ; LD HL,LA247
        ;sta z80_l
        ;lda #>LA247
        ;sta z80_h
        ;lda #$00 ; LD (HL),00
        ;ldy #$00
        ;sta (z80_hl),y

	lda #$00
	sta LA247        

	txa

; colour in barrel bullets 	
@@311   sec ; DEC A
        sbc #$01; A read but not set by previous instruction
        ;ldx #<LC9D9 ; LD BC,LC9D9
        ;stx z80_c
        ;ldx #>LC9D9
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		asl @
		tax
		lda LC9D9,x
		sta z80_l
		lda LC9D9+1,x
		sta z80_h

	jsr LD26B ; CALL LD26B

	; colour bullet yellow
        lda #$61 ; LD A,71
	jsr LC9C8 ; CALL LC9C8
     		
	jsr LAF20 ; CALL LAF20
        jmp LD389 ; JP LD389

;@@312   CALL LD34D
;C9BF    XOR A
;C9C0    LD (LA247),A
;C9C3    INC A
;C9C4    LD (LA243),A
;C9C7    RET

@@312   jsr LD34D ; CALL LD34D
        lda #$00 ; XOR A
        sta LA247 ; LD (LA247),A
        ;clc ; INC A
        ;adc #$01
		lda #$01
        sta LA243 ; LD (LA243),A
        rts ; RET


;LC9C8   LD BC,L0202
;C9CB    LD DE,L001E
;@@313   PUSH BC
;@@314   LD (HL),A
;C9D0    INC HL
;C9D1    DJNZ @@314
;C9D3    ADD HL,DE
;C9D4    POP BC
;C9D5    DEC C
;C9D6    JR NZ,@@313
;C9D8    RET

LC9C8   sta z80_a
        lda #<L0202 ; LD BC,L0202
        sta z80_c
        lda #>L0202
        sta z80_b
        lda #<L001E ; LD DE,L001E
        sta z80_e
        lda #>L001E
        sta z80_d
		
		
@@313   lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
@@314   ldy #$00 ; LD (HL),A
		
		
		lda z80_l
		sta dest_col_lo
		
		clc
		lda z80_h
		adc #$04
		sta dest_col_hi
		
		lda z80_a
		cmp #$01
		beq luma_black
		cmp #$61
		beq luma_yellow
		cmp #$21
		beq luma_red
		cmp #$31
		beq luma_pur
		lda #$61
		sta colour_b
		jmp luma_out
luma_black
		lda #$60
		sta colour_b
		jmp luma_out
luma_yellow
		lda #$67
		sta colour_b
		jmp luma_out		
luma_red   
		lda #$62
		sta colour_b
		jmp luma_out
luma_pur   
		lda #$64
		sta colour_b
				
luma_out
		
		; bullet colour
        lda z80_a
		; write colours for barrel here
        sta (z80_hl),y; A read but not set by previous instruction
        lda colour_b
		sta (dest_col_lo),y
		
		
		inc z80_l ; INC HL
        bne *+4
        inc z80_h
        dec z80_b ; DJNZ @@314
        jne @@314
			
		jsr add_hl_de ; ADD HL,DE
        
		; hack in C64 extra screen width for colour
		clc
		lda z80_l
		adc #08
		sta z80_l
		scc:inc z80_h
				
		pla ; POP BC
        sta z80_b
        pla
        sta z80_c
        dec z80_c ; DEC C
        jne @@313 ; JR NZ,@@313
        rts ; RET

;LC9D9   DW L5A27,L5A49,L5A89,L5AA7
;C9E1    DW L5A85,L5A45

LC9D9   .wo L5A27,L5A49,L5A89,L5AA7 ; DW L5A27,L5A49,L5A89,L5AA7
        .wo L5A85,L5A45 ; DW L5A85,L5A45

;LC9E5   LD A,(LA245)
;C9E8    AND A
;C9E9    JR NZ,@@316
;C9EB    BIT 3,E
;C9ED    RET Z
;C9EE    LD A,(LA247)
;C9F1    AND A
;C9F2    RET NZ
;C9F3    LD A,(LA264)
;C9F6    AND A
;C9F7    RET Z
;C9F8    CALL LCA56
;C9FB    RET NC
;C9FC    LD A,(LA264)
;C9FF    DEC A
;CA00    LD (LA264),A
;CA03    INC A
;CA04    CP 06
;CA06    JR Z,@@315
;CA08    LD BC,LC9D9
;CA0B    CALL LC74B
;CA0E    CALL LD26B
;CA11    LD A,41
;CA13    CALL LC9C8
;@@315   LD A,05
;CA18    LD (LA246),A
;CA1B    LD A,01
;CA1D    LD (LA245),A
;CA20    RET

; fire/shoot
LC9E5

	lda LA245 ; LD A,(LA245)
        ; AND  A
        jne @@316 ; JR NZ,@@316
        lda z80_e ; BIT 3,E
        bit _bitmem3
        bne *+3 ; RET Z
        rts
        lda LA247 ; LD A,(LA247)
        ; AND  A
        beq *+3 ; RET NZ
        rts
        lda LA264 ; LD A,(LA264)
        ; AND  A
        bne *+3 ; RET Z
        rts
        jsr LCA56 ; CALL LCA56
        bcc *+3 ; RET NC
        rts; 

		lda LA264 ; LD A,(LA264)
        sec ; DEC A
        sbc #$01
        sta LA264 ; LD (LA264),A
        
		clc ; INC A
        adc #$01
        cmp #$06 ; CP 06
        jeq @@315 ; JR Z,@@315
        
        ;ldx #<LC9D9 ; LD BC,LC9D9
        ;stx z80_c
        ;ldx #>LC9D9
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		asl @
		tax
		lda LC9D9,x
		sta z80_l
		lda LC9D9+1,x
		sta z80_h
        

		jsr LD26B ; CALL LD26B
		
		; blank out bullet colour
        lda #$01 ; LD A,41
        jsr LC9C8 ; CALL LC9C8
		
@@315   lda #$04 ; LD A,05
        sta LA246 ; LD (LA246),A
        lda #$01 ; LD A,01
        sta LA245 ; LD (LA245),A
        rts ; RET

;@@316   BIT 3,E
;CA23    RET NZ
;CA24    XOR A
;CA25    LD (LA245),A
;CA28    RET

@@316   lda z80_e ; BIT 3,E
        bit _bitmem3
        beq *+3 ; RET NZ
        rts
        lda #$00 ; XOR A
        sta LA245 ; LD (LA245),A
        rts ; RET

;@@317   PUSH IX
;CA2B    POP HL
;CA2C    LD DE,LA34B
;CA2F    PUSH DE
;CA30    POP IY
;CA32    LD BC,L0005
;CA35    LDIR
;CA37    LD (IY+00),05
;CA3B    LD HL,LCA52
;CA3E    LD (IY+08),08
;CA42    LD (IY+09),08
;CA46    LD (IY+0D),00
;CA4A    LD (IY+0E),L
;CA4D    LD (IY+0F),H
;CA50    SCF
;CA51    RET


@@317   ;lda z80_ix ; PUSH IX
        ;pha
        ;lda z80_ix+1
        ;pha
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
		;lda z80_ix
		;sta z80_l
		;lda z80_ix+1
		;sta z80_h
        lda #<LA34B ; LD DE,LA34B
        ;sta z80_e
		sta z80_iy
        lda #>LA34B
        ;sta z80_d
		sta z80_iy+1
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
        ;lda #<L0005 ; LD BC,L0005
        ;sta z80_c
        ;lda #>L0005
        ;sta z80_b
        ;jsr ldir ; LDIR
		ldy #$04
@@317_Loop		
		lda (z80_ix),y
		sta (z80_iy),y
		dey
		bpl @@317_Loop
        ;ldy #$00 ; LD (IY+00),05
		iny
        lda #$05
        sta (z80_iy),y
        ;lda #<LCA52 ; LD HL,LCA52
        ;sta z80_l
        ;lda #>LCA52
        ;sta z80_h
        ldy #$08 ; LD (IY+08),08
        ;lda #$08
		tya
        sta (z80_iy),y
        ;ldy #$09 ; LD (IY+09),08
		iny
        ;lda #$08
        sta (z80_iy),y
        ldy #$0D ; LD (IY+0D),00
        lda #$00
        sta (z80_iy),y
        ;ldy #$0E ; LD (IY+0E),L
		iny
        ;lda z80_l
		lda #<LCA52
        sta (z80_iy),y
        ;ldy #$0F ; LD (IY+0F),H
		iny
        ;lda z80_h
		lda #>LCA52
        sta (z80_iy),y
        ;sec ; SCF
        clc ; C flag tested after return, inverted by convention
        rts ; RET


;LCA52   DB F8,F7,0A,80

LCA52   .he F8,F7,0A,80 ; DB F8,F7,0A,80

;LCA56   CALL LAF2E
;CA59    LD A,(LA269)
;CA5C    AND A
;CA5D    JR Z,@@317
;CA5F    LD HL,LA28B
;CA62    LD DE,L0010
;CA65    LD B,03
;CA67    PUSH BC
;CA68    PUSH HL
;@@318   LD A,(HL)
;CA6A    AND A
;CA6B    JR Z,@@323
;CA6D    ADD HL,DE
;CA6E    DJNZ @@318
;CA70    POP HL
;CA71    POP BC
;CA72    PUSH BC
;CA73    PUSH HL
;@@319   LD A,(HL)
;CA75    CP 02
;CA77    JR NZ,@@323
;CA79    ADD HL,DE
;CA7A    DJNZ @@319
;CA7C    POP IY
;CA7E    POP BC
;@@320   BIT 1,(IY+07)
;CA83    JR Z,@@321
;CA85    ADD IY,DE
;CA87    DJNZ @@320
;CA89    AND A
;CA8A    RET

LCA56   jsr LAF2E ; CALL LAF2E ; sets C at return
        lda game_on ; LD A,(LA269)
        ; AND  A
        jeq @@317 ; JR Z,@@317
				
        lda #<LA28B ; LD HL,LA28B
        sta z80_l
        lda #>LA28B
        sta z80_h
        lda #<L0010 ; LD DE,L0010
        sta z80_e
        lda #>L0010
        sta z80_d
        lda #$03 ; LD B,03
        sta z80_b
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
@@318   ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        ; AND  A
        jeq @@323 ; JR Z,@@323
        jsr add_hl_de ; ADD HL,DE
        dec z80_b ; DJNZ @@318
        jne @@318
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
@@319   ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        cmp #$02 ; CP 02
        jne @@323 ; JR NZ,@@323
        jsr add_hl_de ; ADD HL,DE
        dec z80_b ; DJNZ @@319
        jne @@319
        pla ; POP IY
        sta z80_iy+1
        pla
        sta z80_iy
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
@@320   ldy #$07 ; BIT 1,(IY+07)
        lda (z80_iy),y
        bit _bitmem1
        jeq @@321 ; JR Z,@@321
        jsr add_iy_de ; ADD IY,DE
        dec z80_b ; DJNZ @@320
        jne @@320
        ; AND  A ; uses to clear C flag at return
        sec
        rts ; RET

;@@321   PUSH IY
;CA8D    POP HL
;CA8E    JR @@324

@@321   ;lda z80_iy ; PUSH IY
        ;pha
        ;lda z80_iy+1
        ;pha
        ;pla ; POP HL
        ;sta z80_h
        ;pla
        ;sta z80_l
		lda z80_iy
		sta z80_l

		lda z80_iy+1


		sta z80_h


        jmp @@324 ; JR @@324


;@@323   POP BC
;CA91    POP BC
;@@324   LD (HL),02
;CA94    INC HL
;CA95    PUSH IX
;CA97    POP DE
;CA98    INC DE
;CA99    EX DE,HL
;CA9A    LD BC,L0004
;CA9D    LDIR
;CA9F    LD A,0C
;CAA1    LD (DE),A
;CAA2    INC DE
;CAA3    INC HL
;CAA4    LD C,02
;CAA6    LDIR
;CAA8    LD A,0C
;CAAA    LD (DE),A
;CAAB    INC DE
;CAAC    LD (DE),A
;CAAD    INC DE
;CAAE    INC DE
;CAAF    INC DE
;CAB0    INC DE
;CAB1    INC DE
;CAB2    EX DE,HL
;CAB3    LD DE,LCABB
;CAB6    LD (HL),E
;CAB7    INC HL
;CAB8    LD (HL),D
;CAB9    SCF
;CABA    RET

@@323   pla ; POP BC
        ;sta z80_b
        pla
        ;sta z80_c
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
@@324   lda #$02 ; LD (HL),02
        ldy #$00
        sta (z80_hl),y
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ;lda z80_ix ; PUSH IX
        ;pha
        ;lda z80_ix+1
        ;pha
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		lda z80_ix
		sta z80_e

		lda z80_ix+1


		sta z80_d


        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        jsr ex_de_hl ; EX DE,HL
        lda #<L0004 ; LD BC,L0004
        sta z80_c
        lda #>L0004
        sta z80_b
        jsr ldir ; LDIR
        lda #$0C ; LD A,0C
        ldy #$00 ; LD (DE),A
        sta (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        lda #$02 ; LD C,02
        sta z80_c
        jsr ldir ; LDIR
        lda #$0C ; LD A,0C
        ldy #$00 ; LD (DE),A
        sta (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        ldy #$00 ; LD (DE),A
        sta (z80_de),y
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
        ;inc z80_e ; INC DE
        ;bne *+4
        ;inc z80_d
		lda #$05
		clc
		adc z80_e
		sta z80_e
		scc:inc z80_d
        
	;jsr ex_de_hl ; EX DE,HL
	jsr ld_hl_de
        ;lda #<LCABB ; LD DE,LCABB
        ;sta z80_e
        ;lda #>LCABB

        ;sta z80_d
        ;lda z80_e ; LD (HL),E
		lda #<LCABB
        ldy #$00
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ;lda z80_d ; LD (HL),D
		lda #>LCABB
        ;ldy #$00
		iny
        sta (z80_hl),y
        ;sec ; SCF
		clc ; need to invert, as other returns are inverted
        rts ; RET


;LCABB   DB FC,14,28,80

LCABB   .he FC,14,28,80 ; DB FC,14,28,80

;CABF    LD A,(IX+05)
;CAC2    CALL LCCBB
;CAC5    CALL LCD85
;CAC8    CALL LCCDE
;CACB    CALL LCD89
;CACE    CALL LCCDE
;CAD1    RES 1,(IX+07)
;CAD5    BIT 0,(IX+07)
;CAD9    RET Z
;CADA    LD (IX+00),07
;CADE    LD (IX+0C),02
;CAE2    RET

LCABF   ldy #$05 ; LD A,(IX+05)
        lda (z80_ix),y
        jsr LCCBB ; CALL LCCBB
        jsr LCD85 ; CALL LCD85
        jsr LCCDE ; CALL LCCDE
        jsr LCD89 ; CALL LCD89
        jsr LCCDE ; CALL LCCDE
        ldy #$07 ; RES 1,(IX+07)
        lda (z80_ix),y
        and #_notbitvalue1
        sta (z80_ix),y
        ;ldy #$07 ; BIT 0,(IX+07)
        ;lda (z80_ix),y
        bit _bitmem0
        bne *+3 ; RET Z
        rts
        ldy #$00 ; LD (IX+00),07
        lda #$07
        sta (z80_ix),y
        ldy #$0C ; LD (IX+0C),02
        lda #$02
        sta (z80_ix),y
        rts ; RET

;LCAE3   LD A,(LA246)
;CAE6    AND A
;CAE7    RET Z
;CAE8    LD A,(IX+00)
;CAEB    CP 15
;CAED    RET Z
;CAEE    BIT 2,(IX+0C)
;CAF2    LD A,16
;CAF4    JR Z,@@325
;CAF6    ADD A,05
;@@325   LD (LA22D),A
;CAFB    RET

LCAE3   lda LA246 ; LD A,(LA246)
        ; AND  A
        bne *+3 ; RET Z
        rts
        ldy #$00 ; LD A,(IX+00)
        lda (z80_ix),y
        cmp #$15 ; CP 15
        bne *+3 ; RET Z
        rts
        ldy #$0C ; BIT 2,(IX+0C)
        lda (z80_ix),y
        bit _bitmem2
        php
        lda #$16 ; LD A,16
        plp
        jeq @@325 ; JR Z,@@325; ZERO flag read but not set by previous instruction
        clc ; ADD A,05
        adc #$05;
@@325   sta LA22D ; LD (LA22D),A
        rts ; RET

;LCAFC   LD A,(LA246)
;CAFF    AND A
;CB00    RET Z
;CB01    DEC A
;CB02    LD (LA246),A
;CB05    LD HL,LCB1D
;CB08    CALL LD26E
;CB0B    LD A,(HL)
;CB0C    PUSH AF
;CB0D    LD A,(LA264)
;CB10    LD BC,LC9D9
;CB13    CALL LC74B
;CB16    CALL LD26B
;CB19    POP AF
;CB1A    JP LC9C8

; re-fill bullets
LCAFC   
			
	lda LA246 ; LD A,(LA246)
        ; AND  A
        bne *+3 ; RET Z
        rts

        sec ; DEC A
        sbc #$01
        sta LA246 ; LD (LA246),A
        
	; bullet colour flasher
	;ldx #<LCB1D ; LD HL,LCB1D
        ;stx z80_l
        ;ldx #>LCB1D
        ;stx z80_h
		
        ;jsr LD26E ; CALL LD26E ; uses A as parameter
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y

	tay
	lda LCB1D,y

        pha ; PUSH AF
        php 

        lda LA264 ; LD A,(LA264)
		


        ;ldx #<LC9D9 ; LD BC,LC9D9
        ;stx z80_c
        ;ldx #>LC9D9
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		asl @
		tax
		lda LC9D9,x
		sta z80_l
		lda LC9D9+1,x
		sta z80_h
        

		jsr LD26B ; CALL LD26B
        plp ; POP AF
        pla
        jmp LC9C8 ; JP LC9C8

;LCB1D   DB 41,51,59,79,79 ; AQY..

;LCB1D   .he 41,51,59,79,79 ; DB 41,51,59,79,79

; bullet colour flasher data
LCB1D   .he 01,21,31,71,71 ; DB 41,51,59,79,79

;LCB22   LD L,(IX+0C)
;CB25    LD H,00
;CB27    ADD HL,HL
;CB28    LD BC,LC960
;CB2B    ADD HL,BC
;CB2C    LD E,(HL)
;CB2D    INC HL
;CB2E    LD D,(HL)
;CB2F    LD A,(IX+0C)
;CB32    BIT 2,A
;CB34    LD BC,L1A0F
;CB37    JR NZ,@@326
;CB39    LD BC,L190D
;@@326   RRCA
;CB3D    RRCA
;CB3E    AND 01
;CB40    ADD A,0E
;CB42    EX AF,AF'
;CB43    LD A,(IX+00)
;CB46    CP 01
;CB48    RET Z
;CB49    CP 0A
;CB4B    RET Z
;CB4C    LD BC,L1909
;CB4F    LD A,D
;CB50    SUB 17
;CB52    RRCA
;CB53    AND 01
;CB55    ADD A,34
;CB57    LD D,A
;CB58    RET

LCB22   ldy #$0C ; LD L,(IX+0C)
        lda (z80_ix),y
        sta z80_l
        lda #$00 ; LD H,00
        sta z80_h
        asl z80_l ; ADD HL,HL
        rol z80_h
        lda #<LC960 ; LD BC,LC960
        sta z80_c
        lda #>LC960
        sta z80_b
        jsr add_hl_bc ; ADD HL,BC
        ldy #$00 ; LD E,(HL)
        lda (z80_hl),y
        sta z80_e
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD D,(HL)
        lda (z80_hl),y
        sta z80_d
        ldy #$0C ; LD A,(IX+0C)
        lda (z80_ix),y
        bit _bitmem2 ; BIT 2,A
        php
        ldx #<L1A0F ; LD BC,L1A0F
        stx z80_c
        ldx #>L1A0F
        stx z80_b
        plp
        jne @@326 ; JR NZ,@@326
        ldx #<L190D ; LD BC,L190D
        stx z80_c
        ldx #>L190D
        stx z80_b
@@326   lsr @ ; A read but not set by previous instruction
        lsr @ ; 
        and #$01 ; AND 01
        clc ; ADD A,0E
        adc #$0E
        ldx z80_ap ; EX AF,AF'
        sta z80_ap
        txa ; TODO: EX   AF,AF'
        ldy #$00 ; LD A,(IX+00)
        lda (z80_ix),y
        cmp #$01 ; CP 01
        bne *+3 ; RET Z
        rts
        cmp #$0A ; CP 0A
        bne *+3 ; RET Z
        rts
        lda #<L1909 ; LD BC,L1909
        sta z80_c
        lda #>L1909
        sta z80_b
        lda z80_d ; LD A,D
        sec ; SUB 17
        sbc #$17
        lsr @ ; RRCA
        and #$01 ; AND 01
        clc ; ADD A,34
        adc #$34
        sta z80_d ; LD D,A
        rts ; RET

;LCB59   LD (HL),F4
;CB5B    INC HL
;CB5C    LD (HL),04
;CB5E    INC HL
;CB5F    LD (HL),E
;CB60    INC HL
;CB61    LD A,(IX+00)
;CB64    SUB 15
;CB66    CP 02
;CB68    LD A,F4
;CB6A    JR NC,@@327
;CB6C    SUB 08
;@@327   LD (HL),A
;CB6F    INC HL
;CB70    LD (HL),C
;CB71    INC HL
;CB72    LD (HL),D
;CB73    INC HL
;CB74    LD (HL),F4
;CB76    INC HL
;CB77    LD (HL),B
;CB78    INC HL
;CB79    EX AF,AF'
;CB7A    LD (HL),A
;CB7B    INC HL
;CB7C    LD (HL),80
;CB7E    RET

LCB59   lda #$F4 ; LD (HL),F4
        ;ldy #$00
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		iny
        lda #$04 ; LD (HL),04
        ;ldy #$00
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		iny
        lda z80_e ; LD (HL),E
        ;ldy #$00
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        ldy #$00 ; LD A,(IX+00)
        lda (z80_ix),y
        sec ; SUB 15
        sbc #$15
        cmp #$02 ; CP 02
        lda #$F4 ; LD A,F4
        jcs @@327 ; JR NC,@@327
        sec ; SUB 08
        sbc #$08; 
@@327   ;ldy #$00 ; LD (HL),A
		ldy #$03
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		iny
        lda z80_c ; LD (HL),C
        ;ldy #$00
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		iny
        lda z80_d ; LD (HL),D
        ;ldy #$00
		sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		iny
        lda #$F4 ; LD (HL),F4
        ;ldy #$00
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		iny
        lda z80_b ; LD (HL),B
        ;ldy #$00
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		iny
        ldx z80_ap ; EX AF,AF'
        sta z80_ap
        txa ;
        ;ldy #$00 ; LD (HL),A
        sta (z80_hl),y
        ;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		iny
        lda #$80 ; LD (HL),80
        ;ldy #$00
        sta (z80_hl),y
        rts ; RET

;LCB7F   LD A,(IX+06)
;CB82    AND 07
;CB84    JR Z,@@328
;CB86    DEC (IX+06)
;CB89    JP LCC0C

LCB7F   ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
		tax
        and #$07 ; AND 07
        jeq @@328 ; JR Z,@@328
        ;ldy #$06 ; DEC (IX+06)
        ;lda (z80_ix),y
        ;sec

        ;sbc #$01
		dex
		txa
        sta (z80_ix),y
        jmp LCC0C ; JP LCC0C


;@@328   LD HL,LA21C
;CB8F    LD A,(HL)
;CB90    AND 06
;CB92    JR Z,@@343
;CB94    BIT 3,(HL)
;CB96    JR Z,@@343
;CB98    LD A,(LA24F)
;CB9B    AND 01
;CB9D    CALL NZ,LCD1C
;CBA0    BIT 0,E
;CBA2    JR NZ,@@329
;CBA4    BIT 2,E
;CBA6    JR NZ,@@330
;@@329   BIT 1,E
;CBAA    JR NZ,@@337
;CBAC    BIT 4,E
;CBAE    JR NZ,@@338
;CBB0    BIT 0,E
;CBB2    JR NZ,@@339
;CBB4    RES 2,E
;CBB6    JR @@343

; player movement
@@328   
		
		lda #<game_select_type ; LD HL,LA21C
        sta z80_l
        lda #>game_select_type
        sta z80_h
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        and #$06 ; AND 06

		lda directional
        
		; swap over to jne to swap controls
		jeq @@343 ; JR Z,@@343
        
		ldy #$00 ; BIT 3,(HL)
        lda (z80_hl),y
        bit _bitmem3
        jeq @@343 ; JR Z,@@343
        lda LA24F ; LD A,(LA24F)
        and #$01 ; AND 01
        beq *+5 ; CALL NZ,LCD1C
        jsr LCD1C
        lda z80_e ; BIT 0,E
        bit _bitmem0
        jne @@329 ; JR NZ,@@329
        lda z80_e ; BIT 2,E
        bit _bitmem2
        jne @@330 ; JR NZ,@@330
@@329   lda z80_e ; BIT 1,E
        bit _bitmem1
        jne @@337 ; JR NZ,@@337
        lda z80_e ; BIT 4,E
        bit _bitmem4
        jne @@338 ; JR NZ,@@338
        lda z80_e ; BIT 0,E
        bit _bitmem0
        jne @@339 ; JR NZ,@@339
        lda z80_e ; RES 2,E
        and #_notbitvalue2
        sta z80_e
        jmp @@343 ; JR @@343

;@@330   LD A,(IX+06)
;@@332   AND C0
;CBBD    RES 2,E
;CBBF    JR Z,@@340
;CBC1    CP 40
;CBC3    JR Z,@@334
;CBC5    CP C0
;CBC7    JR Z,@@336
;CBC9    LD A,(LA218)
;CBCC    CP 80
;CBCE    JR C,@@336
;@@334   LD A,(IX+06)
;CBD3    SUB 40
;CBD5    JR @@345

@@330   ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
@@332   and #$C0 ; AND C0
        tax
        lda z80_e ; RES 2,E
        and #_notbitvalue2
        sta z80_e
        txa
        jeq @@340 ; JR Z,@@340; ZERO flag read but not set by previous instruction
        cmp #$40 ; CP 40; A read but not set by previous instruction
        jeq @@334 ; JR Z,@@334
        cmp #$C0 ; CP C0; A read but not set by previous instruction
        jeq @@336 ; JR Z,@@336
        lda LA218 ; LD A,(LA218)
        cmp #$80 ; CP 80
        jcc @@336 ; JR C,@@336
@@334   ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        sec ; SUB 40
        sbc #$40
        jmp @@345 ; JR @@345

;@@336   LD A,(IX+06)
;CBDA    ADD A,40
;CBDC    JR @@345

@@336   ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        clc ; ADD A,40
        adc #$40
        jmp @@345 ; JR @@345

;@@337   LD A,(IX+06)
;CBE1    SUB 40
;CBE3    JR @@332

@@337   ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        sec ; SUB 40
        sbc #$40
        jmp @@332 ; JR @@332

;@@338   LD A,(IX+06)
;CBE8    SUB 80
;CBEA    JR @@332

@@338   ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        sec ; SUB 80
        sbc #$80
        jmp @@332 ; JR @@332

;@@339   LD A,(IX+06)
;CBEF    SUB C0
;CBF1    JR @@332

@@339   ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        sec ; SUB C0
        sbc #$C0
        jmp @@332 ; JR @@332

;@@340   SET 2,E
;CBF5    RET

@@340   lda z80_e ; SET 2,E
        ora #_bitvalue2
        sta z80_e
        rts ; RET

;@@343   LD A,(IX+06)
;CBF9    BIT 0,E
;CBFB    JR Z,@@344
;CBFD    SUB 40
;CBFF    OR 01
;@@344   BIT 1,E
;CC03    JR Z,@@347
;CC05    ADD A,40
;@@345   OR 01
;@@347   LD (IX+06),A
;LCC0C   LD A,(IX+06)
;CC0F    RLCA
;CC10    RLCA
;CC11    AND 03
;CC13    LD L,A
;CC14    LD A,(LA24F)
;CC17    ADD A,A
;CC18    XOR L
;CC19    LD L,A
;CC1A    LD H,00
;CC1C    LD BC,LCCB7
;CC1F    ADD HL,BC
;CC20    LD A,(HL)
;CC21    AND C0
;CC23    LD C,A
;CC24    LD A,(IX+07)
;CC27    AND 3F
;CC29    OR C
;CC2A    LD (IX+07),A
;CC2D    LD A,(HL)
;CC2E    AND 04
;CC30    LD C,A
;CC31    LD A,(IX+0C)
;CC34    AND FB
;CC36    OR C
;CC37    LD (IX+0C),A
;CC3A    RET

@@343   ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        sta z80_a
        lda z80_e ; BIT 0,E
        bit _bitmem0
        jeq @@344 ; JR Z,@@344
        lda z80_a
        sec ; SUB 40
        sbc #$40; A read but not set by previous instruction
        ora #$01 ; OR 01
        sta z80_a
@@344   lda z80_e ; BIT 1,E
        bit _bitmem1
        jeq @@347 ; JR Z,@@347
        lda z80_a
        clc ; ADD A,40
        adc #$40; A read but not set by previous instruction
@@345   ora #$01 ; OR 01
        sta z80_a
@@347   ldy #$06 ; LD (IX+06),A
        lda z80_a
        sta (z80_ix),y
LCC0C   ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        asl @ ; RLCA: this copies bit 7 to bit 0 
        ;asl @ ; RLCA: this copies bit 7 to bit 0 
        rol @
        rol @
        and #$03 ; AND 03
        sta z80_l ; LD L,A
        lda LA24F ; LD A,(LA24F)
        asl @ ; ADD A,A
        eor z80_l ; XOR L
        sta z80_l ; LD L,A
        lda #$00 ; LD H,00
        sta z80_h
        lda #<LCCB7 ; LD BC,LCCB7
        sta z80_c
        lda #>LCCB7
        sta z80_b
        jsr add_hl_bc ; ADD HL,BC
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        and #$C0 ; AND C0
        sta z80_c ; LD C,A
        ldy #$07 ; LD A,(IX+07)
        lda (z80_ix),y
        and #$3F ; AND 3F
        ora z80_c ; OR C
        ldy #$07 ; LD (IX+07),A
        sta (z80_ix),y
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        and #$04 ; AND 04
        sta z80_c ; LD C,A
        ldy #$0C ; LD A,(IX+0C)
        lda (z80_ix),y
        and #$FB ; AND FB
        ora z80_c ; OR C
        ldy #$0C ; LD (IX+0C),A
        sta (z80_ix),y
        rts ; RET

;LCC3B   BIT 2,E
;CC3D    JR NZ,@@354
;CC3F    LD A,(IX+06)
;CC42    RLCA
;CC43    RLCA
;CC44    AND 03
;CC46    LD BC,LCC4C
;CC49    JP LC755

LCC3B   lda z80_e ; BIT 2,E
        bit _bitmem2
        jne @@354 ; JR NZ,@@354
        ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        asl @ ; RLCA: this copies bit 7 to bit 0 
        ;asl @ ; RLCA: this copies bit 7 to bit 0 
        rol @
        rol @
        and #$03 ; AND 03
        ldx #<LCC4C ; LD BC,LCC4C
        stx z80_c
        ldx #>LCC4C
        stx z80_b
        jmp LC755 ; JP LC755 ; uses A as parameter

;LCC4C   DW LCC54,LCC6D,LCC72,LCC79

LCC4C   .wo LCC54,LCC6D,LCC72,LCC79 ; DW LCC54,LCC6D,LCC72,LCC79

;CC54    LD A,(IX+03)
;@@348   AND 07
;CC59    JR Z,@@353
;CC5B    NEG
;CC5D    ADD A,08
;CC5F    LD C,04
;CC61    CP C
;CC62    JR NC,@@350
;CC64    SRL C
;CC66    CP C
;CC67    JR NC,@@350
;CC69    LD C,A
;@@350   LD A,C
;CC6B    JR @@355

LCC54   ldy #$03 ; LD A,(IX+03)
        lda (z80_ix),y
@@348   and #$07 ; AND 07
        jeq @@353 ; JR Z,@@353
        eor #$ff ; NEG
        clc
        adc #$01
        clc ; ADD A,08
        adc #$08
        ldx #$04 ; LD C,04
        stx z80_c
        cmp z80_c ; CP C ; A read but not set by previous instruction
        jcs @@350 ; JR NC,@@350
        lsr z80_c ; SRL C
        cmp z80_c ; CP C
        jcs @@350 ; JR NC,@@350
        sta z80_c ; LD C,A
@@350   lda z80_c ; LD A,C
        jmp @@355 ; JR @@355

;CC6D    LD A,(IX+01)
;CC70    JR @@348

LCC6D   ldy #$01 ; LD A,(IX+01)
        lda (z80_ix),y
        jmp @@348 ; JR @@348

;CC72    LD A,(IX+03)
;@@352   NEG
;CC77    JR @@348

LCC72   ldy #$03 ; LD A,(IX+03)
        lda (z80_ix),y
@@352   eor #$ff ; NEG
        clc
        adc #$01
        jmp @@348 ; JR @@348

;CC79    LD A,(IX+01)
;CC7C    JR @@352

LCC79   ldy #$01 ; LD A,(IX+01)
        lda (z80_ix),y
        jmp @@352 ; JR @@352

;@@353   LD (IX+05),00
;CC82    RET

@@353   ldy #$05 ; LD (IX+05),00
        lda #$00
        sta (z80_ix),y
        rts ; RET

;@@354   LD A,(LA21F)
;CC86    SUB (IX+05)
;CC89    SRL A
;CC8B    ADD A,(IX+05)
;CC8E    AND FE
;@@355   LD (IX+05),A
;CC93    CALL LCCBB
;CC96    LD A,(IX+07)
;CC99    PUSH AF
;CC9A    CALL LCD85
;CC9D    POP AF
;CC9E    CALL LAED1
;CCA1    CALL LCCDE
;CCA4    CALL LAEEB
;LCCA7   LD A,(IX+0C)
;CCAA    LD C,A
;CCAB    INC A
;CCAC    AND 03
;CCAE    LD B,A
;CCAF    LD A,C
;CCB0    AND FC
;CCB2    OR B
;CCB3    LD (IX+0C),A
;CCB6    RET

@@354   lda LA21F ; LD A,(LA21F)
        ldy #$05 ; SUB (IX+05)
        sec
        sbc (z80_ix),y
        lsr @ ; SRL A
        ;ldy #$05 ; ADD A,(IX+05)
        clc
        adc (z80_ix),y
        and #$FE ; AND FE
@@355   ldy #$05 ; LD (IX+05),A
        sta (z80_ix),y
        jsr LCCBB ; CALL LCCBB
        ldy #$07 ; LD A,(IX+07)
        lda (z80_ix),y
        pha ; PUSH AF
        php; 
        jsr LCD85 ; CALL LCD85
        plp ; POP AF
        pla
        jsr LAED1 ; CALL LAED1
        jsr LCCDE ; CALL LCCDE
        jsr LAEEB ; CALL LAEEB
LCCA7   ldy #$0C ; LD A,(IX+0C)
        lda (z80_ix),y
        sta z80_c ; LD C,A
        clc ; INC A
        adc #$01
        and #$03 ; AND 03
        sta z80_b ; LD B,A
        lda z80_c ; LD A,C
        and #$FC ; AND FC
        ora z80_b ; OR B
        ;ldy #$0C ; LD (IX+0C),A
        sta (z80_ix),y
        rts ; RET

;LCCB7   DB 00,44,04,40 ; .D.@

LCCB7   .he 00,44,04,40 ; DB 00,44,04,40

;LCCBB   LD H,00
;CCBD    LD L,A
;CCBE    BIT 6,(IX+06)
;CCC2    JR NZ,@@356
;CCC4    LD H,A
;CCC5    LD L,00
;@@356   BIT 7,(IX+06)
;CCCB    JR Z,@@357
;CCCD    LD A,L
;CCCE    NEG
;CCD0    LD L,A
;CCD1    LD A,H
;CCD2    NEG
;CCD4    LD H,A
;@@357   LD A,L
;CCD6    LD (LA214),A
;CCD9    LD A,H
;CCDA    LD (LA215),A
;CCDD    RET

LCCBB   ldx #$00 ; LD H,00
        stx z80_h
        sta z80_l ; LD L,A; A read but not set by previous instruction
        tax
        ldy #$06 ; BIT 6,(IX+06)
        lda (z80_ix),y
        bit _bitmem6
        jne @@356 ; JR NZ,@@356
        stx z80_h ; LD H,A; A read but not set by previous instruction
        lda #$00 ; LD L,00
        sta z80_l
@@356   ldy #$06 ; BIT 7,(IX+06)
        lda (z80_ix),y
        bit _bitmem7
        jeq @@357 ; JR Z,@@357
        lda z80_l ; LD A,L
        eor #$ff ; NEG
        clc
        adc #$01
        sta z80_l ; LD L,A
        lda z80_h ; LD A,H
        eor #$ff ; NEG
        clc
        adc #$01
        sta z80_h ; LD H,A
@@357   lda z80_l ; LD A,L
        sta LA214 ; LD (LA214),A
        lda z80_h ; LD A,H
        sta LA215 ; LD (LA215),A
        rts ; RET

;LCCDE   LD A,(LA214)
;CCE1    CALL LD01C
;CCE4    LD C,(IX+01)
;CCE7    LD B,(IX+02)
;CCEA    ADD HL,BC
;CCEB    LD (IX+01),L
;CCEE    LD (IX+02),H
;CCF1    LD A,(LA215)
;CCF4    CALL LD01C
;CCF7    LD C,(IX+03)
;CCFA    LD B,(IX+04)
;CCFD    ADD HL,BC
;CCFE    LD (IX+03),L
;CD01    LD (IX+04),H
;CD04    RET

LCCDE   lda LA214 ; LD A,(LA214)
        jsr LD01C ; CALL LD01C
        ldy #$01 ; LD C,(IX+01)
        lda (z80_ix),y
        ;sta z80_c
		clc
		adc z80_l
		sta (z80_ix),y
        ;ldy #$02 ; LD B,(IX+02)
		iny
        lda (z80_ix),y
		adc z80_h



		sta (z80_ix),y
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
        ;ldy #$01 ; LD (IX+01),L
        ;lda z80_l
        ;sta (z80_ix),y
        ;ldy #$02 ; LD (IX+02),H
		;lda z80_h
        ;sta (z80_ix),y
        lda LA215 ; LD A,(LA215)
        jsr LD01C ; CALL LD01C
        ldy #$03 ; LD C,(IX+03)
        lda (z80_ix),y
		clc
		adc z80_l
		sta (z80_ix),y
        ;sta z80_c
        ;ldy #$04 ; LD B,(IX+04)
		iny
        lda (z80_ix),y
		adc z80_h



		sta (z80_ix),y
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
        ;ldy #$03 ; LD (IX+03),L
        ;lda z80_l
        ;sta (z80_ix),y
        ;ldy #$04 ; LD (IX+04),H
        ;lda z80_h
        ;sta (z80_ix),y
        rts ; RET


;LCD05   LD HL,LA258
;CD08    BIT 5,E
;CD0A    JR Z,@@358
;CD0C    LD (HL),01
;CD0E    RET

LCD05   lda #<LA258 ; LD HL,LA258
        sta z80_l
        lda #>LA258
        sta z80_h
        lda z80_e ; BIT 5,E
        bit _bitmem5
        jeq @@358 ; JR Z,@@358
        lda #$01 ; LD (HL),01
        ldy #$00
        sta (z80_hl),y
        rts ; RET

;@@358   LD A,(HL)
;CD10    AND A
;CD11    RET Z
;CD12    LD (HL),00
;CD14    LD HL,LA24F
;CD17    LD A,(HL)
;CD18    XOR 01
;CD1A    LD (HL),A
;CD1B    RET

@@358   ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        ; AND  A
        bne *+3 ; RET Z
        rts
        lda #$00 ; LD (HL),00
        ldy #$00
        sta (z80_hl),y
        ;lda #<LA24F ; LD HL,LA24F
        ;sta z80_l
        ;lda #>LA24F
        ;sta z80_h
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		lda LA24F
        eor #$01 ; XOR 01
        ;ldy #$00 ; LD (HL),A
        ;sta (z80_hl),y
		sta LA24F
        rts ; RET

;LCD1C   LD A,E
;CD1D    AND 08
;CD1F    BIT 0,E
;CD21    JR Z,@@359
;CD23    SET 1,A
;@@359   BIT 1,E
;CD27    JR Z,@@360
;CD29    SET 0,A
;@@360   BIT 2,E
;CD2D    JR Z,@@361
;CD2F    SET 4,A
;@@361   BIT 4,E
;CD33    JR Z,@@362
;CD35    SET 2,A
;@@362   LD E,A
;CD38    RET

LCD1C   lda z80_e ; LD A,E
        and #$08 ; AND 08
        ;lda z80_e ; BIT 0,E
        ;bit _bitmem0
        lsr z80_e
        ;jeq @@359 ; JR Z,@@359
        jcc @@359
        ora #_bitvalue1 ; SET 1,A; A read but not set by previous instruction
@@359   ;lda z80_e ; BIT 1,E
        ;bit _bitmem1
        lsr z80_e
        ;jeq @@360 ; JR Z,@@360
        jcc @@360
        ora #_bitvalue0 ; SET 0,A; A read but not set by previous instruction
@@360   ;lda z80_e ; BIT 2,E
        ;bit _bitmem2
        lsr z80_e
        ;jeq @@361 ; JR Z,@@361
        jcc @@361
        ora #_bitvalue4 ; SET 4,A; A read but not set by previous instruction
@@361   ;lda z80_e ; BIT 4,E
        ;bit _bitmem4
        lsr z80_e
        lsr z80_e
        ;jeq @@362 ; JR Z,@@362
        jcc @@362
        ora #_bitvalue2 ; SET 2,A; A read but not set by previous instruction
@@362   sta z80_e ; LD E,A
        rts ; RET

;LCD39   LD A,(LA214)
;CD3C    AND A
;CD3D    JR Z,@@363
;CD3F    LD A,40
;CD41    JP P,LCD46
;CD44    OR 80
;LCD46   LD C,A
;CD47    LD A,(IX+06)
;CD4A    AND 3F
;CD4C    OR C
;CD4D    LD (IX+06),A
;CD50    LD A,(LA215)
;CD53    PUSH AF
;CD54    XOR A
;CD55    LD (LA215),A
;CD58    CALL LCD85
;CD5B    POP AF
;CD5C    LD (LA215),A
;@@363   LD A,(LA215)
;CD62    AND A
;CD63    RET Z
;CD64    LD A,00
;CD66    JP P,LCD6B
;CD69    OR 80
;LCD6B   LD C,A
;CD6C    LD A,(IX+06)
;CD6F    AND 3F
;CD71    OR C
;CD72    LD (IX+06),A
;CD75    LD A,(LA214)
;CD78    PUSH AF
;CD79    XOR A
;CD7A    LD (LA214),A
;CD7D    CALL LCD89
;CD80    POP AF
;CD81    LD (LA214),A
;CD84    RET

LCD39   lda LA214 ; LD A,(LA214)
        ; AND  A
        jeq @@363 ; JR Z,@@363
        php
        lda #$40 ; LD A,40
        plp
        jpl LCD46 ; JP P,LCD46; SIGN flag read but not set by previous instruction
        ora #$80 ; OR 80
LCD46   sta z80_c ; LD C,A
        ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        and #$3F ; AND 3F
        ora z80_c ; OR C
        ldy #$06 ; LD (IX+06),A
        sta (z80_ix),y
        lda LA215 ; LD A,(LA215)
        pha ; PUSH AF
        php; 
        lda #$00 ; XOR A
        sta LA215 ; LD (LA215),A
        jsr LCD85 ; CALL LCD85
        plp ; POP AF
        pla
        sta LA215 ; LD (LA215),A
@@363   lda LA215 ; LD A,(LA215)
        ; AND  A
        bne *+3 ; RET Z
        rts
        php
        lda #$00 ; LD A,00
        plp
        jpl LCD6B ; JP P,LCD6B; SIGN flag read but not set by previous instruction
        ora #$80 ; OR 80
LCD6B   sta z80_c ; LD C,A
        ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        and #$3F ; AND 3F
        ora z80_c ; OR C
        ldy #$06 ; LD (IX+06),A
        sta (z80_ix),y
        lda LA214 ; LD A,(LA214)
        pha ; PUSH AF
        php
        lda #$00 ; XOR A
        sta LA214 ; LD (LA214),A
        jsr LCD89 ; CALL LCD89
        plp ; POP AF
        pla
        sta LA214 ; LD (LA214),A
        rts ; RET

;LCD85   RES 0,(IX+07)
;LCD89   LD A,(IX+06)
;CD8C    RLCA
;CD8D    RLCA
;CD8E    AND 03
;CD90    LD BC,LCD96
;CD93    JP LC755

LCD85   ldy #$07 ; RES 0,(IX+07)
        lda (z80_ix),y
        and #_notbitvalue0
        sta (z80_ix),y
LCD89   ldy #$06 ; LD A,(IX+06)
        lda (z80_ix),y
        asl @ ; RLCA: this copies bit 7 to bit 0 
        ;asl @ ; RLCA: this copies bit 7 to bit 0 
        rol @
        rol @
        and #$03 ; AND 03
        ldx #<LCD96 ; LD BC,LCD96
        stx z80_c
        ldx #>LCD96
        stx z80_b
        jmp LC755 ; JP LC755 ; uses A as parameter

;LCD96   DW LCD9E,LCE01,LCE64,LCEC9

LCD96   .wo LCD9E,LCE01,LCE64,LCEC9 ; DW LCD9E,LCE01,LCE64,LCEC9

;CD9E    LD L,(IX+01)
;CDA1    LD H,(IX+02)
;CDA4    LD C,(IX+08)
;CDA7    LD B,00
;CDA9    AND A
;CDAA    SBC HL,BC
;CDAC    EX DE,HL
;CDAD    LD L,(IX+03)
;CDB0    LD H,(IX+04)
;CDB3    LD C,(IX+09)
;CDB6    ADD HL,BC
;CDB7    PUSH DE
;CDB8    PUSH HL
;CDB9    CALL LCF2E
;CDBC    POP DE
;CDBD    POP HL
;CDBE    RET C
;CDBF    PUSH HL
;CDC0    PUSH DE
;CDC1    LD C,(IX+08)
;CDC4    SLA C
;CDC6    LD B,00
;CDC8    LD A,H
;CDC9    ADD HL,BC
;CDCA    CP H
;CDCB    JR Z,@@364
;CDCD    EX DE,HL
;CDCE    CALL LCF2E
;CDD1    POP HL
;CDD2    POP DE
;CDD3    RET C
;CDD4    LD A,(LA215)
;CDD7    LD C,A
;CDD8    LD B,00
;CDDA    LD A,H
;CDDB    ADD HL,BC
;CDDC    CP H
;CDDD    RET Z
;CDDE    PUSH DE
;CDDF    PUSH HL
;CDE0    CALL LCF2E
;CDE3    POP DE
;CDE4    POP HL
;CDE5    RET C
;CDE6    LD C,(IX+08)
;CDE9    SLA C
;CDEB    LD B,00
;CDED    ADD HL,BC
;CDEE    EX DE,HL
;CDEF    JP LCF2E

LCD9E   ;ldy #$01 ; LD L,(IX+01)
        ;lda (z80_ix),y
        ;sta z80_l
        ;ldy #$02 ; LD H,(IX+02)
        ;lda (z80_ix),y
        ;sta z80_h
        ;ldy #$08 ; LD C,(IX+08)
        ;lda (z80_ix),y
        ;sta z80_c
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ; AND  A
        ;sec
        ;jsr sbc_hl_bc ; SBC HL,BC
        ;jsr ex_de_hl ; EX DE,HL
		;jsr ld_de_hl
		sec
		ldy #$01
		lda (z80_ix),y
		ldy #$08
		sbc (z80_ix),y
		sta z80_e
		pha
		ldy #$02
		lda (z80_ix),y
		sbc #$00
		sta z80_d
		pha
        ;ldy #$03 ; LD L,(IX+03)
        ;lda (z80_ix),y
        ;sta z80_l
        ;ldy #$04 ; LD H,(IX+04)
        ;lda (z80_ix),y
        ;sta z80_h
        ;ldy #$09 ; LD C,(IX+09)
        ;lda (z80_ix),y
        ;sta z80_c
        ;jsr add_hl_bc ; ADD HL,BC
		clc
		ldy #$03
		lda (z80_ix),y







		ldy #$09
		adc (z80_ix),y
		sta z80_l
		pha
		ldy #$04
		lda (z80_ix),y
		adc #$00
		sta z80_h





		pha
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha

        ;lda z80_l ; PUSH HL
        ;pha

        ;lda z80_h
        ;pha

        jsr LCF2E ; CALL LCF2E
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        bcs *+3 ; RET C
        rts
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        ldy #$08 ; LD C,(IX+08)
        lda (z80_ix),y
        ;sta z80_c
        ;asl z80_c ; SLA C
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;lda z80_h ; LD A,H
        ;tax
		ldx z80_h
		asl @

        ;jsr add_hl_bc ; ADD HL,BC
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
        ;txa

        ;cmp z80_h ; CP H; A read but not set by previous instruction
		cpx z80_h
        jeq @@364 ; JR Z,@@364
        jsr ex_de_hl ; EX DE,HL
        jsr LCF2E ; CALL LCF2E
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        bcs *+3 ; RET C
        rts
        lda LA215 ; LD A,(LA215)
        ;sta z80_c ; LD C,A
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;lda z80_h ; LD A,H
        ;tax
		ldx z80_h

        ;jsr add_hl_bc ; ADD HL,BC
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
        ;txa

        ;cmp z80_h ; CP H
		cpx z80_h
        bne *+3 ; RET Z
        rts
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr LCF2E ; CALL LCF2E
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        bcs *+3 ; RET C
        rts
        ldy #$08 ; LD C,(IX+08)
        lda (z80_ix),y
        ;sta z80_c
        ;asl z80_c ; SLA C
		asl @
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
        jsr ex_de_hl ; EX DE,HL
        jmp LCF2E ; JP LCF2E

;@@364   POP HL
;CDF3    POP DE
;CDF4    LD A,(LA215)
;CDF7    LD C,A
;CDF8    LD B,00
;CDFA    LD A,H
;CDFB    ADD HL,BC
;CDFC    CP H
;CDFD    RET Z
;CDFE    JP LCF2E

@@364   pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        lda LA215 ; LD A,(LA215)
        ;sta z80_c ; LD C,A
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;lda z80_h ; LD A,H
		ldx z80_h
        ;tax

        ;jsr add_hl_bc ; ADD HL,BC
        ;txa

        ;cmp z80_h ; CP H; A read but not set by previous instruction
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
		cpx z80_h
        bne *+3 ; RET Z
        rts
        jmp LCF2E ; JP LCF2E


;CE01    LD L,(IX+01)
;CE04    LD H,(IX+02)
;CE07    LD C,(IX+08)
;CE0A    LD B,00
;CE0C    ADD HL,BC
;CE0D    EX DE,HL
;CE0E    LD L,(IX+03)
;CE11    LD H,(IX+04)
;CE14    LD C,(IX+09)
;CE17    AND A
;CE18    SBC HL,BC
;CE1A    PUSH DE
;CE1B    PUSH HL
;CE1C    CALL LCF49
;CE1F    POP HL
;CE20    POP DE
;CE21    RET C
;CE22    PUSH DE
;CE23    PUSH HL
;CE24    LD C,(IX+09)
;CE27    SLA C
;CE29    LD B,00
;CE2B    LD A,H
;CE2C    ADD HL,BC
;CE2D    CP H
;CE2E    JR Z,@@365
;CE30    CALL LCF49
;CE33    POP DE
;CE34    POP HL
;CE35    RET C
;CE36    LD A,(LA214)
;CE39    LD C,A
;CE3A    LD B,00
;CE3C    LD A,H
;CE3D    ADD HL,BC
;CE3E    CP H
;CE3F    RET Z
;CE40    EX DE,HL
;CE41    PUSH DE
;CE42    PUSH HL
;CE43    CALL LCF49
;CE46    POP HL
;CE47    POP DE
;CE48    RET C
;CE49    LD C,(IX+09)
;CE4C    SLA C
;CE4E    LD B,00
;CE50    ADD HL,BC
;CE51    JP LCF49

LCE01   ldy #$01 ; LD L,(IX+01)
        lda (z80_ix),y
        sta z80_l
        ldy #$02 ; LD H,(IX+02)
        lda (z80_ix),y
        sta z80_h
        ldy #$08 ; LD C,(IX+08)
        lda (z80_ix),y
        sta z80_c
        lda #$00 ; LD B,00
        sta z80_b
        jsr add_hl_bc ; ADD HL,BC

        ;jsr ex_de_hl ; EX DE,HL
        jsr ld_de_hl
	
	ldy #$03 ; LD L,(IX+03)
        lda (z80_ix),y
        sta z80_l
        ldy #$04 ; LD H,(IX+04)
        lda (z80_ix),y
        sta z80_h
        ldy #$09 ; LD C,(IX+09)
        lda (z80_ix),y
        sta z80_c
        ; AND  A
        sec
        jsr sbc_hl_bc ; SBC HL,BC
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr LCF49 ; CALL LCF49
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        bcs *+3 ; RET C
        rts
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        ldy #$09 ; LD C,(IX+09)
        lda (z80_ix),y
        sta z80_c
        asl z80_c ; SLA C
        lda #$00 ; LD B,00
        sta z80_b
        lda z80_h ; LD A,H
        tax
        jsr add_hl_bc ; ADD HL,BC
        txa
        cmp z80_h ; CP H; A read but not set by previous instruction
        jeq @@365 ; JR Z,@@365
        jsr LCF49 ; CALL LCF49
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        bcs *+3 ; RET C
        rts; 
        lda LA214 ; LD A,(LA214)
        sta z80_c ; LD C,A
        lda #$00 ; LD B,00
        sta z80_b
        lda z80_h ; LD A,H
        tax
        jsr add_hl_bc ; ADD HL,BC
        txa
        cmp z80_h ; CP H; A read but not set by previous instruction
        bne *+3 ; RET Z
        rts
        jsr ex_de_hl ; EX DE,HL
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr LCF49 ; CALL LCF49
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        bcs *+3 ; RET C
        rts
        ldy #$09 ; LD C,(IX+09)
        lda (z80_ix),y
        sta z80_c
        asl z80_c ; SLA C
        lda #$00 ; LD B,00
        sta z80_b
        jsr add_hl_bc ; ADD HL,BC
        jmp LCF49 ; JP LCF49

;@@365   POP DE
;CE55    POP HL
;CE56    LD A,(LA214)
;CE59    LD C,A
;CE5A    LD B,00
;CE5C    LD A,H
;CE5D    ADD HL,BC
;CE5E    CP H
;CE5F    RET Z
;CE60    EX DE,HL
;CE61    JP LCF49

@@365   pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        lda LA214 ; LD A,(LA214)
        sta z80_c ; LD C,A
        lda #$00 ; LD B,00
        sta z80_b
        lda z80_h ; LD A,H
        tax
        jsr add_hl_bc ; ADD HL,BC
        txa
        cmp z80_h ; CP H; A read but not set by previous instruction
        bne *+3 ; RET Z
        rts
        jsr ex_de_hl ; EX DE,HL
        jmp LCF49 ; JP LCF49

;CE64    LD L,(IX+01)
;CE67    LD H,(IX+02)
;CE6A    LD C,(IX+08)
;CE6D    LD B,00
;CE6F    AND A
;CE70    SBC HL,BC
;CE72    EX DE,HL
;CE73    LD L,(IX+03)
;CE76    LD H,(IX+04)
;CE79    LD C,(IX+09)
;CE7C    AND A
;CE7D    SBC HL,BC
;CE7F    PUSH DE
;CE80    PUSH HL
;CE81    CALL LCF41
;CE84    POP DE
;CE85    POP HL
;CE86    RET C
;CE87    PUSH HL
;CE88    PUSH DE
;CE89    LD C,(IX+08)
;CE8C    SLA C
;CE8E    LD B,00
;CE90    LD A,H
;CE91    ADD HL,BC
;CE92    CP H
;CE93    JR Z,@@366
;CE95    EX DE,HL
;CE96    CALL LCF41
;CE99    POP HL
;CE9A    POP DE
;CE9B    RET C
;CE9C    LD A,(LA215)
;CE9F    LD C,A
;CEA0    LD B,FF
;CEA2    LD A,H
;CEA3    ADD HL,BC
;CEA4    CP H
;CEA5    RET Z
;CEA6    PUSH DE
;CEA7    PUSH HL
;CEA8    CALL LCF41
;CEAB    POP DE
;CEAC    POP HL
;CEAD    RET C
;CEAE    LD C,(IX+08)
;CEB1    SLA C
;CEB3    LD B,00
;CEB5    ADD HL,BC
;CEB6    EX DE,HL
;CEB7    JP LCF41

LCE64   ldy #$01 ; LD L,(IX+01)
        lda (z80_ix),y
        sta z80_l
        ldy #$02 ; LD H,(IX+02)
        lda (z80_ix),y
        sta z80_h
        ldy #$08 ; LD C,(IX+08)
        lda (z80_ix),y
        sta z80_c
        lda #$00 ; LD B,00
        sta z80_b
        ; AND  A
        sec
        jsr sbc_hl_bc ; SBC HL,BC

        ;jsr ex_de_hl ; EX DE,HL
	jsr ld_de_hl
        ldy #$03 ; LD L,(IX+03)
        lda (z80_ix),y
        sta z80_l
        ldy #$04 ; LD H,(IX+04)
        lda (z80_ix),y
        sta z80_h
        ldy #$09 ; LD C,(IX+09)
        lda (z80_ix),y
        sta z80_c
        ; AND  A
        sec
        jsr sbc_hl_bc ; SBC HL,BC
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr LCF41 ; CALL LCF41
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        bcs *+3 ; RET C
        rts; 
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        ldy #$08 ; LD C,(IX+08)
        lda (z80_ix),y
        sta z80_c
        asl z80_c ; SLA C
        lda #$00 ; LD B,00
        sta z80_b
        lda z80_h ; LD A,H
        tax
        jsr add_hl_bc ; ADD HL,BC
        txa
        cmp z80_h ; CP H
        jeq @@366 ; JR Z,@@366
        jsr ex_de_hl ; EX DE,HL
        jsr LCF41 ; CALL LCF41
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        bcs *+3 ; RET C
        rts
        lda LA215 ; LD A,(LA215)
        sta z80_c ; LD C,A
        lda #$FF ; LD B,FF
        sta z80_b
        lda z80_h ; LD A,H
        tax
        jsr add_hl_bc ; ADD HL,BC
        txa
        cmp z80_h ; CP H; A read but not set by previous instruction
        bne *+3 ; RET Z
        rts
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr LCF41 ; CALL LCF41
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        bcs *+3 ; RET C
        rts
        ldy #$08 ; LD C,(IX+08)
        lda (z80_ix),y
        sta z80_c
        asl z80_c ; SLA C
        lda #$00 ; LD B,00
        sta z80_b
        jsr add_hl_bc ; ADD HL,BC
        jsr ex_de_hl ; EX DE,HL
        jmp LCF41 ; JP LCF41

;@@366   POP HL
;CEBB    POP DE
;CEBC    LD A,(LA215)
;CEBF    LD C,A
;CEC0    LD B,FF
;CEC2    LD A,H
;CEC3    ADD HL,BC
;CEC4    CP H
;CEC5    RET Z
;CEC6    JP LCF41

@@366   pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        lda LA215 ; LD A,(LA215)
        sta z80_c ; LD C,A
        lda #$FF ; LD B,FF
        sta z80_b
        lda z80_h ; LD A,H
        tax
        jsr add_hl_bc ; ADD HL,BC
        txa
        cmp z80_h ; CP H
        bne *+3 ; RET Z
        rts
        jmp LCF41 ; JP LCF41

;CEC9    LD L,(IX+01)
;CECC    LD H,(IX+02)
;CECF    LD C,(IX+08)
;CED2    LD B,00
;CED4    AND A
;CED5    SBC HL,BC
;CED7    EX DE,HL
;CED8    LD L,(IX+03)
;CEDB    LD H,(IX+04)
;CEDE    LD C,(IX+09)
;CEE1    AND A
;CEE2    SBC HL,BC
;CEE4    PUSH DE
;CEE5    PUSH HL
;CEE6    CALL LCF58
;CEE9    POP HL
;CEEA    POP DE
;CEEB    RET C
;CEEC    PUSH DE
;CEED    PUSH HL
;CEEE    LD C,(IX+09)
;CEF1    SLA C
;CEF3    LD B,00
;CEF5    LD A,H
;CEF6    ADD HL,BC
;CEF7    CP H
;CEF8    JR Z,@@367
;CEFA    CALL LCF58
;CEFD    POP DE
;CEFE    POP HL
;CEFF    RET C
;CF00    LD A,(LA214)
;CF03    LD C,A
;CF04    LD B,FF
;CF06    LD A,H
;CF07    ADD HL,BC
;CF08    CP H
;CF09    RET Z
;CF0A    EX DE,HL
;CF0B    PUSH DE
;CF0C    PUSH HL
;CF0D    CALL LCF58
;CF10    POP HL
;CF11    POP DE
;CF12    RET C
;CF13    LD C,(IX+09)
;CF16    SLA C
;CF18    LD B,00
;CF1A    ADD HL,BC
;CF1B    JP LCF58

LCEC9   ;ldy #$01 ; LD L,(IX+01)
        ;lda (z80_ix),y
        ;sta z80_l
        ;ldy #$02 ; LD H,(IX+02)
        ;lda (z80_ix),y
        ;sta z80_h
        ;ldy #$08 ; LD C,(IX+08)
        ;lda (z80_ix),y
        ;sta z80_c
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ; AND  A
        ;sec
        ;jsr sbc_hl_bc ; SBC HL,BC
        ;jsr ex_de_hl ; EX DE,HL
		;jsr ld_de_hl
		sec
		ldy #$01
		lda (z80_ix),y
		ldy #$08
		sbc (z80_ix),y
		sta z80_e
		pha
		ldy #$02
		lda (z80_ix),y
		sbc #$00
		sta z80_d
		pha
        ;ldy #$03 ; LD L,(IX+03)
        ;lda (z80_ix),y
        ;sta z80_l
        ;ldy #$04 ; LD H,(IX+04)
        ;lda (z80_ix),y
        ;sta z80_h
        ;ldy #$09 ; LD C,(IX+09)
        ;lda (z80_ix),y

        ;sta z80_c
        ; AND  A
        ;sec
        ;jsr sbc_hl_bc ; SBC HL,BC
		sec


		ldy #$03
		lda (z80_ix),y
		ldy #$09
		sbc (z80_ix),y
		sta z80_l
		pha
		ldy #$04
		lda (z80_ix),y
		sbc #$00
		sta z80_h







		pha
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha

        ;lda z80_l ; PUSH HL
        ;pha

        ;lda z80_h
        ;pha

        jsr LCF58 ; CALL LCF58
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        bcs *+3 ; RET C
        rts; 
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        ldy #$09 ; LD C,(IX+09)
        lda (z80_ix),y
        ;sta z80_c
        ;asl z80_c ; SLA C
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;lda z80_h ; LD A,H
        ;tax
		ldx z80_h
		asl @
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h

        ;jsr add_hl_bc ; ADD HL,BC
        ;txa

        ;cmp z80_h ; CP H; A read but not set by previous instruction
		cpx z80_h
        jeq @@367 ; JR Z,@@367
        jsr LCF58 ; CALL LCF58
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        bcs *+3 ; RET C
        rts;
        lda LA214 ; LD A,(LA214)
        ;sta z80_c ; LD C,A
        ;lda #$FF ; LD B,FF
        ;sta z80_b
        ;lda z80_h ; LD A,H
        ;tax
		ldx z80_h
		clc
		adc z80_l
		sta z80_l
		lda #$ff
		adc z80_h
		sta z80_h

        ;jsr add_hl_bc ; ADD HL,BC
        ;txa

        ;cmp z80_h ; CP H
		cpx z80_h
        bne *+3 ; RET Z
        rts
        jsr ex_de_hl ; EX DE,HL
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr LCF58 ; CALL LCF58
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        bcs *+3 ; RET C
        rts
        ldy #$09 ; LD C,(IX+09)
        lda (z80_ix),y
        ;sta z80_c
        ;asl z80_c ; SLA C
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
        jmp LCF58 ; JP LCF58


;@@367   POP DE
;CF1F    POP HL
;CF20    LD A,(LA214)
;CF23    LD C,A
;CF24    LD B,FF
;CF26    LD A,H
;CF27    ADD HL,BC
;CF28    CP H
;CF29    RET Z
;CF2A    EX DE,HL
;CF2B    JP LCF58

@@367   pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        lda LA214 ; LD A,(LA214)
        sta z80_c ; LD C,A
        lda #$FF ; LD B,FF
        sta z80_b
        lda z80_h ; LD A,H
        tax
        jsr add_hl_bc ; ADD HL,BC
        txa
        cmp z80_h ; CP H; A read but not set by previous instruction
        bne *+3 ; RET Z
        rts
        jsr ex_de_hl ; EX DE,HL
        jmp LCF58 ; JP LCF58

;LCF2E   CALL LCFD7
;CF31    RET NC
;@@368   ADD A,A
;CF33    LD C,A
;CF34    LD A,(LA215)
;CF37    ADD A,C
;CF38    LD (LA215),A
;@@369   SET 0,(IX+07)
;CF3F    SCF
;CF40    RET

LCF2E   jsr LCFD7 ; CALL LCFD7 ; set A on return ; 
        bcc *+3 ; RET NC
        rts
@@368   asl @ ; ADD A,A; A read but not set by previous instruction
        sta z80_c ; LD C,A
        lda LA215 ; LD A,(LA215)
        clc ; ADD A,C
        adc z80_c
        sta LA215 ; LD (LA215),A
@@369   ldy #$07 ; SET 0,(IX+07)
        lda (z80_ix),y
        ora #_bitvalue0
        sta (z80_ix),y
        ;sec ; SCF
        clc ; C flag checked at return, invert by convention
        rts ; RET

;LCF41   CALL LCFD7
;CF44    RET NC
;CF45    NEG
;CF47    JR @@368

LCF41   jsr LCFD7 ; CALL LCFD7 ; sets C flag at return ; 
        bcc *+3 ; RET NC
        rts
        eor #$ff ; NEG
        clc
        adc #$01
        jmp @@368 ; JR @@368

;LCF49   CALL LCF9A
;CF4C    RET NC
;@@370   ADD A,A
;CF4E    LD C,A
;CF4F    LD A,(LA214)
;CF52    ADD A,C
;CF53    LD (LA214),A
;CF56    JR @@369

LCF49   jsr LCF9A ; CALL LCF9A 
        bcc *+3 ; RET NC
        rts; CARRY flag read but not set by previous instruction
@@370   asl @ ; ADD A,A; A read but not set by previous instruction
        sta z80_c ; LD C,A
        lda LA214 ; LD A,(LA214)
        clc ; ADD A,C
        adc z80_c
        sta LA214 ; LD (LA214),A
        jmp @@369 ; JR @@369

;LCF58   CALL LCF9A
;CF5B    RET NC
;CF5C    NEG
;CF5E    JR @@370

LCF58   jsr LCF9A ; CALL LCF9A ; 
        bcc *+3 ; RET NC
        rts; CARRY flag read but not set by previous instruction
        eor #$ff ; NEG
        clc
        adc #$01; A read but not set by previous instruction
        jmp @@370 ; JR @@370

;LCF60   LD B,H
;CF61    LD C,D
;CF62    PUSH BC
;CF63    LD C,00
;CF65    LD E,C
;CF66    LD L,(IX+01)
;CF69    LD H,(IX+02)
;CF6C    AND A
;CF6D    SBC HL,DE
;CF6F    SRL H
;CF71    RR L
;CF73    LD A,L
;CF74    ADD A,40
;CF76    LD E,A
;CF77    LD L,(IX+03)
;CF7A    LD H,(IX+04)
;CF7D    AND A
;CF7E    SBC HL,BC
;CF80    SRL H
;CF82    RR L
;CF84    LD A,L
;CF85    ADD A,40
;CF87    LD D,A
;CF88    POP HL
;CF89    LD A,L
;CF8A    LD L,H
;CF8B    LD H,00
;CF8D    ADD HL,HL
;CF8E    ADD HL,HL
;CF8F    ADD HL,HL
;CF90    ADD HL,HL
;CF91    OR L
;CF92    LD L,A
;CF93    LD BC,L5FB1
;CF96    ADD HL,BC
;CF97    LD A,(HL)
;CF98    AND A
;CF99    RET

LCF60   ;lda z80_h ; LD B,H
        ;sta z80_b
        lda z80_d ; LD C,D
        ;sta z80_c


		pha
        ;lda z80_c ; PUSH BC
        ;pha
        ;lda z80_b
        ;pha
		lda z80_h
		sta z80_b

		pha
        lda #$00 ; LD C,00
        sta z80_c
        ;lda z80_c ; LD E,C
        sta z80_e
        ldy #$01 ; LD L,(IX+01)
        lda (z80_ix),y
        sta z80_l
        ;ldy #$02 ; LD H,(IX+02)
		iny
        lda (z80_ix),y
        ;sta z80_h
        ; AND  A
        sec
        ;jsr sbc_hl_de ; SBC HL,DE ; E = 0 here
		sbc z80_d
		;sta z80_h
        ;lsr z80_h ; SRL H
		lsr @
		sta z80_h
        ror z80_l ; RR L
        lda z80_l ; LD A,L
        clc ; ADD A,40
        adc #$40
        sta z80_e ; LD E,A
        ;ldy #$03 ; LD L,(IX+03)
		iny
        lda (z80_ix),y
        sta z80_l
        ;ldy #$04 ; LD H,(IX+04)
		iny
        lda (z80_ix),y
        ;sta z80_h
        ; AND  A
        sec
        ;jsr sbc_hl_bc ; SBC HL,BC ; C = 0 here
		sbc z80_b
		lsr @
		sta z80_h
        ;lsr z80_h ; SRL H
        ror z80_l ; RR L
        lda z80_l ; LD A,L
        clc ; ADD A,40
        adc #$40
        sta z80_d ; LD D,A
        pla ; POP HL
        sta z80_h
        pla
        sta z80_l
		sta z80_a
        ;lda z80_l ; LD A,L
        lda z80_h ; LD L,H
        ;stx z80_l
        ldx #$00 ; LD H,00
        stx z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;ora z80_l ; OR L; A read but not set by previous instruction
        ;sta z80_l ; LD L,A
		ora z80_a
        ;lda #<L5FB1 ; LD BC,L5FB1
        ;sta z80_c
        ;lda #>L5FB1
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
		adc #<L5FB1
		sta z80_l
		lda z80_h
		adc #>L5FB1
		sta z80_h
        ldy #$00 ; LD A,(HL)
        lda (z80_hl),y
        ; AND  A
        rts ; RET


;LCF9A   CALL LCF60
;CF9D    LD BC,L6151
;CFA0    CALL LC74B
;CFA3    PUSH HL
;CFA4    POP IY
;@@371   LD A,(IY+00)
;CFA9    AND A
;CFAA    RET Z
;CFAB    CALL LCFFB
;CFAE    JR NC,@@372
;CFB0    CALL LCFBE
;CFB3    RET C
;@@372   INC IY
;CFB6    INC IY
;CFB8    INC IY
;CFBA    INC IY
;CFBC    JR @@371

LCF9A   jsr LCF60 ; CALL LCF60 ; A read at the beginning of the block ; returns C flag ; returns A
        ;ldx #<L6151 ; LD BC,L6151
        ;stx z80_c
        ;ldx #>L6151
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
        ;lda z80_l ; PUSH HL
        ;pha

        ;lda z80_h
        ;pha

        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		asl @
		tax
		lda L6151,x
		sta z80_l
		sta z80_iy
		lda L6151+1,x
		sta z80_h
		sta z80_iy+1

@@371   ldy #$00 ; LD A,(IY+00)
        lda (z80_iy),y
        ; AND  A
        bne *+4 ; RET Z
        sec
        rts
        jsr LCFFB ; CALL LCFFB
        jcs @@372 ; JR NC,@@372
        jsr LCFBE ; CALL LCFBE
        bcs *+3 ; RET C
        rts
@@372   ;inc z80_iy ; INC IY
        ;bne *+4
        ;inc z80_iy+1
        ;inc z80_iy ; INC IY
        ;bne *+4
        ;inc z80_iy+1
        ;inc z80_iy ; INC IY
        ;bne *+4
        ;inc z80_iy+1
        ;inc z80_iy ; INC IY
        ;bne *+4
        ;inc z80_iy+1
		lda #$04
		clc
		adc z80_iy
		sta z80_iy
		scc:inc z80_iy+1
        jmp @@371 ; JR @@371


;LCFBE   LD A,(IX+08)
;CFC1    SRL A
;CFC3    ADD A,(IY+02)
;CFC6    LD C,A
;CFC7    LD A,(LA214)
;CFCA    SRA A
;CFCC    ADD A,E
;CFCD    SUB (IY+00)
;CFD0    JP P,LCFD5
;CFD3    NEG
;LCFD5   SUB C
;CFD6    RET

LCFBE   ldy #$08 ; LD A,(IX+08)
        lda (z80_ix),y
        lsr @ ; SRL A
        ldy #$02 ; ADD A,(IY+02)
        clc
        adc (z80_iy),y
        sta z80_c ; LD C,A
        lda LA214 ; LD A,(LA214)
        cmp #$80 ; SRA A
        ror @
        clc ; ADD A,E
        adc z80_e
        ldy #$00 ; SUB (IY+00)
        sec
        sbc (z80_iy),y
        jpl LCFD5 ; JP P,LCFD5
        eor #$ff ; NEG
        clc
        adc #$01
LCFD5   sec ; SUB C
        sbc z80_c
        rts ; RET

;LCFD7   CALL LCF60
;CFDA    LD BC,L6151
;CFDD    CALL LC74B
;CFE0    PUSH HL
;CFE1    POP IY
;@@373   LD A,(IY+00)
;CFE6    AND A
;CFE7    RET Z
;CFE8    CALL LCFBE
;CFEB    JR NC,@@374
;CFED    CALL LCFFB
;CFF0    RET C
;@@374   INC IY
;CFF3    INC IY
;CFF5    INC IY
;CFF7    INC IY
;CFF9    JR @@373

LCFD7   jsr LCF60 ; CALL LCF60; info: LCFD7 sets C flag at return
        ;ldx #<L6151 ; LD BC,L6151
        ;stx z80_c
        ;ldx #>L6151
        ;stx z80_b
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;pla ; POP IY
        ;sta z80_iy+1
        ;pla
		asl @
		tax
		lda L6151,x

		sta z80_l
		sta z80_iy
		lda L6151+1,x
		sta z80_h
		sta z80_iy+1		


@@373   ldy #$00 ; LD A,(IY+00)
        lda (z80_iy),y
        ; AND  A
        bne *+4 ; RET Z
        sec
        rts
        jsr LCFBE ; CALL LCFBE
        jcs @@374 ; JR NC,@@374
        jsr LCFFB ; CALL LCFFB
        bcs *+3 ; RET C
        rts;
@@374   ;inc z80_iy ; INC IY
        ;bne *+4
        ;inc z80_iy+1
        ;inc z80_iy ; INC IY
        ;bne *+4
        ;inc z80_iy+1
        ;inc z80_iy ; INC IY
        ;bne *+4
        ;inc z80_iy+1
        ;inc z80_iy ; INC IY
        ;bne *+4
        ;inc z80_iy+1
		lda #$04
		clc
		adc z80_iy
		sta z80_iy
		scc:inc z80_iy+1
        jmp @@373 ; JR @@373

;LCFFB   LD A,(IX+09)
;CFFE    SRL A
;D000    ADD A,(IY+03)
;D003    LD C,A
;D004    LD A,(LA215)
;D007    SRA A
;D009    ADD A,D
;D00A    SUB (IY+01)
;D00D    JP P,LD012
;D010    NEG
;LD012   SUB C
;D013    RET

LCFFB   ldy #$09 ; LD A,(IX+09)
        lda (z80_ix),y
        lsr @ ; SRL A
        ldy #$03 ; ADD A,(IY+03)
        clc
        adc (z80_iy),y
        sta z80_c ; LD C,A
        lda LA215 ; LD A,(LA215)
        cmp #$80 ; SRA A
        ror @
        clc ; ADD A,D
        adc z80_d
        ldy #$01 ; SUB (IY+01)
        sec
        sbc (z80_iy),y
        jpl LD012 ; JP P,LD012
        eor #$ff ; NEG
        clc
        adc #$01
LD012   sec ; SUB C
        sbc z80_c
        rts ; RET

;LD014   LD A,L
;D015    CPL
;D016    LD L,A
;D017    LD A,H
;D018    CPL
;D019    LD H,A
;D01A    INC HL
;D01B    RET

LD014   lda z80_l ; LD A,L
        eor #$ff ; CPL
        sta z80_l ; LD L,A
        lda z80_h ; LD A,H
        eor #$ff ; CPL
        sta z80_h ; LD H,A
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        rts ; RET

;LD01C   LD L,A
;D01D    XOR A
;D01E    BIT 7,L
;D020    JR Z,@@375
;D022    CPL
;@@375   LD H,A
;D024    RET

LD01C   sta z80_l ; LD L,A; A read at the beginning of the block
        lda #$00 ; XOR A
        ;lda z80_l ; BIT 7,L
        ;bit _bitmem7
        bit z80_l
        ;jeq @@375 ; JR Z,@@375
        jpl @@375
        eor #$ff ; CPL; A read but not set by previous instruction
@@375   sta z80_h ; LD H,A
        rts ; RET

;LD025   AND A
;D026    JP M,LD030
;D029    ADD A,L
;D02A    LD L,A
;D02B    LD A,H
;D02C    ADC A,00
;D02E    LD H,A
;D02F    RET

LD025   ; AND  A; A read at the beginning of the block
        ;jmi LD030 ; JP M,LD030
		cmp #$80
		bcs LD030
		stx z80_l
        clc ; ADD A,L
        adc z80_l; 
        ;sta z80_l ; LD L,A
		tax
        ;lda z80_h ; LD A,H
        ;adc #$00 ; ADC A,00
        ;sta z80_h ; LD H,A
		scc:iny
        rts ; RET

;LD030   ADD A,L
;D031    LD L,A
;D032    LD A,H
;D033    ADC A,FF
;D035    LD H,A
;D036    RET

LD030   stx z80_l
		clc ; ADD A,L

        adc z80_l; A read at the beginning of the block
        ;sta z80_l ; LD L,A
		tax
        ;lda z80_h ; LD A,H
		tya
        adc #$FF ; ADC A,FF
        ;sta z80_h ; LD H,A
		tay
        rts ; RET


;D037    DB 21,00,00,06,08,29,07,30 ; !....).0
;D03F    DB 01,19,10,F9,C9

        ;.he 21,00,00,06,08,29,07,30 ; DB 21,00,00,06,08,29,07,30
        ;.he 01,19,10,F9,C9 ; DB 01,19,10,F9,C9

;LD044   LD (LA21D),SP
;D048    LD HL,L4FDB
;D04B    CALL LD26B
;D04E    LD SP,HL
;D04F    LD B,70
;D051    LD HL,LD6FB
;@@376   LD D,(HL)
;D055    DEC HL
;D056    LD E,(HL)
;D057    DEC HL
;D058    PUSH DE
;D059    LD D,(HL)
;D05A    DEC HL
;D05B    LD E,(HL)
;D05C    DEC HL
;D05D    PUSH DE
;D05E    LD D,(HL)
;D05F    DEC HL
;D060    LD E,(HL)
;D061    DEC HL
;D062    PUSH DE
;D063    LD D,(HL)
;D064    DEC HL
;D065    LD E,(HL)
;D066    DEC HL
;D067    PUSH DE
;D068    LD D,(HL)
;D069    DEC HL
;D06A    LD E,(HL)
;D06B    DEC HL
;D06C    PUSH DE
;D06D    LD D,(HL)
;D06E    DEC HL
;D06F    LD E,(HL)
;D070    DEC HL
;D071    PUSH DE
;D072    LD D,(HL)
;D073    DEC HL
;D074    LD E,(HL)
;D075    DEC HL
;D076    PUSH DE
;D077    LD D,(HL)
;D078    DEC HL
;D079    LD E,(HL)
;D07A    DEC HL
;D07B    PUSH DE
;D07C    LD D,(HL)
;D07D    DEC HL
;D07E    LD E,(HL)
;D07F    DEC HL
;D080    PUSH DE
;D081    LD D,(HL)
;D082    DEC HL
;D083    LD E,(HL)
;D084    DEC HL
;D085    PUSH DE
;D086    LD D,(HL)
;D087    DEC HL
;D088    LD E,(HL)
;D089    PUSH DE
;D08A    EX DE,HL
;D08B    LD HL,LFF16
;D08E    ADD HL,SP
;D08F    LD A,H
;D090    CPL
;D091    AND 07
;D093    JP NZ,LD0A1
;D096    LD A,L
;D097    SUB 20
;D099    LD L,A
;D09A    JP C,LD0A1
;D09D    LD A,H
;D09E    ADD A,08
;D0A0    LD H,A
;LD0A1   LD SP,HL
;D0A2    LD HL,L002D
;D0A5    ADD HL,DE
;D0A6    DJNZ @@376
;D0A8    LD SP,(LA21D)
;D0AC    RET


		
;LD0AD   CALL LD044
;LD0B0   LD HL,LE164
;D0B3    LD DE,L0000
;D0B6    LD B,70
;D0B8    LD (LA21D),SP
;D0BC    LD SP,HL
;@@377   PUSH DE
;D0BE    PUSH DE
;D0BF    PUSH DE
;D0C0    PUSH DE
;D0C1    PUSH DE
;D0C2    PUSH DE
;D0C3    PUSH DE
;D0C4    PUSH DE
;D0C5    PUSH DE
;D0C6    PUSH DE
;D0C7    PUSH DE
;D0C8    PUSH DE
;D0C9    DJNZ @@377
;D0CB    LD HL,L0000
;D0CE    ADD HL,SP
;D0CF    LD SP,(LA21D)
;D0D3    RET


X_Table_Count	

		dta 000,008,016,024,032,040,048,056,064,072,080,088,096,104,112,120
		dta 128,136,144,152,160,168

CurrentCopyMode dta 0

; update screen
BlitBufferToScreenAndClearBuffer

		jsr FrameSync

		lda game_on
		cmp CurrentCopyMode
		beq CopyLoopStart
; update
		sta CurrentCopyMode
		;clc
		;adc #$05
		;sta z80_a
		
		; works out poss in memory for each screen poss which needs to be modifed
		; only runs when game window has changed poss - bonus game into main game etc.
		lda #<[CopyLoop+4]
		sta z80_l
		lda #>[CopyLoop+4]
		sta z80_h
		
		;inc $01
		;inc border
		;dec $01
		
		ldy #$0
		ldx #$70
CopyUpdateLoop
		
		lda CurrentCopyMode
		beq bonus_mode
		
		; in game window poss
		lda (z80_hl),y
		;and #$f0
		;ora z80_a
		clc
		adc #$20		; difference
		sta (z80_hl),y
		jmp mode_out
		
bonus_mode		
		
		; bonus game window poss
		lda (z80_hl),y
		;and #$f0
		;ora z80_a
		sec
		sbc #$20		; difference
		sta (z80_hl),y

mode_out
		
		tya
		clc
		adc #$06
		tay
		scc:inc z80_h
		dex
		bne CopyUpdateLoop

CopyLoopStart		
		
		ldx #21

		
; bonus game screen blit (start poss but gets modifed when needed)
; rolled out for speed	
buildscreen000
	
		ldy  X_Table_Count,x

CopyLoop		
		lda $f482-$480,x
		sta $d1cf,y
		lda $f49a-$480,x
		sta $d1ce,y
		lda $f4b2-$480,x
		sta $d1cd,y	
	    lda $f4ca-$480,x
		sta $d1cc,y		
		lda $f4e2-$480,x
		sta $d1cb,y
		lda $f4fa-$480,x
		sta $d1ca,y
		lda $f512-$480,x
		sta $d1c9,y
		lda $f52a-$480,x
		sta $d1c8,y
		
		lda $f542-$480,x
		sta $d08f,y
		lda $f55a-$480,x
		sta $d08e,y
		lda $f572-$480,x
		sta $d08d,y	
	    lda $f58a-$480,x
		sta $d08c,y		
		lda $f5a2-$480,x
		sta $d08b,y
		lda $f5ba-$480,x
		sta $d08a,y
		lda $f5d2-$480,x
		sta $d089,y
		lda $f5ea-$480,x
		sta $d088,y

		lda $f602-$480,x
		sta $cf4f,y
		lda $f61a-$480,x
		sta $cf4e,y
		lda $f632-$480,x
		sta $cf4d,y	
	    lda $f64a-$480,x
		sta $cf4c,y		
		lda $f662-$480,x
		sta $cf4b,y
		lda $f67a-$480,x
		sta $cf4a,y
		lda $f692-$480,x
		sta $cf49,y
		lda $f6aa-$480,x
		sta $cf48,y		

		lda $f6c2-$480,x
		sta $ce0f,y
		lda $f6da-$480,x
		sta $ce0e,y
		lda $f6f2-$480,x
		sta $ce0d,y	
	    lda $f70a-$480,x
		sta $ce0c,y		
		lda $f722-$480,x
		sta $ce0b,y
		lda $f73a-$480,x
		sta $ce0a,y
		lda $f752-$480,x
		sta $ce09,y
		lda $f76a-$480,x
		sta $ce08,y			

		lda $f782-$480,x
		sta $cccf,y
		lda $f79a-$480,x
		sta $ccce,y
		lda $f7b2-$480,x
		sta $cccd,y	
	    lda $f7ca-$480,x
		sta $cccc,y		
		lda $f7e2-$480,x
		sta $cccb,y
		lda $f7fa-$480,x
		sta $ccca,y
		lda $f812-$480,x
		sta $ccc9,y
		lda $f82a-$480,x
		sta $ccc8,y

		lda $f842-$480,x
		sta $cb8f,y
		lda $f85a-$480,x
		sta $cb8e,y
		lda $f872-$480,x
		sta $cb8d,y	
	    lda $f88a-$480,x
		sta $cb8c,y		
		lda $f8a2-$480,x
		sta $cb8b,y
		lda $f8ba-$480,x
		sta $cb8a,y
		lda $f8d2-$480,x
		sta $cb89,y
		lda $f8ea-$480,x
		sta $cb88,y		

		lda $f902-$480,x
		sta $ca4f,y
		lda $f91a-$480,x
		sta $ca4e,y
		lda $f932-$480,x
		sta $ca4d,y	
	    lda $f94a-$480,x
		sta $ca4c,y		
		lda $f962-$480,x
		sta $ca4b,y
		lda $f97a-$480,x
		sta $ca4a,y
		lda $f992-$480,x
		sta $ca49,y
		lda $f9aa-$480,x
		sta $ca48,y		

		lda $f9c2-$480,x
		sta $c90f,y
		lda $f9da-$480,x
		sta $c90e,y
		lda $f9f2-$480,x
		sta $c90d,y	
	    lda $fa0a-$480,x
		sta $c90c,y		
		lda $fa22-$480,x
		sta $c90b,y
		lda $fa3a-$480,x
		sta $c90a,y
		lda $fa52-$480,x
		sta $c909,y
		lda $fa6a-$480,x
		sta $c908,y

		lda $fa82-$480,x
		sta $c7cf,y
		lda $fa9a-$480,x
		sta $c7ce,y
		lda $fab2-$480,x
		sta $c7cd,y	
	    lda $faca-$480,x
		sta $c7cc,y		
		lda $fae2-$480,x
		sta $c7cb,y
		lda $fafa-$480,x
		sta $c7ca,y
		lda $fb12-$480,x
		sta $c7c9,y
		lda $fb2a-$480,x
		sta $c7c8,y		
	
		lda $fb42-$480,x
		sta $c68f,y
		lda $fb5a-$480,x
		sta $c68e,y
		lda $fb72-$480,x
		sta $c68d,y	
	    lda $fb8a-$480,x
		sta $c68c,y		
		lda $fba2-$480,x
		sta $c68b,y
		lda $fbba-$480,x
		sta $c68a,y
		lda $fbd2-$480,x
		sta $c689,y
		lda $fbea-$480,x
		sta $c688,y
		
		lda $fc02-$480,x
		sta $c54f,y
		lda $fc1a-$480,x
		sta $c54e,y
		lda $fc32-$480,x
		sta $c54d,y	
	    lda $fc4a-$480,x
		sta $c54c,y		
		lda $fc62-$480,x
		sta $c54b,y
		lda $fc7a-$480,x
		sta $c54a,y
		lda $fc92-$480,x
		sta $c549,y
		lda $fcaa-$480,x
		sta $c548,y		

		lda $fcc2-$480,x
		sta $c40f,y
		lda $fcda-$480,x
		sta $c40e,y
		lda $fcf2-$480,x
		sta $c40d,y	
	    lda $fd0a-$480,x
		sta $c40c,y		
		lda $fd22-$480,x
		sta $c40b,y
		lda $fd3a-$480,x
		sta $c40a,y
		lda $fd52-$480,x
		sta $c409,y
		lda $fd6a-$480,x
		sta $c408,y	

		lda $fd82-$480,x
		sta $c2cf,y
		lda $fd9a-$480,x
		sta $c2ce,y
		lda $fdb2-$480,x
		sta $c2cd,y	
	    lda $fdca-$480,x
		sta $c2cc,y		
		lda $fde2-$480,x
		sta $c2cb,y
		lda $fdfa-$480,x
		sta $c2ca,y
		lda $fe12-$480,x
		sta $c2c9,y
		lda $fe2a-$480,x
		sta $c2c8,y	

		lda $fe42-$480,x
		sta $c18f,y
		lda $fe5a-$480,x
		sta $c18e,y
		lda $fe72-$480,x
		sta $c18d,y	
	    lda $fe8a-$480,x
		sta $c18c,y		
		lda $fea2-$480,x
		sta $c18b,y
		lda $feba-$480,x
		sta $c18a,y
		lda $fed2-$480,x
		sta $c189,y
		lda $feea-$480,x
		sta $c188,y	
		
		;inx
		dex
		
		;cpx  #22
		jpl  buildscreen000

	
; clear game screen window BUFFER
; clear screen buffer
LD0B0

		;lda #$ff
		;sta $ff00
		;sta $ff01
		
		lda #$00
		ldy #$7f	
LD0B0_Loop		
		sta ScreenBuffer+$000,y
		sta ScreenBuffer+$080,y
		sta ScreenBuffer+$100,y
		sta ScreenBuffer+$180,y
		sta ScreenBuffer+$200,y
		sta ScreenBuffer+$280,y
		sta ScreenBuffer+$300,y
		sta ScreenBuffer+$380,y
		sta ScreenBuffer+$400,y
		sta ScreenBuffer+$480,y
		sta ScreenBuffer+$500,y
		sta ScreenBuffer+$580,y
		sta ScreenBuffer+$600,y
		sta ScreenBuffer+$680,y
		sta ScreenBuffer+$700,y
		sta ScreenBuffer+$780,y
		sta ScreenBuffer+$800,y
		sta ScreenBuffer+$880,y
		sta ScreenBuffer+$900,y
		sta ScreenBuffer+$980,y
		sta ScreenBuffer+$a00,y
		dey
		bpl LD0B0_Loop
		
		
        rts ; RET
		
		
;ReadKey   OUT A,(FD)
;D0D6    IN A,(FE)
;D0D8    CPL
;D0D9    AND 1F
;D0DB    RET

; LD0D4
;ReadKey
;				
;		rts

		;jsr out_fd ; OUT A,(FD); A read at the beginning of the block
        ;jsr in_a_fe ; IN A,(FE)
        ;eor #$ff ; CPL
        ;and #$1F ; AND 1F
        ;rts ; RET

;LD0DC   LD A,(LA21C)
;D0DF    RRCA
;D0E0    AND 03
;D0E2    JP Z,LD175
;D0E5    DEC A
;D0E6    JR Z,@@384
;D0E8    DEC A
;D0E9    JR Z,@@390
;D0EB    LD A,F7
;D0ED    CALL ReadKey
;D0F0    PUSH BC
;D0F1    LD B,05
;@@378   RRA
;D0F4    RL C
;D0F6    DJNZ @@378
;D0F8    LD A,C
;D0F9    POP BC
;D0FA    LD C,A
;D0FB    LD A,EF
;D0FD    CALL ReadKey
;D100    OR C
;D101    LD C,00
;D103    BIT 0,A
;D105    JR Z,@@379
;D107    SET 3,C
;@@379   BIT 1,A
;D10B    JR Z,@@380
;D10D    SET 2,C
;@@380   BIT 2,A
;D111    JR Z,@@381
;D113    SET 4,C
;@@381   BIT 3,A
;D117    JR Z,@@382
;D119    SET 1,C
;@@382   BIT 4,A
;D11D    JR Z,@@383
;D11F    SET 0,C
;@@383   JP LD1B7

;LD0DC   
CheckUserInput
		lda 	game_select_type ; LD A,(LA21C)
        lsr 	@ ; RRCA
        and 	#$03 ; AND 03
		
		;Keyboard
		jeq 	keyboard ; JP Z,LD175
        
		; if not must be joystick so run joytick check code and fire 2 code

		lda 	#00
		sta		joyvalue

		LDA 	#$ff	                    
		STA 	$FD30

		LDA 	#$fa	                    	                         
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$05				
		beq     joyupleft	

		LDA 	#$ff	                    
		STA 	$FD30

		LDA 	#$fa	                    	                         
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$09				
		beq     joyupright			

		LDA 	#$ff	                    
		STA 	$FD30

		LDA 	#$fa	                    	                         
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$06				
		beq     joydownleft

		LDA 	#$ff	                    
		STA 	$FD30
		
		LDA 	#$fa	                    	                         
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$0a				
		beq     joydownright

		LDA 	#$ff	                    
		STA 	$FD30

		LDA 	#$fa	                    	                         
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$01			
		beq     joyup
		
		LDA 	#$ff	                    
		STA 	$FD30

		LDA 	#$fa	                    	                         
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$02			
		beq     joydown
		
		LDA 	#$ff	                    
		STA 	$FD30
		
		LDA 	#$fa	                    	                         
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$04			
		beq     joyleft

		LDA 	#$ff	                    
		STA 	$FD30

		LDA 	#$fa	                    	                         
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$08			
		beq     joyright
		
		jmp 	joyfire1mix_02
		
joyupleft		
		lda		#$05
		jmp		joyfire1mix
joyupright	
		lda		#$06
		jmp		joyfire1mix
joydownleft	
		lda		#$11
		jmp		joyfire1mix
joydownright	
		lda		#$12
		jmp		joyfire1mix			
joyup
		lda		#$04
		jmp		joyfire1mix
joydown
		lda		#$10
		jmp		joyfire1mix		
joyleft
		lda		#$01 
		jmp		joyfire1mix		
joyright
		lda		#$02


joyfire1mix
		sta		joyvalue
	
joyfire1mix_02		
		LDA 	#$ff	                    
		STA 	$FD30

		LDA 	#$fa	                    	                         
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$40			
		bne     joynotfire1
joyfire1
		lda		#$08
		clc
		adc		joyvalue
		sta 	joyvalue
		
; get out and add joyvalues to set accumulator to required value
joynotfire1

		; fire 2
		LDA 	#$7f	                    
		STA 	$FD30
		lda 	#$ff
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$10
		
		beq		fire2hit ; if space hit jump to fire2hit, if not check for button2 below...
		
		; no hit so flow through
		lda 	joyvalue
		
		jmp 	fire2nothit

fire2hit
			
		lda		#$20

fire2nothit

        sta 	z80_b
		sta 	z80_c

		rts

;------------------------------------------------------
		
keyboard

		lda 	game_on
		beq		bonus_controls

		; in-game controls
		lda 	#$04
		sta		key_bu
		lda		#$10  ;*****
		sta		key_bd
		lda 	#$08
		sta		key_bf
		
		jmp		main_controls

bonus_controls		
		
		lda 	#$08
		sta		key_bu
		lda		#$04
		sta		key_bd
		lda		#$10
		sta		key_bf
		
main_controls
		
		; reset buffer vaules first
        lda     #$00    
        sta     keyvalue
		sta		key_l
		sta		key_r
		
		; test 'o' key for left
kb_check_left
		LDA 	#$ef	                    
		STA 	$FD30
		lda 	#$ff
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$40	
		beq 	left_hit
			
		; test 'p' key for right
kb_check_right
		LDA 	#$df	                    
		STA 	$FD30
		lda 	#$ff		
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$02
		beq 	right_hit
		
		; test 'q' key for up
kb_check_up

		LDA 	#$7f	                    
		STA 	$FD30
		lda 	#$ff
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$40        
		beq 	up_hit

		; test 'a' key for down
kb_check_down
		LDA 	#$fd	                    
		STA 	$FD30
		lda 	#$ff
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$04		
		beq 	down_hit

		jmp		keymix_01	
	
left_hit
        lda     #$01    
        sta     key_l	
		sta		keyvalue
        jmp		kb_check_right			
		
right_hit
        lda     #$02    
        sta     key_r
		sta		keyvalue
        jmp		kb_check_up

up_hit
        lda     key_bu ;#$08 ;#$04    		
		clc
		adc		key_l
		adc		key_r
		sta		keyvalue
        jmp		kb_check_down	
		
down_hit
		lda		key_bd ;#$04 ;#$10
		clc
		adc		key_l
		adc		key_r
		sta		keyvalue
  		
		
keymix_01
		lda 	keyvalue
		sta		keyvalue
		
		; test 'space' key for fire1
		LDA 	#$7f	                    
		STA 	$FD30
		lda 	#$ff
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$10	; check for space key pressed
		beq		fire1_hit ; if space hit jump to @fire1_hit, if not check for button2 below...
		
		jmp 	nokeyhit

fire1_hit
        lda     key_bf ;#$10 ;#$08
		clc
		adc		keyvalue
		sta 	keyvalue
        
nokeyhit

		; fire 2
		; 'z' key - fire 2
		LDA 	#$fd	                    
		STA 	$FD30
		lda 	#$ff
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$10
		
		beq 	fire2hitk ; if Z hit jump to fire2hitk

		; no hit so flow through
		lda 	keyvalue
		jmp 	fire2nothitk
		
fire2hitk
			
		lda		#$20

fire2nothitk

        sta 	z80_b
		sta 	z80_c

		rts
 
		
;		sec ; DEC A
;        sbc #$01; 
;        jeq @@390 ; JR Z,@@390
;        lda #$F7 ; LD A,F7
;        jsr ReadKey ; CALL ReadKey
;        tax
;        lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda #$05 ; LD B,05
;        sta z80_b
;        txa
;@@378   ror @ ; RRA; A read but not set by previous instruction
;        rol z80_c ; RL C
;        dec z80_b ; DJNZ @@378
;        jne @@378
;        ldx z80_c ; LD A,C
;        pla ; POP BC
;        sta z80_b
;        pla
;        sta z80_c
;        stx z80_c ; LD C,A; A read but not set by previous instruction
;        lda #$EF ; LD A,EF
;        jsr ReadKey ; CALL ReadKey
;        ora z80_c ; OR C
;        sta z80_a
;        lda #$00 ; LD C,00
;        sta z80_c
;        ;bit _bitmem0 ; BIT 0,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@379 ; JR Z,@@379
;        jcc @@379
;        ;lda z80_c ; SET 3,C
;        ora #_bitvalue3
;        ;sta z80_c
;@@379   ;bit _bitmem1 ; BIT 1,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@380 ; JR Z,@@380
;        jcc @@380
;        ;lda z80_c ; SET 2,C
;        ora #_bitvalue2
;        ;sta z80_c
;@@380   ;bit _bitmem2 ; BIT 2,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@381 ; JR Z,@@381
;        ;lda z80_c ; SET 4,C
;        ora #_bitvalue4
;        ;sta z80_c
;@@381   ;bit _bitmem3 ; BIT 3,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@382 ; JR Z,@@382
;        jcc @@382
;        ;lda z80_c ; SET 1,C
;        ora #_bitvalue1
;        ;sta z80_c
;@@382   ;bit _bitmem4 ; BIT 4,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@383 ; JR Z,@@383
;        jcc @@383
;        ;lda z80_c ; SET 0,C
;        ora #_bitvalue0
;        ;sta z80_c
;@@383   sta z80_c

;        jmp joystick_keyboard_mix ; JP LD1B7

;@@384   IN A,(1F)
;D126    LD C,00
;D128    BIT 0,A
;D12A    JR Z,@@385
;D12C    SET 1,C
;@@385   BIT 1,A
;D130    JR Z,@@386
;D132    SET 0,C
;@@386   BIT 2,A
;D136    JR Z,@@387
;D138    SET 4,C
;@@387   BIT 3,A
;D13C    JR Z,@@388
;D13E    SET 2,C
;@@388   BIT 4,A
;D142    JR Z,@@389
;D144    SET 3,C
;@@389   JP LD1B7

; joystick
;joystick
;
;		;jsr in_a_1f ; IN A,(1F)
;        jsr c64joystickp2
;		
;		jmp joystick_keyboard_mix
		
;		sta z80_a
;		
;        lda #$00 ; LD C,00
;        sta z80_c
;        ;bit _bitmem0 ; BIT 0,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@385 ; JR Z,@@385
;        jcc @@385
;        ;lda z80_c ; SET 1,C
;		
;		; j right
;        ora #_bitvalue1
;		
;        ;sta z80_c
;@@385   ;bit _bitmem1 ; BIT 1,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@386 ; JR Z,@@386
;        jcc @@386
;        ;lda z80_c ; SET 0,C
;    
;		; j left
;		ora #_bitvalue0
;		
;		;sta z80_c
;@@386   ;bit _bitmem2 ; BIT 2,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@387 ; JR Z,@@387
;        jcc @@387
;        ;lda z80_c ; SET 4,C
;        
;		; j down
;		ora #_bitvalue4
;  
;		;sta z80_c
;@@387   ;bit _bitmem3 ; BIT 3,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@388 ; JR Z,@@388
;        jcc @@388
;        ;lda z80_c ; SET 2,C
;        
;		; j up
;		ora #_bitvalue2
;
;        ;sta z80_c
;@@388   ;bit _bitmem4 ; BIT 4,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@389 ; JR Z,@@389
;        jcc @@389
;        ;lda z80_c ; SET 3,C
;        
;		; j fire1
;		ora #_bitvalue3
; 
;		;sta z80_c
;@@389   sta z80_c
;        jmp joystick_keyboard_mix ; JP LD1B7

;@@390   LD C,00
;D14B    LD A,F7
;D14D    CALL ReadKey
;D150    BIT 4,A
;D152    JR Z,@@391
;D154    SET 0,C
;@@391   LD A,EF
;D158    CALL ReadKey
;D15B    BIT 0,A
;D15D    JR Z,@@392
;D15F    SET 3,C
;@@392   BIT 3,A
;D163    JR Z,@@393
;D165    SET 2,C
;@@393   BIT 2,A
;D169    JR Z,@@394
;D16B    SET 1,C
;@@394   BIT 4,A
;D16F    JR Z,LD1B7
;D171    SET 4,C
;D173    JR LD1B7

;@@390   lda #$00 ; LD C,00
;        sta z80_c
;        lda #$F7 ; LD A,F7
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem4 ; BIT 4,A
;        jeq @@391 ; JR Z,@@391
;        lda z80_c ; SET 0,C
;        ora #_bitvalue0
;        sta z80_c
;@@391   lda #$EF ; LD A,EF
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem0 ; BIT 0,A
;        jeq @@392 ; JR Z,@@392
;        tax
;        lda z80_c ; SET 3,C
;        ora #_bitvalue3
;        sta z80_c
;        txa
;@@392   bit _bitmem3 ; BIT 3,A; A read but not set by previous instruction
;        jeq @@393 ; JR Z,@@393
;        tax
;        lda z80_c ; SET 2,C
;        ora #_bitvalue2
;        sta z80_c
;        txa
;@@393   bit _bitmem2 ; BIT 2,A; A read but not set by previous instruction
;        jeq @@394 ; JR Z,@@394
;        tax
;        lda z80_c ; SET 1,C
;        ora #_bitvalue1
;        sta z80_c
;        txa
;@@394   bit _bitmem4 ; BIT 4,A; A read but not set by previous instruction
;        jeq LD1B7 ; JR Z,LD1B7
;        lda z80_c ; SET 4,C
;        ora #_bitvalue4
;        sta z80_c
;        jmp LD1B7 ; JR LD1B7

;LD175   LD A,FE
;D177    CALL ReadKey
;D17A    RRCA
;D17B    RRCA
;D17C    BIT 2,A
;D17E    JR Z,@@395
;D180    SET 0,A
;@@395   AND 03
;D184    LD C,A
;D185    LD A,7F
;D187    CALL ReadKey
;D18A    BIT 2,A
;D18C    JR Z,@@396
;D18E    SET 0,C
;@@396   BIT 3,A
;D192    JR Z,@@397
;D194    SET 1,C
;@@397   BIT 4,A
;D198    JR Z,@@398
;D19A    SET 0,C
;@@398   LD A,BD
;D19E    CALL ReadKey
;D1A1    JR Z,@@399
;D1A3    SET 2,C
;@@399   LD A,DB
;D1A7    CALL ReadKey
;D1AA    JR Z,@@400
;D1AC    SET 3,C
;@@400   LD A,E7
;D1B0    CALL ReadKey
;D1B3    JR Z,LD1B7
;D1B5    SET 4,C
;LD1B7   LD A,7E
;D1B9    CALL ReadKey
;D1BC    BIT 1,A
;D1BE    JR Z,@@404
;D1C0    SET 5,C
;@@404   PUSH DE
;D1C3    LD A,(LA248)
;D1C6    LD E,A
;D1C7    LD A,C
;D1C8    AND 03
;D1CA    CP 03
;D1CC    JR Z,@@407
;D1CE    LD B,A
;D1CF    LD A,E
;D1D0    AND FC
;D1D2    OR B
;D1D3    LD E,A
;@@405   LD A,C
;D1D5    AND 0C
;D1D7    CP 0C
;D1D9    JR Z,@@408
;D1DB    LD D,A
;D1DC    OR B
;D1DD    LD B,A
;D1DE    LD A,E
;D1DF    AND F3
;D1E1    OR D
;D1E2    LD E,A
;@@406   LD A,E
;D1E4    LD (LA248),A
;D1E7    POP DE
;D1E8    LD A,C
;D1E9    AND 10
;D1EB    OR B
;D1EC    LD B,A
;D1ED    RET

;keyboard   
			
        ;jsr c64keyboard
		
;		jmp joystick_keyboard_mix
		
;		sta z80_a
;		
;        lda #$00 ; LD C,00
;        sta z80_c
;        lsr z80_a
;        jcc @@395
;		
;		; k right
;        ora #_bitvalue1
;		
;        ;sta z80_c
;@@395   ;bit _bitmem1 ; BIT 1,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@386 ; JR Z,@@386
;        jcc @@396
;        ;lda z80_c ; SET 0,C
;    
;		; k left
;		ora #_bitvalue0
;		
;		;sta z80_c
;@@396   ;bit _bitmem2 ; BIT 2,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@387 ; JR Z,@@387
;        jcc @@397
;        ;lda z80_c ; SET 4,C
;        
;		; k down
;		ora #_bitvalue4
;  
;		;sta z80_c
;@@397   ;bit _bitmem3 ; BIT 3,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@388 ; JR Z,@@388
;        jcc @@398
;        ;lda z80_c ; SET 2,C
;        
;		; k up
;		ora #_bitvalue2
;
;        ;sta z80_c
;@@398   ;bit _bitmem4 ; BIT 4,A; A read but not set by previous instruction
;        lsr z80_a
;        ;jeq @@389 ; JR Z,@@389
;        jcc @@399
;        ;lda z80_c ; SET 3,C
;        
;		; k fire1
;		ora #_bitvalue3
; 
;		;sta z80_c
;@@399   sta z80_c
       
		
;LD1B7
;joystick_keyboard_mix
   
		;sta z80_c
   
		; check for view switch key pressed
		;lda #$7E ; LD A,7E
        ;jsr ReadKey ; CALL ReadKey
        ;bit _bitmem1 ; BIT 1,A
        ;jeq @@404 ; JR Z,@@404
        ;lda z80_c ; SET 5,C
        ;ora #_bitvalue5
        
;		jsr c64fire2
;        sta z80_b
;		sta z80_c		
;@@404   
;		lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        lda LA248 ; LD A,(LA248)
;        sta z80_e ; LD E,A
;        lda z80_c ; LD A,C
;        and #$03 ; AND 03
;        cmp #$03 ; CP 03
;        jeq @@407 ; JR Z,@@407
;        sta z80_b ; LD B,A; 
;        lda z80_e ; LD A,E
;        and #$FC ; AND FC
;        ora z80_b ; OR B
;        sta z80_e ; LD E,A
;@@405   lda z80_c ; LD A,C
;        and #$0C ; AND 0C
;        cmp #$0C ; CP 0C
;        jeq @@408 ; JR Z,@@408
;        sta z80_d ; LD D,A; 
;        ora z80_b ; OR B
;        sta z80_b ; LD B,A
;        lda z80_e ; LD A,E
;        and #$F3 ; AND F3
;        ora z80_d ; OR D
;        sta z80_e ; LD E,A
;@@406   lda z80_e ; LD A,E
;        sta LA248 ; LD (LA248),A
;        pla ; POP DE
;        sta z80_d
;        pla
;        sta z80_e
;        lda z80_c ; LD A,C
;        and #$10 ; AND 10
;        ora z80_b ; OR B
;        sta z80_b ; LD B,A


;		lda z80_c
;		cmp #00
;		beq @+
;		
;		jmp *
;@

		
;        rts ; RET

;@@407   LD A,E
;D1EF    AND 03
;D1F1    XOR 03
;D1F3    LD B,A
;D1F4    JR @@405

;@@407   lda z80_e ; LD A,E
;        and #$03 ; AND 03
;        eor #$03 ; XOR 03
;        sta z80_b ; LD B,A
;        jmp @@405 ; JR @@405

;@@408   LD A,E
;D1F7    AND 0C
;D1F9    XOR 0C
;D1FB    OR B
;D1FC    LD B,A
;D1FD    JR @@406

;@@408   lda z80_e ; LD A,E
;        and #$0C ; AND 0C
;        eor #$0C ; XOR 0C
;        ora z80_b ; OR B
;        sta z80_b ; LD B,A
;        jmp @@406 ; JR @@406

;LD1FF   LD A,7E
;D201    CALL ReadKey
;D204    BIT 0,A
;D206    RET Z
;D207    AND 1E
;D209    RET NZ
;D20A    CALL LAF47
;@@409   LD A,7E
;D20F    CALL ReadKey
;D212    BIT 0,A
;D214    JR NZ,@@409
;@@410   LD A,7E
;D218    CALL ReadKey
;D21B    BIT 0,A
;D21D    JR Z,@@410
;D21F    CALL LAF47
;@@411   LD A,7E
;D224    CALL ReadKey
;D227    BIT 0,A
;D229    JR NZ,@@411
;D22B    RET

;LD1FF
pause_key   

        ;first check if shift pressed, if so pause.

		LDA #$fd	; query keyboard
		STA $FD30
		lda #$ff
		STA $FF08
		LDA $FF08
		AND #$80	; check for shift pressed
                
        beq go_pause

        rts

go_pause

	.if TED_SOUND == 1
		lda #07
		jsr ted_music_play
	.else
		lda #00
		jsr	sound_volume
		
		lda	#01
		sta mpwait
		jsr music_pause_no

		lda #01
		sta sound_off	
	.endif	

		;lda #<sfxpause      ;Start address of sound effect data
        ;ldy #>sfxpause
        ;ldx #14             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 

 		lda		#02
		sta		border		
		
go_pauseb		
		
		jsr c64WaitFrame

		LDA #$7f	                    
		STA $FD30
		lda #$ff
		STA $FF08	                        
		LDA $FF08	                         
		AND #$10	; check for space key pressed
		beq un_pause
		
        ;setup joystick port 2
        ;lda     #$E0    
        ;and     ddra    
        ;sta     ddra    

        ;lda     pra     	;read gameport2
        ;and     #$10    	;isolate button bit
        ;beq     @un_pause	;if =0 then button is down.

		LDA 	#$ff	                    
		STA 	$FD30
		
		LDA 	#$fa	                    	                         
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$40		
		beq 	un_pause

		jmp 	go_pauseb
		 
un_pause

		jsr c64skipkeyheld

	.if TED_SOUND == 1
		lda #07
		jsr ted_music_play
	.else
		lda #00
		sta sound_off
		
		lda #15
		jsr	sound_volume		
		
		;lda #<sfxpause      ;Start address of sound effect data
        ;ldy #>sfxpause
        ;ldx #14             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 
	.endif
 

		lda	#00
		sta	border	
		
        rts
		
;		lda #$7E ; LD A,7E
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem0 ; BIT 0,A
;        bne *+3 ; RET Z
;        rts
;        and #$1E ; AND 1E
;        beq *+3 ; RET NZ
;        rts
;        jsr LAF47 ; CALL LAF47
;@@409   lda #$7E ; LD A,7E
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem0 ; BIT 0,A
;        jne @@409 ; JR NZ,@@409
;@@410   lda #$7E ; LD A,7E
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem0 ; BIT 0,A
;        jeq @@410 ; JR Z,@@410
;        jsr LAF47 ; CALL LAF47
;@@411   lda #$7E ; LD A,7E
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem0 ; BIT 0,A
;        jne @@411 ; JR NZ,@@411
;        rts ; RET

;LD22C   PUSH BC
;D22D    SRL L
;D22F    SRL L
;D231    SRL L
;D233    LD A,L
;D234    LD L,H
;D235    LD H,00
;D237    ADD HL,HL
;D238    ADD HL,HL
;D239    ADD HL,HL
;D23A    LD C,L
;D23B    LD B,H
;D23C    ADD HL,HL
;D23D    ADD HL,BC
;D23E    LD C,A
;D23F    LD B,00
;D241    ADD HL,BC
;D242    LD BC,LD022 
;D245    ADD HL,BC
;D246    POP BC
;D247    RET

GetPointerInBackgroundBuffer
;LD22C   ;lda z80_c ; PUSH BC
        ;pha

        ;lda z80_b
        ;pha
		lda z80_l

        ;lsr z80_l ; SRL L
		lsr @
        ;lsr z80_l ; SRL L
		lsr @
        ;lsr z80_l ; SRL L
		lsr @
        ;ldx z80_l ; LD A,L
		tax
        lda z80_h ; LD L,H
        ;sta z80_l
        ;lda #$00 ; LD H,00
        ;sta z80_h
		ldy #$00
		sty z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
        ;lda z80_l ; LD C,L
        ;sta z80_c
		sta z80_a
        ;lda z80_h ; LD B,H
        ;sta z80_b
		ldy z80_h
		;sty z80_b
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_h
		;sta z80_l
        ;jsr add_hl_bc ; ADD HL,BC
		clc
		;adc z80_c
		adc z80_a
		sta z80_l
		tya
		adc z80_h
		sta z80_h
        ;stx z80_c ; LD C,A; A read but not set by previous instruction
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
		txa
		clc
		adc z80_l
		;sta z80_l
		scc:inc z80_h
        ;lda #<LD022 ; LD BC,LD022
        ;sta z80_c
        ;lda #>LD022
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
		clc
		adc #<LD022
		sta z80_l
		lda z80_h
		adc #>LD022
		sta z80_h
        ;pla ; POP BC
        ;sta z80_b
        ;pla

        ;sta z80_c
        rts ; RET

GetPointerInBackgroundBufferDE
;LD22C   ;lda z80_c ; PUSH BC
        ;pha
        ;lda z80_b
        ;pha
		lda z80_e
        ;lsr z80_l ; SRL L
		lsr @
        ;lsr z80_l ; SRL L
		lsr @
        ;lsr z80_l ; SRL L
		lsr @
        ;ldx z80_l ; LD A,L
		tax
        lda z80_d ; LD L,H
        ;sta z80_l
        ;lda #$00 ; LD H,00
        ;sta z80_h
		ldy #$00
		sty z80_d
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_d
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_d
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_d
        ;lda z80_l ; LD C,L
        ;sta z80_c
		sta z80_a
        ;lda z80_h ; LD B,H
        ;sta z80_b
		ldy z80_d
		;sty z80_b
        ;asl z80_l ; ADD HL,HL
		asl @
        rol z80_d
		;sta z80_l
        ;jsr add_hl_bc ; ADD HL,BC
		clc
		;adc z80_c
		adc z80_a
		sta z80_e
		tya
		adc z80_d
		sta z80_d
        ;stx z80_c ; LD C,A; A read but not set by previous instruction
        ;lda #$00 ; LD B,00
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
		txa
		clc
		adc z80_e
		;sta z80_l
		scc:inc z80_d
        ;lda #<LD022 ; LD BC,LD022
        ;sta z80_c
        ;lda #>LD022
        ;sta z80_b
        ;jsr add_hl_bc ; ADD HL,BC
		clc
		adc #<LD022
		sta z80_e
		lda z80_d
		adc #>LD022
		sta z80_d
        ;pla ; POP BC
        ;sta z80_b
        ;pla
        ;sta z80_c
        rts ; RET



;LD248   PUSH DE
;D249    EX DE,HL
;D24A    LD A,E
;D24B    RRCA
;D24C    RRCA
;D24D    RRCA
;D24E    AND 1F
;D250    LD L,A
;D251    LD A,D
;D252    CPL
;D253    RLCA
;D254    RLCA
;D255    AND E0
;D257    OR L
;D258    LD L,A
;D259    LD A,D
;D25A    CPL
;D25B    RRCA
;D25C    RRCA
;D25D    RRCA
;D25E    AND 18
;D260    LD H,A
;D261    LD A,D
;D262    CPL
;D263    AND 07
;D265    OR H
;D266    ADD A,38
;D268    LD H,A
;D269    POP DE
;D26A    RET

;LD248   lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        ;jsr ex_de_hl ; EX DE,HL
;		jsr ld_de_hl
;        lda z80_e ; LD A,E
;        lsr @ ; RRCA
;        lsr @ ; RRCA
;        lsr @ ; RRCA
;        and #$1F ; AND 1F
;        sta z80_l ; LD L,A
;        lda z80_d ; LD A,D
;        eor #$ff ; CPL
;        asl @ ; RLCA
;        asl @ ; RLCA
;        and #$E0 ; AND E0
;        ora z80_l ; OR L
;        sta z80_l ; LD L,A
;        lda z80_d ; LD A,D
;        eor #$ff ; CPL
;        lsr @ ; RRCA
;        lsr @ ; RRCA
;        lsr @ ; RRCA
;        and #$18 ; AND 18
;        sta z80_h ; LD H,A
;        lda z80_d ; LD A,D
;        eor #$ff ; CPL
;        and #$07 ; AND 07
;        ora z80_h ; OR H
;        clc ; ADD A,38 ; Screen memory address high byte - $08?
;        adc #>[spectrum_screen-$0800]
;        sta z80_h ; LD H,A
;        pla ; POP DE
;        sta z80_d
;        pla
;        sta z80_e
;        rts ; RET

;LD26B   LD A,(LA269)
;LD26E   ADD A,L
;D26F    LD L,A
;D270    LD A,H
;D271    ADC A,00
;D273    LD H,A
;D274    RET

LD26B   lda game_on ; LD A,(LA269)
LD26E   clc ; ADD A,L
        adc z80_l
        sta z80_l ; LD L,A
        lda z80_h ; LD A,H
        adc #$00 ; ADC A,00
        sta z80_h ; LD H,A
        rts ; RET

;LD275   LD A,(LA269)
;D278    AND A
;D279    RET Z
;D27A    LD A,46
;D27C    EX AF,AF'
;D27D    LD HL,L5040
;D280    LD A,(LA265)
;D283    CALL LD28F
;D286    XOR A
;D287    EX AF,AF'
;D288    LD A,(LA265)
;D28B    NEG
;D28D    ADD A,04
;LD28F   AND A
;D290    RET Z
;D291    PUSH AF
;D292    LD DE,LD2A3
;D295    LD BC,L0203
;D298    PUSH HL
;D299    CALL LD58E
;D29C    POP HL
;D29D    INC L
;D29E    INC L
;D29F    POP AF
;D2A0    DEC A
;D2A1    JR LD28F


; LD275
; draw lives
draw_lives

		; skip if bonus on
		lda game_on ; LD A,(LA269)
        ; AND A
        bne *+3 ; RET Z
        rts

		;lda #$30 ; Open up all RAM
		;sta $01
		
		; clear down
		ldy #00
		lda #00
@		
		sta $d6a0,y
		sta $d7e0,y
		sta $d920,y
		
		iny
		cpy #64
		bne @-

		;lda #$35 ; IO Back In     
		;sta $01
		
		; skip if on last life
		lda no_of_lives
		cmp #01
		bcc outofhere
		
		;screen poss
        lda #<$d6a0 
        sta dest_lo
        lda #>$d6a0
        sta dest_hi
		
		lda #16
		sta blitsize
		
		lda #00
		sta hflip_flag

		lda no_of_lives
		cmp #05
		bcs skip_b
				
		ldx no_of_lives
		jmp skip_c
		
skip_b
		ldx #04
skip_c		

		;graphics data
        lda #<LIVESHA
        sta source_lo
        lda #>LIVESHA
        sta source_hi	
		
		jsr screenblit
		
		jsr addline
		lda #16
		jsr addasource
		jsr screenblit
		
		jsr addline
		lda #16
		jsr addasource
		jsr screenblit

		sec		
		lda dest_lo
		sbc #$70
		sta dest_lo
		lda dest_hi
		sbc #$02
		sta dest_hi		
	
		dex 
		bne skip_c

outofhere		
		
		rts
	
	
;        lda #$46 ; LD A,46
;        ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa ; 
;		
;		;screen poss
;        lda #<L5040 ; LD HL,L5040
;        sta z80_l
;        lda #>L5040
;        sta z80_h
;		
;        lda no_of_lives ; LD A,(LA265)
;		
;        jsr LD28F ; CALL LD28F
;        lda #$00 ; XOR A
;        ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        txa ; TODO: EX   AF,AF'
;				
;        lda no_of_lives ; LD A,(LA265)
;        eor #$ff ; NEG
;        clc
;        adc #$01
;        clc ; ADD A,04
;        adc #$04
;LD28F   ; AND  A
;        bne *+3 ; RET Z
;        rts
;		
;        pha ; PUSH AF
;        php; 
;		
;        lda #<LD2A3 ; LD DE,LD2A3
;        sta z80_e
;        lda #>LD2A3
;        sta z80_d
;		
;        lda #<L0203 ; LD BC,L0203
;        sta z80_c
;        lda #>L0203
;        sta z80_b
;		
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;        jsr LD58E ; CALL LD58E
;        pla ; POP HL
;        sta z80_h
;        pla
;        sta z80_l
;        inc z80_l ; INC L
;        inc z80_l ; INC L
;        plp ; POP AF
;        pla
;        sec ; DEC A
;        sbc #$01
;		
;        jmp LD28F ; JR LD28F

;LD2A3   DB 19,1A,1B,1C,1D,1E

;LD2A3   .he 19,1A,1B,1C,1D,1E ; DB 19,1A,1B,1C,1D,1E

;LD2A9   LD A,(DE)
;D2AA    RRCA
;D2AB    RRCA
;D2AC    RRCA
;D2AD    RRCA
;D2AE    AND 0F
;D2B0    PUSH BC
;D2B1    LD BC,L8EB0
;D2B4    CALL LD2C2
;D2B7    LD A,(DE)
;D2B8    INC DE
;D2B9    AND 0F
;D2BB    CALL LD2C2
;D2BE    POP BC
;D2BF    DJNZ LD2A9
;D2C1    RET

; draw bounty numeric text
; LD2A9
draw_bounty_numbers

		lda game_on
		beq LD2A9_a
				
        lda #<$dbb0
        sta dest_lo
        lda #>$dbb0
        sta dest_hi
		
		jmp LD2A9_b

LD2A9_a

        lda #<$d870
        sta dest_lo
        lda #>$d870
        sta dest_hi		
		
LD2A9_b
		
		lda #00
		sta alpha

LD2A9_c	
		ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$0F ; AND 0F
        tax
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
		
		;font data
        ;lda #<L8EB0 ; LD BC,L8EB0
        ;sta z80_c
        ;lda #>L8EB0
        ;sta z80_b
        
		txa
		asl
		asl
		asl
		tax
		jsr fontblit_yx2
		
		;draw part 1 of bounty score graphic
        ;jsr LD2C2 ; CALL LD2C2 ; uses A as parameter
		
		
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        and #$0F ; AND 0F
		
		asl
		asl
		asl
		tax
		jsr fontblit_yx2
				
		;draw part 2 of bounty score graphic
        ;jsr LD2C2 ; CALL LD2C2 ; uses A as parameter
		
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
        dec z80_b ; DJNZ LD2A9
        jne LD2A9_c
		
		
        rts ; RET

;LD2C2   PUSH BC
;D2C3    PUSH DE
;D2C4    PUSH HL
;D2C5    EX DE,HL
;D2C6    LD L,A
;D2C7    LD H,00
;D2C9    ADD HL,HL
;D2CA    ADD HL,HL
;D2CB    ADD HL,HL
;D2CC    ADD HL,BC
;D2CD    EX DE,HL
;D2CE    CALL LD2D6
;D2D1    POP HL
;D2D2    INC L
;D2D3    POP DE
;D2D4    POP BC
;D2D5    RET

; draw numbers to screen
;LD2C2
;
;		sta z80_a
;		
;        lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;        jsr ex_de_hl ; EX DE,HL
;		lda z80_a
;        sta z80_l ; LD L,A; A read but not set by previous instruction
;        lda #$00 ; LD H,00
;        sta z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        jsr add_hl_bc ; ADD HL,BC
;        jsr ex_de_hl ; EX DE,HL
;        jsr LD2D6 ; CALL LD2D6
;        pla ; POP HL
;        sta z80_h
;        pla
;        sta z80_l
;        inc z80_l ; INC L
;        pla ; POP DE
;        sta z80_d
;        pla
;        sta z80_e
;        pla ; POP BC
;        sta z80_b
;        pla
;        sta z80_c
;        rts ; RET

;LD2D6   PUSH HL
;D2D7    CALL LD2E9
;D2DA    POP HL
;D2DB    CALL LD635
;D2DE    CALL LD648
;D2E1    PUSH HL
;D2E2    CALL LD2E9
;D2E5    POP HL
;D2E6    JP LD635


;LD2E9   LD B,04
;@@414   LD A,(DE)
;D2EC    INC DE
;D2ED    LD (HL),A
;D2EE    INC H
;D2EF    LD (HL),A
;D2F0    INC H
;D2F1    DJNZ @@414
;D2F3    RET


;LD2F4   CALL LD6CC
;D2F7    CALL LD6D4
;D2FA    CALL LA6FA
;D2FD    LD HL,L8CF0
;D300    LD (LA20F),HL
;D303    CALL LD5C2
;D306    CALL LD55E
;D309    CALL LD45C
;D30C    CALL LD3A0
;D30F    CALL LD320
;D312    CALL LD275
;D315    JP LD377

; LD2F4
; setup background graphics
draw_background_gfx

		lda #00
		jsr c64clearcols
		jsr c64clearbitmap
		;lda #00
		;sta border
		;sta background
		
		;jsr c64WaitFrame
		
		
		;turn off screen in 24 row mode
		;lda #%11011111
		;and $ff06
		
		lda $ff06
		;sta temp_002
		pha
		
		lda #00
		sta $ff06
		
		; colour in game area colour
		lda z80_e
		sta colourcode
		jsr game_area_colour
		
		; screen off
		;lda #07
		;sta $d011
	
		
		;jsr old_clear_colours ; CALL LD6CC
		; clear background
        ;jsr old_screen_clear ; CALL LD6D4
        ;lda #00
		;jsr c64clearcols        
		;jsr c64clearbitmap
		
		; in game telegram text
		jsr telegram_text_startup ; CALL LA6FA
		
		; background graphics data start address
        ;lda #<L8CF0 ; LD HL,L8CF0
        ;sta z80_l
        ;lda #>L8CF0
        ;sta z80_h
        ;lda z80_l ; LD (LA20F),HL
        ;sta LA20F
        ;lda z80_h
        ;sta LA20F+1
        
		;draw border
		;jsr LD5C2 ; CALL LD5C2
        jsr draw_border
		
		;draw gun barrel
		;jsr LD55E ; CALL LD55E
		jsr draw_barrel
	
		;draw text border
        ;jsr LD45C ; CALL LD45C
		jsr draw_small_border

		
		;draw wanted poster
        jsr in_game_gfx ; CALL LD3A0

		
		;draw duck shoot guns
        ;jsr LD320 ; CALL LD320
		jsr draw_bonus_guns
		
		; draw lives graphics
        ;jsr LD275 ; CALL LD275
        jsr draw_lives
	

		;jsr c64WaitFrame

		
		;turn on bitmap screen in 24 row mode
		;lda #% 00100000
		;ora $ff06
		
		;lda #$3f
		
		jsr HostGameScreenPrepare
		
		pla
		;lda temp_002
		sta $ff06

		jmp bounty_text ; JP LD377
		

;LD318   DB 43,42,4F,55,4E,54,59,00 ; CBOUNTY.

;LD318   .he 43,42,4F,55,4E,54,59,00 ; DB 43,42,4F,55,4E,54,59,00

;LD320   LD A,(LA269)
;D323    AND A
;D324    RET NZ
;D325    LD A,43
;D327    EX AF,AF'
;D328    LD HL,L48DC
;D32B    LD DE,L5E04
;D32E    LD BC,L040A
;D331    CALL LD58E
;D334    LD HL,L48C3
;D337    LD DE,L5E04
;D33A    LD BC,L040A
;D33D    JP LD5A7

;LD320   lda game_on ; LD A,(LA269)
;        ; AND  A
;        beq *+3 ; RET NZ
;        rts
;        lda #$43 ; LD A,43
;        ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa ; 
;        lda #<L48DC ; LD HL,L48DC
;        sta z80_l
;        lda #>L48DC
;        sta z80_h
;        lda #<L5E04 ; LD DE,L5E04
;        sta z80_e
;        lda #>L5E04
;        sta z80_d
;        lda #<L040A ; LD BC,L040A
;        sta z80_c
;        lda #>L040A
;        sta z80_b
;        jsr LD58E ; CALL LD58E
;        lda #<L48C3 ; LD HL,L48C3
;        sta z80_l
;        lda #>L48C3
;        sta z80_h
;        lda #<L5E04 ; LD DE,L5E04
;        sta z80_e
;        lda #>L5E04
;        sta z80_d
;        lda #<L040A ; LD BC,L040A
;        sta z80_c
;        lda #>L040A
;        sta z80_b
;        jmp LD5A7 ; JP LD5A7

;LD340   CALL LD364
;D343    RET NC
;D344    LD HL,LA259
;D347    LD BC,L0003
;D34A    JP LD6DA

LD340   jsr LD364 ; CALL LD364
        bcc *+3 ; RET NC
        rts; 
        lda #<LA259 ; LD HL,LA259
        sta z80_l
        lda #>LA259
        sta z80_h
        lda #<L0003 ; LD BC,L0003
        sta z80_c
        lda #>L0003
        sta z80_b
				
        jmp old_clear_part_2 ; JP LD6DA

;LD34D   XOR A
;D34E    LD (LA243),A
;D351    LD HL,LA25B
;D354    LD A,C
;D355    ADD A,(HL)
;D356    DAA
;D357    LD (HL),A
;D358    DEC HL
;D359    LD A,B
;D35A    ADC A,(HL)
;D35B    DAA
;D35C    LD (HL),A
;D35D    DEC HL
;D35E    LD A,(HL)
;D35F    ADC A,00
;D361    DAA
;D362    LD (HL),A
;D363    RET

LD34D   lda #$00 ; XOR A
        sta LA243 ; LD (LA243),A
        ;lda #<LA25B ; LD HL,LA25B
        ;sta z80_l
        ;lda #>LA25B
        ;sta z80_h
        lda z80_c ; LD A,C
        sed
        ;ldy #$00 ; ADD A,(HL)
        clc
        ;adc (z80_hl),y
		adc LA25B
        ; decimal mode ; DAA
        ;ldy #$00 ; LD (HL),A
        ;sta (z80_hl),y
		sta LA25B
        ;jsr dec_hl ; DEC HL
        lda z80_b ; LD A,B
        ;ldy #$00 ; ADC A,(HL)
        ;adc (z80_hl),y
		adc LA25B-1
        ; decimal mode ; DAA
        ;ldy #$00 ; LD (HL),A
        ;sta (z80_hl),y
		sta LA25B-1
        ;jsr dec_hl ; DEC HL
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
		lda LA25B-2
        adc #$00 ; ADC A,00
        ; decimal mode ; DAA
        cld
        ;ldy #$00 ; LD (HL),A
        ;sta (z80_hl),y
		sta LA25B-2
        rts ; RET


;LD364   LD HL,LA25B
;D367    LD A,(HL)
;D368    SUB C
;D369    DAA
;D36A    LD (HL),A
;D36B    DEC HL
;D36C    LD A,(HL)
;D36D    SBC B
;D36E    DAA
;D36F    LD (HL),A
;D370    DEC HL
;D371    LD A,(HL)
;D372    SBC 00
;D374    DAA
;D375    LD (HL),A
;D376    RET

; money
LD364
		;lda #<LA25B ; LD HL,LA25B
        ;sta z80_l
        ;lda #>LA25B
        ;sta z80_h
        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y

		ldx UNLIMITED_MONEY
		beq @+
		sec
		rts
@
		
        lda LA25B
		sed
        sec ; SUB C
        sbc z80_c
        ; decimal mode ; DAA

		;ldx UNLIMITED_MONEY
		;bne @+

        ;ldy #$00 ; LD (HL),A
        ;sta (z80_hl),y
		sta LA25B	
	
		;jsr dec_hl ; DEC HL
        
		;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y

        lda LA25B-1
		sbc z80_b ; SBC B
        ; decimal mode ; DAA
        ;ldy #$00 ; LD (HL),A
        ;sta (z80_hl),y
        sta LA25B-1
		
		;jsr dec_hl ; DEC HL

        ;ldy #$00 ; LD A,(HL)
        ;lda (z80_hl),y
        		

		lda LA25B-2
		sbc #$00 ; SBC 00
        ; decimal mode ; DAA
        cld
        ;ldy #$00 ; LD (HL),A
        ;sta (z80_hl),y
		sta LA25B-2
	
        rts ; RET

;LD377   LD A,(LA269)
;D37A    AND A
;D37B    JR Z,@@415
;D37D    LD HL,L50A0
;D380    LD DE,LD318
;D383    CALL LD4D0
;@@415   CALL LD543
;LD389   LD A,47
;D38B    EX AF,AF'
;D38C    LD DE,LA259
;D38F    LD A,(LA269)
;D392    AND A
;D393    LD HL,L50C2
;D396    JR NZ,@@416
;D398    LD HL,L5072
;@@416   LD B,03
;D39D    JP LD2A9

;LD377   
bounty_text
		; skip to @@415 if in bonus game
		lda game_on ; LD A,(LA269)
        ; AND  A
        jeq @@415 ; JR Z,@@415
		
		;screen poss
        ;lda #<L50A0 ; LD HL,L50A0
        ;sta z80_l
        ;lda #>L50A0
        ;sta z80_h
		
		;bounty text data
        ;lda #<LD318 ; LD DE,LD318
        ;sta z80_e
        ;lda #>LD318
        ;sta z80_d

		;screen poss
        lda #<$da60
        sta dest_lo
        lda #>$da60
        sta dest_hi
				
		lda #01
		sta alpha		
		
		ldx #00
@	
		lda bountyaplpha,x
		stx count_temp
		tax
		jsr fontblit
		ldx count_temp
		inx
		
		cpx #06
		bne @-
		
		
		; draw bounty text
        ;jsr LD4D0 ; CALL LD4D0
		
@@415   
		; $ sign graphic duck shoot and in-game
		;jsr LD543 ; CALL LD543

		jsr draw_dollar
		
LD389   lda #$47 ; LD A,47
        ;ldx z80_ap ; EX AF,AF'
        sta z80_ap
        ;txa ; 
        lda #<LA259 ; LD DE,LA259
        sta z80_e
        lda #>LA259
        sta z80_d
        lda game_on ; LD A,(LA269)
        ; AND  A
        php
        lda #<L50C2 ; LD HL,L50C2
        sta z80_l
        lda #>L50C2
        sta z80_h
        plp
        jne @@416 ; JR NZ,@@416; ZERO flag read but not set by previous instruction
        lda #<L5072 ; LD HL,L5072
        sta z80_l
        lda #>L5072
        sta z80_h
@@416   lda #$03 ; LD B,03
        sta z80_b
				
        jmp draw_bounty_numbers ; JP LD2A9

;LD3A0   LD A,(LA269)
;D3A3    AND A
;D3A4    RET Z
;D3A5    LD HL,L4000
;D3A8    LD DE,L5E91
;D3AB    LD C,12
;@@417   LD B,08
;D3AF    PUSH HL
;@@418   LD A,(DE)
;D3B1    INC DE
;D3B2    EX AF,AF'
;D3B3    LD A,(DE)
;D3B4    INC DE
;D3B5    PUSH BC
;D3B6    LD BC,L8B48
;D3B9    CALL LD632
;D3BC    POP BC
;D3BD    INC L
;D3BE    DJNZ @@418
;D3C0    POP HL
;D3C1    CALL LD648
;D3C4    DEC C
;D3C5    JR NZ,@@417
;D3C7    CALL LB1F2
;D3CA    LD A,(LA262)
;D3CD    LD HL,LB492
;D3D0    CALL LD26E
;D3D3    LD L,(HL)
;D3D4    LD H,00
;D3D6    LD C,L
;D3D7    LD B,H
;D3D8    ADD HL,HL
;D3D9    ADD HL,HL
;D3DA    ADD HL,BC
;D3DB    LD BC,LB5AE
;D3DE    ADD HL,BC
;D3DF    INC HL
;D3E0    EX DE,HL
;D3E1    LD HL,L4F42
;D3E4    LD B,04
;@@419   LD A,(DE)
;D3E7    INC DE
;D3E8    PUSH BC
;D3E9    PUSH DE
;D3EA    PUSH HL
;D3EB    CALL LD3F9
;D3EE    POP HL
;D3EF    CALL LD652
;D3F2    POP DE
;D3F3    POP BC
;D3F4    DJNZ @@419
;D3F6    JP LD41C

; in game static graphics draw
in_game_gfx   

		; skip all this if game_on = 0
		lda game_on ; LD A,(LA269)	
		; AND  A
        bne *+3 ; RET Z
	    rts

		; turn music off	
		.if TED_SOUND == 1
		lda #05
		jsr ted_music_play
		.else
		; turn bonus music off here
		lda #06
		sta sound_e
		jsr music_play
		
		lda #02
		sta mpwait
		jsr music_pause_no		
		.endif			
		
		; turn bonus music off here
		;lda #09
		;jsr music_play
		lda #00
		sta play_bonus_music
		
		
		; set background colour to gray for main game
		;lda #$f0
		;jsr c64clearcols
		
		jsr draw_border_colour
		jsr draw_small_border_colour
		;jsr draw_barrel_colour
		
		
		;poster colour
		lda #$04
		sta dest_lo
		lda #$b8
		sta dest_hi	
		
		;med gray
		lda #$15
		sta colourcode
		lda #08
		sta blitsize
		
		ldx #00
@		
		jsr colourblit
		
		lda #40
		jsr addadest

		inx
		cpx #18
		bne @-		

		lda #$2d
		sta dest_lo
		lda #$b8
		sta dest_hi		

		;red & med gray
		lda #$10
		sta colourcode
		lda #06
		sta blitsize
		jsr colourblit
		lda #40
		jsr addadest
		jsr colourblit

		
		lda #$0d
		sta dest_lo
		lda #$ba
		sta dest_hi
		;pur & med gray
		lda #$11
		sta colourcode		
		jsr colourblit
		
		lda #40
		jsr addadest
		lda #$10
		sta colourcode		
		jsr colourblit

		; green
		lda #40
		jsr addadest
		lda #$12
		sta colourcode		
		jsr colourblit		
		lda #40
		jsr addadest		
		jsr colourblit

		; face box colour
		lda #$f5
		sta dest_lo
		lda #$b8
		sta dest_hi
		lda #$00
		sta colourcode		
		jsr colourblit
		
		lda #40
		jsr addadest
		lda #$07
		sta colourcode
		jsr colourblit

		lda #40
		jsr addadest
		jsr colourblit

		lda #40
		jsr addadest
		lda #$0a
		sta colourcode
		jsr colourblit
		
		lda #40
		jsr addadest
		jsr colourblit		

		lda #40
		jsr addadest
		lda #$00
		sta colourcode
		jsr colourblit
		
		; bandit arms
		lda #$07
		sta $b996
		sta $b999
		lda #$30
		sta $bd96
		sta $bd99		
		
		; small $ sign colour
		lda #$60
		sta $b9e5
		lda #$69
		sta $bde5
		
		; lives colour
		lda #$d4
		sta dest_lo
		lda #$ba
		sta dest_hi
		lda #08
		sta blitsize
		lda #$07
		sta colourcode		
		jsr colourblit
		lda #40
		jsr addadest
		jsr colourblit
		lda #40
		jsr addadest
		jsr colourblit		

		;bounty text colour
		lda #40
		jsr addadest		
		lda #$04
		sta colourcode
		jsr colourblit
		
		;bounty score colour
		lda #40
		jsr addadest		
		lda #$0f
		sta colourcode
		jsr colourblit
		lda #40
		jsr addadest
		jsr colourblit		
		
		
		; draw top part of poster graphic
		lda #<poster_top
		sta source_lo
		lda #>poster_top
		sta source_hi
		
		;top left corner of screen
		lda #<L4000 
        sta dest_lo
        lda #>L4000
        sta dest_hi
				
		ldx #00
@	
		lda #64
		sta blitsize
		jsr screenblit
		
		jsr addline
		lda #64
		jsr addasource
		
		inx
		cpx #04
		bne @-		

		; draw bottom part of poster graphic
		lda #<poster_bottom1
		sta source_lo
		lda #>poster_bottom1
		sta source_hi
		
		lda #<$d060 
        sta dest_lo
        lda #>$d060
        sta dest_hi
				
		ldx #00
@	
		lda #64
		sta blitsize
		jsr screenblit
		
		jsr addline
		lda #64
		jsr addasource
		
		inx
		cpx #02
		bne @-	

		lda #<poster_bottom2
		sta source_lo
		lda #>poster_bottom2
		sta source_hi		

		ldx #00
@	
		jsr screenblit
		
		jsr addline
		lda #64
		jsr addasource
		
		inx
		cpx #03
		bne @-	
		
;-----------------------------------------------		
		
		; draw sides of poster graphic
		lda #<poster_sides
		sta source_lo
		lda #>poster_sides
		sta source_hi
		
		lda #<$c520 
        sta dest_lo
        lda #>$c520
        sta dest_hi
				
		ldx #00
@	
		lda #08
		sta blitsize
		jsr screenblit
		
		lda #56
		jsr addadest
		
		lda #08
		jsr addasource
		
		lda #08
		sta blitsize
		jsr screenblit

		lda #56
		sta subnum
		jsr subdest
		
		jsr addline
		lda #08
		jsr addasource
		
		inx
		cpx #09
		bne @-	

;-----------------------------------------------		
		
		; small dollar reward sign
		lda #<$cf29 
        sta dest_lo
        lda #>$cf29
        sta dest_hi
				
		ldx #80		
		jsr fontblit_special
		
		;top left corner of screen
;		lda #<L4000 ; LD HL,L4000
;        sta z80_l
;        lda #>L4000
;        sta z80_h
;		
;		; static in game graphics poss
;        lda #<L5E91 ; LD DE,L5E91
;        sta z80_e
;        lda #>L5E91
;        sta z80_d
;		
;        lda #$12 ; LD C,12
;        sta z80_c
;@@417   lda #$08 ; LD B,08
;        sta z80_b
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;@@418   ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa 
;        ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        tax
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;		
;		; static in game graphics data
;        lda #<L8B48 ; LD BC,L8B48
;        sta z80_c
;        lda #>L8B48
;        sta z80_b
;        txa
;		
;		; draw poster static
;        jsr LD632 ; CALL LD632 ; uses A as parameter
;       
;	    pla ; POP BC
;        sta z80_b
;        pla
;        sta z80_c
;        inc z80_l ; INC L
;        dec z80_b ; DJNZ @@418
;        jne @@418
;        pla ; POP HL
;        sta z80_h
;        pla
;        sta z80_l
;        
;		jsr LD648 ; CALL LD648
;        
;		dec z80_c ; DEC C
;        jne @@417 ; JR NZ,@@417

		
		; enemy name text
        jsr enemy_name_txt ; CALL LB1F2
        
		
		lda BanditId ; LD A,(LA262)
		
		;lda #08
		;sta BanditId
		
        ldx #<LB492 ; LD HL,LB492
        stx z80_l
        ldx #>LB492
        stx z80_h
		
        jsr LD26E ; CALL LD26E ; uses A as parameter
        
		ldy #$00 ; LD L,(HL)
        lda (z80_hl),y
        sta z80_l
        lda #$00 ; LD H,00
        sta z80_h
        lda z80_l ; LD C,L
        sta z80_c
        lda z80_h ; LD B,H
        sta z80_b
        asl z80_l ; ADD HL,HL
        rol z80_h
        asl z80_l ; ADD HL,HL
        rol z80_h
        jsr add_hl_bc ; ADD HL,BC

		
		; enemy face on poster
        lda #<LB5AE ; LD BC,LB5AE
        sta z80_c
        lda #>LB5AE
        sta z80_b
        
		jsr add_hl_bc ; ADD HL,BC
        inc z80_l ; INC HL
        bne *+4
        inc z80_h
        ;jsr ex_de_hl ; EX DE,HL
	jsr ld_de_hl
	
		; screen poss start orginal @ $cf42
        ;lda #<L4F42 ; LD HL,L4F42
        ;sta z80_l
        ;lda #>L4F42
        ;sta z80_h
 
		; screen poss start new @ $cc97
		lda #<$ccb7 
        sta dest_lo		
        lda #>$ccb7
        sta dest_hi 
 
		lda #$04 ; LD B,04
        sta z80_b
@@419   ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        tax
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        txa
		
		
		; face blit
        jsr enemy_face_blit ; CALL LD3F9
        
		
		pla ; POP HL
        sta z80_h
        pla
        sta z80_l
        
		
		jsr LD652 ; CALL LD652
        		
		pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
		
		
		
        dec z80_b ; DJNZ @@419
		jne @@419
		
		;jmp *
		
        jmp draw_bounty_reward ; JP LD41C

;LD3F9   EX DE,HL
;D3FA    LD BC,L6AC6
;D3FD    CALL LC74B
;D400    LD (LA21D),SP
;D404    LD SP,HL
;D405    EX DE,HL
;D406    LD B,08
;@@420   POP DE
;D409    LD (HL),E
;D40A    INC HL
;D40B    LD (HL),D
;D40C    INC HL
;D40D    POP DE
;D40E    LD (HL),E
;D40F    INC HL
;D410    LD (HL),D
;D411    LD DE,LFEFD
;D414    ADD HL,DE
;D415    DJNZ @@420
;D417    LD SP,(LA21D)
;D41B    RET

; face blit, had fun picking this to bits!
;LD3F9
enemy_face_blit

	sta z80_a
        jsr ex_de_hl ; EX DE,HL ; A read at the beginning of the block
        ldx #<L6AC6 ; LD BC,L6AC6
        stx z80_c
        ldx #>L6AC6
        stx z80_b
        lda z80_a
        jsr LC74B ; CALL LC74B ; uses A as parameter
        ; LD (LA21D),SP ; LD (LA21D),SP
        ; LD SP,HL ; LD SP,HL
		lda z80_l
		sta z80_sp
		lda z80_h
		sta z80_sp+1
        jsr ex_de_hl ; EX DE,HL
        lda #$08 ; LD B,08
        sta z80_b
@@420   ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		ldy #$00
		lda (z80_sp),y
		sta z80_e
		iny
		lda (z80_sp),y
		sta z80_d
		lda #$02
		clc
		adc z80_sp
		sta z80_sp
		scc:inc z80_sp+1				
        lda z80_e ; LD (HL),E
        ldy #$00
        
		;sta (z80_hl),y
		
		sta (dest_lo),y

		lda #08
		jsr addadest
		
		;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
        
		lda z80_d ; LD (HL),D
        ldy #$00

        sta (dest_lo),y
		
		;sta (z80_hl),y
        
		lda #08
		jsr addadest
		
		;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		
        ;pla ; POP DE
        ;sta z80_d
        ;pla
        ;sta z80_e
		
		ldy #$00
		lda (z80_sp),y
		sta z80_e
		iny
		lda (z80_sp),y
		sta z80_d
		lda #$02
		clc
		adc z80_sp
		sta z80_sp
		scc:inc z80_sp+1				
        lda z80_e ; LD (HL),E
        ldy #$00
        
		;sta (z80_hl),y

        sta (dest_lo),y       

		lda #08
		jsr addadest
		
		;inc z80_l ; INC HL
        ;bne *+4
        ;inc z80_h
		
        lda z80_d ; LD (HL),D
        ldy #$00
        	
		;sta (z80_hl),y

        sta (dest_lo),y
        
		lda #<LFEFD ; LD DE,LFEFD
        sta z80_e
        lda #>LFEFD
        sta z80_d
        jsr add_hl_de ; ADD HL,DE
		
		;lda dest_lo
		;sec
		;sbc #25
		;sta dest_lo
		;scs:dec dest_hi

		lda #25
		sta subnum
		jsr subdest
		
        dec z80_b ; DJNZ @@420
        jne @@420

		; move up one char row
		sec		
		lda dest_lo
		sbc #$38
		sta dest_lo
		lda dest_hi
		sbc #$01
		sta dest_hi
			
        ; LD SP,(LA21D): TODO  ; LD SP,(LA21D)
        rts ; RET

;LD41C   LD A,(LA262)
;D41F    LD C,A
;D420    ADD A,A
;D421    ADD A,C
;D422    LD HL,LB56C
;D425    CALL LD26E
;D428    EX DE,HL
;D429    LD HL,L4882
;D42C    LD B,03
;@@421   LD A,(DE)
;D42F    AND F0
;D431    JR NZ,@@423
;D433    LD A,(DE)
;D434    AND 0F
;D436    JR NZ,@@424
;D438    INC DE
;D439    DJNZ @@421
;D43B    RET

draw_bounty_reward
		
		lda BanditId ; LD A,(LA262)
		;lda #19
        sta z80_c ; LD C,A
        asl @ ; ADD A,A
        clc ; ADD A,C
        adc z80_c
        
		; bounty amount
		ldx #<LB56C ; LD HL,LB56C
        stx z80_l
        ldx #>LB56C
        stx z80_h
        
		jsr LD26E ; CALL LD26E ; uses A as parameter
        
		;jsr ex_de_hl ; EX DE,HL
		jsr ld_de_hl
		; screen poss
        ;lda #<L4882 ; LD HL,L4882
        ;sta z80_l
        ;lda #>L4882
        ;sta z80_h
  
  
		; screen poss
        lda #<$cf31 ; LD HL,L4882
        sta dest_lo
        lda #>$cf31
        sta dest_hi
  
		lda #$03 ; LD B,03
        sta z80_b
@@421   ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        and #$F0 ; AND F0
        jne @@423 ; JR NZ,@@423
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        and #$0F ; AND 0F
        jne @@424 ; JR NZ,@@424
        inc z80_e ; INC DE
        bne *+4
        inc z80_d
        dec z80_b ; DJNZ @@421
        jne @@421
        rts ; RET

;@@423   LD A,(DE)
;D43D    RRCA
;D43E    RRCA
;D43F    RRCA
;D440    RRCA
;D441    AND 0F
;D443    PUSH BC
;D444    LD BC,L8EAF
;D447    CALL LD65C
;D44A    INC L
;D44B    POP BC
;@@424   PUSH BC
;D44D    LD BC,L8EAF
;D450    LD A,(DE)
;D451    INC DE
;D452    AND 0F
;D454    CALL LD65C
;D457    INC L
;D458    POP BC
;D459    DJNZ @@423
;D45B    RET

@@423   ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$0F ; AND 0F
        tax
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda #<L8EAF ; LD BC,L8EAF
        sta z80_c
        lda #>L8EAF
        sta z80_b
        txa
		
		asl
		asl
		asl
		tax
			
		jsr fontblit_special
		
        ;jsr DrawCharacter ; CALL LD65C ; uses A as parameter
		
		inc z80_l ; INC L
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
@@424   lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda #<L8EAF ; LD BC,L8EAF
        sta z80_c
        lda #>L8EAF
        sta z80_b
        ldy #$00 ; LD A,(DE)
        lda (z80_de),y
        inc z80_e ; INC DE
        bne *+4
        ;bne @+
		
		inc z80_d
		
        and #$0F ; AND 0F
			
		asl
		asl
		asl
		tax
		jsr fontblit_special
		
        ;jsr DrawCharacter ; CALL LD65C ; uses A as parameter     
        
		inc z80_l ; INC L
        pla ; POP BC
        sta z80_b
        pla
        sta z80_c
        dec z80_b ; DJNZ @@423
        jne @@423
        
		
		rts ; RET

;LD45C   LD A,4F
;D45E    EX AF,AF'
;D45F    LD BC,(LA20F)
;D463    LD HL,L500C
;D466    CALL LD26B
;D469    LD A,12
;D46B    CALL LD632
;D46E    INC L
;D46F    LD E,0E
;D471    LD A,13
;D473    CALL LD628
;D476    LD A,52
;D478    CALL LD632
;D47B    LD HL,L502C
;D47E    CALL LD26B
;D481    LD E,06
;D483    LD A,14
;D485    CALL LD61C
;D488    LD HL,L503B
;D48B    CALL LD26B
;D48E    LD E,06
;D490    LD A,54
;D492    CALL LD61C
;D495    LD HL,L50EC
;D498    CALL LD26B
;D49B    LD A,92
;D49D    CALL LD632
;D4A0    INC L
;D4A1    LD E,03
;D4A3    LD A,93
;D4A5    CALL LD628
;D4A8    LD HL,L50F8
;D4AB    CALL LD26B
;D4AE    LD E,03
;D4B0    LD A,93
;D4B2    CALL LD628
;D4B5    LD A,D2
;D4B7    CALL LD632
;D4BA    LD HL,L50F0
;D4BD    CALL LD26B
;D4C0    LD DE,LD4C6
;D4C3    JP LD4D0

;LD45C   lda #$4F ; LD A,4F
;        ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        txa ; 
;        lda LA20F ; LD BC,(LA20F)
;        sta z80_c
;        lda LA20F+1
;        sta z80_b
;        lda #<L500C ; LD HL,L500C
;        sta z80_l
;        lda #>L500C
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #$12 ; LD A,12
;        jsr LD632 ; CALL LD632 ; uses A as parameter
;        inc z80_l ; INC L
;        lda #$0E ; LD E,0E
;        sta z80_e
;        lda #$13 ; LD A,13
;        jsr LD628 ; CALL LD628 ; uses A as parameter
;        lda #$52 ; LD A,52
;        jsr LD632 ; CALL LD632 ; uses A as parameter
;        lda #<L502C ; LD HL,L502C
;        sta z80_l
;        lda #>L502C
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #$06 ; LD E,06
;        sta z80_e
;        lda #$14 ; LD A,14
;        jsr LD61C ; CALL LD61C
;        lda #<L503B ; LD HL,L503B
;        sta z80_l
;        lda #>L503B
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #$06 ; LD E,06
;        sta z80_e
;        lda #$54 ; LD A,54
;        jsr LD61C ; CALL LD61C
;        lda #<L50EC ; LD HL,L50EC
;        sta z80_l
;        lda #>L50EC
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #$92 ; LD A,92
;        jsr LD632 ; CALL LD632 ; uses A as parameter
;        inc z80_l ; INC L
;        lda #$03 ; LD E,03
;        sta z80_e
;        lda #$93 ; LD A,93
;        jsr LD628 ; CALL LD628 ; uses A as parameter
;        lda #<L50F8 ; LD HL,L50F8
;        sta z80_l
;        lda #>L50F8
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #$03 ; LD E,03
;        sta z80_e
;        lda #$93 ; LD A,93
;        jsr LD628 ; CALL LD628 ; uses A as parameter
;        lda #$D2 ; LD A,D2
;        jsr LD632 ; CALL LD632
;        lda #<L50F0 ; LD HL,L50F0
;        sta z80_l
;        lda #>L50F0
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #<LD4C6 ; LD DE,LD4C6
;        sta z80_e
;        lda #>LD4C6
;        sta z80_d
;        jmp LD4D0 ; JP LD4D0

;LD4C6   DB 4F,54,45,4C,45,47,52,41 ; OTELEGRA
;D4CE    DB 4D,00

;LD4C6   .he 4F,54,45,4C,45,47,52,41 ; DB 4F,54,45,4C,45,47,52,41
;        .he 4D,00 ; DB 4D,00

;LD4D0   LD A,(DE)
;D4D1    INC DE
;D4D2    EX AF,AF'
;@@425   LD A,(DE)
;D4D4    AND A
;D4D5    RET Z
;D4D6    INC DE
;D4D7    CALL LD4E3
;D4DA    LD BC,L8EA8
;D4DD    CALL LD632
;D4E0    INC L
;D4E1    JR @@425

;LD4D0   ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa ; 
;@@425   ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        ; AND  A
;        bne *+3 ; RET Z
;        rts
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        jsr LD4E3 ; CALL LD4E3 ; uses A as parameter
;        ldx #<L8EA8 ; LD BC,L8EA8
;        stx z80_c
;        ldx #>L8EA8
;        stx z80_b
;        jsr LD632 ; CALL LD632 ; uses A as parameter
;        inc z80_l ; INC L
;        jmp @@425 ; JR @@425

;LD4E3   SUB 20
;D4E5    LD C,A
;D4E6    AND 3F
;D4E8    RET Z
;D4E9    LD A,C
;D4EA    SUB 0F
;D4EC    LD C,A
;D4ED    AND 3F
;D4EF    CP 0B
;D4F1    RET C
;D4F2    LD A,C
;D4F3    SUB 07
;D4F5    RET

LD4E3   sec ; SUB 20
        sbc #$20; A read at the beginning of the block
        sta z80_c ; LD C,A
        and #$3F ; AND 3F
        bne *+3 ; RET Z
        rts
        lda z80_c ; LD A,C
        sec ; SUB 0F
        sbc #$0F
        sta z80_c ; LD C,A
        and #$3F ; AND 3F
        cmp #$0B ; CP 0B
        bcs *+3 ; RET C
        rts
        lda z80_c ; LD A,C
        sec ; SUB 07
        sbc #$07
        rts ; RET

;LD4F6   LD L,00
;@@426   LD D,00
;D4FA    LD E,L
;D4FB    LD H,FF
;D4FD    LD B,03
;@@427   SLA E
;D501    RL D
;D503    SLA E
;D505    RL D
;D507    LD (HL),E
;D508    DEC H
;D509    LD (HL),D
;D50A    DEC H
;D50B    DJNZ @@427
;D50D    INC L
;D50E    JR NZ,@@426
;D510    LD L,00
;@@428   LD D,00
;D514    LD B,08
;D516    LD A,L
;@@429   RRCA
;D518    RL C
;D51A    DJNZ @@429
;D51C    LD E,C
;D51D    LD H,F7
;D51F    LD B,03
;@@430   SLA E
;D523    RL D
;D525    SLA E
;D527    RL D
;D529    LD (HL),E
;D52A    DEC H
;D52B    LD (HL),D
;D52C    DEC H
;D52D    DJNZ @@430
;D52F    INC L
;D530    JR NZ,@@428
;D532    LD HL,LF900
;@@431   LD D,L
;D536    LD B,08
;@@432   SRL D
;D53A    RL E
;D53C    DJNZ @@432
;D53E    LD (HL),E
;D53F    INC L
;D540    JR NZ,@@431
;D542    RET

;LD4F6   lda #$00 ; LD L,00
;        sta z80_l
;@@426   lda #$00 ; LD D,00
;        sta z80_d
;        lda z80_l ; LD E,L
;        sta z80_e
;        ;lda #$FF ; LD H,FF ; lookup table address
;        lda #>[RotationTable+$f00]
;        sta z80_h
;        lda #$03 ; LD B,03
;        sta z80_b
;@@427   asl z80_e ; SLA E
;        rol z80_d ; RL D
;        asl z80_e ; SLA E
;        rol z80_d ; RL D
;        lda z80_e ; LD (HL),E
;        ldy #$00
;        sta (z80_hl),y
;        dec z80_h ; DEC H
;        lda z80_d ; LD (HL),D
;        ldy #$00
;        sta (z80_hl),y
;        dec z80_h ; DEC H
;        dec z80_b ; DJNZ @@427
;        jne @@427
;        inc z80_l ; INC L
;        jne @@426 ; JR NZ,@@426
;        lda #$00 ; LD L,00
;        sta z80_l
;@@428   lda #$00 ; LD D,00
;        sta z80_d
;        lda #$08 ; LD B,08
;        sta z80_b
;        lda z80_l ; LD A,L
;@@429   lsr @ ; RRCA
;        rol z80_c ; RL C
;        dec z80_b ; DJNZ @@429
;        jne @@429
;        lda z80_c ; LD E,C
;        sta z80_e
;        ;lda #$F7 ; LD H,F7 ; lookup table address
;        lda #>[RotationTable+$0700]
;        sta z80_h
;        lda #$03 ; LD B,03
;        sta z80_b
;@@430   asl z80_e ; SLA E
;        rol z80_d ; RL D
;        asl z80_e ; SLA E
;        rol z80_d ; RL D
;        lda z80_e ; LD (HL),E
;        ldy #$00
;        sta (z80_hl),y
;        dec z80_h ; DEC H
;        lda z80_d ; LD (HL),D
;        ldy #$00
;        sta (z80_hl),y
;        dec z80_h ; DEC H
;        dec z80_b ; DJNZ @@430
;        jne @@430
;        inc z80_l ; INC L
;        jne @@428 ; JR NZ,@@428
;        lda #<MirrorTable ; LD HL,LF900 ; lookup mirror table address
;        sta z80_l
;        lda #>MirrorTable
;        sta z80_h
;@@431   lda z80_l ; LD D,L
;        sta z80_d
;        lda #$08 ; LD B,08
;        sta z80_b
;@@432   lsr z80_d ; SRL D
;        rol z80_e ; RL E
;        dec z80_b ; DJNZ @@432
;        jne @@432
;        lda z80_e ; LD (HL),E
;        ldy #$00
;        sta (z80_hl),y
;        inc z80_l ; INC L
;        jne @@431 ; JR NZ,@@431
;        rts ; RET

;LD543   LD A,47
;D545    EX AF,AF'
;D546    LD DE,LD55A
;D549    LD A,(LA269)
;D54C    AND A
;D54D    LD HL,L50C0
;D550    JR NZ,@@433
;D552    LD HL,L5070
;@@433   LD BC,L0202
;D558    JR LD58E

;LD543   lda #$47 ; LD A,47
;        ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa 
;        lda #<LD55A ; LD DE,LD55A
;        sta z80_e
;        lda #>LD55A
;        sta z80_d
;        lda game_on ; LD A,(LA269)
;        ; AND  A
;        php
;        lda #<L50C0 ; LD HL,L50C0
;        sta z80_l
;        lda #>L50C0
;        sta z80_h
;        plp
;        jne @@433 ; JR NZ,@@433; ZERO flag read but not set by previous instruction
;        lda #<L5070 ; LD HL,L5070
;        sta z80_l
;        lda #>L5070
;        sta z80_h
;@@433   lda #<L0202 ; LD BC,L0202
;        sta z80_c
;        lda #>L0202
;        sta z80_b
;        jmp LD58E ; JR LD58E

;LD55A   DB 15,16,17,18

LD55A   .he 15,16,17,18 ; DB 15,16,17,18

;LD55E   LD A,41
;D560    EX AF,AF'
;D561    LD HL,L5004
;D564    CALL LD26B
;D567    LD DE,L5E51
;D56A    LD BC,L0808
;D56D    CALL LD58E
;D570    LD A,(LA264)
;D573    AND A
;D574    RET Z
;D575    LD E,A
;D576    XOR A
;@@434   PUSH AF
;D578    PUSH DE
;D579    LD BC,LC9D9
;D57C    CALL LC74B
;D57F    CALL LD26B
;D582    LD A,71
;D584    CALL LC9C8
;D587    POP DE
;D588    POP AF
;D589    INC A
;D58A    CP E
;D58B    JR NZ,@@434
;D58D    RET

; draw barrel org
;LD55E   

;		lda #$41 ; LD A,41
;        ;ldx z80_ap ; EX AF,AF'
;        sta z80_ap
;        ;txa 
;
;		; screen poss
;        ;lda #<L5004 ; LD HL,L5004
;        ;sta z80_l
;        ;lda #>L5004
;        ;sta z80_h
;
;		lda #<BARR3
;		sta z80_l
;		lda #>BARR3
;		sta z80_h		
;		
;		lda #$30 ; Open up all RAM
;		sta $01 
;		
;        jsr LD26B ; CALL LD26B
;
;		; barrel gfx data
;        lda #<L5E51 ; LD DE,L5E51
;        sta z80_e
;        lda #>L5E51
;        sta z80_d
;
;		; $0808
;        lda #<L0808 ; LD BC,L0808
;        sta z80_c
;        lda #>L0808
;        sta z80_b
;		
;        jsr LD58E ; CALL LD58E
;
;		lda #$35 ; IO back in
;		sta $01 

draw_barrel_colour

;		lda bandit_screen
;		bne dbco01
	
		lda #$88
		sta dest_lo
;		jmp dbco02
;dbco01
;		lda #$88
;		sta dest_lo
;dbco02		
		lda #$ba
		sta dest_hi
		
		lda #$06
		sta colourcode
		lda #12
		sta blitsize
		
		ldx #00
@		
		jsr colourblit
		
		lda #40
		jsr addadest

		inx
		cpx #08
		bne @-	
	
		
        lda LA264 ; LD A,(LA264)
        ; AND  A
        bne *+3 ; RET Z
        rts

        sta z80_e ; LD E,A; 
        lda #$00 ; XOR A
@@434   sta z80_a
        pha ; PUSH AF
        php
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha


        ;lda #<LC9D9 ; LD BC,LC9D9
        ;sta z80_c
        ;lda #>LC9D9
        ;sta z80_b
        lda z80_a
        ;jsr LC74B ; CALL LC74B ; uses A as parameter
		asl @
		tax
		lda LC9D9,x
		sta z80_l
		lda LC9D9+1,x
		sta z80_h




        jsr LD26B ; CALL LD26B
        
		; colour barrel
		lda #$61 ; LD A,71
        jsr LC9C8 ; CALL LC9C8
        
		pla ; POP DE
        sta z80_d
        pla
        sta z80_e
        plp ; POP AF
        pla
        clc ; INC A
        adc #$01
        cmp z80_e ; CP E
        jne @@434 ; JR NZ,@@434
        rts ; RET

;LD58E   PUSH BC
;D58F    PUSH HL
;@@437   LD A,(DE)
;D591    INC DE
;D592    PUSH BC
;D593    LD BC,(LA20F)
;D597    CALL LD632
;D59A    POP BC
;D59B    INC L
;D59C    DJNZ @@437
;D59E    POP HL
;D59F    CALL LD648
;D5A2    POP BC
;D5A3    DEC C
;D5A4    JR NZ,LD58E
;D5A6    RET

;LD58E   lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;@@437   ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        tax
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda LA20F ; LD BC,(LA20F)
;        sta z80_c
;        lda LA20F+1
;        sta z80_b
;        txa
;        jsr LD632 ; CALL LD632 ; uses A as parameter
;        pla ; POP BC
;        sta z80_b
;        pla
;        sta z80_c
;        inc z80_l ; INC L
;        dec z80_b ; DJNZ @@437
;        jne @@437
;        pla ; POP HL
;        sta z80_h
;        pla
;        sta z80_l
;        jsr LD648 ; CALL LD648
;        pla ; POP BC
;        sta z80_b
;        pla
;        sta z80_c
;        dec z80_c ; DEC C
;        jne LD58E ; JR NZ,LD58E
;        rts ; RET

;LD5A7   PUSH BC
;D5A8    PUSH HL
;@@439   LD A,(DE)
;D5AA    INC DE
;D5AB    XOR 40
;D5AD    PUSH BC
;D5AE    LD BC,(LA20F)
;D5B2    CALL LD632
;D5B5    POP BC
;D5B6    DEC L
;D5B7    DJNZ @@439
;D5B9    POP HL
;D5BA    CALL LD648
;D5BD    POP BC
;D5BE    DEC C
;D5BF    JR NZ,LD5A7
;D5C1    RET

;LD5A7   lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;@@439   ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        inc z80_e ; INC DE
;        bne *+4
;        inc z80_d
;        eor #$40 ; XOR 40; 
;        tax
;        lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda LA20F ; LD BC,(LA20F)
;        sta z80_c
;        lda LA20F+1
;        sta z80_b
;        txa
;        jsr LD632 ; CALL LD632 ; uses A as parameter
;        pla ; POP BC
;        sta z80_b
;        pla
;        sta z80_c
;        dec z80_l ; DEC L
;        dec z80_b ; DJNZ @@439
;        jne @@439
;        pla ; POP HL
;        sta z80_h
;        pla
;        sta z80_l
;        jsr LD648 ; CALL LD648
;        pla ; POP BC
;        sta z80_b
;        pla
;        sta z80_c
;        dec z80_c ; DEC C
;        jne LD5A7 ; JR NZ,LD5A7
;        rts ; RET

;LD5C2   LD A,73
;D5C4    EX AF,AF'
;D5C5    LD BC,(LA20F)
;D5C9    LD HL,L4004
;D5CC    CALL LD26B
;D5CF    LD A,01
;D5D1    CALL LD632
;D5D4    INC L
;D5D5    LD E,16
;D5D7    LD A,02
;D5D9    CALL LD628
;D5DC    LD HL,L401B
;D5DF    CALL LD26B
;D5E2    LD A,41
;D5E4    CALL LD632
;D5E7    LD HL,L48E4
;D5EA    CALL LD26B
;D5ED    LD A,81
;D5EF    CALL LD632
;D5F2    INC L
;D5F3    LD E,16
;D5F5    LD A,82
;D5F7    CALL LD628
;D5FA    LD HL,L48FB
;D5FD    CALL LD26B
;D600    LD A,C1
;D602    CALL LD632
;D605    LD HL,L4024
;D608    CALL LD26B
;D60B    LD E,0E
;D60D    LD A,03
;D60F    CALL LD61C
;D612    LD HL,L403B
;D615    CALL LD26B
;D618    LD E,0E
;D61A    LD A,43
;LD61C   PUSH AF
;D61D    CALL LD632
;D620    CALL LD648
;D623    POP AF
;D624    DEC E
;D625    JR NZ,LD61C
;D627    RET


draw_border_colour

		lda game_on
		beq dbc01
				
		;border colour
		lda #$0c
		sta dest_lo
		jmp dbc02

dbc01:

		lda #$08
		sta dest_lo
dbc02:
		
		lda #$b8
		sta dest_hi	
		
		lda #$13
		sta colourcode
		lda #24
		sta blitsize
		jsr colourblit

		lda game_on
		beq dbc03
		
		lda #$64
		sta dest_lo
		jmp dbc04

dbc03:
		lda #$60
		sta dest_lo
dbc04:
		
		lda #$ba
		sta dest_hi	
		jsr colourblit

		lda game_on
		beq dbc05		
		
		lda #$34
		sta dest_lo
		jmp dbc06

dbc05:
		lda #$30
		sta dest_lo
dbc06:		
		
		lda #$b8
		sta dest_hi
	
		lda #01
		sta blitsize
		jsr colourblit
		
		ldx #00
@		
		lda #40
		jsr addadest
		
		jsr colourblit
		inx
		cpx #13
		bne @-

		lda game_on
		beq dbc07			
		
		lda #$4b
		sta dest_lo
		jmp dbc08
		
dbc07:
		lda #$47
		sta dest_lo
dbc08:
		
		lda #$b8
		sta dest_hi
		
		
		lda #01
		sta blitsize
		jsr colourblit
		
		ldx #00
@		
		lda #40
		jsr addadest
		jsr colourblit
		inx
		cpx #13
		bne @-

		rts
		
draw_border

		; clears all screen to bonus yellow
		; colour set in A
		
		;lda	#$70
		;jsr c64clearcols

		jsr draw_border_colour
		
		lda game_on
		beq db01
		
		;top border
		lda #<BDRHO
		sta dest_lo
		lda #>BDRHO
		sta dest_hi
		jmp db02

db01:

		lda #<BDRHOB
		sta dest_lo
		lda #>BDRHOB
		sta dest_hi

db02:		
		
		lda #<BORDERH
		sta source_lo
		lda #>BORDERH
		sta source_hi	
		lda #22
		sta blitsize
		jsr blockblit
	
		; bottom border
		lda #03
		sta	hflip_flag
		jsr vbyteflip		

		lda game_on
		beq db03
		
		lda #<BDRLO
		sta dest_lo
		lda #>BDRLO
		sta dest_hi
		jmp db04
		
db03:
		lda #<BDRLOB
		sta dest_lo
		lda #>BDRLOB
		sta dest_hi
db04:
		
		lda #<BORDERH
		sta source_lo
		lda #>BORDERH
		sta source_hi
		jsr blockblit
		lda #00
		sta	hflip_flag

		lda game_on
		beq db05
		
		;left border
		lda #<BDRLE
		sta dest_lo
		lda #>BDRLE
		sta dest_hi
		jmp db06

db05:
		lda #<BDRLEB
		sta dest_lo
		lda #>BDRLEB
		sta dest_hi
db06:		
		
		lda #<BORDERS
		sta source_lo
		lda #>BORDERS
		sta source_hi

		ldx #$00
		
		lda #08
		sta blitsize
				
@		jsr screenblit		
		jsr addline
		inx
		cpx #14
		bne @-

		;right border
		lda #01
		sta hflip_flag		

		ldx #$00

		lda game_on
		beq db07		
		
		lda #<BDRRI
		sta dest_lo
		lda #>BDRRI
		sta dest_hi
		jmp db08
		
db07:
		lda #<BDRRIB
		sta dest_lo
		lda #>BDRRIB
		sta dest_hi
db08:
		
@		jsr screenblit	
		jsr addline
		inx
		cpx #14
		bne @-		

		lda #00
		sta hflip_flag

		lda game_on
		beq db09
		
		; border corner 1
		lda #<BDRC1
		sta dest_lo
		lda #>BDRC1
		sta dest_hi
		jmp db10
		
db09:
		lda #<BDRC1B
		sta dest_lo
		lda #>BDRC1B
		sta dest_hi
db10:		
		
		lda #<BORDERC
		sta source_lo
		lda #>BORDERC
		sta source_hi		

		jsr screenblit		
		
		; border corner 2
		lda #01
		sta hflip_flag		

		lda game_on
		beq db11
		
		lda #<BDRC2
		sta dest_lo
		lda #>BDRC2
		sta dest_hi
		jmp db12
		
db11:
		lda #<BDRC2B
		sta dest_lo
		lda #>BDRC2B
		sta dest_hi
db12:
		
		jsr screenblit

		; border corner 3
		lda #02
		sta	hflip_flag
		
		jsr vbyteflip

		lda game_on
		beq db13
		
		lda #<BDRC3
		sta dest_lo
		lda #>BDRC3
		sta dest_hi
		jmp db14

db13:
		lda #<BDRC3B
		sta dest_lo
		lda #>BDRC3B
		sta dest_hi
db14:		
		
		jsr screenblit

		; border corner 4
		lda #03
		sta	hflip_flag
		
		jsr vbyteflip

		lda game_on
		beq db15
		
		lda #<BDRC4
		sta dest_lo
		lda #>BDRC4
		sta dest_hi
		jmp db16

db15:
		lda #<BDRC4B
		sta dest_lo
		lda #>BDRC4B
		sta dest_hi
db16:
		
		jsr screenblit

		lda #00
		sta	hflip_flag
		
		rts

draw_small_border_colour

		lda game_on
		beq dsbc01
		
		; small border colour
		lda #$94
		sta dest_lo
;		lda #$f2
;		sta dest_hi
		jmp dsbc02

dsbc01:
		lda #$90
		sta dest_lo

dsbc02:		
		lda #$ba
		sta dest_hi
		
		lda #$14
		sta colourcode
		
		ldx #00
@	
		lda #16
		sta blitsize
		jsr colourblit		

		lda #40
		jsr addadest
		
		inx
		cpx #08
		bne @-

		lda game_on
		beq dsbc03		
		
		; small text box colour
		lda #$bd
		sta dest_lo
		jmp dsbc04

dsbc03:
		lda #$b9
		sta dest_lo
dsbc04:

		lda #$ba
		sta dest_hi
		
		lda #$0f
		sta colourcode
		
		ldx #00
@	
		lda #14
		sta blitsize
		jsr colourblit		

		lda #40
		jsr addadest
		
		inx
		
		cpx #04
		bne @+
		lda #$07
		sta colourcode
		
@		
		cpx #06
		bne @-1

		rts

draw_small_border

		jsr draw_small_border_colour

		lda game_on
		beq dsb01
		
		;small top border
		lda #<SDRHO
		sta dest_lo
		lda #>SDRHO
		sta dest_hi
		
		jmp dsb02

dsb01:

		;small top border
		lda #<SDRHOB
		sta dest_lo
		lda #>SDRHOB
		sta dest_hi

dsb02:
		
		lda #<SBORDEH
		sta source_lo
		lda #>SBORDEH
		sta source_hi	
		lda #14
		sta blitsize
		jsr blockblit

		lda game_on
		beq dsb03
		
		; small bottom border	
		lda #<SDRLO
		sta dest_lo
		lda #>SDRLO
		sta dest_hi
		jmp dsb04
		
dsb03:		
		; small bottom border	
		lda #<SDRLOB
		sta dest_lo
		lda #>SDRLOB
		sta dest_hi

dsb04:
		
		lda #<SBORDEH
		sta source_lo
		lda #>SBORDEH
		sta source_hi
		jsr blockblit

		lda game_on
		beq dsb05
		
		;small left border
		lda #<SDRLE
		sta dest_lo
		lda #>SDRLE
		sta dest_hi
		jmp dsb06
		
dsb05:

		lda #<SDRLEB
		sta dest_lo
		lda #>SDRLEB
		sta dest_hi

dsb06:		
		
		lda #<SBORDES
		sta source_lo
		lda #>SBORDES
		sta source_hi

		ldx #$00
		
		lda #08
		sta blitsize
				
@		jsr screenblit		
		jsr addline
		inx
		cpx #06
		bne @-

		;small right border
		lda #01
		sta hflip_flag		

		ldx #$00

		lda game_on
		beq dsb07		
		
		lda #<SDRRI
		sta dest_lo
		lda #>SDRRI
		sta dest_hi
		jmp dsb08

dsb07:

		lda #<SDRRIB
		sta dest_lo
		lda #>SDRRIB
		sta dest_hi

dsb08:
		
@		jsr screenblit	
		jsr addline
		inx
		cpx #06
		bne @-		

		lda #00
		sta hflip_flag	

		lda game_on
		beq dsb09		
		
		; small border corner 1
		lda #<SDRC1
		sta dest_lo
		lda #>SDRC1
		sta dest_hi
		jmp dsb10
dsb09:
		lda #<SDRC1B
		sta dest_lo
		lda #>SDRC1B
		sta dest_hi

dsb10:		
		
		lda #<SBORDEC
		sta source_lo
		lda #>SBORDEC
		sta source_hi		

		jsr screenblit

		; small border corner 2
		lda #01
		sta hflip_flag		

		lda game_on
		beq dsb11
		
		lda #<SDRC2
		sta dest_lo
		lda #>SDRC2
		sta dest_hi
		jmp dsb12

dsb11:

		lda #<SDRC2B
		sta dest_lo
		lda #>SDRC2B
		sta dest_hi

dsb12:
		
		jsr screenblit

		; small border corner 3
		lda #02
		sta	hflip_flag
		
		jsr vbyteflip

		lda game_on
		beq dsb13
		
		lda #<SDRC3
		sta dest_lo
		lda #>SDRC3
		sta dest_hi
		jmp dsb14
dsb13:

		lda #<SDRC3B
		sta dest_lo
		lda #>SDRC3B
		sta dest_hi

dsb14:		
		jsr screenblit

		; small border corner 4
		lda #03
		sta	hflip_flag
		
		jsr vbyteflip

		lda game_on
		beq dsb15
		
		lda #<SDRC4
		sta dest_lo
		lda #>SDRC4
		sta dest_hi
		jmp dsb16

dsb15:
		lda #<SDRC4B
		sta dest_lo
		lda #>SDRC4B
		sta dest_hi

dsb16:		

		jsr screenblit

		lda #00
		sta	hflip_flag

		lda game_on
		beq dsb17		
		
		; telegram txt
		lda #<TELET
		sta dest_lo
		lda #>TELET
		sta dest_hi
		jmp dsb18

dsb17:
		lda #<TELETB
		sta dest_lo
		lda #>TELETB
		sta dest_hi
dsb18:

		
		lda #01
		sta alpha		
		
		ldx #00
@	
		lda telealpha,x
		stx count_temp
		tax
		jsr fontblit
		ldx count_temp
		inx
		
		cpx #08
		bne @-	
		
		rts
		
draw_bonus_guns

		lda game_on 
        beq *+3
        rts
		
		;right gun colour
		lda #$34
		sta dest_lo
		lda #$ba
		sta dest_hi	
		lda #$04
		sta colourcode
		lda #04
		sta blitsize
		
		ldx #00
@		
		jsr colourblit
		
		lda #40
		jsr addadest

		inx
		cpx #10
		bne @-

		;left gun colour
		lda #$50
		sta dest_lo
		lda #$ba
		sta dest_hi	
		lda #$04
		sta colourcode
		lda #04
		sta blitsize
		
		ldx #00
@		
		jsr colourblit
		
		lda #40
		jsr addadest

		inx
		cpx #10
		bne @-	

		
		
		; gun right
		lda #<RGUNBEG
		sta source_lo
		lda #>RGUNBEG
		sta source_hi
		
		lda #<GUNR
		sta dest_lo
		lda #>GUNR
		sta dest_hi

		ldx #00
@	
		lda #32
		sta blitsize
		jsr screenblit
		
		jsr addline
		lda #32
		jsr addasource
		
		inx
		cpx #10
		bne @-


		; gun left
		lda #<RGUNBEG
		sta source_lo
		lda #>RGUNBEG
		sta source_hi
		
		lda #<GUNL
		sta dest_lo
		lda #>GUNL
		sta dest_hi

		lda #01
		sta hflip_flag
		
		lda #00
		sta count_temp
		
gunl00	
		ldx #00
gunl01		
		lda #08
		sta blitsize
		jsr screenblit		
		
		lda #08
		jsr addasource
		
		;lda dest_lo
		;sec
		;sbc #08
		;sta dest_lo
		;scs:dec dest_hi  

		lda #08
		sta subnum
		jsr subdest
		
		inx
		cpx #04
		bne gunl01
				
		lda #32
		jsr addadest
		jsr addline
		
		inc count_temp
		lda count_temp
		cmp #10
		bne gunl00

		lda #00
		sta hflip_flag			
		
		
		rts
				
draw_barrel

		;barrel left
		lda #<BARELBE
		sta source_lo
		lda #>BARELBE
		sta source_hi

		lda game_on
		beq draw_barrel_001
		
		lda #<BARR1
		sta dest_lo
		lda #>BARR1
		sta dest_hi

		jmp draw_barrel_002
		
draw_barrel_001:
		
		lda #<BARR3
		sta dest_lo
		lda #>BARR3
		sta dest_hi

draw_barrel_002:
		
		ldx #00
@	
		lda #32
		sta blitsize
		jsr screenblit
		
		jsr addline
		lda #32
		jsr addasource
		
		inx
		cpx #08
		bne @-

		
		;barrel right
		lda #<BARELBE
		sta source_lo
		lda #>BARELBE
		sta source_hi

		lda game_on
		beq draw_barrel_003	
		
		lda #<BARR2
		sta dest_lo
		lda #>BARR2
		sta dest_hi

		jmp draw_barrel_004
		
draw_barrel_003:
				
		lda #<BARR4
		sta dest_lo
		lda #>BARR4
		sta dest_hi

draw_barrel_004:
		
		lda #01
		sta hflip_flag
		
		lda #00
		sta count_temp
		
barr00	
		ldx #00
barr01		
		lda #08
		sta blitsize
		jsr screenblit		
		
		lda #08
		jsr addasource
		
		;lda dest_lo
		;sec
		;sbc #08
		;sta dest_lo
		;scs:dec dest_hi

		lda #08
		sta subnum
		jsr subdest
		
		inx
		cpx #04
		bne barr01
				
		lda #32
		jsr addadest
		jsr addline
		
		inc count_temp
		lda count_temp
		cmp #08
		bne barr00

		lda #00
		sta hflip_flag

		jsr draw_barrel_colour
		
		rts
		
draw_dollar
		
		; dollar
		lda game_on
		beq dolla
	
		lda #<DOLL
		sta dest_lo
		lda #>DOLL
		sta dest_hi	

		jmp dollc
		
dolla
		lda #<DOLLB
		sta dest_lo
		lda #>DOLLB
		sta dest_hi	
 
dollc
 
		lda #<DOLLORB
		sta source_lo
		lda #>DOLLORB
		sta source_hi
		
		
		lda #16
		sta blitsize
		jsr screenblit
		
		jsr addline
		lda #16
		jsr addasource
		jsr screenblit
		
		;jmp LD58E
	
		rts

;draw border
;LD5C2
;		lda #$73 ; LD A,73
;       ;ldx z80_ap ; EX AF,AF'
;       sta z80_ap
;        ;txa ; 
;        lda LA20F ; LD BC,(LA20F)
;        sta z80_c
;        lda LA20F+1
;        sta z80_b
;        lda #<L4004 ; LD HL,L4004
;        sta z80_l
;        lda #>L4004
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #$01 ; LD A,01
;        jsr LD632 ; CALL LD632 ; uses A as parameter
;        inc z80_l ; INC L
;        lda #$16 ; LD E,16
;        sta z80_e
;        lda #$02 ; LD A,02
;        jsr LD628 ; CALL LD628 ; uses A as parameter
;        lda #<L401B ; LD HL,L401B
;        sta z80_l
;        lda #>L401B
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #$41 ; LD A,41
;        jsr LD632 ; CALL LD632 ; uses A as parameter
;        lda #<L48E4 ; LD HL,L48E4
;        sta z80_l
;        lda #>L48E4
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #$81 ; LD A,81
;        jsr LD632 ; CALL LD632
;        inc z80_l ; INC L
;        lda #$16 ; LD E,16
;        sta z80_e
;        lda #$82 ; LD A,82
;        jsr LD628 ; CALL LD628 ; uses A as parameter
;        lda #<L48FB ; LD HL,L48FB
;        sta z80_l
;        lda #>L48FB
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #$C1 ; LD A,C1
;        jsr LD632 ; CALL LD632 ; uses A as parameter
;        lda #<L4024 ; LD HL,L4024
;        sta z80_l
;        lda #>L4024
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #$0E ; LD E,0E
;        sta z80_e
;        lda #$03 ; LD A,03
;        jsr LD61C ; CALL LD61C
;        lda #<L403B ; LD HL,L403B
;        sta z80_l
;        lda #>L403B
;        sta z80_h
;        jsr LD26B ; CALL LD26B
;        lda #$0E ; LD E,0E
;        sta z80_e
;        lda #$43 ; LD A,43
;LD61C   pha ; PUSH AF 
;        php; 
;        jsr LD632 ; CALL LD632 ; uses A as parameter
;        jsr LD648 ; CALL LD648
;        plp ; POP AF
;        pla
;        dec z80_e ; DEC E
;        jne LD61C ; JR NZ,LD61C
;        rts ; RET

;LD628   PUSH AF
;D629    CALL LD632
;D62C    POP AF
;D62D    INC L
;D62E    DEC E
;D62F    JR NZ,LD628
;D631    RET

;LD628   pha ; PUSH AF 
;        php; 
;        jsr LD632 ; CALL LD632
;        plp ; POP AF
;        pla
;        inc z80_l ; INC L
;        dec z80_e ; DEC E
;        jne LD628 ; JR NZ,LD628
;        rts ; RET

;LD632   CALL LD65C
;LD635   PUSH DE
;D636    PUSH HL
;D637    LD A,H
;D638    RRCA
;D639    RRCA
;D63A    RRCA
;D63B    AND 03
;D63D    LD H,A
;D63E    LD DE,L5800
;D641    ADD HL,DE
;D642    EX AF,AF'
;D643    LD (HL),A
;D644    EX AF,AF'
;D645    POP HL
;D646    POP DE
;D647    RET

;LD632   jsr DrawCharacter ; CALL LD65C ; A read at the beginning of the block

	
;		lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;        lda z80_h ; LD A,H
;        lsr @ ; RRCA
;        lsr @ ; RRCA
;        lsr @ ; RRCA
;        and #$03 ; AND 03
;        sta z80_h ; LD H,A
;        lda #<L5800 ; LD DE,L5800
;        sta z80_e
;        lda #>L5800
;        sta z80_d
;        jsr add_hl_de ; ADD HL,DE
;        ;ldx z80_ap ; EX AF,AF'
;        ;sta z80_ap
;        ;txa 
;        tax
;        lda z80_ap
;        ldy #$00 ; LD (HL),A
;        
;		sta (z80_hl),y
;        
;		;ldx z80_ap ; EX AF,AF'
;        ;sta z80_ap
;        txa 
;        pla ; POP HL
;        sta z80_h
;        pla
;        sta z80_l
;        pla ; POP DE
;        sta z80_d
;        pla
;        sta z80_e
;        rts ; RET

;LD648   LD A,L
;D649    ADD A,20
;D64B    LD L,A
;D64C    RET NC
;D64D    LD A,H
;D64E    ADD A,08
;D650    LD H,A
;D651    RET

;LD648   lda z80_l ; LD A,L
;        clc ; ADD A,20
;        adc #$20
;        sta z80_l ; LD L,A
;        bcs *+3 ; RET NC
;        rts; 
;        lda z80_h ; LD A,H
;        clc ; ADD A,08
;        adc #$08
;        sta z80_h ; LD H,A
;        rts ; RET

;LD652   LD A,L
;D653    SUB 20
;D655    LD L,A
;D656    RET NC
;D657    LD A,H
;D658    SUB 08
;D65A    LD H,A
;D65B    RET

LD652   lda z80_l ; LD A,L
        sec ; SUB 20
        sbc #$20
        sta z80_l ; LD L,A
        bcc *+3 ; RET NC
        rts
        lda z80_h ; LD A,H
        sec ; SUB 08
        sbc #$08
        sta z80_h ; LD H,A
        rts ; RET

;LD65C   PUSH BC
;D65D    PUSH DE
;D65E    PUSH HL
;D65F    PUSH AF
;D660    EX DE,HL
;D661    AND 3F
;D663    LD L,A
;D664    LD H,00
;D666    ADD HL,HL
;D667    ADD HL,HL
;D668    ADD HL,HL
;D669    ADD HL,BC
;D66A    EX DE,HL
;D66B    POP AF
;D66C    RLCA
;D66D    RLCA
;D66E    AND 03
;D670    JR Z,@@445
;D672    DEC A
;D673    JR Z,@@446
;D675    DEC A
;D676    JR Z,@@447
;D678    CALL LD6B6
;@@442   POP HL
;D67C    POP DE
;D67D    POP BC
;D67E    RET

;DrawCharacter   
;
;		
;		rts
		
;		sta z80_a
;        lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;        lda z80_a
;        pha ; PUSH AF
;        php;
;		
;        jsr ex_de_hl ; EX DE,HL
;        lda z80_a
;        and #$3F ; AND 3F
;        sta z80_l ; LD L,A
;        lda #$00 ; LD H,00
;        sta z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        asl z80_l ; ADD HL,HL
;        rol z80_h
;        jsr add_hl_bc ; ADD HL,BC
;        jsr ex_de_hl ; EX DE,HL
;        
;		plp ; POP AF
;        pla
;        asl @ ; RLCA
;        ;asl @ ; RLCA
;        rol @
;        rol @
;        and #$03 ; AND 03
;        jeq @@445 ; JR Z,@@445
;        sec ; DEC A
;        sbc #$01; 
;        jeq @@446 ; JR Z,@@446
;        sec ; DEC A
;        sbc #$01; 
;        jeq @@447 ; JR Z,@@447
;        jsr DrawTile8x8HVFlip ; CALL LD6B6
;@@442   pla ; POP HL
;        sta z80_h
;        pla
;        sta z80_l
;        pla ; POP DE
;        sta z80_d
;        pla
;        sta z80_e
;        pla ; POP BC
;        sta z80_b
;        pla
;        sta z80_c
;        rts ; RET

;@@445   CALL LD68E
;D682    JR @@442

;@@445   jsr DrawTile8x8 ; CALL LD68E
;        jmp @@442 ; JR @@442

;@@446   CALL LD697
;D687    JR @@442

;@@446   jsr DrawTile8x8HFlip ; CALL LD697
;        jmp @@442 ; JR @@442

;@@447   CALL LD6A6
;D68C    JR @@442

;@@447   jsr DrawTile8x8VFlip ; CALL LD6A6
;        jmp @@442 ; JR @@442

;LD68E   LD B,08
;@@448   LD A,(DE)
;D691    INC DE
;D692    LD (HL),A
;D693    INC H
;D694    DJNZ @@448
;D696    RET

; some gfx and small font
;DrawTile8x8   ;lda #$08 ; LD B,08
;        ;sta z80_b
;		;ldx #$00
;		ldy #$00
;@@448   ;ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;ldy #$00 ; LD (HL),A
;        ;sta (z80_hl),y;
;				
;		;sta (z80_hl,x)
;        ;inc z80_l ; INC H
;		sta (z80_hl),y
;		
;        ;dec z80_b ; DJNZ @@448
;		iny
;		cpy #$08
;        jne @@448
;
;		inc z80_hl
;		;inc j_left
;		
;		;lda j_left
;		;cmp #02
;		;bne test001
;			
;		;jmp *	
;		
;       rts ; RET

;LD697   LD B,08
;@@449   LD A,(DE)
;D69A    INC DE
;D69B    LD C,A
;D69C    PUSH BC
;D69D    LD B,F9
;D69F    LD A,(BC)
;D6A0    LD (HL),A
;D6A1    INC H
;D6A2    POP BC
;D6A3    DJNZ @@449
;D6A5    RET

;DrawTile8x8HFlip   ;lda #$08 ; LD B,08
;        ;sta z80_b
;		ldy #$00
;@@449   ;ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;sta z80_c ; LD C,A; 
;		tax
;		lda MirrorTable,x
;        ;lda z80_c ; PUSH BC
;        ;pha
;        ;lda z80_b
;        ;pha
;        ;lda #$F9 ; LD B,F9 ; lookup table
;        ;lda #>MirrorTable
;        ;sta z80_b
;        ;ldy #$00 ; LD A,(BC)
;        ;lda (z80_bc),y
;        ;ldy #$00 ; LD (HL),A
;		ldx #$00
;        ;sta (z80_hl),y
;		
;		;sta (z80_hl,x)
;        inc z80_h ; INC H
;        
;		;pla ; POP BC
;        ;sta z80_b
;        ;pla
;        ;sta z80_c
;        ;dec z80_b ; DJNZ @@449
;		iny
;		cpy #$08
;        jne @@449
;        rts ; RET

;LD6A6   LD B,08
;D6A8    INC DE
;D6A9    INC DE
;D6AA    INC DE
;D6AB    INC DE
;D6AC    INC DE
;D6AD    INC DE
;D6AE    INC DE
;@@450   LD A,(DE)
;D6B0    DEC DE
;D6B1    LD (HL),A
;D6B2    INC H
;D6B3    DJNZ @@450
;D6B5    RET

;DrawTile8x8VFlip   ;lda #$08 ; LD B,08
;        ;sta z80_b
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;		ldy #$07
;		ldx #$00
;@@450   ;ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        ;tax
;        ;jsr dec_de ; DEC DE
;        ;txa
;        ;ldy #$00 ; LD (HL),A
;        ;sta (z80_hl),y; A read but not set by previous instruction
;		
;		;sta (z80_hl,x)
;        inc z80_h ; INC H
;        
;		;dec z80_b ; DJNZ @@450
;        ;jne @@450
;		dey
;		bpl @@450
;        rts ; RET

;LD6B6   LD B,08
;D6B8    INC DE
;D6B9    INC DE
;D6BA    INC DE
;D6BB    INC DE
;D6BC    INC DE
;D6BD    INC DE
;D6BE    INC DE
;@@451   LD A,(DE)
;D6C0    DEC DE
;D6C1    LD C,A
;D6C2    PUSH BC
;D6C3    LD B,F9
;D6C5    LD A,(BC)
;D6C6    LD (HL),A
;D6C7    INC H
;D6C8    POP BC
;D6C9    DJNZ @@451
;D6CB    RET

;DrawTile8x8HVFlip   ;lda #$08 ; LD B,08
;        ;sta z80_b
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;        ;inc z80_e ; INC DE
;        ;bne *+4
;        ;inc z80_d
;		ldy #$07
;@@451   ;ldy #$00 ; LD A,(DE)
;        lda (z80_de),y
;        ;tax
;        ;jsr dec_de ; DEC DE
;        ;txa
;        ;sta z80_c ; LD C,A; A read but not set by previous instruction
;		tax
;        ;lda z80_c ; PUSH BC
;        ;pha
;        ;lda z80_b
;        ;pha
;        ;lda #$F9 ; LD B,F9 ; Lookup table
;        ;lda #>MirrorTable
;        ;sta z80_b
;        ;ldy #$00 ; LD A,(BC)
;        ;lda (z80_bc),y
;		lda MirrorTable,x
;        ;ldy #$00 ; LD (HL),A
;        ;sta (z80_hl),y
;		ldx #$00
;		
;		;sta (z80_hl,x)
;        inc z80_h ; INC H
;        
;		;pla ; POP BC
;        ;sta z80_b
;        ;pla
;        ;sta z80_c
;        ;dec z80_b ; DJNZ @@451
;        ;jne @@451
;		dey
;		bpl @@451
;        rts ; RET

;LD6CC   LD HL,L5800
;D6CF    LD BC,L0300
;D6D2    JR @@452

; clear colours
; LD6CC

;old_clear_colours   lda #<L5800 ; LD HL,L5800
;        sta z80_l
;        lda #>L5800
;        sta z80_h
;        lda #<L0300 ; LD BC,L0300
;        sta z80_c
;        lda #>L0300
;        sta z80_b
;        jmp @@452 ; JR @@452

;LD6D4   LD HL,L4000
;D6D7    LD BC,L1800
;LD6DA   LD E,00
;@@452   LD (HL),E
;D6DD    INC HL
;D6DE    DEC BC
;D6DF    LD A,B
;D6E0    OR C
;D6E1    JR NZ,@@452
;D6E3    RET

; clear bitmap sceen
;old_screen_clear   
;		
;		lda #<L4000 ; LD HL,L4000
;        sta z80_l
;        lda #>L4000
;        sta z80_h
;        lda #<L1800 ; LD BC,L1800
;        sta z80_c
;        lda #>L1800
;        sta z80_b
		
old_clear_part_2

		;lda #$30 ; Open up all RAM
		;sta $01   
		
		lda #$00 ; LD E,00
        sta z80_e
@@452   lda z80_e ; LD (HL),E
        ldy #$00
		
        sta (z80_hl),y
        
		inc z80_l ; INC HL
        bne *+4
        inc z80_h
        jsr dec_bc ; DEC BC
        lda z80_b ; LD A,B
        ora z80_c ; OR C
        jne @@452 ; JR NZ,@@452

		;lda #$35 ; IO Back In     
		;sta $01
		
        rts ; RET


; select colour/s with A
c64clearcols

	ldx #00
	;lda #$47  ;black out colour
	
charclear001:
	
	sta screen_mem,x
	sta screen_mem+$100,x
	sta screen_mem+$200,x
	sta screen_mem+$2c0,x
	
	sta luma_mem,x
	sta luma_mem+$100,x
	sta luma_mem+$200,x
	sta luma_mem+$2c0,x
	
	inx
	bne charclear001	
	
	rts

c64clearbitmap

	;lda #$30 ; Open up all RAM
	;sta $01 

	lda #$c0
	sta dest_hi	
	
	lda #$00
	sta dest_lo
	tax
		
	
screenclear01:

	ldy #00
	
screenclear02:

	sta (dest_lo),y
	iny
		
	bne screenclear02
	
	inc dest_hi
	
	inx
	cpx #30
	bne screenclear01

	ldy #00
		
screenclear03:
	
	sta $ddc0,y ;$de40,y
	iny
	bne screenclear03

	;lda #$35 ; IO back in
	;sta $01 
	
	rts
	
colourblit	
		
		ldy colourcode
		lda colours_a,y
		sta colour_a
		lda colours_b,y
		sta colour_b
		
		ldy #$00
		lda colour_a
@		
		sta (dest_lo),y

		iny
		cpy blitsize
		bne @-

		lda dest_lo
		sta dest_col_lo
		
		clc
		lda dest_hi
		adc #04
		sta dest_col_hi
		
		ldy #$00
		lda colour_b
@		
		sta (dest_col_lo),y

		iny
		cpy blitsize
		bne @-
		
		rts		

		
game_area_colour
		
		lda colourcode
		cmp #$46
		beq yellow_screen
		cmp #$45
		beq cyan_screen
		
		; white
		;setup background colour for game area
		lda #$35
		sta dest_lo
		lda #$b8
		sta dest_hi

		lda #$35
		sta dest_col_lo
		lda #$bc
		sta dest_col_hi
		
		lda #$06
		sta colour_a
		lda #$10
		sta colour_b		

		jmp process_colours
		
yellow_screen

		lda #$06
		sta colour_a
		lda #$70
		sta colour_b
		
		jmp yellow_and_cyan

cyan_screen		

		lda #$05
		sta colour_a
		lda #$30
		sta colour_b

		ldy #00
		lda #00
@
		sta screen_mem,y
		sta screen_mem+$100,y
		sta screen_mem+$150,y
		
		sta luma_mem,y
		sta luma_mem+$100,y
		sta luma_mem+$150,y
		
		iny
		bne @-		

yellow_and_cyan
		;setup background colour for game area
		lda #$31
		sta dest_lo
		lda #$b8
		sta dest_hi

		lda #$31
		sta dest_col_lo
		lda #$bc
		sta dest_col_hi
		

process_colours

		ldx #00
@	
		ldy #00
@		
		lda colour_a
		sta (dest_lo),y
		lda colour_b
		sta (dest_col_lo),y
		
		iny
		cpy #22
		bne @-

		lda #40
		jsr addadest
		
		clc
		lda dest_col_lo
		adc #40
		sta dest_col_lo
		scc:inc dest_col_hi
		
		inx
		cpx #14
		bne @-1

		
		rts

		lda game_on
		beq gac01
		
		;setup background colour for game area in game
		lda #$0d
		sta dest_lo
		lda #$b8
		sta dest_hi

		lda #$0d
		sta dest_col_lo
		lda #$bc
		sta dest_col_hi		
		
		lda #$06
		sta colour_a
		lda #$10
		sta colour_b
		
		jmp gac00
		
gac01
		
		;setup background colour for game area bonus game
		lda #$09
		sta dest_lo
		lda #$b8
		sta dest_hi

		lda #$09
		sta dest_col_lo
		lda #$bc
		sta dest_col_hi		
		
		lda colourcode
		cmp #$45
		beq gac02
		
		lda #$06
		sta colour_a
		lda #$70
		sta colour_b		
	
		jmp gac00
gac02		
		;lda #$03
		;sta colourcode

		lda #$05
		sta colour_a
		lda #$30
		sta colour_b		
		
		ldy #00
		lda #00
@
		sta screen_mem,y
		sta screen_mem+$100,y
		sta screen_mem+$150,y
		
		sta luma_mem,y
		sta luma_mem+$100,y
		sta luma_mem+$150,y
		
		iny
		bne @-
	
gac00

		ldx #00
@
		;lda colourcode
		ldy #00
	
@		
		lda colour_a
		sta (dest_lo),y
		lda colour_b
		sta (dest_col_lo),y
		

		iny
		cpy #22
		bne @-
			
		lda #40
		jsr addadest
		
		clc
		adc dest_col_lo
		sta dest_col_lo
		scc:inc dest_col_hi
		
		inx
		cpx #15
		bne @-1
		
		rts
		
		
fontblit_special

		;lda #$30 ; Open up all RAM
		;sta $01 
		
		ldy #00 

@
		lda L8EB0,x
		sta (dest_lo),y

		iny
		inx
		
		cpy #07
		bne @-
		
		lda #08
		jsr addadest

		;lda #$35 ; IO back in
		;sta $01 
		
		rts
		
fontblit	

		;lda #$30 ; Open up all RAM
		;sta $01 
			
		ldy #00 
		
blitloop02:

		lda alpha
		beq numbers_on
		cmp #01
		beq alpha_on
		cmp #03
		beq num_t
		
		; alpha ora
		lda fontdta,x
		ora (dest_lo),y
 		sta (dest_lo),y		
		jmp blitloop20
		
		
numbers_on:		
		; numeric 
		lda L8EB0,x
		sta (dest_lo),y
		
		jmp blitloop20
		
alpha_on:
		;alpha
		lda fontdta,x
		sta (dest_lo),y
		
		jmp blitloop20

num_t:
		;num_t
		lda tfont_n,x
		sta (dest_lo),y		
		
blitloop20:

		iny
		inx
		
		cpy #08
		bne blitloop02
		
		lda #08
		jsr addadest

		;lda #$35 ; IO back in
		;sta $01 
		
		rts

draw_stars		
	
		ldx #248
	
		lda #00
		sta alpha
		
		jmp fontblit_tele

draw_spaces	
	
		ldx #00
	
		lda #01
		sta alpha
			
		jmp fontblit_tele		
		
; takes A and leaves with alpha set and X set ready for fontblit_tele that follows
setup_char_tele
		
		; skip a load of crap if it's a star that needs printing
		cmp #41
		beq draw_stars

		; skip a load of crap if it's a space that needs printing
		cmp #00
		beq draw_spaces		
		
		; works out if to draw alpha or numeric chars (if <11 then numeric) then draws it
		cmp #11
		bcc skip_draw00t

		; alpha chars
		sec
		sbc #10
		asl
		asl
		asl
		tax		
				
		lda #00
		jmp skip_draw01t
		
; numbers		
skip_draw00t:

		asl
		asl
		asl
		tax
				
		lda #01
		
skip_draw01t:		
		sta alpha		
	
		lda drawposs
		beq fontblit_tele
	
		lda z80_l
		cmp #$31
		beq list01
		cmp #$51
		beq list02
		cmp #$71
		beq list03
		
		jmp fontblit_tele
		
list01:
		lda #$d5
		sta d2_hi
		lda #$e8
		sta d2_lo
		
		jmp fontblit_tele

list02:
		lda #$d7
		sta d2_hi
		lda #$28
		sta d2_lo
		
		jmp fontblit_tele

list03:
		lda #$d8
		sta d2_hi
		lda #$68
		sta d2_lo		

fontblit_tele	

		; stop it from ever printing into the border in all 3 cases
		lda d2_lo
		cmp #$58
		bne @+
		lda d2_hi
		cmp #$d6
		jeq move_to_next_char	

@

		lda d2_lo
		cmp #$98
		bne @+
		lda d2_hi
		cmp #$d7
		jeq move_to_next_char	

@

		lda d2_lo
		cmp #$d8
		bne @+
		lda d2_hi
		cmp #$d8
		jeq move_to_next_char	

@

		;lda #$30 ; Open up all RAM
		;sta $01 

		ldy #00
		
		lda alpha
		bne numbers_font
	
alpha_font:		
		
		; blit alpha fonts to screen
		lda fontdta,x
		sta (d2_lo),y

		iny
		inx
		
		cpy #07
		bne alpha_font
		
		jmp move_to_next_char

		
numbers_font:
		
		; blit number fonts to screen
		lda tfont_n,x
		sta (d2_lo),y	

		iny
		inx
		
		cpy #07
		bne numbers_font
		
move_to_next_char:
	
		lda block_add
		bne @+
		
		lda #08
		clc
		adc d2_lo
		sta d2_lo
		scc:inc d2_hi
@

		lda #00
		sta block_add
		sta drawposs
		
		;lda #$35 ; IO back in
		;sta $01 
		
		rts		

		
		
fontblit_yx2	

		lda dest_lo
		sta source_lo
		lda dest_hi
		sta source_hi		
		
		ldy #00 
		
blitloop06:

		lda alpha
		beq blitloop09

		;alpha
		lda fontdta,x		
		
		jmp blitloop10
		
blitloop09:

		; numeric 
		lda L8EB0,x

blitloop10:		
		
		sta (dest_lo),y
		iny
		sta (dest_lo),y
		
		iny
		inx
		
		cpy #08
		bne blitloop07
		
		clc
		lda #$38
		adc dest_lo
		sta dest_lo

		lda #$01
		adc dest_hi
		sta dest_hi	
		
blitloop07:
		
		cpy #14
		bne blitloop06
		
		lda source_lo
		sta dest_lo
		lda source_hi
		sta dest_hi
		
		lda #08		
		clc
		adc dest_lo
		sta dest_lo
		scc:inc dest_hi

		rts		
					
		
drawgun
		
		lda #08
		jsr addasource
			
		lda #56
		sta blitsize
		jsr screenblit

		lda blitsize
		jsr addasource
		
		jsr addline
				
		lda #56
		sta blitsize
		jsr screenblit
		
		lda blitsize
		jsr addasource
		
		jsr addline
				
		lda #40
		sta blitsize
		jsr screenblit		

		lda blitsize
		jsr addasource
		
		jsr addline
				
		lda #32
		sta blitsize
		jsr screenblit
		
		lda blitsize
		jsr addasource
		
		jsr addline
				
		lda #16
		sta blitsize
		jsr screenblit		
		
		rts


longpause
		
		stx temp_x
		tax 

pause01:		

		jsr c64waitframe
		dex
		bne pause01
		
		ldx temp_x
		
		rts
		
addline		

		clc
		lda #$40
		adc dest_lo
		sta dest_lo

		lda #$01
		adc dest_hi
		sta dest_hi	
		
		rts
			

subdest 
		
		lda dest_lo
		sec
		sbc subnum
		sta dest_lo
		scs:dec dest_hi

		rts

subsource 
		
		lda source_lo
		sec
		sbc subnum
		sta source_lo
		scs:dec source_hi

		rts
		
addadest

		clc
		adc dest_lo
		sta dest_lo
		scc:inc dest_hi

		rts

addasource

		clc
		adc source_lo
		sta source_lo
		scc:inc source_hi

		rts
		
player_txt

		lda #00
		sta counter2
@	
		jsr c64waitframe		
		
		; expl gfx data
		lda #$d0
		sta source_lo
		lda #$df
		sta source_hi
		
		ldx #00
@	
		ldy #00
@	

		lda counter2
		cmp #02
		bne expl_01
		lda #00
		jmp expl_02
expl_01		
		lda (source_lo),y
expl_02		
		sta (destb_lo),y
		
		iny
		cpy #16
		bne @-
		
		lda #16
		jsr addasource

		clc
		lda #$40
		adc destb_lo
		sta destb_lo

		lda #$01
		adc destb_hi
		sta destb_hi	
		
		inx
		cpx #03
		bne @-1

		sec				
		lda destb_lo
		sbc #$c0			
		sta destb_lo
		lda destb_hi			
		sbc #$03			
		sta destb_hi
		
		inc counter2
		lda counter2
		cmp #03
		bne @-2

		clc
		lda #$50
		adc destb_lo
		sta destb_lo

		lda #$01
		adc destb_hi
		sta destb_hi			
		
		
		lda #00
		sta counter2
		
		; draw alpha not numbers
		lda #01
		sta alpha
		
		
move_bullet

		jsr c64WaitFrame
		
		; draw bullet across screen
		; bullet gfx data
		lda #$b0
		sta source_lo
		lda #$df
		sta source_hi	

		ldx #00
@	
		ldy #00
@	
		lda (source_lo),y
		;ora (destb_lo),y
		sta (destb_lo),y

		iny
		cpy #16
		bne @-
		
		lda #16
		jsr addasource

		clc
		lda #$40
		adc destb_lo
		sta destb_lo

		lda #$01
		adc destb_hi
		sta destb_hi	
		
		inx
		cpx #02
		bne @-1

		; put bullet start address 8 pix on
		sec				
		lda destb_lo
		sbc #$78			
		sta destb_lo
		lda destb_hi			
		sbc #$02			
		sta destb_hi

		; don't draw font on first bullet render
		lda counter2
		beq endofdraw

		; draw font data
		dec counter2
		ldx counter2

		lda text_pos
		cmp #$00
		beq player_text
		cmp #$01
		beq control_txt
		cmp #$02
		beq start_game_txt

control_txt

		lda #02
		bit game_select_type
		bne control_joy

		cpx #09
		bcs @+
		
		lda keyboardalpha,x
		jmp font_render
@	
		lda directional
		bne @+
		lda keyboardalpha,x

		jmp font_render
		
@
		lda joystickalpha,x

		jmp font_render
		
		
control_joy		

		cpx #09
		bcs @+

		lda joystickalpha,x
		jmp font_render
@
		lda directional
		beq @+

		lda joystickalpha,x

		jmp font_render
@
		lda keyboardalpha,x

		jmp font_render

start_game_txt
		
		lda startgamealpha,x
		
		jmp font_render	
		
player_text		
		; work out what text option to render
		lda #01
		bit game_select_type
		bne player_two_txt
			
		lda playeralpha,x
		jmp font_render
		
player_two_txt		
		lda playertwoalpha,x		
		
		
font_render		
		tax
		jsr fontblit_yx2
				
		inc counter2
	
endofdraw		
		inc counter2
		lda counter2
		cmp #23
		jne move_bullet
		
		sec				
		lda destb_lo
		sbc #$08			
		sta destb_lo

		; blank out bullet
		ldx #00
@
		ldy #00
@	
		lda #00
		sta (destb_lo),y
		iny
		cpy #16
		bne @-

		clc
		lda #$40
		adc destb_lo
		sta destb_lo

		lda #$01
		adc destb_hi
		sta destb_hi	
		
		inx
		cpx #02
		bne @-1
		
		
		rts
		

		
; mirror, mirror...
hbitflip
 
		bit zer0page_software_inc
pass01: 
		php
		asl
		bne pass01
pass02: 
		rol
		plp
		bne pass02		

		rts

vbyteflip

		ldy #00
		ldx #07
@
		lda (source_lo),y
		sta blocktemp,x

		iny 
		dex

		bpl @-
		
		rts
		
; sync screen to 50hz/60hz	
c64waitframe

          lda $ff1d
          cmp #255
          beq c64waitframe

WaitStepb
          lda $ff1d
          cmp #255
          bne WaitStepb
		  
        rts

spressed

		jsr 	c64waitframe

		lda 	#02
		sta		border

		LDA 	#$fd                      
		STA 	$FD30
		lda 	#$ff
		STA 	$FF08                         
		LDA 	$FF08                          
		AND 	#$20
        beq 	spressed

		lda 	#$0a
		sta		MAN_SPEED
		lda		#00
		sta		border
		
		rts

fpressed

		jsr 	c64waitframe

		lda 	#05
		sta		border

		LDA 	#$fb                      
		STA 	$FD30
		lda 	#$ff
		STA 	$FF08                         
		LDA 	$FF08                          
		AND 	#$20
        beq 	fpressed	

		lda 	#$0e
		sta		MAN_SPEED
		lda		#00
		sta		border
		
		rts		
		
c64menukeys


		LDA #$fd                      
		STA $FD30
		lda #$ff
		STA $FF08                         
		LDA $FF08                          
		AND #$20
        beq spressed
		
		LDA #$fb                      
		STA $FD30
		lda #$ff
		STA $FF08                         
		LDA $FF08                          
		AND #$20
        beq fpressed		

		LDA #$fd                      
		STA $FD30
		lda #$ff
		STA $FF08                         
		LDA $FF08                          
		AND #$01
        beq key3pressed
		
		LDA #$7f                      
		STA $FD30
		lda #$ff
		STA $FF08                         
		LDA $FF08                          
		AND #$01    
        beq key1pressed

		LDA #$7f                      
		STA $FD30
		lda #$ff
		STA $FF08                         
		LDA $FF08                          
		AND #$08 
        beq key2pressed
		
        rts

key3pressed

		LDA #$fd                      
		STA $FD30
		lda #$ff
		STA $FF08                         
		LDA $FF08                          
		AND #$01
        beq key3pressed

        lda #03     
        sta gameselect 
		sta menuposs
		
		
        rts

key1pressed

		LDA #$7f                      
		STA $FD30
		lda #$ff
		STA $FF08                         
		LDA $FF08                          
		AND #$01  
        beq key1pressed

        lda #01     
        sta gameselect
		sta menuposs
			
        rts

key2pressed

		LDA #$7f                      
		STA $FD30
		lda #$ff
		STA $FF08                         
		LDA $FF08                          
		AND #$08 
        beq key2pressed

        lda     #02     
        sta     gameselect
		sta     menuposs
		
		inc		direct
		lda		direct
		cmp		#02
		beq		@+
		cmp		#04
		beq		@+1
		
		rts
@	
		lda		#01
		sta		directional
		rts
@	
		lda		#00
		sta		directional
		sta		direct 	
		rts
		
		rts
		
player_no_text

	.if TED_SOUND == 1
		lda #08
		jsr ted_music_play
	.else
		lda #<sfxshoot     ;Start address of sound effect data
        ldy #>sfxshoot 
        ldx #14             ;0, 7 or 14 for channels 1-3
        jsr sfx_play 	
	.endif

		;lda #<sfxshoot      ;Start address of sound effect data
        ;ldy #>sfxshoot 
        ;ldx #14             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 
		
		; player 1/2 text
		lda #$00
		sta text_pos
		
		lda #$38
		sta dest_lo
		lda #$c4
		sta dest_hi

		lda #$e8
		sta destb_lo
		lda #$c2
		sta destb_hi		

		jsr player_txt		

		rts

keyboard_text

	.if TED_SOUND == 1
		lda #08
		jsr ted_music_play
	.else
		lda #<sfxshoot     ;Start address of sound effect data
        ldy #>sfxshoot 
        ldx #14             ;0, 7 or 14 for channels 1-3
        jsr sfx_play 	
	.endif

		;lda #<sfxshoot      ;Start address of sound effect data
        ;ldy #>sfxshoot 
        ;ldx #14             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 
		
		; keyboard/joystick text
		lda #$01
		sta text_pos
		
		lda #$f8
		sta dest_lo
		lda #$cc
		sta dest_hi

		lda #$a8
		sta destb_lo
		lda #$cb
		sta destb_hi
		
		jsr player_txt
		
		rts
		
gamestart_text

	.if TED_SOUND == 1
		lda #08
		jsr ted_music_play
	.else
		lda #<sfxshoot     ;Start address of sound effect data
        ldy #>sfxshoot 
        ldx #14             ;0, 7 or 14 for channels 1-3
        jsr sfx_play 	
	.endif

		;lda #<sfxshoot      ;Start address of sound effect data
        ;ldy #>sfxshoot 
        ;ldx #14             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play 
		
		; start game text
		lda #$02
		sta text_pos
		
		lda #$b8
		sta dest_lo
		lda #$d5
		sta dest_hi	

		lda #$68
		sta destb_lo
		lda #$d4
		sta destb_hi		

		jsr player_txt

		rts		

		
screenblit	

		;lda #$30 ; Open up all RAM
		;sta $01 
		
		ldy #$00 		
@ 
		lda hflip_flag
		cmp #00
		beq @+2
		cmp #02
		beq @+
		cmp #03
		beq @+1
		
		lda (source_lo),y
		jsr hbitflip
		sta (dest_lo),y
		jmp screenloop03

@		lda blocktemp,y
		sta (dest_lo),y
		jmp screenloop03

@		lda blocktemp,y
		jsr hbitflip
		sta (dest_lo),y
		jmp screenloop03		
	
@		lda (source_lo),y
		sta (dest_lo),y

screenloop03:
		
		iny
		cpy blitsize
		bne @-3	

		;lda #$35 ; IO back in
		;sta $01 
		
		rts

blockblit	

		;lda #$30 ; Open up all RAM
		;sta $01 

		ldx #$00
blockloop01:		
		ldy #$00 
		
blockloop02:

		lda hflip_flag
		cmp #03
		beq blockloop03

		lda (source_lo),y
		sta (dest_lo),y
		jmp blockloop04

blockloop03:

		lda blocktemp,y
		sta (dest_lo),y

blockloop04:
		
		iny
		cpy #$08
		bne blockloop02

		lda #$08
		jsr addadest
		
		inx
		cpx blitsize
		bne blockloop01
		
		;lda #$35 ; IO back in
		;sta $01 
		
		rts


setup_char		
		; works out if to draw alpha or numeric chars (if <11 then numeric) then draws it
		cmp #11
		bcc skip_draw00

		sec
		sbc #10
		asl
		asl
		asl
		tax		
		
		lda #01
		jmp skip_draw01
		
skip_draw00:

		asl
		asl
		asl
		tax
		
		lda #03
skip_draw01:		
		sta alpha		
		;jsr fontblit
				
		rts

		
print_player_no

		lda #01
		sta alpha

		
		ldx #04
@
		ldy playeralpha,x
		jsr font_expand
		
		ldx count_temp_03
		stx count_temp_03
		
		inx
		cpx #11
		bne @-

		lda #00
		sta alpha
		
		; set to 1 or 2 char based on player number (0 or 1)
		lda player_number
		asl
		asl
		asl
		tay
		jsr font_expand	
		
		lda #$b8
		sta dest_lo
		lda #$b9
		sta dest_hi
		lda #$03
		sta colourcode
		lda #80
		sta blitsize
		jsr colourblit	
		
		rts
		
		
c64skipkeyheld

		jsr c64waitframe

		LDA 	#$7f	                    
		STA 	$FD30
		lda 	#$ff
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$10	; check for space key pressed
		beq 	c64skipkeyheld
		

		LDA 	#$ff	                    
		STA 	$FD30
		
		LDA 	#$fa	                    	                         
		STA 	$FF08	                        
		LDA 	$FF08	                         
		AND 	#$40	; check for fire pressed	
		beq 	c64skipkeyheld		
		
		rts

; get font number start point from Y and expects dest_lo, dest_hi, source_lo, source_hi		
font_expand

		;lda #$30 ; Open up all RAM
		;sta $01 
		
		sty count_temp
		stx count_temp_03
		
		lda #00
		sta count_temp_02
		
loop_font_x		
		
		lda #00
		sta font_d
		sta font_e

		lda alpha
		beq numfont01
		cmp #02
		beq numfont03
		
		ldy count_temp
		sty count_temp
		lda fontdta,y
		sta font_s
		
		jmp numfont04

numfont01

		ldy count_temp
		sty count_temp
		lda sfont,y
		sta font_s
		
		jmp numfont04

numfont03		

		ldy count_temp
		sty count_temp
		lda L8EB0,y
		sta font_s
		
numfont04

		
		; first block (left) x-pand
		ldx #00
@
		asl font_s
		bcc no_action_a
		inc font_s
				
		lda bitpos,x
		ora font_d
		sta font_d
		
		inx
		lda bitpos,x
		ora font_d
		sta font_d
		jmp no_action_b
		
no_action_a
		inx
no_action_b
		inx
		
		cpx #08
		bne @-
		
		; second block (right) x-pand
		ldx #00
@
		asl font_s
		bcc no_action_c
		inc font_s
				
		lda bitpos,x
		ora font_e
		sta font_e
		
		inx
		lda bitpos,x
		ora font_e
		sta font_e
		jmp no_action_d
		
no_action_c
		inx
no_action_d
		inx
		cpx #08
		bne @-		
		
		ldy count_temp_02
		sty count_temp_02
		
		lda font_d
		sta font_f,y
		lda font_e
		sta font_g,y
		
		inc count_temp
		inc count_temp_02
		lda count_temp_02
				
		cmp #08
		jne loop_font_x

		ldx #00
		ldy #00
@
		
		lda font_f,x
		sta (dest_lo),y
		lda font_g,x
		sta (source_lo),y		
		
		iny
		
		lda font_f,x
		sta (dest_lo),y
		lda font_g,x
		sta (source_lo),y
	
		iny
		inx
		cpx #04
		bne @-
	
		jsr addline
		lda #160
		jsr addasource
		lda #160
		jsr addasource
	
		ldx #04
		ldy #00
@
	
		lda font_f,x
		sta (dest_lo),y
		lda font_g,x
		sta (source_lo),y	
		
		iny
		
		lda font_f,x
		sta (dest_lo),y
		lda font_g,x
		sta (source_lo),y	

		iny
		inx
		cpx #08
		bne @-		
		
		lda #152
		sta subnum
		jsr subdest
		jsr subdest
		jsr subsource
		jsr subsource
		
		;lda #$35 ; IO back in
		;sta $01 	
		
		rts

drawtexttoscreen		
		
		lda #01
		sta alpha		
		
        lda #<$d5d0
        sta dest_lo
        lda #>$d5d0
        sta dest_hi

        lda #<$d5d8
        sta source_lo
        lda #>$d5d8
		sta source_hi

		ldx #00
@
		ldy drawalpha,x
		jsr font_expand
		
		ldx count_temp_03
		stx count_temp_03
		
		inx
		cpx #06
		bne @-		

		lda #$ba
		sta dest_lo
		lda #$ba
		sta dest_hi

		lda #12
		sta blitsize
		jsr colourblit	
		
		lda #40
		jsr addadest
		
		jsr colourblit
		
		rts	

centre_text

		;lda #$30 ; Open up all RAM
		;sta $01 
			
		ldy #00 
		
ctext01:
		; load font data into 2 8x buffers
		lda fontdta,x
 		sta font_f,y		
		sta font_g,y
		
		iny
		inx
		
		cpy #08
		bne ctext01
	
		ldx #00
ctext02:
		;shift part 1 of font 4 places to right
		lsr font_f,x
		lsr font_f,x
		lsr font_f,x
		lsr font_f,x
		
		;shift part 2 of font 4 places to the left
		asl font_g,x
		asl font_g,x
		asl font_g,x
		asl font_g,x
		
		inx
		
		cpx #08
		bne ctext02
				
		ldy #00 
		
ctext03:
		;combine the two parts of the shifted font into one font across 2 spaces now centered
		lda font_f,y
		ora (dest_lo),y
 		sta (dest_lo),y		

		iny
		
		cpy #16
		bne ctext03
		
		lda #08
		jsr addadest

		;lda #$35 ; IO back in
		;sta $01 
		
		rts

;setupnocolours
;
;		lda #$50
;		sta $f32b
;		sta $f353
		
;		lda #$f0
;		sta $f0fb
;		sta $f123
		
;		lda #$70
;		sta $f213
;		sta $f23b
;		
;		rts

music_pause
		; wait a few secs for music to play
		
		ldx #05
@	
		jsr c64WaitFrame
		dex
		bne @-
		
		LDA #$7f	                    
		STA $FD30
		lda #$ff
		STA $FF08	                        
		LDA $FF08	                         
		AND #$10	
		beq skipout
		
		LDA #$ff	                    
		STA $FD30
		
		LDA #$fa	                    	                         
		STA $FF08	                        
		LDA $FF08	                         
		AND #$40		
		beq skipout

		
		dec mpwait
		lda mpwait
		bne music_pause
		
		jmp skipout2

skipout		
		
		jsr c64skipkeyheld

skipout2
		
		rts

music_pause_no
		; wait a few secs for music to play

		ldx #05
@	
		jsr c64WaitFrame
		dex
		bne @-
		
		dec mpwait
		lda mpwait
		bne music_pause_no

		rts
			

LastFrameStartSync
		dta 0
		
FrameSync
FrameSyncWait		
		lda frame_counter
		sec
		sbc LastFrameStartSync
		bpl FrameSyncCounterPositive
		eor #$ff
		clc
		adc #$01
FrameSyncCounterPositive
		cmp #FRAME_MIN
FrameSyncCounter equ *-1		
		bcc FrameSyncWait
FrameSyncEnd
		lda frame_counter
		sta LastFrameStartSync
		rts		

HostGameScreenPrepare
; LA269 = 0 - mini-game screen, 4 (not zero) - standard game screen
		lda game_on
		beq HostGameMiniGameScreenPrepare
; game screen	
		lda #FRAME_SYNC_GAME
		sta FrameSyncCounter
		rts
HostGameMiniGameScreenPrepare
		lda #FRAME_SYNC_MINI_GAME
		sta FrameSyncCounter
		rts		
			
blocktemp
		dta 00,00,00,00,00,00,00,00		
hiscorecon
		dta 00,00,00,00,00,00
bitpos
		dta 128,064,032,016,008,004,002,001  
font_s
		dta 000
font_d
		dta 000
font_e
		dta 000
font_f
		dta 000,000,000,000,000,000,000,000
font_g
		dta 000,000,000,000,000,000,000,000

;vars
colourcounter			dta 000
blitsize        		dta 000
colourcode         		dta 000
count_temp				dta 000
count_temp_02 	    	dta 000
hflip_flag		        dta 000
temp_x					dta 000
alpha		       		dta 000
skipsource				dta 000
text_pos				dta 000
gameselect				dta 000
twoplayersup  			dta 000
drawposs				dta 000
button					dta 000
block_add				dta 000
subnum					dta 000
count_temp_03			dta 000
enemy_ctr	 			dta 000
direct	 				dta 000
directional				dta 000
menuposs				dta 001
colour_a				dta 000
colour_b				dta 000
counter2				dta 000
mpwait					dta 000
;temp_002				dta 000

;sound_on				dta 001		
		
acgnum				equ $dec0
acgalpha 			equ $dec0+8-1
gunfrightalpha 		equ $dec0+15-2
playeralpha 		equ $dec0+26-3
playertwoalpha 		equ $dec0+49-4
keyboardalpha 		equ $dec0+72-5
joystickalpha 		equ $dec0+95-6
startgamealpha 		equ $dec0+118-7
telealpha 			equ $dec0+141-8
bountyaplpha 		equ $dec0+150-9
gameoveralpha 		equ $dec0+157-10
drawalpha 			equ $dec0+168-11
bonusalpha 			equ $dec0+175-12
welldonealpha 		equ $dec0+182-13
todaystopalpha 		equ $dec0+192-14
scoreisalpha 		equ $dec0+203-15
colours_a 			equ $dec0+212-16
colours_b 			equ $dec0+235-17
	
poster_bottom2		equ $0100	
poster_top			equ $0200
L8A70				equ $0300
poster_sides		equ $ff40

;poster_sides
;	.he C0,80,8C,8C,80,C0,E0,A0
;	.he 01,01,01,03,03,03,0F,07
;	.he C0,80,8C,8C,80,C0,E0,A0
;	.he 01,01,33,33,03,03,01,01
;	.he 80,80,80,C4,C8,C0,F0,E0
;	.he 01,01,33,33,03,03,01,01
;	.he 80,80,CC,CC,C0,C0,80,80
;	.he 01,01,01,23,13,03,0F,07
;	.he 80,80,CC,CC,C0,C0,80,80
;	.he 03,01,31,31,01,03,07,05
;	.he 80,80,80,C4,C8,C0,F0,E0
;	.he 01,01,33,33,03,03,01,01
;	.he 80,80,80,C4,C8,C0,F0,E0
;	.he 01,01,01,23,13,03,0F,07
;	.he 00,00,00,00,80,80,80,80
;	.he 00,00,00,00,01,01,01,01
;	.he 00,00,00,00,80,80,80,80
;	.he 01,01,01,23,13,03,0F,07	

;poster_bottom2	
;	.he 88,80,87,07,00,27,47,87
;	.he FE,FE,FE,FE,FF,FF,FF,CF
;	.he 0C,0C,0C,0C,5E,5E,5E,5E
;	.he 3C,3C,3C,3C,7E,7E,7E,7E
;	.he 22,22,22,22,72,72,72,72
;	.he 20,20,20,20,73,72,72,70
;	.he 3F,3F,3F,3F,BF,BF,FF,F3
;	.he 11,01,E1,E0,00,E4,E2,E1
;	
;	.he C7,C7,87,C0,C7,C7,C0,C0
;	.he CE,FE,FE,FE,FC,FC,FC,FC
;	.he 0E,0E,4E,4E,44,44,44,44
;	.he 7E,7E,76,76,04,04,04,04
;	.he 72,7A,7A,7A,30,30,30,30
;	.he 70,F0,F2,F3,60,60,60,60
;	.he F3,FF,BF,BF,3F,3F,3F,3F
;	.he E3,E3,E1,03,E3,E3,03,03
;	
;	.he C0,CC,D2,D6,CC,C1,E7,FF
;	.he 00,00,7F,00,00,80,C0,FF
;	.he 00,00,7F,00,00,80,C0,FF
;	.he 00,00,F9,02,02,07,07,FF
;	.he 00,80,3F,00,00,00,80,00
;	.he 00,00,7F,00,00,80,C0,FF
;	.he 00,00,7F,00,00,80,C0,FF
;	.he 90,B1,61,07,0F,3F,7F,FF

		;gun graphics
;L8A70   .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00
;        .he 00,00,1F,3F,07,03,01,01 ; DB 00,00,1F,3F,07,03,01,01
;        .he 00,00,0B,D7,F6,ED,DB,BA ; DB 00,00,0B,D7,F6,ED,DB,BA
;        .he 00,7F,FF,FF,00,7F,78,77 ; DB 00,7F,FF,FF,00,7F,78,77
;        .he 00,C0,F0,FF,00,FE,00,FE ; DB 00,C0,F0,FF,00,FE,00,FE
;        .he 00,00,00,FF,FF,D5,CA,D5 ; DB 00,00,00,FF,FF,D5,CA,D5
;        .he 00,00,00,FF,FF,55,AA,55 ; DB 00,00,00,FF,FF,55,AA,55
;        .he 06,0F,00,FF,FF,55,AA,55 ; DB 06,0F,00,FF,FF,55,AA,55
;        .he 03,02,01,03,03,01,01,00 ; DB 03,02,01,03,03,01,01,00
;        .he 74,F0,F3,37,37,F7,FB,CB ; DB 74,F0,F3,37,37,F7,FB,CB
;        .he 70,78,7F,7F,78,77,70,78 ; DB 70,78,7F,7F,78,77,70,78
;        .he 00,00,FE,FE,00,FE,00,00 ; DB 00,00,FE,FE,00,FE,00,00
;        .he DF,DF,DF,FF,FF,E0,FF,FF ; DB DF,DF,DF,FF,FF,E0,FF,FF
;        .he FF,FF,FF,FF,FF,00,FF,FF ; DB FF,FF,FF,FF,FF,00,FF,FF
;        .he FF,FF,FF,FF,FF,00,80,00 ; DB FF,FF,FF,FF,FF,00,80,00
;        .he 00,00,01,01,03,07,0E,0D ; DB 00,00,01,01,03,07,0E,0D
;        .he CD,FE,FF,FF,AF,57,AA,55 ; DB CD,FE,FF,FF,AF,57,AA,55
;        .he 7F,00,FF,FF,FF,E0,E8,CC ; DB 7F,00,FF,FF,FF,E0,E8,CC
;        .he FE,01,FF,FF,FE,18,18,08 ; DB FE,01,FF,FF,FE,18,18,08
;        .he C0,80,00,00,00,00,00,00 ; DB C0,80,00,00,00,00,00,00
;        .he 1E,1D,3A,34,7B,71,66,73 ; DB 1E,1D,3A,34,7B,71,66,73
;        .he AA,55,AB,57,AF,D7,4F,9E ; DB AA,55,AB,57,AF,D7,4F,9E
;        .he C6,C6,82,80,FF,00,00,00 ; DB C6,C6,82,80,FF,00,00,00
;        .he 08,18,30,E0,80,00,00,00 ; DB 08,18,30,E0,80,00,00,00
;        .he E9,F5,FA,7D,3E,0F,03,00 ; DB E9,F5,FA,7D,3E,0F,03,00
;        .he CE,5E,AE,56,AE,D7,FF,FF ; DB CE,5E,AE,56,AE,D7,FF,FF
;        .he 00,00,00,00,00,00,00,80 ; DB 00,00,00,00,00,00,00,80

;	.he E0,8E,9F,BB,B9,B9,9D,8C
;	.he FF,C0,80,00,00,7F,00,00
;	.he 00,80,00,00,00,3F,80,00
;	.he FF,07,07,02,02,F9,00,00
;	.he 00,80,00,00,00,3F,80,00
;	.he FF,C0,80,00,00,7F,00,00
;	.he FF,07,07,02,02,F9,00,00
;	.he FF,3F,5F,47,45,B9,83,33
;	
;	.he 0C,18,30,66,66,30,00,00
;	.he 08,08,08,08,9C,94,94,94
;	.he 41,41,41,41,E3,E3,C9,C9
;	.he 8C,8C,8C,84,84,C4,C0,C0
;	.he 40,40,40,40,D2,D2,F3,F3
;	.he 80,80,80,80,CE,CE,CB,C3
;	.he 81,80,80,80,CC,CC,CC,CC
;	.he 30,18,0C,66,66,0C,00,00
;	
;	.he 00,00,00,00,80,80,80,80
;	.he 94,94,D5,C1,C9,C9,C9,C9
;	.he C9,C1,C1,C9,88,88,88,88
;	.he C0,C0,C8,C8,88,8C,8C,8C
;	.he F3,F3,F3,F3,61,61,61,61
;	.he C3,CB,CE,CE,80,80,80,80
;	.he CC,CC,CC,CC,80,80,80,81
;	.he 00,00,00,00,01,01,01,01
	
;	.he 00,84,04,07,80,80,80,80
;	.he 00,FF,00,FF,00,00,00,00
;	.he 00,FF,00,FF,00,00,00,00
;	.he 00,FF,00,FF,00,00,00,00
;	.he 00,FF,00,FF,00,00,00,00
;	.he 00,FF,00,FF,00,00,00,00
;	.he 00,FF,00,FF,00,00,00,00
;	.he 00,21,20,E0,01,01,01,01

		
;acgnum
;		dta 088,096,008,072,064,040,096
;acgalpha
;		dta 008,224,024,224,056,224
;gunfrightalpha
;		dta 056,168,112,000,048,144,072,056,064,160
;playeralpha
;		dta 120,112,040,000,128,096,008,200,040,144,000,056,008,104,040,000,000,000,000,000,000,000
;playertwoalpha
;		dta 160,184,120,000,128,096,008,200,040,144,000,056,008,104,040,000,000,000,000,000,000,000
;keyboardalpha
;		dta 088,040,200,016,120,008,144,032,000,160,168,144,112,000,184,008,096,088,000,000,000,000
;joystickalpha
;		dta 080,120,200,152,160,072,024,088,000,032,072,144,040,024,160,072,120,112,008,096,000,000
;startgamealpha
;		dta 152,160,008,144,160,000,056,008,104,040,255,000,000,000,000,000,000,000,000,000,000,000
;telealpha
;		dta 160,40,096,040,056,144,008,104
;bountyaplpha
;		dta 016,120,168,112,160,200
;gameoveralpha
;		dta 056,008,104,040,000,000,120,176,040,144
;drawalpha
;		dta 032,144,008,184,232,232
;bonusalpha
;		dta 016,120,112,168,152,000
;welldonealpha
;		dta 184,040,096,096,000,032,120,112,40
;todaystopalpha
;		dta 160,120,032,008,200,152,000,160,120,128
;scoreisalpha
;		dta 152,024,120,144,040,000,072,152
;colours_a
;		dta $00,$07,$02,$07,$03,$03,$01,$07,$03,$02,$06,$01,$03,$04,$04,$06,$06,$62,$36,$73,$17,$60
;colours_b
;		dta $00,$10,$20,$30,$40,$50,$60,$70,$80,$90,$20,$10,$10,$f0,$d0,$10,$92,$49,$95,$47,$16,$09				

		