
; Pentagram C128 VDC port Release Version 1.30 - Started - 10/04/2017
; ------------------------------------------------------------------------------
		

; Long term to-do (still outstanding):
; ------------
; - directional controls
; - pre-shift/un-mirror more sprites for improved speed.


; Version 1.30 changes:

; Done:
; - new sfx and seperate player (thunder/wind sfx removed to save some cpu time)
; - re-do c64screen
; - Remove first kb check in pause
; - new kb & joystick routines & put fire onto space key and drop/pickup onto M key
; - re-write colour ram routine to save almost 1k
; - removed rot_table generation and let exomizer do it
; - SuperCPU compatability
; - optimise sprite blit routine (remove cpm & screen flip logic and use self mod code and tables for mem location conversion)
; - native & vdc c128 versions
; - turn off GCS64 second button if fails test on some newer hardware in front end
; - improved front end and new title picture
; - improvements above yeilds about 5% extra speed and frees up some more memory

; Not Done:
; - improve ratser IO swaps with new method (removed for SuperCPU compatability)
; - move game vars into ZP (dropped as no speed advantage)
; - bitmap version (VicII/Ted versions only) - Dropped as extra screen offset calcs cost the same amount of speed as the time saved by dropping the 3x raster irqs and cost 2k more mem anyway.


; Version 1.20 changes:

; New and much improved SID sound. 
; Frame Sync and updated Frame Skipping taken from Atari final release version.
; (Run on Turbo Chameleon 64 at 3mhz or greater to play game fully frame synced with no slowdown!)
; Cleaner and faster full updatescreen routine.
; Text flasher improved.
; Improved key/button handling when skipping.
; Improved C64 joystick & keyboard routines.

; Atari MADS compiler format 
; Remove bytes 00,01,04,05 at the start of the created binary to create a runable C64 binary

; Align LB55A to $6B00 and PrepareSorting to $6CC0  
; as C64 binary files don't include the end address only the first org command works and align
; doesn't work so we have to do it manually!

; Goat Tracker 2.73 used for the music & sfx

; LD472
; 5 Runes at $9615,$9625,$9635,$9645,$9655 after game start.


spectrum_screen			equ $0000
ScreenBuffer			equ $e000
;colour_ram				equ $d804
spectrum_attr			equ $fc00

rot_table				equ $c000
LF100					equ $ce00 

spectrum_rom			equ $cf00

sprite_blit_table_lo	equ $f800
sprite_blit_table_hi	equ $f900
vdc_colour_convert		equ $f920
ColourFlasher			equ $f940

;c64screen				equ $fa00

music_on				equ $0200
sound_player			equ $0203
sfx_play				equ $0206

sound_player_e			equ $0b03
sfx_play_e				equ $0b06

sfxwalk					equ $0100 ;C3
sfxdrop					equ $0108 ;C1
sfxpause				equ $0132 ;C2
;sfxjingle  		  	equ $0e70 ;C1 *
sfxjump					equ $0e99 ;C3
sfxshoot     			equ $0ec2 ;C2 *


; C64 Vars
pra						equ	$dc00 ; CIA#1 (Port Register A)
prb 					equ $dc01 ; CIA#1 (Port Register B)
ddra 					equ $dc02 ; CIA#1 (Data Direction Register A)
ddrb 					equ $dc03 ; CIA#1 (Data Direction Register B)

border					equ	$d020 ; border
background			 	equ $d021 ; background

random					equ $d012

frame_counter			equ $1f

mem_buf					= $d9
key_l					= $da
key_r					= $db

; From front end
soundfx					= $dc
fire2off				= $dd
;----------------------------------
C128_MODE_ON			= $de
cpuspeed      	        = $df
;----------------------------------
FRAME_SKIPPING	 		= $e0
UNLIMITED_LIVES			= $e1
MEGA_JUMP				= $e2
START_ROOM				= $e3
START_ROOM_ON 			= $e4
FRAME_SKIPPING_THRESHOLD = $e5
FRAME_MIN				= $e6
vdc_old					= $e7
scpu					= $e8
;----------------------------------

keyvalue				= $e9

source_lo				= $ea
source_hi				= $eb
dest_lo					= $ec
dest_hi					= $ed

temp_ddra				= $ee

joyvalue				= $ef
c64_lo 	   				= $f0
c64_hi 					= $f1
;-----------------------------------

;sound_off				= $f2
;sound_e				= $f3

; In use...
;sound1					= $f4
;sound2					= $f5
;sfx1					= $f6
;sfx2					= $f7
; $f8 - $ff


;soundfx				= $03f2
;fire2off				= $03f3
;C128_MODE_ON			= $03f4
;cpuspeed      	        = $03f5
;----------------------------------
;UNLIMITED_LIVES 		= $03f6
;START_ROOM_ON			= $03f7
;START_ROOM				= $03f8
;MEGA_JUMP				= $03f9
;FRAME_SKIPPING 		= $03fa
;FRAME_SKIPPING_THRESHOLD = $03fb
;FRAME_MIN				= $03fc
;vdc_old				= $03fd
;scpu					= $03fe


		;org $0610

		;sei
		;cld
		;ldx #$ff
		;txs
		;jsr z80_init
		;jsr spectrum_init
		;jmp PlayGame
		
		;run		$0610
		
	
		;org $0801
		;dta $0C,$08,$0A,$00,$9E,$20
		;dta $32,$30,$36,$34,$00		;2064
		;dta $00,$00,$00,$00

		;org $0401
		;dta $0C,$08,$0A,$00,$9E,$20
		;dta $31,$30,$34,$30,$00			;1040
		;dta $00,$00,$00,$00	
	
		;org $0f01
		;dta $0C,$08,$0A,$00,$9E,$20
		;dta $33,$38,$35,$36,$00			;3856
		;dta $00,$00,$00,$00

		org 	$0f01		
		
		; need to put the stuff below in before calling the raster_irq
		lda		$03fe
		sta		scpu
		
		jsr 	raster_irq

		ldx #$ff	; Set the stack pointer to $FF
		txs			
		
		;set VIC to bank $C000
		;lda 	$DD00
		;and 	#%11111100
		;ora 	#%00000000 
		;sta 	$DD00

		; put cheat vars into place
		ldy 	#00
@	
		lda 	$03f2,y
		sta 	$dc,y
		iny
		cpy 	#13
		bne 	@-
	  
		; clear down some vars
		lda 	#$00
		tay
@	
		sta 	$e9,y
		iny
		cpy 	#09
		bne 	@-	
		sta		border
		sta 	background

		;lda     #$ff
		;sta     button_2	; CGS fire 2 setup needs default of $ff

		; REMOVE when front end suppling ******
;		lda 	#09
;		sta 	FRAME_SKIPPING_THRESHOLD 
;		lda 	#03
;		sta 	FRAME_MIN
;
;		lda		#00
;		sta		UNLIMITED_LIVES
;
;		lda		#01
;		sta		MEGA_JUMP
;	
;		lda		#01
;		sta		START_ROOM_ON
;	
;		lda		#00
;		sta		START_ROOM
;		sta		fire2off
;		sta		vdc_old
		; 0 - green room
		; 1 - green room with rocks on right
		; 2 - yellow room
		; 3 - white room		
			
		;jsr c128_check
	
	
;allstartup

		jsr 	copy_sound_music
	
		lda		#00
		sta 	sound_e
		sta 	sound_off

		lda 	soundfx
		beq		@+
		lda		#01
		sta 	sound_off
		
@
		

		ldy 	#00
@
		lda 	$e000,y
		sta 	$0100,y
		iny
		cpy 	#$5c
		bne 	@-

		ldy 	#00
@
		lda 	$e100,y
		sta 	$0e70,y
		iny
		cpy 	#$76
		bne 	@-

		
		lda 	scpu
		beq		@+1
		
		ldy		#00
@
		lda 	$e060,y
		sta 	$0100,y
		iny
		cpy 	#$08
		bne 	@-		
		
@
	
		; music tune off
		lda 	#04
		jsr 	music_on

		;jsr 	c64clearcols
		;jsr 	c64char001	

		; get poss in memory to modify		
;		lda 	#<[blitad+1]
;		sta 	c64_lo
;		lda 	#>[blitad+1]
;		sta 	c64_hi

				
		jsr 	vdc_setup
		jsr 	vdc_screen_clear
		
		lda 	#00
		sta 	colourcode
		jsr 	vdc_colour_clear
		
		jsr 	z80_init
		
		;jsr 	spectrum_init	
				
		jmp 	PlayGame

raster_irq

		lda #$77
		sta $01

		lda #$c0
		sta $a04 

		lda #$ff
		sta $00D8
		
		lda #$7f
		sta $dc0d		; disable timer interrupts
		sta $dd0d

		lda $dc0d  		; by reading this two registers we negate any pending CIA irqs.
		lda $dd0d 
		
		sei

        lda #$3e        ; RAM and I/O only
        sta $ff00		
	
        lda $d01a		; request raster irq
        ora #$01
        sta $d01a

        lda $d011       ; clear high bit of raster line
        and #$7f
        sta $d011 

		; vic ii screen off
		lda #00
		sta $d011		
		
		lda scpu
		bne @+
		
		; 2mhz mode
		lda #$01
		sta $d030		

@	
		
		lda #$00     
		sta frame_counter
		

		lda #<irq1  	
		sta $fffe  		
		lda #>irq1
		sta $ffff		
		
		lda #$f6		; fire raster irq on this line
		sta $d012

		lda #<irq_brk_01
        sta $fffa   
        lda #>irq_brk_01
        sta $fffb  		
		
		lda #$01
		sta $d01a
		sta $d019
		
		cli
		
		rts 		
	
irq1

        sta atemp2+1
        stx xtemp2+1
        sty ytemp2+1
	
		
		;lda $ff00
		;sta mem_buf
		;lda #$3e
		;sta $ff00

		lda $d019
		sta $d019


		lda #<irq1  	
		sta $fffe  		
		lda #>irq1
		sta $ffff		
		
		lda #$f6
		sta $d012
		
		inc frame_counter
		
		lda sound_e
		beq @+
		
		jsr sound_player_e
		jmp skip_music_player
				
@		
			
		lda sound_off
		bne skip_music_player
		jsr sound_player
		
skip_music_player
	
		;lda mem_buf
		;sta $ff00
		

atemp2 	lda #$00
xtemp2 	ldx #$00
ytemp2 	ldy #$00
		
irq_brk_01		
        rti
		
; atari.hea --------------------------------------------------------------

	;org $0800

;.enum	@dmactl
;	blank	= %00
;	narrow	= %01
;	standard= %10
;	wide	= %11
;	missiles= %100
;	players	= %1000
;	lineX1	= %10000
;	lineX2	= %00000
;	dma	= %100000
;.ende

;scr48	= @dmactl(wide|dma|players|missiles|lineX1)		;screen 48b
;scr40	= @dmactl(standard|dma|players|missiles|lineX1)		;screen 40b
;scr32	= @dmactl(narrow|dma|players|missiles|lineX1)		;screen 32b

;.enum	@pmcntl
;	missiles= %1
;	players	= %10
;	trigs	= %100
;.ende

;.enum	@gtictl
;	prior0	= %0
;	prior1	= %1
;	prior2	= %10
;	prior4	= %100
;	prior8	= %1000
;	ply5	= %10000	; Fifth Player Enable
;	mlc	= %100000	; Multiple Color Player Enable
;	mode9	= %01000000
;	mode10	= %10000000
;	mode11	= %11000000
;.ende


;* ---------------------------------------------------------------------------------------------
;* ---	OS
;* ---------------------------------------------------------------------------------------------

;rtclok	= $12		; (3) real time clock

;lmargin	= $52
;rmargin	= $53
;rowcrs	= $54		; cursor line
;colcrs	= $55		; (2) column cursor

;keydef	= $79		; (2) conversion table keypad code to ATASCII

;setvbv	= $e45c
;xitvbv	= $e462
;ciov	= $e456		; Vector for cio

;iocb	= $340		; IOCB
;iocom	= iocb+2	; Command for IOCB
;ioadr	= iocb+4	; (2) address buffer   for IOCB
;ioaux1	= iocb+10	; byte auxiliary 1 IOCB
;ioaux2	= iocb+11	; byte auxiliary 2 IOCB

;icchid	= $0340
;icdno	= $0341
;iccmd	= $0342
;icstat	= $0343
;icbufa	= $0344
;icputb	= $0346
;icbufl	= $0348
;icax1	= $034a
;icax2	= $034b
;icax3	= $034c
;icax4	= $034d
;icax5	= $034e
;icax6	= $034f

;colpf0s	= $02C4		; a record of the shadow COLPF0
;colpf1s	= $02C5		; a record of the shadow COLPF1
;colpf2s	= $02C6		; a record of the shadow COLPF2
;colpf3s	= $02C7		; a record of the shadow COLPF3
;colbaks	= $02C8		; a record of the shadow COLBAK

;crsinh	= $02f0		; Cursor visibility marker
;atachr	= $02fb		; color number for PLOT, DRAW
;kbcodes	= $02fc		; code of the last naciœniêtego key , $ ff if none has not been pressed (KBCODE)
;fildat	= $02fd		; color number for FILL
;chart	= $02f3		; Shade character display control register (CHRCTL)

;* ---------------------------------------------------------------------------------------------
;* ---	KEY ($d209)
;* ---------------------------------------------------------------------------------------------
;key_esc		= 28
;key_space	= 33
;key_v		= 16
;key_b		= 21
;key_n		= 35
;key_m		= 37

;* ---------------------------------------------------------------------------------------------
;* ---	GTIA
;* ---------------------------------------------------------------------------------------------

;hposp0	=	$D000		; The horizontal position of the player 0 (Z)
;hposp1	=	$D001		; The horizontal position of the player 1 (Z)
;hposp2	=	$D002		; The horizontal position of the player 2 (Z)
;hposp3	=	$D003		; The horizontal position of the player 3 (Z)
;hposm0	=	$D004		; The horizontal position of the projectile 0 (Z)
;hposm1	=	$D005		; The horizontal position of the projectile 1 (Z)
;hposm2	=	$D006		; The horizontal position of the projectile 2 (Z)
;hposm3	=	$D007		; The horizontal position of the projectile 3 (Z)
;sizep0	=	$D008		; the horizontal size of the player 0 (Z)
;sizep1	=	$D009		; the horizontal size of the player 1 (Z)
;sizep2	=	$D00A		; the horizontal size of the player 2 (Z)
;sizep3	=	$D00B		; the horizontal size of the player 3 (Z)
;sizem	=	$D00C		; the horizontal size of bullets (Z)
;grafp0	=	$D00D		; Graphics register player 0 (Z)
;grafp1	=	$D00E		; Graphics register player 1 (Z)
;grafp2	=	$D00F		; Graphics register player 2 (Z)
;grafp3	=	$D010		; Graphics register player 3 (Z)
;grafm	=	$D011		; Graphics missiles register (Z)
;colpm0	=	$D012		; color register player and bullet 0 (Z)
;colpm1	=	$D013		; color register player and bullet 1 (Z)
;colpm2	=	$D014		; color register player and bullet 2 (Z)
;colpm3	=	$D015		; color register player and bullet 3 (Z)

;colpf0	=	$D016		; color register the playing field 0 (Z)
;colpf1	=	$D017		; color register the playing field 1 (Z)
;colpf2	=	$D018		; color register the playing field 2 (Z)
;colpf3	=	$D019		; color register the playing field 3 (Z)
;colbak	=	$D01A		; The background color register (Z)

;colpf0	=	$D022		; color register the playing field 0 (Z)
;colpf1	=	$D023		; color register the playing field 1 (Z)
;colpf2	=	$D024		; color register the playing field 2 (Z)
;colpf3	=	$D024		; color register the playing field 3 (Z)
;colbak	=	$D021		; The background color register (Z)

;color0	=	colpf0
;color1	=	colpf1
;color2	=	colpf2
;color3	=	colpf3

;kolm0pf	=	$D000		; collision bullet 0 of the playing field (O)
;kolm1pf	=	$D001		; collision bullet 1 of the playing field (O)
;kolm2pf	=	$D002		; collision bullet 2 of the playing field (O)
;kolm3pf	=	$D003		; collision bullet 3 of the playing field (O)
;kolp0pf	=	$D004		; 0 Player collision with the field of play (O)
;kolp1pf	=	$D005		; 1 Player collision with the field of play (O)
;kolp2pf	=	$D006		; 2 Player collision with the field of play (O)
;kolp3pf	=	$D007		; 3 Player collision with the field of play (O)
;kolm0p	=	$D008		; collision with a player bullet 0 (O)
;kolm1p	=	$D009		; collision with a player bullet 1 (O)
;kolm2p	=	$D00A		; collision with a player bullet 2 (O)
;kolm3p	=	$D00B		; collision with a player bullet 3 (O)
;kolp0p	=	$D00C		; 0 Player collision with another player (O)
;kolp1p	=	$D00D		; 1 Player collision with another player (O)
;kolp2p	=	$D00E		; 2 Player collision with another player (O)
;kolp3p	=	$D00F		; 3 Player collision with another player (O)

;trig0	=	$D010		; state joystick button 0 (O)
;trig1	=	$D011		; state joystick button 1 (O)
;trig3	=	$D013		; marker cartridge (O)

;trig0		=	$dc01		; state joystick button 0 (O)
;trig1		=	$dc00		; state joystick button 1 (O)

;pal		=	$D014		; marker TV system (O)

;gtictl	=	$D01B		; Control log Pact GTIA
;gtiactl	=	gtictl

;vdelay	=	$D01C		; meter vertical delay P/MG
;pmcntl	=	$D01D		; players control register and missiles
;hitclr	=	$D01E		; register reset registers collision

;consol	=	$D01F		; state registry keys console

;* ---------------------------------------------------------------------------------------------
;* ---	POKEY
;* ---------------------------------------------------------------------------------------------

;irqens	=	$0010		; a record of the shadow IRQEN
;irqstat	=	$0011		; a record of the shadow IRQST

;audf1	=	$d200		; frequency generator 1 (Z)
;audc1	=	$d201		; Sound generator control register 1 (Z)
;audf2	=	$d202		; frequency generator 2 (Z)
;audc2	=	$d203		; Sound generator control register 2 (Z)
;audf3	=	$d204		; frequency generator 3 (Z)
;audc3	=	$d205		; Sound generator control register 3 (Z)
;audf4	=	$d206		; frequency generator 4 (Z)
;audc4	=	$d207		; Sound generator control register 4 (Z)

;audctl	=	$D208		; sound generator control register (Z)
;stimer	=	$D209		; register reset counters (Z)

;kbcode	=	$D209		; code of the last naciœniêtego key (O)
;kbcode	=	$dc03		; code of the last naciœniêtego key (O)

;skstres	=	$D20A		; z³¹cza serial status register (Z)
;random	=	$D20A		; a record of the number of random (O)
;serout	=	$D20D		; Serial output register (Z)
;serin	=	$D20D		; Serial output register (O)
;irqen	=	$D20E		; permit interrupts IRQ (Z)
;irqst	=	$D20E		; the status of interrupts IRQ (O)
;skctl	=	$D20F		; z³¹cza serial control register (Z)

;skstat	=	$D20F		; z³¹cza serial status register (O)
;skstat	=	$DC0E		; z³¹cza serial status register (O)

;* ---------------------------------------------------------------------------------------------
;* ---	PIA
;* ---------------------------------------------------------------------------------------------

;porta	=	$D300		; A port Pact PIA
;portb	=	$D301		; B port Pact PIA
;pactl	=	$D302		; port control register A
;pbctl	=	$D303		; port control register B

;porta	=	$DC00		; A port Pact PIA
;portb	=	$DC01		; B port Pact PIA
;pactl	=	$DC02		; port control register A
;pbctl	=	$DC03		; port control register B

;* ---------------------------------------------------------------------------------------------
;* ---	ANTIC
;* ---------------------------------------------------------------------------------------------

;dmactl	=	$D400		; register access control to memory
;chrctl	=	$D401		; register display control characters
;dlptr	=	$D402		; the address of your ANTIC -a
;hscrol	=	$D404		; marker horizontal image shift
;vscrol	=	$D405		; marker horizontal image shift
;pmbase	=	$D407		; Memory address the players and missiles
;chbase	=	$D409		; address character set
;wsync	=	$D40A		; tag waiting for synchronization poziom¹
;vcount	=	$D40B		; a line counter Image
;lpenh	=	$D40C		; the horizontal position of the pen œwietlengo
;lpenv	=	$D40D		; the horizontal position of the pen œwietlengo
;nmien	=	$D40E		; register of permits for NMI
;nmist	=	$D40F		; NMI status register

;* ---------------------------------------------------------------------------------------------
;* ---	HARDWARE
;* ---------------------------------------------------------------------------------------------

;nmivec	=	$FFFA		; interrupt vector NMI
;resetvec=	$FFFC		; interrupt vector RESET
;irqvec	=	$FFFE		; interrupt vector IRQ


; spectrum.asm ----------------------------------------------------------------------------------

		
;out_fe	
		;lsr @
		;sta consol ; Buzzer
;		rts
		
;out_fd
;		sta readkb+1
;		rts
;in_a_fe
;		;lda #$ff
;readkb	lda $d100
;		rts

;out_fd	
		
;		eor #$ff
;		sta keys_rows
			
;		rts
		
;in_a_fe	
;		lda #$ff
;		sta key_result
;		lda skstat
;		and #$04
;		bne nokey
;		stx rk_save_x+1
;		sty rk_save_y+1
;		lda ddrb ;kbcode
;		bmi key_exit
;		tay
;		and #$3f
;		tax
;		lda atari_spectrum_keys,x
;		and #$07
;		tax
;		lda _bitmem0,x
;		and keys_rows
;		beq key_exit
;		tya
;		and #$3f
;		tax
;		lda atari_spectrum_keys,x
;		lsr @
;		lsr @
;		lsr @
;		lsr @
;		tax
;		lda _bitmem0,x
;		eor #$ff
;		sta key_result
;key_exit
;rk_save_x
;		ldx #$00
;rk_save_y
;		ldy #$00
;nokey	lda key_result
;		rts

		
;keys_rows 	dta $00
;key_result	dta $00
		
;atari_spectrum_keys
; spectrum keyboard matrix
;  Bit    Col0  Col1  Col2  Col3  Col4  
;  Row0   CS    "Z"   "X"   "C"   "V"   ; 0xFEFE
;  Row1   "A"   "S"   "D"   "F"   "G"   ; 0xFDFE
;  Row2   "Q"   "W"   "E"   "R"   "T"   ; 0xFBFE
;  Row3   "1"   "2"   "3"   "4"   "5"	; 0xF7FE   
;  Row4   "0"   "9"   "8"   "7"   "6"   ; 0xEFFE
;  Row5   "P"   "O"   "I"   "U"   "Y"	; 0xDFFE   
;  Row6   ENTER "L"   "K"   "J"   "H"   ; 0xBFFE
;  Row7   SPACE SS    "M"   "N"   "B"   ; 0x7FFE
;		dta $16	; L $00
;		dta $36	; J $01
;		dta $ff	; ;: $02
;		dta $ff	; F1 $03
;		dta $ff	; F2 $04
;		dta $26	; K $05
;		dta $ff	; +\ $06
;		dta $ff	; *^ $07
;		dta $15	; O $08
;		dta $ff	;   $09
;		dta $05	; P $0A
;		dta $35	; U $0B
;		dta $06	; RETURN $0C
;		dta $25	; I $0D
;		dta $ff	; -_ $0E
;		dta $ff	; =| $0F
;		dta $40	; $10 V
;		dta $ff	; $11 HELP
;		dta $30	; $12 C
;		dta $ff	; $13 F3
;		dta $ff	; $14 F4
;		dta $47	; $15 B
;		dta $20 ; $16 X
;		dta $10 ; $17 Z
;		dta $33	; $18 4$
;		dta $ff ; $19
;		dta $24	; $1a 3#
;		dta $44	; $1b 6&
;		dta $ff ; $1c ESC
;		dta $43	; $1d 5%
;		dta $13 ; $1e 2"
;		dta $03 ; $1f 1!
;		dta $ff ; $20 ,[
;		dta $07 ; $21 SPACE
;		dta $ff	; $22 .]
;		dta $37	; $23 N
;		dta $ff	; $24
;		dta $27	; $25 M
;		dta $ff	; $26 /?
;		dta $ff ; $27 LOGO (RSHIFT)
;		dta $32	; $28 R
;		dta $ff	; $29
;		dta $22	; $2a E
;		dta $45 ; $2b Y
;		dta $ff	; $2c TAB
;		dta $42	; $2d T
;		dta $12	; $2e W
;		dta $02	; $2f Q
;		dta $14	; $30 9(
;		dta $ff ; $31
;		dta $04 ; $32 0)
;		dta $34 ; $33 7'
;		dta $ff	; $34 BACKSPACE/DEL
;		dta $24 ; $35 8@
;		dta $ff ; $36 <CLEAR
;		dta $ff ; $37 >INS
;		dta $31 ; $38 F
;		dta $46 ; $39 H
;		dta $21 ; $3a D
;		dta $ff ; $3b
;		dta $ff ; $3c CAPS
;		dta $41	; $3d G
;		dta $11	; $3e S
;		dta $01 ; $3f A
		
;in_a_1f
;		lda #$00	; kempston is active high FUDLR
;		rts


;c128_check:
;        lda $d030
;        cmp #$ff
;        beq c64
;        bne done_c128
;c128:
;        lda #$ff
;        sta $d030
;done_c128:
;        lda #$01
;		sta C128_MODE_ON
;        rts
;
;c64:
;        lda #$fc
;        sta $d030
;        eor $d030
;        beq c128
;done_c64:
;        lda #$00
;		sta C128_MODE_ON
;        rts 


		
		;lda trig0
		;lsr @
		;lda porta	; RLDU active low
		;and #$0f
		;tax
		;lda joystick_table,x
		;scs:ora #$10
		;rts
		
;joystick_table
;		dta %1111; 0000
;		dta %0111; 0001
;		dta %1011; 0010
;		dta %0011; 0011
;		dta %1101; 0100
;		dta %0101; 0101
;		dta %1001; 0110
;		dta %0001; 0111
;		dta %1110; 1000
;		dta %0110; 1001
;		dta %1010; 1010
;		dta %0010; 1011
;		dta %1100; 1100
;		dta %0100; 1101
;		dta %1000; 1110
;		dta %0000; 1111

ld_a_r			.macro
				
		; sid random gen
				
		;LDA #$FF  ; maximum frequency value
		;STA $D40E ; voice 3 frequency low byte
		;STA $D40F ; voice 3 frequency high byte
		;LDA #$80  ; noise waveform, gate bit off
		;STA $D412 ; voice 3 control register

		;lda     #%10000000 ;kill vol chan 3
        ;ora     $d418
        ;sta     $d418		
		
		LDA $d012

				.endm
		
		
;spectrum_init

		; init ANTIC + interrupts
;		sei
;		lda #0
;		sta nmien	; disable interrupts
;		sta irqen
;		sta dmactl	; disable screen
;		lda #%11111110
;		sta portb

;		lda #<nmi
;		sta $fffa
;		lda #>nmi
;		sta $fffb
;		lda #<irq
;		sta $fffe
;		lda #>irq
;		sta $ffff
		
		; set screen
;		lda #<dlist
;		sta dlptr
;		lda #>dlist
;		sta dlptr+1
;		lda #%00101101
;		sta dmactl

;		lda #$c0
;		sta nmien

		; init POKEY
;		ldx #$08
;		lda #$00
;		sta skctl
;clear	sta $d200,x
;		dex
;		bpl clear
;		lda #$03
;		sta skctl
		; init GTIA
;		ldx #$0f
;		lda #$00
;cleargtia	sta $d000,x
;		dex
;		bpl cleargtia
		; colors
;		lda #$00
;		sta colbak
;		sta colpf2
;		lda #$0e
;		sta colpf1
		
;		rts

;nmi
;irq
;		rti
		
		
; z80.asm --------------------------------------------------------------------------

; spectrum stuff
; adresses
z80_regs equ $00
z80_f	equ $30		;moved from $00 for C64
z80_a	equ $31		;moved from $01 for C64
z80_af	equ z80_f
z80_c	equ $02
z80_b	equ $03
z80_bc	equ z80_c
z80_e	equ $04
z80_d	equ $05
z80_de	equ z80_e
z80_l	equ $06
z80_h	equ $07
z80_hl	equ z80_l
z80_ix	equ $08
z80_iy	equ $0a
z80_fp	equ $0c
z80_ap	equ $0d
z80_cp	equ $0e
z80_bp	equ $0f
z80_bcp	equ z80_cp
z80_ep	equ $10
z80_dp	equ $11
z80_dep	equ z80_ep
z80_lp	equ $12
z80_hp	equ $13
z80_hlp	equ z80_lp
z80_sp  equ $14
z80_reg0 equ $16
z80_reg1 equ $17
z80_reg2 equ $18
z80_reg3 equ $19


z80_free_zp	equ $20
	
_bitmem0	equ $f8
_bitmem1	equ $f9
_bitmem2	equ $fa
_bitmem3	equ $fb
_bitmem4	equ $fc
_bitmem5	equ $fd
_bitmem6	equ $fe
_bitmem7	equ $ff
	
; constants	
_bitvalue0	equ $01	
_bitvalue1	equ $02	
_bitvalue2	equ $04	
_bitvalue3	equ $08	
_bitvalue4	equ $10	
_bitvalue5	equ $20	
_bitvalue6	equ $40	
_bitvalue7	equ $80	

_notbitvalue0	equ $fe	
_notbitvalue1	equ $fd	
_notbitvalue2	equ $fb	
_notbitvalue3	equ $f7	
_notbitvalue4	equ $ef	
_notbitvalue5	equ $df	
_notbitvalue6	equ $bf	
_notbitvalue7	equ $7f	


add_hl_bc
		lda z80_l
		clc
		adc z80_c
		sta z80_l
		lda z80_h
		adc z80_b
		sta z80_h
		rts
		
add_ix_de
		lda z80_ix
		clc
		adc z80_e
		sta z80_ix
		lda z80_ix+1
		adc z80_d
		sta z80_ix+1
		rts
		
add_iy_de
		lda z80_iy
		clc
		adc z80_e
		sta z80_iy
		lda z80_iy+1
		adc z80_d
		sta z80_iy+1
		rts
		
add_hl_de
		lda z80_l
		clc
		adc z80_e
		sta z80_l
		lda z80_h
		adc z80_d
		sta z80_h
		rts

add_iy_bc
		lda z80_iy
		clc
		adc z80_c
		sta z80_iy
		lda z80_iy+1
		adc z80_b
		sta z80_iy+1
		rts
		
sbc_hl_de
		lda z80_l
		sbc z80_e
		sta z80_l
		lda z80_h
		sbc z80_d
		sta z80_h
		rts

sbc_hl_bc
		lda z80_l
		sbc z80_c
		sta z80_l
		lda z80_h
		sbc z80_b
		sta z80_h
		rts

cmp_hl_bc
		lda z80_l
		cmp z80_c
		bne cmp_hl_bc_end
		lda z80_h
		cmp z80_b
cmp_hl_bc_end
		rts
		
cmp_iy_ix
		lda z80_iy
		cmp z80_ix
		bne cmp_iy_ix_end
		lda z80_iy+1
		cmp z80_ix+1
cmp_iy_ix_end
		rts
		
dec_hl
		lda z80_l
		bne dec_hl_no_dec_h
		dec z80_h
dec_hl_no_dec_h
		dec z80_l
		rts
	
dec_ix
		lda z80_ix
		bne dec_ix_no_dec_h
		dec z80_ix+1
dec_ix_no_dec_h
		dec z80_ix
		rts
		
dec_bc	
		lda z80_c
		bne dec_bc_no_dec_b
		dec z80_b
dec_bc_no_dec_b
		dec z80_c
		rts
	
dec_de
		lda z80_e
		bne dec_de_no_dec_d
		dec z80_d
dec_de_no_dec_d
		dec z80_e
		rts
		
ex_de_hl
		lda z80_e
		ldx z80_l
		stx z80_e
		sta z80_l
		lda z80_d
		ldx z80_h
		stx z80_d
		sta z80_h
		rts

;exx
;		ldx #$00
;exx_loop		
;		lda z80_c,x
;		ldy z80_cp,x
;		sty z80_c,x
;		sta z80_cp,x
;		inx
;		cpx #$06
;		bne exx_loop
;		rts

exx		lda z80_c
		ldx z80_cp
		stx z80_c
		sta z80_cp
		lda z80_b
		ldx z80_bp
		stx z80_b
		sta z80_bp
		lda z80_e
		ldx z80_ep
		stx z80_e
		sta z80_ep
		lda z80_d
		ldx z80_dp
		stx z80_d
		sta z80_dp		
		lda z80_l
		ldx z80_lp
		stx z80_l
		sta z80_lp
		lda z80_h
		ldx z80_hp
		stx z80_h
		sta z80_hp
		rts
		
ex_sp_hl
		tsx
		lda $0103,x
		ldy z80_h
		sta z80_h
		tya
		sta $0103,x
		lda $0104,x
		ldy z80_l
		sta z80_l
		tya
		sta $104,x
		rts
		
ldir
		ldy #$00
		ldx z80_b
		beq ldir_last_page
ldir_loop		
		lda (z80_hl),y
		sta (z80_de),y
		iny
		bne ldir_loop
		inc z80_h
		inc z80_d
		dex
		bne ldir_loop
ldir_last_page
		lda z80_c
		beq ldir_end
ldir_last_page_loop		
		lda (z80_hl),y
		sta (z80_de),y
		iny
		cpy z80_c
		bne ldir_last_page_loop
ldir_end		
		stx z80_c
		stx z80_b
		tya
		clc
		adc z80_l
		sta z80_l
		bcc *+4
		inc z80_h
		tya
		clc
		adc z80_e
		sta z80_e
		bcc *+4
		inc z80_d
		rts
		
lddr	ldy #$00
lddr_loop
		lda (z80_hl),y
		sta (z80_de),y
		jsr dec_hl
		jsr dec_de
		jsr dec_bc
		lda z80_b
		ora z80_c
		bne lddr_loop
		rts
ei
		rts
di
		rts
		
	
z80_init
		ldx #$00
		lda #$01
z80_init_loop		
		sta _bitmem0,x
		inx
		asl @
		bne z80_init_loop
		rts
		
; pentagram_atari.asm --------------------------------------------------------------

		;org $1000
			
;0000 equ 000
;L0004 equ $0004
;L0006 equ $0006
;L0007 equ $0007
;L0008 equ $0008
;L0009 equ $0009
;L000C equ $000C
;L000D equ $000D
;L0010 equ $0010
;L0018 equ $0018
;L001F equ $001F
L0020 equ $0020
L0040 equ $0040
L00F8 equ $00F8
L0101 equ $0101
L0105 equ $0105
L0120 equ $0120
L0300 equ $0300
L0303 equ $0303
L0318 equ $0318
L0500 equ $0500
L060F equ $060F
L0680 equ $0680
L0721 equ $0721
L0726 equ $0726
L09B8 equ $09B8
L0F06 equ $0F06
L0F0F equ $0F0F
L10B8 equ $10B8
L1202 equ $1202
L1800 equ $1800
L1803 equ $1803
L1FC0 equ $1FC0
L2000 equ $2000
L4000 equ spectrum_screen
L4001 equ spectrum_screen+1
L4002 equ $4002
L430B equ $430B
L5700 equ spectrum_screen+$1800-$100
L57E0 equ spectrum_screen+$1800-$20

;L5800 equ spectrum_attr
;L5801 equ spectrum_attr+1

L5A42 equ spectrum_attr+$242;$5A42
L5A62 equ spectrum_attr+$262;$5A62

L5C3A equ $5C3A
L5F90 equ $5F90
L6002 equ $6002
;LB00C equ $B00C
;LB47C equ $B47C
;LB4D0 equ $B4D0
LDD73 equ ScreenBuffer + $4E4 ;$DD73
;LF100 equ $F100
LF4F0 equ $F4F0
LF4FC equ $F4FC
LF810 equ $F810
LF8EC equ $F8EC
LF8F0 equ $F8F0
LF8F4 equ $F8F4
LFAEF equ $FAEF
LFAF4 equ $FAF4
LFBF0 equ $FBF0
LFBF8 equ $FBF8
LFBF9 equ $FBF9
LFBFB equ $FBFB
LFCDC equ $FCDC
LFCF4 equ $FCF4
LFCF8 equ $FCF8
LFCF9 equ $FCF9
LFEF8 equ $FEF8
LFFC0 equ $FFC0
LFFE0 equ $FFE0

;FRAME_SKIPPING = 0
;FRAME_SKIPPING_THRESHOLD = 7
DISABLE_TITLE_SCREEN = 0
;CHEAT_UNLIMITED_LIVES = 1
;START_ROOM = 0			; 0 - green room
						; 1 - green room with rocks on right
						; 2 - yellow room
						; 3 - white room

SPRITE_PARAMS_SIZE = 3	; 0 width + flags
						; 1 height
						; 2 size in bytes (width * height)
						; sprite data
						; sprite mask
sprite_mask_ptr	equ z80_free_zp ; 2 bytes
sprite_has_mask	equ z80_free_zp+2; 1 byte (00 - no mask, ff - mask)
zp_tmp_0		equ z80_free_zp+3
zp_tmp_1		equ z80_free_zp+4
zp_tmp_2		equ z80_free_zp+5
zp_tmp_3		equ z80_free_zp+6
FlagFrameSkipping	equ z80_free_zp+7

;spectrum_rom
;		ins 'rom_page_0.bin'

;PlayGame: ; 5E00
;5E00:   DI
;5E01:   LD   SP,PlayGame
;5E04:   JP   Start

PlayGame: ; 5E00
        jsr di ; DI
        ; LD SP,PlayGame:  ; LD   SP,PlayGame
        jmp Start ; JP   Start

;RoomSizeTable: ; 5E07
;5E07:   DB 40,40,80,20,40,80,40,20,80

RoomSizeTable: ; 5E07
        .he 40,40,80,20,40,80,40,20,80 ; DB 40,40,80,20,40,80,40,20,80

;Locations: ; 5E10
;        DB 000h,01Eh,007h
;        DB 018h,093h,01Ch,000h,00Ch,000h,00Dh,000h,0FFh,001h,0FDh,0FEh,0BDh,05Ah,075h,0B5h
;        DB 0F5h,035h,01Ah,01Dh,02Eh,025h,01Eh,01Ch,015h,033h,088h,09Dh

Locations: ; 000	5E10
        .he 000,01E,001 ; DB 000h,01Eh,007h
        .he 018,093,01C,000,00C,000,00D,000,0FF,001,0FD,0FE,0BD,05A,075,0B5 ; DB 018h,093h,01Ch,000h,00Ch,000h,00Dh,000h,0FFh,001h,0FDh,0FEh,0BDh,05Ah,075h,0B5h
        .he 0F5,035,01A,01D,02E,025,01E,01C,015,033,088,09D ; DB 0F5h,035h,01Ah,01Dh,02Eh,025h,01Eh,01Ch,015h,033h,088h,09Dh

;        DB 001h,012h,002h
;        DB 000h,003h,005h,002h,008h,000h,00Bh,000h,0FFh,02Dh,02Fh,026h,01Eh,02Dh,024h,023h
		
		;001	
        .he 001,012,002 ; DB 001h,012h,002h
        .he 000,003,005,002,008,000,00B,000,0FF,02D,02F,026,01E,02D,024,023 ; DB 000h,003h,005h,002h,008h,000h,00Bh,000h,0FFh,02Dh,02Fh,026h,01Eh,02Dh,024h,023h

;        DB 002h,028h,003h
;        DB 007h,001h,018h,095h,01Ch,000h,00Eh,000h,00Dh,000h,0FFh,042h,02Eh,016h,039h,046h
;        DB 079h,0B9h,0F9h,056h,096h,06Eh,0AEh,080h,091h,088h,099h,060h,038h,001h,0FDh,0FEh
;        DB 02Ch,019h,01Bh,009h,00Bh,026h

		;002
        .he 002,028,004 ; DB 002h,028h,003h
        .he 007,001,018,095,01C,000,00E,000,00D,000,0FF,042,02E,016,039,046 ; DB 007h,001h,018h,095h,01Ch,000h,00Eh,000h,00Dh,000h,0FFh,042h,02Eh,016h,039h,046h
        .he 079,0B9,0F9,056,096,06E,0AE,080,091,088,099,060,038,001,0FD,0FE ; DB 079h,0B9h,0F9h,056h,096h,06Eh,0AEh,080h,091h,088h,099h,060h,038h,001h,0FDh,0FEh
        .he 02C,019,01B,009,00B,026 ; DB 02Ch,019h,01Bh,009h,00Bh,026h

;        DB 003h,011h,004h
;        DB 000h,007h,002h,001h,008h,000h,00Bh,000h,0FFh,022h,01Ah,01Bh,01Ch,090h,00Eh

		;003
        .he 003,011,005 ; DB 003h,011h,004h
        .he 000,007,002,001,008,000,00B,000,0FF,022,01A,01B,01C,090,00E ; DB 000h,007h,002h,001h,008h,000h,00Bh,000h,0FFh,022h,01Ah,01Bh,01Ch,090h,00Eh

;        DB 004h,019h,005h
;        DB 000h,009h,008h,000h,00Bh,000h,0FFh,02Eh,02Ah,022h,01Ah,012h,01Eh,027h,017h,002h
;        DB 01Fh,05Fh,0DFh,0C0h,06Ah,080h,09Fh

		;004
        .he 004,019,003 ; DB 004h,019h,005h
        .he 000,009,008,000,00B,000,0FF,02E,02A,022,01A,012,01E,027,017,002 ; DB 000h,009h,008h,000h,00Bh,000h,0FFh,02Eh,02Ah,022h,01Ah,012h,01Eh,027h,017h,002h
        .he 01F,05F,0DF,0C0,06A,080,09F ; DB 01Fh,05Fh,0DFh,0C0h,06Ah,080h,09Fh

;        DB 005h,015h,006h
;        DB 001h,006h,008h,000h,009h,000h,0FFh,00Ah,01Ah,05Ah,09Ah,02Bh,022h,01Bh,012h,019h
;        DB 021h,02Dh,06Dh

		;005
        .he 005,015,007 ; DB 005h,015h,006h
        .he 001,006,008,000,009,000,0FF,00A,01A,05A,09A,02B,022,01B,012,019 ; DB 001h,006h,008h,000h,009h,000h,0FFh,00Ah,01Ah,05Ah,09Ah,02Bh,022h,01Bh,012h,019h
        .he 021,02D,06D ; DB 021h,02Dh,06Dh

;        DB 006h,00Ch,017h
;        DB 001h,007h,003h,005h,011h,000h,0FFh,0F1h,014h,02Bh

		;006
        .he 006,00C,011 ; DB 006h,00Ch,017h
        .he 001,007,003,005,011,000,0FF,0F1,014,02B ; DB 001h,007h,003h,005h,011h,000h,0FFh,0F1h,014h,02Bh

;        DB 007h,01Fh,002h
;        DB 001h,008h,002h,003h,003h,006h,00Ah,000h,009h,000h,0FFh,01Fh,005h,00Eh,017h,02Fh
;        DB 036h,03Dh,03Ah,031h,01Fh,028h,010h,009h,002h,023h,024h,01Bh,01Ch

		;007
        .he 007,01F,002 ; DB 007h,01Fh,002h
        .he 001,008,002,003,003,006,00A,000,009,000,0FF,01F,005,00E,017,02F ; DB 001h,008h,002h,003h,003h,006h,00Ah,000h,009h,000h,0FFh,01Fh,005h,00Eh,017h,02Fh
        .he 036,03D,03A,031,01F,028,010,009,002,023,024,01B,01C ; DB 036h,03Dh,03Ah,031h,01Fh,028h,010h,009h,002h,023h,024h,01Bh,01Ch

;        DB 008h,00Fh,004h
;        DB 000h,014h,003h,007h,00Ah,000h,00Bh,000h,0FFh,072h,0EAh,0D2h,0EDh

		;008
        .he 008,00F,005 ; DB 008h,00Fh,004h
        .he 000,014,003,007,00A,000,00B,000,0FF,072,0EA,0D2,0ED ; DB 000h,014h,003h,007h,00Ah,000h,00Bh,000h,0FFh,072h,0EAh,0D2h,0EDh

;        DB 009h,018h,005h
;        DB 000h,015h,001h,00Ah,002h,004h,008h,000h,00Bh,000h,0FFh,027h,02Bh,02Ch,025h,01Dh
;        DB 013h,014h,022h,01Ah,090h,024h

		;009
        .he 009,018,003 ; DB 009h,018h,005h
        .he 000,015,001,00A,002,004,008,000,00B,000,0FF,027,02B,02C,025,01D ; DB 000h,015h,001h,00Ah,002h,004h,008h,000h,00Bh,000h,0FFh,027h,02Bh,02Ch,025h,01Dh
        .he 013,014,022,01A,090,024 ; DB 013h,014h,022h,01Ah,090h,024h

;        DB 00Ah,008h,015h
;        DB 001h,00Bh,003h,009h,011h,000h
		
		;010
        .he 00A,008,013 ; DB 00Ah,008h,015h
        .he 001,00B,003,009,011,000 ; DB 001h,00Bh,003h,009h,011h,000h

;        DB 00Bh,01Dh,016h
;        DB 001h,00Ch,003h,00Ah,011h,000h,0FFh,00Fh,014h,054h,094h,0D4h,01Ch,05Ch,09Ch,0DCh
;        DB 00Bh,02Ch,06Ch,0ACh,0ECh,022h,024h,064h,0A4h,078h,0E4h

		;011
        .he 00B,01D,017 ; DB 00Bh,01Dh,016h
        .he 001,00C,003,00A,011,000,0FF,00F,014,054,094,0D4,01C,05C,09C,0DC ; DB 001h,00Ch,003h,00Ah,011h,000h,0FFh,00Fh,014h,054h,094h,0D4h,01Ch,05Ch,09Ch,0DCh
        .he 00B,02C,06C,0AC,0EC,022,024,064,0A4,078,0E4 ; DB 00Bh,02Ch,06Ch,0ACh,0ECh,022h,024h,064h,0A4h,078h,0E4h

;        DB 00Ch,022h,007h
;        DB 000h,016h,001h,00Dh,003h,00Bh,00Ah,000h,00Bh,000h,0FFh,01Fh,010h,011h,012h,013h
;        DB 014h,015h,016h,017h,01Fh,028h,029h,02Ah,032h,03Ah,03Dh,035h,02Dh,019h,02Eh,02Fh

		;012
        .he 00C,022,001 ; DB 00Ch,022h,007h
        .he 000,016,001,00D,003,00B,00A,000,00B,000,0FF,01F,010,011,012,013 ; DB 000h,016h,001h,00Dh,003h,00Bh,00Ah,000h,00Bh,000h,0FFh,01Fh,010h,011h,012h,013h
        .he 014,015,016,017,01F,028,029,02A,032,03A,03D,035,02D,019,02E,02F ; DB 014h,015h,016h,017h,01Fh,028h,029h,02Ah,032h,03Ah,03Dh,035h,02Dh,019h,02Eh,02Fh

;        DB 00Dh,01Ch,012h
;        DB 001h,00Eh,003h,00Ch,011h,000h,0FFh,01Fh,022h,023h,024h,025h,01Ah,01Bh,01Ch,01Dh
;        DB 025h,012h,014h,015h,02Ah,02Bh,02Dh,092h,02Ch,013h

		;013
        .he 00D,01C,012 ; DB 00Dh,01Ch,012h
        .he 001,00E,003,00C,011,000,0FF,01F,022,023,024,025,01A,01B,01C,01D ; DB 001h,00Eh,003h,00Ch,011h,000h,0FFh,01Fh,022h,023h,024h,025h,01Ah,01Bh,01Ch,01Dh
        .he 025,012,014,015,02A,02B,02D,092,02C,013 ; DB 025h,012h,014h,015h,02Ah,02Bh,02Dh,092h,02Ch,013h

;        DB 00Eh,012h,003h
;        DB 000h,017h,003h,00Dh,00Ah,000h,00Bh,000h,0FFh,073h,02Bh,024h,022h,01Bh,090h,023h

		;014
        .he 00E,012,004 ; DB 00Eh,012h,003h
        .he 000,017,003,00D,00A,000,00B,000,0FF,073,02B,024,022,01B,090,023 ; DB 000h,017h,003h,00Dh,00Ah,000h,00Bh,000h,0FFh,073h,02Bh,024h,022h,01Bh,090h,023h

;        DB 00Fh,020h,004h
;        DB 004h,018h,00Ch,000h,00Fh,000h,0FFh,0BAh,003h,043h,083h,01Fh,020h,021h,022h,023h
;        DB 01Bh,013h,00Bh,004h,090h,019h,080h,0C5h,050h,09Dh,0C0h,02Dh,018h,005h

		;015
        .he 00F,020,005 ; DB 00Fh,020h,004h
        .he 004,018,00C,000,00F,000,0FF,0BA,003,043,083,01F,020,021,022,023 ; DB 004h,018h,00Ch,000h,00Fh,000h,0FFh,0BAh,003h,043h,083h,01Fh,020h,021h,022h,023h
        .he 01B,013,00B,004,090,019,080,0C5,050,09D,0C0,02D,018,005 ; DB 01Bh,013h,00Bh,004h,090h,019h,080h,0C5h,050h,09Dh,0C0h,02Dh,018h,005h

;        DB 010h,015h,005h
;        DB 005h,011h,00Ch,000h,00Dh,000h,0FFh,000h,0D8h,0C0h,088h,01Ch,010h,008h,000h,018h
;        DB 019h,038h,024h

		;016
        .he 010,015,003 ; DB 010h,015h,005h
        .he 005,011,00C,000,00D,000,0FF,000,0D8,0C0,088,01C,010,008,000,018 ; DB 005h,011h,00Ch,000h,00Dh,000h,0FFh,000h,0D8h,0C0h,088h,01Ch,010h,008h,000h,018h
        .he 019,038,024 ; DB 019h,038h,024h

;        DB 011h,00Ah,006h
;        DB 007h,010h,000h,01Ah,00Eh,000h,00Bh,000h

		;017
        .he 011,00A,007 ; DB 011h,00Ah,006h
        .he 007,010,000,01A,00E,000,00B,000 ; DB 007h,010h,000h,01Ah,00Eh,000h,00Bh,000h

;        DB 012h,01Ah,007h
;        DB 001h,013h,008h,000h,009h,000h,0FFh,00Bh,009h,049h,089h,0C9h,021h,02Dh,04Ch,01Fh
;        DB 001h,002h,008h,011h,012h,00Ah,00Bh,00Ch

		;018
        .he 012,01A,001 ; DB 012h,01Ah,007h
        .he 001,013,008,000,009,000,0FF,00B,009,049,089,0C9,021,02D,04C,01F ; DB 001h,013h,008h,000h,009h,000h,0FFh,00Bh,009h,049h,089h,0C9h,021h,02Dh,04Ch,01Fh
        .he 001,002,008,011,012,00A,00B,00C ; DB 001h,002h,008h,011h,012h,00Ah,00Bh,00Ch

;        DB 013h,013h,002h
;        DB 000h,01Ch,001h,014h,003h,012h,00Ah,000h,00Bh,000h,0FFh,038h,01Bh,060h,002h,070h
;        DB 00Dh

		;019
        .he 013,013,002 ; DB 013h,013h,002h
        .he 000,01C,001,014,003,012,00A,000,00B,000,0FF,038,01B,060,002,070 ; DB 000h,01Ch,001h,014h,003h,012h,00Ah,000h,00Bh,000h,0FFh,038h,01Bh,060h,002h,070h
        .he 00D ; DB 00Dh

;        DB 014h,011h,003h
;        DB 001h,015h,002h,008h,003h,013h,00Ah,000h,009h,000h,0FFh,028h,01Ch,0A0h,09Ah

		;020
        .he 014,011,004 ; DB 014h,011h,003h
        .he 001,015,002,008,003,013,00A,000,009,000,0FF,028,01C,0A0,09A ; DB 001h,015h,002h,008h,003h,013h,00Ah,000h,009h,000h,0FFh,028h,01Ch,0A0h,09Ah

;        DB 015h,01Ah,004h
;        DB 002h,009h,003h,014h,00Ah,000h,009h,000h,0FFh,02Fh,039h,028h,000h,011h,022h,033h
;        DB 00Bh,01Ch,02Ch,02Dh,03Eh,005h,016h,027h

		;021
        .he 015,01A,005 ; DB 015h,01Ah,004h
        .he 002,009,003,014,00A,000,009,000,0FF,02F,039,028,000,011,022,033 ; DB 002h,009h,003h,014h,00Ah,000h,009h,000h,0FFh,02Fh,039h,028h,000h,011h,022h,033h
        .he 00B,01C,02C,02D,03E,005,016,027 ; DB 00Bh,01Ch,02Ch,02Dh,03Eh,005h,016h,027h

;        DB 016h,00Eh,005h
;        DB 002h,00Ch,000h,01Dh,008h,000h,00Bh,000h,0FFh,021h,0C3h,0C4h

		;022
        .he 016,00E,003 ; DB 016h,00Eh,005h
        .he 002,00C,000,01D,008,000,00B,000,0FF,021,0C3,0C4 ; DB 002h,00Ch,000h,01Dh,008h,000h,00Bh,000h,0FFh,021h,0C3h,0C4h

;        DB 017h,00Ah,006h
;        DB 002h,00Eh,000h,01Fh,008h,000h,00Bh,000h

		;023
        .he 017,00A,007 ; DB 017h,00Ah,006h
        .he 002,00E,000,01F,008,000,00B,000 ; DB 002h,00Eh,000h,01Fh,008h,000h,00Bh,000h

;        DB 018h,012h,007h
;        DB 005h,019h,006h,00Fh,00Ch,000h,00Dh,000h,0FFh,033h,014h,01Bh,01Dh,024h,090h,01Ch

		;024
        .he 018,012,001 ; DB 018h,012h,007h
        .he 005,019,006,00F,00C,000,00D,000,0FF,033,014,01B,01D,024,090,01C ; DB 005h,019h,006h,00Fh,00Ch,000h,00Dh,000h,0FFh,033h,014h,01Bh,01Dh,024h,090h,01Ch

;        DB 019h,00Ah,002h
;        DB 000h,022h,007h,018h,00Eh,000h,00Bh,000h

		;025
        .he 019,00A,002 ; DB 019h,00Ah,002h
        .he 000,022,007,018,00E,000,00B,000 ; DB 000h,022h,007h,018h,00Eh,000h,00Bh,000h

;        DB 01Ah,00Eh,00Bh
;        DB 000h,023h,002h,011h,010h,000h,0FFh,090h,054h,009h,014h,02Ch

		;026
        .he 01A,00E,00c ; DB 01Ah,00Eh,00Bh
        .he 000,023,002,011,010,000,0FF,090,054,009,014,02C ; DB 000h,023h,002h,011h,010h,000h,0FFh,090h,054h,009h,014h,02Ch

;        DB 01Bh,015h,004h
;        DB 000h,024h,008h,000h,00Bh,000h,0FFh,0C0h,047h,001h,0D7h,0D8h,080h,0DFh,029h,005h
;        DB 006h,078h,007h

		;027
        .he 01B,015,005 ; DB 01Bh,015h,004h
        .he 000,024,008,000,00B,000,0FF,0C0,047,001,0D7,0D8,080,0DF,029,005 ; DB 000h,024h,008h,000h,00Bh,000h,0FFh,0C0h,047h,001h,0D7h,0D8h,080h,0DFh,029h,005h
        .he 006,078,007 ; DB 006h,078h,007h

;        DB 01Ch,012h,00Dh
;        DB 000h,028h,002h,013h,010h,000h,0FFh,02Fh,02Ah,02Bh,02Ch,02Dh,012h,013h,014h,015h

		;028
        .he 01C,012,00b ; DB 01Ch,012h,00Dh
        .he 000,028,002,013,010,000,0FF,02F,02A,02B,02C,02D,012,013,014,015 ; DB 000h,028h,002h,013h,010h,000h,0FFh,02Fh,02Ah,02Bh,02Ch,02Dh,012h,013h,014h,015h

;        DB 01Dh,019h,006h
;        DB 002h,016h,008h,000h,009h,000h,0FFh,098h,031h,02Eh,020h,021h,022h,023h,03Bh,033h
;        DB 02Bh,020h,01Ch,0E8h,018h,0F0h,03Ch

		;029
        .he 01D,019,007 ; DB 01Dh,019h,006h
        .he 002,016,008,000,009,000,0FF,098,031,02E,020,021,022,023,03B,033 ; DB 002h,016h,008h,000h,009h,000h,0FFh,098h,031h,02Eh,020h,021h,022h,023h,03Bh,033h
        .he 02B,020,01C,0E8,018,0F0,03C ; DB 02Bh,020h,01Ch,0E8h,018h,0F0h,03Ch

;        DB 01Eh,008h,007h
;        DB 001h,01Fh,008h,000h,009h,000h

		;030
        .he 01E,008,001 ; DB 01Eh,008h,007h
        .he 001,01F,008,000,009,000 ; DB 001h,01Fh,008h,000h,009h,000h

;        DB 01Fh,01Fh,002h
;        DB 001h,020h,002h,017h,003h,01Eh,00Ah,000h,009h,000h,0FFh,007h,002h,00Ah,012h,01Bh
;        DB 024h,02Dh,02Eh,02Fh,01Fh,042h,04Ah,052h,05Bh,064h,06Dh,06Eh,06Fh

		;031
        .he 01F,01F,002 ; DB 01Fh,01Fh,002h
        .he 001,020,002,017,003,01E,00A,000,009,000,0FF,007,002,00A,012,01B ; DB 001h,020h,002h,017h,003h,01Eh,00Ah,000h,009h,000h,0FFh,007h,002h,00Ah,012h,01Bh
        .he 024,02D,02E,02F,01F,042,04A,052,05B,064,06D,06E,06F ; DB 024h,02Dh,02Eh,02Fh,01Fh,042h,04Ah,052h,05Bh,064h,06Dh,06Eh,06Fh

;        DB 020h,00Ch,003h
;        DB 000h,02Eh,001h,021h,003h,01Fh,00Ah,000h,00Bh,000h

		;032
        .he 020,00C,004 ; DB 020h,00Ch,003h
        .he 000,02E,001,021,003,01F,00A,000,00B,000 ; DB 000h,02Eh,001h,021h,003h,01Fh,00Ah,000h,00Bh,000h

;        DB 021h,00Ah,004h
;        DB 000h,02Fh,003h,020h,00Ah,000h,00Bh,000h

		;033
        .he 021,00A,005 ; DB 021h,00Ah,004h
        .he 000,02F,003,020,00A,000,00B,000 ; DB 000h,02Fh,003h,020h,00Ah,000h,00Bh,000h

;        DB 022h,012h,005h
;        DB 000h,030h,001h,023h,002h,019h,008h,000h,00Bh,000h,0FFh,019h,001h,006h,0E8h,002h

		;034
        .he 022,012,003 ; DB 022h,012h,005h
        .he 000,030,001,023,002,019,008,000,00B,000,0FF,019,001,006,0E8,002 ; DB 000h,030h,001h,023h,002h,019h,008h,000h,00Bh,000h,0FFh,019h,001h,006h,0E8h,002h

;        DB 023h,00Ch,006h
;        DB 001h,024h,002h,01Ah,003h,022h,00Ah,000h,009h,000h

		;035
        .he 023,00C,007 ; DB 023h,00Ch,006h
        .he 001,024,002,01A,003,022,00A,000,009,000 ; DB 001h,024h,002h,01Ah,003h,022h,00Ah,000h,009h,000h

;        DB 024h,00Eh,007h
;        DB 002h,01Bh,003h,023h,00Ah,000h,009h,000h,0FFh,029h,00Bh,00Ch

		;036
        .he 024,00E,001 ; DB 024h,00Eh,007h
        .he 002,01B,003,023,00A,000,009,000,0FF,029,00B,00C ; DB 002h,01Bh,003h,023h,00Ah,000h,009h,000h,0FFh,029h,00Bh,00Ch

;        DB 025h,01Ch,002h
;        DB 004h,035h,00Ch,000h,00Fh,000h,0FFh,002h,000h,040h,080h,0CAh,008h,010h,018h,0DAh
;        DB 001h,002h,003h,01Dh,009h,00Ah,00Bh,011h,012h,019h

		;037
        .he 025,01C,002 ; DB 025h,01Ch,002h
        .he 004,035,00C,000,00F,000,0FF,002,000,040,080,0CA,008,010,018,0DA ; DB 004h,035h,00Ch,000h,00Fh,000h,0FFh,002h,000h,040h,080h,0CAh,008h,010h,018h,0DAh
        .he 001,002,003,01D,009,00A,00B,011,012,019 ; DB 001h,002h,003h,01Dh,009h,00Ah,00Bh,011h,012h,019h

;        DB 026h,01Ch,003h
;        DB 004h,036h,005h,027h,00Ch,000h,00Fh,000h,0FFh,004h,07Ah,073h,074h,075h,0BEh,01Fh
;        DB 03Dh,03Eh,036h,02Eh,0BAh,0B3h,0B4h,0B5h,080h,07Fh

		;038
        .he 026,01C,004 ; DB 026h,01Ch,003h
        .he 004,036,005,027,00C,000,00F,000,0FF,004,07A,073,074,075,0BE,01F ; DB 004h,036h,005h,027h,00Ch,000h,00Fh,000h,0FFh,004h,07Ah,073h,074h,075h,0BEh,01Fh
        .he 03D,03E,036,02E,0BA,0B3,0B4,0B5,080,07F ; DB 03Dh,03Eh,036h,02Eh,0BAh,0B3h,0B4h,0B5h,080h,07Fh

;        DB 027h,00Ah,004h
;        DB 004h,037h,007h,026h,00Eh,000h,00Fh,000h

		;039
        .he 027,00A,005 ; DB 027h,00Ah,004h
        .he 004,037,007,026,00E,000,00F,000 ; DB 004h,037h,007h,026h,00Eh,000h,00Fh,000h

;        DB 028h,008h,00Dh
;        DB 004h,038h,002h,01Ch,010h,000h

		;040
        .he 028,008,00b ; DB 028h,008h,00Dh
        .he 004,038,002,01C,010,000 ; DB 004h,038h,002h,01Ch,010h,000h

;        DB 029h,01Eh,003h
;        DB 004h,039h,01Bh,08Ch,01Fh,000h,00Ch,000h,00Fh,000h,0FFh,006h,0D0h,0C8h,012h,052h
;        DB 02Ah,06Ah,0AAh,038h,025h,070h,092h,01Bh,01Ah,013h,00Ah,011h

		;041
        .he 029,01E,004 ; DB 029h,01Eh,003h
        .he 004,039,01B,08C,01F,000,00C,000,00F,000,0FF,006,0D0,0C8,012,052 ; DB 004h,039h,01Bh,08Ch,01Fh,000h,00Ch,000h,00Fh,000h,0FFh,006h,0D0h,0C8h,012h,052h
        .he 02A,06A,0AA,038,025,070,092,01B,01A,013,00A,011 ; DB 02Ah,06Ah,0AAh,038h,025h,070h,092h,01Bh,01Ah,013h,00Ah,011h

;        DB 02Ah,019h,007h
;        DB 004h,03Ah,00Ch,000h,00Fh,000h,0FFh,007h,01Ah,05Ah,09Ah,0DAh,01Ch,05Ch,09Ch,0DCh
;        DB 000h,0DBh,059h,01Bh,05Bh,078h,09Bh

		;042
        .he 02A,019,001 ; DB 02Ah,019h,007h
        .he 004,03A,00C,000,00F,000,0FF,007,01A,05A,09A,0DA,01C,05C,09C,0DC ; DB 004h,03Ah,00Ch,000h,00Fh,000h,0FFh,007h,01Ah,05Ah,09Ah,0DAh,01Ch,05Ch,09Ch,0DCh
        .he 000,0DB,059,01B,05B,078,09B ; DB 000h,0DBh,059h,01Bh,05Bh,078h,09Bh

;        DB 02Bh,00Ah,002h
;        DB 004h,03Bh,005h,02Ch,00Ch,000h,00Fh,000h

		;043
        .he 02B,00A,002 ; DB 02Bh,00Ah,002h
        .he 004,03B,005,02C,00C,000,00F,000 ; DB 004h,03Bh,005h,02Ch,00Ch,000h,00Fh,000h

;        DB 02Ch,01Dh,003h
;        DB 004h,03Ch,007h,02Bh,00Eh,000h,00Fh,000h,0FFh,00Fh,038h,031h,02Ah,023h,01Ch,015h
;        DB 00Eh,007h,01Fh,078h,071h,06Ah,063h,05Ch,055h,04Eh,047h

		;044
        .he 02C,01D,004 ; DB 02Ch,01Dh,003h
        .he 004,03C,007,02B,00E,000,00F,000,0FF,00F,038,031,02A,023,01C,015 ; DB 004h,03Ch,007h,02Bh,00Eh,000h,00Fh,000h,0FFh,00Fh,038h,031h,02Ah,023h,01Ch,015h
        .he 00E,007,01F,078,071,06A,063,05C,055,04E,047 ; DB 00Eh,007h,01Fh,078h,071h,06Ah,063h,05Ch,055h,04Eh,047h

;        DB 02Dh,00Ah,004h
;        DB 000h,03Dh,001h,02Eh,008h,000h,00Bh,000h

		;045
        .he 02D,00A,005 ; DB 02Dh,00Ah,004h
        .he 000,03D,001,02E,008,000,00B,000 ; DB 000h,03Dh,001h,02Eh,008h,000h,00Bh,000h

;        DB 02Eh,01Eh,005h
;        DB 002h,020h,003h,02Dh,00Ah,000h,009h,000h,0FFh,00Eh,028h,029h,022h,01Ah,011h,010h
;        DB 019h,080h,0A4h,088h,005h,02Dh,068h,069h,062h,05Ah,051h,050h

		;046
        .he 02E,01E,003 ; DB 02Eh,01Eh,005h
        .he 002,020,003,02D,00A,000,009,000,0FF,00E,028,029,022,01A,011,010 ; DB 002h,020h,003h,02Dh,00Ah,000h,009h,000h,0FFh,00Eh,028h,029h,022h,01Ah,011h,010h
        .he 019,080,0A4,088,005,02D,068,069,062,05A,051,050 ; DB 019h,080h,0A4h,088h,005h,02Dh,068h,069h,062h,05Ah,051h,050h

;        DB 02Fh,015h,00Eh
;        DB 000h,03Eh,002h,021h,010h,000h,0FFh,01Bh,022h,023h,024h,025h,0C3h,062h,063h,064h
;        DB 065h,0E8h,0A2h

		;047
        .he 02F,015,00f ; DB 02Fh,015h,00Eh
        .he 000,03E,002,021,010,000,0FF,01B,022,023,024,025,0C3,062,063,064 ; DB 000h,03Eh,002h,021h,010h,000h,0FFh,01Bh,022h,023h,024h,025h,0C3h,062h,063h,064h
        .he 065,0E8,0A2 ; DB 065h,0E8h,0A2h

;        DB 030h,00Ah,007h
;        DB 001h,031h,002h,022h,008h,000h,009h,000h

		;048
        .he 030,00A,001 ; DB 030h,00Ah,007h
        .he 001,031,002,022,008,000,009,000 ; DB 001h,031h,002h,022h,008h,000h,009h,000h

;        DB 031h,00Ch,012h
;        DB 001h,032h,003h,030h,011h,000h,0FFh,0F1h,014h,02Ch

		;049
        .he 031,00C,012 ; DB 031h,00Ch,012h
        .he 001,032,003,030,011,000,0FF,0F1,014,02C ; DB 001h,032h,003h,030h,011h,000h,0FFh,0F1h,014h,02Ch

;        DB 032h,008h,013h
;        DB 001h,033h,003h,031h,011h,000h

		;050
        .he 032,008,014 ; DB 032h,008h,013h
        .he 001,033,003,031,011,000 ; DB 001h,033h,003h,031h,011h,000h

;        DB 033h,022h,004h
;        DB 000h,03Fh,001h,034h,003h,032h,00Ah,000h,00Bh,000h,0FFh,01Fh,010h,011h,012h,013h
;        DB 014h,015h,016h,017h,01Fh,028h,029h,02Ah,032h,03Ah,03Dh,035h,02Dh,019h,02Eh,02Fh

		;051
        .he 033,022,005 ; DB 033h,022h,004h
        .he 000,03F,001,034,003,032,00A,000,00B,000,0FF,01F,010,011,012,013 ; DB 000h,03Fh,001h,034h,003h,032h,00Ah,000h,00Bh,000h,0FFh,01Fh,010h,011h,012h,013h
        .he 014,015,016,017,01F,028,029,02A,032,03A,03D,035,02D,019,02E,02F ; DB 014h,015h,016h,017h,01Fh,028h,029h,02Ah,032h,03Ah,03Dh,035h,02Dh,019h,02Eh,02Fh

;        DB 034h,010h,015h
;        DB 005h,035h,003h,033h,011h,000h,0FFh,02Bh,012h,01Ah,02Dh,025h,0A0h,013h

		;052
        .he 034,010,013 ; DB 034h,010h,015h
        .he 005,035,003,033,011,000,0FF,02B,012,01A,02D,025,0A0,013 ; DB 005h,035h,003h,033h,011h,000h,0FFh,02Bh,012h,01Ah,02Dh,025h,0A0h,013h

;        DB 035h,023h,006h
;        DB 004h,040h,005h,036h,006h,025h,007h,034h,00Eh,000h,00Fh,000h,0FFh,01Fh,038h,031h
;        DB 02Ah,023h,01Ch,015h,00Eh,007h,01Fh,000h,009h,012h,01Bh,024h,02Dh,036h,03Fh,090h
;        DB 05Ch

		;053
        .he 035,023,007 ; DB 035h,023h,006h
        .he 004,040,005,036,006,025,007,034,00E,000,00F,000,0FF,01F,038,031 ; DB 004h,040h,005h,036h,006h,025h,007h,034h,00Eh,000h,00Fh,000h,0FFh,01Fh,038h,031h
        .he 02A,023,01C,015,00E,007,01F,000,009,012,01B,024,02D,036,03F,090 ; DB 02Ah,023h,01Ch,015h,00Eh,007h,01Fh,000h,009h,012h,01Bh,024h,02Dh,036h,03Fh,090h
        .he 05C ; DB 05Ch

;        DB 036h,01Dh,007h
;        DB 018h,041h,006h,026h,007h,035h,00Eh,000h,00Dh,000h,01Ch,000h,0FFh,001h,0FDh,0FEh
;        DB 060h,01Dh,0C1h,05Dh,0F5h,01Ch,025h,01Eh,015h,01Ch,035h

		;054
        .he 036,01D,001 ; DB 036h,01Dh,007h
        .he 018,041,006,026,007,035,00E,000,00D,000,01C,000,0FF,001,0FD,0FE ; DB 018h,041h,006h,026h,007h,035h,00Eh,000h,00Dh,000h,01Ch,000h,0FFh,001h,0FDh,0FEh
        .he 060,01D,0C1,05D,0F5,01C,025,01E,015,01C,035 ; DB 060h,01Dh,0C1h,05Dh,0F5h,01Ch,025h,01Eh,015h,01Ch,035h

;        DB 037h,01Fh,002h
;        DB 006h,027h,019h,08Fh,01Dh,000h,00Ch,000h,00Dh,000h,0FFh,003h,029h,0AAh,0F7h,0EFh
;        DB 01Dh,02Ch,02Dh,02Eh,02Fh,02Ah,02Bh,0C0h,0ABh,058h,0EBh,078h,06Ch

		;055
        .he 037,01F,002 ; DB 037h,01Fh,002h
        .he 006,027,019,08F,01D,000,00C,000,00D,000,0FF,003,029,0AA,0F7,0EF ; DB 006h,027h,019h,08Fh,01Dh,000h,00Ch,000h,00Dh,000h,0FFh,003h,029h,0AAh,0F7h,0EFh
        .he 01D,02C,02D,02E,02F,02A,02B,0C0,0AB,058,0EB,078,06C ; DB 01Dh,02Ch,02Dh,02Eh,02Fh,02Ah,02Bh,0C0h,0ABh,058h,0EBh,078h,06Ch

;        DB 038h,017h,006h
;        DB 019h,039h,006h,028h,00Ch,000h,00Dh,000h,01Dh,000h,0FFh,002h,0F7h,0EFh,028h,080h
;        DB 030h,058h,068h,018h,037h

		;056
        .he 038,017,007 ; DB 038h,017h,006h
        .he 019,039,006,028,00C,000,00D,000,01D,000,0FF,002,0F7,0EF,028,080 ; DB 019h,039h,006h,028h,00Ch,000h,00Dh,000h,01Dh,000h,0FFh,002h,0F7h,0EFh,028h,080h
        .he 030,058,068,018,037 ; DB 030h,058h,068h,018h,037h

;        DB 039h,00Ch,004h
;        DB 005h,03Ah,006h,029h,007h,038h,00Eh,000h,00Dh,000h

		;057
        .he 039,00C,005 ; DB 039h,00Ch,004h
        .he 005,03A,006,029,007,038,00E,000,00D,000 ; DB 005h,03Ah,006h,029h,007h,038h,00Eh,000h,00Dh,000h

;        DB 03Ah,00Ch,005h
;        DB 005h,03Bh,006h,02Ah,007h,039h,00Eh,000h,00Dh,000h

		;058
        .he 03A,00C,003 ; DB 03Ah,00Ch,005h
        .he 005,03B,006,02A,007,039,00E,000,00D,000 ; DB 005h,03Bh,006h,02Ah,007h,039h,00Eh,000h,00Dh,000h

;        DB 03Bh,023h,006h
;        DB 018h,042h,005h,03Ch,006h,02Bh,01Bh,03Ah,00Ch,000h,00Dh,000h,01Fh,000h,01Ch,000h
;        DB 0FFh,005h,0FDh,0FEh,0D0h,0C8h,00Eh,04Eh,080h,0C9h,088h,0F6h,01Bh,016h,00Fh,006h
;        DB 00Dh

		;059
        .he 03B,023,007 ; DB 03Bh,023h,006h
        .he 018,042,005,03C,006,02B,01B,03A,00C,000,00D,000,01F,000,01C,000 ; DB 018h,042h,005h,03Ch,006h,02Bh,01Bh,03Ah,00Ch,000h,00Dh,000h,01Fh,000h,01Ch,000h
        .he 0FF,005,0FD,0FE,0D0,0C8,00E,04E,080,0C9,088,0F6,01B,016,00F,006 ; DB 0FFh,005h,0FDh,0FEh,0D0h,0C8h,00Eh,04Eh,080h,0C9h,088h,0F6h,01Bh,016h,00Fh,006h
        .he 00D ; DB 00Dh

;        DB 03Ch,00Ah,007h
;        DB 006h,02Ch,007h,03Bh,00Eh,000h,00Dh,000h

		;060
        .he 03C,00A,001 ; DB 03Ch,00Ah,007h
        .he 006,02C,007,03B,00E,000,00D,000 ; DB 006h,02Ch,007h,03Bh,00Eh,000h,00Dh,000h

;        DB 03Dh,012h,00Ah
;        DB 000h,043h,002h,02Dh,010h,000h,0FFh,02Fh,02Ah,02Bh,02Ch,02Dh,012h,013h,014h,015h

		;061
        .he 03D,012,00a ; DB 03Dh,012h,00Ah
        .he 000,043,002,02D,010,000,0FF,02F,02A,02B,02C,02D,012,013,014,015 ; DB 000h,043h,002h,02Dh,010h,000h,0FFh,02Fh,02Ah,02Bh,02Ch,02Dh,012h,013h,014h,015h

;        DB 03Eh,01Ah,003h
;        DB 002h,02Fh,008h,000h,009h,000h,0FFh,02Dh,03Ah,033h,02Bh,02Dh,035h,03Dh,002h,0BBh
;        DB 0B4h,0ACh,079h,024h,03Ch,0C1h,064h,07Ch

		;062
        .he 03E,01A,004 ; DB 03Eh,01Ah,003h
        .he 002,02F,008,000,009,000,0FF,02D,03A,033,02B,02D,035,03D,002,0BB ; DB 002h,02Fh,008h,000h,009h,000h,0FFh,02Dh,03Ah,033h,02Bh,02Dh,035h,03Dh,002h,0BBh
        .he 0B4,0AC,079,024,03C,0C1,064,07C ; DB 0B4h,0ACh,079h,024h,03Ch,0C1h,064h,07Ch

;        DB 03Fh,00Eh,00Ch
;        DB 000h,045h,002h,033h,010h,000h,0FFh,0ABh,00Dh,013h,032h,02Ch

		;063
        .he 03F,00E,00d ; DB 03Fh,00Eh,00Ch
        .he 000,045,002,033,010,000,0FF,0AB,00D,013,032,02C ; DB 000h,045h,002h,033h,010h,000h,0FFh,0ABh,00Dh,013h,032h,02Ch

;        DB 040h,017h,00Dh
;        DB 000h,047h,006h,035h,010h,000h,0FFh,02Fh,01Ah,01Bh,01Ch,01Dh,022h,023h,024h,025h
;        DB 0C3h,00Dh,09Dh,0A5h,035h

		;064
        .he 040,017,00b ; DB 040h,017h,00Dh
        .he 000,047,006,035,010,000,0FF,02F,01A,01B,01C,01D,022,023,024,025 ; DB 000h,047h,006h,035h,010h,000h,0FFh,02Fh,01Ah,01Bh,01Ch,01Dh,022h,023h,024h,025h
        .he 0C3,00D,09D,0A5,035 ; DB 0C3h,00Dh,09Dh,0A5h,035h

;        DB 041h,008h,00Eh
;        DB 004h,048h,006h,036h,014h,000h

		;065
        .he 041,008,00f ; DB 041h,008h,00Eh
        .he 004,048,006,036,014,000 ; DB 004h,048h,006h,036h,014h,000h

;        DB 042h,008h,00Ah
;        DB 004h,049h,006h,03Bh,014h,000h

		;066
        .he 042,008,00a ; DB 042h,008h,00Ah
        .he 004,049,006,03B,014,000 ; DB 004h,049h,006h,03Bh,014h,000h

;        DB 043h,013h,00Bh
;        DB 000h,04Ch,002h,03Dh,010h,000h,0FFh,0DBh,01Ah,01Bh,01Ch,01Dh,01Bh,062h,063h,064h
;        DB 065h

		;067
        .he 043,013,00c ; DB 043h,013h,00Bh
        .he 000,04C,002,03D,010,000,0FF,0DB,01A,01B,01C,01D,01B,062,063,064 ; DB 000h,04Ch,002h,03Dh,010h,000h,0FFh,0DBh,01Ah,01Bh,01Ch,01Dh,01Bh,062h,063h,064h
        .he 065 ; DB 065h

;        DB 045h,021h,005h
;        DB 002h,03Fh,008h,000h,009h,000h,0FFh,059h,0FEh,037h,080h,0FAh,0C0h,0E1h,028h,039h
;        DB 090h,025h,005h,03Eh,051h,07Eh,0B7h,0BEh,0F7h,004h,011h,036h,076h,0B6h,0F6h

		;069
        .he 045,021,003 ; DB 045h,021h,005h
        .he 002,03F,008,000,009,000,0FF,059,0FE,037,080,0FA,0C0,0E1,028,039 ; DB 002h,03Fh,008h,000h,009h,000h,0FFh,059h,0FEh,037h,080h,0FAh,0C0h,0E1h,028h,039h
        .he 090,025,005,03E,051,07E,0B7,0BE,0F7,004,011,036,076,0B6,0F6 ; DB 090h,025h,005h,03Eh,051h,07Eh,0B7h,0BEh,0F7h,004h,011h,036h,076h,0B6h,0F6h

;        DB 046h,01Dh,006h
;        DB 001h,047h,008h,000h,009h,000h,0FFh,00Fh,02Bh,02Ch,022h,01Ah,013h,014h,01Dh,025h
;        DB 02Fh,06Bh,06Ch,062h,05Ah,053h,054h,05Dh,065h,020h,00Eh

		;070
        .he 046,01D,007 ; DB 046h,01Dh,006h
        .he 001,047,008,000,009,000,0FF,00F,02B,02C,022,01A,013,014,01D,025 ; DB 001h,047h,008h,000h,009h,000h,0FFh,00Fh,02Bh,02Ch,022h,01Ah,013h,014h,01Dh,025h
        .he 02F,06B,06C,062,05A,053,054,05D,065,020,00E ; DB 02Fh,06Bh,06Ch,062h,05Ah,053h,054h,05Dh,065h,020h,00Eh

;        DB 047h,01Fh,007h
;        DB 005h,048h,002h,040h,003h,046h,00Ah,000h,009h,000h,0FFh,098h,033h,021h,015h,055h
;        DB 01Fh,039h,031h,029h,021h,022h,023h,024h,025h,01Ah,02Dh,035h,03Dh

		;071
        .he 047,01F,001 ; DB 047h,01Fh,007h
        .he 005,048,002,040,003,046,00A,000,009,000,0FF,098,033,021,015,055 ; DB 005h,048h,002h,040h,003h,046h,00Ah,000h,009h,000h,0FFh,098h,033h,021h,015h,055h
        .he 01F,039,031,029,021,022,023,024,025,01A,02D,035,03D ; DB 01Fh,039h,031h,029h,021h,022h,023h,024h,025h,01Ah,02Dh,035h,03Dh

;        DB 048h,012h,002h
;        DB 004h,050h,01Ah,041h,007h,047h,00Eh,000h,00Fh,000h,01Eh,000h,0FFh,001h,0C1h,0C2h

		;072
        .he 048,012,002 ; DB 048h,012h,002h
        .he 004,050,01A,041,007,047,00E,000,00F,000,01E,000,0FF,001,0C1,0C2 ; DB 004h,050h,01Ah,041h,007h,047h,00Eh,000h,00Fh,000h,01Eh,000h,0FFh,001h,0C1h,0C2h

;        DB 049h,019h,003h
;        DB 018h,053h,005h,04Ah,006h,042h,01Ch,000h,00Ch,000h,00Dh,000h,0FFh,038h,022h,009h
;        DB 015h,055h,020h,095h,001h,0FDh,0FEh

		;073
        .he 049,019,004 ; DB 049h,019h,003h
        .he 018,053,005,04A,006,042,01C,000,00C,000,00D,000,0FF,038,022,009 ; DB 018h,053h,005h,04Ah,006h,042h,01Ch,000h,00Ch,000h,00Dh,000h,0FFh,038h,022h,009h
        .he 015,055,020,095,001,0FD,0FE ; DB 015h,055h,020h,095h,001h,0FDh,0FEh

;        DB 04Ah,01Ah,004h
;        DB 001h,04Bh,01Bh,049h,00Ch,000h,009h,000h,01Fh,000h,0FFh,009h,014h,054h,021h,094h
;        DB 0D4h,001h,0D0h,0C8h,02Ah,01Ch,013h,00Ch

		;074
        .he 04A,01A,005 ; DB 04Ah,01Ah,004h
        .he 001,04B,01B,049,00C,000,009,000,01F,000,0FF,009,014,054,021,094 ; DB 001h,04Bh,01Bh,049h,00Ch,000h,009h,000h,01Fh,000h,0FFh,009h,014h,054h,021h,094h
        .he 0D4,001,0D0,0C8,02A,01C,013,00C ; DB 0D4h,001h,0D0h,0C8h,02Ah,01Ch,013h,00Ch

;        DB 04Bh,00Ah,005h
;        DB 000h,054h,003h,04Ah,00Ah,000h,00Bh,000h

		;075
        .he 04B,00A,003 ; DB 04Bh,00Ah,005h
        .he 000,054,003,04A,00A,000,00B,000 ; DB 000h,054h,003h,04Ah,00Ah,000h,00Bh,000h

;        DB 04Ch,016h,006h
;        DB 000h,056h,001h,04Dh,002h,043h,008h,000h,00Bh,000h,0FFh,075h,002h,005h,017h,02Fh
;        DB 03Dh,03Ah,0A0h,007h

		;076
        .he 04C,016,007 ; DB 04Ch,016h,006h
        .he 000,056,001,04D,002,043,008,000,00B,000,0FF,075,002,005,017,02F ; DB 000h,056h,001h,04Dh,002h,043h,008h,000h,00Bh,000h,0FFh,075h,002h,005h,017h,02Fh
        .he 03D,03A,0A0,007 ; DB 03Dh,03Ah,0A0h,007h

;        DB 04Dh,012h,007h
;        DB 004h,057h,001h,04Eh,003h,04Ch,00Ah,000h,00Fh,000h,0FFh,0ABh,024h,02Ah,01Ah,014h

		;077
        .he 04D,012,001 ; DB 04Dh,012h,007h
        .he 004,057,001,04E,003,04C,00A,000,00F,000,0FF,0AB,024,02A,01A,014 ; DB 004h,057h,001h,04Eh,003h,04Ch,00Ah,000h,00Fh,000h,0FFh,0ABh,024h,02Ah,01Ah,014h

;        DB 04Eh,018h,002h
;        DB 003h,04Dh,00Ah,000h,00Dh,000h,0FFh,0ADh,02Bh,024h,01Dh,019h,014h,01Bh,06Eh,02Dh
;        DB 022h,026h,012h,016h,00Bh,00Dh

		;078
        .he 04E,018,002 ; DB 04Eh,018h,002h
        .he 003,04D,00A,000,00D,000,0FF,0AD,02B,024,01D,019,014,01B,06E,02D ; DB 003h,04Dh,00Ah,000h,00Dh,000h,0FFh,0ADh,02Bh,024h,01Dh,019h,014h,01Bh,06Eh,02Dh
        .he 022,026,012,016,00B,00D ; DB 022h,026h,012h,016h,00Bh,00Dh

;        DB 050h,027h,004h
;        DB 004h,05Dh,019h,051h,01Ah,048h,00Ch,000h,00Fh,000h,01Dh,000h,01Eh,000h,0FFh,007h
;        DB 0C1h,0C2h,0EFh,0F7h,01Bh,05Bh,09Bh,0DBh,0C4h,044h,025h,065h,0A5h,0E5h,050h,0EDh
;        DB 01Bh,004h,01Ah,01Dh,02Fh

		;080
        .he 050,027,005 ; DB 050h,027h,004h
        .he 004,05D,019,051,01A,048,00C,000,00F,000,01D,000,01E,000,0FF,007 ; DB 004h,05Dh,019h,051h,01Ah,048h,00Ch,000h,00Fh,000h,01Dh,000h,01Eh,000h,0FFh,007h
        .he 0C1,0C2,0EF,0F7,01B,05B,09B,0DB,0C4,044,025,065,0A5,0E5,050,0ED ; DB 0C1h,0C2h,0EFh,0F7h,01Bh,05Bh,09Bh,0DBh,0C4h,044h,025h,065h,0A5h,0E5h,050h,0EDh
        .he 01B,004,01A,01D,02F ; DB 01Bh,004h,01Ah,01Dh,02Fh

;        DB 051h,00Ah,005h
;        DB 004h,05Eh,007h,050h,00Eh,000h,00Fh,000h

		;081
        .he 051,00A,003 ; DB 051h,00Ah,005h
        .he 004,05E,007,050,00E,000,00F,000 ; DB 004h,05Eh,007h,050h,00Eh,000h,00Fh,000h

;        DB 052h,008h,006h
;        DB 004h,061h,00Ch,000h,00Fh,000h

		;082
        .he 052,008,007 ; DB 052h,008h,006h
        .he 004,061,00C,000,00F,000 ; DB 004h,061h,00Ch,000h,00Fh,000h

;        DB 053h,014h,00Fh
;        DB 004h,062h,006h,049h,014h,000h,0FFh,01Fh,02Ah,02Bh,02Ch,02Dh,012h,013h,014h,015h
;        DB 0E8h,06Ah

		;083
        .he 053,014,009 ; DB 053h,014h,00Fh
        .he 004,062,006,049,014,000,0FF,01F,02A,02B,02C,02D,012,013,014,015 ; DB 004h,062h,006h,049h,014h,000h,0FFh,01Fh,02Ah,02Bh,02Ch,02Dh,012h,013h,014h,015h
        .he 0E8,06A ; DB 0E8h,06Ah

;        DB 054h,01Fh,002h
;        DB 000h,063h,001h,055h,002h,04Bh,008h,000h,00Bh,000h,0FFh,02Fh,002h,00Ah,012h,01Ah
;        DB 022h,02Ah,032h,03Ah,02Fh,005h,00Dh,015h,01Dh,025h,02Dh,035h,03Dh

		;084
        .he 054,01F,002 ; DB 054h,01Fh,002h
        .he 000,063,001,055,002,04B,008,000,00B,000,0FF,02F,002,00A,012,01A ; DB 000h,063h,001h,055h,002h,04Bh,008h,000h,00Bh,000h,0FFh,02Fh,002h,00Ah,012h,01Ah
        .he 022,02A,032,03A,02F,005,00D,015,01D,025,02D,035,03D ; DB 022h,02Ah,032h,03Ah,02Fh,005h,00Dh,015h,01Dh,025h,02Dh,035h,03Dh

;        DB 055h,00Ah,003h
;        DB 001h,056h,003h,054h,00Ah,000h,009h,000h

		;085
        .he 055,00A,004 ; DB 055h,00Ah,003h
        .he 001,056,003,054,00A,000,009,000 ; DB 001h,056h,003h,054h,00Ah,000h,009h,000h

;        DB 056h,022h,004h
;        DB 002h,04Ch,003h,055h,019h,091h,01Dh,000h,00Ah,000h,009h,000h,0FFh,001h,0F7h,0EFh
;        DB 02Ch,00Dh,014h,016h,01Dh,025h,050h,095h,041h,012h,02Dh,043h,052h,06Dh,0ADh,0EDh

		;086
        .he 056,022,005 ; DB 056h,022h,004h
        .he 002,04C,003,055,019,091,01D,000,00A,000,009,000,0FF,001,0F7,0EF ; DB 002h,04Ch,003h,055h,019h,091h,01Dh,000h,00Ah,000h,009h,000h,0FFh,001h,0F7h,0EFh
        .he 02C,00D,014,016,01D,025,050,095,041,012,02D,043,052,06D,0AD,0ED ; DB 02Ch,00Dh,014h,016h,01Dh,025h,050h,095h,041h,012h,02Dh,043h,052h,06Dh,0ADh,0EDh

;        DB 057h,026h,005h
;        DB 019h,058h,01Ah,04Dh,00Ch,000h,00Dh,000h,01Dh,000h,01Eh,000h,0FFh,007h,0C1h,0C2h
;        DB 0C3h,0C4h,0F7h,0EFh,0E7h,0DFh,0C4h,0CCh,0D4h,0DCh,0DDh,0DEh,01Ch,00Ch,014h,01Ch
;        DB 01Dh,01Eh,060h,011h

		;087
        .he 057,026,003 ; DB 057h,026h,005h
        .he 019,058,01A,04D,00C,000,00D,000,01D,000,01E,000,0FF,007,0C1,0C2 ; DB 019h,058h,01Ah,04Dh,00Ch,000h,00Dh,000h,01Dh,000h,01Eh,000h,0FFh,007h,0C1h,0C2h
        .he 0C3,0C4,0F7,0EF,0E7,0DF,0C4,0CC,0D4,0DC,0DD,0DE,01C,00C,014,01C ; DB 0C3h,0C4h,0F7h,0EFh,0E7h,0DFh,0C4h,0CCh,0D4h,0DCh,0DDh,0DEh,01Ch,00Ch,014h,01Ch
        .he 01D,01E,060,011 ; DB 01Dh,01Eh,060h,011h

;        DB 058h,00Eh,006h
;        DB 004h,067h,007h,057h,00Eh,000h,00Fh,000h,0FFh,079h,0FBh,0FCh

		;088
        .he 058,00E,007 ; DB 058h,00Eh,006h
        .he 004,067,007,057,00E,000,00F,000,0FF,079,0FB,0FC ; DB 004h,067h,007h,057h,00Eh,000h,00Fh,000h,0FFh,079h,0FBh,0FCh

;        DB 05Bh,00Eh,003h
;        DB 000h,06Ah,001h,05Ch,008h,000h,00Bh,000h,0FFh,049h,0DFh,0E7h

		;091
        .he 05B,00E,004 ; DB 05Bh,00Eh,003h
        .he 000,06A,001,05C,008,000,00B,000,0FF,049,0DF,0E7 ; DB 000h,06Ah,001h,05Ch,008h,000h,00Bh,000h,0FFh,049h,0DFh,0E7h

;        DB 05Ch,022h,004h
;        DB 000h,06Bh,005h,05Dh,003h,05Bh,00Ah,000h,00Bh,000h,0FFh,01Fh,010h,011h,012h,013h
;        DB 014h,015h,016h,017h,01Fh,028h,029h,02Ah,032h,03Ah,03Dh,035h,02Dh,019h,02Eh,02Fh

		;092
        .he 05C,022,005 ; DB 05Ch,022h,004h
        .he 000,06B,005,05D,003,05B,00A,000,00B,000,0FF,01F,010,011,012,013 ; DB 000h,06Bh,005h,05Dh,003h,05Bh,00Ah,000h,00Bh,000h,0FFh,01Fh,010h,011h,012h,013h
        .he 014,015,016,017,01F,028,029,02A,032,03A,03D,035,02D,019,02E,02F ; DB 014h,015h,016h,017h,01Fh,028h,029h,02Ah,032h,03Ah,03Dh,035h,02Dh,019h,02Eh,02Fh

;        DB 05Dh,021h,005h
;        DB 006h,050h,01Bh,05Ch,00Ch,000h,00Dh,000h,01Fh,000h,0FFh,0C7h,0C8h,0D0h,07Eh,0FFh
;        DB 0F7h,0EFh,0E7h,0DFh,080h,0D7h,01Fh,03Fh,037h,02Fh,027h,01Fh,017h,010h,008h

		;093
        .he 05D,021,003 ; DB 05Dh,021h,005h
        .he 006,050,01B,05C,00C,000,00D,000,01F,000,0FF,0C7,0C8,0D0,07E,0FF ; DB 006h,050h,01Bh,05Ch,00Ch,000h,00Dh,000h,01Fh,000h,0FFh,0C7h,0C8h,0D0h,07Eh,0FFh
        .he 0F7,0EF,0E7,0DF,080,0D7,01F,03F,037,02F,027,01F,017,010,008 ; DB 0F7h,0EFh,0E7h,0DFh,080h,0D7h,01Fh,03Fh,037h,02Fh,027h,01Fh,017h,010h,008h

;        DB 05Eh,01Fh,006h
;        DB 019h,05Fh,006h,051h,00Ch,000h,00Dh,000h,01Dh,000h,0FFh,001h,0F7h,0EFh,01Fh,019h
;        DB 01Ah,01Ch,01Dh,00Bh,013h,023h,02Bh,060h,01Bh,088h,0EEh,0C0h,059h

		;094
        .he 05E,01F,007 ; DB 05Eh,01Fh,006h
        .he 019,05F,006,051,00C,000,00D,000,01D,000,0FF,001,0F7,0EF,01F,019 ; DB 019h,05Fh,006h,051h,00Ch,000h,00Dh,000h,01Dh,000h,0FFh,001h,0F7h,0EFh,01Fh,019h
        .he 01A,01C,01D,00B,013,023,02B,060,01B,088,0EE,0C0,059 ; DB 01Ah,01Ch,01Dh,00Bh,013h,023h,02Bh,060h,01Bh,088h,0EEh,0C0h,059h

;        DB 05Fh,00Ah,007h
;        DB 005h,060h,007h,05Eh,00Eh,000h,00Dh,000h

		;095
        .he 05F,00A,001 ; DB 05Fh,00Ah,007h
        .he 005,060,007,05E,00E,000,00D,000 ; DB 005h,060h,007h,05Eh,00Eh,000h,00Dh,000h

;        DB 060h,018h,002h
;        DB 004h,06Ch,005h,061h,007h,05Fh,00Eh,000h,00Fh,000h,0FFh,01Fh,028h,029h,02Ah,02Bh
;        DB 02Ch,02Dh,02Eh,02Fh,0A0h,030h

		;096
        .he 060,018,002 ; DB 060h,018h,002h
        .he 004,06C,005,061,007,05F,00E,000,00F,000,0FF,01F,028,029,02A,02B ; DB 004h,06Ch,005h,061h,007h,05Fh,00Eh,000h,00Fh,000h,0FFh,01Fh,028h,029h,02Ah,02Bh
        .he 02C,02D,02E,02F,0A0,030 ; DB 02Ch,02Dh,02Eh,02Fh,0A0h,030h

;        DB 061h,00Eh,003h
;        DB 004h,06Dh,005h,062h,006h,052h,007h,060h,00Eh,000h,00Fh,000h

		;097
        .he 061,00E,004 ; DB 061h,00Eh,003h
        .he 004,06D,005,062,006,052,007,060,00E,000,00F,000 ; DB 004h,06Dh,005h,062h,006h,052h,007h,060h,00Eh,000h,00Fh,000h

;        DB 062h,012h,004h
;        DB 006h,053h,007h,061h,00Eh,000h,00Dh,000h,0FFh,033h,014h,01Bh,01Dh,024h,090h,01Ch

		;098
        .he 062,012,005 ; DB 062h,012h,004h
        .he 006,053,007,061,00E,000,00D,000,0FF,033,014,01B,01D,024,090,01C ; DB 006h,053h,007h,061h,00Eh,000h,00Dh,000h,0FFh,033h,014h,01Bh,01Dh,024h,090h,01Ch

;        DB 063h,014h,005h
;        DB 001h,064h,002h,054h,008h,000h,009h,000h,0FFh,009h,001h,006h,0E8h,002h,0AAh,022h
;        DB 01Ch,02Dh

		;099
        .he 063,014,003 ; DB 063h,014h,005h
        .he 001,064,002,054,008,000,009,000,0FF,009,001,006,0E8,002,0AA,022 ; DB 001h,064h,002h,054h,008h,000h,009h,000h,0FFh,009h,001h,006h,0E8h,002h,0AAh,022h
        .he 01C,02D ; DB 01Ch,02Dh

;        DB 064h,022h,006h
;        DB 000h,06Eh,001h,065h,003h,063h,00Ah,000h,00Bh,000h,0FFh,01Fh,010h,011h,012h,013h
;        DB 014h,015h,016h,017h,01Fh,028h,029h,02Ah,032h,03Ah,03Dh,035h,02Dh,019h,02Eh,02Fh

		;100
        .he 064,022,007 ; DB 064h,022h,006h
        .he 000,06E,001,065,003,063,00A,000,00B,000,0FF,01F,010,011,012,013 ; DB 000h,06Eh,001h,065h,003h,063h,00Ah,000h,00Bh,000h,0FFh,01Fh,010h,011h,012h,013h
        .he 014,015,016,017,01F,028,029,02A,032,03A,03D,035,02D,019,02E,02F ; DB 014h,015h,016h,017h,01Fh,028h,029h,02Ah,032h,03Ah,03Dh,035h,02Dh,019h,02Eh,02Fh

;        DB 065h,014h,017h
;        DB 001h,066h,003h,064h,011h,000h,0FFh,02Fh,02Bh,02Ch,023h,024h,01Bh,01Ch,013h,014h
;        DB 080h,06Bh

		;101
        .he 065,014,011 ; DB 065h,014h,017h
        .he 001,066,003,064,011,000,0FF,02F,02B,02C,023,024,01B,01C,013,014 ; DB 001h,066h,003h,064h,011h,000h,0FFh,02Fh,02Bh,02Ch,023h,024h,01Bh,01Ch,013h,014h
        .he 080,06B ; DB 080h,06Bh

;        DB 066h,00Ch,002h
;        DB 000h,070h,001h,067h,003h,065h,00Ah,000h,00Bh,000h

		;102
        .he 066,00C,002 ; DB 066h,00Ch,002h
        .he 000,070,001,067,003,065,00A,000,00B,000 ; DB 000h,070h,001h,067h,003h,065h,00Ah,000h,00Bh,000h

;        DB 067h,012h,003h
;        DB 006h,058h,003h,066h,00Ah,000h,009h,000h,0FFh,071h,0C3h,0C4h,0AAh,012h,01Ch,02Bh

		;103
        .he 067,012,004 ; DB 067h,012h,003h
        .he 006,058,003,066,00A,000,009,000,0FF,071,0C3,0C4,0AA,012,01C,02B ; DB 006h,058h,003h,066h,00Ah,000h,009h,000h,0FFh,071h,0C3h,0C4h,0AAh,012h,01Ch,02Bh

;        DB 06Ah,00Fh,006h
;        DB 001h,06Bh,002h,05Bh,008h,000h,009h,000h,0FFh,090h,078h,0A0h,038h

		;106
        .he 06A,00F,007 ; DB 06Ah,00Fh,006h
        .he 001,06B,002,05B,008,000,009,000,0FF,090,078,0A0,038 ; DB 001h,06Bh,002h,05Bh,008h,000h,009h,000h,0FFh,090h,078h,0A0h,038h

;        DB 06Bh,021h,007h
;        DB 000h,075h,002h,05Ch,003h,06Ah,00Ah,000h,00Bh,000h,0FFh,023h,02Bh,02Ch,06Bh,06Ch
;        DB 079h,0ABh,0ACh,02Fh,038h,039h,031h,032h,02Ah,03Eh,03Fh,035h,029h,036h,02Dh

		;107
        .he 06B,021,001 ; DB 06Bh,021h,007h
        .he 000,075,002,05C,003,06A,00A,000,00B,000,0FF,023,02B,02C,06B,06C ; DB 000h,075h,002h,05Ch,003h,06Ah,00Ah,000h,00Bh,000h,0FFh,023h,02Bh,02Ch,06Bh,06Ch
        .he 079,0AB,0AC,02F,038,039,031,032,02A,03E,03F,035,029,036,02D ; DB 079h,0ABh,0ACh,02Fh,038h,039h,031h,032h,02Ah,03Eh,03Fh,035h,029h,036h,02Dh

;        DB 06Ch,01Bh,002h
;        DB 006h,060h,008h,000h,009h,000h,0FFh,0D8h,023h,0E0h,033h,002h,032h,034h,07Bh,019h
;        DB 072h,074h,078h,02Bh,02Ch,039h,03Ah,03Ch,03Dh

		;108
        .he 06C,01B,002 ; DB 06Ch,01Bh,002h
        .he 006,060,008,000,009,000,0FF,0D8,023,0E0,033,002,032,034,07B,019 ; DB 006h,060h,008h,000h,009h,000h,0FFh,0D8h,023h,0E0h,033h,002h,032h,034h,07Bh,019h
        .he 072,074,078,02B,02C,039,03A,03C,03D ; DB 072h,074h,078h,02Bh,02Ch,039h,03Ah,03Ch,03Dh

;        DB 06Dh,01Fh,003h
;        DB 000h,076h,006h,061h,008h,000h,00Bh,000h,0FFh,02Fh,006h,00Dh,014h,01Bh,023h,02Ch
;        DB 035h,03Eh,02Fh,002h,009h,010h,018h,020h,028h,031h,03Ah,090h,01Eh

		;109
        .he 06D,01F,004 ; DB 06Dh,01Fh,003h
        .he 000,076,006,061,008,000,00B,000,0FF,02F,006,00D,014,01B,023,02C ; DB 000h,076h,006h,061h,008h,000h,00Bh,000h,0FFh,02Fh,006h,00Dh,014h,01Bh,023h,02Ch
        .he 035,03E,02F,002,009,010,018,020,028,031,03A,090,01E ; DB 035h,03Eh,02Fh,002h,009h,010h,018h,020h,028h,031h,03Ah,090h,01Eh

;        DB 06Eh,00Ah,004h
;        DB 001h,06Fh,002h,064h,008h,000h,009h,000h

		;110
        .he 06E,00A,005 ; DB 06Eh,00Ah,004h
        .he 001,06F,002,064,008,000,009,000 ; DB 001h,06Fh,002h,064h,008h,000h,009h,000h

;        DB 06Fh,012h,005h
;        DB 000h,077h,003h,06Eh,00Ah,000h,00Bh,000h,0FFh,073h,02Bh,024h,022h,01Bh,090h,023h

		;111
        .he 06F,012,003 ; DB 06Fh,012h,005h
        .he 000,077,003,06E,00A,000,00B,000,0FF,073,02B,024,022,01B,090,023 ; DB 000h,077h,003h,06Eh,00Ah,000h,00Bh,000h,0FFh,073h,02Bh,024h,022h,01Bh,090h,023h

;        DB 070h,01Dh,006h
;        DB 002h,066h,008h,000h,009h,000h,0FFh,06Fh,026h,02Ch,02Eh,02Fh,035h,037h,03Dh,03Fh
;        DB 0ADh,025h,027h,02Dh,034h,036h,03Eh,00Ah,0AFh,017h,057h

		;112
        .he 070,01D,007 ; DB 070h,01Dh,006h
        .he 002,066,008,000,009,000,0FF,06F,026,02C,02E,02F,035,037,03D,03F ; DB 002h,066h,008h,000h,009h,000h,0FFh,06Fh,026h,02Ch,02Eh,02Fh,035h,037h,03Dh,03Fh
        .he 0AD,025,027,02D,034,036,03E,00A,0AF,017,057 ; DB 0ADh,025h,027h,02Dh,034h,036h,03Eh,00Ah,0AFh,017h,057h

;        DB 075h,015h,00Dh
;        DB 000h,07Ah,002h,06Bh,010h,000h,0FFh,00Bh,012h,013h,02Ch,02Dh,02Bh,052h,053h,06Ch
;        DB 06Dh,0A0h,01Ah

		;117
        .he 075,015,00b ; DB 075h,015h,00Dh
        .he 000,07A,002,06B,010,000,0FF,00B,012,013,02C,02D,02B,052,053,06C ; DB 000h,07Ah,002h,06Bh,010h,000h,0FFh,00Bh,012h,013h,02Ch,02Dh,02Bh,052h,053h,06Ch
        .he 06D,0A0,01A ; DB 06Dh,0A0h,01Ah

;        DB 076h,00Ah,006h
;        DB 000h,07Bh,002h,06Dh,008h,000h,00Bh,000h

		;118
        .he 076,00A,007 ; DB 076h,00Ah,006h
        .he 000,07B,002,06D,008,000,00B,000 ; DB 000h,07Bh,002h,06Dh,008h,000h,00Bh,000h

;        DB 077h,00Ch,007h
;        DB 000h,080h,001h,078h,002h,06Fh,008h,000h,00Bh,000h

		;119
        .he 077,00C,001 ; DB 077h,00Ch,007h
        .he 000,080,001,078,002,06F,008,000,00B,000 ; DB 000h,080h,001h,078h,002h,06Fh,008h,000h,00Bh,000h

;        DB 078h,01Bh,002h
;        DB 003h,077h,00Ah,000h,009h,000h,0FFh,00Eh,00Bh,00Ch,00Dh,00Eh,00Fh,04Eh,04Fh,020h
;        DB 023h,02Ch,04Bh,04Ch,04Dh,08Eh,08Fh,0E8h,000h

		;120
        .he 078,01B,002 ; DB 078h,01Bh,002h
        .he 003,077,00A,000,009,000,0FF,00E,00B,00C,00D,00E,00F,04E,04F,020 ; DB 003h,077h,00Ah,000h,009h,000h,0FFh,00Eh,00Bh,00Ch,00Dh,00Eh,00Fh,04Eh,04Fh,020h
        .he 023,02C,04B,04C,04D,08E,08F,0E8,000 ; DB 023h,02Ch,04Bh,04Ch,04Dh,08Eh,08Fh,0E8h,000h

;        DB 07Ah,008h,004h
;        DB 002h,075h,008h,000h,009h,000h

		;122
        .he 07A,008,005 ; DB 07Ah,008h,004h
        .he 002,075,008,000,009,000 ; DB 002h,075h,008h,000h,009h,000h

;        DB 07Bh,020h,005h
;        DB 001h,07Ch,002h,076h,008h,000h,009h,000h,0FFh,098h,031h,06Fh,020h,019h,01Ah,022h
;        DB 023h,02Ch,034h,03Bh,0ACh,018h,021h,02Bh,033h,03Ch,050h,0B4h,008h,036h

		;123
        .he 07B,020,003 ; DB 07Bh,020h,005h
        .he 001,07C,002,076,008,000,009,000,0FF,098,031,06F,020,019,01A,022 ; DB 001h,07Ch,002h,076h,008h,000h,009h,000h,0FFh,098h,031h,06Fh,020h,019h,01Ah,022h
        .he 023,02C,034,03B,0AC,018,021,02B,033,03C,050,0B4,008,036 ; DB 023h,02Ch,034h,03Bh,0ACh,018h,021h,02Bh,033h,03Ch,050h,0B4h,008h,036h

;        DB 07Ch,00Ah,006h
;        DB 001h,07Dh,003h,07Bh,00Ah,000h,009h,000h

		;124
        .he 07C,00A,007 ; DB 07Ch,00Ah,006h
        .he 001,07D,003,07B,00A,000,009,000 ; DB 001h,07Dh,003h,07Bh,00Ah,000h,009h,000h

;        DB 07Dh,016h,007h
;        DB 001h,07Eh,003h,07Ch,00Ah,000h,009h,000h,0FFh,0AFh,02Ah,02Ch,023h,025h,01Ah,01Ch
;        DB 013h,015h,0A0h,05Ch

		;125
        .he 07D,016,001 ; DB 07Dh,016h,007h
        .he 001,07E,003,07C,00A,000,009,000,0FF,0AF,02A,02C,023,025,01A,01C ; DB 001h,07Eh,003h,07Ch,00Ah,000h,009h,000h,0FFh,0AFh,02Ah,02Ch,023h,025h,01Ah,01Ch
        .he 013,015,0A0,05C ; DB 013h,015h,0A0h,05Ch

;        DB 07Eh,017h,012h
;        DB 001h,07Fh,003h,07Dh,011h,000h,0FFh,02Fh,02Ah,02Ch,023h,025h,01Ah,01Ch,013h,015h
;        DB 023h,021h,061h,01Eh,05Eh

		;126
        .he 07E,017,012 ; DB 07Eh,017h,012h
        .he 001,07F,003,07D,011,000,0FF,02F,02A,02C,023,025,01A,01C,013,015 ; DB 001h,07Fh,003h,07Dh,011h,000h,0FFh,02Fh,02Ah,02Ch,023h,025h,01Ah,01Ch,013h,015h
        .he 023,021,061,01E,05E ; DB 023h,021h,061h,01Eh,05Eh

;        DB 07Fh,00Ah,003h
;        DB 000h,082h,003h,07Eh,00Ah,000h,00Bh,000h

		;127
        .he 07F,00A,004 ; DB 07Fh,00Ah,003h
        .he 000,082,003,07E,00A,000,00B,000 ; DB 000h,082h,003h,07Eh,00Ah,000h,00Bh,000h

;        DB 080h,008h,004h
;        DB 002h,077h,008h,000h,009h,000h

		;128
        .he 080,008,005 ; DB 080h,008h,004h
        .he 002,077,008,000,009,000 ; DB 002h,077h,008h,000h,009h,000h

;        DB 081h,01Ah,005h
;        DB 000h,083h,008h,000h,00Bh,000h,0FFh,000h,087h,080h,083h,0F0h,0C7h,0C8h,011h,0AFh
;        DB 006h,00Fh,00Dh,016h,004h,014h,01Dh,003h

		;129
        .he 081,01A,003 ; DB 081h,01Ah,005h
        .he 000,083,008,000,00B,000,0FF,000,087,080,083,0F0,0C7,0C8,011,0AF ; DB 000h,083h,008h,000h,00Bh,000h,0FFh,000h,087h,080h,083h,0F0h,0C7h,0C8h,011h,0AFh
        .he 006,00F,00D,016,004,014,01D,003 ; DB 006h,00Fh,00Dh,016h,004h,014h,01Dh,003h

;        DB 082h,018h,00Eh
;        DB 000h,086h,002h,07Fh,010h,000h,0FFh,00Ah,05Bh,05Ch,05Dh,022h,01Bh,01Ch,01Dh,02Bh
;        DB 09Ah,09Bh,09Ch,09Dh,0E8h,01Ah

		;130
        .he 082,018,00f ; DB 082h,018h,00Eh
        .he 000,086,002,07F,010,000,0FF,00A,05B,05C,05D,022,01B,01C,01D,02B ; DB 000h,086h,002h,07Fh,010h,000h,0FFh,00Ah,05Bh,05Ch,05Dh,022h,01Bh,01Ch,01Dh,02Bh
        .he 09A,09B,09C,09D,0E8,01A ; DB 09Ah,09Bh,09Ch,09Dh,0E8h,01Ah

;        DB 083h,016h,007h
;        DB 001h,084h,002h,081h,008h,000h,009h,000h,0FFh,0AFh,006h,00Dh,016h,014h,01Dh,01Bh
;        DB 024h,02Dh,0A0h,011h

		;131
        .he 083,016,001 ; DB 083h,016h,007h
        .he 001,084,002,081,008,000,009,000,0FF,0AF,006,00D,016,014,01D,01B ; DB 001h,084h,002h,081h,008h,000h,009h,000h,0FFh,0AFh,006h,00Dh,016h,014h,01Dh,01Bh
        .he 024,02D,0A0,011 ; DB 024h,02Dh,0A0h,011h

;        DB 084h,008h,012h
;        DB 001h,085h,003h,083h,011h,000h

		;132
        .he 084,008,012 ; DB 084h,008h,012h
        .he 001,085,003,083,011,000 ; DB 001h,085h,003h,083h,011h,000h

;        DB 085h,016h,003h
;        DB 001h,086h,003h,084h,00Ah,000h,009h,000h,0FFh,027h,02Bh,02Ch,025h,01Dh,013h,014h
;        DB 022h,01Ah,090h,024h

		;133
        .he 085,016,004 ; DB 085h,016h,003h
        .he 001,086,003,084,00A,000,009,000,0FF,027,02B,02C,025,01D,013,014 ; DB 001h,086h,003h,084h,00Ah,000h,009h,000h,0FFh,027h,02Bh,02Ch,025h,01Dh,013h,014h
        .he 022,01A,090,024 ; DB 022h,01Ah,090h,024h

;        DB 086h,011h,004h
;        DB 004h,087h,002h,082h,003h,085h,00Ah,000h,00Fh,000h,0FFh,068h,013h,0A8h,025h

		;134
        .he 086,011,005 ; DB 086h,011h,004h
        .he 004,087,002,082,003,085,00A,000,00F,000,0FF,068,013,0A8,025 ; DB 004h,087h,002h,082h,003h,085h,00Ah,000h,00Fh,000h,0FFh,068h,013h,0A8h,025h

;        DB 087h,00Ch,005h
;        DB 004h,089h,005h,088h,006h,086h,00Ch,000h,00Fh,000h

		;135
        .he 087,00C,003 ; DB 087h,00Ch,005h
        .he 004,089,005,088,006,086,00C,000,00F,000 ; DB 004h,089h,005h,088h,006h,086h,00Ch,000h,00Fh,000h

;        DB 088h,00Ah,006h
;        DB 004h,08Ah,007h,087h,00Eh,000h,00Fh,000h

		;136
        .he 088,00A,007 ; DB 088h,00Ah,006h
        .he 004,08A,007,087,00E,000,00F,000 ; DB 004h,08Ah,007h,087h,00Eh,000h,00Fh,000h

;        DB 089h,00Ah,007h
;        DB 005h,08Ah,006h,087h,00Ch,000h,00Dh,000h

		;137
        .he 089,00A,001 ; DB 089h,00Ah,007h
        .he 005,08A,006,087,00C,000,00D,000 ; DB 005h,08Ah,006h,087h,00Ch,000h,00Dh,000h

;        DB 08Ah,00Ah,002h
;        DB 006h,088h,007h,089h,00Eh,000h,00Dh,000h

		;138
        .he 08A,00A,002 ; DB 08Ah,00Ah,002h
        .he 006,088,007,089,00E,000,00D,000 ; DB 006h,088h,007h,089h,00Eh,000h,00Dh,000h

;        DB 08Bh,00Ah,003h
;        DB 004h,08Eh,005h,08Ch,00Ch,000h,00Fh,000h

		;139
        .he 08B,00A,004 ; DB 08Bh,00Ah,003h
        .he 004,08E,005,08C,00C,000,00F,000 ; DB 004h,08Eh,005h,08Ch,00Ch,000h,00Fh,000h

;        DB 08Ch,00Ch,004h
;        DB 004h,08Fh,005h,029h,007h,08Bh,00Eh,000h,00Fh,000h

		;140
        .he 08C,00C,005 ; DB 08Ch,00Ch,004h
        .he 004,08F,005,029,007,08B,00E,000,00F,000 ; DB 004h,08Fh,005h,029h,007h,08Bh,00Eh,000h,00Fh,000h

;        DB 08Dh,013h,005h
;        DB 004h,090h,00Ch,000h,00Fh,000h,0FFh,0C2h,014h,05Ch,09Bh,000h,0D3h,01Ah,01Ch,01Bh
;        DB 013h

		;141
        .he 08D,013,003 ; DB 08Dh,013h,005h
        .he 004,090,00C,000,00F,000,0FF,0C2,014,05C,09B,000,0D3,01A,01C,01B ; DB 004h,090h,00Ch,000h,00Fh,000h,0FFh,0C2h,014h,05Ch,09Bh,000h,0D3h,01Ah,01Ch,01Bh
        .he 013 ; DB 013h

;        DB 08Eh,019h,006h
;        DB 006h,08Bh,00Ch,000h,00Dh,000h,0FFh,004h,030h,070h,0B0h,0E8h,038h,0C2h,039h,079h
;        DB 0B9h,049h,0F9h,0F8h,091h,078h,0B8h

		;142
        .he 08E,019,007 ; DB 08Eh,019h,006h
        .he 006,08B,00C,000,00D,000,0FF,004,030,070,0B0,0E8,038,0C2,039,079 ; DB 006h,08Bh,00Ch,000h,00Dh,000h,0FFh,004h,030h,070h,0B0h,0E8h,038h,0C2h,039h,079h
        .he 0B9,049,0F9,0F8,091,078,0B8 ; DB 0B9h,049h,0F9h,0F8h,091h,078h,0B8h

;        DB 08Fh,00Ch,007h
;        DB 005h,090h,006h,08Ch,007h,037h,00Eh,000h,00Dh,000h

		;143
        .he 08F,00C,001 ; DB 08Fh,00Ch,007h
        .he 005,090,006,08C,007,037,00E,000,00D,000 ; DB 005h,090h,006h,08Ch,007h,037h,00Eh,000h,00Dh,000h

;        DB 090h,00Ah,002h
;        DB 006h,08Dh,007h,08Fh,00Eh,000h,00Dh,000h

		;144
        .he 090,00A,002 ; DB 090h,00Ah,002h
        .he 006,08D,007,08F,00E,000,00D,000 ; DB 006h,08Dh,007h,08Fh,00Eh,000h,00Dh,000h

;        DB 091h,00Fh,003h
;        DB 005h,092h,007h,056h,00Eh,000h,00Dh,000h,0FFh,090h,05Bh,000h,01Bh

		;145
        .he 091,00F,004 ; DB 091h,00Fh,003h
        .he 005,092,007,056,00E,000,00D,000,0FF,090,05B,000,01B ; DB 005h,092h,007h,056h,00Eh,000h,00Dh,000h,0FFh,090h,05Bh,000h,01Bh

;        DB 092h,01Ch,004h
;        DB 007h,091h,00Eh,000h,00Dh,000h,0FFh,0C3h,019h,01Bh,05Bh,09Bh,050h,09Eh,003h,02Eh
;        DB 06Eh,0AEh,0EEh,048h,0DBh,01Bh,01Dh,026h,01Fh,016h

		;146
        .he 092,01C,005 ; DB 092h,01Ch,004h
        .he 007,091,00E,000,00D,000,0FF,0C3,019,01B,05B,09B,050,09E,003,02E ; DB 007h,091h,00Eh,000h,00Dh,000h,0FFh,0C3h,019h,01Bh,05Bh,09Bh,050h,09Eh,003h,02Eh
        .he 06E,0AE,0EE,048,0DB,01B,01D,026,01F,016 ; DB 06Eh,0AEh,0EEh,048h,0DBh,01Bh,01Dh,026h,01Fh,016h

;        DB 093h,017h,005h
;        DB 019h,094h,006h,000h,00Ch,000h,00Dh,000h,01Dh,000h,0FFh,060h,02Ch,001h,0EFh,0F7h
;        DB 0F0h,0A4h,019h,037h,02Fh

		;147
        .he 093,017,003 ; DB 093h,017h,005h
        .he 019,094,006,000,00C,000,00D,000,01D,000,0FF,060,02C,001,0EF,0F7 ; DB 019h,094h,006h,000h,00Ch,000h,00Dh,000h,01Dh,000h,0FFh,060h,02Ch,001h,0EFh,0F7h
        .he 0F0,0A4,019,037,02F ; DB 0F0h,0A4h,019h,037h,02Fh

;        DB 094h,00Ah,006h
;        DB 005h,095h,007h,093h,00Eh,000h,00Dh,000h

		;148
        .he 094,00A,007 ; DB 094h,00Ah,006h
        .he 005,095,007,093,00E,000,00D,000 ; DB 005h,095h,007h,093h,00Eh,000h,00Dh,000h

;        DB 095h,01Dh,007h
;        DB 006h,002h,01Bh,094h,00Ch,000h,00Dh,000h,01Fh,000h,0FFh,01Eh,03Ah,039h,031h,030h
;        DB 028h,008h,010h,0C2h,0C8h,0D0h,0E8h,060h,03Bh,050h,0F8h

		;149
        .he 095,01D,001 ; DB 095h,01Dh,007h
        .he 006,002,01B,094,00C,000,00D,000,01F,000,0FF,01E,03A,039,031,030 ; DB 006h,002h,01Bh,094h,00Ch,000h,00Dh,000h,01Fh,000h,0FFh,01Eh,03Ah,039h,031h,030h
        .he 028,008,010,0C2,0C8,0D0,0E8,060,03B,050,0F8 ; DB 028h,008h,010h,0C2h,0C8h,0D0h,0E8h,060h,03Bh,050h,0F8h

		
		
;BackgroundTypesTable: ; 696D
;696D:   DW BackgroundTypesData,L69BE,L69CF,L69E0,L69F1,L6A02,L6A13,L6A24
;697D:   DW L6ABD,L6AFE,L6ACD,L6B0E,L6BD1,L6C12,L6BE1,L6C22
;698D:   DW L6B3F,L6B88,BackgroundTypesTable,BackgroundTypesTable,L6C53,L6C9C,BackgroundTypesTable,BackgroundTypesTable
;699D:   DW L6A35,L6A46,L6A57,L6A68,L6A79,L6A8A,L6A9B,L6AAC

BackgroundTypesTable: ; 696D
        .wo BackgroundTypesData,L69BE,L69CF,L69E0,L69F1,L6A02,L6A13,L6A24 ; DW BackgroundTypesData,L69BE,L69CF,L69E0,L69F1,L6A02,L6A13,L6A24
        .wo L6ABD,L6AFE,L6ACD,L6B0E,L6BD1,L6C12,L6BE1,L6C22 ; DW L6ABD,L6AFE,L6ACD,L6B0E,L6BD1,L6C12,L6BE1,L6C22
        .wo L6B3F,L6B88,BackgroundTypesTable,BackgroundTypesTable,L6C53,L6C9C,BackgroundTypesTable,BackgroundTypesTable ; DW L6B3F,L6B88,BackgroundTypesTable,BackgroundTypesTable,L6C53,L6C9C,BackgroundTypesTable,BackgroundTypesTable
        .wo L6A35,L6A46,L6A57,L6A68,L6A79,L6A8A,L6A9B,L6AAC ; DW L6A35,L6A46,L6A57,L6A68,L6A79,L6A8A,L6A9B,L6AAC



;; 00 tree arch north
;; 01 tree arch east
;; 02 tree arch south
;; 03 tree arch west
;; 04 rock arch north
;; 05 rock arch east
;; 06 rock arch south
;; 07 rock arch west
;; 08 rock arch north
;; 09 rock arch east
;; 0a rock arch south
;; 0b rock arch west
;; 0c double brick 
;; 0d double brick
;; 0e double brick
;; 0f double brick
;; 10 tree wall
;; 11 tree wall
;; 12 tree wall
;; 13 tree wall
;; 14 tree wall
;; 15 tree wall
;; 16 tree wall
;; 17 wall
;; 18 wall
;; 19 wall
;; 1a wall
;; 1b wall
;; 1c wall
;; 1d wall

; 00 tree arch north
; 01 tree arch east
; 02 tree arch south
; 03 tree arch west
; 04 rock arch north
; 05 rock arch east
; 06 rock arch south
; 07 rock arch west
; 08 rock arch north
; 09 rock arch east
; 0a rock arch south
; 0b rock arch west
; 0c double brick 
; 0d double brick
; 0e double brick
; 0f double brick
; 10 tree wall
; 11 tree wall
; 12 tree wall
; 13 tree wall
; 14 tree wall
; 15 tree wall
; 16 tree wall
; 17 wall
; 18 wall
; 19 wall
; 1a wall
; 1b wall
; 1c wall
; 1d wall





;BackgroundTypesData: ; 69AD
;69AD:   DB 07,73,C5,80,03,05,28,50,06,8D,C5,80,03,05,28,50,00
;L69BE   DB 07,C5,8D,80,05,03,28,10,06,C5,73,80,05,03,28,10,00
;L69CF   DB 07,73,3B,80,03,05,28,50,06,8D,3B,80,03,05,28,50,00
;L69E0   DB 07,3B,8D,80,05,03,28,10,06,3B,73,80,05,03,28,10,00
;L69F1   DB 09,73,C5,80,03,05,28,50,08,8D,C5,80,03,05,28,50,00
;L6A02   DB 09,C5,8D,80,05,03,28,10,08,C5,73,80,05,03,28,10,00
;L6A13   DB 09,73,3B,80,03,05,28,50,08,8D,3B,80,03,05,28,50,00
;L6A24   DB 09,3B,8D,80,05,03,28,10,08,3B,73,80,05,03,28,10,00
;L6A35   DB 09,93,C5,B0,03,05,28,50,08,AD,C5,B0,03,05,28,50,00
;L6A46   DB 09,C5,AD,B0,05,03,28,10,08,C5,93,B0,05,03,28,10,00
;L6A57   DB 09,53,3B,B0,03,05,28,50,08,6D,3B,B0,03,05,28,50,00
;L6A68   DB 09,3B,6D,B0,05,03,28,10,08,3B,53,B0,05,03,28,10,00

BackgroundTypesData: ; 69AD
        .he 07,73,C5,80,03,05,28,50,06,8D,C5,80,03,05,28,50,00 ; DB 07,73,C5,80,03,05,28,50,06,8D,C5,80,03,05,28,50,00
L69BE   .he 07,C5,8D,80,05,03,28,10,06,C5,73,80,05,03,28,10,00 ; DB 07,C5,8D,80,05,03,28,10,06,C5,73,80,05,03,28,10,00
L69CF   .he 07,73,3B,80,03,05,28,50,06,8D,3B,80,03,05,28,50,00 ; DB 07,73,3B,80,03,05,28,50,06,8D,3B,80,03,05,28,50,00
L69E0   .he 07,3B,8D,80,05,03,28,10,06,3B,73,80,05,03,28,10,00 ; DB 07,3B,8D,80,05,03,28,10,06,3B,73,80,05,03,28,10,00
L69F1   .he 09,73,C5,80,03,05,28,50,08,8D,C5,80,03,05,28,50,00 ; DB 09,73,C5,80,03,05,28,50,08,8D,C5,80,03,05,28,50,00
L6A02   .he 09,C5,8D,80,05,03,28,10,08,C5,73,80,05,03,28,10,00 ; DB 09,C5,8D,80,05,03,28,10,08,C5,73,80,05,03,28,10,00
L6A13   .he 09,73,3B,80,03,05,28,50,08,8D,3B,80,03,05,28,50,00 ; DB 09,73,3B,80,03,05,28,50,08,8D,3B,80,03,05,28,50,00
L6A24   .he 09,3B,8D,80,05,03,28,10,08,3B,73,80,05,03,28,10,00 ; DB 09,3B,8D,80,05,03,28,10,08,3B,73,80,05,03,28,10,00
L6A35   .he 09,93,C5,B0,03,05,28,50,08,AD,C5,B0,03,05,28,50,00 ; DB 09,93,C5,B0,03,05,28,50,08,AD,C5,B0,03,05,28,50,00
L6A46   .he 09,C5,AD,B0,05,03,28,10,08,C5,93,B0,05,03,28,10,00 ; DB 09,C5,AD,B0,05,03,28,10,08,C5,93,B0,05,03,28,10,00
L6A57   .he 09,53,3B,B0,03,05,28,50,08,6D,3B,B0,03,05,28,50,00 ; DB 09,53,3B,B0,03,05,28,50,08,6D,3B,B0,03,05,28,50,00
L6A68   .he 09,3B,6D,B0,05,03,28,10,08,3B,53,B0,05,03,28,10,00 ; DB 09,3B,6D,B0,05,03,28,10,08,3B,53,B0,05,03,28,10,00



;L6A79   DB 0B,98,C8,A4,08,08,0C,10,0B,A8,C8,A4,08,08,0C,10,00
;L6A8A   DB 0B,C8,98,A4,08,08,0C,10,0B,C8,A8,A4,08,08,0C,10,00
;L6A9B   DB 0B,58,39,A4,08,08,0C,10,0B,68,39,A4,08,08,0C,10,00
;L6AAC   DB 0B,38,58,A4,08,08,0C,10,0B,38,68,A4,08,08,0C,10,00

L6A79   .he 0B,98,C8,A4,08,08,0C,10,0B,A8,C8,A4,08,08,0C,10,00 ; DB 0B,98,C8,A4,08,08,0C,10,0B,A8,C8,A4,08,08,0C,10,00
L6A8A   .he 0B,C8,98,A4,08,08,0C,10,0B,C8,A8,A4,08,08,0C,10,00 ; DB 0B,C8,98,A4,08,08,0C,10,0B,C8,A8,A4,08,08,0C,10,00
L6A9B   .he 0B,58,39,A4,08,08,0C,10,0B,68,39,A4,08,08,0C,10,00 ; DB 0B,58,39,A4,08,08,0C,10,0B,68,39,A4,08,08,0C,10,00
L6AAC   .he 0B,38,58,A4,08,08,0C,10,0B,38,68,A4,08,08,0C,10,00 ; DB 0B,38,58,A4,08,08,0C,10,0B,38,68,A4,08,08,0C,10,00

;L6ABD   DB 0F,40,78,80,00,08,18,50,0C,40,88,80,00,08,18,50

L6ABD   .he 0F,40,78,80,00,08,18,50,0C,40,88,80,00,08,18,50 ; DB 0F,40,78,80,00,08,18,50,0C,40,88,80,00,08,18,50

;L6ACD   DB 0C,40,48,80,00,08,18,50,0D,40,58,80,00,08,18,50
;6ADD:   DB 0E,40,68,80,00,08,18,50,0D,40,98,80,00,08,18,50
;6AED:   DB 0E,40,A8,80,00,08,18,50,0F,40,B8,80,00,08,18,50
;6AFD:   DB 00

L6ACD   .he 0C,40,48,80,00,08,18,50,0D,40,58,80,00,08,18,50 ; DB 0C,40,48,80,00,08,18,50,0D,40,58,80,00,08,18,50
        .he 0E,40,68,80,00,08,18,50,0D,40,98,80,00,08,18,50 ; DB 0E,40,68,80,00,08,18,50,0D,40,98,80,00,08,18,50
        .he 0E,40,A8,80,00,08,18,50,0F,40,B8,80,00,08,18,50 ; DB 0E,40,A8,80,00,08,18,50,0F,40,B8,80,00,08,18,50
        .he 00 ; DB 00

;L6AFE   DB 0F,78,C0,80,08,00,18,10,0C,88,C0,80,08,00,18,10

L6AFE   .he 0F,78,C0,80,08,00,18,10,0C,88,C0,80,08,00,18,10 ; DB 0F,78,C0,80,08,00,18,10,0C,88,C0,80,08,00,18,10

;L6B0E   DB 0C,48,C0,80,08,00,18,10,0D,58,C0,80,08,00,18,10
;6B1E:   DB 0E,68,C0,80,08,00,18,10,0D,98,C0,80,08,00,18,10
;6B2E:   DB 0E,A8,C0,80,08,00,18,10,0F,B8,C0,80,08,00,18,10
;6B3E:   DB 00

L6B0E   .he 0C,48,C0,80,08,00,18,10,0D,58,C0,80,08,00,18,10 ; DB 0C,48,C0,80,08,00,18,10,0D,58,C0,80,08,00,18,10
        .he 0E,68,C0,80,08,00,18,10,0D,98,C0,80,08,00,18,10 ; DB 0E,68,C0,80,08,00,18,10,0D,98,C0,80,08,00,18,10
        .he 0E,A8,C0,80,08,00,18,10,0F,B8,C0,80,08,00,18,10 ; DB 0E,A8,C0,80,08,00,18,10,0F,B8,C0,80,08,00,18,10
        .he 00 ; DB 00

;L6B3F   DB 0F,60,78,80,00,08,18,50,0C,60,88,80,00,08,18,50
;6B4F:   DB 0C,60,48,80,00,08,18,50,0D,60,58,80,00,08,18,50
;6B5F:   DB 0E,60,68,80,00,08,18,50,0D,60,98,80,00,08,18,50
;6B6F:   DB 0E,60,A8,80,00,08,18,50,0F,60,B8,80,00,08,18,50
;6B7F:   DB 0E,68,C0,80,08,00,18,10,00

L6B3F   .he 0F,60,78,80,00,08,18,50,0C,60,88,80,00,08,18,50 ; DB 0F,60,78,80,00,08,18,50,0C,60,88,80,00,08,18,50
        .he 0C,60,48,80,00,08,18,50,0D,60,58,80,00,08,18,50 ; DB 0C,60,48,80,00,08,18,50,0D,60,58,80,00,08,18,50
        .he 0E,60,68,80,00,08,18,50,0D,60,98,80,00,08,18,50 ; DB 0E,60,68,80,00,08,18,50,0D,60,98,80,00,08,18,50
        .he 0E,60,A8,80,00,08,18,50,0F,60,B8,80,00,08,18,50 ; DB 0E,60,A8,80,00,08,18,50,0F,60,B8,80,00,08,18,50
        .he 0E,68,C0,80,08,00,18,10,00 ; DB 0E,68,C0,80,08,00,18,10,00

;L6B88   DB 0F,78,A0,80,08,00,18,10,0C,88,A0,80,08,00,18,10
;6B98:   DB 0C,48,A0,80,08,00,18,10,0D,58,A0,80,08,00,18,10
;6BA8:   DB 0E,68,A0,80,08,00,18,10,0D,98,A0,80,08,00,18,10
;6BB8:   DB 0E,A8,A0,80,08,00,18,10,0F,B8,A0,80,08,00,18,10
;6BC8:   DB 0D,40,98,80,00,08,18,50,00

L6B88   .he 0F,78,A0,80,08,00,18,10,0C,88,A0,80,08,00,18,10 ; DB 0F,78,A0,80,08,00,18,10,0C,88,A0,80,08,00,18,10
        .he 0C,48,A0,80,08,00,18,10,0D,58,A0,80,08,00,18,10 ; DB 0C,48,A0,80,08,00,18,10,0D,58,A0,80,08,00,18,10
        .he 0E,68,A0,80,08,00,18,10,0D,98,A0,80,08,00,18,10 ; DB 0E,68,A0,80,08,00,18,10,0D,98,A0,80,08,00,18,10
        .he 0E,A8,A0,80,08,00,18,10,0F,B8,A0,80,08,00,18,10 ; DB 0E,A8,A0,80,08,00,18,10,0F,B8,A0,80,08,00,18,10
        .he 0D,40,98,80,00,08,18,50,00 ; DB 0D,40,98,80,00,08,18,50,00





;L6BD1   DB 34,40,78,80,00,08,18,10,35,40,88,80,00,08,18,10

L6BD1   .he 34,40,78,80,00,08,18,10,35,40,88,80,00,08,18,10 ; DB 34,40,78,80,00,08,18,10,35,40,88,80,00,08,18,10

;L6BE1   DB 39,40,48,80,00,08,18,10,37,40,58,80,00,08,18,10
;6BF1:   DB 38,40,68,80,00,08,18,10,37,40,98,80,00,08,18,10
;6C01:   DB 36,40,A8,80,00,08,18,10,35,40,B8,80,00,08,18,10
;6C11:   DB 00

L6BE1   .he 39,40,48,80,00,08,18,10,37,40,58,80,00,08,18,10 ; DB 39,40,48,80,00,08,18,10,37,40,58,80,00,08,18,10
        .he 38,40,68,80,00,08,18,10,37,40,98,80,00,08,18,10 ; DB 38,40,68,80,00,08,18,10,37,40,98,80,00,08,18,10
        .he 36,40,A8,80,00,08,18,10,35,40,B8,80,00,08,18,10 ; DB 36,40,A8,80,00,08,18,10,35,40,B8,80,00,08,18,10
        .he 00 ; DB 00

;L6C12   DB 37,78,C0,80,08,00,18,50,38,88,C0,80,08,00,18,50

L6C12   .he 37,78,C0,80,08,00,18,50,38,88,C0,80,08,00,18,50 ; DB 37,78,C0,80,08,00,18,50,38,88,C0,80,08,00,18,50

;L6C22   DB 36,48,C0,80,08,00,18,50,35,58,C0,80,08,00,18,50
;6C32:   DB 34,68,C0,80,08,00,18,50,36,98,C0,80,08,00,18,50
;6C42:   DB 37,A8,C0,80,08,00,18,50,39,B8,C0,80,08,00,18,50
;6C52:   DB 00

L6C22   .he 36,48,C0,80,08,00,18,50,35,58,C0,80,08,00,18,50 ; DB 36,48,C0,80,08,00,18,50,35,58,C0,80,08,00,18,50
        .he 34,68,C0,80,08,00,18,50,36,98,C0,80,08,00,18,50 ; DB 34,68,C0,80,08,00,18,50,36,98,C0,80,08,00,18,50
        .he 37,A8,C0,80,08,00,18,50,39,B8,C0,80,08,00,18,50 ; DB 37,A8,C0,80,08,00,18,50,39,B8,C0,80,08,00,18,50
        .he 00 ; DB 00

;L6C53   DB 34,60,78,80,00,08,18,10,35,60,88,80,00,08,18,10
;6C63:   DB 39,60,48,80,00,08,18,10,37,60,58,80,00,08,18,10
;6C73:   DB 36,60,68,80,00,08,18,10,37,60,98,80,00,08,18,10
;6C83:   DB 35,60,A8,80,00,08,18,10,34,60,B8,80,00,08,18,10
;6C93:   DB 36,68,C0,80,08,00,18,50,00

L6C53   .he 34,60,78,80,00,08,18,10,35,60,88,80,00,08,18,10 ; DB 34,60,78,80,00,08,18,10,35,60,88,80,00,08,18,10
        .he 39,60,48,80,00,08,18,10,37,60,58,80,00,08,18,10 ; DB 39,60,48,80,00,08,18,10,37,60,58,80,00,08,18,10
        .he 36,60,68,80,00,08,18,10,37,60,98,80,00,08,18,10 ; DB 36,60,68,80,00,08,18,10,37,60,98,80,00,08,18,10
        .he 35,60,A8,80,00,08,18,10,34,60,B8,80,00,08,18,10 ; DB 35,60,A8,80,00,08,18,10,34,60,B8,80,00,08,18,10
        .he 36,68,C0,80,08,00,18,50,00 ; DB 36,68,C0,80,08,00,18,50,00

;L6C9C   DB 34,78,A0,80,08,00,18,50,37,88,A0,80,08,00,18,50
;6CAC:   DB 36,48,A0,80,08,00,18,50,35,58,A0,80,08,00,18,50
;6CBC:   DB 36,68,A0,80,08,00,18,50,37,98,A0,80,08,00,18,50
;6CCC:   DB 35,A8,A0,80,08,00,18,50,39,B8,A0,80,08,00,18,50
;6CDC:   DB 36,40,98,80,00,08,18,10,00

L6C9C   .he 34,78,A0,80,08,00,18,50,37,88,A0,80,08,00,18,50 ; DB 34,78,A0,80,08,00,18,50,37,88,A0,80,08,00,18,50
        .he 36,48,A0,80,08,00,18,50,35,58,A0,80,08,00,18,50 ; DB 36,48,A0,80,08,00,18,50,35,58,A0,80,08,00,18,50
        .he 36,68,A0,80,08,00,18,50,37,98,A0,80,08,00,18,50 ; DB 36,68,A0,80,08,00,18,50,37,98,A0,80,08,00,18,50
        .he 35,A8,A0,80,08,00,18,50,39,B8,A0,80,08,00,18,50 ; DB 35,A8,A0,80,08,00,18,50,39,B8,A0,80,08,00,18,50
        .he 36,40,98,80,00,08,18,10,00 ; DB 36,40,98,80,00,08,18,10,00

;BlockTypesTable: ; 6CE5
;6CE5:   DW L6D29,L6D3B,L6D41,L6D47,L6D4D,L6D53,L6D59,L6D5F
;6CF5:   DW L6D65,BlockTypesData,L6D6B,L6D71,L6D77,L6D2F,L6D7D,L6D83
;6D05:   DW L6D89,L6D8F,L6D95,L6DA7,L6DAD,L6D35,BlockTypesData,L6DB3
;6D15:   DW L6DB9,L6DBF,L6DC5,L6DCB,L6DD1,L6D9B,L6DA1

BlockTypesTable: ; 6CE5
        .wo L6D29,L6D3B,L6D41,L6D47,L6D4D,L6D53,L6D59,L6D5F ; DW L6D29,L6D3B,L6D41,L6D47,L6D4D,L6D53,L6D59,L6D5F
        .wo L6D65,BlockTypesData,L6D6B,L6D71,L6D77,L6D2F,L6D7D,L6D83 ; DW L6D65,BlockTypesData,L6D6B,L6D71,L6D77,L6D2F,L6D7D,L6D83
        .wo L6D89,L6D8F,L6D95,L6DA7,L6DAD,L6D35,BlockTypesData,L6DB3 ; DW L6D89,L6D8F,L6D95,L6DA7,L6DAD,L6D35,BlockTypesData,L6DB3
        .wo L6DB9,L6DBF,L6DC5,L6DCB,L6DD1,L6D9B,L6DA1 ; DW L6DB9,L6DBF,L6DC5,L6DCB,L6DD1,L6D9B,L6DA1

;; 00 brick
;; 01 brick
;; 02 pond
;; 03 lilly pond
;; 04 log
;; 05 ghost
;; 06 spike
;; 07 log
;; 08 trap
;; 09 stone block
;; 0a table
;; 0b log
;; 0c brick
;; 0d brick
;; 0e brick
;; 0f spike
;; 10 dragon head
;; 11 brick
;; 12 brick
;; 13 spider
;; 14 dragon head
;; 15 dragon head rotated
;; 16 well
;; 17 spider
;; 18 stone block
;; 19 pentagram corner
;; 1a disolving brick
;; 1b brick
;; 1c brick
;; 1d brick
;; 1e -----
;; 1f 

; 00 brick
; 01 brick
; 02 pond
; 03 lilly pond
; 04 log
; 05 ghost
; 06 spike
; 07 log
; 08 trap
; 09 stone block
; 0a table
; 0b log
; 0c brick
; 0d brick
; 0e brick
; 0f spike
; 10 dragon head
; 11 brick
; 12 brick
; 13 spider
; 14 dragon head
; 15 dragon head rotated
; 16 well
; 17 spider
; 18 stone block
; 19 pentagram corner
; 1a disolving brick
; 1b brick
; 1c brick
; 1d brick
; 1e -----
; 1f 



;BlockTypesData: ; 6D23
;6D23:   DB 5B,08,08,0C,10,00

BlockTypesData: ; 6D23
        .he 5B,08,08,0C,10,00 ; DB 5B,08,08,0C,10,00

;L6D29   DB 0B,08,08,0C,10,00

L6D29   .he 0B,08,08,0C,10,00 ; DB 0B,08,08,0C,10,00

;L6D2F   DB 4A,0C,0C,01,10,00

L6D2F   .he 4A,0C,0C,01,10,00 ; DB 4A,0C,0C,01,10,00

;L6D35   DB 4B,0C,0C,01,10,00

L6D35   .he 4B,0C,0C,01,10,00 ; DB 4B,0C,0C,01,10,00

;L6D3B   DB 0A,08,08,0C,10,00

L6D3B   .he 0A,08,08,0C,10,00 ; DB 0A,08,08,0C,10,00

;L6D41   DB 30,05,05,05,10,00

L6D41   .he 30,05,05,05,10,00 ; DB 30,05,05,05,10,00

;L6D47   DB 17,07,07,0A,10,00

L6D47   .he 17,07,07,0A,10,00 ; DB 17,07,07,0A,10,00

;L6D4D   DB 48,08,08,0C,14,00

L6D4D   .he 48,08,08,0C,14,00 ; DB 48,08,08,0C,14,00

;L6D53   DB 1E,07,07,0A,10,00

L6D53   .he 1E,07,07,0A,10,00 ; DB 1E,07,07,0A,10,00

;L6D59   DB 3F,08,08,0C,14,00

L6D59   .he 3F,08,08,0C,14,00 ; DB 3F,08,08,0C,14,00

;L6D5F   DB 49,08,0E,0C,14,00

L6D5F   .he 49,08,0E,0C,14,00 ; DB 49,08,0E,0C,14,00

;L6D65   DB 4C,08,08,0C,10,00

L6D65   .he 4C,08,08,0C,10,00 ; DB 4C,08,08,0C,10,00

;L6D6B   DB 4E,08,08,0C,10,00

L6D6B   .he 4E,08,08,0C,10,00 ; DB 4E,08,08,0C,10,00

;L6D71   DB 4F,08,08,0C,14,00

L6D71   .he 4F,08,08,0C,14,00 ; DB 4F,08,08,0C,14,00

;L6D77   DB 54,08,08,0C,10,00

L6D77   .he 54,08,08,0C,10,00 ; DB 54,08,08,0C,10,00

;L6D7D   DB 1C,07,07,0B,14,00

L6D7D   .he 1C,07,07,0B,14,00 ; DB 1C,07,07,0B,14,00

;L6D83   DB 56,08,08,0C,10,00

L6D83   .he 56,08,08,0C,10,00 ; DB 56,08,08,0C,10,00

;L6D89   DB 57,08,08,0C,10,00

L6D89   .he 57,08,08,0C,10,00 ; DB 57,08,08,0C,10,00

;L6D8F   DB 58,08,08,0C,10,00

L6D8F   .he 58,08,08,0C,10,00 ; DB 58,08,08,0C,10,00

;L6D95   DB 59,08,08,0A,10,00

L6D95   .he 59,08,08,0A,10,00 ; DB 59,08,08,0A,10,00

;L6D9B   DB 5C,08,08,0C,10,00

L6D9B   .he 5C,08,08,0C,10,00 ; DB 5C,08,08,0C,10,00

;L6DA1   DB 5D,08,08,0C,50,00

L6DA1   .he 5D,08,08,0C,50,00 ; DB 5D,08,08,0C,50,00

;L6DA7   DB 78,0A,0A,0C,10,00

L6DA7   .he 78,0A,0A,0C,10,00 ; DB 78,0A,0A,0C,10,00

;L6DAD   DB 10,08,08,0A,10,00

L6DAD   .he 10,08,08,0A,10,00 ; DB 10,08,08,0A,10,00

;L6DB3   DB 52,08,08,0C,10,00

L6DB3   .he 52,08,08,0C,10,00 ; DB 52,08,08,0C,10,00

;L6DB9   DB 88,08,08,0C,10,00

L6DB9   .he 88,08,08,0C,10,00 ; DB 88,08,08,0C,10,00

;L6DBF   DB 8C,08,08,0C,10,00

L6DBF   .he 8C,08,08,0C,10,00 ; DB 8C,08,08,0C,10,00

;L6DC5   DB 8D,08,08,0C,10,00

L6DC5   .he 8D,08,08,0C,10,00 ; DB 8D,08,08,0C,10,00

;L6DCB   DB 8E,08,08,0C,10,00

L6DCB   .he 8E,08,08,0C,10,00 ; DB 8E,08,08,0C,10,00

;L6DD1   DB 8F,08,08,0C,10,00

L6DD1   .he 8F,08,08,0C,10,00 ; DB 8F,08,08,0C,10,00

;Font    DB 6C,D6,D6,D6,D6,6C,38,18,38,58,18,18,18,18,7C,38
;8366:   DB 4C,0C,3C,60,C2,C2,FE,38,4C,0C,3C,0E,86,86,FC,18
;8376:   DB 38,58,9A,FE,1A,18,7C,FE,C2,C0,FC,06,06,86,7C,1E
;8386:   DB 32,60,EC,C6,C6,C6,7C,7E,46,4C,0C,18,18,38,F8,38
;8396:   DB 6C,6C,7C,FE,C6,C6,7C,7C,C6,C6,C6,7C,0C,98,F0,00
;83A6:   DB 00,00,00,00,00,18,18,00,C3,C6,0C,18,30,63,C3,3C
;83B6:   DB 42,99,A1,A1,99,42,3C,00,00,00,00,00,00,00,00,00
;83C6:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;83D6:   DB 00,00,00,00,00,00,00,0C,1C,2E,66,46,CE,D6,66,F8
;83E6:   DB 6C,6C,78,6C,66,66,FC,0E,32,60,40,C0,C2,E6,7C,60
;83F6:   DB 70,68,6C,66,66,66,FC,FE,60,64,7C,64,60,7A,C6,C6
;8406:   DB 7A,60,64,7C,64,60,60,0E,30,60,C6,CE,F6,66,0E,EE
;8416:   DB C6,C6,FE,C6,C6,C6,EE,7C,18,18,18,18,18,18,7C,1E
;8426:   DB 06,06,86,86,C6,7E,1C,E4,68,70,78,6C,64,64,F6,E0
;8436:   DB 60,60,60,60,60,62,FE,C6,EE,EE,D6,D6,D6,C6,EE,CC
;8446:   DB D6,D6,E6,E4,C4,C8,DE,38,6C,C6,C6,C6,C6,6C,38,F8
;8456:   DB 6C,66,76,6E,60,60,F0,38,6C,C6,C6,C6,D6,6C,3A,F8
;8466:   DB 6C,66,76,7E,78,6C,E6,38,64,60,3C,06,86,C6,7C,FE
;8476:   DB 9A,98,18,18,18,18,18,F6,26,46,4E,CE,D6,D6,66,E2
;8486:   DB 62,64,64,68,68,70,60,EE,C6,D6,D6,D6,EE,EE,C6,C6
;8496:   DB C6,6C,38,38,6C,C6,C6,86,66,16,0E,06,04,4C,38,7E

L81D5	equ *-$180
Font    .he 38,6C,D6,D6,D6,D6,6C,38,18,38,58,18,18,18,18,7C,38 ; DB 6C,D6,D6,D6,D6,6C,38,18,38,58,18,18,18,18,7C,38
        .he 4C,0C,3C,60,C2,C2,FE,38,4C,0C,3C,0E,86,86,FC,18 ; DB 4C,0C,3C,60,C2,C2,FE,38,4C,0C,3C,0E,86,86,FC,18
        .he 38,58,9A,FE,1A,18,7C,FE,C2,C0,FC,06,06,86,7C,1E ; DB 38,58,9A,FE,1A,18,7C,FE,C2,C0,FC,06,06,86,7C,1E
        .he 32,60,EC,C6,C6,C6,7C,7E,46,4C,0C,18,18,38,F8,38 ; DB 32,60,EC,C6,C6,C6,7C,7E,46,4C,0C,18,18,38,F8,38
        .he 6C,6C,7C,FE,C6,C6,7C,7C,C6,C6,C6,7C,0C,98,F0,00 ; DB 6C,6C,7C,FE,C6,C6,7C,7C,C6,C6,C6,7C,0C,98,F0,00
        .he 00,00,00,00,00,18,18,00,C3,C6,0C,18,30,63,C3,3C ; DB 00,00,00,00,00,18,18,00,C3,C6,0C,18,30,63,C3,3C
        .he 42,99,A1,A1,99,42,3C,00,00,00,00,00,00,00,00,00 ; DB 42,99,A1,A1,99,42,3C,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,0C,1C,2E,66,46,CE,D6,66,F8 ; DB 00,00,00,00,00,00,00,0C,1C,2E,66,46,CE,D6,66,F8
        .he 6C,6C,78,6C,66,66,FC,0E,32,60,40,C0,C2,E6,7C,60 ; DB 6C,6C,78,6C,66,66,FC,0E,32,60,40,C0,C2,E6,7C,60
        .he 70,68,6C,66,66,66,FC,FE,60,64,7C,64,60,7A,C6,C6 ; DB 70,68,6C,66,66,66,FC,FE,60,64,7C,64,60,7A,C6,C6
        .he 7A,60,64,7C,64,60,60,0E,30,60,C6,CE,F6,66,0E,EE ; DB 7A,60,64,7C,64,60,60,0E,30,60,C6,CE,F6,66,0E,EE
        .he C6,C6,FE,C6,C6,C6,EE,7C,18,18,18,18,18,18,7C,1E ; DB C6,C6,FE,C6,C6,C6,EE,7C,18,18,18,18,18,18,7C,1E
        .he 06,06,86,86,C6,7E,1C,E4,68,70,78,6C,64,64,F6,E0 ; DB 06,06,86,86,C6,7E,1C,E4,68,70,78,6C,64,64,F6,E0
        .he 60,60,60,60,60,62,FE,C6,EE,EE,D6,D6,D6,C6,EE,CC ; DB 60,60,60,60,60,62,FE,C6,EE,EE,D6,D6,D6,C6,EE,CC
        .he D6,D6,E6,E4,C4,C8,DE,38,6C,C6,C6,C6,C6,6C,38,F8 ; DB D6,D6,E6,E4,C4,C8,DE,38,6C,C6,C6,C6,C6,6C,38,F8
        .he 6C,66,76,6E,60,60,F0,38,6C,C6,C6,C6,D6,6C,3A,F8 ; DB 6C,66,76,6E,60,60,F0,38,6C,C6,C6,C6,D6,6C,3A,F8
        .he 6C,66,76,7E,78,6C,E6,38,64,60,3C,06,86,C6,7C,FE ; DB 6C,66,76,7E,78,6C,E6,38,64,60,3C,06,86,C6,7C,FE
        .he 9A,98,18,18,18,18,18,F6,26,46,4E,CE,D6,D6,66,E2 ; DB 9A,98,18,18,18,18,18,F6,26,46,4E,CE,D6,D6,66,E2
        .he 62,64,64,68,68,70,60,EE,C6,D6,D6,D6,EE,EE,C6,C6 ; DB 62,64,64,68,68,70,60,EE,C6,D6,D6,D6,EE,EE,C6,C6
        .he C6,6C,38,38,6C,C6,C6,86,66,16,0E,06,04,4C,38,7E ; DB C6,6C,38,38,6C,C6,C6,86,66,16,0E,06,04,4C,38,7E

		;icl 'pentagram_sprites.asm'		

SprGfxTable
; Sprite 00, pointer 9395: empty
; Sprite 01, pointer 9395: empty
; Sprite 02, pointer 9a4b: vertical ornament from title screen
; Sprite 03, pointer 9add: horizontal ornament from title screen
; Sprite 04, pointer 9b3f: ornament from title screen
; Sprite 05, pointer 9bd1: ornament from title screen
; Sprite 06, pointer 9c63: left tree, room entrance (masked)
; Sprite 07, pointer 9daf: right tree, room entrance (masked)
; Sprite 08, pointer a557: left arch, room entrance (masked)
; Sprite 09, pointer a47d: right arch, room entrance (masked)
; Sprite 0a, pointer 9e51: piece of tree (masked)
; Sprite 0b, pointer 88bd: square stone (masked)
; Sprite 0c, pointer 9f1b: background tree
; Sprite 0d, pointer 9fc9: background tree
; Sprite 0e, pointer a09f: background tree
; Sprite 0f, pointer a175: background tree
; Sprite 10, pointer 84ad: spider (masked)
; Sprite 11, pointer 84ad: spider (masked)
; Sprite 12, pointer 98a5: hero bottom facing NW
; Sprite 13, pointer 9901: hero bottom facing SE
; Sprite 14, pointer 98a5: hero bottom facing NW
; Sprite 15, pointer 9849: hero bottom facing NW
; Sprite 16, pointer 8877: life sign on panel
; Sprite 17, pointer 8795: square with spikes
; Sprite 18, pointer 9395: empty
; Sprite 19, pointer 9395: empty
; Sprite 1a, pointer 9395: empty
; Sprite 1b, pointer 9395: empty
; Sprite 1c, pointer 8795: square with spikes
; Sprite 1d, pointer 9849: hero bottom facing NW
; Sprite 1e, pointer 86eb: forest trap
; Sprite 1f, pointer 86eb: forest trap
; Sprite 20, pointer 98a5: hero bottom facing NW
; Sprite 21, pointer 9849: hero bottom facing NW
; Sprite 22, pointer 97ed: hero bottom facing NW
; Sprite 23, pointer 9849: hero bottom facing NW
; Sprite 24, pointer 996f: hero bottom facing SE
; Sprite 25, pointer 9901: hero bottom facing SE
; Sprite 26, pointer 99dd: hero bottom facing SE
; Sprite 27, pointer 9901: hero bottom facing SE
; Sprite 28, pointer 94df: hero top facing NW
; Sprite 29, pointer 943b: hero top facing NW
; Sprite 2a, pointer 9397: hero top facing NW
; Sprite 2b, pointer 943b: hero top facing NW
; Sprite 2c, pointer 9651: hero top facing SE
; Sprite 2d, pointer 9583: hero top facing SE
; Sprite 2e, pointer 971f: hero top facing SE
; Sprite 2f, pointer 9583: hero top facing SE
; Sprite 30, pointer 7fff: ghost
; Sprite 31, pointer 809d: ghost
; Sprite 32, pointer 7fff: ghost
; Sprite 33, pointer 809d: ghost
; Sprite 34, pointer a327: background column
; Sprite 35, pointer a2a9: background rock
; Sprite 36, pointer a23f: background rock
; Sprite 37, pointer a3ad: background rock
; Sprite 38, pointer a40f: background rock
; Sprite 39, pointer a67f: background rock
; Sprite 3a, pointer 89a7: panel ornament
; Sprite 3b, pointer 89e9: panel ornament
; Sprite 3c, pointer 8a59: panel ornament
; Sprite 3d, pointer 8a59: panel ornament
; Sprite 3e, pointer 8a9b: panel ornament
; Sprite 3f, pointer 8609: box
; Sprite 40, pointer 813b: cloud
; Sprite 41, pointer 8175: cloud
; Sprite 41, pointer 81c5: cloud
; Sprite 43, pointer 8175: cloud
; Sprite 44, pointer 81c5: cloud
; Sprite 45, pointer 81c5: cloud
; Sprite 46, pointer 822d: cloud
; Sprite 47, pointer 822d: cloud
; Sprite 48, pointer 9e51: tree piece
; Sprite 49, pointer 8abd: table
; Sprite 4a, pointer 73bf: small lake
; Sprite 4b, pointer 7441: small lake with flower
; Sprite 4c, pointer 9e51: tree piece
; Sprite 4d, pointer 9e51: tree piece
; Sprite 4e, pointer 88bd: square rock
; Sprite 4f, pointer 88bd: square rock
; Sprite 50, pointer 7a9d: witch
; Sprite 51, pointer 7b5f: witch
; Sprite 52, pointer 8609: square box
; Sprite 53, pointer 9395: empty
; Sprite 54, pointer 88bd: square rock
; Sprite 55, pointer 88bd: square rock
; Sprite 56, pointer 7751: dragon
; Sprite 57, pointer 88bd: square rock
; Sprite 58, pointer 88bd: square rock
; Sprite 59, pointer 84ad: spider
; Sprite 5a, pointer 9029: can
; Sprite 5b, pointer 88bd: square rock
; Sprite 5c, pointer 7751: dragon
; Sprite 5d, pointer 7751: dragon
; Sprite 5e, pointer 9395: empty
; Sprite 5f, pointer 9395: empty
; Sprite 60, pointer 9395: empty
; Sprite 61, pointer 9395: empty
; Sprite 62, pointer 9395: empty
; Sprite 63, pointer 9395: empty
; Sprite 64, pointer 9395: empty
; Sprite 65, pointer 9395: empty
; Sprite 66, pointer 9395: empty
; Sprite 67, pointer 9395: empty
; Sprite 68, pointer 9395: empty
; Sprite 69, pointer 9395: empty
; Sprite 6a, pointer 9395: empty
; Sprite 6b, pointer 9395: empty
; Sprite 6c, pointer 9395: empty
; Sprite 6d, pointer 9395: empty
; Sprite 6e, pointer 9395: empty
; Sprite 6f, pointer 9395: empty
; Sprite 70, pointer 8d55: obelisk (broken)
; Sprite 71, pointer 8d55: obelisk (broken)
; Sprite 72, pointer 8d55: obelisk (broken)
; Sprite 73, pointer 8d55: obelisk (broken)
; Sprite 74, pointer 8e8f: obelisk (fixed)
; Sprite 75, pointer 8e8f: obelisk (fixed)
; Sprite 76, pointer 8e8f: obelisk (fixed)
; Sprite 77, pointer 8e8f: obelisk (fixed)
; Sprite 78, pointer 8c13: well
; Sprite 79, pointer 88bd: square rock
; Sprite 7a, pointer 88bd: square rock
; Sprite 7b, pointer 88bd: square rock
; Sprite 7c, pointer 88bd: square rock
; Sprite 7d, pointer 88bd: square rock
; Sprite 7e, pointer 88bd: square rock
; Sprite 7f, pointer 88bd: square rock
; Sprite 80, pointer 6f2f: pentagram
; Sprite 81, pointer 6fc1: pentagram
; Sprite 82, pointer 7053: pentagram
; Sprite 83, pointer 70e5: pentagram
; Sprite 84, pointer 7177: pentagram
; Sprite 85, pointer 7209: pentagram
; Sprite 86, pointer 729b: pentagram
; Sprite 87, pointer 732d: pentagram
; Sprite 88, pointer 88bd: square rock
; Sprite 89, pointer 74c3: destroyed square rock
; Sprite 8a, pointer 759d: more destroyed square rock
; Sprite 8b, pointer 7677: completely destroyed square rock
; Sprite 8c, pointer 88bd: square rock
; Sprite 8d, pointer 88bd: square rock
; Sprite 8e, pointer 88bd: square rock
; Sprite 8f, pointer 88bd: square rock
; Sprite 90, pointer 90bb: amulet
; Sprite 91, pointer 914d: amulet
; Sprite 92, pointer 91df: amulet
; Sprite 93, pointer 9271: amulet
; Sprite 94, pointer 9303: amulet
; Sprite 95, pointer 828f: destroyed amulet
; Sprite 96, pointer 82d1: destroyed amulet
; Sprite 97, pointer 8313: destroyed amulet
; Sprite 98, pointer 90bb: amulet
; Sprite 99, pointer 914d: amulet
; Sprite 9a, pointer 91df: amulet
; Sprite 9b, pointer 9271: amulet
; Sprite 9c, pointer 9303: amulet
; Sprite 9d, pointer 9395: empty
; Sprite 9e, pointer 9395: empty
; Sprite 9f, pointer 9395: empty
; Sprite a0, pointer 7dd1: fat spider
; Sprite a1, pointer 7e8b: fat spider
; Sprite a2, pointer 7dd1: fat spider
; Sprite a3, pointer 7f45: fat spider
; Sprite a4, pointer 7ca1: ghost
; Sprite a5, pointer 7d33: ghost
; Sprite a6, pointer 7ca1: ghost
; Sprite a7, pointer 7c21: ghost
; Sprite a8, pointer 7813: zombie
; Sprite a9, pointer 78ab: zombie
; Sprite aa, pointer 7943: zombie
; Sprite ab, pointer 79f3: zombie
        .wo sprite_9395,sprite_9395,sprite_9a4b,sprite_9add
        .wo sprite_9b3f,sprite_9bd1,sprite_9c63,sprite_9daf
        .wo sprite_a557,sprite_a47d,sprite_9e51,sprite_88bd
        .wo sprite_9f1b,sprite_9fc9,sprite_a09f,sprite_a175
        .wo sprite_84ad,sprite_84ad,sprite_98a5,sprite_9901
        .wo sprite_98a5,sprite_9849,sprite_8877,sprite_8795
        .wo sprite_9395,sprite_9395,sprite_9395,sprite_9395
        .wo sprite_8795,sprite_9849,sprite_86eb,sprite_86eb
        .wo sprite_98a5,sprite_9849,sprite_97ed,sprite_9849
        .wo sprite_996f,sprite_9901,sprite_99dd,sprite_9901
        .wo sprite_94df,sprite_943b,sprite_9397,sprite_943b
        .wo sprite_9651,sprite_9583,sprite_971f,sprite_9583
        .wo sprite_7fff,sprite_809d,sprite_7fff,sprite_809d
        .wo sprite_a327,sprite_a2a9,sprite_a23f,sprite_a3ad
        .wo sprite_a40f,sprite_a67f,sprite_89a7,sprite_89e9
        .wo sprite_8a59,sprite_8a59,sprite_8a9b,sprite_8609
        .wo sprite_813b,sprite_8175,sprite_81c5,sprite_8175
        .wo sprite_81c5,sprite_81c5,sprite_822d,sprite_822d
        .wo sprite_9e51,sprite_8abd,sprite_73bf,sprite_7441
        .wo sprite_9e51,sprite_9e51,sprite_88bd,sprite_88bd
        .wo sprite_7a9d,sprite_7b5f,sprite_8609,sprite_9395
        .wo sprite_88bd,sprite_88bd,sprite_7751,sprite_88bd
        .wo sprite_88bd,sprite_84ad,sprite_9029,sprite_88bd
        .wo sprite_7751,sprite_7751,sprite_9395,sprite_9395
        .wo sprite_9395,sprite_9395,sprite_9395,sprite_9395
        .wo sprite_9395,sprite_9395,sprite_9395,sprite_9395
        .wo sprite_9395,sprite_9395,sprite_9395,sprite_9395
        .wo sprite_9395,sprite_9395,sprite_9395,sprite_9395
        .wo sprite_8d55,sprite_8d55,sprite_8d55,sprite_8d55
        .wo sprite_8e8f,sprite_8e8f,sprite_8e8f,sprite_8e8f
        .wo sprite_8c13,sprite_88bd,sprite_88bd,sprite_88bd
        .wo sprite_88bd,sprite_88bd,sprite_88bd,sprite_88bd
        .wo sprite_6f2f,sprite_6fc1,sprite_7053,sprite_70e5
        .wo sprite_7177,sprite_7209,sprite_729b,sprite_732d
        .wo sprite_88bd,sprite_74c3,sprite_759d,sprite_7677
        .wo sprite_88bd,sprite_88bd,sprite_88bd,sprite_88bd
        .wo sprite_90bb,sprite_914d,sprite_91df,sprite_9271
        .wo sprite_9303,sprite_828f,sprite_82d1,sprite_8313
        .wo sprite_90bb,sprite_914d,sprite_91df,sprite_9271
        .wo sprite_9303,sprite_9395,sprite_9395,sprite_9395
        .wo sprite_7dd1,sprite_7e8b,sprite_7dd1,sprite_7f45
        .wo sprite_7ca1,sprite_7d33,sprite_7ca1,sprite_7c21
        .wo sprite_7813,sprite_78ab,sprite_7943,sprite_79f3
; 172 sprites found

sprite_6f2f
        .he 13,18,48 ; total 72 bytes

; mask equals to data

sprite_6f2f_data
        .he 70,00,00
        .he 70,00,00
        .he 70,00,00
        .he 70,00,00
        .he 38,00,00
        .he 38,00,00
        .he 1c,00,00
        .he 1e,00,00
        .he 0f,00,01
        .he 07,80,03
        .he 03,c0,07
        .he 01,e0,0f
        .he 00,78,1f
        .he 00,3e,3c
        .he 00,0f,a0
        .he 00,03,e0
        .he 00,00,f8
        .he 00,00,3e
        .he 00,00,0f
        .he 00,00,01
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00

sprite_6fc1
        .he 13,18,48 ; total 72 bytes

; mask equals to data

sprite_6fc1_data
        .he 0f,c0,00
        .he 03,80,00
        .he 07,00,00
        .he 0e,00,00
        .he 1e,00,00
        .he 3c,00,0f
        .he 78,00,ff
        .he f0,0f,ff
        .he e0,ff,f8
        .he cf,ff,00
        .he bf,f0,00
        .he fe,00,00
        .he e0,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he c0,00,00
        .he fc,00,00
        .he 3f,f0,00
        .he 03,ff,ff
        .he 00,0f,ff
        .he 00,00,00

sprite_7053
        .he 13,18,48 ; total 72 bytes

; mask equals to data

sprite_7053_data
        .he 00,00,00
        .he 00,00,7f
        .he 00,03,ff
        .he 00,03,f0
        .he 00,01,80
        .he 80,01,c0
        .he e0,00,c0
        .he f8,00,e0
        .he ff,00,60
        .he 1f,c0,70
        .he 07,f0,30
        .he 00,fe,38
        .he 00,3f,98
        .he 00,07,f8
        .he 00,01,fc
        .he 00,00,3c
        .he 00,00,0e
        .he 00,00,01
        .he 00,00,03
        .he 00,00,3f
        .he 00,0f,fc
        .he ff,ff,c0
        .he ff,f0,00
        .he 00,00,00

sprite_70e5
        .he 13,18,48 ; total 72 bytes

; mask equals to data

sprite_70e5_data
        .he ff,c0,0e
        .he fc,00,0e
        .he 80,00,0e
        .he 00,00,0e
        .he 00,00,1c
        .he 00,00,1c
        .he 00,00,38
        .he 00,00,78
        .he 00,00,f0
        .he 00,01,e0
        .he 00,03,c0
        .he 00,07,80
        .he 00,1e,00
        .he 00,7c,00
        .he 01,f0,00
        .he 07,c0,00
        .he 1f,00,00
        .he 7c,00,00
        .he f0,00,00
        .he 80,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00

sprite_7177
        .he 13,18,48 ; total 72 bytes

; mask equals to data

sprite_7177_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,01
        .he 00,00,0f
        .he 00,00,3e
        .he 00,00,f8
        .he 00,03,e0
        .he 00,0f,80
        .he 00,3e,00
        .he 00,78,00
        .he 01,e0,00
        .he 03,c0,00
        .he 07,80,00
        .he 0f,ff,f0
        .he 1e,1f,ff
        .he 1c,07,ff
        .he 38,00,f8
        .he 38,00,3f
        .he 70,00,07
        .he 70,00,01
        .he 70,00,00

sprite_7209
        .he 13,18,48 ; total 72 bytes

; mask equals to data

sprite_7209_data
        .he 00,00,00
        .he 00,00,00
        .he 00,0f,ff
        .he 03,ff,ff
        .he 3f,f0,00
        .he fc,00,00
        .he c0,00,00
        .he 00,00,01
        .he 00,00,03
        .he 00,00,07
        .he 00,00,0f
        .he 00,00,1e
        .he 00,00,3c
        .he 00,00,78
        .he 00,00,f0
        .he 00,01,e0
        .he 00,03,c0
        .he ff,07,80
        .he ff,ff,00
        .he 7f,fe,00
        .he 00,7c,00
        .he e0,00,00
        .he fc,00,00
        .he 3f,00,00

sprite_729b
        .he 13,18,48 ; total 72 bytes

; mask equals to data

sprite_729b_data
        .he 00,00,00
        .he 00,00,00
        .he ff,f0,00
        .he ff,ff,c0
        .he 3e,0f,fc
        .he 7e,00,3f
        .he f7,00,03
        .he e7,00,00
        .he c3,80,00
        .he 83,80,00
        .he 01,80,00
        .he 01,c0,00
        .he 00,c0,00
        .he 00,e0,00
        .he 00,e0,00
        .he 00,70,00
        .he 00,70,00
        .he 00,38,00
        .he 00,38,00
        .he 00,1c,00
        .he 00,1f,f0
        .he 00,0f,ff
        .he 00,00,ff
        .he 00,00,00

sprite_732d
        .he 13,18,48 ; total 72 bytes

; mask equals to data

sprite_732d_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 80,00,00
        .he f0,00,00
        .he 7c,00,00
        .he 1f,00,00
        .he 07,c0,00
        .he 01,f0,00
        .he 00,7c,00
        .he 00,1e,00
        .he 00,07,80
        .he 00,03,c0
        .he 00,01,e0
        .he 00,00,f0
        .he 00,00,78
        .he 00,00,38
        .he 00,00,1c
        .he 00,00,1c
        .he ff,00,0e
        .he ff,ff,fe
        .he 0f,fc,0e

sprite_73bf
        .he 04,10,40 ; total 64 bytes
sprite_73bf_data
        .he 00,05,55,00
        .he 00,2a,aa,80
        .he 01,55,55,40
        .he 00,aa,aa,a8
        .he 15,55,55,54
        .he 2a,aa,aa,aa
        .he 55,55,55,55
        .he aa,aa,aa,aa
        .he 55,55,55,55
        .he aa,aa,aa,aa
        .he 55,55,55,55
        .he 0a,aa,aa,a8
        .he 01,55,55,50
        .he 00,aa,aa,a0
        .he 00,55,54,00
        .he 00,02,a8,00
sprite_73bf_mask
        .he 00,05,55,00
        .he 00,2f,ff,80
        .he 01,7f,ff,c0
        .he 00,ff,ff,e8
        .he 15,ff,ff,fc
        .he 3f,ff,ff,fe
        .he 7f,ff,ff,ff
        .he ff,ff,ff,fe
        .he 7f,ff,ff,ff
        .he ff,ff,ff,fe
        .he 5f,ff,ff,fd
        .he 0b,ff,ff,f8
        .he 01,ff,ff,f0
        .he 00,ff,fe,a0
        .he 00,57,fc,00
        .he 00,03,f8,00

sprite_7441
        .he 04,10,40 ; total 64 bytes
sprite_7441_data
        .he 00,05,54,00
        .he 00,aa,aa,a0
        .he 01,55,55,50
        .he 0a,aa,0a,a8
        .he 15,51,e5,54
        .he 2a,a7,fa,a8
        .he 55,4f,f5,45
        .he aa,93,f2,ba
        .he 55,47,f9,7d
        .he 2a,a5,aa,54
        .he 15,4d,a5,10
        .he 0a,a9,a2,a8
        .he 15,54,a5,50
        .he 0a,aa,8a,a0
        .he 05,54,95,40
        .he 00,2a,28,00
sprite_7441_mask
        .he 00,0f,fc,00
        .he 01,ff,ff,e0
        .he 03,ff,ff,f0
        .he 0f,ff,ff,fc
        .he 3f,ff,ff,fc
        .he 7f,ff,ff,fd
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he 7f,ff,ff,ff
        .he 3f,ff,ff,fe
        .he 1f,ff,ff,fc
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f0
        .he 0f,ff,ff,c0
        .he 00,3f,f8,00

sprite_74c3
        .he 04,1b,6c ; total 108 bytes
sprite_74c3_data
        .he 00,00,00,00
        .he 00,04,00,00
        .he 00,1e,20,00
        .he 00,3e,50,00
        .he 00,3e,20,00
        .he 00,1c,14,00
        .he 03,00,0a,00
        .he 1f,9c,05,00
        .he 3f,cc,a0,02
        .he 3f,cc,10,44
        .he 03,c0,28,82
        .he 01,c1,90,54
        .he 01,c3,c0,a0
        .he 1c,81,e4,54
        .he 3c,0c,f0,a2
        .he 78,3e,00,04
        .he 20,7f,cf,02
        .he 00,1f,9f,00
        .he 03,9f,3e,70
        .he 0f,0c,78,f8
        .he 0f,80,30,e0
        .he 03,00,0e,c0
        .he 00,03,9b,00
        .he 00,3f,b0,00
        .he 00,0f,a0,00
        .he 00,03,00,00
        .he 00,00,00,00
sprite_74c3_mask
        .he 00,04,00,00
        .he 00,1e,20,00
        .he 00,3f,70,00
        .he 00,7f,f8,00
        .he 00,7f,74,00
        .he 03,3e,3e,00
        .he 1f,bc,1f,00
        .he 3f,fd,af,82
        .he 7f,ff,f5,c7
        .he 7f,fe,f8,ee
        .he 3f,ed,fd,df
        .he 1f,e3,f8,fe
        .he 1f,e7,fd,fc
        .he 3f,cf,fe,fe
        .he 7f,ff,f9,f7
        .he fc,7f,ff,ae
        .he 78,ff,ff,87
        .he 23,ff,ff,f2
        .he 0f,ff,ff,f8
        .he 1f,9f,ff,fc
        .he 1f,cc,7f,f8
        .he 0f,83,ff,e0
        .he 03,3f,ff,c0
        .he 00,7f,fb,00
        .he 00,3f,f0,00
        .he 00,0f,a0,00
        .he 00,03,00,00

sprite_759d
        .he 04,1b,6c ; total 108 bytes
sprite_759d_data
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,04,00,00
        .he 00,0c,10,00
        .he 00,18,20,00
        .he 00,00,14,00
        .he 00,00,08,00
        .he 03,04,04,00
        .he 0f,8c,00,00
        .he 03,c0,10,00
        .he 01,c0,28,02
        .he 00,80,10,44
        .he 00,01,c0,20
        .he 08,01,e0,50
        .he 18,00,40,22
        .he 30,08,00,04
        .he 00,1e,00,00
        .he 00,0e,0e,00
        .he 00,04,18,60
        .he 07,00,30,60
        .he 02,00,00,c0
        .he 00,00,0e,00
        .he 00,00,18,00
        .he 00,0f,90,00
        .he 00,03,00,00
        .he 00,00,00,00
sprite_759d_mask
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,04,00,00
        .he 00,0e,10,00
        .he 00,1e,38,00
        .he 00,3c,74,00
        .he 00,18,3e,00
        .he 03,04,1c,00
        .he 0f,8e,0e,00
        .he 1f,de,14,00
        .he 0f,ec,38,02
        .he 03,e0,7c,47
        .he 01,c1,f8,ee
        .he 80,83,f0,74
        .he 1c,03,f0,fa
        .he 3c,09,e0,77
        .he 78,1e,40,2e
        .he 60,3f,0e,04
        .he 00,1f,1f,60
        .he 07,0e,3e,f0
        .he 0f,84,78,f0
        .he 07,00,3f,e0
        .he 02,00,1f,c0
        .he 00,0f,be,00
        .he 00,1f,f8,00
        .he 00,0f,90,00
        .he 00,03,00,00

sprite_7677
        .he 04,1b,6c ; total 108 bytes
sprite_7677_data
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,04,00,00
        .he 00,08,00,00
        .he 00,00,10,00
        .he 00,00,08,00
        .he 02,00,00,00
        .he 07,04,00,00
        .he 01,c0,10,00
        .he 00,80,00,00
        .he 00,00,10,04
        .he 00,00,c0,20
        .he 00,00,c0,40
        .he 18,00,00,20
        .he 10,00,00,00
        .he 00,0c,00,00
        .he 00,04,08,00
        .he 00,00,18,20
        .he 03,00,10,60
        .he 00,00,00,00
        .he 00,00,04,00
        .he 00,00,18,00
        .he 00,03,00,00
        .he 00,00,00,00
sprite_7677_mask
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,04,00,00
        .he 00,0e,00,00
        .he 00,1c,10,00
        .he 00,08,38,00
        .he 02,00,1c,00
        .he 07,04,08,00
        .he 0f,ce,10,00
        .he 07,e4,38,00
        .he 01,c0,10,04
        .he 00,80,f8,2e
        .he 00,01,f0,74
        .he 18,01,e0,e0
        .he 3c,00,c0,70
        .he 38,0c,00,20
        .he 10,1e,08,00
        .he 00,0e,1c,40
        .he 03,04,3c,e0
        .he 07,80,38,f0
        .he 03,00,18,60
        .he 00,00,1c,00
        .he 00,03,3c,00
        .he 00,07,98,00
        .he 00,03,00,00

sprite_7751
        .he 24,18,60 ; total 96 bytes
sprite_7751_data
        .he 00,00,00,00
        .he 00,16,00,00
        .he 00,27,00,00
        .he 03,b1,83,00
        .he 07,00,ce,00
        .he 14,78,7e,f0
        .he 34,ca,3f,c0
        .he 21,cb,1e,80
        .he 1f,fb,cf,c0
        .he 33,f7,ff,f0
        .he 33,0f,ff,e0
        .he 1e,f7,7f,c0
        .he 0d,fb,93,f0
        .he 03,fc,c7,f8
        .he 00,1f,7c,c0
        .he 00,2b,83,c0
        .he 00,13,ff,c0
        .he 00,0d,bd,e0
        .he 00,00,3e,e0
        .he 00,06,9c,70
        .he 00,03,88,38
        .he 00,01,80,00
        .he 00,00,c0,00
        .he 00,00,00,00
sprite_7751_mask
        .he 00,16,00,00
        .he 00,3f,00,00
        .he 03,ff,83,00
        .he 07,ff,cf,80
        .he 1f,ff,ff,f0
        .he 3f,ff,ff,f8
        .he 7f,ff,ff,f0
        .he 7f,ff,ff,c0
        .he 3f,ff,ff,f0
        .he 7f,ff,ff,f8
        .he 7f,ff,ff,f0
        .he 3f,ff,ff,f0
        .he 1f,ff,ff,f8
        .he 0f,ff,ff,fc
        .he 03,ff,ff,f8
        .he 00,7f,ff,e0
        .he 00,3f,ff,e0
        .he 00,1f,ff,f0
        .he 00,0f,ff,f0
        .he 00,0f,fe,f8
        .he 00,07,dc,7c
        .he 00,03,c8,78
        .he 00,01,e0,00
        .he 00,00,c0,00
sprite_hflip_7751
        .he 44,18,60 ; total 96 bytes
sprite_hflip_7751_data
        .he 00,00,00,00
        .he 00,00,68,00
        .he 00,00,e4,00
        .he 00,c1,8d,c0
        .he 00,73,00,e0
        .he 0f,7e,1e,28
        .he 03,fc,53,2c
        .he 01,78,d3,84
        .he 03,f3,df,f8
        .he 0f,ff,ef,cc
        .he 07,ff,f0,cc
        .he 03,fe,ef,78
        .he 0f,c9,df,b0
        .he 1f,e3,3f,c0
        .he 03,3e,f8,00
        .he 03,c1,d4,00
        .he 03,ff,c8,00
        .he 07,bd,b0,00
        .he 07,7c,00,00
        .he 0e,39,60,00
        .he 1c,11,c0,00
        .he 00,01,80,00
        .he 00,03,00,00
        .he 00,00,00,00
sprite_hflip_7751_mask
        .he 00,00,68,00
        .he 00,00,fc,00
        .he 00,c1,ff,c0
        .he 01,f3,ff,e0
        .he 0f,ff,ff,f8
        .he 1f,ff,ff,fc
        .he 0f,ff,ff,fe
        .he 03,ff,ff,fe
        .he 0f,ff,ff,fc
        .he 1f,ff,ff,fe
        .he 0f,ff,ff,fe
        .he 0f,ff,ff,fc
        .he 1f,ff,ff,f8
        .he 3f,ff,ff,f0
        .he 1f,ff,ff,c0
        .he 07,ff,fe,00
        .he 07,ff,fc,00
        .he 0f,ff,f8,00
        .he 0f,ff,f0,00
        .he 1f,7f,f0,00
        .he 3e,3b,e0,00
        .he 1e,13,c0,00
        .he 00,07,80,00
        .he 00,03,00,00

sprite_7813
        .he 03,19,4b ; total 75 bytes
sprite_7813_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,1c,70
        .he 00,0f,3c
        .he 00,07,1c
        .he 00,06,78
        .he 00,05,f0
        .he 00,86,18
        .he 01,47,e8
        .he 00,e7,f0
        .he 11,e9,f0
        .he 28,5e,70
        .he 3d,3f,b0
        .he 1d,df,f8
        .he 03,ef,f8
        .he 0f,ff,f8
        .he 01,f1,e0
        .he 00,7b,f0
        .he 00,1e,70
        .he 00,12,70
        .he 00,13,f0
        .he 00,1f,e0
        .he 00,0f,c0
        .he 00,00,00
sprite_7813_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,1c,70
        .he 00,3f,fc
        .he 00,1f,fe
        .he 00,0f,fe
        .he 00,0f,fc
        .he 00,8f,f8
        .he 01,cf,f8
        .he 03,ef,f8
        .he 11,ff,f8
        .he 3b,ff,f8
        .he 7f,ff,f8
        .he 7f,ff,f8
        .he 3f,ff,fc
        .he 1f,ff,fc
        .he 1f,ff,fc
        .he 0f,ff,f8
        .he 01,ff,f8
        .he 00,7f,f8
        .he 00,3f,f8
        .he 00,3f,f8
        .he 00,3f,f0
        .he 00,1f,e0
        .he 00,0f,c0

sprite_78ab
        .he 03,19,4b ; total 75 bytes
sprite_78ab_data
        .he 00,00,00
        .he 00,06,00
        .he 00,0f,80
        .he 00,07,c0
        .he 00,01,c0
        .he 00,01,e0
        .he 00,00,ec
        .he 00,02,f4
        .he 00,42,10
        .he 00,a3,e8
        .he 00,73,f0
        .he 08,f4,f8
        .he 14,2f,38
        .he 1e,9f,d8
        .he 0c,ef,fc
        .he 01,f7,fc
        .he 07,ff,fc
        .he 00,f8,f0
        .he 00,3d,f8
        .he 00,0f,38
        .he 00,09,38
        .he 00,09,f8
        .he 00,0f,f0
        .he 00,07,e0
        .he 00,00,00
sprite_78ab_mask
        .he 00,06,00
        .he 00,cf,80
        .he 00,1f,c0
        .he 00,0f,e0
        .he 00,07,f0
        .he 00,03,fc
        .he 00,03,fe
        .he 00,47,fe
        .he 00,e7,fc
        .he 01,f7,fc
        .he 08,ff,f8
        .he 1d,ff,fc
        .he 3f,ff,fc
        .he 3f,ff,fc
        .he 1f,ff,fe
        .he 0f,ff,fe
        .he 0f,ff,fe
        .he 07,ff,fc
        .he 00,ff,fc
        .he 00,3f,fc
        .he 00,1f,fc
        .he 00,1f,fc
        .he 00,1f,f8
        .he 00,0f,f0
        .he 00,07,e0

sprite_7943
        .he 03,1d,57 ; total 87 bytes
sprite_7943_data
        .he 00,00,00
        .he 00,c0,00
        .he 01,f0,00
        .he 01,f0,00
        .he 00,c0,00
        .he 02,c0,00
        .he 06,e0,00
        .he 06,e0,00
        .he 0f,ec,00
        .he 1f,f4,00
        .he 18,70,00
        .he 07,90,00
        .he 1f,e0,00
        .he 3f,e0,00
        .he 3f,e0,00
        .he 3f,f0,00
        .he 3f,fc,00
        .he 38,7f,00
        .he 37,bf,c0
        .he 2f,df,e0
        .he 1f,ef,e8
        .he 3f,f1,ec
        .he 3f,f6,52
        .he 1f,ef,18
        .he 0f,c6,c0
        .he 07,81,40
        .he 00,01,00
        .he 00,00,80
        .he 00,00,00
sprite_7943_mask
        .he 00,c0,00
        .he 01,f0,00
        .he 03,f8,00
        .he 03,f8,00
        .he 03,f0,00
        .he 07,e0,00
        .he 0f,f0,00
        .he 0f,fc,00
        .he 1f,fe,00
        .he 3f,fe,00
        .he 3f,fc,00
        .he 1f,f8,00
        .he 3f,f0,00
        .he 7f,f0,00
        .he 7f,f0,00
        .he 7f,fc,00
        .he 7f,ff,00
        .he 7f,ff,c0
        .he 7f,ff,e0
        .he 7f,ff,f8
        .he 3f,ff,fc
        .he 7f,ff,fe
        .he 7f,ff,ff
        .he 3f,ff,fe
        .he 1f,ef,f8
        .he 0f,c7,e0
        .he 07,83,c0
        .he 00,01,c0
        .he 00,00,80

sprite_79f3
        .he 03,1c,54 ; total 84 bytes
sprite_79f3_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 18,00,00
        .he 1e,0c,00
        .he 1f,1e,00
        .he 1d,9f,80
        .he 0c,7f,00
        .he 0d,fc,00
        .he 0b,f8,00
        .he 0c,30,00
        .he 03,c0,00
        .he 0f,f0,00
        .he 1f,f0,00
        .he 1f,f0,00
        .he 1f,f8,00
        .he 1f,fe,00
        .he 1c,3f,80
        .he 1b,df,e0
        .he 17,ef,f0
        .he 0f,f3,f4
        .he 1f,f8,f6
        .he 1f,fb,2a
        .he 0f,f7,8c
        .he 07,e3,60
        .he 03,c0,a0
        .he 00,00,40
        .he 00,00,00
sprite_79f3_mask
        .he 00,00,00
        .he 00,00,00
        .he 18,00,00
        .he 3e,0c,00
        .he 3f,9e,00
        .he 3f,df,80
        .he 3f,ff,c0
        .he 1f,ff,80
        .he 1f,ff,00
        .he 1f,fc,00
        .he 1f,f8,00
        .he 0f,f0,00
        .he 1f,f8,00
        .he 3f,f8,00
        .he 3f,f8,00
        .he 3f,fe,00
        .he 3f,ff,80
        .he 3f,ff,e0
        .he 3f,ff,f0
        .he 3f,ff,fc
        .he 1f,ff,fe
        .he 3f,ff,ff
        .he 3f,ff,ff
        .he 1f,ff,fe
        .he 0f,f7,fc
        .he 07,e3,f0
        .he 03,c0,e0
        .he 00,00,40

sprite_7a9d
        .he 04,18,60 ; total 96 bytes
sprite_7a9d_data
        .he 00,00,00,00
        .he 00,02,00,10
        .he 00,19,e0,28
        .he 00,00,ef,f8
        .he 00,74,c1,c0
        .he 1f,e8,de,b8
        .he 1f,8c,ff,70
        .he 00,6c,3f,88
        .he 00,16,ff,b8
        .he 00,66,ff,80
        .he 00,7b,ff,80
        .he 00,0d,ff,80
        .he 00,76,ff,80
        .he 00,12,bf,00
        .he 00,a8,be,00
        .he 00,83,00,00
        .he 00,7c,80,00
        .he 00,13,80,00
        .he 00,0f,80,00
        .he 00,07,80,00
        .he 00,03,80,00
        .he 00,01,80,00
        .he 00,00,80,00
        .he 00,00,00,00
sprite_7a9d_mask
        .he 00,02,00,10
        .he 00,1f,e0,38
        .he 00,3f,ff,fc
        .he 00,7f,ff,fc
        .he 1f,ff,ff,f8
        .he bf,ff,ff,fc
        .he 3f,ff,ff,f8
        .he 1f,ff,ff,fc
        .he 00,7f,ff,fc
        .he 00,ff,ff,f8
        .he 00,ff,ff,c0
        .he 00,7f,ff,c0
        .he 00,ff,ff,c0
        .he 00,ff,ff,80
        .he 01,ff,ff,00
        .he 01,ff,ff,00
        .he 00,ff,c0,00
        .he 00,7f,c0,00
        .he 00,1f,c0,00
        .he 00,0f,c0,00
        .he 00,07,c0,00
        .he 00,03,c0,00
        .he 00,01,c0,00
        .he 00,00,80,00

sprite_7b5f
        .he 04,18,60 ; total 96 bytes
sprite_7b5f_data
        .he 00,00,00,00
        .he 00,40,00,00
        .he 00,a0,00,00
        .he 05,f0,00,00
        .he 0a,4c,00,00
        .he 0f,bf,00,00
        .he 05,7f,cc,00
        .he 0e,ff,ef,00
        .he 02,ff,ed,80
        .he 00,ff,fc,00
        .he 00,ff,fe,00
        .he 00,ff,fe,00
        .he 00,7f,e0,00
        .he 00,7f,fc,00
        .he 00,3f,87,c0
        .he 00,1f,78,00
        .he 00,06,fc,70
        .he 00,01,8e,bc
        .he 00,01,76,8e
        .he 00,00,fa,02
        .he 00,03,fa,00
        .he 00,0f,f6,00
        .he 00,1e,0c,00
        .he 00,00,00,00
sprite_7b5f_mask
        .he 00,40,00,00
        .he 00,e0,00,00
        .he 05,f0,00,00
        .he 0f,fc,00,00
        .he 1f,ff,00,00
        .he 1f,ff,cc,00
        .he 0f,ff,ff,00
        .he 1f,ff,ff,80
        .he 0f,ff,ff,c0
        .he 03,ff,ff,80
        .he 01,ff,ff,00
        .he 01,ff,ff,00
        .he 00,ff,fe,00
        .he 00,ff,ff,e0
        .he 00,7f,ff,f0
        .he 00,3f,ff,f0
        .he 00,1f,ff,fc
        .he 00,07,ff,fe
        .he 00,03,ff,ff
        .he 00,03,ff,8f
        .he 00,0f,ff,02
        .he 00,1f,ff,00
        .he 00,3f,fe,00
        .he 00,1e,0c,00

sprite_7c21
        .he 03,15,3f ; total 63 bytes
sprite_7c21_data
        .he 00,00,00
        .he 00,ff,00
        .he 03,ff,c0
        .he 0f,ff,f0
        .he 3f,ff,f8
        .he 7f,ff,fc
        .he 71,ff,fe
        .he 60,ff,fe
        .he 60,7f,fe
        .he 30,7f,fe
        .he 18,3f,fc
        .he 0e,3f,f8
        .he 07,3f,f0
        .he 03,1f,e0
        .he 03,9f,c0
        .he 01,cf,80
        .he 01,ff,80
        .he 00,ff,00
        .he 00,7e,00
        .he 00,38,00
        .he 00,00,00
sprite_7c21_mask
        .he 00,ff,00
        .he 03,ff,c0
        .he 0f,ff,f0
        .he 3f,ff,f8
        .he 7f,ff,fc
        .he ff,ff,fe
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he 7f,ff,ff
        .he 3f,ff,fe
        .he 1f,ff,fc
        .he 0f,ff,f8
        .he 07,ff,f0
        .he 07,ff,e0
        .he 03,ff,c0
        .he 03,ff,c0
        .he 01,ff,80
        .he 00,ff,00
        .he 00,7e,00
        .he 00,38,00

sprite_7ca1
        .he 03,18,48 ; total 72 bytes
sprite_7ca1_data
        .he 00,00,00
        .he 00,3c,00
        .he 01,ff,80
        .he 07,ff,e0
        .he 0f,ff,f0
        .he 1f,ff,f8
        .he 19,ff,f8
        .he 30,ff,fc
        .he 30,ff,fc
        .he 18,7f,f8
        .he 1c,7f,f8
        .he 0c,7f,f0
        .he 0e,7f,f0
        .he 06,7f,e0
        .he 06,3f,e0
        .he 07,3f,e0
        .he 03,3f,c0
        .he 03,bf,c0
        .he 03,bf,c0
        .he 01,ff,80
        .he 01,ff,80
        .he 00,ff,00
        .he 00,7e,00
        .he 00,00,00
sprite_7ca1_mask
        .he 00,3c,00
        .he 01,ff,80
        .he 07,ff,e0
        .he 0f,ff,f0
        .he 1f,ff,f8
        .he 3f,ff,fc
        .he 3f,ff,fc
        .he 7f,ff,ff
        .he 7f,ff,fe
        .he 3f,ff,fc
        .he 3f,ff,fc
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 0f,ff,f0
        .he 0f,ff,f0
        .he 0f,ff,f0
        .he 07,ff,e0
        .he 07,ff,e0
        .he 07,ff,e0
        .he 03,ff,c0
        .he 03,ff,c0
        .he 01,ff,80
        .he 00,ff,00
        .he 00,7e,00

sprite_7d33
        .he 03,1a,4e ; total 78 bytes
sprite_7d33_data
        .he 00,00,00
        .he 00,3c,00
        .he 01,ff,80
        .he 03,ff,c0
        .he 07,ff,e0
        .he 0e,ff,f0
        .he 0c,ff,f0
        .he 08,ff,f0
        .he 08,ff,f0
        .he 0c,7f,f0
        .he 0c,7f,f0
        .he 0e,7f,f0
        .he 06,3f,e0
        .he 07,3f,e0
        .he 03,3f,c0
        .he 03,3f,c0
        .he 01,3f,80
        .he 01,3f,80
        .he 01,bf,80
        .he 01,bf,80
        .he 00,9f,00
        .he 00,df,00
        .he 00,df,00
        .he 00,7e,00
        .he 00,3c,00
        .he 00,00,00
sprite_7d33_mask
        .he 00,3c,00
        .he 01,ff,80
        .he 03,ff,c0
        .he 07,ff,e0
        .he 0f,ff,f0
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 0f,ff,f0
        .he 0f,ff,f0
        .he 07,ff,e0
        .he 07,ff,e0
        .he 03,ff,c0
        .he 03,ff,c0
        .he 03,ff,c0
        .he 03,ff,c0
        .he 01,ff,80
        .he 01,ff,80
        .he 01,ff,80
        .he 00,ff,00
        .he 00,7e,00
        .he 00,3c,00

sprite_7dd1
        .he 04,17,5c ; total 92 bytes
sprite_7dd1_data
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,00,04,00
        .he 00,00,0c,00
        .he 00,00,0c,00
        .he 00,00,1c,00
        .he 00,00,1c,04
        .he 00,00,38,0c
        .he 00,07,78,18
        .he 00,3e,f0,78
        .he 40,ff,6b,f0
        .he 78,7f,9b,e0
        .he 3f,bf,fd,80
        .he 1f,bf,fe,02
        .he 03,7f,ff,de
        .he 04,ff,ff,dc
        .he 43,ff,ff,d0
        .he 7d,ff,ff,80
        .he 3e,ff,ff,00
        .he 1f,3f,fc,00
        .he 00,87,e0,00
        .he 00,f8,00,00
        .he 00,00,00,00
sprite_7dd1_mask
        .he 00,00,00,00
        .he 00,00,04,00
        .he 00,00,0e,00
        .he 00,00,1e,00
        .he 00,00,1e,00
        .he 00,00,3e,04
        .he 00,00,3e,0e
        .he 00,07,7c,1e
        .he 00,3f,fc,7c
        .he 40,ff,fb,fc
        .he f9,ff,ff,f8
        .he ff,ff,ff,f0
        .he 7f,ff,ff,e2
        .he 3f,ff,ff,df
        .he 1f,ff,ff,ff
        .he 4f,ff,ff,fe
        .he ff,ff,ff,fc
        .he ff,ff,ff,d0
        .he 7f,ff,ff,80
        .he 3f,ff,ff,00
        .he 1f,ff,fc,00
        .he 01,ff,e0,00
        .he 00,f8,00,00

sprite_7e8b
        .he 04,17,5c ; total 92 bytes
sprite_7e8b_data
        .he 00,00,00,00
        .he 00,00,10,00
        .he 00,00,10,00
        .he 00,00,18,00
        .he 00,00,18,00
        .he 00,00,38,00
        .he 00,00,38,00
        .he 00,00,78,00
        .he 00,07,70,06
        .he 40,3e,f0,1c
        .he 70,ff,6b,fc
        .he 3e,7f,9b,f8
        .he 1f,bf,fd,e4
        .he 0f,bf,fe,0c
        .he 03,7f,ff,d8
        .he 04,ff,ff,d8
        .he 03,ff,ff,d0
        .he 0d,ff,ff,00
        .he 7e,ff,ff,00
        .he 0f,3f,fc,00
        .he 00,c7,e0,00
        .he 00,38,00,00
        .he 00,00,00,00
sprite_7e8b_mask
        .he 00,00,10,00
        .he 00,00,38,00
        .he 00,00,38,00
        .he 00,00,3c,00
        .he 00,00,3c,00
        .he 00,00,7c,00
        .he 00,00,7c,00
        .he 00,07,fc,06
        .he 40,3f,f8,1f
        .he f0,ff,fb,fe
        .he ff,ff,ff,fe
        .he 7f,ff,ff,fc
        .he 3f,ff,ff,fe
        .he 1f,ff,ff,fe
        .he 0f,ff,ff,fc
        .he 0f,ff,ff,fc
        .he 0f,ff,ff,f8
        .he 7f,ff,ff,d0
        .he ff,ff,ff,80
        .he 7f,ff,ff,00
        .he 0f,ff,fc,00
        .he 00,ff,e0,00
        .he 00,38,00,00

sprite_7f45
        .he 04,17,5c ; total 92 bytes
sprite_7f45_data
        .he 00,00,00,00
        .he 00,00,00,00
        .he 00,00,01,00
        .he 00,00,03,08
        .he 00,00,07,18
        .he 00,00,0e,18
        .he 00,00,1e,38
        .he 00,07,7c,78
        .he 00,3e,f9,f0
        .he 00,ff,73,e0
        .he 40,7f,8b,c0
        .he 7f,bf,fd,80
        .he 3f,bf,fe,00
        .he 0f,7f,ff,d2
        .he 40,ff,ff,de
        .he 73,ff,ff,dc
        .he 3d,ff,ff,80
        .he 1e,ff,ff,00
        .he 07,3f,fc,00
        .he 00,c7,e0,00
        .he 01,f8,00,00
        .he 00,e0,00,00
        .he 00,00,00,00
sprite_7f45_mask
        .he 00,00,00,00
        .he 00,00,01,00
        .he 00,00,03,88
        .he 00,00,07,9c
        .he 00,00,0f,bc
        .he 00,00,1f,3c
        .he 00,07,7f,7c
        .he 00,3f,ff,fc
        .he 00,ff,ff,f8
        .he 41,ff,ff,f0
        .he ff,ff,ff,e0
        .he ff,ff,ff,c0
        .he 7f,ff,ff,d2
        .he 7f,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he 7f,ff,ff,dc
        .he 3f,ff,ff,80
        .he 1f,ff,ff,00
        .he 07,ff,fc,00
        .he 03,ff,e0,00
        .he 01,f8,00,00
        .he 00,e0,00,00

sprite_7fff
        .he 03,1a,4e ; total 78 bytes
sprite_7fff_data
        .he 00,00,00
        .he 00,06,00
        .he 00,0e,00
        .he 00,1c,00
        .he 00,1c,00
        .he 00,1e,04
        .he 00,3e,04
        .he 00,7e,0a
        .he 20,ff,0a
        .he 20,ff,0a
        .he 20,ff,0a
        .he 30,ff,12
        .he 30,ff,32
        .he 38,ff,f2
        .he 38,ff,f2
        .he 3c,fb,f2
        .he 3f,d3,f2
        .he 3f,91,fa
        .he 3f,91,fa
        .he 3f,91,be
        .he 3f,93,0e
        .he 3e,9b,00
        .he 3c,ff,00
        .he 3c,7e,00
        .he 18,3c,00
        .he 00,00,00
sprite_7fff_mask
        .he 00,06,00
        .he 00,0f,00
        .he 00,1f,00
        .he 00,3e,00
        .he 00,3e,04
        .he 00,3f,0e
        .he 00,7f,0e
        .he 20,ff,1f
        .he 71,ff,9f
        .he 71,ff,9f
        .he 71,ff,9f
        .he 79,ff,bf
        .he 79,ff,ff
        .he 7d,ff,ff
        .he 7d,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,bf
        .he 7f,ff,8e
        .he 7f,ff,80
        .he 7d,ff,00
        .he 3c,7e,00
        .he 18,3c,00

sprite_809d
        .he 03,1a,4e ; total 78 bytes
sprite_809d_data
        .he 00,00,00
        .he 00,10,00
        .he 00,38,00
        .he 00,1c,00
        .he 00,0e,04
        .he 00,0e,04
        .he 00,1e,0a
        .he 20,3e,0a
        .he 20,7e,0a
        .he 20,ff,0a
        .he 30,ff,1a
        .he 30,ff,32
        .he 38,ff,72
        .he 38,ff,f2
        .he 3c,ff,f2
        .he 3e,fb,f2
        .he 3f,d3,f2
        .he 3f,91,fa
        .he 3f,91,fa
        .he 3f,91,0e
        .he 3f,93,00
        .he 3e,9b,00
        .he 3c,ff,00
        .he 18,7e,00
        .he 00,3c,00
        .he 00,00,00
sprite_809d_mask
        .he 00,10,00
        .he 00,38,00
        .he 00,7c,00
        .he 00,3e,04
        .he 00,1f,0e
        .he 00,1f,0e
        .he 20,3f,1f
        .he 70,7f,1f
        .he 70,ff,1f
        .he 71,ff,9f
        .he 79,ff,bf
        .he 79,ff,ff
        .he 7d,ff,ff
        .he 7d,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,8e
        .he 7f,ff,80
        .he 7f,ff,80
        .he 3c,ff,00
        .he 18,7e,00
        .he 00,3c,00

sprite_813b
        .he 02,0e,1c ; total 28 bytes
sprite_813b_data
        .he 00,00
        .he 03,e0
        .he 07,f0
        .he 07,ec
        .he 1f,fe
        .he 3f,fe
        .he 3d,9e
        .he 1e,5c
        .he 3f,de
        .he 3d,e6
        .he 1b,fe
        .he 01,dc
        .he 00,c0
        .he 00,00
sprite_813b_mask
        .he 03,e0
        .he 07,f0
        .he 0f,fc
        .he 1f,fe
        .he 3f,ff
        .he 7f,ff
        .he 7f,ff
        .he 3f,fe
        .he 7f,ff
        .he 7f,ff
        .he 3f,ff
        .he 1b,fe
        .he 01,fc
        .he 00,c0

sprite_8175
        .he 03,0d,27 ; total 39 bytes
sprite_8175_data
        .he 00,00,00
        .he 00,fc,00
        .he 01,fb,c0
        .he 3b,ff,e0
        .he 7f,ff,f0
        .he 7f,fb,f0
        .he 7d,e5,c0
        .he 7e,1d,f0
        .he 3f,fe,78
        .he 07,ff,f8
        .he 0f,fb,f0
        .he 06,f0,e0
        .he 00,00,00
sprite_8175_mask
        .he 00,fc,00
        .he 01,ff,c0
        .he 3b,ff,e0
        .he 7f,ff,f0
        .he ff,ff,f8
        .he ff,ff,f8
        .he ff,ff,f0
        .he ff,ff,f8
        .he 7f,ff,fc
        .he 3f,ff,fc
        .he 1f,ff,f8
        .he 0f,fb,f0
        .he 06,f0,e0

sprite_81c5
        .he 03,11,33 ; total 51 bytes
sprite_81c5_data
        .he 00,00,00
        .he 01,f8,00
        .he 07,ff,00
        .he 0f,ff,bc
        .he 0f,ff,fe
        .he 3f,ff,fe
        .he 7f,7c,fe
        .he 7f,81,fe
        .he 7f,c1,fc
        .he 7d,80,78
        .he 3d,e3,fc
        .he 7d,f7,fe
        .he 63,ff,fe
        .he 7f,ff,fe
        .he 3b,fd,fc
        .he 01,f0,f0
        .he 00,00,00
sprite_81c5_mask
        .he 01,f8,00
        .he 07,ff,00
        .he 0f,ff,bc
        .he 1f,ff,fe
        .he 3f,ff,ff
        .he 7f,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,fe
        .he ff,ff,fc
        .he 7f,ff,fe
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he 7f,ff,fe
        .he 3b,fd,fc
        .he 01,f0,f0

sprite_822d
        .he 03,10,30 ; total 48 bytes
sprite_822d_data
        .he 00,00,00
        .he 3f,00,f8
        .he 7f,81,fc
        .he 7e,00,38
        .he 3c,00,00
        .he 00,00,00
        .he 00,00,0c
        .he 00,00,1e
        .he 00,00,1e
        .he 18,00,1e
        .he 3c,00,1e
        .he 2c,00,04
        .he 24,3c,08
        .he 3c,3e,00
        .he 18,1c,00
        .he 00,00,00
sprite_822d_mask
        .he 3f,00,f8
        .he 7f,81,fc
        .he ff,c3,fe
        .he ff,81,fc
        .he 7e,00,38
        .he 3c,00,0c
        .he 00,00,1e
        .he 00,00,3f
        .he 18,00,3f
        .he 3c,00,3f
        .he 7e,00,3f
        .he 7e,3c,1e
        .he 7e,7e,1c
        .he 7e,7f,08
        .he 3c,3e,00
        .he 18,1c,00

sprite_828f
        .he 02,10,20 ; total 32 bytes
sprite_828f_data
        .he 00,00
        .he 08,00
        .he 1c,40
        .he 08,04
        .he 27,0e
        .he 0b,c4
        .he 1c,a0
        .he 0d,b0
        .he 5a,54
        .he 05,f0
        .he 01,a8
        .he 09,40
        .he 00,00
        .he 10,10
        .he 19,00
        .he 00,00
sprite_828f_mask
        .he 08,00
        .he 1c,40
        .he 3e,e4
        .he 3f,4e
        .he 7f,df
        .he 3f,fe
        .he 3f,f4
        .he 5f,fc
        .he ff,fe
        .he 5f,fc
        .he 0f,fc
        .he 1f,f8
        .he 19,50
        .he 39,38
        .he 3f,90
        .he 19,00

sprite_82d1
        .he 02,10,20 ; total 32 bytes
sprite_82d1_data
        .he 00,00
        .he 08,00
        .he 00,20
        .he 01,00
        .he 20,08
        .he 33,a0
        .he 06,c0
        .he 0d,62
        .he 06,f0
        .he 4a,e0
        .he 03,88
        .he 03,5c
        .he 09,88
        .he 1c,00
        .he 08,40
        .he 00,00
sprite_82d1_mask
        .he 08,00
        .he 1c,20
        .he 09,70
        .he 23,a8
        .he 73,bc
        .he 7f,f8
        .he 3f,e2
        .he 1f,ff
        .he 4f,fa
        .he ff,f8
        .he 4f,fc
        .he 0f,fe
        .he 1f,dc
        .he 3f,c8
        .he 1c,e0
        .he 08,40

sprite_8313
        .he 02,10,20 ; total 32 bytes
sprite_8313_data
        .he 00,00
        .he 08,40
        .he 00,68
        .he 03,00
        .he 01,d0
        .he 27,ba
        .he 05,d0
        .he 0f,b0
        .he 32,d4
        .he 33,b0
        .he 01,60
        .he 02,32
        .he 08,80
        .he 00,08
        .he 01,00
        .he 00,00
sprite_8313_mask
        .he 08,40
        .he 1c,e8
        .he 0b,fc
        .he 07,f8
        .he 27,fa
        .he 7f,ff
        .he 3f,fa
        .he 3f,fc
        .he 7f,fe
        .he 7f,fc
        .he 3f,f2
        .he 0f,ff
        .he 1f,fa
        .he 09,9c
        .he 03,88
        .he 01,00

sprite_84ad
        .he 24,12,48 ; total 72 bytes
sprite_84ad_data
        .he 00,00,00,00
        .he 00,00,18,00
        .he 00,00,18,00
        .he 00,30,10,30
        .he 00,38,30,30
        .he 00,18,30,60
        .he 18,0c,30,e0
        .he 1e,06,30,c0
        .he 07,86,31,c6
        .he 01,c3,37,8e
        .he 00,73,17,98
        .he 00,3c,e1,b0
        .he 01,9d,ae,60
        .he 01,d9,47,e0
        .he 00,60,33,c0
        .he 00,1d,b1,80
        .he 00,0d,80,00
        .he 00,00,30,00
sprite_84ad_mask
        .he 00,00,18,00
        .he 00,00,3c,00
        .he 00,30,3c,30
        .he 00,78,38,78
        .he 00,7c,78,78
        .he 18,3c,78,f0
        .he 3e,1e,79,f0
        .he 3f,8f,79,e6
        .he 1f,cf,7f,ef
        .he 07,f7,ff,df
        .he 01,ff,ff,fe
        .he 01,ff,ff,f8
        .he 03,ff,ff,f0
        .he 03,ff,ff,f0
        .he 01,ff,ff,e0
        .he 00,7f,fb,c0
        .he 00,1f,f1,80
        .he 00,0d,f8,00
sprite_hflip_84ad
        .he 44,12,48 ; total 72 bytes
sprite_hflip_84ad_data
        .he 00,00,00,00
        .he 00,18,00,00
        .he 00,18,00,00
        .he 0c,08,0c,00
        .he 0c,0c,1c,00
        .he 06,0c,18,00
        .he 07,0c,30,18
        .he 03,0c,60,78
        .he 63,8c,61,e0
        .he 71,ec,c3,80
        .he 19,e8,ce,00
        .he 0d,87,3c,00
        .he 06,75,b9,80
        .he 07,e2,9b,80
        .he 03,cc,06,00
        .he 01,8d,b8,00
        .he 00,01,b0,00
        .he 00,0c,00,00
sprite_hflip_84ad_mask
        .he 00,18,00,00
        .he 00,3c,00,00
        .he 0c,3c,0c,00
        .he 1e,1c,1e,00
        .he 1e,1e,3e,00
        .he 0f,1e,3c,18
        .he 0f,9e,78,7c
        .he 67,9e,f1,fc
        .he f7,fe,f3,f8
        .he fb,ff,ef,e0
        .he 7f,ff,ff,80
        .he 1f,ff,ff,80
        .he 0f,ff,ff,c0
        .he 0f,ff,ff,c0
        .he 07,ff,ff,80
        .he 03,df,fe,00
        .he 01,8f,f8,00
        .he 00,1f,b0,00

sprite_8609
        .he 04,1c,70 ; total 112 bytes
sprite_8609_data
        .he 00,00,00,00
        .he 00,01,80,00
        .he 00,07,e0,00
        .he 00,1b,d8,00
        .he 00,7b,de,00
        .he 01,fb,df,80
        .he 07,fb,df,e0
        .he 0f,fb,df,f0
        .he 0f,fb,df,f0
        .he 0f,fb,df,f0
        .he 0f,fb,df,f0
        .he 0f,fb,df,f0
        .he 0f,ff,ff,f0
        .he 0f,f8,1f,f0
        .he 0f,e7,e7,f0
        .he 0f,9f,f9,f0
        .he 0e,7f,fe,70
        .he 09,ff,ff,90
        .he 07,ff,ff,e0
        .he 0f,ff,ff,f0
        .he 0f,ff,ff,f0
        .he 0f,ff,ff,f0
        .he 07,ff,ff,e0
        .he 01,ff,ff,80
        .he 00,7f,fe,00
        .he 00,1f,f8,00
        .he 00,07,e0,00
        .he 00,00,00,00
sprite_8609_mask
        .he 00,03,c0,00
        .he 00,0f,f0,00
        .he 00,3f,fc,00
        .he 00,ff,ff,00
        .he 03,ff,ff,c0
        .he 0f,ff,ff,f0
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 0f,ff,ff,f0
        .he 03,ff,ff,c0
        .he 00,ff,ff,00
        .he 00,3f,fc,00
        .he 00,0f,f0,00

sprite_86eb
        .he 04,15,54 ; total 84 bytes
sprite_86eb_data
        .he 00,00,00,00
        .he 00,1e,00,00
        .he 00,ff,e1,80
        .he 07,ff,f3,c0
        .he 0f,b6,8b,e0
        .he 1d,12,3d,e0
        .he 35,00,c6,c0
        .he 34,03,3f,40
        .he 30,0c,fe,e0
        .he 30,33,f8,60
        .he 30,cf,e0,50
        .he 39,3f,80,70
        .he 2e,fe,00,60
        .he 0b,f8,00,e0
        .he 03,e0,01,e0
        .he 01,d8,07,a0
        .he 00,0f,ff,80
        .he 00,0d,fd,80
        .he 00,09,d9,00
        .he 00,00,88,00
        .he 00,00,00,00
sprite_86eb_mask
        .he 00,1e,00,00
        .he 00,ff,e1,80
        .he 07,ff,f3,c0
        .he 0f,ff,ff,e0
        .he 1f,ff,ff,f0
        .he 3f,bf,ff,f0
        .he 7f,93,ff,e0
        .he 7f,0f,ff,e0
        .he 7c,3f,ff,f0
        .he 78,ff,fe,f0
        .he 79,ff,f8,f8
        .he 7f,ff,e0,f8
        .he 7f,ff,80,f0
        .he 3f,fe,01,f0
        .he 0f,f8,07,f0
        .he 03,ff,ff,f0
        .he 01,df,ff,e0
        .he 00,1f,ff,c0
        .he 00,1f,ff,80
        .he 00,09,dd,00
        .he 00,00,88,00

sprite_8795
        .he 04,1c,70 ; total 112 bytes
sprite_8795_data
        .he 00,00,00,00
        .he 00,01,80,00
        .he 00,07,e0,00
        .he 00,1e,78,00
        .he 00,79,9e,00
        .he 01,e7,e7,80
        .he 07,9d,f9,e0
        .he 1f,7d,be,78
        .he 79,ed,ad,9e
        .he 67,6d,ad,e6
        .he 1f,6d,ad,f8
        .he 7f,ad,6b,fe
        .he 5d,ad,6b,ba
        .he 1d,dd,6b,b8
        .he 0d,fd,77,b8
        .he 0d,6e,fe,b8
        .he 0d,6f,fc,b0
        .he 08,6d,b6,30
        .he 08,6d,b6,10
        .he 08,65,a6,10
        .he 08,41,86,10
        .he 08,41,82,00
        .he 00,40,82,00
        .he 00,40,82,00
        .he 00,00,80,00
        .he 00,00,80,00
        .he 00,00,80,00
        .he 00,00,00,00
sprite_8795_mask
        .he 00,01,80,00
        .he 00,07,e0,00
        .he 00,1f,f8,00
        .he 00,7f,fe,00
        .he 01,ff,ff,80
        .he 07,ff,ff,e0
        .he 1f,ff,ff,f8
        .he 7e,ff,ff,fe
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he 7f,ff,ff,fe
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1d,ff,ff,f8
        .he 1c,ff,ff,38
        .he 1c,ff,ff,3b
        .he 1c,e7,ef,38
        .he 1c,e3,c7,10
        .he 08,e1,c7,00
        .he 00,e1,c7,00
        .he 00,41,c2,00
        .he 00,01,c0,00
        .he 00,01,c0,00
        .he 00,00,80,00

sprite_8877
        .he 02,11,22 ; total 34 bytes
sprite_8877_data
        .he 00,00
        .he 0e,38
        .he 0b,78
        .he 05,70
        .he 03,60
        .he 03,e0
        .he 0d,f8
        .he 0d,f8
        .he 0d,f8
        .he 0d,f8
        .he 0e,38
        .he 05,d0
        .he 02,e0
        .he 02,e0
        .he 02,e0
        .he 01,40
        .he 00,00
sprite_8877_mask
        .he 0e,38
        .he 1f,7c
        .he 1f,fc
        .he 0f,f8
        .he 0e,f0
        .he 0f,f8
        .he 1f,fc
        .he 1f,fc
        .he 1f,fc
        .he 1f,fc
        .he 1f,fc
        .he 0f,f8
        .he 07,f0
        .he 07,f0
        .he 07,f0
        .he 03,e0
        .he 01,c0

sprite_88bd
        .he 04,1d,74 ; total 116 bytes
sprite_88bd_data
        .he 00,00,00,00
        .he 00,01,80,00
        .he 00,1e,40,00
        .he 00,3e,a0,00
        .he 00,7e,50,00
        .he 00,fe,a2,80
        .he 06,3e,55,40
        .he 0f,de,aa,a0
        .he 7f,de,15,54
        .he 7f,de,aa,a2
        .he 7f,ce,54,54
        .he 7f,ee,28,82
        .he 73,e8,94,54
        .he 0d,f7,ca,a2
        .he 7d,ef,e4,54
        .he 7d,1f,fc,a2
        .he 7c,ff,fe,04
        .he 79,ff,ff,e2
        .he 43,ff,ff,f4
        .he 1f,ff,ff,f8
        .he 7f,ff,ff,fe
        .he 1f,ff,ff,f8
        .he 0f,ff,ff,e0
        .he 03,ff,ff,c0
        .he 00,7f,f8,00
        .he 00,3f,f0,00
        .he 00,1f,e0,00
        .he 00,07,c0,00
        .he 00,00,00,00
sprite_88bd_mask
        .he 00,01,80,00
        .he 00,1f,e0,00
        .he 00,3f,f0,00
        .he 00,7f,f8,00
        .he 00,ff,ff,80
        .he 07,ff,ff,e0
        .he 0f,ff,ff,f0
        .he 7f,ff,ff,fe
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he 7f,ff,ff,fe
        .he 1f,ff,ff,f8
        .he 0f,ff,ff,e0
        .he 03,ff,ff,c0
        .he 00,7f,f8,00
        .he 00,3f,f0,00
        .he 00,1f,e0,00
        .he 00,07,c0,00

sprite_89a7
        .he 12,10,20 ; total 32 bytes

; mask equals to data

sprite_89a7_data
        .he 0d,f5
        .he 13,80
        .he 1e,00
        .he 0b,e0
        .he 1e,18
        .he 16,06
        .he 1b,80
        .he 1e,00
        .he 0e,00
        .he 0f,d0
        .he 0f,00
        .he 07,80
        .he 07,ec
        .he 00,78
        .he 00,0c
        .he 00,03

sprite_89e9
        .he 12,0b,16 ; total 22 bytes

; mask equals to data

sprite_89e9_data
        .he 18,7e
        .he 07,80
        .he 00,40
        .he 00,30
        .he 00,08
        .he 00,04
        .he 18,06
        .he 07,f8
        .he c0,10
        .he 38,0e
        .he 07,fe

sprite_8a59
        .he 12,10,20 ; total 32 bytes

; mask equals to data

sprite_8a59_data
        .he ff,f0
        .he 08,00
        .he 07,f8
        .he 00,04
        .he 00,08
        .he 03,e4
        .he 04,1c
        .he 79,e6
        .he 86,60
        .he 79,9e
        .he 06,21
        .he 01,c3
        .he 00,1c
        .he 00,c0
        .he 00,3e
        .he 00,06

sprite_8a9b
        .he 12,08,10 ; total 16 bytes

; mask equals to data

sprite_8a9b_data
        .he c0,00
        .he 7f,c0
        .he 1c,00
        .he 03,00
        .he 00,ce
        .he 00,78
        .he 00,04
        .he 00,03

sprite_8abd
        .he 05,22,aa ; total 170 bytes
sprite_8abd_data
        .he 00,00,00,00,00
        .he 00,01,80,00,00
        .he 00,02,c0,00,00
        .he 00,02,c0,00,00
        .he 00,02,c0,00,00
        .he 00,02,c0,00,00
        .he 00,02,c0,00,00
        .he 0c,02,c0,00,00
        .he 16,02,c0,00,00
        .he 16,02,c0,00,00
        .he 16,02,c0,00,00
        .he 16,00,20,00,30
        .he 16,0f,80,00,58
        .he 16,1e,60,00,58
        .he 16,d9,98,00,58
        .he 15,e7,e6,00,58
        .he 03,9f,f9,80,58
        .he 3e,67,fe,60,58
        .he 79,f9,ff,98,58
        .he 66,7e,7f,e6,58
        .he 5f,9f,9f,f9,98
        .he 7f,e7,e7,fe,60
        .he 1f,f9,f9,ff,98
        .he 07,fe,7e,7f,e6
        .he 01,ff,9f,9f,f8
        .he 00,7f,e7,e7,fe
        .he 00,1f,f9,f9,f8
        .he 00,07,fe,7e,60
        .he 00,01,ff,9f,80
        .he 00,00,7f,f6,00
        .he 00,00,1f,f8,00
        .he 00,00,07,e0,00
        .he 00,00,01,80,00
        .he 00,00,00,00,00
sprite_8abd_mask
        .he 00,01,80,00,00
        .he 00,03,c0,00,00
        .he 00,07,e0,00,00
        .he 00,07,e0,00,00
        .he 00,07,e0,00,00
        .he 00,07,e0,00,00
        .he 0c,07,e0,00,00
        .he 1e,07,e0,00,00
        .he 3f,07,e0,00,00
        .he 3f,07,e0,00,00
        .he 3f,07,e0,00,30
        .he 3f,0f,e0,00,78
        .he 3f,1f,e0,00,fc
        .he 3f,ff,f8,00,fc
        .he 3f,ff,fe,00,fc
        .he 3f,ff,ff,80,fc
        .he 3f,ff,ff,e0,fc
        .he 7f,ff,ff,f8,fc
        .he ff,ff,ff,fe,fc
        .he ff,ff,ff,ff,fc
        .he ff,ff,ff,ff,fc
        .he ff,ff,ff,ff,fc
        .he 7f,ff,ff,ff,fe
        .he 1f,ff,ff,ff,ff
        .he 07,ff,ff,ff,ff
        .he 01,ff,ff,ff,ff
        .he 00,7f,ff,ff,fe
        .he 00,1f,ff,ff,f8
        .he 00,07,ff,ff,e0
        .he 00,01,ff,ff,80
        .he 00,00,7f,fe,00
        .he 00,00,1f,f8,00
        .he 00,00,07,e0,00
        .he 00,00,01,80,00

sprite_8c13
        .he 05,20,a0 ; total 160 bytes
sprite_8c13_data
        .he 00,00,00,00,00
        .he 00,00,fc,00,00
        .he 00,03,fc,f0,00
        .he 00,3b,fe,fc,00
        .he 00,fb,fe,fe,00
        .he 00,fb,e0,7e,80
        .he 04,f9,ce,3d,c0
        .he 0e,f0,1f,85,e0
        .he 0e,e1,cf,b9,f0
        .he 0e,4f,83,be,f0
        .he 0e,1f,79,9e,30
        .he 0e,1e,7c,06,d0
        .he 0c,d9,3d,f2,e0
        .he 0b,c7,7e,f8,f0
        .he 07,1e,7f,7c,30
        .he 0e,7e,40,7e,d0
        .he 08,f1,3f,06,60
        .he 06,4f,df,78,30
        .he 0e,3f,3e,ff,10
        .he 0d,9c,00,38,d0
        .he 0b,c0,00,07,e0
        .he 07,f1,00,03,f0
        .he 0f,e0,00,01,f0
        .he 0f,c0,04,01,f0
        .he 00,21,01,00,00
        .he 07,f0,00,03,c0
        .he 07,e9,44,0f,c0
        .he 03,df,01,67,80
        .he 00,be,7d,f2,00
        .he 00,0e,fd,f8,00
        .he 00,00,fe,e0,00
        .he 00,00,00,00,00
sprite_8c13_mask
        .he 00,00,ff,00,00
        .he 00,03,ff,f0,00
        .he 00,3f,ff,fc,00
        .he 00,ff,ff,ff,00
        .he 01,ff,ff,ff,80
        .he 07,ff,ff,ff,c0
        .he 0f,ff,ff,ff,e0
        .he 1f,ff,ff,ff,f0
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f8
        .he 1f,ff,ff,ff,f0
        .he 0f,ff,ff,ff,f0
        .he 0f,ff,ff,ff,e0
        .he 07,ff,ff,ff,c0
        .he 03,ff,ff,ff,80
        .he 00,ff,ff,fe,00
        .he 00,0f,ff,f8,00
        .he 00,00,ff,e0,00

sprite_8d55
        .he 04,27,9c ; total 156 bytes
sprite_8d55_data
        .he 00,00,00,00
        .he 00,01,00,00
        .he 00,02,a0,00
        .he 00,0e,50,00
        .he 00,3c,aa,00
        .he 00,ff,55,00
        .he 03,fe,a8,a0
        .he 0f,f5,55,50
        .he 1f,f2,a8,aa
        .he 3f,f9,54,54
        .he 1f,fa,a2,28
        .he 1f,fd,51,54
        .he 1f,fc,aa,a8
        .he 1f,fe,51,50
        .he 07,fe,aa,a0
        .he 07,fd,55,50
        .he 01,fc,aa,a0
        .he 02,fd,55,40
        .he 03,7e,8a,a0
        .he 07,7d,55,40
        .he 07,bc,aa,a0
        .he 07,bc,54,00
        .he 01,dc,aa,00
        .he 03,ee,54,00
        .he 03,de,8a,00
        .he 01,ef,45,00
        .he 01,ff,2a,00
        .he 01,fe,55,00
        .he 00,fe,aa,00
        .he 00,7e,14,00
        .he 00,38,c8,00
        .he 00,16,e4,00
        .he 00,0e,f8,00
        .he 00,1f,7c,00
        .he 00,07,70,00
        .he 00,01,60,00
        .he 00,00,c0,00
        .he 00,00,80,00
        .he 00,00,00,00
sprite_8d55_mask
        .he 00,01,80,00
        .he 00,03,e0,00
        .he 00,0f,f8,00
        .he 00,3f,fe,00
        .he 00,ff,ff,80
        .he 03,ff,ff,e0
        .he 0f,ff,ff,f8
        .he 1f,ff,ff,fe
        .he 3f,ff,ff,ff
        .he 7f,ff,ff,ff
        .he 3f,ff,ff,fe
        .he 3f,ff,ff,fe
        .he 3f,ff,ff,fc
        .he 3f,ff,ff,fc
        .he 1f,ff,ff,f8
        .he 0f,ff,ff,f8
        .he 07,ff,ff,f0
        .he 07,ff,ff,f0
        .he 07,ff,ff,f0
        .he 0f,ff,ff,f0
        .he 0f,ff,ff,e0
        .he 0f,ff,ff,80
        .he 07,ff,ff,00
        .he 07,ff,ff,00
        .he 07,ff,ff,00
        .he 03,ff,ff,80
        .he 03,ff,ff,00
        .he 03,ff,ff,80
        .he 01,ff,ff,00
        .he 00,ff,fe,00
        .he 00,7f,fe,00
        .he 00,3f,fe,00
        .he 00,3f,fe,00
        .he 00,3f,fe,00
        .he 00,1f,fc,00
        .he 00,07,f0,00
        .he 00,01,e0,00
        .he 00,01,c0,00
        .he 00,00,80,00

sprite_8e8f
        .he 04,33,cc ; total 204 bytes
sprite_8e8f_data
        .he 00,00,00,00
        .he 00,01,80,00
        .he 00,07,20,00
        .he 00,1f,50,00
        .he 00,7f,2a,00
        .he 01,ff,55,00
        .he 07,ff,2a,a0
        .he 1f,ff,55,50
        .he 7f,ff,2a,aa
        .he 7f,ff,55,54
        .he 7f,ff,2a,aa
        .he 7f,ff,55,54
        .he 7f,ff,2a,aa
        .he 3f,ff,55,54
        .he 3f,ff,2a,a8
        .he 3f,ff,55,54
        .he 3f,ff,2a,a8
        .he 3f,ff,55,54
        .he 1f,ff,2a,a8
        .he 1f,ff,55,50
        .he 1f,ff,2a,a8
        .he 1f,ff,55,50
        .he 1f,ff,2a,a8
        .he 0f,ff,55,50
        .he 0f,ff,2a,a0
        .he 0f,ff,55,50
        .he 0f,ff,2a,a0
        .he 0f,ff,55,50
        .he 07,ff,2a,a0
        .he 07,ff,55,40
        .he 07,ff,2a,a0
        .he 07,ff,55,40
        .he 07,ff,2a,a0
        .he 03,ff,55,40
        .he 03,ff,2a,80
        .he 03,ff,55,40
        .he 03,ff,2a,80
        .he 03,fe,55,40
        .he 01,f8,8a,80
        .he 01,e3,e5,00
        .he 01,9e,f8,80
        .he 00,7e,fe,00
        .he 00,fe,ff,00
        .he 00,7e,fe,00
        .he 00,3e,fc,00
        .he 00,1e,f8,00
        .he 00,0e,f0,00
        .he 00,06,e0,00
        .he 00,02,c0,00
        .he 00,01,80,00
        .he 00,00,00,00
sprite_8e8f_mask
        .he 00,01,80,00
        .he 00,07,e0,00
        .he 00,1f,f8,00
        .he 00,7f,fe,00
        .he 01,ff,ff,80
        .he 07,ff,ff,e0
        .he 1f,ff,ff,f1
        .he 7f,ff,ff,fe
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he ff,ff,ff,ff
        .he 7f,ff,ff,fe
        .he 7f,ff,ff,fe
        .he 7f,ff,ff,fe
        .he 7f,ff,ff,fe
        .he 7f,ff,ff,fe
        .he 3f,ff,ff,fc
        .he 3f,ff,ff,fc
        .he 3f,ff,ff,fc
        .he 3f,ff,ff,fc
        .he 3f,ff,ff,fc
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 0f,ff,ff,f0
        .he 0f,ff,ff,f0
        .he 0f,ff,ff,f0
        .he 0f,ff,ff,f0
        .he 0f,ff,ff,f0
        .he 07,ff,ff,e0
        .he 07,ff,ff,e0
        .he 07,ff,ff,e0
        .he 07,ff,ff,e0
        .he 07,ff,ff,e0
        .he 03,ff,ff,c0
        .he 03,ff,ff,c0
        .he 03,ff,ff,c0
        .he 03,ff,ff,80
        .he 01,ff,ff,80
        .he 00,ff,ff,00
        .he 00,7f,fe,00
        .he 00,3f,fc,00
        .he 00,1f,f8,00
        .he 00,0f,f0,00
        .he 00,07,e0,00
        .he 00,03,c0,00
        .he 00,01,80,00

sprite_9029
        .he 03,18,48 ; total 72 bytes
sprite_9029_data
        .he 00,00,00
        .he 00,76,00
        .he 01,76,80
        .he 03,00,c0
        .he 04,f7,20
        .he 02,f7,40
        .he 0e,f7,70
        .he 0d,f7,70
        .he 0d,f7,f0
        .he 1d,f7,b8
        .he 1d,00,b8
        .he 18,ff,18
        .he 27,00,e4
        .he 18,10,18
        .he 62,10,46
        .he 22,10,44
        .he 3a,10,5c
        .he 17,10,f8
        .he 10,ff,08
        .he 08,00,10
        .he 06,00,60
        .he 01,81,80
        .he 00,7e,00
        .he 00,00,00
sprite_9029_mask
        .he 00,7e,00
        .he 01,ff,80
        .he 03,ff,c0
        .he 07,ff,e0
        .he 0f,ff,f0
        .he 0f,ff,f0
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 3f,ff,fc
        .he 3f,ff,fc
        .he 3f,ff,fc
        .he 7f,ff,fe
        .he 7f,ff,fe
        .he ff,ff,ff
        .he 7f,ff,fe
        .he 7f,ff,fe
        .he 3f,ff,fc
        .he 3f,ff,fc
        .he 1f,ff,f8
        .he 0f,ff,f0
        .he 07,ff,e0
        .he 01,ff,80
        .he 00,7e,00

sprite_90bb
        .he 03,18,48 ; total 72 bytes
sprite_90bb_data
        .he 00,00,00
        .he 01,e0,00
        .he 03,ff,f0
        .he 3e,1f,f8
        .he 7d,e0,04
        .he 43,ff,f9
        .he 3f,cf,f9
        .he 7f,87,fc
        .he 7f,c3,fe
        .he 7f,e3,fe
        .he 3f,e3,fe
        .he 1f,c6,1e
        .he 3d,80,0e
        .he 38,00,dc
        .he 1c,33,fc
        .he 0f,e3,f8
        .he 1f,e3,f0
        .he 1f,e1,e0
        .he 0f,f1,e0
        .he 03,fb,c0
        .he 00,ff,00
        .he 00,1c,00
        .he 00,00,00
        .he 00,00,00
sprite_90bb_mask
        .he 03,e0,00
        .he 03,ff,f0
        .he 3f,ff,f8
        .he 7f,ff,fc
        .he ff,ff,fe
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,fe
        .he 3f,ff,fe
        .he 3f,ff,fc
        .he 3f,ff,f8
        .he 3f,ff,f0
        .he 1f,ff,f0
        .he 0f,ff,e0
        .he 03,ff,c0
        .he 00,ff,00
        .he 00,1c,00
        .he 00,00,00

sprite_914d
        .he 03,18,48 ; total 72 bytes
sprite_914d_data
        .he 00,00,00
        .he 00,0f,c0
        .he 00,7f,e0
        .he 00,f8,38
        .he 01,87,dc
        .he 07,7f,e4
        .he 1e,f8,fa
        .he 39,e0,3c
        .he 27,c0,1e
        .he 5f,87,07
        .he 3f,8f,c6
        .he 7f,8f,e6
        .he 70,07,e6
        .he 60,03,c6
        .he 77,c0,06
        .he 7f,f8,0e
        .he 7f,fc,7c
        .he 3f,fc,7c
        .he 1f,f0,f8
        .he 07,fc,f0
        .he 01,ff,e0
        .he 00,ff,c0
        .he 00,0f,80
        .he 00,00,00
sprite_914d_mask
        .he 00,07,c0
        .he 00,7f,e0
        .he 00,ff,f8
        .he 01,ff,fc
        .he 07,ff,fe
        .he 1f,ff,fe
        .he 3f,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,fe
        .he 7f,ff,fe
        .he 3f,ff,fc
        .he 1f,ff,f8
        .he 07,ff,f0
        .he 01,ff,e0
        .he 00,ff,c0
        .he 00,0f,80

sprite_91df
        .he 03,18,48 ; total 72 bytes
sprite_91df_data
        .he 00,00,00
        .he 0f,f0,c0
        .he 1f,ff,f0
        .he 30,0f,38
        .he 2f,f0,cc
        .he 5f,ff,f4
        .he 5f,ff,fa
        .he 5f,ff,fe
        .he 3f,cf,fc
        .he 7b,c3,fe
        .he 60,80,fe
        .he 78,18,3e
        .he 7e,1e,0e
        .he 3e,30,06
        .he 1c,00,fe
        .he 18,08,3e
        .he 18,fe,1e
        .he 3f,ff,b8
        .he 3f,ff,f0
        .he 1f,ff,f0
        .he 07,ff,f0
        .he 01,f3,e0
        .he 00,01,c0
        .he 00,00,00
sprite_91df_mask
        .he 0f,f0,c0
        .he 1f,ff,f0
        .he 3f,ff,f8
        .he 7f,ff,fc
        .he 7f,ff,fe
        .he ff,ff,fe
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he 7f,ff,ff
        .he 3f,ff,ff
        .he 3f,ff,ff
        .he 3f,ff,ff
        .he 7f,ff,fe
        .he 7f,ff,f8
        .he 3f,ff,f8
        .he 1f,ff,f8
        .he 07,ff,f0
        .he 01,f3,e0
        .he 00,01,c0

sprite_9271
        .he 03,18,48 ; total 72 bytes
sprite_9271_data
        .he 00,00,00
        .he 00,fc,00
        .he 03,ff,00
        .he 07,03,f8
        .he 0c,fc,fc
        .he 3b,ff,06
        .he 37,df,fa
        .he 4f,8f,fc
        .he 7f,8f,fe
        .he 3f,8f,fe
        .he 7f,cf,fe
        .he 77,c7,e6
        .he 61,c1,82
        .he 38,80,06
        .he 7c,06,1e
        .he 78,0f,fc
        .he 30,06,fc
        .he 38,21,fc
        .he 1c,77,f0
        .he 1f,ff,e0
        .he 0f,ff,c0
        .he 01,ff,80
        .he 00,fc,00
        .he 00,00,00
sprite_9271_mask
        .he 00,fc,00
        .he 03,ff,00
        .he 07,ff,f8
        .he 0f,ff,fc
        .he 3f,ff,fe
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,f0
        .he ff,ff,ff
        .he ff,ff,fe
        .he 7f,ff,fe
        .he 7f,ff,fe
        .he 3f,ff,fc
        .he 3f,ff,f0
        .he 1f,ff,e0
        .he 0f,ff,c0
        .he 01,ff,80
        .he 00,fc,00

sprite_9303
        .he 03,18,48 ; total 72 bytes
sprite_9303_data
        .he 00,00,00
        .he 07,f8,00
        .he 0f,fc,00
        .he 18,07,f0
        .he 17,fb,f8
        .he 2f,fc,1c
        .he 6f,ff,e4
        .he 5c,ff,f8
        .he 3c,3f,fc
        .he 7c,0f,fa
        .he 7c,03,fe
        .he 7c,30,fc
        .he 7e,7c,3e
        .he 7e,7c,0e
        .he 3e,38,06
        .he 3e,00,3e
        .he 1f,01,fe
        .he 1f,1f,fc
        .he 1f,ff,f8
        .he 0f,ff,f0
        .he 07,ff,e0
        .he 01,ff,c0
        .he 00,39,80
        .he 00,00,00
sprite_9303_mask
        .he 07,f8,00
        .he 0f,fc,00
        .he 1f,ff,f0
        .he 3f,ff,f8
        .he 3f,ff,fc
        .he 7f,ff,fe
        .he ff,ff,fe
        .he ff,ff,fe
        .he ff,ff,fe
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he ff,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 3f,ff,ff
        .he 3f,ff,fe
        .he 3f,ff,fc
        .he 1f,ff,f8
        .he 0f,ff,f0
        .he 07,ff,e0
        .he 01,ff,c0
        .he 00,39,80

sprite_9395
        .he 00,00,00 ; total 0 bytes
sprite_9395_data
sprite_9395_mask

sprite_9397
        .he 03,1b,51 ; total 81 bytes
sprite_9397_data
        .he 00,00,00
        .he 00,00,80
        .he 00,00,c0
        .he 00,00,c0
        .he 00,00,e0
        .he 00,fd,e0
        .he 0f,fb,f4
        .he 0f,f7,f6
        .he 0f,ef,fa
        .he 0f,f7,e0
        .he 0f,f7,80
        .he 1f,ff,80
        .he 1f,ff,c0
        .he 30,3f,c0
        .he 2f,9f,80
        .he 0f,ec,00
        .he 0f,f0,00
        .he 1f,fb,00
        .he 1e,1d,00
        .he 1c,fe,00
        .he 19,fe,00
        .he 1b,fc,00
        .he 1b,f0,00
        .he 3f,80,00
        .he 3c,00,00
        .he 70,00,00
        .he 00,00,00
sprite_9397_mask
        .he 00,00,80
        .he 00,01,c0
        .he 00,01,e0
        .he 00,01,e0
        .he 00,fd,f0
        .he 0f,ff,f4
        .he 1f,ff,fe
        .he 1f,ff,ff
        .he 1f,ff,ff
        .he 1f,ff,fa
        .he 1f,ff,e0
        .he 3f,ff,c0
        .he 3f,ff,e0
        .he 7f,ff,e0
        .he 7f,ff,c0
        .he 3f,ff,80
        .he 1f,ff,00
        .he 3f,ff,80
        .he 3f,ff,80
        .he 3f,ff,00
        .he 3f,ff,00
        .he 3f,fe,00
        .he 3f,fc,00
        .he 7f,f0,00
        .he 7f,80,00
        .he fc,00,00
        .he 70,00,00

sprite_943b
        .he 03,1b,51 ; total 81 bytes
sprite_943b_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,10
        .he 00,00,10
        .he 00,00,30
        .he 00,fe,f0
        .he 0f,fd,f0
        .he 0f,fd,f8
        .he 2f,fd,f8
        .he 2f,fd,fa
        .he 2f,f7,9a
        .he 1f,ff,86
        .he 1f,ff,80
        .he 30,3f,80
        .he 2f,9f,00
        .he 0f,ec,00
        .he 0f,f0,00
        .he 1f,fb,00
        .he 1e,1d,00
        .he 1c,fe,00
        .he 19,fe,00
        .he 1b,fc,00
        .he 1b,f0,00
        .he 3f,80,00
        .he 3c,00,00
        .he 70,00,00
        .he 00,00,00
sprite_943b_mask
        .he 00,00,00
        .he 00,00,10
        .he 00,00,38
        .he 00,00,38
        .he 00,fe,f8
        .he 0f,ff,f8
        .he 1f,ff,f8
        .he 3f,ff,fc
        .he 7f,ff,fe
        .he 7f,ff,ff
        .he 7f,ff,ff
        .he 3f,ff,df
        .he 3f,ff,c6
        .he 7f,ff,c0
        .he 7f,ff,80
        .he 3f,ff,00
        .he 1f,ff,00
        .he 3f,ff,80
        .he 3f,ff,80
        .he 3f,ff,00
        .he 3f,ff,00
        .he 3f,fe,00
        .he 3f,fc,00
        .he 7f,f0,00
        .he 7f,80,00
        .he fc,00,00
        .he 70,00,00

sprite_94df
        .he 03,1b,51 ; total 81 bytes
sprite_94df_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,08
        .he 00,00,18
        .he 00,ff,18
        .he 4f,fe,f8
        .he 6f,fd,f8
        .he 6f,fb,f8
        .he 6f,fb,f8
        .he 6f,f7,f8
        .he 5f,ff,d8
        .he 5f,ff,da
        .he 30,3f,ca
        .he 2f,9f,86
        .he 0f,ec,00
        .he 0f,f0,00
        .he 1f,fb,00
        .he 1e,1d,00
        .he 1c,fe,00
        .he 19,fe,00
        .he 1b,fc,00
        .he 1b,f0,00
        .he 3f,80,00
        .he 3c,00,00
        .he 70,00,00
        .he 00,00,00
sprite_94df_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,00,08
        .he 00,00,1c
        .he 00,ff,3c
        .he 4f,ff,fc
        .he ff,ff,fc
        .he ff,ff,fc
        .he ff,ff,fc
        .he ff,ff,fc
        .he ff,ff,fc
        .he ff,ff,fe
        .he ff,ff,ff
        .he 7f,ff,ff
        .he 7f,ff,cf
        .he 3f,ff,86
        .he 1f,ff,00
        .he 3f,ff,80
        .he 3f,ff,80
        .he 3f,ff,00
        .he 3f,ff,00
        .he 3f,fe,00
        .he 3f,fc,00
        .he 7f,f0,00
        .he 7f,80,00
        .he fc,00,00
        .he 70,00,00

sprite_9583
        .he 03,22,66 ; total 102 bytes
sprite_9583_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,02,00
        .he 00,01,80
        .he 00,02,80
        .he 00,02,c0
        .he 20,02,c0
        .he 30,02,e0
        .he 30,0a,e0
        .he 38,16,e0
        .he 38,f6,f0
        .he 3b,d1,f0
        .he 3b,ae,78
        .he 3b,6e,38
        .he 1a,f6,78
        .he 06,f6,f0
        .he 0e,fb,e0
        .he 0d,fb,c0
        .he 0d,99,20
        .he 02,e0,60
        .he 02,68,60
        .he 02,98,e0
        .he 02,c1,e0
        .he 01,01,e0
        .he 00,cf,e0
        .he 00,78,e0
        .he 00,30,60
        .he 00,0f,20
        .he 00,07,b0
        .he 00,01,f0
        .he 00,00,f0
        .he 00,00,38
        .he 00,00,00
sprite_9583_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,01,00
        .he 00,03,80
        .he 00,03,c0
        .he 00,07,c0
        .he 20,07,e0
        .he 70,07,e0
        .he 78,07,f0
        .he 78,1f,f0
        .he 7c,ff,f0
        .he 7f,ff,f8
        .he 7f,ff,f8
        .he 7f,ff,fc
        .he 7f,ff,fc
        .he 3f,ff,fc
        .he 1f,ff,f8
        .he 1f,ff,f0
        .he 1f,ff,e0
        .he 1f,ff,f0
        .he 0f,ff,f0
        .he 07,ff,f0
        .he 07,ff,f0
        .he 07,ff,f0
        .he 03,ff,f0
        .he 01,ff,f0
        .he 00,ff,f0
        .he 00,7f,f0
        .he 00,3f,f0
        .he 00,0f,f8
        .he 00,07,f8
        .he 00,01,f8
        .he 00,00,fc
        .he 00,00,38

sprite_9651
        .he 03,22,66 ; total 102 bytes
sprite_9651_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,40
        .he 40,00,40
        .he 40,00,a0
        .he 40,00,a0
        .he 60,00,b0
        .he 60,0e,b0
        .he 70,3e,b0
        .he 78,fd,b8
        .he 7b,dd,f8
        .he 7b,ae,fc
        .he 3b,6e,7c
        .he 1a,f6,fc
        .he 06,f6,f8
        .he 0e,fb,e0
        .he 0d,fb,c0
        .he 0d,99,20
        .he 02,e0,60
        .he 02,68,60
        .he 02,98,e0
        .he 02,c1,e0
        .he 01,01,e0
        .he 00,cf,e0
        .he 00,78,e0
        .he 00,30,60
        .he 00,0f,20
        .he 00,07,b0
        .he 00,01,f0
        .he 00,00,f0
        .he 00,00,38
        .he 00,00,00
sprite_9651_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,40
        .he 40,00,e0
        .he e0,00,e0
        .he e0,01,f0
        .he e0,01,f0
        .he f0,01,f8
        .he f0,0f,f8
        .he fc,ff,f8
        .he ff,ff,fc
        .he ff,ff,fc
        .he ff,ff,fe
        .he 7f,ff,fe
        .he 3f,ff,fe
        .he 1f,ff,fc
        .he 1f,ff,f8
        .he 1f,ff,e0
        .he 1f,ff,f0
        .he 0f,ff,f0
        .he 07,ff,f0
        .he 07,ff,f0
        .he 07,ff,f0
        .he 03,ff,f0
        .he 01,ff,f0
        .he 00,ff,f0
        .he 00,7f,f0
        .he 00,3f,f0
        .he 00,0f,f8
        .he 00,07,f8
        .he 00,01,f8
        .he 00,00,fc
        .he 00,00,38

sprite_971f
        .he 03,22,66 ; total 102 bytes
sprite_971f_data
        .he 00,00,00
        .he 00,04,00
        .he 00,0a,00
        .he 00,0a,00
        .he 00,13,00
        .he 00,13,00
        .he 00,13,80
        .he 00,13,80
        .he 10,33,c0
        .he 10,33,c0
        .he 18,0f,e0
        .he 18,f3,e0
        .he 1b,d1,f0
        .he 1b,ae,f0
        .he 0b,6e,f0
        .he 0a,f6,f0
        .he 06,f6,e0
        .he 0e,fb,e0
        .he 0d,fb,c0
        .he 0d,99,20
        .he 02,e0,60
        .he 02,68,60
        .he 02,98,e0
        .he 02,c1,e0
        .he 01,01,e0
        .he 00,cf,e0
        .he 00,78,e0
        .he 00,30,60
        .he 00,0f,20
        .he 00,07,b0
        .he 00,01,f0
        .he 00,00,f0
        .he 00,00,38
        .he 00,00,00
sprite_971f_mask
        .he 00,04,00
        .he 00,0e,00
        .he 00,1f,00
        .he 00,1f,00
        .he 00,3f,80
        .he 00,3f,80
        .he 00,3f,c0
        .he 10,3f,c0
        .he 38,7f,e0
        .he 38,7f,e0
        .he 3c,ff,f0
        .he 3f,ff,f0
        .he 3f,ff,f8
        .he 3f,ff,f8
        .he 1f,ff,f8
        .he 1f,ff,f8
        .he 0f,ff,f0
        .he 1f,ff,f0
        .he 1f,ff,e0
        .he 1f,ff,f0
        .he 0f,ff,f0
        .he 07,ff,f0
        .he 07,ff,f0
        .he 07,ff,f0
        .he 03,ff,f0
        .he 01,ff,f0
        .he 00,ff,f0
        .he 00,7f,f0
        .he 00,3f,f0
        .he 00,0f,f8
        .he 00,07,f8
        .he 00,01,f8
        .he 00,00,fc
        .he 00,00,38

sprite_97ed
        .he 03,0f,2d ; total 45 bytes
sprite_97ed_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 70,00,00
        .he 7e,01,80
        .he 3f,03,c0
        .he 21,03,e0
        .he 0e,00,f0
        .he 1f,07,38
        .he 0f,07,98
        .he 07,8f,c0
        .he 07,7f,80
        .he 0f,ff,00
        .he 0f,03,00
sprite_97ed_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 70,00,00
        .he fe,01,80
        .he ff,03,c0
        .he 7f,87,e0
        .he 7f,87,f0
        .he 3f,07,f8
        .he 3f,8f,fc
        .he 1f,8f,fc
        .he 0f,ff,f8
        .he 0f,ff,c0
        .he 1f,ff,80
        .he 1f,03,80

sprite_9849
        .he 03,0f,2d ; total 45 bytes
sprite_9849_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,06,00
        .he 00,1f,80
        .he 0e,17,c0
        .he 1f,99,c0
        .he 19,de,c0
        .he 06,d8,00
        .he 0f,1e,00
        .he 0f,1e,00
        .he 0f,be,00
        .he 0f,bf,00
        .he 07,ff,00
        .he 07,03,00
sprite_9849_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,06,00
        .he 00,1f,80
        .he 0e,3f,c0
        .he 1f,bf,e0
        .he 3f,ff,e0
        .he 3f,ff,e0
        .he 1f,fe,c0
        .he 1f,ff,00
        .he 1f,ff,00
        .he 1f,ff,00
        .he 1f,ff,80
        .he 0f,ff,80
        .he 0f,03,80

sprite_98a5
        .he 03,0f,2d ; total 45 bytes
sprite_98a5_data
        .he 00,00,00
        .he 00,00,00
        .he 00,70,00
        .he 00,fc,00
        .he 00,ce,00
        .he 00,77,00
        .he 03,ba,00
        .he 01,dc,00
        .he 02,5e,00
        .he 03,9f,00
        .he 01,de,00
        .he 01,de,00
        .he 03,bf,00
        .he 07,ff,80
        .he 07,02,00
sprite_98a5_mask
        .he 00,00,00
        .he 00,70,00
        .he 00,fc,00
        .he 01,fe,00
        .he 01,ff,00
        .he 03,ff,80
        .he 07,ff,00
        .he 03,fe,00
        .he 07,ff,00
        .he 07,ff,80
        .he 03,ff,00
        .he 03,ff,00
        .he 07,ff,80
        .he 0f,ff,c0
        .he 0f,03,80

sprite_9901
        .he 03,12,36 ; total 54 bytes
sprite_9901_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,38,00
        .he 00,3e,00
        .he 06,1f,00
        .he 0f,83,00
        .he 07,c5,00
        .he 02,66,00
        .he 01,8f,00
        .he 01,cf,00
        .he 03,ef,00
        .he 03,df,00
        .he 03,ce,00
        .he 03,f1,00
        .he 03,c0,00
        .he 03,00,00
        .he 00,00,00
sprite_9901_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,38,00
        .he 00,7e,00
        .he 06,7f,00
        .he 0f,bf,80
        .he 1f,df,80
        .he 0f,ef,80
        .he 07,ff,00
        .he 03,ff,80
        .he 03,ff,80
        .he 07,ff,80
        .he 07,ff,80
        .he 07,ff,00
        .he 07,ff,80
        .he 07,f1,00
        .he 07,c0,00
        .he 03,00,00

sprite_996f
        .he 03,12,36 ; total 54 bytes
sprite_996f_data
        .he 00,00,00
        .he 00,40,00
        .he 00,e0,00
        .he 00,f8,00
        .he 00,7e,00
        .he 00,26,00
        .he 00,1a,00
        .he 01,bc,00
        .he 03,bc,00
        .he 01,bc,00
        .he 00,3e,00
        .he 00,de,00
        .he 00,df,00
        .he 01,de,00
        .he 01,f0,00
        .he 01,c0,00
        .he 01,00,00
        .he 00,00,00
sprite_996f_mask
        .he 00,40,00
        .he 00,e0,00
        .he 01,f8,00
        .he 01,fe,00
        .he 00,ff,00
        .he 00,7f,00
        .he 01,ff,00
        .he 03,fe,00
        .he 07,fe,00
        .he 03,fe,00
        .he 01,ff,00
        .he 01,ff,00
        .he 01,ff,80
        .he 03,ff,00
        .he 03,fe,00
        .he 03,f0,00
        .he 03,c0,00
        .he 01,00,00

sprite_99dd
        .he 03,12,36 ; total 54 bytes
sprite_99dd_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 38,0c,00
        .he 3c,0e,00
        .he 0f,0f,00
        .he 07,85,80
        .he 02,04,c0
        .he 01,87,40
        .he 03,8f,80
        .he 07,cf,00
        .he 07,ef,00
        .he 03,de,00
        .he 01,f1,00
        .he 01,c0,00
        .he 01,00,00
        .he 00,00,00
sprite_99dd_mask
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 38,0c,00
        .he 7c,1e,00
        .he 7f,1f,00
        .he 3f,9f,80
        .he 0f,cf,c0
        .he 07,87,e0
        .he 03,cf,e0
        .he 07,df,c0
        .he 0f,ff,80
        .he 0f,ff,80
        .he 07,ff,00
        .he 03,ff,80
        .he 03,f1,00
        .he 03,c0,00
        .he 01,00,00

sprite_9a4b
        .he 13,18,48 ; total 72 bytes

; mask equals to data

sprite_9a4b_data
        .he bf,9f,d0
        .he bf,0f,d0
        .he be,c7,d0
        .he bd,db,d0
        .he bb,bd,d0
        .he b3,7c,d0
        .he aa,fd,50
        .he 99,fd,90
        .he 9b,f9,90
        .he ab,f5,50
        .he b3,ec,d0
        .he bb,dd,d0
        .he bd,bb,d0
        .he be,37,d0
        .he bf,0f,d0
        .he bf,9f,d0
        .he 9f,df,90
        .he 8f,ef,10
        .he 97,f4,90
        .he 9b,f9,90
        .he 99,fd,90
        .he 96,fe,90
        .he 8f,7f,10
        .he 9f,bf,90

sprite_9add
        .he 12,18,30 ; total 48 bytes

; mask equals to data

sprite_9add_data
        .he 00,00
        .he 00,00
        .he 00,00
        .he 00,00
        .he ff,ff
        .he 00,00
        .he fe,7f
        .he fd,bf
        .he fb,df
        .he f0,0f
        .he ef,77
        .he df,bb
        .he 9f,dd
        .he 0f,ec
        .he 37,f0
        .he bb,f9
        .he dd,fb
        .he ee,f7
        .he f0,0f
        .he fb,df
        .he fd,bf
        .he fe,7f
        .he 00,00
        .he ff,ff

sprite_9b3f
        .he 13,18,48 ; total 72 bytes

; mask equals to data

sprite_9b3f_data
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he 00,00,00
        .he ff,ff,ff
        .he 00,00,00
        .he fe,7f,00
        .he fd,bf,bd
        .he fb,df,db
        .he f0,0f,e7
        .he ef,77,ef
        .he df,bb,df
        .he 9f,dd,bf
        .he 0f,ec,7f
        .he 37,f0,fe
        .he bb,f9,fd
        .he dd,fb,fb
        .he ee,f7,f7
        .he f0,0f,e7
        .he fb,df,db
        .he fd,bf,bd
        .he fe,7f,00
        .he 00,00,00
        .he ff,ff,ff

sprite_9bd1
        .he 13,18,48 ; total 72 bytes

; mask equals to data

sprite_9bd1_data
        .he 9f,df,98
        .he 8f,ef,04
        .he 97,f6,c2
        .he 9b,f9,f1
        .he 99,fc,39
        .he 96,fe,18
        .he 8f,7f,0c
        .he 9f,bf,8d
        .he bf,9f,cb
        .he bf,0f,e7
        .he be,07,f7
        .he bd,03,fb
        .he bb,81,fd
        .he b3,c0,fe
        .he ab,e0,7f
        .he 9b,f1,bf
        .he 9b,fb,df
        .he 9b,f7,ef
        .he 98,0f,e7
        .he 9f,df,db
        .he 9f,bf,db
        .he 80,7f,00
        .he 80,00,00
        .he ff,ff,ff

sprite_9c63
        .he 03,37,a5 ; total 165 bytes
sprite_9c63_data
        .he 00,00,00
        .he 02,80,00
        .he 2a,a0,00
        .he 5f,dc,00
        .he ed,b8,00
        .he 6f,b0,00
        .he 77,70,00
        .he 37,60,00
        .he 3f,60,00
        .he 3f,60,00
        .he 3f,e0,00
        .he 3f,e0,00
        .he 3f,e0,00
        .he 3f,c0,00
        .he 3f,c0,00
        .he 3f,c0,00
        .he 3b,c0,00
        .he 37,c0,00
        .he 3f,c0,00
        .he 2f,e0,00
        .he 27,e0,00
        .he 1b,e0,00
        .he 3a,e0,00
        .he 39,e0,00
        .he 1b,e0,00
        .he 07,f0,00
        .he 3f,f0,00
        .he 5f,f0,00
        .he 9f,f0,00
        .he 1f,f8,00
        .he 3f,f8,00
        .he 3b,bc,00
        .he 3b,9c,00
        .he 33,ce,00
        .he 33,c7,00
        .he 33,c3,00
        .he 23,e1,80
        .he 63,60,c0
        .he 63,70,60
        .he 63,30,00
        .he 07,38,30
        .he 43,18,58
        .he c3,0c,c0
        .he 87,0c,46
        .he 87,16,23
        .he 06,16,21
        .he 0a,23,00
        .he 0a,25,80
        .he 12,24,dc
        .he 12,08,60
        .he 12,08,20
        .he 12,08,30
        .he 02,00,18
        .he 02,00,00
        .he 00,00,00
sprite_9c63_mask
        .he 02,80,80
        .he 2f,e0,00
        .he 7f,fc,00
        .he ff,fe,00
        .he ff,fc,00
        .he ff,f8,00
        .he ff,f8,00
        .he 7f,f0,00
        .he 7f,f0,00
        .he 7f,f0,00
        .he 7f,f0,00
        .he 7f,f0,00
        .he 7f,f0,00
        .he 7f,e0,00
        .he 7f,e0,00
        .he 7f,e0,00
        .he 7f,e0,00
        .he 7f,e0,00
        .he 7f,e0,00
        .he 7f,f0,00
        .he 7f,f0,00
        .he 7f,f0,00
        .he 7f,f0,00
        .he 7f,f0,00
        .he 3f,f0,00
        .he 3f,f8,00
        .he 7f,f8,00
        .he ff,f8,00
        .he ff,f8,00
        .he bf,fc,00
        .he 7f,fc,00
        .he 7f,fe,00
        .he 7f,fe,00
        .he 7f,ff,00
        .he 7f,ef,80
        .he 7f,e7,c0
        .he 77,f3,c0
        .he f7,f1,e0
        .he f7,f8,f0
        .he f7,f8,78
        .he e7,fc,78
        .he e7,bc,fc
        .he e7,9e,fe
        .he cf,9e,ef
        .he cf,bf,77
        .he 8f,3f,7e
        .he 1f,77,9e
        .he 1f,7f,dc
        .he 3f,7f,fe
        .he 3f,3c,fc
        .he 3f,1c,70
        .he 3f,1c,78
        .he 17,08,3c
        .he 07,00,18
        .he 02,00,00

sprite_9daf
        .he 02,28,50 ; total 80 bytes
sprite_9daf_data
        .he 00,00
        .he 00,50
        .he 01,54
        .he 0d,aa
        .he 06,f6
        .he 03,7e
        .he 03,7f
        .he 01,ec
        .he 01,ec
        .he 01,f4
        .he 01,f4
        .he 07,f8
        .he 09,fc
        .he 11,f8
        .he 11,c6
        .he 23,d6
        .he 23,d8
        .he 05,b8
        .he 05,b8
        .he 09,78
        .he 09,68
        .he 10,e8
        .he 20,e8
        .he 21,ec
        .he 03,ec
        .he 03,64
        .he 06,e4
        .he 0d,a4
        .he 39,24
        .he 63,24
        .he d2,22
        .he 96,22
        .he 04,31
        .he 0e,29
        .he 2a,28
        .he d2,64
        .he 14,a4
        .he 25,22
        .he 20,22
        .he 00,00
sprite_9daf_mask
        .he 00,50
        .he 01,fc
        .he 0f,fe
        .he 1f,ff
        .he 0f,ff
        .he 07,ff
        .he 07,fe
        .he 03,fe
        .he 03,fe
        .he 03,fe
        .he 07,fe
        .he 0f,fc
        .he 1f,fe
        .he 3b,fe
        .he 3b,fe
        .he 77,ff
        .he 77,fe
        .he 2f,fc
        .he 0f,fc
        .he 1f,fc
        .he 1f,fc
        .he 3b,fc
        .he 73,fc
        .he 73,fe
        .he 27,fe
        .he 07,fe
        .he 0f,fe
        .he 3f,fe
        .he 7f,fe
        .he ff,fe
        .he ff,77
        .he ff,77
        .he 9e,7b
        .he 3f,7f
        .he ff,7d
        .he ff,fe
        .he ff,fe
        .he 7f,f7
        .he 75,77
        .he 20,22

sprite_9e51
        .he 04,19,64 ; total 100 bytes
sprite_9e51_data
        .he 00,00,00,00
        .he 00,0d,d0,00
        .he 00,bd,df,00
        .he 01,bd,df,40
        .he 05,bd,ef,60
        .he 0c,d9,ef,78
        .he 0c,d6,ee,f8
        .he 0e,b6,ee,50
        .he 0e,ba,f6,f0
        .he 0d,d9,f6,f0
        .he 1d,dd,ee,f0
        .he 1d,ed,df,50
        .he 1d,ed,ef,58
        .he 1b,d0,0f,58
        .he 0b,0f,f0,f8
        .he 08,f8,1f,38
        .he 0b,c7,e3,d8
        .he 07,3c,3d,e8
        .he 0e,e3,c6,f0
        .he 0e,e3,c6,f0
        .he 07,3c,3d,e0
        .he 03,c7,e3,c0
        .he 00,f8,1f,00
        .he 00,0f,f0,00
        .he 00,00,00,00
sprite_9e51_mask
        .he 00,0f,f0,00
        .he 00,ff,ff,00
        .he 01,ff,ff,c0
        .he 07,ff,ff,e0
        .he 0f,ff,ff,f8
        .he 1f,ff,ff,fc
        .he 1f,ff,ff,fc
        .he 1f,ff,ff,fc
        .he 1f,ff,ff,f8
        .he 3f,ff,ff,f8
        .he 3f,ff,ff,f8
        .he 3f,ff,ff,fc
        .he 3f,ff,ff,fc
        .he 3f,ff,ff,fc
        .he 3f,ff,ff,fc
        .he 1f,ff,ff,fc
        .he 1f,ff,ff,fc
        .he 1f,ff,ff,fc
        .he 1f,ff,ff,fc
        .he 1f,ff,ff,f8
        .he 1f,ff,ff,f8
        .he 0f,ff,ff,f0
        .he 07,ff,ff,e0
        .he 01,ff,ff,80
        .he 00,1f,f8,00

sprite_9f1b
        .he 02,2b,56 ; total 86 bytes
sprite_9f1b_data
        .he 00,42
        .he 01,51
        .he 06,e9
        .he 03,f1
        .he 29,b1
        .he 7c,b1
        .he 38,b1
        .he 08,b1
        .he 08,b1
        .he 08,f3
        .he 18,e3
        .he 18,e3
        .he 18,e3
        .he 39,e3
        .he 59,e3
        .he 59,e3
        .he 19,d3
        .he 19,d3
        .he 19,ca
        .he 39,ca
        .he 29,42
        .he 29,42
        .he 29,42
        .he 29,64
        .he 49,64
        .he 49,e4
        .he 52,b2
        .he 52,b2
        .he 43,9a
        .he 43,98
        .he 43,18
        .he 07,0c
        .he 0b,0c
        .he 13,04
        .he 17,04
        .he 17,8e
        .he 2b,8a
        .he 4a,8a
        .he 52,92
        .he 12,92
        .he 24,92
        .he 24,00
        .he 04,00
sprite_9f1b_mask
        .he 00,42
        .he 01,51
        .he 06,e9
        .he 03,f1
        .he 29,b1
        .he 7c,b1
        .he 38,b1
        .he 08,b1
        .he 08,b1
        .he 08,f3
        .he 18,e3
        .he 18,e3
        .he 18,e3
        .he 39,e3
        .he 59,e3
        .he 59,e3
        .he 19,d3
        .he 19,d3
        .he 19,ca
        .he 39,ca
        .he 29,42
        .he 29,42
        .he 29,42
        .he 29,64
        .he 49,64
        .he 52,e4
        .he 52,b2
        .he 52,b2
        .he 43,9a
        .he 43,98
        .he 43,18
        .he 07,0c
        .he 0b,0c
        .he 13,04
        .he 17,04
        .he 27,8e
        .he 2b,8a
        .he 4a,8a
        .he 52,92
        .he 12,92
        .he 24,92
        .he 24,00
        .he 04,00

sprite_9fc9
        .he 12,35,6a ; total 106 bytes

; mask equals to data

sprite_9fc9_data
        .he 41,40
        .he 22,52
        .he b2,a2
        .he d6,d0
        .he 7f,e0
        .he 3e,c2
        .he 36,94
        .he 3a,9c
        .he 3b,9c
        .he 1b,de
        .he 1d,dc
        .he 1d,dc
        .he 1d,de
        .he 1d,dc
        .he 1f,8c
        .he 1f,8c
        .he 1f,9c
        .he 1f,9e
        .he 1d,a6
        .he 1d,a6
        .he 1d,ae
        .he 1d,ad
        .he 1d,8d
        .he 15,8d
        .he 0e,8c
        .he 1e,cc
        .he 3e,d4
        .he 37,44
        .he 2f,e4
        .he 2f,e4
        .he 0d,f0
        .he 1d,f8
        .he 1d,dc
        .he 1d,dc
        .he 19,da
        .he 30,cd
        .he 30,cc
        .he 30,cc
        .he 70,c6
        .he 58,c6
        .he 18,c6
        .he 18,e2
        .he 18,e2
        .he 14,53
        .he 14,51
        .he 12,49
        .he 12,49
        .he 10,01
        .he 08,00
        .he 08,00
        .he 08,00
        .he 04,00
        .he 04,00

sprite_a09f
        .he 12,35,6a ; total 106 bytes

; mask equals to data

sprite_a09f_data
        .he 01,24
        .he 01,a5
        .he 04,aa
        .he 0a,ed
        .he af,7f
        .he 5b,be
        .he 73,3c
        .he 73,1c
        .he 71,1c
        .he 31,1c
        .he 31,9c
        .he 31,bc
        .he 39,bc
        .he 35,bc
        .he 35,bc
        .he 31,fa
        .he 31,ea
        .he 39,69
        .he 39,69
        .he 39,e9
        .he 39,b9
        .he 59,b9
        .he 5d,b8
        .he 95,b8
        .he 95,b8
        .he b5,b8
        .he 25,3c
        .he 27,7c
        .he 67,7a
        .he 43,7a
        .he 47,7a
        .he 46,ba
        .he 46,b8
        .he 26,b8
        .he 26,3c
        .he 2e,3c
        .he 2c,74
        .he 2c,76
        .he 1a,b2
        .he 1a,b2
        .he 29,31
        .he 49,31
        .he 52,b8
        .he 92,d8
        .he 92,54
        .he 14,94
        .he 14,b4
        .he 04,32
        .he 00,52
        .he 00,50
        .he 00,90
        .he 00,90
        .he 00,10

sprite_a175
        .he 12,32,64 ; total 100 bytes

; mask equals to data

sprite_a175_data
        .he 00,50
        .he 00,70
        .he 05,27
        .he 2a,2e
        .he 57,ae
        .he 7f,26
        .he 3b,26
        .he 1a,64
        .he 1a,64
        .he 16,a4
        .he 16,a4
        .he 36,b4
        .he 56,34
        .he 5c,2c
        .he 1c,24
        .he 1c,24
        .he 3e,2a
        .he 3e,4a
        .he 77,4a
        .he 57,08
        .he d6,89
        .he 96,89
        .he b5,41
        .he a5,21
        .he 3c,a1
        .he 3a,91
        .he 7a,50
        .he 5a,48
        .he 59,24
        .he 59,22
        .he 59,11
        .he 59,10
        .he 58,88
        .he 98,88
        .he 94,84
        .he 94,44
        .he 14,40
        .he 14,40
        .he 14,40
        .he 14,20
        .he 12,20
        .he 12,20
        .he 12,10
        .he 12,10
        .he 12,10
        .he 12,08
        .he 12,08
        .he 12,00
        .he 02,00
        .he 02,00

sprite_a23f
        .he 12,1a,34 ; total 52 bytes

; mask equals to data

sprite_a23f_data
        .he 40,00
        .he 70,00
        .he 7c,00
        .he 7f,00
        .he 7f,80
        .he 3f,b0
        .he cf,bc
        .he f3,bf
        .he fc,bf
        .he ff,3f
        .he ff,bf
        .he ff,bf
        .he 3f,bf
        .he 4f,bf
        .he 73,3f
        .he 7c,3f
        .he 1d,cf
        .he 65,f3
        .he 75,fc
        .he 38,ff
        .he 07,3f
        .he 1f,cf
        .he 07,f3
        .he 01,fd
        .he 00,7e
        .he 00,18

sprite_a2a9
        .he 12,1f,3e ; total 62 bytes

; mask equals to data

sprite_a2a9_data
        .he 60,00
        .he 70,00
        .he 04,00
        .he 72,00
        .he 7b,00
        .he 78,5c
        .he 78,ee
        .he 31,ce
        .he 01,c8
        .he 00,e6
        .he 30,26
        .he 3e,03
        .he 1e,30
        .he cf,7c
        .he c7,3e
        .he e3,87
        .he f0,30
        .he 1b,7e
        .he e9,7e
        .he 74,7f
        .he 70,7f
        .he 7f,3f
        .he 3e,bf
        .he 3d,bf
        .he 13,bf
        .he 0f,9f
        .he 06,27
        .he 01,f9
        .he 07,fe
        .he 01,f8
        .he 00,60

sprite_a327
        .he 12,21,42 ; total 66 bytes

; mask equals to data

sprite_a327_data
        .he 34,00
        .he f7,00
        .he f7,c0
        .he c9,f0
        .he 3e,7c
        .he ff,9f
        .he f0,27
        .he cf,c9
        .he be,f7
        .he 7c,7a
        .he fc,7c
        .he ec,6c
        .he cc,64
        .he cc,64
        .he cc,64
        .he cc,64
        .he cc,64
        .he cc,64
        .he cc,64
        .he cc,64
        .he cc,64
        .he cc,64
        .he cc,64
        .he cc,64
        .he cc,64
        .he 8f,a4
        .he 76,e4
        .he bf,78
        .he 3d,fc
        .he 53,54
        .he 3d,a8
        .he 07,f0
        .he 00,e0

sprite_a3ad
        .he 12,18,30 ; total 48 bytes

; mask equals to data

sprite_a3ad_data
        .he c0,00
        .he f0,00
        .he fc,00
        .he 7e,00
        .he 3e,c0
        .he 46,f0
        .he f8,f4
        .he fe,f6
        .he 1e,f3
        .he 6c,34
        .he f1,8e
        .he fb,ff
        .he bd,ff
        .he de,ff
        .he ef,7f
        .he f7,8e
        .he 7b,b0
        .he 3f,3e
        .he 58,bf
        .he 07,df
        .he 1f,e6
        .he 03,f8
        .he 04,c6
        .he 06,06

sprite_a40f
        .he 12,1b,36 ; total 54 bytes

; mask equals to data

sprite_a40f_data
        .he c0,00
        .he e0,00
        .he ec,00
        .he 6f,00
        .he 0f,80
        .he e3,b0
        .he f8,bc
        .he fe,0f
        .he fe,e3
        .he fe,f8
        .he 3e,7e
        .he 8d,bf
        .he e3,8f
        .he fb,72
        .he fa,bc
        .he f5,de
        .he 6b,de
        .he 07,ef
        .he 03,ef
        .he 03,e7
        .he 03,fb
        .he 00,7b
        .he 01,8d
        .he 00,ff
        .he 00,fc
        .he 00,70
        .he 00,40

sprite_a47d
        .he 03,24,6c ; total 108 bytes
sprite_a47d_data
        .he 00,00,00
        .he 00,00,30
        .he 00,00,7c
        .he 00,01,bf
        .he 00,03,bf
        .he 00,0f,bf
        .he 00,3f,be
        .he 00,ff,c6
        .he 00,ff,3c
        .he 00,fc,fe
        .he 00,33,ff
        .he 00,0f,f7
        .he 00,03,c8
        .he 00,30,3a
        .he 00,7b,fa
        .he 00,3b,d3
        .he 00,3b,38
        .he 00,02,f7
        .he 00,00,f7
        .he 00,00,f7
        .he 00,00,ee
        .he 00,00,ee
        .he 00,00,ee
        .he 00,0d,ee
        .he 00,3d,cc
        .he 00,1d,f0
        .he 01,a5,fc
        .he 07,b8,7e
        .he 1f,bd,9e
        .he be,5d,e6
        .he b8,e5,f8
        .he 06,79,fc
        .he df,9c,78
        .he df,e5,98
        .he 0f,f0,00
        .he 00,00,00
sprite_a47d_mask
        .he 00,00,30
        .he 00,00,7c
        .he 00,01,ff
        .he 00,03,ff
        .he 00,0f,ff
        .he 00,3f,ff
        .he 00,ff,ff
        .he 01,ff,ff
        .he 01,ff,ff
        .he 01,ff,ff
        .he 00,ff,ff
        .he 00,3f,ff
        .he 00,3f,ff
        .he 00,7f,ff
        .he 00,ff,ff
        .he 00,7f,ff
        .he 00,7f,ff
        .he 00,3f,ff
        .he 00,03,ff
        .he 00,01,ff
        .he 00,01,ff
        .he 00,01,ff
        .he 00,0f,ff
        .he 00,3f,ff
        .he 00,7f,fe
        .he 01,ff,fe
        .he 07,ff,fe
        .he 1f,ff,ff
        .he bf,ff,ff
        .he ff,ff,ff
        .he ff,ff,fe
        .he ff,ff,fe
        .he ff,ff,fc
        .he ff,ff,fc
        .he ff,ff,98
        .he 0f,f0,00

sprite_a557
        .he 03,31,93 ; total 147 bytes
sprite_a557_data
        .he 00,00,00
        .he 01,c0,00
        .he 37,f0,00
        .he f3,fc,00
        .he ee,fc,00
        .he 7e,fa,00
        .he 7e,bc,00
        .he 7f,5c,00
        .he 0f,6e,00
        .he 3d,72,00
        .he 13,b4,00
        .he 0f,b8,00
        .he 0f,76,00
        .he 1e,f0,00
        .he 19,60,00
        .he 67,98,00
        .he 7f,9e,00
        .he ff,af,00
        .he fc,37,00
        .he 7b,73,00
        .he 33,7b,00
        .he 0d,79,00
        .he 0d,1c,00
        .he 09,6f,00
        .he 06,77,00
        .he 1b,7b,00
        .he 7d,78,c0
        .he 7b,37,c0
        .he 2f,83,c0
        .he 3c,8c,c0
        .he 32,2f,00
        .he 0e,77,c0
        .he 3e,7b,e0
        .he 7e,fd,e0
        .he 38,dc,60
        .he 06,6d,80
        .he 0f,7d,e0
        .he 07,bb,f8
        .he 00,04,fc
        .he 01,ff,3c
        .he 00,7f,cc
        .he 00,1f,80
        .he 00,04,7c
        .he 00,03,fc
        .he 00,03,fe
        .he 00,01,ff
        .he 00,00,ff
        .he 00,00,07
        .he 00,00,00
sprite_a557_mask
        .he 01,c0,00
        .he 37,f0,00
        .he ff,fc,00
        .he ff,ff,00
        .he ff,ff,00
        .he ff,ff,00
        .he ff,fe,00
        .he ff,fe,00
        .he ff,ff,00
        .he 7f,ff,00
        .he 3f,ff,00
        .he 1f,ff,00
        .he 1f,ff,00
        .he 3f,fe,00
        .he 7f,f8,00
        .he ff,fe,00
        .he ff,ff,00
        .he ff,ff,80
        .he ff,ff,80
        .he ff,ff,80
        .he 7f,ff,80
        .he 3f,ff,80
        .he 1f,ff,80
        .he 1f,ff,80
        .he 1f,ff,80
        .he 7f,ff,c0
        .he ff,ff,e0
        .he ff,ff,e0
        .he 7f,ff,e0
        .he 7f,ff,e0
        .he 7f,ff,c0
        .he 3f,ff,e0
        .he 7f,ff,f0
        .he ff,ff,f0
        .he 7f,ff,f0
        .he 3f,ff,e0
        .he 1f,ff,f8
        .he 0f,ff,fc
        .he 07,ff,fe
        .he 03,ff,fe
        .he 01,ff,fe
        .he 00,7f,fc
        .he 00,1f,fe
        .he 00,07,fe
        .he 00,07,ff
        .he 00,03,ff
        .he 00,01,ff
        .he 00,00,ff
        .he 00,00,07

sprite_a67f
        .he 12,22,44 ; total 68 bytes

; mask equals to data

sprite_a67f_data
        .he 00,20
        .he 00,d8
        .he 03,de
        .he 1b,df
        .he 7b,c7
        .he fa,39
        .he e1,fc
        .he 9b,fe
        .he 7b,ff
        .he 7b,ff
        .he 7b,fe
        .he 7a,7e
        .he 79,86
        .he 43,f8
        .he 3b,fc
        .he 7b,fe
        .he 7b,ff
        .he 79,fe
        .he 7a,fe
        .he fb,7c
        .he f7,b0
        .he ef,80
        .he 13,7e
        .he 1c,ff
        .he ef,7f
        .he ef,af
        .he d3,c3
        .he bc,fc
        .he 7f,3e
        .he 3f,ce
        .he 07,f2
        .he 01,fc
        .he 00,78
        .he 00,10

		
		
;ScratchMem: ; A709
;LA709   DB 00
;LA70A   DB 00,00
;LA70C   DW 
;LA70D   DB 76
;LA70E   DB 00
;LA70F   DB 00
;LA710   DW 
;LA711   DB 00
;LA712   DW 0000
;LA714   DB 00
;LA715   DB 00,00
;LA717   DW 0000
;LA719   DW 0000
;LA71B   DW 0000
;LA71D   DB 00
;LA71E   DB 00
;LA71F   DB 00
;LA720   DB 00
;LA721   DB 05
;LA722   DB 00
;LA723   DB 00
;LA724   DB 00
;LA725   DB 00
;LA726   DB 00
;LA727   DB 00
;LA728   DB 00
;LA729   DB 00
;LA72A   DB 00
;LA72B   DB 00
;LA72C   DB 00
;LA72D   DB 00
;LA72E   DB 00
;LA72F   DB 00
;LA730   DB 00
;LA731   DW 0000
;LA732   DW L81D5
;LA734   DB 01
;LA735   DB 00
;LA736   DW 
;LA737   DW 
;LA738   DB 00
;LA739   DW 
;LA73A   DW 0000
;LA73C   DW 
;LA73D   DW 
;LA73E   DW 0000
;LA740   DB 00
;LA741   DW 
;LA742   DW 
;LA743   DB 00
;LA744   DB 00
;LA745   DB 00
;LA746   DB 00
;LA747   DB 01
;LA748   DB 00
;LA749   DB 00
;LA74A   DB 00
;LA74B   DB 00
;LA74C   DB 00
;LA74D   DW 
;LA74E   DB 00
;LA74F   DB 00
;LA750   DW 0000,0000,0000,0000,0000,0000,0000
;A75E:   DW 0000,0000,0000,0000,0000,0000,0000,0000
;A76E:   DB 00
;LA76F   DB 00
;LA770   DB 00
;LA771   DB 00,00,00,00,00
;LA776   DB 00
;LA777   DB 00,00,00
;LA77A   DW 
;LA77B   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A78B:   DB 00,00,00,00,00,00,00
;LA792   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A7A2:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00

ScratchMem: ; A709
LA709   .he 00 ; DB 00
LA70A   .he 00,00 ; DB 00,00
LA70C   .he 00; .wo 0 ; DW 
LA70D   .he 76 ; DB 76
LA70E   .he 00 ; DB 00
LA70F   .he 00 ; DB 00
LA710   .he 00; .wo 0 ; DW 
LA711   .he 00 ; DB 00
LA712   .wo 0000 ; DW 0000
LA714   .he 00 ; DB 00
LA715   .he 00,00 ; DB 00,00
LA717   .wo 0000 ; DW 0000
LA719   .wo 0000 ; DW 0000
LA71B   .wo 0000 ; DW 0000
LA71D   .he 00 ; DB 00
LA71E   .he 00 ; DB 00
LA71F   .he 00 ; DB 00
LA720   .he 00 ; DB 00
LA721   .he 05 ; DB 05
LA722   .he 00 ; DB 00
LA723   .he 00 ; DB 00
LA724   .he 00 ; DB 00
LA725   .he 00 ; DB 00
LA726   .he 00 ; DB 00
LA727   .he 00 ; DB 00
LA728   .he 00 ; DB 00
LA729   .he 00 ; DB 00
LA72A   .he 00 ; DB 00
LA72B   .he 00 ; DB 00
LA72C   .he 00 ; DB 00
LA72D   .he 00 ; DB 00
LA72E   .he 00 ; DB 00
LA72F   .he 00 ; DB 00
LA730   .he 00 ; DB 00
LA731   .he 00 ; DW 0000
LA732   .wo L81D5 ; DW L81D5
LA734   .he 01 ; DB 01
LA735   .he 00 ; DB 00
LA736   .he 00; .wo 0 ; DW 
LA737   .he 00; .wo 0 ; DW 
LA738   .he 00 ; DB 00
LA739   .he 00; .wo 0 ; DW 
LA73A   .wo 0000 ; DW 0000
LA73C   .he 00; .wo 0 ; DW 
LA73D   .he 00; .wo 0 ; DW 
LA73E   .wo 0000 ; DW 0000
LA740   .he 00 ; DB 00
LA741   .he 00; .wo 0 ; DW 
LA742   .he 00; .wo 0 ; DW 
LA743   .he 00 ; DB 00
LA744   .he 00 ; DB 00
LA745   .he 00 ; DB 00
LA746   .he 00 ; DB 00
LA747   .he 01 ; DB 01
LA748   .he 00 ; DB 00
LA749   .he 00 ; DB 00
LA74A   .he 00 ; DB 00
LA74B   .he 00 ; DB 00
LA74C   .he 00 ; DB 00
LA74D   .he 00; .wo 0 ; DW 
LA74E   .he 00 ; DB 00
LA74F   .he 00 ; DB 00
LA750   .wo 0000,0000,0000,0000,0000,0000,0000 ; DW 0000,0000,0000,0000,0000,0000,0000
        .wo 0000,0000,0000,0000,0000,0000,0000,0000 ; DW 0000,0000,0000,0000,0000,0000,0000,0000
        .he 00 ; DB 00
LA76F   .he 00 ; DB 00
LA770   .he 00 ; DB 00
LA771   .he 00,00,00,00,00 ; DB 00,00,00,00,00
LA776   .he 00 ; DB 00
LA777   .he 00,00,00 ; DB 00,00,00
LA77A   .he 00 ; .wo 0 ; DW 
LA77B   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00
LA792   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00

;ScreenMakeUpTable: ; A7AF
;A7AF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A7BF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;LA7CF   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A7DF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;LA7EF   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A7FF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;LA80F   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A81F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;LA82F   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A83F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A84F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A85F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A86F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A87F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A88F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A89F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A8AF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A8BF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A8CF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A8DF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A8EF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A8FF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A90F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A91F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A92F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A93F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A94F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A95F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A96F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A97F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A98F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A99F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A9AF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A9BF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A9CF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A9DF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A9EF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;A9FF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AA0F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AA1F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AA2F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AA3F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AA4F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AA5F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AA6F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AA7F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AA8F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AA9F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AAAF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AABF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AACF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AADF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AAEF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AAFF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AB0F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AB1F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AB2F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AB3F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AB4F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AB5F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AB6F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AB7F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AB8F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AB9F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ABAF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ABBF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ABCF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ABDF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ABEF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ABFF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AC0F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AC1F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AC2F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AC3F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AC4F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AC5F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AC6F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AC7F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AC8F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AC9F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ACAF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ACBF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ACCF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ACDF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ACEF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ACFF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AD0F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AD1F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AD2F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AD3F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AD4F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AD5F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AD6F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AD7F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AD8F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AD9F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ADAF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ADBF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ADCF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ADDF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;LADEF   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;ADFF:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;LAE0F   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;AE1F:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

ScreenMakeUpTable: ; A7AF
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
LA7CF   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
LA7EF   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
LA80F   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
LA82F   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
LADEF   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
LAE0F   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

;JumpTable1: ; AE2F
;AE2F:   DW LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC7AD,LC789
;AE3F:   DW LC7AD,LC789,LCB4E,LCB4E,LC784,LC784,LC784,LC784
;AE4F:   DW LD1F5,LD1F5,LC43F,LC43F,LC43F,LC43F,LC43F,LC285
;AE5F:   DW LC43F,LC43F,LC43F,LC43F,LCD70,LC43F,LC285,LC43F
;AE6F:   DW LC440,LC440,LC440,LC440,LC440,LC440,LC440,LC440
;AE7F:   DW LC5D3,LC5D3,LC5D3,LC5D3,LC5D3,LC5D3,LC5D3,LC5D3
;AE8F:   DW LCC4B,LCC4B,LCC4B,LCC4B,LC784,LC77F,LC77F,LC77F
;AE9F:   DW LC77F,LC74B,LC43F,LC43F,LC1C5,LC43F,LC43F,LCD81
;AEAF:   DW LC111,LC111,LC111,LC111,LC111,LC111,LC111,LC11D
;AEBF:   DW LCD81,LCD7C,LC285,LC285,LCB4E,LCB51,LCDA0,LCD81
;AECF:   DW LD1FD,LD1FD,LCB4E,LC43F,LCDBB,LCE31,LCE9A,LCEA3
;AEDF:   DW LCEDD,LCF22,LD0AC,LCD75,LCEA0,LCEDA,LC43F,LC43F
;AEEF:   DW LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F
;AEFF:   DW LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F
;AF0F:   DW LCF68,LCF68,LCF68,LCF68,LCF68,LCF68,LCF68,LCF68
;AF1F:   DW LCFD2,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14
;AF2F:   DW LCF14,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14
;AF3F:   DW LD2AD,LD2AD,LD2AD,LD2AD,LD2DE,LD2E9,LD2F4,LD2FF
;AF4F:   DW LCD16,LCD16,LCD16,LCD16,LCD16,LC1C5,LC1C5,LC1C5
;AF5F:   DW LCB4E,LCB4E,LCB4E,LCB4E,LCB4E,LCB4E,LCB4E,LCB4E
;AF6F:   DW LCC4B,LCC4B,LCC4B,LCC4B,LCC4B,LCC4B,LCC4B,LCC4B
;AF7F:   DW LD251,LD251,LD251,LD251

JumpTable1: ; AE2F
        .wo LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC7AD,LC789 ; DW LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC7AD,LC789
        .wo LC7AD,LC789,LCB4E,LCB4E,LC784,LC784,LC784,LC784 ; DW LC7AD,LC789,LCB4E,LCB4E,LC784,LC784,LC784,LC784
        .wo LD1F5,LD1F5,LC43F,LC43F,LC43F,LC43F,LC43F,LC285 ; DW LD1F5,LD1F5,LC43F,LC43F,LC43F,LC43F,LC43F,LC285
        .wo LC43F,LC43F,LC43F,LC43F,LCD70,LC43F,LC285,LC43F ; DW LC43F,LC43F,LC43F,LC43F,LCD70,LC43F,LC285,LC43F
        .wo LC440,LC440,LC440,LC440,LC440,LC440,LC440,LC440 ; DW LC440,LC440,LC440,LC440,LC440,LC440,LC440,LC440
        .wo LC5D3,LC5D3,LC5D3,LC5D3,LC5D3,LC5D3,LC5D3,LC5D3 ; DW LC5D3,LC5D3,LC5D3,LC5D3,LC5D3,LC5D3,LC5D3,LC5D3
        .wo LCC4B,LCC4B,LCC4B,LCC4B,LC784,LC77F,LC77F,LC77F ; DW LCC4B,LCC4B,LCC4B,LCC4B,LC784,LC77F,LC77F,LC77F
        .wo LC77F,LC74B,LC43F,LC43F,LC1C5,LC43F,LC43F,LCD81 ; DW LC77F,LC74B,LC43F,LC43F,LC1C5,LC43F,LC43F,LCD81
        .wo LC111,LC111,LC111,LC111,LC111,LC111,LC111,LC11D ; DW LC111,LC111,LC111,LC111,LC111,LC111,LC111,LC11D
        .wo LCD81,LCD7C,LC285,LC285,LCB4E,LCB51,LCDA0,LCD81 ; DW LCD81,LCD7C,LC285,LC285,LCB4E,LCB51,LCDA0,LCD81
        .wo LD1FD,LD1FD,LCB4E,LC43F,LCDBB,LCE31,LCE9A,LCEA3 ; DW LD1FD,LD1FD,LCB4E,LC43F,LCDBB,LCE31,LCE9A,LCEA3
        .wo LCEDD,LCF22,LD0AC,LCD75,LCEA0,LCEDA,LC43F,LC43F ; DW LCEDD,LCF22,LD0AC,LCD75,LCEA0,LCEDA,LC43F,LC43F
        .wo LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F ; DW LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F
        .wo LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F ; DW LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F,LC43F
        .wo LCF68,LCF68,LCF68,LCF68,LCF68,LCF68,LCF68,LCF68 ; DW LCF68,LCF68,LCF68,LCF68,LCF68,LCF68,LCF68,LCF68
        .wo LCFD2,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14 ; DW LCFD2,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14
        .wo LCF14,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14 ; DW LCF14,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14,LCF14
        .wo LD2AD,LD2AD,LD2AD,LD2AD,LD2DE,LD2E9,LD2F4,LD2FF ; DW LD2AD,LD2AD,LD2AD,LD2AD,LD2DE,LD2E9,LD2F4,LD2FF
        .wo LCD16,LCD16,LCD16,LCD16,LCD16,LC1C5,LC1C5,LC1C5 ; DW LCD16,LCD16,LCD16,LCD16,LCD16,LC1C5,LC1C5,LC1C5
        .wo LCB4E,LCB4E,LCB4E,LCB4E,LCB4E,LCB4E,LCB4E,LCB4E ; DW LCB4E,LCB4E,LCB4E,LCB4E,LCB4E,LCB4E,LCB4E,LCB4E
        .wo LCC4B,LCC4B,LCC4B,LCC4B,LCC4B,LCC4B,LCC4B,LCC4B ; DW LCC4B,LCC4B,LCC4B,LCC4B,LCC4B,LCC4B,LCC4B,LCC4B
        .wo LD251,LD251,LD251,LD251 ; DW LD251,LD251,LD251,LD251
		
		
;Start   XOR  A
;AF88:   OUT  (FE),A
;AF8A:   LD   HL,ScratchMem
;AF8D:   LD   BC,0726
;AF90:   CALL ClrMem
;LAF93   LD   HL,LA70E
;AF96:   LD   BC,0721
;AF99:   CALL ClrMem
;AF9C:   CALL ClrScr
;AF9F:   LD   A,43
;AFA1:   CALL FillAttr
;AFA4:   CALL LB29A
;AFA7:   LD   A,05
;AFA9:   LD   (LA721),A
;AFAC:   LD   A,R
;AFAE:   LD   B,A
;AFAF:   LD   A,(LA70D)
;AFB2:   ADD  A,B
;AFB3:   LD   (LA70D),A
;AFB6:   CALL DoMenuSelection
;AFB9:   LD   DE,Audio2
;AFBC:   CALL PlayAudio
;AFBF:   CALL InitObjects
;AFC2:   CALL InitStartLocations
;LAFC5   CALL NewLife
;LAFC8   CALL LB115
;AFCB:   CALL DisplayLocation
;AFCE:   CALL LB097
;AFD1:   CALL LCB89
;AFD4:   CALL PrintScore
;AFD7:   CALL LCC31
;LAFDA   CALL InitMonsters
;AFDD:   LD   IX,A76F
;LAFE1   LD   HL,B00C
;AFE4:   PUSH HL
;AFE5:   LD   BC,JumpTable1
;AFE8:   LD   A,(IX+18)
;AFEB:   LD   (IX+1C),A
;AFEE:   LD   A,(IX+19)
;AFF1:   LD   (IX+1D),A
;AFF4:   LD   A,(IX+1A)
;AFF7:   LD   (IX+1E),A
;AFFA:   LD   A,(IX+1B)
;AFFD:   LD   (IX+1F),A
;B000:   LD   L,(IX+00)

Start 

		lda #$00 ; XOR  A
		sta FlagFrameSkipping
        ;jsr out_fe ; OUT  (FE),A
        lda #<ScratchMem ; LD   HL,ScratchMem
        sta z80_l
        lda #>ScratchMem
        sta z80_h
        lda #<L0726 ; LD   BC,0726
        sta z80_c
        lda #>L0726
        sta z80_b
	
	
        jsr ClrMem ; CALL ClrMem
		
		; set joystick option (2) as default on first entry only
		lda     #02     
		sta     LA709
	
		
; This is where the main menu starts and where we go after a game over.		
LAF93   
		lda #<LA70E ; LD   HL,LA70E
        sta z80_l
        lda #>LA70E
        sta z80_h
        lda #<L0721 ; LD   BC,0721
        sta z80_c
        lda #>L0721
        sta z80_b
        jsr ClrMem ; CALL ClrMem

		
        ;jsr ClrScr ; CALL ClrScr
	
		
        ;lda #$04 ; LD   A,43
        ;jsr FillAttr ; CALL FillAttr

		lda #$04
		sta colourcode
		jsr vdc_colour_clear		
		
		;rot_table generator
        ;jsr LB29A ; CALL LB29A ********************************
        
		lda #$05 ; LD   A,05
        sta LA721 ; LD   (LA721),A
        
		ld_a_r ; LD   A,R
			
        sta z80_b ; LD   B,A
        lda LA70D ; LD   A,(LA70D)
        clc ; ADD  A,B
        adc z80_b
        sta LA70D ; LD   (LA70D),A
				
		;game start
	
		jsr DoMenuSelection ; CALL DoMenuSelection

		; game start audio
		;lda #<Audio2 ; LD   DE,Audio2
        ;sta z80_e
        ;lda #>Audio2
        ;sta z80_d
        ;jsr PlayAudio ; CALL PlayAudio
		
		lda #01
		jsr music_on
		
		lda #05
		sta counter2
		
		
gamestarting01

		jsr c64waitframe
		
		dec counter2
		bne gamestarting01
		
		jsr c64skipkeyheld
		
		lda #140
		sta counter2
		
		ldx #00
		
gamestarting02		
		
		jsr c64skipkey
		lda skipkeyon
		cmp #01
		beq gamestarting03
		
		jsr c64waitframe

		dec counter2
		bne gamestarting02

		inx
		cpx #02
		bne gamestarting02
		
gamestarting03		
		
		jsr c64skipkeyheld
		
		lda #00
		sta counter2
		sta skipkeyon
		
		jsr c64WaitFrame
		
		lda 	soundfx
		bne		@+
		lda		#01
		sta 	sound_e
@		
		
		jsr c64WaitFrame
		
		; if soundfx = 0 (all sound on then play music #06)
;		lda soundfx
;		bne gamestarting04
		
		;lda #06 
        ;jsr music_on
		
;gamestarting04

;		lda soundfx
;		cmp #01
;		bne gamestarting05
;		
;		lda #05 
;       jsr music_on
		
gamestarting05		

		;lda #$00
		;sta $d011
		
		
        jsr InitObjects ; CALL InitObjects
		jsr InitStartLocations ; CALL InitStartLocations

		
LAFC5   jsr NewLife ; CALL NewLife

LAFC8   jsr LB115 ; CALL LB115
		jsr DisplayLocation ; CALL DisplayLocation

		
        jsr LB097 ; CALL LB097
        jsr LCB89 ; CALL LCB89
		
        jsr PrintScore ; CALL PrintScore
        jsr LCC31 ; CALL LCC31		
		
LAFDA   jsr InitMonsters ; CALL InitMonsters
        lda #<LA76F ; LD   IX,A76F
        sta z80_ix
        lda #>LA76F
        sta z80_ix+1
;LAFE1   lda #<(LB00C-1) ; LD   HL,B00C
;        sta z80_l
;        lda #>(LB00C-1)
;        sta z80_h
;        lda z80_h ; PUSH HL
;        pha
;        lda z80_l
;        pha
;		optimization
LAFE1	;lda #>(LB00C-1)
		;pha
		;lda #<(LB00C-1)
		;pha
        ;lda #<JumpTable1 ; LD   BC,JumpTable1
        ;sta z80_c
        ;lda #>JumpTable1
        ;sta z80_b
		ldy #$00
		lda (z80_ix),y
		beq LB00C
		tax
			
		;.if FRAME_SKIPPING == 1
		;lda LastFrameSkipped
		;bne MainLoop_HandleObject
		;.endif
		
		lda FRAME_SKIPPING
		beq frameskip001
		
		lda LastFrameSkipped
		bne MainLoop_HandleObject		
		
frameskip001		
		
        ldy #$18 ; LD   A,(IX+18)
        lda (z80_ix),y
        ldy #$1C ; LD   (IX+1C),A
        sta (z80_ix),y
        ldy #$19 ; LD   A,(IX+19)
        lda (z80_ix),y
        ldy #$1D ; LD   (IX+1D),A
        sta (z80_ix),y
        ldy #$1A ; LD   A,(IX+1A)
        lda (z80_ix),y
        ldy #$1E ; LD   (IX+1E),A
        sta (z80_ix),y
        ldy #$1B ; LD   A,(IX+1B)
        lda (z80_ix),y
        ldy #$1F ; LD   (IX+1F),A
        sta (z80_ix),y
        ;ldy #$00 ; LD   L,(IX+00)
        ;lda (z80_ix),y
        ;sta z80_l

		
;RoutineDispatch: ; B003
;B003:   LD   H,00
;B005:   ADD  HL,HL
;B006:   ADD  HL,BC
;B007:   LD   A,(HL)
;B008:   INC  HL
;B009:   LD   H,(HL)
;B00A:   LD   L,A
;_b00b   JP   (HL)
;B00C:   LD   A,R
;B00E:   LD   B,A
;B00F:   LD   A,(LA715)
;B012:   INC  A
;B013:   LD   H,00
;B015:   LD   L,A
;B016:   ADD  A,(HL)
;B017:   ADD  A,B
;B018:   LD   B,A
;B019:   LD   A,(LA70D)
;B01C:   ADD  A,B
;B01D:   LD   (LA70D),A
;B020:   LD   DE,0020
;B023:   ADD  IX,DE
;B025:   PUSH IX
;B027:   POP  HL
;B028:   LD   DE,JumpTable1
;B02B:   AND  A
;B02C:   SBC  HL,DE
;B02E:   JP   C,LAFE1
;B031:   LD   HL,(LA715)
;B034:   INC  HL
;B035:   LD   (LA715),HL
;B038:   CALL LB531
;B03B:   CALL LB19E
;B03E:   LD   (LA73E),SP
;B042:   CALL LB4E0
;B045:   LD   A,(LA714)
;B048:   NEG
;B04A:   ADD  A,06
;B04C:   LD   B,A
;B04D:   JP   M,LB05C
;B050:   JR   Z,LB05C
;@@2     LD   HL,0500
;@@1     DEC  HL
;B056:   LD   A,L
;B057:   OR   H
;B058:   JR   NZ,@@1
;B05A:   DJNZ @@2
;LB05C   LD   A,(LA711)
;B05F:   AND  A
;B060:   JR   Z,@@3
;B062:   XOR  A
;B063:   LD   (LA711),A
;B066:   LD   A,(LA738)
;B069:   CALL FillAttr
;B06C:   CALL LBA3D
;B06F:   CALL PrintPanel
;B072:   CALL PrintLives
;B075:   CALL UpdateScreen
;B078:   CALL PrintScore
;B07B:   CALL LBF0D
;B07E:   LD   HL,0004
;B081:   LD   (A749),HL
;@@3     CALL LD5F2
;B087:   LD   IX,A76F
;B08B:   LD   A,(IX+00)
;B08E:   OR   (IX+20)
;B091:   JP   Z,LAFC5
;B094:   JP   LAFDA


MainLoop_HandleObject
		txa
		asl @
		tax
		bcs MainLoopJumpHighAddress
		lda JumpTable1,x
		sta MainLoopJump+1
		lda JumpTable1+1,x
		sta MainLoopJump+2
		jmp MainLoopJump
MainLoopJumpHighAddress
		lda JumpTable1+$100,x
		sta MainLoopJump+1
		lda JumpTable1+$100+1,x
		sta MainLoopJump+2
MainLoopJump		
		jsr $ffff
LB00C   ;ld_a_r ; LD   A,R
        ;sta z80_b ; LD   B,A
		
        ;lda LA715 ; LD   A,(LA715)
        ;clc ; INC  A
        ;adc #$01
        ;ldx #$02 ; LD   H,00	; note: reads $00xx, probably used as for random number generating
        ;stx z80_h
        ;sta z80_l ; LD   L,A; 
        ;ldy #$00 ; ADD  A,(HL)
        ;clc
        ;adc (z80_hl),y
		
		ldx LA715
		inx
		txa
		clc
		adc spectrum_rom,x
		
        ;clc ; ADD  A,B
        ;adc z80_b
        ;sta z80_b ; LD   B,A
		;clc

		adc random
        		
		;lda LA70D ; LD   A,(LA70D)
        ;clc ; ADD  A,B
        ;adc z80_b
		;clc
		adc LA70D
        sta LA70D ; LD   (LA70D),A
        ;lda #<L0020 ; LD   DE,0020
        ;sta z80_e
        ;lda #>L0020
        ;sta z80_d
        ;jsr add_ix_de ; ADD  IX,DE
		
		
		lda #$20
		clc
		adc z80_ix
		sta z80_ix
		scc:inc z80_ix+1
        ;lda z80_ix ; PUSH IX
        ;pha
        ;lda z80_ix+1
        ;pha
        ;pla ; POP  HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;lda #<JumpTable1 ; LD   DE,JumpTable1
        ;sta z80_e
        ;lda #>JumpTable1
        ;sta z80_d
		;sec ; AND A
        ;jsr sbc_hl_de ; SBC  HL,DE
		;optimization
		;A holds IX here
		cmp #<JumpTable1
		lda z80_ix+1
		sbc #>JumpTable1		
        jcc LAFE1 ; JP   C,LAFE1
        ;lda LA715 ; LD   HL,(LA715)
        ;sta z80_l
        ;lda LA715+1
        ;sta z80_h
        ;inc z80_l ; INC  HL
        ;bne *+4
        ;inc z80_h
        ;lda z80_l ; LD   (LA715),HL
        ;sta LA715
        ;lda z80_h
        ;sta LA715+1
		;optimization
		inc LA715
		sne:inc LA715+1
        jsr LB531 ; CALL LB531
        jsr LB19E ; CALL LB19E
        ; LD (LA73E),SP ; note: not used
		
        ;jsr LB4E0 ; CALL LB4E0
		;jsr pause_key ; CALL LB4E0
		lda #%11111101; left shift
        sta pra     
        lda prb     
        and #%10000000
        bne @+   
		jsr LB4E0
@
    
;		lda LA714 ; LD   A,(LA714)
;        eor #$ff ; NEG
;        clc
;        adc #$01
;        clc ; ADD  A,06
;        adc #$06
;        sta z80_b ; LD   B,A
;        jmi LB05C ; JP   M,LB05C; 
;        jeq LB05C ; JR   Z,LB05C; 

; delay loop, starts when few sprites were rendered (mostly when hero walking through empty room)

;@@2     lda #<L0500 ; LD   HL,0500
;        sta z80_l
;        lda #>L0500
;        sta z80_h
;@@1     ;jsr dec_hl ; DEC  HL
;		;lda z80_l
;		;sne:dec z80_h
;		;dec z80_l
;        ;lda z80_l ; LD   A,L
;        ;ora z80_h ; OR   H
;        ;jne @@1 ; JR   NZ,@@1
;		dec z80_l
;		jne @@1
;		dec z80_h
;		jne @@1
;        dec z80_b ; DJNZ @@2
;        jne @@2


LB05C   lda LA711 ; LD   A,(LA711)
        ; AND  A
        jeq @@3 ; JR   Z,@@3
		
		;lda #$07
		;sta $d011
		
        lda #$00 ; XOR  A
        sta LA711 ; LD   (LA711),A
        lda LA738 ; LD   A,(LA738)
		
		and #$0f
		sta colourcode
		jsr vdc_colour_clear		
		
        ;jsr FillAttr ; CALL FillAttr

		
        jsr LBA3D ; CALL LBA3D
        ;jsr test999
		jsr PrintPanel ; CALL PrintPanel
        jsr PrintLives ; CALL PrintLives
        jsr UpdateScreen ; CALL UpdateScreen
        jsr PrintScore ; CALL PrintScore
        jsr LBF0D ; CALL LBF0D
        ;lda #<L0004 ; LD   HL,0004
        ;sta z80_l
        ;lda #>L0004
        ;sta z80_h
        ;lda z80_l ; LD   (A749),HL
		lda #$04
        sta LA749
        lda #$00
        sta LA749+1

		;lda #<sfxjingle      ;Start address of sound effect data
        ;ldy #>sfxjingle
        ;ldx #00             ;0, 7 or 14 for channels 1-3
        ;jsr sfx_play_e 		
		
@@3     ;jsr LD5F2 ; CALL LD5F2
        
		;lda #<LA76F ; LD   IX,A76F
        ;sta z80_ix
        ;lda #>LA76F
        ;sta z80_ix+1
        ;ldy #$00 ; LD   A,(IX+00)
        ;lda (z80_ix),y
        ;ldy #$20 ; OR   (IX+20)
        ;ora (z80_ix),y
		lda LA76F
		ora LA76F+$20
        jeq LAFC5 ; JP   Z,LAFC5
        jmp LAFDA ; JP   LAFDA

RoutineDispatch
		lda z80_l
		asl @
		scc:inc z80_b
		tay
		lda (z80_bc),y
		sta z80_l
		iny
		lda (z80_bc),y
		sta z80_h
_b00b   jmp (z80_hl) ; JP   (HL)
		
;LB097   LD   IY,LD422
;B09B:   LD   B,12
;@@13    LD   DE,0010
;B0A0:   LD   A,(LA777)
;B0A3:   LD   C,A
;@@6     ADD  IY,DE
;B0A6:   LD   A,(IY+00)
;B0A9:   AND  A
;B0AA:   JR   Z,@@4
;B0AC:   LD   A,(IY+08)
;B0AF:   CP   C
;B0B0:   JR   Z,@@5
;@@4     DJNZ @@6
;B0B4:   RET

LB097   lda #<LD422 ; LD   IY,LD422
        sta z80_iy
        lda #>LD422
        sta z80_iy+1
        lda #$12 ; LD   B,12
        sta z80_b
@@13    lda #<$0010 ; LD   DE,0010
        sta z80_e
        lda #>$0010
        sta z80_d
        lda LA777 ; LD   A,(LA777)
        sta z80_c ; LD   C,A
@@6     jsr add_iy_de ; ADD  IY,DE
        ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        ; AND  A
        jeq @@4 ; JR   Z,@@4
        ldy #$08 ; LD   A,(IY+08)
        lda (z80_iy),y
        cmp z80_c ; CP   C
        jeq @@5 ; JR   Z,@@5
@@4     dec z80_b ; DJNZ @@6
        jne @@6
        rts ; RET

;@@5     LD   HL,A82F
;B0B8:   LD   DE,0020
;B0BB:   PUSH BC
;B0BC:   LD   B,30
;@@8     LD   A,(HL)
;B0BF:   AND  A
;B0C0:   JR   Z,@@7
;B0C2:   ADD  HL,DE
;B0C3:   DJNZ @@8
;B0C5:   POP  BC
;B0C6:   RET

@@5     lda #<LA82F ; LD   HL,A82F
        sta z80_l
        lda #>LA82F
        sta z80_h
        lda #<L0020 ; LD   DE,0020
        sta z80_e
        lda #>L0020
        sta z80_d
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda #$30 ; LD   B,30
        sta z80_b
@@8     ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ; AND  A
        jeq @@7 ; JR   Z,@@7
        jsr add_hl_de ; ADD  HL,DE
        dec z80_b ; DJNZ @@8
        jne @@8
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        rts ; RET

;@@7     EX   DE,HL
;B0C8:   LD   A,(IY+00)
;B0CB:   AND  F8
;B0CD:   CP   80
;B0CF:   JR   NZ,@@9
;B0D1:   LD   A,(LA70F)
;B0D4:   AND  A
;B0D5:   JR   Z,@@10
;@@9     SET  4,(IY+07)
;B0DB:   PUSH IY
;B0DD:   POP  HL
;B0DE:   LD   BC,0010
;B0E1:   LDIR
;B0E3:   PUSH IY
;B0E5:   POP  HL
;B0E6:   EX   DE,HL
;B0E7:   LD   (HL),E
;B0E8:   INC  HL
;B0E9:   LD   (HL),D
;B0EA:   INC  HL
;B0EB:   LD   B,0E
;B0ED:   XOR  A
;@@11    LD   (HL),A
;B0EF:   INC  HL
;B0F0:   DJNZ @@11
;B0F2:   LD   DE,FFE0
;B0F5:   ADD  HL,DE
;B0F6:   PUSH HL
;B0F7:   POP  IX
;B0F9:   LD   A,(IX+00)
;B0FC:   AND  F8
;B0FE:   CP   80
;B100:   JR   Z,@@10
;@@12    CALL LBF1B
;B105:   JR   NC,@@10
;B107:   LD   A,(IX+03)
;B10A:   ADD  A,0C
;B10C:   LD   (IX+03),A
;B10F:   JR   @@12

@@7     jsr ex_de_hl ; EX   DE,HL
        ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        and #$F8 ; AND  F8
        cmp #$80 ; CP   80
        jne @@9 ; JR   NZ,@@9
        lda LA70F ; LD   A,(LA70F)
        ; AND  A
        jeq @@10 ; JR   Z,@@10
@@9     ldy #$07 ; SET  4,(IY+07)
        lda (z80_iy),y
        ora #_bitvalue4
        sta (z80_iy),y
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        lda #<$0010 ; LD   BC,0010
        sta z80_c
        lda #>$0010
        sta z80_b
        jsr ldir ; LDIR
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        jsr ex_de_hl ; EX   DE,HL
        lda z80_e ; LD   (HL),E
        ldy #$00
        sta (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        lda z80_d ; LD   (HL),D
        ldy #$00
        sta (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        lda #$0E ; LD   B,0E
        sta z80_b
        lda #$00 ; XOR  A
@@11    ldy #$00 ; LD   (HL),A
        sta (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        dec z80_b ; DJNZ @@11
        jne @@11
        lda #<LFFE0 ; LD   DE,FFE0
        sta z80_e
        lda #>LFFE0
        sta z80_d
        jsr add_hl_de ; ADD  HL,DE
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        and #$F8 ; AND  F8
        cmp #$80 ; CP   80
        jeq @@10 ; JR   Z,@@10
@@12    jsr LBF1B ; CALL LBF1B
        jcs @@10 ; JR   NC,@@10
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        clc ; ADD  A,0C
        adc #$0C
        ldy #$03 ; LD   (IX+03),A
        sta (z80_ix),y
        jmp @@12 ; JR   @@12

;@@10    POP  BC
;B112:   DJNZ @@13
;B114:   RET

@@10    pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        dec z80_b ; DJNZ @@13
        jne @@13
        rts ; RET

;LB115   LD   IY,A80F
;B119:   LD   C,30
;@@16    LD   DE,0020
;B11E:   ADD  IY,DE
;B120:   LD   A,(IY+00)
;B123:   LD   HL,LD432
;B126:   LD   DE,0010
;B129:   LD   B,12
;@@15    CP   (HL)
;B12C:   JR   Z,@@14
;B12E:   ADD  HL,DE
;B12F:   DJNZ @@15
;@@17    DEC  C
;B132:   JR   NZ,@@16
;B134:   RET

LB115   lda #<LA80F ; LD   IY,A80F
        sta z80_iy
        lda #>LA80F
        sta z80_iy+1
        lda #$30 ; LD   C,30
        sta z80_c
@@16    lda #<L0020 ; LD   DE,0020
        sta z80_e
        lda #>L0020
        sta z80_d
        jsr add_iy_de ; ADD  IY,DE
        ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
		sta z80_a
        lda #<LD432 ; LD   HL,LD432
        sta z80_l
        lda #>LD432
        sta z80_h
        lda #<$0010 ; LD   DE,0010
        sta z80_e
        lda #>$0010
        sta z80_d
        lda #$12 ; LD   B,12
        sta z80_b
@@15    ldy #$00 ; CP   (HL)
        lda z80_a
        cmp (z80_hl),y; 
        jeq @@14 ; JR   Z,@@14
        jsr add_hl_de ; ADD  HL,DE
        dec z80_b ; DJNZ @@15
        jne @@15
@@17    dec z80_c ; DEC  C
        jne @@16 ; JR   NZ,@@16
        rts ; RET

;@@14    EX   DE,HL
;B136:   PUSH IY
;B138:   POP  HL
;B139:   PUSH BC
;B13A:   LD   BC,0010
;B13D:   LDIR
;B13F:   POP  BC
;B140:   LD   DE,0020
;B143:   JR   @@17

@@14    jsr ex_de_hl ; EX   DE,HL
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda #<$0010 ; LD   BC,0010
        sta z80_c
        lda #>$0010
        sta z80_b
        jsr ldir ; LDIR
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        lda #<L0020 ; LD   DE,0020
        sta z80_e
        lda #>L0020
        sta z80_d
        jmp @@17 ; JR   @@17

;LB145   LD   BC,09B8
;B148:   CALL BCtoAttrInDE
;B14B:   CALL BCtoScrAdr
;B14E:   LD   H,B
;B14F:   LD   L,C
;B150:   LD   C,08
;@@19    PUSH BC
;B153:   PUSH DE
;B154:   LD   BC,0006
;B157:   LDIR
;B159:   POP  DE
;B15A:   DEC  D
;B15B:   LD   A,D
;B15C:   CPL
;B15D:   AND  07
;B15F:   JR   NZ,@@18
;B161:   LD   A,E
;B162:   SUB  20
;B164:   LD   E,A
;B165:   JR   C,@@18
;B167:   LD   A,D
;B168:   ADD  A,08
;B16A:   LD   D,A
;@@18    POP  BC
;B16C:   LD   A,L
;B16D:   ADD  A,1A
;B16F:   LD   L,A
;B170:   LD   A,H
;B171:   ADC  A,00
;B173:   LD   H,A
;B174:   DEC  C
;B175:   JR   NZ,@@19
;B177:   RET

; blit score in game
LB145
		
		;lda #$30 ; Open up all RAM
		;sta $01 

		;dec $01

		;inc $ff00

		STA $D07A
		
		lda #<$e217
        sta source_lo
        lda #>$e217
        sta source_hi
		
		lda #<$15f7
        sta dest_lo
        lda #>$15f7
        sta dest_hi
		
		lda #$08
		sta count_temp

score_print
		
		lda dest_hi
		ldx #18
		jsr vdcwrite
		lda dest_lo
		inx
		;STA $D07A
		stx $d600		
		sta $d601
		;STA $D07B
		
		
		ldy #00
@		
		lda (source_lo),y
		ldx #31		 
		stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
		cpy #06
		bne @-1		
		

		lda dest_lo
		clc
		adc #32
		sta dest_lo
		scc:inc dest_hi


		lda source_lo
		sec
		sbc #32
		sta source_lo
		scs:dec source_hi		
			

		dec count_temp
		lda count_temp
		jne score_print	
		
		

		; put IO back in
		;lda #$35
		;sta $01 		
		
		;inc $01
		
		;dec $ff00
		
		STA $D07B
		
		rts

;		lda #<L09B8 ; LD   BC,09B8
;        sta z80_c
;        lda #>L09B8
;        sta z80_b
;        jsr BCtoAttrInDE ; CALL BCtoAttrInDE
;        jsr BCtoScrAdr ; CALL BCtoScrAdr
				
;        lda z80_b ; LD   H,B
;        sta z80_h
;        lda z80_c ; LD   L,C
;        sta z80_l
;        lda #$08 ; LD   C,08
;        sta z80_c
;@@19    lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        lda #<L0006 ; LD   BC,0006
;        sta z80_c
;        lda #>L0006
;        sta z80_b		
;        jsr ldir ; LDIR
;        pla ; POP  DE
;        sta z80_d
;        pla
;        sta z80_e
;        dec z80_d ; DEC  D
;        lda z80_d ; LD   A,D
;        eor #$ff ; CPL
;        and #$07 ; AND  07
;        jne @@18 ; JR   NZ,@@18
;        lda z80_e ; LD   A,E
;        sec ; SUB  20
;        sbc #$20
;        sta z80_e ; LD   E,A
;        jcc @@18 ; JR   C,@@18; 
;        lda z80_d ; LD   A,D
;        clc ; ADD  A,08
;        adc #$08
;        sta z80_d ; LD   D,A
;@@18    pla ; POP  BC
;        sta z80_b
;        pla
;        sta z80_c
;        lda z80_l ; LD   A,L
;        clc ; ADD  A,1A
;        adc #$1A
;        sta z80_l ; LD   L,A
;        lda z80_h ; LD   A,H
;        adc #$00 ; ADC  A,00
;        sta z80_h ; LD   H,A
;        dec z80_c ; DEC  C
;        jne @@19 ; JR   NZ,@@19
				
;        rts ; RET

;UpdateScreen: ; B178
;B178:   LD   HL,ScreenBuffer
;B17B:   LD   DE,57E0
;B17E:   LD   C,C0
;@@21    PUSH BC
;B181:   PUSH DE
;B182:   LD   BC,0020
;B185:   LDIR
;B187:   POP  DE
;B188:   DEC  D
;B189:   LD   A,D
;B18A:   CPL
;B18B:   AND  07
;B18D:   JR   NZ,@@20
;B18F:   LD   A,E
;B190:   SUB  20
;B192:   LD   E,A
;B193:   JR   C,@@20
;B195:   LD   A,D
;B196:   ADD  A,08
;B198:   LD   D,A
;@@20    POP  BC
;B19A:   DEC  C
;B19B:   JR   NZ,@@21
;B19D:   RET

UpdateScreen: ; B178
;        lda #<ScreenBuffer ; LD   HL,ScreenBuffer
;        sta z80_l
;        lda #>ScreenBuffer
;        sta z80_h
;        lda #<L57E0 ; LD   DE,57E0
;        sta z80_e
;        lda #>L57E0
;        sta z80_d
;        lda #$C0 ; LD   C,C0
;        sta z80_c
;@@21    lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        lda #<L0020 ; LD   BC,0020
;        sta z80_c
;        lda #>L0020
;        sta z80_b
;		jsr ldir ; LDIR
;		pla ; POP  DE
;        sta z80_d
;        pla
;        sta z80_e
;        dec z80_d ; DEC  D
;        lda z80_d ; LD   A,D
;        eor #$ff ; CPL
;        and #$07 ; AND  07
;        jne @@20 ; JR   NZ,@@20
;        lda z80_e ; LD   A,E
;        sec ; SUB  20
;        sbc #$20
;        sta z80_e ; LD   E,A
;        jcc @@20 ; JR   C,@@20; 
;        lda z80_d ; LD   A,D
;        clc ; ADD  A,08
;        adc #$08
;        sta z80_d ; LD   D,A
;@@20    pla ; POP  BC
;        sta z80_b
;        pla
;        sta z80_c
;        dec z80_c ; DEC  C
;        jne @@21 ; JR   NZ,@@21
		
		;lda #$00
		;sta $d011
		
		;jsr c64colours
		;jsr c64screen
		;jsr cbmscreen
		
		jsr vdc_colour_copy
		jsr vdcscreen
		
		;lda #$17
		;sta $d011
		
        rts ; RET

;LB19E   XOR  A
;B19F:   LD   (LA710),A
;B1A2:   PUSH IX
;B1A4:   LD   A,(LA711)
;B1A7:   AND  A
;B1A8:   JP   NZ,LB252
;B1AB:   LD   HL,LB55A
;B1AE:   LD   (LA712),HL
;@@22    LD   HL,(LA712)
;B1B4:   LD   A,(HL)
;B1B5:   INC  HL
;B1B6:   LD   (LA712),HL
;B1B9:   CP   FF
;B1BB:   JP   Z,LB252
;B1BE:   CALL LB520
;B1C1:   PUSH HL
;B1C2:   POP  IX
;B1C4:   BIT  5,(IX+07)
;B1C8:   JR   Z,@@22
;B1CA:   RES  5,(IX+07)
;B1CE:   LD   A,(IX+1A)
;B1D1:   SUB  (IX+1E)
;B1D4:   JP   C,LB248
;B1D7:   LD   C,(IX+1E)
;@@27    LD   A,(IX+1E)
;B1DD:   RRCA
;B1DE:   RRCA
;B1DF:   RRCA
;B1E0:   AND  1F
;B1E2:   ADD  A,(IX+1C)
;B1E5:   LD   E,A
;B1E6:   LD   A,(IX+1A)
;B1E9:   RRCA
;B1EA:   RRCA
;B1EB:   RRCA
;B1EC:   AND  1F
;B1EE:   ADD  A,(IX+18)
;B1F1:   CP   E
;B1F2:   JR   C,@@23
;B1F4:   LD   E,A
;@@23    LD   A,C
;B1F6:   RRCA
;B1F7:   RRCA
;B1F8:   RRCA
;B1F9:   AND  1F
;B1FB:   LD   B,A
;B1FC:   LD   A,E
;B1FD:   SUB  B
;B1FE:   LD   H,A
;B1FF:   LD   A,(IX+1B)
;B202:   SUB  (IX+1F)
;B205:   JR   C,@@24
;B207:   LD   B,(IX+1F)
;@@28    LD   A,(IX+1F)
;B20D:   ADD  A,(IX+1D)
;B210:   LD   E,A
;B211:   LD   A,(IX+1B)
;B214:   ADD  A,(IX+19)
;B217:   CP   E
;B218:   JR   NC,@@25
;B21A:   LD   A,E
;@@25    SUB  B
;B21C:   LD   L,A
;B21D:   LD   A,B
;B21E:   CP   C0
;B220:   JR   NC,@@22
;B222:   ADD  A,L
;B223:   SUB  C0
;B225:   JR   C,@@26
;B227:   NEG
;B229:   ADD  A,L
;B22A:   LD   L,A
;@@26    CALL BCtoAttrInDE
;B22E:   CALL BCtoScrAdr
;B231:   LD   A,L
;B232:   LD   L,C
;B233:   LD   C,A
;B234:   LD   A,H
;B235:   LD   H,B
;B236:   LD   B,A
;B237:   LD   A,(LA710)
;B23A:   INC  A
;B23B:   LD   (LA710),A
;B23E:   PUSH BC
;B23F:   PUSH DE
;B240:   PUSH HL
;B241:   XOR  A
;B242:   CALL LB6DD
;B245:   JP   @@22

LastFrameStartSync
		dta 0
		
FrameSync
		;lda LA711
		;bne FrameSyncEnd
FrameSyncWait		
		lda frame_counter
		sec
		sbc LastFrameStartSync
		bpl FrameSyncCounterPositive
		eor #$ff
		clc
		adc #$01
FrameSyncCounterPositive
		cmp FRAME_MIN
		bcc FrameSyncWait
FrameSyncEnd
		lda frame_counter
		sta LastFrameStartSync
		rts


		;.if FRAME_SKIPPING == 1
LastFrameStart	dta 0
LastFrameStartFlag	dta 0
LastFrameSkipped dta 0


FrameSkipping
		lda FlagFrameSkipping
		bpl ResetFrameSkipping
		lda LA711
		bne ResetFrameSkipping
		lda LastFrameStartFlag
		beq StartFrameSkipping
		lda frame_counter
		sec
		sbc LastFrameStart
		bpl FrameCounterPositive
		eor #$ff
		clc
		adc #$01
FrameCounterPositive		
		cmp FRAME_SKIPPING_THRESHOLD
		bcc StartFrameSkipping
		lda frame_counter	; skip rendering this frame
		sta LastFrameStart
		pla
		pla
		lda #$1
		sta LastFrameSkipped
		rts
StartFrameSkipping
;		cmp #FRAME_MIN
;		bcc FrameWait
		lda #1
		sta LastFrameStartFlag
		lda frame_counter
		sta LastFrameStart
		lda #$0
		sta LastFrameSkipped
		rts
ResetFrameSkipping
		lda #0
		sta LastFrameStartFlag
		lda #$0
		sta LastFrameSkipped
		rts
		;.endif


LB19E
		jsr FrameSync
		;.if FRAME_SKIPPING == 1
		;jsr FrameSkipping
		;.endif
		
		lda FRAME_SKIPPING
		beq frameskip002
		
		jsr FrameSkipping
		
frameskip002
		
		lda #$00 ; XOR  A
        sta LA710 ; LD   (LA710),A
        lda z80_ix ; PUSH IX
        pha
        lda z80_ix+1
        pha
        lda LA711 ; LD   A,(LA711)
        ; AND  A: 
        jne LB252 ; JP   NZ,LB252
        ;lda #<LB55A ; LD   HL,LB55A
        ;sta z80_l
        ;lda #>LB55A
        ;sta z80_h
        ;lda z80_l ; LD   (LA712),HL
        ;sta LA712
        ;lda z80_h
        ;sta LA712+1
		sta LA712
@@22    ;lda LA712 ; LD   HL,(LA712)
        ;sta z80_l
        ;lda LA712+1
        ;sta z80_h
        ;ldy #$00 ; LD   A,(HL)
        ;lda (z80_hl),y
		;tax
        ;inc z80_l ; INC  HL
        ;bne *+4
        ;inc z80_h
        ;lda z80_l ; LD   (LA712),HL
        ;sta LA712
        ;lda z80_h
        ;sta LA712+1
		;txa
		ldy LA712
		lda LB55A,y
		inc LA712
        cmp #$FF ; CP   FF; 
        jeq LB252 ; JP   Z,LB252
		ldx #z80_ix
        jsr LB520 ; CALL LB520
		;optimization
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;pla ; POP  IX
        ;sta z80_ix+1
        ;pla
        ;sta z80_ix
        ldy #$07 ; BIT  5,(IX+07)
        lda (z80_ix),y
        bit _bitmem5
        jeq @@22 ; JR   Z,@@22
        ;ldy #$07 ; RES  5,(IX+07)
        ;lda (z80_ix),y
        and #_notbitvalue5
        sta (z80_ix),y
        ldy #$1A ; LD   A,(IX+1A)
        lda (z80_ix),y
        ldy #$1E ; SUB  (IX+1E)
        ;sec
        ;sbc (z80_ix),y
		cmp (z80_ix),y
        jcc LB248 ; JP   C,LB248
        ;ldy #$1E ; LD   C,(IX+1E) ; Y = 1E here
        lda (z80_ix),y
        sta z80_c
@@27    ;ldy #$1E ; LD   A,(IX+1E) ; Y = 1E here
        lda (z80_ix),y
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        ;and #$1F ; AND  1F ; not needed
        ldy #$1C ; ADD  A,(IX+1C)
        clc
        adc (z80_ix),y
        sta z80_e ; LD   E,A
        ldy #$1A ; LD   A,(IX+1A)
        lda (z80_ix),y
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        ;and #$1F ; AND  1F ; not needed
        ldy #$18 ; ADD  A,(IX+18)
        clc
        adc (z80_ix),y
        cmp z80_e ; CP   E
        jcc @@23 ; JR   C,@@23
        sta z80_e ; LD   E,A; 
@@23    lda z80_c ; LD   A,C
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        ;and #$1F ; AND  1F ; not needed
        sta z80_b ; LD   B,A
        lda z80_e ; LD   A,E
        sec ; SUB  B
        sbc z80_b
        sta z80_h ; LD   H,A
        ldy #$1B ; LD   A,(IX+1B)
        lda (z80_ix),y
        ldy #$1F ; SUB  (IX+1F)
        ;sec
        ;sbc (z80_ix),y
		cmp (z80_ix),y
        jcc @@24 ; JR   C,@@24
        ;ldy #$1F ; LD   B,(IX+1F) ; Y = 1F here
        lda (z80_ix),y
        sta z80_b
@@28    ;ldy #$1F ; LD   A,(IX+1F) ; Y = 1F here
        lda (z80_ix),y
        ldy #$1D ; ADD  A,(IX+1D)
        clc
        adc (z80_ix),y
        sta z80_e ; LD   E,A
        ldy #$1B ; LD   A,(IX+1B)
        lda (z80_ix),y
        ldy #$19 ; ADD  A,(IX+19)
        clc
        adc (z80_ix),y
        cmp z80_e ; CP   E
        jcs @@25 ; JR   NC,@@25
        lda z80_e ; LD   A,E
@@25    sec ; SUB  B
        sbc z80_b
        sta z80_l ; LD   L,A
        lda z80_b ; LD   A,B
        cmp #$C0 ; CP   C0
        jcs @@22 ; JR   NC,@@22
        clc ; ADD  A,L
        adc z80_l; 
        sec ; SUB  C0
        sbc #$C0
        jcc @@26 ; JR   C,@@26
        eor #$ff ; NEG
        clc
        adc #$01; 
        clc ; ADD  A,L
        adc z80_l
        sta z80_l ; LD   L,A
@@26    jsr BCtoAttrInDE ; CALL BCtoAttrInDE
        jsr BCtoScrAdr ; CALL BCtoScrAdr
        lda z80_l ; LD   A,L
        ldx z80_c ; LD   L,C
        stx z80_l
        sta z80_c ; LD   C,A;
		pha			; PUSH C
        lda z80_h ; LD   A,H
        ldx z80_b ; LD   H,B
        stx z80_h
        sta z80_b ; LD   B,A; 
		pha			; PUSH B
        ;lda LA710 ; LD   A,(LA710)
        ;clc ; INC  A
        ;adc #$01
        ;sta LA710 ; LD   (LA710),A
		inc LA710
        ;lda z80_c ; PUSH BC
        ;pha
        ;lda z80_b
        ;pha
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda #$00 ; XOR  A
        jsr LB6DD ; CALL LB6DD
        jmp @@22 ; JP   @@22

;LB248   LD   C,(IX+1A)
;B24B:   JR   @@27

LB248   ;ldy #$1A ; LD   C,(IX+1A) ; A = (IX+1A)
        ;lda (z80_ix),y
        sta z80_c
        jmp @@27 ; JR   @@27

;@@24    LD   B,(IX+1B)
;B250:   JR   @@28

@@24    ;ldy #$1B ; LD   B,(IX+1B) ; A = (IX+1B)
        ;lda (z80_ix),y
        sta z80_b
        jmp @@28 ; JR   @@28

;LB252   CALL LB58A
;B255:   CALL LBA34
;B258:   LD   HL,LA710
;B25B:   LD   A,(LA714)
;B25E:   ADD  A,(HL)
;B25F:   LD   (LA714),A
;@@30    LD   HL,LA710
;B265:   LD   A,(HL)
;B266:   AND  A
;B267:   JR   Z,@@29
;B269:   DEC  (HL)
;B26A:   POP  HL
;B26B:   POP  DE
;B26C:   POP  BC
;B26D:   LD   A,B
;B26E:   LD   B,C
;B26F:   LD   C,A
;B270:   CALL LB278
;B273:   JR   @@30

LB252   jsr LB58A ; CALL LB58A
        jsr LBA34 ; CALL LBA34
        ;lda #<LA710 ; LD   HL,LA710
        ;sta z80_l
        ;lda #>LA710
        ;sta z80_h
        ;lda LA714 ; LD   A,(LA714)
        ;ldy #$00 ; ADD  A,(HL)
        ;clc
        ;adc (z80_hl),y
        ;sta LA714 ; LD   (LA714),A
		lda LA714
		clc
		adc LA710
		sta LA714
@@30    ;lda #<LA710 ; LD   HL,LA710
        ;sta z80_l
        ;lda #>LA710
        ;sta z80_h
        ;ldy #$00 ; LD   A,(HL)
        ;lda (z80_hl),y
		lda LA710
        ; AND  A
        jeq @@29 ; JR   Z,@@29
        ;ldy #$00 ; DEC  (HL)
        ;lda (z80_hl),y
        ;sec
        ;sbc #$01
        ;sta (z80_hl),y
		dec LA710
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP  BC
        sta z80_c
        pla
        sta z80_b
        ;lda z80_b ; LD   A,B
        ;ldx z80_c ; LD   B,C
        ;stx z80_b
        ;sta z80_c ; LD   C,A; 
        
		jsr LB278 ; CALL LB278	; blit window to screen
        ;jsr test999
		
		jmp @@30 ; JR   @@30

;@@29    POP  IX
;B277:   RET

@@29    pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix
        rts ; RET

;LB278   PUSH BC
;B279:   PUSH DE
;B27A:   PUSH HL
;B27B:   LD   B,00
;B27D:   LDIR
;B27F:   POP  HL
;B280:   LD   DE,0020
;B283:   ADD  HL,DE
;B284:   POP  DE
;B285:   DEC  D
;B286:   LD   A,D
;B287:   CPL
;B288:   AND  07
;B28A:   JR   NZ,@@31
;B28C:   LD   A,E
;B28D:   SUB  20
;B28F:   LD   E,A
;B290:   JR   C,@@31
;B292:   LD   A,D
;B293:   ADD  A,08
;B295:   LD   D,A
;@@31    POP  BC
;B297:   DJNZ LB278
;B299:   RET

;LB278   lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;        lda #$00 ; LD   B,00
;        sta z80_b
;        jsr ldir ; LDIR
;        pla ; POP  HL
;        sta z80_h
;        pla
;        sta z80_l
;        lda #<L0020 ; LD   DE,0020
;        sta z80_e
;        lda #>L0020
;        sta z80_d
;        jsr add_hl_de ; ADD  HL,DE
;        pla ; POP  DE
;        sta z80_d
;        pla
;        sta z80_e
;        dec z80_d ; DEC  D
;        lda z80_d ; LD   A,D
;        eor #$ff ; CPL
;        and #$07 ; AND  07
;        jne @@31 ; JR   NZ,@@31
;        lda z80_e ; LD   A,E
;        sec ; SUB  20
;        sbc #$20
;        sta z80_e ; LD   E,A
;        jcc @@31 ; JR   C,@@31; 
;        lda z80_d ; LD   A,D
;        clc ; ADD  A,08
;        adc #$08
;        sta z80_d ; LD   D,A
;@@31    pla ; POP  BC
;        sta z80_b
;        pla
;        sta z80_c
;        dec z80_b ; DJNZ LB278
;        jne LB278
;        rts ; RET

; optimization

; blit_to_screen
; HL = buffer from		starts at $e000 to $f7ff
; DE = screen dest		starts at $c000 to $d7ff

; blit sprite to screen

LB278

		;lda #$30 			; open up all RAM
		;sta $01 
		;dec $01
		
		;inc $ff00
		
		;dec z80_c
		
		STA $D07A
		
LB278_002
		
		;ldy #$00	
		
		; use tables to convert buffer address into screen address then...
		; force table value of screen address into modified address (blitad)
		ldx z80_l
		lda sprite_blit_table_lo,x
		sta c64_lo
		
		;iny
		
		ldx z80_h
		lda sprite_blit_table_hi,x
		sta c64_hi

		
		;lda c64_hi
		ldx #18
		stx $d600
@
		bit $d600
		bpl @-
		sta $d601		
		lda c64_lo
		inx
		;STA $D07A
		stx $d600		
		sta $d601
		;STA $D07B

		
		; width of sprite and size of loop below		
		;ldy z80_c
		;dey
		ldy #$00
		
		ldx #31
		stx $d600
		
; blit width of sprite loop		
LB278_001
		
		;ldx  X_Table_Count,y ; Deal with C64 screen format							
		
		lda (z80_hl),y	; SOURCE sprite image data									

@
		bit $d600
		bpl @-
		sta $d601		

		
;blitad	sta $ffff,x		; Self mod code dest. DESTINATION store first 8 pixels block E	
			
		;dey																			
		;bpl LB278_001																

		iny
		cpy z80_c
		bne LB278_001
		
		
		lda #$20	; ADD HL,0020	; next line for source
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
		
		dec z80_b ; DJNZ LB278		; done all lines? z80_b = hight (number of lines) max 27 lines
		
		bne LB278_002
		
		; put IO back in
		;lda #$35
		;sta $01 
		
		;inc $01

		;dec $ff00
		
		STA $D07B
		
		rts 
;LB278

;		ldy #$00		; LDIR
	
;LB278_loop
		
;		lda (z80_hl),y				; sprite image data
;		sta (z80_de),y
		
;		iny
;		cpy z80_c					; width of sprite - 04?
;		bne LB278_loop
		
;		lda #$20	; ADD HL,0020	; next line
;		clc
;		adc z80_l
;		sta z80_l
;		scc:inc z80_h
;        dec z80_d ; DEC  D
;        lda z80_d ; LD   A,D
;        eor #$ff ; CPL
;        and #$07 ; AND  07
;        jne @@31 ; JR   NZ,@@31
;        lda z80_e ; LD   A,E
;        sec ; SUB  20
;        sbc #$20
;        sta z80_e ; LD   E,A
;        jcc @@31 ; JR   C,@@31; 
;        lda z80_d ; LD   A,D
;        clc ; ADD  A,08
;        adc #$08
;        sta z80_d ; LD   D,A
;@@31    dec z80_b ; DJNZ LB278		; done all lines? z80_b = hight (number of lines)
;		jne LB278
 
;		rts ; RET
		
;LB29A   LD   L,00
;@@33    LD   D,00
;B29E:   LD   E,L
;B29F:   LD   H,FF
;B2A1:   LD   B,07
;@@32    SLA  E
;B2A5:   RL   D
;B2A7:   LD   A,E
;B2A8:   CPL
;B2A9:   LD   (HL),A
;B2AA:   DEC  H
;B2AB:   LD   A,D
;B2AC:   CPL
;B2AD:   LD   (HL),A
;B2AE:   DEC  H
;B2AF:   DJNZ @@32
;B2B1:   INC  L
;B2B2:   JR   NZ,@@33
;B2B4:   LD   HL,F100
;@@35    LD   D,L
;B2B8:   LD   B,08
;@@34    SRL  D
;B2BC:   RL   E
;B2BE:   DJNZ @@34
;B2C0:   LD   (HL),E
;B2C1:   INC  L
;B2C2:   JR   NZ,@@35
;B2C4:   RET


;rot_table generator
;LB29A   lda #$00 ; LD   L,00
;        sta z80_l
;@@33    lda #$00 ; LD   D,00
;        sta z80_d
;        lda z80_l ; LD   E,L
;        sta z80_e
;        lda #>(rot_table + $0d00); $FF ; LD   H,FF
;        sta z80_h
;        lda #$07 ; LD   B,07
;        sta z80_b
;@@32    asl z80_e ; SLA  E
;        rol z80_d ; RL   D
;        lda z80_e ; LD   A,E
;        eor #$ff ; CPL
;        ldy #$00 ; LD   (HL),A
;        sta (z80_hl),y
;        dec z80_h ; DEC  H
;        lda z80_d ; LD   A,D
;        eor #$ff ; CPL
;        ldy #$00 ; LD   (HL),A
;        sta (z80_hl),y
;        dec z80_h ; DEC  H
;        dec z80_b ; DJNZ @@32
;        jne @@32
;        inc z80_l ; INC  L
;        jne @@33 ; JR   NZ,@@33
;        lda #<LF100 ; LD   HL,F100
;        sta z80_l
;        lda #>LF100
;        sta z80_h
;@@35    lda z80_l ; LD   D,L
;        sta z80_d
;        lda #$08 ; LD   B,08
;        sta z80_b
;@@34    lsr z80_d ; SRL  D
;        rol z80_e ; RL   E
;        dec z80_b ; DJNZ @@34
;        jne @@34
;        lda z80_e ; LD   (HL),E
;        ldy #$00
;        sta (z80_hl),y
;        inc z80_l ; INC  L
;        jne @@35 ; JR   NZ,@@35
;        rts ; RET


;LB2C5   LD   A,(IX+01)
;B2C8:   ADD  A,(IX+02)
;B2CB:   SUB  80
;B2CD:   ADD  A,(IX+12)
;B2D0:   JR   C,@@36
;B2D2:   XOR  A
;@@36    LD   (IX+1A),A
;B2D6:   LD   A,(IX+02)
;B2D9:   SUB  (IX+01)
;B2DC:   ADD  A,80
;B2DE:   SRL  A
;B2E0:   ADD  A,(IX+03)
;B2E3:   SUB  68
;B2E5:   ADD  A,(IX+13)
;B2E8:   LD   (IX+1B),A
;B2EB:   CP   C0
;B2ED:   RET

LB2C5   ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        ldy #$02 ; ADD  A,(IX+02)
        clc
        adc (z80_ix),y
        sec ; SUB  80
        sbc #$80
        ldy #$12 ; ADD  A,(IX+12)
        clc
        adc (z80_ix),y
        jcs @@36 ; JR   C,@@36; 
        lda #$00 ; XOR  A
@@36    ldy #$1A ; LD   (IX+1A),A
        sta (z80_ix),y
        ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        ldy #$01 ; SUB  (IX+01)
        sec
        sbc (z80_ix),y
        clc ; ADD  A,80
        adc #$80
        lsr @ ; SRL  A
        ldy #$03 ; ADD  A,(IX+03)
        clc
        adc (z80_ix),y
        sec ; SUB  68
        sbc #$68
        ldy #$13 ; ADD  A,(IX+13)
        clc
        adc (z80_ix),y
        ldy #$1B ; LD   (IX+1B),A
        sta (z80_ix),y
        cmp #$C0 ; CP   C0
        rts ; RET

;LB2EE   LD   L,(IX+00)
;B2F1:   LD   H,00
;B2F3:   ADD  HL,HL
;B2F4:   LD   BC,SprGfxTable
;B2F7:   ADD  HL,BC
;B2F8:   LD   E,(HL)
;B2F9:   INC  HL
;B2FA:   LD   D,(HL)
;B2FB:   LD   A,(DE)
;B2FC:   AND  A
;B2FD:   JR   NZ,@@37
;B2FF:   INC  SP
;B300:   INC  SP
;B301:   RET

LB2EE   ldy #$00 ; LD   L,(IX+00)
        lda (z80_ix),y
        ;sta z80_l
        ;lda #$00 ; LD   H,00
        ;sta z80_h
        ;asl z80_l ; ADD  HL,HL
        ;rol z80_h
        ;lda #<SprGfxTable ; LD   BC,SprGfxTable
        ;sta z80_c
        ;lda #>SprGfxTable
        ;sta z80_b
        ;jsr add_hl_bc ; ADD  HL,BC
		;sty z80_h
		asl @
		tax
		bcs LB2EE_high_sprite_table
		lda SprGfxTable,x
		sta z80_e
		lda SprGfxTable+1,x
		sta z80_d
		jmp LB2EE_CheckEmptySprite
LB2EE_high_sprite_table
		lda SprGfxTable+$100,x
		sta z80_e
		lda SprGfxTable+$100+1,x
		sta z80_d		
		;rol z80_h
		;adc #<SprGfxTable
		;sta z80_l
		;lda z80_h
		;adc #>SprGfxTable
		;sta z80_h
        ;ldy #$00 ; LD   E,(HL)
        ;lda (z80_hl),y
        ;sta z80_e
        ;inc z80_l ; INC  HL
        ;bne *+4
        ;inc z80_h
        ;ldy #$00 ; LD   D,(HL)
		;iny
        ;lda (z80_hl),y
        ;sta z80_d
        ;ldy #$00 ; LD   A,(DE)
LB2EE_CheckEmptySprite		
        lda (z80_de),y
        ; AND  A
        jne @@37 ; JR   NZ,@@37
        pla ; INC  SP
        pla ; INC  SP
        rts ; RET

;@@37    PUSH DE
;B303:   LD   A,(DE)
;B304:   XOR  (IX+07)
;B307:   AND  80
;B309:   JR   Z,@@38
;B30B:   LD   A,(DE)
;B30C:   XOR  80
;B30E:   LD   (DE),A
;B30F:   RLCA
;B310:   AND  1E
;B312:   LD   B,A
;B313:   INC  DE
;B314:   LD   A,(DE)
;B315:   LD   C,A
;B316:   INC  DE
;B317:   PUSH BC
;B318:   PUSH DE
;B319:   LD   E,C
;B31A:   LD   D,00
;B31C:   LD   H,D
;B31D:   LD   L,D
;@@39    ADD  HL,DE
;B31F:   DJNZ @@39
;B321:   POP  DE
;B322:   POP  BC
;B323:   ADD  HL,DE
;B324:   EX   DE,HL
;B325:   LD   A,B
;B326:   CALL Add_HL_A
;B329:   DEC  DE
;B32A:   DEC  HL
;B32B:   SRL  C
;@@41    PUSH BC
;@@40    LD   A,(DE)
;B32F:   LD   C,(HL)
;B330:   LD   (HL),A
;B331:   LD   A,C
;B332:   LD   (DE),A
;B333:   DEC  HL
;B334:   DEC  DE
;B335:   DJNZ @@40
;B337:   POP  BC
;B338:   LD   A,B
;B339:   CALL Add_HL_A
;B33C:   LD   A,B
;B33D:   CALL Add_HL_A
;B340:   DEC  C
;B341:   JR   NZ,@@41
;@@38    POP  DE
;B344:   PUSH DE
;B345:   LD   A,(DE)
;B346:   XOR  (IX+07)
;B349:   AND  40
;B34B:   JR   Z,@@42
;B34D:   LD   A,(DE)
;B34E:   XOR  40
;B350:   LD   (DE),A
;B351:   AND  0F
;B353:   LD   B,A
;B354:   LD   C,A
;B355:   INC  DE
;B356:   LD   A,(DE)
;B357:   EX   AF,AF'
;B358:   INC  DE
;B359:   EX   DE,HL
;B35A:   PUSH HL
;B35B:   EXX
;B35C:   POP  HL
;B35D:   LD   B,F1
;B35F:   EXX
;@@43    EXX
;B361:   LD   C,(HL)
;B362:   LD   A,(BC)
;B363:   LD   E,A
;B364:   INC  HL
;B365:   LD   C,(HL)
;B366:   LD   A,(BC)
;B367:   LD   D,A
;B368:   INC  HL
;B369:   PUSH DE
;B36A:   EXX
;B36B:   DJNZ @@43
;B36D:   LD   B,C
;@@44    POP  DE
;B36F:   LD   (HL),E
;B370:   INC  HL
;B371:   LD   (HL),D
;B372:   INC  HL
;B373:   DJNZ @@44
;B375:   EX   AF,AF'
;B376:   DEC  A
;B377:   JR   Z,@@42
;B379:   EX   AF,AF'
;B37A:   LD   B,C
;B37B:   JR   @@43

@@37    ; compute address of mask
		ldx #$00
		and #$10
		bne LB2EE_no_mask
		dex
		; calc mask address
		lda #SPRITE_PARAMS_SIZE		; adjust for first three bytes of sprite data (width+flags,height,size)
		clc
		ldy #$02
		adc (z80_de),y
		adc z80_e
		sta sprite_mask_ptr
		lda z80_d
		adc #$00
		sta sprite_mask_ptr+1
		
LB2EE_no_mask
		stx sprite_has_mask
		ldy #$00
		lda (z80_de),y
		ldy #$07
		eor (z80_ix),y
		and #$c0
		bne LB2EE_flip
		rts
LB2EE_flip
		cmp #$40	; check if only hflip required
		bne LB2EE_hflip
		ldy #$00
		lda (z80_de),y
		and #$20	; check "has mirror"
		beq LB2EE_hflip
		ldy #$02
		lda (z80_de),y
		sta z80_a
		clc			; adjust sprite pointer (DE = DE + SPRITE_PARAMS_SIZE + 2*size)
		adc #SPRITE_PARAMS_SIZE
		adc z80_e
		sta z80_e
		scc:inc z80_d
		lda z80_a
		clc
		adc z80_e
		sta z80_e
		scc:inc z80_d
		lda #SPRITE_PARAMS_SIZE	; adjust mask pointer ( += SPRITE_PARAMS_SIZE + 2*size)
		clc
		adc z80_a
		adc sprite_mask_ptr
		sta sprite_mask_ptr
		scc:inc sprite_mask_ptr+1
		lda z80_a
		clc
		adc sprite_mask_ptr
		sta sprite_mask_ptr
		scc:inc sprite_mask_ptr+1
		rts
LB2EE_hflip		
		lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        ldy #$00 ; LD   A,(DE)	; DE - sprite address
        lda (z80_de),y
        ldy #$07 ; XOR  (IX+07)	; check for v-flip
        eor (z80_ix),y
        and #$80 ; AND  80
        jeq @@38 ; JR   Z,@@38	; jump if v-flip not needed (either v-flip not set or sprite data already v-flipped)
        ldy #$00 ; LD   A,(DE)	; mark sprite data as v-flipped
        lda (z80_de),y
        eor #$80 ; XOR  80
        ;ldy #$00 ; LD   (DE),A
        sta (z80_de),y
        ;asl @ ; RLCA			; perform v-flip
        ;and #$1E ; AND  1E
		and #$07	; not need to multiply width by two
        sta z80_b ; LD   B,A
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
        ;ldy #$00 ; LD   A,(DE)
		ldy #$01
        lda (z80_de),y
		bit sprite_has_mask
		bpl vflip_no_mask
		asl @ ; multiply height by two
vflip_no_mask		
        sta z80_c ; LD   C,A
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
		lda #SPRITE_PARAMS_SIZE
		clc
		adc z80_e
		sta z80_e
		scc:inc z80_d
        ;lda z80_c ; PUSH BC
        ;pha
        ;lda z80_b
        ;pha
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha
        ;lda z80_c ; LD   E,C
        ;sta z80_e
        ;lda #$00 ; LD   D,00
        ;sta z80_d
        ;lda z80_d ; LD   H,D
        ;sta z80_h
        ;lda z80_d ; LD   L,D
        ;sta z80_l
		lda #$00
		sta z80_h
		;sty_z80_l
		ldx z80_b
		;tya
		clc
@@39	adc z80_c
		bcc @@39_no_inc_h
		inc z80_h
		clc
@@39_no_inc_h		
		dex
		bne @@39
		sta z80_l
;@@39    jsr add_hl_de ; ADD  HL,DE
;        dec z80_b ; DJNZ @@39
;        jne @@39
        ;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;pla ; POP  BC
        ;sta z80_b
        ;pla
        ;sta z80_c
        jsr add_hl_de ; ADD  HL,DE
        jsr ex_de_hl ; EX   DE,HL
        lda z80_b ; LD   A,B
        jsr Add_HL_A ; CALL Add_HL_A
        jsr dec_de ; DEC  DE
        jsr dec_hl ; DEC  HL
        lsr z80_c ; SRL  C
@@41    lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
@@40    ldy #$00 ; LD   A,(DE)
        lda (z80_de),y
		tax
        ldy #$00 ; LD   C,(HL)
        lda (z80_hl),y
        sta z80_c
        ldy #$00 ; LD   (HL),A
		txa
        sta (z80_hl),y; 
        lda z80_c ; LD   A,C
        ldy #$00 ; LD   (DE),A
        sta (z80_de),y
        jsr dec_hl ; DEC  HL
        jsr dec_de ; DEC  DE
        dec z80_b ; DJNZ @@40
        jne @@40
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        lda z80_b ; LD   A,B
        jsr Add_HL_A ; CALL Add_HL_A
        lda z80_b ; LD   A,B
        jsr Add_HL_A ; CALL Add_HL_A
        dec z80_c ; DEC  C
        jne @@41 ; JR   NZ,@@41
@@38    pla ; POP  DE			; DE - sprite data address
        sta z80_d
        pla
        sta z80_e
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        ldy #$00 ; LD   A,(DE)	; check if h-flip needed
        lda (z80_de),y
        ldy #$07 ; XOR  (IX+07)
        eor (z80_ix),y
        and #$40 ; AND  40
        jeq @@42 ; JR   Z,@@42	; jump if not needed
        ldy #$00 ; LD   A,(DE)	; mark sprite as h-flipped
        lda (z80_de),y
        eor #$40 ; XOR  40
        ;ldy #$00 ; LD   (DE),A
        sta (z80_de),y
        and #$0F ; AND  0F		; perform h-flip
        sta z80_b ; LD   B,A
        sta z80_c ; LD   C,A
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
        ;ldy #$00 ; LD   A,(DE)
		ldy #$01
        lda (z80_de),y
        ;ldx z80_ap ; EX   AF,AF'
		bit sprite_has_mask
		bpl hflip_no_mask
		asl @	; two times more rows to flip
hflip_no_mask		
        sta z80_ap
        ;txa ; 
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
        ;jsr ex_de_hl ; EX   DE,HL
		lda #SPRITE_PARAMS_SIZE
		clc
		adc z80_e
		sta z80_e
		scc:inc z80_d
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;        jsr exx ; EXX
;        pla ; POP  HL
;        sta z80_h
;        pla
;        sta z80_l
;        lda #>LF100 ; LD   B,F1
;        sta z80_b
;        jsr exx ; EXX
;@@43    jsr exx ; EXX
;        ldy #$00 ; LD   C,(HL)
;        lda (z80_hl),y
;        sta z80_c
;        ldy #$00 ; LD   A,(BC)
;        lda (z80_bc),y
;        sta z80_e ; LD   E,A
;        inc z80_l ; INC  HL
;        bne *+4
;        inc z80_h
;        ldy #$00 ; LD   C,(HL)
;        lda (z80_hl),y
;        sta z80_c
;        ldy #$00 ; LD   A,(BC)
;        lda (z80_bc),y
;        sta z80_d ; LD   D,A
;        inc z80_l ; INC  HL
;        bne *+4
;        inc z80_h
;        lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        jsr exx ; EXX
;        dec z80_b ; DJNZ @@43
;        jne @@43

		;lda z80_b
		;cmp #$03
		;beq hflip_sprite_width_3
		ldx z80_b
		lda hflip_jump_table_low-1,x
		sta hflip_jump+1
		lda hflip_jump_table_high-1,x
		sta hflip_jump+2
hflip_jump
		jmp @@43
;optimization
@@43	ldy #$00
@@43_loop
		lda (z80_de),y
		iny
		tax
		lda LF100,x
		pha
		;lda (z80_hl),y
		;iny
		;tax
		;lda LF100,x
		;pha
		;dec z80_b
		cpy z80_b
		jne @@43_loop
		
        ;lda z80_c ; LD   B,C
        ;sta z80_b
		
;@@44    pla ; POP  DE
;        sta z80_d
;        pla
;        sta z80_e
;        lda z80_e ; LD   (HL),E
;        ldy #$00
;        sta (z80_hl),y
;        inc z80_l ; INC  HL
;        bne *+4
;        inc z80_h
;        lda z80_d ; LD   (HL),D
;        ldy #$00
;        sta (z80_hl),y
;        inc z80_l ; INC  HL
;        bne *+4
;        inc z80_h
;        dec z80_b ; DJNZ @@44
;        jne @@44

; optimization
		ldy #$00
@@44	;pla
		;tax
		pla
		sta (z80_de),y
		;iny
		;txa
		;sta (z80_hl),y
		iny
		;dec z80_b
		cpy z80_b
		jne @@44
		tya
		clc
		adc z80_e
		sta z80_e
		scc:inc z80_d
		
;        ldx z80_ap ; EX   AF,AF'
;        sta z80_ap
;        txa ; 
;        sec ; DEC  A
;        sbc #$01
;        jeq @@42 ; JR   Z,@@42
;        ldx z80_ap ; EX   AF,AF'
;        sta z80_ap
;        txa ; 

; 		optimization
		dec z80_ap
		jeq @@42
		
        ;lda z80_c ; LD   B,C
        ;sta z80_b
        jmp @@43 ; JR   @@43

;@@42    POP  DE
;B37E:   RET

@@42    pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        rts ; RET
		
hflip_jump_table_low
		dta l(@@43), l(hflip_sprite_width_2),l(hflip_sprite_width_3),l(hflip_sprite_width_4),l(@@43)
hflip_jump_table_high
		dta h(@@43), h(hflip_sprite_width_2),h(hflip_sprite_width_3),h(hflip_sprite_width_4),h(@@43)

hflip_sprite_width_4
		ldy #$00
hflip_sprite_width_4_loop		
		;sty zp_tmp_0
		lda (z80_de),y
		sta zp_tmp_1
		iny
		lda (z80_de),y
		sta zp_tmp_2
		iny
		lda (z80_de),y
		sta zp_tmp_3
		iny
		lda (z80_de),y
		tax
		
		dey
		dey
		dey
		lda LF100,x
		sta (z80_de),y
		iny
		ldx zp_tmp_3
		lda LF100,x
		sta (z80_de),y
		iny
		ldx zp_tmp_2
		lda LF100,x
		sta (z80_de),y
		iny
		ldx zp_tmp_1
		lda LF100,x
		sta (z80_de),y
		iny
		dec z80_ap
		jeq @@42
		cpy #-3
		bcc hflip_sprite_width_4_loop
		clc
		tya
		adc z80_e
		sta z80_e
		scc:inc z80_d
		ldy #$00
		;inc z80_d
		beq hflip_sprite_width_4_loop
		
hflip_sprite_width_3
		ldy #$00
hflip_sprite_width_3_loop		
		;sty zp_tmp_0
		lda (z80_de),y
		sta zp_tmp_1
		iny
		lda (z80_de),y
		sta zp_tmp_2
		iny
		lda (z80_de),y
		;sta zp_tmp_3
		tax
		
		;ldy zp_tmp_0
		dey
		dey
		;ldx zp_tmp_3
		lda LF100,x
		sta (z80_de),y
		iny
		ldx zp_tmp_2
		lda LF100,x
		sta (z80_de),y
		iny
		ldx zp_tmp_1
		lda LF100,x
		sta (z80_de),y
		iny
		dec z80_ap
		jeq @@42
		cpy #-2
		bcc hflip_sprite_width_3_loop
		clc
		tya
		adc z80_e
		sta z80_e
		scc:inc z80_d
		ldy #$00
		;inc z80_d
		beq hflip_sprite_width_3_loop
		
hflip_sprite_width_2
		ldy #$00
hflip_sprite_width_2_loop		
		;sty zp_tmp_0
		lda (z80_de),y
		sta zp_tmp_1
		iny
		lda (z80_de),y
		tax
		
		;ldy zp_tmp_0
		;ldx zp_tmp_3
		dey
		lda LF100,x
		sta (z80_de),y
		iny
		ldx zp_tmp_1
		lda LF100,x
		sta (z80_de),y
		iny
		dec z80_ap
		jeq @@42
		cpy #-1
		bcc hflip_sprite_width_2_loop
		clc
		tya
		adc z80_e
		sta z80_e
		scc:inc z80_d
		ldy #$00
		;inc z80_d
		beq hflip_sprite_width_2_loop			

;BCtoScrAdr: ; B37F
;B37F:   PUSH HL
;B380:   SRL  B
;B382:   RR   C
;B384:   SRL  B
;B386:   RR   C
;B388:   SRL  B
;B38A:   RR   C
;B38C:   LD   HL,ScreenBuffer
;B38F:   ADD  HL,BC
;B390:   LD   C,L
;B391:   LD   B,H
;B392:   POP  HL
;B393:   RET

BCtoScrAdr: ; B37F
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
		lda z80_c
        lsr z80_b ; SRL  B
        ;ror z80_c ; RR   C
		ror @
        lsr z80_b ; SRL  B
        ;ror z80_c ; RR   C
		ror @
        lsr z80_b ; SRL  B
        ;ror z80_c ; RR   C
		ror @
		clc
		adc #<ScreenBuffer
		sta z80_c
		lda z80_b
		adc #>ScreenBuffer
		sta z80_b
        ;lda #<ScreenBuffer ; LD   HL,ScreenBuffer
        ;sta z80_l
        ;lda #>ScreenBuffer
        ;sta z80_h
        ;jsr add_hl_bc ; ADD  HL,BC
        ;lda z80_l ; LD   C,L
        ;sta z80_c
        ;lda z80_h ; LD   B,H
        ;sta z80_b
        ;pla ; POP  HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        rts ; RET

;BCtoAttrInDE: ; B394
;B394:   LD   A,C
;B395:   RRCA
;B396:   RRCA
;B397:   RRCA
;B398:   AND  1F
;B39A:   LD   E,A
;B39B:   LD   A,B
;B39C:   CPL
;B39D:   AND  07
;B39F:   EX   AF,AF'
;B3A0:   LD   A,B
;B3A1:   CPL
;B3A2:   RLCA
;B3A3:   RLCA
;B3A4:   AND  E0
;B3A6:   OR   E
;B3A7:   LD   E,A
;B3A8:   LD   A,B
;B3A9:   CPL
;B3AA:   RRCA
;B3AB:   RRCA
;B3AC:   RRCA
;B3AD:   AND  18
;B3AF:   LD   D,A
;B3B0:   EX   AF,AF'
;B3B1:   OR   D
;B3B2:   ADD  A,38
;B3B4:   LD   D,A
;B3B5:   RET


BCtoAttrInDE: ; B394
        lda z80_c ; LD   A,C
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$1F ; AND  1F
        sta z80_e ; LD   E,A
        lda z80_b ; LD   A,B
        eor #$ff ; CPL
        and #$07 ; AND  07
        ldx z80_ap ; EX   AF,AF'
        sta z80_ap
        txa ; 
        lda z80_b ; LD   A,B
        eor #$ff ; CPL
        asl @ ; RLCA
        asl @ ; RLCA
        and #$E0 ; AND  E0
        ora z80_e ; OR   E
        sta z80_e ; LD   E,A
        lda z80_b ; LD   A,B
        eor #$ff ; CPL
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$18 ; AND  18
        sta z80_d ; LD   D,A
        ldx z80_ap ; EX   AF,AF'
        sta z80_ap
        txa ;  
        ora z80_d ; OR   D
        clc ; ADD  A,38
        ;adc #$38
		adc #>[spectrum_screen-$0800]
        sta z80_d ; LD   D,A
        rts ; RET

;LB3B6   PUSH HL
;B3B7:   LD   A,H
;B3B8:   CPL
;B3B9:   LD   H,A
;B3BA:   SRL  H
;B3BC:   SRL  H
;B3BE:   SRL  H
;B3C0:   SRL  H
;B3C2:   RR   L
;B3C4:   SRL  H
;B3C6:   RR   L
;B3C8:   SRL  H
;B3CA:   RR   L
;B3CC:   LD   DE,5700
;B3CF:   ADD  HL,DE
;B3D0:   EX   DE,HL
;B3D1:   POP  HL
;B3D2:   RET

; colour ram update
LB3B6
		
		lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda z80_h ; LD   A,H
        eor #$ff ; CPL
        sta z80_h ; LD   H,A
        lsr z80_h ; SRL  H
        lsr z80_h ; SRL  H
        lsr z80_h ; SRL  H
        lsr z80_h ; SRL  H
        ror z80_l ; RR   L
        lsr z80_h ; SRL  H
        ror z80_l ; RR   L
        lsr z80_h ; SRL  H
        ror z80_l ; RR   L
	
		; writes additional attribute colour info in here. Attr colour mem minus $0100
        ;lda #<L5700 ; LD   DE,5700
        lda #<$fb00
		sta z80_e
        ;lda #>L5700
        lda #>$fb00
		sta z80_d
        

		
        jsr add_hl_de ; ADD  HL,DE
        jsr ex_de_hl ; EX   DE,HL
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        rts ; RET
		
		;lda (z80_bc),y
sprite_norot_nomask_5_bytes	
		ora (z80_sp),y
		sta (z80_bc),y
		iny
		lda (z80_bc),y
sprite_norot_nomask_4_bytes	
		ora (z80_sp),y
		sta (z80_bc),y
		iny
		lda (z80_bc),y
sprite_norot_nomask_3_bytes	
		ora (z80_sp),y
		sta (z80_bc),y
		iny
		lda (z80_bc),y
sprite_norot_nomask_2_bytes	
		ora (z80_sp),y
		sta (z80_bc),y
		iny
		lda (z80_bc),y
sprite_norot_nomask_1_bytes	
		ora (z80_sp),y
		sta (z80_bc),y
		iny
        jmp LB4CE ; JP   LB4CE
		
sprite_norot_nomask_table_low
		dta <sprite_norot_nomask_1_bytes, <sprite_norot_nomask_2_bytes, <sprite_norot_nomask_3_bytes, <sprite_norot_nomask_4_bytes, <sprite_norot_nomask_5_bytes
		
sprite_norot_nomask_table_high
		dta >sprite_norot_nomask_1_bytes, >sprite_norot_nomask_2_bytes, >sprite_norot_nomask_3_bytes, >sprite_norot_nomask_4_bytes, >sprite_norot_nomask_5_bytes
		
PrintSpriteNoMaskNoRot
		ldy #$00 ; LD   A,(DE)	; non-rotated sprite
        lda (z80_de),y
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
        and #$0F ; AND  0F; 	; read sprite width
        ldy #$18 ; LD   (IX+18),A
        sta (z80_ix),y
        sta z80_b ; LD   B,A
		inc z80_b	; adjust for screen pointer calculation
		tax
		lda sprite_norot_nomask_table_low-1,x
		ldy sprite_norot_nomask_table_high-1,x
        jmp @@49 ; JR   @@49
       
PrintSpriteNoMask
		ldy #$1a
		lda (z80_ix),y
		and #$07
		beq PrintSpriteNoMaskNoRot
		; this doesn't happen?
		; fallback code
		pha
		lda z80_e
		clc
		adc #SPRITE_PARAMS_SIZE
		sta sprite_mask_ptr
		lda z80_d
		adc #$00
		sta sprite_mask_ptr+1
		pla
		jmp PrintSpriteRotated
		
;LB3D3   LD   A,(IX+00)
;B3D6:   CP   01
;B3D8:   JR   NZ,@@45
;B3DA:   LD   (IX+00),00
;B3DE:   RET

LB3D3   ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        cmp #$01 ; CP   01
        jne @@45 ; JR   NZ,@@45
		;optimization
        ;ldy #$00 ; LD   (IX+00),00
        ;lda #$00
		tya
        sta (z80_ix),y
        rts ; RET		


;@@45    RES  4,(IX+07)
;B3E3:   CALL LB2C5
;B3E6:   RET  NC

@@45    ldy #$07 ; RES  4,(IX+07)
        lda (z80_ix),y
        and #_notbitvalue4
        sta (z80_ix),y
        jsr LB2C5 ; CALL LB2C5
        bcc *+3 ; RET  NC
        rts; 

;PrintSprite: ; B3E7
;B3E7:   CALL LB2EE
;B3EA:   LD   A,(IX+1A)
;B3ED:   AND  07
;B3EF:   JR   Z,@@46
;B3F1:   RLCA
;B3F2:   AND  0E
;B3F4:   OR   F0
;B3F6:   LD   H,A
;B3F7:   LD   A,(DE)
;B3F8:   INC  DE
;B3F9:   AND  07
;B3FB:   INC  A
;B3FC:   LD   B,A
;B3FD:   LD   (IX+18),A
;B400:   DEC  A
;B401:   AND  07
;B403:   ADD  A,A
;B404:   ADD  A,A
;B405:   ADD  A,A
;B406:   ADD  A,A
;B407:   NEG
;B409:   ADD  A,50
;@@49    LD   (LB47C),A
;B40E:   LD   A,B
;B40F:   CPL
;B410:   ADD  A,22
;B412:   LD   (LB4D0),A
;B415:   LD   A,(DE)
;B416:   INC  DE
;B417:   LD   (IX+19),A
;B41A:   ADD  A,(IX+1B)
;B41D:   SUB  C0
;B41F:   JR   C,@@47
;B421:   NEG
;B423:   ADD  A,(IX+19)
;B426:   LD   (IX+19),A
;@@47    LD   C,(IX+1A)
;B42C:   LD   B,(IX+1B)
;B42F:   CALL BCtoScrAdr
;B432:   LD   (LA717),SP
;B436:   EX   DE,HL
;B437:   LD    SP,HL
;B438:   EX   DE,HL
;B439:   LD   A,(IX+19)
;B43C:   JR   @@48

z80_hl2	equ z80_reg2

PrintSprite: ; B3E7
        jsr LB2EE ; CALL LB2EE
		bit sprite_has_mask
		bpl PrintSpriteNoMask
        ldy #$1A ; LD   A,(IX+1A) ; check x position of the sprite
        lda (z80_ix),y
        and #$07 ; AND  07
        jeq @@46 ; JR   Z,@@46	; jump if (x & 07) = 0 (no need to rotate the sprite)
PrintSpriteRotated
        asl @ ; RLCA	; rotated sprite
        and #$0E ; AND  0E
		sec
		sbc #$02
        ora #>rot_table ; OR   F0	; adjust the address of rotation tables
		; set shift table pointers
		sta shift_low_5_1+2
		sta shift_low_5_2+2
		sta shift_low_4_1+2
		sta shift_low_4_2+2
		sta shift_low_3_1+2
		sta shift_low_3_2+2
		sta shift_low_2_1+2
		sta shift_low_2_2+2
		sta shift_low_1_1+2
		sta shift_low_1_2+2
		ora #$01
		sta shift_hi_5_1+2
		sta shift_hi_5_2+2
		sta shift_hi_4_1+2
		sta shift_hi_4_2+2
		sta shift_hi_3_1+2
		sta shift_hi_3_2+2
		sta shift_hi_2_1+2
		sta shift_hi_2_2+2
		sta shift_hi_1_1+2
		sta shift_hi_1_2+2
		; set mask pointers
		lda sprite_mask_ptr
		sta mask_5_rot+1
		sta mask_4_rot+1
		sta mask_3_rot+1
		sta mask_2_rot+1
		sta mask_1_rot+1
		sec
		sbc #$01
		sta mask1_5_rot+1
		sta mask1_4_rot+1
		sta mask1_3_rot+1
		sta mask1_2_rot+1
		sta mask1_1_rot+1
		lda sprite_mask_ptr+1
		sta mask_5_rot+2
		sta mask_4_rot+2
		sta mask_3_rot+2
		sta mask_2_rot+2
		sta mask_1_rot+2
		sbc #$00
		sta mask1_5_rot+2
		sta mask1_4_rot+2
		sta mask1_3_rot+2
		sta mask1_2_rot+2
		sta mask1_1_rot+2
		; set data pointers
		lda z80_e
		clc
		adc #SPRITE_PARAMS_SIZE
		sta data_5_rot+1
		sta data_4_rot+1
		sta data_3_rot+1
		sta data_2_rot+1
		sta data_1_rot+1
		lda z80_d
		adc #$00
		sta data_5_rot+2
		sta data_4_rot+2
		sta data_3_rot+2
		sta data_2_rot+2
		sta data_1_rot+2
		lda z80_e
		clc
		adc #SPRITE_PARAMS_SIZE-1
		sta data1_5_rot+1
		sta data1_4_rot+1
		sta data1_3_rot+1
		sta data1_2_rot+1
		sta data1_1_rot+1
		lda z80_d
		adc #$00
		sta data1_5_rot+2
		sta data1_4_rot+2
		sta data1_3_rot+2
		sta data1_2_rot+2
		sta data1_1_rot+2
		
        ;sta z80_h ; LD   H,A
		;sta z80_hl2+1
		;inc z80_hl2+1
        ldy #$00 ; LD   A,(DE)	; width
		;sty z80_l
		;sty z80_hl2
        lda (z80_de),y
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
        and #$07 ; AND  07; 
        clc ; INC  A
        adc #$01
        sta z80_b ; LD   B,A
        ldy #$18 ; LD   (IX+18),A
        sta (z80_ix),y
        sec ; DEC  A
        sbc #$01
        and #$07 ; AND  07
        ;asl @ ; ADD  A,A
        ;asl @ ; ADD  A,A
        ;asl @ ; ADD  A,A
        ;asl @ ; ADD  A,A
        ;eor #$ff ; NEG
        ;clc
        ;adc #$01
        ;clc ; ADD  A,50
        ;adc #$50
		tax
		lda sprite_rot_table_low-1,x
		ldy sprite_rot_table_high-1,x
@@49    sta LB47C+1 ; LD   (LB47C),A ; Warning: self-modifying code
		sty LB47C+2
        lda z80_b ; LD   A,B
        eor #$ff ; CPL
        clc ; ADD  A,22
        adc #$22
        sta LB4D0 ; LD   (LB4D0),A ; self-modifying code
        ldy #$01 ; LD   A,(DE)
        lda (z80_de),y
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
        ldy #$19 ; LD   (IX+19),A
        sta (z80_ix),y; 
        ldy #$1B ; ADD  A,(IX+1B)
        clc
        adc (z80_ix),y
        sec ; SUB  C0
        sbc #$C0
        jcc @@47 ; JR   C,@@47
        eor #$ff ; NEG
        clc
        adc #$01; 
        ldy #$19 ; ADD  A,(IX+19)
        clc
        adc (z80_ix),y
        ldy #$19 ; LD   (IX+19),A
        sta (z80_ix),y
@@47    ldy #$1A ; LD   C,(IX+1A)
        lda (z80_ix),y
        sta z80_c
        ldy #$1B ; LD   B,(IX+1B)
        lda (z80_ix),y
        sta z80_b
        jsr BCtoScrAdr ; CALL BCtoScrAdr
        ; LD   (LA717),SP
        ;jsr ex_de_hl ; EX   DE,HL
        ; LD    SP,HL
        ;jsr ex_de_hl ; EX   DE,HL
		;lda z80_e
		;sta z80_sp
		;lda z80_d
		;sta z80_sp+1
		lda #SPRITE_PARAMS_SIZE
		clc
		adc z80_e
		sta z80_sp
		lda z80_d
		adc #$00
		sta z80_sp+1
        ldy #$19 ; LD   A,(IX+19)
        lda (z80_ix),y
		
		sta z80_ap	; optimization
        ldy #$00 
		;sty z80_bc_idx
		;sty z80_sp_idx
		
		jmp @@48 ; JR   @@48

;@@46    LD   A,(DE)
;B43F:   INC  DE
;B440:   AND  0F
;B442:   LD   (IX+18),A
;B445:   LD   B,A
;B446:   ADD  A,A
;B447:   ADD  A,A
;B448:   ADD  A,A
;B449:   NEG
;B44B:   SUB  06
;B44D:   JR   @@49

@@46    ldy #$00 ; LD   A,(DE)	; non-rotated sprite
        lda (z80_de),y
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
        and #$0F ; AND  0F; 	; read sprite width
        ldy #$18 ; LD   (IX+18),A
        sta (z80_ix),y
        sta z80_b ; LD   B,A
		inc z80_b	; adjust for screen pointer calculation
        ;asl @ ; ADD  A,A
        ;asl @ ; ADD  A,A
        ;asl @ ; ADD  A,A
        ;eor #$ff ; NEG
        ;clc
        ;adc #$01
        ;sec ; SUB  06
        ;sbc #$06
		tax
		lda sprite_norot_table_low-1,x
		ldy sprite_norot_table_high-1,x
        jmp @@49 ; JR   @@49

sprite_norot_table_low
		dta <sprite_norot_1_bytes, <sprite_norot_2_bytes, <sprite_norot_3_bytes, <sprite_norot_4_bytes, <sprite_norot_5_bytes
		
sprite_norot_table_high
		dta >sprite_norot_1_bytes, >sprite_norot_2_bytes, >sprite_norot_3_bytes, >sprite_norot_4_bytes, >sprite_norot_5_bytes
;LB44F   POP  DE
;B450:   LD   A,(BC)
;B451:   CPL
;B452:   OR   E
;B453:   CPL
;B454:   OR   D
;B455:   LD   (BC),A
;B456:   INC  BC
;B457:   POP  DE
;B458:   LD   A,(BC)
;B459:   CPL
;B45A:   OR   E
;B45B:   CPL
;B45C:   OR   D
;B45D:   LD   (BC),A
;B45E:   INC  BC
;@@50    POP  DE
;B460:   LD   A,(BC)
;B461:   CPL
;B462:   OR   E
;B463:   CPL
;B464:   OR   D
;B465:   LD   (BC),A
;B466:   INC  BC
;B467:   POP  DE
;B468:   LD   A,(BC)
;B469:   CPL
;B46A:   OR   E
;B46B:   CPL
;B46C:   OR   D
;B46D:   LD   (BC),A
;B46E:   INC  BC
;B46F:   POP  DE
;B470:   LD   A,(BC)
;B471:   CPL
;B472:   OR   E
;B473:   CPL
;B474:   OR   D
;B475:   LD   (BC),A
;B476:   JP   LB4CE

		lda (z80_bc),y
sprite_norot_5_bytes
		;beq sprite_norot_5_bytes_screen_empty
		eor #$ff
		ora (sprite_mask_ptr),y
		eor #$ff
sprite_norot_5_bytes_screen_empty		
		ora (z80_sp),y
		sta (z80_bc),y
		iny
		lda (z80_bc),y
sprite_norot_4_bytes
		;beq sprite_norot_4_bytes_screen_empty
		eor #$ff
		ora (sprite_mask_ptr),y
		eor #$ff
sprite_norot_4_bytes_screen_empty		
		ora (z80_sp),y
		sta (z80_bc),y
		iny
		lda (z80_bc),y
sprite_norot_3_bytes
		;beq sprite_norot_3_bytes_screen_empty
		eor #$ff
		ora (sprite_mask_ptr),y
		eor #$ff
sprite_norot_3_bytes_screen_empty		
		ora (z80_sp),y
		sta (z80_bc),y
		iny
		lda (z80_bc),y
sprite_norot_2_bytes
		;beq sprite_norot_2_bytes_screen_empty
		eor #$ff
		ora (sprite_mask_ptr),y
		eor #$ff
sprite_norot_2_bytes_screen_empty		
		ora (z80_sp),y
		sta (z80_bc),y
		iny
		lda (z80_bc),y
sprite_norot_1_bytes
		;beq sprite_norot_1_bytes_screen_empty
		eor #$ff
		ora (sprite_mask_ptr),y
		eor #$ff
sprite_norot_1_bytes_screen_empty		
		ora (z80_sp),y
		sta (z80_bc),y
		iny
		
;sprite_norot_5_bytes
		;ldy #$00
		;ldy z80_sp_idx
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;ldy #$00 ; LD   A,(BC)
		;ldy z80_bc_idx
        ;lda (z80_bc),y
		;bne sprite_norot_5_bytes_non_empty_screen
		; empty screen
		;ldy z80_sp_idx
		;iny
		;lda (z80_sp),y
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;jmp sprite_norot_5_bytes_save_screen
;sprite_norot_5_bytes_non_empty_screen				
        ;eor #$ff ; CPL
        ;ora z80_e ; OR   E
		;ldy z80_sp_idx
		;ora (z80_sp),y
		;iny
        ;eor #$ff ; CPL
        ;ora z80_d ; OR   D
		;ora (z80_sp),y
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1	
        ;ldy #$00 ; LD   (BC),A
;sprite_norot_5_bytes_save_screen		
		;ldy z80_bc_idx		
        ;sta (z80_bc),y
		;iny
		;sty z80_bc_idx
        ;inc z80_c ; INC  BC
        ;bne *+4
        ;inc z80_b
		
;sprite_norot_4_bytes		
		;ldy #$00
		;ldy z80_sp_idx
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;ldy #$00 ; LD   A,(BC)
		;ldy z80_bc_idx
        ;lda (z80_bc),y
		;bne sprite_norot_4_bytes_non_empty_screen
		; empty screen
		;ldy z80_sp_idx
		;iny
		;lda (z80_sp),y
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;jmp sprite_norot_4_bytes_save_screen
;sprite_norot_4_bytes_non_empty_screen		
        ;eor #$ff ; CPL
        ;ora z80_e ; OR   E
		;ldy z80_sp_idx
		;ora (z80_sp),y
		;iny
        ;eor #$ff ; CPL
        ;ora z80_d ; OR   D
		;ora (z80_sp),y
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
;sprite_norot_4_bytes_save_screen		
		;ldy z80_bc_idx		
        ;ldy #$00 ; LD   (BC),A
        ;sta (z80_bc),y
		;iny
		;sty z80_bc_idx
        ;inc z80_c ; INC  BC
        ;bne *+4
        ;inc z80_b
		
;@@50    
;sprite_norot_3_bytes
		;ldy #$00
		;ldy z80_sp_idx
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;ldy #$00 ; LD   A,(BC)
		;ldy z80_bc_idx
        ;lda (z80_bc),y
		;bne sprite_norot_3_bytes_non_empty_screen
		; empty screen
		;ldy z80_sp_idx
		;iny
		;lda (z80_sp),y
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;jmp sprite_norot_3_bytes_save_screen
;sprite_norot_3_bytes_non_empty_screen			
        ;eor #$ff ; CPL
        ;ora z80_e ; OR   E
		;ldy z80_sp_idx
		;ora (z80_sp),y
		;iny
        ;eor #$ff ; CPL
        ;ora z80_d ; OR   D
		;ora (z80_sp),y
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
;sprite_norot_3_bytes_save_screen		
        ;ldy #$00 ; LD   (BC),A
		;ldy z80_bc_idx
        ;sta (z80_bc),y
		;iny
		;sty z80_bc_idx
        ;inc z80_c ; INC  BC
        ;bne *+4
        ;inc z80_b
	
;sprite_norot_2_bytes	
		;ldy #$00
		;ldy z80_sp_idx	; 3
		;lda (z80_sp),y	; 5.5
		;sta z80_e		; 3
		;iny				; 2
		;lda (z80_sp),y	; 5.5
		;sta z80_d		; 3
		;iny				; 2
		;sty z80_sp_idx	; 3
		;sne:inc z80_sp+1	; 3
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;ldy #$00 ; LD   A,(BC)
		;ldy z80_bc_idx	; 3
        ;lda (z80_bc),y	; 5.5
		;bne sprite_norot_2_bytes_non_empty_screen
		; empty screen
		;ldy z80_sp_idx
		;iny
		;lda (z80_sp),y
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;jmp sprite_norot_2_bytes_save_screen
;sprite_norot_2_bytes_non_empty_screen		
        ;eor #$ff ; CPL	; 2
        ;ora z80_e ; OR   E	; 3
		;ldy z80_sp_idx
		;ora (z80_sp),y
		;iny
        ;eor #$ff ; CPL	; 2
        ;ora z80_d ; OR   D	; 3
		;ora (z80_sp),y
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
        ;ldy #$00 ; LD   (BC),A
;sprite_norot_2_bytes_save_screen		
		;ldy z80_bc_idx
        ;sta (z80_bc),y	; 6 = 54,5
		;iny
		;sty z80_bc_idx
        ;inc z80_c ; INC  BC
        ;bne *+4
        ;inc z80_b
		
;sprite_norot_1_bytes		
		;ldy #$00
		;ldy z80_sp_idx
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;ldy #$00 ; LD   A,(BC)
		;ldy z80_bc_idx	; 3
        ;lda (z80_bc),y	; 5.5
		;beq sprite_norot_1_bytes_empty_screen	; 2/3
        ;eor #$ff ; CPL	; 2
        ;ora z80_e ; OR   E
		;ldy z80_sp_idx	; 3
		;ora (z80_sp),y	; 5.5
		;iny				; 2
        ;eor #$ff ; CPL	; 2
        ;ora z80_d ; OR   D
		;ora (z80_sp),y	; 5.5
		;iny				; 2
		;sty z80_sp_idx	; 3
		;sne:inc z80_sp+1; 3
;sprite_norot_1_bytes_save_screen		
        ;ldy #$00 ; LD   (BC),A
		;ldy z80_bc_idx	; 3
        ;sta (z80_bc),y	; 6	= 45,5 + 2 = 47,5
        jmp LB4CE ; JP   LB4CE

;sprite_norot_1_bytes_empty_screen
;		ldy z80_sp_idx	; 3
;		iny				; 2
;		lda (z80_sp),y	; 5.5
;		iny				; 2
;		sty z80_sp_idx	; 3
;		sne:inc z80_sp+1	; 3
;		jmp sprite_norot_1_bytes_save_screen ; 3 - total 33
		
;@@48    EX   AF,AF'
;B47A:   LD   A,(BC)
;B47B:   JR   @@50

@@48    ;optimization
		;ldx z80_ap ; EX   AF,AF'
        ;sta z80_ap
        ;txa 
		;ldy z80_bc_idx	; LD   A,(BC)
        lda (z80_bc),y
LB47C   jmp $ffff ; JR   @@50	; selft modified

;LB47D   POP  DE
;B47E:   LD   L,E
;B47F:   AND  (HL)
;B480:   LD   L,D
;B481:   XOR  (HL)
;B482:   CPL
;B483:   LD   (BC),A
;B484:   INC  BC
;B485:   INC  H
;B486:   LD   L,E
;B487:   LD   A,(BC)
;B488:   AND  (HL)
;B489:   LD   L,D
;B48A:   XOR  (HL)
;B48B:   CPL
;B48C:   DEC  H
;B48D:   POP  DE
;B48E:   LD   L,E
;B48F:   AND  (HL)
;B490:   LD   L,D
;B491:   XOR  (HL)
;B492:   CPL
;B493:   LD   (BC),A
;B494:   INC  BC
;B495:   INC  H
;B496:   LD   L,E
;B497:   LD   A,(BC)
;B498:   AND  (HL)
;B499:   LD   L,D
;B49A:   XOR  (HL)
;B49B:   CPL
;B49C:   DEC  H
;B49D:   POP  DE
;B49E:   LD   L,E
;B49F:   AND  (HL)
;B4A0:   LD   L,D
;B4A1:   XOR  (HL)
;B4A2:   CPL
;B4A3:   LD   (BC),A
;B4A4:   INC  BC
;B4A5:   INC  H
;B4A6:   LD   L,E
;B4A7:   LD   A,(BC)
;B4A8:   AND  (HL)
;B4A9:   LD   L,D
;B4AA:   XOR  (HL)
;B4AB:   CPL
;B4AC:   DEC  H
;B4AD:   POP  DE
;B4AE:   LD   L,E
;B4AF:   AND  (HL)
;B4B0:   LD   L,D
;B4B1:   XOR  (HL)
;B4B2:   CPL
;B4B3:   LD   (BC),A
;B4B4:   INC  BC
;B4B5:   INC  H
;B4B6:   LD   L,E
;B4B7:   LD   A,(BC)
;B4B8:   AND  (HL)
;B4B9:   LD   L,D
;B4BA:   XOR  (HL)
;B4BB:   CPL
;B4BC:   DEC  H
;B4BD:   POP  DE
;B4BE:   LD   L,E
;B4BF:   AND  (HL)
;B4C0:   LD   L,D
;B4C1:   XOR  (HL)
;B4C2:   CPL
;B4C3:   LD   (BC),A
;B4C4:   INC  BC
;B4C5:   INC  H
;B4C6:   LD   L,E
;B4C7:   LD   A,(BC)
;B4C8:   AND  (HL)
;B4C9:   LD   L,D
;B4CA:   XOR  (HL)
;B4CB:   CPL
;B4CC:   DEC  H
;B4CD:   LD   (BC),A
;LB4CE   LD   A,C
;B4CF:   ADD  A,1E
;B4D1:   LD   C,A
;B4D2:   LD   A,B
;B4D3:   ADC  A,00
;B4D5:   LD   B,A
;B4D6:   EX   AF,AF'
;B4D7:   DEC  A
;B4D8:   JP   NZ,@@48
;B4DB:   LD   SP,(LA717)
;B4DF:   RET
sprite_rot_table_low
		dta <sprite_rot_1_bytes, <sprite_rot_2_bytes, <sprite_rot_3_bytes, <sprite_rot_4_bytes, <sprite_rot_5_bytes
sprite_rot_table_high
		dta >sprite_rot_1_bytes, >sprite_rot_2_bytes, >sprite_rot_3_bytes, >sprite_rot_4_bytes, >sprite_rot_5_bytes
	
z80_sp_idx	equ z80_reg0
z80_bc_idx	equ z80_reg1
	
sprite_rot_5_bytes
mask_5_rot
		ldx $ffff,y	; mask
shift_low_5_1		
		and $ff00,x	; shift table low
data_5_rot		
		ldx $ffff,y	; data
shift_low_5_2
		eor $ff00,x ; shift table low
		eor #$ff
		sta (z80_bc),y
		iny
		lda (z80_bc),y
mask1_5_rot		
		ldx $ffff-1,y	; mask - 1
shift_hi_5_1		
		and $ff00,x		; shift table high
data1_5_rot		
		ldx $ffff-1,y	; data - 1
shift_hi_5_2		
		eor $ff00,x		; shift table high
		eor #$ff
		
sprite_rot_4_bytes
mask_4_rot
		ldx $ffff,y	; mask
shift_low_4_1		
		and $ff00,x	; shift table low
data_4_rot		
		ldx $ffff,y	; data
shift_low_4_2
		eor $ff00,x ; shift table low
		eor #$ff
		sta (z80_bc),y
		iny
		lda (z80_bc),y
mask1_4_rot		
		ldx $ffff-1,y	; mask - 1
shift_hi_4_1		
		and $ff00,x		; shift table high
data1_4_rot		
		ldx $ffff-1,y	; data - 1
shift_hi_4_2		
		eor $ff00,x		; shift table high
		eor #$ff
		
sprite_rot_3_bytes
mask_3_rot
		ldx $ffff,y	; mask
shift_low_3_1		
		and $ff00,x	; shift table low
data_3_rot		
		ldx $ffff,y	; data
shift_low_3_2
		eor $ff00,x ; shift table low
		eor #$ff
		sta (z80_bc),y
		iny
		lda (z80_bc),y
mask1_3_rot		
		ldx $ffff-1,y	; mask - 1
shift_hi_3_1		
		and $ff00,x		; shift table high
data1_3_rot		
		ldx $ffff-1,y	; data - 1
shift_hi_3_2		
		eor $ff00,x		; shift table high
		eor #$ff
		
sprite_rot_2_bytes
mask_2_rot
		ldx $ffff,y	; mask
shift_low_2_1		
		and $ff00,x	; shift table low
data_2_rot		
		ldx $ffff,y	; data
shift_low_2_2
		eor $ff00,x ; shift table low
		eor #$ff
		sta (z80_bc),y
		iny
		lda (z80_bc),y
mask1_2_rot		
		ldx $ffff-1,y	; mask - 1
shift_hi_2_1		
		and $ff00,x		; shift table high
data1_2_rot		
		ldx $ffff-1,y	; data - 1
shift_hi_2_2		
		eor $ff00,x		; shift table high
		eor #$ff

sprite_rot_1_bytes
mask_1_rot
		ldx $ffff,y	; mask
shift_low_1_1		
		and $ff00,x	; shift table low
data_1_rot		
		ldx $ffff,y	; data
shift_low_1_2
		eor $ff00,x ; shift table low
		eor #$ff
		sta (z80_bc),y
		iny
		lda (z80_bc),y
mask1_1_rot		
		ldx $ffff-1,y	; mask - 1
shift_hi_1_1		
		and $ff00,x		; shift table high
data1_1_rot		
		ldx $ffff-1,y	; data - 1
shift_hi_1_2		
		eor $ff00,x		; shift table high
		eor #$ff
		
		
;sprite_rot_5_bytes
;LB47D   tax
		;ldy #$00
		;ldy z80_sp_idx
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;lda z80_e ; LD   L,E
        ;sta z80_l
        ;ldy #$00 ; AND  (HL)
		;txa
		;ldy z80_e
        ;and (z80_hl),y; 
        ;lda z80_d ; LD   L,D
        ;sta z80_l
        ;ldy #$00 ; XOR  (HL)
		;ldy z80_d
        ;eor (z80_hl),y; 
        ;eor #$ff ; CPL
        ;ldy #$00 ; LD   (BC),A
		;ldy z80_bc_idx
        ;sta (z80_bc),y
		;iny
		;sty z80_bc_idx
        ;inc z80_c ; INC  BC
        ;bne *+4
        ;inc z80_b
        ;inc z80_h ; INC  H
        ;lda z80_e ; LD   L,E
        ;sta z80_l
        ;ldy #$00 ; LD   A,(BC)
        ;lda (z80_bc),y
		;ldy z80_e
        ;ldy #$00 ; AND  (HL)
        ;and (z80_hl2),y
        ;lda z80_d ; LD   L,D
        ;sta z80_l
		;ldy z80_d
        ;ldy #$00 ; XOR  (HL)
        ;eor (z80_hl2),y; 
        ;eor #$ff ; CPL
        ;dec z80_h ; DEC  H

;sprite_rot_4_bytes		
		;tax
		;ldy #$00
		;ldy z80_sp_idx
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;lda z80_e ; LD   L,E
        ;sta z80_l
        ;ldy #$00 ; AND  (HL)
		;txa
		;ldy z80_e
        ;and (z80_hl),y; 
        ;lda z80_d ; LD   L,D
        ;sta z80_l
        ;ldy #$00 ; XOR  (HL)
		;ldy z80_d
        ;eor (z80_hl),y; 
        ;eor #$ff ; CPL
        ;ldy #$00 ; LD   (BC),A
		;ldy z80_bc_idx
        ;sta (z80_bc),y
		;iny
		;sty z80_bc_idx
        ;inc z80_c ; INC  BC
        ;bne *+4
        ;inc z80_b
        ;inc z80_h ; INC  H
        ;lda z80_e ; LD   L,E
        ;sta z80_l
        ;ldy #$00 ; LD   A,(BC)
        ;lda (z80_bc),y
		;ldy z80_e
        ;ldy #$00 ; AND  (HL)
        ;and (z80_hl2),y
        ;lda z80_d ; LD   L,D
        ;sta z80_l
		;ldy z80_d
        ;ldy #$00 ; XOR  (HL)
        ;eor (z80_hl2),y; 
        ;eor #$ff ; CPL
        ;dec z80_h ; DEC  H
		
;sprite_rot_3_bytes		
		;tax
		;ldy #$00
		;ldy z80_sp_idx
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;lda z80_e ; LD   L,E
        ;sta z80_l
        ;ldy #$00 ; AND  (HL)
		;txa
		;ldy z80_e
        ;and (z80_hl),y; 
        ;lda z80_d ; LD   L,D
        ;sta z80_l
        ;ldy #$00 ; XOR  (HL)
		;ldy z80_d
        ;eor (z80_hl),y; 
        ;eor #$ff ; CPL
        ;ldy #$00 ; LD   (BC),A
		;ldy z80_bc_idx
        ;sta (z80_bc),y
		;iny
		;sty z80_bc_idx
        ;inc z80_c ; INC  BC
        ;bne *+4
        ;inc z80_b
        ;inc z80_h ; INC  H
        ;lda z80_e ; LD   L,E
        ;sta z80_l
        ;ldy #$00 ; LD   A,(BC)
        ;lda (z80_bc),y
		;ldy z80_e
        ;ldy #$00 ; AND  (HL)
        ;and (z80_hl2),y
        ;lda z80_d ; LD   L,D
        ;sta z80_l
		;ldy z80_d
        ;ldy #$00 ; XOR  (HL)
        ;eor (z80_hl2),y; 
        ;eor #$ff ; CPL
        ;dec z80_h ; DEC  H
		
;sprite_rot_2_bytes		
		;tax
		;ldy #$00
		;ldy z80_sp_idx
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;lda z80_e ; LD   L,E
        ;sta z80_l
        ;ldy #$00 ; AND  (HL)
		;txa
		;ldy z80_e
        ;and (z80_hl),y; 
        ;lda z80_d ; LD   L,D
        ;sta z80_l
        ;ldy #$00 ; XOR  (HL)
		;ldy z80_d
        ;eor (z80_hl),y; 
        ;eor #$ff ; CPL
        ;ldy #$00 ; LD   (BC),A
		;ldy z80_bc_idx
        ;sta (z80_bc),y
		;iny
		;sty z80_bc_idx
        ;inc z80_c ; INC  BC
        ;bne *+4
        ;inc z80_b
        ;inc z80_h ; INC  H
        ;lda z80_e ; LD   L,E
        ;sta z80_l
        ;ldy #$00 ; LD   A,(BC)
        ;lda (z80_bc),y
		;ldy z80_e
        ;ldy #$00 ; AND  (HL)
        ;and (z80_hl2),y
        ;lda z80_d ; LD   L,D
        ;sta z80_l
		;ldy z80_d
        ;ldy #$00 ; XOR  (HL)
        ;eor (z80_hl2),y; 
        ;eor #$ff ; CPL
        ;dec z80_h ; DEC  H
		
;sprite_rot_1_bytes		
		;tax
		;ldy #$00
		;ldy z80_sp_idx
		;lda (z80_sp),y
		;sta z80_e
		;iny
		;lda (z80_sp),y
		;sta z80_d
		;iny
		;sty z80_sp_idx
		;sne:inc z80_sp+1
		;lda #$02
		;clc
		;adc z80_sp
		;sta z80_sp
		;scc:inc z80_sp+1
		;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;lda z80_e ; LD   L,E
        ;sta z80_l
        ;ldy #$00 ; AND  (HL)
		;txa
		;ldy z80_e
        ;and (z80_hl),y; 
        ;lda z80_d ; LD   L,D
        ;sta z80_l
        ;ldy #$00 ; XOR  (HL)
		;ldy z80_d
        ;eor (z80_hl),y; 
        ;eor #$ff ; CPL
        ;ldy #$00 ; LD   (BC),A
		;ldy z80_bc_idx
        ;sta (z80_bc),y
		;iny
		;sty z80_bc_idx
        ;inc z80_c ; INC  BC
        ;bne *+4
        ;inc z80_b
        ;inc z80_h ; INC  H
        ;lda z80_e ; LD   L,E
        ;sta z80_l
        ;ldy #$00 ; LD   A,(BC)
        ;lda (z80_bc),y
		;ldy z80_e
        ;ldy #$00 ; AND  (HL)
        ;and (z80_hl2),y
        ;lda z80_d ; LD   L,D
        ;sta z80_l
		;ldy z80_d
        ;ldy #$00 ; XOR  (HL)
        ;eor (z80_hl2),y; 
        ;eor #$ff ; CPL
        ;dec z80_h ; DEC  H
		
        ;ldy #$00 ; LD   (BC),A
		;ldy z80_bc_idx
        sta (z80_bc),y; 
LB4CE   lda z80_c ; LD   A,C
        clc ; ADD  A,1E
		adc #$1E
LB4D0	equ *-1
        sta z80_c ; LD   C,A
        ;lda z80_b ; LD   A,B
        ;adc #$00 ; ADC  A,00
        ;sta z80_b ; LD   B,A
		scc:inc z80_b
        ;ldx z80_ap ; EX   AF,AF'
        ;sta z80_ap
        ;txa ; 
        ;sec ; DEC  A
        ;sbc #$01
		dec z80_ap
        jne @@48 ; JP   NZ,@@48
        ; LD SP,(LA717): TODO  ; LD   SP,(LA717)
        rts ; RET

;LB4E0   LD   A,7E
;B4E2:   CALL ReadKey
;B4E5:   BIT  0,A
;B4E7:   RET  Z
;B4E8:   AND  1E
;B4EA:   RET  NZ
;B4EB:   CALL LD5D7
;@@51    LD   A,7E
;B4F0:   CALL ReadKey
;B4F3:   BIT  0,A
;B4F5:   JR   NZ,@@51
;B4F7:   LD   IY,5C3A
;B4FB:   EI
;@@52    LD   A,7E
;B4FE:   CALL ReadKey
;B501:   BIT  0,A
;B503:   JR   Z,@@52
;@@53    LD   A,7E
;B507:   CALL ReadKey
;B50A:   BIT  0,A
;B50C:   JR   NZ,@@53
;B50E:   DI
;B50F:   CALL LD5D7
;B512:   RET

check_fire		
		
		jsr     c64WaitFrame
		
        ;setup keyboard reading
        lda     #%11111111; CIA#1 Port A set to output
        sta     ddra    
        lda     #%00000000; CIA#1 Port B set to input
        sta     ddrb    

		lda 	#%01111111 ; select row 8    
        sta     pra     
        lda     prb       
        and 	#%00010000 ; Space key
        beq     un_pause
				
        ;setup joystick port 2
        lda     #$E0    
        and     ddra    
        sta     ddra    

        lda     pra     	;read gameport2
        and     #$10    	;isolate button bit
        beq     un_pause	;if =0 then button is down.

		jmp 	check_fire
		 
un_pause
		
		rts

;pause		
LB4E0

		;STA $D07A

		lda #<sfxpause      ;Start address of sound effect data
        ldy #>sfxpause
        ldx #07             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e 
		
 		;lda	#15
		;sta	border		
	
		;lda 	#$0e ;set colour gray
		;ldx	#26
		;jsr 	vdcwrite
		
		nop
		nop
		nop
		nop
	
		jsr check_fire
				
		jsr c64skipkeyheld
	
		lda #<sfxpause      ;Start address of sound effect data
        ldy #>sfxpause
        ldx #07             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e 		
		
		;lda	#00
		;sta	border	

		;lda 	#$00 ;set colour black
		;ldx	#26
		;jsr 	vdcwrite

		nop
		nop
		nop
		nop
		nop
		
		;STA $D07B
		
        rts


		
;		lda #$7E ; LD   A,7E
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem0 ; BIT  0,A
;        bne *+3 ; RET  Z
;        rts
;        and #$1E ; AND  1E
;        beq *+3 ; RET  NZ
;        rts
;        jsr LD5D7 ; CALL LD5D7
;@@51    lda #$7E ; LD   A,7E
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem0 ; BIT  0,A
;        jne @@51 ; JR   NZ,@@51
;        lda #<L5C3A ; LD   IY,5C3A
;        sta z80_iy
;        lda #>L5C3A
;        sta z80_iy+1
;        jsr ei ; EI
;@@52    lda #$7E ; LD   A,7E
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem0 ; BIT  0,A
;        jeq @@52 ; JR   Z,@@52
;@@53    lda #$7E ; LD   A,7E
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem0 ; BIT  0,A
;        jne @@53 ; JR   NZ,@@53
;        jsr di ; DI
;        jsr LD5D7 ; CALL LD5D7
;        rts ; RET

;Zero_DE XOR  A

Zero_DE lda #$00 ; XOR  A

;Fill_DE LD   (DE),A
;B515:   INC  DE
;B516:   DJNZ Fill_DE
;B518:   RET

Fill_DE ldy #$00 ; LD   (DE),A
        sta (z80_de),y
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
        dec z80_b ; DJNZ Fill_DE
        jne Fill_DE
        rts ; RET

;Add_HL_A: ; B519
;B519:   ADD  A,L
;B51A:   LD   L,A
;B51B:   LD   A,H
;B51C:   ADC  A,00
;B51E:   LD   H,A
;B51F:   RET

Add_HL_A: ; B519
        clc ; ADD  A,L
        adc z80_l; 
        sta z80_l ; LD   L,A
        lda z80_h ; LD   A,H
        adc #$00 ; ADC  A,00
        sta z80_h ; LD   H,A
        rts ; RET

;LB520   PUSH BC
;B521:   AND  7F
;B523:   LD   L,A
;B524:   LD   H,00
;B526:   ADD  HL,HL
;B527:   ADD  HL,HL
;B528:   ADD  HL,HL
;B529:   ADD  HL,HL
;B52A:   ADD  HL,HL
;B52B:   LD   BC,A76F
;B52E:   ADD  HL,BC
;B52F:   POP  BC
;B530:   RET

;LB520   tax
;        lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;  		 txa
;        and #$7F ; AND  7F; 
;        sta z80_l ; LD   L,A
;        lda #$00 ; LD   H,00
;        sta z80_h
;        asl z80_l ; ADD  HL,HL
;        rol z80_h
;        asl z80_l ; ADD  HL,HL
;        rol z80_h
;        asl z80_l ; ADD  HL,HL
;        rol z80_h
;        asl z80_l ; ADD  HL,HL
;        rol z80_h
;        asl z80_l ; ADD  HL,HL
;        rol z80_h
;        lda #<LA76F ; LD   BC,A76F
;        sta z80_c
;        lda #>LA76F
;        sta z80_b
;        jsr add_hl_bc ; ADD  HL,BC
;        pla ; POP  BC
;        sta z80_b
;        pla
;        sta z80_c
;        rts ; RET

		; optimization
;LB520	and #$7f
;		asl @
;		asl @
;		adc #0
;		asl @
;		adc #0
;		asl @
;		adc #0
;		asl @
;		adc #0
;		tay
;		and #$e0
;		adc #<LA76F
;		sta z80_regs,x
;		tya
;		and #$1f
;		adc #>LA76F
;		sta z80_regs+1,x
;		rts

		; optimization version 2
LB520	and #$7f
		tay
		lda LB520_table_low,y
		sta z80_regs,x
		lda LB520_table_high,y
		sta z80_regs+1,x
		rts
		
LB520_table_low  :128 dta l(LA76F+#*$20)
LB520_table_high :128 dta h(LA76F+#*$20)

;LB531   PUSH IX
;B533:   LD   B,36
;B535:   LD   DE,0020
;B538:   LD   IX,A76F
;B53C:   LD   HL,LB55A
;B53F:   LD   C,00
;@@55    LD   A,(IX+00)
;B544:   AND  A
;B545:   JR   Z,@@54
;B547:   BIT  4,(IX+07)
;B54B:   JR   Z,@@54
;B54D:   LD   (HL),C
;B54E:   INC  HL
;@@54    INC  C
;B550:   ADD  IX,DE
;B552:   DJNZ @@55
;B554:   LD   A,FF
;B556:   LD   (HL),A
;B557:   POP  IX
;B559:   RET

LB531   ;lda z80_ix ; PUSH IX
        ;pha
        ;lda z80_ix+1
        ;pha
        lda #$36 ; LD   B,36
        sta z80_b
        ;lda #<L0020 ; LD   DE,0020
        ;sta z80_e
        ;lda #>L0020
        ;sta z80_d
        lda #<LA76F ; LD   IX,A76F
        sta z80_reg0
        lda #>LA76F
        sta z80_reg0+1
        ;lda #<LB55A ; LD   HL,LB55A
        ;sta z80_l
        ;lda #>LB55A
        ;sta z80_h
        ;lda #$00 ; LD   C,00
        ;sta z80_c
		ldx #$00
		stx z80_c
@@55    ldy #$00 ; LD   A,(IX+00)
        lda (z80_reg0),y
        ; AND  A: 
        jeq @@54 ; JR   Z,@@54
        ldy #$07 ; BIT  4,(IX+07)
        lda (z80_reg0),y
        bit _bitmem4
        jeq @@54 ; JR   Z,@@54
        lda z80_c ; LD   (HL),C
        ;ldy #$00
        ;sta (z80_hl),y
        ;inc z80_l ; INC  HL
        ;bne *+4
        ;inc z80_h
		sta LB55A,x
		inx
@@54    inc z80_c ; INC  C
        ;jsr add_ix_de ; ADD  IX,DE
		lda #$20
		clc
		adc z80_reg0
		sta z80_reg0
		scc:inc z80_reg0+1
        dec z80_b ; DJNZ @@55
        jne @@55
        lda #$FF ; LD   A,FF
        ;ldy #$00 ; LD   (HL),A
        ;sta (z80_hl),y
		sta LB55A,x
        ;pla ; POP  IX
        ;sta z80_ix+1
        ;pla
        ;sta z80_ix
        rts ; RET

		; to align to $6B00 & $6CC0
		
		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
		dta $00,$00,$00,$00,$00,$00,$00,$00,$00
		
		;.align
;LB55A   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;B56A:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;B57A:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

LB55A   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

		ert >* != >LB55A
;LB58A   XOR  A
;B58B:   LD   (LA714),A
;B58E:   PUSH IX
;B590:   PUSH IY
;LB592   LD   DE,LB55A
;@@56    LD   A,(DE)
;B596:   INC  DE
;B597:   CP   FF
;B599:   JP   Z,LB6C8
;B59C:   BIT  7,A
;B59E:   JR   NZ,@@56
;B5A0:   CALL LB520
;B5A3:   LD   (LA719),DE
;B5A7:   PUSH HL
;B5A8:   POP  IX
;@@57    LD   A,(DE)
;B5AB:   INC  DE
;B5AC:   CP   FF
;B5AE:   JP   Z,LB6B3
;B5B1:   BIT  7,A
;B5B3:   JR   NZ,@@57
;B5B5:   CALL LB520
;B5B8:   LD   (LA71B),DE
;B5BC:   PUSH HL
;B5BD:   POP  IY
;B5BF:   PUSH IX
;B5C1:   POP  BC
;B5C2:   AND  A
;B5C3:   SBC  HL,BC
;B5C5:   JR   Z,@@57
;B5C7:   LD   C,00
;B5C9:   LD   A,(IY+03)
;B5CC:   ADD  A,(IY+06)
;B5CF:   LD   L,A
;B5D0:   LD   A,(IX+03)
;B5D3:   SUB  L
;B5D4:   JR   NC,@@58
;B5D6:   LD   A,(IX+03)
;B5D9:   ADD  A,(IX+06)
;B5DC:   LD   L,A
;B5DD:   LD   A,(IY+03)
;B5E0:   SUB  L
;B5E1:   JR   C,@@59
;B5E3:   INC  C
;@@59    INC  C
;@@58    LD   A,(IY+02)
;B5E8:   ADD  A,(IY+05)
;B5EB:   LD   L,A
;B5EC:   LD   A,(IX+02)
;B5EF:   SUB  (IX+05)
;B5F2:   SUB  L
;B5F3:   JR   NC,@@60
;B5F5:   LD   A,(IX+02)
;B5F8:   ADD  A,(IX+05)
;B5FB:   LD   L,A
;B5FC:   LD   A,(IY+02)
;B5FF:   SUB  (IY+05)
;B602:   SUB  L
;B603:   LD   A,C
;B604:   JR   C,@@61
;B606:   ADD  A,03
;@@61    ADD  A,03
;B60A:   LD   C,A
;@@60    LD   A,(IY+01)
;B60E:   ADD  A,(IY+04)
;B611:   LD   L,A
;B612:   LD   A,(IX+01)
;B615:   SUB  (IX+04)
;B618:   SUB  L
;B619:   JR   NC,@@62
;B61B:   LD   A,(IX+01)
;B61E:   ADD  A,(IX+04)
;B621:   LD   L,A
;B622:   LD   A,(IY+01)
;B625:   SUB  (IY+04)
;B628:   SUB  L
;B629:   LD   A,C
;B62A:   JR   C,@@63
;B62C:   ADD  A,09
;@@63    ADD  A,09
;B630:   LD   C,A
;@@62    LD   L,C
;B632:   LD   BC,JumpTable2
;B635:   JP   RoutineDispatch

		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 

		;.align $40 ; actually 36, use 40 to force fitting on page
Object_3

		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		
		;.ds $40
Object_sum_3_6
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		;.ds $40
Object_sum_2_5
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		;.ds $40
Object_diff_2_5
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		;.ds $40
Object_sum_1_4
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		;.ds $40
Object_diff_1_4
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		;.ds $40
		
PrepareSorting
		ldx #$00
PrepareSorting_loop		
		lda LB55A,x
		cmp #$ff
		beq PrepareSorting_end
		stx z80_reg2
		sta z80_reg3
		ldx #z80_reg0
 		jsr LB520
 		ldx z80_reg3
 		ldy #$03
 		lda (z80_reg0),y
 		sta Object_3,x
 		clc
 		ldy #$06
 		adc (z80_reg0),y
 		sta Object_sum_3_6,x
 		ldy #$02
 		lda (z80_reg0),y
 		pha
 		clc
 		ldy #$05
 		adc (z80_reg0),y
 		sta Object_sum_2_5,x
 		pla
 		sec
 		sbc (z80_reg0),y
 		sta Object_diff_2_5,x
 		ldy #$01
 		lda (z80_reg0),y
 		pha
 		clc
 		ldy #$04
 		adc (z80_reg0),y
 		sta Object_sum_1_4,x
 		pla
 		sec
 		sbc (z80_reg0),y
 		sta Object_diff_1_4,x
 		
 		ldx z80_reg2
 		inx
 		bne PrepareSorting_loop
		
PrepareSorting_end
		rts
	
LB55A_last_frame
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		;.ds $30
LB55A_sorted_objects
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
		dta 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00		
		;.ds $30
		
	
SortingNoCache
		lda #$ff
		sta LB55A_last_frame
		rts
		
SortingCache
		lda LA711
		bne SortingNoCache
		ldx #0
SortingCache_Loop
		lda LB55A,x
		cmp #$ff
		beq SortingCache_EndOfTable
		cmp LB55A_last_frame,x
		bne SortingCache_Different
		inx
		bne SortingCache_Loop
SortingCache_EndOfTable
		cmp LB55A_last_frame,x
		bne SortingCache_Different
; cache hit, copy last frame objects
		ldx #0
SortingCacheCopy_Loop		
		lda LB55A_sorted_objects,x
		cmp #$ff
		beq SortingCache_End
		sta LB55A,x
		inx
		bne SortingCacheCopy_Loop
SortingCache_End		
		rts
SortingCache_Different
; copy list of objects
		ldx #0
SortingCache_Different_Loop		
		lda LB55A,x
		sta LB55A_last_frame,x
		inx
		cmp #$ff
		bne SortingCache_Different_Loop
		rts

LB58A   jsr PrepareSorting
		jsr SortingCache
		lda #$00 ; XOR  A
        sta LA714 ; LD   (LA714),A
        lda z80_ix ; PUSH IX
        pha
        lda z80_ix+1
        pha
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
LB592   ;lda #<LB55A ; LD   DE,LB55A
        ;sta z80_e
        ;lda #>LB55A
        ;sta z80_d
		ldy #$00
@@56    ;ldy #$00 ; LD   A,(DE)
		;lda (z80_de),y
		lda LB55A,y
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
		iny
        cmp #$FF ; CP   FF; 
        jeq LB6C8 ; JP   Z,LB6C8
        ;bit _bitmem7 ; BIT  7,A; 
        ;jne @@56 ; JR   NZ,@@56
		bmi @@56
		;ldx #z80_ix
        ;jsr LB520 ; CALL LB520
		sta z80_ix
        ;lda z80_e ; LD   (LA719),DE
        ;sta LA719
		sty LA719
		sty z80_e
        ;lda z80_d
        ;sta LA719+1
		;optimization
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;pla ; POP  IX
        ;sta z80_ix+1
        ;pla
        ;sta z80_ix
@@57    ;ldy #$00 ; LD   A,(DE)
		ldy z80_e
@@57_2
		lda LB55A,y
		iny
        ;lda (z80_de),y
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
        cmp #$FF ; CP   FF; 
        jeq LB6B3 ; JP   Z,LB6B3
        ;bit _bitmem7 ; BIT  7,A; 
        ;jne @@57 ; JR   NZ,@@57
		;jne @@57_2
		bmi @@57_2
		cmp z80_ix
		jeq @@57_2
		;ldx #z80_iy
        ;jsr LB520 ; CALL LB520
		sta z80_iy
        ;lda z80_e ; LD   (LA71B),DE
        ;sta LA71B
		sty LA71B
		sty z80_e
        ;lda z80_d
        ;sta LA71B+1
		; optimization
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;pla ; POP  IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		;optimization
        ;lda z80_ix ; PUSH IX
        ;pha
        ;lda z80_ix+1
        ;pha
        ;pla ; POP  BC
        ;sta z80_b
        ;pla
        ;sta z80_c
        ; AND  A
        ;jsr sbc_hl_bc ; SBC  HL,BC
		;jsr cmp_hl_bc
		;jsr cmp_iy_ix
		;lda z80_ix
		;cmp z80_iy
        ;jeq @@57 ; JR   Z,@@57
		tay
		ldx z80_ix
        lda #$00 ; LD   C,00
        sta z80_c
		
        ;ldy #$03 ; LD   A,(IY+03)
        ;lda (z80_iy),y
        ;ldy #$06 ; ADD  A,(IY+06)
        ;clc
        ;adc (z80_iy),y
        ;sta z80_l ; LD   L,A
        ;ldy #$03 ; LD   A,(IX+03)
        ;lda (z80_ix),y
        ;sec ; SUB  L
        ;sbc z80_l
        ;jcs @@58 ; JR   NC,@@58
		lda Object_3,x
		cmp Object_sum_3_6,y
		jcs @@58
		
        ;ldy #$03 ; LD   A,(IX+03)
        ;lda (z80_ix),y
        ;ldy #$06 ; ADD  A,(IX+06)
        ;clc
        ;adc (z80_ix),y
        ;sta z80_l ; LD   L,A
        ;ldy #$03 ; LD   A,(IY+03)
        ;lda (z80_iy),y
        ;sec ; SUB  L
        ;sbc z80_l
        ;jcc @@59 ; JR   C,@@59
		lda Object_3,y
		cmp Object_sum_3_6,x
		jcc @@59
		
		; if we are here, then C will be 2,5,8,11,14,17,20,23,26 (3*n+2), but these always go to @@57
		jmp @@57
		
        inc z80_c ; INC  C
@@59    inc z80_c ; INC  C

;@@58    ldy #$02 ; LD   A,(IY+02)
;        lda (z80_iy),y
;        ldy #$05 ; ADD  A,(IY+05)
;        clc
;        adc (z80_iy),y
;        sta z80_l ; LD   L,A
;        ldy #$02 ; LD   A,(IX+02)
;        lda (z80_ix),y
;        ldy #$05 ; SUB  (IX+05)
;        sec
;        sbc (z80_ix),y
;        sec ; SUB  L
;        sbc z80_l
        ;jcs @@60 ; JR   NC,@@60	; if this branch is taken, code will always go to jp @@57 (through JumpTable2), as C is 0,1,2 here and it can only 0,1,2 or 9,10,11 or 18,19,20 finally but all of these go to jp @@57
;        jcs @@57
@@58	lda Object_diff_2_5,x
		cmp Object_sum_2_5,y
		jcs @@57
		
		;ldy #$02 ; LD   A,(IX+02)
        ;lda (z80_ix),y
        ;ldy #$05 ; ADD  A,(IX+05)
        ;clc
        ;adc (z80_ix),y
        ;sta z80_l ; LD   L,A
        ;ldy #$02 ; LD   A,(IY+02)
        ;lda (z80_iy),y
        ;ldy #$05 ; SUB  (IY+05)
        ;sec
        ;sbc (z80_iy),y
        ;sec ; SUB  L
        ;sbc z80_l
		
		lda Object_diff_2_5,y
		cmp Object_sum_2_5,x
		
        lda z80_c ; LD   A,C
        jcc @@61 ; JR   C,@@61; 
        ;clc ; ADD  A,03
        adc #$02; always C=1 here 
@@61    ;clc ; ADD  A,03 ; always C=0 here
        adc #$03
        sta z80_c ; LD   C,A
		
;@@60    ldy #$01 ; LD   A,(IY+01)
;        lda (z80_iy),y
;        ldy #$04 ; ADD  A,(IY+04)
;        clc
;        adc (z80_iy),y
;        sta z80_l ; LD   L,A
;        ldy #$01 ; LD   A,(IX+01)
;        lda (z80_ix),y
;        ldy #$04 ; SUB  (IX+04)
;        sec
;        sbc (z80_ix),y
;        sec ; SUB  L
;        sbc z80_l
;        jcs @@62 ; JR   NC,@@62
		lda Object_diff_1_4,x
		cmp Object_sum_1_4,y
		jcs @@62
		
;        ldy #$01 ; LD   A,(IX+01)
;        lda (z80_ix),y
;        ldy #$04 ; ADD  A,(IX+04)
;        clc
;        adc (z80_ix),y
;        sta z80_l ; LD   L,A
;        ldy #$01 ; LD   A,(IY+01)
;        lda (z80_iy),y
;        ldy #$04 ; SUB  (IY+04)
;        sec
;        sbc (z80_iy),y
;        sec ; SUB  L
;        sbc z80_l

		lda Object_diff_1_4,y
		cmp Object_sum_1_4,x
		
        lda z80_c ; LD   A,C
        jcc @@63 ; JR   C,@@63; 
		; if we are here, then final value of C will be 18+, but for all values bigger or equal to 18, code always go to @@57 through JumpTable2
		jmp @@57
        ;clc ; ADD  A,09 ; not reachable
        ;adc #$09; 
@@63    ;clc ; ADD  A,09 ; always C=0
        adc #$09
        sta z80_c ; LD   C,A
;@@62    lda z80_c ; LD   L,C
;        sta z80_l
;        lda #<JumpTable2 ; LD   BC,JumpTable2
;        sta z80_c
;        lda #>JumpTable2
;        sta z80_b
;        jmp RoutineDispatch ; JP   RoutineDispatch
@@62	ldx z80_c
		lda JumpTable2,x
		sta Jump2+1
Jump2	jmp LB66E
		
		;.align
		
;JumpTable2: ; B638
;B638:   DW LB66E,LB66E,LB66E,LB674,LB674,LB66E,LB674,LB674
;B648:   DW LB66E,LB66E,LB671,LB671,LB674,LB6B0,LB671,LB674
;B658:   DW LB674,LB66E,LB66E,LB671,LB671,LB66E,LB671,LB671
;B668:   DW LB66E,LB66E,LB66E

;JumpTable2: ; B638
;        .wo LB66E,LB66E,LB66E,LB674,LB674,LB66E,LB674,LB674 ; DW LB66E,LB66E,LB66E,LB674,LB674,LB66E,LB674,LB674
;        .wo LB66E,LB66E,LB671,LB671,LB674,LB6B0,LB671,LB674 ; DW LB66E,LB66E,LB671,LB671,LB674,LB6B0,LB671,LB674
;        .wo LB674,LB66E,LB66E,LB671,LB671,LB66E,LB671,LB671 ; DW LB674,LB66E,LB66E,LB671,LB671,LB66E,LB671,LB671
;        .wo LB66E,LB66E,LB66E ; DW LB66E,LB66E,LB66E

JumpTable2: ; B638
        dta l(LB66E),l(LB66E),l(LB66E),l(LB674),l(LB674),l(LB66E),l(LB674),l(LB674) ; DW LB66E,LB66E,LB66E,LB674,LB674,LB66E,LB674,LB674
        dta l(LB66E),l(LB66E),l(LB671),l(LB671),l(LB674),l(LB66E),l(LB671),l(LB674) ; DW LB66E,LB66E,LB671,LB671,LB674,LB6B0,LB671,LB674
        dta l(LB674),l(LB66E),l(LB66E),l(LB671),l(LB671),l(LB66E),l(LB671),l(LB671) ; DW LB674,LB66E,LB66E,LB671,LB671,LB66E,LB671,LB671
        dta l(LB66E),l(LB66E),l(LB66E) ; DW LB66E,LB66E,LB66E
		
		ert >LB66E <> >LB674
;LB66E   JP   @@57

LB66E   jmp @@57 ; JP   @@57

;LB671   JP   @@57

LB671   jmp @@57 ; JP   @@57

;LB674   LD   HL,(LA71B)
;B677:   DEC  HL
;B678:   LD   C,(HL)
;B679:   LD   DE,LB6CD
;@@66    LD   A,(DE)
;B67D:   CP   FF
;B67F:   JR   Z,@@64
;B681:   CP   C
;B682:   JR   Z,@@65
;B684:   INC  DE
;B685:   JR   @@66

LB674   ;lda LA71B ; LD   HL,(LA71B)
        ;sta z80_l
        ;lda LA71B+1
		;lda #>LB55A
        ;sta z80_h
        ;jsr dec_hl ; DEC  HL
		;dec z80_l
		ldy LA71B
		dey
        ;ldy #$00 ; LD   C,(HL)
        ;lda (z80_hl),y
		lda LB55A,y
        sta z80_c
        ;lda #<LB6CD ; LD   DE,LB6CD
        ;sta z80_e
        ;lda #>LB6CD
        ;sta z80_d
		ldx #$00
@@66    ;ldy #$00 ; LD   A,(DE)
        ;lda (z80_de),y
		lda LB6CD,x
        cmp #$FF ; CP   FF
        jeq @@64 ; JR   Z,@@64
        cmp z80_c ; CP   C; 
        jeq @@65 ; JR   Z,@@65
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
		inx
        jmp @@66 ; JR   @@66

;@@64    LD   A,C
;B688:   LD   (DE),A
;B689:   INC  DE
;B68A:   LD   A,FF
;B68C:   LD   (DE),A
;B68D:   PUSH IY
;B68F:   POP  IX
;B691:   LD   HL,(LA71B)
;B694:   LD   (LA719),HL
;B697:   LD   DE,LB55A
;B69A:   JP   @@57

@@64    lda z80_c ; LD   A,C
        ;ldy #$00 ; LD   (DE),A
        ;sta (z80_de),y
		sta LB6CD,x
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
		inx
        lda #$FF ; LD   A,FF
        ;ldy #$00 ; LD   (DE),A
        ;sta (z80_de),y
		sta LB6CD,x
		lda z80_iy
		sta z80_ix
		;lda z80_iy ; PUSH IY
        ;pha
        ;lda z80_iy+1
        ;pha
        ;pla ; POP  IX
        ;sta z80_ix+1
        ;pla
        ;sta z80_ix
        lda LA71B ; LD   HL,(LA71B)
        sta LA719
		;sta z80_l
        ;lda LA71B+1
        ;sta z80_h
        ;lda z80_l ; LD   (LA719),HL
        ;sta LA719
        ;lda z80_h
        ;sta LA719+1
        ;lda #<LB55A ; LD   DE,LB55A
        ;sta z80_e
        ;lda #>LB55A
        ;sta z80_d
		lda #$00
		sta z80_e
        jmp @@57 ; JP   @@57

;@@65    LD   HL,LB55A
;@@67    LD   A,(HL)
;B6A1:   INC  HL
;B6A2:   CP   FF
;B6A4:   JP   Z,LB592
;B6A7:   CP   C
;B6A8:   JR   NZ,@@67
;B6AA:   PUSH IY
;B6AC:   POP  IX
;B6AE:   JR   @@68

@@65    ;lda #<LB55A ; LD   HL,LB55A
        ;sta z80_l
        ;lda #>LB55A
        ;sta z80_h
		ldy #$00
@@67    ;ldy #$00 ; LD   A,(HL)
        ;lda (z80_hl),y
		lda LB55A,y
        ;inc z80_l ; INC  HL
        ;bne *+4
        ;inc z80_h
		iny
        cmp #$FF ; CP   FF; 
        jeq LB592 ; JP   Z,LB592
        cmp z80_c ; CP   C; 
        jne @@67 ; JR   NZ,@@67
		lda z80_iy
		sta z80_ix
		;lda z80_iy ; PUSH IY
        ;pha
        ;lda z80_iy+1
        ;pha
        ;pla ; POP  IX
        ;sta z80_ix+1
        ;pla
        ;sta z80_ix
        jmp @@68 ; JR   @@68

;LB6B0   JP   @@57

LB6B0   jmp @@57 ; JP   @@57

;LB6B3   LD   HL,(LA719)
;@@68    DEC  HL
;B6B7:   SET  7,(HL)
;B6B9:   LD   A,FF
;B6BB:   LD   (LB6CD),A
;B6BE:   LD   HL,LA714
;B6C1:   INC  (HL)
;B6C2:   CALL LB3D3
;B6C5:   JP   LB592

LB6B3   ;lda LA719 ; LD   HL,(LA719)
        ;sta z80_l
        ;lda LA719+1
		;lda #>LB55A
        ;sta z80_h
		ldy LA719
@@68    sty z80_l
		lda z80_ix
		ldx #z80_ix
		jsr LB520
		;jsr dec_hl ; DEC  HL
		;dec z80_l
		ldy z80_l
		dey
        ;ldy #$00 ; SET  7,(HL)
        ;lda (z80_hl),y
		lda LB55A,y
		tax
        ora #_bitvalue7
        ;sta (z80_hl),y
		sta LB55A,y
        lda #$FF ; LD   A,FF
        sta LB6CD ; LD   (LB6CD),A
        ;lda #<LA714 ; LD   HL,LA714
        ;sta z80_l
        ;lda #>LA714
        ;sta z80_h
        ;ldy #$00 ; INC  (HL)
        ;lda (z80_hl),y
        ;clc
        ;adc #$01
        ;sta (z80_hl),y
		txa
		ldy LA714
		sta LB55A_sorted_objects,y
		inc LA714
        jsr LB3D3 ; CALL LB3D3
        jmp LB592 ; JP   LB592

;LB6C8   POP  IY
;B6CA:   POP  IX
;B6CC:   RET

LB6C8   ldy LA714
		lda #$ff
		sta LB55A_sorted_objects,y
		pla ; POP  IY
        sta z80_iy+1
        pla
        sta z80_iy
        pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix
        rts ; RET

;LB6CD   DB FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF

LB6CD   .he FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF ; DB FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF

LB6DD	sta z80_a
		ldx z80_c
		ldy z80_b
		lda table_LB6DD,y
		sta LB6DD_jump+1
		lda #$21
		sec 
		sbc z80_b
		sta LB6DD_adjust_y+1
		ldy #$00
		clc
		jmp LB6DD_next_iteration
		
		;.align
		
LB6DD_start_fill
		sta (z80_hl),y ; 32
		iny
		sta (z80_hl),y ; 31
		iny
		sta (z80_hl),y ; 30
		iny
		sta (z80_hl),y ; 29
		iny
		sta (z80_hl),y ; 28
		iny
		sta (z80_hl),y ; 27
		iny
		sta (z80_hl),y ; 26
		iny
		sta (z80_hl),y ; 25
		iny
		sta (z80_hl),y ; 24
		iny
		sta (z80_hl),y ; 23
		iny
		sta (z80_hl),y ; 22
		iny
		sta (z80_hl),y ; 21
		iny
		sta (z80_hl),y ; 20
		iny
		sta (z80_hl),y ; 19
		iny
		sta (z80_hl),y ; 18
		iny
		sta (z80_hl),y ; 17
		iny
		sta (z80_hl),y ; 16
		iny
		sta (z80_hl),y ; 15
		iny
		sta (z80_hl),y ; 14
		iny
		sta (z80_hl),y ; 13
		iny
		sta (z80_hl),y ; 12
		iny
		sta (z80_hl),y ; 11
		iny
		sta (z80_hl),y ; 10
		iny
		sta (z80_hl),y ; 9
		iny
		sta (z80_hl),y ; 8
		iny
		sta (z80_hl),y ; 7
		iny
		sta (z80_hl),y ; 6
		iny
		sta (z80_hl),y ; 5
		iny
		sta (z80_hl),y ; 4
		iny
		sta (z80_hl),y ; 3
		iny
		sta (z80_hl),y ; 2
		iny
		sta (z80_hl),y ; 1
		;iny
LB6DD_end_fill		
		;lda #$20
		;clc
		;adc z80_l
		;sta z80_l
		;scc:inc z80_h
		;dex
		;beq LB6DD_end
		tya
LB6DD_adjust_y
		adc #$00
		tay
		bcc LB6DD_dex
		inc z80_h
		clc
LB6DD_dex		
		dex
		beq LB6DD_end
LB6DD_next_iteration		
		lda z80_a
		;ldy #$00
LB6DD_jump		
		jmp LB6DD_start_fill
LB6DD_end
		rts
table_LB6DD :32 dta [<LB6DD_start_fill+(32-#)*3]	

		ert >LB6DD_end_fill != >LB6DD_start_fill		

		

		
;LB6DD   LD   DE,0020
;@@70    PUSH BC
;B6E1:   PUSH HL
;@@69    LD   (HL),A
;B6E3:   INC  HL
;B6E4:   DJNZ @@69
;B6E6:   POP  HL
;B6E7:   ADD  HL,DE
;B6E8:   POP  BC
;B6E9:   DEC  C
;B6EA:   JR   NZ,@@70
;B6EC:   RET

;LB6DD   sta z80_a
;		lda #<L0020 ; LD   DE,0020
;        sta z80_e
;        lda #>L0020
;        sta z80_d
;@@70    lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda z80_l ; PUSH HL
;        pha
;        lda z80_h
;        pha
;		lda z80_a
;@@69    ldy #$00 ; LD   (HL),A
;        sta (z80_hl),y; 
;        inc z80_l ; INC  HL
;        bne *+4
;        inc z80_h
;        dec z80_b ; DJNZ @@69
;        jne @@69
;        pla ; POP  HL
;        sta z80_h
;        pla
;        sta z80_l
;        jsr add_hl_de ; ADD  HL,DE
;        pla ; POP  BC
;        sta z80_b
;        pla
;        sta z80_c
;        dec z80_c ; DEC  C
;        jne @@70 ; JR   NZ,@@70
;        rts ; RET

	
;LB6DD_old   sta z80_a
;		ldx z80_c
		;lda #<L0020 ; LD   DE,0020
        ;sta z80_e
        ;lda #>L0020
        ;sta z80_d
;@@70    ;lda z80_c ; PUSH BC
        ;pha
        ;lda z80_b
        ;pha
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
;		lda z80_a
;		ldy #$00 ; LD   (HL),A
;@@69    sta (z80_hl),y; 
        ;inc z80_l ; INC  HL
        ;bne *+4
        ;inc z80_h
        ;dec z80_b ; DJNZ @@69
;		iny
;		cpy z80_b
;        jne @@69
;		lda #$20
;		clc
;		adc z80_l
;		sta z80_l
;		scc:inc z80_h
        ;pla ; POP  HL
        ;sta z80_h
        ;pla
        ;sta z80_l
        ;jsr add_hl_de ; ADD  HL,DE
        ;pla ; POP  BC
        ;sta z80_b
        ;pla
        ;sta z80_c
        ;dec z80_c ; DEC  C
;		dex
;        jne @@70 ; JR   NZ,@@70
;        rts ; RET
		
;LB6ED   BIT  1,(IX+07)
;B6F1:   RET  NZ
;B6F2:   SET  1,(IX+07)
;B6F6:   LD   A,(IX+0C)
;B6F9:   AND  F8
;B6FB:   LD   (IX+0C),A
;B6FE:   LD   L,00
;B700:   LD   C,L
;B701:   LD   A,(IX+0B)
;B704:   AND  A
;B705:   LD   H,A
;B706:   JR   Z,@@71
;B708:   CALL LB963
;B70B:   LD   A,H
;B70C:   AND  A
;B70D:   JR   Z,@@71
;B70F:   CALL LB7E0
;@@71    LD   A,(IX+09)
;B715:   AND  A
;B716:   LD   C,A
;B717:   JR   Z,@@72
;B719:   CALL LB8E2
;B71C:   LD   A,C
;B71D:   AND  A
;B71E:   JR   Z,@@72
;B720:   CALL LB742
;@@72    LD   A,(IX+0A)
;B726:   AND  A
;B727:   LD   L,A
;B728:   JR   Z,@@73
;B72A:   CALL LB90D
;B72D:   LD   A,L
;B72E:   AND  A
;B72F:   JR   Z,@@73
;B731:   CALL LB791
;@@73    LD   (IX+09),C
;B737:   LD   (IX+0A),L
;B73A:   LD   (IX+0B),H
;B73D:   RES  1,(IX+07)
;B741:   RET

LB6ED   ldy #$07 ; BIT  1,(IX+07)
        lda (z80_ix),y
        bit _bitmem1
        beq *+3 ; RET  NZ
        rts
        ;ldy #$07 ; SET  1,(IX+07)
        ;lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
        ldy #$0C ; LD   A,(IX+0C)
        lda (z80_ix),y
        and #$F8 ; AND  F8
        ;ldy #$0C ; LD   (IX+0C),A
        sta (z80_ix),y
        lda #$00 ; LD   L,00
        sta z80_l
        ;lda z80_l ; LD   C,L
        sta z80_c
        ldy #$0B ; LD   A,(IX+0B)
        lda (z80_ix),y
        ; AND  A 
        sta z80_h ; LD   H,A
        jeq @@71 ; JR   Z,@@71; 
        jsr LB963 ; CALL LB963
        lda z80_h ; LD   A,H
        ; AND  A 
        jeq @@71 ; JR   Z,@@71
        jsr LB7E0 ; CALL LB7E0
@@71    ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        ; AND  A
        sta z80_c ; LD   C,A
        jeq @@72 ; JR   Z,@@72
        jsr LB8E2 ; CALL LB8E2
        lda z80_c ; LD   A,C
        ; AND  A
        jeq @@72 ; JR   Z,@@72
        jsr LB742 ; CALL LB742
@@72    ldy #$0A ; LD   A,(IX+0A)
        lda (z80_ix),y
        ; AND  A: 
        sta z80_l ; LD   L,A
        jeq @@73 ; JR   Z,@@73; 
        jsr LB90D ; CALL LB90D
        lda z80_l ; LD   A,L
        ; AND  A: 
        jeq @@73 ; JR   Z,@@73
        jsr LB791 ; CALL LB791
@@73    ldy #$09 ; LD   (IX+09),C
        lda z80_c
        sta (z80_ix),y
        ldy #$0A ; LD   (IX+0A),L
        lda z80_l
        sta (z80_ix),y
        ldy #$0B ; LD   (IX+0B),H
        lda z80_h
        sta (z80_ix),y
        ldy #$07 ; RES  1,(IX+07)
        lda (z80_ix),y
        and #_notbitvalue1
        sta (z80_ix),y
        rts ; RET

;LB742   LD   IY,A76F
;B746:   LD   B,36
;@@77    CALL LB99B
;B74B:   JR   Z,@@74
;B74D:   CALL LB8B7
;B750:   JR   NC,@@74
;B752:   CALL LB8CC
;B755:   JR   NC,@@74
;@@76    CALL LB8A2
;B75A:   JR   NC,@@74
;B75C:   SET  0,(IX+0C)
;B760:   LD   A,(IX+0D)
;B763:   RRCA
;B764:   AND  40
;B766:   OR   (IY+0D)
;B769:   LD   (IY+0D),A
;B76C:   RLCA
;B76D:   AND  40
;B76F:   OR   (IX+0D)
;B772:   LD   (IX+0D),A
;B775:   BIT  2,(IY+07)
;B779:   JR   Z,@@75
;B77B:   LD   A,(IX+09)
;B77E:   LD   (IY+09),A
;@@75    LD   A,C
;B782:   CALL LB95A
;B785:   LD   C,A
;B786:   RET  Z
;B787:   JR   @@76

LB742   lda #<LA76F ; LD   IY,A76F
        sta z80_iy
        lda #>LA76F
        sta z80_iy+1
        lda #$36 ; LD   B,36
        sta z80_b
@@77    jsr LB99B ; CALL LB99B
        jeq @@74 ; JR   Z,@@74
        jsr LB8B7 ; CALL LB8B7
        jcs @@74 ; JR   NC,@@74
        jsr LB8CC ; CALL LB8CC
        jcs @@74 ; JR   NC,@@74
@@76    jsr LB8A2 ; CALL LB8A2
        jcs @@74 ; JR   NC,@@74
        ldy #$0C ; SET  0,(IX+0C)
        lda (z80_ix),y
        ora #_bitvalue0
        sta (z80_ix),y
        ;ldy #$0D ; LD   A,(IX+0D)
		iny
        lda (z80_ix),y
        lsr @ ; RRCA
        and #$40 ; AND  40
        ;ldy #$0D ; OR   (IY+0D)
        ora (z80_iy),y
        ;ldy #$0D ; LD   (IY+0D),A
        sta (z80_iy),y
        asl @ ; RLCA
        and #$40 ; AND  40
        ;ldy #$0D ; OR   (IX+0D)
        ora (z80_ix),y
        ;ldy #$0D ; LD   (IX+0D),A
        sta (z80_ix),y
        ldy #$07 ; BIT  2,(IY+07)
        lda (z80_iy),y
        bit _bitmem2
        jeq @@75 ; JR   Z,@@75
        ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        ;ldy #$09 ; LD   (IY+09),A
        sta (z80_iy),y
@@75    lda z80_c ; LD   A,C
        jsr LB95A ; CALL LB95A
        sta z80_c ; LD   C,A; 
        bne *+3 ; RET  Z
        rts; 
        jmp @@76 ; JR   @@76

;@@74    LD   DE,0020
;B78C:   ADD  IY,DE
;B78E:   DJNZ @@77
;B790:   RET

;@@74    lda #<L0020 ; LD   DE,0020
;        sta z80_e
;        lda #>L0020
;        sta z80_d
;        jsr add_iy_de ; ADD  IY,DE
@@74	lda #$20
		clc
		adc z80_iy
		sta z80_iy
		scc:inc z80_iy+1
        dec z80_b ; DJNZ @@77
        jne @@77
        rts ; RET

;LB791   LD   IY,A76F
;B795:   LD   B,36
;@@81    CALL LB99B
;B79A:   JR   Z,@@78
;B79C:   CALL LB8A2
;B79F:   JR   NC,@@78
;B7A1:   CALL LB8CC
;B7A4:   JR   NC,@@78
;@@80    CALL LB8B7
;B7A9:   JR   NC,@@78
;B7AB:   SET  1,(IX+0C)
;B7AF:   LD   A,(IX+0D)
;B7B2:   RRCA
;B7B3:   AND  40
;B7B5:   OR   (IY+0D)
;B7B8:   LD   (IY+0D),A
;B7BB:   RLCA
;B7BC:   AND  40
;B7BE:   OR   (IX+0D)
;B7C1:   LD   (IX+0D),A
;B7C4:   BIT  2,(IY+07)
;B7C8:   JR   Z,@@79
;B7CA:   LD   A,(IX+0A)
;B7CD:   LD   (IY+0A),A
;@@79    LD   A,L
;B7D1:   CALL LB95A
;B7D4:   LD   L,A
;B7D5:   RET  Z
;B7D6:   JR   @@80

LB791   lda #<LA76F ; LD   IY,A76F
        sta z80_iy
        lda #>LA76F
        sta z80_iy+1
        lda #$36 ; LD   B,36
        sta z80_b
@@81    jsr LB99B ; CALL LB99B
        jeq @@78 ; JR   Z,@@78; 
        jsr LB8A2 ; CALL LB8A2
        jcs @@78 ; JR   NC,@@78; 
        jsr LB8CC ; CALL LB8CC
        jcs @@78 ; JR   NC,@@78;
@@80    jsr LB8B7 ; CALL LB8B7
        jcs @@78 ; JR   NC,@@78; 
        ldy #$0C ; SET  1,(IX+0C)
        lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
        ldy #$0D ; LD   A,(IX+0D)
        lda (z80_ix),y
        lsr @ ; RRCA
        and #$40 ; AND  40
        ;ldy #$0D ; OR   (IY+0D)
        ora (z80_iy),y
        ;ldy #$0D ; LD   (IY+0D),A
        sta (z80_iy),y
        asl @ ; RLCA
        and #$40 ; AND  40
        ;ldy #$0D ; OR   (IX+0D)
        ora (z80_ix),y
        ;ldy #$0D ; LD   (IX+0D),A
        sta (z80_ix),y
        ldy #$07 ; BIT  2,(IY+07)
        lda (z80_iy),y
        bit _bitmem2
        jeq @@79 ; JR   Z,@@79
        ldy #$0A ; LD   A,(IX+0A)
        lda (z80_ix),y
        ;ldy #$0A ; LD   (IY+0A),A
        sta (z80_iy),y
@@79    lda z80_l ; LD   A,L
        jsr LB95A ; CALL LB95A
        sta z80_l ; LD   L,A; 
        bne *+3 ; RET  Z
        rts; 
        jmp @@80 ; JR   @@80

;@@78    LD   DE,0020
;B7DB:   ADD  IY,DE
;B7DD:   DJNZ @@81
;B7DF:   RET

;@@78    lda #<L0020 ; LD   DE,0020
;        sta z80_e
;        lda #>L0020
;        sta z80_d
;        jsr add_iy_de ; ADD  IY,DE
@@78	lda #$20
		clc
		adc z80_iy
		sta z80_iy
		scc:inc z80_iy+1
        dec z80_b ; DJNZ @@81
        jne @@81
        rts ; RET

;LB7E0   LD   IY,A76F
;B7E4:   LD   B,36
;@@88    CALL LB99B
;B7E9:   JR   Z,@@82
;B7EB:   CALL LB8A2
;B7EE:   JR   NC,@@82
;B7F0:   CALL LB8B7
;B7F3:   JR   NC,@@82
;@@87    CALL LB8CC
;B7F8:   JR   NC,@@82
;B7FA:   SET  2,(IX+0C)
;B7FE:   CALL LB890
;B801:   LD   A,(IY+00)
;B804:   CP   20
;B806:   JR   C,@@83
;B808:   CP   28
;B80A:   JR   NC,@@83
;B80C:   SET  7,(IX+17)
;@@83    CP   8C
;B812:   JR   C,@@84
;B814:   CP   90
;B816:   CALL C,LB866
;@@84    LD   A,(IX+0D)
;B81C:   RRCA
;B81D:   AND  40
;B81F:   OR   (IY+0D)
;B822:   LD   (IY+0D),A
;B825:   RLCA
;B826:   AND  40
;B828:   OR   (IX+0D)
;B82B:   LD   (IX+0D),A
;B82E:   SET  3,(IY+0D)
;B832:   BIT  2,(IX+07)
;B836:   JR   Z,@@85
;B838:   LD   A,(IX+0B)
;B83B:   LD   (IY+0B),A
;B83E:   LD   A,(IX+09)
;B841:   AND  A
;B842:   JR   NZ,@@86
;B844:   LD   A,(IY+09)
;B847:   LD   (IX+09),A
;@@86    LD   A,(IX+0A)
;B84D:   AND  A
;B84E:   JR   NZ,@@85
;B850:   LD   A,(IY+0A)
;B853:   LD   (IX+0A),A
;@@85    LD   A,H
;B857:   CALL LB95A
;B85A:   LD   H,A
;B85B:   RET  Z
;B85C:   JR   @@87

LB7E0   lda #<LA76F ; LD   IY,A76F
        sta z80_iy
        lda #>LA76F
        sta z80_iy+1
        lda #$36 ; LD   B,36
        sta z80_b
@@88    jsr LB99B ; CALL LB99B
        jeq @@82 ; JR   Z,@@82; 
        jsr LB8A2 ; CALL LB8A2
        jcs @@82 ; JR   NC,@@82
        jsr LB8B7 ; CALL LB8B7
        jcs @@82 ; JR   NC,@@82
@@87    jsr LB8CC ; CALL LB8CC
        jcs @@82 ; JR   NC,@@82
        ldy #$0C ; SET  2,(IX+0C)
        lda (z80_ix),y
        ora #_bitvalue2
        sta (z80_ix),y
        jsr LB890 ; CALL LB890
        ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        cmp #$20 ; CP   20
        jcc @@83 ; JR   C,@@83
        cmp #$28 ; CP   28
        jcs @@83 ; JR   NC,@@83
		tax
        ldy #$17 ; SET  7,(IX+17)
        lda (z80_ix),y
        ora #_bitvalue7
        sta (z80_ix),y
		txa
@@83    cmp #$8C ; CP   8C
        jcc @@84 ; JR   C,@@84
        cmp #$90 ; CP   90
        bcs *+5 ; CALL C,LB866
        jsr LB866 ; 
@@84    ldy #$0D ; LD   A,(IX+0D)
        lda (z80_ix),y
        lsr @ ;  RRCA
        and #$40 ; AND  40
        ;ldy #$0D ; OR   (IY+0D)
        ora (z80_iy),y
        ;ldy #$0D ; LD   (IY+0D),A
        sta (z80_iy),y
        asl @ ; RLCA
        and #$40 ; AND  40
        ;ldy #$0D ; OR   (IX+0D)
        ora (z80_ix),y
        ;ldy #$0D ; LD   (IX+0D),A
        sta (z80_ix),y
        ;ldy #$0D ; SET  3,(IY+0D)
        lda (z80_iy),y
        ora #_bitvalue3
        sta (z80_iy),y
        ldy #$07 ; BIT  2,(IX+07)
        lda (z80_ix),y
        bit _bitmem2
        jeq @@85 ; JR   Z,@@85
        ldy #$0B ; LD   A,(IX+0B)
        lda (z80_ix),y
        ;ldy #$0B ; LD   (IY+0B),A
        sta (z80_iy),y
        ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        ; AND  A
        jne @@86 ; JR   NZ,@@86
        ;ldy #$09 ; LD   A,(IY+09)
        lda (z80_iy),y
        ;ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
@@86    ldy #$0A ; LD   A,(IX+0A)
        lda (z80_ix),y
        ; AND  A
        jne @@85 ; JR   NZ,@@85
        ;ldy #$0A ; LD   A,(IY+0A)
        lda (z80_iy),y
        ;ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
@@85    lda z80_h ; LD   A,H
        jsr LB95A ; CALL LB95A
        sta z80_h ; LD   H,A
        bne *+3 ; RET  Z
        rts; 
        jmp @@87 ; JR   @@87

;@@82    LD   DE,0020
;B861:   ADD  IY,DE
;B863:   DJNZ @@88
;B865:   RET

@@82    ;lda #<L0020 ; LD   DE,0020
        ;sta z80_e
        ;lda #>L0020
        ;sta z80_d
        ;jsr add_iy_de ; ADD  IY,DE
		;optimization
		lda #$20
		clc
		adc z80_iy
		sta z80_iy
		scc:inc z80_iy+1
        dec z80_b ; DJNZ @@88
        jne @@88
        rts ; RET

;LB866   BIT  3,(IY+0D)
;B86A:   RET  NZ
;B86B:   AND  03
;B86D:   ADD  A,A
;B86E:   PUSH DE
;B86F:   PUSH HL
;B870:   LD   D,00
;B872:   LD   E,A
;B873:   LD   A,(LA715)
;B876:   AND  01
;B878:   JR   Z,@@89
;B87A:   LD   HL,LD30A
;B87D:   ADD  HL,DE
;B87E:   LD   A,(HL)
;B87F:   ADD  A,(IX+09)
;B882:   LD   (IX+09),A
;B885:   INC  HL
;B886:   LD   A,(HL)
;B887:   ADD  A,(IX+0A)
;B88A:   LD   (IX+0A),A
;@@89    POP  HL
;B88E:   POP  DE
;B88F:   RET

LB866   tax
		ldy #$0D ; BIT  3,(IY+0D)
        lda (z80_iy),y
        bit _bitmem3
        beq *+3 ; RET  NZ
        rts
		txa
        and #$03 ; AND  03
        asl @ ; ADD  A,A
		tax
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda #$00 ; LD   D,00
        sta z80_d
        stx z80_e ; LD   E,A
        lda LA715 ; LD   A,(LA715)
        and #$01 ; AND  01
        jeq @@89 ; JR   Z,@@89
        lda #<LD30A ; LD   HL,LD30A
        sta z80_l
        lda #>LD30A
        sta z80_h
        jsr add_hl_de ; ADD  HL,DE
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ldy #$09 ; ADD  A,(IX+09)
        clc
        adc (z80_ix),y
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ldy #$0A ; ADD  A,(IX+0A)
        clc
        adc (z80_ix),y
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
@@89    pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        rts ; RET

;LB890   LD   A,(IX+00)
;B893:   CP   5B
;B895:   JR   Z,@@90
;B897:   CP   20
;B899:   RET  C
;B89A:   CP   28
;B89C:   RET  NC
;@@90    SET  7,(IY+17)
;B8A1:   RET

LB890   ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        cmp #$5B ; CP   5B
        jeq @@90 ; JR   Z,@@90
        cmp #$20 ; CP   20
        bcs *+3 ; RET  C
        rts
        cmp #$28 ; CP   28
        bcc *+3 ; RET  NC
        rts
@@90    ldy #$17 ; SET  7,(IY+17)
        lda (z80_iy),y
        ora #_bitvalue7
        sta (z80_iy),y
        rts ; RET

;LB8A2   LD   A,(IX+04)
;B8A5:   ADD  A,(IY+04)
;B8A8:   LD   D,A
;B8A9:   LD   A,(IX+01)
;B8AC:   ADD  A,C
;B8AD:   SUB  (IY+01)
;B8B0:   JP   P,LB8B5
;B8B3:   NEG
;LB8B5   SUB  D
;B8B6:   RET

LB8A2   ldy #$04 ; LD   A,(IX+04)
        lda (z80_ix),y
        ;ldy #$04 ; ADD  A,(IY+04)
        clc
        adc (z80_iy),y
        sta z80_d ; LD   D,A
        ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        clc ; ADD  A,C
        adc z80_c
        ;ldy #$01 ; SUB  (IY+01)
        sec
        sbc (z80_iy),y
        jpl LB8B5 ; JP   P,LB8B5
        eor #$ff ; NEG
        clc
        adc #$01; 
LB8B5   sec ; SUB  D
        sbc z80_d
        rts ; RET

;LB8B7   LD   A,(IX+05)
;B8BA:   ADD  A,(IY+05)
;B8BD:   LD   D,A
;B8BE:   LD   A,(IX+02)
;B8C1:   ADD  A,L
;B8C2:   SUB  (IY+02)
;B8C5:   JP   P,LB8CA
;B8C8:   NEG
;LB8CA   SUB  D
;B8CB:   RET

LB8B7   ldy #$05 ; LD   A,(IX+05)
        lda (z80_ix),y
        ;ldy #$05 ; ADD  A,(IY+05)
        clc
        adc (z80_iy),y
        sta z80_d ; LD   D,A
        ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        clc ; ADD  A,L
        adc z80_l
        ;ldy #$02 ; SUB  (IY+02)
        sec
        sbc (z80_iy),y
        jpl LB8CA ; JP   P,LB8CA
        eor #$ff ; NEG
        clc
        adc #$01; 
LB8CA   sec ; SUB  D
        sbc z80_d
        rts ; RET

;LB8CC   LD   A,(IX+03)
;B8CF:   ADD  A,H
;B8D0:   SUB  (IY+03)
;B8D3:   JP   P,LB8DD
;B8D6:   NEG
;B8D8:   LD   D,(IX+06)
;@@91    SUB  D
;B8DC:   RET

LB8CC   ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        clc ; ADD  A,H
        adc z80_h
        ;ldy #$03 ; SUB  (IY+03)
        sec
        sbc (z80_iy),y
        jpl LB8DD ; JP   P,LB8DD
        eor #$ff ; NEG
        clc
        adc #$01; 
		tax
        ldy #$06 ; LD   D,(IX+06)
        lda (z80_ix),y
        sta z80_d
@@91    txa
		sec ; SUB  D
        sbc z80_d; 
        rts ; RET

;LB8DD   LD   D,(IY+06)
;B8E0:   JR   @@91

LB8DD   tax
		ldy #$06 ; LD   D,(IY+06)
        lda (z80_iy),y
        sta z80_d
        jmp @@91 ; JR   @@91

;LB8E2   LD   A,(IX+0C)
;B8E5:   AND  F0
;B8E7:   RET  NZ
;B8E8:   BIT  0,(IX+07)
;B8EC:   RET  NZ
;B8ED:   LD   A,(LA71D)
;B8F0:   LD   B,A
;@@94    LD   A,(IX+01)
;B8F4:   ADD  A,C
;B8F5:   SUB  80
;B8F7:   JR   NC,@@92
;B8F9:   NEG
;@@92    ADD  A,(IX+04)
;B8FE:   CP   B
;B8FF:   JR   C,@@93
;B901:   SET  0,(IX+0C)
;B905:   LD   A,C
;B906:   CALL LB95A
;B909:   LD   C,A
;B90A:   JR   NZ,@@94
;@@93    RET

LB8E2   ldy #$0C ; LD   A,(IX+0C)
        lda (z80_ix),y
        and #$F0 ; AND  F0
        beq *+3 ; RET  NZ
        rts
        ldy #$07 ; BIT  0,(IX+07)
        lda (z80_ix),y
        bit _bitmem0
        beq *+3 ; RET  NZ
        rts
        lda LA71D ; LD   A,(LA71D)
        sta z80_b ; LD   B,A
@@94    ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        clc ; ADD  A,C
        adc z80_c
        sec ; SUB  80
        sbc #$80
        jcs @@92 ; JR   NC,@@92
        eor #$ff ; NEG
        clc
        adc #$01; 
@@92    ldy #$04 ; ADD  A,(IX+04)
        clc
        adc (z80_ix),y
        cmp z80_b ; CP   B
        jcc @@93 ; JR   C,@@93
        ldy #$0C ; SET  0,(IX+0C)
        lda (z80_ix),y
        ora #_bitvalue0
        sta (z80_ix),y
        lda z80_c ; LD   A,C
        jsr LB95A ; CALL LB95A
        sta z80_c ; LD   C,A; 
        jne @@94 ; JR   NZ,@@94; 
@@93    rts ; RET

;LB90D   LD   A,(IX+0C)
;B910:   AND  F0
;B912:   RET  NZ
;B913:   BIT  0,(IX+07)
;B917:   RET  NZ
;B918:   LD   A,(LA71E)
;B91B:   LD   B,A
;@@97    LD   A,(IX+02)
;B91F:   ADD  A,L
;B920:   SUB  80
;B922:   JR   NC,@@95
;B924:   NEG
;@@95    ADD  A,(IX+05)
;B929:   CP   B
;B92A:   JR   C,@@96
;B92C:   SET  1,(IX+0C)
;B930:   LD   A,L
;B931:   CALL LB95A
;B934:   LD   L,A
;B935:   JR   NZ,@@97
;@@96    RET

LB90D   ldy #$0C ; LD   A,(IX+0C)
        lda (z80_ix),y
        and #$F0 ; AND  F0
        beq *+3 ; RET  NZ
        rts
        ldy #$07 ; BIT  0,(IX+07)
        lda (z80_ix),y
        bit _bitmem0
        beq *+3 ; RET  NZ
        rts
        lda LA71E ; LD   A,(LA71E)
        sta z80_b ; LD   B,A
@@97    ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        clc ; ADD  A,L
        adc z80_l
        sec ; SUB  80
        sbc #$80
        jcs @@95 ; JR   NC,@@95
        eor #$ff ; NEG
        clc
        adc #$01; 
@@95    ldy #$05 ; ADD  A,(IX+05)
        clc
        adc (z80_ix),y
        cmp z80_b ; CP   B
        jcc @@96 ; JR   C,@@96
        ldy #$0C ; SET  1,(IX+0C)
        lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
        lda z80_l ; LD   A,L
        jsr LB95A ; CALL LB95A
        sta z80_l ; LD   L,A; 
        jne @@97 ; JR   NZ,@@97
@@96    rts ; RET

;LB938   CALL LB2C5
;B93B:   CALL LB2EE
;B93E:   LD   A,(IX+1A)
;B941:   AND  07
;B943:   LD   A,(DE)
;B944:   INC  DE
;B945:   JR   Z,@@98
;B947:   INC  A
;@@98    AND  0F
;B94A:   LD   (IX+18),A
;B94D:   LD   A,(DE)
;B94E:   LD   (IX+19),A
;B951:   RET

LB938   jsr LB2C5 ; CALL LB2C5
        jsr LB2EE ; CALL LB2EE
        ldy #$1A ; LD   A,(IX+1A)
        lda (z80_ix),y
        and #$07 ; AND  07
		php
        ldy #$00 ; LD   A,(DE)
        lda (z80_de),y
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
		plp
        jeq @@98 ; JR   Z,@@98
        clc ; INC  A
        adc #$01; 
@@98    and #$0F ; AND  0F
        ldy #$18 ; LD   (IX+18),A
        sta (z80_ix),y
        ldy #$00 ; LD   A,(DE)
        lda (z80_de),y
        ldy #$19 ; LD   (IX+19),A
        sta (z80_ix),y
        rts ; RET

;ReadKey OUT  (FD),A
;B954:   IN   A,(FE)
;B956:   CPL
;B957:   AND  1F
;B959:   RET

;ReadKey
;		jsr out_fd ; OUT  (FD),A
;        jsr in_a_fe ; IN   A,(FE)
;        eor #$ff ; CPL
;        and #$1F ; AND  1F
;        rts ; RET

;LB95A   AND  A
;B95B:   RET  Z
;B95C:   JP   P,LB961
;B95F:   INC  A
;B960:   INC  A
;LB961   DEC  A
;B962:   RET

LB95A   ; AND  A
        bne *+3 ; RET  Z
        rts
        jpl LB961 ; JP   P,LB961
        clc ; INC  A
        adc #$01
        clc ; INC  A
        adc #$01
LB961   sec ; DEC  A
        sbc #$01
        rts ; RET

;LB963   LD   A,(LA71F)
;B966:   LD   D,A
;@@99    LD   A,(IX+03)
;B96A:   ADD  A,H
;B96B:   CP   D
;B96C:   RET  NC
;B96D:   SET  2,(IX+0C)
;B971:   LD   A,H
;B972:   CALL LB95A
;B975:   LD   H,A
;B976:   JR   NZ,@@99
;B978:   RET

LB963   lda LA71F ; LD   A,(LA71F)
        sta z80_d ; LD   D,A
@@99    ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        clc ; ADD  A,H
        adc z80_h
        cmp z80_d ; CP   D
        bcc *+3 ; RET  NC
        rts
        ldy #$0C ; SET  2,(IX+0C)
        lda (z80_ix),y
        ora #_bitvalue2
        sta (z80_ix),y
        lda z80_h ; LD   A,H
        jsr LB95A ; CALL LB95A
        sta z80_h ; LD   H,A; 
        jne @@99 ; JR   NZ,@@99
        rts ; RET

;LB979   DEC  (IX+0B)
;LB97C   CALL LB6ED
;LB97F   LD   A,(IX+01)
;B982:   ADD  A,(IX+09)
;B985:   LD   (IX+01),A
;B988:   LD   A,(IX+02)
;B98B:   ADD  A,(IX+0A)
;B98E:   LD   (IX+02),A
;B991:   LD   A,(IX+03)
;B994:   ADD  A,(IX+0B)
;B997:   LD   (IX+03),A
;B99A:   RET

LB979   ldy #$0B ; DEC  (IX+0B)
        lda (z80_ix),y
        sec
        sbc #$01
        sta (z80_ix),y
LB97C   jsr LB6ED ; CALL LB6ED
LB97F   ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        ldy #$09 ; ADD  A,(IX+09)
        clc
        adc (z80_ix),y
        ldy #$01 ; LD   (IX+01),A
        sta (z80_ix),y
        ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        ldy #$0A ; ADD  A,(IX+0A)
        clc
        adc (z80_ix),y
        ldy #$02 ; LD   (IX+02),A
        sta (z80_ix),y
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        ldy #$0B ; ADD  A,(IX+0B)
        clc
        adc (z80_ix),y
        ldy #$03 ; LD   (IX+03),A
        sta (z80_ix),y
        rts ; RET

;LB99B   LD   A,(IY+00)
;B99E:   AND  A
;B99F:   RET  Z
;B9A0:   LD   A,(IY+07)
;B9A3:   CPL
;B9A4:   AND  02
;B9A6:   RET

LB99B   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        ; AND  A
        ;bne *+3 ; RET  Z
        ;rts
		beq LB99B_RET
        ldy #$07 ; LD   A,(IY+07)
        lda (z80_iy),y
        eor #$ff ; CPL
        and #$02 ; AND  02
LB99B_RET		
        rts ; RET

;LB9A7   LD   IY,A76F
;B9AB:   CALL LB938
;B9AE:   LD   B,36
;B9B0:   LD   A,(IX+1A)
;B9B3:   RRCA
;B9B4:   RRCA
;B9B5:   RRCA
;B9B6:   AND  1F
;B9B8:   LD   L,A
;B9B9:   LD   A,(IX+1E)
;B9BC:   RRCA
;B9BD:   RRCA
;B9BE:   RRCA
;B9BF:   AND  1F
;B9C1:   LD   H,A
;B9C2:   CP   L
;B9C3:   JR   C,@@100
;B9C5:   LD   A,L
;@@100   LD   E,A
;B9C7:   LD   A,L
;B9C8:   ADD  A,(IX+18)
;B9CB:   LD   L,A
;B9CC:   LD   A,H
;B9CD:   ADD  A,(IX+1C)
;B9D0:   CP   L
;B9D1:   JR   NC,@@101
;B9D3:   LD   A,L
;@@101   SUB  E
;B9D5:   LD   D,A
;B9D6:   LD   A,(IX+1B)
;B9D9:   CP   (IX+1F)
;B9DC:   JR   C,@@102
;B9DE:   LD   A,(IX+1F)
;@@102   LD   L,A
;B9E2:   LD   A,(IX+1B)
;B9E5:   ADD  A,(IX+19)
;B9E8:   LD   H,A
;B9E9:   LD   A,(IX+1F)
;B9EC:   ADD  A,(IX+1D)
;B9EF:   CP   H
;B9F0:   JR   NC,@@103
;B9F2:   LD   A,H
;@@103   SUB  L
;B9F4:   LD   H,A
;@@107   LD   A,(IY+00)
;B9F8:   AND  A
;B9F9:   JR   Z,@@104
;B9FB:   BIT  4,(IY+07)
;B9FF:   JR   NZ,@@104
;BA01:   LD   A,(IY+1A)
;BA04:   RRCA
;BA05:   RRCA
;BA06:   RRCA
;BA07:   AND  1F
;BA09:   SUB  E
;BA0A:   JR   C,@@105
;BA0C:   CP   D
;@@108   JR   NC,@@104
;BA0F:   LD   A,(IY+1B)
;BA12:   SUB  L
;BA13:   JR   C,@@106
;BA15:   CP   H
;@@109   JR   NC,@@104
;BA18:   SET  4,(IY+07)
;@@104   EXX
;BA1D:   LD   DE,0020
;BA20:   ADD  IY,DE
;BA22:   EXX
;BA23:   DJNZ @@107
;BA25:   RET

LB9A7   lda #<LA76F ; LD   IY,A76F
        sta z80_iy
        lda #>LA76F
        sta z80_iy+1
        jsr LB938 ; CALL LB938
        ;lda #$36 ; LD   B,36
        ;sta z80_b
        ldy #$1A ; LD   A,(IX+1A)
        lda (z80_ix),y
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        ;and #$1F ; AND  1F
        sta z80_l ; LD   L,A
        ldy #$1E ; LD   A,(IX+1E)
        lda (z80_ix),y
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        ;and #$1F ; AND  1F
        sta z80_h ; LD   H,A
        cmp z80_l ; CP   L
        jcc @@100 ; JR   C,@@100
        lda z80_l ; LD   A,L
@@100   sta z80_e ; LD   E,A
        lda z80_l ; LD   A,L
        ldy #$18 ; ADD  A,(IX+18)
        clc
        adc (z80_ix),y
        sta z80_l ; LD   L,A
        lda z80_h ; LD   A,H
        ldy #$1C ; ADD  A,(IX+1C)
        clc
        adc (z80_ix),y
        cmp z80_l ; CP   L
        jcs @@101 ; JR   NC,@@101
        lda z80_l ; LD   A,L
@@101   sec ; SUB  E
        sbc z80_e
        sta z80_d ; LD   D,A
        ldy #$1B ; LD   A,(IX+1B)
        lda (z80_ix),y
        ldy #$1F ; CP   (IX+1F)
        cmp (z80_ix),y
        jcc @@102 ; JR   C,@@102
        ldy #$1F ; LD   A,(IX+1F)
        lda (z80_ix),y
@@102   sta z80_l ; LD   L,A
        ldy #$1B ; LD   A,(IX+1B)
        lda (z80_ix),y
        ldy #$19 ; ADD  A,(IX+19)
        clc
        adc (z80_ix),y
        sta z80_h ; LD   H,A
        ldy #$1F ; LD   A,(IX+1F)
        lda (z80_ix),y
        ldy #$1D ; ADD  A,(IX+1D)
        clc
        adc (z80_ix),y
        cmp z80_h ; CP   H
        jcs @@103 ; JR   NC,@@103
        lda z80_h ; LD   A,H
@@103   sec ; SUB  L
        sbc z80_l
        sta z80_h ; LD   H,A
		ldx #$36
@@107   ldy #$00 ; LD   A,(IY+00)
@@107_2 lda (z80_iy),y
        ; AND  A: 
        jeq @@104_fast ; JR   Z,@@104
		tya
		beq @@107_3
		clc
		adc z80_iy
		sta z80_iy
		scc:inc z80_iy+1
@@107_3		
        ldy #$07 ; BIT  4,(IY+07)
        lda (z80_iy),y
        bit _bitmem4
        jne @@104 ; JR   NZ,@@104
        ldy #$1A ; LD   A,(IY+1A)
        lda (z80_iy),y
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        ;and #$1F ; AND  1F
        sec ; SUB  E
        sbc z80_e
        jcc @@105 ; JR   C,@@105
        cmp z80_d ; CP   D; 
@@108   jcs @@104 ; JR   NC,@@104
        ldy #$1B ; LD   A,(IY+1B)
        lda (z80_iy),y
        sec ; SUB  L
        sbc z80_l
        jcc @@106 ; JR   C,@@106
        cmp z80_h ; CP   H; 
@@109   jcs @@104 ; JR   NC,@@104
        ldy #$07 ; SET  4,(IY+07)
        lda (z80_iy),y
        ora #_bitvalue4
        sta (z80_iy),y
@@104   ;jsr exx ; EXX
        ;lda #<L0020 ; LD   DE,0020
        ;sta z80_e
        ;lda #>L0020
        ;sta z80_d
        ;jsr add_iy_de ; ADD  IY,DE
        ;jsr exx ; EXX
		
		; optimization
		lda #$20
		clc
		adc z80_iy
		sta z80_iy
		scc:inc z80_iy+1
		
        ;dec z80_b ; DJNZ @@107
		dex
        jne @@107
@@104_ret		
        rts ; RET

@@104_fast
		dex
		beq @@104_ret
		tya
		clc
		adc #$20
		tay
		bcc @@107_2
		inc z80_iy+1
		bne @@107_2
;@@105   NEG
;BA28:   CP   (IY+18)
;BA2B:   JR   @@108

@@105   eor #$ff ; NEG
        ;clc ; C=0 always here
        adc #$01; 
        ldy #$18 ; CP   (IY+18)
        cmp (z80_iy),y
        jmp @@108 ; JR   @@108

;@@106   NEG
;BA2F:   CP   (IY+19)
;BA32:   JR   @@109

@@106   eor #$ff ; NEG
        ;clc ; C=0 here
        adc #$01; 
        ldy #$19 ; CP   (IY+19)
        cmp (z80_iy),y
        jmp @@109 ; JR   @@109

;LBA34   LD   A,(LA720)
;BA37:   AND  A
;BA38:   RET  Z
;BA39:   XOR  A
;BA3A:   LD   (LA720),A
;LBA3D   PUSH IX
;BA3F:   LD   IX,SprInfoBuffer
;BA43:   LD   B,03
;BA45:   LD   HL,A726
;@@111   PUSH BC
;BA49:   PUSH HL
;BA4A:   LD   A,B
;BA4B:   NEG
;BA4D:   ADD  A,03
;BA4F:   SLA  A
;BA51:   SLA  A
;BA53:   SLA  A
;BA55:   LD   C,A
;BA56:   SLA  A
;BA58:   ADD  A,C
;BA59:   ADD  A,10
;BA5B:   LD   (IX+1A),A
;BA5E:   LD   (IX+1B),00
;BA62:   LD   C,(IX+1A)
;BA65:   LD   B,(IX+1B)
;BA68:   PUSH HL
;BA69:   CALL BCtoScrAdr
;BA6C:   LD   L,C
;BA6D:   LD   H,B
;BA6E:   LD   BC,0318
;BA71:   XOR  A
;BA72:   CALL LB6DD
;BA75:   POP  HL
;BA76:   LD   A,(HL)
;BA77:   AND  A
;BA78:   JR   Z,@@110
;BA7A:   LD   (IX+00),A
;BA7D:   CALL PrintSprite
;@@110   LD   C,(IX+1A)
;BA83:   LD   B,(IX+1B)
;BA86:   CALL BCtoAttrInDE
;BA89:   CALL BCtoScrAdr
;BA8C:   LD   L,C
;BA8D:   LD   H,B
;BA8E:   LD   BC,1803
;BA91:   CALL LB278
;BA94:   POP  HL
;BA95:   POP  BC
;BA96:   PUSH BC
;BA97:   PUSH HL
;BA98:   LD   A,(HL)
;BA99:   AND  07
;BA9B:   LD   E,A
;BA9C:   LD   D,00
;BA9E:   LD   HL,LBAC2
;BAA1:   ADD  HL,DE
;BAA2:   LD   C,(HL)
;BAA3:   LD   L,(IX+1A)
;BAA6:   LD   A,(IX+1B)
;BAA9:   ADD  A,17
;BAAB:   LD   H,A
;BAAC:   CALL LB3B6
;BAAF:   EX   DE,HL
;BAB0:   LD   A,C
;BAB1:   LD   BC,0303
;BAB4:   CALL LB6DD
;BAB7:   POP  HL
;BAB8:   POP  BC
;BAB9:   INC  HL
;BABA:   INC  HL
;BABB:   INC  HL
;BABC:   INC  HL
;BABD:   DJNZ @@111
;BABF:   POP  IX
;BAC1:   RET

LBA34   lda LA720 ; LD   A,(LA720)
        ; AND  A: 
        bne *+3 ; RET  Z
        rts
        lda #$00 ; XOR  A
        sta LA720 ; LD   (LA720),A
		
		lda #<sfxdrop      ;Start address of sound effect data
        ldy #>sfxdrop
        ldx #00             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e 		
		
LBA3D
	
		lda z80_ix ; PUSH IX
        pha
        lda z80_ix+1
        pha
        lda #<SprInfoBuffer ; LD   IX,SprInfoBuffer
        sta z80_ix
        lda #>SprInfoBuffer
        sta z80_ix+1
        lda #$03 ; LD   B,03
        sta z80_b
        lda #<LA726 ; LD   HL,A726
        sta z80_l
        lda #>LA726
        sta z80_h
@@111   lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda z80_b ; LD   A,B
        eor #$ff ; NEG
        clc
        adc #$01
        clc ; ADD  A,03
        adc #$03
        asl @ ; SLA  A
        asl @ ; SLA  A
        asl @ ; SLA  A
        sta z80_c ; LD   C,A
        asl @ ; SLA  A
        clc ; ADD  A,C
        adc z80_c
        clc ; ADD  A,10
        adc #$10
        ldy #$1A ; LD   (IX+1A),A
        sta (z80_ix),y
        ldy #$1B ; LD   (IX+1B),00
        lda #$00
        sta (z80_ix),y
        ldy #$1A ; LD   C,(IX+1A)
        lda (z80_ix),y
        sta z80_c
        ldy #$1B ; LD   B,(IX+1B)
        lda (z80_ix),y
        sta z80_b
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr BCtoScrAdr ; CALL BCtoScrAdr
        lda z80_c ; LD   L,C
        sta z80_l
        lda z80_b ; LD   H,B
        sta z80_h
        lda #<L0318 ; LD   BC,0318
        sta z80_c
        lda #>L0318
        sta z80_b
        lda #$00 ; XOR  A
        jsr LB6DD ; CALL LB6DD
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ; AND  A
        jeq @@110 ; JR   Z,@@110
        ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y; 
        jsr PrintSprite ; CALL PrintSprite
@@110   ldy #$1A ; LD   C,(IX+1A)
        lda (z80_ix),y
        sta z80_c
        ldy #$1B ; LD   B,(IX+1B)
        lda (z80_ix),y
        sta z80_b
        jsr BCtoAttrInDE ; CALL BCtoAttrInDE
        jsr BCtoScrAdr ; CALL BCtoScrAdr
        lda z80_c ; LD   L,C
        sta z80_l
        lda z80_b ; LD   H,B
        sta z80_h
        lda #<L1803 ; LD   BC,1803
        sta z80_c
        lda #>L1803
        sta z80_b
        jsr LB278 ; CALL LB278
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        and #$07 ; AND  07
        sta z80_e ; LD   E,A
        lda #$00 ; LD   D,00
        sta z80_d
				
		;read in colours for items picked up
        lda #<LBAC2 ; LD   HL,LBAC2
        sta z80_l
        lda #>LBAC2
        sta z80_h
        jsr add_hl_de ; ADD  HL,DE
        
		ldy #$00 ; LD   C,(HL)
        lda (z80_hl),y
        sta z80_c
        ldy #$1A ; LD   L,(IX+1A)
        lda (z80_ix),y
        sta z80_l
        ldy #$1B ; LD   A,(IX+1B)
        lda (z80_ix),y
        clc ; ADD  A,17
        adc #$17
        sta z80_h ; LD   H,A

		jsr LB3B6_2 ; CALL LB3B6
		
		;lda #$00
		;sta z80_e
		;lda #$f8
		;sta z80_d
		
		
        jsr ex_de_hl ; EX   DE,HL
        lda z80_c ; LD   A,C
        ldx #<L0303 ; LD   BC,0303
        stx z80_c
        ldx #>L0303
        stx z80_b
		
        jsr LB6DD ; CALL LB6DD
        
		pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        dec z80_b ; DJNZ @@111
        jne @@111
        pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix

		;copy new colours for pickup items only into colour ram
		jsr c64colourspickup
		
        rts ; RET

;LBAC2   DB 41,42,43,44,45,46,47,47

;LBAC2   .he 41,42,43,44,45,46,47,47 ; DB 41,42,43,44,45,46,47,47

; hack in c64 colours for items picked-up
LBAC2    dta $02,$08,$0a,$04,$07,$0d,$0f,$0f


;SprInfoBuffer: ; BACA
;BACA:   DB 02,00,00,00,00,00,00,40,00,00,00,00,00,00,00,00
;BADA:   DB 00,00,00,00,00,00,00,00,03,18,E8,A8,00,00,00,00

SprInfoBuffer: ; BACA
        .he 02,00,00,00,00,00,00,40,00,00,00,00,00,00,00,00 ; DB 02,00,00,00,00,00,00,40,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,03,18,E8,A8,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,03,18,E8,A8,00,00,00,00

;Print8x8: ; BAEA
;BAEA:   PUSH BC
;BAEB:   PUSH DE
;BAEC:   PUSH HL
;BAED:   CP   20
;BAEF:   JR   NZ,@@112
;BAF1:   LD   A,3D
;@@112   LD   L,A
;BAF4:   LD   H,00
;BAF6:   ADD  HL,HL
;BAF7:   ADD  HL,HL
;BAF8:   ADD  HL,HL
;BAF9:   LD   DE,(LA732)
;BAFD:   ADD  HL,DE
;BAFE:   EX   DE,HL
;BAFF:   POP  HL
;BB00:   LD   B,08
;@@113   LD   A,(DE)
;BB03:   LD   (HL),A
;BB04:   INC  DE
;BB05:   PUSH BC
;BB06:   LD   BC,FFE0
;BB09:   ADD  HL,BC
;BB0A:   POP  BC
;BB0B:   DJNZ @@113
;BB0D:   POP  DE
;BB0E:   LD   BC,0101
;BB11:   ADD  HL,BC
;BB12:   POP  BC
;BB13:   RET

Print8x8: ; BAEA
		tax
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
		txa
        cmp #$20 ; CP   20
        jne @@112 ; JR   NZ,@@112
        lda #$3D ; LD   A,3D
@@112   sta z80_l ; LD   L,A
        lda #$00 ; LD   H,00
        sta z80_h
        asl z80_l ; ADD  HL,HL
        rol z80_h
        asl z80_l ; ADD  HL,HL
        rol z80_h
        asl z80_l ; ADD  HL,HL
        rol z80_h
        lda LA732 ; LD   DE,(LA732)
        sta z80_e
        lda LA732+1
        sta z80_d
        jsr add_hl_de ; ADD  HL,DE
        jsr ex_de_hl ; EX   DE,HL
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        lda #$08 ; LD   B,08
        sta z80_b
@@113   ldy #$00 ; LD   A,(DE)
        lda (z80_de),y
        ldy #$00 ; LD   (HL),A
        sta (z80_hl),y
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda #<LFFE0 ; LD   BC,FFE0
        sta z80_c
        lda #>LFFE0
        sta z80_b
        jsr add_hl_bc ; ADD  HL,BC
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        dec z80_b ; DJNZ @@113
        jne @@113
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        lda #<L0101 ; LD   BC,0101
        sta z80_c
        lda #>L0101
        sta z80_b
        jsr add_hl_bc ; ADD  HL,BC
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        rts ; RET

;PrintScore: ; BB14
;BB14:   LD   HL,1FC0
;BB17:   LD   A,47
;BB19:   LD   (LA736),A
;BB1C:   LD   DE,ScoreTXT
;BB1F:   CALL PrintTextInColor?
;BB22:   JR   PrintScoreNumber

PrintScore: ; BB14
        lda #<L1FC0 ; LD   HL,1FC0
        sta z80_l
        lda #>L1FC0
        sta z80_h
		
        lda #$0f ; LD   A,47
        sta LA736 ; LD   (LA736),A
        
		lda #<ScoreTXT ; LD   DE,ScoreTXT
        sta z80_e
        lda #>ScoreTXT
        sta z80_d
        jsr PrintTextInColor? ; CALL PrintTextInColor?
        jmp PrintScoreNumber ; JR   PrintScoreNumber

;ScoreTXT: ; BB24
;BB24:   DB 53,43,4F,52,C5
;LBB29   LD   HL,A746
;BB2C:   LD   A,(HL)
;BB2D:   ADD  A,C
;BB2E:   DAA
;BB2F:   LD   (HL),A
;BB30:   DEC  HL
;BB31:   LD   A,(HL)
;BB32:   ADC  A,B
;BB33:   DAA
;BB34:   LD   (HL),A
;BB35:   DEC  HL
;BB36:   LD   A,(HL)
;BB37:   ADC  A,00
;BB39:   DAA
;BB3A:   LD   (HL),A

ScoreTXT: ; BB24
        .he 53,43,4F,52,C5 ; DB 53,43,4F,52,C5
LBB29   lda #<LA746 ; LD   HL,A746
        sta z80_l
        lda #>LA746
        sta z80_h
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
		sed
        clc ; ADD  A,C
        adc z80_c
        ; DAA
        ldy #$00 ; LD   (HL),A
        sta (z80_hl),y
        jsr dec_hl ; DEC  HL
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        adc z80_b ; ADC  A,B
        ; DAA
        ldy #$00 ; LD   (HL),A
        sta (z80_hl),y
        jsr dec_hl ; DEC  HL
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        adc #$00 ; ADC  A,00
        ; DAA
		cld
        ldy #$00 ; LD   (HL),A
        sta (z80_hl),y

;PrintScoreNumber: ; BB3B
;BB3B:   LD   BC,10B8
;BB3E:   CALL BCtoScrAdr
;BB41:   LD   L,C
;BB42:   LD   H,B
;BB43:   LD   DE,A744
;BB46:   LD   B,03

PrintScoreNumber: ; BB3B
        lda #<L10B8 ; LD   BC,10B8
        sta z80_c
        lda #>L10B8
        sta z80_b
        jsr BCtoScrAdr ; CALL BCtoScrAdr
        lda z80_c ; LD   L,C
        sta z80_l
        lda z80_b ; LD   H,B
        sta z80_h
        lda #<LA744 ; LD   DE,A744
        sta z80_e
        lda #>LA744
        sta z80_d
        lda #$03 ; LD   B,03
        sta z80_b

;PrintNumber: ; BB48
;BB48:   PUSH HL
;BB49:   LD   HL,Font
;BB4C:   LD   (LA732),HL
;BB4F:   POP  HL
;BB50:   LD   A,(DE)
;BB51:   RRCA
;BB52:   RRCA
;BB53:   RRCA
;BB54:   RRCA
;BB55:   AND  0F
;BB57:   CALL Print8x8
;LBB5A   LD   A,(DE)
;BB5B:   AND  0F
;BB5D:   CALL Print8x8
;BB60:   INC  DE
;BB61:   DJNZ PrintNumber
;BB63:   RET

PrintNumber: ; BB48
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda #<Font ; LD   HL,Font
        sta z80_l
        lda #>Font
        sta z80_h
        lda z80_l ; LD   (LA732),HL
        sta LA732
        lda z80_h
        sta LA732+1
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        ldy #$00 ; LD   A,(DE)
        lda (z80_de),y
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$0F ; AND  0F
        jsr Print8x8 ; CALL Print8x8
LBB5A   ldy #$00 ; LD   A,(DE)
        lda (z80_de),y
        and #$0F ; AND  0F
        jsr Print8x8 ; CALL Print8x8
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
        dec z80_b ; DJNZ PrintNumber
        jne PrintNumber
        rts ; RET

;ToggleSelected: ; BB64
;BB64:   AND  A
;BB65:   JR   NZ,@@114
;@@116   SET  7,(HL)
;BB69:   JR   @@115

ToggleSelected: ; BB64
        ; AND  A
        jne @@114 ; JR   NZ,@@114
@@116   ldy #$00 ; SET  7,(HL)
        lda (z80_hl),y
        ora #_bitvalue7
        sta (z80_hl),y
        jmp @@115 ; JR   @@115

;LBB6B   DEC  A
;BB6C:   JR   Z,@@116
;@@114   RES  7,(HL)
;@@115   INC  HL
;BB71:   DJNZ LBB6B
;BB73:   RET

LBB6B   sec ; DEC  A
        sbc #$01; 
        jeq @@116 ; JR   Z,@@116
@@114   tax
		ldy #$00 ; RES  7,(HL)
        lda (z80_hl),y
        and #_notbitvalue7
        sta (z80_hl),y
		txa
@@115   inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        dec z80_b ; DJNZ LBB6B
        jne LBB6B
        rts ; RET

;DoMenuSelection: ; BB74
;BB74:   XOR  A
;BB75:   LD   (LA734),A
;BB78:   LD   HL,LBBF1
;BB7B:   LD   B,08
;@@117   RES  7,(HL)
;BB7F:   INC  HL
;BB80:   DJNZ @@117
;BB82:   CALL ClrWrkScr
;BB85:   CALL DisplayMenu
;BB88:   CALL LBBD8
;LBB8B   CALL DisplayMenu
;BB8E:   LD   DE,Audio1
;BB91:   CALL PlayAudioWaitKey
;BB94:   LD   A,F7
;BB96:   CALL ReadKey
;BB99:   LD   E,A
;BB9A:   LD   A,(LA709)
;BB9D:   LD   (LA70C),A
;BBA0:   BIT  0,E
;BBA2:   JR   Z,@@118
;BBA4:   AND  F9
;@@118   BIT  1,E
;BBA8:   JR   Z,@@119
;BBAA:   AND  F9
;BBAC:   OR   02
;@@119   BIT  2,E
;BBB0:   JR   Z,@@120
;BBB2:   AND  F9
;BBB4:   OR   04
;@@120   BIT  3,E
;BBB8:   JR   Z,@@121
;BBBA:   OR   06
;@@121   LD   (LA709),A
;BBBF:   LD   HL,A735
;BBC2:   LD   HL,LA70C
;BBC5:   CP   (HL)
;BBC6:   LD   A,EF
;BBC8:   CALL ReadKey
;BBCB:   BIT  0,A
;BBCD:   RET  NZ
;BBCE:   LD   HL,A70A
;BBD1:   INC  (HL)
;BBD2:   CALL LBBD8
;BBD5:   JP   LBB8B

DoMenuSelection: ; BB74
;        lda #$00 ; XOR  A
;        sta LA734 ; LD   (LA734),A
;        lda #<LBBF1 ; LD   HL,LBBF1
;        sta z80_l
;        lda #>LBBF1
;        sta z80_h
;        lda #$08 ; LD   B,08
;        sta z80_b
;@@117   ldy #$00 ; RES  7,(HL)
;        lda (z80_hl),y
;        and #_notbitvalue7
;        sta (z80_hl),y
;        inc z80_l ; INC  HL
;        bne *+4
;        inc z80_h
;        dec z80_b ; DJNZ @@117
;        jne @@117
        jsr ClrWrkScr ; CALL ClrWrkScr				
        ;jsr DisplayMenu ; CALL DisplayMenu
	
		
        jsr LBBD8 ; CALL LBBD8 Flash menu
		        		
LBB8B	jsr DisplayMenu ; CALL DisplayMenu

		jsr c64WaitFrame

		lda #00
		sta sound_e
		
		jsr c64WaitFrame
		
		lda #00 ;song number
        jsr music_on

LBB8B_1 ;lda #<Audio1 ; LD   DE,Audio1
        ;sta z80_e
        ;lda #>Audio1
        ;sta z80_d
        ;jsr PlayAudioWaitKey ; CALL PlayAudioWaitKey
;        lda #$F7 ; LD   A,F7
;        jsr ReadKey ; CALL ReadKey
;        sta z80_e ; LD   E,A; 
;        lda LA709 ; LD   A,(LA709)		user_input_method
;        sta LA70C ; LD   (LA70C),A		tmp_input_method
;        lsr z80_e ; BIT  0,E
;        jcc @@118 ; JR   Z,@@118
;        and #$F9 ; AND  F9
;@@118   lsr z80_e ; BIT  1,E
;        jcc @@119 ; JR   Z,@@119
;        and #$F9 ; AND  F9
;        ora #$02 ; OR   02
;@@119   lsr z80_e ; BIT  2,E
;        jcc @@120 ; JR   Z,@@120
;        and #$F9 ; AND  F9
;        ora #$04 ; OR   04
;@@120   lsr z80_e ; BIT  3,E
;        jcc @@121 ; JR   Z,@@121
;        ora #$06 ; OR   06
;@@121   sta LA709 ; LD   (LA709),A
;		tax
;        lda #<LA735 ; LD   HL,A735
;        sta z80_l
;        lda #>LA735
;        sta z80_h
;        lda #<LA70C ; LD   HL,LA70C
;        sta z80_l
;        lda #>LA70C
;        sta z80_h
;	 	txa
;        ldy #$00 ; CP   (HL)
;        cmp (z80_hl),y; 
;        lda #$EF ; LD   A,EF
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem0 ; BIT  0,A
;        beq *+3 ; RET  NZ
;        rts
;        lda #<LA70A ; LD   HL,A70A
;        sta z80_l
;        lda #>LA70A
;        sta z80_h
;        ldy #$00 ; INC  (HL)
;        lda (z80_hl),y
;        clc
;        adc #$01
;        sta (z80_hl),y
        
		
		jsr LBBD8 ; CALL LBBD8		;flash menu
		jsr c64menukeys
		jsr c64waitframe
		
		
		; check if zero pressed and get out of loop and start game if it is.
		lda gamestartf
		cmp #01
		beq outhere
        
		jmp LBB8B_1 ; JP   LBB8B ; jump back to menu loop (without re-drawing screen!)

outhere
		;reset game start flag
		lda #0
		sta gamestartf
		
		;put text colours back to green
flashkb02
		
		lda LA709
		cmp #02
		beq flashkb04
	
        lda #<$20c6
        sta dest_lo
        lda #>$20c6
        sta dest_hi

		lda #$05
		sta colourcode
		
		jsr vdc_flasher

        lda #<$2106
        sta dest_lo
        lda #>$2106
        sta dest_hi
		
		jsr vdc_flasher
		
		jmp flashkb06

flashkb04		
        lda #<$2146
        sta dest_lo
        lda #>$2146
        sta dest_hi

		lda #$05
		sta colourcode
		
		jsr vdc_flasher

        lda #<$2186
        sta dest_lo
        lda #>$2186
        sta dest_hi
		
		jsr vdc_flasher
		
flashkb06		
		;start game
		
		lda #04 ;song number 4 empty song no to kill sound
        jsr music_on

		
		rts
		
;LBBD8   LD   HL,LBBF2
;BBDB:   LD   A,(LA709)
;BBDE:   RRCA
;BBDF:   AND  03
;BBE1:   LD   B,04
;BBE3:   CALL ToggleSelected
;BBE6:   RES  7,(HL)
;BBE8:   LD   A,(LA709)
;BBEB:   AND  08
;BBED:   RET  Z
;BBEE:   SET  7,(HL)
;BBF0:   RET

LBBD8
		lda #17
		cmp colourcounter
		bcc flashaa

		jmp flashbb
		
flashaa
		lda #00
		sta colourcounter

flashbb		

		; flash text on main menu
		lda LA709
		beq flashkb
		cmp #02
		beq flashjoy	

; flash keyboard selected text		
flashkb		

        lda #<$20c6
        sta dest_lo
        lda #>$20c6
        sta dest_hi

		ldx colourcounter
		lda ColourFlasher,x
		sta colourcode
		
		jsr vdc_flasher

        lda #<$2106
        sta dest_lo
        lda #>$2106
        sta dest_hi
		
		jsr vdc_flasher

        lda #<$2146
        sta dest_lo
        lda #>$2146
        sta dest_hi

		lda #$04
		sta colourcode
		
		jsr vdc_flasher

        lda #<$2186
        sta dest_lo
        lda #>$2186
        sta dest_hi
		
		jsr vdc_flasher
		
		inc colourcounter
		
;		lda colourcounter
;		tax 
;		
;		lda ColourFlasher,x
;		sta c64flashtx
;
;		inc colourcounter
;		
;		ldy#0
;flashkb01
;		lda c64flashtx
;		sta $d8FA,y
;		sta $d94A,y
;		lda #$05
;		sta $d99A,y
;		sta $d9EA,y
;		iny
;		cpy #20
;		bne flashkb01

		rts
		
; flash joystick selected text
flashjoy

        lda #<$2146
        sta dest_lo
        lda #>$2146
        sta dest_hi

		ldx colourcounter
		lda ColourFlasher,x
		sta colourcode
		
		jsr vdc_flasher

        lda #<$2186
        sta dest_lo
        lda #>$2186
        sta dest_hi
		
		jsr vdc_flasher

        lda #<$20c6
        sta dest_lo
        lda #>$20c6
        sta dest_hi

		lda #$04
		sta colourcode
		
		jsr vdc_flasher

        lda #<$2106
        sta dest_lo
        lda #>$2106
        sta dest_hi
		
		jsr vdc_flasher

		
		inc colourcounter

;		lda colourcounter
;		tax 
;		
;		lda ColourFlasher,x
;		sta c64flashtx
;
;		inc colourcounter
;		
;		ldy#0
;flashjoy01
;		lda c64flashtx
;		sta $d99A,y
;		sta $d9EA,y
;		lda #$05
;		sta $d8FA,y
;		sta $d94A,y
;		iny
;		cpy #20
;		bne flashjoy01		

		rts


   
		;lda #<LBBF2 ; LD   HL,LBBF2
        ;sta z80_l
        ;lda #>LBBF2
        ;sta z80_h
        ;lda #$04 ; LD   B,04
        ;sta z80_b		
        ;lda LA709 ; LD   A,(LA709)
        ;lsr @ ; RRCA
        ;and #$03 ; AND  03
        ;jsr ToggleSelected ; CALL ToggleSelected
        ;ldy #$00 ; RES  7,(HL)
        ;lda (z80_hl),y
        ;and #_notbitvalue7
        ;sta (z80_hl),y
        ;lda LA709 ; LD   A,(LA709)
        ;and #$08 ; AND  08
        ;bne *+3 ; RET  Z
        ;rts
        ;ldy #$00 ; SET  7,(HL)
        ;lda (z80_hl),y
        ;ora #_bitvalue7
        ;sta (z80_hl),y
        ;rts ; RET

;LBBF1   DB 43

LBBF1   .he 0a ; DB 43

;LBBF2   DB C4,44,44,44,47,47

LBBF2   .he 04,04,04,04,0f,0f ; DB C4,44,44,44,47,47

;LBBF8   DB 58,9F,30,8F,30,7F,30,6F,30,5F,30,3F,50,27

LBBF8   .he 58,9F,30,8F,30,7F,30,6F,30,5F,30,3F,50,27 ; DB 58,9F,30,8F,30,7F,30,6F,30,5F,30,3F,50,27

;MainMenuText: ; BC06
;BC06:   DB 50,45,4E,54,41,47,52,41,CD,31,20,4B,45,59,42,4F
;BC16:   DB 41,52,C4,32,20,4B,45,4D,50,53,54,4F,4E,20,4A,4F
;BC26:   DB 59,53,54,49,43,CB,33,20,43,55,52,53,4F,52,20,20
;BC36:   DB 20,4A,4F,59,53,54,49,43,CB,34,20,49,4E,54,45,52
;BC46:   DB 46,41,43,45,20,49,C9,30,20,53,54,41,52,54,20,47
;BC56:   DB 41,4D,C5,3C,20,31,39,38,36,20,41,3A,43,3A,47,BA

MainMenuText: ; BC06
        .he 50,45,4E,54,41,47,52,41,CD
		.he	31,20,4B,45,59,42,4F,41,52,C4
		;.he 4B,45,59,53,20,51,41,4F,50,20,4D,20,53,50,41,43,C5
		.he	4B,45,59,53,20,51,41,4F,50,20,53,50,41,43,45,20,CD
		.he	32,20,4A,4F,59,53,54,49,43,4B,20,50,4F,52,54,20,B2
		.he	50,4C,55,53,20,53,50,41,43,45,20,4F,52,20,46,49,52,45,20,B2
		.he	30,20,4F,52,20,46,49,52,45,20,54,4F,20,53,54,41,52,D4
		.he	3C,20,31,39,38,36,20,41,3A,43,3A,47,BA
		
		
		
;MainMenuText: ; BC06
;        .he 50,45,4E,54,41,47,52,41,CD,20,20,20,20,20,20,20 ; DB 50,45,4E,54,41,47,52,41,CD,31,20,4B,45,59,42,4F
;        .he 20,20,A0,31,20,4B,45,59,42,4F,41,52,44,20,20,20 ; DB 41,52,C4,32,20,4B,45,4D,50,53,54,4F,4E,20,4A,4F
;        .he 20,20,20,20,20,A0,32,20,4A,4F,59,53,54,49,43,4B ; DB 59,53,54,49,43,CB,33,20,43,55,52,53,4F,52,20,20
;        .he 20,50,4F,52,54,20,32,20,A0,20,20,20,20,20,20,20 ; DB 20,4A,4F,59,53,54,49,43,CB,34,20,49,4E,54,45,52
;        .he 20,20,20,20,20,20,A0,30,20,53,54,41,52,54,20,47 ; DB 46,41,43,45,20,49,C9,30,20,53,54,41,52,54,20,47
;        .he 41,4D,C5,3C,20,31,39,38,36,20,41,3A,43,3A,47,BA ; DB 41,4D,C5,3C,20,31,39,38,36,20,41,3A,43,3A,47,BA		
		
;MainMenuText: ; BC06
;        .he 50,45,4E,54,41,47,52,41,CD,31,20,4B,45,59,42,4F ; DB 50,45,4E,54,41,47,52,41,CD,31,20,4B,45,59,42,4F
;        .he 41,52,C4,32,20,4B,45,4D,50,53,54,4F,4E,20,4A,4F ; DB 41,52,C4,32,20,4B,45,4D,50,53,54,4F,4E,20,4A,4F
;        .he 59,53,54,49,43,CB,33,20,43,55,52,53,4F,52,20,20 ; DB 59,53,54,49,43,CB,33,20,43,55,52,53,4F,52,20,20
;        .he 20,4A,4F,59,53,54,49,43,CB,34,20,49,4E,54,45,52 ; DB 20,4A,4F,59,53,54,49,43,CB,34,20,49,4E,54,45,52
;        .he 46,41,43,45,20,49,C9,30,20,53,54,41,52,54,20,47 ; DB 46,41,43,45,20,49,C9,30,20,53,54,41,52,54,20,47
;        .he 41,4D,C5,3C,20,31,39,38,36,20,41,3A,43,3A,47,BA ; DB 41,4D,C5,3C,20,31,39,38,36,20,41,3A,43,3A,47,BA

		
		
;PrintTextInColor?: ; BC66
;BC66:   PUSH HL
;BC67:   LD   HL,L81D5
;BC6A:   LD   (LA732),HL
;BC6D:   POP  BC
;BC6E:   PUSH BC
;BC6F:   CALL BCtoScrAdr
;BC72:   LD   L,C
;BC73:   LD   H,B
;BC74:   LD   A,(LA736)
;BC77:   EX   AF,AF'
;BC78:   JR   @@122

PrintTextInColor?: ; BC66
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda #<L81D5 ; LD   HL,L81D5
        sta z80_l
        lda #>L81D5
        sta z80_h
        lda z80_l ; LD   (LA732),HL
        sta LA732
        lda z80_h
        sta LA732+1
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        jsr BCtoScrAdr ; CALL BCtoScrAdr
        lda z80_c ; LD   L,C
        sta z80_l
        lda z80_b ; LD   H,B
        sta z80_h
        lda LA736 ; LD   A,(LA736)
        ldx z80_ap ; EX   AF,AF'
        sta z80_ap
        txa ; 
        jmp @@122 ; JR   @@122

;PrintText: ; BC7A
;BC7A:   PUSH HL
;BC7B:   LD   HL,L81D5
;BC7E:   LD   (LA732),HL
;BC81:   POP  BC
;BC82:   PUSH BC
;BC83:   CALL BCtoScrAdr
;BC86:   LD   L,C
;BC87:   LD   H,B
;BC88:   LD   A,(DE)
;BC89:   EX   AF,AF'
;BC8A:   INC  DE
;@@122   EXX
;BC8C:   POP  HL
;BC8D:   PUSH DE
;BC8E:   CALL LB3B6
;BC91:   LD   L,E
;BC92:   LD   H,D
;BC93:   POP  DE
;@@124   EXX
;BC95:   LD   A,(DE)
;BC96:   BIT  7,A
;BC98:   JR   NZ,@@123
;BC9A:   PUSH DE
;BC9B:   CALL Print8x8
;BC9E:   POP  DE
;BC9F:   INC  DE
;BCA0:   EXX
;BCA1:   EX   AF,AF'
;BCA2:   LD   (HL),A
;BCA3:   INC  L
;BCA4:   EX   AF,AF'
;BCA5:   JR   @@124

PrintText: ; BC7A
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda #<L81D5 ; LD   HL,L81D5
        sta z80_l
        lda #>L81D5
        sta z80_h
        lda z80_l ; LD   (LA732),HL
        sta LA732
        lda z80_h
        sta LA732+1
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        jsr BCtoScrAdr ; CALL BCtoScrAdr
        lda z80_c ; LD   L,C
        sta z80_l
        lda z80_b ; LD   H,B
        sta z80_h
        ldy #$00 ; LD   A,(DE)
        lda (z80_de),y
        ldx z80_ap ; EX   AF,AF'
        sta z80_ap
        txa ; 
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
@@122   jsr exx ; EXX
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
		;inc $d020
        jsr LB3B6 ; CALL LB3B6
        lda z80_e ; LD   L,E
        sta z80_l
        lda z80_d ; LD   H,D
        sta z80_h
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
@@124   jsr exx ; EXX
        ldy #$00 ; LD   A,(DE)
        lda (z80_de),y
        bit _bitmem7 ; BIT  7,A
        jne @@123 ; JR   NZ,@@123
		tax
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
		txa
        jsr Print8x8 ; CALL Print8x8
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
        jsr exx ; EXX
        ldx z80_ap ; EX   AF,AF'
        sta z80_ap
        txa

;		sta colourcode
		
        ldy #$00 ; LD   (HL),A
		
        sta (z80_hl),y ;<-************************
     		
;		lda z80_h
;		ldx #18
;		jsr vdcwrite
;		lda z80_l
;		inx
;		;STA $D07A
;		stx $d600		
;		sta $d601
;		;STA $D07B
;		lda colourcode
;		ldx #31		 
;		jsr vdcwrite		
;
;		ldx #31		 
;		jsr vdcwrite
		
		inc z80_l ; INC  L
        ldx z80_ap ; EX   AF,AF'
        sta z80_ap
        txa 
        jmp @@124 ; JR   @@124

;@@123   AND  7F
;BCA9:   PUSH DE
;BCAA:   CALL Print8x8
;BCAD:   POP  DE
;BCAE:   INC  DE
;BCAF:   EXX
;BCB0:   EX   AF,AF'
;BCB1:   LD   (HL),A
;BCB2:   EXX
;BCB3:   RET

@@123   and #$7F ; AND  7F
		tax
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
		txa
        jsr Print8x8 ; CALL Print8x8
		tay
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
        jsr exx ; EXX
		tya		; note: y destroyed by exx
        ldx z80_ap ; EX   AF,AF'
        sta z80_ap
        txa 
        ldy #$00 ; LD   (HL),A
        sta (z80_hl),y
        jsr exx ; EXX
        rts ; RET

;DisplayMenu: ; BCB4
;BCB4:   LD   DE,LBBF1
;BCB7:   EXX
;BCB8:   LD   HL,LBBF8
;BCBB:   LD   DE,MainMenuText
;BCBE:   LD   B,07
;@@125   EXX
;BCC1:   LD   A,(DE)
;BCC2:   LD   (LA736),A
;BCC5:   INC  DE
;BCC6:   EXX
;BCC7:   PUSH BC
;BCC8:   LD   A,(HL)
;BCC9:   INC  HL
;BCCA:   INC  HL
;BCCB:   PUSH HL
;BCCC:   DEC  HL
;BCCD:   LD   H,(HL)
;BCCE:   LD   L,A
;BCCF:   CALL PrintTextInColor?
;BCD2:   POP  HL
;BCD3:   POP  BC
;BCD4:   DJNZ @@125
;BCD6:   LD   A,(LA734)
;BCD9:   AND  A
;BCDA:   RET  NZ
;BCDB:   INC  A
;BCDC:   LD   (LA734),A
;BCDF:   CALL PrintBorder
;BCE2:   JP   UpdateScreen

DisplayMenu: ; BCB4
        lda #<LBBF1 ; LD   DE,LBBF1
        sta z80_e
        lda #>LBBF1
        sta z80_d
        jsr exx ; EXX
        lda #<LBBF8 ; LD   HL,LBBF8
        sta z80_l
        lda #>LBBF8
        sta z80_h
        lda #<MainMenuText ; LD   DE,MainMenuText
        sta z80_e
        lda #>MainMenuText
        sta z80_d
        lda #$07 ; LD   B,07
        sta z80_b
@@125   jsr exx ; EXX
        ldy #$00 ; LD   A,(DE)
        lda (z80_de),y
        sta LA736 ; LD   (LA736),A
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
        jsr exx ; EXX
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
		tax
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr dec_hl ; DEC  HL
        ldy #$00 ; LD   H,(HL)
        lda (z80_hl),y
        sta z80_h
		txa
        sta z80_l ; LD   L,A
        jsr PrintTextInColor? ; CALL PrintTextInColor?
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        dec z80_b ; DJNZ @@125
        jne @@125
        lda LA734 ; LD   A,(LA734)
        ; AND  A: 
        beq *+3 ; RET  NZ
        rts
        clc ; INC  A
        adc #$01; 
        sta LA734 ; LD   (LA734),A
        jsr PrintBorder ; CALL PrintBorder
		;jsr c64clearcols
        jmp UpdateScreen ; JP   UpdateScreen

;PrintPanel: ; BCE5
;BCE5:   LD   IX,SprInfoBuffer
;BCE9:   LD   HL,PanelData
;BCEC:   CALL TransferSpr
;BCEF:   LD   DE,F810
;BCF2:   LD   B,05
;BCF4:   CALL MultPrintSpr
;BCF7:   CALL TransferSpr
;BCFA:   LD   DE,F8F0
;BCFD:   LD   B,05
;BCFF:   CALL MultPrintSpr
;BD02:   CALL TransferSpr
;BD05:   LD   DE,2000
;BD08:   LD   B,02
;BD0A:   CALL MultPrintSpr
;BD0D:   CALL TransferSpr
;BD10:   LD   B,02
;BD12:   CALL MultPrintSpr
;BD15:   CALL TransferSpr
;BD18:   LD   B,02
;BD1A:   CALL MultPrintSpr
;BD1D:   CALL TransferSpr
;BD20:   LD   B,02
;BD22:   CALL MultPrintSpr
;BD25:   CALL TransAndPrintSpr
;BD28:   CALL TransAndPrintSpr
;BD2B:   CALL TransAndPrintSpr
;BD2E:   JP   TransAndPrintSpr

PrintPanel: ; BCE5
        lda #<SprInfoBuffer ; LD   IX,SprInfoBuffer
        sta z80_ix
        lda #>SprInfoBuffer
        sta z80_ix+1
        lda #<PanelData ; LD   HL,PanelData
        sta z80_l
        lda #>PanelData
        sta z80_h
        jsr TransferSpr ; CALL TransferSpr
        lda #<LF810 ; LD   DE,F810
        sta z80_e
        lda #>LF810
        sta z80_d
        lda #$05 ; LD   B,05
        sta z80_b
        jsr MultPrintSpr ; CALL MultPrintSpr
        jsr TransferSpr ; CALL TransferSpr
        lda #<LF8F0 ; LD   DE,F8F0
        sta z80_e
        lda #>LF8F0
        sta z80_d
        lda #$05 ; LD   B,05
        sta z80_b
        jsr MultPrintSpr ; CALL MultPrintSpr
        jsr TransferSpr ; CALL TransferSpr
        lda #<L2000 ; LD   DE,2000
        sta z80_e
        lda #>L2000
        sta z80_d
        lda #$02 ; LD   B,02
        sta z80_b
        jsr MultPrintSpr ; CALL MultPrintSpr
        jsr TransferSpr ; CALL TransferSpr
        lda #$02 ; LD   B,02
        sta z80_b
        jsr MultPrintSpr ; CALL MultPrintSpr
        jsr TransferSpr ; CALL TransferSpr
        lda #$02 ; LD   B,02
        sta z80_b
        jsr MultPrintSpr ; CALL MultPrintSpr
        jsr TransferSpr ; CALL TransferSpr
        lda #$02 ; LD   B,02
        sta z80_b
        jsr MultPrintSpr ; CALL MultPrintSpr
        jsr TransAndPrintSpr ; CALL TransAndPrintSpr
        jsr TransAndPrintSpr ; CALL TransAndPrintSpr
        jsr TransAndPrintSpr ; CALL TransAndPrintSpr
        jmp TransAndPrintSpr ; JP   TransAndPrintSpr

;PanelData: ; BD31
;BD31:   DB 3E,40,10,34,3E,00,E0,34,3D,40,00,04,3D,00,F0,04
;BD41:   DB 3C,40,00,14,3C,00,F0,14,3A,40,60,04,3A,00,90,04
;BD51:   DB 3B,40,00,34,3B,00,F0,34

PanelData: ; BD31
        .he 3E,40,10,34,3E,00,E0,34,3D,40,00,04,3D,00,F0,04 ; DB 3E,40,10,34,3E,00,E0,34,3D,40,00,04,3D,00,F0,04
        .he 3C,40,00,14,3C,00,F0,14,3A,40,60,04,3A,00,90,04 ; DB 3C,40,00,14,3C,00,F0,14,3A,40,60,04,3A,00,90,04
        .he 3B,40,00,34,3B,00,F0,34 ; DB 3B,40,00,34,3B,00,F0,34

;PrintBorder: ; BD59
;BD59:   LD   IX,SprInfoBuffer
;BD5D:   LD   HL,BorderData
;BD60:   CALL TransAndPrintSpr
;BD63:   CALL TransAndPrintSpr
;BD66:   CALL TransAndPrintSpr
;BD69:   CALL TransAndPrintSpr
;BD6C:   CALL TransferSpr
;BD6F:   LD   DE,0018
;BD72:   LD   B,08
;BD74:   CALL MultPrintSpr
;BD77:   CALL TransferSpr
;BD7A:   LD   B,08
;BD7C:   CALL MultPrintSpr
;BD7F:   CALL TransAndPrintSpr
;BD82:   CALL TransAndPrintSpr
;BD85:   CALL TransferSpr
;BD88:   LD   DE,1800
;BD8B:   LD   B,06
;BD8D:   CALL MultPrintSpr
;BD90:   CALL TransferSpr
;BD93:   LD   B,06
;BD95:   JP   MultPrintSpr

PrintBorder: ; BD59
        lda #<SprInfoBuffer ; LD   IX,SprInfoBuffer
        sta z80_ix
        lda #>SprInfoBuffer
        sta z80_ix+1
        lda #<BorderData ; LD   HL,BorderData
        sta z80_l
        lda #>BorderData
        sta z80_h
        jsr TransAndPrintSpr ; CALL TransAndPrintSpr
        jsr TransAndPrintSpr ; CALL TransAndPrintSpr
        jsr TransAndPrintSpr ; CALL TransAndPrintSpr
        jsr TransAndPrintSpr ; CALL TransAndPrintSpr
        jsr TransferSpr ; CALL TransferSpr
        lda #<$0018 ; LD   DE,0018
        sta z80_e
        lda #>$0018
        sta z80_d
        lda #$08 ; LD   B,08
        sta z80_b
        jsr MultPrintSpr ; CALL MultPrintSpr
        jsr TransferSpr ; CALL TransferSpr
        lda #$08 ; LD   B,08
        sta z80_b
        jsr MultPrintSpr ; CALL MultPrintSpr
        jsr TransAndPrintSpr ; CALL TransAndPrintSpr
        jsr TransAndPrintSpr ; CALL TransAndPrintSpr
        jsr TransferSpr ; CALL TransferSpr
        lda #<L1800 ; LD   DE,1800
        sta z80_e
        lda #>L1800
        sta z80_d
        lda #$06 ; LD   B,06
        sta z80_b
        jsr MultPrintSpr ; CALL MultPrintSpr
        jsr TransferSpr ; CALL TransferSpr
        lda #$06 ; LD   B,06
        sta z80_b
        jmp MultPrintSpr ; JP   MultPrintSpr

;BorderData: ; BD98
;BD98:   DB 05,00,00,A8,05,40,E8,A8,05,C0,E8,00,05,80,00,00
;BDA8:   DB 04,00,18,A8,04,80,18,00,03,00,D8,A8,03,80,D8,00
;BDB8:   DB 02,00,00,18,02,40,E8,18

BorderData: ; BD98
        .he 05,00,00,A8,05,40,E8,A8,05,C0,E8,00,05,80,00,00 ; DB 05,00,00,A8,05,40,E8,A8,05,C0,E8,00,05,80,00,00
        .he 04,00,18,A8,04,80,18,00,03,00,D8,A8,03,80,D8,00 ; DB 04,00,18,A8,04,80,18,00,03,00,D8,A8,03,80,D8,00
        .he 02,00,00,18,02,40,E8,18 ; DB 02,00,00,18,02,40,E8,18

;TransferSpr: ; BDC0
;BDC0:   LD   A,(HL)
;BDC1:   INC  HL
;BDC2:   LD   (IX+00),A
;BDC5:   LD   A,(HL)
;BDC6:   INC  HL
;BDC7:   LD   (IX+07),A
;BDCA:   LD   A,(HL)
;BDCB:   INC  HL
;BDCC:   LD   (IX+1A),A
;BDCF:   LD   A,(HL)
;BDD0:   INC  HL
;BDD1:   LD   (IX+1B),A
;BDD4:   RET

TransferSpr: ; BDC0
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y; 
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$07 ; LD   (IX+07),A
        sta (z80_ix),y; 
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$1A ; LD   (IX+1A),A
        sta (z80_ix),y; 
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$1B ; LD   (IX+1B),A
        sta (z80_ix),y; 
        rts ; RET

;TransAndPrintSpr: ; BDD5
;BDD5:   CALL TransferSpr
;BDD8:   PUSH HL
;BDD9:   CALL PrintSprite
;BDDC:   POP  HL
;BDDD:   RET

TransAndPrintSpr: ; BDD5
        jsr TransferSpr ; CALL TransferSpr
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr PrintSprite ; CALL PrintSprite
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        rts ; RET

;MultPrintSpr: ; BDDE
;BDDE:   PUSH BC
;BDDF:   PUSH DE
;BDE0:   PUSH HL
;BDE1:   CALL PrintSprite
;BDE4:   POP  HL
;BDE5:   POP  DE
;BDE6:   POP  BC
;BDE7:   LD   A,(IX+1A)
;BDEA:   ADD  A,E
;BDEB:   LD   (IX+1A),A
;BDEE:   LD   A,(IX+1B)
;BDF1:   ADD  A,D
;BDF2:   LD   (IX+1B),A
;BDF5:   DJNZ MultPrintSpr
;BDF7:   RET

MultPrintSpr: ; BDDE
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr PrintSprite ; CALL PrintSprite
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        ldy #$1A ; LD   A,(IX+1A)
        lda (z80_ix),y
        clc ; ADD  A,E
        adc z80_e
        ldy #$1A ; LD   (IX+1A),A
        sta (z80_ix),y
        ldy #$1B ; LD   A,(IX+1B)
        lda (z80_ix),y
        clc ; ADD  A,D
        adc z80_d
        ldy #$1B ; LD   (IX+1B),A
        sta (z80_ix),y
        dec z80_b ; DJNZ MultPrintSpr
        jne MultPrintSpr
        rts ; RET

;CheckUserInput: ; BDF8
;BDF8:   LD   A,(LA709)
;BDFB:   RRCA
;BDFC:   AND  03
;BDFE:   JP   Z,Keyboard
;BE01:   DEC  A
;BE02:   JR   Z,Kempston
;BE04:   DEC  A
;BE05:   JR   Z,Cursor

CheckUserInput: ; BDF8
        lda LA709 ; LD   A,(LA709)
        jeq Keyboard
		;lsr @ ; RRCA
        ;and #$03 ; AND  03
        ;jeq Keyboard ; JP   Z,Keyboard

		; if not must be joystick so run joytick check code and fire 2 code
		; c64 joystick port 2

		; joystick checking in-game
		lda 	#00
		sta		joyvalue			
		
		;setup joystick port 2
        lda     #$E0    
        and     ddra    
        sta     ddra 		
		
		; check for no joystick input and if so move on
		lda 	pra
		and 	#%00011111
		cmp 	#%00011111
		beq		joynotfire1
			
		lda		pra
		and		#$05
		beq		joyupleft

		lda		pra
		and		#$09
		beq		joyupright

		lda		pra
		and		#$06
		beq		joydownleft			

		lda		pra
		and		#$0a
		beq		joydownright
		
		lda		pra
		and		#$01
		beq		joyup
		
		lda		pra
		and		#$02
		beq		joydown

		lda		pra
		and		#$04
		beq		joyleft		

		lda		pra
		and		#$08
		beq		joyright
		
		jmp 	joyfire1mix_02
		
joyupleft		
		lda		#$05
		jmp		joyfire1mix
joyupright	
		lda		#$06
		jmp		joyfire1mix
joydownleft	
		lda		#$09
		jmp		joyfire1mix
joydownright	
		lda		#$0a
		jmp		joyfire1mix			
joyup
		lda		#$04
		jmp		joyfire1mix
joydown
		lda		#$08
		jmp		joyfire1mix		
joyleft
		lda		#$01 
		jmp		joyfire1mix		
joyright
		lda		#$02


joyfire1mix
		sta		joyvalue
		
joyfire1mix_02		
		lda     pra   			;read port 2
        and     #$10    		;isolate button bit
        bne     joynotfire1		;if =0 then button is down.
joyfire1
		lda		#$40
		clc
		adc		joyvalue
		sta 	joyvalue
		
; get out and add joyvalues to set accumulator to required value and test for second fire next.
joynotfire1

		; setup keyboard for reading	
        lda 	#$ff    
        sta 	ddra    
        lda 	#$00    
        sta 	ddrb		
		
		; use 'Space' for Joystick fire 2
		lda 	#%01111111 ; select row 8    
        sta 	pra     
        lda 	prb       
        and 	#%00010000 ; test 'space' key for fire2
		beq		fire2hit ; if space hit jump to fire2hit, if not check for button2 below...
		
		lda 	fire2off
		bne		fire2_off_flow
		
        ;check second fire button
        lda 	ddra            ;GET CURRENT VALUE OF DDR
        sta 	temp_ddra       ;SAVE IT AWAY
        lda 	#$C0
        and 	ddra            ;added need test
        sta 	ddra            ;SET PORT A FOR INPUT

        ;select joy port 2
        lda 	pra ;Control-Port 2 selected (when bit6=0 and bit7=1)
        and 	#%00111111 ;clear bit-6/7
        ora 	#%10000000 ;set bit-7
        sta 	pra ;now control-port 2 is selected for reading the POT registers

        ;if second button is zero then its been hit ($ff if not hit).
        lda 	$D419
        ;cmp	#$ff
		bne		fire2_pass

		;inc	border

		lda 	temp_ddra 
        sta 	ddra    ;RESTORE PREVIOUS VALUE OF DDR

fire2hit

		lda		#$10
		clc
		adc 	joyvalue
		
		jmp 	fire2_flow	

fire2_pass

		lda 	temp_ddra 
        sta 	ddra    ;RESTORE PREVIOUS VALUE OF DDR

fire2_off_flow
		
		; no hit so flow through
		lda 	joyvalue

fire2_flow			

		sta 	z80_c
        sta 	LA737 ; LD   (LA737),A
	
		rts

;nokbaction
;		lda 	#00
;		sta 	z80_c
;       sta 	LA737 
;		
;		rts
		
keyboard		
	
		; reset buffer vaules first
        lda     #$00    
        sta     keyvalue
		sta		key_l
		sta		key_r
		
		; setup keyboard for reading	
        lda     #$ff    
        sta     ddra    
        lda     #$00    
        sta     ddrb
		
		; check for no key hit then move on
;		lda 	#$00
;		sta 	pra		
;		lda 	prb       
;		cmp 	#$ff
;		jeq 	nokbaction			
		
		
		; test 'o' key for left
kb_check_left
		lda     #$ef    
        sta     pra     
        lda     prb     
        and     #$40    
        beq     left_hit
			
		; test 'p' key for right
kb_check_right
		lda     #$df    
        sta     pra     
        lda     prb     
        and     #$02    
        beq     right_hit
		
		; test 'q' key for up
kb_check_up

        lda     #$7f    
        sta     pra     
        lda     prb     
        and     #$40    
        beq     up_hit

		; test 'a' key for down
kb_check_down
		lda     #$fd    
        sta     pra     
        lda     prb     
        and     #$04    
        beq     down_hit

		jmp		keymix_01	
	
left_hit
        lda     #$01    
        sta     key_l	
		sta		keyvalue
        jmp		kb_check_right			
		
right_hit
        lda     #$02    
        sta     key_r
		sta		keyvalue
        jmp		kb_check_up

up_hit
        lda     #$04    		
		clc
		adc		key_l
		adc		key_r
		sta		keyvalue
        jmp		kb_check_down	
		
down_hit
		lda		#$08
		clc
		adc		key_l
		adc		key_r
		sta		keyvalue
  		
		
keymix_01
		lda 	keyvalue
		sta		keyvalue
	
		; test 'space' key for fire1
		lda 	#%01111111 ; select row 8    
        sta     pra     
        lda     prb       
        and 	#%00010000 ; test 'space' key for fire2
		beq		fire1_hit ; if space hit jump to @fire1_hit, if not check for button2 below...
		
		jmp 	nokeyhit
			
fire1_hit
        lda     #$40
		clc
		adc		keyvalue
		sta 	keyvalue
        
nokeyhit
		
		; fire 2
		lda     #%11101111; select row 5
		;lda 	#%11111101 ; select row 2    
        sta     pra     
        lda     prb     
        and     #%00010000 ; test 'm' key
		;and 	#%00010000 ; test 'Z' key
		beq 	fire2hitk ; if m hit jump to fire2hitk

		; no hit so flow through
		lda 	keyvalue
		jmp 	fire2nothitk
		
fire2hitk
			
		lda		#$10
		clc
		adc 	keyvalue		
		
fire2nothitk

		sta 	z80_c
        sta 	LA737

		rts
		
	
		;jsr c64fire2
		;jsr c64joystickp2
		;jmp LBEFD
        
		;sec ; DEC  A
        ;sbc #$01; 
        ;jeq Kempston ; JR   Z,Kempston
        ;sec ; DEC  A
        ;sbc #$01; 
        ;jeq Cursor ; JR   Z,Cursor

;InterfaceII: ; BE07
;BE07:   LD   A,F7
;BE09:   CALL ReadKey
;BE0C:   PUSH BC
;BE0D:   LD   B,05
;@@126   RRA
;BE10:   RL   C
;BE12:   DJNZ @@126
;BE14:   LD   A,C
;BE15:   POP  BC
;BE16:   LD   C,A
;BE17:   LD   A,EF
;BE19:   CALL ReadKey
;BE1C:   OR   C
;BE1D:   LD   C,00
;BE1F:   BIT  0,A
;BE21:   JR   Z,@@127
;BE23:   SET  6,C
;@@127   BIT  1,A
;BE27:   JR   Z,@@128
;BE29:   SET  2,C
;@@128   BIT  2,A
;BE2D:   JR   Z,@@129
;BE2F:   SET  3,C
;@@129   BIT  3,A
;BE33:   JR   Z,@@130
;BE35:   SET  1,C
;@@130   BIT  4,A
;BE39:   JR   Z,@@131
;BE3B:   SET  0,C
;@@131   JP   LBEFD

;InterfaceII: ; BE07
;		rts
;        lda #$F7 ; LD   A,F7
;        jsr ReadKey ; CALL ReadKey
;		tax
;        lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda #$05 ; LD   B,05
;        sta z80_b
;		txa
;@@126   ror @ ; RRA; 
;        rol z80_c ; RL   C
;        dec z80_b ; DJNZ @@126
;        jne @@126
;        ldx z80_c ; LD   A,C
;        pla ; POP  BC
;        sta z80_b
;        pla
;        sta z80_c
;        stx z80_c ; LD   C,A
;        lda #$EF ; LD   A,EF
;        jsr ReadKey ; CALL ReadKey
;        ora z80_c ; OR   C
;		sta z80_a
;        lda #$00 ; LD   C,00
;        sta z80_c
;        lsr z80_a ; BIT  0,A
;        jcc @@127 ; JR   Z,@@127
;        ;lda z80_c ; SET  6,C
;        ora #_bitvalue6
;        ;sta z80_c
;@@127   lsr z80_a ; BIT  1,A
;        jcc @@128 ; JR   Z,@@128
;        ;lda z80_c ; SET  2,C
;        ora #_bitvalue2
;        ;sta z80_c
;@@128   lsr z80_a ; BIT  2,A
;        jcc @@129 ; JR   Z,@@129
;        ;lda z80_c ; SET  3,C
;        ora #_bitvalue3
;        ;sta z80_c
;@@129   lsr z80_a ; BIT  3,A
;        jcc @@130 ; JR   Z,@@130
;        ;lda z80_c ; SET  1,C
;        ora #_bitvalue1
;        ;sta z80_c
;@@130   lsr z80_a ; BIT  4,A
;        jcc @@131 ; JR   Z,@@131
;        ;lda z80_c ; SET  0,C
;        ora #_bitvalue0
;        sta z80_c
;@@131   jmp LBEFD ; JP   LBEFD

;Kempston: ; BE40
;BE40:   IN   A,(1F)
;BE42:   LD   C,00
;BE44:   BIT  0,A
;BE46:   JR   Z,@@132
;BE48:   SET  1,C
;@@132   BIT  1,A
;BE4C:   JR   Z,@@133
;BE4E:   SET  0,C
;@@133   BIT  2,A
;BE52:   JR   Z,@@134
;BE54:   SET  3,C
;@@134   BIT  3,A
;BE58:   JR   Z,@@135
;BE5A:   SET  2,C
;@@135   BIT  4,A
;BE5E:   JR   Z,@@136
;BE60:   SET  6,C
;@@136   JP   LBEFD

;Kempston: ; BE40
;
;        jsr c64joystickp2 ; IN   A,(1F)
;		sta z80_a
;        lda #$00 ; LD   C,00
;        ;sta z80_c
;        lsr z80_a; BIT  0,A
;        jcc @@132 ; JR   Z,@@132
;        ;lda z80_c ; SET  1,C
;        ora #_bitvalue1
;        ;sta z80_c
;@@132   lsr z80_a ; BIT  1,A;
;        jcc @@133 ; JR   Z,@@133
;        ;lda z80_c ; SET  0,C
;        ora #_bitvalue0
;        ;sta z80_c
;@@133   lsr z80_a; BIT  2,A; 
;        jcc @@134 ; JR   Z,@@134
;        ;lda z80_c ; SET  3,C
;        ora #_bitvalue3
;        ;sta z80_c
;@@134   lsr z80_a ; BIT  3,A
;        jcc @@135 ; JR   Z,@@135
;        ;lda z80_c ; SET  2,C
;        ora #_bitvalue2
;        ;sta z80_c
;@@135   lsr z80_a ; BIT  4,A
;        jcc @@136 ; JR   Z,@@136
;        ;lda z80_c ; SET  6,C
;        ora #_bitvalue6
;        ;sta z80_c
;@@136   sta z80_c
;		;sta $ffc0
;		
;
;		jmp LBEFD ; JP   LBEFD
		
;Cursor  LD   C,00
;BE67:   LD   A,F7
;BE69:   CALL ReadKey
;BE6C:   BIT  4,A
;BE6E:   JR   Z,@@137
;BE70:   SET  0,C
;@@137   LD   A,EF
;BE74:   CALL ReadKey
;BE77:   BIT  0,A
;BE79:   JR   Z,@@138
;BE7B:   SET  6,C
;@@138   BIT  3,A
;BE7F:   JR   Z,@@139
;BE81:   SET  2,C
;@@139   BIT  2,A
;BE85:   JR   Z,@@140
;BE87:   SET  1,C
;@@140   BIT  4,A
;BE8B:   JR   Z,LBEFD
;BE8D:   SET  3,C
;BE8F:   JR   LBEFD

;Cursor  
;		rts
		
;		lda #$00 ; LD   C,00
;        sta z80_c
;        lda #$F7 ; LD   A,F7
;        jsr ReadKey ; CALL ReadKey
;        bit _bitmem4 ; BIT  4,A
;        jeq @@137 ; JR   Z,@@137
;        lda z80_c ; SET  0,C
;        ora #_bitvalue0
;        sta z80_c
;@@137   lda #$EF ; LD   A,EF
;        jsr ReadKey ; CALL ReadKey
;		sta z80_a
;        bit _bitmem0 ; BIT  0,A
;        jeq @@138 ; JR   Z,@@138
;        lda z80_c ; SET  6,C
;        ora #_bitvalue6
;        sta z80_c
;@@138   lda z80_a
;		bit _bitmem3 ; BIT  3,A
;        jeq @@139 ; JR   Z,@@139
;        lda z80_c ; SET  2,C
;        ora #_bitvalue2
;        sta z80_c
;@@139   lda z80_a
;		bit _bitmem2 ; BIT  2,A
;        jeq @@140 ; JR   Z,@@140
;        lda z80_c ; SET  1,C
;        ora #_bitvalue1
;        sta z80_c
;@@140   lda z80_a
;		bit _bitmem4 ; BIT  4,A
;        jeq LBEFD ; JR   Z,LBEFD
;        lda z80_c ; SET  3,C
;        ora #_bitvalue3
;        sta z80_c
;        jmp LBEFD ; JR   LBEFD

;Keyboard: ; BE91
;BE91:   LD   A,FE
;BE93:   CALL ReadKey
;BE96:   RRCA
;BE97:   LD   C,A
;BE98:   AND  03
;BE9A:   SRL  C
;BE9C:   SRL  C
;BE9E:   OR   C
;BE9F:   AND  03
;BEA1:   LD   C,A
;BEA2:   LD   A,7F
;BEA4:   CALL ReadKey
;BEA7:   BIT  1,A
;BEA9:   JR   Z,@@141
;BEAB:   SET  1,C
;@@141   BIT  2,A
;BEAF:   JR   Z,@@142
;BEB1:   SET  0,C
;@@142   BIT  3,A
;BEB5:   JR   Z,@@143
;BEB7:   SET  1,C
;@@143   BIT  4,A
;BEBB:   JR   Z,@@144
;BEBD:   SET  0,C
;@@144   LD   A,BD
;BEC1:   CALL ReadKey
;BEC4:   JR   Z,@@145
;BEC6:   SET  2,C
;@@145   LD   A,DF
;BECA:   CALL ReadKey
;BECD:   LD   B,A
;BECE:   AND  0A
;BED0:   JR   NZ,@@146
;BED2:   LD   A,FB
;BED4:   CALL ReadKey
;BED7:   LD   E,A
;BED8:   AND  15
;BEDA:   JR   Z,@@147
;@@146   SET  3,C
;@@147   LD   A,E7
;BEE0:   CALL ReadKey
;BEE3:   JR   Z,@@148
;BEE5:   SET  4,C
;@@148   LD   A,DF
;BEE9:   CALL ReadKey
;BEEC:   AND  15
;BEEE:   JR   NZ,@@149
;BEF0:   LD   A,FB
;BEF2:   CALL ReadKey
;BEF5:   AND  0A
;BEF7:   JR   Z,@@150
;@@149   SET  6,C
;BEFB:   JR   @@150

;Keyboard: ; BE91

		;jsr c64keyboard

;		; right
;        jsr c64keyboard ; IN   A,(1F)
;		sta z80_a
;        lda #$00 ; LD   C,00
;        ;sta z80_c
;        lsr z80_a; BIT  0,A
;        jcc @@132b ; JR   Z,@@132
;        ;lda z80_c ; SET  1,C
;        ora #_bitvalue1
;        ;sta z80_c
;		
;		; left
;@@132b   lsr z80_a ; BIT  1,A;
;        jcc @@133b ; JR   Z,@@133
;        ;lda z80_c ; SET  0,C
;        ora #_bitvalue0
;        ;sta z80_c
;
;		; down
;@@133b   lsr z80_a; BIT  2,A; 
;        jcc @@134b ; JR   Z,@@134
;        ;lda z80_c ; SET  3,C
;        ora #_bitvalue3
;        ;sta z80_c
;		
;		; up
;@@134b   lsr z80_a ; BIT  3,A
;        jcc @@135b ; JR   Z,@@135
;        ;lda z80_c ; SET  2,C
;        ora #_bitvalue2
;        ;sta z80_c
;		
;		; fire1
;@@135b   lsr z80_a ; BIT  4,A
;        jcc @@136b ; JR   Z,@@136
;        ;lda z80_c ; SET  6,C
;        ora #_bitvalue6
;        ;sta z80_c
;
;		; fire2 - pickup/drop
;@@136bz  lsr z80_a ; BIT  4,A
;        jcc @@136b ; JR   Z,@@136
;        lda z80_c ; SET  6,C
;        ora #_bitvalue4
;        sta z80_c
;		
;@@136b   sta z80_c
		;sta $ffc0
		
		;cmp #00
		;beq @@test008
		;lda z80_c
		;sta $ffc1
;@@test008		
				
;		jmp LBEFD ; JP   LBEFD


;        lda #$FE ; LD   A,FE
;        jsr ReadKey ; CALL ReadKey
;        lsr @ ; RRCA
;		jcc Keyboard_no_ora_80
;		ora #$80
;Keyboard_no_ora_80		
;        sta z80_c ; LD   C,A
;        and #$03 ; AND  03
;        lsr z80_c ; SRL  C
;        lsr z80_c ; SRL  C
;        ora z80_c ; OR   C
;        and #$03 ; AND  03
;        sta z80_c ; LD   C,A
;        lda #$7F ; LD   A,7F
;        jsr ReadKey ; CALL ReadKey
;		lsr @
;		sta z80_a
;		lda z80_c
;        lsr z80_a ; BIT  1,A
;        jcc @@141 ; JR   Z,@@141
;        ;lda z80_c ; SET  1,C
;        ora #_bitvalue1
;        ;sta z80_c
;@@141   lsr z80_a ; BIT  2,A
;        jcc @@142 ; JR   Z,@@142
;        ;lda z80_c ; SET  0,C
;        ora #_bitvalue0
;        ;sta z80_c
;@@142   lsr z80_a ; BIT  3,A
;        jcc @@143 ; JR   Z,@@143
;        ;lda z80_c ; SET  1,C
;        ora #_bitvalue1
;        ;sta z80_c
;@@143   lsr z80_a ; BIT  4,A
;        jcc @@144 ; JR   Z,@@144
;        ;lda z80_c ; SET  0,C
;        ora #_bitvalue0
;        sta z80_c
;@@144   lda #$BD ; LD   A,BD
;        jsr ReadKey ; CALL ReadKey
;        jeq @@145 ; JR   Z,@@145
;        lda z80_c ; SET  2,C
;        ora #_bitvalue2
;        sta z80_c
;@@145   lda #$DF ; LD   A,DF
;        jsr ReadKey ; CALL ReadKey
;        sta z80_b ; LD   B,A
;        and #$0A ; AND  0A
;        jne @@146 ; JR   NZ,@@146
;        lda #$FB ; LD   A,FB
;        jsr ReadKey ; CALL ReadKey
;        sta z80_e ; LD   E,A
;        and #$15 ; AND  15
;        jeq @@147 ; JR   Z,@@147
;@@146   lda z80_c ; SET  3,C
;        ora #_bitvalue3
;        sta z80_c
;@@147   lda #$E7 ; LD   A,E7
;        jsr ReadKey ; CALL ReadKey
;        jeq @@148 ; JR   Z,@@148
;        lda z80_c ; SET  4,C
;        ora #_bitvalue4
;        sta z80_c
;@@148   lda #$DF ; LD   A,DF
;        jsr ReadKey ; CALL ReadKey
;        and #$15 ; AND  15
;        jne @@149 ; JR   NZ,@@149
;        lda #$FB ; LD   A,FB
;        jsr ReadKey ; CALL ReadKey
;        and #$0A ; AND  0A
;        jeq @@150 ; JR   Z,@@150
;@@149   lda z80_c ; SET  6,C
;        ora #_bitvalue6
;        sta z80_c
;        jmp @@150 ; JR   @@150

;LBEFD   LD   A,7E
;BEFF:   CALL ReadKey
;BF02:   AND  1E
;BF04:   JR   Z,@@150
;BF06:   SET  4,C
;@@150   LD   A,C
;BF09:   LD   (LA737),A
;BF0C:   RET

;LBEFD   
		;lda #$7E ; LD   A,7E
        ;jsr ReadKey ; CALL ReadKey
        ;and #$1E ; AND  1E
        ;jeq @@150 ; JR   Z,@@150
        ;lda z80_c ; SET  4,C
        ;ora #_bitvalue4
        ;sta z80_c
;@@150   
		;lda z80_c ; LD   A,C
		
		;sta z80_c
		;jsr c64fire2
;		sta z80_c
;        sta LA737 ; LD   (LA737),A
		;sta $ffc1
		
		;cmp #00
		;beq @@test008
		;lda z80_c
		;sta $ffc1
;@@test008		
		
;		rts ; RET

;LBF0D   LD   B,36
;BF0F:   LD   DE,0020
;BF12:   LD   HL,A776
;@@151   RES  5,(HL)
;BF17:   ADD  HL,DE
;BF18:   DJNZ @@151
;BF1A:   RET

LBF0D   lda #$36 ; LD   B,36
        sta z80_b
        lda #<L0020 ; LD   DE,0020
        sta z80_e
        lda #>L0020
        sta z80_d
        lda #<LA776 ; LD   HL,A776
        sta z80_l
        lda #>LA776
        sta z80_h
@@151   ldy #$00 ; RES  5,(HL)
        lda (z80_hl),y
        and #_notbitvalue5
        sta (z80_hl),y
        jsr add_hl_de ; ADD  HL,DE
        dec z80_b ; DJNZ @@151
        jne @@151
        rts ; RET

;LBF1B   PUSH BC
;BF1C:   PUSH DE
;BF1D:   PUSH HL
;BF1E:   PUSH IY
;BF20:   LD   IY,A76F
;BF24:   LD   B,36
;BF26:   LD   C,00
;BF28:   LD   L,C
;BF29:   LD   H,C
;BF2A:   SET  1,(IX+07)
;@@153   CALL LB99B
;BF31:   JR   Z,@@152
;BF33:   CALL LB8A2
;BF36:   JR   NC,@@152
;BF38:   CALL LB8B7
;BF3B:   JR   NC,@@152
;BF3D:   CALL LB8CC
;BF40:   JR   NC,@@152
;@@154   POP  IY
;BF44:   POP  HL
;BF45:   POP  DE
;BF46:   POP  BC
;BF47:   RES  1,(IX+07)
;BF4B:   RET

LBF1B   lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        lda #<LA76F ; LD   IY,A76F
        sta z80_iy
        lda #>LA76F
        sta z80_iy+1
        lda #$36 ; LD   B,36
        sta z80_b
        lda #$00 ; LD   C,00
        sta z80_c
        ;lda z80_c ; LD   L,C
        sta z80_l
        ;lda z80_c ; LD   H,C
        sta z80_h
        ldy #$07 ; SET  1,(IX+07)
        lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
@@153   jsr LB99B ; CALL LB99B
        jeq @@152 ; JR   Z,@@152
        jsr LB8A2 ; CALL LB8A2
        jcs @@152 ; JR   NC,@@152
        jsr LB8B7 ; CALL LB8B7
        jcs @@152 ; JR   NC,@@152
        jsr LB8CC ; CALL LB8CC
        jcs @@152 ; JR   NC,@@152
@@154   pla ; POP  IY
        sta z80_iy+1
        pla
        sta z80_iy
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        ldy #$07 ; RES  1,(IX+07)
        lda (z80_ix),y
        and #_notbitvalue1
        sta (z80_ix),y
        rts ; RET

;@@152   LD   DE,0020
;BF4F:   ADD  IY,DE
;BF51:   DJNZ @@153
;BF53:   AND  A
;BF54:   JR   @@154

;@@152   lda #<L0020 ; LD   DE,0020
;        sta z80_e
;        lda #>L0020
;        sta z80_d
;        jsr add_iy_de ; ADD  IY,DE
@@152	lda #$20
		clc
		adc z80_iy
		sta z80_iy
		scc:inc z80_iy+1
        dec z80_b ; DJNZ @@153
        jne @@153
        sec ; AND  A
        jmp @@154 ; JR   @@154

;LBF56   PUSH IY
;BF58:   PUSH IX
;BF5A:   PUSH IY
;BF5C:   POP  IX
;BF5E:   CALL LCCDE
;BF61:   POP  IX
;BF63:   POP  IY
;BF65:   RET

LBF56   lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        lda z80_ix ; PUSH IX
        pha
        lda z80_ix+1
        pha
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix
        jsr LCCDE ; CALL LCCDE
        pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix
        pla ; POP  IY
        sta z80_iy+1
        pla
        sta z80_iy
        rts ; RET

;LBF66   LD   HL,ScratchMem
;BF69:   LD   A,(HL)
;BF6A:   AND  06
;BF6C:   LD   A,(LA737)
;BF6F:   JR   Z,@@155
;BF71:   BIT  3,(HL)
;BF73:   JR   Z,@@155
;BF75:   RRCA
;@@155   AND  10
;BF78:   RET

;LBF66   lda #<ScratchMem ; LD   HL,ScratchMem
;        sta z80_l
;        lda #>ScratchMem
;        sta z80_h
;        ldy #$00 ; LD   A,(HL)
;        lda (z80_hl),y
;        and #$06 ; AND  06
;		php
;        lda LA737 ; LD   A,(LA737)
;		plp
;        jeq @@155 ; JR   Z,@@155
;        ldy #$00 ; BIT  3,(HL)
;        lda (z80_hl),y
;        bit _bitmem3
;        jeq @@155 ; JR   Z,@@155
;        lsr @ ; RRCA
;@@155   and #$10 ; AND  10
;        rts ; RET

LBF66	lda ScratchMem
		and #$06
		beq @@155
		lda ScratchMem
		and #$08
		beq @@155
		lda LA737
		lsr @
		and #$10
		rts
@@155	lda LA737
		and #$10
		rts
		
;LBF79   LD   A,(LA740)
;BF7C:   AND  A
;BF7D:   JP   NZ,LC00E
;BF80:   CALL LBF66
;BF83:   RET  Z
;BF84:   CALL LC4A3
;BF87:   RET  NC
;BF88:   BIT  3,(IX+0C)
;BF8C:   RET  NZ
;BF8D:   BIT  2,(IX+0C)
;BF91:   RET  Z
;BF92:   XOR  A
;BF93:   LD   (LA741),A
;BF96:   LD   A,(IX+03)
;BF99:   LD   B,A
;BF9A:   ADD  A,0C
;BF9C:   LD   (IX+03),A
;BF9F:   CALL LBF1B
;BFA2:   LD   (IX+03),B
;BFA5:   JR   NC,@@156
;BFA7:   LD   A,01
;BFA9:   LD   (LA741),A
;@@156   LD   A,01
;BFAE:   LD   (LA740),A
;BFB1:   LD   (LA720),A
;BFB4:   LD   B,30
;BFB6:   LD   L,(IX+04)
;BFB9:   LD   A,L
;BFBA:   ADD  A,04
;BFBC:   LD   (IX+04),A
;BFBF:   LD   H,(IX+05)
;BFC2:   LD   A,H
;BFC3:   ADD  A,04
;BFC5:   LD   (IX+05),A
;BFC8:   PUSH HL
;BFC9:   LD   L,(IX+06)
;BFCC:   LD   A,L
;BFCD:   ADD  A,04
;BFCF:   LD   (IX+06),A
;BFD2:   PUSH HL
;BFD3:   LD   IY,A82F
;@@157   CALL LC0D4
;BFDA:   JP   C,LC0A7
;BFDD:   LD   DE,0020
;BFE0:   ADD  IY,DE
;BFE2:   DJNZ @@157
;BFE4:   CALL LBF66
;BFE7:   JR   Z,@@158
;BFE9:   LD   DE,0020
;BFEC:   LD   B,30
;BFEE:   LD   IY,A82F
;@@160   LD   A,(IY+00)
;BFF5:   AND  A
;BFF6:   JR   Z,@@159
;BFF8:   ADD  IY,DE
;BFFA:   DJNZ @@160
;@@158   POP  HL
;BFFD:   LD   (IX+06),L
;C000:   POP  HL
;C001:   LD   (IX+04),L
;C004:   LD   (IX+05),H
;C007:   LD   HL,0105
;C00A:   LD   (A749),HL
;C00D:   RET

LBF79   lda LA740 ; LD   A,(LA740)
        ; AND  A
        jne LC00E ; JP   NZ,LC00E
        jsr LBF66 ; CALL LBF66
        bne *+3 ; RET  Z
        rts; 
        jsr LC4A3 ; CALL LC4A3
        bcc *+3 ; RET  NC
        rts; 
        ldy #$0C ; BIT  3,(IX+0C)
        lda (z80_ix),y
        bit _bitmem3
        beq *+3 ; RET  NZ
        rts
        ldy #$0C ; BIT  2,(IX+0C)
        lda (z80_ix),y
        bit _bitmem2
        bne *+3 ; RET  Z
        rts
        lda #$00 ; XOR  A
        sta LA741 ; LD   (LA741),A
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        sta z80_b ; LD   B,A
        clc ; ADD  A,0C
        adc #$0C
        ldy #$03 ; LD   (IX+03),A
        sta (z80_ix),y
        jsr LBF1B ; CALL LBF1B
        ldy #$03 ; LD   (IX+03),B
        lda z80_b
        sta (z80_ix),y
        jcs @@156 ; JR   NC,@@156
        lda #$01 ; LD   A,01
        sta LA741 ; LD   (LA741),A
@@156   lda #$01 ; LD   A,01
        sta LA740 ; LD   (LA740),A
        sta LA720 ; LD   (LA720),A
        lda #$30 ; LD   B,30
        sta z80_b
        ldy #$04 ; LD   L,(IX+04)
        lda (z80_ix),y
        sta z80_l
        lda z80_l ; LD   A,L
        clc ; ADD  A,04
        adc #$04
        ldy #$04 ; LD   (IX+04),A
        sta (z80_ix),y
        ldy #$05 ; LD   H,(IX+05)
        lda (z80_ix),y
        sta z80_h
        lda z80_h ; LD   A,H
        clc ; ADD  A,04
        adc #$04
        ldy #$05 ; LD   (IX+05),A
        sta (z80_ix),y
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        ldy #$06 ; LD   L,(IX+06)
        lda (z80_ix),y
        sta z80_l
        lda z80_l ; LD   A,L
        clc ; ADD  A,04
        adc #$04
        ldy #$06 ; LD   (IX+06),A
        sta (z80_ix),y
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda #<LA82F ; LD   IY,A82F
        sta z80_iy
        lda #>LA82F
        sta z80_iy+1
@@157   jsr LC0D4 ; CALL LC0D4
        jcc LC0A7 ; JP   C,LC0A7
        lda #<L0020 ; LD   DE,0020
        sta z80_e
        lda #>L0020
        sta z80_d
        jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@157
        jne @@157
        jsr LBF66 ; CALL LBF66
        jeq @@158 ; JR   Z,@@158
        lda #<L0020 ; LD   DE,0020
        sta z80_e
        lda #>L0020
        sta z80_d
        lda #$30 ; LD   B,30
        sta z80_b
        lda #<LA82F ; LD   IY,A82F
        sta z80_iy
        lda #>LA82F
        sta z80_iy+1
@@160   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        ; AND  A: 
        jeq @@159 ; JR   Z,@@159
        jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@160
        jne @@160
@@158   pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        ldy #$06 ; LD   (IX+06),L
        lda z80_l
        sta (z80_ix),y
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        ldy #$04 ; LD   (IX+04),L
        lda z80_l
        sta (z80_ix),y
        ldy #$05 ; LD   (IX+05),H
        lda z80_h
        sta (z80_ix),y
        lda #<L0105 ; LD   HL,0105
        sta z80_l
        lda #>L0105
        sta z80_h
        lda z80_l ; LD   (A749),HL
        sta LA749
        lda z80_h
        sta LA749+1
        rts ; RET

;LC00E   CALL LBF66
;C011:   RET  NZ
;C012:   XOR  A
;C013:   LD   (LA740),A
;C016:   RET

LC00E   jsr LBF66 ; CALL LBF66
        beq *+3 ; RET  NZ
        rts; 
        lda #$00 ; XOR  A
        sta LA740 ; LD   (LA740),A
        rts ; RET

;@@159   LD   HL,A72E
;C01A:   LD   A,(HL)
;C01B:   INC  HL
;C01C:   AND  A
;C01D:   JR   Z,@@161
;C01F:   LD   A,(LA741)
;C022:   AND  A
;C023:   JR   NZ,@@158
;C025:   DEC  HL
;C026:   LD   A,(HL)
;C027:   INC  HL
;C028:   LD   (IY+00),A
;C02B:   PUSH HL
;C02C:   LD   BC,001F
;C02F:   PUSH IX
;C031:   POP  HL
;C032:   PUSH IY
;C034:   POP  DE
;C035:   INC  DE
;C036:   INC  HL
;C037:   LDIR
;C039:   LD   A,(IX+03)
;C03C:   ADD  A,0C
;C03E:   LD   (IX+03),A
;C041:   LD   A,(IX+23)
;C044:   ADD  A,0C
;C046:   LD   (IX+23),A
;C049:   PUSH IX
;C04B:   PUSH IY
;C04D:   PUSH IY
;C04F:   POP  IX
;C051:   CALL LC75F
;C054:   CALL LB2C5
;C057:   CALL LB979
;C05A:   CALL LCCDE
;C05D:   POP  IY
;C05F:   POP  IX
;@@162   LD   (IY+04),05
;C065:   LD   (IY+05),05
;C069:   LD   (IY+06),0C
;C06D:   POP  HL
;C06E:   LD   A,(HL)
;C06F:   INC  HL
;C070:   LD   (IY+07),A
;C073:   LD   A,(IX+08)
;C076:   LD   (IY+08),A
;C079:   LD   A,(HL)
;C07A:   INC  HL
;C07B:   LD   (IY+10),A
;C07E:   LD   A,(HL)
;C07F:   LD   (IY+11),A
;C082:   LD   H,A
;C083:   LD   L,(IY+10)
;C086:   LD   A,(IY+00)
;C089:   LD   (HL),A
;C08A:   SET  0,(IY+0D)
;C08E:   CALL LBF56
;@@161   LD   HL,A72D
;C094:   LD   DE,A731
;C097:   LD   BC,000C
;C09A:   LDDR
;C09C:   LD   DE,A722
;C09F:   LD   B,04
;C0A1:   CALL Zero_DE
;C0A4:   JP   @@158

@@159   lda #<LA72E ; LD   HL,A72E
        sta z80_l
        lda #>LA72E
        sta z80_h
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        cmp #$00; AND  A
        jeq @@161 ; JR   Z,@@161
        lda LA741 ; LD   A,(LA741)
        ; AND  A
        jne @@158 ; JR   NZ,@@158
        jsr dec_hl ; DEC  HL
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD   (IY+00),A
        sta (z80_iy),y
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda #<$001F ; LD   BC,001F
        sta z80_c
        lda #>$001F
        sta z80_b
        lda z80_ix ; PUSH IX
        pha
        lda z80_ix+1
        pha
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        jsr ldir ; LDIR
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        clc ; ADD  A,0C
        adc #$0C
        ldy #$03 ; LD   (IX+03),A
        sta (z80_ix),y
        ldy #$23 ; LD   A,(IX+23)
        lda (z80_ix),y
        clc ; ADD  A,0C
        adc #$0C
        ldy #$23 ; LD   (IX+23),A
        sta (z80_ix),y
        lda z80_ix ; PUSH IX
        pha
        lda z80_ix+1
        pha
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix
        jsr LC75F ; CALL LC75F
        jsr LB2C5 ; CALL LB2C5
        jsr LB979 ; CALL LB979
        jsr LCCDE ; CALL LCCDE
        pla ; POP  IY
        sta z80_iy+1
        pla
        sta z80_iy
        pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix
@@162   ldy #$04 ; LD   (IY+04),05
        lda #$05
        sta (z80_iy),y
        ldy #$05 ; LD   (IY+05),05
        lda #$05
        sta (z80_iy),y
        ldy #$06 ; LD   (IY+06),0C
        lda #$0C
        sta (z80_iy),y
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$07 ; LD   (IY+07),A
        sta (z80_iy),y
        ldy #$08 ; LD   A,(IX+08)
        lda (z80_ix),y
        ldy #$08 ; LD   (IY+08),A
        sta (z80_iy),y
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$10 ; LD   (IY+10),A
        sta (z80_iy),y
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ldy #$11 ; LD   (IY+11),A
        sta (z80_iy),y
        sta z80_h ; LD   H,A
        ldy #$10 ; LD   L,(IY+10)
        lda (z80_iy),y
        sta z80_l
        ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        ldy #$00 ; LD   (HL),A
        sta (z80_hl),y
        ldy #$0D ; SET  0,(IY+0D)
        lda (z80_iy),y
        ora #_bitvalue0
        sta (z80_iy),y
        jsr LBF56 ; CALL LBF56
@@161   lda #<LA72D ; LD   HL,A72D
        sta z80_l
        lda #>LA72D
        sta z80_h
        lda #<LA731 ; LD   DE,A731
        sta z80_e
        lda #>LA731
        sta z80_d
        lda #<$000C ; LD   BC,000C
        sta z80_c
        lda #>$000C
        sta z80_b
        jsr lddr ; LDDR
        lda #<LA722 ; LD   DE,A722
        sta z80_e
        lda #>LA722
        sta z80_d
        lda #$04 ; LD   B,04
        sta z80_b
        jsr Zero_DE ; CALL Zero_DE
        jmp @@158 ; JP   @@158

;LC0A7   LD   HL,A722
;C0AA:   LD   A,(IY+00)
;C0AD:   LD   (HL),A
;C0AE:   INC  HL
;C0AF:   LD   A,(IY+07)
;C0B2:   LD   (HL),A
;C0B3:   INC  HL
;C0B4:   LD   E,(IY+10)
;C0B7:   LD   D,(IY+11)
;C0BA:   XOR  A
;C0BB:   LD   (DE),A
;C0BC:   LD   (HL),E
;C0BD:   INC  HL
;C0BE:   LD   (HL),D
;C0BF:   CALL LBF56
;C0C2:   LD   (IY+00),01
;C0C6:   LD   HL,A72E
;C0C9:   LD   A,(HL)
;C0CA:   INC  HL
;C0CB:   AND  A
;C0CC:   JR   Z,@@161
;C0CE:   LD   (IY+00),A
;C0D1:   PUSH HL
;C0D2:   JR   @@162

LC0A7   lda #<LA722 ; LD   HL,A722
        sta z80_l
        lda #>LA722
        sta z80_h
        ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        ldy #$00 ; LD   (HL),A
        sta (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$07 ; LD   A,(IY+07)
        lda (z80_iy),y
        ldy #$00 ; LD   (HL),A
        sta (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$10 ; LD   E,(IY+10)
        lda (z80_iy),y
        sta z80_e
        ldy #$11 ; LD   D,(IY+11)
        lda (z80_iy),y
        sta z80_d
        lda #$00 ; XOR  A
        ldy #$00 ; LD   (DE),A
        sta (z80_de),y
        lda z80_e ; LD   (HL),E
        ldy #$00
        sta (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        lda z80_d ; LD   (HL),D
        ldy #$00
        sta (z80_hl),y
        jsr LBF56 ; CALL LBF56
        ldy #$00 ; LD   (IY+00),01
        lda #$01
        sta (z80_iy),y
        lda #<LA72E ; LD   HL,A72E
        sta z80_l
        lda #>LA72E
        sta z80_h
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        cmp #$00; AND  A
        jeq @@161 ; JR   Z,@@161
        ldy #$00 ; LD   (IY+00),A
        sta (z80_iy),y; 
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jmp @@162 ; JR   @@162

;LC0D4   LD   A,(IY+00)
;C0D7:   CP   5A
;C0D9:   JR   Z,@@163
;C0DB:   SUB  90
;C0DD:   CP   05
;C0DF:   RET  NC
;@@163   PUSH BC
;C0E1:   LD   BC,0000
;C0E4:   LD   L,C
;C0E5:   LD   H,C
;C0E6:   CALL LB8A2
;C0E9:   JR   NC,@@164
;C0EB:   CALL LB8B7
;C0EE:   JR   NC,@@164
;C0F0:   LD   A,(IX+03)
;C0F3:   SUB  04
;C0F5:   LD   (IX+03),A
;C0F8:   CALL LB8CC
;C0FB:   PUSH AF
;C0FC:   LD   A,(IX+03)
;C0FF:   ADD  A,04
;C101:   LD   (IX+03),A
;C104:   POP  AF
;@@164   POP  BC
;C106:   RET

LC0D4   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        cmp #$5A ; CP   5A
        jeq @@163 ; JR   Z,@@163
        sec ; SUB  90
        sbc #$90; 
        cmp #$05 ; CP   05
        bcc *+3 ; RET  NC
        rts
@@163   lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda #<0000 ; LD   BC,0000
        sta z80_c
        lda #>0000
        sta z80_b
        lda z80_c ; LD   L,C
        sta z80_l
        lda z80_c ; LD   H,C
        sta z80_h
        jsr LB8A2 ; CALL LB8A2
        jcs @@164 ; JR   NC,@@164
        jsr LB8B7 ; CALL LB8B7
        jcs @@164 ; JR   NC,@@164
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        sec ; SUB  04
        sbc #$04
        ldy #$03 ; LD   (IX+03),A
        sta (z80_ix),y
        jsr LB8CC ; CALL LB8CC
        ;pha ; PUSH AF
        php; Note: this preserves CARRY flag
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        clc ; ADD  A,04
        adc #$04
        ldy #$03 ; LD   (IX+03),A
        sta (z80_ix),y
        plp ; POP  AF
        ;pha
@@164   pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        rts ; RET

;LC107   LD   (IX+00),40
;C10B:   SET  1,(IX+07)
;C10F:   JR   @@165

LC107   ldy #$00 ; LD   (IX+00),40
        lda #$40
        sta (z80_ix),y
        ldy #$07 ; SET  1,(IX+07)
        lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
        jmp @@165 ; JR   @@165

;LC111   CALL LC77A
;C114:   CALL LD64E
;C117:   INC  (IX+00)
;@@165   JP   LCCDE

LC111   jsr LC77A ; CALL LC77A
        jsr LD64E ; CALL LD64E
        ldy #$00 ; INC  (IX+00)
        lda (z80_ix),y
        clc
        adc #$01
        sta (z80_ix),y
@@165   jmp LCCDE ; JP   LCCDE

;LC11D   CALL LC77A
;LC120   LD   (IX+00),01
;C124:   JR   @@165

LC11D   jsr LC77A ; CALL LC77A
LC120   ldy #$00 ; LD   (IX+00),01
        lda #$01
        sta (z80_ix),y
        jmp @@165 ; JR   @@165

;LC126   LD   HL,ScreenMakeUpTable
;C129:   LD   A,(LA737)
;C12C:   AND  40
;C12E:   JR   NZ,@@166
;C130:   XOR  A
;C131:   LD   (LA743),A
;C134:   RET

LC126   lda #<ScreenMakeUpTable ; LD   HL,ScreenMakeUpTable
        sta z80_l
        lda #>ScreenMakeUpTable
        sta z80_h
        lda LA737 ; LD   A,(LA737)
        and #$40 ; AND  40
        jne @@166 ; JR   NZ,@@166
        lda #$00 ; XOR  A
        sta LA743 ; LD   (LA743),A
        rts ; RET

;@@166   LD   A,(LA743)
;C138:   AND  A
;C139:   RET  NZ
;C13A:   INC  A
;C13B:   LD   (LA743),A
;C13E:   LD   BC,0020
;C141:   LD   A,(HL)
;C142:   AND  A
;C143:   JR   Z,@@167
;C145:   ADD  HL,BC
;C146:   LD   A,(HL)
;C147:   AND  A
;C148:   RET  NZ
;@@167   EX   DE,HL
;C14A:   PUSH DE
;C14B:   POP  IY
;C14D:   PUSH IX
;C14F:   POP  HL
;C150:   LDIR
;C152:   LD   (IY+00),96
;C156:   CALL LC5BD
;C159:   LD   L,A
;C15A:   LD   H,00
;C15C:   LD   DE,LC1BD
;C15F:   ADD  HL,HL
;C160:   ADD  HL,DE
;C161:   LD   A,(HL)
;C162:   LD   (IY+14),A
;C165:   ADD  A,A
;C166:   LD   E,A
;C167:   INC  HL
;C168:   LD   A,(HL)
;C169:   LD   (IY+15),A
;C16C:   ADD  A,A
;C16D:   ADD  A,(IY+02)
;C170:   LD   (IY+02),A
;C173:   LD   A,E
;C174:   ADD  A,(IY+01)
;C177:   LD   (IY+01),A
;C17A:   LD   A,(IY+03)
;C17D:   ADD  A,04
;C17F:   LD   (IY+03),A
;C182:   LD   (IY+07),14
;C186:   LD   (IY+0C),00
;C18A:   LD   (IY+06),08
;C18E:   LD   HL,(LA71D)
;C191:   LD   A,L
;C192:   SUB  (IY+04)
;C195:   LD   L,A
;C196:   LD   A,H
;C197:   SUB  (IY+05)
;C19A:   LD   H,A
;C19B:   LD   A,(IY+01)
;C19E:   SUB  80
;C1A0:   JP   P,LC1A5
;C1A3:   NEG
;LC1A5   CP   L
;C1A6:   JR   NC,@@168
;C1A8:   LD   A,(IY+02)
;C1AB:   SUB  80
;C1AD:   JP   P,LC1B2
;C1B0:   NEG
;LC1B2   CP   H
;C1B3:   JR   NC,@@168
;C1B5:   JP   LD629

@@166   lda LA743 ; LD   A,(LA743)
        ; AND  A: 
        beq *+3 ; RET  NZ
        rts
        clc ; INC  A
        adc #$01; 
        sta LA743 ; LD   (LA743),A
        lda #<L0020 ; LD   BC,0020
        sta z80_c
        lda #>L0020
        sta z80_b
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ; AND  A: 
        jeq @@167 ; JR   Z,@@167
        jsr add_hl_bc ; ADD  HL,BC
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ; AND  A: 
        beq *+3 ; RET  NZ
        rts
@@167   jsr ex_de_hl ; EX   DE,HL
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        pla ; POP  IY
        sta z80_iy+1
        pla
        sta z80_iy
        lda z80_ix ; PUSH IX
        pha
        lda z80_ix+1
        pha
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        jsr ldir ; LDIR
        ldy #$00 ; LD   (IY+00),96
        lda #$96
        sta (z80_iy),y
        jsr LC5BD ; CALL LC5BD
        sta z80_l ; LD   L,A; 
        lda #$00 ; LD   H,00
        sta z80_h
        lda #<LC1BD ; LD   DE,LC1BD
        sta z80_e
        lda #>LC1BD
        sta z80_d
        asl z80_l ; ADD  HL,HL
        rol z80_h
        jsr add_hl_de ; ADD  HL,DE
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ldy #$14 ; LD   (IY+14),A
        sta (z80_iy),y
        asl @ ; ADD  A,A
        sta z80_e ; LD   E,A
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ldy #$15 ; LD   (IY+15),A
        sta (z80_iy),y
        asl @ ; ADD  A,A
        ldy #$02 ; ADD  A,(IY+02)
        clc
        adc (z80_iy),y
        ldy #$02 ; LD   (IY+02),A
        sta (z80_iy),y
        lda z80_e ; LD   A,E
        ldy #$01 ; ADD  A,(IY+01)
        clc
        adc (z80_iy),y
        ldy #$01 ; LD   (IY+01),A
        sta (z80_iy),y
        ldy #$03 ; LD   A,(IY+03)
        lda (z80_iy),y
        clc ; ADD  A,04
        adc #$04
        ldy #$03 ; LD   (IY+03),A
        sta (z80_iy),y
        ldy #$07 ; LD   (IY+07),14
        lda #$14
        sta (z80_iy),y
        ldy #$0C ; LD   (IY+0C),00
        lda #$00
        sta (z80_iy),y
        ldy #$06 ; LD   (IY+06),08
        lda #$08
        sta (z80_iy),y
        lda LA71D ; LD   HL,(LA71D)
        sta z80_l
        lda LA71D+1
        sta z80_h
        lda z80_l ; LD   A,L
        ldy #$04 ; SUB  (IY+04)
        sec
        sbc (z80_iy),y
        sta z80_l ; LD   L,A
        lda z80_h ; LD   A,H
        ldy #$05 ; SUB  (IY+05)
        sec
        sbc (z80_iy),y
        sta z80_h ; LD   H,A
        ldy #$01 ; LD   A,(IY+01)
        lda (z80_iy),y
        sec ; SUB  80
        sbc #$80
        jpl LC1A5 ; JP   P,LC1A5
        eor #$ff ; NEG
        clc
        adc #$01;

		
LC1A5   cmp z80_l ; CP   L
        jcs @@168 ; JR   NC,@@168
        ldy #$02 ; LD   A,(IY+02)
        lda (z80_iy),y
        sec ; SUB  80
        sbc #$80
        jpl LC1B2 ; JP   P,LC1B2
        eor #$ff ; NEG
        clc
        adc #$01; 
LC1B2   cmp z80_h ; CP   H
        jcs @@168 ; JR   NC,@@168
		
		lda #<sfxshoot      ;Start address of sound effect data
        ldy #>sfxshoot
        ldx #07             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e
		
		; sfx shoot
        jmp LD629 ; JP   LD629

;@@168   LD   (IY+00),00
;C1BC:   RET

@@168   ldy #$00 ; LD   (IY+00),00
        lda #$00
        sta (z80_iy),y
        rts ; RET

;LC1BD   DB F8,00,08,00,00,08,00,F8

LC1BD   .he F8,00,08,00,00,08,00,F8 ; DB F8,00,08,00,00,08,00,F8

;LC1C5   CALL LC775
;C1C8:   CALL LB979
;C1CB:   LD   A,(IX+00)
;C1CE:   DEC  A
;C1CF:   CP   94
;C1D1:   JR   NZ,@@169
;C1D3:   LD   A,97
;@@169   LD   (IX+00),A
;C1D8:   LD   A,(IX+03)
;C1DB:   CP   84
;C1DD:   JR   NC,@@170
;C1DF:   LD   (IX+03),84
;C1E3:   LD   (IX+0B),00
;@@170   CALL LC206
;C1EA:   LD   A,D
;C1EB:   AND  A
;C1EC:   JP   Z,LC264
;C1EF:   LD   A,(IX+0C)
;C1F2:   AND  03
;C1F4:   JP   NZ,LC107
;C1F7:   LD   A,(IX+14)
;C1FA:   LD   (IX+09),A
;C1FD:   LD   A,(IX+15)
;C200:   LD   (IX+0A),A
;C203:   JP   LCCDE

LC1C5   jsr LC775 ; CALL LC775
        jsr LB979 ; CALL LB979
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        sec ; DEC  A
        sbc #$01
        cmp #$94 ; CP   94
        jne @@169 ; JR   NZ,@@169
        lda #$97 ; LD   A,97
@@169   ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        cmp #$84 ; CP   84
        jcs @@170 ; JR   NC,@@170
        ldy #$03 ; LD   (IX+03),84
        lda #$84
        sta (z80_ix),y
        ldy #$0B ; LD   (IX+0B),00
        lda #$00
        sta (z80_ix),y
@@170   jsr LC206 ; CALL LC206
        lda z80_d ; LD   A,D
        ; AND  A: 
        jeq LC264 ; JP   Z,LC264
        ldy #$0C ; LD   A,(IX+0C)
        lda (z80_ix),y
        and #$03 ; AND  03
        jne LC107 ; JP   NZ,LC107
        ldy #$14 ; LD   A,(IX+14)
        lda (z80_ix),y
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        ldy #$15 ; LD   A,(IX+15)
        lda (z80_ix),y
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        jmp LCCDE ; JP   LCCDE

;LC206   LD   D,01
;C208:   LD   IY,A7EF
;C20C:   CALL LC216
;C20F:   LD   A,D
;C210:   AND  A
;C211:   RET  Z
;C212:   LD   IY,A80F
;LC216   LD   A,(IY+00)
;C219:   AND  F8
;C21B:   RET  Z
;C21C:   CP   40
;LC21E   RET  Z
;C21F:   LD   A,(IY+01)
;C222:   SUB  (IX+01)
;C225:   JP   P,LC22A
;C228:   NEG
;LC22A   LD   E,A
;C22B:   LD   A,(IY+04)
;C22E:   ADD  A,(IX+04)
;C231:   ADD  A,02
;C233:   CP   E
;C234:   RET  C
;C235:   LD   A,(IX+02)
;C238:   SUB  (IY+02)
;C23B:   JP   P,LC240
;C23E:   NEG
;LC240   LD   E,A
;C241:   LD   A,(IX+05)
;C244:   ADD  A,(IY+05)
;C247:   ADD  A,02
;C249:   CP   E
;C24A:   RET  C
;C24B:   LD   A,(IX+03)
;C24E:   SUB  (IY+03)
;C251:   JP   P,LC256
;C254:   NEG
;LC256   LD   E,A
;C257:   LD   A,(IX+06)
;C25A:   ADD  A,(IY+06)
;C25D:   ADD  A,02
;C25F:   CP   E
;C260:   RET  C
;C261:   LD   D,00
;C263:   RET

LC206   lda #$01 ; LD   D,01
        sta z80_d
        lda #<LA7EF ; LD   IY,A7EF
        sta z80_iy
        lda #>LA7EF
        sta z80_iy+1
        jsr LC216 ; CALL LC216
        lda z80_d ; LD   A,D
        ; AND  A: 
        bne *+3 ; RET  Z
        rts
        lda #<LA80F ; LD   IY,A80F
        sta z80_iy
        lda #>LA80F
        sta z80_iy+1
LC216   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        and #$F8 ; AND  F8
        bne *+3 ; RET  Z
        rts
        cmp #$40 ; CP   40; 
LC21E   bne *+3 ; RET  Z
        rts
        ldy #$01 ; LD   A,(IY+01)
        lda (z80_iy),y
        ldy #$01 ; SUB  (IX+01)
        sec
        sbc (z80_ix),y
        jpl LC22A ; JP   P,LC22A
        eor #$ff ; NEG
        clc
        adc #$01; 
LC22A   sta z80_e ; LD   E,A
        ldy #$04 ; LD   A,(IY+04)
        lda (z80_iy),y
        ldy #$04 ; ADD  A,(IX+04)
        clc
        adc (z80_ix),y
        clc ; ADD  A,02
        adc #$02
        cmp z80_e ; CP   E
        bcs *+3 ; RET  C
        rts
        ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        ldy #$02 ; SUB  (IY+02)
        sec
        sbc (z80_iy),y
        jpl LC240 ; JP   P,LC240
        eor #$ff ; NEG
        clc
        adc #$01; 
LC240   sta z80_e ; LD   E,A
        ldy #$05 ; LD   A,(IX+05)
        lda (z80_ix),y
        ldy #$05 ; ADD  A,(IY+05)
        clc
        adc (z80_iy),y
        clc ; ADD  A,02
        adc #$02
        cmp z80_e ; CP   E
        bcs *+3 ; RET  C
        rts
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        ldy #$03 ; SUB  (IY+03)
        sec
        sbc (z80_iy),y
        jpl LC256 ; JP   P,LC256
        eor #$ff ; NEG
        clc
        adc #$01; 
LC256   sta z80_e ; LD   E,A
        ldy #$06 ; LD   A,(IX+06)
        lda (z80_ix),y
        ldy #$06 ; ADD  A,(IY+06)
        clc
        adc (z80_iy),y
        clc ; ADD  A,02
        adc #$02
        cmp z80_e ; CP   E
        bcs *+3 ; RET  C
        rts
        lda #$00 ; LD   D,00
        sta z80_d
        rts ; RET

;LC264   LD   A,(IY+00)
;C267:   LD   B,A
;C268:   RLCA
;C269:   RLCA
;C26A:   AND  77
;C26C:   LD   C,A
;C26D:   LD   A,B
;C26E:   RLCA
;C26F:   RLCA
;C270:   RLCA
;C271:   AND  07
;C273:   LD   B,A
;C274:   CALL LBB29
;C277:   CALL LB145
;C27A:   LD   (IY+00),40
;C27E:   SET  1,(IY+07)
;C282:   JP   LC120

LC264   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        sta z80_b ; LD   B,A
        asl @ ; RLCA
		adc #$00
        asl @ ; RLCA
		adc #$00
        and #$77 ; AND  77
        sta z80_c ; LD   C,A
        lda z80_b ; LD   A,B
        asl @ ; RLCA
        rol @ ; RLCA
        rol @ ; RLCA
		rol @
        and #$07 ; AND  07
        sta z80_b ; LD   B,A
        jsr LBB29 ; CALL LBB29
        jsr LB145 ; CALL LB145
        ldy #$00 ; LD   (IY+00),40
        lda #$40
        sta (z80_iy),y
        ldy #$07 ; SET  1,(IY+07)
        lda (z80_iy),y
        ora #_bitvalue1
        sta (z80_iy),y
        jmp LC120 ; JP   LC120

;LC285   CALL LC291
;C288:   JP   LC75F

LC285   jsr LC291 ; CALL LC291
        jmp LC75F ; JP   LC75F

;LC28B   CALL LC291
;C28E:   JP   LCCDE

LC28B   jsr LC291 ; CALL LC291
        jmp LCCDE ; JP   LCCDE

;LC291   LD   A,(IX+0D)
;C294:   OR   A0
;C296:   LD   (IX+0D),A
;C299:   RET

LC291   ldy #$0D ; LD   A,(IX+0D)
        lda (z80_ix),y
        ora #$A0 ; OR   A0
        ;ldy #$0D ; LD   (IX+0D),A
        sta (z80_ix),y
        rts ; RET

;PrintLives: ; C29A
;C29A:   LD   IX,SprInfoBuffer
;C29E:   LD   (IX+00),16
;C2A2:   LD   (IX+07),00
;C2A6:   LD   (IX+1A),10
;C2AA:   LD   (IX+1B),20
;C2AE:   CALL PrintSprite
;C2B1:   LD   A,47
;C2B3:   LD   DE,5A42
;C2B6:   LD   B,02
;C2B8:   CALL Fill_DE
;C2BB:   LD   DE,5A62
;C2BE:   LD   B,04
;C2C0:   CALL Fill_DE
;C2C3:   LD   DE,LA721
;C2C6:   LD   B,01
;C2C8:   LD   HL,DD73
;C2CB:   JP   PrintNumber

PrintLives: ; C29A
        lda #<SprInfoBuffer ; LD   IX,SprInfoBuffer
        sta z80_ix
        lda #>SprInfoBuffer
        sta z80_ix+1
        ldy #$00 ; LD   (IX+00),16
        lda #$16
        sta (z80_ix),y
        ldy #$07 ; LD   (IX+07),00
        lda #$00
        sta (z80_ix),y
        ldy #$1A ; LD   (IX+1A),10
        lda #$10
        sta (z80_ix),y
        ldy #$1B ; LD   (IX+1B),20
        lda #$20
        sta (z80_ix),y
        jsr PrintSprite ; CALL PrintSprite
        lda #$0f ; LD   A,47
        ldx #<L5A42 ; LD   DE,5A42
        stx z80_e
        ldx #>L5A42
        stx z80_d
        ldx #$02 ; LD   B,02
        stx z80_b
        jsr Fill_DE ; CALL Fill_DE
        lda #$0f ; LD   A,47
        ldx #<L5A62 ; LD   DE,5A62
        stx z80_e
        ldx #>L5A62
        stx z80_d
        ldx #$04 ; LD   B,04
        stx z80_b
        jsr Fill_DE ; CALL Fill_DE
        lda #<LA721 ; LD   DE,LA721
        sta z80_e
        lda #>LA721
        sta z80_d
        lda #$01 ; LD   B,01
        sta z80_b
        lda #<LDD73 ; LD   HL,DD73
        sta z80_l
        lda #>LDD73
        sta z80_h
        jmp PrintNumber ; JP   PrintNumber

;InitStartLocations: ; C2CE
;C2CE:   LD   HL,LC3EF
;C2D1:   LD   DE,LC3FF
;C2D4:   LD   BC,0010
;C2D7:   LDIR
;C2D9:   LD   A,(LA70D)
;C2DC:   AND  03
;C2DE:   LD   C,A
;C2DF:   LD   HL,StartLocations
;C2E2:   ADD  HL,BC
;C2E3:   LD   A,(HL)
;C2E4:   LD   (LC407),A
;C2E7:   RET

InitStartLocations: ; C2CE
        ;lda #<LC3EF ; LD   HL,LC3EF
        ;sta z80_l
        ;lda #>LC3EF
        ;sta z80_h
        ;lda #<LC3FF ; LD   DE,LC3FF
        ;sta z80_e
        ;lda #>LC3FF
        ;sta z80_d
        ;lda #<$0010 ; LD   BC,0010
        ;sta z80_c
        ;lda #>$0010
        ;sta z80_b
        ;jsr ldir ; LDIR
		ldx #$0f
InitStartLocationsLoop		
		lda LC3EF,x
		sta LC3FF,x
		dex
		bpl InitStartLocationsLoop
		
		;.ifdef START_ROOM
		
		lda START_ROOM_ON
		beq start_room_skip_01
		
		ldx START_ROOM
		jmp start_room_skip_02
		
		;.else
start_room_skip_01
        
		;lda LA70D ; LD   A,(LA70D)
        ;and #$03 ; AND  03
		;tax
		;.endif
		
		;ld_a_r
		
		lda LA70D
		and #$03
				
		tax
		
start_room_skip_02		
		
        ;sta z80_c ; LD   C,A
        ;lda #<StartLocations ; LD   HL,StartLocations
        ;sta z80_l
        ;lda #>StartLocations
        ;sta z80_h
        ;jsr add_hl_bc ; ADD  HL,BC
        ;ldy #$00 ; LD   A,(HL)
        ;lda (z80_hl),y
		lda StartLocations,x
		;lda #06
        sta LC407 ; LD   (LC407),A
        rts ; RET

;StartLocations: ; C2E8
;C2E8:   DB 33,5C,64,0C

StartLocations: ; C2E8
        .he 33,5C,64,0C ; DB 33,5C,64,0C

;NewLife LD   HL,LC3FF
;C2EF:   LD   DE,A76F
;C2F2:   PUSH DE
;C2F3:   POP  IX
;C2F5:   LD   BC,0040
;C2F8:   LDIR
;C2FA:   LD   HL,LA721
;C2FD:   DEC  (HL)
;C2FE:   JP   M,GameOver
;C301:   RET

NewLife lda #<LC3FF ; LD   HL,LC3FF
        sta z80_l
        lda #>LC3FF
        sta z80_h
        lda #<LA76F ; LD   DE,A76F
        sta z80_e
		sta z80_ix
        lda #>LA76F
        sta z80_d
		sta z80_ix+1
        ;lda z80_e ; PUSH DE
        ;pha
        ;lda z80_d
        ;pha
        ;pla ; POP  IX
        ;sta z80_ix+1
        ;pla
        ;sta z80_ix
        lda #<L0040 ; LD   BC,0040
        sta z80_c
        lda #>L0040
        sta z80_b
        jsr ldir ; LDIR
        ;lda #<LA721 ; LD   HL,LA721
        ;sta z80_l
        ;lda #>LA721
        ;sta z80_h
        ;ldy #$00 ; DEC  (HL)
        ;lda (z80_hl),y
        ;sec
        ;sbc #$01
        ;sta (z80_hl),y
		;.if CHEAT_UNLIMITED_LIVES == 0
		lda UNLIMITED_LIVES
		bne lives_cheat
		dec LA721
        jmi GameOver ; JP   M,GameOver
		;.endif
		rts
lives_cheat
	    rts ; RET

;GameCompletedMsg: ; C302
;C302:   CALL ClrWrkScr
;C305:   LD   A,45
;C307:   CALL FillAttr
;C30A:   LD   DE,LC3E9
;C30D:   EXX
;C30E:   LD   HL,LC3DD
;C311:   LD   DE,LC38B
;C314:   LD   B,06
;C316:   XOR  A
;C317:   LD   (LA734),A
;C31A:   CALL @@125
;C31D:   LD   DE,Audio5
;C320:   CALL PlayAudio

GameCompletedMsg: ; C302
        jsr ClrWrkScr ; CALL ClrWrkScr
        lda #$03 ; LD   A,45

		sta colourcode
		jsr vdc_colour_clear		
		
        ;jsr FillAttr ; CALL FillAttr
        lda #<LC3E9 ; LD   DE,LC3E9
        sta z80_e
        lda #>LC3E9
        sta z80_d
        jsr exx ; EXX
        lda #<LC3DD ; LD   HL,LC3DD
        sta z80_l
        lda #>LC3DD
        sta z80_h
        lda #<LC38B ; LD   DE,LC38B
        sta z80_e
        lda #>LC38B
        sta z80_d
        lda #$06 ; LD   B,06
        sta z80_b
        lda #$00 ; XOR  A
        sta LA734 ; LD   (LA734),A
        jsr @@125 ; CALL @@125
		
        ;lda #<Audio5 ; LD   DE,Audio5
        ;sta z80_e
        ;lda #>Audio5
        ;sta z80_d
        ;jsr PlayAudio ; CALL PlayAudio

		jsr c64WaitFrame
		
		lda #00
		sta sound_e
		
		jsr c64WaitFrame
		
		lda #02
		jsr music_on
		
		lda #200
		sta counter2
		
gamecomplete01

		jsr c64waitframe

		dec counter2
		bne gamecomplete01

		lda #200
		sta counter2
		
gamecomplete02		
		
		;jsr c64skipkey
		;lda skipkeyon
		;cmp #01
		;beq gamecomplete03
		
		jsr c64waitframe

		dec counter2
		bne gamecomplete02

gamecomplete03		
		
		lda #00
		sta counter2
		;sta skipkeyon
		
		lda #04 
        jsr music_on
		
		
;GameOver: ; C323
;C323:   CALL ClrWrkScr
;C326:   LD   A,46
;C328:   CALL FillAttr
;C32B:   CALL PrintBorder
;C32E:   LD   DE,LC35D
;C331:   EXX
;C332:   LD   HL,LC360
;C335:   LD   DE,LC366
;C338:   LD   B,03
;C33A:   CALL @@125
;C33D:   CALL LC6EA
;C340:   XOR  A
;C341:   LD   (LA734),A
;C344:   CALL UpdateScreen
;C347:   LD   DE,Audio4
;C34A:   CALL PlayAudio
;C34D:   LD   B,40
;@@172   LD   HL,2000
;@@171   DEC  HL
;C353:   LD   A,H
;C354:   OR   L
;C355:   JR   NZ,@@171
;C357:   DJNZ @@172
;C359:   POP  HL
;C35A:   JP   LAF93

GameOver: ; C323
        jsr ClrWrkScr ; CALL ClrWrkScr
        lda #$07 ; LD   A,46
		
		sta colourcode
		jsr vdc_colour_clear		
		
        ;jsr FillAttr ; CALL FillAttr
        jsr PrintBorder ; CALL PrintBorder
        lda #<LC35D ; LD   DE,LC35D
        sta z80_e
        lda #>LC35D
        sta z80_d
        jsr exx ; EXX
        lda #<LC360 ; LD   HL,LC360
        sta z80_l
        lda #>LC360
        sta z80_h
        lda #<LC366 ; LD   DE,LC366
        sta z80_e
        lda #>LC366
        sta z80_d
        lda #$03 ; LD   B,03
        sta z80_b
        jsr @@125 ; CALL @@125
        jsr LC6EA ; CALL LC6EA
        lda #$00 ; XOR  A
        sta LA734 ; LD   (LA734),A
        ;jsr c64clearcols
		jsr UpdateScreen ; CALL UpdateScreen
		
		
        ;lda #<Audio4 ; LD   DE,Audio4
        ;sta z80_e
        ;lda #>Audio4
        ;sta z80_d
        ;jsr PlayAudio ; CALL PlayAudio
        
		jsr c64WaitFrame
		
		lda #00
		sta sound_e
		
		jsr c64WaitFrame
		
		lda #03
		jsr music_on
		
		jsr c64skipkeyheld
		
		; length of pause below $40 z80_b
		lda #140 ; LD   B,40
        sta z80_b
@@172   
				
		lda #<L2000 ; LD   HL,2000
        sta z80_l
        lda #>L2000
        sta z80_h
		
;@@171   jsr dec_hl ; DEC  HL
;        lda z80_h ; LD   A,H
;        ora z80_l ; OR   L
;        jne @@171 ; JR   NZ,@@171
		
		; check if fire buttons pressed and get out if they have (to skiphere)
		jsr c64skipkey
		lda skipkeyon
		cmp #01
		beq skiphere
		
		jsr c64waitframe
		
        dec z80_b ; DJNZ @@172
        ;jne @@172
		jeq secondtime
		
		jmp @@172
		
skiphere

		jsr c64skipkeyheld
		
		lda #00
		sta skipkeyon
		sta z80_b
		sta counter2
		
		lda #04 ;song number 4 empty song no to kill sound
        jsr music_on
	
		jsr vdc_screen_clear
		
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l		
        jmp LAF93 ; JP   LAF93

secondtime
		
		inc counter2
		lda counter2
		cmp #02
		jeq skiphere
		lda #220 
        sta z80_b
		jmp @@172
	
		
;LC35D   DB 42,43,44

LC35D   .he 08,0a,07 ; DB 42,43,44

;LC360   DB 58,9F,30,6F,40,5F

LC360   .he 58,9F,30,6F,40,5F ; DB 58,9F,30,6F,40,5F

;LC366   DB 47,41,4D,45,20,4F,56,45,D2,50,45,52,43,45,4E,54
;C376:   DB 41,47,45,20,4F,46,20,51,55,45,53,D4,43,4F,4D,50
;C386:   DB 4C,45,54,45,C4

LC366   .he 47,41,4D,45,20,4F,56,45,D2,50,45,52,43,45,4E,54 ; DB 47,41,4D,45,20,4F,56,45,D2,50,45,52,43,45,4E,54
        .he 41,47,45,20,4F,46,20,51,55,45,53,D4,43,4F,4D,50 ; DB 41,47,45,20,4F,46,20,51,55,45,53,D4,43,4F,4D,50
        .he 4C,45,54,45,C4 ; DB 4C,45,54,45,C4

;LC38B   DB 43,4F,4E,47,52,41,54,55,4C,41,54,49,4F,4E,D3,59
;C39B:   DB 4F,55,20,48,41,56,45,20,43,4F,4D,50,4C,45,41,54
;C3AB:   DB 45,C4,54,48,45,20,50,45,4E,54,41,47,52,41,CD,59
;C3BB:   DB 4F,55,52,20,41,44,56,45,4E,54,55,52,C5,43,4F,4E
;C3CB:   DB 54,49,4E,55,45,53,20,49,CE,4D,49,52,45,20,4D,41
;C3DB:   DB 52,C5

LC38B   .he 43,4F,4E,47,52,41,54,55,4C,41,54,49,4F,4E,D3,59 ; DB 43,4F,4E,47,52,41,54,55,4C,41,54,49,4F,4E,D3,59
        .he 4F,55,20,48,41,56,45,20,43,4F,4D,50,4C,45,41,54 ; DB 4F,55,20,48,41,56,45,20,43,4F,4D,50,4C,45,41,54
        .he 45,C4,54,48,45,20,50,45,4E,54,41,47,52,41,CD,59 ; DB 45,C4,54,48,45,20,50,45,4E,54,41,47,52,41,CD,59
        .he 4F,55,52,20,41,44,56,45,4E,54,55,52,C5,43,4F,4E ; DB 4F,55,52,20,41,44,56,45,4E,54,55,52,C5,43,4F,4E
        .he 54,49,4E,55,45,53,20,49,CE,4D,49,52,45,20,4D,41 ; DB 54,49,4E,55,45,53,20,49,CE,4D,49,52,45,20,4D,41
        .he 52,C5 ; DB 52,C5

;LC3DD   DB 48,8F,38,6F,50,5F,48,4F,50,3F,60,1F

LC3DD   .he 48,8F,38,6F,50,5F,48,4F,50,3F,60,1F ; DB 48,8F,38,6F,50,5F,48,4F,50,3F,60,1F

;LC3E9   DB 46,45,45,42,42,43

;LC3E9   .he 46,45,45,42,42,43 ; DB 46,45,45,42,42,43
LC3E9   .he 0d,07,07,08,08,0a ; DB 46,45,45,42,42,43

;LC3EF   DB 20,80,80,80,05,05,17,5C,62,00,00,00,00,00,00,00

LC3EF   .he 20,80,80,80,05,05,17,5C,62,00,00,00,00,00,00,00 ; DB 20,80,80,80,05,05,17,5C,62,00,00,00,00,00,00,00

;LC3FF   DB 20,80,80,80,05,05,17,5C
;;LC407   DW 0062,0000,0000,0000,0000,0000,0000,0000
;;C417:   DW 0000,0000,0000,0000,8028,8C80,0505,5E00
;;C427:   DW 0001,0000,0000,0000,0000,0000,0000,0000
;;C437:   DW 0000,0000,0000,0000
;LC407   DB 62,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;C417:   DB 00,00,00,00,00,00,00,00,28,80,80,8C,05,05,00,5E
;C427:   DB 01,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;C437:   DB 00,00,00,00,00,00,00

LC3FF   .he 20,80,80,80,05,05,17,5C ; DB 20,80,80,80,05,05,17,5C
;LC407   DW 0062,0000,0000,0000,0000,0000,0000,0000
;C417:   DW 0000,0000,0000,0000,8028,8C80,0505,5E00
;C427:   DW 0001,0000,0000,0000,0000,0000,0000,0000
;C437:   DW 0000,0000,0000,0000
LC407   .he 62,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 62,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,28,80,80,8C,05,05,00,5E ; DB 00,00,00,00,00,00,00,00,28,80,80,8C,05,05,00,5E
        .he 01,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 01,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00

;LC43F   RET

LC43F   rts ; RET

;LC440   CALL LC775
;C443:   BIT  6,(IX+0D)
;C447:   JR   Z,@@173
;C449:   SET  6,(IX+2D)
;C44D:   JP   LC107

LC440   jsr LC775 ; CALL LC775
        ldy #$0D ; BIT  6,(IX+0D)
        lda (z80_ix),y
        bit _bitmem6
        jeq @@173 ; JR   Z,@@173
        ldy #$2D ; SET  6,(IX+2D)
        lda (z80_ix),y
        ora #_bitvalue6
        sta (z80_ix),y
        jmp LC107 ; JP   LC107

;@@173   CALL CheckUserInput
;C453:   XOR  A
;C454:   LD   (IX+09),A
;C457:   LD   (IX+0A),A
;C45A:   CALL LC4C8
;C45D:   CALL LC58D
;C460:   CALL LC56C
;C463:   CALL LBF79
;C466:   CALL LC4A3
;C469:   JR   NC,@@174
;LC46B   SET  1,(IX+27)
;C46F:   LD   A,(IX+03)
;C472:   CP   F0
;C474:   JR   C,@@175
;C476:   LD   (IX+03),F0
;@@175   CALL LC61D
;C47D:   CALL LC126
;C480:   RES  1,(IX+27)
;C484:   RES  0,(IX+07)
;C488:   LD   A,(IX+0C)
;C48B:   SUB  10
;C48D:   JR   C,@@176
;C48F:   LD   (IX+0C),A
;@@176   JP   LCCDE

@@173   jsr CheckUserInput ; CALL CheckUserInput
        lda #$00 ; XOR  A
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        jsr LC4C8 ; CALL LC4C8 - left/right
        jsr LC58D ; CALL LC58D - anim
        jsr LC56C ; CALL LC56C - jump
        jsr LBF79 ; CALL LBF79 - pick up
        jsr LC4A3 ; CALL LC4A3 - jump
        jcs @@174 ; JR   NC,@@174; 
LC46B   ldy #$27 ; SET  1,(IX+27)
        lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        cmp #$F0 ; CP   F0
        jcc @@175 ; JR   C,@@175
        ;ldy #$03 ; LD   (IX+03),F0
        lda #$F0
        sta (z80_ix),y
@@175   jsr LC61D ; CALL LC61D - forward
        jsr LC126 ; CALL LC126 - fire
        ldy #$27 ; RES  1,(IX+27)
        lda (z80_ix),y
        and #_notbitvalue1
        sta (z80_ix),y
        ldy #$07 ; RES  0,(IX+07)
        lda (z80_ix),y
        and #_notbitvalue0
        sta (z80_ix),y
        ldy #$0C ; LD   A,(IX+0C)
        lda (z80_ix),y
        sec ; SUB  10
        sbc #$10
        jcc @@176 ; JR   C,@@176
        ;ldy #$0C ; LD   (IX+0C),A
        sta (z80_ix),y; 
@@176   jmp LCCDE ; JP   LCCDE

;@@174   LD   A,(IX+0B)
;C498:   AND  A
;C499:   JP   M,LC46B
;C49C:   XOR  A
;C49D:   LD   (IX+0B),A
;C4A0:   JR   LC46B

@@174   ldy #$0B ; LD   A,(IX+0B)
        lda (z80_ix),y
        ; AND  A: 
        jmi LC46B ; JP   M,LC46B
        lda #$00 ; XOR  A
        ldy #$0B ; LD   (IX+0B),A
        sta (z80_ix),y
        jmp LC46B ; JR   LC46B

;LC4A2   RET

LC4A2   rts ; RET

;LC4A3   LD   HL,(LA71D)
;C4A6:   LD   A,L
;C4A7:   SUB  (IX+04)
;C4AA:   LD   L,A
;C4AB:   LD   A,H
;C4AC:   SUB  (IX+05)
;C4AF:   LD   H,A
;C4B0:   LD   A,(IX+01)
;C4B3:   SUB  80
;C4B5:   JP   P,LC4BA
;C4B8:   NEG
;LC4BA   CP   L
;C4BB:   RET  NC
;C4BC:   LD   A,(IX+02)
;C4BF:   SUB  80
;C4C1:   JP   P,LC4C6
;C4C4:   NEG
;LC4C6   CP   H
;C4C7:   RET

LC4A3   ;lda LA71D ; LD   HL,(LA71D)
        ;sta z80_l
        ;lda LA71D+1
        ;sta z80_h
        ;lda z80_l ; LD   A,L
		lda LA71D
        ldy #$04 ; SUB  (IX+04)
        sec
        sbc (z80_ix),y
        sta z80_l ; LD   L,A
        ;lda z80_h ; LD   A,H
		lda LA71D+1
        ldy #$05 ; SUB  (IX+05)
        sec
        sbc (z80_ix),y
        sta z80_h ; LD   H,A
        ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        sec ; SUB  80
        sbc #$80
        jpl LC4BA ; JP   P,LC4BA
        eor #$ff ; NEG
        clc
        adc #$01; 
LC4BA   cmp z80_l ; CP   L
        bcc *+3 ; RET  NC
        rts
        ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        sec ; SUB  80
        sbc #$80
        jpl LC4C6 ; JP   P,LC4C6
        eor #$ff ; NEG
        clc
        adc #$01; 
LC4C6   cmp z80_h ; CP   H
        rts ; RET

;LC4C8   LD   HL,ScratchMem
;C4CB:   LD   A,(HL)
;C4CC:   AND  06
;C4CE:   JR   Z,@@177
;C4D0:   BIT  3,(HL)
;C4D2:   JR   Z,@@177
;C4D4:   LD   A,(IX+0C)
;C4D7:   AND  F0
;C4D9:   RET  NZ
;C4DA:   BIT  2,(IX+0C)
;C4DE:   RET  Z
;C4DF:   BIT  0,C
;C4E1:   JR   NZ,@@178
;C4E3:   BIT  2,C
;C4E5:   JR   NZ,@@179
;@@178   BIT  1,C
;C4E9:   JR   NZ,@@180
;C4EB:   BIT  4,C
;C4ED:   JR   NZ,@@181
;C4EF:   BIT  0,C
;C4F1:   JR   NZ,@@182
;C4F3:   RES  2,C
;C4F5:   RET

LC4C8   lda #<ScratchMem ; LD   HL,ScratchMem
        sta z80_l
        lda #>ScratchMem
        sta z80_h
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        and #$06 ; AND  06
        jeq @@177 ; JR   Z,@@177
        ldy #$00 ; BIT  3,(HL)
        lda (z80_hl),y
        bit _bitmem3
        jeq @@177 ; JR   Z,@@177
        ldy #$0C ; LD   A,(IX+0C)
        lda (z80_ix),y
        and #$F0 ; AND  F0
        beq *+3 ; RET  NZ
        rts
        ldy #$0C ; BIT  2,(IX+0C)
        lda (z80_ix),y
        bit _bitmem2
        bne *+3 ; RET  Z
        rts
        lda z80_c ; BIT  0,C
        bit _bitmem0
        jne @@178 ; JR   NZ,@@178
        lda z80_c ; BIT  2,C
        bit _bitmem2
        jne @@179 ; JR   NZ,@@179
@@178   lda z80_c ; BIT  1,C
        bit _bitmem1
        jne @@180 ; JR   NZ,@@180
        lda z80_c ; BIT  4,C
        bit _bitmem4
        jne @@181 ; JR   NZ,@@181
        lda z80_c ; BIT  0,C
        bit _bitmem0
        jne @@182 ; JR   NZ,@@182
        lda z80_c ; RES  2,C
        and #_notbitvalue2
        sta z80_c
        rts ; RET

;@@179   CALL LC5BD
;C4F9:   CP   02
;@@185   JR   Z,@@183
;C4FD:   CPL
;@@186   AND  01
;C500:   JR   @@184

@@179   jsr LC5BD ; CALL LC5BD
        cmp #$02 ; CP   02; 
@@185   jeq @@183 ; JR   Z,@@183
        eor #$ff ; CPL; 
@@186   and #$01 ; AND  01
        jmp @@184 ; JR   @@184

;@@180   CALL LC5BD
;C505:   CP   01
;C507:   JR   @@185

@@180   jsr LC5BD ; CALL LC5BD
        cmp #$01 ; CP   01; 
        jmp @@185 ; JR   @@185

;@@181   CALL LC5BD
;C50C:   CP   03
;@@187   JR   Z,@@183
;C510:   JR   @@186

@@181   jsr LC5BD ; CALL LC5BD
        cmp #$03 ; CP   03; 
@@187   jeq @@183 ; JR   Z,@@183
        jmp @@186 ; JR   @@186

;@@182   CALL LC5BD
;C515:   AND  A
;C516:   JR   @@187

@@182   jsr LC5BD ; CALL LC5BD
        ; AND  A: 
        jmp @@187 ; JR   @@187

;@@183   SET  2,C
;C51A:   RET

@@183   lda z80_c ; SET  2,C
        ora #_bitvalue2
        sta z80_c
        rts ; RET

;@@177   LD   A,(IX+0D)
;C51E:   AND  07
;C520:   JR   Z,@@188
;C522:   DEC  (IX+0D)
;C525:   RET

@@177   ldy #$0D ; LD   A,(IX+0D)
        lda (z80_ix),y
        and #$07 ; AND  07
        jeq @@188 ; JR   Z,@@188
        ldy #$0D ; DEC  (IX+0D)
        lda (z80_ix),y
        sec
        sbc #$01
        sta (z80_ix),y
        rts ; RET

;@@188   LD   A,C
;C527:   AND  03
;C529:   RET  Z
;C52A:   LD   A,(IX+0C)
;C52D:   AND  F0
;C52F:   RET  NZ
;C530:   BIT  3,(IX+0C)
;C534:   RET  NZ
;C535:   BIT  2,C
;C537:   JR   NZ,@@189
;@@189   LD   A,(IX+0D)
;C53C:   OR   02
;C53E:   LD   (IX+0D),A
;C541:   BIT  1,C
;@@184   JR   NZ,@@190
;C545:   BIT  6,(IX+07)
;C549:   JR   Z,@@191
;@@192   LD   A,(IX+00)
;C54E:   XOR  04
;C550:   LD   (IX+00),A
;@@191   LD   A,(IX+07)
;C556:   XOR  40
;C558:   LD   (IX+07),A
;C55B:   LD   A,(IX+00)
;C55E:   ADD  A,08
;C560:   LD   (IX+20),A
;C563:   RET

@@188   lda z80_c ; LD   A,C
        and #$03 ; AND  03
        bne *+3 ; RET  Z
        rts
        ldy #$0C ; LD   A,(IX+0C)
        lda (z80_ix),y
        and #$F0 ; AND  F0
        beq *+3 ; RET  NZ
        rts
        ldy #$0C ; BIT  3,(IX+0C)
        lda (z80_ix),y
        bit _bitmem3
        beq *+3 ; RET  NZ
        rts
        lda z80_c ; BIT  2,C
        bit _bitmem2
        jne @@189 ; JR   NZ,@@189
@@189   ldy #$0D ; LD   A,(IX+0D)
        lda (z80_ix),y
        ora #$02 ; OR   02
        ldy #$0D ; LD   (IX+0D),A
        sta (z80_ix),y
        lda z80_c ; BIT  1,C
        bit _bitmem1
@@184   jne @@190 ; JR   NZ,@@190
        ldy #$07 ; BIT  6,(IX+07)
        lda (z80_ix),y
        bit _bitmem6
        jeq @@191 ; JR   Z,@@191
@@192   ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        eor #$04 ; XOR  04
        ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y
@@191   ldy #$07 ; LD   A,(IX+07)
        lda (z80_ix),y
        eor #$40 ; XOR  40
        ldy #$07 ; LD   (IX+07),A
        sta (z80_ix),y
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        clc ; ADD  A,08
        adc #$08
        ldy #$20 ; LD   (IX+20),A
        sta (z80_ix),y
        rts ; RET

;@@190   BIT  6,(IX+07)
;C568:   JR   Z,@@192
;C56A:   JR   @@191

@@190   ldy #$07 ; BIT  6,(IX+07)
        lda (z80_ix),y
        bit _bitmem6
        jeq @@192 ; JR   Z,@@192
        jmp @@191 ; JR   @@191

;LC56C   BIT  3,C
;C56E:   RET  Z
;C56F:   LD   A,(IX+0C)
;C572:   AND  F0
;C574:   RET  NZ
;C575:   BIT  3,(IX+0C)
;C579:   RET  NZ
;C57A:   BIT  2,(IX+0C)
;C57E:   RET  Z
;C57F:   SET  3,(IX+0C)
;C583:   LD   (IX+0B),08
;C587:   PUSH BC
;C588:   CALL LD5E4
;C58B:   POP  BC
;C58C:   RET

LC56C   lda z80_c ; BIT  3,C
        bit _bitmem3
        bne *+3 ; RET  Z
        rts
        ldy #$0C ; LD   A,(IX+0C)
        lda (z80_ix),y
        and #$F0 ; AND  F0
        beq *+3 ; RET  NZ
        rts
        ldy #$0C ; BIT  3,(IX+0C)
        lda (z80_ix),y
        bit _bitmem3
        beq *+3 ; RET  NZ
        rts
        ldy #$0C ; BIT  2,(IX+0C)
        lda (z80_ix),y
        bit _bitmem2
        bne *+3 ; RET  Z
        rts
        ldy #$0C ; SET  3,(IX+0C)
        lda (z80_ix),y
        ora #_bitvalue3
        sta (z80_ix),y
        ldy #$0B ; LD   (IX+0B),08
        lda #$08
        sta (z80_ix),y
        lda z80_c ; PUSH BC
        pha
	
        lda z80_b
        pha

		lda #<sfxjump      ;Start address of sound effect data
        ldy #>sfxjump
        ldx #14             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e         
		
		;jsr LD5E4 ; CALL LD5E4
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        rts ; RET
			
		; sfx jump
        ;jsr LD5E4 ; CALL LD5E4
        
		;pla ; POP  BC
        ;sta z80_b
        ;pla
        ;sta z80_c
        ;rts ; RET

;LC58D   LD   A,(IX+0C)
;C590:   AND  F0
;C592:   JR   NZ,@@193
;C594:   BIT  3,(IX+0C)
;C598:   JR   NZ,@@193
;C59A:   BIT  2,C
;C59C:   JR   Z,@@194
;@@193   LD   A,(IX+00)
;C5A1:   LD   E,A
;C5A2:   INC  A
;C5A3:   AND  03
;C5A5:   LD   D,A
;C5A6:   LD   A,E
;C5A7:   AND  FC
;C5A9:   OR   D
;C5AA:   LD   (IX+00),A
;C5AD:   PUSH BC
;C5AE:   CALL LD635
;C5B1:   POP  BC
;C5B2:   RET

LC58D   ldy #$0C ; LD   A,(IX+0C)
        lda (z80_ix),y
        and #$F0 ; AND  F0
        jne @@193 ; JR   NZ,@@193
        ldy #$0C ; BIT  3,(IX+0C)
        lda (z80_ix),y
        bit _bitmem3
        jne @@193 ; JR   NZ,@@193
        lda z80_c ; BIT  2,C
        bit _bitmem2
        jeq @@194 ; JR   Z,@@194
@@193   ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        sta z80_e ; LD   E,A
        clc ; INC  A
        adc #$01
        and #$03 ; AND  03
        sta z80_d ; LD   D,A
        lda z80_e ; LD   A,E
        and #$FC ; AND  FC
        ora z80_d ; OR   D
        ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        jsr LD635 ; CALL LD635
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        rts ; RET

;@@194   LD   A,(IX+00)
;C5B6:   AND  03
;C5B8:   CP   02
;C5BA:   RET  Z
;C5BB:   JR   @@193

@@194   ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        and #$03 ; AND  03
        cmp #$02 ; CP   02
        bne *+3 ; RET  Z
        rts
        jmp @@193 ; JR   @@193

;LC5BD   LD   A,(IX+07)
;C5C0:   RRCA
;C5C1:   RRCA
;C5C2:   RRCA
;C5C3:   AND  08
;C5C5:   XOR  08
;C5C7:   LD   L,A
;C5C8:   LD   A,(IX+00)
;C5CB:   AND  04
;C5CD:   OR   L
;C5CE:   RRCA
;C5CF:   RRCA
;C5D0:   AND  03
;C5D2:   RET

LC5BD   ldy #$07 ; LD   A,(IX+07)
        lda (z80_ix),y
        lsr @ ; RRCA 
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$08 ; AND  08
        eor #$08 ; XOR  08
        sta z80_l ; LD   L,A
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        and #$04 ; AND  04
        ora z80_l ; OR   L
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$03 ; AND  03
        rts ; RET

;LC5D3   CALL LC764
;C5D6:   BIT  6,(IX+0D)
;C5DA:   JP   NZ,LC107
;C5DD:   PUSH IX
;C5DF:   POP  DE
;C5E0:   LD   HL,FFE0
;C5E3:   ADD  HL,DE
;C5E4:   PUSH HL
;C5E5:   POP  IY
;C5E7:   INC  DE
;C5E8:   INC  HL
;C5E9:   LD   BC,0007
;C5EC:   LDIR
;C5EE:   LD   (IX+06),00
;C5F2:   SET  1,(IX+07)
;C5F6:   LD   A,(IX+0D)
;C5F9:   AND  0F
;C5FB:   JR   Z,@@195
;C5FD:   DEC  (IX+0D)
;C600:   JR   @@196

LC5D3   jsr LC764 ; CALL LC764
        ldy #$0D ; BIT  6,(IX+0D)
        lda (z80_ix),y
        bit _bitmem6
        jne LC107 ; JP   NZ,LC107
        ;lda z80_ix ; PUSH IX
        ;pha
        ;lda z80_ix+1
        ;pha
        ;pla ; POP  DE
        ;sta z80_d
        ;pla
        ;sta z80_e
        ;lda #<LFFE0 ; LD   HL,FFE0
        ;sta z80_l
        ;lda #>LFFE0
        ;sta z80_h
        ;jsr add_hl_de ; ADD  HL,DE
        ;lda z80_l ; PUSH HL
        ;pha
        ;lda z80_h
        ;pha
        ;pla ; POP  IY
        ;sta z80_iy+1
        ;pla
        ;sta z80_iy
		lda z80_ix
		clc
		adc #$e0
		sta z80_iy
		lda z80_ix+1
		adc #$ff
		sta z80_iy+1
        ;inc z80_e ; INC  DE
        ;bne *+4
        ;inc z80_d
        ;inc z80_l ; INC  HL
        ;bne *+4
        ;inc z80_h
        ;lda #<$0007 ; LD   BC,0007
        ;sta z80_c
        ;lda #>$0007
        ;sta z80_b
        ;jsr ldir ; LDIR
		ldy #1
		ldx #$7
LC5D3_loop		
		lda (z80_iy),y
		sta (z80_ix),y
		iny
		dex
		bne LC5D3_loop
        ldy #$06 ; LD   (IX+06),00
        lda #$00
        sta (z80_ix),y
        ldy #$07 ; SET  1,(IX+07)
        lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
        ldy #$0D ; LD   A,(IX+0D)
        lda (z80_ix),y
        and #$0F ; AND  0F
        jeq @@195 ; JR   Z,@@195
        ;ldy #$0D ; DEC  (IX+0D)
        ;lda (z80_ix),y
        sec
        sbc #$01
        sta (z80_ix),y
        jmp @@196 ; JR   @@196

;@@195   LD   A,(IY+00)
;C605:   ADD  A,08
;C607:   LD   (IX+00),A
;@@196   LD   A,(IY+00)
;C60D:   AND  04
;C60F:   XOR  04
;C611:   ADD  A,08
;C613:   ADD  A,(IY+03)
;C616:   LD   (IX+03),A
;C619:   CALL LB9A7
;C61C:   RET

@@195   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        clc ; ADD  A,08
        adc #$08
        ;ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y
@@196   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        and #$04 ; AND  04
        eor #$04 ; XOR  04
        clc ; ADD  A,08
        adc #$08
        ldy #$03 ; ADD  A,(IY+03)
        clc
        adc (z80_iy),y
        ;ldy #$03 ; LD   (IX+03),A
        sta (z80_ix),y
        jsr LB9A7 ; CALL LB9A7
        rts ; RET

;LC61D   BIT  3,(IX+0C)
;C621:   JR   NZ,@@197
;C623:   LD   A,(IX+0C)
;C626:   AND  F0
;C628:   JR   NZ,@@197
;C62A:   BIT  2,C
;C62C:   JR   Z,@@198
;@@197   PUSH BC
;C62F:   CALL LC66A
;C632:   POP  BC
;@@198   LD   A,(IX+0B)
;C636:   AND  A
;C637:   JP   M,LC63E
;C63A:   BIT  3,C
;C63C:   JR   NZ,@@199
;LC63E   DEC  A
;@@199   DEC  A
;C640:   LD   (IX+0B),A
;C643:   LD   (LA739),A
;C646:   ADD  A,02
;C648:   CALL LB6ED
;C64B:   CALL LC6B5
;C64E:   CALL LB97F
;C651:   BIT  2,(IX+0C)
;C655:   JR   Z,@@200
;C657:   LD   A,(LA739)
;C65A:   AND  A
;C65B:   JP   P,@@200
;C65E:   RES  3,(IX+0C)
;@@200   XOR  A
;C663:   LD   (IX+09),A
;C666:   LD   (IX+0A),A
;C669:   RET

LC61D   ldy #$0C ; BIT  3,(IX+0C)
        lda (z80_ix),y
        bit _bitmem3
        jne @@197 ; JR   NZ,@@197
        ldy #$0C ; LD   A,(IX+0C)
        lda (z80_ix),y
        and #$F0 ; AND  F0
        jne @@197 ; JR   NZ,@@197
        lda z80_c ; BIT  2,C
        bit _bitmem2
        jeq @@198 ; JR   Z,@@198
@@197   lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        jsr LC66A ; CALL LC66A
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
@@198   ldy #$0B ; LD   A,(IX+0B)
        lda (z80_ix),y
        ; AND  A: 
		tax
        jmi LC63E ; JP   M,LC63E
        lda z80_c ; BIT  3,C
        bit _bitmem3
        jne @@199 ; JR   NZ,@@199
LC63E   dex ; DEC A

@@199   
		
		lda MEGA_JUMP
		bne megajumpon

		dex ; DEC A   ;remove for mega jump

megajumpon		
		
		txa
        ldy #$0B ; LD   (IX+0B),A
        sta (z80_ix),y
        sta LA739 ; LD   (LA739),A
        clc ; ADD  A,02
        adc #$02
        jsr LB6ED ; CALL LB6ED
        jsr LC6B5 ; CALL LC6B5
        jsr LB97F ; CALL LB97F
        ldy #$0C ; BIT  2,(IX+0C)
        lda (z80_ix),y
        bit _bitmem2
        jeq @@200 ; JR   Z,@@200
        lda LA739 ; LD   A,(LA739)
        ; AND  A
        jpl @@200 ; JP   P,@@200
        ldy #$0C ; RES  3,(IX+0C)
        lda (z80_ix),y
        and #_notbitvalue3
        sta (z80_ix),y
@@200   lda #$00 ; XOR  A
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        rts ; RET

;LC66A   LD   A,(IX+09)
;C66D:   ADD  A,(IX+0E)
;C670:   LD   (IX+09),A
;C673:   LD   A,(IX+0A)
;C676:   ADD  A,(IX+0F)
;C679:   LD   (IX+0A),A
;C67C:   XOR  A
;C67D:   LD   (IX+0E),A
;C680:   LD   (IX+0F),A
;C683:   LD   BC,JumpTable3
;LC686   CALL LC5BD
;C689:   LD   L,A
;C68A:   JP   RoutineDispatch

LC66A   ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        ldy #$0E ; ADD  A,(IX+0E)
        clc
        adc (z80_ix),y
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        ldy #$0A ; LD   A,(IX+0A)
        lda (z80_ix),y
        ldy #$0F ; ADD  A,(IX+0F)
        clc
        adc (z80_ix),y
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        lda #$00 ; XOR  A
        ldy #$0E ; LD   (IX+0E),A
        sta (z80_ix),y
        ldy #$0F ; LD   (IX+0F),A
        sta (z80_ix),y
        lda #<JumpTable3 ; LD   BC,JumpTable3
        sta z80_c
        lda #>JumpTable3
        sta z80_b
LC686   jsr LC5BD ; CALL LC5BD
        sta z80_l ; LD   L,A
        jmp RoutineDispatch ; JP   RoutineDispatch

;JumpTable3: ; C68D
;C68D:   DW LC695,LC69E,LC6A5,LC6AE

JumpTable3: ; C68D
        .wo LC695,LC69E,LC6A5,LC6AE ; DW LC695,LC69E,LC6A5,LC6AE

;LC695   LD   A,(IX+09)
;C698:   ADD  A,FD
;@@201   LD   (IX+09),A
;C69D:   RET

LC695   ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        clc ; ADD  A,FD
        adc #$FD
@@201   ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        rts ; RET

;LC69E   LD   A,(IX+09)
;C6A1:   ADD  A,03
;C6A3:   JR   @@201

LC69E   ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        clc ; ADD  A,03
        adc #$03
        jmp @@201 ; JR   @@201

;LC6A5   LD   A,(IX+0A)
;C6A8:   ADD  A,03
;@@202   LD   (IX+0A),A
;C6AD:   RET

LC6A5   ldy #$0A ; LD   A,(IX+0A)
        lda (z80_ix),y
        clc ; ADD  A,03
        adc #$03
@@202   ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        rts ; RET

;LC6AE   LD   A,(IX+0A)
;C6B1:   ADD  A,FD
;C6B3:   JR   @@202

LC6AE   ldy #$0A ; LD   A,(IX+0A)
        lda (z80_ix),y
        clc ; ADD  A,FD
        adc #$FD
        jmp @@202 ; JR   @@202

;LC6B5   RET

LC6B5   rts ; RET



;DisplayLocation: ; C6B6
;C6B6:   LD   IX,A76F
;C6BA:   CALL ClrWrkScr
;C6BD:   CALL RetrieveScreen
;C6C0:   CALL LCA82
;C6C3:   CALL LC6CC
;C6C6:   LD   A,01
;C6C8:   LD   (LA711),A
;C6CB:   RET

DisplayLocation: ; C6B6
        lda #<LA76F ; LD   IX,A76F
        sta z80_ix
        lda #>LA76F
        sta z80_ix+1
        jsr ClrWrkScr ; CALL ClrWrkScr
        jsr RetrieveScreen ; CALL RetrieveScreen
        jsr LCA82 ; CALL LCA82
        jsr LC6CC ; CALL LC6CC
        lda #$01 ; LD   A,01
        sta LA711 ; LD   (LA711),A
        rts ; RET

;LC6CC   LD   A,(IX+08)
;C6CF:   RRA
;C6D0:   RRA
;C6D1:   RRA
;C6D2:   AND  1F
;C6D4:   LD   E,A
;C6D5:   LD   A,(IX+08)
;C6D8:   AND  07
;C6DA:   LD   B,A
;C6DB:   INC  B
;C6DC:   XOR  A
;C6DD:   SCF
;@@203   RRA
;C6DF:   DJNZ @@203
;C6E1:   LD   D,00
;C6E3:   LD   HL,A74F
;C6E6:   ADD  HL,DE
;C6E7:   OR   (HL)
;C6E8:   LD   (HL),A
;C6E9:   RET

LC6CC   ldy #$08 ; LD   A,(IX+08)
        lda (z80_ix),y
        ror @ ; RRA
        ror @ ; RRA
        ror @ ; RRA
        and #$1F ; AND  1F
        sta z80_e ; LD   E,A
        ldy #$08 ; LD   A,(IX+08)
        lda (z80_ix),y
        and #$07 ; AND  07
        sta z80_b ; LD   B,A
        inc z80_b ; INC  B
        lda #$00 ; XOR  A
        sec ; SCF
@@203   ror @ ; RRA; 
        dec z80_b ; DJNZ @@203
        jne @@203
		pha
        lda #$00 ; LD   D,00
        sta z80_d
        lda #<LA74F ; LD   HL,A74F
        sta z80_l
        lda #>LA74F
        sta z80_h
        jsr add_hl_de ; ADD  HL,DE
		pla
        ldy #$00 ; OR   (HL)
        ora (z80_hl),y; 
        ldy #$00 ; LD   (HL),A
        sta (z80_hl),y
        rts ; RET

;LC6EA   LD   HL,A74F
;C6ED:   LD   C,1F
;C6EF:   LD   E,00
;@@206   LD   B,08
;C6F3:   LD   A,(HL)
;@@205   RRA
;C6F5:   JR   NC,@@204
;C6F7:   INC  E
;@@204   DJNZ @@205
;C6FA:   INC  HL
;C6FB:   DEC  C
;C6FC:   JR   NZ,@@206
;C6FE:   SRL  E
;C700:   LD   A,E
;C701:   CP   36
;C703:   JR   C,@@207
;C705:   LD   E,36
;@@207   LD   A,(LA74C)
;C70A:   ADD  A,A
;C70B:   ADD  A,A
;C70C:   ADD  A,E
;C70D:   LD   E,A
;C70E:   LD   A,(LA74B)
;C711:   ADD  A,A
;C712:   LD   D,A
;C713:   ADD  A,A
;C714:   ADD  A,D
;C715:   ADD  A,E
;C716:   LD   B,A
;C717:   XOR  A
;@@208   ADD  A,01
;C71A:   DAA
;C71B:   DJNZ @@208
;C71D:   LD   (LA74E),A
;C720:   LD   A,00
;C722:   ADC  A,00
;C724:   LD   (LA74D),A
;C727:   EX   AF,AF'
;C728:   LD   BC,5F90
;C72B:   CALL BCtoScrAdr
;C72E:   LD   L,C
;C72F:   LD   H,B
;C730:   EX   AF,AF'
;C731:   LD   DE,LA74D
;C734:   LD   B,01
;C736:   AND  A
;C737:   JR   Z,@@209
;C739:   INC  B
;C73A:   PUSH HL
;C73B:   LD   HL,Font
;C73E:   LD   (LA732),HL
;C741:   POP  HL
;C742:   JP   LBB5A

LC6EA
		lda #<LA74F ; LD   HL,A74F
        sta z80_l

        lda #>LA74F
        sta z80_h
			
        lda #$1F ; LD   C,1F
        sta z80_c
        lda #$00 ; LD   E,00
        sta z80_e
@@206   lda #$08 ; LD   B,08
        sta z80_b
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
@@205   ror @ ; RRA
        jcc @@204 ; JR   NC,@@204
        inc z80_e ; INC  E
@@204   dec z80_b ; DJNZ @@205

        jne @@205
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        dec z80_c ; DEC  C
				
        jne @@206 ; JR   NZ,@@206
		
		lda z80_e	; fix first screen only percentage
		cmp #01		;
		bne @@207b	;
		inc z80_e	;	
@@207b				;

        lsr z80_e ; SRL  E
        lda z80_e ; LD   A,E
        		
		cmp #$36 ; CP   36
        jcc @@207 ; JR   C,@@207
        lda #$36 ; LD   E,36
        sta z80_e
@@207   lda LA74C ; LD   A,(LA74C)
        asl @ ; ADD  A,A
        asl @ ; ADD  A,A
        clc ; ADD  A,E
        adc z80_e
        sta z80_e ; LD   E,A
        lda LA74B ; LD   A,(LA74B)
        asl @ ; ADD  A,A
        sta z80_d ; LD   D,A
        asl @ ; ADD  A,A
        clc ; ADD  A,D
        adc z80_d
        clc ; ADD  A,E
        adc z80_e
        sta z80_b ; LD   B,A
        lda #$00 ; XOR  
		sed
@@208   clc ; ADD  A,01
        adc #$01
        ; DAA
        dec z80_b ; DJNZ @@208
        jne @@208
		cld
        sta LA74E ; LD   (LA74E),A; 
        lda #$00 ; LD   A,00
        adc #$00 ; ADC  A,00
        sta LA74D ; LD   (LA74D),A
        ldx z80_ap ; EX   AF,AF'
        sta z80_ap
        txa ; 
        lda #<L5F90 ; LD   BC,5F90
        sta z80_c
        lda #>L5F90
        sta z80_b
        jsr BCtoScrAdr ; CALL BCtoScrAdr
        lda z80_c ; LD   L,C
        sta z80_l
        lda z80_b ; LD   H,B
        sta z80_h
        ldx z80_ap ; EX   AF,AF'
        sta z80_ap
        txa ; 
		tax
        lda #<LA74D ; LD   DE,LA74D
        sta z80_e
        lda #>LA74D
        sta z80_d
        lda #$01 ; LD   B,01
        sta z80_b
		txa
        ; AND  A
        jeq @@209 ; JR   Z,@@209
        inc z80_b ; INC  B
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda #<Font ; LD   HL,Font
        sta z80_l
        lda #>Font
        sta z80_h
        lda z80_l ; LD   (LA732),HL
        sta LA732
        lda z80_h
        sta LA732+1
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        jmp LBB5A ; JP   LBB5A

;@@209   INC  HL
;C746:   INC  DE
;C747:   JP   PrintNumber

@@209   inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
        jmp PrintNumber ; JP   PrintNumber

;LC74A   RET

LC74A   rts ; RET

;LC74B   LD   HL,00F8
;C74E:   JR   @@210

LC74B   lda #<L00F8 ; LD   HL,00F8
        ;sta z80_l
        ldx #>L00F8
        ;sta z80_h
        jmp @@210_v2 ; JR   @@210

;LC750   LD   HL,F4FC
;C753:   JR   @@210

LC750   lda #<LF4FC ; LD   HL,F4FC
        ;sta z80_l
        ldx #>LF4FC
        ;sta z80_h
        jmp @@210_v2 ; JR   @@210

;LC755   LD   HL,FCDC
;C758:   JR   @@210

LC755   lda #<LFCDC ; LD   HL,FCDC
        ;sta z80_l
        ldx #>LFCDC
        ;sta z80_h
        jmp @@210_v2 ; JR   @@210

;LC75A   LD   HL,F8EC
;C75D:   JR   @@210

LC75A   lda #<LF8EC ; LD   HL,F8EC
        ;sta z80_l
        ldx #>LF8EC
        ;sta z80_h
        jmp @@210_v2 ; JR   @@210

;LC75F   LD   HL,F8F0
;C762:   JR   @@210

LC75F   lda #<LF8F0 ; LD   HL,F8F0
        ;sta z80_l
        ldx #>LF8F0
        ;sta z80_h
        jmp @@210_v2 ; JR   @@210

;LC764   LD   HL,F8F4
;C767:   JR   @@210

LC764   lda #<LF8F4 ; LD   HL,F8F4
        ;sta z80_l
        ldx #>LF8F4
        ;sta z80_h
        jmp @@210_v2 ; JR   @@210

;LC769   LD   HL,F4F0
;C76C:   JR   @@210

LC769   lda #<LF4F0 ; LD   HL,F4F0
        ;sta z80_l
        ldx #>LF4F0
        ;sta z80_h
        jmp @@210_v2 ; JR   @@210

;@@210   LD   (IX+12),L
;C771:   LD   (IX+13),H
;C774:   RET

@@210   ldy #$12 ; LD   (IX+12),L
        lda z80_l
        sta (z80_ix),y
        ldy #$13 ; LD   (IX+13),H
        lda z80_h
        sta (z80_ix),y
        rts ; RET

@@210_v2
		ldy #$12 ; LD   (IX+12),L
        ;lda z80_l
        sta (z80_ix),y
        ;ldy #$13 ; LD   (IX+13),H
		iny
        ;lda z80_h
		txa
        sta (z80_ix),y
        rts ; RET

;LC775   LD   HL,FAF4
;C778:   JR   @@210

LC775   lda #<LFAF4 ; LD   HL,FAF4
        ;sta z80_l
        ldx #>LFAF4
        ;sta z80_h
        jmp @@210_v2 ; JR   @@210

;LC77A   LD   HL,FCF4
;C77D:   JR   @@210

LC77A   lda #<LFCF4 ; LD   HL,FCF4
        ;sta z80_l
        ldx #>LFCF4
        ;sta z80_h
        jmp @@210_v2 ; JR   @@210

;LC77F   LD   HL,FCF8
;C782:   JR   @@210

LC77F   lda #<LFCF8 ; LD   HL,FCF8
        ;sta z80_l
        ldx #>LFCF8
        ;sta z80_h
        jmp @@210_v2 ; JR   @@210

;LC784   LD   HL,FEF8
;C787:   JR   @@210

LC784   lda #<LFEF8 ; LD   HL,FEF8
        ;sta z80_l
        ldx #>LFEF8
        ;sta z80_h
        jmp @@210_v2 ; JR   @@210

;LC789   BIT  6,(IX+07)
;C78D:   JR   NZ,@@211
;C78F:   LD   A,(IX+00)
;C792:   CP   09
;C794:   JR   Z,@@212
;C796:   LD   HL,FBF9
;C799:   JP   @@210

LC789   ldy #$07 ; BIT  6,(IX+07)
        lda (z80_ix),y
        bit _bitmem6
        jne @@211 ; JR   NZ,@@211
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        cmp #$09 ; CP   09
        jeq @@212 ; JR   Z,@@212
        lda #<LFBF9 ; LD   HL,FBF9
        ;sta z80_l
        ldx #>LFBF9
        ;sta z80_h
        jmp @@210_v2 ; JP   @@210

;@@211   LD   HL,FCF9
;C79F:   JP   @@210

@@211   lda #<LFCF9 ; LD   HL,FCF9
        ;sta z80_l
        ldx #>LFCF9
        ;sta z80_h
        jmp @@210_v2 ; JP   @@210

;@@212   LD   HL,FBF0
;C7A5:   JP   @@210

@@212   lda #<LFBF0 ; LD   HL,FBF0
        ;sta z80_l
        ldx #>LFBF0
        ;sta z80_h
        jmp @@210_v2 ; JP   @@210

;LC7A8   LD   HL,FBF8
;C7AB:   JR   @@213

LC7A8   lda #<LFBF8 ; LD   HL,FBF8
        ;sta z80_l
        ldx #>LFBF8
        ;sta z80_h
        jmp @@213 ; JR   @@213

;LC7AD   BIT  6,(IX+07)
;C7B1:   JR   NZ,@@214
;C7B3:   LD   A,(IX+00)
;C7B6:   CP   08
;C7B8:   JR   Z,LC7A8
;C7BA:   LD   HL,FBFB
;@@213   CALL @@210
;C7C0:   LD   A,(IX+02)
;C7C3:   ADD  A,0D
;C7C5:   LD   (IX+0A),A
;C7C8:   LD   A,(IX+01)
;C7CB:   LD   (IX+09),A
;C7CE:   LD   HL,060F
;@@216   LD   A,(IX+03)
;C7D4:   LD   (IX+0B),A
;C7D7:   CALL LC802
;C7DA:   JP   LC8D2

LC7AD   ldy #$07 ; BIT  6,(IX+07)
        lda (z80_ix),y
        bit _bitmem6
        jne @@214 ; JR   NZ,@@214
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        cmp #$08 ; CP   08
        jeq LC7A8 ; JR   Z,LC7A8
        lda #<LFBFB ; LD   HL,FBFB
        ;sta z80_l
        ldx #>LFBFB
        ;sta z80_h
@@213   jsr @@210_v2 ; CALL @@210
        ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        clc ; ADD  A,0D
        adc #$0D
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        lda #<L060F ; LD   HL,060F
        sta z80_l
        lda #>L060F
        sta z80_h
@@216   ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        ldy #$0B ; LD   (IX+0B),A
        sta (z80_ix),y
        jsr LC802 ; CALL LC802
        jmp LC8D2 ; JP   LC8D2

;@@214   LD   A,(IX+00)
;C7E0:   CP   08
;C7E2:   JR   Z,@@215
;C7E4:   LD   HL,FAEF
;@@217   CALL @@210
;C7EA:   LD   A,(IX+01)
;C7ED:   SUB  0D
;C7EF:   LD   (IX+09),A
;C7F2:   LD   A,(IX+02)
;C7F5:   LD   (IX+0A),A
;C7F8:   LD   HL,0F06
;C7FB:   JR   @@216

@@214   ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        cmp #$08 ; CP   08
        jeq @@215 ; JR   Z,@@215
        lda #<LFAEF ; LD   HL,FAEF
        sta z80_l
        lda #>LFAEF
        sta z80_h
@@217   jsr @@210 ; CALL @@210
        ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        sec ; SUB  0D
        sbc #$0D
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        lda #<L0F06 ; LD   HL,0F06
        sta z80_l
        lda #>L0F06
        sta z80_h
        jmp @@216 ; JR   @@216

;@@215   LD   HL,FBF0
;C800:   JR   @@217

@@215   lda #<LFBF0 ; LD   HL,FBF0
        sta z80_l
        lda #>LFBF0
        sta z80_h
        jmp @@217 ; JR   @@217

;LC802   LD   IY,A76F
;C806:   LD   A,(IY+00)
;C809:   SUB  10
;C80B:   CP   20
;C80D:   RET  NC
;C80E:   BIT  3,(IY+07)
;C812:   RET  Z
;C813:   CALL LC8AD
;C816:   RET  NC
;C817:   SET  0,(IY+07)
;C81B:   LD   BC,JumpTable4
;C81E:   LD   HL,(LA71D)
;C821:   PUSH HL
;C822:   LD   A,(IY+07)
;C825:   RRCA
;C826:   RRCA
;C827:   RRCA
;C828:   AND  08
;C82A:   XOR  08
;C82C:   LD   L,A
;C82D:   LD   A,(IY+00)
;C830:   AND  04
;C832:   OR   L
;C833:   RRCA
;C834:   RRCA
;C835:   AND  03
;C837:   LD   L,A
;C838:   JP   RoutineDispatch

LC802   lda #<LA76F ; LD   IY,A76F
        sta z80_iy
        lda #>LA76F
        sta z80_iy+1
        ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        sec ; SUB  10
        sbc #$10
        cmp #$20 ; CP   20
        bcc *+3 ; RET  NC
        rts
        ldy #$07 ; BIT  3,(IY+07)
        lda (z80_iy),y
        bit _bitmem3
        bne *+3 ; RET  Z
        rts
        jsr LC8AD ; CALL LC8AD
        bcc *+3 ; RET  NC
        rts; 
        ldy #$07 ; SET  0,(IY+07)
        lda (z80_iy),y
        ora #_bitvalue0
        sta (z80_iy),y
        lda #<JumpTable4 ; LD   BC,JumpTable4
        sta z80_c
        lda #>JumpTable4
        sta z80_b
        lda LA71D ; LD   HL,(LA71D)
        sta z80_l
        lda LA71D+1
        sta z80_h
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        ldy #$07 ; LD   A,(IY+07)
        lda (z80_iy),y
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$08 ; AND  08
        eor #$08 ; XOR  08
        sta z80_l ; LD   L,A
        ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        and #$04 ; AND  04
        ora z80_l ; OR   L
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$03 ; AND  03
        sta z80_l ; LD   L,A
        jmp RoutineDispatch ; JP   RoutineDispatch

;JumpTable4: ; C83B
;C83B:   DW LC843,LC874,LC887,LC89A

JumpTable4: ; C83B
        .wo LC843,LC874,LC887,LC89A ; DW LC843,LC874,LC887,LC89A

;LC843   POP  HL
;C844:   LD   A,80
;C846:   SUB  L
;C847:   LD   L,A
;C848:   LD   A,(IY+01)
;C84B:   ADD  A,(IY+04)
;C84E:   CP   L
;C84F:   RET  NC
;C850:   LD   (IY+01),00
;@@218   LD   A,(IX+08)
;C857:   LD   (IY+08),A
;C85A:   LD   A,(IY+0C)
;C85D:   OR   30
;C85F:   LD   (IY+0C),A
;C862:   PUSH IY
;C864:   POP  HL
;C865:   LD   DE,LC3FF
;C868:   LD   BC,0040
;C86B:   LDIR
;C86D:   INC  SP
;C86E:   INC  SP
;C86F:   INC  SP
;C870:   INC  SP
;C871:   JP   LAFC8

LC843   pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        lda #$80 ; LD   A,80
        sec ; SUB  L
        sbc z80_l
        sta z80_l ; LD   L,A
        ldy #$01 ; LD   A,(IY+01)
        lda (z80_iy),y
        ldy #$04 ; ADD  A,(IY+04)
        clc
        adc (z80_iy),y
        cmp z80_l ; CP   L
        bcc *+3 ; RET  NC
        rts
        ldy #$01 ; LD   (IY+01),00
        lda #$00
        sta (z80_iy),y
@@218   ldy #$08 ; LD   A,(IX+08)
        lda (z80_ix),y
        ldy #$08 ; LD   (IY+08),A
        sta (z80_iy),y
        ldy #$0C ; LD   A,(IY+0C)
        lda (z80_iy),y
        ora #$30 ; OR   30
        ldy #$0C ; LD   (IY+0C),A
        sta (z80_iy),y
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        lda #<LC3FF ; LD   DE,LC3FF
        sta z80_e
        lda #>LC3FF
        sta z80_d
        lda #<L0040 ; LD   BC,0040
        sta z80_c
        lda #>L0040
        sta z80_b
        jsr ldir ; LDIR
        pla ; INC  SP
        pla ; INC  SP
        pla ; INC  SP
        pla ; INC  SP
        jmp LAFC8 ; JP   LAFC8

;LC874   POP  HL
;C875:   LD   A,L
;C876:   ADD  A,80
;C878:   LD   L,A
;C879:   LD   A,(IY+01)
;C87C:   SUB  (IY+04)
;C87F:   CP   L
;C880:   RET  C
;C881:   LD   (IY+01),FF
;C885:   JR   @@218

LC874   pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        lda z80_l ; LD   A,L
        clc ; ADD  A,80
        adc #$80
        sta z80_l ; LD   L,A
        ldy #$01 ; LD   A,(IY+01)
        lda (z80_iy),y
        ldy #$04 ; SUB  (IY+04)
        sec
        sbc (z80_iy),y
        cmp z80_l ; CP   L
        bcs *+3 ; RET  C
        rts
        ldy #$01 ; LD   (IY+01),FF
        lda #$FF
        sta (z80_iy),y
        jmp @@218 ; JR   @@218

;LC887   POP  HL
;C888:   LD   A,H
;C889:   ADD  A,80
;C88B:   LD   H,A
;C88C:   LD   A,(IY+02)
;C88F:   SUB  (IY+05)
;C892:   CP   H
;C893:   RET  C
;C894:   LD   (IY+02),FF
;C898:   JR   @@218

LC887   pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        lda z80_h ; LD   A,H
        clc ; ADD  A,80
        adc #$80
        sta z80_h ; LD   H,A
        ldy #$02 ; LD   A,(IY+02)
        lda (z80_iy),y
        ldy #$05 ; SUB  (IY+05)
        sec
        sbc (z80_iy),y
        cmp z80_h ; CP   H
        bcs *+3 ; RET  C
        rts
        ldy #$02 ; LD   (IY+02),FF
        lda #$FF
        sta (z80_iy),y
        jmp @@218 ; JR   @@218

;LC89A   POP  HL
;C89B:   LD   A,80
;C89D:   SUB  H
;C89E:   LD   H,A
;C89F:   LD   A,(IY+02)
;C8A2:   ADD  A,(IY+05)
;C8A5:   CP   H
;C8A6:   RET  NC
;C8A7:   LD   (IY+02),00
;C8AB:   JR   @@218

LC89A   pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        lda #$80 ; LD   A,80
        sec ; SUB  H
        sbc z80_h
        sta z80_h ; LD   H,A
        ldy #$02 ; LD   A,(IY+02)
        lda (z80_iy),y
        ldy #$05 ; ADD  A,(IY+05)
        clc
        adc (z80_iy),y
        cmp z80_h ; CP   H
        bcc *+3 ; RET  NC
        rts
        ldy #$02 ; LD   (IY+02),00
        lda #$00
        sta (z80_iy),y
        jmp @@218 ; JR   @@218

;LC8AD   LD   A,(IX+09)
;C8B0:   SUB  (IY+01)
;C8B3:   JR   NC,@@219
;C8B5:   NEG
;@@219   CP   L
;C8B8:   RET  NC
;C8B9:   LD   A,(IX+0A)
;C8BC:   SUB  (IY+02)
;C8BF:   JR   NC,@@220
;C8C1:   NEG
;@@220   CP   H
;C8C4:   RET  NC
;C8C5:   LD   A,(IX+0B)
;C8C8:   SUB  (IY+03)
;C8CB:   JR   NC,@@221
;C8CD:   NEG
;@@221   CP   04
;C8D1:   RET

LC8AD   ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        ldy #$01 ; SUB  (IY+01)
        sec
        sbc (z80_iy),y
        jcs @@219 ; JR   NC,@@219
        eor #$ff ; NEG
        clc
        adc #$01; 
@@219   cmp z80_l ; CP   L
        bcc *+3 ; RET  NC
        rts
        ldy #$0A ; LD   A,(IX+0A)
        lda (z80_ix),y
        ldy #$02 ; SUB  (IY+02)
        sec
        sbc (z80_iy),y
        jcs @@220 ; JR   NC,@@220
        eor #$ff ; NEG
        clc
        adc #$01; 
@@220   cmp z80_h ; CP   H
        bcc *+3 ; RET  NC
        rts
        ldy #$0B ; LD   A,(IX+0B)
        lda (z80_ix),y
        ldy #$03 ; SUB  (IY+03)
        sec
        sbc (z80_iy),y
        jcs @@221 ; JR   NC,@@221
        eor #$ff ; NEG
        clc
        adc #$01; 
@@221   cmp #$04 ; CP   04
        rts ; RET

;LC8D2   LD   HL,0F0F
;C8D5:   LD   IY,A76F
;C8D9:   LD   A,(IY+00)
;C8DC:   AND  A
;C8DD:   RET  Z
;C8DE:   BIT  3,(IY+07)
;C8E2:   RET  Z
;C8E3:   CALL LC8AD
;C8E6:   RET  NC
;C8E7:   LD   BC,JumpTable5
;C8EA:   BIT  3,(IX+00)
;C8EE:   JP   NZ,LC686
;C8F1:   LD   BC,JumpTable6
;C8F4:   JP   LC686

LC8D2   lda #<L0F0F ; LD   HL,0F0F
        sta z80_l
        lda #>L0F0F
        sta z80_h
        lda #<LA76F ; LD   IY,A76F
        sta z80_iy
        lda #>LA76F
        sta z80_iy+1
        ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        ; AND  A: 
        bne *+3 ; RET  Z
        rts
        ldy #$07 ; BIT  3,(IY+07)
        lda (z80_iy),y
        bit _bitmem3
        bne *+3 ; RET  Z
        rts
        jsr LC8AD ; CALL LC8AD
        bcc *+3 ; RET  NC
        rts; 
        lda #<JumpTable5 ; LD   BC,JumpTable5
        sta z80_c
        lda #>JumpTable5
        sta z80_b
        ldy #$00 ; BIT  3,(IX+00)
        lda (z80_ix),y
        bit _bitmem3
        jne LC686 ; JP   NZ,LC686
        lda #<JumpTable6 ; LD   BC,JumpTable6
        sta z80_c
        lda #>JumpTable6
        sta z80_b
        jmp LC686 ; JP   LC686

;JumpTable5: ; C8F7
;C8F7:   DW LC91A,LC907,LC907,LC91A

JumpTable5: ; C8F7
        .wo LC91A,LC907,LC907,LC91A ; DW LC91A,LC907,LC907,LC91A

;JumpTable6: ; C8FF
;C8FF:   DW LC907,LC91A,LC91A,LC907

JumpTable6: ; C8FF
        .wo LC907,LC91A,LC91A,LC907 ; DW LC907,LC91A,LC91A,LC907

;LC907   LD   A,(IX+0A)
;C90A:   CP   (IY+02)
;C90D:   JR   Z,@@222
;C90F:   LD   A,01
;C911:   JR   NC,@@223
;C913:   NEG
;@@223   LD   (IY+0F),A
;C918:   JR   @@222

LC907   ldy #$0A ; LD   A,(IX+0A)
        lda (z80_ix),y
        ldy #$02 ; CP   (IY+02)
        cmp (z80_iy),y
        jeq @@222 ; JR   Z,@@222
        lda #$01 ; LD   A,01
        jcs @@223 ; JR   NC,@@223; 
        eor #$ff ; NEG
        clc
        adc #$01; 
@@223   ldy #$0F ; LD   (IY+0F),A
        sta (z80_iy),y
        jmp @@222 ; JR   @@222

;LC91A   LD   A,(IX+09)
;C91D:   CP   (IY+01)
;C920:   JR   Z,@@222
;C922:   LD   A,01
;C924:   JR   NC,@@224
;C926:   NEG
;@@224   LD   (IY+0E),A
;@@222   RET

LC91A   ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        ldy #$01 ; CP   (IY+01)
        cmp (z80_iy),y
        jeq @@222 ; JR   Z,@@222
        lda #$01 ; LD   A,01
        jcs @@224 ; JR   NC,@@224; 
        eor #$ff ; NEG
        clc
        adc #$01; 
@@224   ldy #$0E ; LD   (IY+0E),A
        sta (z80_iy),y
@@222   rts ; RET

;RetrieveScreen: ; C92C
;C92C:   CALL ClrScrMakeUpTable
;C92F:   LD   HL,BlockTypesTable
;C932:   LD   (LA73A),HL
;C935:   XOR  A
;C936:   LD   (LA73C),A
;C939:   LD   DE,AE0F
;C93C:   LD   BC,BackgroundTypesTable
;C93F:   LD   HL,Locations
;@@226   LD   A,(HL)
;C943:   INC  HL
;C944:   CP   (IX+08)
;C947:   JR   Z,@@225
;C949:   LD   A,(HL)
;C94A:   CALL Add_HL_A
;C94D:   AND  A
;C94E:   SBC  HL,BC
;C950:   ADD  HL,BC
;C951:   JR   @@226

RetrieveScreen: ; C92C
        jsr ClrScrMakeUpTable ; CALL ClrScrMakeUpTable
        lda #<BlockTypesTable ; LD   HL,BlockTypesTable
        sta z80_l
        lda #>BlockTypesTable
        sta z80_h
        lda z80_l ; LD   (LA73A),HL
        sta LA73A
        lda z80_h
        sta LA73A+1
        lda #$00 ; XOR  A
        sta LA73C ; LD   (LA73C),A
        lda #<LAE0F ; LD   DE,AE0F
        sta z80_e
        lda #>LAE0F
        sta z80_d
        lda #<BackgroundTypesTable ; LD   BC,BackgroundTypesTable
        sta z80_c
        lda #>BackgroundTypesTable
        sta z80_b
        lda #<Locations ; LD   HL,Locations
        sta z80_l
        lda #>Locations
        sta z80_h
@@226   ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$08 ; CP   (IX+08)
        cmp (z80_ix),y; 
        jeq @@225 ; JR   Z,@@225
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        jsr Add_HL_A ; CALL Add_HL_A
        sec ; AND  A
        jsr sbc_hl_bc ; SBC  HL,BC
        jsr add_hl_bc ; ADD  HL,BC
        jmp @@226 ; JR   @@226

;@@225   LD   B,(HL)
;C954:   INC  HL
;C955:   LD   A,(HL)
;C956:   AND  07
;C958:   OR   40
;C95A:   LD   (LA738),A
;C95D:   PUSH DE
;C95E:   EX   DE,HL
;C95F:   LD   A,(DE)
;C960:   INC  DE
;C961:   RRCA
;C962:   RRCA
;C963:   RRCA
;C964:   AND  1F
;C966:   LD   C,A
;C967:   ADD  A,A
;C968:   ADD  A,C
;C969:   LD   HL,RoomSizeTable
;C96C:   CALL Add_HL_A
;C96F:   LD   A,(HL)
;C970:   INC  HL
;C971:   LD   (LA71D),A
;C974:   LD   A,(HL)
;C975:   INC  HL
;C976:   LD   (LA71E),A
;C979:   LD   A,(HL)
;C97A:   LD   (LA71F),A
;C97D:   DEC  B
;C97E:   DEC  B
;C97F:   EX   DE,HL
;C980:   POP  DE
;@@229   LD   A,(HL)
;C982:   INC  HL
;C983:   CP   FF
;C985:   JR   Z,@@227
;C987:   PUSH BC
;C988:   PUSH HL
;C989:   LD   L,A
;C98A:   LD   H,00
;C98C:   ADD  HL,HL
;C98D:   LD   BC,BackgroundTypesTable
;C990:   ADD  HL,BC
;C991:   LD   A,(HL)
;C992:   INC  HL
;C993:   LD   H,(HL)
;C994:   LD   L,A
;@@228   LD   BC,0008
;C998:   LDIR
;C99A:   EX   (SP),HL
;C99B:   LD   A,(HL)
;C99C:   EX   (SP),HL
;C99D:   LD   (DE),A
;C99E:   INC  DE
;C99F:   LD   B,17
;C9A1:   CALL Zero_DE
;C9A4:   PUSH HL
;C9A5:   LD   HL,FFC0
;C9A8:   ADD  HL,DE
;C9A9:   EX   DE,HL
;C9AA:   POP  HL
;C9AB:   LD   A,(HL)
;C9AC:   AND  A
;C9AD:   JR   NZ,@@228
;C9AF:   POP  HL
;C9B0:   POP  BC
;C9B1:   INC  HL
;C9B2:   DEC  B
;C9B3:   DJNZ @@229
;C9B5:   RET

@@225   ldy #$00 ; LD   B,(HL)
        lda (z80_hl),y
        sta z80_b
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        and #$07 ; AND  07
        ora #$40 ; OR   40
        sta LA738 ; LD   (LA738),A
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        jsr ex_de_hl ; EX   DE,HL
        ldy #$00 ; LD   A,(DE)
        lda (z80_de),y
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
        lsr @ ; RRCA
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$1F ; AND  1F
        sta z80_c ; LD   C,A
        asl @ ; ADD  A,A
        clc ; ADD  A,C
        adc z80_c
        ldx #<RoomSizeTable ; LD   HL,RoomSizeTable
        stx z80_l
        ldx #>RoomSizeTable
        stx z80_h
        jsr Add_HL_A ; CALL Add_HL_A
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        sta LA71D ; LD   (LA71D),A
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        sta LA71E ; LD   (LA71E),A
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        sta LA71F ; LD   (LA71F),A
        dec z80_b ; DEC  B
        dec z80_b ; DEC  B
        jsr ex_de_hl ; EX   DE,HL
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
@@229   ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        cmp #$FF ; CP   FF
        jeq @@227 ; JR   Z,@@227
		tax
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        stx z80_l ; LD   L,A; 
        lda #$00 ; LD   H,00
        sta z80_h
        asl z80_l ; ADD  HL,HL
        rol z80_h
        lda #<BackgroundTypesTable ; LD   BC,BackgroundTypesTable
        sta z80_c
        lda #>BackgroundTypesTable
        sta z80_b
        jsr add_hl_bc ; ADD  HL,BC
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
		tax
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD   H,(HL)
        lda (z80_hl),y
        sta z80_h
		txa
        sta z80_l ; LD   L,A
@@228   ;sta z80_a
		lda #<$0008 ; LD   BC,0008
        sta z80_c
        lda #>$0008
        sta z80_b
        jsr ldir ; LDIR
        jsr ex_sp_hl; EX   (SP),HL
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
		sta z80_a
        jsr ex_sp_hl; EX   (SP),HL
		lda z80_a
        ldy #$00 ; LD   (DE),A
        sta (z80_de),y; 
        inc z80_e ; INC  DE
        bne *+4
        inc z80_d
        lda #$17 ; LD   B,17
        sta z80_b
        jsr Zero_DE ; CALL Zero_DE
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda #<LFFC0 ; LD   HL,FFC0
        sta z80_l
        lda #>LFFC0
        sta z80_h
        jsr add_hl_de ; ADD  HL,DE
        jsr ex_de_hl ; EX   DE,HL
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ; AND  A
        jne @@228 ; JR   NZ,@@228
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        dec z80_b ; DEC  B
        dec z80_b ; DJNZ @@229
        jne @@229
        rts ; RET

;@@227   DEC  B
;C9B7:   PUSH IY
;C9B9:   PUSH DE
;C9BA:   POP  IY
;LC9BC   LD   A,(HL)
;C9BD:   AND  07
;C9BF:   INC  A
;C9C0:   LD   C,A
;C9C1:   LD   A,(HL)
;C9C2:   INC  HL
;C9C3:   DEC  B
;C9C4:   LD   D,(HL)
;C9C5:   INC  HL
;C9C6:   PUSH HL
;C9C7:   RRCA
;C9C8:   RRCA
;C9C9:   AND  3E
;C9CB:   CP   3E
;C9CD:   JP   Z,LCA6C
;C9D0:   LD   HL,(LA73A)
;C9D3:   CALL Add_HL_A
;C9D6:   LD   A,(HL)
;C9D7:   INC  HL
;C9D8:   LD   H,(HL)
;C9D9:   LD   L,A
;LC9DA   PUSH HL
;@@231   LD   A,(HL)
;C9DC:   INC  HL
;C9DD:   LD   (IY+00),A
;C9E0:   LD   A,(HL)
;C9E1:   INC  HL
;C9E2:   LD   (IY+04),A
;C9E5:   LD   A,(HL)
;C9E6:   INC  HL
;C9E7:   LD   (IY+05),A
;C9EA:   LD   A,(HL)
;C9EB:   INC  HL
;C9EC:   LD   (IY+06),A
;C9EF:   LD   A,(HL)
;C9F0:   INC  HL
;C9F1:   LD   (IY+07),A
;C9F4:   LD   A,(IX+08)
;C9F7:   LD   (IY+08),A
;C9FA:   LD   A,(LA73C)
;C9FD:   RLCA
;C9FE:   RLCA
;C9FF:   RLCA
;CA00:   AND  08
;CA02:   LD   E,A
;CA03:   LD   A,D
;CA04:   RLCA
;CA05:   RLCA
;CA06:   RLCA
;CA07:   RLCA
;CA08:   AND  70
;CA0A:   ADD  A,E
;CA0B:   ADD  A,48
;CA0D:   LD   (IY+01),A
;CA10:   LD   A,(LA73C)
;CA13:   RLCA
;CA14:   RLCA
;CA15:   AND  08
;CA17:   LD   E,A
;CA18:   LD   A,D
;CA19:   RLCA
;CA1A:   AND  70
;CA1C:   ADD  A,E
;CA1D:   ADD  A,48
;CA1F:   LD   (IY+02),A
;CA22:   LD   A,D
;CA23:   RLCA
;CA24:   RLCA
;CA25:   AND  03
;CA27:   ADD  A,A
;CA28:   ADD  A,A
;CA29:   LD   E,A
;CA2A:   ADD  A,A
;CA2B:   ADD  A,E
;CA2C:   LD   E,A
;CA2D:   LD   A,(LA73C)
;CA30:   ADD  A,E
;CA31:   AND  FC
;CA33:   LD   E,A
;CA34:   LD   A,(LA71F)
;CA37:   ADD  A,E
;CA38:   LD   (IY+03),A
;CA3B:   PUSH BC
;CA3C:   LD   BC,0009
;CA3F:   ADD  IY,BC
;CA41:   LD   B,17
;@@230   LD   (IY+00),00
;CA47:   INC  IY
;CA49:   DJNZ @@230
;CA4B:   LD   BC,FFC0
;CA4E:   ADD  IY,BC
;CA50:   POP  BC
;CA51:   LD   A,(HL)
;CA52:   AND  A
;CA53:   JR   NZ,@@231
;CA55:   POP  DE
;CA56:   POP  HL
;CA57:   DEC  B
;CA58:   JR   Z,@@232
;CA5A:   DEC  C
;CA5B:   JP   Z,LC9BC
;CA5E:   LD   A,(HL)
;CA5F:   INC  HL
;CA60:   PUSH HL
;CA61:   EX   DE,HL
;CA62:   LD   D,A
;CA63:   JP   LC9DA

@@227   dec z80_b ; DEC  B
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        lda z80_e ; PUSH DE
        pha
        lda z80_d
        pha
        pla ; POP  IY
        sta z80_iy+1
        pla
        sta z80_iy
LC9BC   ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        and #$07 ; AND  07
        clc ; INC  A
        adc #$01
        sta z80_c ; LD   C,A
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
		tax
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        dec z80_b ; DEC  B
        ldy #$00 ; LD   D,(HL)
        lda (z80_hl),y
        sta z80_d
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
		txa
        lsr @ ; RRCA
        lsr @ ; RRCA
        and #$3E ; AND  3E
        cmp #$3E ; CP   3E
        jeq LCA6C ; JP   Z,LCA6C
        ldx LA73A ; LD   HL,(LA73A)
        stx z80_l
        ldx LA73A+1
        stx z80_h
        jsr Add_HL_A ; CALL Add_HL_A
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
		tax
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD   H,(HL)
        lda (z80_hl),y
        sta z80_h
        stx z80_l ; LD   L,A
LC9DA   lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
@@231   ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD   (IY+00),A
        sta (z80_iy),y
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$04 ; LD   (IY+04),A
        sta (z80_iy),y
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$05 ; LD   (IY+05),A
        sta (z80_iy),y
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$06 ; LD   (IY+06),A
        sta (z80_iy),y
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$07 ; LD   (IY+07),A
        sta (z80_iy),y
        ldy #$08 ; LD   A,(IX+08)
        lda (z80_ix),y
        ldy #$08 ; LD   (IY+08),A
        sta (z80_iy),y
        lda LA73C ; LD   A,(LA73C)
        asl @ ; RLCA
        asl @ ; RLCA
        asl @ ; RLCA
        and #$08 ; AND  08
        sta z80_e ; LD   E,A
        lda z80_d ; LD   A,D
        asl @ ; RLCA
        asl @ ; RLCA
        asl @ ; RLCA
        asl @ ; RLCA
        and #$70 ; AND  70
        clc ; ADD  A,E
        adc z80_e
        clc ; ADD  A,48
        adc #$48
        ldy #$01 ; LD   (IY+01),A
        sta (z80_iy),y
        lda LA73C ; LD   A,(LA73C)
        asl @ ; RLCA
        asl @ ; RLCA
        and #$08 ; AND  08
        sta z80_e ; LD   E,A
        lda z80_d ; LD   A,D
        asl @ ; RLCA
        and #$70 ; AND  70
        clc ; ADD  A,E
        adc z80_e
        clc ; ADD  A,48
        adc #$48
        ldy #$02 ; LD   (IY+02),A
        sta (z80_iy),y
        lda z80_d ; LD   A,D
        asl @ ; RLCA
        rol @ ; RLCA
		rol @
        and #$03 ; AND  03
        asl @ ; ADD  A,A
        asl @ ; ADD  A,A
        sta z80_e ; LD   E,A
        asl @ ; ADD  A,A
        clc ; ADD  A,E
        adc z80_e
        sta z80_e ; LD   E,A
        lda LA73C ; LD   A,(LA73C)
        clc ; ADD  A,E
        adc z80_e
        and #$FC ; AND  FC
        sta z80_e ; LD   E,A
        lda LA71F ; LD   A,(LA71F)
        clc ; ADD  A,E
        adc z80_e
        ldy #$03 ; LD   (IY+03),A
        sta (z80_iy),y
        lda z80_c ; PUSH BC
        pha
        lda z80_b
        pha
        lda #<$0009 ; LD   BC,0009
        sta z80_c
        lda #>$0009
        sta z80_b
        jsr add_iy_bc ; ADD  IY,BC
        lda #$17 ; LD   B,17
        sta z80_b
@@230   ldy #$00 ; LD   (IY+00),00
        lda #$00
        sta (z80_iy),y
        inc z80_iy ; INC  IY
        bne *+4
        inc z80_iy+1
        dec z80_b ; DJNZ @@230
        jne @@230
        lda #<LFFC0 ; LD   BC,FFC0
        sta z80_c
        lda #>LFFC0
        sta z80_b
        jsr add_iy_bc ; ADD  IY,BC
        pla ; POP  BC
        sta z80_b
        pla
        sta z80_c
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ; AND  A
        jne @@231 ; JR   NZ,@@231
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        dec z80_b ; DEC  B
        jeq @@232 ; JR   Z,@@232
        dec z80_c ; DEC  C
        jeq LC9BC ; JP   Z,LC9BC
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
		tay
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        jsr ex_de_hl ; EX   DE,HL
        sty z80_d ; LD   D,A
        jmp LC9DA ; JP   LC9DA

;@@232   PUSH IY
;CA68:   POP  DE
;CA69:   POP  IY
;CA6B:   RET

@@232   lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        pla ; POP  IY
        sta z80_iy+1
        pla
        sta z80_iy
        rts ; RET

;LCA6C   LD   HL,(LA73A)
;CA6F:   LD   A,40
;CA71:   CALL Add_HL_A
;CA74:   LD   (LA73A),HL
;@@233   DEC  B
;CA78:   POP  HL
;CA79:   JP   LC9BC

LCA6C   lda LA73A ; LD   HL,(LA73A)
        sta z80_l
        lda LA73A+1
        sta z80_h
        lda #$40 ; LD   A,40
        jsr Add_HL_A ; CALL Add_HL_A
        lda z80_l ; LD   (LA73A),HL
        sta LA73A
        lda z80_h
        sta LA73A+1
@@233   dec z80_b ; DEC  B
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        jmp LC9BC ; JP   LC9BC

;LCA7C   LD   A,D
;CA7D:   LD   (LA73C),A
;CA80:   JR   @@233

LCA7C   lda z80_d ; LD   A,D
        sta LA73C ; LD   (LA73C),A
        jmp @@233 ; JR   @@233

;LCA82   LD   A,(LA71D)
;CA85:   SUB  02
;CA87:   LD   L,A
;CA88:   LD   A,(LA71E)
;CA8B:   SUB  02
;CA8D:   LD   H,A
;CA8E:   LD   A,(IX+01)
;CA91:   AND  A
;CA92:   JR   Z,@@234
;CA94:   INC  A
;CA95:   JR   Z,@@235
;CA97:   LD   A,(IX+02)
;CA9A:   AND  A
;CA9B:   JR   Z,@@236
;CA9D:   INC  A
;CA9E:   JR   Z,@@237
;CAA0:   RET

LCA82   lda LA71D ; LD   A,(LA71D)
        sec ; SUB  02
        sbc #$02
        sta z80_l ; LD   L,A
        lda LA71E ; LD   A,(LA71E)
        sec ; SUB  02
        sbc #$02
        sta z80_h ; LD   H,A
        ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        ; AND  A
        jeq @@234 ; JR   Z,@@234
        clc ; INC  A
        adc #$01; 
        jeq @@235 ; JR   Z,@@235
        ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        ; AND  A: 
        jeq @@236 ; JR   Z,@@236
        clc ; INC  A
        adc #$01; 
        jeq @@237 ; JR   Z,@@237
        rts ; RET

;@@237   LD   C,03
;CAA3:   CALL LCAEE
;CAA6:   LD   A,80
;CAA8:   SUB  H
;CAA9:   SUB  (IX+05)
;@@238   LD   (IX+02),A
;@@239   SET  4,(IX+07)
;CAB3:   SET  4,(IX+27)
;CAB7:   LD   A,(IX+01)
;CABA:   LD   (IX+21),A
;CABD:   LD   A,(IX+02)
;CAC0:   LD   (IX+22),A
;CAC3:   RET

@@237   lda #$03 ; LD   C,03
        sta z80_c
        jsr LCAEE ; CALL LCAEE
        lda #$80 ; LD   A,80
        sec ; SUB  H
        sbc z80_h
        ldy #$05 ; SUB  (IX+05)
        sec
        sbc (z80_ix),y
@@238   ldy #$02 ; LD   (IX+02),A
        sta (z80_ix),y
@@239   ldy #$07 ; SET  4,(IX+07)
        lda (z80_ix),y
        ora #_bitvalue4
        sta (z80_ix),y
        ldy #$27 ; SET  4,(IX+27)
        lda (z80_ix),y
        ora #_bitvalue4
        sta (z80_ix),y
        ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        ldy #$21 ; LD   (IX+21),A
        sta (z80_ix),y
        ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        ldy #$22 ; LD   (IX+22),A
        sta (z80_ix),y
        rts ; RET

;@@236   LD   C,02
;CAC6:   CALL LCAEE
;CAC9:   LD   A,H
;CACA:   ADD  A,80
;CACC:   ADD  A,(IX+05)
;CACF:   JR   @@238

@@236   lda #$02 ; LD   C,02
        sta z80_c
        jsr LCAEE ; CALL LCAEE
        lda z80_h ; LD   A,H
        clc ; ADD  A,80
        adc #$80
        ldy #$05 ; ADD  A,(IX+05)
        clc
        adc (z80_ix),y
        jmp @@238 ; JR   @@238

;@@235   LD   C,01
;CAD3:   CALL LCAEE
;CAD6:   LD   A,80
;CAD8:   SUB  L
;CAD9:   SUB  (IX+04)
;@@240   LD   (IX+01),A
;CADF:   JR   @@239

@@235   lda #$01 ; LD   C,01
        sta z80_c
        jsr LCAEE ; CALL LCAEE
        lda #$80 ; LD   A,80
        sec ; SUB  L
        sbc z80_l
        ldy #$04 ; SUB  (IX+04)
        sec
        sbc (z80_ix),y
@@240   ldy #$01 ; LD   (IX+01),A
        sta (z80_ix),y
        jmp @@239 ; JR   @@239

;@@234   LD   C,00
;CAE3:   CALL LCAEE
;CAE6:   LD   A,L
;CAE7:   ADD  A,80
;CAE9:   ADD  A,(IX+04)
;CAEC:   JR   @@240

@@234   lda #$00 ; LD   C,00
        sta z80_c
        jsr LCAEE ; CALL LCAEE
        lda z80_l ; LD   A,L
        clc ; ADD  A,80
        adc #$80
        ldy #$04 ; ADD  A,(IX+04)
        clc
        adc (z80_ix),y
        jmp @@240 ; JR   @@240

;LCAEE   LD   IY,ADEF
;CAF2:   LD   DE,FFC0
;CAF5:   LD   B,04
;@@245   LD   A,(IY+00)
;CAFA:   SUB  06
;CAFC:   CP   04
;CAFE:   RET  NC
;CAFF:   LD   A,C
;CB00:   AND  A
;CB01:   JR   Z,@@241
;CB03:   DEC  A
;CB04:   JR   Z,@@242
;CB06:   DEC  A
;CB07:   JR   Z,@@243
;CB09:   LD   A,(IY+02)
;CB0C:   CP   40
;CB0E:   JR   C,@@244
;@@247   ADD  IY,DE
;CB12:   DJNZ @@245
;CB14:   RET

LCAEE   lda #<LADEF ; LD   IY,ADEF
        sta z80_iy
        lda #>LADEF
        sta z80_iy+1
        lda #<LFFC0 ; LD   DE,FFC0
        sta z80_e
        lda #>LFFC0
        sta z80_d
        lda #$04 ; LD   B,04
        sta z80_b
@@245   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        sec ; SUB  06
        sbc #$06
        cmp #$04 ; CP   04
        bcc *+3 ; RET  NC
        rts
        lda z80_c ; LD   A,C
        ; AND  A
        jeq @@241 ; JR   Z,@@241
        sec ; DEC  A
        sbc #$01; 
        jeq @@242 ; JR   Z,@@242
        sec ; DEC  A
        sbc #$01; 
        jeq @@243 ; JR   Z,@@243
        ldy #$02 ; LD   A,(IY+02)
        lda (z80_iy),y
        cmp #$40 ; CP   40
        jcc @@244 ; JR   C,@@244
@@247   jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@245
        jne @@245
        rts ; RET

;LCB15   LD   A,(IY+02)
;CB18:   ADD  A,0D
;CB1A:   LD   (IX+02),A
;@@246   LD   A,(IY+03)
;CB20:   LD   (IX+03),A
;CB23:   ADD  A,0C
;CB25:   LD   (IX+23),A
;CB28:   RET

LCB15   ldy #$02 ; LD   A,(IY+02)
        lda (z80_iy),y
        clc ; ADD  A,0D
        adc #$0D
        ldy #$02 ; LD   (IX+02),A
        sta (z80_ix),y
@@246   ldy #$03 ; LD   A,(IY+03)
        lda (z80_iy),y
        ldy #$03 ; LD   (IX+03),A
        sta (z80_ix),y
        clc ; ADD  A,0C
        adc #$0C
        ldy #$23 ; LD   (IX+23),A
        sta (z80_ix),y
        rts ; RET

;@@244   LD   A,(IY+01)
;CB2C:   SUB  0D
;CB2E:   LD   (IX+01),A
;CB31:   JR   @@246

@@244   ldy #$01 ; LD   A,(IY+01)
        lda (z80_iy),y
        sec ; SUB  0D
        sbc #$0D
        ldy #$01 ; LD   (IX+01),A
        sta (z80_ix),y
        jmp @@246 ; JR   @@246

;@@241   LD   A,(IY+01)
;CB36:   CP   C0
;CB38:   JR   NC,LCB15
;CB3A:   JR   @@247

@@241   ldy #$01 ; LD   A,(IY+01)
        lda (z80_iy),y
        cmp #$C0 ; CP   C0
        jcs LCB15 ; JR   NC,LCB15
        jmp @@247 ; JR   @@247

;@@242   LD   A,(IY+01)
;CB3F:   CP   40
;CB41:   JR   C,LCB15
;CB43:   JR   @@247

@@242   ldy #$01 ; LD   A,(IY+01)
        lda (z80_iy),y
        cmp #$40 ; CP   40
        jcc LCB15 ; JR   C,LCB15
        jmp @@247 ; JR   @@247

;@@243   LD   A,(IY+02)
;CB48:   CP   C0
;CB4A:   JR   NC,@@244
;CB4C:   JR   @@247

@@243   ldy #$02 ; LD   A,(IY+02)
        lda (z80_iy),y
        cmp #$C0 ; CP   C0
        jcs @@244 ; JR   NC,@@244
        jmp @@247 ; JR   @@247

;LCB4E   JP   LC75F

LCB4E   jmp LC75F ; JP   LC75F

;LCB51   JP   LC769

LCB51   jmp LC769 ; JP   LC769

;ClrScrMakeUpTable: ; CB54
;CB54:   LD   HL,ScreenMakeUpTable
;CB57:   LD   BC,0680
;CB5A:   JR   ClrMem

ClrScrMakeUpTable: ; CB54
        lda #<ScreenMakeUpTable ; LD   HL,ScreenMakeUpTable
        sta z80_l
        lda #>ScreenMakeUpTable
        sta z80_h
        lda #<L0680 ; LD   BC,0680
        sta z80_c
        lda #>L0680
        sta z80_b
        jmp ClrMem ; JR   ClrMem

;ClrScr  LD   HL,4000
;CB5F:   LD   DE,4001
;CB62:   LD   BC,1800
;CB65:   LD   (HL),00
;CB67:   LDIR
;CB69:   RET

;ClrScr  
;
;		;lda #$30 ; Open up all RAM
;		;sta $01
;		;dec $01
;		;inc $ff00
;		
;		
;		lda #<L4000 ; LD   HL,4000
;        sta z80_l
;        lda #>L4000
;        sta z80_h
;        lda #<L4001 ; LD   DE,4001
;        sta z80_e
;        lda #>L4001
;        sta z80_d
;        lda #<L1800 ; LD   BC,1800
;        sta z80_c
;        lda #>L1800
;        sta z80_b
;        lda #$00 ; LD   (HL),00
;        ldy #$00
;        sta (z80_hl),y
;        jsr ldir ; LDIR
;		
;		; put IO back in
;		;lda #$35
;		;sta $01
; 		
;		;inc $01
;		;dec $ff00
;		
;        rts ; RET

;FillAttr: ; CB6A
;CB6A:   LD   HL,5800
;CB6D:   LD   DE,5801
;CB70:   LD   BC,0300
;CB73:   LD   (HL),A
;CB74:   LDIR
;CB76:   RET

;FillAttr: ; CB6A
;		;jsr c64colours
;		
;		cmp #$41
;		bne not_white
;		lda #$0f
;not_white		
;		sta colour_code
;		
;		lda #<colour_ram
;		sta dest_lo
;		lda #>colour_ram
;		sta dest_hi
;		
;		ldx #00
;@	
;		lda colour_code
;	
;		ldy #00
;@
;		sta (dest_lo),y
;		
;		iny
;		cpy #32
;		bne @-
;			
;		lda #40
;		clc
;		adc dest_lo
;		sta dest_lo
;		scc:inc dest_hi
;		
;		inx
;		cpx #24
;		bne @-1
		
;		tax
;        lda #<L5800 ; LD   HL,5800
;        sta z80_l
;        lda #>L5800
;        sta z80_h
;        lda #<L5801 ; LD   DE,5801
;        sta z80_e
;        lda #>L5801
;        sta z80_d
;        lda #<L0300 ; LD   BC,0300
;        sta z80_c
;        lda #>L0300
;        sta z80_b
;        ldy #$00 ; LD   (HL),A
;		txa
;        sta (z80_hl),y; 
;        jsr ldir ; LDIR
		
		
;        rts ; RET

;ClrMem  LD   E,00

ClrMem  lda #$00 ; LD   E,00
        sta z80_e

;FillMem LD   (HL),E
;CB7A:   INC  HL
;CB7B:   DEC  BC
;CB7C:   LD   A,B
;CB7D:   OR   C
;CB7E:   JR   NZ,FillMem
;CB80:   RET

;FillMem lda z80_e ; LD   (HL),E
;        ldy #$00
;        sta (z80_hl),y
;        inc z80_l ; INC  HL
;        bne *+4
;        inc z80_h
;        jsr dec_bc ; DEC  BC
;        lda z80_b ; LD   A,B
;        ora z80_c ; OR   C
;        jne FillMem ; JR   NZ,FillMem
;        rts ; RET

FillMem	ldy #0
		lda z80_e
		ldx z80_b
		beq FillMem_LastPage
FillMem_Loop		
		sta (z80_hl),y
		iny
		bne FillMem_Loop
		inc z80_h
		dex
		bne FillMem_Loop
FillMem_LastPage
		cpx z80_c
		beq FillMem_end
FillMem_LastPage_Loop		
		sta (z80_hl),y
		iny
		cpy z80_c
		bne FillMem_LastPage_Loop
FillMem_end		
		stx z80_c
		stx z80_b
		tya
		clc
		adc z80_l
		sta z80_l
		scc:inc z80_h
		rts
		
;ClrWrkScr: ; CB81
;CB81:   LD   BC,1800
;CB84:   LD   HL,ScreenBuffer
;CB87:   JR   ClrMem

ClrWrkScr: ; CB81
        lda #<L1800 ; LD   BC,1800
        sta z80_c
        lda #>L1800
        sta z80_b
        lda #<ScreenBuffer ; LD   HL,ScreenBuffer
        sta z80_l
        lda #>ScreenBuffer
        sta z80_h
        jmp ClrMem ; JR   ClrMem

;LCB89   CALL LD071
;CB8C:   LD   C,70
;@@249   LD   A,(IY+00)
;CB91:   CP   78
;CB93:   JR   Z,@@248
;CB95:   AND  F8
;CB97:   CP   C
;CB98:   JR   Z,@@248
;CB9A:   CP   80
;CB9C:   JR   Z,@@248
;CB9E:   ADD  IY,DE
;CBA0:   DJNZ @@249
;CBA2:   XOR  A
;@@250   LD   (LA742),A
;CBA6:   RET

LCB89   jsr LD071 ; CALL LD071
        lda #$70 ; LD   C,70
        sta z80_c
@@249   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        cmp #$78 ; CP   78
        jeq @@248 ; JR   Z,@@248
        and #$F8 ; AND  F8; 
        cmp z80_c ; CP   C
        jeq @@248 ; JR   Z,@@248
        cmp #$80 ; CP   80
        jeq @@248 ; JR   Z,@@248
        jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@249
        jne @@249
        lda #$00 ; XOR  A
@@250   sta LA742 ; LD   (LA742),A
        rts ; RET

;@@248   LD   A,01
;CBA9:   JR   @@250

@@248   lda #$01 ; LD   A,01
        jmp @@250 ; JR   @@250

;InitMonsters: ; CBAB
;CBAB:   LD   A,(LA742)
;CBAE:   AND  A
;CBAF:   RET  NZ
;CBB0:   LD   HL,LA73D
;CBB3:   DEC  (HL)
;CBB4:   RET  NZ
;CBB5:   LD   (HL),01
;CBB7:   LD   A,(LA70D)
;CBBA:   AND  03
;CBBC:   RET  NZ
;CBBD:   CALL LCC31
;CBC0:   LD   HL,A7EF
;CBC3:   LD   BC,0020
;CBC6:   LD   DE,LCC11
;CBC9:   LD   A,(HL)
;CBCA:   AND  A
;CBCB:   JR   Z,@@251
;CBCD:   ADD  HL,BC
;CBCE:   LD   A,(HL)
;CBCF:   AND  A
;CBD0:   RET  NZ
;@@251   EX   DE,HL
;CBD2:   PUSH HL
;CBD3:   POP  IX
;CBD5:   LDIR
;CBD7:   LD   A,(LA70D)
;CBDA:   AND  2F
;CBDC:   ADD  A,68
;CBDE:   LD   (IX+01),A
;CBE1:   LD   A,R
;CBE3:   AND  2F
;CBE5:   ADD  A,68
;CBE7:   LD   (IX+02),A
;CBEA:   LD   A,(LA70D)
;CBED:   RRA
;CBEE:   RRA
;CBEF:   RRA
;CBF0:   AND  07
;CBF2:   LD   L,A
;CBF3:   LD   H,00
;CBF5:   LD   DE,MonsterTable
;CBF8:   ADD  HL,DE
;CBF9:   LD   A,(HL)
;CBFA:   LD   (IX+00),A
;CBFD:   CALL LB2C5
;CC00:   CALL LBF1B
;CC03:   RET  NC
;CC04:   LD   (IX+00),00
;CC08:   RET

InitMonsters: ; CBAB
        lda LA742 ; LD   A,(LA742)
        ; AND  A
        beq *+3 ; RET  NZ
        rts
        ;lda #<LA73D ; LD   HL,LA73D
        ;sta z80_l
        ;lda #>LA73D
        ;sta z80_h
        ;ldy #$00 ; DEC  (HL)
        ;lda (z80_hl),y
        ;sec
        ;sbc #$01
        ;sta (z80_hl),y
		dec LA73D
        beq *+3 ; RET  NZ
        rts
        ;lda #$01 ; LD   (HL),01
        ;ldy #$00
        ;sta (z80_hl),y
		inc LA73D
        lda LA70D ; LD   A,(LA70D)
        and #$03 ; AND  03
        beq *+3 ; RET  NZ
        rts
        jsr LCC31 ; CALL LCC31
        lda #<LA7EF ; LD   HL,A7EF
        sta z80_l
        lda #>LA7EF
        sta z80_h
        lda #<L0020 ; LD   BC,0020
        sta z80_c
        lda #>L0020
        sta z80_b
        lda #<LCC11 ; LD   DE,LCC11
        sta z80_e
        lda #>LCC11
        sta z80_d
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ; AND  A
        jeq @@251 ; JR   Z,@@251
        jsr add_hl_bc ; ADD  HL,BC
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ; AND  A
        beq *+3 ; RET  NZ
        rts
@@251   jsr ex_de_hl ; EX   DE,HL
        lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix
        jsr ldir ; LDIR
        lda LA70D ; LD   A,(LA70D)
        and #$2F ; AND  2F
        clc ; ADD  A,68
        adc #$68
        ldy #$01 ; LD   (IX+01),A
        sta (z80_ix),y
		
        ld_a_r ; LD   A,R
		
        and #$2F ; AND  2F
        clc ; ADD  A,68
        adc #$68
        ldy #$02 ; LD   (IX+02),A
        sta (z80_ix),y
        lda LA70D ; LD   A,(LA70D)
        ror @ ; RRA
        ror @ ; RRA
        ror @ ; RRA
        and #$07 ; AND  07
        sta z80_l ; LD   L,A
		
		
        lda #$00 ; LD   H,00
        sta z80_h
        lda #<MonsterTable ; LD   DE,MonsterTable
        sta z80_e
        lda #>MonsterTable
        sta z80_d
        jsr add_hl_de ; ADD  HL,DE
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y
        jsr LB2C5 ; CALL LB2C5
        jsr LBF1B ; CALL LBF1B
        ;bcc *+3 ; RET  NC
		bcc DeleteMonster
		
		;.if FRAME_SKIPPING == 1
        
		lda FRAME_SKIPPING
		beq frameskip003
				
		ldy #$18 ; LD   A,(IX+18)	; need to set "last rectangle", as with frame skipping it might not be set by main loop, causing rendering errors
        lda (z80_ix),y
        ldy #$1C ; LD   (IX+1C),A
        sta (z80_ix),y
        ldy #$19 ; LD   A,(IX+19)
        lda (z80_ix),y
        ldy #$1D ; LD   (IX+1D),A
        sta (z80_ix),y
        ldy #$1A ; LD   A,(IX+1A)
        lda (z80_ix),y
        ldy #$1E ; LD   (IX+1E),A
        sta (z80_ix),y
        ldy #$1B ; LD   A,(IX+1B)
        lda (z80_ix),y
        ldy #$1F ; LD   (IX+1F),A
        sta (z80_ix),y
		;.endif

frameskip003
		
        rts;
DeleteMonster		
        ldy #$00 ; LD   (IX+00),00
        lda #$00
        sta (z80_ix),y
        rts ; RET

;MonsterTable: ; CC09
;CC09:   DB A4,A0,30,50,A8,A0,30,50

MonsterTable: ; CC09
        .he A4,A0,30,50,A8,A0,30,50 ; DB A4,A0,30,50,A8,A0,30,50

;LCC11   DB 00,A0,A0,D8,08,08,08,10,00,00,00,00,00,00,00,00
;CC21:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

LCC11   .he 00,A0,A0,D8,08,08,08,10,00,00,00,00,00,00,00,00 ; DB 00,A0,A0,D8,08,08,08,10,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

;LCC31   LD   HL,LD432
;CC34:   LD   DE,0010
;CC37:   LD   BC,1202
;@@253   LD   A,(HL)
;CC3B:   AND  FC
;CC3D:   CP   70
;CC3F:   JR   NZ,@@252
;CC41:   INC  C
;@@252   DJNZ @@253
;CC44:   LD   A,C
;CC45:   ADD  A,A
;CC46:   ADD  A,A
;CC47:   LD   (LA73D),A
;CC4A:   RET

LCC31   lda #<LD432 ; LD   HL,LD432
        sta z80_l
        lda #>LD432
        sta z80_h
        lda #<$0010 ; LD   DE,0010
        sta z80_e
        lda #>$0010
        sta z80_d
        lda #<L1202 ; LD   BC,1202
        sta z80_c
        lda #>L1202
        sta z80_b
@@253   ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        and #$FC ; AND  FC
        cmp #$70 ; CP   70
        jne @@252 ; JR   NZ,@@252
        inc z80_c ; INC  C
@@252   dec z80_b ; DJNZ @@253
        jne @@253
        lda z80_c ; LD   A,C
        asl @ ; ADD  A,A
        asl @ ; ADD  A,A
        sta LA73D ; LD   (LA73D),A
        rts ; RET

;LCC4B   CALL LC775
;CC4E:   LD   (IX+04),0A
;CC52:   LD   (IX+05),0A
;CC56:   CALL LB979
;CC59:   LD   A,(IX+0C)
;CC5C:   AND  07
;CC5E:   JR   Z,@@254
;CC60:   AND  01
;CC62:   CALL NZ,LCCE9
;CC65:   BIT  1,(IX+0C)
;CC69:   CALL NZ,LCCF2
;@@254   LD   A,(LA770)
;CC6F:   SUB  (IX+01)
;CC72:   LD   A,(IX+14)
;CC75:   JR   NC,@@255
;CC77:   CALL LCD0D
;@@260   LD   (IX+14),A
;CC7D:   LD   A,(LA771)
;CC80:   SUB  (IX+02)
;CC83:   LD   A,(IX+15)
;CC86:   JR   NC,@@256
;CC88:   CALL LCD0D
;@@261   LD   (IX+15),A
;CC8E:   LD   A,(LA792)
;CC91:   SUB  (IX+03)
;CC94:   LD   A,(IX+16)
;CC97:   JR   NC,@@257
;CC99:   CALL LCD0D
;@@262   LD   (IX+16),A
;CC9F:   LD   B,03
;@@258   INC  IX
;CCA3:   LD   A,(IX+13)
;CCA6:   ADD  A,08
;CCA8:   SRA  A
;CCAA:   SRA  A
;CCAC:   SRA  A
;CCAE:   SRA  A
;CCB0:   LD   (IX+08),A
;CCB3:   DJNZ @@258
;CCB5:   DEC  IX
;CCB7:   DEC  IX
;CCB9:   DEC  IX
;CCBB:   JR   @@259

LCC4B   jsr LC775 ; CALL LC775
        ldy #$04 ; LD   (IX+04),0A
        lda #$0A
        sta (z80_ix),y
        ;ldy #$05 ; LD   (IX+05),0A
        ;lda #$0A
		iny
        sta (z80_ix),y
        jsr LB979 ; CALL LB979
        ldy #$0C ; LD   A,(IX+0C)
        lda (z80_ix),y
        and #$07 ; AND  07
        jeq @@254 ; JR   Z,@@254
        and #$01 ; AND  01; 
        beq *+5 ; CALL NZ,LCCE9
        jsr LCCE9
        ldy #$0C ; BIT  1,(IX+0C)
        lda (z80_ix),y
        bit _bitmem1
        beq *+5 ; CALL NZ,LCCF2
        jsr LCCF2
@@254   lda LA770 ; LD   A,(LA770)
        ldy #$01 ; SUB  (IX+01)
        sec
        sbc (z80_ix),y
        ldy #$14 ; LD   A,(IX+14)
        lda (z80_ix),y
        jcs @@255 ; JR   NC,@@255
        jsr LCD0D ; CALL LCD0D
@@260   ldy #$14 ; LD   (IX+14),A
        sta (z80_ix),y
        lda LA771 ; LD   A,(LA771)
        ldy #$02 ; SUB  (IX+02)
        sec
        sbc (z80_ix),y
        ldy #$15 ; LD   A,(IX+15)
        lda (z80_ix),y
        jcs @@256 ; JR   NC,@@256
        jsr LCD0D ; CALL LCD0D
@@261   ldy #$15 ; LD   (IX+15),A
        sta (z80_ix),y
        lda LA792 ; LD   A,(LA792)
        ldy #$03 ; SUB  (IX+03)
        sec
        sbc (z80_ix),y
        ldy #$16 ; LD   A,(IX+16)
        lda (z80_ix),y
        jcs @@257 ; JR   NC,@@257
        jsr LCD0D ; CALL LCD0D
@@262   ldy #$16 ; LD   (IX+16),A
        sta (z80_ix),y
        lda #$03 ; LD   B,03
        sta z80_b
@@258   inc z80_ix ; INC  IX
        bne *+4
        inc z80_ix+1
        ldy #$13 ; LD   A,(IX+13)
        lda (z80_ix),y
        clc ; ADD  A,08
        adc #$08
        cmp #$80 ; SRA  A
        ror @
        cmp #$80 ; SRA  A
        ror @
        cmp #$80 ; SRA  A
        ror @
        cmp #$80 ; SRA  A
        ror @
        ldy #$08 ; LD   (IX+08),A
        sta (z80_ix),y
        dec z80_b ; DJNZ @@258
        jne @@258
        jsr dec_ix ; DEC  IX
        jsr dec_ix ; DEC  IX
        jsr dec_ix ; DEC  IX
        jmp @@259 ; JR   @@259

;@@255   CALL LCD04
;CCC0:   JR   @@260

@@255   jsr LCD04 ; CALL LCD04
        jmp @@260 ; JR   @@260

;@@256   CALL LCD04
;CCC5:   JR   @@261

@@256   jsr LCD04 ; CALL LCD04
        jmp @@261 ; JR   @@261

;@@257   CALL LCD04
;CCCA:   JR   @@262

@@257   jsr LCD04 ; CALL LCD04
        jmp @@262 ; JR   @@262

;@@259   INC  (IX+10)
;CCCF:   LD   A,(IX+10)
;CCD2:   AND  03
;CCD4:   LD   B,A
;CCD5:   LD   A,(IX+00)
;CCD8:   AND  FC
;CCDA:   ADD  A,B
;CCDB:   LD   (IX+00),A
;LCCDE   LD   A,(IX+07)
;CCE1:   OR   30
;CCE3:   LD   (IX+07),A
;CCE6:   JP   LB9A7

@@259   ldy #$10 ; INC  (IX+10)
        lda (z80_ix),y
        clc
        adc #$01
        sta (z80_ix),y
        ;ldy #$10 ; LD   A,(IX+10)
        ;lda (z80_ix),y
        and #$03 ; AND  03
        sta z80_b ; LD   B,A
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        and #$FC ; AND  FC
        clc ; ADD  A,B
        adc z80_b
        ;ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y
LCCDE   ldy #$07 ; LD   A,(IX+07)
        lda (z80_ix),y
        ora #$30 ; OR   30
        ;ldy #$07 ; LD   (IX+07),A
        sta (z80_ix),y
        jmp LB9A7 ; JP   LB9A7

;LCCE9   LD   A,(IX+14)
;CCEC:   NEG
;CCEE:   LD   (IX+14),A
;CCF1:   RET

LCCE9   ldy #$14 ; LD   A,(IX+14)
        lda (z80_ix),y
        eor #$ff ; NEG
        clc
        adc #$01
        ldy #$14 ; LD   (IX+14),A
        sta (z80_ix),y
        rts ; RET

;LCCF2   LD   A,(IX+15)
;CCF5:   NEG
;CCF7:   LD   (IX+15),A
;CCFA:   RET

LCCF2   ldy #$15 ; LD   A,(IX+15)
        lda (z80_ix),y
        eor #$ff ; NEG
        clc
        adc #$01
        ldy #$15 ; LD   (IX+15),A
        sta (z80_ix),y
        rts ; RET

;LCCFB   LD   A,(IX+16)
;CCFE:   NEG
;CD00:   LD   (IX+16),A
;CD03:   RET

LCCFB   ldy #$16 ; LD   A,(IX+16)
        lda (z80_ix),y
        eor #$ff ; NEG
        clc
        adc #$01
        ldy #$16 ; LD   (IX+16),A
        sta (z80_ix),y
        rts ; RET

;LCD04   ADD  A,03
;CD06:   RET  M
;CD07:   CP   38
;CD09:   RET  C
;CD0A:   LD   A,38
;CD0C:   RET

LCD04   clc ; ADD  A,03
        adc #$03
        bpl *+3 ; RET  M
        rts
        cmp #$38 ; CP   38
        bcs *+3 ; RET  C
        rts
        lda #$38 ; LD   A,38
        rts ; RET

;LCD0D   SUB  03
;CD0F:   RET  P
;CD10:   CP   B8
;CD12:   RET  NC
;CD13:   LD   A,B8
;CD15:   RET

LCD0D   sec ; SUB  03
        sbc #$03
        bmi *+3 ; RET  P
        rts
        cmp #$B8 ; CP   B8
        bcc *+3 ; RET  NC
        rts
        lda #$B8 ; LD   A,B8
        rts ; RET

;LCD16   CALL LC75F
;CD19:   LD   A,(LA777)
;CD1C:   CP   52
;CD1E:   JP   NZ,LCD84
;CD21:   LD   A,(LA70F)
;CD24:   AND  A
;CD25:   JP   Z,LCD84
;CD28:   LD   A,(IX+00)
;CD2B:   AND  07
;CD2D:   ADD  A,A
;CD2E:   LD   L,A
;CD2F:   LD   H,00
;CD31:   LD   DE,D562
;CD34:   ADD  HL,DE
;CD35:   LD   A,(HL)
;CD36:   LD   (IX+15),A
;CD39:   INC  HL
;CD3A:   LD   A,(HL)
;CD3B:   LD   (IX+16),A
;CD3E:   CALL LD085
;CD41:   CALL LB97C
;CD44:   LD   A,(IX+01)
;CD47:   SUB  (IX+15)
;CD4A:   LD   C,A
;CD4B:   LD   A,(IX+02)
;CD4E:   SUB  (IX+16)
;CD51:   OR   C
;CD52:   JP   NZ,LCD87
;CD55:   LD   A,(IX+00)
;CD58:   ADD  A,08
;CD5A:   LD   C,A
;CD5B:   LD   A,(IX+00)
;CD5E:   CALL LCF9E
;CD61:   LD   A,(LA74B)
;CD64:   INC  A
;CD65:   LD   (LA74B),A
;CD68:   CP   05
;CD6A:   JP   NC,GameCompletedMsg
;CD6D:   JP   LCD87

LCD16   jsr LC75F ; CALL LC75F
        lda LA777 ; LD   A,(LA777)
        cmp #$52 ; CP   52
        jne LCD84 ; JP   NZ,LCD84
        lda LA70F ; LD   A,(LA70F)
        ; AND  A: 
        jeq LCD84 ; JP   Z,LCD84
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        and #$07 ; AND  07
        asl @ ; ADD  A,A
        sta z80_l ; LD   L,A
        lda #$00 ; LD   H,00
        sta z80_h
        lda #<LD562 ; LD   DE,D562
        sta z80_e
        lda #>LD562
        sta z80_d
        jsr add_hl_de ; ADD  HL,DE
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ldy #$15 ; LD   (IX+15),A
        sta (z80_ix),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ldy #$16 ; LD   (IX+16),A
        sta (z80_ix),y
        jsr LD085 ; CALL LD085
        jsr LB97C ; CALL LB97C
        ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        ldy #$15 ; SUB  (IX+15)
        sec
        sbc (z80_ix),y
        sta z80_c ; LD   C,A
        ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        ldy #$16 ; SUB  (IX+16)
        sec
        sbc (z80_ix),y
        ora z80_c ; OR   C
        jne LCD87 ; JP   NZ,LCD87
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        clc ; ADD  A,08
        adc #$08
        sta z80_c ; LD   C,A
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        jsr LCF9E ; CALL LCF9E
        lda LA74B ; LD   A,(LA74B)
        clc ; INC  A
        adc #$01
        sta LA74B ; LD   (LA74B),A
        cmp #$05 ; CP   05
        jcs GameCompletedMsg ; JP   NC,GameCompletedMsg
        jmp LCD87 ; JP   LCD87

;LCD70   CALL LC291
;CD73:   JR   LCD81

LCD70   jsr LC291 ; CALL LC291
        jmp LCD81 ; JR   LCD81

;LCD75   XOR  A
;CD76:   LD   (IX+09),A
;CD79:   LD   (IX+0A),A
;LCD7C   CALL LC769
;CD7F:   JR   LCD84

LCD75   lda #$00 ; XOR  A
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
LCD7C   jsr LC769 ; CALL LC769
        jmp LCD84 ; JR   LCD84

;LCD81   CALL LC75F
;LCD84   CALL LB979
;LCD87   LD   A,(IX+09)
;CD8A:   OR   (IX+0A)
;CD8D:   OR   (IX+0B)
;CD90:   RET  Z
;CD91:   LD   (IX+09),00
;CD95:   LD   (IX+0A),00
;CD99:   LD   (IX+0B),00
;CD9D:   JP   LCCDE

LCD81   jsr LC75F ; CALL LC75F
LCD84   jsr LB979 ; CALL LB979
LCD87   ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        ;ldy #$0A ; OR   (IX+0A)
		iny
        ora (z80_ix),y
        ;ldy #$0B ; OR   (IX+0B)
		iny
        ora (z80_ix),y
        bne *+3 ; RET  Z
        rts
        ldy #$09 ; LD   (IX+09),00
        lda #$00
        sta (z80_ix),y
        ;ldy #$0A ; LD   (IX+0A),00
		iny
        ;lda #$00
        sta (z80_ix),y
        ;ldy #$0B ; LD   (IX+0B),00
		iny
        ;lda #$00
        sta (z80_ix),y
        jmp LCCDE ; JP   LCCDE

;LCDA0   CALL LC75F
;CDA3:   LD   (IX+09),00
;CDA7:   LD   (IX+0A),00
;CDAB:   LD   A,(IX+0B)
;CDAE:   AND  A
;CDAF:   JR   Z,@@264
;CDB1:   LD   A,FF
;CDB3:   LD   (IX+0B),A
;@@264   CALL LB97C
;CDB9:   JR   LCD87

LCDA0   jsr LC75F ; CALL LC75F
        ldy #$09 ; LD   (IX+09),00
        lda #$00
        sta (z80_ix),y
        ldy #$0A ; LD   (IX+0A),00
        lda #$00
        sta (z80_ix),y
        ldy #$0B ; LD   A,(IX+0B)
        lda (z80_ix),y
        ; AND  A: 
        jeq @@264 ; JR   Z,@@264
        lda #$FF ; LD   A,FF
        ldy #$0B ; LD   (IX+0B),A
        sta (z80_ix),y
@@264   jsr LB97C ; CALL LB97C
        jmp LCD87 ; JR   LCD87

;LCDBB   LD   (IX+09),00
;CDBF:   LD   (IX+0A),00
;CDC3:   CALL LC75F
;CDC6:   CALL LB97C
;CDC9:   XOR  A
;CDCA:   LD   (IX+09),A
;CDCD:   LD   (IX+0A),A
;CDD0:   BIT  0,(IX+17)
;CDD4:   JR   NZ,@@265
;CDD6:   BIT  2,(IX+0C)
;CDDA:   JR   Z,LCD87
;CDDC:   BIT  7,(IX+17)
;CDE0:   JR   Z,LCD87
;CDE2:   RES  7,(IX+17)
;CDE6:   SET  0,(IX+17)
;CDEA:   JR   @@266

LCDBB   ldy #$09 ; LD   (IX+09),00
        lda #$00
        sta (z80_ix),y
        ldy #$0A ; LD   (IX+0A),00
        lda #$00
        sta (z80_ix),y
        jsr LC75F ; CALL LC75F
        jsr LB97C ; CALL LB97C
        lda #$00 ; XOR  A
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        ldy #$17 ; BIT  0,(IX+17)
        lda (z80_ix),y
        bit _bitmem0
        jne @@265 ; JR   NZ,@@265
        ldy #$0C ; BIT  2,(IX+0C)
        lda (z80_ix),y
        bit _bitmem2
        jeq LCD87 ; JR   Z,LCD87
        ldy #$17 ; BIT  7,(IX+17)
        lda (z80_ix),y
        bit _bitmem7
        jeq LCD87 ; JR   Z,LCD87
        ldy #$17 ; RES  7,(IX+17)
        lda (z80_ix),y
        and #_notbitvalue7
        sta (z80_ix),y
        ldy #$17 ; SET  0,(IX+17)
        lda (z80_ix),y
        ora #_bitvalue0
        sta (z80_ix),y
        jmp @@266 ; JR   @@266

;@@265   BIT  2,(IX+0C)
;CDF0:   JR   NZ,@@267
;CDF2:   SET  1,(IX+17)
;CDF6:   LD   (IX+0B),FF
;CDFA:   JP   LCCDE

@@265   ldy #$0C ; BIT  2,(IX+0C)
        lda (z80_ix),y
        bit _bitmem2
        jne @@267 ; JR   NZ,@@267
        ldy #$17 ; SET  1,(IX+17)
        lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
        ldy #$0B ; LD   (IX+0B),FF
        lda #$FF
        sta (z80_ix),y
        jmp LCCDE ; JP   LCCDE

;@@267   BIT  1,(IX+17)
;CE01:   JR   NZ,@@268
;CE03:   LD   A,(IX+03)
;CE06:   CP   B0
;CE08:   JR   C,@@266
;CE0A:   LD   (IX+03),B0
;CE0E:   LD   A,FE
;CE10:   LD   (LA77A),A
;CE13:   JP   LCCDE

@@267   ldy #$17 ; BIT  1,(IX+17)
        lda (z80_ix),y
        bit _bitmem1
        jne @@268 ; JR   NZ,@@268
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        cmp #$B0 ; CP   B0
        jcc @@266 ; JR   C,@@266
        ldy #$03 ; LD   (IX+03),B0
        lda #$B0
        sta (z80_ix),y
        lda #$FE ; LD   A,FE
        sta LA77A ; LD   (LA77A),A
        jmp LCCDE ; JP   LCCDE

;@@266   LD   (IX+0B),02
;CE1A:   LD   A,03
;CE1C:   LD   (LA77A),A
;CE1F:   LD   A,(LA77B)
;CE22:   OR   04
;CE24:   LD   (LA77B),A
;CE27:   JP   LCCDE

@@266   ldy #$0B ; LD   (IX+0B),02
        lda #$02
        sta (z80_ix),y
        lda #$03 ; LD   A,03
        sta LA77A ; LD   (LA77A),A
        lda LA77B ; LD   A,(LA77B)
        ora #$04 ; OR   04
        sta LA77B ; LD   (LA77B),A
        jmp LCCDE ; JP   LCCDE

;@@268   LD   (IX+17),00
;CE2E:   JP   LCD87

@@268   ldy #$17 ; LD   (IX+17),00
        lda #$00
        sta (z80_ix),y
        jmp LCD87 ; JP   LCD87

;LCE31   CALL LC75F
;CE34:   XOR  A
;CE35:   LD   (IX+09),A
;CE38:   LD   (IX+0A),A
;CE3B:   BIT  2,(IX+0D)
;CE3F:   JR   NZ,@@269
;CE41:   LD   (IX+0B),A
;CE44:   CALL LB979
;CE47:   BIT  2,(IX+0C)
;CE4B:   JR   Z,@@270
;CE4D:   SET  2,(IX+0D)
;CE51:   LD   (IX+0B),02
;@@270   XOR  A
;CE56:   LD   (IX+09),A
;CE59:   LD   (IX+0A),A
;CE5C:   JP   LCCDE

LCE31   jsr LC75F ; CALL LC75F
        lda #$00 ; XOR  A
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        ldy #$0D ; BIT  2,(IX+0D)
        lda (z80_ix),y
        bit _bitmem2
        jne @@269 ; JR   NZ,@@269
        ldy #$0B ; LD   (IX+0B),A
		lda #$00
        sta (z80_ix),y
        jsr LB979 ; CALL LB979
        ldy #$0C ; BIT  2,(IX+0C)
        lda (z80_ix),y
        bit _bitmem2
        jeq @@270 ; JR   Z,@@270
        ldy #$0D ; SET  2,(IX+0D)
        lda (z80_ix),y
        ora #_bitvalue2
        sta (z80_ix),y
        ldy #$0B ; LD   (IX+0B),02
        lda #$02
        sta (z80_ix),y
@@270   lda #$00 ; XOR  A
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        jmp LCCDE ; JP   LCCDE

;@@269   LD   A,(LA77B)
;CE62:   AND  08
;CE64:   JR   Z,@@271
;CE66:   RES  7,(IX+17)
;@@271   LD   A,(IX+0B)
;CE6D:   AND  A
;CE6E:   BIT  7,(IX+17)
;CE72:   JR   NZ,@@272
;CE74:   AND  A
;CE75:   JR   Z,@@273
;@@272   LD   A,01
;CE79:   JP   P,LCE7E
;CE7C:   ADD  A,02
;LCE7E   LD   (IX+0B),A
;CE81:   CALL LB97C
;CE84:   LD   A,(IX+03)
;CE87:   CP   B0
;CE89:   JR   C,@@270
;CE8B:   RES  2,(IX+0D)
;CE8F:   JR   @@270

@@269   lda LA77B ; LD   A,(LA77B)
        and #$08 ; AND  08
        jeq @@271 ; JR   Z,@@271
        ldy #$17 ; RES  7,(IX+17)
        lda (z80_ix),y
        and #_notbitvalue7
        sta (z80_ix),y
@@271   ldy #$0B ; LD   A,(IX+0B)
        lda (z80_ix),y
		sta z80_a
        ; AND  A
        ldy #$17 ; BIT  7,(IX+17)
        lda (z80_ix),y
        bit _bitmem7
        jne @@272 ; JR   NZ,@@272
		lda z80_a
        ; AND  A
        jeq @@273 ; JR   Z,@@273
@@272   lda #$01 ; LD   A,01
		bit z80_a
        jpl LCE7E ; JP   P,LCE7E
        clc ; ADD  A,02
        adc #$02; 
LCE7E   ldy #$0B ; LD   (IX+0B),A
        sta (z80_ix),y
        jsr LB97C ; CALL LB97C
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        cmp #$B0 ; CP   B0
        jcc @@270 ; JR   C,@@270
        ldy #$0D ; RES  2,(IX+0D)
        lda (z80_ix),y
        and #_notbitvalue2
        sta (z80_ix),y
        jmp @@270 ; JR   @@270

;@@273   CALL LB979
;CE94:   RES  2,(IX+0D)
;CE98:   JR   @@270

@@273   jsr LB979 ; CALL LB979
        ldy #$0D ; RES  2,(IX+0D)
        lda (z80_ix),y
        and #_notbitvalue2
        sta (z80_ix),y
        jmp @@270 ; JR   @@270

;LCE9A   CALL LC291
;CE9D:   JP   LCE31

LCE9A   jsr LC291 ; CALL LC291
        jmp LCE31 ; JP   LCE31

;LCEA0   CALL LC291
;LCEA3   CALL LC75F
;CEA6:   XOR  A
;CEA7:   LD   (IX+0A),A
;CEAA:   LD   (IX+0B),A
;CEAD:   BIT  0,(IX+10)
;CEB1:   JR   Z,@@274
;CEB3:   LD   (IX+09),02
;CEB7:   CALL LB97C
;CEBA:   BIT  0,(IX+0C)
;CEBE:   JR   Z,@@275
;CEC0:   RES  0,(IX+10)
;@@275   JP   LCCDE

LCEA0   jsr LC291 ; CALL LC291
LCEA3   jsr LC75F ; CALL LC75F
        lda #$00 ; XOR  A
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        ldy #$0B ; LD   (IX+0B),A
        sta (z80_ix),y
        ldy #$10 ; BIT  0,(IX+10)
        lda (z80_ix),y
        bit _bitmem0
        jeq @@274 ; JR   Z,@@274
        ldy #$09 ; LD   (IX+09),02
        lda #$02
        sta (z80_ix),y
        jsr LB97C ; CALL LB97C
        ldy #$0C ; BIT  0,(IX+0C)
        lda (z80_ix),y
        bit _bitmem0
        jeq @@275 ; JR   Z,@@275
        ldy #$10 ; RES  0,(IX+10)
        lda (z80_ix),y
        and #_notbitvalue0
        sta (z80_ix),y
@@275   jmp LCCDE ; JP   LCCDE

;@@274   LD   (IX+09),FE
;CECB:   CALL LB97C
;CECE:   BIT  0,(IX+0C)
;CED2:   JR   Z,@@275
;CED4:   SET  0,(IX+10)
;CED8:   JR   @@275

@@274   ldy #$09 ; LD   (IX+09),FE
        lda #$FE
        sta (z80_ix),y
        jsr LB97C ; CALL LB97C
        ldy #$0C ; BIT  0,(IX+0C)
        lda (z80_ix),y
        bit _bitmem0
        jeq @@275 ; JR   Z,@@275
        ldy #$10 ; SET  0,(IX+10)
        lda (z80_ix),y
        ora #_bitvalue0
        sta (z80_ix),y
        jmp @@275 ; JR   @@275

;LCEDA   CALL LC291
;LCEDD   CALL LC75F
;CEE0:   XOR  A
;CEE1:   LD   (IX+09),A
;CEE4:   LD   (IX+0B),A
;CEE7:   BIT  0,(IX+10)
;CEEB:   JR   Z,@@276
;CEED:   LD   (IX+0A),02
;CEF1:   CALL LB97C
;CEF4:   BIT  1,(IX+0C)
;CEF8:   JR   Z,@@277
;CEFA:   RES  0,(IX+10)
;@@277   JP   LCCDE

LCEDA   jsr LC291 ; CALL LC291
LCEDD   jsr LC75F ; CALL LC75F
        lda #$00 ; XOR  A
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        ldy #$0B ; LD   (IX+0B),A
        sta (z80_ix),y
        ldy #$10 ; BIT  0,(IX+10)
        lda (z80_ix),y
        bit _bitmem0
        jeq @@276 ; JR   Z,@@276
        ldy #$0A ; LD   (IX+0A),02
        lda #$02
        sta (z80_ix),y
        jsr LB97C ; CALL LB97C
        ldy #$0C ; BIT  1,(IX+0C)
        lda (z80_ix),y
        bit _bitmem1
        jeq @@277 ; JR   Z,@@277
        ldy #$10 ; RES  0,(IX+10)
        lda (z80_ix),y
        and #_notbitvalue0
        sta (z80_ix),y
@@277   jmp LCCDE ; JP   LCCDE

;@@276   LD   (IX+0A),FE
;CF05:   CALL LB97C
;CF08:   BIT  1,(IX+0C)
;CF0C:   JR   Z,@@277
;CF0E:   SET  0,(IX+10)
;CF12:   JR   @@277

@@276   ldy #$0A ; LD   (IX+0A),FE
        lda #$FE
        sta (z80_ix),y
        jsr LB97C ; CALL LB97C
        ldy #$0C ; BIT  1,(IX+0C)
        lda (z80_ix),y
        bit _bitmem1
        jeq @@277 ; JR   Z,@@277
        ldy #$10 ; SET  0,(IX+10)
        lda (z80_ix),y
        ora #_bitvalue0
        sta (z80_ix),y
        jmp @@277 ; JR   @@277

;LCF14   CALL LC75F
;CF17:   CALL LB97C
;CF1A:   BIT  2,(IX+07)
;CF1E:   RET  Z
;CF1F:   JP   LCD87

LCF14   jsr LC75F ; CALL LC75F
        jsr LB97C ; CALL LB97C
        ldy #$07 ; BIT  2,(IX+07)
        lda (z80_ix),y
        bit _bitmem2
        bne *+3 ; RET  Z
        rts
        jmp LCD87 ; JP   LCD87

;LCF22   CALL LC75F
;CF25:   CALL LC291
;CF28:   LD   (IX+0B),00
;CF2C:   CALL LB979
;CF2F:   RES  6,(IX+07)
;CF33:   LD   A,(LA715)
;CF36:   AND  01
;CF38:   JR   Z,@@278
;CF3A:   SET  6,(IX+07)
;@@278   BIT  0,(IX+0C)
;CF42:   JR   NZ,@@279
;CF44:   BIT  1,(IX+0C)
;CF48:   JR   NZ,@@279
;CF4A:   LD   A,(IX+09)
;CF4D:   OR   (IX+0A)
;CF50:   JR   NZ,@@280
;@@279   LD   A,(LA70D)
;CF55:   AND  08
;CF57:   SUB  04
;CF59:   LD   (IX+09),A
;CF5C:   LD   A,R
;CF5E:   AND  08
;CF60:   SUB  04
;CF62:   LD   (IX+0A),A
;@@280   JP   LCCDE

LCF22   jsr LC75F ; CALL LC75F
        jsr LC291 ; CALL LC291
        ldy #$0B ; LD   (IX+0B),00
        lda #$00
        sta (z80_ix),y
        jsr LB979 ; CALL LB979
        ldy #$07 ; RES  6,(IX+07)
        lda (z80_ix),y
        and #_notbitvalue6
        sta (z80_ix),y
        lda LA715 ; LD   A,(LA715)
        and #$01 ; AND  01
        jeq @@278 ; JR   Z,@@278
        ldy #$07 ; SET  6,(IX+07)
        lda (z80_ix),y
        ora #_bitvalue6
        sta (z80_ix),y
@@278   ldy #$0C ; BIT  0,(IX+0C)
        lda (z80_ix),y
		and #$03
		jne @@279
        ;bit _bitmem0
        ;jne @@279 ; JR   NZ,@@279
        ;ldy #$0C ; BIT  1,(IX+0C)
        ;lda (z80_ix),y
        ;bit _bitmem1
        ;jne @@279 ; JR   NZ,@@279
        ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        ldy #$0A ; OR   (IX+0A)
        ora (z80_ix),y
        jne @@280 ; JR   NZ,@@280
@@279   lda LA70D ; LD   A,(LA70D)
        and #$08 ; AND  08
        sec ; SUB  04
        sbc #$04
        ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
		
        ld_a_r ; LD   A,R
		
		and #$08 ; AND  08
        sec ; SUB  04
        sbc #$04
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
		
		
@@280   jmp LCCDE ; JP   LCCDE

;LCF68   CALL LC75F
;CF6B:   CALL LB97C
;CF6E:   BIT  0,(IX+16)
;CF72:   RET  Z
;CF73:   LD   A,(LA74C)
;CF76:   INC  A
;CF77:   LD   (LA74C),A
;CF7A:   LD   A,(LA721)
;CF7D:   INC  A
;CF7E:   LD   (LA721),A
;CF81:   PUSH IX
;CF83:   CALL PrintLives
;CF86:   POP  IX
;CF88:   RES  0,(IX+16)
;CF8C:   LD   A,(IX+00)
;CF8F:   ADD  A,04
;CF91:   LD   C,A
;CF92:   LD   A,(IX+00)
;CF95:   CALL LCF9E
;CF98:   CALL LD13A
;CF9B:   JP   LCCDE

LCF68   jsr LC75F ; CALL LC75F
        jsr LB97C ; CALL LB97C
        ldy #$16 ; BIT  0,(IX+16)
        lda (z80_ix),y
        bit _bitmem0
        bne *+3 ; RET  Z
        rts
        lda LA74C ; LD   A,(LA74C)
        clc ; INC  A
        adc #$01
        sta LA74C ; LD   (LA74C),A
        lda LA721 ; LD   A,(LA721)
        clc ; INC  A
        adc #$01
        sta LA721 ; LD   (LA721),A
        lda z80_ix ; PUSH IX
        pha
        lda z80_ix+1
        pha
        jsr PrintLives ; CALL PrintLives
        pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix
        ldy #$16 ; RES  0,(IX+16)
        lda (z80_ix),y
        and #_notbitvalue0
        sta (z80_ix),y
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        clc ; ADD  A,04
        adc #$04
        sta z80_c ; LD   C,A
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        jsr LCF9E ; CALL LCF9E
        jsr LD13A ; CALL LD13A
        jmp LCCDE ; JP   LCCDE

;LCF9E   CALL LD07B
;@@282   CP   (IY+00)
;CFA4:   JR   Z,@@281
;CFA6:   ADD  IY,DE
;CFA8:   DJNZ @@282
;CFAA:   RET

LCF9E   sta z80_a
		jsr LD07B ; CALL LD07B
@@282   ldy #$00 ; CP   (IY+00)
		lda z80_a
        cmp (z80_iy),y
        jeq @@281 ; JR   Z,@@281
        jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@282
        jne @@282
        rts ; RET

;@@281   LD   (IY+00),C
;CFAE:   LD   (IX+00),C
;CFB1:   RET

@@281   ldy #$00 ; LD   (IY+00),C
        lda z80_c
        sta (z80_iy),y
        ldy #$00 ; LD   (IX+00),C
        lda z80_c
        sta (z80_ix),y
        rts ; RET

;LCFB2   LD   D,01
;CFB4:   LD   IY,ScreenMakeUpTable
;CFB8:   LD   A,(IY+00)
;CFBB:   AND  F8
;CFBD:   CALL LC21E
;CFC0:   LD   A,D
;CFC1:   AND  A
;CFC2:   RET  Z
;CFC3:   LD   IY,A7CF
;CFC7:   LD   A,(IY+00)
;CFCA:   AND  F8
;CFCC:   CALL LC216
;CFCF:   LD   A,D
;CFD0:   AND  A
;CFD1:   RET

LCFB2   lda #$01 ; LD   D,01
        sta z80_d
        lda #<ScreenMakeUpTable ; LD   IY,ScreenMakeUpTable
        sta z80_iy
        lda #>ScreenMakeUpTable
        sta z80_iy+1
        ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        and #$F8 ; AND  F8
        jsr LC21E ; CALL LC21E
        lda z80_d ; LD   A,D
        ; AND  A
        bne *+3 ; RET  Z
        rts
        lda #<LA7CF ; LD   IY,A7CF
        sta z80_iy
        lda #>LA7CF
        sta z80_iy+1
        ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        and #$F8 ; AND  F8
        jsr LC216 ; CALL LC216
        lda z80_d ; LD   A,D
        ; AND  A
        rts ; RET

;LCFD2   CALL LC75F
;CFD5:   CALL LB97C
;CFD8:   LD   A,(LA70E)
;CFDB:   AND  A
;CFDC:   RET  NZ
;CFDD:   CALL LCFB2
;CFE0:   RET  NZ
;CFE1:   INC  (IX+14)
;CFE4:   LD   A,(IX+14)
;CFE7:   CP   20
;CFE9:   RET  C
;CFEA:   LD   (IX+14),00
;CFEE:   CALL LD071
;CFF1:   LD   A,5A
;@@283   CP   (IY+00)
;CFF6:   RET  Z
;CFF7:   ADD  IY,DE
;CFF9:   DJNZ @@283
;CFFB:   CALL LD071
;CFFE:   XOR  A
;@@285   CP   (IY+00)
;D002:   JR   Z,@@284
;D004:   ADD  IY,DE
;D006:   DJNZ @@285
;D008:   RET

LCFD2   jsr LC75F ; CALL LC75F
        jsr LB97C ; CALL LB97C
        lda LA70E ; LD   A,(LA70E)
        ; AND  A
        beq *+3 ; RET  NZ
        rts
        jsr LCFB2 ; CALL LCFB2
        beq *+3 ; RET  NZ
        rts; 
        ldy #$14 ; INC  (IX+14)
        lda (z80_ix),y
        clc
        adc #$01
        sta (z80_ix),y
        ldy #$14 ; LD   A,(IX+14)
        lda (z80_ix),y
        cmp #$20 ; CP   20
        bcs *+3 ; RET  C
        rts
        ldy #$14 ; LD   (IX+14),00
        lda #$00
        sta (z80_ix),y
        jsr LD071 ; CALL LD071
        lda #$5A ; LD   A,5A
		sta z80_a
@@283   lda z80_a
		ldy #$00 ; CP   (IY+00)
        cmp (z80_iy),y
        bne *+3 ; RET  Z
        rts
        jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@283
        jne @@283
        jsr LD071 ; CALL LD071
        lda #$00 ; XOR  A
@@285   ldy #$00 ; CP   (IY+00)
        cmp (z80_iy),y
        jeq @@284 ; JR   Z,@@284
        jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@285
        jne @@285
        rts ; RET

;@@284   PUSH IX
;D00B:   POP  HL
;D00C:   PUSH IY
;D00E:   POP  DE
;D00F:   LD   BC,0020
;D012:   LDIR
;D014:   LD   (IY+00),5A
;D018:   LD   (IY+03),8D
;D01C:   LD   A,08
;D01E:   LD   (IY+04),A
;D021:   LD   (IY+05),A
;D024:   LD   (IY+06),0C
;D028:   LD   (IY+07),14
;D02C:   LD   (IY+0B),01
;D030:   LD   DE,LD542
;D033:   LD   (IY+10),E
;D036:   LD   (IY+11),D
;D039:   LD   A,(IX+01)
;D03C:   LD   (IY+01),A
;D03F:   LD   A,(IX+02)
;D042:   ADD  A,08
;D044:   LD   (IY+02),A
;D047:   LD   A,01
;D049:   LD   (LA70E),A
;D04C:   PUSH IX
;D04E:   PUSH IY
;D050:   POP  IX
;D052:   CALL LC75F
;D055:   CALL LB2C5
;D058:   CALL LB979
;D05B:   CALL LCCDE
;D05E:   POP  IX
;D060:   LD   IY,LD542
;D064:   LD   (IY+00),5A
;D068:   LD   A,(IX+08)
;D06B:   LD   (IY+08),A
;D06E:   JP   LCCDE

@@284   lda z80_ix ; PUSH IX
        pha
        lda z80_ix+1
        pha
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        pla ; POP  DE
        sta z80_d
        pla
        sta z80_e
        lda #<L0020 ; LD   BC,0020
        sta z80_c
        lda #>L0020
        sta z80_b
        jsr ldir ; LDIR
        ldy #$00 ; LD   (IY+00),5A
        lda #$5A
        sta (z80_iy),y
        ldy #$03 ; LD   (IY+03),8D
        lda #$8D
        sta (z80_iy),y
        lda #$08 ; LD   A,08
        ldy #$04 ; LD   (IY+04),A
        sta (z80_iy),y
        ldy #$05 ; LD   (IY+05),A
        sta (z80_iy),y
        ldy #$06 ; LD   (IY+06),0C
        lda #$0C
        sta (z80_iy),y
        ldy #$07 ; LD   (IY+07),14
        lda #$14
        sta (z80_iy),y
        ldy #$0B ; LD   (IY+0B),01
        lda #$01
        sta (z80_iy),y
        lda #<LD542 ; LD   DE,LD542
        sta z80_e
        lda #>LD542
        sta z80_d
        ldy #$10 ; LD   (IY+10),E
        lda z80_e
        sta (z80_iy),y
        ldy #$11 ; LD   (IY+11),D
        lda z80_d
        sta (z80_iy),y
        ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        ldy #$01 ; LD   (IY+01),A
        sta (z80_iy),y
        ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        clc ; ADD  A,08
        adc #$08
        ldy #$02 ; LD   (IY+02),A
        sta (z80_iy),y
        lda #$01 ; LD   A,01
        sta LA70E ; LD   (LA70E),A
        lda z80_ix ; PUSH IX
        pha
        lda z80_ix+1
        pha
        lda z80_iy ; PUSH IY
        pha
        lda z80_iy+1
        pha
        pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix
        jsr LC75F ; CALL LC75F
        jsr LB2C5 ; CALL LB2C5
        jsr LB979 ; CALL LB979
        jsr LCCDE ; CALL LCCDE
        pla ; POP  IX
        sta z80_ix+1
        pla
        sta z80_ix
        lda #<LD542 ; LD   IY,LD542
        sta z80_iy
        lda #>LD542
        sta z80_iy+1
        ldy #$00 ; LD   (IY+00),5A
        lda #$5A
        sta (z80_iy),y
        ldy #$08 ; LD   A,(IX+08)
        lda (z80_ix),y
        ldy #$08 ; LD   (IY+08),A
        sta (z80_iy),y
        jmp LCCDE ; JP   LCCDE

;LD071   LD   DE,0020
;D074:   LD   IY,A82F
;D078:   LD   B,30
;D07A:   RET

LD071   lda #<L0020 ; LD   DE,0020
        sta z80_e
        lda #>L0020
        sta z80_d
        lda #<LA82F ; LD   IY,A82F
        sta z80_iy
        lda #>LA82F
        sta z80_iy+1
        lda #$30 ; LD   B,30
        sta z80_b
        rts ; RET

;LD07B   LD   DE,0010
;D07E:   LD   IY,LD432
;D082:   LD   B,12
;D084:   RET

LD07B   lda #<$0010 ; LD   DE,0010
        sta z80_e
        lda #>$0010
        sta z80_d
        lda #<LD432 ; LD   IY,LD432
        sta z80_iy
        lda #>LD432
        sta z80_iy+1
        lda #$12 ; LD   B,12
        sta z80_b
        rts ; RET

;LD085   LD   A,(IX+01)
;D088:   CP   (IX+15)
;D08B:   JR   Z,@@286
;D08D:   JR   C,@@287
;D08F:   LD   (IX+09),FF
;D093:   JR   @@286

LD085   ldy #$01 ; LD   A,(IX+01)
        lda (z80_ix),y
        ldy #$15 ; CP   (IX+15)
        cmp (z80_ix),y
        jeq @@286 ; JR   Z,@@286
        jcc @@287 ; JR   C,@@287; 
        ldy #$09 ; LD   (IX+09),FF
        lda #$FF
        sta (z80_ix),y
        jmp @@286 ; JR   @@286

;@@287   LD   (IX+09),01
;@@286   LD   A,(IX+02)
;D09C:   CP   (IX+16)
;D09F:   RET  Z
;D0A0:   JR   C,@@288
;D0A2:   LD   (IX+0A),FF
;D0A6:   RET

@@287   ldy #$09 ; LD   (IX+09),01
        lda #$01
        sta (z80_ix),y
@@286   ldy #$02 ; LD   A,(IX+02)
        lda (z80_ix),y
        ldy #$16 ; CP   (IX+16)
        cmp (z80_ix),y
        bne *+3 ; RET  Z
        rts
        jcc @@288 ; JR   C,@@288; 
        ldy #$0A ; LD   (IX+0A),FF
        lda #$FF
        sta (z80_ix),y
        rts ; RET

;@@288   LD   (IX+0A),01
;D0AB:   RET

@@288   ldy #$0A ; LD   (IX+0A),01
        lda #$01
        sta (z80_ix),y
        rts ; RET

;LD0AC   CALL LC75F
;D0AF:   BIT  0,(IX+14)
;D0B3:   JR   Z,@@289
;D0B5:   CALL LD085
;D0B8:   LD   A,(IX+03)
;D0BB:   CP   B0
;D0BD:   JR   NC,@@290
;D0BF:   LD   (IX+0B),01
;@@290   CALL LB97C
;D0C6:   LD   A,(IX+0A)
;D0C9:   OR   (IX+09)
;D0CC:   OR   (IX+0B)
;D0CF:   JP   NZ,LCD87
;D0D2:   CALL LD071
;D0D5:   LD   C,70
;@@292   LD   A,(IY+00)
;D0DA:   AND  FC
;D0DC:   CP   C
;D0DD:   JR   Z,@@291
;D0DF:   ADD  IY,DE
;D0E1:   DJNZ @@292
;D0E3:   JP   LCD87

LD0AC   jsr LC75F ; CALL LC75F
        ldy #$14 ; BIT  0,(IX+14)
        lda (z80_ix),y
        bit _bitmem0
        jeq @@289 ; JR   Z,@@289
        jsr LD085 ; CALL LD085
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        cmp #$B0 ; CP   B0
        jcs @@290 ; JR   NC,@@290
        ldy #$0B ; LD   (IX+0B),01
        lda #$01
        sta (z80_ix),y
@@290   jsr LB97C ; CALL LB97C
        ldy #$0A ; LD   A,(IX+0A)
        lda (z80_ix),y
        ldy #$09 ; OR   (IX+09)
        ora (z80_ix),y
        ldy #$0B ; OR   (IX+0B)
        ora (z80_ix),y
        jne LCD87 ; JP   NZ,LCD87
        jsr LD071 ; CALL LD071
        lda #$70 ; LD   C,70
        sta z80_c
@@292   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        and #$FC ; AND  FC
        cmp z80_c ; CP   C
        jeq @@291 ; JR   Z,@@291
        jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@292
        jne @@292
        jmp LCD87 ; JP   LCD87

;@@291   SET  0,(IY+16)
;D0EA:   XOR  A
;D0EB:   LD   (LA70E),A
;D0EE:   LD   DE,Audio3
;D0F1:   CALL PlayAudio
;D0F4:   CALL LD07B
;D0F7:   LD   A,5A
;@@294   CP   (IY+00)
;D0FC:   JR   Z,@@293
;D0FE:   ADD  IY,DE
;D100:   DJNZ @@294
;D102:   JP   LC107

@@291   ldy #$16 ; SET  0,(IY+16)
        lda (z80_iy),y
        ora #_bitvalue0
        sta (z80_iy),y
        lda #$00 ; XOR  A
        sta LA70E ; LD   (LA70E),A
		
		; play pyramid activate music
		
;		lda soundfx
;		cmp #01
;		bne prysound00
		
		;lda #04
		;jsr music_on
		
;		jmp prysound01
		
;prysound00

;		lda #07
;		jsr music_on
		
prysound01
		
        ;lda #<Audio3 ; LD   DE,Audio3
        ;sta z80_e
        ;lda #>Audio3
        ;sta z80_d
        ;jsr PlayAudio ; CALL PlayAudio
		
        jsr LD07B ; CALL LD07B
        lda #$5A ; LD   A,5A
@@294   ldy #$00 ; CP   (IY+00)
        cmp (z80_iy),y
        jeq @@293 ; JR   Z,@@293
        jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@294
        jne @@294
        jmp LC107 ; JP   LC107

;@@293   LD   (IY+00),00
;D109:   JP   LC107

@@293   ldy #$00 ; LD   (IY+00),00
        lda #$00
        sta (z80_iy),y
        jmp LC107 ; JP   LC107

;@@289   LD   (IX+0B),FF
;D110:   CALL LB97C
;D113:   CALL LD071
;D116:   LD   C,70
;@@296   LD   A,(IY+00)
;D11B:   AND  FC
;D11D:   CP   C
;D11E:   JR   Z,@@295
;D120:   ADD  IY,DE
;D122:   DJNZ @@296
;D124:   JP   LCD87

@@289   ldy #$0B ; LD   (IX+0B),FF
        lda #$FF
        sta (z80_ix),y
        jsr LB97C ; CALL LB97C
        jsr LD071 ; CALL LD071
        lda #$70 ; LD   C,70
        sta z80_c
@@296   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        and #$FC ; AND  FC
        cmp z80_c ; CP   C
        jeq @@295 ; JR   Z,@@295
        jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@296
        jne @@296
        jmp LCD87 ; JP   LCD87

;@@295   LD   A,(IY+01)
;D12A:   LD   (IX+15),A
;D12D:   LD   A,(IY+02)
;D130:   LD   (IX+16),A
;D133:   SET  0,(IX+14)
;D137:   JP   LCD87

@@295   ldy #$01 ; LD   A,(IY+01)
        lda (z80_iy),y
        ldy #$15 ; LD   (IX+15),A
        sta (z80_ix),y
        ldy #$02 ; LD   A,(IY+02)
        lda (z80_iy),y
        ldy #$16 ; LD   (IX+16),A
        sta (z80_ix),y
        ldy #$14 ; SET  0,(IX+14)
        lda (z80_ix),y
        ora #_bitvalue0
        sta (z80_ix),y
        jmp LCD87 ; JP   LCD87

;LD13A   CALL LD07B
;D13D:   LD   C,00
;@@298   LD   A,(IY+00)
;D142:   AND  FC
;D144:   CP   74
;D146:   JR   NZ,@@297
;D148:   INC  C
;@@297   ADD  IY,DE
;D14B:   DJNZ @@298
;D14D:   LD   A,C
;D14E:   CP   04
;D150:   RET  NZ
;D151:   CALL LD07B
;@@300   LD   A,(IY+00)
;D157:   AND  F8
;D159:   CP   80
;D15B:   JR   NZ,@@299
;D15D:   SET  0,(IX+11)
;D161:   SET  4,(IY+07)
;D165:   LD   A,01
;D167:   LD   (LA70F),A
;@@299   ADD  IY,DE
;D16C:   DJNZ @@300
;D16E:   RET

LD13A   jsr LD07B ; CALL LD07B
        lda #$00 ; LD   C,00
        sta z80_c
@@298   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        and #$FC ; AND  FC
        cmp #$74 ; CP   74
        jne @@297 ; JR   NZ,@@297
        inc z80_c ; INC  C
@@297   jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@298
        jne @@298
        lda z80_c ; LD   A,C
        cmp #$04 ; CP   04
        beq *+3 ; RET  NZ
        rts
        jsr LD07B ; CALL LD07B
@@300   ldy #$00 ; LD   A,(IY+00)
        lda (z80_iy),y
        and #$F8 ; AND  F8
        cmp #$80 ; CP   80
        jne @@299 ; JR   NZ,@@299
        ldy #$11 ; SET  0,(IX+11)
        lda (z80_ix),y
        ora #_bitvalue0
        sta (z80_ix),y
        ldy #$07 ; SET  4,(IY+07)
        lda (z80_iy),y
        ora #_bitvalue4
        sta (z80_iy),y
        lda #$01 ; LD   A,01
        sta LA70F ; LD   (LA70F),A
@@299   jsr add_iy_de ; ADD  IY,DE
        dec z80_b ; DJNZ @@300
        jne @@300
        rts ; RET

;InitObjects: ; D16F
;D16F:   LD   DE,LD432
;D172:   LD   HL,LD312
;D175:   LD   BC,0120
;D178:   LDIR
;D17A:   LD   A,(LA70D)
;D17D:   AND  3C
;D17F:   LD   E,A
;D180:   LD   D,00
;D182:   LD   HL,ObjectLocations
;D185:   ADD  HL,DE
;D186:   LD   IY,LD472
;D18A:   LD   C,05
;D18C:   LD   DE,000D
;@@302   LD   A,(HL)
;D190:   LD   (IY+08),A
;D193:   LD   B,03
;@@301   INC  HL
;D196:   INC  IY
;D198:   LD   A,(HL)
;D199:   LD   (IY+00),A
;D19C:   DJNZ @@301
;D19E:   INC  HL
;D19F:   ADD  IY,DE
;D1A1:   DEC  C
;D1A2:   JR   NZ,@@302
;D1A4:   RET

InitObjects: ; D16F
        lda #<LD432 ; LD   DE,LD432
        sta z80_e
        lda #>LD432
        sta z80_d
        lda #<LD312 ; LD   HL,LD312
        sta z80_l
        lda #>LD312
        sta z80_h
        lda #<L0120 ; LD   BC,0120
        sta z80_c
        lda #>L0120
        sta z80_b
        jsr ldir ; LDIR
        
		; test for runes gen - REMOVE
		;lda #16
		;sta LA70D
		
		lda LA70D ; LD   A,(LA70D)
        and #$3C ; AND  3C
				
		sta z80_e ; LD   E,A
        lda #$00 ; LD   D,00
        sta z80_d
        lda #<ObjectLocations ; LD   HL,ObjectLocations
        sta z80_l
        lda #>ObjectLocations
        sta z80_h
        jsr add_hl_de ; ADD  HL,DE
        lda #<LD472 ; LD   IY,LD472
        sta z80_iy
        lda #>LD472
        sta z80_iy+1
        lda #$05 ; LD   C,05
        sta z80_c
        lda #<$000D ; LD   DE,000D
        sta z80_e
        lda #>$000D
        sta z80_d
@@302   ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ldy #$08 ; LD   (IY+08),A
        sta (z80_iy),y
        lda #$03 ; LD   B,03
        sta z80_b
@@301   inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        inc z80_iy ; INC  IY
        bne *+4
        inc z80_iy+1
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        ldy #$00 ; LD   (IY+00),A
        sta (z80_iy),y
        dec z80_b ; DJNZ @@301
        jne @@301
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        jsr add_iy_de ; ADD  IY,DE
        dec z80_c ; DEC  C
        jne @@302 ; JR   NZ,@@302
				
        rts ; RET

;ObjectLocations: ; D1A5
;D1A5:   DB 78,B8,48,80,25,48,48,A4,3E,78,B8,80,70,B8,B8,81
;D1B5:   DB 6C,78,B8,98,00,68,78,98,45,B8,B8,80,8E,48,98,B0
;D1C5:   DB 4E,80,80,81,0F,78,48,A4,2A,78,78,B0,05,68,78,A4
;D1D5:   DB 8D,78,68,B0,46,80,80,80,04,B8,78,B0,10,48,78,B0
;D1E5:   DB 81,A8,48,81,12,58,58,B0,92,A8,98,B0,1B,48,78,B0

ObjectLocations: ; D1A5
        .he 78,B8,48,80,25,48,48,A4,3E,78,B8,80,70,B8,B8,81 ; DB 78,B8,48,80,25,48,48,A4,3E,78,B8,80,70,B8,B8,81
        .he 6C,78,B8,98,00,68,78,98,45,B8,B8,80,8E,48,98,B0 ; DB 6C,78,B8,98,00,68,78,98,45,B8,B8,80,8E,48,98,B0
        .he 4E,80,80,81,0F,78,48,A4,2A,78,78,B0,05,68,78,A4 ; DB 4E,80,80,81,0F,78,48,A4,2A,78,78,B0,05,68,78,A4
        .he 8D,78,68,B0,46,80,80,80,04,B8,78,B0,10,48,78,B0 ; DB 8D,78,68,B0,46,80,80,80,04,B8,78,B0,10,48,78,B0
        .he 81,A8,48,81,12,58,58,B0,92,A8,98,B0,1B,48,78,B0 ; DB 81,A8,48,81,12,58,58,B0,92,A8,98,B0,1B,48,78,B0

;LD1F5   LD   A,(IX+07)
;D1F8:   XOR  40
;D1FA:   LD   (IX+07),A
;LD1FD   CALL LC75F
;D200:   CALL LC291
;D203:   CALL LB979
;D206:   LD   A,(IX+03)
;D209:   CP   81
;D20B:   JR   NC,@@303
;D20D:   LD   (IX+03),81
;D211:   LD   (IX+0B),00
;@@303   LD   A,(IX+09)
;D218:   OR   (IX+0A)
;D21B:   JP   NZ,LCCDE
;D21E:   LD   A,R
;D220:   AND  08
;D222:   SUB  04
;D224:   BIT  1,(IX+0C)
;D228:   JR   NZ,@@304
;D22A:   LD   (IX+0A),A
;D22D:   SET  0,(IX+00)
;D231:   RES  6,(IX+07)
;D235:   JR   @@305

LD1F5   ldy #$07 ; LD   A,(IX+07)
        lda (z80_ix),y
        eor #$40 ; XOR  40
        ;ldy #$07 ; LD   (IX+07),A
        sta (z80_ix),y
LD1FD   jsr LC75F ; CALL LC75F
        jsr LC291 ; CALL LC291
        jsr LB979 ; CALL LB979
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        cmp #$81 ; CP   81
        jcs @@303 ; JR   NC,@@303
        ;ldy #$03 ; LD   (IX+03),81
        lda #$81
        sta (z80_ix),y
        ldy #$0B ; LD   (IX+0B),00
        lda #$00
        sta (z80_ix),y
@@303   ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        ldy #$0A ; OR   (IX+0A)
        ora (z80_ix),y
        jne LCCDE ; JP   NZ,LCCDE
		
        ld_a_r ; LD   A,R
		
		and #$08 ; AND  08
        sec ; SUB  04
        sbc #$04
		tax
        ldy #$0C ; BIT  1,(IX+0C)

		
        lda (z80_ix),y
        bit _bitmem1
        jne @@304 ; JR   NZ,@@304
		txa
        ldy #$0A ; LD   (IX+0A),A
        sta (z80_ix),y
        ldy #$00 ; SET  0,(IX+00)
        lda (z80_ix),y
        ora #_bitvalue0
        sta (z80_ix),y
        ldy #$07 ; RES  6,(IX+07)
        lda (z80_ix),y
        and #_notbitvalue6
        sta (z80_ix),y
        jmp @@305 ; JR   @@305

;@@304   LD   (IX+09),A
;D23A:   RES  0,(IX+00)
;D23E:   SET  6,(IX+07)
;@@305   AND  A
;D243:   JP   P,LCCDE
;D246:   LD   A,(IX+00)
;D249:   XOR  01
;D24B:   LD   (IX+00),A
;D24E:   JP   LCCDE

@@304   txa
		ldy #$09 ; LD   (IX+09),A
        sta (z80_ix),y
        ldy #$00 ; RES  0,(IX+00)
        lda (z80_ix),y
        and #_notbitvalue0
        sta (z80_ix),y
        ldy #$07 ; SET  6,(IX+07)
        lda (z80_ix),y
        ora #_bitvalue6
        sta (z80_ix),y
@@305   txa
		; AND  A
        jpl LCCDE ; JP   P,LCCDE
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        eor #$01 ; XOR  01
        ;ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y
        jmp LCCDE ; JP   LCCDE

;LD251   CALL LC75F
;D254:   CALL LC291
;D257:   CALL LB979
;D25A:   LD   A,(IX+00)
;D25D:   XOR  01
;D25F:   LD   (IX+00),A
;D262:   LD   A,(IX+03)
;D265:   CP   81
;D267:   JR   NC,@@306
;D269:   LD   (IX+03),81
;D26D:   LD   (IX+0B),00
;@@306   LD   A,(IX+09)
;D274:   OR   (IX+0A)
;D277:   JP   NZ,LCCDE
;D27A:   LD   A,R
;D27C:   AND  08
;D27E:   SUB  04
;D280:   BIT  1,(IX+0C)
;D284:   JR   NZ,@@307
;D286:   LD   (IX+0A),A
;D289:   SET  1,(IX+00)
;D28D:   RES  6,(IX+07)
;D291:   JR   @@308

LD251   jsr LC75F ; CALL LC75F
        jsr LC291 ; CALL LC291
        jsr LB979 ; CALL LB979
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        eor #$01 ; XOR  01
        ;ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y
        ldy #$03 ; LD   A,(IX+03)
        lda (z80_ix),y
        cmp #$81 ; CP   81
        jcs @@306 ; JR   NC,@@306
        ;ldy #$03 ; LD   (IX+03),81
        lda #$81
        sta (z80_ix),y
        ldy #$0B ; LD   (IX+0B),00
        lda #$00
        sta (z80_ix),y
@@306   ldy #$09 ; LD   A,(IX+09)
        lda (z80_ix),y
        ldy #$0A ; OR   (IX+0A)
        ora (z80_ix),y
        jne LCCDE ; JP   NZ,LCCDE
        
		ld_a_r ; LD   A,R
		
		and #$08 ; AND  08
        sec ; SUB  04
        sbc #$04
		tax
        ldy #$0C ; BIT  1,(IX+0C)##
		
		
        lda (z80_ix),y
        bit _bitmem1
        jne @@307 ; JR   NZ,@@307
        ldy #$0A ; LD   (IX+0A),A
		txa
        sta (z80_ix),y; 
        ldy #$00 ; SET  1,(IX+00)
        lda (z80_ix),y
        ora #_bitvalue1
        sta (z80_ix),y
        ldy #$07 ; RES  6,(IX+07)
        lda (z80_ix),y
        and #_notbitvalue6
        sta (z80_ix),y
        jmp @@308 ; JR   @@308

;@@307   LD   (IX+09),A
;D296:   RES  1,(IX+00)
;D29A:   SET  6,(IX+07)
;@@308   AND  A
;D29F:   JP   P,LCCDE
;D2A2:   LD   A,(IX+00)
;D2A5:   XOR  02
;D2A7:   LD   (IX+00),A
;D2AA:   JP   LCCDE

@@307   ldy #$09 ; LD   (IX+09),A
		txa
        sta (z80_ix),y; 
        ldy #$00 ; RES  1,(IX+00)
        lda (z80_ix),y
        and #_notbitvalue1
        sta (z80_ix),y
        ldy #$07 ; SET  6,(IX+07)
        lda (z80_ix),y
        ora #_bitvalue6
        sta (z80_ix),y
@@308  	txa 
		; AND  A
        jpl LCCDE ; JP   P,LCCDE
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        eor #$02 ; XOR  02
        ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y
        jmp LCCDE ; JP   LCCDE

;LD2AD   CALL LC75F
;D2B0:   LD   (IX+0B),00
;D2B4:   CALL LB97C
;D2B7:   BIT  7,(IX+17)
;D2BB:   RET  Z
;D2BC:   RES  7,(IX+17)
;D2C0:   BIT  3,(IX+0D)
;D2C4:   RET  Z
;D2C5:   RES  3,(IX+0D)
;D2C9:   LD   A,(IX+00)
;D2CC:   CP   8B
;D2CE:   JR   Z,@@309
;D2D0:   INC  A
;D2D1:   LD   (IX+00),A
;D2D4:   JP   LCCDE

LD2AD   jsr LC75F ; CALL LC75F
        ldy #$0B ; LD   (IX+0B),00
        lda #$00
        sta (z80_ix),y
        jsr LB97C ; CALL LB97C
        ldy #$17 ; BIT  7,(IX+17)
        lda (z80_ix),y
        bit _bitmem7
        bne *+3 ; RET  Z
        rts
        ldy #$17 ; RES  7,(IX+17)
        lda (z80_ix),y
        and #_notbitvalue7
        sta (z80_ix),y
        ldy #$0D ; BIT  3,(IX+0D)
        lda (z80_ix),y
        bit _bitmem3
        bne *+3 ; RET  Z
        rts
        ldy #$0D ; RES  3,(IX+0D)
        lda (z80_ix),y
        and #_notbitvalue3
        sta (z80_ix),y
        ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        cmp #$8B ; CP   8B
        jeq @@309 ; JR   Z,@@309
        clc ; INC  A
        adc #$01; 
        ldy #$00 ; LD   (IX+00),A
        sta (z80_ix),y
        jmp LCCDE ; JP   LCCDE

;@@309   LD   (IX+00),01
;D2DB:   JP   LCCDE

@@309   ldy #$00 ; LD   (IX+00),01
        lda #$01
        sta (z80_ix),y
        jmp LCCDE ; JP   LCCDE

;LD2DE   CALL LC75F
;D2E1:   RES  3,(IX+0D)
;D2E5:   CALL LB97C
;D2E8:   RET

LD2DE   jsr LC75F ; CALL LC75F
        ldy #$0D ; RES  3,(IX+0D)
        lda (z80_ix),y
        and #_notbitvalue3
        sta (z80_ix),y
        jsr LB97C ; CALL LB97C
        rts ; RET

;LD2E9   CALL LC75F
;D2EC:   RES  3,(IX+0D)
;D2F0:   CALL LB97C
;D2F3:   RET

LD2E9   jsr LC75F ; CALL LC75F
        ldy #$0D ; RES  3,(IX+0D)
        lda (z80_ix),y
        and #_notbitvalue3
        sta (z80_ix),y
        jsr LB97C ; CALL LB97C
        rts ; RET

;LD2F4   CALL LC75F
;D2F7:   RES  3,(IX+0D)
;D2FB:   CALL LB97C
;D2FE:   RET

LD2F4   jsr LC75F ; CALL LC75F
        ldy #$0D ; RES  3,(IX+0D)
        lda (z80_ix),y
        and #_notbitvalue3
        sta (z80_ix),y
        jsr LB97C ; CALL LB97C
        rts ; RET

;LD2FF   CALL LC75F
;D302:   RES  3,(IX+0D)
;D306:   CALL LB97C
;D309:   RET

LD2FF   jsr LC75F ; CALL LC75F
        ldy #$0D ; RES  3,(IX+0D)
        lda (z80_ix),y
        and #_notbitvalue3
        sta (z80_ix),y
        jsr LB97C ; CALL LB97C
        rts ; RET

;LD30A   DB 02,00,FE,00,00,02,00,FE

LD30A   .he 02,00,FE,00,00,02,00,FE ; DB 02,00,FE,00,00,02,00,FE

;LD312   DB 70,50,A0,80,08,08,20,10,7A,00,00,00,00,00,00,00
;D322:   DB 71,70,A0,80,08,08,20,10,80,00,00,00,00,00,00,00
;D332:   DB 72,84,A0,80,08,08,20,10,11,00,00,00,00,00,00,00
;D342:   DB 73,A0,A0,80,08,08,20,10,21,00,00,00,00,00,00,00
;D352:   DB 94,50,50,80,08,08,0C,14,61,00,00,00,00,00,00,00
;D362:   DB 93,50,80,80,08,08,0C,14,61,00,00,00,00,00,00,00
;D372:   DB 92,70,80,80,08,08,0C,14,61,00,00,00,00,00,00,00
;D382:   DB 91,80,80,80,08,08,0C,14,61,00,00,00,00,00,00,00
;D392:   DB 90,A0,80,80,08,08,0C,14,61,00,00,00,00,00,00,00
;D3A2:   DB 80,60,80,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
;D3B2:   DB 81,6C,8C,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
;D3C2:   DB 82,78,98,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
;D3D2:   DB 83,84,A4,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
;D3E2:   DB 84,78,68,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
;D3F2:   DB 85,84,74,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
;D402:   DB 86,90,80,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
;D412:   DB 87,9C,8C,7F,0C,0C,00,00,52,00,00,00,00,00,00,00

LD312   .he 70,50,A0,80,08,08,20,10,7A,00,00,00,00,00,00,00 ; DB 70,50,A0,80,08,08,20,10,7A,00,00,00,00,00,00,00
        .he 71,70,A0,80,08,08,20,10,80,00,00,00,00,00,00,00 ; DB 71,70,A0,80,08,08,20,10,80,00,00,00,00,00,00,00
        .he 72,84,A0,80,08,08,20,10,11,00,00,00,00,00,00,00 ; DB 72,84,A0,80,08,08,20,10,11,00,00,00,00,00,00,00
        .he 73,A0,A0,80,08,08,20,10,21,00,00,00,00,00,00,00 ; DB 73,A0,A0,80,08,08,20,10,21,00,00,00,00,00,00,00
        .he 94,50,50,80,08,08,0C,14,61,00,00,00,00,00,00,00 ; DB 94,50,50,80,08,08,0C,14,61,00,00,00,00,00,00,00
        .he 93,50,80,80,08,08,0C,14,61,00,00,00,00,00,00,00 ; DB 93,50,80,80,08,08,0C,14,61,00,00,00,00,00,00,00
        .he 92,70,80,80,08,08,0C,14,61,00,00,00,00,00,00,00 ; DB 92,70,80,80,08,08,0C,14,61,00,00,00,00,00,00,00
        .he 91,80,80,80,08,08,0C,14,61,00,00,00,00,00,00,00 ; DB 91,80,80,80,08,08,0C,14,61,00,00,00,00,00,00,00
        .he 90,A0,80,80,08,08,0C,14,61,00,00,00,00,00,00,00 ; DB 90,A0,80,80,08,08,0C,14,61,00,00,00,00,00,00,00
        .he 80,60,80,7F,0C,0C,00,00,52,00,00,00,00,00,00,00 ; DB 80,60,80,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
        .he 81,6C,8C,7F,0C,0C,00,00,52,00,00,00,00,00,00,00 ; DB 81,6C,8C,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
        .he 82,78,98,7F,0C,0C,00,00,52,00,00,00,00,00,00,00 ; DB 82,78,98,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
        .he 83,84,A4,7F,0C,0C,00,00,52,00,00,00,00,00,00,00 ; DB 83,84,A4,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
        .he 84,78,68,7F,0C,0C,00,00,52,00,00,00,00,00,00,00 ; DB 84,78,68,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
        .he 85,84,74,7F,0C,0C,00,00,52,00,00,00,00,00,00,00 ; DB 85,84,74,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
        .he 86,90,80,7F,0C,0C,00,00,52,00,00,00,00,00,00,00 ; DB 86,90,80,7F,0C,0C,00,00,52,00,00,00,00,00,00,00
        .he 87,9C,8C,7F,0C,0C,00,00,52,00,00,00,00,00,00,00 ; DB 87,9C,8C,7F,0C,0C,00,00,52,00,00,00,00,00,00,00

;LD422   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

LD422   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

;LD432   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D442:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D452:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D462:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

LD432   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

;LD472   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D482:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D492:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D4A2:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D4B2:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D4C2:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D4D2:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D4E2:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D4F2:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D502:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D512:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D522:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;D532:   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

LD472   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
        .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

;LD542   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

LD542   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

;LD552   DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;LD562   DB 70,B0,9C,A2,A2,6A,72,5C,50,88

LD552   .he 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
LD562   .he 70,B0,9C,A2,A2,6A,72,5C,50,88 ; DB 70,B0,9C,A2,A2,6A,72,5C,50,88

;LD56C   LD   BC,LD587
;D56F:   BIT  1,(IX+07)
;D573:   RES  1,(IX+07)
;D577:   RET  Z
;D578:   LD   A,(LA715)
;D57B:   AND  0F
;D57D:   LD   L,A
;D57E:   LD   H,00
;D580:   ADD  HL,BC
;D581:   LD   B,(HL)
;D582:   LD   C,0C
;D584:   JP   LD67B

LD56C   lda #<LD587 ; LD   BC,LD587
        sta z80_c
        lda #>LD587
        sta z80_b
        ldy #$07 ; BIT  1,(IX+07)
        lda (z80_ix),y
        bit _bitmem1
		php
        ldy #$07 ; RES  1,(IX+07)
        lda (z80_ix),y
        and #_notbitvalue1
        sta (z80_ix),y
		plp
        bne *+3 ; RET  Z
        rts; 
        lda LA715 ; LD   A,(LA715)
        and #$0F ; AND  0F
        sta z80_l ; LD   L,A
        lda #$00 ; LD   H,00
        sta z80_h
        jsr add_hl_bc ; ADD  HL,BC
        ldy #$00 ; LD   B,(HL)
        lda (z80_hl),y
        sta z80_b
        lda #$0C ; LD   C,0C
        sta z80_c
        jmp LD67B ; JP   LD67B

;LD587   DB 20,20,30,40,50,20,20,30,40,50,20,20,30,40,50,20
;D597:   DB 20,20,30,30,40,40,50,50,60,60,70,70,80,80,90,90
;D5A7:   DB 90,90,80,80,70,70,60,60,50,50,40,40,30,30,20,20
;D5B7:   DB 90,80,70,80,70,60,70,60,50,60,50,40,50,40,30,20
;D5C7:   DB 40,40,40,30,50,50,50,50,40,40,40,30,50,50,50,50

LD587   .he 20,20,30,40,50,20,20,30,40,50,20,20,30,40,50,20 ; DB 20,20,30,40,50,20,20,30,40,50,20,20,30,40,50,20
        .he 20,20,30,30,40,40,50,50,60,60,70,70,80,80,90,90 ; DB 20,20,30,30,40,40,50,50,60,60,70,70,80,80,90,90
        .he 90,90,80,80,70,70,60,60,50,50,40,40,30,30,20,20 ; DB 90,90,80,80,70,70,60,60,50,50,40,40,30,30,20,20
        .he 90,80,70,80,70,60,70,60,50,60,50,40,50,40,30,20 ; DB 90,80,70,80,70,60,70,60,50,60,50,40,50,40,30,20
        .he 40,40,40,30,50,50,50,50,40,40,40,30,50,50,50,50 ; DB 40,40,40,30,50,50,50,50,40,40,40,30,50,50,50,50

;LD5D7   LD   HL,A749
;D5DA:   INC  (HL)
;D5DB:   LD   A,(HL)
;D5DC:   ADD  A,40
;D5DE:   LD   B,A
;D5DF:   LD   C,0C
;D5E1:   JP   LD67B

LD5D7   lda #<LA749 ; LD   HL,A749
        sta z80_l
        lda #>LA749
        sta z80_h
        ldy #$00 ; INC  (HL)
        lda (z80_hl),y
        clc
        adc #$01
        sta (z80_hl),y
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        clc ; ADD  A,40
        adc #$40
        sta z80_b ; LD   B,A
        lda #$0C ; LD   C,0C
        sta z80_c
        jmp LD67B ; JP   LD67B

;LD5E4   LD   C,10
;@@310   LD   A,C
;D5E7:   XOR  A5
;D5E9:   ADD  A,C
;D5EA:   LD   B,A
;D5EB:   CALL LD682
;D5EE:   DEC  C
;D5EF:   JR   NZ,@@310
;D5F1:   RET

LD5E4   lda #$10 ; LD   C,10
        sta z80_c
@@310   lda z80_c ; LD   A,C
        eor #$A5 ; XOR  A5
        clc ; ADD  A,C
        adc z80_c
        sta z80_b ; LD   B,A
        jsr LD682 ; CALL LD682
        dec z80_c ; DEC  C
        jne @@310 ; JR   NZ,@@310
        rts ; RET

;LD5F2   LD   HL,A749
;D5F5:   LD   A,(HL)
;D5F6:   AND  A
;D5F7:   RET  Z
;D5F8:   DEC  (HL)
;D5F9:   EX   AF,AF'
;D5FA:   INC  HL
;D5FB:   LD   A,(HL)
;D5FC:   LD   BC,LD60D
;D5FF:   CALL LD692
;D602:   EX   AF,AF'
;D603:   LD   C,A
;D604:   LD   B,00
;D606:   ADD  HL,BC
;D607:   LD   B,(HL)
;D608:   LD   C,0C
;D60A:   JP   LD67B

LD5F2   ;lda #<LA749 ; LD   HL,A749
        ;sta z80_l
        ;lda #>LA749
        ;sta z80_h
        ;ldy #$00 ; LD   A,(HL)
        ;lda (z80_hl),y
		;tax
		lda LA749
        ; AND  A
        bne *+3 ; RET  Z
        rts
        ;ldy #$00 ; DEC  (HL)
        ;lda (z80_hl),y
        ;sec
        ;sbc #$01
        ;sta (z80_hl),y
		;txa
		dec LA749
        ldx z80_ap ; EX   AF,AF'
        sta z80_ap
        txa 
        ;inc z80_l ; INC  HL
        ;bne *+4
        ;inc z80_h
		
		
        ;lda #<LD60D ; LD   BC,LD60D
        ;sta z80_c
        ;lda #>LD60D
        ;sta z80_b
        
		
		;ldy #$00 ; LD   A,(HL)
        ;lda (z80_hl),y
		lda LA749+1
        jsr LD692 ; CALL LD692
        ;ldx z80_ap ; EX   AF,AF'
		ldy z80_ap
        ;sta z80_ap
        ;txa 
        ;sta z80_c ; LD   C,A
        ;lda #$00 ; LD   B,00
        ;sta z80_b
        ;jsr add_hl_bc ; ADD  HL,BC
        ;ldy #$00 ; LD   B,(HL)
        lda (z80_hl),y
        sta z80_b
        lda #$0C ; LD   C,0C
        sta z80_c
        jmp LD67B ; JP   LD67B

;LD60D   DW LD615,LD619,LD61E,LD625

;LD60D   .wo LD615,LD619,LD61E,LD625 ; DW LD615,LD619,LD61E,LD625

;LD615   DB 40,70,40,70

;LD615   .he 40,70,40,70 ; DB 40,70,40,70

;LD619   DB 50,70,60,50,40

;LD619   .he 50,70,60,50,40 ; DB 50,70,60,50,40

;LD61E   DB 40,50,60,70,80,80,80

;LD61E   .he 40,50,60,70,80,80,80 ; DB 40,50,60,70,80,80,80

;LD625   DB 30,60,30,60

;LD625   .he 30,60,30,60 ; DB 30,60,30,60

;LD629   LD   C,20
;@@311   LD   A,C
;D62C:   SUB  B
;D62D:   LD   B,A
;D62E:   CALL LD682
;D631:   DEC  C
;D632:   JR   NZ,@@311
;D634:   RET

LD629   lda #$20 ; LD   C,20
        sta z80_c
@@311   lda z80_c ; LD   A,C
        sec ; SUB  B
        sbc z80_b
        sta z80_b ; LD   B,A
        jsr LD682 ; CALL LD682
        dec z80_c ; DEC  C
        jne @@311 ; JR   NZ,@@311
        rts ; RET

;LD635   LD   HL,A748
;D638:   INC  (HL)
;D639:   LD   A,(HL)
;D63A:   BIT  2,A
;D63C:   JR   Z,@@312
;D63E:   AND  03
;D640:   RET  NZ
;D641:   LD   BC,4002
;D644:   JR   LD67B

LD635   lda #<LA748 ; LD   HL,A748
        sta z80_l
        lda #>LA748
        sta z80_h
        ldy #$00 ; INC  (HL)
        lda (z80_hl),y
        clc
        adc #$01
        sta (z80_hl),y
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        bit _bitmem2 ; BIT  2,A
        jeq @@312 ; JR   Z,@@312
        and #$03 ; AND  03
        beq *+3 ; RET  NZ
        rts
        lda #<L4002 ; LD   BC,4002
        sta z80_c
        lda #>L4002
        sta z80_b
        jmp LD67B ; JR   LD67B

;@@312   AND  03
;D648:   RET  NZ
;D649:   LD   BC,6002
;D64C:   JR   LD67B

@@312   and #$03 ; AND  03
        beq *+3 ; RET  NZ
        rts
        lda #<L6002 ; LD   BC,6002
        sta z80_c
        lda #>L6002
        sta z80_b
        jmp LD67B ; JR   LD67B

;LD64E   LD   HL,(LA70D)
;D651:   LD   A,H
;D652:   AND  1F
;D654:   LD   H,A
;D655:   LD   E,04
;@@313   LD   A,(HL)
;D658:   INC  HL
;D659:   AND  7F
;D65B:   LD   B,A
;D65C:   LD   C,01
;D65E:   CALL LD67B
;D661:   DEC  E
;D662:   JR   NZ,@@313
;D664:   RET

LD64E   lda LA70D ; LD   HL,(LA70D)
        sta z80_l
        lda LA70D+1
        sta z80_h
        lda z80_h ; LD   A,H
        and #$1F ; AND  1F
        sta z80_h ; LD   H,A
        lda #$04 ; LD   E,04
        sta z80_e
@@313   ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        and #$7F ; AND  7F
        sta z80_b ; LD   B,A
        lda #$01 ; LD   C,01
        sta z80_c
        jsr LD67B ; CALL LD67B
        dec z80_e ; DEC  E
        jne @@313 ; JR   NZ,@@313
        rts ; RET

;LD665   LD   A,(IX+00)
;D668:   CPL
;D669:   RRCA
;D66A:   RRCA
;D66B:   RRCA
;D66C:   AND  E0
;D66E:   LD   B,A
;D66F:   LD   C,06
;D671:   JR   LD67B

LD665   ldy #$00 ; LD   A,(IX+00)
        lda (z80_ix),y
        eor #$ff ; CPL
        lsr @ ; RRCA
        ror @ ; RRCA
        ror @ ; RRCA
		ror @
        and #$E0 ; AND  E0
        sta z80_b ; LD   B,A
        lda #$06 ; LD   C,06
        sta z80_c
        jmp LD67B ; JR   LD67B

;LD673   NOP
;D674:   LD   A,(LD673)
;D677:   CPL
;D678:   LD   B,A
;D679:   LD   C,08
;LD67B   CALL LD682
;D67E:   DEC  C
;D67F:   JR   NZ,LD67B
;D681:   RET

LD673   nop ; NOP
        lda LD673 ; LD   A,(LD673)
        eor #$ff ; CPL
        sta z80_b ; LD   B,A
        lda #$08 ; LD   C,08
        sta z80_c
				
LD67B   

		lda #<sfxwalk      ;Start address of sound effect data
        ldy #>sfxwalk
        ldx #14             ;0, 7 or 14 for channels 1-3
        jsr sfx_play_e 
								
		; sfx walk
		;jsr LD682 ; CALL LD682
		
		dec z80_c ; DEC  C
        jne LD67B ; JR   NZ,LD67B
				
        rts ; RET

;LD682   LD   A,10
;D684:   OUT  (FE),A
;D686:   LD   A,B
;@@314   DJNZ @@314
;D689:   LD   B,A
;D68A:   XOR  A
;D68B:   OUT  (FE),A
;D68D:   LD   A,B
;@@315   DJNZ @@315
;D690:   LD   B,A
;D691:   RET

LD682   lda #$10 ; LD   A,10
        ;jsr out_fe ; OUT  (FE),A
        lda z80_b ; LD   A,B
		tax
@@314   ;dec z80_b ; DJNZ @@314
		dex
        jne @@314
        sta z80_b ; LD   B,A; 
        lda #$00 ; XOR  A
        ;jsr out_fe ; OUT  (FE),A
        lda z80_b ; LD   A,B
		tax
@@315   ;dec z80_b ; DJNZ @@315
		dex
        jne @@315
        sta z80_b ; LD   B,A;
        rts ; RET

;LD692   LD   L,A
;D693:   LD   H,00
;D695:   ADD  HL,HL
;D696:   ADD  HL,BC
;D697:   LD   A,(HL)
;D698:   INC  HL
;D699:   LD   H,(HL)
;D69A:   LD   L,A
;D69B:   RET

LD692   sta z80_l ; LD   L,A
        lda #$00 ; LD   H,00
        sta z80_h
        asl z80_l ; ADD  HL,HL
        rol z80_h
        jsr add_hl_bc ; ADD  HL,BC
        ldy #$00 ; LD   A,(HL)
        lda (z80_hl),y
		tax
        inc z80_l ; INC  HL
        bne *+4
        inc z80_h
        ldy #$00 ; LD   H,(HL)
        lda (z80_hl),y
        sta z80_h
        stx z80_l ; LD   L,A; 
        rts ; RET

;PlayAudioWaitKey: ; D69C
;D69C:   LD   HL,A747
;D69F:   LD   A,(HL)
;D6A0:   AND  A
;D6A1:   RET  NZ
;D6A2:   SET  0,(HL)
;@@318   XOR  A
;D6A5:   CALL ReadKey
;D6A8:   JR   Z,@@316
;D6AA:   RET

;PlayAudioWaitKey: ; D69C
;        lda #<LA747 ; LD   HL,A747
;        sta z80_l
;        lda #>LA747
;        sta z80_h
;        ldy #$00 ; LD   A,(HL)
;        lda (z80_hl),y
        ; AND  A
;        beq *+3 ; RET  NZ
;        rts
;        ldy #$00 ; SET  0,(HL)
;        lda (z80_hl),y
;        ora #_bitvalue0
;        sta (z80_hl),y
;@@318   lda #$00 ; XOR  A
;        jsr ReadKey ; CALL ReadKey
;        jeq @@316 ; JR   Z,@@316
;        rts ; RET

;@@316   LD   A,(DE)
;D6AC:   CP   FF
;D6AE:   JR   Z,@@317
;D6B0:   CALL LD6C0
;D6B3:   JR   @@318

;@@316   ldy #$00 ; LD   A,(DE)
;        lda (z80_de),y
;        cmp #$FF ; CP   FF
;        jeq @@317 ; JR   Z,@@317
;        jsr LD6C0 ; CALL LD6C0
;        jmp @@318 ; JR   @@318

;PlayAudio: ; D6B5
;D6B5:   LD   A,(DE)
;D6B6:   CP   FF
;D6B8:   JR   Z,@@317
;D6BA:   CALL LD6C0
;D6BD:   JR   PlayAudio

;PlayAudio: ; D6B5
;        ldy #$00 ; LD   A,(DE)
;        lda (z80_de),y
;        cmp #$FF ; CP   FF
;        jeq @@317 ; JR   Z,@@317
;        jsr LD6C0 ; CALL LD6C0
;        jmp PlayAudio ; JR   PlayAudio

;@@317   RET

;@@317   rts ; RET

;LD6C0   AND  3F
;D6C2:   JR   Z,@@319
;D6C4:   LD   L,A
;D6C5:   LD   H,00
;D6C7:   ADD  HL,HL
;D6C8:   CALL Add_HL_A
;D6CB:   LD   BC,FrequencyTable
;D6CE:   ADD  HL,BC
;D6CF:   LD   B,(HL)
;D6D0:   INC  HL
;D6D1:   LD   C,(HL)
;D6D2:   INC  HL
;D6D3:   LD   L,(HL)
;D6D4:   LD   H,00
;D6D6:   LD   A,(DE)
;D6D7:   RLCA
;D6D8:   RLCA
;D6D9:   AND  03
;D6DB:   INC  A
;D6DC:   PUSH DE
;D6DD:   LD   E,L
;D6DE:   LD   D,H
;@@321   DEC  A
;D6E0:   JR   Z,@@320
;D6E2:   ADD  HL,DE
;D6E3:   JR   @@321

; Audio playback, not needed ??
;LD6C0   and #$3F ; AND  3F; 
;        jeq @@319 ; JR   Z,@@319
;        sta z80_l ; LD   L,A; 
;        ldx #$00 ; LD   H,00
;        stx z80_h
;        asl z80_l ; ADD  HL,HL
;        rol z80_h
;        jsr Add_HL_A ; CALL Add_HL_A
;        lda #<FrequencyTable ; LD   BC,FrequencyTable
;        sta z80_c
;        lda #>FrequencyTable
;        sta z80_b
;        jsr add_hl_bc ; ADD  HL,BC
;        ldy #$00 ; LD   B,(HL)
;        lda (z80_hl),y
;        sta z80_b
;        inc z80_l ; INC  HL
;        bne *+4
;        inc z80_h
;        ldy #$00 ; LD   C,(HL)
;        lda (z80_hl),y
;        sta z80_c
;        inc z80_l ; INC  HL
;        bne *+4
;        inc z80_h
;        ldy #$00 ; LD   L,(HL)
;        lda (z80_hl),y
;        sta z80_l
;        lda #$00 ; LD   H,00
;        sta z80_h
;        ldy #$00 ; LD   A,(DE)
;        lda (z80_de),y
;        asl @ ; RLCA
;        rol @ ; RLCA
;		rol @
;        and #$03 ; AND  03
;        clc ; INC  A
;        adc #$01
;		sta z80_a
;        lda z80_e ; PUSH DE
;        pha
;        lda z80_d
;        pha
;        lda z80_l ; LD   E,L
;        sta z80_e
;        lda z80_h ; LD   D,H
;        sta z80_d
;@@321   lda z80_a
;		sec ; DEC  A
;        sbc #$01;
;		sta z80_a
;        jeq @@320 ; JR   Z,@@320
;        jsr add_hl_de ; ADD  HL,DE
;        jmp @@321 ; JR   @@321

;@@320   POP  DE
;@@324   PUSH BC
;D6E7:   XOR  A
;D6E8:   OUT  (FE),A
;@@322   DJNZ @@322
;D6EC:   DEC  C
;D6ED:   JR   NZ,@@322
;D6EF:   POP  BC
;D6F0:   PUSH BC
;D6F1:   LD   A,10
;D6F3:   OUT  (FE),A
;@@323   DJNZ @@323
;D6F7:   DEC  C
;D6F8:   JR   NZ,@@323
;D6FA:   POP  BC
;D6FB:   DEC  HL
;D6FC:   LD   A,H
;D6FD:   OR   L
;D6FE:   JR   NZ,@@324
;D700:   INC  DE
;D701:   RET

;@@320   pla ; POP  DE
;        sta z80_d
;        pla
;        sta z80_e
;@@324   lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda #$00 ; XOR  A
;        ;jsr out_fe ; OUT  (FE),A
;@@322   dec z80_b ; DJNZ @@322
;        jne @@322
;        dec z80_c ; DEC  C
;        jne @@322 ; JR   NZ,@@322
;        pla ; POP  BC
;        sta z80_b
;        pla
;        sta z80_c
;        lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;        lda #$10 ; LD   A,10
        ;jsr out_fe ; OUT  (FE),A
;@@323   dec z80_b ; DJNZ @@323
;        jne @@323
;        dec z80_c ; DEC  C
;        jne @@323 ; JR   NZ,@@323
;        pla ; POP  BC
;        sta z80_b
;        pla
;        sta z80_c
;        jsr dec_hl ; DEC  HL
;        lda z80_h ; LD   A,H
;        ora z80_l ; OR   L
;        jne @@324 ; JR   NZ,@@324
;        inc z80_e ; INC  DE
;        bne *+4
;        inc z80_d
;        rts ; RET

;@@319   LD   A,(DE)
;D703:   INC  DE
;D704:   RLCA
;D705:   RLCA
;D706:   AND  03
;D708:   INC  A
;D709:   LD   L,A
;D70A:   LD   BC,430B
;@@326   PUSH BC
;@@325   DEC  BC
;D70F:   LD   A,B
;D710:   OR   C
;D711:   JR   NZ,@@325
;D713:   POP  BC
;D714:   DEC  L
;D715:   JR   NZ,@@326
;D717:   RET

;@@319   ldy #$00 ; LD   A,(DE)
;        lda (z80_de),y
;        inc z80_e ; INC  DE
;        bne *+4
;        inc z80_d
;        asl @ ; RLCA
;        rol @ ; RLCA
;		rol @
;        and #$03 ; AND  03
;        clc ; INC  A
;        adc #$01
;        sta z80_l ; LD   L,A
;        lda #<L430B ; LD   BC,430B
;        sta z80_c
;        lda #>L430B
;        sta z80_b
;@@326   lda z80_c ; PUSH BC
;        pha
;        lda z80_b
;        pha
;@@325   jsr dec_bc ; DEC  BC
;        lda z80_b ; LD   A,B
;        ora z80_c ; OR   C
;        jne @@325 ; JR   NZ,@@325
;        pla ; POP  BC
;        sta z80_b
;        pla
;        sta z80_c
;        dec z80_l ; DEC  L
;        jne @@326 ; JR   NZ,@@326
;        rts ; RET

		
		
;FrequencyTable: ; D718
;D718:   DB 00,00,00,F4,0A,08,65,0A,09,DE,09,09,5E,09,0A,E7
;D728:   DB 08,0A,75,08,0B,0A,08,0C,A5,07,0C,45,07,0D,EB,06
;D738:   DB 0E,96,06,0F,46,06,0F,FA,05,10,B3,05,11,6F,05,12
;D748:   DB 2F,05,13,F3,04,15,F3,04,16,85,04,17,52,04,19,23
;D758:   DB 04,1A,F6,03,1C,CB,03,1D,A3,03,1F,7D,03,21,59,03
;D768:   DB 23,38,03,25,18,03,27,FA,02,29,DD,02,2C,C2,02,2E
;D778:   DB A9,02,31,91,02,34,7B,02,37,66,02,3A,51,02,3E,3F
;D788:   DB 02,41,2D,02,45,1C,02,49,0C,02,4E,FD,01,52,EF,01
;D798:   DB 57,E2,01,5D,D5,01,62,C9,01,68,BD,01,6E,B3,01,75
;D7A8:   DB A9,01,7B,9F,01,83,96,01,8B,8E,01,93,86,01,9C,7E
;D7B8:   DB 01,A5,77,01,AF,71,01,B9,6A,01,C4,64,01,D0,5F,01
;D7C8:   DB DC,59,01,E9,54,01,F7

;FrequencyTable: ; D718
;        .he 00,00,00,F4,0A,08,65,0A,09,DE,09,09,5E,09,0A,E7 ; DB 00,00,00,F4,0A,08,65,0A,09,DE,09,09,5E,09,0A,E7
;        .he 08,0A,75,08,0B,0A,08,0C,A5,07,0C,45,07,0D,EB,06 ; DB 08,0A,75,08,0B,0A,08,0C,A5,07,0C,45,07,0D,EB,06
;        .he 0E,96,06,0F,46,06,0F,FA,05,10,B3,05,11,6F,05,12 ; DB 0E,96,06,0F,46,06,0F,FA,05,10,B3,05,11,6F,05,12
;        .he 2F,05,13,F3,04,15,F3,04,16,85,04,17,52,04,19,23 ; DB 2F,05,13,F3,04,15,F3,04,16,85,04,17,52,04,19,23
;        .he 04,1A,F6,03,1C,CB,03,1D,A3,03,1F,7D,03,21,59,03 ; DB 04,1A,F6,03,1C,CB,03,1D,A3,03,1F,7D,03,21,59,03
;        .he 23,38,03,25,18,03,27,FA,02,29,DD,02,2C,C2,02,2E ; DB 23,38,03,25,18,03,27,FA,02,29,DD,02,2C,C2,02,2E
;        .he A9,02,31,91,02,34,7B,02,37,66,02,3A,51,02,3E,3F ; DB A9,02,31,91,02,34,7B,02,37,66,02,3A,51,02,3E,3F
;        .he 02,41,2D,02,45,1C,02,49,0C,02,4E,FD,01,52,EF,01 ; DB 02,41,2D,02,45,1C,02,49,0C,02,4E,FD,01,52,EF,01
;        .he 57,E2,01,5D,D5,01,62,C9,01,68,BD,01,6E,B3,01,75 ; DB 57,E2,01,5D,D5,01,62,C9,01,68,BD,01,6E,B3,01,75
;        .he A9,01,7B,9F,01,83,96,01,8B,8E,01,93,86,01,9C,7E ; DB A9,01,7B,9F,01,83,96,01,8B,8E,01,93,86,01,9C,7E
;        .he 01,A5,77,01,AF,71,01,B9,6A,01,C4,64,01,D0,5F,01 ; DB 01,A5,77,01,AF,71,01,B9,6A,01,C4,64,01,D0,5F,01
;        .he DC,59,01,E9,54,01,F7 ; DB DC,59,01,E9,54,01,F7

;Audio1  DB 6C,29,2A,2C,29,6A,6A,29,2A,2C,29,67,6C,29,2A,2C
;D7DF:   DB 29,6A,29,2A,6C,60,65,6C,29,2A,2C,29,6A,6A,29,2A
;D7EF:   DB 2C,29,67,6C,29,2A,2C,29,6A,29,2A,6C,60,A5,27,69
;D7FF:   DB 65,AA,27,69,65,A7,27,29,2A,2C,29,6A,29,2A,6C,60
;D80F:   DB A5,27,69,65,AA,27,69,65,A7,27,29,2A,2C,29,6A,29
;D81F:   DB 2A,6C,60,A5,FF,27,67,67,23,67,EA,DE,23,23,5E,5B
;D82F:   DB 59,D7,23,FF

;Audio1  .he 6C,29,2A,2C,29,6A,6A,29,2A,2C,29,67,6C,29,2A,2C ; DB 6C,29,2A,2C,29,6A,6A,29,2A,2C,29,67,6C,29,2A,2C
;        .he 29,6A,29,2A,6C,60,65,6C,29,2A,2C,29,6A,6A,29,2A ; DB 29,6A,29,2A,6C,60,65,6C,29,2A,2C,29,6A,6A,29,2A
;        .he 2C,29,67,6C,29,2A,2C,29,6A,29,2A,6C,60,A5,27,69 ; DB 2C,29,67,6C,29,2A,2C,29,6A,29,2A,6C,60,A5,27,69
;        .he 65,AA,27,69,65,A7,27,29,2A,2C,29,6A,29,2A,6C,60 ; DB 65,AA,27,69,65,A7,27,29,2A,2C,29,6A,29,2A,6C,60
;        .he A5,27,69,65,AA,27,69,65,A7,27,29,2A,2C,29,6A,29 ; DB A5,27,69,65,AA,27,69,65,A7,27,29,2A,2C,29,6A,29
;        .he 2A,6C,60,A5,FF,27,67,67,23,67,EA,DE,23,23,5E,5B ; DB 2A,6C,60,A5,FF,27,67,67,23,67,EA,DE,23,23,5E,5B
;        .he 59,D7,23,FF ; DB 59,D7,23,FF

;Audio2  DB 65,68,6C,71,6F,2D,2C,2F,2D,6A,6D,2C,2A,2C,31,6C
;D843:   DB 68,67,E5,FF

;Audio2  .he 65,68,6C,71,6F,2D,2C,2F,2D,6A,6D,2C,2A,2C,31,6C ; DB 65,68,6C,71,6F,2D,2C,2F,2D,6A,6D,2C,2A,2C,31,6C
;        .he 68,67,E5,FF ; DB 68,67,E5,FF

;Audio3  DB 20,20,25,26,2C,69,20,20,22,24,E5,FF

;Audio3  .he 20,20,25,26,2C,69,20,20,22,24,E5,FF ; DB 20,20,25,26,2C,69,20,20,22,24,E5,FF

;Audio4  DB 60,65,69,6C,69,65,65,67,2A,29,27,25,64,60,60,65
;D863:   DB 29,27,25,24,62,5E,62,60,65,64,E5,FF

;Audio4  .he 60,65,69,6C,69,65,65,67,2A,29,27,25,64,60,60,65 ; DB 60,65,69,6C,69,65,65,67,2A,29,27,25,64,60,60,65
;        .he 29,27,25,24,62,5E,62,60,65,64,E5,FF ; DB 29,27,25,24,62,5E,62,60,65,64,E5,FF

;Audio5  DB 29,2A,6C,29,2A,2C,2E,6C,6A,69,6A,27,29,2A,2C,6A
;D87F:   DB 69,67,69,25,27,29,2A,69,67,65,27,20,6C,64,E5,FF

;Audio5  .he 29,2A,6C,29,2A,2C,2E,6C,6A,69,6A,27,29,2A,2C,6A ; DB 29,2A,6C,29,2A,2C,2E,6C,6A,69,6A,27,29,2A,2C,6A
;        .he 69,67,69,25,27,29,2A,69,67,65,27,20,6C,64,E5,FF ; DB 69,67,69,25,27,29,2A,69,67,65,27,20,6C,64,E5,FF

;ScreenBuffer: ; D88F
	
	
c64menukeys

                        ;setup keyboard reading
        lda     #%11111111; CIA#1 Port A set to output
        sta     ddra    
        lda     #%00000000; CIA#1 Port B set to input
        sta     ddrb    

        lda     #%11101111; select row 5
        sta     pra     
        lda     prb     ; load column information
        and     #%00001000; test '0' key for left
        beq     @key0pressed

		lda 	#%01111111 ; select row 8    
        sta     pra     
        lda     prb       
        and 	#%00010000 ; Space key 
        beq     @key0pressed		
		
        lda     #%01111111; select row 8
        sta     pra     
        lda     prb     ; load column information
        and     #%00000001; test '1' key for left
        beq     @key1pressed

        lda     #%01111111; select row 8
        sta     pra     
        lda     prb     ; load column information
        and     #%00001000; test '2' key for left
        beq     @key2pressed

		;setup joystick port 2
        lda     #$E0    
        and     ddra    
        sta     ddra    

        lda     pra   ;read port 2
        and     #$10    ;isolate button bit
        beq     @key0pressed	;if =0 then button is down.

        lda     pra   ;read port 2
        and     #$02  ;down              	
		beq     @key2pressed

        lda     pra   ;read port 2
        and     #$01  ;up              	
		beq     @key1pressed
		
        rts

@key0pressed

        lda     #01     
        sta     gamestartf   
        rts

@key1pressed

        lda     #00     
        sta     LA709

;		inc border
;		inc cpuspeed
;
;		ldx #00
;testone
;		jsr c64waitframe
;		inx
;		cpx #17
;		bne testone
		
        rts

@key2pressed

        lda     #02     
        sta     LA709

;		dec border
;		dec cpuspeed
;
;		ldx #00
;testtwo
;		jsr c64waitframe
;		inx
;		cpx #17
;		bne testtwo
		
        rts

c64skipkey

        ;setup keyboard reading
        lda     #%11111111; CIA#1 Port A set to output
        sta     ddra    
        lda     #%00000000; CIA#1 Port B set to input
        sta     ddrb 
		
		lda 	#%01111111 ; select row 8    
        sta     pra     
        lda     prb       
        and 	#%00010000 ; Space key 
        beq     @skippressed			
		
		;setup joystick port 2
        lda     #$E0    
        and     ddra    
        sta     ddra    

        lda     pra   ;read port 2
        and     #$10    ;isolate button bit
        beq     @skippressed	;if =0 then button is down.		
		
		rts

@skippressed		
		
		lda     #01     
        sta     skipkeyon
		
        rts
		
; sync screen to 50hz Sub	
c64waitframe

WaitFramea
          lda $d012
          cmp #$ff
          beq WaitFramea

WaitStepb
          lda $d012
          cmp #$ff
          bne WaitStepb

          rts

c64skipkeyheld

		jsr c64waitframe

        ; setup keyboard reading
        lda     #%11111111; CIA#1 Port A set to output
        sta     ddra    
        lda     #%00000000; CIA#1 Port B set to input
        sta     ddrb 
		
		lda 	#%01111111 ; select row 8    
        sta     pra     
        lda     prb       
        and 	#%00010000 ; Space
				
		beq     c64skipkeyheld			
		
		;setup joystick port 2
        lda     #$E0    
        and     ddra    
        sta     ddra    

        lda     pra   ;read port 2
        and     #$10    ;isolate button bit	

		beq     c64skipkeyheld	;if =0 then button is down.		

		rts
		  

LB3B6_2
		lda z80_l ; PUSH HL
        pha
        lda z80_h
        pha
        lda z80_h ; LD   A,H
        eor #$ff ; CPL
        sta z80_h ; LD   H,A
        lsr z80_h ; SRL  H
        lsr z80_h ; SRL  H
        lsr z80_h ; SRL  H
        lsr z80_h ; SRL  H
        ror z80_l ; RR   L
        lsr z80_h ; SRL  H
        ror z80_l ; RR   L
        lsr z80_h ; SRL  H
        ror z80_l ; RR   L
	
		; writes additional attribute colour info in here. Attr colour mem minus $0100
        ;lda #<L5700 ; LD   DE,5700
        lda #<$fb00
		sta z80_e
        ;lda #>L5700
        lda #>$fb00
		sta z80_d
       	
        jsr add_hl_de ; ADD  HL,DE
        jsr ex_de_hl ; EX   DE,HL
        pla ; POP  HL
        sta z80_h
        pla
        sta z80_l
        rts ; RET
		
;c64clearcols
;
;	ldx #00
;	lda #00 ; black out border colour
;	
;charclear001:
;	
;	sta $d800,x
;	sta $d900,x
;	sta $da00,x
;	sta $db00,x
;	inx
;	bne charclear001	
;	
;	rts
		
	
;c64char001
;
;	;lda #$30  ; Open up all RAM 	
;	;sta $01
;	;dec $01
;	;inc $ff00
;	
;	ldx #00
;	ldy #00
;	sty counter
;	
;charloop001:
;	
;	tya 
;	sta $dc04,x
;	sta $dd44,x
;	sta $de84,x
;	
;	inx
;	iny
;	inc counter
;	
;	lda counter
;	cmp  #32
;	jne  charloop001
;
;	txa
;	clc
;	adc #08
;	tax
;	
;	lda #00
;	sta counter
;	
;	cpx #240
;	jne charloop001
;		
;	ldx#00
;	
;charloop007:
;	
;	tya 
;	sta $dcf4,x
;	sta $de34,x
;	sta $df74,x
;	
;	inx
;	iny
;	
;	cpx  #32
;	jne  charloop007
;
;	ldx#00
;	
;charloop008:
;	
;	tya 
;	sta $dd1c,x
;	sta $de5c,x
;	sta $df9c,x
;
;	inx
;	iny
;	
;	cpx  #32
;	jne  charloop008
;
;	; put IO back in
;	;lda #$35   	
;	;sta $01
;	;inc $01
;	
;	;dec $ff00	
;	
;	rts	

;c64colours	
;	
;	ldx #0
;	
;maincoloursloop01:
;
;	lda $f800,x
;	sta $d804,x
;	lda $f820,x
;	sta $d82c,x
;	lda $f840,x
;	sta $d854,x
;	lda $f860,x
;	sta $d87c,x
;	lda $f880,x	
;	sta $d8a4,x
;	lda $f8a0,x
;	sta $d8cc,x
;	lda $f8c0,x
;	sta $d8f4,x
;	lda $f8e0,x
;	sta $d91c,x
;	
;
;	lda $f900,x
;	sta $d944,x
;	lda $f920,x
;	sta $d96c,x
;	lda $f940,x
;	sta $d994,x
;	lda $f960,x
;	sta $d9bc,x
;	lda $f980,x	
;	sta $d9e4,x
;	lda $f9a0,x
;	sta $da0c,x
;	lda $f9c0,x
;	sta $da34,x
;	lda $f9e0,x
;	sta $da5c,x
;	
;	lda $fa00,x
;	sta $da84,x
;	lda $fa20,x
;	sta $daac,x
;	lda $fa40,x
;	sta $dad4,x
;	lda $fa60,x
;	sta $dafc,x
;	lda $fa80,x	
;	sta $db24,x
;	lda $faa0,x
;	sta $db4c,x
;	lda $fac0,x
;	sta $db74,x
;	lda $fae0,x
;	sta $db9c,x
;	
;	inx
;	
;	cpx  #32
;	jne  maincoloursloop01	
;
;		lda #15
;		sta $db3c
;		sta $db3d
;		sta $db3e
;		sta $db3f
;		sta $db40
;	
;	rts

c64colourspickup

		STA $D07A

		lda #$22
		ldx #18
		jsr vdcwrite
		lda #$a2
		inx
		;STA $D07A
		stx $d600		
		sta $d601
		;STA $D07B
		
		ldy #00
@		
		lda $fea2,y
		ldx #31		 
		stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
		cpy #09
		bne @-1

		lda #$22
		ldx #18
		jsr vdcwrite
		lda #$c2
		inx
		;STA $D07A
		stx $d600		
		sta $d601
		;STA $D07B
		
		ldy #00
@		
		lda $fec2,y
		ldx #31		 
		stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
		cpy #09
		bne @-1

		lda #$22
		ldx #18
		jsr vdcwrite
		lda #$e2
		inx
		;STA $D07A
		stx $d600		
		sta $d601
		;STA $D07B
		
		ldy #00
@		
		lda $fee2,y
		ldx #31		 
		stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
		cpy #09
		bne @-1
			
		STA $D07B
			
		rts


copy_sound_music

	  ;lda #14
	  ;sta pages

      lda #$00      ;source memory address to copy from
      sta source_lo
      lda #$e2
      sta source_hi
    
      lda #$00      ;destination memory address to copy to
      sta dest_lo
      lda #$02
      sta dest_hi

      ldx #13		;number of pages to copy
      ldy #00
	  
soundcopyloop
	  
      lda (source_lo),y   ;indirect index source memory address, starting at $00
      sta (dest_lo),y   ;indirect index dest memory address, starting at $00
      iny
      bne soundcopyloop  ;loop until our dest goes over 255

      inc source_hi     ;increment high order source memory address, starting at $80
      inc dest_hi     ;increment high order dest memory address, starting at $60
    
      dex
      bne soundcopyloop ;if we're not there yet, loop 
	  
	  rts 	
	
vdcwrite
		stx $d600		
waitloop02:
		bit $d600
		bpl waitloop02
		sta $d601
		rts

		; X = Reg - A = Value
vdc_setup

		STA $D07A
		
		; need to set this for double width mode to work
		lda #137
		ldx	#22
		jsr vdcwrite
	
		; horizontal Total - need to set this for double width mode to work
		lda #63
		ldx #00
		jsr vdcwrite
		
		; horz poss - need to set this for double width mode to work
		lda #51
		ldx #02
		jsr vdcwrite

		; horz sync - need to set this for double width mode to work
		lda #36
		ldx #03
		jsr vdcwrite		
			
		; horz cols - 40 - need to set this for double width mode to work
		lda #32
		ldx #01
		jsr vdcwrite

		; vert lines - 24 (192 pix) ************************
		lda #24
		ldx #06
		jsr vdcwrite		

		lda #$00 ;set colour to black/black
		ldx #26
		jsr vdcwrite 		


		;enter bitmap mode with attr colour $d7 for rev1/2 or $d0 for rev 0
		lda vdc_old
		bne vdcatold
		lda #$d7
		jmp vdcrevout
vdcatold
		lda #$d0
vdcrevout
		ldx #25
		jsr vdcwrite
				

		; $0000
		lda #$00 ;set VDC RAM display address high
		ldx #12
		jsr vdcwrite
		inx ;set VDC RAM display address low 
		jsr vdcwrite

		; $2000
		lda #$20 ;set VDC Attribute start address high
		ldx #20
		jsr vdcwrite
		lda #$00
		inx ;set VDC Attribute start address low 
		jsr vdcwrite
		
		STA $D07B
		
		rts

vdc_screen_clear		
	
		STA $D07A
	
		; clear down screen and colour VDC ram (9k - 8k screen and 1k colour)
		
		; $0000
		lda #$00 ;set VDC RAM update start address high for copy
		ldx #18 
		jsr vdcwrite
		inx ;set VDC RAM address update start address low for copy
		jsr vdcwrite

		lda #$20 ;select block fill mode - 0 (not 1) in bit 7 turns block mode on.
		ldx #24 
		jsr vdcwrite

		;ldx #24 ; VDC register for block fill/copy - This seems to switch block mode off not on.
		;jsr vdcread
		;ora #$80 ; want BLOCK COPY
		;jsr vdcwrite	
		
		lda #$00 ;fill screen with this
		ldx #31
		jsr vdcwrite
	
		
		lda #$00 ;number of bytes to fill (0=256)
		ldx #30  ;to clear the hires screen
		ldy #63  ;number of pages to clear (64x256 bytes = 16384)
@		
		jsr vdcwrite		
		dey
		bne @-
		
		STA $D07B
		
		rts		

vdc_colour_clear

		STA $D07A

		ldx colourcode
		lda vdc_colour_convert,x
		sta colourcode

		ldx #00
@
		sta $fc00,x
		sta $fd00,x
		sta $fe00,x
		
		inx
		bne @-
		
		
		; $2000
		lda #$20 ;set VDC RAM update start address high for copy
		ldx #18 
		jsr vdcwrite
		lda #00
		inx ;set VDC RAM address update start address low for copy
		jsr vdcwrite

		lda #$20 ;select block fill mode - 0 (not 1) in bit 7 turns block mode on.
		ldx #24 
		jsr vdcwrite

		;ldx #24 ; VDC register for block fill/copy
		;jsr vdcread
		;ora #$80 ; want BLOCK COPY
		;jsr vdcwrite		

		lda colourcode ;fill screen with this
		ldx #31
		jsr vdcwrite
		
		lda #$00 ;number of bytes to fill (0=256)
		ldx #30  ;to clear the hires screen
		ldy #04  ;number of pages to clear (04x256 bytes = 1024)
@		
		jsr vdcwrite		
		dey
		bne @-		
		
		STA $D07B
		
		rts

;blockcopyr
;
;		lda colour3
;		ldx #31
;		jsr vdcwrite
;		dec counter3
;		lda counter3
;		bne blockcopyr
;
;		rts		

vdcscreen

		STA $D07A

		lda #<$f7e0
        sta source_lo
        lda #>$f7e0
        sta source_hi
		
		lda #<$0000
        sta dest_lo
        lda #>$0000
        sta dest_hi

	
		lda #192
		sta count_temp

	
buildscreen001:

	
		ldy #$00 
		
		
		lda dest_hi
		ldx #18
		stx $d600		
@
		bit $d600
		bpl @-
		sta $d601
		
		lda dest_lo
		inx		
		stx $d600		
		sta $d601				
				
		ldx #31
		stx $d600
		
		lda (source_lo),y		
@
		bit $d600
		bpl @-
		sta $d601
	
		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601
		
		iny
		
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601		

		iny
		
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601		

		iny
		
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601		

		iny
		
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny

		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601	
	
		iny

		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601
	
		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601		

		iny

		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601		

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601		

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
		
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601
		
		iny
		
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601		
		
		iny

		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny

		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny

		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601		

		iny

		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601		

		iny
		
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601		

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601
		
		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
	
		lda (source_lo),y
		;stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		;iny
		
		lda dest_lo
		clc
		adc #32
		sta dest_lo
		scc:inc dest_hi


		lda source_lo
		sec
		sbc #32
		sta source_lo
		scs:dec source_hi		
			

		dec count_temp
		lda count_temp
		jne buildscreen001	
		
		STA $D07B
		
	rts

vdc_colour_copy
		
		STA $D07A
		
		lda #<spectrum_attr
        sta source_lo
        lda #>spectrum_attr
        sta source_hi
		
		lda #<$2000
        sta dest_lo
        lda #>$2000
        sta dest_hi
		
		lda #3
		sta count_temp

vdc_colour_loop:
		
		lda dest_hi
		ldx #18
		jsr vdcwrite
		lda dest_lo
		inx
		;STA $D07A
		stx $d600		
		sta $d601
		;STA $D07B
		
		
		ldy #00
@		
		lda (source_lo),y
		ldx #31		 
		stx $d600		
@
		bit $d600
		bpl @-
		sta $d601

		iny
		
		bne @-1		
		
		inc dest_hi
		inc source_hi		
			

		dec count_temp
		lda count_temp
		jne vdc_colour_loop	

		lda #$22
		ldx #18
		jsr vdcwrite
		lda #$98
		inx
		;STA $D07A
		stx $d600		
		sta $d601
		;STA $D07B		
		
		ldy #$00
		lda #$0f

		ldx #31		 
		stx $d600
		
@
		bit $d600
		bpl @-
		sta $d601

		iny
		cpy #$05
		bne @-
		
		STA $D07B
		
		rts

vdc_flasher
		
		STA $D07A
		
		lda dest_hi
		ldx #18
		jsr vdcwrite
		lda dest_lo
		inx
		;STA $D07A
		stx $d600		
		sta $d601
		;STA $D07B		
		
		lda colourcode

		ldx #31		 
		stx $d600
		
		ldx #$00
		
@
		bit $d600
		bpl @-
		sta $d601

		inx
		cpx #20
		bne @-
		
		STA $D07B
		
		rts
		

		
colour_code				dta 000
multi_no_1				dta 000
multi_no_2				dta 000
multi_no_3				dta 000

gamestartf 				dta 000
c64flashtx 				dta 000

colourcounter	 		dta 000
counter2				dta 000
counter					dta 000
skipkeyon				dta 000

sound_off				dta 001
sound_e					dta 000

counter3				dta 000
colour3					dta 000

colourcode				dta 000
count_temp				dta 000

;button_2				dta 000
;temp_ddra				dta 000
;kbbuffer				dta 000
;joyfire1value 			dta 000
;keyleft 				dta 000
;keyright				dta 000
;keyup 					dta 000
;keydown 				dta 000
;keyfire1 				dta 000
;keyfire1value 			dta 000

		
;speccoltable
;	dta $40,$41,$42,$43,$44,$45,$46,$47
	
;c64coltable
;	dta 00,14,10,04,05,03,07,15

;Table_B
;
;	dta 248,240,232,224,216,208,200,192
;	dta 184,176,168,160,152,144,136,128
;	dta 120,112,104,096,088,080,072,064
;	dta 056,048,040,032,024,016,008,000
;
;	dta 249,241,233,225,217,209,201,193
;	dta 185,177,169,161,153,145,137,129
;	dta 121,113,105,097,089,081,073,065
;	dta 057,049,041,033,025,017,009,001
;
;	dta 250,242,234,226,218,210,202,194
;	dta 186,178,170,162,154,146,138,130
;	dta 122,114,106,098,090,082,074,066
;	dta 058,050,042,034,026,018,010,002
;
;	dta 251,243,235,227,219,211,203,195
;	dta 187,179,171,163,155,147,139,131
;	dta 123,115,107,099,091,083,075,067
;	dta 059,051,043,035,027,019,011,003
;
;	dta 252,244,236,228,220,212,204,196
;	dta 188,180,172,164,156,148,140,132
;	dta 124,116,108,100,092,084,076,068
;	dta 060,052,044,036,028,020,012,004
;
;	dta 253,245,237,229,221,213,205,197
;	dta 189,181,173,165,157,149,141,133
;	dta 125,117,109,101,093,085,077,069
;	dta 061,053,045,037,029,021,013,005
;
;	dta 254,246,238,230,222,214,206,198
;	dta 190,182,174,166,158,150,142,134
;	dta 126,118,110,102,094,086,078,070
;	dta 062,054,046,038,030,022,014,006	
;
;	dta 255,247,239,231,223,215,207,199
;	dta 191,183,175,167,159,151,143,135
;	dta 127,119,111,103,095,087,079,071
;	dta 063,055,047,039,031,023,015,007	


;cbmscreen
;
;		;lda #$30 ; Open up all RAM
;		;sta $01
;		
;		;dec $01      ;Swap out the I/O page
;		inc $ff00
;		
;		
;		lda #$e0 ; source memory address to copy from
;		sta source_lo
;		lda #$f7
;		sta source_hi
;		
;		lda #$00 ; destination memory address to copy to
;		sta dest_lo
;		lda #$c0
;		sta dest_hi
;
;screenloop01		
;	
;		ldy #$00 
;		ldx #$00
;		
;screenloop02
;
;		lda (source_lo),y 
;		sta (dest_lo),y 
;		
;		clc
;		lda dest_lo
;		adc #07
;		sta dest_lo
;		
;		iny
;		cpy #32
;		bne screenloop02
;
;		sec
;		lda source_lo
;		sbc #$20
;		sta source_lo
;		
;		inx
;		
;;		txa
;		sta dest_lo
;
;		ldy #$00
;		
;		cpx #08
;		bne screenloop02
;		
;		lda #00
;		sta dest_lo
;		
;		dec source_hi
;		inc dest_hi
;
;		lda source_hi
;		cmp #$df
;		bne screenloop01
;
;		;lda #$35
;		;sta $01 
;		
;		;inc $01
;		
;		dec $ff00
;		
;		rts	


	

;c64screen
;
;	dec $01      ;Swap out the I/O page 
;
;	ldy #$00 
;	ldx #$00 
;
;buildscreen001:
;	
;	ldy  X_Table_Count,x
;
;	lda $f7e0,x
;   sta $c000,y
;	lda $f7c0,x
;   sta $c001,y
;	lda $f7a0,x
;   sta $c002,y
; 	lda $f780,x
;   sta $c003,y
; 	lda $f760,x
;   sta $c004,y
; 	lda $f740,x
;   sta $c005,y
; 	lda $f720,x
; 	sta $c006,y
; 	lda $f700,x
;    sta $c007,y
;
;	lda $f6e0,x
;    sta $c100,y 
;	lda $f6c0,x
;    sta $c101,y
;	lda $f6a0,x
;    sta $c102,y
; 	lda $f680,x
;    sta $c103,y
; 	lda $f660,x
;    sta $c104,y
; 	lda $f640,x
;    sta $c105,y
; 	lda $f620,x
; 	sta $c106,y
; 	lda $f600,x
;    sta $c107,y		
;
;	lda $f5e0,x
;    sta $c200,y 
;	lda $f5c0,x
;    sta $c201,y
;	lda $f5a0,x
;    sta $c202,y
; 	lda $f580,x
;    sta $c203,y
; 	lda $f560,x
;    sta $c204,y
;	lda $f540,x
;    sta $c205,y
; 	lda $f520,x
; 	sta $c206,y
; 	lda $f500,x
;	sta $c207,y	
;
;	lda $f4e0,x
;    sta $c300,y 
;	lda $f4c0,x
;    sta $c301,y
;	lda $f4a0,x
;    sta $c302,y
; 	lda $f480,x
;    sta $c303,y
; 	lda $f460,x
;    sta $c304,y
; 	lda $f440,x
;    sta $c305,y
; 	lda $f420,x
; 	sta $c306,y
; 	lda $f400,x
;    sta $c307,y
;
;	lda $f3e0,x
;    sta $c400,y 
;	lda $f3c0,x
;    sta $c401,y
;	lda $f3a0,x
;    sta $c402,y
; 	lda $f380,x
;    sta $c403,y
; 	lda $f360,x
;    sta $c404,y
; 	lda $f340,x
;    sta $c405,y
; 	lda $f320,x
; 	sta $c406,y
; 	lda $f300,x
;    sta $c407,y	
;
;	lda $f2e0,x
;    sta $c500,y 
;	lda $f2c0,x
;    sta $c501,y
;	lda $f2a0,x
;    sta $c502,y
; 	lda $f280,x
;    sta $c503,y
; 	lda $f260,x
;    sta $c504,y
; 	lda $f240,x
;    sta $c505,y
; 	lda $f220,x
; 	sta $c506,y
; 	lda $f200,x
;    sta $c507,y		
;
;	lda $f1e0,x
;    sta $c600,y 
;	lda $f1c0,x
;    sta $c601,y
;	lda $f1a0,x
;    sta $c602,y
; 	lda $f180,x
;    sta $c603,y
;	lda $f160,x
;    sta $c604,y
;	lda $f140,x
;    sta $c605,y
;	lda $f120,x
;	sta $c606,y
;	lda $f100,x
;    sta $c607,y	
;
;	lda $f0e0,x
;    sta $c700,y 
;	lda $f0c0,x
;    sta $c701,y
;	lda $f0a0,x
;    sta $c702,y
; 	lda $f080,x
;    sta $c703,y
; 	lda $f060,x
;    sta $c704,y
; 	lda $f040,x
;    sta $c705,y
; 	lda $f020,x
; 	sta $c706,y
; 	lda $f000,x
;    sta $c707,y
;
;	lda $efe0,x
;    sta $c800,y 
;	lda $efc0,x
;    sta $c801,y
;	lda $efa0,x
;    sta $c802,y
; 	lda $ef80,x
;    sta $c803,y
; 	lda $ef60,x
;    sta $c804,y
; 	lda $ef40,x
;    sta $c805,y
; 	lda $ef20,x
; 	sta $c806,y
; 	lda $ef00,x
;    sta $c807,y
;
;	lda $eee0,x
;    sta $c900,y 
;	lda $eec0,x
;    sta $c901,y
;	lda $eea0,x
;    sta $c902,y
; 	lda $ee80,x
;    sta $c903,y
; 	lda $ee60,x
;    sta $c904,y
; 	lda $ee40,x
;    sta $c905,y
; 	lda $ee20,x
; 	sta $c906,y
; 	lda $ee00,x
;    sta $c907,y
;
;	lda $ede0,x
;    sta $ca00,y 
;	lda $edc0,x
;    sta $ca01,y
;	lda $eda0,x
;    sta $ca02,y
; 	lda $ed80,x
;    sta $ca03,y
; 	lda $ed60,x
;    sta $ca04,y
; 	lda $ed40,x
;    sta $ca05,y
; 	lda $ed20,x
; 	sta $ca06,y
; 	lda $ed00,x
;    sta $ca07,y	
;
;	lda $ece0,x
;    sta $cb00,y 
;	lda $ecc0,x
;    sta $cb01,y
;	lda $eca0,x
;    sta $cb02,y
; 	lda $ec80,x
;    sta $cb03,y
; 	lda $ec60,x
;    sta $cb04,y
; 	lda $ec40,x
;    sta $cb05,y
; 	lda $ec20,x
; 	sta $cb06,y
; 	lda $ec00,x
;    sta $cb07,y		
;
;	lda $ebe0,x
;    sta $cc00,y 
;	lda $ebc0,x
;    sta $cc01,y
;	lda $eba0,x
;    sta $cc02,y
; 	lda $eb80,x
;    sta $cc03,y
; 	lda $eb60,x
;    sta $cc04,y
; 	lda $eb40,x
;    sta $cc05,y
; 	lda $eb20,x
; 	sta $cc06,y
; 	lda $eb00,x
;    sta $cc07,y	
;
;	lda $eae0,x
;    sta $cd00,y 
;	lda $eac0,x
;    sta $cd01,y
;	lda $eaa0,x
;    sta $cd02,y
; 	lda $ea80,x
;    sta $cd03,y
; 	lda $ea60,x
;    sta $cd04,y
; 	lda $ea40,x
;    sta $cd05,y
; 	lda $ea20,x
; 	sta $cd06,y
; 	lda $ea00,x
;    sta $cd07,y	
;
;	lda $e9e0,x
;    sta $ce00,y 
;	lda $e9c0,x
;    sta $ce01,y
;	lda $e9a0,x
;    sta $ce02,y
; 	lda $e980,x
;    sta $ce03,y
; 	lda $e960,x
;    sta $ce04,y
; 	lda $e940,x
;    sta $ce05,y
; 	lda $e920,x
; 	sta $ce06,y
; 	lda $e900,x
;    sta $ce07,y	
;
;	lda $e8e0,x
;    sta $cf00,y 
;	lda $e8c0,x
;    sta $cf01,y
;	lda $e8a0,x
;    sta $cf02,y
; 	lda $e880,x
;    sta $cf03,y
; 	lda $e860,x
;    sta $cf04,y
; 	lda $e840,x
;    sta $cf05,y
; 	lda $e820,x
; 	sta $cf06,y
; 	lda $e800,x
;    sta $cf07,y	
;
;	lda $e7e0,x
;    sta $d000,y 
;	lda $e7c0,x
;    sta $d001,y
;	lda $e7a0,x
;    sta $d002,y
; 	lda $e780,x
;    sta $d003,y
; 	lda $e760,x
;    sta $d004,y
; 	lda $e740,x
;    sta $d005,y
; 	lda $e720,x
; 	sta $d006,y
; 	lda $e700,x
;    sta $d007,y	
;
;	lda $e6e0,x
;    sta $d100,y 
;	lda $e6c0,x
;    sta $d101,y
;	lda $e6a0,x
;    sta $d102,y
; 	lda $e680,x
;    sta $d103,y
; 	lda $e660,x
;    sta $d104,y
; 	lda $e640,x
;    sta $d105,y
; 	lda $e620,x
; 	sta $d106,y
; 	lda $e600,x
;    sta $d107,y	
;
;	lda $e5e0,x
;    sta $d200,y 
;	lda $e5c0,x
;    sta $d201,y
;	lda $e5a0,x
;    sta $d202,y
; 	lda $e580,x
;    sta $d203,y
; 	lda $e560,x
;    sta $d204,y
; 	lda $e540,x
;    sta $d205,y
; 	lda $e520,x
; 	sta $d206,y
; 	lda $e500,x
;    sta $d207,y	
;
;	lda $e4e0,x
;    sta $d300,y 
;	lda $e4c0,x
;    sta $d301,y
;	lda $e4a0,x
;    sta $d302,y
; 	lda $e480,x
;    sta $d303,y
; 	lda $e460,x
;    sta $d304,y
; 	lda $e440,x
;    sta $d305,y
; 	lda $e420,x
; 	sta $d306,y
; 	lda $e400,x
;    sta $d307,y	
;
;	lda $e3e0,x
;    sta $d400,y 
;	lda $e3c0,x
;    sta $d401,y
;	lda $e3a0,x
;    sta $d402,y
; 	lda $e380,x
;    sta $d403,y
; 	lda $e360,x
;    sta $d404,y
; 	lda $e340,x
;    sta $d405,y
; 	lda $e320,x
; 	sta $d406,y
; 	lda $e300,x
;    sta $d407,y	
;
;	lda $e2e0,x
;    sta $d500,y 
;	lda $e2c0,x
;    sta $d501,y
;	lda $e2a0,x
;    sta $d502,y
; 	lda $e280,x
;    sta $d503,y
; 	lda $e260,x
;    sta $d504,y
; 	lda $e240,x
;    sta $d505,y
; 	lda $e220,x
; 	sta $d506,y
; 	lda $e200,x
;    sta $d507,y	
;	
;	lda $e1e0,x
;    sta $d600,y 
;	lda $e1c0,x
;    sta $d601,y
;	lda $e1a0,x
;    sta $d602,y
; 	lda $e180,x
;    sta $d603,y
; 	lda $e160,x
;    sta $d604,y
; 	lda $e140,x
;    sta $d605,y
; 	lda $e120,x
; 	sta $d606,y
; 	lda $e100,x
;    sta $d607,y	
;
;	lda $e0e0,x
;    sta $d700,y 
;	lda $e0c0,x
;    sta $d701,y
;	lda $e0a0,x
;    sta $d702,y
; 	lda $e080,x
;    sta $d703,y
; 	lda $e060,x
;    sta $d704,y
; 	lda $e040,x
;    sta $d705,y
; 	lda $e020,x
; 	sta $d706,y
; 	lda $e000,x
;    sta $d707,y	
;	
;	inx
;	
;	cpx  #32
;	jne  buildscreen001	
;
;	inc $01      ;Restore the I/O page 
;	
;	rts
	

;sprite_blit_table_lo
;		dta 224,225,226,227,228,229,230,231,232             
;		dta 233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248
;	
;		dta 249,250,251,252,253,254,255,192,193,194,195,196,197,198,199,200
;		dta 201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216
;	
;		dta 217,218,219,220,221,222,223,160,161,162,163,164,165,166,167,168
;		dta 169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184
;
;		dta 185,186,187,188,189,190,191,128,129,130,131,132,133,134,135,136
;		dta 137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152
;	
;		dta 153,154,155,156,157,158,159,096,097,098,099,100,101,102,103,104
;		dta 105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120
;
;		dta 121,122,123,124,125,126,127,064,065,066,067,068,069,070,071,072
;		dta 073,074,075,076,077,078,079,080,081,082,083,084,085,086,087,088
;
;		dta 089,090,091,092,093,094,095,032,033,034,035,036,037,038,039,040
;		dta 041,042,043,044,045,046,047,048,049,050,051,052,053,054,055,056
;
;		dta 057,058,059,060,061,062,063,000,001,002,003,004,005,006,007,008
;		dta 009,010,011,012,013,014,015,016,017,018,019,020,021,022,023,024
;		dta 025,026,027,028,029,030,031
;
;sprite_blit_table_hi
;		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;
;vdc_colour_convert
;		dta $00,$0f,$08,$07,$0a,$04,$02,$0d,$00,$00,$00,$00,$00,$00,$00,$00
;		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;ColourFlasher
;		dta $00,$00,$00,$01,$01,$01,$0e,$0e,$0e,$0f,$0f,$0f,$0e,$0e,$0e,$01
;		dta $01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;		
;		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;
;		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;
;		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;
;		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
;		dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00						
;						
;		dta $17,$16,$15,$14,$13,$12,$11,$10,$0f,$0e,$0d,$0c,$0b,$0a,$09,$08
;		dta $07,$06,$05,$04,$03,$02,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00
		
		