/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.Label;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.LabelReferenceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;

public class LabelAssignmentDirective
extends AsmDirective
implements Label {
    private String name;
    private ExprNode valueExpr;

    public LabelAssignmentDirective(String string, ExprNode exprNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
        this.valueExpr = exprNode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        Value value = this.valueExpr.evaluate(evaluationState);
        if (value.isInvalidOrInvalidContent()) {
            return this;
        }
        if (!value.hasRepresentation(Value.RP_DOUBLEVALUE)) {
            throw new AsmError("The value of a label. This expression returns a value of type '" + value.getType() + "'", this.debug);
        }
        SymbolScope symbolScope = evaluationState.getCurrentScope().getSymbols();
        LabelReferenceValue labelReferenceValue = (LabelReferenceValue)symbolScope.getLocalDefinedEntities().get(this.name);
        labelReferenceValue.setResolvedLabelValue(value, evaluationState, this.debug);
        evaluationState.setMadeMetaProgress();
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope().getSymbols();
        SymbolScopeValue symbolScopeValue = (SymbolScopeValue)symbolScope.getLocalDefinedEntities().get(this.name);
        if (symbolScopeValue != null) {
            throw new AsmError("The symbol '" + this.name + "' is already defined", this.debug);
        }
        symbolScope.put(this.name, new LabelReferenceValue());
        return this;
    }

    @Override
    public String toString() {
        return "Label(" + this.name + ")";
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("LabelAsg", this.debug, this.name, this.valueExpr);
        return nodeTreeBuilder;
    }
}

