/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.misc;

import cml.kickass.exceptions.AsmError;
import cml.kickass.misc.MemoryBlock;
import cml.log.Log;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class C64File {
    private static Log log = new Log("");
    private static boolean allowOverlappingMemoryBlocks = false;
    byte[] startAddress = new byte[2];
    byte[] data;

    public static void allowOverlappingMemoryBlocks(boolean bl) {
        allowOverlappingMemoryBlocks = bl;
    }

    public C64File(List<MemoryBlock> list, byte by) throws AsmError {
        int n;
        int n2;
        MemoryBlock memoryBlock2;
        ArrayList<MemoryBlock> arrayList = new ArrayList<MemoryBlock>();
        for (MemoryBlock memoryBlock2 : list) {
            if (memoryBlock2.isVirtual()) continue;
            arrayList.add(memoryBlock2);
        }
        if (arrayList.isEmpty()) {
            this.startAddress[0] = 0;
            this.startAddress[1] = 32;
            System.out.println("WARNING! No data in memory!");
            this.data = new byte[0];
            return;
        }
        Comparator<MemoryBlock> comparator = new Comparator<MemoryBlock>(){

            @Override
            public int compare(MemoryBlock memoryBlock, MemoryBlock memoryBlock2) {
                int n;
                int n2 = memoryBlock.getStartAdress();
                if (n2 < (n = memoryBlock2.getStartAdress())) {
                    return -1;
                }
                if (n2 == n) {
                    return 0;
                }
                return 1;
            }
        };
        Collections.sort(arrayList, comparator);
        memoryBlock2 = (MemoryBlock)arrayList.get(0);
        int n3 = memoryBlock2.getStartAdress();
        int n4 = n3 + memoryBlock2.getSize();
        for (n2 = 1; n2 < arrayList.size(); ++n2) {
            MemoryBlock memoryBlock3 = (MemoryBlock)arrayList.get(n2);
            if (memoryBlock3.getStartAdress() < n4) {
                String string = "Memoryblock starting at $" + Integer.toHexString(memoryBlock3.getStartAdress()) + " overlaps the previous block";
                if (allowOverlappingMemoryBlocks) {
                    log.warn("Warning: " + string);
                } else {
                    throw new AsmError("Error: " + string, null);
                }
            }
            if ((n = memoryBlock3.getStartAdress() + memoryBlock3.getSize()) <= n4) continue;
            n4 = n;
        }
        this.startAddress[0] = (byte)(n3 & 0xFF);
        this.startAddress[1] = (byte)((n3 & 0xFF00) >> 8);
        this.data = new byte[n4 - n3];
        for (n2 = 0; n2 < this.data.length; ++n2) {
            this.data[n2] = by;
        }
        for (MemoryBlock memoryBlock3 : arrayList) {
            n = memoryBlock3.getStartAdress() - n3;
            byte[] byArray = memoryBlock3.getMemory();
            for (int i = 0; i < memoryBlock3.getSize(); ++i) {
                this.data[n + i] = byArray[i];
            }
        }
    }

    public boolean writeFile(String string, boolean bl) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            if (!bl) {
                fileOutputStream.write(this.startAddress);
            }
            fileOutputStream.write(this.data);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

