/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmException;
import cml.kickass.function.BooleanFunction;
import cml.kickass.function.BooleanX2Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.Value;

public class BooleanValue
extends ImmutableValue {
    private boolean value;
    public static BooleanValue invalid = new BooleanValue();
    public static BooleanValue falseValue = new BooleanValue(false);
    public static BooleanValue trueValue = new BooleanValue(true);
    static FunctionTable functions = new StdFunctionTable(BooleanValue.getStandardFunctions());

    public static BooleanValue get(boolean bl) {
        return bl ? trueValue : falseValue;
    }

    private BooleanValue() {
        this.setInvalid();
    }

    private BooleanValue(boolean bl) {
        this.value = bl;
    }

    @Override
    public String getType() {
        return "boolean";
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        if (n == RP_BOOLEANVALUE) {
            return new Boolean(this.value);
        }
        if (n == RP_STRINGVALUE) {
            if (this.isInvalid()) {
                return "<<Invalid Boolean>>";
            }
            return "" + this.value;
        }
        return null;
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    static {
        functions.add(new BooleanFunction("!", invalid){

            @Override
            protected Value f(boolean bl) {
                return BooleanValue.get(!bl);
            }
        });
        functions.add(new BooleanX2Function("==", invalid){

            @Override
            protected Value f(boolean bl, boolean bl2) {
                return BooleanValue.get(bl == bl2);
            }
        });
        functions.add(new BooleanX2Function("!=", invalid){

            @Override
            protected Value f(boolean bl, boolean bl2) {
                return BooleanValue.get(bl != bl2);
            }
        });
        functions.add(new BooleanX2Function("&&", invalid){

            @Override
            protected Value f(boolean bl, boolean bl2) {
                return BooleanValue.get(bl && bl2);
            }
        });
        functions.add(new BooleanX2Function("||", invalid){

            @Override
            protected Value f(boolean bl, boolean bl2) {
                return BooleanValue.get(bl || bl2);
            }
        });
    }
}

