/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.asmnode.metanodes;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.state.EvaluationState;
import java.util.ArrayList;
import java.util.List;

public class AsmNodeList
extends AsmNode {
    private Boolean isFinished = null;
    private List<AsmNode> list;

    public AsmNodeList() {
        this.list = new ArrayList<AsmNode>();
    }

    public AsmNodeList(List<AsmNode> list) {
        this.list = list;
    }

    public List<AsmNode> getValues() {
        return this.list;
    }

    public void add(AsmNode asmNode) {
        this.list.add(asmNode);
    }

    @Override
    public boolean isFinished() {
        if (this.isFinished == null) {
            boolean bl = true;
            for (AsmNode asmNode : this.list) {
                bl &= asmNode.isFinished();
            }
            this.isFinished = bl;
        }
        return this.isFinished;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        boolean bl = true;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            AsmNode asmNode = this.list.get(i).parse(evaluationState);
            this.list.set(i, asmNode);
            bl = bl && asmNode.isFinished();
        }
        this.isFinished = bl;
        return this;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        boolean bl = true;
        for (int i = 0; i < this.list.size(); ++i) {
            AsmNode asmNode = this.list.get(i).preParse(evaluationState);
            this.list.set(i, asmNode);
            bl = bl && asmNode.isFinished();
        }
        this.isFinished = bl;
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        for (int i = 0; i < this.list.size(); ++i) {
            AsmNode asmNode = this.list.get(i).registerMetaDefinitions(evaluationState);
            this.list.set(i, asmNode);
        }
        return this;
    }

    @Override
    public AsmNode copy() {
        ArrayList<AsmNode> arrayList = new ArrayList<AsmNode>();
        arrayList.ensureCapacity(this.list.size());
        for (AsmNode asmNode : this.list) {
            arrayList.add(asmNode.copy());
        }
        return new AsmNodeList(arrayList);
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        for (AsmNode asmNode : this.list) {
            asmNode.deliverOutput(outputReciever);
        }
    }

    @Override
    public String toString() {
        return "AsmNodeList[finished=" + this.isFinished + "]";
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        for (AsmNode asmNode : this.list) {
            asmNode.functionParse(evaluationState);
        }
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("AsmNodeList", null);
        for (AsmNode asmNode : this.list) {
            nodeTreeBuilder.addArg(null, asmNode);
        }
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

