/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ReturnException;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.state.scope.StdScope;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.NullValue;
import cml.kickass.values.Value;
import cml.kickass.values.VariableReferenceValue;
import java.util.List;

class UserFunction
extends Function {
    private List<String> argumentNames;
    private List<AsmNode> body;

    protected UserFunction(String string, ExecutableDirectives executableDirectives) {
        super(string, executableDirectives.getArgumentNames().size(), null, true);
        this.argumentNames = executableDirectives.getArgumentNames();
        this.body = executableDirectives.getDirectives();
    }

    @Override
    public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) throws AsmException {
        Scope scope = evaluationState.getCurrentScope();
        Scope scope2 = evaluationState.getScopeBeforeFunctionMode();
        boolean bl = evaluationState.getFunctionsMode();
        Scope scope3 = scope2;
        if (scope3 == null) {
            scope3 = evaluationState.getCurrentScope();
            evaluationState.setScopeBeforeFunctionMode(scope3);
        }
        StdScope stdScope = new StdScope(scope3, false);
        evaluationState.setCurrentScope(stdScope);
        SymbolScope symbolScope = stdScope.getSymbols();
        for (int i = 0; i < valueArray.length; ++i) {
            VariableReferenceValue variableReferenceValue = new VariableReferenceValue(valueArray[i]);
            symbolScope.put(this.argumentNames.get(i), variableReferenceValue);
        }
        evaluationState.setFunctionMode(true);
        Value value = NullValue.instance;
        try {
            for (AsmNode asmNode : this.body) {
                asmNode.functionParse(evaluationState);
            }
        }
        catch (ReturnException returnException) {
            value = returnException.getReturnValue();
        }
        evaluationState.setFunctionMode(bl);
        evaluationState.setCurrentScope(scope);
        evaluationState.setScopeBeforeFunctionMode(scope2);
        return value;
    }
}

