/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass;

import cml.kickass.AssemblerToolbox;
import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.asmnode.output.reciever.MainOutputReciever;
import cml.kickass.exceptions.AsmError;
import cml.kickass.libraries.MathLibrary;
import cml.kickass.libraries.MiscLibrary;
import cml.kickass.libraries.MnemonicsLibrary;
import cml.kickass.libraries.PrintLibrary;
import cml.kickass.libraries.StdConstructorLibrary;
import cml.kickass.libraries.VectorLibrary;
import cml.kickass.misc.C64File;
import cml.kickass.misc.SymbolFile;
import cml.kickass.misc.ViceSymbolFile;
import cml.kickass.state.AssertManager;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.ConstantReferenceValue;
import cml.kickass.values.HashtableValue;
import cml.log.Log;
import cml.tools.Timer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class KickAssembler {
    private static final String AUTO_INCLUDED_FILE = "/include/autoinclude.asm";
    private static final String CONFIG_FILE = "/KickAss.cfg";
    private static Log log = new Log("");

    public static void main(String[] stringArray) {
        stringArray = KickAssembler.getExtraArgs(stringArray);
        log.addPrintStream(System.out);
        log.println("//------------------------------------------------------");
        log.println("//------------------------------------------------------");
        log.println("//       Kick Assembler v3.19 - The LCP Release!        ");
        log.println("//------------------------------------------------------");
        log.println("//------------------------------------------------------");
        File file = new File(".");
        String string = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        byte by = 0;
        boolean bl10 = false;
        boolean bl11 = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        OutputStreamWriter outputStreamWriter = null;
        EvaluationState evaluationState = new EvaluationState();
        try {
            String string4;
            Object object;
            AssertManager assertManager;
            String string5;
            int n = 0;
            while (n < stringArray.length) {
                if ((string5 = stringArray[n++]).equalsIgnoreCase("-o")) {
                    KickAssembler.ensureArgument(n, stringArray, "-o");
                    string = stringArray[n++];
                    continue;
                }
                if (string5.equalsIgnoreCase("-libdir")) {
                    KickAssembler.ensureArgument(n, stringArray, "-libdir");
                    arrayList.add(new File(stringArray[n++]));
                    continue;
                }
                if (string5.equalsIgnoreCase("-execute")) {
                    KickAssembler.ensureArgument(n, stringArray, "-execute");
                    string3 = stringArray[n++];
                    continue;
                }
                if (string5.equalsIgnoreCase("-showmem")) {
                    bl = true;
                    continue;
                }
                if (string5.equalsIgnoreCase("-debug")) {
                    bl2 = true;
                    continue;
                }
                if (string5.equalsIgnoreCase("-binfile")) {
                    bl10 = true;
                    continue;
                }
                if (string5.equalsIgnoreCase("-dtv")) {
                    bl3 = true;
                    continue;
                }
                if (string5.equalsIgnoreCase("-time")) {
                    bl6 = true;
                    continue;
                }
                if (string5.equalsIgnoreCase("-warningsoff")) {
                    bl5 = false;
                    continue;
                }
                if (string5.equalsIgnoreCase("-fillbyte")) {
                    KickAssembler.ensureArgument(n, stringArray, "-fillbyte");
                    try {
                        by = (byte)Integer.valueOf(stringArray[n++]).intValue();
                    }
                    catch (Exception exception) {
                        log.println("Invalid arg for -fillbyte: " + stringArray[n - 1]);
                    }
                    continue;
                }
                if (string5.equalsIgnoreCase("-aom")) {
                    bl4 = true;
                    continue;
                }
                if (string5.equalsIgnoreCase("-vicesymbols")) {
                    bl7 = true;
                    continue;
                }
                if (string5.equalsIgnoreCase("-symbolfile")) {
                    bl8 = true;
                    continue;
                }
                if (string5.equalsIgnoreCase("-afo")) {
                    bl11 = true;
                    continue;
                }
                if (string5.equalsIgnoreCase("-parsetree")) {
                    bl9 = true;
                    continue;
                }
                if (string5.equalsIgnoreCase("-log")) {
                    KickAssembler.ensureArgument(n, stringArray, "-log");
                    try {
                        log.addPrintStream(new PrintStream(new FileOutputStream(stringArray[n++])));
                    }
                    catch (Exception exception) {
                        log.println("Couldn't create log : " + exception.getMessage());
                    }
                    continue;
                }
                if (string5.charAt(0) == ':') {
                    KickAssembler.parseCommandLineVar(string5, hashMap);
                    continue;
                }
                if (string2 == null) {
                    string2 = string5;
                    continue;
                }
                log.println("Warning. Allready have an inputfile. Won't use '" + string5 + "'");
            }
            Log.setDebugging(bl2);
            Log.setWarnings(bl5);
            C64File.allowOverlappingMemoryBlocks(bl4);
            if (string2 == null) {
                log.println("Error: No inputfile supplied.");
                return;
            }
            if (!new File(string2).exists()) {
                log.println("Error: Inputfile '" + string2 + "' doesn't exist.");
                return;
            }
            string5 = string2;
            int n2 = string5.lastIndexOf(46);
            if (n2 >= 0) {
                string5 = string5.substring(0, n2);
            }
            if (string == null) {
                String string6 = bl10 ? ".bin" : ".prg";
                string = string5 + string6;
            }
            if (bl9) {
                outputStreamWriter = new FileWriter("parsetree_.txt");
            }
            long l = System.nanoTime();
            evaluationState.setSourceLibraryPath(arrayList);
            evaluationState.setDtvMode(bl3);
            HashtableValue hashtableValue = new HashtableValue().addStringValues(hashMap);
            hashtableValue.lock(null);
            evaluationState.getSystemScope().getSymbols().putErrorIfExist("cmdLineVars", new ConstantReferenceValue(hashtableValue), "ERROR!", null);
            evaluationState.addLibrary(new MathLibrary());
            evaluationState.addLibrary(new PrintLibrary());
            evaluationState.addLibrary(new VectorLibrary());
            evaluationState.addLibrary(new StdConstructorLibrary());
            evaluationState.addLibrary(new MiscLibrary());
            evaluationState.addLibrary(new MnemonicsLibrary());
            boolean bl12 = true;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("User Arguments: ");
            for (Map.Entry object22 : hashMap.entrySet()) {
                if (bl12) {
                    bl12 = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)object22.getKey() + "=" + (String)object22.getValue());
            }
            if (!bl12) {
                log.println(stringBuffer.toString());
            }
            log.println("parsing");
            AsmNodeList asmNodeList = new AsmNodeList();
            InputStream inputStream = new KickAssembler().getClass().getResourceAsStream(AUTO_INCLUDED_FILE);
            asmNodeList.add(AssemblerToolbox.loadAndLex(inputStream, AUTO_INCLUDED_FILE, evaluationState, null));
            File file2 = evaluationState.getFile(string2, null);
            evaluationState.setCurrentDirectory(file2.getCanonicalFile().getParentFile());
            asmNodeList.add(AssemblerToolbox.loadAndLex(string2, evaluationState, null));
            AsmNodeList asmNodeList2 = asmNodeList;
            if (bl9) {
                outputStreamWriter.append("*****  Init tree *****\n");
                outputStreamWriter.append(((AsmNode)asmNodeList2).toNodeTreeString(new NodeTreeBuilder()).toString());
                outputStreamWriter.append("\n");
            }
            do {
                evaluationState.prepareNewParse();
                log.println("flex pass " + evaluationState.getPassNo());
                if (evaluationState.getPassNo() == 1) {
                    ((AsmNode)asmNodeList2).registerMetaDefinitions(evaluationState);
                    ((AsmNode)asmNodeList2).preParse(evaluationState);
                    if (bl9) {
                        outputStreamWriter.append("\n*****  Parsetree after preparse *****\n");
                        outputStreamWriter.append(((AsmNode)asmNodeList2).toNodeTreeString(new NodeTreeBuilder()).toString());
                        outputStreamWriter.append("\n");
                    }
                }
                asmNodeList2 = ((AsmNode)asmNodeList2).parse(evaluationState);
                if (bl9) {
                    outputStreamWriter.append("\n*****  Parsetree after parse " + evaluationState.getPassNo() + " *****\n");
                    outputStreamWriter.append(((AsmNode)asmNodeList2).toNodeTreeString(new NodeTreeBuilder()).toString());
                    outputStreamWriter.append("\n");
                }
                if (evaluationState.getMadeMetaProgress() || ((AsmNode)asmNodeList2).isFinished()) continue;
                evaluationState.prepareNewParse();
                evaluationState.setFailOnInvalidValue(true);
                asmNodeList2 = ((AsmNode)asmNodeList2).parse(evaluationState);
                throw new AsmError("Made no progress and cant solve the program.. You should have gotten an error. Contact the author!", null);
            } while (!((AsmNode)asmNodeList2).isFinished());
            log.println("Output pass");
            MainOutputReciever mainOutputReciever = new MainOutputReciever(8192, bl11);
            ((AsmNode)asmNodeList2).deliverOutput(mainOutputReciever);
            mainOutputReciever.finish();
            long l2 = System.nanoTime() - l;
            if (bl6) {
                log.println("Assemble time = " + l2 / 1000000L + " ms");
            }
            Timer.printTimers();
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                    outputStreamWriter = null;
                }
                catch (Exception assertManager2) {
                    // empty catch block
                }
            }
            if (bl) {
                log.println();
                log.println(AssemblerToolbox.printMemoryBlocks(mainOutputReciever.getMemoryBlocks()));
            }
            if ((assertManager = evaluationState.getAssertManager()).getNoOfAsserts() > 0) {
                log.println();
                object = assertManager.getNoOfFailedAsserts() == 0 ? " failed" : " FAILED!";
                log.println("Made " + assertManager.getNoOfAsserts() + " asserts , " + assertManager.getNoOfFailedAsserts() + (String)object);
            }
            object = new C64File(mainOutputReciever.getMemoryBlocks(), by);
            log.println("Writing file: " + string);
            ((C64File)object).writeFile(string, bl10);
            if (bl7) {
                string4 = string5 + ".vs";
                log.println("Writing Vice symbol file: " + string4);
                new ViceSymbolFile(evaluationState.getCurrentScope()).writeFile(string4);
            }
            if (bl8) {
                string4 = string5 + ".sym";
                new SymbolFile(evaluationState.getCurrentScope()).writeFile(string4);
                log.println("Writing Symbol file: " + string4);
            }
            if (string3 != null) {
                string4 = string3 + " " + string;
                try {
                    Runtime.getRuntime().exec(string4);
                }
                catch (Exception exception) {
                    log.error("Error while executing external program: " + exception);
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof AsmError) {
                ((AsmError)exception).setCallStack(evaluationState.getCallStack());
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            log.error(exception);
            System.exit(1);
        }
    }

    static void parseCommandLineVar(String string, Map<String, String> map) {
        int n = string.indexOf(61);
        if (n < 0) {
            throw new AsmError("Can't parse user command line argument. Missing '='. " + string, null);
        }
        String string2 = string.substring(1, n);
        String string3 = string.substring(n + 1);
        if (string2.length() == 0) {
            throw new AsmError("Can't parse user command line argument. Invalid argument name. " + string, null);
        }
        if (string3.length() != 0 && string3.charAt(0) == '\"') {
            if (string3.charAt(string3.length() - 1) == '\"') {
                throw new AsmError("Unterminated '\"' in command line argument. " + string, null);
            }
            string3 = string3.substring(1, string3.length() - 2);
        }
        map.put(string2, string3);
    }

    private static void ensureArgument(int n, String[] stringArray, String string) {
        if (n >= stringArray.length) {
            log.println("Missing parameter for '" + string + "' option");
            System.exit(1);
        }
    }

    private static String[] getExtraArgs(String[] stringArray) {
        String[] stringArray2;
        Serializable serializable;
        File file = null;
        try {
            serializable = new File(KickAssembler.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!((File)serializable).isDirectory()) {
                serializable = ((File)serializable).getParentFile();
            } else {
                boolean bl = KickAssembler.javaFileExist((File)serializable, KickAssembler.class.getCanonicalName());
                if (bl) {
                    serializable = ((File)serializable).getParentFile();
                }
            }
            file = new File((File)serializable, CONFIG_FILE);
            if (!file.exists()) {
                return stringArray;
            }
        }
        catch (Exception exception) {
            return stringArray;
        }
        serializable = new ArrayList();
        try {
            String string;
            stringArray2 = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string = stringArray2.readLine()) != null) {
                KickAssembler.parseConfigLine(string, (List<String>)((Object)serializable));
            }
        }
        catch (IOException iOException) {
            System.out.println("Error while reading config file (/KickAss.cfg): " + iOException.getMessage());
            System.exit(1);
        }
        for (String string : stringArray) {
            serializable.add(string);
        }
        stringArray2 = new String[serializable.size()];
        int n = 0;
        Iterator iterator = serializable.iterator();
        while (iterator.hasNext()) {
            String string;
            string = (String)iterator.next();
            stringArray2[n++] = string;
        }
        return stringArray2;
    }

    private static boolean javaFileExist(File file, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        File file2 = file;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                string2 = string2 + ".class";
            }
            if ((file2 = new File(file2, string2)).exists()) continue;
            return false;
        }
        return true;
    }

    private static void parseConfigLine(String string, List<String> list) {
        int n = string.indexOf(34);
        String string2 = n < 0 ? string : string.substring(0, n);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        int n2 = string.indexOf(34, n + 1);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n >= 0) {
            list.add(string.substring(n + 1, n2));
        }
        if (n2 + 1 < string.length()) {
            KickAssembler.parseConfigLine(string.substring(n2 + 1), list);
        }
    }
}

