/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.asmnode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.values.Value;
import cml.tools.tuples.Pair;
import java.util.ArrayList;
import java.util.List;

public class NodeTreeBuilder {
    int nodeIndent = 0;
    private StringBuilder sb = new StringBuilder();
    private String nodeReferenceName = null;
    private boolean isFinished = false;
    private NodeData nodeData = null;

    public String toString() {
        return this.sb.toString();
    }

    public void addNode(String string, DebugInfo debugInfo, List<ExprNode> list) {
        this.enterNode(string, debugInfo);
        for (ExprNode exprNode : list) {
            this.addArg(null, exprNode);
        }
        this.exitNode();
    }

    public void addNode(String string, DebugInfo debugInfo, String string2, List<ExprNode> list) {
        this.enterNode(string, debugInfo);
        this.addArg(null, string2);
        for (ExprNode exprNode : list) {
            this.addArg(null, exprNode);
        }
        this.exitNode();
    }

    public void addNode(String string, DebugInfo debugInfo, String string2, String string3, List<ExprNode> list) {
        this.enterNode(string, debugInfo);
        this.addArg(null, string2);
        this.addArg(null, string3);
        for (ExprNode exprNode : list) {
            this.addArg(null, exprNode);
        }
        this.exitNode();
    }

    public void addNode(String string, DebugInfo debugInfo, ExprNode ... exprNodeArray) {
        this.enterNode(string, debugInfo);
        for (ExprNode exprNode : exprNodeArray) {
            this.addArg(null, exprNode);
        }
        this.exitNode();
    }

    public void addNode(String string, DebugInfo debugInfo, String string2, ExprNode ... exprNodeArray) {
        this.enterNode(string, debugInfo);
        this.addArg(null, string2);
        for (ExprNode exprNode : exprNodeArray) {
            this.addArg(null, exprNode);
        }
        this.exitNode();
    }

    public void addArg(String string, Value value) {
        this.addArg(string, value.toString());
    }

    public void addArg(String string, String string2) {
        this.nodeData.args.add(new Pair<String, String>(string, string2));
    }

    public void addArg(String string, ExprNode exprNode) {
        this.addArg(string, exprNode.toNodeTreeString(new ExprTreeBuilder()).toString());
    }

    public void addArg(String string, AsmNode asmNode) {
        this.nodeData.subNodes.add(new Pair<String, AsmNode>(string, asmNode));
    }

    public void enterNode(String string, DebugInfo debugInfo) {
        this.nodeData = new NodeData();
        this.nodeData.name = string;
        this.nodeData.debug = debugInfo;
    }

    public void exitNode() {
        NodeData nodeData = this.nodeData;
        this.nodeData = null;
        this.addNodeIndentStr(nodeData.debug);
        if (this.nodeReferenceName != null) {
            this.sb.append(this.nodeReferenceName + ": ");
        }
        if (!this.isFinished) {
            this.sb.append("#");
        }
        this.sb.append("N" + nodeData.name + "(");
        boolean bl = true;
        for (Pair<String, String> pair : nodeData.args) {
            if (bl) {
                bl = false;
            } else {
                this.sb.append(", ");
            }
            String string = pair.getA();
            if (string != null) {
                this.sb.append(string + ":");
            }
            this.sb.append(pair.getB());
        }
        this.sb.append(")\n");
        ++this.nodeIndent;
        for (Pair<String, Object> pair : nodeData.subNodes) {
            this.nodeReferenceName = pair.getA();
            this.isFinished = ((AsmNode)pair.getB()).isFinished();
            ((AsmNode)pair.getB()).toNodeTreeString(this);
        }
        --this.nodeIndent;
    }

    private void addNodeIndentStr(DebugInfo debugInfo) {
        int n;
        int n2 = 30;
        String string = debugInfo == null ? "" : String.format("%s %d:%d ", debugInfo.getFilename(), debugInfo.getLine() + 1, debugInfo.getCollumn() + 1);
        string = string.substring(Math.max(0, string.length() - n2));
        this.sb.append(string);
        for (n = n2 - string.length(); n > 0; --n) {
            this.sb.append(" ");
        }
        this.sb.append(" : ");
        for (n = 0; n < this.nodeIndent; ++n) {
            this.sb.append("   ");
        }
    }

    private static class NodeData {
        String name;
        DebugInfo debug;
        List<Pair<String, String>> args = new ArrayList<Pair<String, String>>();
        List<Pair<String, AsmNode>> subNodes = new ArrayList<Pair<String, AsmNode>>();

        private NodeData() {
        }
    }
}

