/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.asmnode.output;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.asmnode.output.reciever.OutputStreamType;
import cml.kickass.exceptions.AsmError;
import cml.kickass.sideeffect.SideEffect;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.FunctionSideOutput;
import cml.tools.tuples.Triple;

public abstract class AsmOutput
extends AsmNode {
    private FunctionSideOutput sideEffectOutput = null;

    protected AsmOutput() {
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    protected AsmOutput(FunctionSideOutput functionSideOutput) {
        this.sideEffectOutput = functionSideOutput;
    }

    @Override
    public boolean isFinished() {
        return true;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        this.parseSideOutput(this.sideEffectOutput, evaluationState);
        return this;
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        throw new AsmError("This directive cannot be used in functions/functionmode", null);
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        if (this.sideEffectOutput == null) {
            return;
        }
        for (Triple<OutputStreamType, String, Object> triple : this.sideEffectOutput.getStreamOutput()) {
            outputReciever.addToStream(triple.getA(), triple.getB(), triple.getC());
        }
    }

    protected void addSideEffectOutput(NodeTreeBuilder nodeTreeBuilder) {
        if (this.sideEffectOutput == null) {
            return;
        }
        for (SideEffect sideEffect : this.sideEffectOutput.getSideEffects()) {
            nodeTreeBuilder.addArg(null, "SE" + sideEffect.getNodeTreeString());
        }
    }
}

