/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.directives.Directive;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.StdScope;
import cml.kickass.values.Value;
import java.util.List;

public class ForDirective
extends Directive {
    private List<ExprNode> initExprs;
    private ExprNode conditionExpr;
    private List<ExprNode> iterExprs;
    private AsmNode body;
    private AsmNode outerScopeNode;

    public ForDirective(List<ExprNode> list, ExprNode exprNode, List<ExprNode> list2, AsmNode asmNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.initExprs = list;
        this.conditionExpr = exprNode;
        this.iterExprs = list2;
        this.body = asmNode;
    }

    @Override
    public boolean isFinished() {
        return this.outerScopeNode == null ? false : this.outerScopeNode.isFinished();
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        this.outerScopeNode.deliverOutput(outputReciever);
    }

    @Override
    public AsmNode copy() {
        return new ForDirective(this.initExprs, this.conditionExpr, this.iterExprs, this.body, this.debug);
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        AsmNodeList asmNodeList = new AsmNodeList();
        ScopeNode scopeNode = new ScopeNode(asmNodeList);
        this.outerScopeNode = scopeNode;
        scopeNode.enterScope(evaluationState);
        evaluationState.clearFunctionSideOutput();
        this.evaluateExprs(this.initExprs, evaluationState);
        while (this.errorIfInvalid(this.conditionExpr.evaluate(evaluationState)).getBoolean(this.debug)) {
            asmNodeList.add(new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput()));
            evaluationState.clearFunctionSideOutput();
            AsmNode asmNode = new ScopeNode(this.body.copy());
            asmNode = ((AsmNode)asmNode).preParse(evaluationState).parse(evaluationState);
            asmNodeList.add(asmNode);
            evaluationState.clearFunctionSideOutput();
            this.evaluateExprs(this.iterExprs, evaluationState);
        }
        asmNodeList.add(new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput()));
        scopeNode.exitScope(evaluationState);
        return this.outerScopeNode;
    }

    private void evaluateExprs(List<ExprNode> list, EvaluationState evaluationState) {
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).evaluate(evaluationState);
        }
    }

    private Value errorIfInvalid(Value value) {
        if (value.isInvalid()) {
            throw new AsmError("Can't evaluate condition in first pass", this.debug);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void functionParse(EvaluationState evaluationState) {
        StdScope stdScope = new StdScope(evaluationState.getCurrentScope(), false);
        evaluationState.setCurrentScope(stdScope);
        this.evaluateExprs(this.initExprs, evaluationState);
        try {
            while (this.errorIfInvalid(this.conditionExpr.evaluate(evaluationState)).getBoolean(this.debug)) {
                StdScope stdScope2 = new StdScope(stdScope, false);
                evaluationState.setCurrentScope(stdScope2);
                this.body.functionParse(evaluationState);
                evaluationState.setCurrentScope(stdScope);
                this.evaluateExprs(this.iterExprs, evaluationState);
            }
        }
        finally {
            evaluationState.setCurrentScope(stdScope.getParrent());
        }
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        int n;
        nodeTreeBuilder.enterNode("For", this.debug);
        for (n = 0; n < this.initExprs.size(); ++n) {
            nodeTreeBuilder.addArg("init" + n, this.initExprs.get(n));
        }
        nodeTreeBuilder.addArg("condition", this.conditionExpr);
        for (n = 0; n < this.iterExprs.size(); ++n) {
            nodeTreeBuilder.addArg("iter" + n, this.iterExprs.get(n));
        }
        nodeTreeBuilder.addArg("body", this.body);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

