/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.ScopeNode;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.values.Value;
import cml.log.Log;

public class AssertErrorCodeDirective
extends AsmDirective {
    private Log log = new Log("AssertCodeDirective");
    private ExprNode testNameExpr;
    private AsmNode body;
    private DebugInfo debug;
    boolean preparsed = false;

    public AssertErrorCodeDirective(ExprNode exprNode, AsmNode asmNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.testNameExpr = exprNode;
        this.body = new ScopeNode(asmNode).setRegisterInParrentScope(false);
    }

    @Override
    public AsmNode copy() {
        return new AssertErrorCodeDirective(this.testNameExpr, this.body, this.debug);
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        Integer n = evaluationState.getMemoryPosition();
        boolean bl = evaluationState.getFunctionsMode();
        Scope scope = evaluationState.getCurrentScope();
        int n2 = evaluationState.getCallStack().getStackSize();
        evaluationState.setMemoryPositionWithoutSideEffect(8192);
        AsmError asmError = null;
        try {
            if (!this.preparsed) {
                this.body = this.body.registerMetaDefinitions(evaluationState).preParse(evaluationState);
                this.preparsed = true;
            }
            this.body = this.body.parse(evaluationState);
        }
        catch (AsmError asmError2) {
            asmError = asmError2;
        }
        evaluationState.setMemoryPositionWithoutSideEffect(n);
        evaluationState.setFunctionMode(bl);
        evaluationState.setCurrentScope(scope);
        evaluationState.getCallStack().popTilDepth(n2);
        evaluationState.clearFunctionSideOutput();
        Value value = this.testNameExpr.evaluate(evaluationState);
        if (asmError == null && !this.body.isFinished()) {
            return this;
        }
        String string = value.getString(this.debug);
        String string2 = asmError != null ? string + " -- OK. | " + asmError.getOneLineMessage() : string + " -- FAILED!";
        evaluationState.addTextOutput(string2);
        evaluationState.getAssertManager().madeAssert(asmError == null);
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("AssertCode", this.debug);
        nodeTreeBuilder.addArg("msg", this.testNameExpr);
        nodeTreeBuilder.addArg(null, this.body);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

