/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.StdScope;
import cml.kickass.values.NullValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;
import cml.kickass.values.VariableReferenceValue;
import java.util.ArrayList;

public class FillDirective
extends AsmDirective {
    private ArrayList<ExprNode> arguments;

    @Override
    public AsmNode copy() {
        return this;
    }

    public FillDirective(ArrayList<ExprNode> arrayList, DebugInfo debugInfo) {
        super(debugInfo);
        this.arguments = arrayList;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        int n;
        evaluationState.clearFunctionSideOutput();
        if (this.arguments.size() != 2) {
            throw new AsmError("Invalid number of arguemnts", this.debug);
        }
        ExprNode exprNode = this.arguments.get(0);
        ExprNode exprNode2 = this.arguments.get(1);
        Value value = exprNode.evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmError("You must be able to determine the size argument en first pass", this.debug);
        }
        int n2 = value.getInt(this.debug);
        if (n2 < 0) {
            throw new AsmError("The size of a fill directive cant be negative. Size=" + n2, this.debug);
        }
        StdScope stdScope = new StdScope(evaluationState.getCurrentScope(), true);
        evaluationState.setCurrentScope(stdScope);
        VariableReferenceValue variableReferenceValue = new VariableReferenceValue(NullValue.instance);
        stdScope.getSymbols().put("i", variableReferenceValue);
        byte[] byArray = new byte[n2];
        for (n = 0; n < n2; ++n) {
            ((SymbolScopeValue)variableReferenceValue).setWithoutSideEffect(new NumberValue(n));
            Value value2 = exprNode2.evaluate(evaluationState);
            if (value2.isInvalid()) continue;
            byArray[n] = (byte)(value2.getInt(this.debug) & 0xFF);
        }
        evaluationState.setCurrentScope(stdScope.getParrent());
        evaluationState.increaseMemoryPosition(n2);
        n = evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation() ? 1 : 0;
        return n != 0 ? this : new ByteOutput(byArray, evaluationState.getFunctionSideOutput());
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("Fill", this.debug, this.arguments);
        return nodeTreeBuilder;
    }
}

