/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.AssemblerToolbox;
import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.AddDebugToCallStackNode;
import cml.kickass.asmnode.metanodes.PreSideEffectsNode;
import cml.kickass.asmnode.metanodes.SetCurrentDirectoryNode;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.directives.Directive;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.CharToPetsciiConverter;
import cml.kickass.sideeffect.SEIncreaseMemoryPosition;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.FunctionSideOutput;
import cml.kickass.values.Value;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ImportDirective
extends AsmDirective {
    private String type;
    private ExprNode filenameExpr;

    public ImportDirective(String string, ExprNode exprNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.type = string;
        this.filenameExpr = exprNode;
    }

    @Override
    public Directive copy() {
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        if (this.type.equalsIgnoreCase("source")) {
            evaluationState.clearFunctionSideOutput();
            Value value = this.filenameExpr.evaluate(evaluationState);
            if (value.isInvalid()) {
                throw new AsmError("Must be able to solve filename during first parse", this.debug);
            }
            String string = value.getString(this.debug);
            return this.importSource(evaluationState, string);
        }
        return this;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        Value value = this.filenameExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmError("Must be able to solve filename during first parse", this.debug);
        }
        String string = value.getString(this.debug);
        AsmNode asmNode = null;
        if (this.type.equalsIgnoreCase("binary")) {
            asmNode = this.importBinary(evaluationState, string, false);
        } else if (this.type.equalsIgnoreCase("c64")) {
            asmNode = this.importBinary(evaluationState, string, true);
        } else if (this.type.equalsIgnoreCase("text")) {
            asmNode = this.importText(evaluationState, string);
        } else {
            throw new AsmError("Unknown import type '" + this.type + "'", this.debug);
        }
        return asmNode;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        throw NotImplementedException.intance;
    }

    private AsmNode importBinary(EvaluationState evaluationState, String string, boolean bl) {
        InputStream inputStream = evaluationState.openFile(string, this.debug);
        byte[] byArray = new byte[]{};
        try {
            int n;
            byte[] byArray2 = new byte[65536];
            if (bl) {
                inputStream.read(byArray2, 0, 2);
            }
            if ((n = inputStream.read(byArray2, 0, 65536)) < 0) {
                n = 0;
            }
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = byArray2[i];
            }
        }
        catch (Exception exception) {
            throw new AsmError("Can't read file: " + string, this.debug);
        }
        evaluationState.addSideEffect(new SEIncreaseMemoryPosition(byArray.length));
        return new ByteOutput(byArray, evaluationState.getFunctionSideOutput());
    }

    private AsmNode importSource(EvaluationState evaluationState, String string) {
        FunctionSideOutput functionSideOutput = evaluationState.getFunctionSideOutput();
        File file = evaluationState.getFile(string, this.debug);
        AsmNode asmNode = AssemblerToolbox.loadAndLex(file, evaluationState, this.debug);
        asmNode = new AddDebugToCallStackNode(this.debug, asmNode);
        File file2 = file.getParentFile();
        asmNode = new SetCurrentDirectoryNode(file2, asmNode);
        AsmNode asmNode2 = asmNode.registerMetaDefinitions(evaluationState);
        return functionSideOutput == null ? asmNode2 : new PreSideEffectsNode(functionSideOutput, asmNode2);
    }

    private AsmNode importText(EvaluationState evaluationState, String string) {
        InputStream inputStream = evaluationState.openFile(string, this.debug);
        byte[] byArray = new byte[]{};
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[65536];
            int n2 = inputStreamReader.read(cArray, 0, 65536);
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                if (CharToPetsciiConverter.convert(cArray[n]) == null) continue;
                ++n3;
            }
            byArray = new byte[n3];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                Byte by = CharToPetsciiConverter.convert(cArray[i]);
                if (by == null) continue;
                byArray[n++] = by;
            }
        }
        catch (Exception exception) {
            throw new AsmError("Can't read file: " + string, this.debug);
        }
        evaluationState.addSideEffect(new SEIncreaseMemoryPosition(byArray.length));
        return new ByteOutput(byArray, evaluationState.getFunctionSideOutput());
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("Import", this.debug, this.type, this.filenameExpr);
        return nodeTreeBuilder;
    }
}

