/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.StartOfMemoryBlockOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class MemoryBlockDirective
extends AsmDirective {
    private DebugInfo debug;
    private ExprNode startAddressExpr;
    private String virtualStr;
    private String name;
    boolean adressNotResolvedBefore = true;

    public MemoryBlockDirective(ExprNode exprNode, String string, String string2, DebugInfo debugInfo) {
        super(debugInfo);
        this.startAddressExpr = exprNode;
        this.virtualStr = string2;
        this.name = string == null ? "Unnamed" : string;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        boolean bl;
        if (evaluationState.getPseudoPcMode()) {
            throw new AsmError("You cant define a memoryblock inside the scope of a pseudopc directive", this.debug);
        }
        evaluationState.clearFunctionSideOutput();
        Value value = this.startAddressExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n = value.getInt(this.debug);
        if (this.virtualStr == null) {
            bl = false;
        } else if (this.virtualStr.equals("virtual")) {
            bl = true;
        } else {
            throw new AsmError("Invalid argument: " + this.virtualStr, this.debug);
        }
        evaluationState.setMemoryPosition(n);
        if (this.adressNotResolvedBefore) {
            evaluationState.setMadeMetaProgress();
            this.adressNotResolvedBefore = false;
        }
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new StartOfMemoryBlockOutput(n, this.name, bl, evaluationState.getFunctionSideOutput());
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("Memblock", this.debug);
        nodeTreeBuilder.addArg("name", this.name);
        nodeTreeBuilder.addArg("virtual", this.virtualStr);
        nodeTreeBuilder.addArg("startAddr", this.startAddressExpr);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

