/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.expressions.ExprNode;
import java.util.List;
import java.util.Stack;

public class ExprTreeBuilder {
    private StringBuilder sb = new StringBuilder();
    private Stack<Boolean> firstArgument = new Stack();

    public String toString() {
        return this.sb.toString();
    }

    public void addNode(String string, List<ExprNode> list) {
        this.enterExpr(string);
        for (ExprNode exprNode : list) {
            this.addSubExpr(exprNode);
        }
        this.exitExpr();
    }

    public void addNode(String string, String string2, List<ExprNode> list) {
        this.enterExpr(string);
        this.addArg(string2);
        for (ExprNode exprNode : list) {
            this.addSubExpr(exprNode);
        }
        this.exitExpr();
    }

    public void addNode(String string, ExprNode ... exprNodeArray) {
        this.enterExpr(string);
        this.addSubExpressions(exprNodeArray);
        this.exitExpr();
    }

    public void addNode(String string, String string2, ExprNode ... exprNodeArray) {
        this.enterExpr(string);
        this.addArg(string2);
        this.addSubExpressions(exprNodeArray);
        this.exitExpr();
    }

    public void addNode(String string, String string2, String string3, ExprNode ... exprNodeArray) {
        this.enterExpr(string);
        this.addArg(string2);
        this.addArg(string3);
        this.addSubExpressions(exprNodeArray);
        this.exitExpr();
    }

    public void enterExpr(String string) {
        this.sb.append("E" + string + "(");
        this.firstArgument.push(true);
    }

    public void exitExpr() {
        this.sb.append(")");
        this.firstArgument.pop();
    }

    public void addArg(String string) {
        if (this.firstArgument.peek().booleanValue()) {
            this.firstArgument.pop();
            this.firstArgument.push(false);
        } else {
            this.sb.append(",");
        }
        this.sb.append(string);
    }

    public void addSubExpr(ExprNode exprNode) {
        if (this.firstArgument.peek().booleanValue()) {
            this.firstArgument.pop();
            this.firstArgument.push(false);
        } else {
            this.sb.append(",");
        }
        exprNode.toNodeTreeString(this);
    }

    public void addSubExpressions(ExprNode ... exprNodeArray) {
        for (ExprNode exprNode : exprNodeArray) {
            if (exprNode == null) continue;
            this.addSubExpr(exprNode);
        }
    }
}

