/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;
import java.util.ArrayList;
import java.util.List;

public class ObjFunctionCall
extends ExprNode {
    private String functionName;
    private ExprNode[] objAndArgumentExprs;

    public ObjFunctionCall(String string, DebugInfo debugInfo, ExprNode exprNode, ExprNode ... exprNodeArray) {
        super(debugInfo);
        this.functionName = string;
        this.objAndArgumentExprs = new ExprNode[exprNodeArray.length + 1];
        this.objAndArgumentExprs[0] = exprNode;
        for (int i = 0; i < exprNodeArray.length; ++i) {
            this.objAndArgumentExprs[i + 1] = exprNodeArray[i];
        }
    }

    public ObjFunctionCall(String string, DebugInfo debugInfo, ExprNode exprNode, ArrayList<ExprNode> arrayList) {
        this(string, debugInfo, exprNode, ObjFunctionCall.toArray(arrayList));
    }

    private static ExprNode[] toArray(List<ExprNode> list) {
        int n = list.size();
        ExprNode[] exprNodeArray = new ExprNode[n];
        for (int i = 0; i < n; ++i) {
            exprNodeArray[i] = list.get(i);
        }
        return exprNodeArray;
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        Value value;
        boolean bl = false;
        Value[] valueArray = new Value[this.objAndArgumentExprs.length];
        Value value2 = null;
        for (int i = 0; i < this.objAndArgumentExprs.length; ++i) {
            value = this.objAndArgumentExprs[i].evaluate(evaluationState);
            if (i == 0) {
                value2 = value;
            }
            valueArray[i] = value.deReference();
            if (!value.isInvalid()) continue;
            bl = true;
        }
        Function function = value2.getFunctions().get(this.functionName, valueArray, this.debug);
        if (bl && !function.handlesInvalidArguments()) {
            return function.getInvalidResult(valueArray);
        }
        evaluationState.getCallStack().push(this.debug);
        value = function.execute(valueArray, evaluationState, this.debug);
        evaluationState.getCallStack().pop();
        return value;
    }

    public String toString() {
        return "obj." + this.functionName + "()";
    }

    @Override
    public ExprTreeBuilder toNodeTreeString(ExprTreeBuilder exprTreeBuilder) {
        exprTreeBuilder.addNode("ObjFuncCall", this.functionName, this.objAndArgumentExprs);
        return exprTreeBuilder;
    }
}

