/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.libraries;

import cml.kickass.constant.Constant;
import cml.kickass.exceptions.AsmError;
import cml.kickass.function.Function;
import cml.kickass.function.IntFunction;
import cml.kickass.function.VoidFunction;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.libraries.Library;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.AsmCommandArgumentValue;
import cml.kickass.values.HashtableValue;
import cml.kickass.values.ListValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.OutputFileValue;
import cml.kickass.values.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StdConstructorLibrary
implements Library {
    public List<Constant> getConstants() {
        ArrayList<Constant> arrayList = new ArrayList<Constant>();
        arrayList.add(new Constant("AT_ABSOLUTE", new NumberValue(7.0)));
        arrayList.add(new Constant("AT_ABSOLUTEX", new NumberValue(8.0)));
        arrayList.add(new Constant("AT_ABSOLUTEY", new NumberValue(9.0)));
        arrayList.add(new Constant("AT_IMMEDIATE", new NumberValue(1.0)));
        arrayList.add(new Constant("AT_INDIRECT", new NumberValue(10.0)));
        arrayList.add(new Constant("AT_IZEROPAGEX", new NumberValue(5.0)));
        arrayList.add(new Constant("AT_IZEROPAGEY", new NumberValue(6.0)));
        arrayList.add(new Constant("AT_NONE", new NumberValue(0.0)));
        return arrayList;
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new Function("createFile", 1, OutputFileValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                return new OutputFileValue(valueArray[0].getString(debugInfo), evaluationState);
            }
        });
        arrayList.add(new VoidFunction("List", (Value)ListValue.invalid){

            @Override
            protected Value f() {
                return new ListValue(0);
            }
        });
        arrayList.add(new IntFunction("List", (Value)ListValue.invalid){

            @Override
            protected Value f(int n) {
                return new ListValue(n);
            }
        });
        arrayList.add(new VoidFunction("Hashtable", null){

            @Override
            protected Value f() {
                return new HashtableValue();
            }
        });
        arrayList.add(new Function("CmdArgument", 2, null, true){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                Value value = valueArray[0];
                Value value2 = valueArray[1];
                if (value.isInvalid()) {
                    throw new AsmError("The type is an invalid value", debugInfo);
                }
                if (!value2.hasRepresentation(Value.RP_DOUBLEVALUE)) {
                    throw new AsmError("a " + value.getType() + "is not a valid value argument", debugInfo);
                }
                int n = value.getInt(debugInfo);
                return new AsmCommandArgumentValue(n, value2);
            }
        });
        return arrayList;
    }
}

