/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.misc;

import cml.kickass.exceptions.AsmError;
import cml.kickass.lexvalues.DebugInfo;

public class MemoryBlock {
    private String name;
    private int startAdress;
    private boolean virtual;
    private int currentAdress = 0;
    private byte[] memory;

    public MemoryBlock(int n, String string, boolean bl) {
        this.startAdress = n;
        this.name = string == null ? "unnamed" : string;
        this.virtual = bl;
        this.memory = bl ? null : new byte[65536];
    }

    public String getName() {
        return this.name;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void addByte(byte by, DebugInfo debugInfo) throws AsmError {
        if (this.startAdress + this.currentAdress > 65535) {
            throw new AsmError("ERROR! Memory overflow. Memory exceeds the $ffff limit!", debugInfo);
        }
        if (!this.virtual) {
            this.memory[this.startAdress + this.currentAdress] = by;
        }
        ++this.currentAdress;
    }

    public void addBytes(byte[] byArray, DebugInfo debugInfo) throws AsmError {
        for (int i = 0; i < byArray.length; ++i) {
            this.addByte(byArray[i], debugInfo);
        }
    }

    public int getStartAdress() {
        return this.startAdress;
    }

    public int getSize() {
        return this.currentAdress;
    }

    public byte[] getMemory() {
        byte[] byArray = new byte[this.currentAdress];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.memory[this.startAdress + i];
        }
        return byArray;
    }

    public boolean contentEquals(MemoryBlock memoryBlock) {
        boolean bl;
        boolean bl2 = bl = this.name.equals(memoryBlock.name) && this.startAdress == memoryBlock.startAdress && this.currentAdress == memoryBlock.currentAdress && this.virtual == memoryBlock.virtual;
        if (!bl) {
            return false;
        }
        byte[] byArray = this.getMemory();
        byte[] byArray2 = memoryBlock.getMemory();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

