/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.Value;

public class NullValue
extends ImmutableValue {
    public static final NullValue instance = new NullValue();
    static FunctionTable functions = new StdFunctionTable(NullValue.getStandardFunctions());

    private NullValue() {
    }

    @Override
    public String getType() {
        return "Null";
    }

    @Override
    public Object getRepresentation(int n) {
        if (n == Value.RP_STRINGVALUE) {
            return "Null";
        }
        return null;
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    static {
        functions.add(new Function("==", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                return BooleanValue.get(valueArray[0] == valueArray[1]);
            }
        });
        functions.add(new Function("!=", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                return BooleanValue.get(valueArray[0] != valueArray[1]);
            }
        });
    }
}

