/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.asmnode.output.reciever.OutputStreamType;
import cml.kickass.exceptions.AsmError;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.StringValue;
import cml.kickass.values.Value;

public class OutputFileValue
extends ImmutableValue {
    private static String newline = System.getProperty("line.separator");
    public static OutputFileValue invalid = new OutputFileValue();
    private String filename;
    static FunctionTable functions = new StdFunctionTable(OutputFileValue.getStandardFunctions());

    private OutputFileValue() {
        this.setInvalid();
    }

    public OutputFileValue(String string, EvaluationState evaluationState) {
        this.filename = string;
        evaluationState.addStreamOutput(OutputStreamType.FILE, string, "");
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public Object getRepresentation(int n) {
        return null;
    }

    @Override
    public String getType() {
        return "OutputFile";
    }

    static {
        functions.add(new Function("writeln", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                Value value;
                if (valueArray.length > 2) {
                    throw new AsmError("Cannot use more than 1 argument", debugInfo);
                }
                OutputFileValue outputFileValue = (OutputFileValue)valueArray[0];
                Value value2 = value = valueArray.length == 1 ? StringValue.emptyString : valueArray[1];
                if (outputFileValue.isInvalid() || value.isInvalid()) {
                    evaluationState.setErrrorDuringFunctionEvaluation(true);
                    return NullValue.instance;
                }
                evaluationState.addStreamOutput(OutputStreamType.FILE, outputFileValue.filename, value.getString(debugInfo) + newline);
                return NullValue.instance;
            }
        });
    }
}

