/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmException;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.values.InvalidValue;
import cml.kickass.values.LockableValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.Value;
import cml.kickass.values.VariableReferenceValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructValue
extends LockableValue {
    public static StructValue invalid = new StructValue();
    private String structName;
    private Map<String, Value> variables = new HashMap<String, Value>();
    static FunctionTable functions = new StdFunctionTable(StructValue.getStandardFunctions());
    private boolean checkingInvalidContent = false;

    private StructValue() {
        this.setInvalid();
        this.structName = "Invalid";
    }

    public StructValue(String string, List<String> list, Value[] valueArray) {
        this.structName = string;
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            NullValue nullValue = valueArray == null ? NullValue.instance : valueArray[i];
            VariableReferenceValue variableReferenceValue = new VariableReferenceValue(nullValue);
            this.variables.put(string2, variableReferenceValue);
        }
    }

    @Override
    public boolean hasInvalidContent() {
        if (this.checkingInvalidContent) {
            return false;
        }
        this.checkingInvalidContent = true;
        boolean bl = false;
        for (Value value : this.variables.values()) {
            if (!value.isInvalidOrInvalidContent()) continue;
            bl = true;
            break;
        }
        this.checkingInvalidContent = false;
        return bl;
    }

    @Override
    public String getType() {
        return "struct";
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        if (n == RP_STRINGVALUE) {
            if (this.isInvalid()) {
                return "<<Invalid Struct>>";
            }
            return this.structName + "-struct";
        }
        return null;
    }

    @Override
    public Value localGetVariable(String string, DebugInfo debugInfo) throws AsmException {
        if (this.isInvalid()) {
            return InvalidValue.instance;
        }
        return this.variables.get(string);
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(DebugInfo debugInfo) {
        if (this.isLocked) {
            return;
        }
        this.isLocked = true;
        for (Value value : this.variables.values()) {
            value.lock(debugInfo);
        }
    }
}

