/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.Argument;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Lockable;
import cml.kickass.values.NumberValue;
import cml.kickass.values.StringValue;
import java.util.ArrayList;

public abstract class Value
implements Lockable {
    private boolean isInvalid = false;
    public static int RP_DOUBLEVALUE = 1;
    public static int RP_STRINGVALUE = 2;
    public static int RP_BOOLEANVALUE = 3;
    public static int RP_MATRIXVALUE = 4;
    public static int RP_VECTORVALUE = 5;
    public static int RP_LISTVALUE = 6;
    public static int RP_ASMARGVALUE = 7;
    private static StdFunctionTable functions = null;

    public abstract String getType();

    public abstract Object getRepresentation(int var1);

    public boolean hasRepresentation(int n) {
        return this.getRepresentation(n) != null;
    }

    public abstract FunctionTable getFunctions();

    protected Value localGetVariable(String string, DebugInfo debugInfo) {
        return null;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public boolean hasInvalidContent() {
        return false;
    }

    public boolean isInvalidOrInvalidContent() {
        return this.isInvalid() || this.hasInvalidContent();
    }

    protected void setInvalid() {
        this.isInvalid = true;
    }

    public Value deReference() {
        return this;
    }

    private static StdFunctionTable createStdFunctions() {
        StdFunctionTable stdFunctionTable = new StdFunctionTable();
        stdFunctionTable.add(new Function("lock", 1, null, true){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                valueArray[0].lock(debugInfo);
                return valueArray[0];
            }
        });
        stdFunctionTable.add(new Function("number", 1, NumberValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                Double d = (Double)valueArray[0].getRepresentation(RP_DOUBLEVALUE);
                if (d == null) {
                    throw new AsmError("A value of type '" + valueArray[0].getType() + "' doesn't have a number representation", debugInfo);
                }
                return new NumberValue(d);
            }
        });
        stdFunctionTable.add(new Function("string", 1, NumberValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                String string = (String)valueArray[0].getRepresentation(RP_STRINGVALUE);
                if (string == null) {
                    throw new AsmError("A value of type '" + valueArray[0].getType() + "' doesn't have a string representation", debugInfo);
                }
                return new StringValue(string);
            }
        });
        return stdFunctionTable;
    }

    protected static StdFunctionTable getStandardFunctions() {
        if (functions == null) {
            functions = Value.createStdFunctions();
        }
        return functions;
    }

    public Argument getCmdArgument(DebugInfo debugInfo) {
        Argument argument = (Argument)this.getRepresentation(RP_ASMARGVALUE);
        if (argument == null) {
            throw new AsmError("Can't get a command argument from a value of type " + this.getType(), debugInfo);
        }
        return argument;
    }

    public String getString(DebugInfo debugInfo) {
        String string = (String)this.getRepresentation(RP_STRINGVALUE);
        if (string == null) {
            throw new AsmError("Can't get a string representation from a value of type " + this.getType(), debugInfo);
        }
        return string;
    }

    public boolean getBoolean(DebugInfo debugInfo) {
        Boolean bl = (Boolean)this.getRepresentation(RP_BOOLEANVALUE);
        if (bl == null) {
            throw new AsmError("Can't get a boolean representation from a value of type " + this.getType(), debugInfo);
        }
        return bl;
    }

    public double getDouble(DebugInfo debugInfo) {
        Double d = (Double)this.getRepresentation(RP_DOUBLEVALUE);
        if (d == null) {
            throw new AsmError("Can't get a numeric representation from a value of type " + this.getType(), debugInfo);
        }
        return d;
    }

    public int getInt(DebugInfo debugInfo) {
        Double d = (Double)this.getRepresentation(RP_DOUBLEVALUE);
        if (d == null) {
            throw new AsmError("Can't get a numeric representation from a value of type " + this.getType(), debugInfo);
        }
        return d.intValue();
    }

    public long getLong(DebugInfo debugInfo) {
        Double d = (Double)this.getRepresentation(RP_DOUBLEVALUE);
        if (d == null) {
            throw new AsmError("Can't get a numeric representation from a value of type " + this.getType(), debugInfo);
        }
        return d.longValue();
    }

    public double[] getVector(DebugInfo debugInfo) {
        double[] dArray = (double[])this.getRepresentation(RP_VECTORVALUE);
        if (dArray == null) {
            throw new AsmError("Can't get a vector representation from a value of type " + this.getType(), debugInfo);
        }
        return dArray;
    }

    public ArrayList<Value> getList(DebugInfo debugInfo) {
        ArrayList arrayList = (ArrayList)this.getRepresentation(RP_LISTVALUE);
        if (arrayList == null) {
            throw new AsmError("Can't get a list representation from a value of type " + this.getType(), debugInfo);
        }
        return arrayList;
    }

    public Value getVariable(String string, DebugInfo debugInfo) {
        Value value = this.localGetVariable(string, debugInfo);
        if (value == null) {
            throw new AsmError("Variable '" + string + "' not present on value of type '" + this.getType() + "'", debugInfo);
        }
        return value;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String getNodeTreeString() {
        String string = this.toString();
        if (this.hasInvalidContent()) {
            string = "(%)" + string;
        }
        if (this.isInvalid()) {
            string = "%" + string;
        }
        if (this.isLocked()) {
            string = "!" + string;
        }
        return string;
    }
}

