;========================
; Bucket level game loop
;========================

loop_bucket_top
                jsr set_butt_sprites

                ; Different butt behavior depending on phase
                lda game_phase
                beq loobu2
                jmp loobu3
loobu2          ; Game phase 0, normal play
                lda butt_y
                cmp #50
                beq loobu6
                inc butt_y
                jmp loobu4
loobu6          ; Butt normal motion
                ldx random_pos
                inx
                lda random_table,x
                and #15
                bne loobu10
                ; Change butt direction
loobu11         inx
                lda random_table,x
                cmp #159
                bcs loobu11
                clc
                adc #24
                and #254
                sta butt_target
loobu10         stx random_pos
                ldx butt_x
                cpx butt_target
                beq loobu13
                bcc loobu12
                dex
                dex
                jmp loobu13
loobu12         inx
                inx
loobu13         stx butt_x

                lda #0 ; Clear sound effect flag
                sta snd_effect_flag

                ; Time to release new shit?
                lda shit_num
                cmp max_shit
                beq loobu14 ; Already max on screen?
                lda shit_count
                cmp shit_goal
                beq loobu14 ; Already spawned max?
                lda shit_timer
                cmp shit_interval
                beq loobu17
                inc shit_timer
                jmp loobu14
loobu17         ldx #0 ; Find empty position
loobu16         lda shit_mode,x
                beq loobu15
                inx
                jmp loobu16
loobu15         lda #1 ; Falling mode
                sta shit_mode,x
                lda butt_x
                clc
                adc #36
                sta shit_x,x
                lda #68
                sta shit_y,x
                lda #78
                sta shit_look,x
                lda #0 ; Reset timer
                sta shit_timer
                inc shit_count
                inc shit_num
                lda #4
                jsr start_sound

loobu14         ; Go through shit list
                ldx #0
                ldy #0
loobu20         lda shit_mode,x
                beq loobu18 ; Is it active?
                cmp #1
                bne loobu19
                inc shit_y,x ; Falling
                lda shit_y,x
                cmp #240 ; Land on floor?
                bne loobu21
                jmp shit_landed_on_floor

loobu21         cmp #190 ; Check if landed in bucket
                bcc loobu18
                cmp #206
                bcs loobu18
                lda manx+1
                clc
                adc #32
                sec 
                sbc shit_x,x
                bcc loobu18
                cmp #30
                bcs loobu18
                lda bucket_drawn
                cmp #20
                bcs loobu18
                ; Hit bucket
                jmp shit_hit_bucket

loobu19         cmp #2 ; Bucket splat
                bne loobu18
                lda irq_counter
                and #1
                bne loobu18
                inc shit_look,x
                lda shit_look,x
                cmp #78
                bne loobu18
                ; Remove shit
                lda #0
                sta shit_y,x
                sta shit_mode,x
                dec shit_num
                inc shit_caught

                lda #5
                sta score_delta

loobu18         ; Put on screen
                lda shit_look,x
                sta 24568,x
                lda #9 ; Color
                sta 53287,x
                lda shit_x,x
                sta 53248,y
                lda shit_y,x
                sta 53249,y
                inx
                iny
                iny
                cpx #4
                beq loobu22
                jmp loobu20
loobu22
                ; Check if we should start a sound effect
                lda snd_effect_flag
                beq loobu42
                jsr start_sound
loobu42
                ; Handle player
                lda joystick
                and #4
                bne loobu7
                ; Go left
                lda man_pos
                beq loobu9
                dec man_pos
                lda man_pos
                cmp #94
                bne loobu44
                lda #6 ; Stop bucket sound
                jsr stop_sound
                jmp loobu8
loobu44         and #3
                bne loobu9
                lda #2 ; Step sound
                jsr start_sound
loobu9          jmp loobu8
loobu7          lda joystick
                and #8
                bne loobu8
                ; Go right
                lda man_pos
                cmp #95
                beq loobu8
                inc man_pos
                lda man_pos
                cmp #95 ; Start bucket sound
                bne loobu43
                lda #6
                jsr start_sound
                jmp loobu8
loobu43         cmp #89
                bcs loobu8
                and #3
                bne loobu8
                lda #2
                jsr start_sound

loobu8          ; Check if level complete
                lda shit_caught
                cmp shit_goal
                bne loobu35
                jsr bucket_wave_completed

loobu35         jsr animate_man_normal
                jmp loobu4

loobu3          cmp #1
                bne loobu5
                ; Game phase 1, shit on floor
                lda tooly+1
                and #128
                beq loobu41
                inc bucket_speed ; Let bucket fall and accelerate
                lda bucket_speed
                and #248
                lsr 
                lsr 
                lsr
                clc
                adc tooly+1
                sta tooly+1
loobu41         lda irq_counter
                and #31
                cmp #30
                bne loobu45
                ; Play beep sound
                lda #8
                jsr start_sound
                jmp loobu46
loobu45         cmp #16
                bne loobu46
                ; Stop beep sound
                lda #8
                jsr stop_sound
loobu46         lda irq_counter
                bne loobu39
                ; Done waiting
                lda fail 
                cmp #3
                bne loobu40
                ; Game over
                jsr game_over
                jmp irq_end
loobu40         ; Clean up and continue
                jsr reset_shit_variables
                lda #0
                sta game_phase

                lda man_pos ; Adjust man position
                cmp #89
                bcc loobu39
                lda #88
                sta man_pos
loobu39         
                jmp loobu4
loobu5          ; Game phase 2, level complete
                ; Move butt up
                lda butt_y
                beq loobu38
                dec butt_y
loobu38         lda irq_counter
                bne loobu37
                ; Counter reached zero
                ; Move on to next level
                jsr level_completed
                jsr prepare_level
                jmp loobu36
loobu37         and #3
                cmp #1
                bne loobu36
                sta score_delta
loobu36         lda irq_counter
                and #7
                bne loobu4
                lda #5 ; Play bing
                jsr start_sound


loobu4          ; Animate bucket fill
                lda man_pos
                cmp #95
                bne loobu33
                lda bucket_drawn
                beq loobu33
                dec bucket_drawn
loobu33         lda bucket_level
                cmp bucket_drawn
                bcc loobu32
                bne loobu31
                lda #6
                jsr stop_sound
                jmp loobu30 ; No change
loobu32         ; Needs to fill up
                tay 
                clc
                asl
                asl
                adc bucket_level
                tax
                lda fill_pos_low,y
                sta 251
                lda fill_pos_high,y
                sta 252
                ldy #0
                lda bucket_full,x
                sta (251),y
                inx
                ldy #8
                lda bucket_full,x
                sta (251),y
                inx
                ldy #16
                lda bucket_full,x
                sta (251),y
                inx
                ldy #24
                lda bucket_full,x
                sta (251),y
                inx
                ldy #32
                lda bucket_full,x
                sta (251),y
                inc bucket_level
                jmp loobu30
loobu31         ; Needs to empty
                dec bucket_level
                lda bucket_level
                tay
                clc
                asl
                asl
                adc bucket_level
                tax
                lda fill_pos_low,y
                sta 251
                lda fill_pos_high,y
                sta 252
                ldy #0
                lda bucket_empty,x
                sta (251),y
                inx
                ldy #8
                lda bucket_empty,x
                sta (251),y
                inx
                ldy #16
                lda bucket_empty,x
                sta (251),y
                inx
                ldy #24
                lda bucket_empty,x
                sta (251),y
                inx
                ldy #32
                lda bucket_empty,x
                sta (251),y
loobu30

                lda score_delta
                beq loobu34
                jsr update_score
                lda #0
                sta score_delta
loobu34

                jmp irq_prepare_drawman


;========================
; Fart level game loop
;========================
loop_fart_top
                jsr set_butt_sprites

                ; Different butt behavior depending on phase
                lda game_phase
                beq loofa2
                jmp loofa3
loofa2          ; Game phase 0, normal play
                lda butt_y
                cmp #50
                beq loofa6
                inc butt_y
                jmp loofa4
loofa6          ; Butt normal motion
                ldx random_pos
                inx
                lda random_table,x
                and #15
                bne loofa10
                ; Change butt direction
loofa11         inx
                lda random_table,x
                cmp #159
                bcs loofa11
                clc
                adc #24
                and #254
                sta butt_target
loofa10         stx random_pos
                ldx butt_x
                cpx butt_target
                beq loofa13
                bcc loofa12
                dex
                dex
                jmp loofa13
loofa12         inx
                inx
loofa13         stx butt_x

loofa4          jsr control_player

loofa14         jsr animate_man_normal

                ; Farts
                ; Time to release new fart?
                lda shit_num
                cmp max_shit
                beq loofa30 ; Already max on screen?
                lda shit_timer
                cmp shit_interval
                beq loofa31
                inc shit_timer
                jmp loofa30
loofa31         ldx #0 ; Find empty position
loofa32         lda shit_mode,x
                beq loofa33
                inx
                jmp loofa32
loofa33         lda #1 ; Falling mode
                sta shit_mode,x
                lda butt_x
                clc
                adc #36
                sta shit_x,x
                lda #60
                sta shit_y,x
                lda #83
                sta shit_look,x
                lda #0 ; Reset timer
                sta shit_timer
                inc shit_num
                lda #11
                jsr start_sound
loofa30 
                ; Go through fart list
                ldx #0
                ldy #0
loofa60         lda shit_mode,x
                beq loofa61 ; Is it active?               
                lda shit_y,x ; Falling
                clc
                adc shit_speed,x
                sta shit_y,x

                lda irq_counter
                and #3
                bne loofa63
                lda shit_look,x
                cmp #86
                bcs loofa64
                inc shit_look,x
loofa64
                lda shit_x,x ; Track man
                cmp manx+1
                bcs loofa65 
                inc shit_x,x
                jmp loofa66
loofa65         adc #2
                cmp manx+1
                bcc loofa66
                dec shit_x,x
loofa66
                lda shit_y,x
                cmp #180 ; Maximum reach?
                bcc loofa63
                inc shit_look,x
                lda shit_look,x
                cmp #90
                bne loofa63
                lda #0 ; Remove fart
                sta shit_mode,x
                sta shit_y,x
                dec shit_num

loofa63         ; Check if man hit
                lda shit_y,x
                cmp #177
                bcc loofa61
                lda shit_x,x
                adc #16
                cmp manx+1
                bcc loofa61
                sbc #40
                cmp manx+1
                bcs loofa61
                jmp fart_hit_man

loofa61         ; Put on screen
                lda shit_look,x
                sta 24569,x
                lda #5 ; Color
                sta 53288,x
                lda shit_x,x
                sta 53250,y
                lda shit_y,x
                sta 53251,y
                inx
                iny
                iny
                cpx #3
                beq loofa62
                jmp loofa60
loofa62


                lda bullet_mode
                beq loofa20
                cmp #1
                bne loofa21
                ; Moving up
                lda bullet_y
                sec
                sbc #4
                sta bullet_y

                cmp #32
                bcs loofa23 
                lda #0 ; Remove bullet
                sta bullet_mode
                jmp loofa20
                ; Check butt collision
loofa23         cmp #58
                bcs loofa22
                lda bullet_x
                adc #10
                cmp butt_x
                bcc loofa22
                sbc #88
                cmp butt_x
                bcs loofa22
                inc bullet_mode
                lda #83
                sta bullet_look
                lda #7
                sta 53287
                lda #5
                sta score_delta
                lda #10
                jsr start_sound
                jsr update_butthurt

loofa22         jmp loofa20
loofa21         cmp #2
                bne loofa20
                ; Exploding bullet
                inc bullet_look
                lda bullet_look
                cmp #90
                bne loofa20
                lda #0
                sta bullet_mode
                sta bullet_y
                lda butthurt 
                cmp #20
                bne loofa20
                ; Level cleared
                jsr fart_wave_completed
                jmp loofa5

loofa20         lda bullet_x
                sta 53248
                lda bullet_y
                sta 53249
                lda bullet_look
                sta 24568
                jmp loofa5
loofa3          cmp #1
                bne loofa15
                ; Game phase 1, hit by fart
                lda tooly+1
                and #128
                beq loofa71
                inc bucket_speed ; Let bucket fall and accelerate
                lda bucket_speed
                and #248
                lsr 
                lsr 
                lsr
                clc
                adc tooly+1
                sta tooly+1
loofa71         lda irq_counter
                and #31
                cmp #30
                bne loofa72
                ; Play beep sound
                lda #8
                jsr start_sound
                jmp loofa73
loofa72         cmp #16
                bne loofa73
                ; Stop beep sound
                lda #8
                jsr stop_sound
loofa73         lda irq_counter
                bne loofa74
                ; Done waiting
                lda fail 
                cmp #3
                bne loofa75
                ; Game over
                jsr game_over
                jmp irq_end
loofa75         ; Clean up and continue
                jsr reset_shit_variables
                lda #0
                sta game_phase

loofa74
                jmp loofa5
loofa15         ; Game phase 2, level complete
                ; Blink butt
                ldx #50
                lda irq_counter
                cmp #50
                bcc loofa57
                and #1
                beq loofa50
loofa57         ldx #0
loofa50         stx butt_y
                lda irq_counter
                bne loofa51
                ; Counter reached zero
                ; Move on to next level
                jsr level_completed
                jsr prepare_level
                jmp loofa5
loofa51         and #3
                cmp #1
                bne loofa52
                sta score_delta
loofa52         lda irq_counter
                and #7
                bne loofa53
                lda #5 ; Play bing
                jsr start_sound
loofa53         ; Explosions
                lda irq_counter
                cmp #50 ; No new explosions
                bcc loofa56
                inc random_pos
                ldx random_pos
                lda random_table,x
                and #3
                tax
                lda shit_mode,x
                bne loofa56
                ; New explosion
                lda #1
                sta shit_mode,x
                lda irq_counter
                and #7
                asl
                adc #43
                sta shit_y,x
                lda #83
                sta shit_look,x
                inc random_pos
                ldy random_pos
                lda random_table,y
                and #63
                adc #6
                adc butt_x
                sta shit_x,x
loofa56
                ldx #0
                ldy #0
loofa55         lda shit_mode,x
                cmp #1
                bne loofa54
                inc shit_look,x
                lda shit_look,x
                cmp #90
                bne loofa54
                lda #0
                sta shit_mode,x
                sta shit_y,x
loofa54         lda shit_look,x
                sta 24568,x
                lda #7 ; Color
                sta 53287,x
                lda shit_x,x
                sta 53248,y
                lda shit_y,x
                sta 53249,y
                inx
                iny
                iny
                cpx #4 
                bne loofa55
loofa5

                lda score_delta
                beq loofa34
                jsr update_score
                lda #0
                sta score_delta
loofa34

                jmp irq_prepare_drawman


;==========================
; Fan level main game loop
;==========================

loop_fan_top    lda #0
                sta snd_effect_flag
                lda game_phase
                beq loofn1
                jmp loofn2
loofn1          ; Game phase 0, normal play

                lda irq_counter ; Fan
                and #3
                bne loofn6
                inc fan_look ; Rotate blades
                lda fan_look
                cmp #9
                bne loofn7
                lda #6
                sta fan_look
loofn7          ; Update speed
                lda fan_raw_x
                cmp fan_target_x
                bcs loofn8
                ; Less
                lda fan_dx
                cmp #4
                beq loofn9
                inc fan_dx
                jmp loofn9
loofn8          ; Greater
                lda fan_dx
                cmp #252
                beq loofn9
                dec fan_dx
loofn9          lda fan_raw_y
                cmp fan_target_y
                bcs loofn10
                ; Less
                lda fan_dy
                cmp #4
                beq loofn11
                inc fan_dy
                jmp loofn11
loofn10          ; Greater
                lda fan_dy
                cmp #252
                beq loofn11
                dec fan_dy
loofn11
                lda irq_counter
                and #127
                bne loofn6
                ; Update targets
                ldx random_pos
                inx
                lda random_table,x
                and #127
                adc #64
                sta fan_target_x
                inx
                lda random_table,x
                and #127
                adc #64
                sta fan_target_y
                stx random_pos

loofn6          lda fan_raw_x
                clc
                adc fan_dx
                sta fan_raw_x
                lsr
                lsr
                adc #96
                sta fan_x
                sta 53250
                sta 53252
                lda fan_raw_y
                clc
                adc fan_dy
                sta fan_raw_y
                lsr
                lsr
                adc #80
                sta fan_y
                sta 53251
                clc
                adc #21
                sta 53253
                lda #12
                sta 53288
                sta 53289
                lda fan_look
                sta 24569
                lda #9
                sta 24570


                jsr control_player
                jsr animate_man_normal

                lda bullet_mode ; Handle bullet
                beq loofn20
                ; Moving up
                lda bullet_y
                sec
                sbc #4
                sta bullet_y
                cmp #32
                bcs loofn20 
                lda #0 ; Remove bullet
                sta bullet_mode
loofn20
                lda bullet_x
                sta 53248
                lda bullet_y
                sta 53249
                lda bullet_look
                sta 24568


                ; Time to release new shit?
                lda shit_num
                cmp max_shit
                beq loofn30 ; Already max on screen?
                lda shit_timer
                cmp shit_interval
                beq loofn31
                inc shit_timer
                jmp loofn30
loofn31         ldx #0 ; Find empty position
loofn32         lda shit_mode,x
                beq loofn33
                inx
                jmp loofn32
loofn33         lda #1 ; Flying mode
                sta shit_mode,x
                lda #91
                sta shit_look,x
                lda #63
                sta shit_y,x
                lda #9
                sta shit_color,x
                inc random_pos
                ldy random_pos
                lda random_table,y
                and #1
                beq loofn34
                ; From the left
                lda #136
                sta shit_x_low,x
                lda #0
                sta shit_x_high,x
                lda #34
                sta shit_x,x
                lda #4
                sta shit_speed,x
                jmp loofn36
loofn34         ; From the right
                lda #216
                sta shit_x_low,x
                lda #3
                sta shit_x_high,x
                lda #246
                sta shit_x,x
                lda #252
                sta shit_speed,x
loofn36         lda #0 ; Reset timer
                sta shit_timer
                inc shit_num
                lda #4
                jsr start_sound
loofn30

                ; Handle shit
                ldx #0
                ldy #0
loofn35         lda shit_mode,x
                cmp #1
                beq loofn45
                jmp loofn37
loofn45         ; Flying
                lda irq_counter
                and #3
                bne loofn39
                ; Update look
                inc shit_look,x
                lda shit_look,x
                cmp #96
                bne loofn43
                lda #94
                sta shit_look,x
                ; Update speeds
loofn43         lda shit_x,x
                cmp #50
                bcs loofn40
                lda shit_speed,x
maxspeed_right  cmp #4
                beq loofn39
                inc shit_speed,x
                inc shit_y,x
                jmp loofn39
loofn40         cmp #228
                bcc loofn39
                lda shit_speed,x
maxspeed_left   cmp #252
                beq loofn39
                dec shit_speed,x
                inc shit_y,x
loofn39         ; Check for bullet collision
                lda shit_y,x
                adc #10
                cmp bullet_y
                bcc loofn44
                sbc #30
                cmp bullet_y
                bcs loofn44
                lda shit_x,x
                adc #10
                cmp bullet_x
                bcc loofn44
                sbc #30
                cmp bullet_x
                bcs loofn44
                lda #7 ; Explode shit
                sta shit_color,x
                lda #2
                sta shit_mode,x
                lda #84
                sta shit_look,x
                lda #0
                sta bullet_y
                sta bullet_mode
                lda #10
                sta snd_effect_flag

loofn44         ; Check for fan collision
                lda shit_y,x
                adc #15
                cmp 53251
                bcc loofn59
                sbc #40
                cmp 53251
                bcs loofn59
                lda shit_x,x
                adc #20
                cmp 53250
                bcc loofn59
                sbc #40
                cmp 53250
                bcs loofn59
                ; Hit fan
                lda shit_x,x
                sta splat_x
                lda shit_y,x
                sta splat_y
                jmp shit_hit_fan
loofn59
                ; Move
                lda shit_speed,x
                bmi loofn41
                clc
                adc shit_x_low,x
                sta shit_x_low,x
                lda shit_x_high,x
                adc #0
                sta shit_x_high,x
                jmp loofn38
loofn41         clc
                adc shit_x_low,x
                sta shit_x_low,x
                lda shit_x_high,x
                sbc #0
                sta shit_x_high,x
                jmp loofn38
loofn37         cmp #2
                bne loofn38
                ; Exploding
                lda irq_counter
                and #3
                bne loofn38
                inc shit_look,x
                lda shit_look,x
                cmp #90
                bne loofn38
                lda #0 ; Remove shit and update counter
                sta shit_mode,x
                sta shit_y,x
                dec shit_num
                lda #5
                sta score_delta

loofn38         lda shit_x_high,x
                sta 252
                lda shit_x_low,x
                clc
                lsr 252
                ror
                lsr 252
                ror
                sta 53254,y
                sta shit_x,x
                lda shit_y,x
                sta 53255,y
                lda shit_look,x
                sta 24571,x
                lda shit_color,x
                sta 53290,x
                inx
                iny
                iny
                cpx #5
                beq loofn42
                jmp loofn35
loofn42
                jmp loofn5
loofn2          cmp #1
                beq loofn3
                jmp loofn4
loofn3          ; Fan hit
                ; Place splat sprites
                ldx #0
                ldy #0
loofn58         lda splat_y,x
                sta 53249,y
                lda #9
                sta 53287,x
                lda splat_x,x
                sta 53248,y
                and #1 ; Random look
                ora #96
                sta 24568,x
                inx
                iny
                iny
                cpx #8
                bne loofn58

                lda tooly+1
                and #128
                beq loofn60
                inc bucket_speed ; Let gun fall and accelerate
                lda bucket_speed
                and #248
                lsr 
                lsr 
                lsr
                clc
                adc tooly+1
                sta tooly+1
loofn60         lda irq_counter
                and #31
                cmp #30
                bne loofn61
                ; Play beep sound
                lda #8
                jsr start_sound
                jmp loofn62
loofn61         cmp #16
                bne loofn62
                ; Stop beep sound
                lda #8
                jsr stop_sound
loofn62         lda irq_counter
                bne loofn63
                ; Done waiting
                lda fail 
                cmp #3
                bne loofn64 
                ; Game over
                jsr game_over
                jmp irq_end
loofn64         ; Clean up and continue
                jsr reset_shit_variables
                lda #0
                sta game_phase

loofn63         jmp loofn5
loofn4          ; Wave completed
                ; Explode remaining items
                lda irq_counter
                cmp #96
                bcc loofn53
                lda #120
                sbc irq_counter
                lsr
                lsr
                clc
                adc #83
                sta shit_look
                ldx #0
                ldy #0
loofn54         lda shit_x,x
                sta 53254,y
                lda shit_y,x
                sta 53255,y
                lda #7
                sta 53290,x
                lda shit_look
                sta 24571,x
                inx
                iny
                iny
                cpx #5
                bne loofn54
                lda #7
                sta 53288
                sta 53289
                lda shit_look
                sta 24569
                sta 24570
                jmp loofn52
loofn53         lda #0 ; Move all sprites off screen
                ldy #0
loofn55         sta 53249,y
                iny
                iny
                cpy #16
                bne loofn55
loofn52         ; Score and sound effects
                lda irq_counter
                and #3
                cmp #1
                bne loofn56
                sta score_delta
loofn56         lda irq_counter
                and #7
                bne loofn57
                lda #5 ; Play bing
                jsr start_sound
                ; Check if timer reached zero
loofn57         lda irq_counter
                bne loofn5
                jsr level_completed
                jsr remove_stereo_butts
                jsr prepare_level
                jmp loofn51

loofn5          lda snd_effect_flag
                beq loofn50
                jsr start_sound
                lda #0
                sta snd_effect_flag
loofn50
                lda score_delta
                beq loofn51
                jsr update_score
                lda #0
                sta score_delta
                lda game_phase
                bne loofn51
                jsr update_butthurt
                lda butthurt
                cmp #20
                bne loofn51
                ; Wave cleared
                jsr fan_wave_completed
loofn51

                jmp irq_prepare_drawman


;==========================
; Bucket diarrhea game loop
;==========================

loop_diarrhea_top
                lda #0
                sta score_delta
                lda diarrhea_length
                cmp #23
                beq loodia1
                ; Draw diarrhea stream
                lda diarrhea_pix
                sta 251
                lda diarrhea_pix+1
                sta 252
                lda #154
                ldy #0
loodia2         sta (251),y
                iny
                cpy #8
                bne loodia2
                lda 251
                clc
                adc #64
                sta diarrhea_pix
                lda 252
                adc #1
                sta diarrhea_pix+1
                lda diarrhea_col
                sta 251
                lda diarrhea_col+1
                sta 252
                lda #137
                ldy #0
                sta (251),y
                lda 251
                clc
                adc #40
                sta diarrhea_col
                lda 252
                adc #0
                sta diarrhea_col+1
                inc diarrhea_length
                lda diarrhea_length
                cmp #23
                bne loodia17
                ; Start diarrhea flooding
                lda #250
                sta diarrhea_y
                lda #64
                sta diarrhea_pix
                lda #127
                sta diarrhea_pix+1
                lda diarrhea_delay
                sta diarrhea_timer
loodia17        jmp loodia8
loodia1         ; Diarrhea flooding
                lda game_phase
                bne loodia14
                dec diarrhea_timer
                lda diarrhea_timer
                bne loodia14
                ; Raise diarrhea level
                dec diarrhea_y
                lda diarrhea_delay
                sta diarrhea_timer
                lda diarrhea_pix+1
                sta 252
                lda diarrhea_pix
                sta 251
                and #7
                bne loodia15
                lda 251
                sec
                sbc #57
                sta 251
                lda 252
                sbc #1
                sta 252
                jmp loodia18
loodia15        dec 251
loodia18        lda 251
                sta diarrhea_pix
                lda 252
                sta diarrhea_pix+1
                ldy #0
                ldx #0
loodia16        lda #0
                sta (251),y
                lda 251
                clc
                adc #8
                sta 251
                lda 252
                adc #0
                sta 252
                inx
                cpx #40
                bne loodia16
                lda diarrhea_y
                cmp #191 ; Reached drowning height
                bne loodia14
                jmp man_drowned
loodia14        ; Play diarrhea splash sound effect
                lda game_phase
                bne loodia19
                ;inc random_pos
                ;ldx random_pos
                ;lda random_table,x
                lda irq_counter
                and #15
                bne loodia19
                lda #14
                jsr start_sound

loodia19        ; Set diarrhea splash sprite values
                lda diarrhea_y
                sec
                sbc #21
                sta splash_y+1
                lda irq_counter
                and #3
                bne loodia13
                inc diarrhea_look
loodia13        lda diarrhea_look
                cmp #101
                bne loodia9
                lda #98
loodia9         sta diarrhea_look
                sta splash_frame+1
loodia8         

                lda game_phase
                beq loodia3
                jmp loodia4
loodia3         ; Normal phase

                ; Modify walking sound
                ldy #80
                lda diarrhea_y
                cmp #248
                bcs loodia20
                ldy #0
                cmp #240
                bcc loodia20
                and #7
                asl
                asl
                asl
                tay
loodia20        sty sound2+1

                ; Handle player
                jsr control_player

                jsr animate_man_diarrhea

                ; Handle bullet
                lda bullet_mode
                cmp #1
                beq loodia88
                jmp loodia11
loodia88        ; Moving up
                lda bullet_y
                sec
                sbc #4
                sta bullet_y
                cmp #32
                bcs loodia82 
                lda #0 ; Remove bullet
                sta bullet_mode
loodia12        jmp loodia10
                ; Check tush collisions
loodia82        ldx #0
loodia81        lda tush_mode,x
                beq loodia80
                lda tush_x,x
                adc #16
                sbc bullet_x
                and #224
                bne loodia80
                lda tush_y,x
                adc #14
                cmp bullet_y
                bcc loodia80
                sbc #28
                cmp bullet_y
                bcs loodia80
                ; Tush hit
                lda #83
                sta bullet_look
                lda #7
                sta 53287
                lda tush_x,x
                sta bullet_x
                lda tush_y,x
                sta bullet_y
                lda tush_color,x
                cmp #10
                bne loodia86
                ; Increase tush speed and change color
                lda #2
                sta tush_color,x
                lda #3
                sta tush_speed,x
                lda #5
                sta score_delta
                jmp loodia87
loodia86        lda #0 ; Remove tush
                sta tush_mode,x
                sta tush_y,x
                lda #$10
                sta score_delta
                dec tush_count
                jsr update_butthurt ; Only update butthurt here
loodia87        lda #2
                sta bullet_mode
                lda #10
                jsr start_sound
                ldx #6 ; End loop

loodia80        inx
                cpx #7
                bne loodia81
                jmp loodia10
loodia11        cmp #2
                bne loodia10
                ; Exploding bullet
                inc bullet_look
                lda bullet_look
                cmp #90
                bne loodia10
                lda #0
                sta bullet_mode
                sta bullet_y
                lda butthurt 
                cmp #20
                bne loodia10
                ; Level cleared
                jsr fan_wave_completed
                jmp loodia6
loodia10        lda bullet_x
                sta 53248
                lda bullet_y
                sta 53249
                lda bullet_look
                sta 24568

                ; Tush management
                lda tush_count
                cmp #7
                beq loodia60
                inc tush_timer
                lda tush_timer
                cmp #30
                bcc loodia60
                ; Add new tush
                ldx #0
                stx tush_timer
loodia62        lda tush_mode,x
                beq loodia61 
                inx
                jmp loodia62
loodia61        lda #2
                sta tush_mode,x
                lda #128
                sta tush_x,x
                lda #29
                sta tush_y,x
                lda #10
                sta tush_color,x
                lda #2
                sta tush_speed,x
                lda #0
                sta tush_steps,x
                inc tush_count
loodia60        
                lda irq_counter
                and #24
                lsr
                lsr
                lsr
                tax
                lda tush_frames,x
                sta tush_look

                ; Handle tushes
                ldx #0
                ldy #0
loodia72        lda tush_mode,x
                cmp #1 ; Up
                bne loodia63
                lda tush_y,x
                sec
                sbc tush_speed,x
                sta tush_y,x
                cmp #29
                bcs loodia64
                lda #0 ; Remove
                sta tush_mode,x
                dec tush_count
loodia64        jmp loodia65
loodia63        cmp #2 ; Down?
                bne loodia66
                lda tush_y,x
                clc
                adc tush_speed,x
                sta tush_y,x
                lda tush_steps,x
                adc tush_speed,x
                sta tush_steps,x
                cmp #21
                bcc loodia67
                lda #0
                sta tush_steps,x
                lda tush_x,x
                cmp #200
                bcs loodia68
                lda #4 ; Go right
                sta tush_mode,x
                jmp loodia65
loodia68        lda #3 ; Go left
                sta tush_mode,x
loodia67        jmp loodia65
loodia66        cmp #3 ; Left
                bne loodia69
                lda tush_x,x
                sec
                sbc tush_speed,x
                sta tush_x,x
                cmp #33
                bcs loodia70
                lda #2 ; Go down
                sta tush_mode,x
loodia70        jmp loodia65
loodia69        cmp #4 ; Right?
                bne loodia65
                lda tush_x,x
                clc
                adc tush_speed,x
                sta tush_x,x
                cmp #247
                bcc loodia65
                ; Check if we have reached vertical limit
                lda tush_y,x
                cmp #134
                bcc loodia73
                lda #1 ; Go up
                sta tush_mode,x
                jmp loodia65
loodia73        lda #2 ; Go down
                sta tush_mode,x
loodia65        ; Draw tush sprites
                lda tush_look
                sta 24569,x
                lda tush_color,x
                sta 53288,x
                lda tush_x,x
                sta 53250,y
                lda tush_y,x
                sta 53251,y
                iny
                iny
                inx
                cpx #7
                beq loodia71
                jmp loodia72
loodia71 
                jmp loodia7
loodia4         ; Restore walking sound
                ldy #80
                sty sound2+1
                cmp #1
                beq loodia5
                jmp loodia6
loodia5         ; Drowned
                lda irq_counter
                and #31
                cmp #30
                bne loodia51 
                ; Play beep sound
                lda #8
                jsr start_sound
                jmp loodia52
loodia51        cmp #16
                bne loodia52
                ; Stop beep sound
                lda #8
                jsr stop_sound
loodia52        lda irq_counter
                bne loodia53
                ; Done waiting
                lda fail 
                cmp #3
                bne loodia54 
                ; Game over
                lda #<gameover_text
                sta line_source+1
                lda #>gameover_text
                sta line_source+2
                lda #9
                sta line_length+1
                lda #32
                sta text_to+1
                lda #110
                sta text_to+2
                jsr draw_text_line

loodia54        ; Clean up and continue
                jsr setup_curtain_sprites
                jsr set_curtain_at_top
                lda #<diarrhea_curtain_down
                sta irq_top_jump+1
                lda #>diarrhea_curtain_down
                sta irq_top_jump+2
                jmp irq_end

loodia53        jmp loodia7
loodia6         ; Wave complete
                ; Explode remaining items
                lda irq_counter
                cmp #96
                bcc loodia92
                lda #120
                sbc irq_counter
                lsr
                lsr
                clc
                adc #83
                sta shit_look
                ldx #0
                ldy #0
loodia93        lda tush_x,x
                sta 53250,y
                lda tush_y,x
                sta 53251,y
                lda #7
                sta 53288,x
                lda shit_look
                sta 24569,x
                inx
                iny
                iny
                cpx #7
                bne loodia93
                lda #7
                jmp loodia95
loodia92        lda #0 ; Move all sprites off screen
                ldy #0
loodia94        sta 53249,y
                iny
                iny
                cpy #16
                bne loodia94
                ; Score and sound effects
loodia95        lda irq_counter
                and #3
                cmp #1
                bne loodia90
                sta score_delta
loodia90        lda irq_counter
                and #7
                bne loodia91
                lda #5 ; Play bing
                jsr start_sound
                ; Check if timer reached zero
loodia91        lda irq_counter
                bne loodia7
                jsr level_completed
                ; Clean up and continue
                jsr setup_curtain_sprites
                jsr set_curtain_at_top
                lda #<diarrhea_curtain_down
                sta irq_top_jump+1
                lda #>diarrhea_curtain_down
                sta irq_top_jump+2
                jmp irq_end

loodia7         lda score_delta
                beq loodia85
                jsr update_score
                lda #0
                sta score_delta
loodia85

                jmp irq_prepare_diarrhea


;===========================
; Victory sequence game loop
;===========================

loop_victory_top
                ; Draw the butts with white flags
                lda irq_counter
                and #24
                lsr
                lsr
                lsr
                tax
                lda tush_frames,x
                sta tush_look
                txa
                ora #108
                sta shit_look
                ldx #0
victop1         lda #10
                sta 53287,x
                lda #8
                sta 53291,x
                lda tush_look
                sta 24568,x
                lda shit_look
                sta 24572,x
                inx
                cpx #4
                bne victop1

                lda tush_y
                and #128
                bne victop2
                inc tush_speed
                jmp victop3
victop2         dec tush_speed
victop3         lda tush_y
                clc
                adc tush_speed
                sta tush_y

                clc
                lsr
                lsr
                lsr
                adc #72
                sta 53249
                sta 53251
                sta 53253
                sta 53255
                adc #19
                sta 53257
                sta 53259
                sta 53261
                sta 53263
                lda #68
                sta 53248
                sta 53256
                lda #108
                sta 53250
                sta 53258
                lda #148
                sta 53252
                sta 53260
                lda #188
                sta 53254
                sta 53262

                ; Check for timeout
                lda irq_counter
                ora irq_counter+1
                beq victop4
                jmp victop5
victop4         ; Prepare to go back to menu
                lda #0
                sta music_on
                jsr game_over
                jmp irq_end

victop5         lda #<victory_bottom
                ldx #>victory_bottom
                sta $314    ; Next is man in victory pose
                stx $315
                lda #170    ; trigger next interrupt at row 170
                sta $d012
                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine

victory_bottom
                ; Draw man in victory pose
                ldx #0
vicbot1         lda #10 ; Pink color
                sta 53287,x
                txa
                ora #104 ; Sprite look
                sta 24568,x
                inx
                cpx #6
                bne vicbot1
                lda #191
                sta 53249
                sta 53251
                lda #128
                sta 53248
                sta 53252
                lda #212
                sta 53253
                sta 53255
                lda #152
                sta 53250
                sta 53254
                lda #233
                sta 53257
                sta 53259
                lda #128
                sta 53256
                lda #150
                sta 53258
                lda #32
                sta 24572
                lda #33
                sta 24573

                lda #<irq_top
                ldx #>irq_top
                sta $314    ; Next is top IRQ
                stx $315
                lda #0
                sta $d012
                jmp irq_end



;========================
; Shit landed on floor
;========================
shit_landed_on_floor
                lda #1
                sta game_phase
                lda shit_x,x
                sta 53248
                lda #229
                sta 53249
                lda #79
                sta 24568
                lda #0 ; Remove unused shit
                sta 53251
                sta 53253
                sta 53255
                sta bucket_drawn
                ; Prepare man look
                lda #191
                sta mantopy+1
                lda #212
                sta moveydown1+1
                lda #233
                sta moveydown2+1
                lda manx+1
                clc
                adc #4
                sta botx1+1
                adc #20
                sta botx2+1
                ldx #60
                stx toplook1+1
                inx
                stx toplook2+1
                inx
                stx midlook1+1
                inx
                stx midlook2+1
                ldx #32
                stx botlook1+1
                inx
                stx botlook2+1
                lda #0
                sta mantopbit+1
                lda #80
                sta toollook+1
                lda manx+1
                adc #16
                sta toolx+1
                lda #196
                sta tooly+1

                lda #1
                sta bucket_speed
                lda #110
                sta irq_counter

                jsr stop_all_sounds

                lda #7
                jsr start_sound

                jsr update_fail

                jmp irq_prepare_drawman

;===========================
; When shit hits the bucket
;===========================
shit_hit_bucket
                lda #182
                sta shit_y,x
                lda #2
                sta shit_mode,x
                lda #72
                sta shit_look,x
                lda #3
                sta snd_effect_flag
                lda bucket_drawn
                clc
                adc #4
                sta bucket_drawn
                cmp #20
                bcc shihi1
                lda #20 ; Cap at 20 pixels high
                sta bucket_drawn
shihi1          
                jmp loobu18


;===========================
; Bucket wave completed
;===========================
bucket_wave_completed
                jsr stop_all_sounds
                lda #2
                sta game_phase
                lda #0
                sta bucket_drawn
                lda #<clear_text
                sta line_source+1
                lda #>clear_text
                sta line_source+2
                lda #12
                sta line_length+1
                lda #16
                sta text_to+1
                lda #100
                sta text_to+2
                jsr draw_text_line
                lda #120
                sta irq_counter
                rts

;===========================
; Fart wave completed
;===========================
fart_wave_completed
                jsr stop_all_sounds
                lda #2
                sta game_phase
                lda #<clear_text
                sta line_source+1
                lda #>clear_text
                sta line_source+2
                lda #12
                sta line_length+1
                lda #16
                sta text_to+1
                lda #100
                sta text_to+2
                jsr draw_text_line
                lda #120
                sta irq_counter
                ldx #3
                lda #0 ; Prepare for explosions
fawav1          sta shit_mode,x
                sta shit_y,x
                dex
                bne fawav1
                lda #1
                sta shit_mode
                lda #83
                sta shit_look
                lda bullet_x
                sta shit_x
                lda bullet_y
                sta shit_y

                rts

;=======================
; Fan wave completed
;=======================
fan_wave_completed
                jsr stop_all_sounds
                lda #2
                sta game_phase
                lda #<clear_text
                sta line_source+1
                lda #>clear_text
                sta line_source+2
                lda #12
                sta line_length+1
                lda #16
                sta text_to+1
                lda #100
                sta text_to+2
                jsr draw_text_line
                lda #120
                sta irq_counter
                lda #0 ; Remove bullet if it is still visible
                sta bullet_y
                sta 53249
                rts

;========================
; Fart hit man
;========================
fart_hit_man
                lda #1
                sta game_phase
                lda #0 ; Remove farts and bullet
                sta 53249
                sta 53251
                sta 53253
                sta 53255

                ; Prepare man look
                lda #191
                sta mantopy+1
                lda #212
                sta moveydown1+1
                lda #233
                sta moveydown2+1
                lda manx+1
                clc
                adc #4
                sta botx1+1
                adc #20
                sta botx2+1
                ldx #64
                stx toplook1+1
                inx
                stx toplook2+1
                inx
                stx midlook1+1
                inx
                stx midlook2+1
                ldx #32
                stx botlook1+1
                inx
                stx botlook2+1
                lda #0
                sta mantopbit+1
                lda #82
                sta toollook+1
                lda manx+1
                adc #16
                sta toolx+1
                lda #196
                sta tooly+1

                lda #1
                sta bucket_speed
                lda #110
                sta irq_counter

                jsr stop_all_sounds

                lda #12
                jsr start_sound

                jsr update_fail

                jmp irq_prepare_drawman


;====================
; Shit hit fan
;====================
shit_hit_fan
                lda #1
                sta game_phase

                ldx #1
shihi2          inc random_pos
                ldy random_pos
                lda random_table,y
                and #63
                sbc #32
                adc splat_x
                sta splat_x,x
                inc random_pos
                ldy random_pos
                lda random_table,y
                and #63
                sbc #32
                adc splat_y
                sta splat_y,x
                inx
                cpx #8
                bne shihi2

                ; Prepare man look
                lda #191
                sta mantopy+1
                lda #212
                sta moveydown1+1
                lda #233
                sta moveydown2+1
                lda manx+1
                clc
                adc #4
                sta botx1+1
                adc #20
                sta botx2+1
                ldx #60
                stx toplook1+1
                inx
                stx toplook2+1
                inx
                stx midlook1+1
                inx
                stx midlook2+1
                ldx #32
                stx botlook1+1
                inx
                stx botlook2+1
                lda #0
                sta mantopbit+1
                lda #80
                sta toollook+1
                lda manx+1
                adc #16
                sta toolx+1
                lda #196
                sta tooly+1

                lda #1
                sta bucket_speed
                lda #110
                sta irq_counter

                jsr stop_all_sounds

                lda #12
                jsr start_sound

                jsr update_fail

                jmp loofn3


;====================
; Man drowned
;====================
man_drowned
                lda #1
                sta game_phase
                lda #0
                sta bullet_mode
                sta bullet_y

                lda #110
                sta irq_counter

                jsr stop_all_sounds

                lda #13
                jsr start_sound

                jsr update_fail

                jmp loodia5



;==========================
; Game over preparation
;==========================

game_over
                lda #<gameover_text
                sta line_source+1
                lda #>gameover_text
                sta line_source+2
                lda #9
                sta line_length+1
                lda #32
                sta text_to+1
                lda #110
                sta text_to+2
                jsr draw_text_line
                lda #0 ; Make sure stage is reset
                sta level
                jsr setup_curtain_sprites
                jsr set_curtain_at_top
                lda #<irq_curtain_down_gameover
                sta irq_top_jump+1
                lda #>irq_curtain_down_gameover
                sta irq_top_jump+2
                rts

;=============================
; Routines for drawing the man
; and the tool
;=============================

drawman_top     lda #10 ; Color
                sta 53293
                sta 53294
                lda #12
                sta 53292
mantopbit       lda #0
                sta 53264

manx            lda #100 ; Man positions
                sta 53260
                clc
                adc #24
                sta 53262
mantopy         lda #191
                sta 53261
                sta 53263
toplook1        lda #10 ; Looks
                sta 24574
toplook2        lda #11
                sta 24575

toolx           lda #120 ; Tool positions
                sta 53258
tooly           lda #150
                sta 53259
toollook        lda #8 ; Look
                sta 24573

                lda #<moveydown1
                ldx #>moveydown1 
                sta $314    ; Next is routine for drawing man middle
                stx $315
                lda mantopy+1
                clc
                adc #10 ; Next interrupt 10 pixels down
                sta $d012

                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine


moveydown1      lda #211 ; Move sprites down
                sta 53261
                sta 53263

                lda #<midlook1
                ldx #>midlook1 
                sta $314    ; Next is routine for drawing man middle
                stx $315

                lda moveydown1+1 ; Next interrupt where middle sprite row starts
                sta $d012

                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine



midlook1        lda #10
                sta 24574
midlook2        lda #11
                sta 24575

                lda moveydown1+1
                clc
                adc #10 ; Next interrupt 10 pixels below
                sta $d012

                lda #<moveydown2
                ldx #>moveydown2 
                sta $314    ; Next is routine for drawing man bottom
                stx $315

                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine


moveydown2      lda #233 ; Move sprites down
                sta 53261
                sta 53263

                cmp #235
                beq movedo1
                lda #<botlook1
                ldx #>botlook1 
                sta $314    ; Next is routine for drawing man bottom
                stx $315
                lda moveydown2+1 ; Next interrupt where bottom sprite row starts
                sta $d012
                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine
movedo1         lda #<badline1
                ldx #>badline1 
                sta $314    ; Next is routine for drawing man bottom, special badline case
                stx $315
                lda #234 ; Next interrupt 1 row before bottom sprite row starts
                sta $d012
                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine



botlook1        lda #10 
                sta 24574
botlook2        lda #11
                sta 24575
botx1           lda #100 ; x pos
                sta 53260
botx2           lda #124
                sta 53262

                lda #0
                sta $d012
                lda #<irq_top
                ldx #>irq_top 
                sta $314    ; Next is top IRQ
                stx $315

                asl $d019 ; Clear interrupt flag
                jmp $ea31 ; Jump to complete IRQ standard routine


badline1        lda #10 
                sta 24574
badline2        lda #11
                sta 24575
badbotx1        lda #100 ; x pos
                sta 53260
badbotx2        lda #124
                sta 53262

                lda #0
                sta $d012
                lda #<irq_top
                ldx #>irq_top 
                sta $314    ; Next is top IRQ
                stx $315

                asl $d019 ; Clear interrupt flag
                jmp $ea31 ; Jump to complete IRQ standard routine



animate_man_normal
                ldx man_pos ; Compute sprite coordinates
                cpx #89
                bcs anmanno1
                ; Normal walk
                lda body_x,x
                sta manx+1
                clc
                adc #16
                sta toolx+1
                txa
                and #7
                tax 
                lda cycle_y,x
                sta mantopy+1
                clc
                adc #5
                sta tooly+1
                clc
                adc #16
                sta moveydown1+1
                adc #21
                sta moveydown2+1
                lda leg1_dx,x
                adc manx+1
                sta botx1+1
                sta badbotx1+1
                lda leg2_dx,x
                clc
                adc manx+1
                sta botx2+1
                sta badbotx2+1
                lda #14 ; Looks
                sta toplook1+1
                lda #15
                sta toplook2+1
                txa
                clc
                asl
                tay
                ora #16
                sta midlook1+1
                ora #1
                sta midlook2+1
                tya 
                ora #32
                sta botlook1+1
                sta badline1+1
                ora #1
                sta botlook2+1
                sta badline2+1
anmanno2        lda #10
                sta toollook+1
                lda #0
                sta mantopbit+1
                rts
anmanno1        ; Emptying bucket
                txa 
                and #7
                tax
                lda empty_topframes,x
                sta toplook1+1
                ora #1
                sta toplook2+1
                lda empty_midframes,x
                sta midlook1+1
                ora #1
                sta midlook2+1
                lda empty_bucketframes,x
                sta toollook+1
                lda empty_bucketx,x
                sta toolx+1
                lda empty_buckety,x
                sta tooly+1
                lda #32
                sta mantopbit+1
                rts

;=====================
; Routines for the
; diarrhea waves
;=====================

;=======================
; Preparing to draw the
; sprites on the lower
; half of the screen
;=======================

diarrhea_top
                ; First draw diarrhea splash
splash_y        lda #0
                sta 53257
splash_frame    lda #98
                sta 24572
                lda #32
                sta 53256
                lda #9
                sta 53291

                ; Place the gun
gunlook         lda #81
                sta 24569
                lda #12
                sta 53288
gunx            lda #120
                sta 53250
guny            lda #195
                sta 53251

                ; Draw player top
head_y          lda #191
                sta 53253
                sta 53255
head_x          lda #100
                sta 53252
                clc
                adc #24
                sta 53254
head_look       lda #14
                sta 24570
                clc
                adc #1
                sta 24571
                lda #10
                sta 53289
                sta 53290


                lda mid_y+1
                cmp diarrhea_y
                bcs diatop1
                sbc #10
                sta $d012
                lda #<diarrhea_movedown1
                ldx #>diarrhea_movedown1 
                sta $314
                stx $315
                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine
diatop1         lda diarrhea_y ; Diarrhea surface comes first
                sta $d012
                lda #<diarrhea_surface
                ldx #>diarrhea_surface 
                sta $314
                stx $315
                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine

;=======================
; Diarrhea surface level
;=======================

diarrhea_surface
                lda #0
                sta 53250
                sta 53252
                sta 53254
                lda #9
                sta 53281

                lda #0
                sta $d012
                lda #<irq_top
                ldx #>irq_top 
                sta $314    ; Next is top IRQ
                stx $315

                asl $d019 ; Clear interrupt flag
                jmp $ea31 ; Jump to complete IRQ standard routine


diarrhea_movedown1   ; Move sprites down first time
mid_y           lda #212
                sta 53253
                sta 53255

                lda mid_y+1
                sta $d012
                lda #<diarrhea_mid
                ldx #>diarrhea_mid 
                sta $314
                stx $315
                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine


diarrhea_mid ; Place mid section of player
mid_look1       lda #16
                sta 24570
mid_look2       lda #17
                sta 24571

                ; Check if diarrhea surface is immediately below
diamid4         lda mid_y+1
                clc
                adc #1
                cmp diarrhea_y
                bne diamid1
                ldx #10 ; Padding
diamid2         dex
                bne diamid2
                jmp diarrhea_surface ; Jump straight to surface routine

diamid1         lda bot_y+1
                cmp diarrhea_y
                bcs diamid3
                sbc #10
                sta $d012
                lda #<diarrhea_movedown2
                ldx #>diarrhea_movedown2 
                sta $314
                stx $315
                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine
diamid3         lda diarrhea_y
                sta $d012
                lda #<diarrhea_surface
                ldx #>diarrhea_surface 
                sta $314
                stx $315
                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine


diarrhea_movedown2   ; Move sprites down second time
bot_y           lda #212
                sta 53253
                sta 53255

                cmp #235 ; Badline?
                bne diado1
                lda #234 ; Start 1 row before
diado1          sta $d012
                lda #<diarrhea_bottom
                ldx #>diarrhea_bottom 
                sta $314
                stx $315

                ; Badline special cases management
                ldx #5
                ldy #0
                lda diarrhea_y
                cmp #234
                bne diado5
                ldx #1
                ldy #1
                jmp diado2

diado5          cmp #235
                bne diado6
                ldy #1
                lda bot_y+1
                cmp #233
                beq diado2
                ldx #1
                jmp diado2

diado6          cmp #236
                bne diado7
                lda bot_y+1
                ldx #1
                cmp #234
                bcc diado2
                ldy #1
                cmp #234
                beq diado2
                ldx #8
                jmp diado2

diado7          cmp #237
                bne diado2
                lda bot_y+1
                cmp #236
                bne diado2
                ldy #1
                ldx #5

diado2          sty bot_cont_flag+1
                stx bot_delay+1


                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine


diarrhea_bottom
bot_look2       lda #11
                sta 24571
bot_look1       lda #10 
                sta 24570
bot_x1          lda #100
                sta 53252
                nop
                nop
bot_x2          lda #124
                sta 53254

bot_cont_flag   lda #0 ; Immediate continuation flag
                beq diabot1

bot_delay       ldx #5
diabot10        dex
                bne diabot10
                jmp diarrhea_surface ; Jump straight to surface routine

diabot1         lda diarrhea_y
                sta $d012
                lda #<diarrhea_surface
                ldx #>diarrhea_surface 
                sta $314
                stx $315
                asl $d019 ; Clear interrupt flag
                jmp $ea81 ; Jump to end of IRQ standard routine


animate_man_diarrhea
                ldx man_pos ; Compute sprite coordinates
                lda body_x,x
                sta head_x+1
                clc
                adc #16
                sta gunx+1
                txa
                and #7
                tax 
                lda cycle_y,x
                sta head_y+1
                clc
                adc #5
                sta guny+1
                adc #16
                sta mid_y+1
                adc #21
                sta bot_y+1
                lda leg1_dx,x
                adc head_x+1
                sta bot_x1+1
                lda leg2_dx,x
                clc
                adc head_x+1
                sta bot_x2+1

                lda #14
                sta head_look+1

                txa
                clc
                asl
                tay
                ora #16
                sta mid_look1+1
                ora #1
                sta mid_look2+1
                tya 
                ora #32
                sta bot_look1+1
                ora #1
                sta bot_look2+1

                rts
                