;============================================================
; Scuttlebutt 64
; By Karl Hörnell 2018
; Version 0.9
;============================================================

;============================================================
;    specify output file
;============================================================

!cpu 6502
!to "build/scuttlebutt.prg",cbm    ; output file

;============================================================
; BASIC loader with start address $c000
;============================================================

* = $0801                               ; BASIC start address (#2049)
!byte $0d,$08,$dc,$07,$9e,$20,$32,$31   ; BASIC loader to start at $c000...
!byte $30,$30,$00,$00,$00,$00           ; puts BASIC line 2012 SYS 2100

* = 2100
!source "code/main.asm"					; The bulk of the code goes here
!source "code/help_routines.asm"
!source "code/variables.asm"			; Variables and constants
!source "code/irq.asm"
!source "code/gameloop.asm"

!source "code/music.asm"

!source "data/introvoice1.asm"
!source "data/introvoice2.asm"


* = 16384
!source "data/sprites.asm" ; Sprite data

* = 32768
!source "data/digits.asm" ; Score digit pixels
!source "data/curtainline.asm" ; Curtain line
!source "data/ctrl_top.asm" ; Control panel top
!source "data/ctrl_mid_bucket.asm" ; Control panel middles
!source "data/ctrl_mid_butthurt.asm"
!source "data/ctrl_mid_hit.asm"
!source "data/ctrl_fail.asm" ; Control panel fail section
!source "data/ctrl_toilet.asm" ; Control panel bottom
!source "data/board.asm" ; Text board
!source "data/fontdata.asm" ; Font
!source "data/logo.asm" ; Logo
!source "data/bucket_pix.asm" ; Bucket filled and empty pixels
!source "data/extra_sprites.asm" ; Modular sprite data for player
!source "data/leftbutt.asm" ; Stationary butts
!source "data/rightbutt.asm"
!source "data/diarrhea_butt.asm"
!source "data/inverted1.asm" ; First room, with data from bottom to top
!source "data/inverted2.asm" ; Second room, with data from bottom to top
!source "data/inverted3.asm" ; Third room, with data from bottom to top

!source "data/victoryvoice1.asm"
!source "data/victoryvoice2.asm"
