;============================================================
;    Various useful subroutines
;============================================================

;=================================
; Copy highres pixels and colors
;=================================
copy_block
from_low        lda #0
                sta 251
from_high       lda #0
                sta 252
to_low          lda #0
                sta 253
to_high         lda #0
                sta 254

num_rows        ldx #10
copblo1         ldy #0

copblo0         lda (251),y
                sta (253),y
                iny
bytes_per_row   cpy #64
                bne copblo0

                clc
                lda 251
                adc bytes_per_row+1
                sta 251
                lda 252
                adc #0
                sta 252

                clc
                lda 253
                adc #64
                sta 253
                lda 254
                adc #1
                sta 254

                dex
                bne copblo1

                lda bytes_per_row+1
                clc
                lsr
                lsr
                lsr
                sta chars_per_row+1

                lda to_low+1
                sta 253
                lda to_high+1
                sec
                sbc #96
                lsr
                ror 253
                lsr
                ror 253
                lsr
                ror 253
                sta 254
                sta 221
                lda 253
                sta 220

                lda 254
                ora #92
                sta 254

                ldx num_rows+1
copblo3         ldy #0

copblo2         lda (251),y
                sta (253),y
                iny
chars_per_row   cpy #8
                bne copblo2

                lda chars_per_row+1
                clc
                adc 251
                sta 251
                lda 252
                adc #0
                sta 252
                lda 253
                clc
                adc #40
                sta 253
                lda 254
                adc #0
                sta 254

                dex
                bne copblo3

                lda 221
                ora #216
                sta 221

                ldx num_rows+1
copblo5         ldy #0

copblo4         lda (251),y
                sta (220),y
                iny
                cpy chars_per_row+1
                bne copblo4

                lda chars_per_row+1
                clc
                adc 251
                sta 251
                lda 252
                adc #0
                sta 252
                lda 220
                clc
                adc #40
                sta 220
                lda 221
                adc #0
                sta 221

                dex
                bne copblo5

                rts

draw_text_line
                ldx #0
line_source     lda 23000,x
                tay
                lda charpos,y ; Empty char?
                beq dratex2

                clc
                adc #<fontpixels
                sta 251
                lda #>fontpixels
                adc #0
                sta 252

                ldy #0
dratex0         lda (251),y
text_to         sta 24540,y
                iny
                cpy #5
                bne dratex0

dratex2         lda text_to+1
                clc
                adc #8
                sta text_to+1
                lda text_to+2
                adc #0
                sta text_to+2

                inx
line_length     cpx #10
                bne line_source
                rts

set_curtain_at_bottom
                lda #250
                sta curtain_sprite_y
                lda #64
                sta curtain_pix 
                lda #127
                sta curtain_pix+1
                lda #232
                sta curtain_bgcol 
                sta curtain_fgcol
                lda #95
                sta curtain_bgcol+1
                lda #219
                sta curtain_fgcol+1
                ldx level ; Update stage
                lda stage_table,x
                sta stage
                tax
                lda stage_data_low,x
                sta stage_data
                lda stage_data_high,x
                sta stage_data+1
curbot0         rts

set_curtain_at_top
                lda #38
                sta curtain_sprite_y
                lda #0
                sta curtain_pix 
                lda #96
                sta curtain_pix+1
                lda #0
                sta curtain_bgcol 
                sta curtain_fgcol
                lda #92
                sta curtain_bgcol+1
                lda #216
                sta curtain_fgcol+1
                rts
                
setup_curtain_sprites
                lda #10 ; Multicolor 2 is pink
                sta 53286
                lda #41 ; Spites 0, 3 and 5 are wide
                sta 53277
                lda #128 
                sta 53264 ; Sprite 7 MSb set
                ldx #0
                ldy #0
setcur0         lda #2 ; Main color red
                sta 53287,x
                lda curtain_sprite_look,x ; Sprite looks
                sta 24568,x
                lda curtain_sprite_y ; y pos
                sta 53249,y
                lda curtain_sprite_x,x ; x pos
                sta 53248,y
                iny
                iny
                inx
                cpx #8
                bne setcur0

                rts

;=====================================
; Level completed
; Called after a wave has been cleared
;=====================================
level_completed inc level
                lda wave
                sed
                clc
                adc #1
                cld
                sta wave
                ; Remove "Wave cleared text"
                ldx #96
                lda #255
levcom1         sta 25615,x
                dex
                bne levcom1
                rts

;====================
; Remove stereo butts
;====================
remove_stereo_butts
                ldx level
                lda wave_types,x
                cmp #2
                beq remste2
                lda #0
                sta 251
                lda #92
                sta 252
                ldx #0
remste6         ldy #0
remste3         lda #12
                sta (251),y
                lda 252
                eor #132
                sta 252
                lda #15
                sta (251),y
                lda 252
                eor #132
                sta 252
                iny
                cpy #3
                bne remste3
                txa
                and #1
                bne remste4
                lda 251
                clc
                adc #29
                sta 251
                lda 252
                adc #0
                sta 252
                jmp remste5
remste4         lda 251
                clc
                adc #11
                sta 251
                lda 252
                adc #0
                sta 252
remste5         inx
                cpx #12
                bne remste6
                ldx #0 ; Remove if wave does not have stereo butts
                lda #255
remste1         sta 24576,x
                sta 24896,x
                sta 25216,x
                sta 25536,x
                sta 25856,x
                sta 26176,x
                sta 24808,x
                sta 25128,x
                sta 25448,x
                sta 25768,x
                sta 26088,x
                sta 26408,x
                inx
                cpx #24
                bne remste1

remste2         rts

;====================
; Start game
;====================

start_game      lda #1
                sta level
                sta wave
                lda #0
                sta score
                sta score+1
                sta fail
                lda #40
                sta man_pos
                lda #0
                jsr update_score
                jsr prepare_level

                rts

;==============================
; Reset shits
;==============================
reset_shit_variables
                lda #0
                sta bullet_mode
                sta bullet_y
                sta shit_num
                tax
                ldy level
                lda shit_speeds,y
                tay
resshi1         lda #0
                sta shit_y,x
                sta shit_mode,x
                tya 
                sta shit_speed,x
                inx
                cpx #5
                bne resshi1
                lda shit_caught
                sta shit_count
                lda shit_speed ; Set fan level shit max speed
                sta maxspeed_right+1
                eor #255
                tax
                inx
                stx maxspeed_left+1
                lda man_pos ; Round player position to nearest multiple of 4
                clc
                adc #2
                and #252
                sta man_pos
                rts

;================================
; Called at the start of a level
;================================
prepare_level   lda #0
                sta 53277 ; Clear wide sprite bit
                lda #1
                sta 53286 ; Multicolor register 1 is white
                lda #0
                sta game_phase

                ; Set counters and other stuff
                lda #0
                sta shit_caught
                sta butthurt
                sta bullet_mode
                sta bullet_y
                ldy level
                lda interval_table,y
                sta shit_interval
                lda max_table,y
                sta max_shit
                lda goal_table,y
                sta shit_goal

                jsr reset_shit_variables
 
                lda wave
                ; Draw level digits
                and #240
                lsr
                tay
                ldx #0
prelev1         lda digit_data,y
                sta 27416,x
                iny
                inx
                cpx #7
                bne prelev1
                lda wave
                and #15
                asl
                asl
                asl
                tay
                ldx #0
prelev2         lda digit_data,y
                sta 27424,x
                iny
                inx
                cpx #7
                bne prelev2
                ; Set control panel middle here
                ldx level
                lda wave_types,x
                tax 
                lda midpanel_low,x
                sta from_low+1
                lda midpanel_high,x
                sta from_high+1

                lda #128
                sta to_low+1
                lda #109
                sta to_high+1
                lda #4
                sta num_rows+1
                lda #64
                sta bytes_per_row+1
                jsr copy_block


                ; Check if we need to switch between bucket and gun
                ldx level
                lda wave_tools,x
                sta current_tool
                cmp last_tool
                beq prelev4
                sta last_tool
                cmp #0
                bne prelev5
                jsr switch_to_bucket
                jmp prelev4
prelev5         jsr switch_to_gun
prelev4
                ; Prepare man sprites
                jsr animate_man_normal

                ; Check if we need to show instructions
                ldx level
                lda instructions_high,x
                beq prelev3
                ; Should show instructions
                ; Set text source and destination pointers
                sta text_source+1
                lda instructions_low,x
                sta text_source
                lda #0
                sta text_dest
                sta line_dest
                lda #96
                sta text_dest+1
                sta line_dest+1

                lda #<irq_show_instructions
                sta irq_top_jump+1
                lda #>irq_show_instructions
                sta irq_top_jump+2

                ldx level ; Clear instructions flag
                lda #0
                sta instructions_high,x
                rts
prelev3         jmp final_level_preparations ; No instructions

;==========================
; Adds accumulator to score
; and updates digits
;==========================
update_score    sed
                clc
                adc score
                sta score
                lda score+1
                adc #0
                sta score+1
                cld 
                and #240
                lsr
                sta 251
                lda score+1
                and #15
                asl
                asl
                asl
                sta 252
                lda score
                and #240
                lsr
                sta 253
                lda score
                and #15
                asl
                asl
                asl
                sta 254
                ldx #0
updsc1          txa
                ora 251
                tay
                lda digit_data,y
                sta 25488,x
                txa
                ora 252
                tay
                lda digit_data,y
                sta 25496,x
                txa
                ora 253
                tay
                lda digit_data,y
                sta 25504,x
                txa
                ora 254
                tay
                lda digit_data,y
                sta 25512,x
                inx
                cpx #7
                bne updsc1
                ; See if new highscore
                lda highscore
                sec
                sbc score
                lda highscore+1
                sbc score+1
                bcs updsc2
                lda score
                sta highscore
                lda score+1
                sta highscore+1
                ldx #0 ; Copy pixel data
updsc3          lda 25488,x
                sta 26448,x
                inx
                cpx #31
                bne updsc3
updsc2          rts


;==========================
; Last code before starting
; a level
;==========================

final_level_preparations
                ldx level
                lda wave_types,x
                tay
                lda gameloop_low,y
                sta irq_top_jump+1
                lda gameloop_high,y
                sta irq_top_jump+2
                cpy #0
                bne finlev1
                ; Bucket level
                ; Place butt just outside of screen
                lda #100
                sta butt_x
                lda #39
                sta butt_y
                rts
finlev1         cpy #1
                bne finlev2
                ; Fart level
                ; Place butt just outside of screen
                lda #100
                sta butt_x
                lda #39
                sta butt_y
                rts
finlev2         cpy #2
                bne finlev3
                ; Fan level
                ; Place side butts
                lda #<leftbutt
                sta from_low+1
                lda #>leftbutt
                sta from_high+1
                lda #0
                sta to_low+1
                lda #96
                sta to_high+1
                lda #6
                sta num_rows+1
                lda #24
                sta bytes_per_row+1
                jsr copy_block
                lda #<rightbutt
                sta from_low+1
                lda #>rightbutt
                sta from_high+1
                lda #232
                sta to_low+1
                lda #96
                sta to_high+1
                lda #6
                sta num_rows+1
                lda #24
                sta bytes_per_row+1
                jsr copy_block
                rts
finlev3         cpy #3
                bne finlev4
                ; Diarrhea level
                jsr reset_diarrhea_stream
                lda #0
                sta butthurt
                rts
finlev4         ; Victory sequence
                lda #0
                sta 53264
                sta tush_speed
                lda #64
                sta tush_y
                lda #4 ; Enough time for the victory music to play
                sta irq_counter
                sta irq_counter+1
                jsr start_victory_music
                rts

;=======================
; Called after each fail
;=======================

update_fail
                lda infinite_lives
                bne updfai1
                lda fail
                clc
                asl
                asl
                asl
                tax 
                lda #$a9
                sta 29979,x
                lda #$fd
                sta 29980,x
                sta 29981,x
                inc fail
updfai1         rts

;========================
; Called when switching
; to bucket
;========================

switch_to_bucket
                ldx #0
swibu1          lda bucket_head_data,x
                sta 17280,x
                inx
                cpx #127
                bne swibu1
                ldx #0
swibu2          lda bucket_torso_data,x
                sta 17408,x
                sta 17536,x
                sta 17664,x
                sta 17792,x
                sta 17920,x
                sta 18048,x
                sta 18176,x
                sta 18304,x
                lda bucket_torso_data+33,x
                sta 17472,x
                sta 17600,x
                sta 17728,x
                sta 17856,x
                sta 17984,x
                sta 18112,x
                sta 18240,x
                sta 18368,x
                inx
                cpx #33
                bne swibu2
                lda #10
                sta anmanno2+1
                rts

;========================
; Called when switching
; to gun
;========================

switch_to_gun
                ldx #0
swigu1          lda gun_head_data,x
                sta 17280,x
                inx
                cpx #127
                bne swigu1
                ldx #0
swigu2          lda gun_torso_data,x
                sta 17408,x
                sta 17536,x
                sta 17664,x
                sta 17792,x
                sta 17920,x
                sta 18048,x
                sta 18176,x
                sta 18304,x
                lda gun_torso_data+33,x
                sta 17472,x
                sta 17600,x
                sta 17728,x
                sta 17856,x
                sta 17984,x
                sta 18112,x
                sta 18240,x
                sta 18368,x
                inx
                cpx #33
                bne swigu2
                lda #81
                sta anmanno2+1
                rts

;=======================
; Set butt sprites
; Used for wave types
; bucket and fart
;=======================

set_butt_sprites
                lda #0
                sta 53264 ; Top x bits 0
                ldx #2 ; Looks
                stx 24572
                inx
                stx 24573
                inx
                stx 24574
                inx
                stx 24575
                lda butt_y ; y pos
                sta 53257
                sta 53259
                sta 53261
                sta 53263
                lda butt_x ; x pos
                sta 53256
                clc
                adc #24
                sta 53258
                adc #24
                sta 53260
                adc #24
                sta 53262
                lda #10 ; pink color
                ldx #0
setbu1          sta 53291,x
                inx
                cpx #4
                bne setbu1
                rts

update_butthurt
                lda butthurt
                clc
                adc #3
                asl
                and #120
                tay
                lda butthurt
                and #3
                tax
                lda butthurt_adjust,x
                tax
                ora 28683,y
                sta 28683,y
                txa
                ora 28684,y
                sta 28684,y
                txa
                ora 28685,y
                sta 28685,y
                inc butthurt
                rts

;==========================
; Called before activating
; diarrhea wave
;==========================

reset_diarrhea_stream
                lda #82
                sta diarrhea_col
                lda #92
                sta diarrhea_col+1
                lda #144
                sta diarrhea_pix
                lda #98
                sta diarrhea_pix+1
                lda #0
                sta diarrhea_length
                sta splash_y+1
                ; Draw stationary butt
                lda #<diarrhea_butt
                sta from_low+1
                lda #>diarrhea_butt
                sta from_high+1
                lda #0
                sta to_low+1
                lda #96
                sta to_high+1
                lda #2
                sta num_rows+1
                lda #40
                sta bytes_per_row+1
                jsr copy_block
                lda #0
                sta 53264 ; Clear top x bits
                tax
resdia1         sta tush_count,x
                inx
                cpx #44
                bne resdia1
                ldx level ; Set diarrhea surface rise delay
                lda interval_table,x
                sta diarrhea_delay
                rts

;===========================
; Player control, shooting
; ability, used by fart, fan
; and diarrhea level
;===========================

control_player
                ; Handle player
                lda joystick
                and #4
                bne conpla1
                ; Go left
                lda man_pos
                beq conpla2
                dec man_pos
                lda man_pos

                and #3
                bne conpla2
                lda #2 ; Step sound
                jsr start_sound
conpla2         jmp conpla3
conpla1         lda joystick
                and #8
                bne conpla3
                ; Go right
                lda man_pos
                cmp #88
                beq conpla3
                inc man_pos
                lda man_pos
                and #3
                bne conpla3
                lda #2 ; Step sound
                jsr start_sound
conpla3          ; Check fire button
                lda joystick
                and #16
                bne conpla4
                ; Fire
                lda bullet_mode
                bne conpla4
                lda #1
                sta bullet_mode
                lda #181
                sta bullet_y
                ldx man_pos
                lda body_x,x
                clc
                adc #14
                sta bullet_x
                lda #90
                sta bullet_look
                lda #9
                jsr start_sound
conpla4         rts

;========================
; Draw the text board on
; top of the curtain
;========================

draw_board
                lda #<board ; Text board
                sta from_low+1
                lda #>board
                sta from_high+1
                lda #184
                sta to_low+1
                lda #108
                sta to_high+1
                lda #5
                sta num_rows+1
                lda #144
                sta bytes_per_row+1
                jsr copy_block

                lda #<board_text
                sta line_source+1
                lda #>board_text
                sta line_source+2
                ldx stage
drabo3          beq drabo1
                lda #42
                clc
                adc line_source+1
                sta line_source+1
                bcc drabo2
                inc line_source+2
drabo2          dex
                jmp drabo3
drabo1          
                lda #14
                sta line_length+1
                lda #11
                sta text_to+1
                lda #110
                sta text_to+2
                jsr draw_text_line

                lda line_source+1
                clc
                adc #14
                sta line_source+1
                bcc drabo4
                inc line_source+2
drabo4          lda #75
                sta text_to+1
                lda #111
                sta text_to+2
                jsr draw_text_line

                lda line_source+1
                clc
                adc #14
                sta line_source+1
                bcc drabo5
                inc line_source+2
drabo5          lda #139
                sta text_to+1
                lda #112
                sta text_to+2
                jsr draw_text_line              

                rts