;============================================================
;    setting up the highres screen
;============================================================

; Set up bitmap and screen data pointers

                lda #15          ; Light gray border and dark gray background
                sta $d020
                lda #11
                sta $d021
                lda #0        ; Blank screen

                lda #255        ; Activate all sprites
                sta 53269     
                lda #0          ; Multicolors
                sta 53285
                lda #1
                sta 53286
                lda #255        ; Activate multicolor
                sta 53276

                lda #54         ; Turn off BASIC ROM
                sta 1

                lda #250
                sta curtain_sprite_y
                jsr setup_curtain_sprites
                jsr draw_initial_screen

                lda #$3b        ; Bitmap mode on
                sta $d011

                sta $d011
                lda #$18        ; Multicolor on
                sta $d016

                lda #15         ; Volume to max
                sta 54296

                lda $dd00       ; Set video bank to start at 16384
                and #252
                ora #2
                sta $dd00

                lda #$78        ; Set bitmap to top half and
                sta $d018       ; color screen to start at 23352

                jsr setup_initial_irq

state_checker   ldx game_state          ; Loop that monitors state changes and
state_loop1     cpx game_state          ; jumps to the subroutine specified in state_handler+1,2
                beq state_loop1
                ldx game_state
                lda state_jumptab1,x
                sta state_handler+1
                lda state_jumptab2,x
                sta state_handler+2
state_handler   jsr dummy_mode
                jmp state_checker


state_jumptab1    !byte <dummy_routine
state_jumptab2    !byte >dummy_routine


dummy_routine   rts


draw_initial_screen
                lda #0
                sta 251
                lda #96
                sta 252

                ldx #25
                ldy #0
drawini0
                lda curtain_line,y
                sta (251),y
                iny
                bne drawini0
                clc
                lda 251
                adc #64
                sta 251
                lda 252
                adc #1
                sta 252
                dex
                bne drawini0

drawini1        lda #0 ; Curtain colors
                sta $d800,y
                sta $d900,y
                sta $da00,y
                sta $db00,y
                lda #42
                sta $5c00,y
                sta $5d00,y
                sta $5e00,y
                sta $5f00,y
                iny
                bne drawini1

                lda #<ctrl_top
                sta from_low+1
                lda #>ctrl_top
                sta from_high+1
                lda #0
                sta to_low+1
                lda #97
                sta to_high+1
                lda #10
                sta num_rows+1
                lda #64
                sta bytes_per_row+1
                jsr copy_block

                lda #<ctrl_mid_bucket
                sta from_low+1
                lda #>ctrl_mid_bucket
                sta from_high+1
                lda #128
                sta to_low+1
                lda #109
                sta to_high+1
                lda #4
                sta num_rows+1
                lda #64
                sta bytes_per_row+1
                jsr copy_block

                lda #<ctrl_fail
                sta from_low+1
                lda #>ctrl_fail
                sta from_high+1
                lda #128
                sta to_low+1
                lda #114
                sta to_high+1
                lda #3
                sta num_rows+1
                lda #64
                sta bytes_per_row+1
                jsr copy_block

                lda #<ctrl_toilet
                sta from_low+1
                lda #>ctrl_toilet
                sta from_high+1
                lda #64
                sta to_low+1
                lda #118
                sta to_high+1
                lda #8
                sta num_rows+1
                lda #64
                sta bytes_per_row+1
                jsr copy_block

                jsr draw_board
                rts


setup_initial_irq 
                sei         ; set interrupt disable flag
                ldy #$7f    ; $7f = %01111111
                sty $dc0d   ; Turn off CIAs Timer interrupts ($7f = %01111111)
                sty $dd0d   ; Turn off CIAs Timer interrupts ($7f = %01111111)
                lda $dc0d   ; by reading $dc0d and $dd0d we cancel all CIA-IRQs in queue/unprocessed
                lda $dd0d   ; by reading $dc0d and $dd0d we cancel all CIA-IRQs in queue/unprocessed
          
                lda #$01    ; Set Interrupt Request Mask...
                sta $d01a   ; ...we want IRQ by Rasterbeam (%00000001)

                lda $d011   ; Bit#0 of $d011 indicates if we have passed line 255 on the screen
                and #$7f    ; it is basically the 9th Bit for $d012
                sta $d011   

                lda #250          ; Set up initial intro state and counter
                sta irq_counter
                lda #0
                sta irq_counter+1

                lda #<irq_top
                ldx #>irq_top 
                sta $314    ; store in $314/$315
                stx $315   

                lda #0    ; trigger first interrupt at row 0
                sta $d012

                cli       ; clear interrupt disable flag
                rts


dummy_mode
                sei
                lda #<irq_dummy
                ldx #>irq_dummy 
                sta $314
                stx $315   
                cli
                rts
