; Music code and variables

; Music variables
music_on		!byte 0
voice1pos1 		!byte 0
voice1pos2 		!byte 0
voice2pos1 		!byte 0
voice2pos2 		!byte 0
voice1start1 	!byte 0
voice1start2 	!byte 0
voice2start1 	!byte 0
voice2start2 	!byte 0
voice1count 	!byte 0
voice2count 	!byte 0
voice1arp		!byte 0
voice2arp		!byte 0

; Note frequency tables, low and high byte
notes_low		!byte $2a,$4b,$6e,$93,$ba,$e3,$0f,$3e,$6f,$a4,$db,$16
				!byte $54,$96,$dc,$26,$74,$c7,$1f,$7c,$df,$47,$b6,$2c
				!byte $a8,$2c,$b7,$4b,$e8,$8e,$3e,$f8,$be,$8f,$6c,$57
				!byte $50,$58,$6f,$96,$d0,$1c,$7c,$f0,$7b,$1e,$d9,$ae
				!byte $a0,$af,$dd,$2d,$a0,$38,$f8,$e1,$f6,$3b,$b2,$5c
				!byte $40,$5e,$bb,$5a,$3f,$6f,$ef,$c2,$ed,$76,$63,$b9
				!byte 0

notes_high		!byte $02,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$04
				!byte $04,$04,$04,$05,$05,$05,$06,$06,$06,$07,$07,$08
				!byte $08,$09,$09,$0a,$0a,$0b,$0c,$0c,$0d,$0e,$0f,$10
				!byte $11,$12,$13,$14,$15,$17,$18,$19,$1b,$1d,$1e,$20
				!byte $22,$24,$26,$29,$2b,$2e,$30,$33,$36,$3a,$3d,$41
				!byte $45,$49,$4d,$52,$57,$5c,$61,$67,$6d,$74,$7b,$82
				!byte 0

song_reset		!byte 0,1,0,255,1,0


;===============================
; Music routine
;===============================

start_intro_music
                lda #<introvoice1
                sta voice1start1
                lda #>introvoice1
                sta voice1start2
                lda #<introvoice2
                sta voice2start1
                lda #>introvoice2
                sta voice2start2
                jmp start_music

start_victory_music
                lda #<victoryvoice1
                sta voice1start1
                lda #>victoryvoice1
                sta voice1start2
                lda #<victoryvoice2
                sta voice2start1
                lda #>victoryvoice2
                sta voice2start2
                jmp start_music 

start_music     lda #0
                sta voice1count
                sta voice1arp
                sta voice2count
                sta voice2arp
                lda #<song_reset
                sta voice1pos1
                sta voice2pos1
                lda #>song_reset
                sta voice1pos2
                sta voice2pos2
                lda #1
                sta music_on
                rts

;===================================
; Play music
;===================================

playmusic      lda music_on
                bne playmus0
                rts
playmus0
		lda voice1pos1
                sta 220
                lda voice1pos2
                sta 221
                ldy #0
                lda (220),y
                cmp voice1count
                bne playmus_1
                lda #0
                sta voice1count
                sta voice1arp
                ldy #1
                lda (220),y
                clc
                adc #2
                adc 220
                sta 220
                lda 221
                adc #0
                sta 221
                ldy #0
                lda (220),y
                cmp #255
                bne playmus_2
                lda voice1start1
                sta 220
                lda voice1start2
                sta 221
playmus_2       lda 220
                sta voice1pos1
                lda 221
                sta voice1pos2
                lda #0 ; Restart note
                sta 54276
                lda #56
                sta 54277
                lda #0
                sta 54278
                lda #17
                sta 54276
playmus_1       ldy voice1arp
                iny
                iny
                lda (220),y
                tax
                lda notes_low,x
                sta 54272
                lda notes_high,x
                sta 54273
                inc voice1arp
                ldy #1
                lda (220),y
                cmp voice1arp
                bne playmus_3
                lda #0
                sta voice1arp
playmus_3       inc voice1count

                lda voice2pos1
                sta 220
                lda voice2pos2
                sta 221
                ldy #0
                lda (220),y
                cmp voice2count
                bne playmus_4
                lda #0
                sta voice2count
                sta voice2arp
                ldy #1
                lda (220),y
                clc
                adc #2
                adc 220
                sta 220
                lda 221
                adc #0
                sta 221
                ldy #0
                lda (220),y
                cmp #255
                bne playmus_5
                lda voice2start1
                sta 220
                lda voice2start2
                sta 221
playmus_5       lda 220
                sta voice2pos1
                lda 221
                sta voice2pos2
                lda #0 ; Restart note
                sta 54283
                lda #8
                sta 54284
                lda #0
                sta 54285
                lda #17
                sta 54283
playmus_4       ldy voice2arp
                iny
                iny
                lda (220),y
                tax
                lda notes_low,x
                sta 54279
                lda notes_high,x
                sta 54280
                inc voice2arp
                ldy #1
                lda (220),y
                cmp voice2arp
                bne playmus_6
                lda #0
                sta voice2arp
playmus_6       inc voice2count

                rts

